/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;
import org.languagetool.dev.DictionaryBuilder;

@Deprecated
final class SynthDictionaryBuilder
extends DictionaryBuilder {
    private static final String POLISH_IGNORE_REGEX = ":neg|qub|depr";

    SynthDictionaryBuilder(File infoFile) throws IOException {
        super(infoFile);
    }

    public static void main(String[] args) throws Exception {
        SynthDictionaryBuilder.checkUsageOrExit(SynthDictionaryBuilder.class.getSimpleName(), args);
        File infoFile = new File(args[1]);
        SynthDictionaryBuilder builder = new SynthDictionaryBuilder(infoFile);
        builder.build(new File(args[0]), infoFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    File build(File plainTextDictFile, File infoFile) throws Exception {
        File tempFile = File.createTempFile(SynthDictionaryBuilder.class.getSimpleName(), ".txt");
        File reversedFile = null;
        try {
            Set<String> itemsToBeIgnored = this.getIgnoreItems(new File(infoFile.getParent(), "filter-archaic.txt"));
            Pattern ignorePosRegex = this.getPosTagIgnoreRegex(infoFile);
            reversedFile = this.reverseLineContent(plainTextDictFile, itemsToBeIgnored, ignorePosRegex);
            List<String> tab2morphOptions = this.getTab2MorphOptions(reversedFile, tempFile);
            tab2morphOptions.add(0, "tab2morph");
            tab2morphOptions.add(1, "-nw");
            this.prepare(tab2morphOptions);
            this.writePosTagsToFile(plainTextDictFile, this.getTagFile(tempFile));
            File file = this.buildDict(tempFile);
            return file;
        }
        finally {
            tempFile.delete();
            if (reversedFile != null) {
                reversedFile.delete();
            }
        }
    }

    private Set<String> getIgnoreItems(File file) throws FileNotFoundException {
        HashSet<String> result = new HashSet<String>();
        if (file.exists()) {
            try (Scanner scanner = new Scanner(file, this.getOption("fsa.dict.encoding"));){
                while (scanner.hasNextLine()) {
                    String line = scanner.nextLine();
                    if (line.startsWith("#")) continue;
                    result.add(line);
                }
            }
            System.out.println("Loaded " + result.size() + " words to be ignored from " + file);
        } else {
            System.out.println("File " + file.getAbsolutePath() + " does not exist, no items will be ignored");
        }
        return result;
    }

    @Nullable
    private Pattern getPosTagIgnoreRegex(File infoFile) {
        String fileName = infoFile.getName();
        int underscorePos = fileName.indexOf(95);
        if (underscorePos == -1) {
            throw new IllegalArgumentException("Please specify an .info file for a synthesizer as the second parameter, named '<xyz>_synth.info', with <xyz> being a language'");
        }
        String baseName = fileName.substring(0, underscorePos);
        if (baseName.equals("polish")) {
            return Pattern.compile(POLISH_IGNORE_REGEX);
        }
        return null;
    }

    private File reverseLineContent(File plainTextDictFile, Set<String> itemsToBeIgnored, Pattern ignorePosRegex) throws IOException {
        File reversedFile = File.createTempFile(SynthDictionaryBuilder.class.getSimpleName() + "_reversed", ".txt");
        String encoding = this.getOption("fsa.dict.encoding");
        int posIgnoreCount = 0;
        Scanner scanner = new Scanner(plainTextDictFile, encoding);
        try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(reversedFile), encoding));){
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                if (itemsToBeIgnored.contains(line)) {
                    System.out.println("Ignoring: " + line);
                    continue;
                }
                String[] parts = line.split("\t");
                if (parts.length == 3) {
                    String posTag = parts[2];
                    if (ignorePosRegex != null && ignorePosRegex.matcher(posTag).find()) {
                        ++posIgnoreCount;
                        continue;
                    }
                    out.write(parts[1] + "|" + posTag + "\t" + parts[0]);
                    out.write("\n");
                    continue;
                }
                System.err.println("Invalid input, expected three tab-separated columns in " + plainTextDictFile + ": " + line + " => ignoring");
            }
            scanner.close();
        }
        System.out.println("Number of lines ignored due to POS tag filter ('" + ignorePosRegex + "'): " + posIgnoreCount);
        return reversedFile;
    }

    private File getTagFile(File tempFile) {
        String name = tempFile.getAbsolutePath() + "_tags.txt";
        return new File(name);
    }

    private void writePosTagsToFile(File plainTextDictFile, File tagFile) throws IOException {
        Set<String> posTags = this.collectTags(plainTextDictFile);
        ArrayList<String> sortedTags = new ArrayList<String>(posTags);
        Collections.sort(sortedTags);
        System.out.println("Writing tag file to " + tagFile);
        try (FileWriter out = new FileWriter(tagFile);){
            for (String tag : sortedTags) {
                out.write(tag);
                out.write("\n");
            }
        }
    }

    private Set<String> collectTags(File plainTextDictFile) throws IOException {
        HashSet<String> posTags = new HashSet<String>();
        try (Scanner scanner = new Scanner(plainTextDictFile, this.getOption("fsa.dict.encoding"));){
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                String[] parts = line.split("\t");
                if (parts.length == 3) {
                    String posTag = parts[2];
                    posTags.add(posTag);
                    continue;
                }
                System.err.println("Invalid input, expected three tab-separated columns in " + plainTextDictFile + ": " + line + " => ignoring");
            }
        }
        return posTags;
    }
}

