/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view.popup;

import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.view.SessionDialog;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.view.ContextExcludePanel;
import org.zaproxy.zap.view.popup.PopupMenuItemSiteNodeContainer;

public class PopupMenuItemExcludeFromContext
extends PopupMenuItemSiteNodeContainer {
    private static final long serialVersionUID = 2766535157899537709L;
    private static final Logger LOGGER = Logger.getLogger(PopupMenuItemExcludeFromContext.class);
    protected Context context;

    public PopupMenuItemExcludeFromContext(Context context) {
        super(context.getName(), true);
        this.context = context;
    }

    @Override
    public String getParentMenuName() {
        return Constant.messages.getString("context.exclude.popup");
    }

    @Override
    public boolean isSubMenu() {
        return true;
    }

    @Override
    public void performAction(SiteNode siteNode) {
        Session session = Model.getSingleton().getSession();
        SessionDialog sessionDialog = View.getSingleton().getSessionDialog();
        sessionDialog.recreateUISharedContexts(session);
        Context context = sessionDialog.getUISharedContext(this.context.getIndex());
        try {
            context.excludeFromContext(siteNode, !siteNode.isLeaf());
            View.getSingleton().showSessionDialog(session, ContextExcludePanel.getPanelName(this.context.getIndex()), false);
        }
        catch (Exception exception) {
            LOGGER.error((Object)("Failed to execute action exclude from context: " + exception.getMessage()), (Throwable)exception);
        }
    }

    @Override
    public boolean isButtonEnabledForSiteNode(SiteNode siteNode) {
        return this.context.isIncluded(siteNode) && !this.context.isExcluded(siteNode);
    }

    @Override
    public boolean isSafe() {
        return true;
    }
}

