/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.EmptyStatement;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.codegen.BranchLabel;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class IfStatement
extends Statement {
    public Expression condition;
    public Statement thenStatement;
    public Statement elseStatement;
    int thenInitStateIndex = -1;
    int elseInitStateIndex = -1;
    int mergedInitStateIndex = -1;

    public IfStatement(Expression expression, Statement statement, int n, int n2) {
        this.condition = expression;
        this.thenStatement = statement;
        if (statement instanceof EmptyStatement) {
            statement.bits |= 1;
        }
        this.sourceStart = n;
        this.sourceEnd = n2;
    }

    public IfStatement(Expression expression, Statement statement, Statement statement2, int n, int n2) {
        this.condition = expression;
        this.thenStatement = statement;
        if (statement instanceof EmptyStatement) {
            statement.bits |= 1;
        }
        this.elseStatement = statement2;
        if (statement2 instanceof IfStatement) {
            statement2.bits |= 0x20000000;
        }
        if (statement2 instanceof EmptyStatement) {
            statement2.bits |= 1;
        }
        this.sourceStart = n;
        this.sourceEnd = n2;
    }

    @Override
    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        boolean bl;
        FlowInfo flowInfo2 = this.condition.analyseCode(blockScope, flowContext, flowInfo);
        int n = (flowInfo.reachMode() & 3) != 0 ? 1 : 0;
        Constant constant = this.condition.optimizedBooleanConstant();
        this.condition.checkNPEbyUnboxing(blockScope, flowContext, flowInfo);
        boolean bl2 = constant != Constant.NotAConstant && constant.booleanValue();
        boolean bl3 = constant != Constant.NotAConstant && !constant.booleanValue();
        ++flowContext.conditionalLevel;
        FlowInfo flowInfo3 = flowInfo2.safeInitsWhenTrue();
        if (bl3) {
            flowInfo3.setReachMode(1);
        }
        FlowInfo flowInfo4 = flowInfo2.initsWhenFalse().copy();
        if (bl2) {
            flowInfo4.setReachMode(1);
        }
        if ((flowInfo.tagBits & 3) == 0 && (flowInfo3.tagBits & 3) != 0) {
            this.bits |= 0x100;
        } else if ((flowInfo.tagBits & 3) == 0 && (flowInfo4.tagBits & 3) != 0) {
            this.bits |= 0x80;
        }
        boolean bl4 = bl = !IfStatement.isKnowDeadCodePattern(this.condition) || blockScope.compilerOptions().reportDeadCodeInTrivialIfStatement;
        if (this.thenStatement != null) {
            this.thenInitStateIndex = blockScope.methodScope().recordInitializationStates(flowInfo3);
            if (bl3 || (this.bits & 0x100) != 0) {
                if (bl) {
                    this.thenStatement.complainIfUnreachable(flowInfo3, blockScope, n, false);
                } else {
                    this.bits &= 0xFFFFFEFF;
                }
            }
            flowInfo3 = this.thenStatement.analyseCode(blockScope, flowContext, flowInfo3);
        }
        flowContext.expireNullCheckedFieldInfo();
        if ((flowInfo3.tagBits & 1) != 0) {
            this.bits |= 0x40000000;
        }
        if (this.elseStatement != null) {
            if (flowInfo3 == FlowInfo.DEAD_END && (this.bits & 0x20000000) == 0 && !(this.elseStatement instanceof IfStatement)) {
                blockScope.problemReporter().unnecessaryElse(this.elseStatement);
            }
            this.elseInitStateIndex = blockScope.methodScope().recordInitializationStates(flowInfo4);
            if (bl2 || (this.bits & 0x80) != 0) {
                if (bl) {
                    this.elseStatement.complainIfUnreachable(flowInfo4, blockScope, n, false);
                } else {
                    this.bits &= 0xFFFFFF7F;
                }
            }
            flowInfo4 = this.elseStatement.analyseCode(blockScope, flowContext, flowInfo4);
        }
        blockScope.correlateTrackingVarsIfElse(flowInfo3, flowInfo4);
        UnconditionalFlowInfo unconditionalFlowInfo = FlowInfo.mergedOptimizedBranchesIfElse(flowInfo3, bl2, flowInfo4, bl3, true, flowInfo, this, bl);
        this.mergedInitStateIndex = blockScope.methodScope().recordInitializationStates(unconditionalFlowInfo);
        --flowContext.conditionalLevel;
        return unconditionalFlowInfo;
    }

    @Override
    public void generateCode(BlockScope blockScope, CodeStream codeStream) {
        boolean bl;
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        int n = codeStream.position;
        BranchLabel branchLabel = new BranchLabel(codeStream);
        Constant constant = this.condition.optimizedBooleanConstant();
        boolean bl2 = (constant == Constant.NotAConstant || constant.booleanValue()) && this.thenStatement != null && !this.thenStatement.isEmptyBlock();
        boolean bl3 = bl = (constant == Constant.NotAConstant || !constant.booleanValue()) && this.elseStatement != null && !this.elseStatement.isEmptyBlock();
        if (bl2) {
            BranchLabel branchLabel2 = null;
            if (constant != Constant.NotAConstant && constant.booleanValue()) {
                this.condition.generateCode(blockScope, codeStream, false);
            } else {
                this.condition.generateOptimizedBoolean(blockScope, codeStream, null, bl ? (branchLabel2 = new BranchLabel(codeStream)) : branchLabel, true);
            }
            if (this.thenInitStateIndex != -1) {
                codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.thenInitStateIndex);
                codeStream.addDefinitelyAssignedVariables(blockScope, this.thenInitStateIndex);
            }
            this.thenStatement.generateCode(blockScope, codeStream);
            if (bl) {
                if ((this.bits & 0x40000000) == 0) {
                    this.thenStatement.branchChainTo(branchLabel);
                    int n2 = codeStream.position;
                    codeStream.goto_(branchLabel);
                    codeStream.recordPositionsFrom(n2, this.thenStatement.sourceEnd);
                }
                if (this.elseInitStateIndex != -1) {
                    codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.elseInitStateIndex);
                    codeStream.addDefinitelyAssignedVariables(blockScope, this.elseInitStateIndex);
                }
                if (branchLabel2 != null) {
                    branchLabel2.place();
                }
                this.elseStatement.generateCode(blockScope, codeStream);
            }
        } else if (bl) {
            if (constant != Constant.NotAConstant && !constant.booleanValue()) {
                this.condition.generateCode(blockScope, codeStream, false);
            } else {
                this.condition.generateOptimizedBoolean(blockScope, codeStream, branchLabel, null, true);
            }
            if (this.elseInitStateIndex != -1) {
                codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.elseInitStateIndex);
                codeStream.addDefinitelyAssignedVariables(blockScope, this.elseInitStateIndex);
            }
            this.elseStatement.generateCode(blockScope, codeStream);
        } else {
            this.condition.generateCode(blockScope, codeStream, false);
            codeStream.recordPositionsFrom(n, this.sourceStart);
        }
        if (this.mergedInitStateIndex != -1) {
            codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.mergedInitStateIndex);
            codeStream.addDefinitelyAssignedVariables(blockScope, this.mergedInitStateIndex);
        }
        branchLabel.place();
        codeStream.recordPositionsFrom(n, this.sourceStart);
    }

    @Override
    public StringBuffer printStatement(int n, StringBuffer stringBuffer) {
        IfStatement.printIndent(n, stringBuffer).append("if (");
        this.condition.printExpression(0, stringBuffer).append(")\n");
        this.thenStatement.printStatement(n + 2, stringBuffer);
        if (this.elseStatement != null) {
            stringBuffer.append('\n');
            IfStatement.printIndent(n, stringBuffer);
            stringBuffer.append("else\n");
            this.elseStatement.printStatement(n + 2, stringBuffer);
        }
        return stringBuffer;
    }

    @Override
    public void resolve(BlockScope blockScope) {
        TypeBinding typeBinding = this.condition.resolveTypeExpecting(blockScope, TypeBinding.BOOLEAN);
        this.condition.computeConversion(blockScope, typeBinding, typeBinding);
        if (this.thenStatement != null) {
            this.thenStatement.resolve(blockScope);
        }
        if (this.elseStatement != null) {
            this.elseStatement.resolve(blockScope);
        }
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            this.condition.traverse(aSTVisitor, blockScope);
            if (this.thenStatement != null) {
                this.thenStatement.traverse(aSTVisitor, blockScope);
            }
            if (this.elseStatement != null) {
                this.elseStatement.traverse(aSTVisitor, blockScope);
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }
}

