/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.details.jdk.ui;

import java.awt.Component;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToggleButton;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.modules.profiler.heapwalk.details.jdk.ui.BaseBuilders;
import org.netbeans.modules.profiler.heapwalk.details.jdk.ui.ComponentBuilders;
import org.netbeans.modules.profiler.heapwalk.details.jdk.ui.Utils;
import org.netbeans.modules.profiler.heapwalk.details.spi.DetailsUtils;

final class ButtonBuilders {
    ButtonBuilders() {
    }

    static ComponentBuilders.ComponentBuilder getBuilder(Instance instance, Heap heap) {
        if (DetailsUtils.isSubclassOf(instance, JButton.class.getName())) {
            return new JButtonBuilder(instance, heap);
        }
        if (DetailsUtils.isSubclassOf(instance, JCheckBox.class.getName())) {
            return new JCheckBoxBuilder(instance, heap);
        }
        if (DetailsUtils.isSubclassOf(instance, JRadioButton.class.getName())) {
            return new JRadioButtonBuilder(instance, heap);
        }
        if (DetailsUtils.isSubclassOf(instance, JToggleButton.class.getName())) {
            return new JToggleButtonBuilder(instance, heap);
        }
        if (DetailsUtils.isSubclassOf(instance, JCheckBoxMenuItem.class.getName())) {
            return new JCheckBoxMenuItemBuilder(instance, heap);
        }
        if (DetailsUtils.isSubclassOf(instance, JRadioButtonMenuItem.class.getName())) {
            return new JRadioButtonMenuItemBuilder(instance, heap);
        }
        if (DetailsUtils.isSubclassOf(instance, JMenu.class.getName())) {
            return new JMenuBuilder(instance, heap);
        }
        if (DetailsUtils.isSubclassOf(instance, JMenuBar.class.getName())) {
            return new JMenuBarBuilder(instance, heap);
        }
        if (DetailsUtils.isSubclassOf(instance, JMenuItem.class.getName())) {
            return new JMenuItemBuilder(instance, heap);
        }
        return null;
    }

    private static class JMenuBarBuilder
    extends ComponentBuilders.JComponentBuilder<JMenuBar> {
        private final boolean paintBorder;
        private final BaseBuilders.InsetsBuilder margin;

        JMenuBarBuilder(Instance instance, Heap heap) {
            super(instance, heap);
            this.paintBorder = DetailsUtils.getBooleanFieldValue(instance, "paintBorder", true);
            this.margin = BaseBuilders.InsetsBuilder.fromField(instance, "margin", heap);
        }

        @Override
        protected void setupInstance(JMenuBar jMenuBar) {
            super.setupInstance(jMenuBar);
            jMenuBar.setBorderPainted(this.paintBorder);
            if (this.margin != null) {
                jMenuBar.setMargin((Insets)this.margin.createInstance());
            }
        }

        @Override
        protected JMenuBar createInstanceImpl() {
            return new JMenuBar();
        }
    }

    private static class JMenuBuilder
    extends JMenuItemBuilder {
        JMenuBuilder(Instance instance, Heap heap) {
            super(instance, heap);
        }

        @Override
        protected JMenuItem createInstanceImpl() {
            return new JMenu();
        }

        @Override
        protected Component createPresenterImpl(JMenuItem jMenuItem) {
            JMenuBar jMenuBar = new JMenuBar();
            jMenuBar.add(jMenuItem);
            return jMenuBar;
        }
    }

    private static class JRadioButtonMenuItemBuilder
    extends JMenuItemBuilder {
        JRadioButtonMenuItemBuilder(Instance instance, Heap heap) {
            super(instance, heap);
        }

        @Override
        protected JMenuItem createInstanceImpl() {
            return new JRadioButtonMenuItem();
        }
    }

    private static class JCheckBoxMenuItemBuilder
    extends JMenuItemBuilder {
        JCheckBoxMenuItemBuilder(Instance instance, Heap heap) {
            super(instance, heap);
        }

        @Override
        protected JMenuItem createInstanceImpl() {
            return new JCheckBoxMenuItem();
        }
    }

    private static class JMenuItemBuilder
    extends AbstractButtonBuilder<JMenuItem> {
        JMenuItemBuilder(Instance instance, Heap heap) {
            super(instance, heap, true);
        }

        @Override
        protected JMenuItem createInstanceImpl() {
            return new JMenuItem();
        }

        @Override
        protected Component createPresenterImpl(JMenuItem jMenuItem) {
            Utils.JPopupMenuImpl jPopupMenuImpl = new Utils.JPopupMenuImpl();
            jPopupMenuImpl.add(jMenuItem);
            return jPopupMenuImpl;
        }
    }

    private static class JRadioButtonBuilder
    extends JToggleButtonBuilder {
        JRadioButtonBuilder(Instance instance, Heap heap) {
            super(instance, heap);
        }

        @Override
        protected JToggleButton createInstanceImpl() {
            return new JRadioButton();
        }
    }

    private static class JCheckBoxBuilder
    extends JToggleButtonBuilder {
        private final boolean flat;

        JCheckBoxBuilder(Instance instance, Heap heap) {
            super(instance, heap);
            this.flat = DetailsUtils.getBooleanFieldValue(instance, "flat", false);
        }

        @Override
        protected JToggleButton createInstanceImpl() {
            JCheckBox jCheckBox = new JCheckBox();
            jCheckBox.setBorderPaintedFlat(this.flat);
            return jCheckBox;
        }
    }

    private static class JToggleButtonBuilder
    extends AbstractButtonBuilder<JToggleButton> {
        JToggleButtonBuilder(Instance instance, Heap heap) {
            super(instance, heap);
        }

        @Override
        protected JToggleButton createInstanceImpl() {
            return new JToggleButton();
        }
    }

    private static final class JButtonBuilder
    extends AbstractButtonBuilder<JButton> {
        JButtonBuilder(Instance instance, Heap heap) {
            super(instance, heap);
        }

        @Override
        protected JButton createInstanceImpl() {
            return new JButton();
        }
    }

    private static abstract class AbstractButtonBuilder<T extends AbstractButton>
    extends ComponentBuilders.JComponentBuilder<T> {
        private final DefaultButtonModelBuilder model;
        private final String text;
        private final BaseBuilders.InsetsBuilder margin;
        private final BaseBuilders.IconBuilder defaultIcon;
        private final int verticalAlignment;
        private final boolean borderPaintedSet;
        private final boolean paintBorder;
        private final boolean contentAreaFilledSet;
        private final boolean contentAreaFilled;
        private final int horizontalAlignment;
        private final int verticalTextPosition;
        private final int horizontalTextPosition;
        private final int iconTextGap;

        AbstractButtonBuilder(Instance instance, Heap heap) {
            this(instance, heap, false);
        }

        AbstractButtonBuilder(Instance instance, Heap heap, boolean bl) {
            super(instance, heap, false);
            this.model = DefaultButtonModelBuilder.fromField(instance, "model", heap);
            this.text = Utils.getFieldString(instance, "text");
            this.margin = BaseBuilders.InsetsBuilder.fromField(instance, "margin", heap);
            this.defaultIcon = BaseBuilders.IconBuilder.fromField(instance, "defaultIcon", heap);
            this.borderPaintedSet = DetailsUtils.getBooleanFieldValue(instance, "borderPaintedSet", false);
            this.paintBorder = DetailsUtils.getBooleanFieldValue(instance, "paintBorder", true);
            this.contentAreaFilledSet = DetailsUtils.getBooleanFieldValue(instance, "contentAreaFilledSet", false);
            this.contentAreaFilled = DetailsUtils.getBooleanFieldValue(instance, "contentAreaFilled", true);
            this.verticalAlignment = DetailsUtils.getIntFieldValue(instance, "verticalAlignment", 0);
            this.horizontalAlignment = DetailsUtils.getIntFieldValue(instance, "horizontalAlignment", 10);
            this.verticalTextPosition = DetailsUtils.getIntFieldValue(instance, "verticalTextPosition", 0);
            this.horizontalTextPosition = DetailsUtils.getIntFieldValue(instance, "horizontalTextPosition", 11);
            this.iconTextGap = DetailsUtils.getIntFieldValue(instance, "iconTextGap", 4);
        }

        @Override
        protected void setupInstance(T t) {
            super.setupInstance(t);
            if (this.model != null) {
                ((AbstractButton)t).setModel((ButtonModel)this.model.createInstance());
            }
            ((AbstractButton)t).setText(this.text);
            if (this.margin != null) {
                ((AbstractButton)t).setMargin((Insets)this.margin.createInstance());
            }
            if (this.defaultIcon != null) {
                ((AbstractButton)t).setIcon((Icon)this.defaultIcon.createInstance());
            }
            if (this.borderPaintedSet) {
                ((AbstractButton)t).setBorderPainted(this.paintBorder);
            }
            if (this.contentAreaFilledSet) {
                ((AbstractButton)t).setContentAreaFilled(this.contentAreaFilled);
            }
            ((AbstractButton)t).setVerticalAlignment(this.verticalAlignment);
            ((AbstractButton)t).setHorizontalAlignment(this.horizontalAlignment);
            ((AbstractButton)t).setVerticalTextPosition(this.verticalTextPosition);
            ((AbstractButton)t).setHorizontalTextPosition(this.horizontalTextPosition);
            ((AbstractButton)t).setIconTextGap(this.iconTextGap);
        }
    }

    private static final class DefaultButtonModelBuilder
    extends Utils.InstanceBuilder<DefaultButtonModel> {
        private final int stateMask;

        DefaultButtonModelBuilder(Instance instance, Heap heap) {
            super(instance, heap);
            this.stateMask = DetailsUtils.getIntFieldValue(instance, "stateMask", 0);
        }

        static DefaultButtonModelBuilder fromField(Instance instance, String string, Heap heap) {
            Object object = instance.getValueOfField(string);
            if (!(object instanceof Instance)) {
                return null;
            }
            if (!DetailsUtils.isSubclassOf((Instance)object, DefaultButtonModel.class.getName())) {
                return null;
            }
            return new DefaultButtonModelBuilder((Instance)object, heap);
        }

        @Override
        protected void setupInstance(DefaultButtonModel defaultButtonModel) {
            super.setupInstance(defaultButtonModel);
            defaultButtonModel.setArmed((this.stateMask & 1) != 0);
            defaultButtonModel.setSelected((this.stateMask & 2) != 0);
            defaultButtonModel.setEnabled((this.stateMask & 8) != 0);
            defaultButtonModel.setPressed((this.stateMask & 4) != 0);
            defaultButtonModel.setRollover((this.stateMask & 0x10) != 0);
        }

        @Override
        protected DefaultButtonModel createInstanceImpl() {
            return new DefaultButtonModel();
        }
    }
}

