/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.util.Accountable;
import org.elasticsearch.index.fielddata.AtomicFieldData;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.shard.ShardId;

public interface IndexFieldDataCache {
    public <FD extends AtomicFieldData, IFD extends IndexFieldData<FD>> FD load(LeafReaderContext var1, IFD var2) throws Exception;

    public <FD extends AtomicFieldData, IFD extends IndexFieldData.Global<FD>> IFD load(DirectoryReader var1, IFD var2) throws Exception;

    public void clear();

    public void clear(String var1);

    public static class None
    implements IndexFieldDataCache {
        @Override
        public <FD extends AtomicFieldData, IFD extends IndexFieldData<FD>> FD load(LeafReaderContext context, IFD indexFieldData) throws Exception {
            return indexFieldData.loadDirect(context);
        }

        @Override
        public <FD extends AtomicFieldData, IFD extends IndexFieldData.Global<FD>> IFD load(DirectoryReader indexReader, IFD indexFieldData) throws Exception {
            return (IFD)((IndexFieldData.Global)indexFieldData.localGlobalDirect(indexReader));
        }

        @Override
        public void clear() {
        }

        @Override
        public void clear(String fieldName) {
        }
    }

    public static interface Listener {
        public void onCache(ShardId var1, MappedFieldType.Names var2, FieldDataType var3, Accountable var4);

        public void onRemoval(ShardId var1, MappedFieldType.Names var2, FieldDataType var3, boolean var4, long var5);
    }
}

