#############################################################################
##
#W  database.g                GAP4 Package `RCWA'                 Stefan Kohl
##
##  Data library of the groups generated by 3 class transpositions which
##  interchange residue classes with moduli <= 9.
##
##  This data library is a record with the following components:
##
##    - 'cts' is a list of all class transpositions which interchange
##      residue classes with moduli <= 9.
##    - 'mods' is the list of moduli, i.e. we have
##      mods[i][j][k] = Mod(Group(cts{[i,j,k]})).
##    - 'partlengths' is the list of lengths of shortest respected
##      partitions, i.e. we have partlengths[i][j][k] =
##      Length(RespectedPartition(Group(cts{[i,j,k]}))).
##    - 'sizes' is the list of group orders, i.e. we have
##      sizes[i][j][k] = Size(Group(cts{[i,j,k]})).
##      This list is recovered from the two lists 'sizesset' and 'sizespos',
##      where sizes[i][j][k] = sizesset[sizespos[i][j][k]].
##
return rec(

  cts := List(List(ClassPairs(9),ClassTransposition),SparseRep),

  mods :=
    ReadAsFunction(Concatenation(PackageInfo("rcwa")[1].InstallationPath,
                                 "/data/3ctsgroups9/mods.g"))(),

  partlengths :=
    ReadAsFunction(Concatenation(PackageInfo("rcwa")[1].InstallationPath,
                                 "/data/3ctsgroups9/partitionlengths.g"))(),

  sizesset :=
    ReadAsFunction(Concatenation(PackageInfo("rcwa")[1].InstallationPath,
                                 "/data/3ctsgroups9/sizesset.g"))(),

  sizespos :=
    ReadAsFunction(Concatenation(PackageInfo("rcwa")[1].InstallationPath,
                                 "/data/3ctsgroups9/sizespos.g"))()

);

#############################################################################
##
#E  database.g . . . . . . . . . . . . . . . . . . . . . . . . . .  ends here