/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import org.scilab.forge.jlatexmath.CharFont;
import org.scilab.forge.jlatexmath.FontAlreadyLoadedException;
import org.scilab.forge.jlatexmath.FontInfo;
import org.scilab.forge.jlatexmath.ResourceParseException;
import org.scilab.forge.jlatexmath.SymbolAtom;
import org.scilab.forge.jlatexmath.TeXFormula;
import org.scilab.forge.jlatexmath.XMLResourceParseException;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTeXFontParser {
    private static boolean registerFontExceptionDisplayed = false;
    private static boolean shouldRegisterFonts = true;
    private static DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    public static final String RESOURCE_NAME = "DefaultTeXFont.xml";
    public static final String STYLE_MAPPING_EL = "TextStyleMapping";
    public static final String SYMBOL_MAPPING_EL = "SymbolMapping";
    public static final String GEN_SET_EL = "GeneralSettings";
    public static final String MUFONTID_ATTR = "mufontid";
    public static final String SPACEFONTID_ATTR = "spacefontid";
    protected static ArrayList<String> Font_ID = new ArrayList();
    private static Map<String, Integer> rangeTypeMappings = new HashMap<String, Integer>();
    private static Map<String, CharChildParser> charChildParsers = new HashMap<String, CharChildParser>();
    private Map<String, CharFont[]> parsedTextStyles;
    private Element root;
    private Object base = null;

    public DefaultTeXFontParser() throws ResourceParseException {
        this(DefaultTeXFontParser.class.getResourceAsStream(RESOURCE_NAME), RESOURCE_NAME);
    }

    public DefaultTeXFontParser(InputStream inputStream, String string) throws ResourceParseException {
        factory.setIgnoringElementContentWhitespace(true);
        factory.setIgnoringComments(true);
        try {
            this.root = factory.newDocumentBuilder().parse(inputStream).getDocumentElement();
        }
        catch (Exception exception) {
            throw new XMLResourceParseException(string, exception);
        }
    }

    public DefaultTeXFontParser(Object object, InputStream inputStream, String string) throws ResourceParseException {
        this.base = object;
        factory.setIgnoringElementContentWhitespace(true);
        factory.setIgnoringComments(true);
        try {
            this.root = factory.newDocumentBuilder().parse(inputStream).getDocumentElement();
        }
        catch (Exception exception) {
            throw new XMLResourceParseException(string, exception);
        }
    }

    private static void setCharChildParsers() {
        charChildParsers.put("Kern", new KernParser());
        charChildParsers.put("Lig", new LigParser());
        charChildParsers.put("NextLarger", new NextLargerParser());
        charChildParsers.put("Extension", new ExtensionParser());
    }

    public FontInfo[] parseFontDescriptions(FontInfo[] fontInfoArray, InputStream inputStream, String string) throws ResourceParseException {
        int n;
        Element element;
        if (inputStream == null) {
            return fontInfoArray;
        }
        ArrayList<FontInfo> arrayList = new ArrayList<FontInfo>(Arrays.asList(fontInfoArray));
        try {
            element = factory.newDocumentBuilder().parse(inputStream).getDocumentElement();
        }
        catch (Exception exception) {
            throw new XMLResourceParseException("Cannot find the file " + string + "!" + exception.toString());
        }
        String string2 = DefaultTeXFontParser.getAttrValueAndCheckIfNotNull("name", element);
        String string3 = DefaultTeXFontParser.getAttrValueAndCheckIfNotNull("id", element);
        if (Font_ID.indexOf(string3) >= 0) {
            throw new FontAlreadyLoadedException("Font " + string3 + " is already loaded !");
        }
        Font_ID.add(string3);
        float f = DefaultTeXFontParser.getFloatAndCheck("space", element);
        float f2 = DefaultTeXFontParser.getFloatAndCheck("xHeight", element);
        float f3 = DefaultTeXFontParser.getFloatAndCheck("quad", element);
        int n2 = DefaultTeXFontParser.getOptionalInt("skewChar", element, -1);
        int n3 = DefaultTeXFontParser.getOptionalInt("unicode", element, 0);
        String string4 = null;
        try {
            string4 = DefaultTeXFontParser.getAttrValueAndCheckIfNotNull("boldVersion", element);
        }
        catch (ResourceParseException resourceParseException) {
            // empty catch block
        }
        String string5 = null;
        try {
            string5 = DefaultTeXFontParser.getAttrValueAndCheckIfNotNull("romanVersion", element);
        }
        catch (ResourceParseException resourceParseException) {
            // empty catch block
        }
        String string6 = null;
        try {
            string6 = DefaultTeXFontParser.getAttrValueAndCheckIfNotNull("ssVersion", element);
        }
        catch (ResourceParseException resourceParseException) {
            // empty catch block
        }
        String string7 = null;
        try {
            string7 = DefaultTeXFontParser.getAttrValueAndCheckIfNotNull("ttVersion", element);
        }
        catch (ResourceParseException resourceParseException) {
            // empty catch block
        }
        String string8 = null;
        try {
            string8 = DefaultTeXFontParser.getAttrValueAndCheckIfNotNull("itVersion", element);
        }
        catch (ResourceParseException resourceParseException) {
            // empty catch block
        }
        String string9 = string.substring(0, string.lastIndexOf("/") + 1) + string2;
        FontInfo fontInfo = new FontInfo(Font_ID.indexOf(string3), this.base, string9, string2, n3, f2, f, f3, string4, string5, string6, string7, string8);
        if (n2 != -1) {
            fontInfo.setSkewChar((char)n2);
        }
        NodeList nodeList = element.getElementsByTagName("Char");
        for (n = 0; n < nodeList.getLength(); ++n) {
            DefaultTeXFontParser.processCharElement((Element)nodeList.item(n), fontInfo);
        }
        arrayList.add(fontInfo);
        for (n = 0; n < arrayList.size(); ++n) {
            FontInfo fontInfo2 = arrayList.get(n);
            fontInfo2.setBoldId(Font_ID.indexOf(fontInfo2.boldVersion));
            fontInfo2.setRomanId(Font_ID.indexOf(fontInfo2.romanVersion));
            fontInfo2.setSsId(Font_ID.indexOf(fontInfo2.ssVersion));
            fontInfo2.setTtId(Font_ID.indexOf(fontInfo2.ttVersion));
            fontInfo2.setItId(Font_ID.indexOf(fontInfo2.itVersion));
        }
        this.parsedTextStyles = this.parseStyleMappings();
        return arrayList.toArray(fontInfoArray);
    }

    public FontInfo[] parseFontDescriptions(FontInfo[] fontInfoArray) throws ResourceParseException {
        Element element = (Element)this.root.getElementsByTagName("FontDescriptions").item(0);
        if (element != null) {
            NodeList nodeList = element.getElementsByTagName("Metrics");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String string = DefaultTeXFontParser.getAttrValueAndCheckIfNotNull("include", (Element)nodeList.item(i));
                fontInfoArray = this.base == null ? this.parseFontDescriptions(fontInfoArray, DefaultTeXFontParser.class.getResourceAsStream(string), string) : this.parseFontDescriptions(fontInfoArray, this.base.getClass().getResourceAsStream(string), string);
            }
        }
        return fontInfoArray;
    }

    protected void parseExtraPath() throws ResourceParseException {
        Object object;
        Element element = (Element)this.root.getElementsByTagName("TeXSymbols").item(0);
        if (element != null) {
            object = DefaultTeXFontParser.getAttrValueAndCheckIfNotNull("include", element);
            SymbolAtom.addSymbolAtom(this.base.getClass().getResourceAsStream((String)object), (String)object);
        }
        if ((object = (Element)this.root.getElementsByTagName("FormulaSettings").item(0)) != null) {
            String string = DefaultTeXFontParser.getAttrValueAndCheckIfNotNull("include", (Element)object);
            TeXFormula.addSymbolMappings(this.base.getClass().getResourceAsStream(string), string);
        }
    }

    private static void processCharElement(Element element, FontInfo fontInfo) throws ResourceParseException {
        char c = (char)DefaultTeXFontParser.getIntAndCheck("code", element);
        float[] fArray = new float[]{DefaultTeXFontParser.getOptionalFloat("width", element, 0.0f), DefaultTeXFontParser.getOptionalFloat("height", element, 0.0f), DefaultTeXFontParser.getOptionalFloat("depth", element, 0.0f), DefaultTeXFontParser.getOptionalFloat("italic", element, 0.0f)};
        fontInfo.setMetrics(c, fArray);
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() == 3) continue;
            Element element2 = (Element)node;
            CharChildParser charChildParser = charChildParsers.get(element2.getTagName());
            if (charChildParser == null) {
                throw new XMLResourceParseException("DefaultTeXFont.xml: a <Char>-element has an unknown child element '" + element2.getTagName() + "'!");
            }
            charChildParser.parse(element2, c, fontInfo);
        }
    }

    public static void registerFonts(boolean bl) {
        shouldRegisterFonts = bl;
    }

    public static Font createFont(String string) throws ResourceParseException {
        return DefaultTeXFontParser.createFont(DefaultTeXFontParser.class.getResourceAsStream(string), string);
    }

    public static Font createFont(InputStream inputStream, String string) throws ResourceParseException {
        try {
            Object object;
            Font font;
            block14: {
                font = Font.createFont(0, inputStream).deriveFont(TeXFormula.PIXELS_PER_POINT);
                GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
                if (shouldRegisterFonts) {
                    try {
                        object = graphicsEnvironment.getClass().getMethod("registerFont", Font.class);
                        if ((Boolean)((Method)object).invoke((Object)graphicsEnvironment, font) == Boolean.FALSE) {
                            System.err.println("Cannot register the font " + font.getFontName());
                        }
                    }
                    catch (Exception exception) {
                        if (registerFontExceptionDisplayed) break block14;
                        System.err.println("Warning: Jlatexmath: Could not access to registerFont. Please update to java 6");
                        registerFontExceptionDisplayed = true;
                    }
                }
            }
            object = font;
            return object;
        }
        catch (Exception exception) {
            throw new XMLResourceParseException("DefaultTeXFont.xml: error reading font '" + string + "'. Error message: " + exception.getMessage());
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException("Close threw exception", iOException);
            }
        }
    }

    public Map<String, CharFont> parseSymbolMappings() throws ResourceParseException {
        HashMap<String, CharFont> hashMap = new HashMap<String, CharFont>();
        Element element = (Element)this.root.getElementsByTagName("SymbolMappings").item(0);
        if (element == null) {
            throw new XMLResourceParseException(RESOURCE_NAME, "SymbolMappings");
        }
        NodeList nodeList = element.getElementsByTagName("Mapping");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2;
            String string = DefaultTeXFontParser.getAttrValueAndCheckIfNotNull("include", (Element)nodeList.item(i));
            try {
                element2 = this.base == null ? factory.newDocumentBuilder().parse(DefaultTeXFontParser.class.getResourceAsStream(string)).getDocumentElement() : factory.newDocumentBuilder().parse(this.base.getClass().getResourceAsStream(string)).getDocumentElement();
            }
            catch (Exception exception) {
                throw new XMLResourceParseException("Cannot find the file " + string + "!");
            }
            NodeList nodeList2 = element2.getElementsByTagName(SYMBOL_MAPPING_EL);
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                Element element3 = (Element)nodeList2.item(j);
                String string2 = DefaultTeXFontParser.getAttrValueAndCheckIfNotNull("name", element3);
                int n = DefaultTeXFontParser.getIntAndCheck("ch", element3);
                String string3 = DefaultTeXFontParser.getAttrValueAndCheckIfNotNull("fontId", element3);
                String string4 = null;
                try {
                    string4 = DefaultTeXFontParser.getAttrValueAndCheckIfNotNull("boldId", element3);
                }
                catch (ResourceParseException resourceParseException) {
                    // empty catch block
                }
                if (string4 == null) {
                    hashMap.put(string2, new CharFont((char)n, Font_ID.indexOf(string3)));
                    continue;
                }
                hashMap.put(string2, new CharFont((char)n, Font_ID.indexOf(string3), Font_ID.indexOf(string4)));
            }
        }
        return hashMap;
    }

    public String[] parseDefaultTextStyleMappings() throws ResourceParseException {
        String[] stringArray = new String[4];
        Element element = (Element)this.root.getElementsByTagName("DefaultTextStyleMapping").item(0);
        if (element == null) {
            return stringArray;
        }
        NodeList nodeList = element.getElementsByTagName("MapStyle");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            int n;
            Element element2 = (Element)nodeList.item(i);
            String string = DefaultTeXFontParser.getAttrValueAndCheckIfNotNull("code", element2);
            Integer n2 = rangeTypeMappings.get(string);
            if (n2 == null) {
                throw new XMLResourceParseException(RESOURCE_NAME, "MapStyle", "code", "contains an unknown \"range name\" '" + string + "'!");
            }
            String string2 = DefaultTeXFontParser.getAttrValueAndCheckIfNotNull("textStyle", element2);
            CharFont[] charFontArray = this.parsedTextStyles.get(string2);
            if (charFontArray == null) {
                throw new XMLResourceParseException(RESOURCE_NAME, "MapStyle", "textStyle", "contains an unknown text style '" + string2 + "'!");
            }
            CharFont[] charFontArray2 = this.parsedTextStyles.get(string2);
            if (charFontArray2[n = n2.intValue()] == null) {
                throw new XMLResourceParseException("DefaultTeXFont.xml: the default text style mapping '" + string2 + "' for the range '" + string + "' contains no mapping for that range!");
            }
            stringArray[n] = string2;
        }
        return stringArray;
    }

    public Map<String, Float> parseParameters() throws ResourceParseException {
        HashMap<String, Float> hashMap = new HashMap<String, Float>();
        Element element = (Element)this.root.getElementsByTagName("Parameters").item(0);
        if (element == null) {
            throw new XMLResourceParseException(RESOURCE_NAME, "Parameters");
        }
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            String string = ((Attr)namedNodeMap.item(i)).getName();
            hashMap.put(string, new Float(DefaultTeXFontParser.getFloatAndCheck(string, element)));
        }
        return hashMap;
    }

    public Map<String, Number> parseGeneralSettings() throws ResourceParseException {
        HashMap<String, Number> hashMap = new HashMap<String, Number>();
        Element element = (Element)this.root.getElementsByTagName(GEN_SET_EL).item(0);
        if (element == null) {
            throw new XMLResourceParseException(RESOURCE_NAME, GEN_SET_EL);
        }
        hashMap.put(MUFONTID_ATTR, Font_ID.indexOf(DefaultTeXFontParser.getAttrValueAndCheckIfNotNull(MUFONTID_ATTR, element)));
        hashMap.put(SPACEFONTID_ATTR, Font_ID.indexOf(DefaultTeXFontParser.getAttrValueAndCheckIfNotNull(SPACEFONTID_ATTR, element)));
        hashMap.put("scriptfactor", Float.valueOf(DefaultTeXFontParser.getFloatAndCheck("scriptfactor", element)));
        hashMap.put("scriptscriptfactor", Float.valueOf(DefaultTeXFontParser.getFloatAndCheck("scriptscriptfactor", element)));
        return hashMap;
    }

    public Map<String, CharFont[]> parseTextStyleMappings() {
        return this.parsedTextStyles;
    }

    private Map<String, CharFont[]> parseStyleMappings() throws ResourceParseException {
        HashMap<String, CharFont[]> hashMap = new HashMap<String, CharFont[]>();
        Element element = (Element)this.root.getElementsByTagName("TextStyleMappings").item(0);
        if (element == null) {
            return hashMap;
        }
        NodeList nodeList = element.getElementsByTagName(STYLE_MAPPING_EL);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2 = (Element)nodeList.item(i);
            String string = DefaultTeXFontParser.getAttrValueAndCheckIfNotNull("name", element2);
            String string2 = null;
            try {
                string2 = DefaultTeXFontParser.getAttrValueAndCheckIfNotNull("bold", element2);
            }
            catch (ResourceParseException resourceParseException) {
                // empty catch block
            }
            NodeList nodeList2 = element2.getElementsByTagName("MapRange");
            CharFont[] charFontArray = new CharFont[4];
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                Element element3 = (Element)nodeList2.item(j);
                String string3 = DefaultTeXFontParser.getAttrValueAndCheckIfNotNull("fontId", element3);
                int n = DefaultTeXFontParser.getIntAndCheck("start", element3);
                String string4 = DefaultTeXFontParser.getAttrValueAndCheckIfNotNull("code", element3);
                Integer n2 = rangeTypeMappings.get(string4);
                if (n2 == null) {
                    throw new XMLResourceParseException(RESOURCE_NAME, "MapRange", "code", "contains an unknown \"range name\" '" + string4 + "'!");
                }
                charFontArray[n2.intValue()] = string2 == null ? new CharFont((char)n, Font_ID.indexOf(string3)) : new CharFont((char)n, Font_ID.indexOf(string3), Font_ID.indexOf(string2));
            }
            hashMap.put(string, charFontArray);
        }
        return hashMap;
    }

    private static void setRangeTypeMappings() {
        rangeTypeMappings.put("numbers", 0);
        rangeTypeMappings.put("capitals", 1);
        rangeTypeMappings.put("small", 2);
        rangeTypeMappings.put("unicode", 3);
    }

    private static String getAttrValueAndCheckIfNotNull(String string, Element element) throws ResourceParseException {
        String string2 = element.getAttribute(string);
        if (string2.equals("")) {
            throw new XMLResourceParseException(RESOURCE_NAME, element.getTagName(), string, null);
        }
        return string2;
    }

    public static float getFloatAndCheck(String string, Element element) throws ResourceParseException {
        String string2 = DefaultTeXFontParser.getAttrValueAndCheckIfNotNull(string, element);
        float f = 0.0f;
        try {
            f = (float)Double.parseDouble(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new XMLResourceParseException(RESOURCE_NAME, element.getTagName(), string, "has an invalid real value!");
        }
        return f;
    }

    public static int getIntAndCheck(String string, Element element) throws ResourceParseException {
        String string2 = DefaultTeXFontParser.getAttrValueAndCheckIfNotNull(string, element);
        int n = 0;
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new XMLResourceParseException(RESOURCE_NAME, element.getTagName(), string, "has an invalid integer value!");
        }
        return n;
    }

    public static int getOptionalInt(String string, Element element, int n) throws ResourceParseException {
        String string2 = element.getAttribute(string);
        if (string2.equals("")) {
            return n;
        }
        int n2 = 0;
        try {
            n2 = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new XMLResourceParseException(RESOURCE_NAME, element.getTagName(), string, "has an invalid integer value!");
        }
        return n2;
    }

    public static float getOptionalFloat(String string, Element element, float f) throws ResourceParseException {
        String string2 = element.getAttribute(string);
        if (string2.equals("")) {
            return f;
        }
        float f2 = 0.0f;
        try {
            f2 = (float)Double.parseDouble(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new XMLResourceParseException(RESOURCE_NAME, element.getTagName(), string, "has an invalid float value!");
        }
        return f2;
    }

    static {
        DefaultTeXFontParser.setRangeTypeMappings();
        DefaultTeXFontParser.setCharChildParsers();
    }

    private static interface CharChildParser {
        public void parse(Element var1, char var2, FontInfo var3) throws XMLResourceParseException;
    }

    private static class ExtensionParser
    implements CharChildParser {
        ExtensionParser() {
        }

        public void parse(Element element, char c, FontInfo fontInfo) throws ResourceParseException {
            int[] nArray = new int[4];
            nArray[2] = DefaultTeXFontParser.getIntAndCheck("rep", element);
            nArray[0] = DefaultTeXFontParser.getOptionalInt("top", element, -1);
            nArray[1] = DefaultTeXFontParser.getOptionalInt("mid", element, -1);
            nArray[3] = DefaultTeXFontParser.getOptionalInt("bot", element, -1);
            fontInfo.setExtension(c, nArray);
        }
    }

    private static class KernParser
    implements CharChildParser {
        KernParser() {
        }

        public void parse(Element element, char c, FontInfo fontInfo) throws ResourceParseException {
            int n = DefaultTeXFontParser.getIntAndCheck("code", element);
            float f = DefaultTeXFontParser.getFloatAndCheck("val", element);
            fontInfo.addKern(c, (char)n, f);
        }
    }

    private static class LigParser
    implements CharChildParser {
        LigParser() {
        }

        public void parse(Element element, char c, FontInfo fontInfo) throws ResourceParseException {
            int n = DefaultTeXFontParser.getIntAndCheck("code", element);
            int n2 = DefaultTeXFontParser.getIntAndCheck("ligCode", element);
            fontInfo.addLigature(c, (char)n, (char)n2);
        }
    }

    private static class NextLargerParser
    implements CharChildParser {
        NextLargerParser() {
        }

        public void parse(Element element, char c, FontInfo fontInfo) throws ResourceParseException {
            String string = DefaultTeXFontParser.getAttrValueAndCheckIfNotNull("fontId", element);
            int n = DefaultTeXFontParser.getIntAndCheck("code", element);
            fontInfo.setNextLarger(c, (char)n, Font_ID.indexOf(string));
        }
    }
}

