/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.buildcomparison.gradle.internal;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.gradle.api.Transformer;
import org.gradle.api.plugins.buildcomparison.outcome.internal.BuildOutcome;
import org.gradle.api.plugins.buildcomparison.outcome.internal.archive.GeneratedArchiveBuildOutcome;
import org.gradle.api.plugins.buildcomparison.outcome.internal.unknown.UnknownBuildOutcome;
import org.gradle.internal.resource.local.FileStore;
import org.gradle.internal.resource.local.LocallyAvailableResource;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GradleBuildOutcomeSetInferrer
implements Transformer<Set<BuildOutcome>, Set<BuildOutcome>> {
    private final FileStore<String> fileStore;
    private final String fileStorePrefix;
    private final File baseDir;

    public GradleBuildOutcomeSetInferrer(FileStore<String> fileStore, String fileStorePrefix, File baseDir) {
        this.fileStore = fileStore;
        this.fileStorePrefix = fileStorePrefix;
        this.baseDir = baseDir;
    }

    public Set<BuildOutcome> transform(Set<BuildOutcome> sourceOutcomes) {
        return (Set)CollectionUtils.collect(sourceOutcomes, new HashSet(sourceOutcomes.size()), (Transformer)new Transformer<BuildOutcome, BuildOutcome>(){

            public BuildOutcome transform(BuildOutcome original) {
                return GradleBuildOutcomeSetInferrer.this.infer(original);
            }
        });
    }

    private BuildOutcome infer(BuildOutcome outcome) {
        if (outcome instanceof UnknownBuildOutcome) {
            return new UnknownBuildOutcome(outcome.getName(), outcome.getDescription());
        }
        if (outcome instanceof GeneratedArchiveBuildOutcome) {
            GeneratedArchiveBuildOutcome archiveBuildOutcome = (GeneratedArchiveBuildOutcome)outcome;
            File file = new File(this.baseDir, archiveBuildOutcome.getRootRelativePath());
            String rootRelativePath = archiveBuildOutcome.getRootRelativePath();
            String taskPath = outcome.getName();
            LocallyAvailableResource resource = null;
            if (file.exists()) {
                String filestoreDestination = String.format("%s/%s/%s", this.fileStorePrefix, taskPath, file.getName());
                resource = this.fileStore.move((Object)filestoreDestination, file);
            }
            return new GeneratedArchiveBuildOutcome(outcome.getName(), outcome.getDescription(), resource, rootRelativePath);
        }
        throw new IllegalStateException(String.format("Unhandled build outcome type: %s", outcome.getClass().getName()));
    }
}

