/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories.resolver;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.ivy.util.ContextualSAXHandler;
import org.apache.ivy.util.XMLHelper;
import org.gradle.api.Action;
import org.gradle.api.internal.artifacts.repositories.resolver.MavenMetadata;
import org.gradle.internal.ErroringAction;
import org.gradle.internal.resource.ExternalResource;
import org.gradle.internal.resource.ResourceException;
import org.gradle.internal.resource.ResourceNotFoundException;
import org.gradle.internal.resource.transport.ExternalResourceRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class MavenMetadataLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(MavenMetadataLoader.class);
    private final ExternalResourceRepository repository;

    public MavenMetadataLoader(ExternalResourceRepository repository) {
        this.repository = repository;
    }

    public MavenMetadata load(URI metadataLocation) throws ResourceException {
        MavenMetadata metadata = new MavenMetadata();
        try {
            this.parseMavenMetadataInfo(metadataLocation, metadata);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceException(metadataLocation, String.format("Unable to load Maven meta-data from %s.", metadataLocation), (Throwable)e);
        }
        return metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseMavenMetadataInfo(URI metadataLocation, MavenMetadata metadata) {
        ExternalResource resource = this.repository.getResource(metadataLocation);
        if (resource == null) {
            throw new ResourceNotFoundException(metadataLocation, String.format("Maven meta-data not available: %s", metadataLocation));
        }
        try {
            this.parseMavenMetadataInto(resource, metadata);
        }
        finally {
            resource.close();
        }
    }

    private void parseMavenMetadataInto(ExternalResource metadataResource, final MavenMetadata mavenMetadata) {
        LOGGER.debug("parsing maven-metadata: {}", (Object)metadataResource);
        metadataResource.withContent((Action)new ErroringAction<InputStream>(){

            public void doExecute(InputStream inputStream) throws ParserConfigurationException, SAXException, IOException {
                XMLHelper.parse((InputStream)inputStream, null, (DefaultHandler)new ContextualSAXHandler(){

                    public void endElement(String uri, String localName, String qName) throws SAXException {
                        if ("metadata/versioning/snapshot/timestamp".equals(this.getContext())) {
                            mavenMetadata.timestamp = this.getText();
                        }
                        if ("metadata/versioning/snapshot/buildNumber".equals(this.getContext())) {
                            mavenMetadata.buildNumber = this.getText();
                        }
                        if ("metadata/versioning/versions/version".equals(this.getContext())) {
                            mavenMetadata.versions.add(this.getText().trim());
                        }
                        super.endElement(uri, localName, qName);
                    }
                }, null);
            }
        });
    }
}

