/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testkit.jarjar.org.gradle.util;

import java.net.URI;
import java.net.URISyntaxException;
import org.gradle.testkit.jarjar.org.gradle.internal.UncheckedException;
import org.gradle.testkit.jarjar.org.gradle.util.GradleVersion;

public class DistributionLocator {
    private static final String RELEASE_REPOSITORY = "https://services.gradle.org/distributions";
    private static final String SNAPSHOT_REPOSITORY = "https://services.gradle.org/distributions-snapshots";

    public URI getDistributionFor(GradleVersion version) {
        return this.getDistribution(this.getDistributionRepository(version), version, "gradle", "bin");
    }

    private String getDistributionRepository(GradleVersion version) {
        if (version.isSnapshot()) {
            return SNAPSHOT_REPOSITORY;
        }
        return RELEASE_REPOSITORY;
    }

    private URI getDistribution(String repositoryUrl, GradleVersion version, String archiveName, String archiveClassifier) {
        try {
            return new URI(String.format("%s/%s-%s-%s.zip", repositoryUrl, archiveName, version.getVersion(), archiveClassifier));
        }
        catch (URISyntaxException e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
    }
}

