/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.daemon;

import java.io.File;
import org.gradle.StartParameter;
import org.gradle.api.Action;
import org.gradle.api.internal.tasks.compile.daemon.CompilerDaemonClient;
import org.gradle.api.internal.tasks.compile.daemon.CompilerDaemonClientProtocol;
import org.gradle.api.internal.tasks.compile.daemon.CompilerDaemonServer;
import org.gradle.api.internal.tasks.compile.daemon.CompilerDaemonServerProtocol;
import org.gradle.api.internal.tasks.compile.daemon.DaemonForkOptions;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.Factory;
import org.gradle.process.internal.JavaExecHandleBuilder;
import org.gradle.process.internal.WorkerProcess;
import org.gradle.process.internal.WorkerProcessBuilder;
import org.gradle.util.Clock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompilerDaemonStarter {
    private static final Logger LOG = Logging.getLogger(CompilerDaemonStarter.class);
    private final Factory<WorkerProcessBuilder> workerFactory;
    private final StartParameter startParameter;

    public CompilerDaemonStarter(Factory<WorkerProcessBuilder> workerFactory, StartParameter startParameter) {
        this.workerFactory = workerFactory;
        this.startParameter = startParameter;
    }

    public CompilerDaemonClient startDaemon(File workingDir, DaemonForkOptions forkOptions) {
        LOG.debug("Starting Gradle compiler daemon with fork options {}.", (Object)forkOptions);
        Clock clock = new Clock();
        WorkerProcessBuilder builder = (WorkerProcessBuilder)this.workerFactory.create();
        builder.setLogLevel(this.startParameter.getLogLevel());
        builder.applicationClasspath(forkOptions.getClasspath());
        builder.sharedPackages(forkOptions.getSharedPackages());
        builder.setLoadApplicationInSystemClassLoader(true);
        JavaExecHandleBuilder javaCommand = builder.getJavaCommand();
        javaCommand.setMinHeapSize(forkOptions.getMinHeapSize());
        javaCommand.setMaxHeapSize(forkOptions.getMaxHeapSize());
        javaCommand.setJvmArgs(forkOptions.getJvmArgs());
        javaCommand.setWorkingDir((Object)workingDir);
        WorkerProcess process = builder.worker((Action)new CompilerDaemonServer()).setBaseName("Gradle Compiler Daemon").build();
        process.start();
        CompilerDaemonServerProtocol server = (CompilerDaemonServerProtocol)process.getConnection().addOutgoing(CompilerDaemonServerProtocol.class);
        CompilerDaemonClient client = new CompilerDaemonClient(forkOptions, process, server);
        process.getConnection().addIncoming(CompilerDaemonClientProtocol.class, (Object)client);
        process.getConnection().connect();
        LOG.info("Started Gradle compiler daemon ({}) with fork options {}.", (Object)clock.getTime(), (Object)forkOptions);
        return client;
    }
}

