/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.gpx;

import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.openstreetmap.gui.jmapviewer.tilesources.AbstractTMSTileSource;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AbstractMergeAction;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.GpxTrackSegment;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.layer.AbstractTileSourceLayer;
import org.openstreetmap.josm.gui.progress.ProgressTaskId;
import org.openstreetmap.josm.gui.progress.ProgressTaskIds;
import org.openstreetmap.josm.gui.widgets.JosmComboBox;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.xml.sax.SAXException;

public class DownloadWmsAlongTrackAction
extends AbstractAction {
    private final transient GpxData data;

    public DownloadWmsAlongTrackAction(GpxData gpxData) {
        super(I18n.tr("Precache imagery tiles along this track", new Object[0]), ImageProvider.get("downloadalongtrack"));
        this.data = gpxData;
    }

    PrecacheWmsTask createTask() {
        ArrayList<LatLon> arrayList = new ArrayList<LatLon>();
        for (GpxTrack iWithAttributes : this.data.tracks) {
            for (GpxTrackSegment gpxTrackSegment : iWithAttributes.getSegments()) {
                for (WayPoint wayPoint : gpxTrackSegment.getWayPoints()) {
                    arrayList.add(wayPoint.getCoor());
                }
            }
        }
        for (WayPoint wayPoint : this.data.waypoints) {
            arrayList.add(wayPoint.getCoor());
        }
        AbstractTileSourceLayer<? extends AbstractTMSTileSource> abstractTileSourceLayer = this.askedLayer();
        return abstractTileSourceLayer != null ? new PrecacheWmsTask(abstractTileSourceLayer, arrayList) : null;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        PrecacheWmsTask precacheWmsTask = this.createTask();
        if (precacheWmsTask != null) {
            Main.worker.execute(precacheWmsTask);
        }
    }

    protected AbstractTileSourceLayer<? extends AbstractTMSTileSource> askedLayer() {
        if (!Main.isDisplayingMapView()) {
            return null;
        }
        List<AbstractTileSourceLayer> list = Main.map.mapView.getLayersOfType(AbstractTileSourceLayer.class);
        if (list.isEmpty()) {
            if (!GraphicsEnvironment.isHeadless()) {
                this.warnNoImageryLayers();
            }
            return null;
        }
        JosmComboBox<AbstractTileSourceLayer> josmComboBox = new JosmComboBox<AbstractTileSourceLayer>(list.toArray(new AbstractTileSourceLayer[0]));
        josmComboBox.setRenderer(new AbstractMergeAction.LayerListCellRenderer());
        josmComboBox.setSelectedIndex(0);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)new JLabel(I18n.tr("Please select the imagery layer.", new Object[0])), GBC.eol());
        jPanel.add(josmComboBox, GBC.eol());
        if (GraphicsEnvironment.isHeadless()) {
            return list.get(0);
        }
        ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, I18n.tr("Select imagery layer", new Object[0]), new String[]{I18n.tr("Download", new Object[0]), I18n.tr("Cancel", new Object[0])});
        extendedDialog.setButtonIcons(new String[]{"dialogs/down", "cancel"});
        extendedDialog.setContent(jPanel);
        extendedDialog.showDialog();
        if (extendedDialog.getValue() != 1) {
            return null;
        }
        return (AbstractTileSourceLayer)josmComboBox.getSelectedItem();
    }

    protected void warnNoImageryLayers() {
        JOptionPane.showMessageDialog(Main.parent, I18n.tr("There are no imagery layers.", new Object[0]), I18n.tr("No imagery layers", new Object[0]), 2);
    }

    static class PrecacheWmsTask
    extends PleaseWaitRunnable {
        private final AbstractTileSourceLayer<? extends AbstractTMSTileSource> layer;
        private final List<LatLon> points;
        private AbstractTileSourceLayer.PrecacheTask precacheTask;

        protected PrecacheWmsTask(AbstractTileSourceLayer<? extends AbstractTMSTileSource> abstractTileSourceLayer, List<LatLon> list) {
            super(I18n.tr("Precaching WMS", new Object[0]));
            this.layer = abstractTileSourceLayer;
            this.points = list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void realRun() throws SAXException, IOException, OsmTransferException {
            this.precacheTask = this.layer.downloadAreaToCache(this.progressMonitor, this.points, 0.0, 0.0);
            while (!this.precacheTask.isFinished() && !this.progressMonitor.isCanceled()) {
                PrecacheWmsTask precacheWmsTask = this;
                synchronized (precacheWmsTask) {
                    try {
                        this.wait(200L);
                    }
                    catch (InterruptedException interruptedException) {
                        Main.warn("InterruptedException in " + this.getClass().getSimpleName() + " while precaching WMS");
                    }
                }
            }
        }

        @Override
        protected void finish() {
        }

        @Override
        protected void cancel() {
            this.precacheTask.cancel();
        }

        @Override
        public ProgressTaskId canRunInBackground() {
            return ProgressTaskIds.PRECACHE_WMS;
        }
    }
}

