/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ActionMapUIResource;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class QuadStateCheckBox
extends JCheckBox {
    private final transient QuadStateDecorator model;
    private State[] allowed;

    public QuadStateCheckBox(String string, Icon icon, State state, State[] stateArray) {
        super(string, icon);
        this.allowed = Utils.copyArray(stateArray);
        super.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                QuadStateCheckBox.this.grabFocus();
                QuadStateCheckBox.this.model.nextState();
            }
        });
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("pressed", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                QuadStateCheckBox.this.grabFocus();
                QuadStateCheckBox.this.model.nextState();
            }
        });
        actionMapUIResource.put("released", null);
        SwingUtilities.replaceUIActionMap(this, actionMapUIResource);
        this.model = new QuadStateDecorator(this.getModel());
        this.setModel(this.model);
        this.setState(state);
    }

    public QuadStateCheckBox(String string, State state, State[] stateArray) {
        this(string, null, state, stateArray);
    }

    @Override
    public void addMouseListener(MouseListener mouseListener) {
    }

    public final void setPropertyText(String string) {
        this.model.setPropertyText(string);
    }

    public final void setState(State state) {
        this.model.setState(state);
    }

    public State getState() {
        return this.model.getState();
    }

    @Override
    public void setSelected(boolean bl) {
        if (bl) {
            this.setState(State.SELECTED);
        } else {
            this.setState(State.NOT_SELECTED);
        }
    }

    private final class QuadStateDecorator
    implements ButtonModel {
        private final ButtonModel other;
        private String propertyText;

        private QuadStateDecorator(ButtonModel buttonModel) {
            this.other = buttonModel;
        }

        private void setState(State state) {
            if (state == State.NOT_SELECTED) {
                this.other.setArmed(false);
                this.other.setPressed(false);
                this.other.setSelected(false);
                QuadStateCheckBox.this.setToolTipText(this.propertyText == null ? I18n.tr("false: the property is explicitly switched off", new Object[0]) : I18n.tr("false: the property ''{0}'' is explicitly switched off", this.propertyText));
            } else if (state == State.SELECTED) {
                this.other.setArmed(false);
                this.other.setPressed(false);
                this.other.setSelected(true);
                QuadStateCheckBox.this.setToolTipText(this.propertyText == null ? I18n.tr("true: the property is explicitly switched on", new Object[0]) : I18n.tr("true: the property ''{0}'' is explicitly switched on", this.propertyText));
            } else if (state == State.PARTIAL) {
                this.other.setArmed(true);
                this.other.setPressed(true);
                this.other.setSelected(true);
                QuadStateCheckBox.this.setToolTipText(this.propertyText == null ? I18n.tr("partial: different selected objects have different values, do not change", new Object[0]) : I18n.tr("partial: different selected objects have different values for ''{0}'', do not change", this.propertyText));
            } else {
                this.other.setArmed(true);
                this.other.setPressed(true);
                this.other.setSelected(false);
                QuadStateCheckBox.this.setToolTipText(this.propertyText == null ? I18n.tr("unset: do not set this property on the selected objects", new Object[0]) : I18n.tr("unset: do not set the property ''{0}'' on the selected objects", this.propertyText));
            }
        }

        protected void setPropertyText(String string) {
            this.propertyText = string;
        }

        private State getState() {
            if (this.isSelected() && !this.isArmed()) {
                return State.SELECTED;
            }
            if (this.isSelected() && this.isArmed()) {
                return State.PARTIAL;
            }
            if (!this.isSelected() && !this.isArmed()) {
                return State.NOT_SELECTED;
            }
            return State.UNSET;
        }

        private void nextState() {
            State state = this.getState();
            for (int i = 0; i < QuadStateCheckBox.this.allowed.length; ++i) {
                if (QuadStateCheckBox.this.allowed[i] != state) continue;
                this.setState(i == QuadStateCheckBox.this.allowed.length - 1 ? QuadStateCheckBox.this.allowed[0] : QuadStateCheckBox.this.allowed[i + 1]);
                break;
            }
        }

        @Override
        public void setArmed(boolean bl) {
        }

        @Override
        public void setSelected(boolean bl) {
        }

        @Override
        public void setPressed(boolean bl) {
        }

        @Override
        public void setEnabled(boolean bl) {
            QuadStateCheckBox.this.setFocusable(bl);
            this.other.setEnabled(bl);
        }

        @Override
        public boolean isArmed() {
            return this.other.isArmed();
        }

        @Override
        public boolean isSelected() {
            return this.other.isSelected();
        }

        @Override
        public boolean isEnabled() {
            return this.other.isEnabled();
        }

        @Override
        public boolean isPressed() {
            return this.other.isPressed();
        }

        @Override
        public boolean isRollover() {
            return this.other.isRollover();
        }

        @Override
        public void setRollover(boolean bl) {
            this.other.setRollover(bl);
        }

        @Override
        public void setMnemonic(int n) {
            this.other.setMnemonic(n);
        }

        @Override
        public int getMnemonic() {
            return this.other.getMnemonic();
        }

        @Override
        public void setActionCommand(String string) {
            this.other.setActionCommand(string);
        }

        @Override
        public String getActionCommand() {
            return this.other.getActionCommand();
        }

        @Override
        public void setGroup(ButtonGroup buttonGroup) {
            this.other.setGroup(buttonGroup);
        }

        @Override
        public void addActionListener(ActionListener actionListener) {
            this.other.addActionListener(actionListener);
        }

        @Override
        public void removeActionListener(ActionListener actionListener) {
            this.other.removeActionListener(actionListener);
        }

        @Override
        public void addItemListener(ItemListener itemListener) {
            this.other.addItemListener(itemListener);
        }

        @Override
        public void removeItemListener(ItemListener itemListener) {
            this.other.removeItemListener(itemListener);
        }

        @Override
        public void addChangeListener(ChangeListener changeListener) {
            this.other.addChangeListener(changeListener);
        }

        @Override
        public void removeChangeListener(ChangeListener changeListener) {
            this.other.removeChangeListener(changeListener);
        }

        @Override
        public Object[] getSelectedObjects() {
            return this.other.getSelectedObjects();
        }
    }

    public static enum State {
        NOT_SELECTED,
        SELECTED,
        UNSET,
        PARTIAL;

    }
}

