/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.PlatformHook;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;

public class PlatformHookUnixoid
implements PlatformHook {
    private String osDescription;

    @Override
    public void preStartupHook() {
        if ("org.GNOME.Accessibility.AtkWrapper".equals(System.getProperty("assistive_technologies"))) {
            System.clearProperty("assistive_technologies");
        }
    }

    @Override
    public void afterPrefStartupHook() {
    }

    @Override
    public void startupHook() {
    }

    @Override
    public void openUrl(String string) throws IOException {
        for (String string2 : Main.pref.getCollection("browser.unix", Arrays.asList("xdg-open", "#DESKTOP#", "$BROWSER", "gnome-open", "kfmclient openURL", "firefox"))) {
            try {
                if ("#DESKTOP#".equals(string2)) {
                    Desktop.getDesktop().browse(new URI(string));
                } else if (string2.startsWith("$")) {
                    string2 = System.getenv().get(string2.substring(1));
                    Runtime.getRuntime().exec(new String[]{string2, string});
                } else {
                    Runtime.getRuntime().exec(new String[]{string2, string});
                }
                return;
            }
            catch (IOException | URISyntaxException exception) {
                Main.warn(exception);
            }
        }
    }

    @Override
    public void initSystemShortcuts() {
        for (int i = 112; i <= 123; ++i) {
            Shortcut.registerSystemShortcut("screen:toogle" + i, I18n.tr("reserved", new Object[0]), i, 640).setAutomatic();
        }
        Shortcut.registerSystemShortcut("system:reset", I18n.tr("reserved", new Object[0]), 127, 640).setAutomatic();
        Shortcut.registerSystemShortcut("system:resetX", I18n.tr("reserved", new Object[0]), 8, 640).setAutomatic();
    }

    @Override
    public String makeTooltip(String string, Shortcut shortcut) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>").append(string);
        if (shortcut != null && !shortcut.getKeyText().isEmpty()) {
            stringBuilder.append(' ').append("<font size='-2'>").append('(').append(shortcut.getKeyText()).append(')').append("</font>");
        }
        return stringBuilder.append("&nbsp;</html>").toString();
    }

    @Override
    public String getDefaultStyle() {
        return "javax.swing.plaf.metal.MetalLookAndFeel";
    }

    @Override
    public boolean canFullscreen() {
        return !GraphicsEnvironment.isHeadless() && GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().isFullScreenSupported();
    }

    @Override
    public boolean rename(File file, File file2) {
        return file.renameTo(file2);
    }

    public static boolean isOpenJDK() {
        String string = System.getProperty("java.home");
        return string != null && string.contains("openjdk");
    }

    public static String getPackageDetails(String ... stringArray) {
        try {
            boolean bl = Files.exists(Paths.get("/usr/bin/dpkg-query", new String[0]), new LinkOption[0]);
            boolean bl2 = Files.exists(Paths.get("/usr/bin/equery", new String[0]), new LinkOption[0]);
            boolean bl3 = Files.exists(Paths.get("/bin/rpm", new String[0]), new LinkOption[0]);
            if (bl || bl3 || bl2) {
                for (String string : stringArray) {
                    String[] stringArray2 = null;
                    stringArray2 = bl ? new String[]{"dpkg-query", "--show", "--showformat", "${Architecture}-${Version}", string} : (bl2 ? new String[]{"equery", "-q", "list", "-e", "--format=$fullversion", string} : new String[]{"rpm", "-q", "--qf", "%{arch}-%{version}", string});
                    String string2 = Utils.execOutput(Arrays.asList(stringArray2));
                    if (string2 == null || string2.contains("not installed")) continue;
                    return string + ':' + string2;
                }
            }
        }
        catch (IOException iOException) {
            Main.warn(iOException);
        }
        return null;
    }

    public String getJavaPackageDetails() {
        String string = System.getProperty("java.home");
        if (string.contains("java-7-openjdk") || string.contains("java-1.7.0-openjdk")) {
            return PlatformHookUnixoid.getPackageDetails("openjdk-7-jre", "java-1_7_0-openjdk", "java-1.7.0-openjdk");
        }
        if (string.contains("icedtea")) {
            return PlatformHookUnixoid.getPackageDetails("icedtea-bin");
        }
        if (string.contains("oracle")) {
            return PlatformHookUnixoid.getPackageDetails("oracle-jdk-bin", "oracle-jre-bin");
        }
        return null;
    }

    public String getWebStartPackageDetails() {
        if (PlatformHookUnixoid.isOpenJDK()) {
            return PlatformHookUnixoid.getPackageDetails("icedtea-netx", "icedtea-web");
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String buildOSDescription() {
        String string = System.getProperty("os.name");
        if (!"Linux".equalsIgnoreCase(string)) return string;
        try {
            Process process = Runtime.getRuntime().exec("lsb_release -ds");
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));){
                String string2 = Utils.strip(bufferedReader.readLine());
                if (string2 == null) return string;
                if (string2.isEmpty()) return string;
                string2 = string2.replaceAll("\"+", "");
                if ((string2 = string2.replaceAll("NAME=", "")).startsWith("Linux ")) {
                    String string3 = string2;
                    return string3;
                }
                if (string2.isEmpty()) return string;
                String string4 = "Linux " + string2;
                return string4;
            }
        }
        catch (IOException iOException) {
            LinuxReleaseInfo[] linuxReleaseInfoArray = new LinuxReleaseInfo[]{new LinuxReleaseInfo("/etc/lsb-release", "DISTRIB_DESCRIPTION", "DISTRIB_ID", "DISTRIB_RELEASE"), new LinuxReleaseInfo("/etc/os-release", "PRETTY_NAME", "NAME", "VERSION"), new LinuxReleaseInfo("/etc/arch-release"), new LinuxReleaseInfo("/etc/debian_version", "Debian GNU/Linux "), new LinuxReleaseInfo("/etc/fedora-release"), new LinuxReleaseInfo("/etc/gentoo-release"), new LinuxReleaseInfo("/etc/redhat-release"), new LinuxReleaseInfo("/etc/SuSE-release")};
            int n = linuxReleaseInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                LinuxReleaseInfo linuxReleaseInfo = linuxReleaseInfoArray[n2];
                String string5 = linuxReleaseInfo.extractDescription();
                if (string5 != null && !string5.isEmpty()) {
                    return "Linux " + string5;
                }
                ++n2;
            }
            return string;
        }
    }

    @Override
    public String getOSDescription() {
        if (this.osDescription == null) {
            this.osDescription = this.buildOSDescription();
        }
        return this.osDescription;
    }

    protected void askUpdateJava(String string) {
        if (!GraphicsEnvironment.isHeadless()) {
            this.askUpdateJava(string, "https://www.java.com/download");
        }
    }

    protected void askUpdateJava(final String string, final String string2) {
        GuiHelper.runInEDTAndWait(new Runnable(){

            @Override
            public void run() {
                ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, I18n.tr("Outdated Java version", new Object[0]), new String[]{I18n.tr("OK", new Object[0]), I18n.tr("Update Java", new Object[0]), I18n.tr("Cancel", new Object[0])});
                if (!extendedDialog.toggleEnable("askUpdateJava8").toggleCheckState()) {
                    extendedDialog.setButtonIcons(new String[]{"ok", "java", "cancel"}).setCancelButton(3);
                    extendedDialog.setMinimumSize(new Dimension(480, 300));
                    extendedDialog.setIcon(2);
                    StringBuilder stringBuilder = new StringBuilder(I18n.tr("You are running version {0} of Java.", "<b>" + string + "</b>")).append("<br><br>");
                    if ("Sun Microsystems Inc.".equals(System.getProperty("java.vendor")) && !PlatformHookUnixoid.isOpenJDK()) {
                        stringBuilder.append("<b>").append(I18n.tr("This version is no longer supported by {0} since {1} and is not recommended for use.", "Oracle", I18n.tr("April 2015", new Object[0]))).append("</b><br><br>");
                    }
                    stringBuilder.append("<b>").append(I18n.tr("JOSM will soon stop working with this version; we highly recommend you to update to Java {0}.", "8")).append("</b><br><br>").append(I18n.tr("Would you like to update now ?", new Object[0]));
                    extendedDialog.setContent(stringBuilder.toString());
                    if (extendedDialog.showDialog().getValue() == 2) {
                        try {
                            PlatformHookUnixoid.this.openUrl(string2);
                        }
                        catch (IOException iOException) {
                            Main.warn(iOException);
                        }
                    }
                }
            }
        });
    }

    @Override
    public boolean setupHttpsCertificate(String string, KeyStore.TrustedCertificateEntry trustedCertificateEntry) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        return false;
    }

    @Override
    public File getDefaultCacheDirectory() {
        return new File(Main.pref.getUserDataDirectory(), "cache");
    }

    @Override
    public File getDefaultPrefDirectory() {
        return new File(System.getProperty("user.home"), ".josm");
    }

    @Override
    public File getDefaultUserDataDirectory() {
        return Main.pref.getPreferencesDirectory();
    }

    protected void extendFontconfig(String string) {
        String string2 = Main.pref.get("fontconfig.properties", null);
        if (string2 != null) {
            Utils.updateSystemProperty("sun.awt.fontconfig", string2);
            return;
        }
        if (!Main.pref.getBoolean("font.extended-unicode", true)) {
            return;
        }
        String string3 = System.getProperty("java.home") + File.separator + "lib";
        Path path = FileSystems.getDefault().getPath(string3, string);
        if (!Files.isReadable(path)) {
            Main.warn("extended font config - unable to find font config template file " + path.toString());
            return;
        }
        try (FileInputStream fileInputStream = new FileInputStream(path.toFile());){
            Properties properties = new Properties();
            properties.load(fileInputStream);
            byte[] byArray = Files.readAllBytes(path);
            File file = Main.pref.getCacheDirectory();
            Path path2 = file.toPath().resolve("fontconfig.properties");
            OutputStream outputStream = Files.newOutputStream(path2, new OpenOption[0]);
            outputStream.write(byArray);
            try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8));){
                String string4;
                String string5;
                Collection<String> collection;
                List<FontEntry> list = Main.pref.getListOfStructs("font.extended-unicode.extra-items", this.getAdditionalFonts(), FontEntry.class);
                ArrayList<FontEntry> arrayList = new ArrayList<FontEntry>();
                bufferedWriter.append("\n\n# Added by JOSM to extend unicode coverage of Java font support:\n\n");
                ArrayList<String> arrayList2 = new ArrayList<String>();
                for (FontEntry fontEntry : list) {
                    collection = this.getInstalledFonts();
                    if (collection != null && collection.contains(fontEntry.file.toUpperCase(Locale.ENGLISH))) {
                        if (!arrayList2.contains(fontEntry.charset)) {
                            arrayList2.add(fontEntry.charset);
                            arrayList.add(fontEntry);
                            continue;
                        }
                        Main.trace("extended font config - already registered font for charset ''{0}'' - skipping ''{1}''", fontEntry.charset, fontEntry.name);
                        continue;
                    }
                    Main.trace("extended font config - Font ''{0}'' not found on system - skipping", fontEntry.name);
                }
                for (FontEntry fontEntry : arrayList) {
                    arrayList2.add(fontEntry.charset);
                    if ("".equals(fontEntry.name)) continue;
                    collection = "allfonts." + fontEntry.charset;
                    string5 = fontEntry.name;
                    string4 = properties.getProperty((String)((Object)collection));
                    if (string4 != null && !string4.equals(string5)) {
                        Main.warn("extended font config - overriding ''{0}={1}'' with ''{2}''", collection, string4, string5);
                    }
                    bufferedWriter.append((String)((Object)collection) + '=' + string5 + '\n');
                }
                bufferedWriter.append('\n');
                for (FontEntry fontEntry : arrayList) {
                    if ("".equals(fontEntry.name) || "".equals(fontEntry.file)) continue;
                    collection = "filename." + fontEntry.name.replace(' ', '_');
                    string5 = fontEntry.file;
                    string4 = properties.getProperty((String)((Object)collection));
                    if (string4 != null && !string4.equals(string5)) {
                        Main.warn("extended font config - overriding ''{0}={1}'' with ''{2}''", collection, string4, string5);
                    }
                    bufferedWriter.append((String)((Object)collection) + '=' + string5 + '\n');
                }
                bufferedWriter.append('\n');
                String string6 = properties.getProperty("sequence.fallback");
                if (string6 != null) {
                    bufferedWriter.append("sequence.fallback=" + (String)string6 + ',' + Utils.join(",", arrayList2) + '\n');
                } else {
                    bufferedWriter.append("sequence.fallback=" + Utils.join(",", arrayList2) + '\n');
                }
            }
            Utils.updateSystemProperty("sun.awt.fontconfig", path2.toString());
        }
        catch (IOException iOException) {
            Main.error(iOException);
        }
    }

    public Collection<String> getInstalledFonts() {
        throw new UnsupportedOperationException();
    }

    public Collection<FontEntry> getAdditionalFonts() {
        throw new UnsupportedOperationException();
    }

    protected static class LinuxReleaseInfo {
        private final String path;
        private final String descriptionField;
        private final String idField;
        private final String releaseField;
        private final boolean plainText;
        private final String prefix;

        public LinuxReleaseInfo(String string, String string2, String string3, String string4) {
            this(string, string2, string3, string4, false, null);
        }

        public LinuxReleaseInfo(String string) {
            this(string, null, null, null, true, null);
        }

        public LinuxReleaseInfo(String string, String string2) {
            this(string, null, null, null, true, string2);
        }

        private LinuxReleaseInfo(String string, String string2, String string3, String string4, boolean bl, String string5) {
            this.path = string;
            this.descriptionField = string2;
            this.idField = string3;
            this.releaseField = string4;
            this.plainText = bl;
            this.prefix = string5;
        }

        public String toString() {
            return "ReleaseInfo [path=" + this.path + ", descriptionField=" + this.descriptionField + ", idField=" + this.idField + ", releaseField=" + this.releaseField + ']';
        }

        public String extractDescription() {
            String string;
            block22: {
                Path path;
                string = null;
                if (this.path != null && Files.exists(path = Paths.get(this.path, new String[0]), new LinkOption[0])) {
                    try (BufferedReader bufferedReader = Files.newBufferedReader(path, StandardCharsets.UTF_8);){
                        String string2;
                        String string3 = null;
                        String string4 = null;
                        while (string == null && (string2 = bufferedReader.readLine()) != null) {
                            if (string2.contains("=")) {
                                String[] stringArray = string2.split("=");
                                if (stringArray.length < 2) continue;
                                if (this.descriptionField != null && this.descriptionField.equalsIgnoreCase(stringArray[0])) {
                                    string = Utils.strip(stringArray[1]);
                                    continue;
                                }
                                if (this.idField != null && this.idField.equalsIgnoreCase(stringArray[0])) {
                                    string3 = Utils.strip(stringArray[1]);
                                    continue;
                                }
                                if (this.releaseField == null || !this.releaseField.equalsIgnoreCase(stringArray[0])) continue;
                                string4 = Utils.strip(stringArray[1]);
                                continue;
                            }
                            if (!this.plainText || string2.isEmpty()) continue;
                            string = Utils.strip(string2);
                        }
                        if (string == null && string3 != null && string4 != null) {
                            string = string3 + ' ' + string4;
                        }
                    }
                    catch (IOException iOException) {
                        if (!Main.isTraceEnabled()) break block22;
                        Main.trace(iOException.getMessage());
                    }
                }
            }
            if (string != null && !string.isEmpty() && this.prefix != null && !this.prefix.isEmpty()) {
                string = this.prefix + string;
            }
            if (string != null) {
                string = string.replaceAll("\"+", "");
            }
            return string;
        }
    }

    public static class FontEntry {
        @Preferences.pref
        public String charset;
        @Preferences.pref
        @Preferences.writeExplicitly
        public String name = "";
        @Preferences.pref
        @Preferences.writeExplicitly
        public String file = "";

        public FontEntry() {
        }

        public FontEntry(String string, String string2, String string3) {
            this.charset = string;
            this.name = string2;
            this.file = string3;
        }
    }
}

