/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.spi.FileTypeDetector;
import java.util.Locale;
import java.util.regex.Pattern;

public final class RubyFiletypeDetector
extends FileTypeDetector {
    private static final String[] KNOWN_RUBY_FILES = new String[]{"Gemfile", "Rakefile", "Mavenfile"};
    private static final String[] KNOWN_RUBY_SUFFIXES = new String[]{".rb", ".rake", ".gemspec"};
    private static final String RUBY_MIME = "application/x-ruby";
    private static final Pattern SHEBANG_REGEXP = Pattern.compile("^#! ?/usr/bin/(env +ruby|ruby).*");

    @Override
    public String probeContentType(Path path2) throws IOException {
        Path fileNamePath = path2.getFileName();
        if (fileNamePath == null) {
            return null;
        }
        String fileName = fileNamePath.toString();
        String lowerCaseFileName = fileName.toLowerCase(Locale.ROOT);
        for (String candidate : KNOWN_RUBY_SUFFIXES) {
            if (!lowerCaseFileName.endsWith(candidate)) continue;
            return RUBY_MIME;
        }
        for (String candidate : KNOWN_RUBY_FILES) {
            if (!fileName.equals(candidate)) continue;
            return RUBY_MIME;
        }
        try (BufferedReader fileContent = Files.newBufferedReader(path2, StandardCharsets.UTF_8);){
            String firstLine = fileContent.readLine();
            if (firstLine != null && SHEBANG_REGEXP.matcher(firstLine).matches()) {
                String string2 = RUBY_MIME;
                return string2;
            }
        }
        return null;
    }
}

