/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.impl;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.debug.Debugger;
import com.oracle.truffle.api.debug.SuspendedEvent;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.instrument.Instrumenter;
import com.oracle.truffle.api.instrument.Probe;
import com.oracle.truffle.api.instrument.Visualizer;
import com.oracle.truffle.api.instrument.WrapperNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.Source;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Map;

public abstract class Accessor {
    private static Accessor API;
    private static Accessor SPI;
    private static Accessor NODES;
    private static Accessor INSTRUMENT;
    private static Accessor DEBUG;
    private static final ThreadLocal<Object> CURRENT_VM;
    private static Reference<Object> previousVM;
    private static Assumption oneVM;

    protected Accessor() {
        if (this.getClass().getSimpleName().endsWith("API")) {
            if (API != null) {
                throw new IllegalStateException();
            }
            API = this;
        } else if (this.getClass().getSimpleName().endsWith("Nodes")) {
            if (NODES != null) {
                throw new IllegalStateException();
            }
            NODES = this;
        } else if (this.getClass().getSimpleName().endsWith("Instrument")) {
            if (INSTRUMENT != null) {
                throw new IllegalStateException();
            }
            INSTRUMENT = this;
        } else if (this.getClass().getSimpleName().endsWith("Debug")) {
            if (DEBUG != null) {
                throw new IllegalStateException();
            }
            DEBUG = this;
        } else {
            if (SPI != null) {
                throw new IllegalStateException();
            }
            SPI = this;
        }
    }

    protected TruffleLanguage.Env attachEnv(Object vm, TruffleLanguage<?> language, OutputStream stdOut, OutputStream stdErr, InputStream stdIn, Instrumenter instrumenter) {
        return API.attachEnv(vm, language, stdOut, stdErr, stdIn, instrumenter);
    }

    protected Object eval(TruffleLanguage<?> l, Source s, Map<Source, CallTarget> cache) throws IOException {
        return API.eval(l, s, cache);
    }

    protected Object evalInContext(Object vm, SuspendedEvent ev, String code, Node node, MaterializedFrame frame) throws IOException {
        return API.evalInContext(vm, ev, code, node, frame);
    }

    protected Object importSymbol(Object vm, TruffleLanguage<?> queryingLang, String globalName) {
        return SPI.importSymbol(vm, queryingLang, globalName);
    }

    protected Object findExportedSymbol(TruffleLanguage.Env env, String globalName, boolean onlyExplicit) {
        return API.findExportedSymbol(env, globalName, onlyExplicit);
    }

    protected Object languageGlobal(TruffleLanguage.Env env) {
        return API.languageGlobal(env);
    }

    protected boolean isInstrumentable(Object vm, Node node) {
        RootNode rootNode = node.getRootNode();
        Class<? extends TruffleLanguage> languageClazz = this.findLanguage(rootNode);
        TruffleLanguage<?> language = this.findLanguageImpl(vm, languageClazz, null);
        return this.isInstrumentable(node, language);
    }

    protected boolean isInstrumentable(Node node, TruffleLanguage<?> language) {
        return API.isInstrumentable(node, language);
    }

    protected WrapperNode createWrapperNode(Object vm, Node node) {
        RootNode rootNode = node.getRootNode();
        Class<? extends TruffleLanguage> languageClazz = this.findLanguage(rootNode);
        TruffleLanguage<?> language = this.findLanguageImpl(vm, languageClazz, null);
        return this.createWrapperNode(node, language);
    }

    protected WrapperNode createWrapperNode(Node node, TruffleLanguage<?> language) {
        return API.createWrapperNode(node, language);
    }

    protected Class<? extends TruffleLanguage> findLanguage(RootNode n) {
        return NODES.findLanguage(n);
    }

    protected Class<? extends TruffleLanguage> findLanguage(Probe probe) {
        return INSTRUMENT.findLanguage(probe);
    }

    protected TruffleLanguage.Env findLanguage(Object known, Class<? extends TruffleLanguage> languageClass) {
        Object vm;
        if (known == null) {
            vm = CURRENT_VM.get();
            if (vm == null) {
                throw new IllegalStateException("Accessor.findLanguage access to vm");
            }
            if (languageClass == null) {
                return null;
            }
        } else {
            vm = known;
        }
        return SPI.findLanguage(vm, languageClass);
    }

    protected TruffleLanguage<?> findLanguageImpl(Object known, Class<? extends TruffleLanguage> languageClass, String mimeType) {
        Object vm;
        if (known == null) {
            vm = CURRENT_VM.get();
            if (vm == null) {
                throw new IllegalStateException("Accessor.findLanguageImpl access to vm");
            }
        } else {
            vm = known;
        }
        return SPI.findLanguageImpl(vm, languageClass, mimeType);
    }

    protected Instrumenter getInstrumenter(Object known) {
        Object vm;
        if (known == null) {
            vm = CURRENT_VM.get();
            if (vm == null) {
                return null;
            }
        } else {
            vm = known;
        }
        return SPI.getInstrumenter(vm);
    }

    protected Instrumenter createInstrumenter(Object vm) {
        return INSTRUMENT.createInstrumenter(vm);
    }

    protected Debugger createDebugger(Object vm, Instrumenter instrumenter) {
        return DEBUG.createDebugger(vm, instrumenter);
    }

    @CompilerDirectives.TruffleBoundary
    protected Closeable executionStart(Object vm, int currentDepth, Debugger debugger, Source s) {
        vm.getClass();
        final Object prev = CURRENT_VM.get();
        final Closeable debugClose = DEBUG.executionStart(vm, prev == null ? 0 : -1, debugger, s);
        if (vm != previousVM.get()) {
            previousVM = new WeakReference<Object>(vm);
            oneVM.invalidate();
            oneVM = Truffle.getRuntime().createAssumption();
        }
        CURRENT_VM.set(vm);
        class ContextCloseable
        implements Closeable {
            ContextCloseable() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void close() throws IOException {
                CURRENT_VM.set(prev);
                debugClose.close();
            }
        }
        return new ContextCloseable();
    }

    protected void dispatchEvent(Object vm, Object event) {
        SPI.dispatchEvent(vm, event);
    }

    static Assumption oneVMAssumption() {
        return oneVM;
    }

    static <C> C findContext(Class<? extends TruffleLanguage> type) {
        TruffleLanguage.Env env = SPI.findLanguage(CURRENT_VM.get(), type);
        return (C)API.findContext(env);
    }

    public static void main(String ... args) {
        throw new IllegalStateException();
    }

    protected Object findContext(TruffleLanguage.Env env) {
        return API.findContext(env);
    }

    protected void probeAST(RootNode rootNode) {
        INSTRUMENT.probeAST(rootNode);
    }

    protected void dispose(TruffleLanguage<?> impl, TruffleLanguage.Env env) {
        API.dispose(impl, env);
    }

    protected CallTarget parse(Class<? extends TruffleLanguage> languageClass, Source code, Node context, String ... argumentNames) throws IOException {
        TruffleLanguage<?> truffleLanguage = this.findLanguageImpl(null, languageClass, code.getMimeType());
        return this.parse(truffleLanguage, code, context, argumentNames);
    }

    protected TruffleLanguage<?> findLanguage(TruffleLanguage.Env env) {
        return API.findLanguage(env);
    }

    protected CallTarget parse(TruffleLanguage<?> truffleLanguage, Source code, Node context, String ... argumentNames) throws IOException {
        return API.parse(truffleLanguage, code, context, argumentNames);
    }

    protected String toString(TruffleLanguage<?> language, TruffleLanguage.Env env, Object obj) {
        return API.toString(language, env, obj);
    }

    static <T extends TruffleLanguage<?>> T findLanguageByClass(Object vm, Class<T> languageClass) {
        TruffleLanguage.Env env = API.findLanguage(vm, languageClass);
        TruffleLanguage<?> language = API.findLanguage(env);
        return (T)((TruffleLanguage)languageClass.cast(language));
    }

    static {
        CURRENT_VM = new ThreadLocal();
        TruffleLanguage<Object> lng = new TruffleLanguage<Object>(){

            @Override
            protected Object findExportedSymbol(Object context, String globalName, boolean onlyExplicit) {
                return null;
            }

            @Override
            protected Object getLanguageGlobal(Object context) {
                return null;
            }

            @Override
            protected boolean isObjectOfLanguage(Object object) {
                return false;
            }

            @Override
            protected CallTarget parse(Source code, Node context, String ... argumentNames) throws IOException {
                throw new IOException();
            }

            @Override
            protected Object createContext(TruffleLanguage.Env env) {
                return null;
            }

            @Override
            protected boolean isInstrumentable(Node node) {
                return false;
            }

            @Override
            protected WrapperNode createWrapperNode(Node node) {
                return null;
            }

            @Override
            protected Visualizer getVisualizer() {
                return null;
            }

            @Override
            protected Object evalInContext(Source source, Node node, MaterializedFrame mFrame) throws IOException {
                return null;
            }
        };
        lng.hashCode();
        new Node(null){}.getRootNode();
        try {
            Class.forName(Instrumenter.class.getName(), true, Instrumenter.class.getClassLoader());
            Class.forName(Debugger.class.getName(), true, Debugger.class.getClassLoader());
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException(ex);
        }
        previousVM = new WeakReference<Object>(null);
        oneVM = Truffle.getRuntime().createAssumption();
    }
}

