/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.runtime.Visibility;
import org.jruby.truffle.nodes.RubyRootNode;
import org.jruby.truffle.nodes.methods.DeclarationContext;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.RubyLanguage;
import org.jruby.truffle.runtime.methods.InternalMethod;
import org.jruby.truffle.runtime.subsystems.AttachmentsManager;
import org.jruby.truffle.translator.TranslatorDriver;

public class LazyRubyRootNode
extends RootNode {
    private final Source source;
    private final String[] argumentNames;
    @CompilerDirectives.CompilationFinal
    private RubyContext cachedContext;
    @CompilerDirectives.CompilationFinal
    private DynamicObject mainObject;
    @CompilerDirectives.CompilationFinal
    private InternalMethod method;
    @Node.Child
    private Node findContextNode;
    @Node.Child
    private DirectCallNode callNode;

    public LazyRubyRootNode(SourceSection sourceSection, FrameDescriptor frameDescriptor, Source source, String[] argumentNames) {
        super(RubyLanguage.class, sourceSection, frameDescriptor);
        this.source = source;
        this.argumentNames = argumentNames;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        if (this.findContextNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.findContextNode = this.insert(RubyLanguage.INSTANCE.unprotectedCreateFindContextNode());
        }
        RubyContext context = RubyLanguage.INSTANCE.unprotectedFindContext(this.findContextNode);
        if (this.cachedContext == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.cachedContext = context;
        }
        if (this.callNode == null || context != this.cachedContext) {
            CompilerDirectives.transferToInterpreter();
            if (AttachmentsManager.ATTACHMENT_SOURCE == this.source) {
                SourceSection sourceSection = (SourceSection)frame.getArguments()[this.getIndex("section")];
                DynamicObject block = (DynamicObject)frame.getArguments()[this.getIndex("block")];
                AttachmentsManager.AttachmentRootNode rootNode = new AttachmentsManager.AttachmentRootNode(RubyLanguage.class, this.cachedContext, sourceSection, null, block);
                RootCallTarget callTarget = Truffle.getRuntime().createCallTarget(rootNode);
                this.callNode = this.insert(Truffle.getRuntime().createDirectCallNode(callTarget));
                this.callNode.forceInlining();
            } else {
                TranslatorDriver translator = new TranslatorDriver(context);
                RubyRootNode rootNode = translator.parse(context, this.source, (Encoding)UTF8Encoding.INSTANCE, TranslatorDriver.ParserContext.TOP_LEVEL, this.argumentNames, null, true, null);
                RootCallTarget callTarget = Truffle.getRuntime().createCallTarget(rootNode);
                this.callNode = this.insert(Truffle.getRuntime().createDirectCallNode(callTarget));
                this.callNode.forceInlining();
                this.mainObject = context.getCoreLibrary().getMainObject();
                this.method = new InternalMethod(rootNode.getSharedMethodInfo(), rootNode.getSharedMethodInfo().getName(), context.getCoreLibrary().getObjectClass(), Visibility.PUBLIC, callTarget);
            }
        }
        if (this.method == null) {
            MaterializedFrame callerFrame = Truffle.getRuntime().getCallerFrame().getFrame(FrameInstance.FrameAccess.MATERIALIZE, false).materialize();
            return this.callNode.call(frame, new Object[]{callerFrame});
        }
        return this.callNode.call(frame, RubyArguments.pack(null, null, this.method, DeclarationContext.TOP_LEVEL, null, this.mainObject, null, frame.getArguments()));
    }

    private int getIndex(String name) {
        for (int i = 0; i < this.argumentNames.length; ++i) {
            if (!name.equals(this.argumentNames[i])) continue;
            return i;
        }
        return -1;
    }
}

