/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.ValueProfile;
import java.util.Arrays;
import java.util.List;
import org.jruby.runtime.Visibility;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.core.ModuleNodes;
import org.jruby.truffle.nodes.methods.CanBindMethodToModuleNode;
import org.jruby.truffle.runtime.NotProvided;
import org.jruby.truffle.runtime.RubyContext;

@GeneratedBy(value=ModuleNodes.class)
public final class ModuleNodesFactory {
    public static List<NodeFactory<? extends CoreMethodNode>> getFactories() {
        return Arrays.asList(ContainsInstanceNodeFactory.getInstance(), IsSubclassOfNodeFactory.getInstance(), IsSubclassOfOrEqualToNodeFactory.getInstance(), IsSuperclassOfNodeFactory.getInstance(), IsSuperclassOfOrEqualToNodeFactory.getInstance(), CompareNodeFactory.getInstance(), AliasMethodNodeFactory.getInstance(), AncestorsNodeFactory.getInstance(), AppendFeaturesNodeFactory.getInstance(), AttrNodeFactory.getInstance(), AttrAccessorNodeFactory.getInstance(), AttrReaderNodeFactory.getInstance(), AttrWriterNodeFactory.getInstance(), AutoloadNodeFactory.getInstance(), AutoloadQueryNodeFactory.getInstance(), ClassEvalNodeFactory.getInstance(), ClassExecNodeFactory.getInstance(), ClassVariableDefinedNodeFactory.getInstance(), ClassVariableGetNodeFactory.getInstance(), ClassVariableSetNodeFactory.getInstance(), ClassVariablesNodeFactory.getInstance(), ConstantsNodeFactory.getInstance(), ConstDefinedNodeFactory.getInstance(), ConstGetNodeFactory.getInstance(), ConstMissingNodeFactory.getInstance(), ConstSetNodeFactory.getInstance(), DefineMethodNodeFactory.getInstance(), ExtendObjectNodeFactory.getInstance(), InitializeNodeFactory.getInstance(), InitializeCopyNodeFactory.getInstance(), IncludedNodeFactory.getInstance(), IncludedModulesNodeFactory.getInstance(), MethodDefinedNodeFactory.getInstance(), ModuleFunctionNodeFactory.getInstance(), NameNodeFactory.getInstance(), NestingNodeFactory.getInstance(), PublicNodeFactory.getInstance(), PublicClassMethodNodeFactory.getInstance(), PrivateNodeFactory.getInstance(), PrependFeaturesNodeFactory.getInstance(), PrivateClassMethodNodeFactory.getInstance(), PrivateMethodDefinedNodeFactory.getInstance(), ProtectedInstanceMethodsNodeFactory.getInstance(), ProtectedMethodDefinedNodeFactory.getInstance(), PrivateInstanceMethodsNodeFactory.getInstance(), PublicInstanceMethodNodeFactory.getInstance(), PublicInstanceMethodsNodeFactory.getInstance(), PublicMethodDefinedNodeFactory.getInstance(), InstanceMethodsNodeFactory.getInstance(), InstanceMethodNodeFactory.getInstance(), PrivateConstantNodeFactory.getInstance(), PublicConstantNodeFactory.getInstance(), ProtectedNodeFactory.getInstance(), RemoveClassVariableNodeFactory.getInstance(), RemoveConstNodeFactory.getInstance(), RemoveMethodNodeFactory.getInstance(), ToSNodeFactory.getInstance(), UndefMethodNodeFactory.getInstance(), AllocateNodeFactory.getInstance(), IsSingletonClassNodeFactory.getInstance());
    }

    @GeneratedBy(value=ModuleNodes.IsSingletonClassNode.class)
    public static final class IsSingletonClassNodeFactory
    extends NodeFactoryBase<ModuleNodes.IsSingletonClassNode> {
        private static IsSingletonClassNodeFactory isSingletonClassNodeFactoryInstance;

        private IsSingletonClassNodeFactory() {
            super(ModuleNodes.IsSingletonClassNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ModuleNodes.IsSingletonClassNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return IsSingletonClassNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ModuleNodes.IsSingletonClassNode> getInstance() {
            if (isSingletonClassNodeFactoryInstance == null) {
                isSingletonClassNodeFactoryInstance = new IsSingletonClassNodeFactory();
            }
            return isSingletonClassNodeFactoryInstance;
        }

        public static ModuleNodes.IsSingletonClassNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new IsSingletonClassNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ModuleNodes.IsSingletonClassNode.class)
        public static final class IsSingletonClassNodeGen
        extends ModuleNodes.IsSingletonClassNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private BaseNode_ specialization_;

            private IsSingletonClassNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="doClass(DynamicObject)", value=ModuleNodes.IsSingletonClassNode.class)
            private static final class ClassNode_
            extends BaseNode_ {
                ClassNode_(IsSingletonClassNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isRubyClass(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.doClass(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(IsSingletonClassNodeGen root) {
                    return new ClassNode_(root);
                }
            }

            @GeneratedBy(methodName="doModule(DynamicObject)", value=ModuleNodes.IsSingletonClassNode.class)
            private static final class ModuleNode_
            extends BaseNode_ {
                ModuleNode_(IsSingletonClassNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && !RubyGuards.isRubyClass(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.doModule(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(IsSingletonClassNodeGen root) {
                    return new ModuleNode_(root);
                }
            }

            @GeneratedBy(value=ModuleNodes.IsSingletonClassNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(IsSingletonClassNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(IsSingletonClassNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ModuleNodes.IsSingletonClassNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(IsSingletonClassNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(IsSingletonClassNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ModuleNodes.IsSingletonClassNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected IsSingletonClassNodeGen root;

                BaseNode_(IsSingletonClassNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (IsSingletonClassNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (!RubyGuards.isRubyClass(arguments0Value_)) {
                            return ModuleNode_.create(this.root);
                        }
                        if (RubyGuards.isRubyClass(arguments0Value_)) {
                            return ClassNode_.create(this.root);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.AllocateNode.class)
    public static final class AllocateNodeFactory
    extends NodeFactoryBase<ModuleNodes.AllocateNode> {
        private static AllocateNodeFactory allocateNodeFactoryInstance;

        private AllocateNodeFactory() {
            super(ModuleNodes.AllocateNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ModuleNodes.AllocateNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return AllocateNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ModuleNodes.AllocateNode> getInstance() {
            if (allocateNodeFactoryInstance == null) {
                allocateNodeFactoryInstance = new AllocateNodeFactory();
            }
            return allocateNodeFactoryInstance;
        }

        public static ModuleNodes.AllocateNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new AllocateNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ModuleNodes.AllocateNode.class)
        public static final class AllocateNodeGen
        extends ModuleNodes.AllocateNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private AllocateNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.allocate(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_}, arguments0Value);
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.SetMethodVisibilityNode.class)
    public static final class SetMethodVisibilityNodeGen
    extends ModuleNodes.SetMethodVisibilityNode {
        @Node.Child
        private RubyNode module_;
        @Node.Child
        private RubyNode name_;
        @CompilerDirectives.CompilationFinal
        private boolean seenUnsupported0;

        private SetMethodVisibilityNodeGen(RubyContext context, SourceSection sourceSection, Visibility visibility, RubyNode module, RubyNode name) {
            super(context, sourceSection, visibility);
            this.module_ = module;
            this.name_ = name;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        @Override
        public DynamicObject executeSetMethodVisibility(VirtualFrame frameValue, DynamicObject moduleValue, Object nameValue) {
            return this.setMethodVisibility(frameValue, moduleValue, nameValue);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            DynamicObject moduleValue_;
            try {
                moduleValue_ = this.module_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object nameValue = this.name_.execute(frameValue);
                throw this.unsupported(ex.getResult(), nameValue);
            }
            Object nameValue_ = this.name_.execute(frameValue);
            return this.setMethodVisibility(frameValue, moduleValue_, nameValue_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private UnsupportedSpecializationException unsupported(Object moduleValue, Object nameValue) {
            if (!this.seenUnsupported0) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.seenUnsupported0 = true;
            }
            return new UnsupportedSpecializationException(this, new Node[]{this.module_, this.name_}, moduleValue, nameValue);
        }

        public static ModuleNodes.SetMethodVisibilityNode create(RubyContext context, SourceSection sourceSection, Visibility visibility, RubyNode module, RubyNode name) {
            return new SetMethodVisibilityNodeGen(context, sourceSection, visibility, module, name);
        }
    }

    @GeneratedBy(value=ModuleNodes.SetVisibilityNode.class)
    public static final class SetVisibilityNodeGen
    extends ModuleNodes.SetVisibilityNode {
        @Node.Child
        private RubyNode module_;
        @Node.Child
        private RubyNode names_;
        @CompilerDirectives.CompilationFinal
        private boolean seenUnsupported0;

        private SetVisibilityNodeGen(RubyContext context, SourceSection sourceSection, Visibility visibility, RubyNode module, RubyNode names) {
            super(context, sourceSection, visibility);
            this.module_ = module;
            this.names_ = names;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        @Override
        public DynamicObject executeSetVisibility(VirtualFrame frameValue, DynamicObject moduleValue, Object[] namesValue) {
            return this.setVisibility(frameValue, moduleValue, namesValue);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object[] namesValue_;
            DynamicObject moduleValue_;
            try {
                moduleValue_ = this.module_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object namesValue = this.names_.execute(frameValue);
                throw this.unsupported(ex.getResult(), namesValue);
            }
            try {
                namesValue_ = this.names_.executeObjectArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                throw this.unsupported(moduleValue_, ex.getResult());
            }
            return this.setVisibility(frameValue, moduleValue_, namesValue_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private UnsupportedSpecializationException unsupported(Object moduleValue, Object namesValue) {
            if (!this.seenUnsupported0) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.seenUnsupported0 = true;
            }
            return new UnsupportedSpecializationException(this, new Node[]{this.module_, this.names_}, moduleValue, namesValue);
        }

        public static ModuleNodes.SetVisibilityNode create(RubyContext context, SourceSection sourceSection, Visibility visibility, RubyNode module, RubyNode names) {
            return new SetVisibilityNodeGen(context, sourceSection, visibility, module, names);
        }
    }

    @GeneratedBy(value=ModuleNodes.UndefMethodNode.class)
    public static final class UndefMethodNodeFactory
    extends NodeFactoryBase<ModuleNodes.UndefMethodNode> {
        private static UndefMethodNodeFactory undefMethodNodeFactoryInstance;

        private UndefMethodNodeFactory() {
            super(ModuleNodes.UndefMethodNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ModuleNodes.UndefMethodNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return UndefMethodNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ModuleNodes.UndefMethodNode> getInstance() {
            if (undefMethodNodeFactoryInstance == null) {
                undefMethodNodeFactoryInstance = new UndefMethodNodeFactory();
            }
            return undefMethodNodeFactoryInstance;
        }

        public static ModuleNodes.UndefMethodNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new UndefMethodNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ModuleNodes.UndefMethodNode.class)
        public static final class UndefMethodNodeGen
        extends ModuleNodes.UndefMethodNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private UndefMethodNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object[] arguments1Value_;
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments1_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), arguments1Value);
                }
                try {
                    arguments1Value_ = this.arguments1_.executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(arguments0Value_, ex.getResult());
                }
                return this.undefMethods(frameValue, arguments0Value_, arguments1Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value, Object arguments1Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_, this.arguments1_}, arguments0Value, arguments1Value);
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.ToSNode.class)
    public static final class ToSNodeFactory
    extends NodeFactoryBase<ModuleNodes.ToSNode> {
        private static ToSNodeFactory toSNodeFactoryInstance;

        private ToSNodeFactory() {
            super(ModuleNodes.ToSNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ModuleNodes.ToSNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ToSNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ModuleNodes.ToSNode> getInstance() {
            if (toSNodeFactoryInstance == null) {
                toSNodeFactoryInstance = new ToSNodeFactory();
            }
            return toSNodeFactoryInstance;
        }

        public static ModuleNodes.ToSNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new ToSNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ModuleNodes.ToSNode.class)
        public static final class ToSNodeGen
        extends ModuleNodes.ToSNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private ToSNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.toS(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_}, arguments0Value);
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.RemoveMethodNode.class)
    public static final class RemoveMethodNodeFactory
    extends NodeFactoryBase<ModuleNodes.RemoveMethodNode> {
        private static RemoveMethodNodeFactory removeMethodNodeFactoryInstance;

        private RemoveMethodNodeFactory() {
            super(ModuleNodes.RemoveMethodNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ModuleNodes.RemoveMethodNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return RemoveMethodNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ModuleNodes.RemoveMethodNode> getInstance() {
            if (removeMethodNodeFactoryInstance == null) {
                removeMethodNodeFactoryInstance = new RemoveMethodNodeFactory();
            }
            return removeMethodNodeFactoryInstance;
        }

        public static ModuleNodes.RemoveMethodNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new RemoveMethodNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ModuleNodes.RemoveMethodNode.class)
        public static final class RemoveMethodNodeGen
        extends ModuleNodes.RemoveMethodNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private RemoveMethodNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object[] arguments1Value_;
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments1_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), arguments1Value);
                }
                try {
                    arguments1Value_ = this.arguments1_.executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(arguments0Value_, ex.getResult());
                }
                return this.removeMethods(frameValue, arguments0Value_, arguments1Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value, Object arguments1Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_, this.arguments1_}, arguments0Value, arguments1Value);
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.RemoveConstNode.class)
    public static final class RemoveConstNodeFactory
    extends NodeFactoryBase<ModuleNodes.RemoveConstNode> {
        private static RemoveConstNodeFactory removeConstNodeFactoryInstance;

        private RemoveConstNodeFactory() {
            super(ModuleNodes.RemoveConstNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class}});
        }

        @Override
        public ModuleNodes.RemoveConstNode createNode(Object ... arguments) {
            if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
                return RemoveConstNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode)arguments[2], (RubyNode)arguments[3]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ModuleNodes.RemoveConstNode> getInstance() {
            if (removeConstNodeFactoryInstance == null) {
                removeConstNodeFactoryInstance = new RemoveConstNodeFactory();
            }
            return removeConstNodeFactoryInstance;
        }

        public static ModuleNodes.RemoveConstNode create(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name) {
            return new RemoveConstNodeGen(context, sourceSection, module, name);
        }

        @GeneratedBy(value=ModuleNodes.RemoveConstNode.class)
        public static final class RemoveConstNodeGen
        extends ModuleNodes.RemoveConstNode {
            @Node.Child
            private RubyNode module_;
            @Node.Child
            private RubyNode name_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private RemoveConstNodeGen(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name) {
                super(context, sourceSection);
                this.module_ = module;
                this.name_ = this.coerceToString(name);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                String nameValue_;
                DynamicObject moduleValue_;
                try {
                    moduleValue_ = this.module_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object nameValue = this.name_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), nameValue);
                }
                try {
                    nameValue_ = RemoveConstNodeGen.expectString(this.name_.execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(moduleValue_, ex.getResult());
                }
                return this.removeConstant(moduleValue_, nameValue_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object moduleValue, Object nameValue) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.module_, this.name_}, moduleValue, nameValue);
            }

            private static String expectString(Object value) throws UnexpectedResultException {
                if (value instanceof String) {
                    return (String)value;
                }
                throw new UnexpectedResultException(value);
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.RemoveClassVariableNode.class)
    public static final class RemoveClassVariableNodeFactory
    extends NodeFactoryBase<ModuleNodes.RemoveClassVariableNode> {
        private static RemoveClassVariableNodeFactory removeClassVariableNodeFactoryInstance;

        private RemoveClassVariableNodeFactory() {
            super(ModuleNodes.RemoveClassVariableNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class}});
        }

        @Override
        public ModuleNodes.RemoveClassVariableNode createNode(Object ... arguments) {
            if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
                return RemoveClassVariableNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode)arguments[2], (RubyNode)arguments[3]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ModuleNodes.RemoveClassVariableNode> getInstance() {
            if (removeClassVariableNodeFactoryInstance == null) {
                removeClassVariableNodeFactoryInstance = new RemoveClassVariableNodeFactory();
            }
            return removeClassVariableNodeFactoryInstance;
        }

        public static ModuleNodes.RemoveClassVariableNode create(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name) {
            return new RemoveClassVariableNodeGen(context, sourceSection, module, name);
        }

        @GeneratedBy(value=ModuleNodes.RemoveClassVariableNode.class)
        public static final class RemoveClassVariableNodeGen
        extends ModuleNodes.RemoveClassVariableNode {
            @Node.Child
            private RubyNode module_;
            @Node.Child
            private RubyNode name_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private RemoveClassVariableNodeGen(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name) {
                super(context, sourceSection);
                this.module_ = module;
                this.name_ = this.coerceToString(name);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                String nameValue_;
                DynamicObject moduleValue_;
                try {
                    moduleValue_ = this.module_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object nameValue = this.name_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), nameValue);
                }
                try {
                    nameValue_ = RemoveClassVariableNodeGen.expectString(this.name_.execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(moduleValue_, ex.getResult());
                }
                return this.removeClassVariableString(moduleValue_, nameValue_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object moduleValue, Object nameValue) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.module_, this.name_}, moduleValue, nameValue);
            }

            private static String expectString(Object value) throws UnexpectedResultException {
                if (value instanceof String) {
                    return (String)value;
                }
                throw new UnexpectedResultException(value);
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.ProtectedNode.class)
    public static final class ProtectedNodeFactory
    extends NodeFactoryBase<ModuleNodes.ProtectedNode> {
        private static ProtectedNodeFactory protectedNodeFactoryInstance;

        private ProtectedNodeFactory() {
            super(ModuleNodes.ProtectedNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ModuleNodes.ProtectedNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ProtectedNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ModuleNodes.ProtectedNode> getInstance() {
            if (protectedNodeFactoryInstance == null) {
                protectedNodeFactoryInstance = new ProtectedNodeFactory();
            }
            return protectedNodeFactoryInstance;
        }

        public static ModuleNodes.ProtectedNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new ProtectedNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ModuleNodes.ProtectedNode.class)
        public static final class ProtectedNodeGen
        extends ModuleNodes.ProtectedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private ProtectedNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object[] arguments1Value_;
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments1_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), arguments1Value);
                }
                try {
                    arguments1Value_ = this.arguments1_.executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(arguments0Value_, ex.getResult());
                }
                return this.doProtected(frameValue, arguments0Value_, arguments1Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value, Object arguments1Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_, this.arguments1_}, arguments0Value, arguments1Value);
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.PublicConstantNode.class)
    public static final class PublicConstantNodeFactory
    extends NodeFactoryBase<ModuleNodes.PublicConstantNode> {
        private static PublicConstantNodeFactory publicConstantNodeFactoryInstance;

        private PublicConstantNodeFactory() {
            super(ModuleNodes.PublicConstantNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ModuleNodes.PublicConstantNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return PublicConstantNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ModuleNodes.PublicConstantNode> getInstance() {
            if (publicConstantNodeFactoryInstance == null) {
                publicConstantNodeFactoryInstance = new PublicConstantNodeFactory();
            }
            return publicConstantNodeFactoryInstance;
        }

        public static ModuleNodes.PublicConstantNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new PublicConstantNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ModuleNodes.PublicConstantNode.class)
        public static final class PublicConstantNodeGen
        extends ModuleNodes.PublicConstantNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private PublicConstantNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object[] arguments1Value_;
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments1_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), arguments1Value);
                }
                try {
                    arguments1Value_ = this.arguments1_.executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(arguments0Value_, ex.getResult());
                }
                return this.publicConstant(frameValue, arguments0Value_, arguments1Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value, Object arguments1Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_, this.arguments1_}, arguments0Value, arguments1Value);
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.PrivateConstantNode.class)
    public static final class PrivateConstantNodeFactory
    extends NodeFactoryBase<ModuleNodes.PrivateConstantNode> {
        private static PrivateConstantNodeFactory privateConstantNodeFactoryInstance;

        private PrivateConstantNodeFactory() {
            super(ModuleNodes.PrivateConstantNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ModuleNodes.PrivateConstantNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return PrivateConstantNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ModuleNodes.PrivateConstantNode> getInstance() {
            if (privateConstantNodeFactoryInstance == null) {
                privateConstantNodeFactoryInstance = new PrivateConstantNodeFactory();
            }
            return privateConstantNodeFactoryInstance;
        }

        public static ModuleNodes.PrivateConstantNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new PrivateConstantNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ModuleNodes.PrivateConstantNode.class)
        public static final class PrivateConstantNodeGen
        extends ModuleNodes.PrivateConstantNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private PrivateConstantNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object[] arguments1Value_;
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments1_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), arguments1Value);
                }
                try {
                    arguments1Value_ = this.arguments1_.executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(arguments0Value_, ex.getResult());
                }
                return this.privateConstant(frameValue, arguments0Value_, arguments1Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value, Object arguments1Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_, this.arguments1_}, arguments0Value, arguments1Value);
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.InstanceMethodNode.class)
    public static final class InstanceMethodNodeFactory
    extends NodeFactoryBase<ModuleNodes.InstanceMethodNode> {
        private static InstanceMethodNodeFactory instanceMethodNodeFactoryInstance;

        private InstanceMethodNodeFactory() {
            super(ModuleNodes.InstanceMethodNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class}});
        }

        @Override
        public ModuleNodes.InstanceMethodNode createNode(Object ... arguments) {
            if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
                return InstanceMethodNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode)arguments[2], (RubyNode)arguments[3]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ModuleNodes.InstanceMethodNode> getInstance() {
            if (instanceMethodNodeFactoryInstance == null) {
                instanceMethodNodeFactoryInstance = new InstanceMethodNodeFactory();
            }
            return instanceMethodNodeFactoryInstance;
        }

        public static ModuleNodes.InstanceMethodNode create(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name) {
            return new InstanceMethodNodeGen(context, sourceSection, module, name);
        }

        @GeneratedBy(value=ModuleNodes.InstanceMethodNode.class)
        public static final class InstanceMethodNodeGen
        extends ModuleNodes.InstanceMethodNode {
            @Node.Child
            private RubyNode module_;
            @Node.Child
            private RubyNode name_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private InstanceMethodNodeGen(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name) {
                super(context, sourceSection);
                this.module_ = module;
                this.name_ = this.coerceToString(name);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                String nameValue_;
                DynamicObject moduleValue_;
                try {
                    moduleValue_ = this.module_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object nameValue = this.name_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), nameValue);
                }
                try {
                    nameValue_ = InstanceMethodNodeGen.expectString(this.name_.execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(moduleValue_, ex.getResult());
                }
                return this.instanceMethod(moduleValue_, nameValue_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object moduleValue, Object nameValue) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.module_, this.name_}, moduleValue, nameValue);
            }

            private static String expectString(Object value) throws UnexpectedResultException {
                if (value instanceof String) {
                    return (String)value;
                }
                throw new UnexpectedResultException(value);
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.InstanceMethodsNode.class)
    public static final class InstanceMethodsNodeFactory
    extends NodeFactoryBase<ModuleNodes.InstanceMethodsNode> {
        private static InstanceMethodsNodeFactory instanceMethodsNodeFactoryInstance;

        private InstanceMethodsNodeFactory() {
            super(ModuleNodes.InstanceMethodsNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class}});
        }

        @Override
        public ModuleNodes.InstanceMethodsNode createNode(Object ... arguments) {
            if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
                return InstanceMethodsNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode)arguments[2], (RubyNode)arguments[3]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ModuleNodes.InstanceMethodsNode> getInstance() {
            if (instanceMethodsNodeFactoryInstance == null) {
                instanceMethodsNodeFactoryInstance = new InstanceMethodsNodeFactory();
            }
            return instanceMethodsNodeFactoryInstance;
        }

        public static ModuleNodes.InstanceMethodsNode create(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode includeAncestors) {
            return new InstanceMethodsNodeGen(context, sourceSection, module, includeAncestors);
        }

        @GeneratedBy(value=ModuleNodes.InstanceMethodsNode.class)
        public static final class InstanceMethodsNodeGen
        extends ModuleNodes.InstanceMethodsNode {
            @Node.Child
            private RubyNode module_;
            @Node.Child
            private RubyNode includeAncestors_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private InstanceMethodsNodeGen(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode includeAncestors) {
                super(context, sourceSection);
                this.module_ = module;
                this.includeAncestors_ = this.coerceToBoolean(includeAncestors);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeDynamicObject(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeDynamicObject(frameValue);
            }

            @Override
            public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
                boolean includeAncestorsValue_;
                DynamicObject moduleValue_;
                try {
                    moduleValue_ = this.module_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object includeAncestorsValue = this.includeAncestors_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), includeAncestorsValue);
                }
                try {
                    includeAncestorsValue_ = this.includeAncestors_.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(moduleValue_, ex.getResult());
                }
                return this.instanceMethods(moduleValue_, includeAncestorsValue_);
            }

            private UnsupportedSpecializationException unsupported(Object moduleValue, Object includeAncestorsValue) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.module_, this.includeAncestors_}, moduleValue, includeAncestorsValue);
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.PublicMethodDefinedNode.class)
    public static final class PublicMethodDefinedNodeFactory
    extends NodeFactoryBase<ModuleNodes.PublicMethodDefinedNode> {
        private static PublicMethodDefinedNodeFactory publicMethodDefinedNodeFactoryInstance;

        private PublicMethodDefinedNodeFactory() {
            super(ModuleNodes.PublicMethodDefinedNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class}});
        }

        @Override
        public ModuleNodes.PublicMethodDefinedNode createNode(Object ... arguments) {
            if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
                return PublicMethodDefinedNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode)arguments[2], (RubyNode)arguments[3]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ModuleNodes.PublicMethodDefinedNode> getInstance() {
            if (publicMethodDefinedNodeFactoryInstance == null) {
                publicMethodDefinedNodeFactoryInstance = new PublicMethodDefinedNodeFactory();
            }
            return publicMethodDefinedNodeFactoryInstance;
        }

        public static ModuleNodes.PublicMethodDefinedNode create(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name) {
            return new PublicMethodDefinedNodeGen(context, sourceSection, module, name);
        }

        @GeneratedBy(value=ModuleNodes.PublicMethodDefinedNode.class)
        public static final class PublicMethodDefinedNodeGen
        extends ModuleNodes.PublicMethodDefinedNode {
            @Node.Child
            private RubyNode module_;
            @Node.Child
            private RubyNode name_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private PublicMethodDefinedNodeGen(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name) {
                super(context, sourceSection);
                this.module_ = module;
                this.name_ = this.coerceToString(name);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeBoolean(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeBoolean(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                String nameValue_;
                DynamicObject moduleValue_;
                try {
                    moduleValue_ = this.module_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object nameValue = this.name_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), nameValue);
                }
                try {
                    nameValue_ = PublicMethodDefinedNodeGen.expectString(this.name_.execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(moduleValue_, ex.getResult());
                }
                return this.isPublicMethodDefined(moduleValue_, nameValue_);
            }

            private UnsupportedSpecializationException unsupported(Object moduleValue, Object nameValue) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.module_, this.name_}, moduleValue, nameValue);
            }

            private static String expectString(Object value) throws UnexpectedResultException {
                if (value instanceof String) {
                    return (String)value;
                }
                throw new UnexpectedResultException(value);
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.PublicInstanceMethodsNode.class)
    public static final class PublicInstanceMethodsNodeFactory
    extends NodeFactoryBase<ModuleNodes.PublicInstanceMethodsNode> {
        private static PublicInstanceMethodsNodeFactory publicInstanceMethodsNodeFactoryInstance;

        private PublicInstanceMethodsNodeFactory() {
            super(ModuleNodes.PublicInstanceMethodsNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class}});
        }

        @Override
        public ModuleNodes.PublicInstanceMethodsNode createNode(Object ... arguments) {
            if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
                return PublicInstanceMethodsNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode)arguments[2], (RubyNode)arguments[3]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ModuleNodes.PublicInstanceMethodsNode> getInstance() {
            if (publicInstanceMethodsNodeFactoryInstance == null) {
                publicInstanceMethodsNodeFactoryInstance = new PublicInstanceMethodsNodeFactory();
            }
            return publicInstanceMethodsNodeFactoryInstance;
        }

        public static ModuleNodes.PublicInstanceMethodsNode create(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode includeAncestors) {
            return new PublicInstanceMethodsNodeGen(context, sourceSection, module, includeAncestors);
        }

        @GeneratedBy(value=ModuleNodes.PublicInstanceMethodsNode.class)
        public static final class PublicInstanceMethodsNodeGen
        extends ModuleNodes.PublicInstanceMethodsNode {
            @Node.Child
            private RubyNode module_;
            @Node.Child
            private RubyNode includeAncestors_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private PublicInstanceMethodsNodeGen(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode includeAncestors) {
                super(context, sourceSection);
                this.module_ = module;
                this.includeAncestors_ = this.coerceToBoolean(includeAncestors);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeDynamicObject(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeDynamicObject(frameValue);
            }

            @Override
            public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
                boolean includeAncestorsValue_;
                DynamicObject moduleValue_;
                try {
                    moduleValue_ = this.module_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object includeAncestorsValue = this.includeAncestors_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), includeAncestorsValue);
                }
                try {
                    includeAncestorsValue_ = this.includeAncestors_.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(moduleValue_, ex.getResult());
                }
                return this.publicInstanceMethods(moduleValue_, includeAncestorsValue_);
            }

            private UnsupportedSpecializationException unsupported(Object moduleValue, Object includeAncestorsValue) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.module_, this.includeAncestors_}, moduleValue, includeAncestorsValue);
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.PublicInstanceMethodNode.class)
    public static final class PublicInstanceMethodNodeFactory
    extends NodeFactoryBase<ModuleNodes.PublicInstanceMethodNode> {
        private static PublicInstanceMethodNodeFactory publicInstanceMethodNodeFactoryInstance;

        private PublicInstanceMethodNodeFactory() {
            super(ModuleNodes.PublicInstanceMethodNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class}});
        }

        @Override
        public ModuleNodes.PublicInstanceMethodNode createNode(Object ... arguments) {
            if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
                return PublicInstanceMethodNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode)arguments[2], (RubyNode)arguments[3]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ModuleNodes.PublicInstanceMethodNode> getInstance() {
            if (publicInstanceMethodNodeFactoryInstance == null) {
                publicInstanceMethodNodeFactoryInstance = new PublicInstanceMethodNodeFactory();
            }
            return publicInstanceMethodNodeFactoryInstance;
        }

        public static ModuleNodes.PublicInstanceMethodNode create(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name) {
            return new PublicInstanceMethodNodeGen(context, sourceSection, module, name);
        }

        @GeneratedBy(value=ModuleNodes.PublicInstanceMethodNode.class)
        public static final class PublicInstanceMethodNodeGen
        extends ModuleNodes.PublicInstanceMethodNode {
            @Node.Child
            private RubyNode module_;
            @Node.Child
            private RubyNode name_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private PublicInstanceMethodNodeGen(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name) {
                super(context, sourceSection);
                this.module_ = module;
                this.name_ = this.coerceToString(name);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                String nameValue_;
                DynamicObject moduleValue_;
                try {
                    moduleValue_ = this.module_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object nameValue = this.name_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), nameValue);
                }
                try {
                    nameValue_ = PublicInstanceMethodNodeGen.expectString(this.name_.execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(moduleValue_, ex.getResult());
                }
                return this.publicInstanceMethod(moduleValue_, nameValue_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object moduleValue, Object nameValue) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.module_, this.name_}, moduleValue, nameValue);
            }

            private static String expectString(Object value) throws UnexpectedResultException {
                if (value instanceof String) {
                    return (String)value;
                }
                throw new UnexpectedResultException(value);
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.PrivateInstanceMethodsNode.class)
    public static final class PrivateInstanceMethodsNodeFactory
    extends NodeFactoryBase<ModuleNodes.PrivateInstanceMethodsNode> {
        private static PrivateInstanceMethodsNodeFactory privateInstanceMethodsNodeFactoryInstance;

        private PrivateInstanceMethodsNodeFactory() {
            super(ModuleNodes.PrivateInstanceMethodsNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class}});
        }

        @Override
        public ModuleNodes.PrivateInstanceMethodsNode createNode(Object ... arguments) {
            if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
                return PrivateInstanceMethodsNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode)arguments[2], (RubyNode)arguments[3]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ModuleNodes.PrivateInstanceMethodsNode> getInstance() {
            if (privateInstanceMethodsNodeFactoryInstance == null) {
                privateInstanceMethodsNodeFactoryInstance = new PrivateInstanceMethodsNodeFactory();
            }
            return privateInstanceMethodsNodeFactoryInstance;
        }

        public static ModuleNodes.PrivateInstanceMethodsNode create(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode includeAncestors) {
            return new PrivateInstanceMethodsNodeGen(context, sourceSection, module, includeAncestors);
        }

        @GeneratedBy(value=ModuleNodes.PrivateInstanceMethodsNode.class)
        public static final class PrivateInstanceMethodsNodeGen
        extends ModuleNodes.PrivateInstanceMethodsNode {
            @Node.Child
            private RubyNode module_;
            @Node.Child
            private RubyNode includeAncestors_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private PrivateInstanceMethodsNodeGen(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode includeAncestors) {
                super(context, sourceSection);
                this.module_ = module;
                this.includeAncestors_ = this.coerceToBoolean(includeAncestors);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeDynamicObject(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeDynamicObject(frameValue);
            }

            @Override
            public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
                boolean includeAncestorsValue_;
                DynamicObject moduleValue_;
                try {
                    moduleValue_ = this.module_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object includeAncestorsValue = this.includeAncestors_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), includeAncestorsValue);
                }
                try {
                    includeAncestorsValue_ = this.includeAncestors_.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(moduleValue_, ex.getResult());
                }
                return this.privateInstanceMethods(moduleValue_, includeAncestorsValue_);
            }

            private UnsupportedSpecializationException unsupported(Object moduleValue, Object includeAncestorsValue) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.module_, this.includeAncestors_}, moduleValue, includeAncestorsValue);
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.ProtectedMethodDefinedNode.class)
    public static final class ProtectedMethodDefinedNodeFactory
    extends NodeFactoryBase<ModuleNodes.ProtectedMethodDefinedNode> {
        private static ProtectedMethodDefinedNodeFactory protectedMethodDefinedNodeFactoryInstance;

        private ProtectedMethodDefinedNodeFactory() {
            super(ModuleNodes.ProtectedMethodDefinedNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class}});
        }

        @Override
        public ModuleNodes.ProtectedMethodDefinedNode createNode(Object ... arguments) {
            if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
                return ProtectedMethodDefinedNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode)arguments[2], (RubyNode)arguments[3]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ModuleNodes.ProtectedMethodDefinedNode> getInstance() {
            if (protectedMethodDefinedNodeFactoryInstance == null) {
                protectedMethodDefinedNodeFactoryInstance = new ProtectedMethodDefinedNodeFactory();
            }
            return protectedMethodDefinedNodeFactoryInstance;
        }

        public static ModuleNodes.ProtectedMethodDefinedNode create(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name) {
            return new ProtectedMethodDefinedNodeGen(context, sourceSection, module, name);
        }

        @GeneratedBy(value=ModuleNodes.ProtectedMethodDefinedNode.class)
        public static final class ProtectedMethodDefinedNodeGen
        extends ModuleNodes.ProtectedMethodDefinedNode {
            @Node.Child
            private RubyNode module_;
            @Node.Child
            private RubyNode name_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private ProtectedMethodDefinedNodeGen(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name) {
                super(context, sourceSection);
                this.module_ = module;
                this.name_ = this.coerceToString(name);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeBoolean(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeBoolean(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                String nameValue_;
                DynamicObject moduleValue_;
                try {
                    moduleValue_ = this.module_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object nameValue = this.name_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), nameValue);
                }
                try {
                    nameValue_ = ProtectedMethodDefinedNodeGen.expectString(this.name_.execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(moduleValue_, ex.getResult());
                }
                return this.isProtectedMethodDefined(moduleValue_, nameValue_);
            }

            private UnsupportedSpecializationException unsupported(Object moduleValue, Object nameValue) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.module_, this.name_}, moduleValue, nameValue);
            }

            private static String expectString(Object value) throws UnexpectedResultException {
                if (value instanceof String) {
                    return (String)value;
                }
                throw new UnexpectedResultException(value);
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.ProtectedInstanceMethodsNode.class)
    public static final class ProtectedInstanceMethodsNodeFactory
    extends NodeFactoryBase<ModuleNodes.ProtectedInstanceMethodsNode> {
        private static ProtectedInstanceMethodsNodeFactory protectedInstanceMethodsNodeFactoryInstance;

        private ProtectedInstanceMethodsNodeFactory() {
            super(ModuleNodes.ProtectedInstanceMethodsNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class}});
        }

        @Override
        public ModuleNodes.ProtectedInstanceMethodsNode createNode(Object ... arguments) {
            if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
                return ProtectedInstanceMethodsNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode)arguments[2], (RubyNode)arguments[3]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ModuleNodes.ProtectedInstanceMethodsNode> getInstance() {
            if (protectedInstanceMethodsNodeFactoryInstance == null) {
                protectedInstanceMethodsNodeFactoryInstance = new ProtectedInstanceMethodsNodeFactory();
            }
            return protectedInstanceMethodsNodeFactoryInstance;
        }

        public static ModuleNodes.ProtectedInstanceMethodsNode create(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode includeAncestors) {
            return new ProtectedInstanceMethodsNodeGen(context, sourceSection, module, includeAncestors);
        }

        @GeneratedBy(value=ModuleNodes.ProtectedInstanceMethodsNode.class)
        public static final class ProtectedInstanceMethodsNodeGen
        extends ModuleNodes.ProtectedInstanceMethodsNode {
            @Node.Child
            private RubyNode module_;
            @Node.Child
            private RubyNode includeAncestors_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private ProtectedInstanceMethodsNodeGen(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode includeAncestors) {
                super(context, sourceSection);
                this.module_ = module;
                this.includeAncestors_ = this.coerceToBoolean(includeAncestors);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeDynamicObject(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeDynamicObject(frameValue);
            }

            @Override
            public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
                boolean includeAncestorsValue_;
                DynamicObject moduleValue_;
                try {
                    moduleValue_ = this.module_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object includeAncestorsValue = this.includeAncestors_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), includeAncestorsValue);
                }
                try {
                    includeAncestorsValue_ = this.includeAncestors_.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(moduleValue_, ex.getResult());
                }
                return this.protectedInstanceMethods(moduleValue_, includeAncestorsValue_);
            }

            private UnsupportedSpecializationException unsupported(Object moduleValue, Object includeAncestorsValue) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.module_, this.includeAncestors_}, moduleValue, includeAncestorsValue);
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.PrivateMethodDefinedNode.class)
    public static final class PrivateMethodDefinedNodeFactory
    extends NodeFactoryBase<ModuleNodes.PrivateMethodDefinedNode> {
        private static PrivateMethodDefinedNodeFactory privateMethodDefinedNodeFactoryInstance;

        private PrivateMethodDefinedNodeFactory() {
            super(ModuleNodes.PrivateMethodDefinedNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class}});
        }

        @Override
        public ModuleNodes.PrivateMethodDefinedNode createNode(Object ... arguments) {
            if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
                return PrivateMethodDefinedNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode)arguments[2], (RubyNode)arguments[3]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ModuleNodes.PrivateMethodDefinedNode> getInstance() {
            if (privateMethodDefinedNodeFactoryInstance == null) {
                privateMethodDefinedNodeFactoryInstance = new PrivateMethodDefinedNodeFactory();
            }
            return privateMethodDefinedNodeFactoryInstance;
        }

        public static ModuleNodes.PrivateMethodDefinedNode create(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name) {
            return new PrivateMethodDefinedNodeGen(context, sourceSection, module, name);
        }

        @GeneratedBy(value=ModuleNodes.PrivateMethodDefinedNode.class)
        public static final class PrivateMethodDefinedNodeGen
        extends ModuleNodes.PrivateMethodDefinedNode {
            @Node.Child
            private RubyNode module_;
            @Node.Child
            private RubyNode name_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private PrivateMethodDefinedNodeGen(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name) {
                super(context, sourceSection);
                this.module_ = module;
                this.name_ = this.coerceToString(name);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeBoolean(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeBoolean(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                String nameValue_;
                DynamicObject moduleValue_;
                try {
                    moduleValue_ = this.module_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object nameValue = this.name_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), nameValue);
                }
                try {
                    nameValue_ = PrivateMethodDefinedNodeGen.expectString(this.name_.execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(moduleValue_, ex.getResult());
                }
                return this.isPrivateMethodDefined(moduleValue_, nameValue_);
            }

            private UnsupportedSpecializationException unsupported(Object moduleValue, Object nameValue) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.module_, this.name_}, moduleValue, nameValue);
            }

            private static String expectString(Object value) throws UnexpectedResultException {
                if (value instanceof String) {
                    return (String)value;
                }
                throw new UnexpectedResultException(value);
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.PrivateClassMethodNode.class)
    public static final class PrivateClassMethodNodeFactory
    extends NodeFactoryBase<ModuleNodes.PrivateClassMethodNode> {
        private static PrivateClassMethodNodeFactory privateClassMethodNodeFactoryInstance;

        private PrivateClassMethodNodeFactory() {
            super(ModuleNodes.PrivateClassMethodNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ModuleNodes.PrivateClassMethodNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return PrivateClassMethodNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ModuleNodes.PrivateClassMethodNode> getInstance() {
            if (privateClassMethodNodeFactoryInstance == null) {
                privateClassMethodNodeFactoryInstance = new PrivateClassMethodNodeFactory();
            }
            return privateClassMethodNodeFactoryInstance;
        }

        public static ModuleNodes.PrivateClassMethodNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new PrivateClassMethodNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ModuleNodes.PrivateClassMethodNode.class)
        public static final class PrivateClassMethodNodeGen
        extends ModuleNodes.PrivateClassMethodNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private PrivateClassMethodNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object[] arguments1Value_;
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments1_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), arguments1Value);
                }
                try {
                    arguments1Value_ = this.arguments1_.executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(arguments0Value_, ex.getResult());
                }
                return this.privateClassMethod(frameValue, arguments0Value_, arguments1Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value, Object arguments1Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_, this.arguments1_}, arguments0Value, arguments1Value);
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.PrependFeaturesNode.class)
    public static final class PrependFeaturesNodeFactory
    extends NodeFactoryBase<ModuleNodes.PrependFeaturesNode> {
        private static PrependFeaturesNodeFactory prependFeaturesNodeFactoryInstance;

        private PrependFeaturesNodeFactory() {
            super(ModuleNodes.PrependFeaturesNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ModuleNodes.PrependFeaturesNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return PrependFeaturesNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ModuleNodes.PrependFeaturesNode> getInstance() {
            if (prependFeaturesNodeFactoryInstance == null) {
                prependFeaturesNodeFactoryInstance = new PrependFeaturesNodeFactory();
            }
            return prependFeaturesNodeFactoryInstance;
        }

        public static ModuleNodes.PrependFeaturesNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new PrependFeaturesNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ModuleNodes.PrependFeaturesNode.class)
        public static final class PrependFeaturesNodeGen
        extends ModuleNodes.PrependFeaturesNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private PrependFeaturesNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments1Value_;
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments1_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), arguments1Value);
                }
                try {
                    arguments1Value_ = this.arguments1_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(arguments0Value_, ex.getResult());
                }
                if (RubyGuards.isRubyModule(arguments1Value_)) {
                    return this.prependFeatures(arguments0Value_, arguments1Value_);
                }
                throw this.unsupported(arguments0Value_, arguments1Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value, Object arguments1Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_, this.arguments1_}, arguments0Value, arguments1Value);
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.PrivateNode.class)
    public static final class PrivateNodeFactory
    extends NodeFactoryBase<ModuleNodes.PrivateNode> {
        private static PrivateNodeFactory privateNodeFactoryInstance;

        private PrivateNodeFactory() {
            super(ModuleNodes.PrivateNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ModuleNodes.PrivateNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return PrivateNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ModuleNodes.PrivateNode> getInstance() {
            if (privateNodeFactoryInstance == null) {
                privateNodeFactoryInstance = new PrivateNodeFactory();
            }
            return privateNodeFactoryInstance;
        }

        public static ModuleNodes.PrivateNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new PrivateNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ModuleNodes.PrivateNode.class)
        public static final class PrivateNodeGen
        extends ModuleNodes.PrivateNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private PrivateNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public DynamicObject executePrivate(VirtualFrame frameValue, DynamicObject arguments0Value, Object[] arguments1Value) {
                return this.doPrivate(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object[] arguments1Value_;
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments1_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), arguments1Value);
                }
                try {
                    arguments1Value_ = this.arguments1_.executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(arguments0Value_, ex.getResult());
                }
                return this.doPrivate(frameValue, arguments0Value_, arguments1Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value, Object arguments1Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_, this.arguments1_}, arguments0Value, arguments1Value);
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.PublicClassMethodNode.class)
    public static final class PublicClassMethodNodeFactory
    extends NodeFactoryBase<ModuleNodes.PublicClassMethodNode> {
        private static PublicClassMethodNodeFactory publicClassMethodNodeFactoryInstance;

        private PublicClassMethodNodeFactory() {
            super(ModuleNodes.PublicClassMethodNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ModuleNodes.PublicClassMethodNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return PublicClassMethodNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ModuleNodes.PublicClassMethodNode> getInstance() {
            if (publicClassMethodNodeFactoryInstance == null) {
                publicClassMethodNodeFactoryInstance = new PublicClassMethodNodeFactory();
            }
            return publicClassMethodNodeFactoryInstance;
        }

        public static ModuleNodes.PublicClassMethodNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new PublicClassMethodNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ModuleNodes.PublicClassMethodNode.class)
        public static final class PublicClassMethodNodeGen
        extends ModuleNodes.PublicClassMethodNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private PublicClassMethodNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object[] arguments1Value_;
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments1_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), arguments1Value);
                }
                try {
                    arguments1Value_ = this.arguments1_.executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(arguments0Value_, ex.getResult());
                }
                return this.publicClassMethod(frameValue, arguments0Value_, arguments1Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value, Object arguments1Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_, this.arguments1_}, arguments0Value, arguments1Value);
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.PublicNode.class)
    public static final class PublicNodeFactory
    extends NodeFactoryBase<ModuleNodes.PublicNode> {
        private static PublicNodeFactory publicNodeFactoryInstance;

        private PublicNodeFactory() {
            super(ModuleNodes.PublicNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ModuleNodes.PublicNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return PublicNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ModuleNodes.PublicNode> getInstance() {
            if (publicNodeFactoryInstance == null) {
                publicNodeFactoryInstance = new PublicNodeFactory();
            }
            return publicNodeFactoryInstance;
        }

        public static ModuleNodes.PublicNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new PublicNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ModuleNodes.PublicNode.class)
        public static final class PublicNodeGen
        extends ModuleNodes.PublicNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private PublicNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public DynamicObject executePublic(VirtualFrame frameValue, DynamicObject arguments0Value, Object[] arguments1Value) {
                return this.doPublic(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object[] arguments1Value_;
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments1_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), arguments1Value);
                }
                try {
                    arguments1Value_ = this.arguments1_.executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(arguments0Value_, ex.getResult());
                }
                return this.doPublic(frameValue, arguments0Value_, arguments1Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value, Object arguments1Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_, this.arguments1_}, arguments0Value, arguments1Value);
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.NestingNode.class)
    public static final class NestingNodeFactory
    extends NodeFactoryBase<ModuleNodes.NestingNode> {
        private static NestingNodeFactory nestingNodeFactoryInstance;

        private NestingNodeFactory() {
            super(ModuleNodes.NestingNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ModuleNodes.NestingNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return NestingNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ModuleNodes.NestingNode> getInstance() {
            if (nestingNodeFactoryInstance == null) {
                nestingNodeFactoryInstance = new NestingNodeFactory();
            }
            return nestingNodeFactoryInstance;
        }

        public static ModuleNodes.NestingNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new NestingNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ModuleNodes.NestingNode.class)
        public static final class NestingNodeGen
        extends ModuleNodes.NestingNode {
            private NestingNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.nesting();
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.NameNode.class)
    public static final class NameNodeFactory
    extends NodeFactoryBase<ModuleNodes.NameNode> {
        private static NameNodeFactory nameNodeFactoryInstance;

        private NameNodeFactory() {
            super(ModuleNodes.NameNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ModuleNodes.NameNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return NameNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ModuleNodes.NameNode> getInstance() {
            if (nameNodeFactoryInstance == null) {
                nameNodeFactoryInstance = new NameNodeFactory();
            }
            return nameNodeFactoryInstance;
        }

        public static ModuleNodes.NameNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new NameNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ModuleNodes.NameNode.class)
        public static final class NameNodeGen
        extends ModuleNodes.NameNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private BaseNode_ specialization_;

            private NameNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="name(DynamicObject, ValueProfile)", value=ModuleNodes.NameNode.class)
            private static final class NameNode_
            extends BaseNode_ {
                private final ValueProfile fieldsProfile;

                NameNode_(NameNodeGen root, ValueProfile fieldsProfile) {
                    super(root, 1);
                    this.fieldsProfile = fieldsProfile;
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        return this.root.name(arguments0Value_, this.fieldsProfile);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(NameNodeGen root, ValueProfile fieldsProfile) {
                    return new NameNode_(root, fieldsProfile);
                }
            }

            @GeneratedBy(value=ModuleNodes.NameNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(NameNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(NameNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ModuleNodes.NameNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected NameNodeGen root;

                BaseNode_(NameNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (NameNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        ValueProfile fieldsProfile1 = ValueProfile.createIdentityProfile();
                        return NameNode_.create(this.root, fieldsProfile1);
                    }
                    return null;
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.ModuleFunctionNode.class)
    public static final class ModuleFunctionNodeFactory
    extends NodeFactoryBase<ModuleNodes.ModuleFunctionNode> {
        private static ModuleFunctionNodeFactory moduleFunctionNodeFactoryInstance;

        private ModuleFunctionNodeFactory() {
            super(ModuleNodes.ModuleFunctionNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ModuleNodes.ModuleFunctionNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ModuleFunctionNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ModuleNodes.ModuleFunctionNode> getInstance() {
            if (moduleFunctionNodeFactoryInstance == null) {
                moduleFunctionNodeFactoryInstance = new ModuleFunctionNodeFactory();
            }
            return moduleFunctionNodeFactoryInstance;
        }

        public static ModuleNodes.ModuleFunctionNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new ModuleFunctionNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ModuleNodes.ModuleFunctionNode.class)
        public static final class ModuleFunctionNodeGen
        extends ModuleNodes.ModuleFunctionNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private ModuleFunctionNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object[] arguments1Value_;
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments1_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), arguments1Value);
                }
                try {
                    arguments1Value_ = this.arguments1_.executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(arguments0Value_, ex.getResult());
                }
                return this.moduleFunction(frameValue, arguments0Value_, arguments1Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value, Object arguments1Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_, this.arguments1_}, arguments0Value, arguments1Value);
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.MethodDefinedNode.class)
    public static final class MethodDefinedNodeFactory
    extends NodeFactoryBase<ModuleNodes.MethodDefinedNode> {
        private static MethodDefinedNodeFactory methodDefinedNodeFactoryInstance;

        private MethodDefinedNodeFactory() {
            super(ModuleNodes.MethodDefinedNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class, RubyNode.class}});
        }

        @Override
        public ModuleNodes.MethodDefinedNode createNode(Object ... arguments) {
            if (!(arguments.length != 5 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode) || arguments[4] != null && !(arguments[4] instanceof RubyNode))) {
                return MethodDefinedNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode)arguments[2], (RubyNode)arguments[3], (RubyNode)arguments[4]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ModuleNodes.MethodDefinedNode> getInstance() {
            if (methodDefinedNodeFactoryInstance == null) {
                methodDefinedNodeFactoryInstance = new MethodDefinedNodeFactory();
            }
            return methodDefinedNodeFactoryInstance;
        }

        public static ModuleNodes.MethodDefinedNode create(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name, RubyNode inherit) {
            return new MethodDefinedNodeGen(context, sourceSection, module, name, inherit);
        }

        @GeneratedBy(value=ModuleNodes.MethodDefinedNode.class)
        public static final class MethodDefinedNodeGen
        extends ModuleNodes.MethodDefinedNode {
            @Node.Child
            private RubyNode module_;
            @Node.Child
            private RubyNode name_;
            @Node.Child
            private RubyNode inherit_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private MethodDefinedNodeGen(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name, RubyNode inherit) {
                super(context, sourceSection);
                this.module_ = module;
                this.name_ = this.coerceToString(name);
                this.inherit_ = this.coerceToBoolean(inherit);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeBoolean(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeBoolean(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                boolean inheritValue_;
                String nameValue_;
                DynamicObject moduleValue_;
                try {
                    moduleValue_ = this.module_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object nameValue = this.name_.execute(frameValue);
                    Object inheritValue = this.inherit_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), nameValue, inheritValue);
                }
                try {
                    nameValue_ = MethodDefinedNodeGen.expectString(this.name_.execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object inheritValue = this.inherit_.execute(frameValue);
                    throw this.unsupported(moduleValue_, ex.getResult(), inheritValue);
                }
                try {
                    inheritValue_ = this.inherit_.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(moduleValue_, nameValue_, ex.getResult());
                }
                return this.isMethodDefined(moduleValue_, nameValue_, inheritValue_);
            }

            private UnsupportedSpecializationException unsupported(Object moduleValue, Object nameValue, Object inheritValue) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.module_, this.name_, this.inherit_}, moduleValue, nameValue, inheritValue);
            }

            private static String expectString(Object value) throws UnexpectedResultException {
                if (value instanceof String) {
                    return (String)value;
                }
                throw new UnexpectedResultException(value);
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.IncludedModulesNode.class)
    public static final class IncludedModulesNodeFactory
    extends NodeFactoryBase<ModuleNodes.IncludedModulesNode> {
        private static IncludedModulesNodeFactory includedModulesNodeFactoryInstance;

        private IncludedModulesNodeFactory() {
            super(ModuleNodes.IncludedModulesNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ModuleNodes.IncludedModulesNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return IncludedModulesNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ModuleNodes.IncludedModulesNode> getInstance() {
            if (includedModulesNodeFactoryInstance == null) {
                includedModulesNodeFactoryInstance = new IncludedModulesNodeFactory();
            }
            return includedModulesNodeFactoryInstance;
        }

        public static ModuleNodes.IncludedModulesNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new IncludedModulesNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ModuleNodes.IncludedModulesNode.class)
        public static final class IncludedModulesNodeGen
        extends ModuleNodes.IncludedModulesNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private IncludedModulesNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.includedModules(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_}, arguments0Value);
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.IncludedNode.class)
    public static final class IncludedNodeFactory
    extends NodeFactoryBase<ModuleNodes.IncludedNode> {
        private static IncludedNodeFactory includedNodeFactoryInstance;

        private IncludedNodeFactory() {
            super(ModuleNodes.IncludedNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ModuleNodes.IncludedNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return IncludedNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ModuleNodes.IncludedNode> getInstance() {
            if (includedNodeFactoryInstance == null) {
                includedNodeFactoryInstance = new IncludedNodeFactory();
            }
            return includedNodeFactoryInstance;
        }

        public static ModuleNodes.IncludedNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new IncludedNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ModuleNodes.IncludedNode.class)
        public static final class IncludedNodeGen
        extends ModuleNodes.IncludedNode {
            @Node.Child
            private RubyNode arguments0_;

            private IncludedNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                return this.included(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.InitializeCopyNode.class)
    public static final class InitializeCopyNodeFactory
    extends NodeFactoryBase<ModuleNodes.InitializeCopyNode> {
        private static InitializeCopyNodeFactory initializeCopyNodeFactoryInstance;

        private InitializeCopyNodeFactory() {
            super(ModuleNodes.InitializeCopyNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ModuleNodes.InitializeCopyNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InitializeCopyNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ModuleNodes.InitializeCopyNode> getInstance() {
            if (initializeCopyNodeFactoryInstance == null) {
                initializeCopyNodeFactoryInstance = new InitializeCopyNodeFactory();
            }
            return initializeCopyNodeFactoryInstance;
        }

        public static ModuleNodes.InitializeCopyNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new InitializeCopyNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ModuleNodes.InitializeCopyNode.class)
        public static final class InitializeCopyNodeGen
        extends ModuleNodes.InitializeCopyNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private BaseNode_ specialization_;

            private InitializeCopyNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="initializeCopy(DynamicObject, DynamicObject)", value=ModuleNodes.InitializeCopyNode.class)
            private static final class InitializeCopyNode_
            extends BaseNode_ {
                InitializeCopyNode_(InitializeCopyNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubyClass(arguments0Value_) && RubyGuards.isRubyClass(arguments1Value_)) {
                            return this.root.initializeCopy(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(InitializeCopyNodeGen root) {
                    return new InitializeCopyNode_(root);
                }
            }

            @GeneratedBy(methodName="initializeCopyModule(DynamicObject, DynamicObject)", value=ModuleNodes.InitializeCopyNode.class)
            private static final class InitializeCopyModuleNode_
            extends BaseNode_ {
                InitializeCopyModuleNode_(InitializeCopyNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (!RubyGuards.isRubyClass(arguments0Value_) && RubyGuards.isRubyModule(arguments1Value_) && !RubyGuards.isRubyClass(arguments1Value_)) {
                            return this.root.initializeCopyModule(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(InitializeCopyNodeGen root) {
                    return new InitializeCopyModuleNode_(root);
                }
            }

            @GeneratedBy(value=ModuleNodes.InitializeCopyNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(InitializeCopyNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(InitializeCopyNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ModuleNodes.InitializeCopyNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(InitializeCopyNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(InitializeCopyNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ModuleNodes.InitializeCopyNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected InitializeCopyNodeGen root;

                BaseNode_(InitializeCopyNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (InitializeCopyNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (!RubyGuards.isRubyClass(arguments0Value_) && RubyGuards.isRubyModule(arguments1Value_) && !RubyGuards.isRubyClass(arguments1Value_)) {
                            return InitializeCopyModuleNode_.create(this.root);
                        }
                        if (RubyGuards.isRubyClass(arguments0Value_) && RubyGuards.isRubyClass(arguments1Value_)) {
                            return InitializeCopyNode_.create(this.root);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.InitializeNode.class)
    public static final class InitializeNodeFactory
    extends NodeFactoryBase<ModuleNodes.InitializeNode> {
        private static InitializeNodeFactory initializeNodeFactoryInstance;

        private InitializeNodeFactory() {
            super(ModuleNodes.InitializeNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ModuleNodes.InitializeNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InitializeNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ModuleNodes.InitializeNode> getInstance() {
            if (initializeNodeFactoryInstance == null) {
                initializeNodeFactoryInstance = new InitializeNodeFactory();
            }
            return initializeNodeFactoryInstance;
        }

        public static ModuleNodes.InitializeNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new InitializeNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ModuleNodes.InitializeNode.class)
        public static final class InitializeNodeGen
        extends ModuleNodes.InitializeNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private BaseNode_ specialization_;

            private InitializeNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public DynamicObject executeInitialize(VirtualFrame frameValue, DynamicObject arguments0Value, DynamicObject arguments1Value) {
                return this.specialization_.executeDynamicObject1(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="initialize(VirtualFrame, DynamicObject, DynamicObject)", value=ModuleNodes.InitializeNode.class)
            private static final class Initialize1Node_
            extends BaseNode_ {
                Initialize1Node_(InitializeNodeGen root) {
                    super(root, 2);
                }

                @Override
                public DynamicObject executeDynamicObject1(VirtualFrame frameValue, DynamicObject arguments0Value, DynamicObject arguments1Value) {
                    return this.root.initialize(frameValue, arguments0Value, arguments1Value);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        return this.root.initialize(frameValue, arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(InitializeNodeGen root) {
                    return new Initialize1Node_(root);
                }
            }

            @GeneratedBy(methodName="initialize(DynamicObject, NotProvided)", value=ModuleNodes.InitializeNode.class)
            private static final class Initialize0Node_
            extends BaseNode_ {
                Initialize0Node_(InitializeNodeGen root) {
                    super(root, 1);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        return this.root.initialize(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(InitializeNodeGen root) {
                    return new Initialize0Node_(root);
                }
            }

            @GeneratedBy(value=ModuleNodes.InitializeNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(InitializeNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(InitializeNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ModuleNodes.InitializeNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(InitializeNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return (DynamicObject)this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(InitializeNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ModuleNodes.InitializeNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected InitializeNodeGen root;

                BaseNode_(InitializeNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (InitializeNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.executeDynamicObject_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract DynamicObject executeDynamicObject_(VirtualFrame var1, Object var2, Object var3);

                public DynamicObject executeDynamicObject1(VirtualFrame frameValue, DynamicObject arguments0Value, DynamicObject arguments1Value) {
                    return this.executeDynamicObject_(frameValue, arguments0Value, arguments1Value);
                }

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.executeDynamicObject_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        if (arguments1Value instanceof NotProvided) {
                            return Initialize0Node_.create(this.root);
                        }
                        if (arguments1Value instanceof DynamicObject) {
                            return Initialize1Node_.create(this.root);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.ExtendObjectNode.class)
    public static final class ExtendObjectNodeFactory
    extends NodeFactoryBase<ModuleNodes.ExtendObjectNode> {
        private static ExtendObjectNodeFactory extendObjectNodeFactoryInstance;

        private ExtendObjectNodeFactory() {
            super(ModuleNodes.ExtendObjectNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ModuleNodes.ExtendObjectNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ExtendObjectNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ModuleNodes.ExtendObjectNode> getInstance() {
            if (extendObjectNodeFactoryInstance == null) {
                extendObjectNodeFactoryInstance = new ExtendObjectNodeFactory();
            }
            return extendObjectNodeFactoryInstance;
        }

        public static ModuleNodes.ExtendObjectNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new ExtendObjectNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ModuleNodes.ExtendObjectNode.class)
        public static final class ExtendObjectNodeGen
        extends ModuleNodes.ExtendObjectNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private ExtendObjectNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments1Value_;
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments1_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), arguments1Value);
                }
                try {
                    arguments1Value_ = this.arguments1_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(arguments0Value_, ex.getResult());
                }
                return this.extendObject(arguments0Value_, arguments1Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value, Object arguments1Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_, this.arguments1_}, arguments0Value, arguments1Value);
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.DefineMethodNode.class)
    public static final class DefineMethodNodeFactory
    extends NodeFactoryBase<ModuleNodes.DefineMethodNode> {
        private static DefineMethodNodeFactory defineMethodNodeFactoryInstance;

        private DefineMethodNodeFactory() {
            super(ModuleNodes.DefineMethodNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class, RubyNode.class, RubyNode.class}});
        }

        @Override
        public ModuleNodes.DefineMethodNode createNode(Object ... arguments) {
            if (!(arguments.length != 6 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode) || arguments[4] != null && !(arguments[4] instanceof RubyNode) || arguments[5] != null && !(arguments[5] instanceof RubyNode))) {
                return DefineMethodNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode)arguments[2], (RubyNode)arguments[3], (RubyNode)arguments[4], (RubyNode)arguments[5]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ModuleNodes.DefineMethodNode> getInstance() {
            if (defineMethodNodeFactoryInstance == null) {
                defineMethodNodeFactoryInstance = new DefineMethodNodeFactory();
            }
            return defineMethodNodeFactoryInstance;
        }

        public static ModuleNodes.DefineMethodNode create(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name, RubyNode proc, RubyNode block) {
            return new DefineMethodNodeGen(context, sourceSection, module, name, proc, block);
        }

        @GeneratedBy(value=ModuleNodes.DefineMethodNode.class)
        public static final class DefineMethodNodeGen
        extends ModuleNodes.DefineMethodNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode module_;
            @Node.Child
            private RubyNode name_;
            @Node.Child
            private RubyNode proc_;
            @Node.Child
            private RubyNode block_;
            @Node.Child
            private BaseNode_ specialization_;

            private DefineMethodNodeGen(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name, RubyNode proc, RubyNode block) {
                super(context, sourceSection);
                this.module_ = module;
                this.name_ = this.coerceToString(name);
                this.proc_ = proc;
                this.block_ = block;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="defineMethod(VirtualFrame, DynamicObject, String, DynamicObject, NotProvided)", value=ModuleNodes.DefineMethodNode.class)
            private static final class DefineMethod1Node_
            extends BaseNode_ {
                DefineMethod1Node_(DefineMethodNodeGen root) {
                    super(root, 5);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object moduleValue, Object nameValue, Object procValue, Object blockValue) {
                    if (moduleValue instanceof DynamicObject && nameValue instanceof String && procValue instanceof DynamicObject && blockValue instanceof NotProvided) {
                        DynamicObject moduleValue_ = (DynamicObject)moduleValue;
                        String nameValue_ = (String)nameValue;
                        DynamicObject procValue_ = (DynamicObject)procValue;
                        NotProvided blockValue_ = (NotProvided)blockValue;
                        if (RubyGuards.isRubyUnboundMethod(procValue_)) {
                            return this.root.defineMethod(frameValue, moduleValue_, nameValue_, procValue_, blockValue_);
                        }
                    }
                    return this.getNext().executeDynamicObject_(frameValue, moduleValue, nameValue, procValue, blockValue);
                }

                static BaseNode_ create(DefineMethodNodeGen root) {
                    return new DefineMethod1Node_(root);
                }
            }

            @GeneratedBy(methodName="defineMethodMethod(DynamicObject, String, DynamicObject, NotProvided, CanBindMethodToModuleNode)", value=ModuleNodes.DefineMethodNode.class)
            private static final class DefineMethodMethodNode_
            extends BaseNode_ {
                @Node.Child
                private CanBindMethodToModuleNode canBindMethodToModuleNode;

                DefineMethodMethodNode_(DefineMethodNodeGen root, CanBindMethodToModuleNode canBindMethodToModuleNode) {
                    super(root, 4);
                    this.canBindMethodToModuleNode = canBindMethodToModuleNode;
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object moduleValue, Object nameValue, Object procValue, Object blockValue) {
                    if (moduleValue instanceof DynamicObject && nameValue instanceof String && procValue instanceof DynamicObject && blockValue instanceof NotProvided) {
                        DynamicObject moduleValue_ = (DynamicObject)moduleValue;
                        String nameValue_ = (String)nameValue;
                        DynamicObject procValue_ = (DynamicObject)procValue;
                        NotProvided blockValue_ = (NotProvided)blockValue;
                        if (RubyGuards.isRubyMethod(procValue_)) {
                            return this.root.defineMethodMethod(moduleValue_, nameValue_, procValue_, blockValue_, this.canBindMethodToModuleNode);
                        }
                    }
                    return this.getNext().executeDynamicObject_(frameValue, moduleValue, nameValue, procValue, blockValue);
                }

                static BaseNode_ create(DefineMethodNodeGen root, CanBindMethodToModuleNode canBindMethodToModuleNode) {
                    return new DefineMethodMethodNode_(root, canBindMethodToModuleNode);
                }
            }

            @GeneratedBy(methodName="defineMethodProc(DynamicObject, String, DynamicObject, NotProvided)", value=ModuleNodes.DefineMethodNode.class)
            private static final class DefineMethodProcNode_
            extends BaseNode_ {
                DefineMethodProcNode_(DefineMethodNodeGen root) {
                    super(root, 3);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object moduleValue, Object nameValue, Object procValue, Object blockValue) {
                    if (moduleValue instanceof DynamicObject && nameValue instanceof String && procValue instanceof DynamicObject && blockValue instanceof NotProvided) {
                        DynamicObject moduleValue_ = (DynamicObject)moduleValue;
                        String nameValue_ = (String)nameValue;
                        DynamicObject procValue_ = (DynamicObject)procValue;
                        NotProvided blockValue_ = (NotProvided)blockValue;
                        if (RubyGuards.isRubyProc(procValue_)) {
                            return this.root.defineMethodProc(moduleValue_, nameValue_, procValue_, blockValue_);
                        }
                    }
                    return this.getNext().executeDynamicObject_(frameValue, moduleValue, nameValue, procValue, blockValue);
                }

                static BaseNode_ create(DefineMethodNodeGen root) {
                    return new DefineMethodProcNode_(root);
                }
            }

            @GeneratedBy(methodName="defineMethodBlock(DynamicObject, String, NotProvided, DynamicObject)", value=ModuleNodes.DefineMethodNode.class)
            private static final class DefineMethodBlockNode_
            extends BaseNode_ {
                DefineMethodBlockNode_(DefineMethodNodeGen root) {
                    super(root, 2);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object moduleValue, Object nameValue, Object procValue, Object blockValue) {
                    if (moduleValue instanceof DynamicObject && nameValue instanceof String && procValue instanceof NotProvided && blockValue instanceof DynamicObject) {
                        DynamicObject moduleValue_ = (DynamicObject)moduleValue;
                        String nameValue_ = (String)nameValue;
                        NotProvided procValue_ = (NotProvided)procValue;
                        DynamicObject blockValue_ = (DynamicObject)blockValue;
                        return this.root.defineMethodBlock(moduleValue_, nameValue_, procValue_, blockValue_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, moduleValue, nameValue, procValue, blockValue);
                }

                static BaseNode_ create(DefineMethodNodeGen root) {
                    return new DefineMethodBlockNode_(root);
                }
            }

            @GeneratedBy(methodName="defineMethod(DynamicObject, String, NotProvided, NotProvided)", value=ModuleNodes.DefineMethodNode.class)
            private static final class DefineMethod0Node_
            extends BaseNode_ {
                DefineMethod0Node_(DefineMethodNodeGen root) {
                    super(root, 1);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object moduleValue, Object nameValue, Object procValue, Object blockValue) {
                    if (moduleValue instanceof DynamicObject && nameValue instanceof String && procValue instanceof NotProvided && blockValue instanceof NotProvided) {
                        DynamicObject moduleValue_ = (DynamicObject)moduleValue;
                        String nameValue_ = (String)nameValue;
                        NotProvided procValue_ = (NotProvided)procValue;
                        NotProvided blockValue_ = (NotProvided)blockValue;
                        return this.root.defineMethod(moduleValue_, nameValue_, procValue_, blockValue_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, moduleValue, nameValue, procValue, blockValue);
                }

                static BaseNode_ create(DefineMethodNodeGen root) {
                    return new DefineMethod0Node_(root);
                }
            }

            @GeneratedBy(value=ModuleNodes.DefineMethodNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(DefineMethodNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object moduleValue, Object nameValue, Object procValue, Object blockValue) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, moduleValue, nameValue, procValue, blockValue));
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object moduleValue, Object nameValue, Object procValue, Object blockValue) {
                    return this.getNext().executeDynamicObject_(frameValue, moduleValue, nameValue, procValue, blockValue);
                }

                static BaseNode_ create(DefineMethodNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ModuleNodes.DefineMethodNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(DefineMethodNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object moduleValue, Object nameValue, Object procValue, Object blockValue) {
                    return (DynamicObject)this.uninitialized((Frame)frameValue, moduleValue, nameValue, procValue, blockValue);
                }

                static BaseNode_ create(DefineMethodNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ModuleNodes.DefineMethodNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected DefineMethodNodeGen root;

                BaseNode_(DefineMethodNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (DefineMethodNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.module_, this.root.name_, this.root.proc_, this.root.block_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object moduleValue, Object nameValue, Object procValue, Object blockValue) {
                    return this.executeDynamicObject_((VirtualFrame)frameValue, moduleValue, nameValue, procValue, blockValue);
                }

                public abstract DynamicObject executeDynamicObject_(VirtualFrame var1, Object var2, Object var3, Object var4, Object var5);

                public Object execute(VirtualFrame frameValue) {
                    Object moduleValue_ = this.root.module_.execute(frameValue);
                    Object nameValue_ = this.root.name_.execute(frameValue);
                    Object procValue_ = this.root.proc_.execute(frameValue);
                    Object blockValue_ = this.root.block_.execute(frameValue);
                    return this.executeDynamicObject_(frameValue, moduleValue_, nameValue_, procValue_, blockValue_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object moduleValue, Object nameValue, Object procValue, Object blockValue) {
                    if (moduleValue instanceof DynamicObject && nameValue instanceof String) {
                        if (procValue instanceof NotProvided) {
                            if (blockValue instanceof NotProvided) {
                                return DefineMethod0Node_.create(this.root);
                            }
                            if (blockValue instanceof DynamicObject) {
                                return DefineMethodBlockNode_.create(this.root);
                            }
                        }
                        if (procValue instanceof DynamicObject && blockValue instanceof NotProvided) {
                            DynamicObject procValue_ = (DynamicObject)procValue;
                            if (RubyGuards.isRubyProc(procValue_)) {
                                return DefineMethodProcNode_.create(this.root);
                            }
                            if (RubyGuards.isRubyMethod(procValue_)) {
                                CanBindMethodToModuleNode canBindMethodToModuleNode4 = this.root.createCanBindMethodToModuleNode();
                                return DefineMethodMethodNode_.create(this.root, canBindMethodToModuleNode4);
                            }
                            if (RubyGuards.isRubyUnboundMethod(procValue_)) {
                                return DefineMethod1Node_.create(this.root);
                            }
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.ConstSetNode.class)
    public static final class ConstSetNodeFactory
    extends NodeFactoryBase<ModuleNodes.ConstSetNode> {
        private static ConstSetNodeFactory constSetNodeFactoryInstance;

        private ConstSetNodeFactory() {
            super(ModuleNodes.ConstSetNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class, RubyNode.class}});
        }

        @Override
        public ModuleNodes.ConstSetNode createNode(Object ... arguments) {
            if (!(arguments.length != 5 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode) || arguments[4] != null && !(arguments[4] instanceof RubyNode))) {
                return ConstSetNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode)arguments[2], (RubyNode)arguments[3], (RubyNode)arguments[4]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ModuleNodes.ConstSetNode> getInstance() {
            if (constSetNodeFactoryInstance == null) {
                constSetNodeFactoryInstance = new ConstSetNodeFactory();
            }
            return constSetNodeFactoryInstance;
        }

        public static ModuleNodes.ConstSetNode create(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name, RubyNode value) {
            return new ConstSetNodeGen(context, sourceSection, module, name, value);
        }

        @GeneratedBy(value=ModuleNodes.ConstSetNode.class)
        public static final class ConstSetNodeGen
        extends ModuleNodes.ConstSetNode {
            @Node.Child
            private RubyNode module_;
            @Node.Child
            private RubyNode name_;
            @Node.Child
            private RubyNode value_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private ConstSetNodeGen(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name, RubyNode value) {
                super(context, sourceSection);
                this.module_ = module;
                this.name_ = this.coerceToString(name);
                this.value_ = value;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                String nameValue_;
                DynamicObject moduleValue_;
                try {
                    moduleValue_ = this.module_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object nameValue = this.name_.execute(frameValue);
                    Object valueValue = this.value_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), nameValue, valueValue);
                }
                try {
                    nameValue_ = ConstSetNodeGen.expectString(this.name_.execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object valueValue = this.value_.execute(frameValue);
                    throw this.unsupported(moduleValue_, ex.getResult(), valueValue);
                }
                Object valueValue_ = this.value_.execute(frameValue);
                return this.setConstant(moduleValue_, nameValue_, valueValue_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object moduleValue, Object nameValue, Object valueValue) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.module_, this.name_, this.value_}, moduleValue, nameValue, valueValue);
            }

            private static String expectString(Object value) throws UnexpectedResultException {
                if (value instanceof String) {
                    return (String)value;
                }
                throw new UnexpectedResultException(value);
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.ConstMissingNode.class)
    public static final class ConstMissingNodeFactory
    extends NodeFactoryBase<ModuleNodes.ConstMissingNode> {
        private static ConstMissingNodeFactory constMissingNodeFactoryInstance;

        private ConstMissingNodeFactory() {
            super(ModuleNodes.ConstMissingNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class}});
        }

        @Override
        public ModuleNodes.ConstMissingNode createNode(Object ... arguments) {
            if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
                return ConstMissingNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode)arguments[2], (RubyNode)arguments[3]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ModuleNodes.ConstMissingNode> getInstance() {
            if (constMissingNodeFactoryInstance == null) {
                constMissingNodeFactoryInstance = new ConstMissingNodeFactory();
            }
            return constMissingNodeFactoryInstance;
        }

        public static ModuleNodes.ConstMissingNode create(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name) {
            return new ConstMissingNodeGen(context, sourceSection, module, name);
        }

        @GeneratedBy(value=ModuleNodes.ConstMissingNode.class)
        public static final class ConstMissingNodeGen
        extends ModuleNodes.ConstMissingNode {
            @Node.Child
            private RubyNode module_;
            @Node.Child
            private RubyNode name_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private ConstMissingNodeGen(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name) {
                super(context, sourceSection);
                this.module_ = module;
                this.name_ = this.coerceToString(name);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                String nameValue_;
                DynamicObject moduleValue_;
                try {
                    moduleValue_ = this.module_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object nameValue = this.name_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), nameValue);
                }
                try {
                    nameValue_ = ConstMissingNodeGen.expectString(this.name_.execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(moduleValue_, ex.getResult());
                }
                return this.constMissing(moduleValue_, nameValue_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object moduleValue, Object nameValue) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.module_, this.name_}, moduleValue, nameValue);
            }

            private static String expectString(Object value) throws UnexpectedResultException {
                if (value instanceof String) {
                    return (String)value;
                }
                throw new UnexpectedResultException(value);
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.ConstGetNode.class)
    public static final class ConstGetNodeFactory
    extends NodeFactoryBase<ModuleNodes.ConstGetNode> {
        private static ConstGetNodeFactory constGetNodeFactoryInstance;

        private ConstGetNodeFactory() {
            super(ModuleNodes.ConstGetNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class, RubyNode.class}});
        }

        @Override
        public ModuleNodes.ConstGetNode createNode(Object ... arguments) {
            if (!(arguments.length != 5 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode) || arguments[4] != null && !(arguments[4] instanceof RubyNode))) {
                return ConstGetNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode)arguments[2], (RubyNode)arguments[3], (RubyNode)arguments[4]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ModuleNodes.ConstGetNode> getInstance() {
            if (constGetNodeFactoryInstance == null) {
                constGetNodeFactoryInstance = new ConstGetNodeFactory();
            }
            return constGetNodeFactoryInstance;
        }

        public static ModuleNodes.ConstGetNode create(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name, RubyNode inherit) {
            return new ConstGetNodeGen(context, sourceSection, module, name, inherit);
        }

        @GeneratedBy(value=ModuleNodes.ConstGetNode.class)
        public static final class ConstGetNodeGen
        extends ModuleNodes.ConstGetNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode module_;
            @Node.Child
            private RubyNode name_;
            @Node.Child
            private RubyNode inherit_;
            @CompilerDirectives.CompilationFinal
            private Class<?> inheritType_;
            @Node.Child
            private BaseNode_ specialization_;

            private ConstGetNodeGen(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name, RubyNode inherit) {
                super(context, sourceSection);
                this.module_ = module;
                this.name_ = this.coerceToSymbolOrString(name);
                this.inherit_ = this.coerceToBoolean(inherit);
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="getConstantScoped(DynamicObject, DynamicObject, boolean)", value=ModuleNodes.ConstGetNode.class)
            private static final class GetConstantScopedNode_
            extends BaseNode_ {
                GetConstantScopedNode_(ConstGetNodeGen root) {
                    super(root, 5);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    boolean inheritValue_;
                    DynamicObject nameValue_;
                    DynamicObject moduleValue_;
                    try {
                        moduleValue_ = this.root.module_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object nameValue = this.root.name_.execute(frameValue);
                        Object inheritValue = this.executeInherit_(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), nameValue, inheritValue);
                    }
                    try {
                        nameValue_ = this.root.name_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object inheritValue = this.executeInherit_(frameValue);
                        return this.getNext().execute_(frameValue, moduleValue_, ex.getResult(), inheritValue);
                    }
                    try {
                        inheritValue_ = this.root.inherit_.executeBoolean(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, moduleValue_, nameValue_, ex.getResult());
                    }
                    if (RubyGuards.isRubyString(nameValue_) && this.root.isScoped(nameValue_)) {
                        return this.root.getConstantScoped(moduleValue_, nameValue_, inheritValue_);
                    }
                    return this.getNext().execute_(frameValue, moduleValue_, nameValue_, inheritValue_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object moduleValue, Object nameValue, Object inheritValue) {
                    if (moduleValue instanceof DynamicObject && nameValue instanceof DynamicObject && inheritValue instanceof Boolean) {
                        DynamicObject moduleValue_ = (DynamicObject)moduleValue;
                        DynamicObject nameValue_ = (DynamicObject)nameValue;
                        boolean inheritValue_ = (Boolean)inheritValue;
                        if (RubyGuards.isRubyString(nameValue_) && this.root.isScoped(nameValue_)) {
                            return this.root.getConstantScoped(moduleValue_, nameValue_, inheritValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, moduleValue, nameValue, inheritValue);
                }

                static BaseNode_ create(ConstGetNodeGen root) {
                    return new GetConstantScopedNode_(root);
                }
            }

            @GeneratedBy(methodName="getConstantNoInheritString(DynamicObject, DynamicObject, boolean)", value=ModuleNodes.ConstGetNode.class)
            private static final class GetConstantNoInheritStringNode_
            extends BaseNode_ {
                GetConstantNoInheritStringNode_(ConstGetNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    boolean inheritValue_;
                    DynamicObject nameValue_;
                    DynamicObject moduleValue_;
                    try {
                        moduleValue_ = this.root.module_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object nameValue = this.root.name_.execute(frameValue);
                        Object inheritValue = this.executeInherit_(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), nameValue, inheritValue);
                    }
                    try {
                        nameValue_ = this.root.name_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object inheritValue = this.executeInherit_(frameValue);
                        return this.getNext().execute_(frameValue, moduleValue_, ex.getResult(), inheritValue);
                    }
                    try {
                        inheritValue_ = this.root.inherit_.executeBoolean(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, moduleValue_, nameValue_, ex.getResult());
                    }
                    if (!inheritValue_ && RubyGuards.isRubyString(nameValue_) && !this.root.isScoped(nameValue_)) {
                        return this.root.getConstantNoInheritString(moduleValue_, nameValue_, inheritValue_);
                    }
                    return this.getNext().execute_(frameValue, moduleValue_, nameValue_, inheritValue_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object moduleValue, Object nameValue, Object inheritValue) {
                    if (moduleValue instanceof DynamicObject && nameValue instanceof DynamicObject && inheritValue instanceof Boolean) {
                        DynamicObject moduleValue_ = (DynamicObject)moduleValue;
                        DynamicObject nameValue_ = (DynamicObject)nameValue;
                        boolean inheritValue_ = (Boolean)inheritValue;
                        if (!inheritValue_ && RubyGuards.isRubyString(nameValue_) && !this.root.isScoped(nameValue_)) {
                            return this.root.getConstantNoInheritString(moduleValue_, nameValue_, inheritValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, moduleValue, nameValue, inheritValue);
                }

                static BaseNode_ create(ConstGetNodeGen root) {
                    return new GetConstantNoInheritStringNode_(root);
                }
            }

            @GeneratedBy(methodName="getConstantString(VirtualFrame, DynamicObject, DynamicObject, boolean)", value=ModuleNodes.ConstGetNode.class)
            private static final class GetConstantStringNode_
            extends BaseNode_ {
                GetConstantStringNode_(ConstGetNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    boolean inheritValue_;
                    DynamicObject nameValue_;
                    DynamicObject moduleValue_;
                    try {
                        moduleValue_ = this.root.module_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object nameValue = this.root.name_.execute(frameValue);
                        Object inheritValue = this.executeInherit_(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), nameValue, inheritValue);
                    }
                    try {
                        nameValue_ = this.root.name_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object inheritValue = this.executeInherit_(frameValue);
                        return this.getNext().execute_(frameValue, moduleValue_, ex.getResult(), inheritValue);
                    }
                    try {
                        inheritValue_ = this.root.inherit_.executeBoolean(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, moduleValue_, nameValue_, ex.getResult());
                    }
                    if (inheritValue_ && RubyGuards.isRubyString(nameValue_) && !this.root.isScoped(nameValue_)) {
                        return this.root.getConstantString(frameValue, moduleValue_, nameValue_, inheritValue_);
                    }
                    return this.getNext().execute_(frameValue, moduleValue_, nameValue_, inheritValue_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object moduleValue, Object nameValue, Object inheritValue) {
                    if (moduleValue instanceof DynamicObject && nameValue instanceof DynamicObject && inheritValue instanceof Boolean) {
                        DynamicObject moduleValue_ = (DynamicObject)moduleValue;
                        DynamicObject nameValue_ = (DynamicObject)nameValue;
                        boolean inheritValue_ = (Boolean)inheritValue;
                        if (inheritValue_ && RubyGuards.isRubyString(nameValue_) && !this.root.isScoped(nameValue_)) {
                            return this.root.getConstantString(frameValue, moduleValue_, nameValue_, inheritValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, moduleValue, nameValue, inheritValue);
                }

                static BaseNode_ create(ConstGetNodeGen root) {
                    return new GetConstantStringNode_(root);
                }
            }

            @GeneratedBy(methodName="getConstantNoInherit(DynamicObject, DynamicObject, boolean)", value=ModuleNodes.ConstGetNode.class)
            private static final class GetConstantNoInheritNode_
            extends BaseNode_ {
                GetConstantNoInheritNode_(ConstGetNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    boolean inheritValue_;
                    DynamicObject nameValue_;
                    DynamicObject moduleValue_;
                    try {
                        moduleValue_ = this.root.module_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object nameValue = this.root.name_.execute(frameValue);
                        Object inheritValue = this.executeInherit_(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), nameValue, inheritValue);
                    }
                    try {
                        nameValue_ = this.root.name_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object inheritValue = this.executeInherit_(frameValue);
                        return this.getNext().execute_(frameValue, moduleValue_, ex.getResult(), inheritValue);
                    }
                    try {
                        inheritValue_ = this.root.inherit_.executeBoolean(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, moduleValue_, nameValue_, ex.getResult());
                    }
                    if (!inheritValue_ && RubyGuards.isRubySymbol(nameValue_)) {
                        return this.root.getConstantNoInherit(moduleValue_, nameValue_, inheritValue_);
                    }
                    return this.getNext().execute_(frameValue, moduleValue_, nameValue_, inheritValue_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object moduleValue, Object nameValue, Object inheritValue) {
                    if (moduleValue instanceof DynamicObject && nameValue instanceof DynamicObject && inheritValue instanceof Boolean) {
                        DynamicObject moduleValue_ = (DynamicObject)moduleValue;
                        DynamicObject nameValue_ = (DynamicObject)nameValue;
                        boolean inheritValue_ = (Boolean)inheritValue;
                        if (!inheritValue_ && RubyGuards.isRubySymbol(nameValue_)) {
                            return this.root.getConstantNoInherit(moduleValue_, nameValue_, inheritValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, moduleValue, nameValue, inheritValue);
                }

                static BaseNode_ create(ConstGetNodeGen root) {
                    return new GetConstantNoInheritNode_(root);
                }
            }

            @GeneratedBy(methodName="getConstant(VirtualFrame, DynamicObject, DynamicObject, boolean)", value=ModuleNodes.ConstGetNode.class)
            private static final class GetConstantNode_
            extends BaseNode_ {
                GetConstantNode_(ConstGetNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    boolean inheritValue_;
                    DynamicObject nameValue_;
                    DynamicObject moduleValue_;
                    try {
                        moduleValue_ = this.root.module_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object nameValue = this.root.name_.execute(frameValue);
                        Object inheritValue = this.executeInherit_(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), nameValue, inheritValue);
                    }
                    try {
                        nameValue_ = this.root.name_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object inheritValue = this.executeInherit_(frameValue);
                        return this.getNext().execute_(frameValue, moduleValue_, ex.getResult(), inheritValue);
                    }
                    try {
                        inheritValue_ = this.root.inherit_.executeBoolean(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, moduleValue_, nameValue_, ex.getResult());
                    }
                    if (inheritValue_ && RubyGuards.isRubySymbol(nameValue_)) {
                        return this.root.getConstant(frameValue, moduleValue_, nameValue_, inheritValue_);
                    }
                    return this.getNext().execute_(frameValue, moduleValue_, nameValue_, inheritValue_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object moduleValue, Object nameValue, Object inheritValue) {
                    if (moduleValue instanceof DynamicObject && nameValue instanceof DynamicObject && inheritValue instanceof Boolean) {
                        DynamicObject moduleValue_ = (DynamicObject)moduleValue;
                        DynamicObject nameValue_ = (DynamicObject)nameValue;
                        boolean inheritValue_ = (Boolean)inheritValue;
                        if (inheritValue_ && RubyGuards.isRubySymbol(nameValue_)) {
                            return this.root.getConstant(frameValue, moduleValue_, nameValue_, inheritValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, moduleValue, nameValue, inheritValue);
                }

                static BaseNode_ create(ConstGetNodeGen root) {
                    return new GetConstantNode_(root);
                }
            }

            @GeneratedBy(value=ModuleNodes.ConstGetNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ConstGetNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object moduleValue, Object nameValue, Object inheritValue) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, moduleValue, nameValue, inheritValue));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object moduleValue, Object nameValue, Object inheritValue) {
                    return this.getNext().execute_(frameValue, moduleValue, nameValue, inheritValue);
                }

                static BaseNode_ create(ConstGetNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ModuleNodes.ConstGetNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ConstGetNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object moduleValue, Object nameValue, Object inheritValue) {
                    return this.uninitialized((Frame)frameValue, moduleValue, nameValue, inheritValue);
                }

                static BaseNode_ create(ConstGetNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ModuleNodes.ConstGetNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected ConstGetNodeGen root;

                BaseNode_(ConstGetNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (ConstGetNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.module_, this.root.name_, this.root.inherit_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object moduleValue, Object nameValue, Object inheritValue) {
                    return this.execute_((VirtualFrame)frameValue, moduleValue, nameValue, inheritValue);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3, Object var4);

                public Object execute(VirtualFrame frameValue) {
                    Object moduleValue_ = this.root.module_.execute(frameValue);
                    Object nameValue_ = this.root.name_.execute(frameValue);
                    Object inheritValue_ = this.executeInherit_(frameValue);
                    return this.execute_(frameValue, moduleValue_, nameValue_, inheritValue_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object moduleValue, Object nameValue, Object inheritValue) {
                    if (moduleValue instanceof DynamicObject && nameValue instanceof DynamicObject && inheritValue instanceof Boolean) {
                        DynamicObject nameValue_ = (DynamicObject)nameValue;
                        boolean inheritValue_ = (Boolean)inheritValue;
                        if (inheritValue_ && RubyGuards.isRubySymbol(nameValue_)) {
                            return GetConstantNode_.create(this.root);
                        }
                        if (!inheritValue_ && RubyGuards.isRubySymbol(nameValue_)) {
                            return GetConstantNoInheritNode_.create(this.root);
                        }
                        if (inheritValue_ && RubyGuards.isRubyString(nameValue_) && !this.root.isScoped(nameValue_)) {
                            return GetConstantStringNode_.create(this.root);
                        }
                        if (!inheritValue_ && RubyGuards.isRubyString(nameValue_) && !this.root.isScoped(nameValue_)) {
                            return GetConstantNoInheritStringNode_.create(this.root);
                        }
                        if (RubyGuards.isRubyString(nameValue_) && this.root.isScoped(nameValue_)) {
                            return GetConstantScopedNode_.create(this.root);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeInherit_(Frame frameValue) {
                    Object object;
                    Class inheritType_ = this.root.inheritType_;
                    if (inheritType_ == Boolean.TYPE) {
                        return this.root.inherit_.executeBoolean((VirtualFrame)frameValue);
                    }
                    if (inheritType_ != null) return this.root.inherit_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.inherit_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Boolean ? Boolean.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.inheritType_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.inheritType_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.inheritType_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.ConstDefinedNode.class)
    public static final class ConstDefinedNodeFactory
    extends NodeFactoryBase<ModuleNodes.ConstDefinedNode> {
        private static ConstDefinedNodeFactory constDefinedNodeFactoryInstance;

        private ConstDefinedNodeFactory() {
            super(ModuleNodes.ConstDefinedNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class, RubyNode.class}});
        }

        @Override
        public ModuleNodes.ConstDefinedNode createNode(Object ... arguments) {
            if (!(arguments.length != 5 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode) || arguments[4] != null && !(arguments[4] instanceof RubyNode))) {
                return ConstDefinedNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode)arguments[2], (RubyNode)arguments[3], (RubyNode)arguments[4]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ModuleNodes.ConstDefinedNode> getInstance() {
            if (constDefinedNodeFactoryInstance == null) {
                constDefinedNodeFactoryInstance = new ConstDefinedNodeFactory();
            }
            return constDefinedNodeFactoryInstance;
        }

        public static ModuleNodes.ConstDefinedNode create(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name, RubyNode inherit) {
            return new ConstDefinedNodeGen(context, sourceSection, module, name, inherit);
        }

        @GeneratedBy(value=ModuleNodes.ConstDefinedNode.class)
        public static final class ConstDefinedNodeGen
        extends ModuleNodes.ConstDefinedNode {
            @Node.Child
            private RubyNode module_;
            @Node.Child
            private RubyNode name_;
            @Node.Child
            private RubyNode inherit_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private ConstDefinedNodeGen(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name, RubyNode inherit) {
                super(context, sourceSection);
                this.module_ = module;
                this.name_ = this.coerceToString(name);
                this.inherit_ = this.coerceToBoolean(inherit);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeBoolean(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeBoolean(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                boolean inheritValue_;
                String nameValue_;
                DynamicObject moduleValue_;
                try {
                    moduleValue_ = this.module_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object nameValue = this.name_.execute(frameValue);
                    Object inheritValue = this.inherit_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), nameValue, inheritValue);
                }
                try {
                    nameValue_ = ConstDefinedNodeGen.expectString(this.name_.execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object inheritValue = this.inherit_.execute(frameValue);
                    throw this.unsupported(moduleValue_, ex.getResult(), inheritValue);
                }
                try {
                    inheritValue_ = this.inherit_.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(moduleValue_, nameValue_, ex.getResult());
                }
                return this.isConstDefined(moduleValue_, nameValue_, inheritValue_);
            }

            private UnsupportedSpecializationException unsupported(Object moduleValue, Object nameValue, Object inheritValue) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.module_, this.name_, this.inherit_}, moduleValue, nameValue, inheritValue);
            }

            private static String expectString(Object value) throws UnexpectedResultException {
                if (value instanceof String) {
                    return (String)value;
                }
                throw new UnexpectedResultException(value);
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.ConstantsNode.class)
    public static final class ConstantsNodeFactory
    extends NodeFactoryBase<ModuleNodes.ConstantsNode> {
        private static ConstantsNodeFactory constantsNodeFactoryInstance;

        private ConstantsNodeFactory() {
            super(ModuleNodes.ConstantsNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class}});
        }

        @Override
        public ModuleNodes.ConstantsNode createNode(Object ... arguments) {
            if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
                return ConstantsNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode)arguments[2], (RubyNode)arguments[3]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ModuleNodes.ConstantsNode> getInstance() {
            if (constantsNodeFactoryInstance == null) {
                constantsNodeFactoryInstance = new ConstantsNodeFactory();
            }
            return constantsNodeFactoryInstance;
        }

        public static ModuleNodes.ConstantsNode create(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode inherit) {
            return new ConstantsNodeGen(context, sourceSection, module, inherit);
        }

        @GeneratedBy(value=ModuleNodes.ConstantsNode.class)
        public static final class ConstantsNodeGen
        extends ModuleNodes.ConstantsNode {
            @Node.Child
            private RubyNode module_;
            @Node.Child
            private RubyNode inherit_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private ConstantsNodeGen(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode inherit) {
                super(context, sourceSection);
                this.module_ = module;
                this.inherit_ = this.coerceToBoolean(inherit);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeDynamicObject(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeDynamicObject(frameValue);
            }

            @Override
            public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
                boolean inheritValue_;
                DynamicObject moduleValue_;
                try {
                    moduleValue_ = this.module_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object inheritValue = this.inherit_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), inheritValue);
                }
                try {
                    inheritValue_ = this.inherit_.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(moduleValue_, ex.getResult());
                }
                return this.constants(moduleValue_, inheritValue_);
            }

            private UnsupportedSpecializationException unsupported(Object moduleValue, Object inheritValue) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.module_, this.inherit_}, moduleValue, inheritValue);
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.ClassVariablesNode.class)
    public static final class ClassVariablesNodeFactory
    extends NodeFactoryBase<ModuleNodes.ClassVariablesNode> {
        private static ClassVariablesNodeFactory classVariablesNodeFactoryInstance;

        private ClassVariablesNodeFactory() {
            super(ModuleNodes.ClassVariablesNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ModuleNodes.ClassVariablesNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ClassVariablesNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ModuleNodes.ClassVariablesNode> getInstance() {
            if (classVariablesNodeFactoryInstance == null) {
                classVariablesNodeFactoryInstance = new ClassVariablesNodeFactory();
            }
            return classVariablesNodeFactoryInstance;
        }

        public static ModuleNodes.ClassVariablesNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new ClassVariablesNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ModuleNodes.ClassVariablesNode.class)
        public static final class ClassVariablesNodeGen
        extends ModuleNodes.ClassVariablesNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private ClassVariablesNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.getClassVariables(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_}, arguments0Value);
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.ClassVariableSetNode.class)
    public static final class ClassVariableSetNodeFactory
    extends NodeFactoryBase<ModuleNodes.ClassVariableSetNode> {
        private static ClassVariableSetNodeFactory classVariableSetNodeFactoryInstance;

        private ClassVariableSetNodeFactory() {
            super(ModuleNodes.ClassVariableSetNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class, RubyNode.class}});
        }

        @Override
        public ModuleNodes.ClassVariableSetNode createNode(Object ... arguments) {
            if (!(arguments.length != 5 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode) || arguments[4] != null && !(arguments[4] instanceof RubyNode))) {
                return ClassVariableSetNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode)arguments[2], (RubyNode)arguments[3], (RubyNode)arguments[4]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ModuleNodes.ClassVariableSetNode> getInstance() {
            if (classVariableSetNodeFactoryInstance == null) {
                classVariableSetNodeFactoryInstance = new ClassVariableSetNodeFactory();
            }
            return classVariableSetNodeFactoryInstance;
        }

        public static ModuleNodes.ClassVariableSetNode create(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name, RubyNode value) {
            return new ClassVariableSetNodeGen(context, sourceSection, module, name, value);
        }

        @GeneratedBy(value=ModuleNodes.ClassVariableSetNode.class)
        public static final class ClassVariableSetNodeGen
        extends ModuleNodes.ClassVariableSetNode {
            @Node.Child
            private RubyNode module_;
            @Node.Child
            private RubyNode name_;
            @Node.Child
            private RubyNode value_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private ClassVariableSetNodeGen(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name, RubyNode value) {
                super(context, sourceSection);
                this.module_ = module;
                this.name_ = this.coerceToString(name);
                this.value_ = value;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                String nameValue_;
                DynamicObject moduleValue_;
                try {
                    moduleValue_ = this.module_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object nameValue = this.name_.execute(frameValue);
                    Object valueValue = this.value_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), nameValue, valueValue);
                }
                try {
                    nameValue_ = ClassVariableSetNodeGen.expectString(this.name_.execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object valueValue = this.value_.execute(frameValue);
                    throw this.unsupported(moduleValue_, ex.getResult(), valueValue);
                }
                Object valueValue_ = this.value_.execute(frameValue);
                return this.setClassVariable(moduleValue_, nameValue_, valueValue_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object moduleValue, Object nameValue, Object valueValue) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.module_, this.name_, this.value_}, moduleValue, nameValue, valueValue);
            }

            private static String expectString(Object value) throws UnexpectedResultException {
                if (value instanceof String) {
                    return (String)value;
                }
                throw new UnexpectedResultException(value);
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.ClassVariableGetNode.class)
    public static final class ClassVariableGetNodeFactory
    extends NodeFactoryBase<ModuleNodes.ClassVariableGetNode> {
        private static ClassVariableGetNodeFactory classVariableGetNodeFactoryInstance;

        private ClassVariableGetNodeFactory() {
            super(ModuleNodes.ClassVariableGetNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class}});
        }

        @Override
        public ModuleNodes.ClassVariableGetNode createNode(Object ... arguments) {
            if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
                return ClassVariableGetNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode)arguments[2], (RubyNode)arguments[3]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ModuleNodes.ClassVariableGetNode> getInstance() {
            if (classVariableGetNodeFactoryInstance == null) {
                classVariableGetNodeFactoryInstance = new ClassVariableGetNodeFactory();
            }
            return classVariableGetNodeFactoryInstance;
        }

        public static ModuleNodes.ClassVariableGetNode create(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name) {
            return new ClassVariableGetNodeGen(context, sourceSection, module, name);
        }

        @GeneratedBy(value=ModuleNodes.ClassVariableGetNode.class)
        public static final class ClassVariableGetNodeGen
        extends ModuleNodes.ClassVariableGetNode {
            @Node.Child
            private RubyNode module_;
            @Node.Child
            private RubyNode name_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private ClassVariableGetNodeGen(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name) {
                super(context, sourceSection);
                this.module_ = module;
                this.name_ = this.coerceToString(name);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                String nameValue_;
                DynamicObject moduleValue_;
                try {
                    moduleValue_ = this.module_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object nameValue = this.name_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), nameValue);
                }
                try {
                    nameValue_ = ClassVariableGetNodeGen.expectString(this.name_.execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(moduleValue_, ex.getResult());
                }
                return this.getClassVariable(moduleValue_, nameValue_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object moduleValue, Object nameValue) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.module_, this.name_}, moduleValue, nameValue);
            }

            private static String expectString(Object value) throws UnexpectedResultException {
                if (value instanceof String) {
                    return (String)value;
                }
                throw new UnexpectedResultException(value);
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.ClassVariableDefinedNode.class)
    public static final class ClassVariableDefinedNodeFactory
    extends NodeFactoryBase<ModuleNodes.ClassVariableDefinedNode> {
        private static ClassVariableDefinedNodeFactory classVariableDefinedNodeFactoryInstance;

        private ClassVariableDefinedNodeFactory() {
            super(ModuleNodes.ClassVariableDefinedNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class}});
        }

        @Override
        public ModuleNodes.ClassVariableDefinedNode createNode(Object ... arguments) {
            if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
                return ClassVariableDefinedNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode)arguments[2], (RubyNode)arguments[3]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ModuleNodes.ClassVariableDefinedNode> getInstance() {
            if (classVariableDefinedNodeFactoryInstance == null) {
                classVariableDefinedNodeFactoryInstance = new ClassVariableDefinedNodeFactory();
            }
            return classVariableDefinedNodeFactoryInstance;
        }

        public static ModuleNodes.ClassVariableDefinedNode create(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name) {
            return new ClassVariableDefinedNodeGen(context, sourceSection, module, name);
        }

        @GeneratedBy(value=ModuleNodes.ClassVariableDefinedNode.class)
        public static final class ClassVariableDefinedNodeGen
        extends ModuleNodes.ClassVariableDefinedNode {
            @Node.Child
            private RubyNode module_;
            @Node.Child
            private RubyNode name_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private ClassVariableDefinedNodeGen(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name) {
                super(context, sourceSection);
                this.module_ = module;
                this.name_ = this.coerceToString(name);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeBoolean(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeBoolean(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                String nameValue_;
                DynamicObject moduleValue_;
                try {
                    moduleValue_ = this.module_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object nameValue = this.name_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), nameValue);
                }
                try {
                    nameValue_ = ClassVariableDefinedNodeGen.expectString(this.name_.execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(moduleValue_, ex.getResult());
                }
                return this.isClassVariableDefinedString(moduleValue_, nameValue_);
            }

            private UnsupportedSpecializationException unsupported(Object moduleValue, Object nameValue) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.module_, this.name_}, moduleValue, nameValue);
            }

            private static String expectString(Object value) throws UnexpectedResultException {
                if (value instanceof String) {
                    return (String)value;
                }
                throw new UnexpectedResultException(value);
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.ClassExecNode.class)
    public static final class ClassExecNodeFactory
    extends NodeFactoryBase<ModuleNodes.ClassExecNode> {
        private static ClassExecNodeFactory classExecNodeFactoryInstance;

        private ClassExecNodeFactory() {
            super(ModuleNodes.ClassExecNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ModuleNodes.ClassExecNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ClassExecNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ModuleNodes.ClassExecNode> getInstance() {
            if (classExecNodeFactoryInstance == null) {
                classExecNodeFactoryInstance = new ClassExecNodeFactory();
            }
            return classExecNodeFactoryInstance;
        }

        public static ModuleNodes.ClassExecNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new ClassExecNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ModuleNodes.ClassExecNode.class)
        public static final class ClassExecNodeGen
        extends ModuleNodes.ClassExecNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private RubyNode arguments2_;
            @Node.Child
            private BaseNode_ specialization_;

            private ClassExecNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object executeClassExec(VirtualFrame frameValue, DynamicObject arguments0Value, Object[] arguments1Value, DynamicObject arguments2Value) {
                return this.specialization_.execute1(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute0(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="classExec(VirtualFrame, DynamicObject, Object[], NotProvided)", value=ModuleNodes.ClassExecNode.class)
            private static final class ClassExec1Node_
            extends BaseNode_ {
                ClassExec1Node_(ClassExecNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof Object[] && arguments2Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        Object[] arguments1Value_ = (Object[])arguments1Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        return this.root.classExec(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(ClassExecNodeGen root) {
                    return new ClassExec1Node_(root);
                }
            }

            @GeneratedBy(methodName="classExec(VirtualFrame, DynamicObject, Object[], DynamicObject)", value=ModuleNodes.ClassExecNode.class)
            private static final class ClassExec0Node_
            extends BaseNode_ {
                ClassExec0Node_(ClassExecNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute1(VirtualFrame frameValue, DynamicObject arguments0Value, Object[] arguments1Value, DynamicObject arguments2Value) {
                    return this.root.classExec(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof Object[] && arguments2Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        Object[] arguments1Value_ = (Object[])arguments1Value;
                        DynamicObject arguments2Value_ = (DynamicObject)arguments2Value;
                        return this.root.classExec(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(ClassExecNodeGen root) {
                    return new ClassExec0Node_(root);
                }
            }

            @GeneratedBy(value=ModuleNodes.ClassExecNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ClassExecNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value, arguments2Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(ClassExecNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ModuleNodes.ClassExecNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ClassExecNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(ClassExecNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ModuleNodes.ClassExecNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected ClassExecNodeGen root;

                BaseNode_(ClassExecNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (ClassExecNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_, this.root.arguments2_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3, Object var4);

                public Object execute1(VirtualFrame frameValue, DynamicObject arguments0Value, Object[] arguments1Value, DynamicObject arguments2Value) {
                    return this.execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                public Object execute0(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    Object arguments2Value_ = this.root.arguments2_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute0(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof Object[]) {
                        if (arguments2Value instanceof DynamicObject) {
                            return ClassExec0Node_.create(this.root);
                        }
                        if (arguments2Value instanceof NotProvided) {
                            return ClassExec1Node_.create(this.root);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.ClassEvalNode.class)
    public static final class ClassEvalNodeFactory
    extends NodeFactoryBase<ModuleNodes.ClassEvalNode> {
        private static ClassEvalNodeFactory classEvalNodeFactoryInstance;

        private ClassEvalNodeFactory() {
            super(ModuleNodes.ClassEvalNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class, RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ModuleNodes.ClassEvalNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ClassEvalNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ModuleNodes.ClassEvalNode> getInstance() {
            if (classEvalNodeFactoryInstance == null) {
                classEvalNodeFactoryInstance = new ClassEvalNodeFactory();
            }
            return classEvalNodeFactoryInstance;
        }

        public static ModuleNodes.ClassEvalNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new ClassEvalNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ModuleNodes.ClassEvalNode.class)
        public static final class ClassEvalNodeGen
        extends ModuleNodes.ClassEvalNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private RubyNode arguments2_;
            @Node.Child
            private RubyNode arguments3_;
            @Node.Child
            private RubyNode arguments4_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments3Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private ClassEvalNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
                this.arguments3_ = arguments != null && 3 < arguments.length ? arguments[3] : null;
                this.arguments4_ = arguments != null && 4 < arguments.length ? arguments[4] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="classEval(DynamicObject, Object, NotProvided, NotProvided, DynamicObject)", value=ModuleNodes.ClassEvalNode.class)
            private static final class ClassEval7Node_
            extends BaseNode_ {
                ClassEval7Node_(ClassEvalNodeGen root) {
                    super(root, 8);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value, Object arguments4Value) {
                    if (arguments0Value instanceof DynamicObject && arguments2Value instanceof NotProvided && arguments3Value instanceof NotProvided && arguments4Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        NotProvided arguments3Value_ = (NotProvided)arguments3Value;
                        DynamicObject arguments4Value_ = (DynamicObject)arguments4Value;
                        if (RubyGuards.wasProvided(arguments1Value)) {
                            return this.root.classEval(arguments0Value_, arguments1Value, arguments2Value_, arguments3Value_, arguments4Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, arguments4Value);
                }

                static BaseNode_ create(ClassEvalNodeGen root) {
                    return new ClassEval7Node_(root);
                }
            }

            @GeneratedBy(methodName="classEval(DynamicObject, NotProvided, NotProvided, NotProvided, NotProvided)", value=ModuleNodes.ClassEvalNode.class)
            private static final class ClassEval6Node_
            extends BaseNode_ {
                ClassEval6Node_(ClassEvalNodeGen root) {
                    super(root, 7);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value, Object arguments4Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof NotProvided && arguments2Value instanceof NotProvided && arguments3Value instanceof NotProvided && arguments4Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        NotProvided arguments3Value_ = (NotProvided)arguments3Value;
                        NotProvided arguments4Value_ = (NotProvided)arguments4Value;
                        return this.root.classEval(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_, arguments4Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, arguments4Value);
                }

                static BaseNode_ create(ClassEvalNodeGen root) {
                    return new ClassEval6Node_(root);
                }
            }

            @GeneratedBy(methodName="classEval(VirtualFrame, DynamicObject, NotProvided, NotProvided, NotProvided, DynamicObject)", value=ModuleNodes.ClassEvalNode.class)
            private static final class ClassEval5Node_
            extends BaseNode_ {
                ClassEval5Node_(ClassEvalNodeGen root) {
                    super(root, 6);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value, Object arguments4Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof NotProvided && arguments2Value instanceof NotProvided && arguments3Value instanceof NotProvided && arguments4Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        NotProvided arguments3Value_ = (NotProvided)arguments3Value;
                        DynamicObject arguments4Value_ = (DynamicObject)arguments4Value;
                        return this.root.classEval(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_, arguments4Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, arguments4Value);
                }

                static BaseNode_ create(ClassEvalNodeGen root) {
                    return new ClassEval5Node_(root);
                }
            }

            @GeneratedBy(methodName="classEval(VirtualFrame, DynamicObject, DynamicObject, Object, NotProvided, NotProvided)", value=ModuleNodes.ClassEvalNode.class)
            private static final class ClassEval4Node_
            extends BaseNode_ {
                ClassEval4Node_(ClassEvalNodeGen root) {
                    super(root, 5);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value, Object arguments4Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject && arguments3Value instanceof NotProvided && arguments4Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        NotProvided arguments3Value_ = (NotProvided)arguments3Value;
                        NotProvided arguments4Value_ = (NotProvided)arguments4Value;
                        if (RubyGuards.isRubyString(arguments1Value_) && RubyGuards.wasProvided(arguments2Value)) {
                            return this.root.classEval(frameValue, arguments0Value_, arguments1Value_, arguments2Value, arguments3Value_, arguments4Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, arguments4Value);
                }

                static BaseNode_ create(ClassEvalNodeGen root) {
                    return new ClassEval4Node_(root);
                }
            }

            @GeneratedBy(methodName="classEval(VirtualFrame, DynamicObject, Object, NotProvided, NotProvided, NotProvided)", value=ModuleNodes.ClassEvalNode.class)
            private static final class ClassEval3Node_
            extends BaseNode_ {
                ClassEval3Node_(ClassEvalNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value, Object arguments4Value) {
                    if (arguments0Value instanceof DynamicObject && arguments2Value instanceof NotProvided && arguments3Value instanceof NotProvided && arguments4Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        NotProvided arguments3Value_ = (NotProvided)arguments3Value;
                        NotProvided arguments4Value_ = (NotProvided)arguments4Value;
                        if (RubyGuards.wasProvided(arguments1Value)) {
                            return this.root.classEval(frameValue, arguments0Value_, arguments1Value, arguments2Value_, arguments3Value_, arguments4Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, arguments4Value);
                }

                static BaseNode_ create(ClassEvalNodeGen root) {
                    return new ClassEval3Node_(root);
                }
            }

            @GeneratedBy(methodName="classEval(DynamicObject, DynamicObject, DynamicObject, int, NotProvided)", value=ModuleNodes.ClassEvalNode.class)
            private static final class ClassEval2Node_
            extends BaseNode_ {
                private final Class<?> arguments3ImplicitType;

                ClassEval2Node_(ClassEvalNodeGen root, Object arguments3Value) {
                    super(root, 3);
                    this.arguments3ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments3Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments3ImplicitType == ((ClassEval2Node_)other).arguments3ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    NotProvided arguments4Value_;
                    int arguments3Value_;
                    DynamicObject arguments2Value_;
                    DynamicObject arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.root.arguments1_.execute(frameValue);
                        Object arguments2Value = this.root.arguments2_.execute(frameValue);
                        Object arguments3Value = this.executeArguments3_(frameValue);
                        Object arguments4Value = this.root.arguments4_.execute(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value, arguments2Value, arguments3Value, arguments4Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.root.arguments2_.execute(frameValue);
                        Object arguments3Value = this.executeArguments3_(frameValue);
                        Object arguments4Value = this.root.arguments4_.execute(frameValue);
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult(), arguments2Value, arguments3Value, arguments4Value);
                    }
                    try {
                        arguments2Value_ = this.root.arguments2_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments3Value = this.executeArguments3_(frameValue);
                        Object arguments4Value = this.root.arguments4_.execute(frameValue);
                        return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, ex.getResult(), arguments3Value, arguments4Value);
                    }
                    try {
                        if (this.arguments3ImplicitType == Integer.TYPE) {
                            arguments3Value_ = this.root.arguments3_.executeInteger(frameValue);
                        } else {
                            Object arguments3Value__ = this.executeArguments3_(frameValue);
                            arguments3Value_ = RubyTypesGen.expectImplicitInteger(arguments3Value__, this.arguments3ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments4Value = this.root.arguments4_.execute(frameValue);
                        return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, ex.getResult(), arguments4Value);
                    }
                    try {
                        arguments4Value_ = this.root.arguments4_.executeNotProvided(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyString(arguments1Value_) && RubyGuards.isRubyString(arguments2Value_)) {
                        return this.root.classEval(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_, arguments4Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_, arguments4Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value, Object arguments4Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject && arguments2Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments3Value, this.arguments3ImplicitType) && arguments4Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        DynamicObject arguments2Value_ = (DynamicObject)arguments2Value;
                        int arguments3Value_ = RubyTypesGen.asImplicitInteger(arguments3Value, this.arguments3ImplicitType);
                        NotProvided arguments4Value_ = (NotProvided)arguments4Value;
                        if (RubyGuards.isRubyString(arguments1Value_) && RubyGuards.isRubyString(arguments2Value_)) {
                            return this.root.classEval(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_, arguments4Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, arguments4Value);
                }

                static BaseNode_ create(ClassEvalNodeGen root, Object arguments3Value) {
                    return new ClassEval2Node_(root, arguments3Value);
                }
            }

            @GeneratedBy(methodName="classEval(DynamicObject, DynamicObject, DynamicObject, NotProvided, NotProvided)", value=ModuleNodes.ClassEvalNode.class)
            private static final class ClassEval1Node_
            extends BaseNode_ {
                ClassEval1Node_(ClassEvalNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value, Object arguments4Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject && arguments2Value instanceof DynamicObject && arguments3Value instanceof NotProvided && arguments4Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        DynamicObject arguments2Value_ = (DynamicObject)arguments2Value;
                        NotProvided arguments3Value_ = (NotProvided)arguments3Value;
                        NotProvided arguments4Value_ = (NotProvided)arguments4Value;
                        if (RubyGuards.isRubyString(arguments1Value_) && RubyGuards.isRubyString(arguments2Value_)) {
                            return this.root.classEval(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_, arguments4Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, arguments4Value);
                }

                static BaseNode_ create(ClassEvalNodeGen root) {
                    return new ClassEval1Node_(root);
                }
            }

            @GeneratedBy(methodName="classEval(DynamicObject, DynamicObject, NotProvided, NotProvided, NotProvided)", value=ModuleNodes.ClassEvalNode.class)
            private static final class ClassEval0Node_
            extends BaseNode_ {
                ClassEval0Node_(ClassEvalNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value, Object arguments4Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject && arguments2Value instanceof NotProvided && arguments3Value instanceof NotProvided && arguments4Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        NotProvided arguments3Value_ = (NotProvided)arguments3Value;
                        NotProvided arguments4Value_ = (NotProvided)arguments4Value;
                        if (RubyGuards.isRubyString(arguments1Value_)) {
                            return this.root.classEval(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_, arguments4Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, arguments4Value);
                }

                static BaseNode_ create(ClassEvalNodeGen root) {
                    return new ClassEval0Node_(root);
                }
            }

            @GeneratedBy(value=ModuleNodes.ClassEvalNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ClassEvalNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value, Object arguments4Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, arguments4Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value, Object arguments4Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, arguments4Value);
                }

                static BaseNode_ create(ClassEvalNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ModuleNodes.ClassEvalNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ClassEvalNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value, Object arguments4Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, arguments4Value);
                }

                static BaseNode_ create(ClassEvalNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ModuleNodes.ClassEvalNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected ClassEvalNodeGen root;

                BaseNode_(ClassEvalNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (ClassEvalNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_, this.root.arguments2_, this.root.arguments3_, this.root.arguments4_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value, Object arguments4Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, arguments4Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3, Object var4, Object var5, Object var6);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    Object arguments2Value_ = this.root.arguments2_.execute(frameValue);
                    Object arguments3Value_ = this.executeArguments3_(frameValue);
                    Object arguments4Value_ = this.root.arguments4_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_, arguments4Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value, Object arguments4Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        if (arguments4Value instanceof NotProvided) {
                            DynamicObject arguments1Value_;
                            if (arguments1Value instanceof DynamicObject) {
                                DynamicObject arguments2Value_;
                                arguments1Value_ = (DynamicObject)arguments1Value;
                                if (arguments3Value instanceof NotProvided) {
                                    if (arguments2Value instanceof NotProvided && RubyGuards.isRubyString(arguments1Value_)) {
                                        return ClassEval0Node_.create(this.root);
                                    }
                                    if (arguments2Value instanceof DynamicObject) {
                                        arguments2Value_ = (DynamicObject)arguments2Value;
                                        if (RubyGuards.isRubyString(arguments1Value_) && RubyGuards.isRubyString(arguments2Value_)) {
                                            return ClassEval1Node_.create(this.root);
                                        }
                                    }
                                }
                                if (arguments2Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments3Value)) {
                                    arguments2Value_ = (DynamicObject)arguments2Value;
                                    if (RubyGuards.isRubyString(arguments1Value_) && RubyGuards.isRubyString(arguments2Value_)) {
                                        return ClassEval2Node_.create(this.root, arguments3Value);
                                    }
                                }
                            }
                            if (arguments3Value instanceof NotProvided) {
                                if (arguments2Value instanceof NotProvided && RubyGuards.wasProvided(arguments1Value)) {
                                    return ClassEval3Node_.create(this.root);
                                }
                                if (arguments1Value instanceof DynamicObject && RubyGuards.isRubyString(arguments1Value_ = (DynamicObject)arguments1Value) && RubyGuards.wasProvided(arguments2Value)) {
                                    return ClassEval4Node_.create(this.root);
                                }
                            }
                        }
                        if (arguments2Value instanceof NotProvided && arguments3Value instanceof NotProvided) {
                            if (arguments1Value instanceof NotProvided) {
                                if (arguments4Value instanceof DynamicObject) {
                                    return ClassEval5Node_.create(this.root);
                                }
                                if (arguments4Value instanceof NotProvided) {
                                    return ClassEval6Node_.create(this.root);
                                }
                            }
                            if (arguments4Value instanceof DynamicObject && RubyGuards.wasProvided(arguments1Value)) {
                                return ClassEval7Node_.create(this.root);
                            }
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments3_(Frame frameValue) {
                    Object object;
                    Class arguments3Type_ = this.root.arguments3Type_;
                    if (arguments3Type_ == Integer.TYPE) {
                        return this.root.arguments3_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments3Type_ != null) return this.root.arguments3_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments3_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments3Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments3Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments3Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.AutoloadQueryNode.class)
    public static final class AutoloadQueryNodeFactory
    extends NodeFactoryBase<ModuleNodes.AutoloadQueryNode> {
        private static AutoloadQueryNodeFactory autoloadQueryNodeFactoryInstance;

        private AutoloadQueryNodeFactory() {
            super(ModuleNodes.AutoloadQueryNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ModuleNodes.AutoloadQueryNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return AutoloadQueryNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ModuleNodes.AutoloadQueryNode> getInstance() {
            if (autoloadQueryNodeFactoryInstance == null) {
                autoloadQueryNodeFactoryInstance = new AutoloadQueryNodeFactory();
            }
            return autoloadQueryNodeFactoryInstance;
        }

        public static ModuleNodes.AutoloadQueryNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new AutoloadQueryNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ModuleNodes.AutoloadQueryNode.class)
        public static final class AutoloadQueryNodeGen
        extends ModuleNodes.AutoloadQueryNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private BaseNode_ specialization_;

            private AutoloadQueryNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="autoloadQueryString(DynamicObject, DynamicObject)", value=ModuleNodes.AutoloadQueryNode.class)
            private static final class AutoloadQueryStringNode_
            extends BaseNode_ {
                AutoloadQueryStringNode_(AutoloadQueryNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubyString(arguments1Value_)) {
                            return this.root.autoloadQueryString(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(AutoloadQueryNodeGen root) {
                    return new AutoloadQueryStringNode_(root);
                }
            }

            @GeneratedBy(methodName="autoloadQuerySymbol(DynamicObject, DynamicObject)", value=ModuleNodes.AutoloadQueryNode.class)
            private static final class AutoloadQuerySymbolNode_
            extends BaseNode_ {
                AutoloadQuerySymbolNode_(AutoloadQueryNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubySymbol(arguments1Value_)) {
                            return this.root.autoloadQuerySymbol(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(AutoloadQueryNodeGen root) {
                    return new AutoloadQuerySymbolNode_(root);
                }
            }

            @GeneratedBy(value=ModuleNodes.AutoloadQueryNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(AutoloadQueryNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(AutoloadQueryNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ModuleNodes.AutoloadQueryNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(AutoloadQueryNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(AutoloadQueryNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ModuleNodes.AutoloadQueryNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected AutoloadQueryNodeGen root;

                BaseNode_(AutoloadQueryNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (AutoloadQueryNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubySymbol(arguments1Value_)) {
                            return AutoloadQuerySymbolNode_.create(this.root);
                        }
                        if (RubyGuards.isRubyString(arguments1Value_)) {
                            return AutoloadQueryStringNode_.create(this.root);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.AutoloadNode.class)
    public static final class AutoloadNodeFactory
    extends NodeFactoryBase<ModuleNodes.AutoloadNode> {
        private static AutoloadNodeFactory autoloadNodeFactoryInstance;

        private AutoloadNodeFactory() {
            super(ModuleNodes.AutoloadNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class, RubyNode.class}});
        }

        @Override
        public ModuleNodes.AutoloadNode createNode(Object ... arguments) {
            if (!(arguments.length != 5 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode) || arguments[4] != null && !(arguments[4] instanceof RubyNode))) {
                return AutoloadNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode)arguments[2], (RubyNode)arguments[3], (RubyNode)arguments[4]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ModuleNodes.AutoloadNode> getInstance() {
            if (autoloadNodeFactoryInstance == null) {
                autoloadNodeFactoryInstance = new AutoloadNodeFactory();
            }
            return autoloadNodeFactoryInstance;
        }

        public static ModuleNodes.AutoloadNode create(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name, RubyNode filename) {
            return new AutoloadNodeGen(context, sourceSection, module, name, filename);
        }

        @GeneratedBy(value=ModuleNodes.AutoloadNode.class)
        public static final class AutoloadNodeGen
        extends ModuleNodes.AutoloadNode {
            @Node.Child
            private RubyNode module_;
            @Node.Child
            private RubyNode name_;
            @Node.Child
            private RubyNode filename_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private AutoloadNodeGen(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name, RubyNode filename) {
                super(context, sourceSection);
                this.module_ = module;
                this.name_ = this.coerceNameToString(name);
                this.filename_ = this.coerceFilenameToPath(filename);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject filenameValue_;
                String nameValue_;
                DynamicObject moduleValue_;
                try {
                    moduleValue_ = this.module_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object nameValue = this.name_.execute(frameValue);
                    Object filenameValue = this.filename_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), nameValue, filenameValue);
                }
                try {
                    nameValue_ = AutoloadNodeGen.expectString(this.name_.execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object filenameValue = this.filename_.execute(frameValue);
                    throw this.unsupported(moduleValue_, ex.getResult(), filenameValue);
                }
                try {
                    filenameValue_ = this.filename_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(moduleValue_, nameValue_, ex.getResult());
                }
                if (RubyGuards.isRubyString(filenameValue_)) {
                    return this.autoload(moduleValue_, nameValue_, filenameValue_);
                }
                throw this.unsupported(moduleValue_, nameValue_, filenameValue_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object moduleValue, Object nameValue, Object filenameValue) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.module_, this.name_, this.filename_}, moduleValue, nameValue, filenameValue);
            }

            private static String expectString(Object value) throws UnexpectedResultException {
                if (value instanceof String) {
                    return (String)value;
                }
                throw new UnexpectedResultException(value);
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.AttrWriterNode.class)
    public static final class AttrWriterNodeFactory
    extends NodeFactoryBase<ModuleNodes.AttrWriterNode> {
        private static AttrWriterNodeFactory attrWriterNodeFactoryInstance;

        private AttrWriterNodeFactory() {
            super(ModuleNodes.AttrWriterNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ModuleNodes.AttrWriterNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return AttrWriterNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ModuleNodes.AttrWriterNode> getInstance() {
            if (attrWriterNodeFactoryInstance == null) {
                attrWriterNodeFactoryInstance = new AttrWriterNodeFactory();
            }
            return attrWriterNodeFactoryInstance;
        }

        public static ModuleNodes.AttrWriterNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new AttrWriterNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ModuleNodes.AttrWriterNode.class)
        public static final class AttrWriterNodeGen
        extends ModuleNodes.AttrWriterNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private AttrWriterNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object[] arguments1Value_;
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments1_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), arguments1Value);
                }
                try {
                    arguments1Value_ = this.arguments1_.executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(arguments0Value_, ex.getResult());
                }
                return this.attrWriter(frameValue, arguments0Value_, arguments1Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value, Object arguments1Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_, this.arguments1_}, arguments0Value, arguments1Value);
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.AttrReaderNode.class)
    public static final class AttrReaderNodeFactory
    extends NodeFactoryBase<ModuleNodes.AttrReaderNode> {
        private static AttrReaderNodeFactory attrReaderNodeFactoryInstance;

        private AttrReaderNodeFactory() {
            super(ModuleNodes.AttrReaderNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ModuleNodes.AttrReaderNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return AttrReaderNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ModuleNodes.AttrReaderNode> getInstance() {
            if (attrReaderNodeFactoryInstance == null) {
                attrReaderNodeFactoryInstance = new AttrReaderNodeFactory();
            }
            return attrReaderNodeFactoryInstance;
        }

        public static ModuleNodes.AttrReaderNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new AttrReaderNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ModuleNodes.AttrReaderNode.class)
        public static final class AttrReaderNodeGen
        extends ModuleNodes.AttrReaderNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private AttrReaderNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object[] arguments1Value_;
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments1_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), arguments1Value);
                }
                try {
                    arguments1Value_ = this.arguments1_.executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(arguments0Value_, ex.getResult());
                }
                return this.attrReader(frameValue, arguments0Value_, arguments1Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value, Object arguments1Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_, this.arguments1_}, arguments0Value, arguments1Value);
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.AttrAccessorNode.class)
    public static final class AttrAccessorNodeFactory
    extends NodeFactoryBase<ModuleNodes.AttrAccessorNode> {
        private static AttrAccessorNodeFactory attrAccessorNodeFactoryInstance;

        private AttrAccessorNodeFactory() {
            super(ModuleNodes.AttrAccessorNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ModuleNodes.AttrAccessorNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return AttrAccessorNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ModuleNodes.AttrAccessorNode> getInstance() {
            if (attrAccessorNodeFactoryInstance == null) {
                attrAccessorNodeFactoryInstance = new AttrAccessorNodeFactory();
            }
            return attrAccessorNodeFactoryInstance;
        }

        public static ModuleNodes.AttrAccessorNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new AttrAccessorNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ModuleNodes.AttrAccessorNode.class)
        public static final class AttrAccessorNodeGen
        extends ModuleNodes.AttrAccessorNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private AttrAccessorNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object[] arguments1Value_;
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments1_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), arguments1Value);
                }
                try {
                    arguments1Value_ = this.arguments1_.executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(arguments0Value_, ex.getResult());
                }
                return this.attrAccessor(frameValue, arguments0Value_, arguments1Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value, Object arguments1Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_, this.arguments1_}, arguments0Value, arguments1Value);
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.AttrNode.class)
    public static final class AttrNodeFactory
    extends NodeFactoryBase<ModuleNodes.AttrNode> {
        private static AttrNodeFactory attrNodeFactoryInstance;

        private AttrNodeFactory() {
            super(ModuleNodes.AttrNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ModuleNodes.AttrNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return AttrNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ModuleNodes.AttrNode> getInstance() {
            if (attrNodeFactoryInstance == null) {
                attrNodeFactoryInstance = new AttrNodeFactory();
            }
            return attrNodeFactoryInstance;
        }

        public static ModuleNodes.AttrNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new AttrNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ModuleNodes.AttrNode.class)
        public static final class AttrNodeGen
        extends ModuleNodes.AttrNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private AttrNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object[] arguments1Value_;
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments1_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), arguments1Value);
                }
                try {
                    arguments1Value_ = this.arguments1_.executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(arguments0Value_, ex.getResult());
                }
                return this.attr(frameValue, arguments0Value_, arguments1Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value, Object arguments1Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_, this.arguments1_}, arguments0Value, arguments1Value);
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.GenerateAccessorNode.class)
    public static final class GenerateAccessorNodeGen
    extends ModuleNodes.GenerateAccessorNode {
        @Node.Child
        private RubyNode module_;
        @Node.Child
        private RubyNode name_;
        @CompilerDirectives.CompilationFinal
        private boolean seenUnsupported0;

        private GenerateAccessorNodeGen(RubyContext context, SourceSection sourceSection, boolean isGetter, RubyNode module, RubyNode name) {
            super(context, sourceSection, isGetter);
            this.module_ = module;
            this.name_ = name;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        @Override
        public DynamicObject executeGenerateAccessor(VirtualFrame frameValue, DynamicObject moduleValue, Object nameValue) {
            return this.generateAccessor(frameValue, moduleValue, nameValue);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            DynamicObject moduleValue_;
            try {
                moduleValue_ = this.module_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object nameValue = this.name_.execute(frameValue);
                throw this.unsupported(ex.getResult(), nameValue);
            }
            Object nameValue_ = this.name_.execute(frameValue);
            return this.generateAccessor(frameValue, moduleValue_, nameValue_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private UnsupportedSpecializationException unsupported(Object moduleValue, Object nameValue) {
            if (!this.seenUnsupported0) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.seenUnsupported0 = true;
            }
            return new UnsupportedSpecializationException(this, new Node[]{this.module_, this.name_}, moduleValue, nameValue);
        }

        public static ModuleNodes.GenerateAccessorNode create(RubyContext context, SourceSection sourceSection, boolean isGetter, RubyNode module, RubyNode name) {
            return new GenerateAccessorNodeGen(context, sourceSection, isGetter, module, name);
        }
    }

    @GeneratedBy(value=ModuleNodes.AppendFeaturesNode.class)
    public static final class AppendFeaturesNodeFactory
    extends NodeFactoryBase<ModuleNodes.AppendFeaturesNode> {
        private static AppendFeaturesNodeFactory appendFeaturesNodeFactoryInstance;

        private AppendFeaturesNodeFactory() {
            super(ModuleNodes.AppendFeaturesNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ModuleNodes.AppendFeaturesNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return AppendFeaturesNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ModuleNodes.AppendFeaturesNode> getInstance() {
            if (appendFeaturesNodeFactoryInstance == null) {
                appendFeaturesNodeFactoryInstance = new AppendFeaturesNodeFactory();
            }
            return appendFeaturesNodeFactoryInstance;
        }

        public static ModuleNodes.AppendFeaturesNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new AppendFeaturesNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ModuleNodes.AppendFeaturesNode.class)
        public static final class AppendFeaturesNodeGen
        extends ModuleNodes.AppendFeaturesNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private AppendFeaturesNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments1Value_;
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments1_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), arguments1Value);
                }
                try {
                    arguments1Value_ = this.arguments1_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(arguments0Value_, ex.getResult());
                }
                if (RubyGuards.isRubyModule(arguments1Value_)) {
                    return this.appendFeatures(arguments0Value_, arguments1Value_);
                }
                throw this.unsupported(arguments0Value_, arguments1Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value, Object arguments1Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_, this.arguments1_}, arguments0Value, arguments1Value);
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.AncestorsNode.class)
    public static final class AncestorsNodeFactory
    extends NodeFactoryBase<ModuleNodes.AncestorsNode> {
        private static AncestorsNodeFactory ancestorsNodeFactoryInstance;

        private AncestorsNodeFactory() {
            super(ModuleNodes.AncestorsNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ModuleNodes.AncestorsNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return AncestorsNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ModuleNodes.AncestorsNode> getInstance() {
            if (ancestorsNodeFactoryInstance == null) {
                ancestorsNodeFactoryInstance = new AncestorsNodeFactory();
            }
            return ancestorsNodeFactoryInstance;
        }

        public static ModuleNodes.AncestorsNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new AncestorsNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ModuleNodes.AncestorsNode.class)
        public static final class AncestorsNodeGen
        extends ModuleNodes.AncestorsNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private AncestorsNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.ancestors(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_}, arguments0Value);
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.AliasMethodNode.class)
    public static final class AliasMethodNodeFactory
    extends NodeFactoryBase<ModuleNodes.AliasMethodNode> {
        private static AliasMethodNodeFactory aliasMethodNodeFactoryInstance;

        private AliasMethodNodeFactory() {
            super(ModuleNodes.AliasMethodNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class, RubyNode.class}});
        }

        @Override
        public ModuleNodes.AliasMethodNode createNode(Object ... arguments) {
            if (!(arguments.length != 5 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode) || arguments[4] != null && !(arguments[4] instanceof RubyNode))) {
                return AliasMethodNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode)arguments[2], (RubyNode)arguments[3], (RubyNode)arguments[4]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ModuleNodes.AliasMethodNode> getInstance() {
            if (aliasMethodNodeFactoryInstance == null) {
                aliasMethodNodeFactoryInstance = new AliasMethodNodeFactory();
            }
            return aliasMethodNodeFactoryInstance;
        }

        public static ModuleNodes.AliasMethodNode create(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode newName, RubyNode oldName) {
            return new AliasMethodNodeGen(context, sourceSection, module, newName, oldName);
        }

        @GeneratedBy(value=ModuleNodes.AliasMethodNode.class)
        public static final class AliasMethodNodeGen
        extends ModuleNodes.AliasMethodNode {
            @Node.Child
            private RubyNode module_;
            @Node.Child
            private RubyNode newName_;
            @Node.Child
            private RubyNode oldName_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private AliasMethodNodeGen(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode newName, RubyNode oldName) {
                super(context, sourceSection);
                this.module_ = module;
                this.newName_ = this.coercetNewNameToString(newName);
                this.oldName_ = this.coerceOldNameToString(oldName);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                String oldNameValue_;
                String newNameValue_;
                DynamicObject moduleValue_;
                try {
                    moduleValue_ = this.module_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object newNameValue = this.newName_.execute(frameValue);
                    Object oldNameValue = this.oldName_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), newNameValue, oldNameValue);
                }
                try {
                    newNameValue_ = AliasMethodNodeGen.expectString(this.newName_.execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object oldNameValue = this.oldName_.execute(frameValue);
                    throw this.unsupported(moduleValue_, ex.getResult(), oldNameValue);
                }
                try {
                    oldNameValue_ = AliasMethodNodeGen.expectString(this.oldName_.execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(moduleValue_, newNameValue_, ex.getResult());
                }
                return this.aliasMethod(moduleValue_, newNameValue_, oldNameValue_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object moduleValue, Object newNameValue, Object oldNameValue) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.module_, this.newName_, this.oldName_}, moduleValue, newNameValue, oldNameValue);
            }

            private static String expectString(Object value) throws UnexpectedResultException {
                if (value instanceof String) {
                    return (String)value;
                }
                throw new UnexpectedResultException(value);
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.CompareNode.class)
    public static final class CompareNodeFactory
    extends NodeFactoryBase<ModuleNodes.CompareNode> {
        private static CompareNodeFactory compareNodeFactoryInstance;

        private CompareNodeFactory() {
            super(ModuleNodes.CompareNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ModuleNodes.CompareNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return CompareNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ModuleNodes.CompareNode> getInstance() {
            if (compareNodeFactoryInstance == null) {
                compareNodeFactoryInstance = new CompareNodeFactory();
            }
            return compareNodeFactoryInstance;
        }

        public static ModuleNodes.CompareNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new CompareNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ModuleNodes.CompareNode.class)
        public static final class CompareNodeGen
        extends ModuleNodes.CompareNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private BaseNode_ specialization_;

            private CompareNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="compareOther(VirtualFrame, DynamicObject, DynamicObject)", value=ModuleNodes.CompareNode.class)
            private static final class CompareOtherNode_
            extends BaseNode_ {
                CompareOtherNode_(CompareNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (!RubyGuards.isRubyModule(arguments1Value_)) {
                            return this.root.compareOther(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CompareNodeGen root) {
                    return new CompareOtherNode_(root);
                }
            }

            @GeneratedBy(methodName="compare(VirtualFrame, DynamicObject, DynamicObject)", value=ModuleNodes.CompareNode.class)
            private static final class CompareNode_
            extends BaseNode_ {
                CompareNode_(CompareNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubyModule(arguments1Value_)) {
                            return this.root.compare(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CompareNodeGen root) {
                    return new CompareNode_(root);
                }
            }

            @GeneratedBy(value=ModuleNodes.CompareNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(CompareNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CompareNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ModuleNodes.CompareNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(CompareNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CompareNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ModuleNodes.CompareNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected CompareNodeGen root;

                BaseNode_(CompareNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (CompareNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubyModule(arguments1Value_)) {
                            return CompareNode_.create(this.root);
                        }
                        return CompareOtherNode_.create(this.root);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.IsSuperclassOfOrEqualToNode.class)
    public static final class IsSuperclassOfOrEqualToNodeFactory
    extends NodeFactoryBase<ModuleNodes.IsSuperclassOfOrEqualToNode> {
        private static IsSuperclassOfOrEqualToNodeFactory isSuperclassOfOrEqualToNodeFactoryInstance;

        private IsSuperclassOfOrEqualToNodeFactory() {
            super(ModuleNodes.IsSuperclassOfOrEqualToNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ModuleNodes.IsSuperclassOfOrEqualToNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return IsSuperclassOfOrEqualToNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ModuleNodes.IsSuperclassOfOrEqualToNode> getInstance() {
            if (isSuperclassOfOrEqualToNodeFactoryInstance == null) {
                isSuperclassOfOrEqualToNodeFactoryInstance = new IsSuperclassOfOrEqualToNodeFactory();
            }
            return isSuperclassOfOrEqualToNodeFactoryInstance;
        }

        public static ModuleNodes.IsSuperclassOfOrEqualToNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new IsSuperclassOfOrEqualToNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ModuleNodes.IsSuperclassOfOrEqualToNode.class)
        public static final class IsSuperclassOfOrEqualToNodeGen
        extends ModuleNodes.IsSuperclassOfOrEqualToNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private BaseNode_ specialization_;

            private IsSuperclassOfOrEqualToNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object executeIsSuperclassOfOrEqualTo(VirtualFrame frameValue, DynamicObject arguments0Value, DynamicObject arguments1Value) {
                return this.specialization_.execute1(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute0(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="isSuperclassOfOrEqualToOther(VirtualFrame, DynamicObject, DynamicObject)", value=ModuleNodes.IsSuperclassOfOrEqualToNode.class)
            private static final class IsSuperclassOfOrEqualToOtherNode_
            extends BaseNode_ {
                IsSuperclassOfOrEqualToOtherNode_(IsSuperclassOfOrEqualToNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute1(VirtualFrame frameValue, DynamicObject arguments0Value, DynamicObject arguments1Value) {
                    if (!RubyGuards.isRubyModule(arguments1Value)) {
                        return this.root.isSuperclassOfOrEqualToOther(frameValue, arguments0Value, arguments1Value);
                    }
                    return this.getNext().execute1(frameValue, arguments0Value, arguments1Value);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (!RubyGuards.isRubyModule(arguments1Value_)) {
                            return this.root.isSuperclassOfOrEqualToOther(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(IsSuperclassOfOrEqualToNodeGen root) {
                    return new IsSuperclassOfOrEqualToOtherNode_(root);
                }
            }

            @GeneratedBy(methodName="isSuperclassOfOrEqualTo(VirtualFrame, DynamicObject, DynamicObject)", value=ModuleNodes.IsSuperclassOfOrEqualToNode.class)
            private static final class IsSuperclassOfOrEqualToNode_
            extends BaseNode_ {
                IsSuperclassOfOrEqualToNode_(IsSuperclassOfOrEqualToNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute1(VirtualFrame frameValue, DynamicObject arguments0Value, DynamicObject arguments1Value) {
                    if (RubyGuards.isRubyModule(arguments1Value)) {
                        return this.root.isSuperclassOfOrEqualTo(frameValue, arguments0Value, arguments1Value);
                    }
                    return this.getNext().execute1(frameValue, arguments0Value, arguments1Value);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubyModule(arguments1Value_)) {
                            return this.root.isSuperclassOfOrEqualTo(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(IsSuperclassOfOrEqualToNodeGen root) {
                    return new IsSuperclassOfOrEqualToNode_(root);
                }
            }

            @GeneratedBy(value=ModuleNodes.IsSuperclassOfOrEqualToNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(IsSuperclassOfOrEqualToNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(IsSuperclassOfOrEqualToNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ModuleNodes.IsSuperclassOfOrEqualToNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(IsSuperclassOfOrEqualToNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(IsSuperclassOfOrEqualToNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ModuleNodes.IsSuperclassOfOrEqualToNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected IsSuperclassOfOrEqualToNodeGen root;

                BaseNode_(IsSuperclassOfOrEqualToNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (IsSuperclassOfOrEqualToNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute1(VirtualFrame frameValue, DynamicObject arguments0Value, DynamicObject arguments1Value) {
                    return this.execute_(frameValue, arguments0Value, arguments1Value);
                }

                public Object execute0(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute0(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubyModule(arguments1Value_)) {
                            return IsSuperclassOfOrEqualToNode_.create(this.root);
                        }
                        return IsSuperclassOfOrEqualToOtherNode_.create(this.root);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.IsSuperclassOfNode.class)
    public static final class IsSuperclassOfNodeFactory
    extends NodeFactoryBase<ModuleNodes.IsSuperclassOfNode> {
        private static IsSuperclassOfNodeFactory isSuperclassOfNodeFactoryInstance;

        private IsSuperclassOfNodeFactory() {
            super(ModuleNodes.IsSuperclassOfNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ModuleNodes.IsSuperclassOfNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return IsSuperclassOfNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ModuleNodes.IsSuperclassOfNode> getInstance() {
            if (isSuperclassOfNodeFactoryInstance == null) {
                isSuperclassOfNodeFactoryInstance = new IsSuperclassOfNodeFactory();
            }
            return isSuperclassOfNodeFactoryInstance;
        }

        public static ModuleNodes.IsSuperclassOfNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new IsSuperclassOfNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ModuleNodes.IsSuperclassOfNode.class)
        public static final class IsSuperclassOfNodeGen
        extends ModuleNodes.IsSuperclassOfNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private BaseNode_ specialization_;

            private IsSuperclassOfNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object executeIsSuperclassOf(VirtualFrame frameValue, DynamicObject arguments0Value, DynamicObject arguments1Value) {
                return this.specialization_.execute1(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute0(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="isSuperclassOfOther(VirtualFrame, DynamicObject, DynamicObject)", value=ModuleNodes.IsSuperclassOfNode.class)
            private static final class IsSuperclassOfOtherNode_
            extends BaseNode_ {
                IsSuperclassOfOtherNode_(IsSuperclassOfNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute1(VirtualFrame frameValue, DynamicObject arguments0Value, DynamicObject arguments1Value) {
                    if (!RubyGuards.isRubyModule(arguments1Value)) {
                        return this.root.isSuperclassOfOther(frameValue, arguments0Value, arguments1Value);
                    }
                    return this.getNext().execute1(frameValue, arguments0Value, arguments1Value);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (!RubyGuards.isRubyModule(arguments1Value_)) {
                            return this.root.isSuperclassOfOther(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(IsSuperclassOfNodeGen root) {
                    return new IsSuperclassOfOtherNode_(root);
                }
            }

            @GeneratedBy(methodName="isSuperclassOf(VirtualFrame, DynamicObject, DynamicObject)", value=ModuleNodes.IsSuperclassOfNode.class)
            private static final class IsSuperclassOfNode_
            extends BaseNode_ {
                IsSuperclassOfNode_(IsSuperclassOfNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute1(VirtualFrame frameValue, DynamicObject arguments0Value, DynamicObject arguments1Value) {
                    if (RubyGuards.isRubyModule(arguments1Value)) {
                        return this.root.isSuperclassOf(frameValue, arguments0Value, arguments1Value);
                    }
                    return this.getNext().execute1(frameValue, arguments0Value, arguments1Value);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubyModule(arguments1Value_)) {
                            return this.root.isSuperclassOf(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(IsSuperclassOfNodeGen root) {
                    return new IsSuperclassOfNode_(root);
                }
            }

            @GeneratedBy(value=ModuleNodes.IsSuperclassOfNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(IsSuperclassOfNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(IsSuperclassOfNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ModuleNodes.IsSuperclassOfNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(IsSuperclassOfNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(IsSuperclassOfNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ModuleNodes.IsSuperclassOfNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected IsSuperclassOfNodeGen root;

                BaseNode_(IsSuperclassOfNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (IsSuperclassOfNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute1(VirtualFrame frameValue, DynamicObject arguments0Value, DynamicObject arguments1Value) {
                    return this.execute_(frameValue, arguments0Value, arguments1Value);
                }

                public Object execute0(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute0(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubyModule(arguments1Value_)) {
                            return IsSuperclassOfNode_.create(this.root);
                        }
                        return IsSuperclassOfOtherNode_.create(this.root);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.IsSubclassOfOrEqualToNode.class)
    public static final class IsSubclassOfOrEqualToNodeFactory
    extends NodeFactoryBase<ModuleNodes.IsSubclassOfOrEqualToNode> {
        private static IsSubclassOfOrEqualToNodeFactory isSubclassOfOrEqualToNodeFactoryInstance;

        private IsSubclassOfOrEqualToNodeFactory() {
            super(ModuleNodes.IsSubclassOfOrEqualToNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ModuleNodes.IsSubclassOfOrEqualToNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return IsSubclassOfOrEqualToNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ModuleNodes.IsSubclassOfOrEqualToNode> getInstance() {
            if (isSubclassOfOrEqualToNodeFactoryInstance == null) {
                isSubclassOfOrEqualToNodeFactoryInstance = new IsSubclassOfOrEqualToNodeFactory();
            }
            return isSubclassOfOrEqualToNodeFactoryInstance;
        }

        public static ModuleNodes.IsSubclassOfOrEqualToNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new IsSubclassOfOrEqualToNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ModuleNodes.IsSubclassOfOrEqualToNode.class)
        public static final class IsSubclassOfOrEqualToNodeGen
        extends ModuleNodes.IsSubclassOfOrEqualToNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private BaseNode_ specialization_;

            private IsSubclassOfOrEqualToNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object executeIsSubclassOfOrEqualTo(VirtualFrame frameValue, DynamicObject arguments0Value, DynamicObject arguments1Value) {
                return this.specialization_.execute1(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute0(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="isSubclassOfOrEqualToOther(VirtualFrame, DynamicObject, DynamicObject)", value=ModuleNodes.IsSubclassOfOrEqualToNode.class)
            private static final class IsSubclassOfOrEqualToOtherNode_
            extends BaseNode_ {
                IsSubclassOfOrEqualToOtherNode_(IsSubclassOfOrEqualToNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute1(VirtualFrame frameValue, DynamicObject arguments0Value, DynamicObject arguments1Value) {
                    if (!RubyGuards.isRubyModule(arguments1Value)) {
                        return this.root.isSubclassOfOrEqualToOther(frameValue, arguments0Value, arguments1Value);
                    }
                    return this.getNext().execute1(frameValue, arguments0Value, arguments1Value);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (!RubyGuards.isRubyModule(arguments1Value_)) {
                            return this.root.isSubclassOfOrEqualToOther(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(IsSubclassOfOrEqualToNodeGen root) {
                    return new IsSubclassOfOrEqualToOtherNode_(root);
                }
            }

            @GeneratedBy(methodName="isSubclassOfOrEqualTo(VirtualFrame, DynamicObject, DynamicObject)", value=ModuleNodes.IsSubclassOfOrEqualToNode.class)
            private static final class IsSubclassOfOrEqualToNode_
            extends BaseNode_ {
                IsSubclassOfOrEqualToNode_(IsSubclassOfOrEqualToNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute1(VirtualFrame frameValue, DynamicObject arguments0Value, DynamicObject arguments1Value) {
                    if (RubyGuards.isRubyModule(arguments1Value)) {
                        return this.root.isSubclassOfOrEqualTo(frameValue, arguments0Value, arguments1Value);
                    }
                    return this.getNext().execute1(frameValue, arguments0Value, arguments1Value);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubyModule(arguments1Value_)) {
                            return this.root.isSubclassOfOrEqualTo(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(IsSubclassOfOrEqualToNodeGen root) {
                    return new IsSubclassOfOrEqualToNode_(root);
                }
            }

            @GeneratedBy(value=ModuleNodes.IsSubclassOfOrEqualToNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(IsSubclassOfOrEqualToNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(IsSubclassOfOrEqualToNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ModuleNodes.IsSubclassOfOrEqualToNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(IsSubclassOfOrEqualToNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(IsSubclassOfOrEqualToNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ModuleNodes.IsSubclassOfOrEqualToNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected IsSubclassOfOrEqualToNodeGen root;

                BaseNode_(IsSubclassOfOrEqualToNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (IsSubclassOfOrEqualToNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute1(VirtualFrame frameValue, DynamicObject arguments0Value, DynamicObject arguments1Value) {
                    return this.execute_(frameValue, arguments0Value, arguments1Value);
                }

                public Object execute0(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute0(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubyModule(arguments1Value_)) {
                            return IsSubclassOfOrEqualToNode_.create(this.root);
                        }
                        return IsSubclassOfOrEqualToOtherNode_.create(this.root);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.IsSubclassOfNode.class)
    public static final class IsSubclassOfNodeFactory
    extends NodeFactoryBase<ModuleNodes.IsSubclassOfNode> {
        private static IsSubclassOfNodeFactory isSubclassOfNodeFactoryInstance;

        private IsSubclassOfNodeFactory() {
            super(ModuleNodes.IsSubclassOfNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ModuleNodes.IsSubclassOfNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return IsSubclassOfNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ModuleNodes.IsSubclassOfNode> getInstance() {
            if (isSubclassOfNodeFactoryInstance == null) {
                isSubclassOfNodeFactoryInstance = new IsSubclassOfNodeFactory();
            }
            return isSubclassOfNodeFactoryInstance;
        }

        public static ModuleNodes.IsSubclassOfNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new IsSubclassOfNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ModuleNodes.IsSubclassOfNode.class)
        public static final class IsSubclassOfNodeGen
        extends ModuleNodes.IsSubclassOfNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private BaseNode_ specialization_;

            private IsSubclassOfNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object executeIsSubclassOf(VirtualFrame frameValue, DynamicObject arguments0Value, DynamicObject arguments1Value) {
                return this.specialization_.execute1(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute0(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="isSubclassOfOther(VirtualFrame, DynamicObject, DynamicObject)", value=ModuleNodes.IsSubclassOfNode.class)
            private static final class IsSubclassOfOtherNode_
            extends BaseNode_ {
                IsSubclassOfOtherNode_(IsSubclassOfNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute1(VirtualFrame frameValue, DynamicObject arguments0Value, DynamicObject arguments1Value) {
                    if (!RubyGuards.isRubyModule(arguments1Value)) {
                        return this.root.isSubclassOfOther(frameValue, arguments0Value, arguments1Value);
                    }
                    return this.getNext().execute1(frameValue, arguments0Value, arguments1Value);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (!RubyGuards.isRubyModule(arguments1Value_)) {
                            return this.root.isSubclassOfOther(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(IsSubclassOfNodeGen root) {
                    return new IsSubclassOfOtherNode_(root);
                }
            }

            @GeneratedBy(methodName="isSubclassOf(VirtualFrame, DynamicObject, DynamicObject)", value=ModuleNodes.IsSubclassOfNode.class)
            private static final class IsSubclassOfNode_
            extends BaseNode_ {
                IsSubclassOfNode_(IsSubclassOfNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute1(VirtualFrame frameValue, DynamicObject arguments0Value, DynamicObject arguments1Value) {
                    if (RubyGuards.isRubyModule(arguments1Value)) {
                        return this.root.isSubclassOf(frameValue, arguments0Value, arguments1Value);
                    }
                    return this.getNext().execute1(frameValue, arguments0Value, arguments1Value);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubyModule(arguments1Value_)) {
                            return this.root.isSubclassOf(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(IsSubclassOfNodeGen root) {
                    return new IsSubclassOfNode_(root);
                }
            }

            @GeneratedBy(value=ModuleNodes.IsSubclassOfNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(IsSubclassOfNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(IsSubclassOfNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ModuleNodes.IsSubclassOfNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(IsSubclassOfNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(IsSubclassOfNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ModuleNodes.IsSubclassOfNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected IsSubclassOfNodeGen root;

                BaseNode_(IsSubclassOfNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (IsSubclassOfNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute1(VirtualFrame frameValue, DynamicObject arguments0Value, DynamicObject arguments1Value) {
                    return this.execute_(frameValue, arguments0Value, arguments1Value);
                }

                public Object execute0(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute0(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubyModule(arguments1Value_)) {
                            return IsSubclassOfNode_.create(this.root);
                        }
                        return IsSubclassOfOtherNode_.create(this.root);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.ContainsInstanceNode.class)
    public static final class ContainsInstanceNodeFactory
    extends NodeFactoryBase<ModuleNodes.ContainsInstanceNode> {
        private static ContainsInstanceNodeFactory containsInstanceNodeFactoryInstance;

        private ContainsInstanceNodeFactory() {
            super(ModuleNodes.ContainsInstanceNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public ModuleNodes.ContainsInstanceNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ContainsInstanceNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ModuleNodes.ContainsInstanceNode> getInstance() {
            if (containsInstanceNodeFactoryInstance == null) {
                containsInstanceNodeFactoryInstance = new ContainsInstanceNodeFactory();
            }
            return containsInstanceNodeFactoryInstance;
        }

        public static ModuleNodes.ContainsInstanceNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new ContainsInstanceNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ModuleNodes.ContainsInstanceNode.class)
        public static final class ContainsInstanceNodeGen
        extends ModuleNodes.ContainsInstanceNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private ContainsInstanceNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeBoolean(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeBoolean(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments1_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), arguments1Value);
                }
                Object arguments1Value_ = this.arguments1_.execute(frameValue);
                return this.containsInstance(arguments0Value_, arguments1Value_);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value, Object arguments1Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_, this.arguments1_}, arguments0Value, arguments1Value);
            }
        }
    }
}

