/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.objects;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.ShapeCachingGuards;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.layouts.Layouts;

@ImportStatic(value={ShapeCachingGuards.class})
@NodeChild(value="object", type=RubyNode.class)
public abstract class MetaClassWithShapeCacheNode
extends RubyNode {
    public MetaClassWithShapeCacheNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
    }

    public abstract DynamicObject executeMetaClass(Object var1);

    @Specialization(guards={"value"})
    protected DynamicObject metaClassClassTrue(boolean value) {
        return this.getContext().getCoreLibrary().getTrueClass();
    }

    @Specialization(guards={"!value"})
    protected DynamicObject metaClassClassFalse(boolean value) {
        return this.getContext().getCoreLibrary().getFalseClass();
    }

    @Specialization
    protected DynamicObject metaClassInt(int value) {
        return this.getContext().getCoreLibrary().getFixnumClass();
    }

    @Specialization
    protected DynamicObject metaClassLong(long value) {
        return this.getContext().getCoreLibrary().getFixnumClass();
    }

    @Specialization
    protected DynamicObject metaClassDouble(double value) {
        return this.getContext().getCoreLibrary().getFloatClass();
    }

    @Specialization(guards={"object.getShape() == cachedShape"}, assumptions={"cachedShape.getValidAssumption()"}, limit="1")
    protected DynamicObject cachedMetaClass(DynamicObject object, @Cached(value="object.getShape()") Shape cachedShape, @Cached(value="getMetaClass(cachedShape)") DynamicObject metaClass) {
        return metaClass;
    }

    @Specialization(guards={"updateShape(object)"})
    protected DynamicObject updateShapeAndMetaClass(DynamicObject object) {
        return this.executeMetaClass(object);
    }

    @Specialization(contains={"cachedMetaClass", "updateShapeAndMetaClass"})
    protected DynamicObject metaClass(DynamicObject object) {
        return Layouts.BASIC_OBJECT.getMetaClass(object);
    }

    protected static DynamicObject getMetaClass(Shape shape) {
        return Layouts.BASIC_OBJECT.getMetaClass(shape.getObjectType());
    }
}

