/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.engine.resolver;

import java.lang.annotation.ElementType;
import javax.persistence.Persistence;
import javax.validation.Path;
import javax.validation.TraversableResolver;
import org.hibernate.validator.util.LoggerFactory;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPATraversableResolver
implements TraversableResolver {
    private static final Logger log = LoggerFactory.make();

    @Override
    public final boolean isReachable(Object traversableObject, Path.Node traversableProperty, Class<?> rootBeanType, Path pathToTraversableObject, ElementType elementType) {
        if (log.isTraceEnabled()) {
            log.trace("Calling isReachable on object {} with node name {}", traversableObject, (Object)traversableProperty.getName());
        }
        if (traversableObject == null || traversableProperty.getName() == null || ElementType.TYPE.equals((Object)elementType)) {
            return true;
        }
        return Persistence.getPersistenceUtil().isLoaded(traversableObject, traversableProperty.getName());
    }

    @Override
    public final boolean isCascadable(Object traversableObject, Path.Node traversableProperty, Class<?> rootBeanType, Path pathToTraversableObject, ElementType elementType) {
        return true;
    }
}

