/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.model.parameter;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.sejda.model.parameter.base.SinglePdfSourceSingleOutputParameters;
import org.sejda.model.pdf.transition.PdfPageTransition;
import org.sejda.model.validation.constraint.HasTransitions;
import org.sejda.model.validation.constraint.SingleOutputAllowedExtensions;

@SingleOutputAllowedExtensions
@HasTransitions
public class SetPagesTransitionParameters
extends SinglePdfSourceSingleOutputParameters {
    @Valid
    private final Map<Integer, PdfPageTransition> transitions = new HashMap<Integer, PdfPageTransition>();
    @Valid
    private PdfPageTransition defaultTransition;
    private boolean fullScreen = false;

    public SetPagesTransitionParameters() {
    }

    public SetPagesTransitionParameters(PdfPageTransition defaultTransition) {
        this.defaultTransition = defaultTransition;
    }

    public boolean isFullScreen() {
        return this.fullScreen;
    }

    public void setFullScreen(boolean fullScreen) {
        this.fullScreen = fullScreen;
    }

    public PdfPageTransition putTransition(Integer page, PdfPageTransition transition) {
        return this.transitions.put(page, transition);
    }

    public void clearTransitions() {
        this.transitions.clear();
    }

    public Map<Integer, PdfPageTransition> getTransitions() {
        return Collections.unmodifiableMap(this.transitions);
    }

    public PdfPageTransition getDefaultTransition() {
        return this.defaultTransition;
    }

    public PdfPageTransition getOrDefault(int page) {
        return this.transitions.getOrDefault(page, this.defaultTransition);
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append(this.transitions).append(this.defaultTransition).append(this.fullScreen).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SetPagesTransitionParameters)) {
            return false;
        }
        SetPagesTransitionParameters parameter = (SetPagesTransitionParameters)other;
        return new EqualsBuilder().appendSuper(super.equals(other)).append(this.transitions, parameter.getTransitions()).append(this.defaultTransition, parameter.getDefaultTransition()).append(this.fullScreen, parameter.isFullScreen()).isEquals();
    }
}

