/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.AttributeFigure;
import CH.ifa.draw.framework.FigureChangeEvent;
import CH.ifa.draw.standard.BoxHandleKit;
import CH.ifa.draw.util.Iconkit;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Vector;

public class ImageFigure
extends AttributeFigure
implements ImageObserver {
    private String fFileName;
    private transient Image fImage;
    private Rectangle fDisplayBox;
    private static final long serialVersionUID = 148012030121282439L;
    private int imageFigureSerializedDataVersion = 1;

    public ImageFigure() {
        this.fFileName = null;
        this.fImage = null;
        this.fDisplayBox = null;
    }

    public ImageFigure(Image image, String fileName, Point origin) {
        this.fFileName = fileName;
        this.fImage = image;
        this.fDisplayBox = new Rectangle(origin.x, origin.y, 0, 0);
        this.fDisplayBox.width = this.fImage.getWidth(this);
        this.fDisplayBox.height = this.fImage.getHeight(this);
    }

    public void basicDisplayBox(Point origin, Point corner) {
        this.fDisplayBox = new Rectangle(origin);
        this.fDisplayBox.add(corner);
    }

    public Vector handles() {
        Vector handles = new Vector();
        BoxHandleKit.addHandles(this, handles);
        return handles;
    }

    public Rectangle displayBox() {
        return new Rectangle(this.fDisplayBox.x, this.fDisplayBox.y, this.fDisplayBox.width, this.fDisplayBox.height);
    }

    protected void basicMoveBy(int x, int y) {
        this.fDisplayBox.translate(x, y);
    }

    public void draw(Graphics g) {
        if (this.fImage == null) {
            this.fImage = Iconkit.instance().getImage(this.fFileName);
        }
        if (this.fImage != null) {
            g.drawImage(this.fImage, this.fDisplayBox.x, this.fDisplayBox.y, this.fDisplayBox.width, this.fDisplayBox.height, this);
        } else {
            this.drawGhost(g);
        }
    }

    private void drawGhost(Graphics g) {
        g.setColor(Color.gray);
        g.fillRect(this.fDisplayBox.x, this.fDisplayBox.y, this.fDisplayBox.width, this.fDisplayBox.height);
    }

    public boolean imageUpdate(Image img, int flags, int x, int y, int w, int h) {
        if ((flags & 0x30) != 0) {
            this.invalidate();
            if (this.listener() != null) {
                this.listener().figureRequestUpdate(new FigureChangeEvent(this));
            }
        }
        return (flags & 0xA0) == 0;
    }

    public void release() {
        this.fImage.flush();
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeInt(this.fDisplayBox.x);
        dw.writeInt(this.fDisplayBox.y);
        dw.writeInt(this.fDisplayBox.width);
        dw.writeInt(this.fDisplayBox.height);
        dw.writeString(this.fFileName);
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.fDisplayBox = new Rectangle(dr.readInt(), dr.readInt(), dr.readInt(), dr.readInt());
        this.fFileName = dr.readString();
        Iconkit.instance().registerImage(this.fFileName);
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        Iconkit.instance().registerImage(this.fFileName);
        this.fImage = null;
    }
}

