/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.facet.specific.sequence_aio;

import com.baselet.control.basics.geom.DimensionDouble;
import com.baselet.control.basics.geom.PointDouble;
import com.baselet.control.enums.AlignHorizontal;
import com.baselet.control.enums.AlignVertical;
import com.baselet.diagram.draw.DrawHandler;
import com.baselet.diagram.draw.TextSplitter;
import com.baselet.element.facet.specific.sequence_aio.DrawingInfoImpl;
import com.baselet.element.facet.specific.sequence_aio.HorizontalDrawingInfo;
import com.baselet.element.facet.specific.sequence_aio.HorizontalDrawingInfoImpl;
import com.baselet.element.facet.specific.sequence_aio.Lifeline;
import com.baselet.element.facet.specific.sequence_aio.LifelineSpanningTickSpanningOccurrence;
import com.baselet.element.facet.specific.sequence_aio.PentagonDrawingHelper;
import com.baselet.element.facet.specific.sequence_aio.VerticalDrawingInfoImpl;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class SequenceDiagram {
    private static final double LIFELINE_X_PADDING = 40.0;
    private static final double LIFELINE_Y_PADDING = 20.0;
    private static final double LIFELINE_MIN_WIDTH = 100.0;
    private static final double DESCRIPTION_V_PADDING = 10.0;
    private static final double DESCRIPTION_H_PADDING = 10.0;
    private static final double TICK_HEIGHT = 20.0;
    private static final double TICK_Y_PADDING = 6.0;
    private String[] titleLines = new String[]{""};
    private String[] descLines = new String[]{""};
    private Lifeline[] lifelines = new Lifeline[0];
    private final Collection<LifelineSpanningTickSpanningOccurrence> spanningLifelineOccurrences = new LinkedList<LifelineSpanningTickSpanningOccurrence>();
    private int lastTick;

    public void setTitle(String title) {
        this.titleLines = title.split("\n");
    }

    public void setTitle(String[] titleLines) {
        this.titleLines = titleLines;
    }

    public void setText(String text) {
        this.descLines = text.split("\n");
    }

    public void setText(String[] textLines) {
        this.descLines = textLines;
    }

    public int getLastTick() {
        return this.lastTick;
    }

    public void setLastTick(int lastTick) {
        this.lastTick = lastTick;
    }

    public Lifeline addLiveline(String headText, Lifeline.LifelineHeadType headType, boolean createdOnStart, boolean execSpecFromStart) {
        this.lifelines = Arrays.copyOf(this.lifelines, this.lifelines.length + 1);
        this.lifelines[this.lifelines.length - 1] = new Lifeline(headText, this.lifelines.length - 1, headType, createdOnStart, execSpecFromStart);
        return this.lifelines[this.lifelines.length - 1];
    }

    public void addLifelineSpanningTickSpanningOccurrence(LifelineSpanningTickSpanningOccurrence occurrence) {
        this.spanningLifelineOccurrences.add(occurrence);
    }

    public int getLifelineCount() {
        return this.lifelines.length;
    }

    public List<Lifeline> getLifelines() {
        return Arrays.asList(this.lifelines);
    }

    public Lifeline[] getLifelinesArray() {
        return this.lifelines;
    }

    public DimensionDouble draw(DrawHandler drawHandler) {
        DoubleConverter identity = new DoubleConverter(){

            @Override
            public double convert(double value) {
                return value;
            }
        };
        return this.draw(drawHandler, identity, identity);
    }

    public DimensionDouble draw(DrawHandler drawHandler, DoubleConverter widthConverter, DoubleConverter heightConverter) {
        double lifelineWidth = Math.max(this.getLifelineWidth(drawHandler), 100.0);
        double diagramMinWidth = Math.max(100.0, TextSplitter.getTextMinWidth(this.descLines, drawHandler) + 20.0);
        diagramMinWidth = Math.max(diagramMinWidth, PentagonDrawingHelper.getMinimumWidth(drawHandler, this.titleLines));
        LinkedList<LifelineSpanningTickSpanningOccurrence.ContainerPadding> allPaddings = new LinkedList<LifelineSpanningTickSpanningOccurrence.ContainerPadding>();
        for (LifelineSpanningTickSpanningOccurrence lstso : this.spanningLifelineOccurrences) {
            if (lstso.getPaddingInformation() == null) continue;
            allPaddings.add(lstso.getPaddingInformation());
        }
        HorizontalDrawingInfoImpl horizontalDrawingInfo = new HorizontalDrawingInfoImpl(0.0, diagramMinWidth, widthConverter, lifelineWidth, 40.0, this.lifelines.length, this.lastTick, allPaddings);
        double diagramWidth = horizontalDrawingInfo.getDiagramWidth();
        double headerHeight = 0.0;
        if (this.titleLines.length > 1 || this.titleLines.length == 1 && !this.titleLines[0].isEmpty()) {
            headerHeight = PentagonDrawingHelper.draw((DrawHandler)drawHandler, (String[])this.titleLines, (double)diagramWidth, (PointDouble)new PointDouble((double)0.0, (double)0.0)).y;
        }
        drawHandler.drawLine(0.0, 0.0, diagramWidth, 0.0);
        double descHeight = TextSplitter.getSplitStringHeight(this.descLines, diagramWidth - 20.0, drawHandler);
        TextSplitter.drawText(drawHandler, this.descLines, 10.0, headerHeight + 10.0, diagramWidth - 20.0, descHeight, AlignHorizontal.LEFT, AlignVertical.CENTER);
        double lifelineHeadTop = headerHeight + descHeight + 20.0 + 20.0;
        double lifelineHeadHeight = this.getLifelineHeadHeight(drawHandler, horizontalDrawingInfo);
        VerticalDrawingInfoImpl verticalInfo = new VerticalDrawingInfoImpl(lifelineHeadTop, lifelineHeadHeight, 20.0, 6.0, this.calculateAddiontalHeights(drawHandler, horizontalDrawingInfo), allPaddings);
        DrawingInfoImpl drawingInfo = new DrawingInfoImpl(horizontalDrawingInfo, verticalInfo, this.getLifelineCount());
        if (this.lifelines.length > 0) {
            for (LifelineSpanningTickSpanningOccurrence llstso : this.spanningLifelineOccurrences) {
                llstso.draw(drawHandler, drawingInfo);
            }
            for (Lifeline ll : this.lifelines) {
                ll.draw(drawHandler, drawingInfo.getDrawingInfo(ll), this.lastTick);
            }
        }
        double bottomY = heightConverter.convert(verticalInfo.getVerticalEnd(this.lastTick) + 20.0);
        drawHandler.drawLine(0.0, bottomY, diagramWidth, bottomY);
        drawHandler.drawLine(0.0, 0.0, 0.0, bottomY);
        drawHandler.drawLine(diagramWidth, 0.0, diagramWidth, bottomY);
        return new DimensionDouble(diagramWidth, bottomY);
    }

    private double getLifelineWidth(DrawHandler drawHandler) {
        double maxMinWidth = 0.0;
        for (Lifeline ll : this.lifelines) {
            maxMinWidth = Math.max(maxMinWidth, ll.getMinWidth(drawHandler));
        }
        for (LifelineSpanningTickSpanningOccurrence llstso : this.spanningLifelineOccurrences) {
            int llCount = llstso.getLastLifeline().getIndex() - llstso.getFirstLifeline().getIndex() + 1;
            maxMinWidth = Math.max(maxMinWidth, (llstso.getOverallMinWidth(drawHandler, 40.0) - 40.0 * (double)(llCount - 1)) / (double)llCount);
        }
        return maxMinWidth;
    }

    private double[] calculateAddiontalHeights(DrawHandler drawHandler, HorizontalDrawingInfo hDrawingInfo) {
        double[] addiontalHeight = new double[this.lastTick + 1];
        for (Lifeline ll : this.lifelines) {
            for (Map.Entry<Integer, Double> e : ll.getAdditionalYHeights(drawHandler, hDrawingInfo.getHDrawingInfo(ll), 20.0).entrySet()) {
                addiontalHeight[e.getKey().intValue()] = Math.max(addiontalHeight[e.getKey()], e.getValue());
            }
        }
        for (LifelineSpanningTickSpanningOccurrence llstso : this.spanningLifelineOccurrences) {
            for (Map.Entry<Integer, Double> e : llstso.getEveryAdditionalYHeight(drawHandler, hDrawingInfo, 20.0).entrySet()) {
                addiontalHeight[e.getKey().intValue()] = Math.max(addiontalHeight[e.getKey()], e.getValue());
            }
        }
        return addiontalHeight;
    }

    private double getLifelineHeadHeight(DrawHandler drawHandler, HorizontalDrawingInfo hDrawingInfo) {
        double maxHeight = 0.0;
        for (Lifeline ll : this.lifelines) {
            if (!ll.isCreatedOnStart()) continue;
            maxHeight = Math.max(maxHeight, ll.getHeadMinHeight(drawHandler, hDrawingInfo.getHDrawingInfo(ll).getWidth()));
        }
        return maxHeight;
    }

    public static interface DoubleConverter {
        public double convert(double var1);
    }
}

