/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.SystemColor;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ImageProducer;
import java.awt.image.WritableRaster;
import sun.awt.image.OffScreenImageSource;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;

public class OffScreenImage
extends BufferedImage {
    protected Component c;
    private OffScreenImageSource osis;
    private Font defaultFont;

    public OffScreenImage(Component c, ColorModel cm, WritableRaster raster, boolean isRasterPremultiplied) {
        super(cm, raster, isRasterPremultiplied, null);
        this.c = c;
        this.initSurface(raster.getWidth(), raster.getHeight());
    }

    @Override
    public Graphics getGraphics() {
        return this.createGraphics();
    }

    @Override
    public Graphics2D createGraphics() {
        Font font;
        Color fg;
        if (this.c == null) {
            GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
            return env.createGraphics(this);
        }
        Color bg = this.c.getBackground();
        if (bg == null) {
            bg = SystemColor.window;
        }
        if ((fg = this.c.getForeground()) == null) {
            fg = SystemColor.windowText;
        }
        if ((font = this.c.getFont()) == null) {
            if (this.defaultFont == null) {
                this.defaultFont = new Font("Dialog", 0, 12);
            }
            font = this.defaultFont;
        }
        return new SunGraphics2D(SurfaceData.getPrimarySurfaceData(this), fg, bg, font);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSurface(int width, int height) {
        Graphics2D g2 = this.createGraphics();
        try {
            g2.clearRect(0, 0, width, height);
        }
        finally {
            g2.dispose();
        }
    }

    @Override
    public ImageProducer getSource() {
        if (this.osis == null) {
            this.osis = new OffScreenImageSource(this);
        }
        return this.osis;
    }
}

