/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.api.project;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.modules.profiler.spi.project.ProjectContentsSupportProvider;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public final class ProjectContentsSupport {
    private static final ClientUtils.SourceCodeSelection[] EMPTY_SELECTION = new ClientUtils.SourceCodeSelection[0];
    private static ProjectContentsSupport DEFAULT;
    private final Collection<? extends ProjectContentsSupportProvider> providers;

    public ClientUtils.SourceCodeSelection[] getProfilingRoots(FileObject fileObject, boolean bl) {
        if (this.providers == null) {
            return EMPTY_SELECTION;
        }
        HashSet<ClientUtils.SourceCodeSelection> hashSet = new HashSet<ClientUtils.SourceCodeSelection>();
        for (ProjectContentsSupportProvider projectContentsSupportProvider : this.providers) {
            ClientUtils.SourceCodeSelection[] sourceCodeSelectionArray = projectContentsSupportProvider.getProfilingRoots(fileObject, bl);
            if (sourceCodeSelectionArray == null || sourceCodeSelectionArray.length <= 0) continue;
            hashSet.addAll(Arrays.asList(sourceCodeSelectionArray));
        }
        return hashSet.toArray(new ClientUtils.SourceCodeSelection[hashSet.size()]);
    }

    public String getInstrumentationFilter(boolean bl) {
        if (this.providers == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (ProjectContentsSupportProvider projectContentsSupportProvider : this.providers) {
            String string = projectContentsSupportProvider.getInstrumentationFilter(bl);
            if (string == null || string.isEmpty()) continue;
            stringBuilder.append(string).append(" ");
        }
        return stringBuilder.toString().trim();
    }

    public void reset() {
        if (this.providers != null) {
            for (ProjectContentsSupportProvider projectContentsSupportProvider : this.providers) {
                projectContentsSupportProvider.reset();
            }
        }
    }

    private ProjectContentsSupport(Collection<? extends ProjectContentsSupportProvider> collection) {
        this.providers = collection;
    }

    private static synchronized ProjectContentsSupport defaultImpl() {
        if (DEFAULT == null) {
            DEFAULT = new ProjectContentsSupport(null);
        }
        return DEFAULT;
    }

    public static ProjectContentsSupport get(Lookup.Provider provider) {
        Collection collection;
        Collection collection2 = collection = provider != null ? provider.getLookup().lookupAll(ProjectContentsSupportProvider.class) : null;
        if (collection == null || collection.isEmpty()) {
            return ProjectContentsSupport.defaultImpl();
        }
        return new ProjectContentsSupport(collection);
    }
}

