/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.application.type;

import com.sun.tools.visualvm.application.Application;
import com.sun.tools.visualvm.application.jvm.Jvm;
import com.sun.tools.visualvm.application.type.ApplicationType;
import java.awt.Image;
import java.util.Properties;
import java.util.Set;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetBeansBasedApplicationType
extends ApplicationType {
    Application application;
    String name;
    String branding;
    Set<String> clusters;
    String fullVersionString;

    NetBeansBasedApplicationType(Application app, Jvm jvm, Set<String> cls, String br) {
        Properties p;
        this.application = app;
        this.clusters = cls;
        this.branding = br;
        if (jvm.isGetSystemPropertiesSupported() && (p = jvm.getSystemProperties()) != null) {
            this.fullVersionString = p.getProperty("netbeans.productversion");
        }
    }

    public Set<String> getClusters() {
        return this.clusters;
    }

    @Override
    public String getName() {
        if (this.fullVersionString != null) {
            int index = this.fullVersionString.indexOf("(");
            if (index != -1) {
                return this.fullVersionString.substring(0, index).trim();
            }
            index = this.fullVersionString.lastIndexOf(" ");
            String buildNo = this.fullVersionString.substring(index + 1);
            if (buildNo.length() > 19 && buildNo.charAt(8) == '-') {
                return this.fullVersionString.substring(0, index);
            }
            return this.fullVersionString;
        }
        return NbBundle.getMessage(NetBeansBasedApplicationType.class, (String)"LBL_NbPlatformApplication");
    }

    @Override
    public String getVersion() {
        return NbBundle.getMessage(NetBeansBasedApplicationType.class, (String)"LBL_Unknown");
    }

    @Override
    public String getDescription() {
        if (this.fullVersionString != null) {
            return this.fullVersionString;
        }
        return NbBundle.getMessage(NetBeansBasedApplicationType.class, (String)"DESCR_NetBeansBasedApplicationType");
    }

    @Override
    public Image getIcon() {
        String iconPath = "com/sun/tools/visualvm/application/type/resources/NetBeansPlatform.png";
        return ImageUtilities.loadImage((String)iconPath, (boolean)true);
    }
}

