/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.plaf.synth.SynthContext;
import org.netbeans.modules.profiler.snaptracer.impl.swing.VerticalLayout;
import sun.swing.plaf.synth.SynthIcon;

public final class CategoryList
extends JPanel {
    private static final Icon expandedIcon;
    private static final Icon collapsedIcon;

    public CategoryList(String[] stringArray, String[] stringArray2, boolean[] blArray, Component[][] componentArray) {
        this.setOpaque(false);
        this.setLayout(new VerticalLayout(false));
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            this.add(new Category(stringArray[i], stringArray2[i], blArray[i], componentArray[i], i, n));
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        Component[] componentArray;
        for (Component component : componentArray = this.getComponents()) {
            component.setEnabled(bl);
        }
    }

    private static Icon centeredIcon(final Icon icon, final int n, final int n2) {
        Object object = null;
        try {
            if (icon instanceof SynthIcon) {
                object = new SynthIcon(){
                    private final SynthIcon sicon;
                    {
                        this.sicon = (SynthIcon)icon;
                    }

                    public void paintIcon(SynthContext synthContext, Graphics graphics, int n9, int n22, int n3, int n4) {
                        try {
                            int n5 = SynthIcon.getIconWidth((Icon)this.sicon, (SynthContext)synthContext);
                            int n6 = SynthIcon.getIconHeight((Icon)this.sicon, (SynthContext)synthContext);
                            int n7 = n - n5;
                            int n8 = n2 - n6;
                            SynthIcon.paintIcon((Icon)this.sicon, (SynthContext)synthContext, (Graphics)graphics, (int)(n9 + n7 / 2), (int)(n22 + n8 / 2), (int)(n5 + 2), (int)(n6 + 2));
                        }
                        catch (Throwable throwable) {
                            try {
                                this.sicon.paintIcon(synthContext, graphics, n9, n22, n3, n4);
                            }
                            catch (Throwable throwable2) {
                                // empty catch block
                            }
                        }
                    }

                    public int getIconWidth(SynthContext synthContext) {
                        return n;
                    }

                    public int getIconHeight(SynthContext synthContext) {
                        return n2;
                    }
                };
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (object == null) {
            object = new Icon(){

                @Override
                public void paintIcon(Component component, Graphics graphics, int n5, int n22) {
                    int n3 = n - icon.getIconWidth();
                    int n4 = n2 - icon.getIconHeight();
                    icon.paintIcon(component, graphics, n5 + n3 / 2, n22 + n4 / 2);
                }

                @Override
                public int getIconWidth() {
                    return n;
                }

                @Override
                public int getIconHeight() {
                    return n2;
                }
            };
        }
        return object;
    }

    static {
        Icon icon = UIManager.getIcon("Tree.expandedIcon");
        Icon icon2 = UIManager.getIcon("Tree.collapsedIcon");
        int n = Math.max(icon.getIconWidth(), icon2.getIconWidth());
        int n2 = Math.max(icon.getIconHeight(), icon2.getIconHeight());
        expandedIcon = CategoryList.centeredIcon(icon, n, n2);
        collapsedIcon = CategoryList.centeredIcon(icon2, n, n2);
    }

    private static class Category
    extends JPanel {
        private boolean expanded;
        private final JLabel headerLabel;
        private final JPanel itemsContainer;

        public Category(String string, String string2, boolean bl, Component[] componentArray, int n, int n2) {
            this.expanded = bl;
            this.setOpaque(false);
            this.setLayout(new BorderLayout());
            this.headerLabel = new JLabel(string);
            this.headerLabel.setForeground(new JMenuItem().getForeground());
            this.headerLabel.setToolTipText(string2);
            this.headerLabel.setIconTextGap(5);
            this.headerLabel.setCursor(Cursor.getPredefinedCursor(12));
            this.headerLabel.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 5));
            this.headerLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    Category.this.expanded = !Category.this.expanded;
                    Category.this.updateState();
                }
            });
            JMenuBar jMenuBar = new JMenuBar();
            jMenuBar.setBorder(BorderFactory.createEmptyBorder());
            jMenuBar.setBorderPainted(false);
            jMenuBar.setLayout(new BorderLayout());
            jMenuBar.add((Component)this.headerLabel, "Center");
            this.itemsContainer = new JPanel(){

                @Override
                public void setEnabled(boolean bl) {
                    Component[] componentArray;
                    for (Component component : componentArray = this.getComponents()) {
                        component.setEnabled(bl);
                    }
                }
            };
            this.itemsContainer.setOpaque(false);
            this.itemsContainer.setLayout(new VerticalLayout(false));
            for (int i = 0; i < componentArray.length; ++i) {
                this.itemsContainer.add(componentArray[i]);
            }
            this.add((Component)jMenuBar, "North");
            this.add((Component)this.itemsContainer, "Center");
            this.updateState();
        }

        @Override
        public void setEnabled(boolean bl) {
            Component[] componentArray;
            for (Component component : componentArray = this.getComponents()) {
                if (component instanceof JMenuBar) continue;
                component.setEnabled(bl);
            }
        }

        private void updateState() {
            this.headerLabel.setIcon(this.expanded ? expandedIcon : collapsedIcon);
            this.itemsContainer.setVisible(this.expanded);
        }
    }
}

