/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.session;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.markerlayer.Marker;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.io.GpxWriter;
import org.openstreetmap.josm.io.session.AbstractSessionExporter;
import org.openstreetmap.josm.io.session.SessionWriter;
import org.openstreetmap.josm.tools.GBC;
import org.w3c.dom.Element;

public class MarkerSessionExporter
extends AbstractSessionExporter<MarkerLayer> {
    public MarkerSessionExporter(MarkerLayer markerLayer) {
        super(markerLayer);
    }

    @Override
    public Collection<Layer> getDependencies() {
        GpxLayer gpxLayer = ((MarkerLayer)this.layer).fromLayer;
        if (gpxLayer != null && Main.map.mapView.hasLayer(gpxLayer)) {
            return Collections.singleton(gpxLayer);
        }
        return Collections.emptySet();
    }

    @Override
    public Component getExportPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.export.setSelected(true);
        JLabel jLabel = new JLabel(((MarkerLayer)this.layer).getName(), ((MarkerLayer)this.layer).getIcon(), 2);
        jLabel.setToolTipText(((MarkerLayer)this.layer).getToolTipText());
        jLabel.setLabelFor(this.export);
        jPanel.add((Component)this.export, GBC.std());
        jPanel.add((Component)jLabel, GBC.std());
        jPanel.add(GBC.glue(1, 0), GBC.std().fill(2));
        return jPanel;
    }

    @Override
    public boolean requiresZip() {
        return true;
    }

    @Override
    public Element export(SessionWriter.ExportSupport exportSupport) throws IOException {
        Element element = exportSupport.createElement("layer");
        element.setAttribute("type", "markers");
        element.setAttribute("version", "0.1");
        Element element2 = exportSupport.createElement("file");
        element.appendChild(element2);
        String string = "layers/" + String.format("%02d", exportSupport.getLayerIndex()) + "/data.gpx";
        element2.appendChild(exportSupport.createTextNode(string));
        this.addDataFile(exportSupport.getOutputStreamZip(string));
        return element;
    }

    protected void addDataFile(OutputStream outputStream) {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);
        MarkerWriter markerWriter = new MarkerWriter(new PrintWriter(outputStreamWriter));
        markerWriter.write((MarkerLayer)this.layer);
        markerWriter.flush();
    }

    public static class MarkerWriter
    extends GpxWriter {
        public MarkerWriter(PrintWriter printWriter) {
            super(printWriter);
        }

        public void write(MarkerLayer markerLayer) {
            GpxData gpxData = new GpxData();
            gpxData.put("meta.desc", "exported JOSM marker layer");
            for (Marker marker : markerLayer.data) {
                gpxData.waypoints.add(marker.convertToWayPoint());
            }
            super.write(gpxData);
        }
    }
}

