/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop.java;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.java.JavaInterop;
import com.oracle.truffle.api.interop.java.JavaInteropLanguage;
import com.oracle.truffle.api.nodes.RootNode;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

final class ReadFieldNode
extends RootNode {
    ReadFieldNode() {
        super(JavaInteropLanguage.class, null, null);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        try {
            Object val;
            JavaInterop.JavaObject receiver = (JavaInterop.JavaObject)ForeignAccess.getReceiver(frame);
            Object obj = receiver.obj;
            boolean onlyStatic = obj == null;
            Object nameOrIndex = ForeignAccess.getArguments(frame).get(0);
            if (nameOrIndex instanceof Integer) {
                val = Array.get(obj, (Integer)nameOrIndex);
            } else {
                String name = (String)nameOrIndex;
                try {
                    boolean isStatic;
                    Field field = receiver.clazz.getField(name);
                    boolean bl = isStatic = (field.getModifiers() & 8) != 0;
                    if (onlyStatic != isStatic) {
                        throw new NoSuchFieldException();
                    }
                    val = field.get(obj);
                }
                catch (NoSuchFieldException ex) {
                    for (Method m : receiver.clazz.getMethods()) {
                        boolean isStatic;
                        boolean bl = isStatic = (m.getModifiers() & 8) != 0;
                        if (onlyStatic != isStatic || !m.getName().equals(name)) continue;
                        return new JavaInterop.JavaFunctionObject(m, obj);
                    }
                    throw (NoSuchFieldError)new NoSuchFieldError(ex.getMessage()).initCause(ex);
                }
            }
            if (JavaInterop.isPrimitive(val)) {
                return val;
            }
            return JavaInterop.asTruffleObject(val);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
    }
}

