/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.format.nodes.read;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import java.nio.ByteBuffer;
import org.jcodings.Encoding;
import org.jruby.truffle.format.nodes.PackNode;
import org.jruby.truffle.format.nodes.SourceNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.layouts.Layouts;
import org.jruby.util.ByteList;
import org.jruby.util.Pack;

@NodeChildren(value={@NodeChild(value="value", type=SourceNode.class)})
public abstract class ReadMIMEStringNode
extends PackNode {
    public ReadMIMEStringNode(RubyContext context) {
        super(context);
    }

    @Specialization
    public Object read(VirtualFrame frame, byte[] source) {
        ByteBuffer encode = ByteBuffer.wrap(source, this.getSourcePosition(frame), this.getSourceLength(frame) - this.getSourcePosition(frame));
        byte[] lElem = new byte[Math.max(encode.remaining(), 0)];
        int index = 0;
        while (encode.hasRemaining()) {
            int c = Pack.safeGet((ByteBuffer)encode);
            if (c != 61) {
                lElem[index++] = (byte)c;
                continue;
            }
            if (!encode.hasRemaining()) break;
            encode.mark();
            int c1 = Pack.safeGet((ByteBuffer)encode);
            if (c1 == 10 || c1 == 13 && (c1 = Pack.safeGet((ByteBuffer)encode)) == 10) continue;
            int d1 = Character.digit(c1, 16);
            if (d1 == -1) {
                encode.reset();
                break;
            }
            encode.mark();
            if (!encode.hasRemaining()) break;
            int c2 = Pack.safeGet((ByteBuffer)encode);
            int d2 = Character.digit(c2, 16);
            if (d2 == -1) {
                encode.reset();
                break;
            }
            byte value = (byte)(d1 << 4 | d2);
            lElem[index++] = value;
        }
        Encoding encoding = Encoding.load((String)"ASCII");
        ByteList result = new ByteList(lElem, 0, index, encoding, false);
        this.setSourcePosition(frame, encode.position());
        return Layouts.STRING.createString(this.getContext().getCoreLibrary().getStringFactory(), result, 0, null);
    }
}

