/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime;

import com.oracle.truffle.api.instrument.SyntaxTag;

public enum RubySyntaxTag implements SyntaxTag
{
    LINE("line", "Execute code on a new line"),
    CLASS("class", "Start a class or module definition"),
    END("end", "Finish a class or module definition"),
    CALL("call", "Call a Ruby method"),
    RETURN("return", "Return from a Ruby method"),
    C_CALL("c_call", "Call a C-language routine"),
    C_RETURN("c_return", "Return from a C-language routine"),
    RAISE("raise", "Raise an exception"),
    B_CALL("b_call", "Event hook at block entry"),
    B_RETURN("b_return", "Event hook at block ending"),
    THREAD_BEGIN("thread_begin", "Event hook at thread beginning"),
    THREAD_END("thread_end", "Event hook at thread ending");

    private final String name;
    private final String description;

    private RubySyntaxTag(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }
}

