/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.util.common;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class CaseAwareMap
implements Map {
    private boolean isCaseSensitive;
    private Map caseInsensitiveMap;
    private Map actualMap;

    public CaseAwareMap() {
        this(false);
    }

    public CaseAwareMap(boolean bl) {
        this.isCaseSensitive = bl;
        this.caseInsensitiveMap = new HashMap();
        this.actualMap = new HashMap();
    }

    public boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    public void setCaseSensitive(boolean bl) {
        this.clear();
        this.isCaseSensitive = bl;
    }

    public void clear() {
        this.caseInsensitiveMap.clear();
        this.actualMap.clear();
    }

    public boolean containsKey(Object object) {
        Object object2 = this.getCompareKey(object);
        return this.getCompareMap().containsKey(object2);
    }

    public boolean containsValue(Object object) {
        return this.actualMap.containsValue(object);
    }

    public Set entrySet() {
        return this.actualMap.entrySet();
    }

    public Object get(Object object) {
        Object object2 = this.getCompareKey(object);
        return this.getCompareMap().get(object2);
    }

    public boolean isEmpty() {
        return this.size() <= 0;
    }

    public Set keySet() {
        return this.actualMap.keySet();
    }

    public Object put(Object object, Object object2) {
        return this.doConsistentModify(object, new ConsistentPut(object2));
    }

    public void putAll(Map map) {
        for (Object k : map.keySet()) {
            Object v = map.get(k);
            this.put(k, v);
        }
    }

    public Object remove(Object object) {
        return this.doConsistentModify(object, new ConsistentRemove());
    }

    public int size() {
        return this.actualMap.size();
    }

    public Collection values() {
        return this.actualMap.values();
    }

    private boolean areKeysEquals(Object object, Object object2) {
        if (null == object && null == object2) {
            return true;
        }
        if (null == object) {
            return false;
        }
        if (null == object2) {
            return false;
        }
        Object object3 = this.getCompareKey(object);
        return object2.equals(object3);
    }

    private boolean isStringKey(Object object) {
        return null != object && object instanceof String;
    }

    private Object getCompareKey(Object object) {
        if (this.isCaseSensitive || !this.isStringKey(object)) {
            return object;
        }
        return ((String)object).toUpperCase();
    }

    private Map getCompareMap() {
        if (this.isCaseSensitive) {
            return this.actualMap;
        }
        return this.caseInsensitiveMap;
    }

    private Object doConsistentModify(Object object, ConsistentModify consistentModify) {
        Object object2 = this.getCompareKey(object);
        if (!this.caseInsensitiveMap.containsKey(object2)) {
            return consistentModify.modify(object, object2);
        }
        for (Object k : this.actualMap.keySet()) {
            if (!this.areKeysEquals(k, object2)) continue;
            return consistentModify.modify(k, object2);
        }
        return null;
    }

    private class ConsistentPut
    implements ConsistentModify {
        private Object value;

        public ConsistentPut(Object object) {
            this.value = object;
        }

        public Object modify(Object object, Object object2) {
            CaseAwareMap.this.actualMap.put(object, this.value);
            return CaseAwareMap.this.caseInsensitiveMap.put(object2, this.value);
        }
    }

    private class ConsistentRemove
    implements ConsistentModify {
        private ConsistentRemove() {
        }

        public Object modify(Object object, Object object2) {
            CaseAwareMap.this.actualMap.remove(object);
            return CaseAwareMap.this.caseInsensitiveMap.remove(object2);
        }
    }

    private static interface ConsistentModify {
        public Object modify(Object var1, Object var2);
    }
}

