/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.IntersectionCastTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.RawTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.UnresolvedAnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.UnresolvedReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;
import org.eclipse.jdt.internal.compiler.util.SimpleLookupTable;
import org.eclipse.jdt.internal.compiler.util.Util;

public class TypeSystem {
    private int typeid = 128;
    private TypeBinding[][] types;
    private SimpleLookupTable annotationTypes;
    private LookupEnvironment environment;

    public TypeSystem(LookupEnvironment lookupEnvironment) {
        this.environment = lookupEnvironment;
        this.annotationTypes = new SimpleLookupTable(16);
        this.typeid = 128;
        this.types = new TypeBinding[256][];
    }

    public final TypeBinding getUnannotatedType(TypeBinding typeBinding) {
        if (typeBinding.isUnresolvedType() && CharOperation.indexOf('$', typeBinding.sourceName()) > 0) {
            typeBinding = BinaryTypeBinding.resolveType(typeBinding, this.environment, true);
        }
        if (typeBinding.id == Integer.MAX_VALUE) {
            if (typeBinding.hasTypeAnnotations()) {
                throw new IllegalStateException();
            }
            int n = this.types.length;
            if (this.typeid == n) {
                this.types = new TypeBinding[n * 2][];
                System.arraycopy(this.types, 0, this.types, 0, n);
            }
            typeBinding.id = this.typeid++;
            this.types[typeBinding.id] = new TypeBinding[4];
        } else {
            TypeBinding typeBinding2;
            TypeBinding typeBinding3 = typeBinding2 = this.types[typeBinding.id] == null ? null : this.types[typeBinding.id][0];
            if (typeBinding.hasTypeAnnotations() && typeBinding2 == null) {
                throw new IllegalStateException();
            }
            if (typeBinding2 != null) {
                return typeBinding2;
            }
            this.types[typeBinding.id] = new TypeBinding[4];
        }
        TypeBinding typeBinding4 = typeBinding;
        this.types[typeBinding.id][0] = typeBinding4;
        return typeBinding4;
    }

    public TypeBinding[] getAnnotatedTypes(TypeBinding typeBinding) {
        return Binding.NO_TYPES;
    }

    public ArrayBinding getArrayType(TypeBinding typeBinding, int n) {
        TypeBinding typeBinding2;
        int n2;
        TypeBinding typeBinding3 = this.getUnannotatedType(typeBinding);
        TypeBinding[] typeBindingArray = this.types[typeBinding3.id];
        int n3 = typeBindingArray.length;
        for (n2 = 0; n2 < n3 && (typeBinding2 = typeBindingArray[n2]) != null; ++n2) {
            if (!typeBinding2.isArrayType() || typeBinding2.hasTypeAnnotations() || typeBinding2.leafComponentType() != typeBinding3 || typeBinding2.dimensions() != n) continue;
            return (ArrayBinding)typeBinding2;
        }
        if (n2 == n3) {
            TypeBinding[] typeBindingArray2 = typeBindingArray;
            typeBindingArray = new TypeBinding[n3 * 2];
            System.arraycopy(typeBindingArray2, 0, typeBindingArray, 0, n3);
            this.types[typeBinding3.id] = typeBindingArray;
        }
        typeBinding2 = typeBindingArray[n2] = new ArrayBinding(typeBinding3, n, this.environment);
        int n4 = this.types.length;
        if (this.typeid == n4) {
            this.types = new TypeBinding[n4 * 2][];
            System.arraycopy(this.types, 0, this.types, 0, n4);
        }
        this.types[this.typeid] = new TypeBinding[1];
        typeBinding2.id = this.typeid++;
        TypeBinding typeBinding4 = typeBinding2;
        this.types[typeBinding2.id][0] = typeBinding4;
        return (ArrayBinding)typeBinding4;
    }

    public ArrayBinding getArrayType(TypeBinding typeBinding, int n, AnnotationBinding[] annotationBindingArray) {
        return this.getArrayType(typeBinding, n);
    }

    public ReferenceBinding getMemberType(ReferenceBinding referenceBinding, ReferenceBinding referenceBinding2) {
        return referenceBinding;
    }

    public ParameterizedTypeBinding getParameterizedType(ReferenceBinding referenceBinding, TypeBinding[] typeBindingArray, ReferenceBinding referenceBinding2) {
        TypeBinding typeBinding;
        int n;
        ReferenceBinding referenceBinding3 = (ReferenceBinding)this.getUnannotatedType(referenceBinding);
        int n2 = typeBindingArray == null ? 0 : typeBindingArray.length;
        Object[] objectArray = typeBindingArray == null ? null : new TypeBinding[n2];
        for (int i = 0; i < n2; ++i) {
            objectArray[i] = this.getUnannotatedType(typeBindingArray[i]);
        }
        ReferenceBinding referenceBinding4 = referenceBinding2 == null ? null : (ReferenceBinding)this.getUnannotatedType(referenceBinding2);
        TypeBinding[] typeBindingArray2 = this.types[referenceBinding3.id];
        int n3 = typeBindingArray2.length;
        for (n = 0; n < n3 && (typeBinding = typeBindingArray2[n]) != null; ++n) {
            if (!typeBinding.isParameterizedType() || typeBinding.actualType() != referenceBinding3 || typeBinding.hasTypeAnnotations() || typeBinding.enclosingType() != referenceBinding4 || !Util.effectivelyEqual(typeBinding.typeArguments(), objectArray)) continue;
            return (ParameterizedTypeBinding)typeBinding;
        }
        if (n == n3) {
            TypeBinding[] typeBindingArray3 = typeBindingArray2;
            typeBindingArray2 = new TypeBinding[n3 * 2];
            System.arraycopy(typeBindingArray3, 0, typeBindingArray2, 0, n3);
            this.types[referenceBinding3.id] = typeBindingArray2;
        }
        typeBinding = typeBindingArray2[n] = new ParameterizedTypeBinding(referenceBinding3, (TypeBinding[])objectArray, referenceBinding4, this.environment);
        int n4 = this.types.length;
        if (this.typeid == n4) {
            this.types = new TypeBinding[n4 * 2][];
            System.arraycopy(this.types, 0, this.types, 0, n4);
        }
        this.types[this.typeid] = new TypeBinding[1];
        typeBinding.id = this.typeid++;
        TypeBinding typeBinding2 = typeBinding;
        this.types[typeBinding.id][0] = typeBinding2;
        return (ParameterizedTypeBinding)typeBinding2;
    }

    public ParameterizedTypeBinding getParameterizedType(ReferenceBinding referenceBinding, TypeBinding[] typeBindingArray, ReferenceBinding referenceBinding2, AnnotationBinding[] annotationBindingArray) {
        return this.getParameterizedType(referenceBinding, typeBindingArray, referenceBinding2);
    }

    public RawTypeBinding getRawType(ReferenceBinding referenceBinding, ReferenceBinding referenceBinding2) {
        TypeBinding typeBinding;
        int n;
        ReferenceBinding referenceBinding3 = (ReferenceBinding)this.getUnannotatedType(referenceBinding);
        ReferenceBinding referenceBinding4 = referenceBinding2 == null ? null : (ReferenceBinding)this.getUnannotatedType(referenceBinding2);
        TypeBinding[] typeBindingArray = this.types[referenceBinding3.id];
        int n2 = typeBindingArray.length;
        for (n = 0; n < n2 && (typeBinding = typeBindingArray[n]) != null; ++n) {
            if (!typeBinding.isRawType() || typeBinding.actualType() != referenceBinding3 || typeBinding.hasTypeAnnotations() || typeBinding.enclosingType() != referenceBinding4) continue;
            return (RawTypeBinding)typeBinding;
        }
        if (n == n2) {
            TypeBinding[] typeBindingArray2 = typeBindingArray;
            typeBindingArray = new TypeBinding[n2 * 2];
            System.arraycopy(typeBindingArray2, 0, typeBindingArray, 0, n2);
            this.types[referenceBinding3.id] = typeBindingArray;
        }
        typeBinding = typeBindingArray[n] = new RawTypeBinding(referenceBinding3, referenceBinding4, this.environment);
        int n3 = this.types.length;
        if (this.typeid == n3) {
            this.types = new TypeBinding[n3 * 2][];
            System.arraycopy(this.types, 0, this.types, 0, n3);
        }
        this.types[this.typeid] = new TypeBinding[1];
        typeBinding.id = this.typeid++;
        TypeBinding typeBinding2 = typeBinding;
        this.types[typeBinding.id][0] = typeBinding2;
        return (RawTypeBinding)typeBinding2;
    }

    public RawTypeBinding getRawType(ReferenceBinding referenceBinding, ReferenceBinding referenceBinding2, AnnotationBinding[] annotationBindingArray) {
        return this.getRawType(referenceBinding, referenceBinding2);
    }

    public WildcardBinding getWildcard(ReferenceBinding referenceBinding, int n, TypeBinding typeBinding, TypeBinding[] typeBindingArray, int n2) {
        TypeBinding typeBinding2;
        int n3;
        if (referenceBinding == null) {
            referenceBinding = ReferenceBinding.LUB_GENERIC;
        }
        ReferenceBinding referenceBinding2 = (ReferenceBinding)this.getUnannotatedType(referenceBinding);
        int n4 = typeBindingArray == null ? 0 : typeBindingArray.length;
        Object[] objectArray = typeBindingArray == null ? null : new TypeBinding[n4];
        for (int i = 0; i < n4; ++i) {
            objectArray[i] = this.getUnannotatedType(typeBindingArray[i]);
        }
        TypeBinding typeBinding3 = typeBinding == null ? null : this.getUnannotatedType(typeBinding);
        TypeBinding[] typeBindingArray2 = this.types[referenceBinding2.id];
        int n5 = typeBindingArray2.length;
        for (n3 = 0; n3 < n5 && (typeBinding2 = typeBindingArray2[n3]) != null; ++n3) {
            if (!typeBinding2.isWildcard() || typeBinding2.actualType() != referenceBinding2 || typeBinding2.hasTypeAnnotations() || typeBinding2.rank() != n || typeBinding2.boundKind() != n2 || typeBinding2.bound() != typeBinding3 || !Util.effectivelyEqual(typeBinding2.additionalBounds(), objectArray)) continue;
            return (WildcardBinding)typeBinding2;
        }
        if (n3 == n5) {
            TypeBinding[] typeBindingArray3 = typeBindingArray2;
            typeBindingArray2 = new TypeBinding[n5 * 2];
            System.arraycopy(typeBindingArray3, 0, typeBindingArray2, 0, n5);
            this.types[referenceBinding2.id] = typeBindingArray2;
        }
        typeBinding2 = typeBindingArray2[n3] = new WildcardBinding(referenceBinding2, n, typeBinding3, (TypeBinding[])objectArray, n2, this.environment);
        int n6 = this.types.length;
        if (this.typeid == n6) {
            this.types = new TypeBinding[n6 * 2][];
            System.arraycopy(this.types, 0, this.types, 0, n6);
        }
        this.types[this.typeid] = new TypeBinding[1];
        typeBinding2.id = this.typeid++;
        TypeBinding typeBinding4 = typeBinding2;
        this.types[typeBinding2.id][0] = typeBinding4;
        return (WildcardBinding)typeBinding4;
    }

    public WildcardBinding getWildcard(ReferenceBinding referenceBinding, int n, TypeBinding typeBinding, TypeBinding[] typeBindingArray, int n2, AnnotationBinding[] annotationBindingArray) {
        return this.getWildcard(referenceBinding, n, typeBinding, typeBindingArray, n2);
    }

    public TypeBinding getAnnotatedType(TypeBinding typeBinding, AnnotationBinding[][] annotationBindingArray) {
        return typeBinding;
    }

    protected final TypeBinding[] getDerivedTypes(TypeBinding typeBinding) {
        typeBinding = this.getUnannotatedType(typeBinding);
        return this.types[typeBinding.id];
    }

    private TypeBinding cacheDerivedType(TypeBinding typeBinding, TypeBinding typeBinding2) {
        int n;
        if (typeBinding == null || typeBinding2 == null || typeBinding.id == Integer.MAX_VALUE) {
            throw new IllegalStateException();
        }
        TypeBinding[] typeBindingArray = this.types[typeBinding.id];
        int n2 = typeBindingArray.length;
        for (n = 0; n < n2 && typeBindingArray[n] != null; ++n) {
        }
        if (n == n2) {
            TypeBinding[] typeBindingArray2 = typeBindingArray;
            typeBindingArray = new TypeBinding[n2 * 2];
            System.arraycopy(typeBindingArray2, 0, typeBindingArray, 0, n2);
            this.types[typeBinding.id] = typeBindingArray;
        }
        typeBindingArray[n] = typeBinding2;
        return typeBindingArray[n];
    }

    protected final TypeBinding cacheDerivedType(TypeBinding typeBinding, TypeBinding typeBinding2, TypeBinding typeBinding3) {
        this.cacheDerivedType(typeBinding, typeBinding3);
        if (typeBinding2.id != typeBinding.id) {
            this.cacheDerivedType(typeBinding2, typeBinding3);
        }
        return typeBinding3;
    }

    public final AnnotationBinding getAnnotationType(ReferenceBinding referenceBinding, boolean bl) {
        AnnotationBinding annotationBinding = (AnnotationBinding)this.annotationTypes.get(referenceBinding);
        if (annotationBinding == null) {
            annotationBinding = bl ? new AnnotationBinding(referenceBinding, Binding.NO_ELEMENT_VALUE_PAIRS) : new UnresolvedAnnotationBinding(referenceBinding, Binding.NO_ELEMENT_VALUE_PAIRS, this.environment);
            this.annotationTypes.put(referenceBinding, annotationBinding);
        }
        if (bl) {
            annotationBinding.resolve();
        }
        return annotationBinding;
    }

    public boolean isAnnotatedTypeSystem() {
        return false;
    }

    public void reset() {
        this.annotationTypes = new SimpleLookupTable(16);
        this.typeid = 128;
        this.types = new TypeBinding[256][];
    }

    public void updateCaches(UnresolvedReferenceBinding unresolvedReferenceBinding, ReferenceBinding referenceBinding) {
        int n = unresolvedReferenceBinding.id;
        if (n != Integer.MAX_VALUE && this.types[n] != null && this.types[n][0] == unresolvedReferenceBinding) {
            referenceBinding.id = n;
            this.types[n][0] = referenceBinding;
        }
        if (this.annotationTypes.get(unresolvedReferenceBinding) != null) {
            Object[] objectArray = this.annotationTypes.keyTable;
            int n2 = objectArray.length;
            for (int i = 0; i < n2; ++i) {
                if (objectArray[i] != unresolvedReferenceBinding) continue;
                objectArray[i] = referenceBinding;
                break;
            }
        }
    }

    public final TypeBinding getIntersectionCastType(ReferenceBinding[] referenceBindingArray) {
        int n;
        int n2 = n = referenceBindingArray == null ? 0 : referenceBindingArray.length;
        if (n == 0) {
            return null;
        }
        ReferenceBinding referenceBinding = referenceBindingArray[0];
        if (referenceBinding == null || n == 1) {
            return referenceBinding;
        }
        block0: for (TypeBinding typeBinding : this.getDerivedTypes(referenceBinding)) {
            ReferenceBinding[] referenceBindingArray2;
            if (typeBinding == null) break;
            if (!typeBinding.isIntersectionCastType() || (referenceBindingArray2 = typeBinding.getIntersectingTypes()).length != n) continue;
            for (int i = 0; i < n; ++i) {
                if (referenceBindingArray[i] != referenceBindingArray2[i]) continue block0;
            }
            return typeBinding;
        }
        return this.cacheDerivedType(referenceBinding, new IntersectionCastTypeBinding(referenceBindingArray, this.environment));
    }
}

