/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.Socket;
import java.security.AlgorithmConstraints;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.ExtendedSSLSession;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509KeyManager;
import sun.security.provider.certpath.AlgorithmChecker;
import sun.security.ssl.Debug;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.SSLAlgorithmConstraints;

final class X509KeyManagerImpl
extends X509ExtendedKeyManager
implements X509KeyManager {
    private static final Debug debug = Debug.getInstance("ssl");
    private static final boolean useDebug = debug != null && Debug.isOn("keymanager");
    private static Date verificationDate;
    private final List<KeyStore.Builder> builders;
    private final AtomicLong uidCounter;
    private final Map<String, Reference<KeyStore.PrivateKeyEntry>> entryCacheMap;

    X509KeyManagerImpl(KeyStore.Builder builder) {
        this(Collections.singletonList(builder));
    }

    X509KeyManagerImpl(List<KeyStore.Builder> builders) {
        this.builders = builders;
        this.uidCounter = new AtomicLong();
        this.entryCacheMap = Collections.synchronizedMap(new SizedMap());
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        KeyStore.PrivateKeyEntry entry = this.getEntry(alias);
        return entry == null ? null : (X509Certificate[])entry.getCertificateChain();
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        KeyStore.PrivateKeyEntry entry = this.getEntry(alias);
        return entry == null ? null : entry.getPrivateKey();
    }

    @Override
    public String chooseClientAlias(String[] keyTypes, Principal[] issuers, Socket socket) {
        return this.chooseAlias(X509KeyManagerImpl.getKeyTypes(keyTypes), issuers, CheckType.CLIENT, this.getAlgorithmConstraints(socket));
    }

    @Override
    public String chooseEngineClientAlias(String[] keyTypes, Principal[] issuers, SSLEngine engine) {
        return this.chooseAlias(X509KeyManagerImpl.getKeyTypes(keyTypes), issuers, CheckType.CLIENT, this.getAlgorithmConstraints(engine));
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        return this.chooseAlias(X509KeyManagerImpl.getKeyTypes(keyType), issuers, CheckType.SERVER, this.getAlgorithmConstraints(socket));
    }

    @Override
    public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
        return this.chooseAlias(X509KeyManagerImpl.getKeyTypes(keyType), issuers, CheckType.SERVER, this.getAlgorithmConstraints(engine));
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        return this.getAliases(keyType, issuers, CheckType.CLIENT, null);
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        return this.getAliases(keyType, issuers, CheckType.SERVER, null);
    }

    private AlgorithmConstraints getAlgorithmConstraints(Socket socket) {
        if (socket != null && socket.isConnected() && socket instanceof SSLSocket) {
            SSLSocket sslSocket = (SSLSocket)socket;
            SSLSession session = sslSocket.getHandshakeSession();
            if (session != null) {
                ProtocolVersion protocolVersion = ProtocolVersion.valueOf(session.getProtocol());
                if (protocolVersion.v >= ProtocolVersion.TLS12.v) {
                    String[] peerSupportedSignAlgs = null;
                    if (session instanceof ExtendedSSLSession) {
                        ExtendedSSLSession extSession = (ExtendedSSLSession)session;
                        peerSupportedSignAlgs = extSession.getPeerSupportedSignatureAlgorithms();
                    }
                    return new SSLAlgorithmConstraints(sslSocket, peerSupportedSignAlgs, true);
                }
            }
            return new SSLAlgorithmConstraints(sslSocket, true);
        }
        return new SSLAlgorithmConstraints((SSLSocket)null, true);
    }

    private AlgorithmConstraints getAlgorithmConstraints(SSLEngine engine) {
        SSLSession session;
        if (engine != null && (session = engine.getHandshakeSession()) != null) {
            ProtocolVersion protocolVersion = ProtocolVersion.valueOf(session.getProtocol());
            if (protocolVersion.v >= ProtocolVersion.TLS12.v) {
                String[] peerSupportedSignAlgs = null;
                if (session instanceof ExtendedSSLSession) {
                    ExtendedSSLSession extSession = (ExtendedSSLSession)session;
                    peerSupportedSignAlgs = extSession.getPeerSupportedSignatureAlgorithms();
                }
                return new SSLAlgorithmConstraints(engine, peerSupportedSignAlgs, true);
            }
        }
        return new SSLAlgorithmConstraints(engine, true);
    }

    private String makeAlias(EntryStatus entry) {
        return this.uidCounter.incrementAndGet() + "." + entry.builderIndex + "." + entry.alias;
    }

    private KeyStore.PrivateKeyEntry getEntry(String alias) {
        KeyStore.PrivateKeyEntry entry;
        if (alias == null) {
            return null;
        }
        Reference<KeyStore.PrivateKeyEntry> ref = this.entryCacheMap.get(alias);
        KeyStore.PrivateKeyEntry privateKeyEntry = entry = ref != null ? ref.get() : null;
        if (entry != null) {
            return entry;
        }
        int firstDot = alias.indexOf(46);
        int secondDot = alias.indexOf(46, firstDot + 1);
        if (firstDot == -1 || secondDot == firstDot) {
            return null;
        }
        try {
            int builderIndex = Integer.parseInt(alias.substring(firstDot + 1, secondDot));
            String keyStoreAlias = alias.substring(secondDot + 1);
            KeyStore.Builder builder = this.builders.get(builderIndex);
            KeyStore ks = builder.getKeyStore();
            KeyStore.Entry newEntry = ks.getEntry(keyStoreAlias, builder.getProtectionParameter(alias));
            if (!(newEntry instanceof KeyStore.PrivateKeyEntry)) {
                return null;
            }
            entry = (KeyStore.PrivateKeyEntry)newEntry;
            this.entryCacheMap.put(alias, new SoftReference<KeyStore.PrivateKeyEntry>(entry));
            return entry;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static List<KeyType> getKeyTypes(String ... keyTypes) {
        if (keyTypes == null || keyTypes.length == 0 || keyTypes[0] == null) {
            return null;
        }
        ArrayList<KeyType> list = new ArrayList<KeyType>(keyTypes.length);
        for (String keyType : keyTypes) {
            list.add(new KeyType(keyType));
        }
        return list;
    }

    private String chooseAlias(List<KeyType> keyTypeList, Principal[] issuers, CheckType checkType, AlgorithmConstraints constraints) {
        if (keyTypeList == null || keyTypeList.size() == 0) {
            return null;
        }
        Set<Principal> issuerSet = this.getIssuerSet(issuers);
        ArrayList<EntryStatus> allResults = null;
        int n = this.builders.size();
        for (int i = 0; i < n; ++i) {
            try {
                List<EntryStatus> results = this.getAliases(i, keyTypeList, issuerSet, false, checkType, constraints);
                if (results == null) continue;
                EntryStatus status = results.get(0);
                if (status.checkResult == CheckResult.OK) {
                    if (useDebug) {
                        debug.println("KeyMgr: choosing key: " + status);
                    }
                    return this.makeAlias(status);
                }
                if (allResults == null) {
                    allResults = new ArrayList<EntryStatus>();
                }
                allResults.addAll(results);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (allResults == null) {
            if (useDebug) {
                debug.println("KeyMgr: no matching key found");
            }
            return null;
        }
        Collections.sort(allResults);
        if (useDebug) {
            debug.println("KeyMgr: no good matching key found, returning best match out of:");
            debug.println(((Object)allResults).toString());
        }
        return this.makeAlias((EntryStatus)allResults.get(0));
    }

    public String[] getAliases(String keyType, Principal[] issuers, CheckType checkType, AlgorithmConstraints constraints) {
        if (keyType == null) {
            return null;
        }
        Set<Principal> issuerSet = this.getIssuerSet(issuers);
        List<KeyType> keyTypeList = X509KeyManagerImpl.getKeyTypes(keyType);
        ArrayList<EntryStatus> allResults = null;
        int n = this.builders.size();
        for (int i = 0; i < n; ++i) {
            try {
                List<EntryStatus> results = this.getAliases(i, keyTypeList, issuerSet, true, checkType, constraints);
                if (results == null) continue;
                if (allResults == null) {
                    allResults = new ArrayList<EntryStatus>();
                }
                allResults.addAll(results);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (allResults == null || allResults.size() == 0) {
            if (useDebug) {
                debug.println("KeyMgr: no matching alias found");
            }
            return null;
        }
        Collections.sort(allResults);
        if (useDebug) {
            debug.println("KeyMgr: getting aliases: " + allResults);
        }
        return this.toAliases((List<EntryStatus>)allResults);
    }

    private String[] toAliases(List<EntryStatus> results) {
        String[] s = new String[results.size()];
        int i = 0;
        for (EntryStatus result : results) {
            s[i++] = this.makeAlias(result);
        }
        return s;
    }

    private Set<Principal> getIssuerSet(Principal[] issuers) {
        if (issuers != null && issuers.length != 0) {
            return new HashSet<Principal>(Arrays.asList(issuers));
        }
        return null;
    }

    private List<EntryStatus> getAliases(int builderIndex, List<KeyType> keyTypes, Set<Principal> issuerSet, boolean findAll, CheckType checkType, AlgorithmConstraints constraints) throws Exception {
        KeyStore.Builder builder = this.builders.get(builderIndex);
        KeyStore ks = builder.getKeyStore();
        ArrayList<EntryStatus> results = null;
        Date date = verificationDate;
        boolean preferred = false;
        Enumeration<String> e = ks.aliases();
        while (e.hasMoreElements()) {
            Certificate[] chain;
            String alias = e.nextElement();
            if (!ks.isKeyEntry(alias) || (chain = ks.getCertificateChain(alias)) == null || chain.length == 0) continue;
            boolean incompatible = false;
            for (Certificate cert : chain) {
                if (cert instanceof X509Certificate) continue;
                incompatible = true;
                break;
            }
            if (incompatible) continue;
            int keyIndex = -1;
            int j = 0;
            for (KeyType keyType : keyTypes) {
                if (keyType.matches(chain)) {
                    keyIndex = j;
                    break;
                }
                ++j;
            }
            if (keyIndex == -1) {
                if (!useDebug) continue;
                debug.println("Ignoring alias " + alias + ": key algorithm does not match");
                continue;
            }
            if (issuerSet != null) {
                boolean found = false;
                for (Certificate cert : chain) {
                    X509Certificate xcert = (X509Certificate)cert;
                    if (!issuerSet.contains(xcert.getIssuerX500Principal())) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    if (!useDebug) continue;
                    debug.println("Ignoring alias " + alias + ": issuers do not match");
                    continue;
                }
            }
            if (constraints != null && !X509KeyManagerImpl.conformsToAlgorithmConstraints(constraints, chain)) {
                if (!useDebug) continue;
                debug.println("Ignoring alias " + alias + ": certificate list does not conform to " + "algorithm constraints");
                continue;
            }
            if (date == null) {
                date = new Date();
            }
            CheckResult checkResult = checkType.check((X509Certificate)chain[0], date);
            EntryStatus status = new EntryStatus(builderIndex, keyIndex, alias, chain, checkResult);
            if (!preferred && checkResult == CheckResult.OK && keyIndex == 0) {
                preferred = true;
            }
            if (preferred && !findAll) {
                return Collections.singletonList(status);
            }
            if (results == null) {
                results = new ArrayList<EntryStatus>();
            }
            results.add(status);
        }
        return results;
    }

    private static boolean conformsToAlgorithmConstraints(AlgorithmConstraints constraints, Certificate[] chain) {
        AlgorithmChecker checker = new AlgorithmChecker(constraints);
        try {
            checker.init(false);
        }
        catch (CertPathValidatorException cpve) {
            return false;
        }
        for (int i = chain.length - 1; i >= 0; --i) {
            Certificate cert = chain[i];
            try {
                checker.check(cert, Collections.emptySet());
                continue;
            }
            catch (CertPathValidatorException cpve) {
                return false;
            }
        }
        return true;
    }

    private static enum CheckResult {
        OK,
        EXPIRED,
        EXTENSION_MISMATCH;

    }

    private static enum CheckType {
        NONE(Collections.emptySet()),
        CLIENT(new HashSet<String>(Arrays.asList("2.5.29.37.0", "1.3.6.1.5.5.7.3.2"))),
        SERVER(new HashSet<String>(Arrays.asList("2.5.29.37.0", "1.3.6.1.5.5.7.3.1", "2.16.840.1.113730.4.1", "1.3.6.1.4.1.311.10.3.3")));

        final Set<String> validEku;

        private CheckType(Set<String> validEku) {
            this.validEku = validEku;
        }

        private static boolean getBit(boolean[] keyUsage, int bit) {
            return bit < keyUsage.length && keyUsage[bit];
        }

        CheckResult check(X509Certificate cert, Date date) {
            if (this == NONE) {
                return CheckResult.OK;
            }
            try {
                List<String> certEku = cert.getExtendedKeyUsage();
                if (certEku != null && Collections.disjoint(this.validEku, certEku)) {
                    return CheckResult.EXTENSION_MISMATCH;
                }
                boolean[] ku = cert.getKeyUsage();
                if (ku != null) {
                    String algorithm = cert.getPublicKey().getAlgorithm();
                    boolean kuSignature = CheckType.getBit(ku, 0);
                    if (algorithm.equals("RSA")) {
                        if (!(kuSignature || this != CLIENT && CheckType.getBit(ku, 2))) {
                            return CheckResult.EXTENSION_MISMATCH;
                        }
                    } else if (algorithm.equals("DSA")) {
                        if (!kuSignature) {
                            return CheckResult.EXTENSION_MISMATCH;
                        }
                    } else if (algorithm.equals("DH")) {
                        if (!CheckType.getBit(ku, 4)) {
                            return CheckResult.EXTENSION_MISMATCH;
                        }
                    } else if (algorithm.equals("EC")) {
                        if (!kuSignature) {
                            return CheckResult.EXTENSION_MISMATCH;
                        }
                        if (this == SERVER && !CheckType.getBit(ku, 4)) {
                            return CheckResult.EXTENSION_MISMATCH;
                        }
                    }
                }
            }
            catch (CertificateException e) {
                return CheckResult.EXTENSION_MISMATCH;
            }
            try {
                cert.checkValidity(date);
                return CheckResult.OK;
            }
            catch (CertificateException e) {
                return CheckResult.EXPIRED;
            }
        }
    }

    private static class EntryStatus
    implements Comparable<EntryStatus> {
        final int builderIndex;
        final int keyIndex;
        final String alias;
        final CheckResult checkResult;

        EntryStatus(int builderIndex, int keyIndex, String alias, Certificate[] chain, CheckResult checkResult) {
            this.builderIndex = builderIndex;
            this.keyIndex = keyIndex;
            this.alias = alias;
            this.checkResult = checkResult;
        }

        @Override
        public int compareTo(EntryStatus other) {
            int result = this.checkResult.compareTo(other.checkResult);
            return result == 0 ? this.keyIndex - other.keyIndex : result;
        }

        public String toString() {
            String s = this.alias + " (verified: " + (Object)((Object)this.checkResult) + ")";
            if (this.builderIndex == 0) {
                return s;
            }
            return "Builder #" + this.builderIndex + ", alias: " + s;
        }
    }

    private static class KeyType {
        final String keyAlgorithm;
        final String sigKeyAlgorithm;

        KeyType(String algorithm) {
            int k = algorithm.indexOf("_");
            if (k == -1) {
                this.keyAlgorithm = algorithm;
                this.sigKeyAlgorithm = null;
            } else {
                this.keyAlgorithm = algorithm.substring(0, k);
                this.sigKeyAlgorithm = algorithm.substring(k + 1);
            }
        }

        boolean matches(Certificate[] chain) {
            if (!chain[0].getPublicKey().getAlgorithm().equals(this.keyAlgorithm)) {
                return false;
            }
            if (this.sigKeyAlgorithm == null) {
                return true;
            }
            if (chain.length > 1) {
                return this.sigKeyAlgorithm.equals(chain[1].getPublicKey().getAlgorithm());
            }
            X509Certificate issuer = (X509Certificate)chain[0];
            String sigAlgName = issuer.getSigAlgName().toUpperCase(Locale.ENGLISH);
            String pattern = "WITH" + this.sigKeyAlgorithm.toUpperCase(Locale.ENGLISH);
            return sigAlgName.contains(pattern);
        }
    }

    private static class SizedMap<K, V>
    extends LinkedHashMap<K, V> {
        private SizedMap() {
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > 10;
        }
    }
}

