/*
 * Decompiled with CFR 0.152.
 */
package freemind.view.mindmapview.attributeview;

import freemind.main.Resources;
import freemind.view.mindmapview.attributeview.AttributeTable;
import freemind.view.mindmapview.attributeview.AttributeTableModelDecoratorAdapter;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;

public class AttributePopupMenu
extends JPopupMenu
implements MouseListener {
    private JMenuItem edit = null;
    private JMenuItem optimalWidth = null;
    private JMenuItem hide = null;
    private JMenuItem insert = null;
    private JMenuItem delete = null;
    private JMenuItem up = null;
    private JMenuItem down = null;
    private AttributeTable table;
    private int row;
    private boolean oldTable;

    private JMenuItem getOptimalWidth() {
        if (this.optimalWidth == null) {
            this.optimalWidth = new JMenuItem(Resources.getInstance().getResourceString("attributes_popup_optimal_width"));
            this.optimalWidth.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AttributePopupMenu.this.table.setOptimalColumnWidths();
                }
            });
        }
        return this.optimalWidth;
    }

    private JMenuItem getInsert() {
        if (this.insert == null) {
            this.insert = new JMenuItem(Resources.getInstance().getResourceString("attributes_popup_new"));
            this.insert.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AttributePopupMenu.this.table.insertRow(AttributePopupMenu.this.row + 1);
                }
            });
        }
        return this.insert;
    }

    private JMenuItem getDelete() {
        if (this.delete == null) {
            this.delete = new JMenuItem(Resources.getInstance().getResourceString("attributes_popup_delete"));
            this.delete.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AttributePopupMenu.this.table.removeRow(AttributePopupMenu.this.row);
                }
            });
        }
        return this.delete;
    }

    private JMenuItem getUp() {
        if (this.up == null) {
            this.up = new JMenuItem(Resources.getInstance().getResourceString("attributes_popup_up"));
            this.up.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AttributePopupMenu.this.table.moveRowUp(AttributePopupMenu.this.row);
                }
            });
        }
        return this.up;
    }

    private JMenuItem getDown() {
        if (this.down == null) {
            this.down = new JMenuItem(Resources.getInstance().getResourceString("attributes_popup_down"));
            this.down.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AttributePopupMenu.this.table.moveRowDown(AttributePopupMenu.this.row);
                }
            });
        }
        return this.down;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.maybeShowPopup(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.maybeShowPopup(e);
    }

    private void maybeShowPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.selectTable(e.getComponent(), e.getPoint());
            this.make();
            this.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private void make() {
        String attributeViewType = this.table.getAttributeView().getViewType();
        AttributeTableModelDecoratorAdapter model = this.table.getAttributeTableModel();
        int rowCount = model.getRowCount();
        if (attributeViewType.equals("extended")) {
            if (rowCount != 0) {
                this.add(this.getOptimalWidth());
            }
            this.add(this.getInsert());
            if (this.row != -1) {
                this.add(this.getDelete());
                if (this.row != 0) {
                    this.add(this.getUp());
                }
                if (this.row != rowCount - 1) {
                    this.add(this.getDown());
                }
            }
        } else if (rowCount != 0) {
            this.add(this.getOptimalWidth());
        }
    }

    private void selectTable(Component component, Point point) throws AssertionError {
        int componentCount;
        int i = componentCount = this.getComponentCount();
        while (i > 0) {
            this.remove(--i);
        }
        if (component instanceof AttributeTable) {
            this.oldTable = false;
            this.table = (AttributeTable)component;
            this.row = this.table.rowAtPoint(point);
            if (this.table.getValueAt(this.row, 0).equals("")) {
                --this.row;
            }
            int selectedRow = this.table.getSelectedRow();
        } else if (component instanceof JTableHeader) {
            this.oldTable = false;
            JTableHeader header = (JTableHeader)component;
            this.table = (AttributeTable)header.getTable();
            this.row = -1;
        } else {
            throw new AssertionError();
        }
        this.table.requestFocus();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    protected void firePopupMenuWillBecomeInvisible() {
        if (this.row != -1) {
            this.table.removeRowSelectionInterval(this.row, this.row);
        }
        this.oldTable = true;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!AttributePopupMenu.this.oldTable) {
                    return;
                }
                KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                Container focusOwner = SwingUtilities.getAncestorOfClass(AttributeTable.class, focusManager.getFocusOwner());
                if (AttributePopupMenu.this.table != focusOwner && focusOwner instanceof JComponent) {
                    AttributePopupMenu.this.table.requestFocus(true);
                    ((JComponent)focusOwner).requestFocus();
                }
                AttributePopupMenu.this.table = null;
            }
        });
    }

    @Override
    protected void firePopupMenuWillBecomeVisible() {
        if (this.row != -1) {
            this.table.addRowSelectionInterval(this.row, this.row);
        }
    }

    public AttributeTable getTable() {
        return this.table;
    }
}

