#############################################################################
##
#W  extreme/oper.tst
#Y  Copyright (C) 2015                                   James D. Mitchell
##                                                       Michael C. Torpey
##
##  Licensing information can be found in the README file of this package.
##
#############################################################################
##
gap> START_TEST("Digraphs package: extreme/oper.tst");
gap> LoadPackage("digraphs", false);;

#
gap> DIGRAPHS_StartTest();

#T# OutNeighboursCopy 1
# For a digraph with lots of edges: digraphs-lib/extreme.d6.gz
gap> gr := ReadDigraphs(Concatenation(DIGRAPHS_Dir(),
>                       "/digraphs-lib/extreme.d6.gz"), 1);
<digraph with 5000 vertices, 4211332 edges>
gap> out := OutNeighboursCopy(gr);;
gap> out := OutNeighborsCopy(gr);;
gap> IsMutable(out);
true
gap> ForAll(out, IsMutable);
true
gap> out[1] := "a";
"a"
gap> OutNeighbours(gr)[1];
[ 4531, 4166, 685, 1356, 2644, 4177, 595, 295, 2650, 3523, 1363, 903, 1244, 
  3497, 3043, 2831, 2584, 2239, 4970, 3946, 767, 4280, 618, 1958, 4555, 3891, 
  1463, 2242, 4892, 173, 625, 3520, 4426, 3218, 395, 2009, 2796, 4284, 583, 
  1923, 2557, 1948, 4573, 4021, 96, 2973, 3573, 4439, 3058, 1871, 544, 4407, 
  1398, 3358, 4289, 2581, 2541, 2454, 4944, 1229, 952, 1884, 438, 1952, 1962, 
  2900, 4717, 1692, 866, 467, 3623, 2375, 1467, 4740, 4819, 3994, 1676, 3830, 
  2362, 3168, 1666, 4518, 4254, 4657, 3242, 130, 3009, 4586, 2226, 216, 3044, 
  2507, 92, 1708, 3963, 1849, 8, 3327, 2567, 3501, 3937, 696, 4089, 4905, 
  4997, 495, 4983, 637, 930, 507, 4237, 3729, 1910, 2589, 264, 4574, 3325, 
  1447, 3976, 3540, 4391, 663, 2103, 4364, 1913, 4556, 2977, 4382, 2022, 
  3877, 3947, 4921, 4111, 1285, 1779, 3957, 2693, 4287, 1777, 3194, 3172, 87, 
  2268, 1420, 4060, 435, 2523, 3483, 3512, 229, 4945, 2025, 3919, 2019, 3579, 
  889, 4662, 1390, 786, 2230, 477, 2813, 2077, 2281, 1254, 600, 870, 2342, 
  4465, 3659, 4308, 4866, 4408, 1602, 2713, 4130, 4052, 148, 857, 1975, 4674, 
  617, 4326, 569, 3509, 49, 420, 3973, 3453, 4373, 1687, 1342, 2753, 3114, 
  2791, 2187, 2576, 1888, 1943, 2794, 416, 4683, 1381, 1856, 4074, 524, 2739, 
  446, 4853, 4293, 52, 4564, 1124, 1403, 4903, 3137, 4731, 4315, 3153, 1455, 
  360, 4421, 3733, 2481, 3772, 4081, 1490, 2308, 3672, 3331, 1606, 2285, 
  3538, 351, 4322, 455, 214, 3391, 1107, 2305, 88, 4969, 3144, 3631, 1293, 
  4090, 308, 1289, 1931, 1674, 4909, 4900, 3, 2678, 4547, 4644, 876, 1873, 
  253, 4842, 4687, 4935, 2662, 297, 936, 817, 135, 2409, 3775, 1578, 2518, 
  2063, 3759, 2976, 3275, 3367, 3292, 3126, 3348, 3425, 3993, 1346, 2364, 
  2843, 98, 3250, 2697, 1202, 2880, 1071, 381, 1048, 4544, 4269, 1494, 3066, 
  543, 4795, 787, 1359, 4894, 965, 470, 3481, 4438, 2238, 1565, 3239, 3744, 
  1277, 4576, 1745, 270, 312, 4579, 1627, 4638, 2221, 4871, 43, 1228, 1316, 
  1385, 1665, 3211, 82, 1998, 1504, 1136, 3494, 3996, 1437, 2740, 1584, 3102, 
  4147, 2588, 4508, 3763, 56, 105, 1909, 237, 2941, 4002, 4703, 2564, 3966, 
  1382, 1935, 282, 4813, 71, 4075, 60, 2872, 2744, 407, 4114, 727, 1796, 
  1033, 4562, 678, 3910, 4982, 1752, 4767, 2276, 3382, 834, 4151, 533, 662, 
  3235, 2400, 2354, 347, 37, 4210, 4698, 4835, 3691, 4950, 3055, 4779, 3465, 
  2692, 740, 2301, 1401, 4079, 3352, 1113, 2323, 4728, 3757, 1933, 3074, 170, 
  1689, 3070, 3052, 2404, 1405, 1075, 4882, 4549, 189, 3790, 3874, 4691, 
  2916, 2030, 4348, 815, 1281, 276, 2442, 4015, 558, 4991, 4485, 2190, 4545, 
  4721, 1881, 3466, 324, 4120, 2141, 4817, 419, 3169, 1370, 1367, 1782, 1415, 
  3130, 3992, 745, 1715, 510, 2100, 2347, 4601, 120, 2529, 2500, 123, 4886, 
  1127, 3504, 2867, 555, 728, 3979, 610, 1084, 1307, 4336, 4908, 551, 1746, 
  80, 4942, 2808, 101, 1843, 4010, 4358, 781, 4855, 4953, 392, 4859, 3486, 
  2929, 1830, 3502, 2637, 743, 4975, 346, 245, 1588, 3636, 785, 3252, 3283, 
  2590, 908, 911, 2017, 4774, 2385, 4149, 4413, 3614, 2233, 3788, 3647, 4715, 
  2807, 2351, 2504, 1548, 1751, 2013, 4313, 4180, 454, 3699, 2273, 4288, 
  2178, 2659, 683, 2573, 4144, 2327, 1776, 593, 4305, 3031, 1643, 3065, 4863, 
  4457, 2517, 3944, 4283, 3140, 1839, 4604, 1357, 3287, 2767, 4640, 3249, 
  3746, 3468, 4146, 4880, 2616, 4955, 3008, 665, 2508, 4017, 4716, 3673, 
  4990, 388, 3739, 1693, 4832, 4587, 354, 3010, 1587, 232, 42, 4026, 2665, 
  3295, 2901, 3995, 3894, 3686, 2940, 1070, 3662, 4510, 4771, 26, 2772, 3765, 
  3748, 331, 2897, 2879, 2367, 2208, 1773, 1703, 3177, 4885, 4276, 4672, 145, 
  1166, 4847, 4553, 620, 3251, 4464, 3574, 1091, 3118, 4299, 2926, 4202, 
  4615, 2153, 2857, 1234, 4356, 1059, 4252, 2395, 845, 1258, 118, 4273, 1056, 
  1379, 3345, 4947, 275, 3909, 3195, 67, 2303, 4841, 4550, 4104, 2907, 4167, 
  3084, 2189, 3658, 553, 2546, 28, 3398, 1157, 2127, 3248, 306, 3694, 2455, 
  2524, 2887, 208, 239, 3903, 3227, 2202, 320, 1097, 3001, 2719, 1197, 4972, 
  6, 233, 3855, 1148, 3237, 4217, 1964, 1855, 4534, 3241, 2964, 4257, 2441, 
  3113, 1694, 1139, 1078, 2712, 1893, 4596, 4788, 1478, 3434, 1634, 212, 
  3472, 4826, 1279, 501, 1651, 3626, 3135, 948, 2552, 1275, 2334, 2006, 2811, 
  807, 3820, 220, 3561, 772, 1938, 4432, 2680, 1083, 414, 457, 4784, 2577, 
  4746, 2476, 4766, 3853, 1126, 4666, 1653, 1108, 3362, 2803, 1431, 3756, 
  2607, 4401, 2112, 1448, 4152, 4912, 3730, 3536, 3371, 4092, 751, 3551, 
  1877, 129, 204, 304, 2403, 4872, 3176, 4425, 4548, 2336, 352, 1165, 2755, 
  2792, 4183, 1294, 4569, 301, 2411, 3923, 1971, 2568, 4056, 2007, 3635, 478, 
  3807, 2213, 3612, 121, 2913, 4928, 3816, 1727, 2903, 4893, 4506, 4802, 
  4697, 1629, 1679, 2558, 644, 1824, 4754, 3390, 1438, 3988, 4325, 2173, 
  1338, 1341, 3617, 2578, 4739, 2185, 2591, 2812, 2008, 2171, 2827, 4396, 
  4519, 3842, 4375, 651, 3191, 1981, 796, 336, 3584, 449, 3625, 4039, 2871, 
  1867, 1973, 3567, 1473, 4649, 483, 2542, 4030, 2038, 579, 195, 910, 746, 
  1633, 1465, 2996, 4705, 4043, 426, 2778, 2627, 691, 4361, 3322, 2853, 4253, 
  3050, 3789, 4192, 3899, 3432, 4833, 363, 459, 4182, 3178, 4850, 2350, 2554, 
  550, 4572, 1972, 890, 2938, 3341, 3661, 1594, 2599, 2775, 4175, 1221, 3709, 
  2113, 111, 2122, 1026, 3864, 4265, 3854, 823, 975, 4783, 675, 3336 ]

#T# DigraphReverseEdges 1
# For a digraph with lots of edges: digraphs-lib/extreme.d6.gz
gap> d := ReadDigraphs(Concatenation(DIGRAPHS_Dir(),
>                      "/digraphs-lib/extreme.ds6.gz"))[1];;
gap> DigraphReverseEdges(d, [12, 2001, 401000]);
<digraph with 113082 vertices, 451854 edges>
gap> DigraphReverseEdge(d, [95000, 4067]);
<digraph with 113082 vertices, 451854 edges>

#T# DigraphLayers
gap> list := ReadDigraphs(Concatenation(DIGRAPHS_Dir(),
> "/digraphs-lib/fining.p.gz"));;
gap> gr := list[4];;
gap> gr2 := DigraphCopy(gr);;
gap> layers1 := List(DigraphLayers(gr, 1), x -> Set(x));;
gap> layers2 := List(DigraphLayers(gr2, 1), x -> Set(x));;
gap> layers1 = layers2;
true
gap> layers := [];;
gap> for i in list do
> Add(layers, DigraphLayers(i, 1));
> od;
gap> List(layers, x -> Size(x));
[ 3, 3, 5, 5, 7, 9 ]
gap> gr := list[4];;
gap> DigraphLayers(gr, 1);
[ [ 1 ], [ 41, 50, 59, 68 ], [ 2, 3, 4, 5, 8, 10, 14, 27, 28, 31, 34, 37 ], 
  [ 42, 43, 44, 45, 46, 47, 48, 49, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 
      62, 63, 64, 65, 66, 67, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80 ]
    , [ 6, 7, 9, 11, 12, 13, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 
      29, 30, 32, 33, 35, 36, 38, 39, 40 ] ]
gap> DigraphLayers(gr, 2);
[ [ 2 ], [ 41, 51, 60, 76 ], [ 5, 6, 7, 1, 13, 15, 19, 23, 29, 32, 34, 38 ], 
  [ 42, 43, 44, 45, 46, 47, 48, 49, 53, 54, 50, 56, 57, 52, 58, 55, 62, 63, 
      59, 65, 66, 61, 67, 64, 73, 71, 75, 68, 74, 69, 70, 72, 77, 78, 79, 80 ]
    , [ 11, 12, 14, 3, 4, 18, 20, 21, 22, 8, 9, 10, 24, 25, 26, 16, 17, 27, 
      30, 28, 33, 31, 35, 36, 39, 37, 40 ] ]
gap> DigraphLayers(gr, 8);
[ [ 8 ], [ 44, 50, 64, 71 ], [ 13, 1, 16, 18, 3, 23, 7, 25, 28, 33, 36, 39 ], 
  [ 41, 47, 42, 43, 49, 45, 46, 48, 51, 52, 53, 54, 55, 56, 57, 58, 66, 59, 
      67, 60, 61, 62, 63, 65, 68, 74, 69, 70, 76, 72, 73, 75, 77, 78, 79, 80 ]
    , [ 2, 21, 4, 5, 24, 6, 26, 9, 10, 11, 12, 27, 14, 15, 17, 19, 20, 22, 
      29, 30, 31, 32, 34, 35, 37, 38, 40 ] ]
gap> DigraphLayers(gr, 12);
[ [ 12 ], [ 43, 56, 62, 75 ], [ 4, 19, 20, 7, 24, 5, 17, 13, 28, 33, 35, 37 ],
  [ 45, 46, 47, 48, 41, 49, 42, 44, 52, 58, 54, 55, 53, 57, 50, 51, 59, 65, 
      60, 61, 67, 63, 64, 66, 76, 69, 73, 71, 72, 68, 74, 70, 77, 78, 79, 80 ]
    , [ 9, 10, 25, 14, 15, 16, 1, 27, 11, 21, 22, 2, 23, 3, 18, 26, 6, 8, 29, 
      30, 31, 32, 36, 34, 38, 39, 40 ] ]
gap> DigraphLayers(gr, 28);
[ [ 28 ], [ 50, 56, 57, 77 ], [ 1, 3, 12, 8, 19, 15, 24, 22, 26, 29, 30, 40 ],
  [ 41, 42, 43, 44, 45, 46, 47, 48, 49, 51, 52, 58, 53, 54, 55, 59, 61, 62, 
      64, 65, 60, 67, 63, 66, 68, 69, 75, 71, 76, 74, 73, 70, 72, 78, 79, 80 ]
    , [ 2, 6, 4, 13, 9, 20, 16, 25, 27, 5, 11, 7, 18, 14, 10, 21, 17, 23, 31, 
      32, 33, 34, 35, 36, 37, 38, 39 ] ]
gap> gr := list[5];
<digraph with 2730 vertices, 13650 edges>
gap> DigraphOrbitReps(gr);
[ 1, 1366 ]
gap> Size(DigraphLayers(gr, 1));
7
gap> Size(DigraphLayers(gr, 1366));
7
gap> Size(DigraphLayers(gr, 7));
7
gap> DigraphLayers(gr, 1)[2];
[ 1366, 1368, 1369, 1370, 1367 ]
gap> DigraphLayers(gr, 1366)[2];
[ 1, 351, 343, 9, 341 ]
gap> DigraphLayers(gr, 6)[2];
[ 2144, 1391, 2395, 2544, 2645 ]
gap> DigraphLayers(gr, 1500)[2];
[ 81, 254, 253, 82, 169 ]

#T# DIGRAPHS_UnbindVariables
gap> Unbind(d);
gap> Unbind(gr);
gap> Unbind(gr2);
gap> Unbind(i);
gap> Unbind(layers);
gap> Unbind(layers1);
gap> Unbind(layers2);
gap> Unbind(list);
gap> Unbind(out);

#E#
gap> STOP_TEST("Digraphs package: extreme/oper.tst");
