#############################################################################
##
#W  subgroups.g                GAP4 Package `RCWA'                Stefan Kohl
##
##  Data library of groups generated by 3 class transpositions which inter-
##  change residue classes with moduli <= 6: part containing lists of
##  subgroups.
##
##  For all i in [1..52394], subgroups[i] is a list of all indices j such
##  that grps[j] is a subgroup of grps[i].
##
#############################################################################

return 
[[2279],[2279],[202,1625,10077,17521],[268,2479],[328],[393,2604],[202,1625,10077,17521],
 [328],[569,2780],[268,2479],[569,2780],[393,2604],[],[],[],[],[],[],[],
 [],[],[],[1625,3507,3520,3836,38497],
 [23,26,31,32,41,42,44,89,90,91,92,93,94,107,156,158,163,166,173,177,1289,1290,1291,1292,
   1293,1296,1298,1300,1306,1309,1311,1313,1333,1334,1335,1336,1339,1340,1341,1343,1349,1350,
   1352,1354,1356,1376,1377,1378,1381,1382,1383,1385,1392,1394,1396,1398,1418,1419,1422,1423,
   1432,1433,1435,1459,1462,1463,1464,1466,1473,1475,1477,1479,1501,1502,1503,1505,1511,1512,
   1514,1516,1518,1613,1614,1616,1622,1623,1625,1627,1629,1649,1651,1657,1658,1660,1662,1664,
   1685,1691,1692,1694,1696,1698,1756,1757,1759,1761,1763,1928,1930,1932,1934,1955,1957,1959,
   2004,2006,2049,2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,3501,
   3502,3503,3504,3507,3508,3509,3511,3517,3518,3520,3522,3524,3544,3545,3546,3547,3550,3551,
   3552,3554,3560,3561,3563,3565,3567,3587,3588,3589,3592,3593,3594,3596,3602,3603,3605,3607,
   3609,3629,3630,3633,3634,3635,3637,3643,3644,3646,3648,3650,3670,3673,3674,3675,3677,3683,
   3684,3688,3690,3712,3713,3714,3716,3722,3723,3727,3729,3824,3825,3827,3833,3834,3836,3838,
   3840,3860,3862,3868,3869,3871,3873,3875,3896,3902,3903,3907,3909,3967,3968,3972,3974,4139,
   4141,4143,4145,4166,4168,4170,4215,4217,4260,4510,4511,4512,4518,4528,4529,5645,5646,5647,
   5648,5649,5652,5653,5654,5656,5662,5663,5665,5667,5669,5689,5690,5691,5692,5695,5696,5697,
   5699,5705,5706,5708,5710,5712,5732,5733,5734,5737,5738,5739,5741,5747,5748,5750,5752,5754,
   5774,5775,5778,5779,5780,5782,5788,5789,5791,5793,5795,5815,5818,5819,5820,5822,5828,5829,
   5831,5833,5835,5857,5861,5867,5868,5874,5969,5970,5972,5978,5979,5981,5983,5985,6005,6007,
   6013,6014,6016,6018,6020,6041,6047,6048,6050,6052,6054,6112,6113,6115,6117,6119,6284,6286,
   6288,6290,6311,6313,6315,6360,6362,6405,7725,7726,7727,7728,7729,7732,7733,7734,7736,7742,
   7743,7745,7747,7749,7769,7770,7771,7772,7775,7776,7777,7779,7785,7786,7788,7790,7792,7812,
   7813,7814,7817,7818,7819,7821,7827,7828,7830,7832,7834,7854,7855,7858,7859,7862,7868,7869,
   7871,7873,7875,7895,7898,7899,7900,7902,7908,7909,7911,7913,7915,7937,7938,7941,7947,7948,
   7950,7952,7954,8049,8050,8052,8058,8059,8061,8063,8065,8085,8087,8093,8094,8096,8098,8100,
   8121,8127,8128,8132,8192,8193,8195,8197,8199,8364,8366,8368,8370,8391,8393,8395,8440,8442,
   8485,38205,38206,38207,38208,38211,38212,38213,38215,38221,38222,38224,38226,38228,38248,38249,
   38250,38253,38254,38255,38257,38263,38264,38266,38268,38270,38290,38291,38294,38295,38296,38298,
   38304,38305,38307,38309,38311,38331,38334,38335,38336,38338,38344,38345,38347,38349,38351,38373,
   38374,38375,38377,38383,38384,38386,38388,38390,38485,38486,38488,38494,38495,38497,38499,38501,
   38521,38523,38529,38532,38534,38536,38557,38563,38564,38566,38568,38570,38628,38629,38631,38633,
   38635,38800,38802,38804,38806,38827,38829,38831,38876,38878,38921,39151,39152,39153,39156,39157,
   39158,39160,39166,39167,39169,39171,39173,39193,39194,39197,39198,39199,39201,39207,39208,39210,
   39212,39214,39234,39237,39238,39239,39241,39247,39248,39250,39252,39254,39276,39277,39278,39280,
   39286,39287,39289,39291,39293,39388,39389,39391,39397,39398,39400,39402,39424,39426,39432,39433,
   39435,39437,39439,39460,39466,39467,39469,39471,39473,39531,39534,39536,39538,39703,39705,39707,
   39709,39730,39732,39734,39779,39781,39824,40054,40055,40058,40059,40060,40062,40068,40069,40071,
   40073,40075,40095,40098,40099,40100,40102,40109,40111,40113,40115,40137,40138,40139,40141,40147,
   40148,40150,40152,40154,40249,40250,40252,40258,40259,40261,40265,40285,40287,40293,40294,40296,
   40298,40300,40321,40327,40328,40330,40332,40334,40392,40393,40395,40397,40399,40564,40566,40568,
   40570,40591,40593,40595,40640,40642,40685,40915,40918,40919,40920,40922,40928,40929,40931,40933,
   40935,40957,40958,40959,40961,40967,40968,40970,40972,40974,41069,41070,41072,41078,41079,41081,
   41083,41085,41105,41107,41113,41114,41116,41118,41120,41141,41147,41148,41150,41152,41212,41213,
   41215,41217,41219,41384,41386,41388,41390,41411,41413,41415,41460,41462,41505,41737,41738,41739,
   41741,41747,41748,41750,41752,41754,41849,41850,41852,41858,41859,41861,41863,41865,41885,41887,
   41893,41894,41896,41898,41900,41921,41927,41928,41930,41932,41934,41992,41993,41997,41999,42164,
   42166,42168,42170,42191,42193,42195,42240,42242,42285,42590,42591,42593,42599,42600,42602,42604,
   42606,42626,42628,42634,42635,42637,42641,42662,42668,42669,42673,42675,42733,42734,42736,42738,
   42740,42905,42907,42909,42911,42932,42934,42936,42981,42983,43026,44625,44627,44633,44634,44636,
   44638,44640,44661,44667,44668,44670,44672,44674,44732,44733,44735,44737,44739,44904,44906,44908,
   44910,44931,44933,44935,44980,44982,45025,45256,45262,45263,45265,45267,45269,45327,45328,45330,
   45332,45334,45499,45501,45503,45505,45526,45528,45530,45575,45577,45620,45888,45889,45891,45893,
   45895,46060,46062,46064,46066,46087,46089,46091,46136,46138,46181,47084,47086,47088,47090,47111,
   47113,47115,47160,47162,47205,49471,49473,49475,49520,49522,49565,49820,49822,49865,50394],
 [23,26,31,32,41,42,44,89,90,91,92,93,94,107,156,158,163,166,173,177,1289,1290,1291,1292,
   1293,1296,1298,1300,1306,1309,1311,1313,1333,1334,1335,1336,1339,1340,1341,1343,1349,1350,
   1352,1354,1356,1376,1377,1378,1381,1382,1383,1385,1392,1394,1396,1398,1418,1419,1422,1423,
   1432,1433,1435,1459,1462,1463,1464,1466,1473,1475,1477,1479,1501,1502,1503,1505,1511,1512,
   1514,1516,1518,1613,1614,1616,1622,1623,1625,1627,1629,1649,1651,1657,1658,1660,1662,1664,
   1685,1691,1692,1694,1696,1698,1756,1757,1759,1761,1763,1928,1930,1932,1934,1955,1957,1959,
   2004,2006,2049,2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,3501,
   3502,3503,3504,3507,3508,3509,3511,3517,3518,3520,3522,3524,3544,3545,3546,3547,3550,3551,
   3552,3554,3560,3561,3563,3565,3567,3587,3588,3589,3592,3593,3594,3596,3602,3603,3605,3607,
   3609,3629,3630,3633,3634,3635,3637,3643,3644,3646,3648,3650,3670,3673,3674,3675,3677,3683,
   3684,3688,3690,3712,3713,3714,3716,3722,3723,3727,3729,3824,3825,3827,3833,3834,3836,3838,
   3840,3860,3862,3868,3869,3871,3873,3875,3896,3902,3903,3907,3909,3967,3968,3972,3974,4139,
   4141,4143,4145,4166,4168,4170,4215,4217,4260,4510,4511,4512,4518,4528,4529,5645,5646,5647,
   5648,5649,5652,5653,5654,5656,5662,5663,5665,5667,5669,5689,5690,5691,5692,5695,5696,5697,
   5699,5705,5706,5708,5710,5712,5732,5733,5734,5737,5738,5739,5741,5747,5748,5750,5752,5754,
   5774,5775,5778,5779,5780,5782,5788,5789,5791,5793,5795,5815,5818,5819,5820,5822,5828,5829,
   5831,5833,5835,5857,5861,5867,5868,5874,5969,5970,5972,5978,5979,5981,5983,5985,6005,6007,
   6013,6014,6016,6018,6020,6041,6047,6048,6050,6052,6054,6112,6113,6115,6117,6119,6284,6286,
   6288,6290,6311,6313,6315,6360,6362,6405,7725,7726,7727,7728,7729,7732,7733,7734,7736,7742,
   7743,7745,7747,7749,7769,7770,7771,7772,7775,7776,7777,7779,7785,7786,7788,7790,7792,7812,
   7813,7814,7817,7818,7819,7821,7827,7828,7830,7832,7834,7854,7855,7858,7859,7862,7868,7869,
   7871,7873,7875,7895,7898,7899,7900,7902,7908,7909,7911,7913,7915,7937,7938,7941,7947,7948,
   7950,7952,7954,8049,8050,8052,8058,8059,8061,8063,8065,8085,8087,8093,8094,8096,8098,8100,
   8121,8127,8128,8132,8192,8193,8195,8197,8199,8364,8366,8368,8370,8391,8393,8395,8440,8442,
   8485,38205,38206,38207,38208,38211,38212,38213,38215,38221,38222,38224,38226,38228,38248,38249,
   38250,38253,38254,38255,38257,38263,38264,38266,38268,38270,38290,38291,38294,38295,38296,38298,
   38304,38305,38307,38309,38311,38331,38334,38335,38336,38338,38344,38345,38347,38349,38351,38373,
   38374,38375,38377,38383,38384,38386,38388,38390,38485,38486,38488,38494,38495,38497,38499,38501,
   38521,38523,38529,38532,38534,38536,38557,38563,38564,38566,38568,38570,38628,38629,38631,38633,
   38635,38800,38802,38804,38806,38827,38829,38831,38876,38878,38921,39151,39152,39153,39156,39157,
   39158,39160,39166,39167,39169,39171,39173,39193,39194,39197,39198,39199,39201,39207,39208,39210,
   39212,39214,39234,39237,39238,39239,39241,39247,39248,39250,39252,39254,39276,39277,39278,39280,
   39286,39287,39289,39291,39293,39388,39389,39391,39397,39398,39400,39402,39424,39426,39432,39433,
   39435,39437,39439,39460,39466,39467,39469,39471,39473,39531,39534,39536,39538,39703,39705,39707,
   39709,39730,39732,39734,39779,39781,39824,40054,40055,40058,40059,40060,40062,40068,40069,40071,
   40073,40075,40095,40098,40099,40100,40102,40109,40111,40113,40115,40137,40138,40139,40141,40147,
   40148,40150,40152,40154,40249,40250,40252,40258,40259,40261,40265,40285,40287,40293,40294,40296,
   40298,40300,40321,40327,40328,40330,40332,40334,40392,40393,40395,40397,40399,40564,40566,40568,
   40570,40591,40593,40595,40640,40642,40685,40915,40918,40919,40920,40922,40928,40929,40931,40933,
   40935,40957,40958,40959,40961,40967,40968,40970,40972,40974,41069,41070,41072,41078,41079,41081,
   41083,41085,41105,41107,41113,41114,41116,41118,41120,41141,41147,41148,41150,41152,41212,41213,
   41215,41217,41219,41384,41386,41388,41390,41411,41413,41415,41460,41462,41505,41737,41738,41739,
   41741,41747,41748,41750,41752,41754,41849,41850,41852,41858,41859,41861,41863,41865,41885,41887,
   41893,41894,41896,41898,41900,41921,41927,41928,41930,41932,41934,41992,41993,41997,41999,42164,
   42166,42168,42170,42191,42193,42195,42240,42242,42285,42590,42591,42593,42599,42600,42602,42604,
   42606,42626,42628,42634,42635,42637,42641,42662,42668,42669,42673,42675,42733,42734,42736,42738,
   42740,42905,42907,42909,42911,42932,42934,42936,42981,42983,43026,44625,44627,44633,44634,44636,
   44638,44640,44661,44667,44668,44670,44672,44674,44732,44733,44735,44737,44739,44904,44906,44908,
   44910,44931,44933,44935,44980,44982,45025,45256,45262,45263,45265,45267,45269,45327,45328,45330,
   45332,45334,45499,45501,45503,45505,45526,45528,45530,45575,45577,45620,45888,45889,45891,45893,
   45895,46060,46062,46064,46066,46087,46089,46091,46136,46138,46181,47084,47086,47088,47090,47111,
   47113,47115,47160,47162,47205,49471,49473,49475,49520,49522,49565,49820,49822,49865,50394],
 [23,31,44,1291,1296,1306,1309,1432,1625,1658,3502,3507,3508,3517,3518,3520,3633,3634,3824,3833,
   3834,3836,4139,38294,38295,38304,38485,38494,38495,38497,38800,41069,41078,41079,41081,41113,
   41114,41116,41384,41386,41411,44633,44634,44636,44904,44906,44931,45499,45501,45526,49471],
 [23,26,31,32,41,42,44,89,90,91,92,93,94,107,156,158,163,166,173,177,1289,1290,1291,1292,
   1293,1296,1298,1300,1306,1309,1311,1313,1333,1334,1335,1336,1339,1340,1341,1343,1349,1350,
   1352,1354,1356,1376,1377,1378,1381,1382,1383,1385,1392,1394,1396,1398,1418,1419,1422,1423,
   1432,1433,1435,1459,1462,1463,1464,1466,1473,1475,1477,1479,1501,1502,1503,1505,1511,1512,
   1514,1516,1518,1613,1614,1616,1622,1623,1625,1627,1629,1649,1651,1657,1658,1660,1662,1664,
   1685,1691,1692,1694,1696,1698,1756,1757,1759,1761,1763,1928,1930,1932,1934,1955,1957,1959,
   2004,2006,2049,2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,3501,
   3502,3503,3504,3507,3508,3509,3511,3517,3518,3520,3522,3524,3544,3545,3546,3547,3550,3551,
   3552,3554,3560,3561,3563,3565,3567,3587,3588,3589,3592,3593,3594,3596,3602,3603,3605,3607,
   3609,3629,3630,3633,3634,3635,3637,3643,3644,3646,3648,3650,3670,3673,3674,3675,3677,3683,
   3684,3688,3690,3712,3713,3714,3716,3722,3723,3727,3729,3824,3825,3827,3833,3834,3836,3838,
   3840,3860,3862,3868,3869,3871,3873,3875,3896,3902,3903,3907,3909,3967,3968,3972,3974,4139,
   4141,4143,4145,4166,4168,4170,4215,4217,4260,4510,4511,4512,4518,4528,4529,5645,5646,5647,
   5648,5649,5652,5653,5654,5656,5662,5663,5665,5667,5669,5689,5690,5691,5692,5695,5696,5697,
   5699,5705,5706,5708,5710,5712,5732,5733,5734,5737,5738,5739,5741,5747,5748,5750,5752,5754,
   5774,5775,5778,5779,5780,5782,5788,5789,5791,5793,5795,5815,5818,5819,5820,5822,5828,5829,
   5831,5833,5835,5857,5861,5867,5868,5874,5969,5970,5972,5978,5979,5981,5983,5985,6005,6007,
   6013,6014,6016,6018,6020,6041,6047,6048,6050,6052,6054,6112,6113,6115,6117,6119,6284,6286,
   6288,6290,6311,6313,6315,6360,6362,6405,7725,7726,7727,7728,7729,7732,7733,7734,7736,7742,
   7743,7745,7747,7749,7769,7770,7771,7772,7775,7776,7777,7779,7785,7786,7788,7790,7792,7812,
   7813,7814,7817,7818,7819,7821,7827,7828,7830,7832,7834,7854,7855,7858,7859,7862,7868,7869,
   7871,7873,7875,7895,7898,7899,7900,7902,7908,7909,7911,7913,7915,7937,7938,7941,7947,7948,
   7950,7952,7954,8049,8050,8052,8058,8059,8061,8063,8065,8085,8087,8093,8094,8096,8098,8100,
   8121,8127,8128,8132,8192,8193,8195,8197,8199,8364,8366,8368,8370,8391,8393,8395,8440,8442,
   8485,38205,38206,38207,38208,38211,38212,38213,38215,38221,38222,38224,38226,38228,38248,38249,
   38250,38253,38254,38255,38257,38263,38264,38266,38268,38270,38290,38291,38294,38295,38296,38298,
   38304,38305,38307,38309,38311,38331,38334,38335,38336,38338,38344,38345,38347,38349,38351,38373,
   38374,38375,38377,38383,38384,38386,38388,38390,38485,38486,38488,38494,38495,38497,38499,38501,
   38521,38523,38529,38532,38534,38536,38557,38563,38564,38566,38568,38570,38628,38629,38631,38633,
   38635,38800,38802,38804,38806,38827,38829,38831,38876,38878,38921,39151,39152,39153,39156,39157,
   39158,39160,39166,39167,39169,39171,39173,39193,39194,39197,39198,39199,39201,39207,39208,39210,
   39212,39214,39234,39237,39238,39239,39241,39247,39248,39250,39252,39254,39276,39277,39278,39280,
   39286,39287,39289,39291,39293,39388,39389,39391,39397,39398,39400,39402,39424,39426,39432,39433,
   39435,39437,39439,39460,39466,39467,39469,39471,39473,39531,39534,39536,39538,39703,39705,39707,
   39709,39730,39732,39734,39779,39781,39824,40054,40055,40058,40059,40060,40062,40068,40069,40071,
   40073,40075,40095,40098,40099,40100,40102,40109,40111,40113,40115,40137,40138,40139,40141,40147,
   40148,40150,40152,40154,40249,40250,40252,40258,40259,40261,40265,40285,40287,40293,40294,40296,
   40298,40300,40321,40327,40328,40330,40332,40334,40392,40393,40395,40397,40399,40564,40566,40568,
   40570,40591,40593,40595,40640,40642,40685,40915,40918,40919,40920,40922,40928,40929,40931,40933,
   40935,40957,40958,40959,40961,40967,40968,40970,40972,40974,41069,41070,41072,41078,41079,41081,
   41083,41085,41105,41107,41113,41114,41116,41118,41120,41141,41147,41148,41150,41152,41212,41213,
   41215,41217,41219,41384,41386,41388,41390,41411,41413,41415,41460,41462,41505,41737,41738,41739,
   41741,41747,41748,41750,41752,41754,41849,41850,41852,41858,41859,41861,41863,41865,41885,41887,
   41893,41894,41896,41898,41900,41921,41927,41928,41930,41932,41934,41992,41993,41997,41999,42164,
   42166,42168,42170,42191,42193,42195,42240,42242,42285,42590,42591,42593,42599,42600,42602,42604,
   42606,42626,42628,42634,42635,42637,42641,42662,42668,42669,42673,42675,42733,42734,42736,42738,
   42740,42905,42907,42909,42911,42932,42934,42936,42981,42983,43026,44625,44627,44633,44634,44636,
   44638,44640,44661,44667,44668,44670,44672,44674,44732,44733,44735,44737,44739,44904,44906,44908,
   44910,44931,44933,44935,44980,44982,45025,45256,45262,45263,45265,45267,45269,45327,45328,45330,
   45332,45334,45499,45501,45503,45505,45526,45528,45530,45575,45577,45620,45888,45889,45891,45893,
   45895,46060,46062,46064,46066,46087,46089,46091,46136,46138,46181,47084,47086,47088,47090,47111,
   47113,47115,47160,47162,47205,49471,49473,49475,49520,49522,49565,49820,49822,49865,50394],
 [23,26,31,32,41,42,44,89,90,91,92,93,94,107,156,158,163,166,173,177,1289,1290,1291,1292,
   1293,1296,1298,1300,1306,1309,1311,1313,1333,1334,1335,1336,1339,1340,1341,1343,1349,1350,
   1352,1354,1356,1376,1377,1378,1381,1382,1383,1385,1392,1394,1396,1398,1418,1419,1422,1423,
   1432,1433,1435,1459,1462,1463,1464,1466,1473,1475,1477,1479,1501,1502,1503,1505,1511,1512,
   1514,1516,1518,1613,1614,1616,1622,1623,1625,1627,1629,1649,1651,1657,1658,1660,1662,1664,
   1685,1691,1692,1694,1696,1698,1756,1757,1759,1761,1763,1928,1930,1932,1934,1955,1957,1959,
   2004,2006,2049,2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,3501,
   3502,3503,3504,3507,3508,3509,3511,3517,3518,3520,3522,3524,3544,3545,3546,3547,3550,3551,
   3552,3554,3560,3561,3563,3565,3567,3587,3588,3589,3592,3593,3594,3596,3602,3603,3605,3607,
   3609,3629,3630,3633,3634,3635,3637,3643,3644,3646,3648,3650,3670,3673,3674,3675,3677,3683,
   3684,3688,3690,3712,3713,3714,3716,3722,3723,3727,3729,3824,3825,3827,3833,3834,3836,3838,
   3840,3860,3862,3868,3869,3871,3873,3875,3896,3902,3903,3907,3909,3967,3968,3972,3974,4139,
   4141,4143,4145,4166,4168,4170,4215,4217,4260,4510,4511,4512,4518,4528,4529,5645,5646,5647,
   5648,5649,5652,5653,5654,5656,5662,5663,5665,5667,5669,5689,5690,5691,5692,5695,5696,5697,
   5699,5705,5706,5708,5710,5712,5732,5733,5734,5737,5738,5739,5741,5747,5748,5750,5752,5754,
   5774,5775,5778,5779,5780,5782,5788,5789,5791,5793,5795,5815,5818,5819,5820,5822,5828,5829,
   5831,5833,5835,5857,5861,5867,5868,5874,5969,5970,5972,5978,5979,5981,5983,5985,6005,6007,
   6013,6014,6016,6018,6020,6041,6047,6048,6050,6052,6054,6112,6113,6115,6117,6119,6284,6286,
   6288,6290,6311,6313,6315,6360,6362,6405,7725,7726,7727,7728,7729,7732,7733,7734,7736,7742,
   7743,7745,7747,7749,7769,7770,7771,7772,7775,7776,7777,7779,7785,7786,7788,7790,7792,7812,
   7813,7814,7817,7818,7819,7821,7827,7828,7830,7832,7834,7854,7855,7858,7859,7862,7868,7869,
   7871,7873,7875,7895,7898,7899,7900,7902,7908,7909,7911,7913,7915,7937,7938,7941,7947,7948,
   7950,7952,7954,8049,8050,8052,8058,8059,8061,8063,8065,8085,8087,8093,8094,8096,8098,8100,
   8121,8127,8128,8132,8192,8193,8195,8197,8199,8364,8366,8368,8370,8391,8393,8395,8440,8442,
   8485,38205,38206,38207,38208,38211,38212,38213,38215,38221,38222,38224,38226,38228,38248,38249,
   38250,38253,38254,38255,38257,38263,38264,38266,38268,38270,38290,38291,38294,38295,38296,38298,
   38304,38305,38307,38309,38311,38331,38334,38335,38336,38338,38344,38345,38347,38349,38351,38373,
   38374,38375,38377,38383,38384,38386,38388,38390,38485,38486,38488,38494,38495,38497,38499,38501,
   38521,38523,38529,38532,38534,38536,38557,38563,38564,38566,38568,38570,38628,38629,38631,38633,
   38635,38800,38802,38804,38806,38827,38829,38831,38876,38878,38921,39151,39152,39153,39156,39157,
   39158,39160,39166,39167,39169,39171,39173,39193,39194,39197,39198,39199,39201,39207,39208,39210,
   39212,39214,39234,39237,39238,39239,39241,39247,39248,39250,39252,39254,39276,39277,39278,39280,
   39286,39287,39289,39291,39293,39388,39389,39391,39397,39398,39400,39402,39424,39426,39432,39433,
   39435,39437,39439,39460,39466,39467,39469,39471,39473,39531,39534,39536,39538,39703,39705,39707,
   39709,39730,39732,39734,39779,39781,39824,40054,40055,40058,40059,40060,40062,40068,40069,40071,
   40073,40075,40095,40098,40099,40100,40102,40109,40111,40113,40115,40137,40138,40139,40141,40147,
   40148,40150,40152,40154,40249,40250,40252,40258,40259,40261,40265,40285,40287,40293,40294,40296,
   40298,40300,40321,40327,40328,40330,40332,40334,40392,40393,40395,40397,40399,40564,40566,40568,
   40570,40591,40593,40595,40640,40642,40685,40915,40918,40919,40920,40922,40928,40929,40931,40933,
   40935,40957,40958,40959,40961,40967,40968,40970,40972,40974,41069,41070,41072,41078,41079,41081,
   41083,41085,41105,41107,41113,41114,41116,41118,41120,41141,41147,41148,41150,41152,41212,41213,
   41215,41217,41219,41384,41386,41388,41390,41411,41413,41415,41460,41462,41505,41737,41738,41739,
   41741,41747,41748,41750,41752,41754,41849,41850,41852,41858,41859,41861,41863,41865,41885,41887,
   41893,41894,41896,41898,41900,41921,41927,41928,41930,41932,41934,41992,41993,41997,41999,42164,
   42166,42168,42170,42191,42193,42195,42240,42242,42285,42590,42591,42593,42599,42600,42602,42604,
   42606,42626,42628,42634,42635,42637,42641,42662,42668,42669,42673,42675,42733,42734,42736,42738,
   42740,42905,42907,42909,42911,42932,42934,42936,42981,42983,43026,44625,44627,44633,44634,44636,
   44638,44640,44661,44667,44668,44670,44672,44674,44732,44733,44735,44737,44739,44904,44906,44908,
   44910,44931,44933,44935,44980,44982,45025,45256,45262,45263,45265,45267,45269,45327,45328,45330,
   45332,45334,45499,45501,45503,45505,45526,45528,45530,45575,45577,45620,45888,45889,45891,45893,
   45895,46060,46062,46064,46066,46087,46089,46091,46136,46138,46181,47084,47086,47088,47090,47111,
   47113,47115,47160,47162,47205,49471,49473,49475,49520,49522,49565,49820,49822,49865,50394],
 [3756],[1583,3794],[1625,3507,3520,3836,38497],
 [23,31,44,1291,1296,1306,1309,1432,1625,1658,3502,3507,3508,3517,3518,3520,3633,3634,3824,3833,
   3834,3836,4139,38294,38295,38304,38485,38494,38495,38497,38800,41069,41078,41079,41081,41113,
   41114,41116,41384,41386,41411,44633,44634,44636,44904,44906,44931,45499,45501,45526,49471],
 [23,26,31,32,41,42,44,89,90,91,92,93,94,107,156,158,163,166,173,177,1289,1290,1291,1292,
   1293,1296,1298,1300,1306,1309,1311,1313,1333,1334,1335,1336,1339,1340,1341,1343,1349,1350,
   1352,1354,1356,1376,1377,1378,1381,1382,1383,1385,1392,1394,1396,1398,1418,1419,1422,1423,
   1432,1433,1435,1459,1462,1463,1464,1466,1473,1475,1477,1479,1501,1502,1503,1505,1511,1512,
   1514,1516,1518,1613,1614,1616,1622,1623,1625,1627,1629,1649,1651,1657,1658,1660,1662,1664,
   1685,1691,1692,1694,1696,1698,1756,1757,1759,1761,1763,1928,1930,1932,1934,1955,1957,1959,
   2004,2006,2049,2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,3501,
   3502,3503,3504,3507,3508,3509,3511,3517,3518,3520,3522,3524,3544,3545,3546,3547,3550,3551,
   3552,3554,3560,3561,3563,3565,3567,3587,3588,3589,3592,3593,3594,3596,3602,3603,3605,3607,
   3609,3629,3630,3633,3634,3635,3637,3643,3644,3646,3648,3650,3670,3673,3674,3675,3677,3683,
   3684,3688,3690,3712,3713,3714,3716,3722,3723,3727,3729,3824,3825,3827,3833,3834,3836,3838,
   3840,3860,3862,3868,3869,3871,3873,3875,3896,3902,3903,3907,3909,3967,3968,3972,3974,4139,
   4141,4143,4145,4166,4168,4170,4215,4217,4260,4510,4511,4512,4518,4528,4529,5645,5646,5647,
   5648,5649,5652,5653,5654,5656,5662,5663,5665,5667,5669,5689,5690,5691,5692,5695,5696,5697,
   5699,5705,5706,5708,5710,5712,5732,5733,5734,5737,5738,5739,5741,5747,5748,5750,5752,5754,
   5774,5775,5778,5779,5780,5782,5788,5789,5791,5793,5795,5815,5818,5819,5820,5822,5828,5829,
   5831,5833,5835,5857,5861,5867,5868,5874,5969,5970,5972,5978,5979,5981,5983,5985,6005,6007,
   6013,6014,6016,6018,6020,6041,6047,6048,6050,6052,6054,6112,6113,6115,6117,6119,6284,6286,
   6288,6290,6311,6313,6315,6360,6362,6405,7725,7726,7727,7728,7729,7732,7733,7734,7736,7742,
   7743,7745,7747,7749,7769,7770,7771,7772,7775,7776,7777,7779,7785,7786,7788,7790,7792,7812,
   7813,7814,7817,7818,7819,7821,7827,7828,7830,7832,7834,7854,7855,7858,7859,7862,7868,7869,
   7871,7873,7875,7895,7898,7899,7900,7902,7908,7909,7911,7913,7915,7937,7938,7941,7947,7948,
   7950,7952,7954,8049,8050,8052,8058,8059,8061,8063,8065,8085,8087,8093,8094,8096,8098,8100,
   8121,8127,8128,8132,8192,8193,8195,8197,8199,8364,8366,8368,8370,8391,8393,8395,8440,8442,
   8485,38205,38206,38207,38208,38211,38212,38213,38215,38221,38222,38224,38226,38228,38248,38249,
   38250,38253,38254,38255,38257,38263,38264,38266,38268,38270,38290,38291,38294,38295,38296,38298,
   38304,38305,38307,38309,38311,38331,38334,38335,38336,38338,38344,38345,38347,38349,38351,38373,
   38374,38375,38377,38383,38384,38386,38388,38390,38485,38486,38488,38494,38495,38497,38499,38501,
   38521,38523,38529,38532,38534,38536,38557,38563,38564,38566,38568,38570,38628,38629,38631,38633,
   38635,38800,38802,38804,38806,38827,38829,38831,38876,38878,38921,39151,39152,39153,39156,39157,
   39158,39160,39166,39167,39169,39171,39173,39193,39194,39197,39198,39199,39201,39207,39208,39210,
   39212,39214,39234,39237,39238,39239,39241,39247,39248,39250,39252,39254,39276,39277,39278,39280,
   39286,39287,39289,39291,39293,39388,39389,39391,39397,39398,39400,39402,39424,39426,39432,39433,
   39435,39437,39439,39460,39466,39467,39469,39471,39473,39531,39534,39536,39538,39703,39705,39707,
   39709,39730,39732,39734,39779,39781,39824,40054,40055,40058,40059,40060,40062,40068,40069,40071,
   40073,40075,40095,40098,40099,40100,40102,40109,40111,40113,40115,40137,40138,40139,40141,40147,
   40148,40150,40152,40154,40249,40250,40252,40258,40259,40261,40265,40285,40287,40293,40294,40296,
   40298,40300,40321,40327,40328,40330,40332,40334,40392,40393,40395,40397,40399,40564,40566,40568,
   40570,40591,40593,40595,40640,40642,40685,40915,40918,40919,40920,40922,40928,40929,40931,40933,
   40935,40957,40958,40959,40961,40967,40968,40970,40972,40974,41069,41070,41072,41078,41079,41081,
   41083,41085,41105,41107,41113,41114,41116,41118,41120,41141,41147,41148,41150,41152,41212,41213,
   41215,41217,41219,41384,41386,41388,41390,41411,41413,41415,41460,41462,41505,41737,41738,41739,
   41741,41747,41748,41750,41752,41754,41849,41850,41852,41858,41859,41861,41863,41865,41885,41887,
   41893,41894,41896,41898,41900,41921,41927,41928,41930,41932,41934,41992,41993,41997,41999,42164,
   42166,42168,42170,42191,42193,42195,42240,42242,42285,42590,42591,42593,42599,42600,42602,42604,
   42606,42626,42628,42634,42635,42637,42641,42662,42668,42669,42673,42675,42733,42734,42736,42738,
   42740,42905,42907,42909,42911,42932,42934,42936,42981,42983,43026,44625,44627,44633,44634,44636,
   44638,44640,44661,44667,44668,44670,44672,44674,44732,44733,44735,44737,44739,44904,44906,44908,
   44910,44931,44933,44935,44980,44982,45025,45256,45262,45263,45265,45267,45269,45327,45328,45330,
   45332,45334,45499,45501,45503,45505,45526,45528,45530,45575,45577,45620,45888,45889,45891,45893,
   45895,46060,46062,46064,46066,46087,46089,46091,46136,46138,46181,47084,47086,47088,47090,47111,
   47113,47115,47160,47162,47205,49471,49473,49475,49520,49522,49565,49820,49822,49865,50394],
 [1719,3930],[23,26,31,32,41,42,44,89,90,91,92,93,94,107,156,158,163,166,173,177,1289,
   1290,1291,1292,1293,1296,1298,1300,1306,1309,1311,1313,1333,1334,1335,1336,1339,1340,1341,
   1343,1349,1350,1352,1354,1356,1376,1377,1378,1381,1382,1383,1385,1392,1394,1396,1398,1418,
   1419,1422,1423,1432,1433,1435,1459,1462,1463,1464,1466,1473,1475,1477,1479,1501,1502,1503,
   1505,1511,1512,1514,1516,1518,1613,1614,1616,1622,1623,1625,1627,1629,1649,1651,1657,1658,
   1660,1662,1664,1685,1691,1692,1694,1696,1698,1756,1757,1759,1761,1763,1928,1930,1932,1934,
   1955,1957,1959,2004,2006,2049,2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,
   2384,3500,3501,3502,3503,3504,3507,3508,3509,3511,3517,3518,3520,3522,3524,3544,3545,3546,
   3547,3550,3551,3552,3554,3560,3561,3563,3565,3567,3587,3588,3589,3592,3593,3594,3596,3602,
   3603,3605,3607,3609,3629,3630,3633,3634,3635,3637,3643,3644,3646,3648,3650,3670,3673,3674,
   3675,3677,3683,3684,3688,3690,3712,3713,3714,3716,3722,3723,3727,3729,3824,3825,3827,3833,
   3834,3836,3838,3840,3860,3862,3868,3869,3871,3873,3875,3896,3902,3903,3907,3909,3967,3968,
   3972,3974,4139,4141,4143,4145,4166,4168,4170,4215,4217,4260,4510,4511,4512,4518,4528,4529,
   5645,5646,5647,5648,5649,5652,5653,5654,5656,5662,5663,5665,5667,5669,5689,5690,5691,5692,
   5695,5696,5697,5699,5705,5706,5708,5710,5712,5732,5733,5734,5737,5738,5739,5741,5747,5748,
   5750,5752,5754,5774,5775,5778,5779,5780,5782,5788,5789,5791,5793,5795,5815,5818,5819,5820,
   5822,5828,5829,5831,5833,5835,5857,5861,5867,5868,5874,5969,5970,5972,5978,5979,5981,5983,
   5985,6005,6007,6013,6014,6016,6018,6020,6041,6047,6048,6050,6052,6054,6112,6113,6115,6117,
   6119,6284,6286,6288,6290,6311,6313,6315,6360,6362,6405,7725,7726,7727,7728,7729,7732,7733,
   7734,7736,7742,7743,7745,7747,7749,7769,7770,7771,7772,7775,7776,7777,7779,7785,7786,7788,
   7790,7792,7812,7813,7814,7817,7818,7819,7821,7827,7828,7830,7832,7834,7854,7855,7858,7859,
   7862,7868,7869,7871,7873,7875,7895,7898,7899,7900,7902,7908,7909,7911,7913,7915,7937,7938,
   7941,7947,7948,7950,7952,7954,8049,8050,8052,8058,8059,8061,8063,8065,8085,8087,8093,8094,
   8096,8098,8100,8121,8127,8128,8132,8192,8193,8195,8197,8199,8364,8366,8368,8370,8391,8393,
   8395,8440,8442,8485,38205,38206,38207,38208,38211,38212,38213,38215,38221,38222,38224,38226,
   38228,38248,38249,38250,38253,38254,38255,38257,38263,38264,38266,38268,38270,38290,38291,38294,
   38295,38296,38298,38304,38305,38307,38309,38311,38331,38334,38335,38336,38338,38344,38345,38347,
   38349,38351,38373,38374,38375,38377,38383,38384,38386,38388,38390,38485,38486,38488,38494,38495,
   38497,38499,38501,38521,38523,38529,38532,38534,38536,38557,38563,38564,38566,38568,38570,38628,
   38629,38631,38633,38635,38800,38802,38804,38806,38827,38829,38831,38876,38878,38921,39151,39152,
   39153,39156,39157,39158,39160,39166,39167,39169,39171,39173,39193,39194,39197,39198,39199,39201,
   39207,39208,39210,39212,39214,39234,39237,39238,39239,39241,39247,39248,39250,39252,39254,39276,
   39277,39278,39280,39286,39287,39289,39291,39293,39388,39389,39391,39397,39398,39400,39402,39424,
   39426,39432,39433,39435,39437,39439,39460,39466,39467,39469,39471,39473,39531,39534,39536,39538,
   39703,39705,39707,39709,39730,39732,39734,39779,39781,39824,40054,40055,40058,40059,40060,40062,
   40068,40069,40071,40073,40075,40095,40098,40099,40100,40102,40109,40111,40113,40115,40137,40138,
   40139,40141,40147,40148,40150,40152,40154,40249,40250,40252,40258,40259,40261,40265,40285,40287,
   40293,40294,40296,40298,40300,40321,40327,40328,40330,40332,40334,40392,40393,40395,40397,40399,
   40564,40566,40568,40570,40591,40593,40595,40640,40642,40685,40915,40918,40919,40920,40922,40928,
   40929,40931,40933,40935,40957,40958,40959,40961,40967,40968,40970,40972,40974,41069,41070,41072,
   41078,41079,41081,41083,41085,41105,41107,41113,41114,41116,41118,41120,41141,41147,41148,41150,
   41152,41212,41213,41215,41217,41219,41384,41386,41388,41390,41411,41413,41415,41460,41462,41505,
   41737,41738,41739,41741,41747,41748,41750,41752,41754,41849,41850,41852,41858,41859,41861,41863,
   41865,41885,41887,41893,41894,41896,41898,41900,41921,41927,41928,41930,41932,41934,41992,41993,
   41997,41999,42164,42166,42168,42170,42191,42193,42195,42240,42242,42285,42590,42591,42593,42599,
   42600,42602,42604,42606,42626,42628,42634,42635,42637,42641,42662,42668,42669,42673,42675,42733,
   42734,42736,42738,42740,42905,42907,42909,42911,42932,42934,42936,42981,42983,43026,44625,44627,
   44633,44634,44636,44638,44640,44661,44667,44668,44670,44672,44674,44732,44733,44735,44737,44739,
   44904,44906,44908,44910,44931,44933,44935,44980,44982,45025,45256,45262,45263,45265,45267,45269,
   45327,45328,45330,45332,45334,45499,45501,45503,45505,45526,45528,45530,45575,45577,45620,45888,
   45889,45891,45893,45895,46060,46062,46064,46066,46087,46089,46091,46136,46138,46181,47084,47086,
   47088,47090,47111,47113,47115,47160,47162,47205,49471,49473,49475,49520,49522,49565,49820,49822,
   49865,50394],[1719,3930],[3756],[1583,3794],[1887,4098],[1915,4126],
 [23,31,44,1291,1296,1306,1309,1432,1625,1658,3502,3507,3508,3517,3518,3520,3633,3634,3824,3833,
   3834,3836,4139,38294,38295,38304,38485,38494,38495,38497,38800,41069,41078,41079,41081,41113,
   41114,41116,41384,41386,41411,44633,44634,44636,44904,44906,44931,45499,45501,45526,49471],
 [23,31,44,1291,1296,1306,1309,1432,1625,1658,3502,3507,3508,3517,3518,3520,3633,3634,3824,3833,
   3834,3836,4139,38294,38295,38304,38485,38494,38495,38497,38800,41069,41078,41079,41081,41113,
   41114,41116,41384,41386,41411,44633,44634,44636,44904,44906,44931,45499,45501,45526,49471],
 [4193],[1625,3507,3520,3836,38497],[2033,4244],
 [23,26,31,32,41,42,44,89,90,91,92,93,94,107,156,158,163,166,173,177,1289,1290,1291,1292,
   1293,1296,1298,1300,1306,1309,1311,1313,1333,1334,1335,1336,1339,1340,1341,1343,1349,1350,
   1352,1354,1356,1376,1377,1378,1381,1382,1383,1385,1392,1394,1396,1398,1418,1419,1422,1423,
   1432,1433,1435,1459,1462,1463,1464,1466,1473,1475,1477,1479,1501,1502,1503,1505,1511,1512,
   1514,1516,1518,1613,1614,1616,1622,1623,1625,1627,1629,1649,1651,1657,1658,1660,1662,1664,
   1685,1691,1692,1694,1696,1698,1756,1757,1759,1761,1763,1928,1930,1932,1934,1955,1957,1959,
   2004,2006,2049,2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,3501,
   3502,3503,3504,3507,3508,3509,3511,3517,3518,3520,3522,3524,3544,3545,3546,3547,3550,3551,
   3552,3554,3560,3561,3563,3565,3567,3587,3588,3589,3592,3593,3594,3596,3602,3603,3605,3607,
   3609,3629,3630,3633,3634,3635,3637,3643,3644,3646,3648,3650,3670,3673,3674,3675,3677,3683,
   3684,3688,3690,3712,3713,3714,3716,3722,3723,3727,3729,3824,3825,3827,3833,3834,3836,3838,
   3840,3860,3862,3868,3869,3871,3873,3875,3896,3902,3903,3907,3909,3967,3968,3972,3974,4139,
   4141,4143,4145,4166,4168,4170,4215,4217,4260,4510,4511,4512,4518,4528,4529,5645,5646,5647,
   5648,5649,5652,5653,5654,5656,5662,5663,5665,5667,5669,5689,5690,5691,5692,5695,5696,5697,
   5699,5705,5706,5708,5710,5712,5732,5733,5734,5737,5738,5739,5741,5747,5748,5750,5752,5754,
   5774,5775,5778,5779,5780,5782,5788,5789,5791,5793,5795,5815,5818,5819,5820,5822,5828,5829,
   5831,5833,5835,5857,5861,5867,5868,5874,5969,5970,5972,5978,5979,5981,5983,5985,6005,6007,
   6013,6014,6016,6018,6020,6041,6047,6048,6050,6052,6054,6112,6113,6115,6117,6119,6284,6286,
   6288,6290,6311,6313,6315,6360,6362,6405,7725,7726,7727,7728,7729,7732,7733,7734,7736,7742,
   7743,7745,7747,7749,7769,7770,7771,7772,7775,7776,7777,7779,7785,7786,7788,7790,7792,7812,
   7813,7814,7817,7818,7819,7821,7827,7828,7830,7832,7834,7854,7855,7858,7859,7862,7868,7869,
   7871,7873,7875,7895,7898,7899,7900,7902,7908,7909,7911,7913,7915,7937,7938,7941,7947,7948,
   7950,7952,7954,8049,8050,8052,8058,8059,8061,8063,8065,8085,8087,8093,8094,8096,8098,8100,
   8121,8127,8128,8132,8192,8193,8195,8197,8199,8364,8366,8368,8370,8391,8393,8395,8440,8442,
   8485,38205,38206,38207,38208,38211,38212,38213,38215,38221,38222,38224,38226,38228,38248,38249,
   38250,38253,38254,38255,38257,38263,38264,38266,38268,38270,38290,38291,38294,38295,38296,38298,
   38304,38305,38307,38309,38311,38331,38334,38335,38336,38338,38344,38345,38347,38349,38351,38373,
   38374,38375,38377,38383,38384,38386,38388,38390,38485,38486,38488,38494,38495,38497,38499,38501,
   38521,38523,38529,38532,38534,38536,38557,38563,38564,38566,38568,38570,38628,38629,38631,38633,
   38635,38800,38802,38804,38806,38827,38829,38831,38876,38878,38921,39151,39152,39153,39156,39157,
   39158,39160,39166,39167,39169,39171,39173,39193,39194,39197,39198,39199,39201,39207,39208,39210,
   39212,39214,39234,39237,39238,39239,39241,39247,39248,39250,39252,39254,39276,39277,39278,39280,
   39286,39287,39289,39291,39293,39388,39389,39391,39397,39398,39400,39402,39424,39426,39432,39433,
   39435,39437,39439,39460,39466,39467,39469,39471,39473,39531,39534,39536,39538,39703,39705,39707,
   39709,39730,39732,39734,39779,39781,39824,40054,40055,40058,40059,40060,40062,40068,40069,40071,
   40073,40075,40095,40098,40099,40100,40102,40109,40111,40113,40115,40137,40138,40139,40141,40147,
   40148,40150,40152,40154,40249,40250,40252,40258,40259,40261,40265,40285,40287,40293,40294,40296,
   40298,40300,40321,40327,40328,40330,40332,40334,40392,40393,40395,40397,40399,40564,40566,40568,
   40570,40591,40593,40595,40640,40642,40685,40915,40918,40919,40920,40922,40928,40929,40931,40933,
   40935,40957,40958,40959,40961,40967,40968,40970,40972,40974,41069,41070,41072,41078,41079,41081,
   41083,41085,41105,41107,41113,41114,41116,41118,41120,41141,41147,41148,41150,41152,41212,41213,
   41215,41217,41219,41384,41386,41388,41390,41411,41413,41415,41460,41462,41505,41737,41738,41739,
   41741,41747,41748,41750,41752,41754,41849,41850,41852,41858,41859,41861,41863,41865,41885,41887,
   41893,41894,41896,41898,41900,41921,41927,41928,41930,41932,41934,41992,41993,41997,41999,42164,
   42166,42168,42170,42191,42193,42195,42240,42242,42285,42590,42591,42593,42599,42600,42602,42604,
   42606,42626,42628,42634,42635,42637,42641,42662,42668,42669,42673,42675,42733,42734,42736,42738,
   42740,42905,42907,42909,42911,42932,42934,42936,42981,42983,43026,44625,44627,44633,44634,44636,
   44638,44640,44661,44667,44668,44670,44672,44674,44732,44733,44735,44737,44739,44904,44906,44908,
   44910,44931,44933,44935,44980,44982,45025,45256,45262,45263,45265,45267,45269,45327,45328,45330,
   45332,45334,45499,45501,45503,45505,45526,45528,45530,45575,45577,45620,45888,45889,45891,45893,
   45895,46060,46062,46064,46066,46087,46089,46091,46136,46138,46181,47084,47086,47088,47090,47111,
   47113,47115,47160,47162,47205,49471,49473,49475,49520,49522,49565,49820,49822,49865,50394],
 [4193],[23,26,31,32,41,42,44,89,90,91,92,93,94,107,156,158,163,166,173,177,1289,1290,
   1291,1292,1293,1296,1298,1300,1306,1309,1311,1313,1333,1334,1335,1336,1339,1340,1341,1343,
   1349,1350,1352,1354,1356,1376,1377,1378,1381,1382,1383,1385,1392,1394,1396,1398,1418,1419,
   1422,1423,1432,1433,1435,1459,1462,1463,1464,1466,1473,1475,1477,1479,1501,1502,1503,1505,
   1511,1512,1514,1516,1518,1613,1614,1616,1622,1623,1625,1627,1629,1649,1651,1657,1658,1660,
   1662,1664,1685,1691,1692,1694,1696,1698,1756,1757,1759,1761,1763,1928,1930,1932,1934,1955,
   1957,1959,2004,2006,2049,2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,
   3500,3501,3502,3503,3504,3507,3508,3509,3511,3517,3518,3520,3522,3524,3544,3545,3546,3547,
   3550,3551,3552,3554,3560,3561,3563,3565,3567,3587,3588,3589,3592,3593,3594,3596,3602,3603,
   3605,3607,3609,3629,3630,3633,3634,3635,3637,3643,3644,3646,3648,3650,3670,3673,3674,3675,
   3677,3683,3684,3688,3690,3712,3713,3714,3716,3722,3723,3727,3729,3824,3825,3827,3833,3834,
   3836,3838,3840,3860,3862,3868,3869,3871,3873,3875,3896,3902,3903,3907,3909,3967,3968,3972,
   3974,4139,4141,4143,4145,4166,4168,4170,4215,4217,4260,4510,4511,4512,4518,4528,4529,5645,
   5646,5647,5648,5649,5652,5653,5654,5656,5662,5663,5665,5667,5669,5689,5690,5691,5692,5695,
   5696,5697,5699,5705,5706,5708,5710,5712,5732,5733,5734,5737,5738,5739,5741,5747,5748,5750,
   5752,5754,5774,5775,5778,5779,5780,5782,5788,5789,5791,5793,5795,5815,5818,5819,5820,5822,
   5828,5829,5831,5833,5835,5857,5861,5867,5868,5874,5969,5970,5972,5978,5979,5981,5983,5985,
   6005,6007,6013,6014,6016,6018,6020,6041,6047,6048,6050,6052,6054,6112,6113,6115,6117,6119,
   6284,6286,6288,6290,6311,6313,6315,6360,6362,6405,7725,7726,7727,7728,7729,7732,7733,7734,
   7736,7742,7743,7745,7747,7749,7769,7770,7771,7772,7775,7776,7777,7779,7785,7786,7788,7790,
   7792,7812,7813,7814,7817,7818,7819,7821,7827,7828,7830,7832,7834,7854,7855,7858,7859,7862,
   7868,7869,7871,7873,7875,7895,7898,7899,7900,7902,7908,7909,7911,7913,7915,7937,7938,7941,
   7947,7948,7950,7952,7954,8049,8050,8052,8058,8059,8061,8063,8065,8085,8087,8093,8094,8096,
   8098,8100,8121,8127,8128,8132,8192,8193,8195,8197,8199,8364,8366,8368,8370,8391,8393,8395,
   8440,8442,8485,38205,38206,38207,38208,38211,38212,38213,38215,38221,38222,38224,38226,38228,
   38248,38249,38250,38253,38254,38255,38257,38263,38264,38266,38268,38270,38290,38291,38294,38295,
   38296,38298,38304,38305,38307,38309,38311,38331,38334,38335,38336,38338,38344,38345,38347,38349,
   38351,38373,38374,38375,38377,38383,38384,38386,38388,38390,38485,38486,38488,38494,38495,38497,
   38499,38501,38521,38523,38529,38532,38534,38536,38557,38563,38564,38566,38568,38570,38628,38629,
   38631,38633,38635,38800,38802,38804,38806,38827,38829,38831,38876,38878,38921,39151,39152,39153,
   39156,39157,39158,39160,39166,39167,39169,39171,39173,39193,39194,39197,39198,39199,39201,39207,
   39208,39210,39212,39214,39234,39237,39238,39239,39241,39247,39248,39250,39252,39254,39276,39277,
   39278,39280,39286,39287,39289,39291,39293,39388,39389,39391,39397,39398,39400,39402,39424,39426,
   39432,39433,39435,39437,39439,39460,39466,39467,39469,39471,39473,39531,39534,39536,39538,39703,
   39705,39707,39709,39730,39732,39734,39779,39781,39824,40054,40055,40058,40059,40060,40062,40068,
   40069,40071,40073,40075,40095,40098,40099,40100,40102,40109,40111,40113,40115,40137,40138,40139,
   40141,40147,40148,40150,40152,40154,40249,40250,40252,40258,40259,40261,40265,40285,40287,40293,
   40294,40296,40298,40300,40321,40327,40328,40330,40332,40334,40392,40393,40395,40397,40399,40564,
   40566,40568,40570,40591,40593,40595,40640,40642,40685,40915,40918,40919,40920,40922,40928,40929,
   40931,40933,40935,40957,40958,40959,40961,40967,40968,40970,40972,40974,41069,41070,41072,41078,
   41079,41081,41083,41085,41105,41107,41113,41114,41116,41118,41120,41141,41147,41148,41150,41152,
   41212,41213,41215,41217,41219,41384,41386,41388,41390,41411,41413,41415,41460,41462,41505,41737,
   41738,41739,41741,41747,41748,41750,41752,41754,41849,41850,41852,41858,41859,41861,41863,41865,
   41885,41887,41893,41894,41896,41898,41900,41921,41927,41928,41930,41932,41934,41992,41993,41997,
   41999,42164,42166,42168,42170,42191,42193,42195,42240,42242,42285,42590,42591,42593,42599,42600,
   42602,42604,42606,42626,42628,42634,42635,42637,42641,42662,42668,42669,42673,42675,42733,42734,
   42736,42738,42740,42905,42907,42909,42911,42932,42934,42936,42981,42983,43026,44625,44627,44633,
   44634,44636,44638,44640,44661,44667,44668,44670,44672,44674,44732,44733,44735,44737,44739,44904,
   44906,44908,44910,44931,44933,44935,44980,44982,45025,45256,45262,45263,45265,45267,45269,45327,
   45328,45330,45332,45334,45499,45501,45503,45505,45526,45528,45530,45575,45577,45620,45888,45889,
   45891,45893,45895,46060,46062,46064,46066,46087,46089,46091,46136,46138,46181,47084,47086,47088,
   47090,47111,47113,47115,47160,47162,47205,49471,49473,49475,49520,49522,49565,49820,49822,49865,
   50394],[23,31,44,1296,1309,1625,1630,1631,2007,2008,2108,3507,3520,3525,3526,3836,3841,
   3842,4319,38497,38502,38503,38980,44983,44984,45084,50453],
 [23,31,44,1296,1309,1625,1630,1631,2007,2008,2108,3507,3520,3525,3526,3836,3841,3842,4319,
   38497,38502,38503,38980,44983,44984,45084,50453],
 [23,31,44,1296,1309,1316,1317,1625,2143,3507,3520,3527,3528,3836,3843,3844,4354,38497,38504,
   38505,39015,45119],[23,31,44,1296,1309,1316,1317,1625,2143,3507,3520,3527,3528,3836,3843,
   3844,4354,38497,38504,38505,39015,45119],[2033,4244],[1887,4098],[1915,4126],
 [2215,4426],[2224,4435],[2224,4435],[2215,4426],[2254,4465],[2262,4473],[2268,4479],
 [2270,4481],[2254,4465],[2270,4481],[2262,4473],[2268,4479],[2279],
 [202,1336,9788,17232],[268,4624],[328],[393,4749],[202,1336,9788,17232],[328],
 [569,4925],[268,4624],[569,4925],[393,4749],[],[],[],[],[],[],[],[],[],
 [],[90,94,107,1291,1306,1336,1349,1377,1432,1511,5645,5646,5662,5689,5690,5691,5692,5705,
   5747,5774,5788,5828,5867,38205,38206,38207,38208,38221,38248,38249,38250,38263,38290,38291,
   38304,38331,39151,39152,39153,39166,39193,39194,39207,39234,39247,39286,40054,40055,40095,40915,
   40928],[1336,5692,5705,5867,39286],
 [90,94,107,1291,1306,1336,1349,1377,1432,1511,5645,5646,5662,5689,5690,5691,5692,5705,5747,
   5774,5788,5828,5867,38205,38206,38207,38208,38221,38248,38249,38250,38263,38290,38291,38304,
   38331,39151,39152,39153,39166,39193,39194,39207,39234,39247,39286,40054,40055,40095,40915,40928]
  ,[90,94,107,1291,1306,1336,1349,1377,1432,1511,5645,5646,5662,5689,5690,5691,5692,5705,5747,
   5774,5788,5828,5867,38205,38206,38207,38208,38221,38248,38249,38250,38263,38290,38291,38304,
   38331,39151,39152,39153,39166,39193,39194,39207,39234,39247,39286,40054,40055,40095,40915,40928]
  ,[90,94,107,1291,1306,1336,1349,1377,1432,1511,5645,5646,5662,5689,5690,5691,5692,5705,5747,
   5774,5788,5828,5867,38205,38206,38207,38208,38221,38248,38249,38250,38263,38290,38291,38304,
   38331,39151,39152,39153,39166,39193,39194,39207,39234,39247,39286,40054,40055,40095,40915,40928]
  ,[1336,5692,5705,5867,39286],[90,94,107,1336,1337,1338,1349,1499,1500,1511,1538,5692,5693,
   5694,5705,5867,5894,5905,5942,39274,39275,39286,39313,39324,39361,42515,43266],
 [90,94,107,1336,1337,1338,1349,1499,1500,1511,1538,5692,5693,5694,5705,5867,5894,5905,5942,
   39274,39275,39286,39313,39324,39361,42515,43266],
 [23,26,31,32,41,42,44,89,90,91,92,93,94,107,156,158,163,166,173,177,1289,1290,1291,1292,
   1293,1296,1298,1300,1306,1309,1311,1313,1333,1334,1335,1336,1339,1340,1341,1343,1349,1350,
   1352,1354,1356,1376,1377,1378,1381,1382,1383,1385,1392,1394,1396,1398,1418,1419,1422,1423,
   1432,1433,1435,1459,1462,1463,1464,1466,1473,1475,1477,1479,1501,1502,1503,1505,1511,1512,
   1514,1516,1518,1613,1614,1616,1622,1623,1625,1627,1629,1649,1651,1657,1658,1660,1662,1664,
   1685,1691,1692,1694,1696,1698,1756,1757,1759,1761,1763,1928,1930,1932,1934,1955,1957,1959,
   2004,2006,2049,2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,3501,
   3502,3503,3504,3507,3508,3509,3511,3517,3518,3520,3522,3524,3544,3545,3546,3547,3550,3551,
   3552,3554,3560,3561,3563,3565,3567,3587,3588,3589,3592,3593,3594,3596,3602,3603,3605,3607,
   3609,3629,3630,3633,3634,3635,3637,3643,3644,3646,3648,3650,3670,3673,3674,3675,3677,3683,
   3684,3688,3690,3712,3713,3714,3716,3722,3723,3727,3729,3824,3825,3827,3833,3834,3836,3838,
   3840,3860,3862,3868,3869,3871,3873,3875,3896,3902,3903,3907,3909,3967,3968,3972,3974,4139,
   4141,4143,4145,4166,4168,4170,4215,4217,4260,4510,4511,4512,4518,4528,4529,5645,5646,5647,
   5648,5649,5652,5653,5654,5656,5662,5663,5665,5667,5669,5689,5690,5691,5692,5695,5696,5697,
   5699,5705,5706,5708,5710,5712,5732,5733,5734,5737,5738,5739,5741,5747,5748,5750,5752,5754,
   5774,5775,5778,5779,5780,5782,5788,5789,5791,5793,5795,5815,5818,5819,5820,5822,5828,5829,
   5831,5833,5835,5857,5861,5867,5868,5874,5969,5970,5972,5978,5979,5981,5983,5985,6005,6007,
   6013,6014,6016,6018,6020,6041,6047,6048,6050,6052,6054,6112,6113,6115,6117,6119,6284,6286,
   6288,6290,6311,6313,6315,6360,6362,6405,7725,7726,7727,7728,7729,7732,7733,7734,7736,7742,
   7743,7745,7747,7749,7769,7770,7771,7772,7775,7776,7777,7779,7785,7786,7788,7790,7792,7812,
   7813,7814,7817,7818,7819,7821,7827,7828,7830,7832,7834,7854,7855,7858,7859,7862,7868,7869,
   7871,7873,7875,7895,7898,7899,7900,7902,7908,7909,7911,7913,7915,7937,7938,7941,7947,7948,
   7950,7952,7954,8049,8050,8052,8058,8059,8061,8063,8065,8085,8087,8093,8094,8096,8098,8100,
   8121,8127,8128,8132,8192,8193,8195,8197,8199,8364,8366,8368,8370,8391,8393,8395,8440,8442,
   8485,38205,38206,38207,38208,38211,38212,38213,38215,38221,38222,38224,38226,38228,38248,38249,
   38250,38253,38254,38255,38257,38263,38264,38266,38268,38270,38290,38291,38294,38295,38296,38298,
   38304,38305,38307,38309,38311,38331,38334,38335,38336,38338,38344,38345,38347,38349,38351,38373,
   38374,38375,38377,38383,38384,38386,38388,38390,38485,38486,38488,38494,38495,38497,38499,38501,
   38521,38523,38529,38532,38534,38536,38557,38563,38564,38566,38568,38570,38628,38629,38631,38633,
   38635,38800,38802,38804,38806,38827,38829,38831,38876,38878,38921,39151,39152,39153,39156,39157,
   39158,39160,39166,39167,39169,39171,39173,39193,39194,39197,39198,39199,39201,39207,39208,39210,
   39212,39214,39234,39237,39238,39239,39241,39247,39248,39250,39252,39254,39276,39277,39278,39280,
   39286,39287,39289,39291,39293,39388,39389,39391,39397,39398,39400,39402,39424,39426,39432,39433,
   39435,39437,39439,39460,39466,39467,39469,39471,39473,39531,39534,39536,39538,39703,39705,39707,
   39709,39730,39732,39734,39779,39781,39824,40054,40055,40058,40059,40060,40062,40068,40069,40071,
   40073,40075,40095,40098,40099,40100,40102,40109,40111,40113,40115,40137,40138,40139,40141,40147,
   40148,40150,40152,40154,40249,40250,40252,40258,40259,40261,40265,40285,40287,40293,40294,40296,
   40298,40300,40321,40327,40328,40330,40332,40334,40392,40393,40395,40397,40399,40564,40566,40568,
   40570,40591,40593,40595,40640,40642,40685,40915,40918,40919,40920,40922,40928,40929,40931,40933,
   40935,40957,40958,40959,40961,40967,40968,40970,40972,40974,41069,41070,41072,41078,41079,41081,
   41083,41085,41105,41107,41113,41114,41116,41118,41120,41141,41147,41148,41150,41152,41212,41213,
   41215,41217,41219,41384,41386,41388,41390,41411,41413,41415,41460,41462,41505,41737,41738,41739,
   41741,41747,41748,41750,41752,41754,41849,41850,41852,41858,41859,41861,41863,41865,41885,41887,
   41893,41894,41896,41898,41900,41921,41927,41928,41930,41932,41934,41992,41993,41997,41999,42164,
   42166,42168,42170,42191,42193,42195,42240,42242,42285,42590,42591,42593,42599,42600,42602,42604,
   42606,42626,42628,42634,42635,42637,42641,42662,42668,42669,42673,42675,42733,42734,42736,42738,
   42740,42905,42907,42909,42911,42932,42934,42936,42981,42983,43026,44625,44627,44633,44634,44636,
   44638,44640,44661,44667,44668,44670,44672,44674,44732,44733,44735,44737,44739,44904,44906,44908,
   44910,44931,44933,44935,44980,44982,45025,45256,45262,45263,45265,45267,45269,45327,45328,45330,
   45332,45334,45499,45501,45503,45505,45526,45528,45530,45575,45577,45620,45888,45889,45891,45893,
   45895,46060,46062,46064,46066,46087,46089,46091,46136,46138,46181,47084,47086,47088,47090,47111,
   47113,47115,47160,47162,47205,49471,49473,49475,49520,49522,49565,49820,49822,49865,50394],
 [23,26,31,32,41,42,44,89,90,91,92,93,94,107,156,158,163,166,173,177,1289,1290,1291,1292,
   1293,1296,1298,1300,1306,1309,1311,1313,1333,1334,1335,1336,1339,1340,1341,1343,1349,1350,
   1352,1354,1356,1376,1377,1378,1381,1382,1383,1385,1392,1394,1396,1398,1418,1419,1422,1423,
   1432,1433,1435,1459,1462,1463,1464,1466,1473,1475,1477,1479,1501,1502,1503,1505,1511,1512,
   1514,1516,1518,1613,1614,1616,1622,1623,1625,1627,1629,1649,1651,1657,1658,1660,1662,1664,
   1685,1691,1692,1694,1696,1698,1756,1757,1759,1761,1763,1928,1930,1932,1934,1955,1957,1959,
   2004,2006,2049,2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,3501,
   3502,3503,3504,3507,3508,3509,3511,3517,3518,3520,3522,3524,3544,3545,3546,3547,3550,3551,
   3552,3554,3560,3561,3563,3565,3567,3587,3588,3589,3592,3593,3594,3596,3602,3603,3605,3607,
   3609,3629,3630,3633,3634,3635,3637,3643,3644,3646,3648,3650,3670,3673,3674,3675,3677,3683,
   3684,3688,3690,3712,3713,3714,3716,3722,3723,3727,3729,3824,3825,3827,3833,3834,3836,3838,
   3840,3860,3862,3868,3869,3871,3873,3875,3896,3902,3903,3907,3909,3967,3968,3972,3974,4139,
   4141,4143,4145,4166,4168,4170,4215,4217,4260,4510,4511,4512,4518,4528,4529,5645,5646,5647,
   5648,5649,5652,5653,5654,5656,5662,5663,5665,5667,5669,5689,5690,5691,5692,5695,5696,5697,
   5699,5705,5706,5708,5710,5712,5732,5733,5734,5737,5738,5739,5741,5747,5748,5750,5752,5754,
   5774,5775,5778,5779,5780,5782,5788,5789,5791,5793,5795,5815,5818,5819,5820,5822,5828,5829,
   5831,5833,5835,5857,5861,5867,5868,5874,5969,5970,5972,5978,5979,5981,5983,5985,6005,6007,
   6013,6014,6016,6018,6020,6041,6047,6048,6050,6052,6054,6112,6113,6115,6117,6119,6284,6286,
   6288,6290,6311,6313,6315,6360,6362,6405,7725,7726,7727,7728,7729,7732,7733,7734,7736,7742,
   7743,7745,7747,7749,7769,7770,7771,7772,7775,7776,7777,7779,7785,7786,7788,7790,7792,7812,
   7813,7814,7817,7818,7819,7821,7827,7828,7830,7832,7834,7854,7855,7858,7859,7862,7868,7869,
   7871,7873,7875,7895,7898,7899,7900,7902,7908,7909,7911,7913,7915,7937,7938,7941,7947,7948,
   7950,7952,7954,8049,8050,8052,8058,8059,8061,8063,8065,8085,8087,8093,8094,8096,8098,8100,
   8121,8127,8128,8132,8192,8193,8195,8197,8199,8364,8366,8368,8370,8391,8393,8395,8440,8442,
   8485,38205,38206,38207,38208,38211,38212,38213,38215,38221,38222,38224,38226,38228,38248,38249,
   38250,38253,38254,38255,38257,38263,38264,38266,38268,38270,38290,38291,38294,38295,38296,38298,
   38304,38305,38307,38309,38311,38331,38334,38335,38336,38338,38344,38345,38347,38349,38351,38373,
   38374,38375,38377,38383,38384,38386,38388,38390,38485,38486,38488,38494,38495,38497,38499,38501,
   38521,38523,38529,38532,38534,38536,38557,38563,38564,38566,38568,38570,38628,38629,38631,38633,
   38635,38800,38802,38804,38806,38827,38829,38831,38876,38878,38921,39151,39152,39153,39156,39157,
   39158,39160,39166,39167,39169,39171,39173,39193,39194,39197,39198,39199,39201,39207,39208,39210,
   39212,39214,39234,39237,39238,39239,39241,39247,39248,39250,39252,39254,39276,39277,39278,39280,
   39286,39287,39289,39291,39293,39388,39389,39391,39397,39398,39400,39402,39424,39426,39432,39433,
   39435,39437,39439,39460,39466,39467,39469,39471,39473,39531,39534,39536,39538,39703,39705,39707,
   39709,39730,39732,39734,39779,39781,39824,40054,40055,40058,40059,40060,40062,40068,40069,40071,
   40073,40075,40095,40098,40099,40100,40102,40109,40111,40113,40115,40137,40138,40139,40141,40147,
   40148,40150,40152,40154,40249,40250,40252,40258,40259,40261,40265,40285,40287,40293,40294,40296,
   40298,40300,40321,40327,40328,40330,40332,40334,40392,40393,40395,40397,40399,40564,40566,40568,
   40570,40591,40593,40595,40640,40642,40685,40915,40918,40919,40920,40922,40928,40929,40931,40933,
   40935,40957,40958,40959,40961,40967,40968,40970,40972,40974,41069,41070,41072,41078,41079,41081,
   41083,41085,41105,41107,41113,41114,41116,41118,41120,41141,41147,41148,41150,41152,41212,41213,
   41215,41217,41219,41384,41386,41388,41390,41411,41413,41415,41460,41462,41505,41737,41738,41739,
   41741,41747,41748,41750,41752,41754,41849,41850,41852,41858,41859,41861,41863,41865,41885,41887,
   41893,41894,41896,41898,41900,41921,41927,41928,41930,41932,41934,41992,41993,41997,41999,42164,
   42166,42168,42170,42191,42193,42195,42240,42242,42285,42590,42591,42593,42599,42600,42602,42604,
   42606,42626,42628,42634,42635,42637,42641,42662,42668,42669,42673,42675,42733,42734,42736,42738,
   42740,42905,42907,42909,42911,42932,42934,42936,42981,42983,43026,44625,44627,44633,44634,44636,
   44638,44640,44661,44667,44668,44670,44672,44674,44732,44733,44735,44737,44739,44904,44906,44908,
   44910,44931,44933,44935,44980,44982,45025,45256,45262,45263,45265,45267,45269,45327,45328,45330,
   45332,45334,45499,45501,45503,45505,45526,45528,45530,45575,45577,45620,45888,45889,45891,45893,
   45895,46060,46062,46064,46066,46087,46089,46091,46136,46138,46181,47084,47086,47088,47090,47111,
   47113,47115,47160,47162,47205,49471,49473,49475,49520,49522,49565,49820,49822,49865,50394],
 [23,26,31,32,41,42,44,89,90,91,92,93,94,107,156,158,163,166,173,177,1289,1290,1291,1292,
   1293,1296,1298,1300,1306,1309,1311,1313,1333,1334,1335,1336,1339,1340,1341,1343,1349,1350,
   1352,1354,1356,1376,1377,1378,1381,1382,1383,1385,1392,1394,1396,1398,1418,1419,1422,1423,
   1432,1433,1435,1459,1462,1463,1464,1466,1473,1475,1477,1479,1501,1502,1503,1505,1511,1512,
   1514,1516,1518,1613,1614,1616,1622,1623,1625,1627,1629,1649,1651,1657,1658,1660,1662,1664,
   1685,1691,1692,1694,1696,1698,1756,1757,1759,1761,1763,1928,1930,1932,1934,1955,1957,1959,
   2004,2006,2049,2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,3501,
   3502,3503,3504,3507,3508,3509,3511,3517,3518,3520,3522,3524,3544,3545,3546,3547,3550,3551,
   3552,3554,3560,3561,3563,3565,3567,3587,3588,3589,3592,3593,3594,3596,3602,3603,3605,3607,
   3609,3629,3630,3633,3634,3635,3637,3643,3644,3646,3648,3650,3670,3673,3674,3675,3677,3683,
   3684,3688,3690,3712,3713,3714,3716,3722,3723,3727,3729,3824,3825,3827,3833,3834,3836,3838,
   3840,3860,3862,3868,3869,3871,3873,3875,3896,3902,3903,3907,3909,3967,3968,3972,3974,4139,
   4141,4143,4145,4166,4168,4170,4215,4217,4260,4510,4511,4512,4518,4528,4529,5645,5646,5647,
   5648,5649,5652,5653,5654,5656,5662,5663,5665,5667,5669,5689,5690,5691,5692,5695,5696,5697,
   5699,5705,5706,5708,5710,5712,5732,5733,5734,5737,5738,5739,5741,5747,5748,5750,5752,5754,
   5774,5775,5778,5779,5780,5782,5788,5789,5791,5793,5795,5815,5818,5819,5820,5822,5828,5829,
   5831,5833,5835,5857,5861,5867,5868,5874,5969,5970,5972,5978,5979,5981,5983,5985,6005,6007,
   6013,6014,6016,6018,6020,6041,6047,6048,6050,6052,6054,6112,6113,6115,6117,6119,6284,6286,
   6288,6290,6311,6313,6315,6360,6362,6405,7725,7726,7727,7728,7729,7732,7733,7734,7736,7742,
   7743,7745,7747,7749,7769,7770,7771,7772,7775,7776,7777,7779,7785,7786,7788,7790,7792,7812,
   7813,7814,7817,7818,7819,7821,7827,7828,7830,7832,7834,7854,7855,7858,7859,7862,7868,7869,
   7871,7873,7875,7895,7898,7899,7900,7902,7908,7909,7911,7913,7915,7937,7938,7941,7947,7948,
   7950,7952,7954,8049,8050,8052,8058,8059,8061,8063,8065,8085,8087,8093,8094,8096,8098,8100,
   8121,8127,8128,8132,8192,8193,8195,8197,8199,8364,8366,8368,8370,8391,8393,8395,8440,8442,
   8485,38205,38206,38207,38208,38211,38212,38213,38215,38221,38222,38224,38226,38228,38248,38249,
   38250,38253,38254,38255,38257,38263,38264,38266,38268,38270,38290,38291,38294,38295,38296,38298,
   38304,38305,38307,38309,38311,38331,38334,38335,38336,38338,38344,38345,38347,38349,38351,38373,
   38374,38375,38377,38383,38384,38386,38388,38390,38485,38486,38488,38494,38495,38497,38499,38501,
   38521,38523,38529,38532,38534,38536,38557,38563,38564,38566,38568,38570,38628,38629,38631,38633,
   38635,38800,38802,38804,38806,38827,38829,38831,38876,38878,38921,39151,39152,39153,39156,39157,
   39158,39160,39166,39167,39169,39171,39173,39193,39194,39197,39198,39199,39201,39207,39208,39210,
   39212,39214,39234,39237,39238,39239,39241,39247,39248,39250,39252,39254,39276,39277,39278,39280,
   39286,39287,39289,39291,39293,39388,39389,39391,39397,39398,39400,39402,39424,39426,39432,39433,
   39435,39437,39439,39460,39466,39467,39469,39471,39473,39531,39534,39536,39538,39703,39705,39707,
   39709,39730,39732,39734,39779,39781,39824,40054,40055,40058,40059,40060,40062,40068,40069,40071,
   40073,40075,40095,40098,40099,40100,40102,40109,40111,40113,40115,40137,40138,40139,40141,40147,
   40148,40150,40152,40154,40249,40250,40252,40258,40259,40261,40265,40285,40287,40293,40294,40296,
   40298,40300,40321,40327,40328,40330,40332,40334,40392,40393,40395,40397,40399,40564,40566,40568,
   40570,40591,40593,40595,40640,40642,40685,40915,40918,40919,40920,40922,40928,40929,40931,40933,
   40935,40957,40958,40959,40961,40967,40968,40970,40972,40974,41069,41070,41072,41078,41079,41081,
   41083,41085,41105,41107,41113,41114,41116,41118,41120,41141,41147,41148,41150,41152,41212,41213,
   41215,41217,41219,41384,41386,41388,41390,41411,41413,41415,41460,41462,41505,41737,41738,41739,
   41741,41747,41748,41750,41752,41754,41849,41850,41852,41858,41859,41861,41863,41865,41885,41887,
   41893,41894,41896,41898,41900,41921,41927,41928,41930,41932,41934,41992,41993,41997,41999,42164,
   42166,42168,42170,42191,42193,42195,42240,42242,42285,42590,42591,42593,42599,42600,42602,42604,
   42606,42626,42628,42634,42635,42637,42641,42662,42668,42669,42673,42675,42733,42734,42736,42738,
   42740,42905,42907,42909,42911,42932,42934,42936,42981,42983,43026,44625,44627,44633,44634,44636,
   44638,44640,44661,44667,44668,44670,44672,44674,44732,44733,44735,44737,44739,44904,44906,44908,
   44910,44931,44933,44935,44980,44982,45025,45256,45262,45263,45265,45267,45269,45327,45328,45330,
   45332,45334,45499,45501,45503,45505,45526,45528,45530,45575,45577,45620,45888,45889,45891,45893,
   45895,46060,46062,46064,46066,46087,46089,46091,46136,46138,46181,47084,47086,47088,47090,47111,
   47113,47115,47160,47162,47205,49471,49473,49475,49520,49522,49565,49820,49822,49865,50394],
 [90,94,107,1336,1349,1511,1724,1730,1933,5692,5698,5705,5711,5867,6080,6086,6289,39286,39499,
   39505,39708,46593],[23,26,31,32,41,42,44,89,90,91,92,93,94,107,156,158,163,166,173,177,
   1289,1290,1291,1292,1293,1296,1298,1300,1306,1309,1311,1313,1333,1334,1335,1336,1339,1340,
   1341,1343,1349,1350,1352,1354,1356,1376,1377,1378,1381,1382,1383,1385,1392,1394,1396,1398,
   1418,1419,1422,1423,1432,1433,1435,1459,1462,1463,1464,1466,1473,1475,1477,1479,1501,1502,
   1503,1505,1511,1512,1514,1516,1518,1613,1614,1616,1622,1623,1625,1627,1629,1649,1651,1657,
   1658,1660,1662,1664,1685,1691,1692,1694,1696,1698,1756,1757,1759,1761,1763,1928,1930,1932,
   1934,1955,1957,1959,2004,2006,2049,2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,
   2383,2384,3500,3501,3502,3503,3504,3507,3508,3509,3511,3517,3518,3520,3522,3524,3544,3545,
   3546,3547,3550,3551,3552,3554,3560,3561,3563,3565,3567,3587,3588,3589,3592,3593,3594,3596,
   3602,3603,3605,3607,3609,3629,3630,3633,3634,3635,3637,3643,3644,3646,3648,3650,3670,3673,
   3674,3675,3677,3683,3684,3688,3690,3712,3713,3714,3716,3722,3723,3727,3729,3824,3825,3827,
   3833,3834,3836,3838,3840,3860,3862,3868,3869,3871,3873,3875,3896,3902,3903,3907,3909,3967,
   3968,3972,3974,4139,4141,4143,4145,4166,4168,4170,4215,4217,4260,4510,4511,4512,4518,4528,
   4529,5645,5646,5647,5648,5649,5652,5653,5654,5656,5662,5663,5665,5667,5669,5689,5690,5691,
   5692,5695,5696,5697,5699,5705,5706,5708,5710,5712,5732,5733,5734,5737,5738,5739,5741,5747,
   5748,5750,5752,5754,5774,5775,5778,5779,5780,5782,5788,5789,5791,5793,5795,5815,5818,5819,
   5820,5822,5828,5829,5831,5833,5835,5857,5861,5867,5868,5874,5969,5970,5972,5978,5979,5981,
   5983,5985,6005,6007,6013,6014,6016,6018,6020,6041,6047,6048,6050,6052,6054,6112,6113,6115,
   6117,6119,6284,6286,6288,6290,6311,6313,6315,6360,6362,6405,7725,7726,7727,7728,7729,7732,
   7733,7734,7736,7742,7743,7745,7747,7749,7769,7770,7771,7772,7775,7776,7777,7779,7785,7786,
   7788,7790,7792,7812,7813,7814,7817,7818,7819,7821,7827,7828,7830,7832,7834,7854,7855,7858,
   7859,7862,7868,7869,7871,7873,7875,7895,7898,7899,7900,7902,7908,7909,7911,7913,7915,7937,
   7938,7941,7947,7948,7950,7952,7954,8049,8050,8052,8058,8059,8061,8063,8065,8085,8087,8093,
   8094,8096,8098,8100,8121,8127,8128,8132,8192,8193,8195,8197,8199,8364,8366,8368,8370,8391,
   8393,8395,8440,8442,8485,38205,38206,38207,38208,38211,38212,38213,38215,38221,38222,38224,
   38226,38228,38248,38249,38250,38253,38254,38255,38257,38263,38264,38266,38268,38270,38290,38291,
   38294,38295,38296,38298,38304,38305,38307,38309,38311,38331,38334,38335,38336,38338,38344,38345,
   38347,38349,38351,38373,38374,38375,38377,38383,38384,38386,38388,38390,38485,38486,38488,38494,
   38495,38497,38499,38501,38521,38523,38529,38532,38534,38536,38557,38563,38564,38566,38568,38570,
   38628,38629,38631,38633,38635,38800,38802,38804,38806,38827,38829,38831,38876,38878,38921,39151,
   39152,39153,39156,39157,39158,39160,39166,39167,39169,39171,39173,39193,39194,39197,39198,39199,
   39201,39207,39208,39210,39212,39214,39234,39237,39238,39239,39241,39247,39248,39250,39252,39254,
   39276,39277,39278,39280,39286,39287,39289,39291,39293,39388,39389,39391,39397,39398,39400,39402,
   39424,39426,39432,39433,39435,39437,39439,39460,39466,39467,39469,39471,39473,39531,39534,39536,
   39538,39703,39705,39707,39709,39730,39732,39734,39779,39781,39824,40054,40055,40058,40059,40060,
   40062,40068,40069,40071,40073,40075,40095,40098,40099,40100,40102,40109,40111,40113,40115,40137,
   40138,40139,40141,40147,40148,40150,40152,40154,40249,40250,40252,40258,40259,40261,40265,40285,
   40287,40293,40294,40296,40298,40300,40321,40327,40328,40330,40332,40334,40392,40393,40395,40397,
   40399,40564,40566,40568,40570,40591,40593,40595,40640,40642,40685,40915,40918,40919,40920,40922,
   40928,40929,40931,40933,40935,40957,40958,40959,40961,40967,40968,40970,40972,40974,41069,41070,
   41072,41078,41079,41081,41083,41085,41105,41107,41113,41114,41116,41118,41120,41141,41147,41148,
   41150,41152,41212,41213,41215,41217,41219,41384,41386,41388,41390,41411,41413,41415,41460,41462,
   41505,41737,41738,41739,41741,41747,41748,41750,41752,41754,41849,41850,41852,41858,41859,41861,
   41863,41865,41885,41887,41893,41894,41896,41898,41900,41921,41927,41928,41930,41932,41934,41992,
   41993,41997,41999,42164,42166,42168,42170,42191,42193,42195,42240,42242,42285,42590,42591,42593,
   42599,42600,42602,42604,42606,42626,42628,42634,42635,42637,42641,42662,42668,42669,42673,42675,
   42733,42734,42736,42738,42740,42905,42907,42909,42911,42932,42934,42936,42981,42983,43026,44625,
   44627,44633,44634,44636,44638,44640,44661,44667,44668,44670,44672,44674,44732,44733,44735,44737,
   44739,44904,44906,44908,44910,44931,44933,44935,44980,44982,45025,45256,45262,45263,45265,45267,
   45269,45327,45328,45330,45332,45334,45499,45501,45503,45505,45526,45528,45530,45575,45577,45620,
   45888,45889,45891,45893,45895,46060,46062,46064,46066,46087,46089,46091,46136,46138,46181,47084,
   47086,47088,47090,47111,47113,47115,47160,47162,47205,49471,49473,49475,49520,49522,49565,49820,
   49822,49865,50394],[6152],[1827,6183],[6213],[1887,6243],[1915,6271],
 [1336,5692,5705,5867,39286],[23,26,31,32,41,42,44,89,90,91,92,93,94,107,156,158,163,166,
   173,177,1289,1290,1291,1292,1293,1296,1298,1300,1306,1309,1311,1313,1333,1334,1335,1336,1339,
   1340,1341,1343,1349,1350,1352,1354,1356,1376,1377,1378,1381,1382,1383,1385,1392,1394,1396,
   1398,1418,1419,1422,1423,1432,1433,1435,1459,1462,1463,1464,1466,1473,1475,1477,1479,1501,
   1502,1503,1505,1511,1512,1514,1516,1518,1613,1614,1616,1622,1623,1625,1627,1629,1649,1651,
   1657,1658,1660,1662,1664,1685,1691,1692,1694,1696,1698,1756,1757,1759,1761,1763,1928,1930,
   1932,1934,1955,1957,1959,2004,2006,2049,2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,
   2373,2383,2384,3500,3501,3502,3503,3504,3507,3508,3509,3511,3517,3518,3520,3522,3524,3544,
   3545,3546,3547,3550,3551,3552,3554,3560,3561,3563,3565,3567,3587,3588,3589,3592,3593,3594,
   3596,3602,3603,3605,3607,3609,3629,3630,3633,3634,3635,3637,3643,3644,3646,3648,3650,3670,
   3673,3674,3675,3677,3683,3684,3688,3690,3712,3713,3714,3716,3722,3723,3727,3729,3824,3825,
   3827,3833,3834,3836,3838,3840,3860,3862,3868,3869,3871,3873,3875,3896,3902,3903,3907,3909,
   3967,3968,3972,3974,4139,4141,4143,4145,4166,4168,4170,4215,4217,4260,4510,4511,4512,4518,
   4528,4529,5645,5646,5647,5648,5649,5652,5653,5654,5656,5662,5663,5665,5667,5669,5689,5690,
   5691,5692,5695,5696,5697,5699,5705,5706,5708,5710,5712,5732,5733,5734,5737,5738,5739,5741,
   5747,5748,5750,5752,5754,5774,5775,5778,5779,5780,5782,5788,5789,5791,5793,5795,5815,5818,
   5819,5820,5822,5828,5829,5831,5833,5835,5857,5861,5867,5868,5874,5969,5970,5972,5978,5979,
   5981,5983,5985,6005,6007,6013,6014,6016,6018,6020,6041,6047,6048,6050,6052,6054,6112,6113,
   6115,6117,6119,6284,6286,6288,6290,6311,6313,6315,6360,6362,6405,7725,7726,7727,7728,7729,
   7732,7733,7734,7736,7742,7743,7745,7747,7749,7769,7770,7771,7772,7775,7776,7777,7779,7785,
   7786,7788,7790,7792,7812,7813,7814,7817,7818,7819,7821,7827,7828,7830,7832,7834,7854,7855,
   7858,7859,7862,7868,7869,7871,7873,7875,7895,7898,7899,7900,7902,7908,7909,7911,7913,7915,
   7937,7938,7941,7947,7948,7950,7952,7954,8049,8050,8052,8058,8059,8061,8063,8065,8085,8087,
   8093,8094,8096,8098,8100,8121,8127,8128,8132,8192,8193,8195,8197,8199,8364,8366,8368,8370,
   8391,8393,8395,8440,8442,8485,38205,38206,38207,38208,38211,38212,38213,38215,38221,38222,
   38224,38226,38228,38248,38249,38250,38253,38254,38255,38257,38263,38264,38266,38268,38270,38290,
   38291,38294,38295,38296,38298,38304,38305,38307,38309,38311,38331,38334,38335,38336,38338,38344,
   38345,38347,38349,38351,38373,38374,38375,38377,38383,38384,38386,38388,38390,38485,38486,38488,
   38494,38495,38497,38499,38501,38521,38523,38529,38532,38534,38536,38557,38563,38564,38566,38568,
   38570,38628,38629,38631,38633,38635,38800,38802,38804,38806,38827,38829,38831,38876,38878,38921,
   39151,39152,39153,39156,39157,39158,39160,39166,39167,39169,39171,39173,39193,39194,39197,39198,
   39199,39201,39207,39208,39210,39212,39214,39234,39237,39238,39239,39241,39247,39248,39250,39252,
   39254,39276,39277,39278,39280,39286,39287,39289,39291,39293,39388,39389,39391,39397,39398,39400,
   39402,39424,39426,39432,39433,39435,39437,39439,39460,39466,39467,39469,39471,39473,39531,39534,
   39536,39538,39703,39705,39707,39709,39730,39732,39734,39779,39781,39824,40054,40055,40058,40059,
   40060,40062,40068,40069,40071,40073,40075,40095,40098,40099,40100,40102,40109,40111,40113,40115,
   40137,40138,40139,40141,40147,40148,40150,40152,40154,40249,40250,40252,40258,40259,40261,40265,
   40285,40287,40293,40294,40296,40298,40300,40321,40327,40328,40330,40332,40334,40392,40393,40395,
   40397,40399,40564,40566,40568,40570,40591,40593,40595,40640,40642,40685,40915,40918,40919,40920,
   40922,40928,40929,40931,40933,40935,40957,40958,40959,40961,40967,40968,40970,40972,40974,41069,
   41070,41072,41078,41079,41081,41083,41085,41105,41107,41113,41114,41116,41118,41120,41141,41147,
   41148,41150,41152,41212,41213,41215,41217,41219,41384,41386,41388,41390,41411,41413,41415,41460,
   41462,41505,41737,41738,41739,41741,41747,41748,41750,41752,41754,41849,41850,41852,41858,41859,
   41861,41863,41865,41885,41887,41893,41894,41896,41898,41900,41921,41927,41928,41930,41932,41934,
   41992,41993,41997,41999,42164,42166,42168,42170,42191,42193,42195,42240,42242,42285,42590,42591,
   42593,42599,42600,42602,42604,42606,42626,42628,42634,42635,42637,42641,42662,42668,42669,42673,
   42675,42733,42734,42736,42738,42740,42905,42907,42909,42911,42932,42934,42936,42981,42983,43026,
   44625,44627,44633,44634,44636,44638,44640,44661,44667,44668,44670,44672,44674,44732,44733,44735,
   44737,44739,44904,44906,44908,44910,44931,44933,44935,44980,44982,45025,45256,45262,45263,45265,
   45267,45269,45327,45328,45330,45332,45334,45499,45501,45503,45505,45526,45528,45530,45575,45577,
   45620,45888,45889,45891,45893,45895,46060,46062,46064,46066,46087,46089,46091,46136,46138,46181,
   47084,47086,47088,47090,47111,47113,47115,47160,47162,47205,49471,49473,49475,49520,49522,49565,
   49820,49822,49865,50394],[1984,6340],[23,26,31,32,41,42,44,89,90,91,92,93,94,107,156,
   158,163,166,173,177,1289,1290,1291,1292,1293,1296,1298,1300,1306,1309,1311,1313,1333,1334,
   1335,1336,1339,1340,1341,1343,1349,1350,1352,1354,1356,1376,1377,1378,1381,1382,1383,1385,
   1392,1394,1396,1398,1418,1419,1422,1423,1432,1433,1435,1459,1462,1463,1464,1466,1473,1475,
   1477,1479,1501,1502,1503,1505,1511,1512,1514,1516,1518,1613,1614,1616,1622,1623,1625,1627,
   1629,1649,1651,1657,1658,1660,1662,1664,1685,1691,1692,1694,1696,1698,1756,1757,1759,1761,
   1763,1928,1930,1932,1934,1955,1957,1959,2004,2006,2049,2279,2300,2301,2302,2308,2318,2319,
   2365,2366,2367,2373,2383,2384,3500,3501,3502,3503,3504,3507,3508,3509,3511,3517,3518,3520,
   3522,3524,3544,3545,3546,3547,3550,3551,3552,3554,3560,3561,3563,3565,3567,3587,3588,3589,
   3592,3593,3594,3596,3602,3603,3605,3607,3609,3629,3630,3633,3634,3635,3637,3643,3644,3646,
   3648,3650,3670,3673,3674,3675,3677,3683,3684,3688,3690,3712,3713,3714,3716,3722,3723,3727,
   3729,3824,3825,3827,3833,3834,3836,3838,3840,3860,3862,3868,3869,3871,3873,3875,3896,3902,
   3903,3907,3909,3967,3968,3972,3974,4139,4141,4143,4145,4166,4168,4170,4215,4217,4260,4510,
   4511,4512,4518,4528,4529,5645,5646,5647,5648,5649,5652,5653,5654,5656,5662,5663,5665,5667,
   5669,5689,5690,5691,5692,5695,5696,5697,5699,5705,5706,5708,5710,5712,5732,5733,5734,5737,
   5738,5739,5741,5747,5748,5750,5752,5754,5774,5775,5778,5779,5780,5782,5788,5789,5791,5793,
   5795,5815,5818,5819,5820,5822,5828,5829,5831,5833,5835,5857,5861,5867,5868,5874,5969,5970,
   5972,5978,5979,5981,5983,5985,6005,6007,6013,6014,6016,6018,6020,6041,6047,6048,6050,6052,
   6054,6112,6113,6115,6117,6119,6284,6286,6288,6290,6311,6313,6315,6360,6362,6405,7725,7726,
   7727,7728,7729,7732,7733,7734,7736,7742,7743,7745,7747,7749,7769,7770,7771,7772,7775,7776,
   7777,7779,7785,7786,7788,7790,7792,7812,7813,7814,7817,7818,7819,7821,7827,7828,7830,7832,
   7834,7854,7855,7858,7859,7862,7868,7869,7871,7873,7875,7895,7898,7899,7900,7902,7908,7909,
   7911,7913,7915,7937,7938,7941,7947,7948,7950,7952,7954,8049,8050,8052,8058,8059,8061,8063,
   8065,8085,8087,8093,8094,8096,8098,8100,8121,8127,8128,8132,8192,8193,8195,8197,8199,8364,
   8366,8368,8370,8391,8393,8395,8440,8442,8485,38205,38206,38207,38208,38211,38212,38213,38215,
   38221,38222,38224,38226,38228,38248,38249,38250,38253,38254,38255,38257,38263,38264,38266,38268,
   38270,38290,38291,38294,38295,38296,38298,38304,38305,38307,38309,38311,38331,38334,38335,38336,
   38338,38344,38345,38347,38349,38351,38373,38374,38375,38377,38383,38384,38386,38388,38390,38485,
   38486,38488,38494,38495,38497,38499,38501,38521,38523,38529,38532,38534,38536,38557,38563,38564,
   38566,38568,38570,38628,38629,38631,38633,38635,38800,38802,38804,38806,38827,38829,38831,38876,
   38878,38921,39151,39152,39153,39156,39157,39158,39160,39166,39167,39169,39171,39173,39193,39194,
   39197,39198,39199,39201,39207,39208,39210,39212,39214,39234,39237,39238,39239,39241,39247,39248,
   39250,39252,39254,39276,39277,39278,39280,39286,39287,39289,39291,39293,39388,39389,39391,39397,
   39398,39400,39402,39424,39426,39432,39433,39435,39437,39439,39460,39466,39467,39469,39471,39473,
   39531,39534,39536,39538,39703,39705,39707,39709,39730,39732,39734,39779,39781,39824,40054,40055,
   40058,40059,40060,40062,40068,40069,40071,40073,40075,40095,40098,40099,40100,40102,40109,40111,
   40113,40115,40137,40138,40139,40141,40147,40148,40150,40152,40154,40249,40250,40252,40258,40259,
   40261,40265,40285,40287,40293,40294,40296,40298,40300,40321,40327,40328,40330,40332,40334,40392,
   40393,40395,40397,40399,40564,40566,40568,40570,40591,40593,40595,40640,40642,40685,40915,40918,
   40919,40920,40922,40928,40929,40931,40933,40935,40957,40958,40959,40961,40967,40968,40970,40972,
   40974,41069,41070,41072,41078,41079,41081,41083,41085,41105,41107,41113,41114,41116,41118,41120,
   41141,41147,41148,41150,41152,41212,41213,41215,41217,41219,41384,41386,41388,41390,41411,41413,
   41415,41460,41462,41505,41737,41738,41739,41741,41747,41748,41750,41752,41754,41849,41850,41852,
   41858,41859,41861,41863,41865,41885,41887,41893,41894,41896,41898,41900,41921,41927,41928,41930,
   41932,41934,41992,41993,41997,41999,42164,42166,42168,42170,42191,42193,42195,42240,42242,42285,
   42590,42591,42593,42599,42600,42602,42604,42606,42626,42628,42634,42635,42637,42641,42662,42668,
   42669,42673,42675,42733,42734,42736,42738,42740,42905,42907,42909,42911,42932,42934,42936,42981,
   42983,43026,44625,44627,44633,44634,44636,44638,44640,44661,44667,44668,44670,44672,44674,44732,
   44733,44735,44737,44739,44904,44906,44908,44910,44931,44933,44935,44980,44982,45025,45256,45262,
   45263,45265,45267,45269,45327,45328,45330,45332,45334,45499,45501,45503,45505,45526,45528,45530,
   45575,45577,45620,45888,45889,45891,45893,45895,46060,46062,46064,46066,46087,46089,46091,46136,
   46138,46181,47084,47086,47088,47090,47111,47113,47115,47160,47162,47205,49471,49473,49475,49520,
   49522,49565,49820,49822,49865,50394],[2033,6389],
 [23,26,31,32,41,42,44,89,90,91,92,93,94,107,156,158,163,166,173,177,1289,1290,1291,1292,
   1293,1296,1298,1300,1306,1309,1311,1313,1333,1334,1335,1336,1339,1340,1341,1343,1349,1350,
   1352,1354,1356,1376,1377,1378,1381,1382,1383,1385,1392,1394,1396,1398,1418,1419,1422,1423,
   1432,1433,1435,1459,1462,1463,1464,1466,1473,1475,1477,1479,1501,1502,1503,1505,1511,1512,
   1514,1516,1518,1613,1614,1616,1622,1623,1625,1627,1629,1649,1651,1657,1658,1660,1662,1664,
   1685,1691,1692,1694,1696,1698,1756,1757,1759,1761,1763,1928,1930,1932,1934,1955,1957,1959,
   2004,2006,2049,2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,3501,
   3502,3503,3504,3507,3508,3509,3511,3517,3518,3520,3522,3524,3544,3545,3546,3547,3550,3551,
   3552,3554,3560,3561,3563,3565,3567,3587,3588,3589,3592,3593,3594,3596,3602,3603,3605,3607,
   3609,3629,3630,3633,3634,3635,3637,3643,3644,3646,3648,3650,3670,3673,3674,3675,3677,3683,
   3684,3688,3690,3712,3713,3714,3716,3722,3723,3727,3729,3824,3825,3827,3833,3834,3836,3838,
   3840,3860,3862,3868,3869,3871,3873,3875,3896,3902,3903,3907,3909,3967,3968,3972,3974,4139,
   4141,4143,4145,4166,4168,4170,4215,4217,4260,4510,4511,4512,4518,4528,4529,5645,5646,5647,
   5648,5649,5652,5653,5654,5656,5662,5663,5665,5667,5669,5689,5690,5691,5692,5695,5696,5697,
   5699,5705,5706,5708,5710,5712,5732,5733,5734,5737,5738,5739,5741,5747,5748,5750,5752,5754,
   5774,5775,5778,5779,5780,5782,5788,5789,5791,5793,5795,5815,5818,5819,5820,5822,5828,5829,
   5831,5833,5835,5857,5861,5867,5868,5874,5969,5970,5972,5978,5979,5981,5983,5985,6005,6007,
   6013,6014,6016,6018,6020,6041,6047,6048,6050,6052,6054,6112,6113,6115,6117,6119,6284,6286,
   6288,6290,6311,6313,6315,6360,6362,6405,7725,7726,7727,7728,7729,7732,7733,7734,7736,7742,
   7743,7745,7747,7749,7769,7770,7771,7772,7775,7776,7777,7779,7785,7786,7788,7790,7792,7812,
   7813,7814,7817,7818,7819,7821,7827,7828,7830,7832,7834,7854,7855,7858,7859,7862,7868,7869,
   7871,7873,7875,7895,7898,7899,7900,7902,7908,7909,7911,7913,7915,7937,7938,7941,7947,7948,
   7950,7952,7954,8049,8050,8052,8058,8059,8061,8063,8065,8085,8087,8093,8094,8096,8098,8100,
   8121,8127,8128,8132,8192,8193,8195,8197,8199,8364,8366,8368,8370,8391,8393,8395,8440,8442,
   8485,38205,38206,38207,38208,38211,38212,38213,38215,38221,38222,38224,38226,38228,38248,38249,
   38250,38253,38254,38255,38257,38263,38264,38266,38268,38270,38290,38291,38294,38295,38296,38298,
   38304,38305,38307,38309,38311,38331,38334,38335,38336,38338,38344,38345,38347,38349,38351,38373,
   38374,38375,38377,38383,38384,38386,38388,38390,38485,38486,38488,38494,38495,38497,38499,38501,
   38521,38523,38529,38532,38534,38536,38557,38563,38564,38566,38568,38570,38628,38629,38631,38633,
   38635,38800,38802,38804,38806,38827,38829,38831,38876,38878,38921,39151,39152,39153,39156,39157,
   39158,39160,39166,39167,39169,39171,39173,39193,39194,39197,39198,39199,39201,39207,39208,39210,
   39212,39214,39234,39237,39238,39239,39241,39247,39248,39250,39252,39254,39276,39277,39278,39280,
   39286,39287,39289,39291,39293,39388,39389,39391,39397,39398,39400,39402,39424,39426,39432,39433,
   39435,39437,39439,39460,39466,39467,39469,39471,39473,39531,39534,39536,39538,39703,39705,39707,
   39709,39730,39732,39734,39779,39781,39824,40054,40055,40058,40059,40060,40062,40068,40069,40071,
   40073,40075,40095,40098,40099,40100,40102,40109,40111,40113,40115,40137,40138,40139,40141,40147,
   40148,40150,40152,40154,40249,40250,40252,40258,40259,40261,40265,40285,40287,40293,40294,40296,
   40298,40300,40321,40327,40328,40330,40332,40334,40392,40393,40395,40397,40399,40564,40566,40568,
   40570,40591,40593,40595,40640,40642,40685,40915,40918,40919,40920,40922,40928,40929,40931,40933,
   40935,40957,40958,40959,40961,40967,40968,40970,40972,40974,41069,41070,41072,41078,41079,41081,
   41083,41085,41105,41107,41113,41114,41116,41118,41120,41141,41147,41148,41150,41152,41212,41213,
   41215,41217,41219,41384,41386,41388,41390,41411,41413,41415,41460,41462,41505,41737,41738,41739,
   41741,41747,41748,41750,41752,41754,41849,41850,41852,41858,41859,41861,41863,41865,41885,41887,
   41893,41894,41896,41898,41900,41921,41927,41928,41930,41932,41934,41992,41993,41997,41999,42164,
   42166,42168,42170,42191,42193,42195,42240,42242,42285,42590,42591,42593,42599,42600,42602,42604,
   42606,42626,42628,42634,42635,42637,42641,42662,42668,42669,42673,42675,42733,42734,42736,42738,
   42740,42905,42907,42909,42911,42932,42934,42936,42981,42983,43026,44625,44627,44633,44634,44636,
   44638,44640,44661,44667,44668,44670,44672,44674,44732,44733,44735,44737,44739,44904,44906,44908,
   44910,44931,44933,44935,44980,44982,45025,45256,45262,45263,45265,45267,45269,45327,45328,45330,
   45332,45334,45499,45501,45503,45505,45526,45528,45530,45575,45577,45620,45888,45889,45891,45893,
   45895,46060,46062,46064,46066,46087,46089,46091,46136,46138,46181,47084,47086,47088,47090,47111,
   47113,47115,47160,47162,47205,49471,49473,49475,49520,49522,49565,49820,49822,49865,50394],
 [90,94,107,1336,1349,1511,1724,1730,1933,5692,5698,5705,5711,5867,6080,6086,6289,39286,39499,
   39505,39708,46593],[23,26,31,32,41,42,44,89,90,91,92,93,94,107,156,158,163,166,173,177,
   1289,1290,1291,1292,1293,1296,1298,1300,1306,1309,1311,1313,1333,1334,1335,1336,1339,1340,
   1341,1343,1349,1350,1352,1354,1356,1376,1377,1378,1381,1382,1383,1385,1392,1394,1396,1398,
   1418,1419,1422,1423,1432,1433,1435,1459,1462,1463,1464,1466,1473,1475,1477,1479,1501,1502,
   1503,1505,1511,1512,1514,1516,1518,1613,1614,1616,1622,1623,1625,1627,1629,1649,1651,1657,
   1658,1660,1662,1664,1685,1691,1692,1694,1696,1698,1756,1757,1759,1761,1763,1928,1930,1932,
   1934,1955,1957,1959,2004,2006,2049,2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,
   2383,2384,3500,3501,3502,3503,3504,3507,3508,3509,3511,3517,3518,3520,3522,3524,3544,3545,
   3546,3547,3550,3551,3552,3554,3560,3561,3563,3565,3567,3587,3588,3589,3592,3593,3594,3596,
   3602,3603,3605,3607,3609,3629,3630,3633,3634,3635,3637,3643,3644,3646,3648,3650,3670,3673,
   3674,3675,3677,3683,3684,3688,3690,3712,3713,3714,3716,3722,3723,3727,3729,3824,3825,3827,
   3833,3834,3836,3838,3840,3860,3862,3868,3869,3871,3873,3875,3896,3902,3903,3907,3909,3967,
   3968,3972,3974,4139,4141,4143,4145,4166,4168,4170,4215,4217,4260,4510,4511,4512,4518,4528,
   4529,5645,5646,5647,5648,5649,5652,5653,5654,5656,5662,5663,5665,5667,5669,5689,5690,5691,
   5692,5695,5696,5697,5699,5705,5706,5708,5710,5712,5732,5733,5734,5737,5738,5739,5741,5747,
   5748,5750,5752,5754,5774,5775,5778,5779,5780,5782,5788,5789,5791,5793,5795,5815,5818,5819,
   5820,5822,5828,5829,5831,5833,5835,5857,5861,5867,5868,5874,5969,5970,5972,5978,5979,5981,
   5983,5985,6005,6007,6013,6014,6016,6018,6020,6041,6047,6048,6050,6052,6054,6112,6113,6115,
   6117,6119,6284,6286,6288,6290,6311,6313,6315,6360,6362,6405,7725,7726,7727,7728,7729,7732,
   7733,7734,7736,7742,7743,7745,7747,7749,7769,7770,7771,7772,7775,7776,7777,7779,7785,7786,
   7788,7790,7792,7812,7813,7814,7817,7818,7819,7821,7827,7828,7830,7832,7834,7854,7855,7858,
   7859,7862,7868,7869,7871,7873,7875,7895,7898,7899,7900,7902,7908,7909,7911,7913,7915,7937,
   7938,7941,7947,7948,7950,7952,7954,8049,8050,8052,8058,8059,8061,8063,8065,8085,8087,8093,
   8094,8096,8098,8100,8121,8127,8128,8132,8192,8193,8195,8197,8199,8364,8366,8368,8370,8391,
   8393,8395,8440,8442,8485,38205,38206,38207,38208,38211,38212,38213,38215,38221,38222,38224,
   38226,38228,38248,38249,38250,38253,38254,38255,38257,38263,38264,38266,38268,38270,38290,38291,
   38294,38295,38296,38298,38304,38305,38307,38309,38311,38331,38334,38335,38336,38338,38344,38345,
   38347,38349,38351,38373,38374,38375,38377,38383,38384,38386,38388,38390,38485,38486,38488,38494,
   38495,38497,38499,38501,38521,38523,38529,38532,38534,38536,38557,38563,38564,38566,38568,38570,
   38628,38629,38631,38633,38635,38800,38802,38804,38806,38827,38829,38831,38876,38878,38921,39151,
   39152,39153,39156,39157,39158,39160,39166,39167,39169,39171,39173,39193,39194,39197,39198,39199,
   39201,39207,39208,39210,39212,39214,39234,39237,39238,39239,39241,39247,39248,39250,39252,39254,
   39276,39277,39278,39280,39286,39287,39289,39291,39293,39388,39389,39391,39397,39398,39400,39402,
   39424,39426,39432,39433,39435,39437,39439,39460,39466,39467,39469,39471,39473,39531,39534,39536,
   39538,39703,39705,39707,39709,39730,39732,39734,39779,39781,39824,40054,40055,40058,40059,40060,
   40062,40068,40069,40071,40073,40075,40095,40098,40099,40100,40102,40109,40111,40113,40115,40137,
   40138,40139,40141,40147,40148,40150,40152,40154,40249,40250,40252,40258,40259,40261,40265,40285,
   40287,40293,40294,40296,40298,40300,40321,40327,40328,40330,40332,40334,40392,40393,40395,40397,
   40399,40564,40566,40568,40570,40591,40593,40595,40640,40642,40685,40915,40918,40919,40920,40922,
   40928,40929,40931,40933,40935,40957,40958,40959,40961,40967,40968,40970,40972,40974,41069,41070,
   41072,41078,41079,41081,41083,41085,41105,41107,41113,41114,41116,41118,41120,41141,41147,41148,
   41150,41152,41212,41213,41215,41217,41219,41384,41386,41388,41390,41411,41413,41415,41460,41462,
   41505,41737,41738,41739,41741,41747,41748,41750,41752,41754,41849,41850,41852,41858,41859,41861,
   41863,41865,41885,41887,41893,41894,41896,41898,41900,41921,41927,41928,41930,41932,41934,41992,
   41993,41997,41999,42164,42166,42168,42170,42191,42193,42195,42240,42242,42285,42590,42591,42593,
   42599,42600,42602,42604,42606,42626,42628,42634,42635,42637,42641,42662,42668,42669,42673,42675,
   42733,42734,42736,42738,42740,42905,42907,42909,42911,42932,42934,42936,42981,42983,43026,44625,
   44627,44633,44634,44636,44638,44640,44661,44667,44668,44670,44672,44674,44732,44733,44735,44737,
   44739,44904,44906,44908,44910,44931,44933,44935,44980,44982,45025,45256,45262,45263,45265,45267,
   45269,45327,45328,45330,45332,45334,45499,45501,45503,45505,45526,45528,45530,45575,45577,45620,
   45888,45889,45891,45893,45895,46060,46062,46064,46066,46087,46089,46091,46136,46138,46181,47084,
   47086,47088,47090,47111,47113,47115,47160,47162,47205,49471,49473,49475,49520,49522,49565,49820,
   49822,49865,50394],[1984,6340],[6152],[1827,6183],[6213],[2033,6389],[1887,6243],
 [1915,6271],[2215,6571],[2224,6580],[2224,6580],[2215,6571],[2254,6610],[2262,6618],
 [2268,6624],[2270,6626],[2254,6610],[2270,6626],[2262,6618],[2268,6624],[202],
 [268,6704],[328,6764],[393,6829],[202],[328,6764],[569,7005],[268,6704],[569,7005],
 [393,6829],[],[],[],[],[],[],[],[],[],[],
 [23,26,31,32,41,42,44,89,90,91,92,93,94,107,156,158,163,166,173,177,1289,1290,1291,1292,
   1293,1296,1298,1300,1306,1309,1311,1313,1333,1334,1335,1336,1339,1340,1341,1343,1349,1350,
   1352,1354,1356,1376,1377,1378,1381,1382,1383,1385,1392,1394,1396,1398,1418,1419,1422,1423,
   1432,1433,1435,1459,1462,1463,1464,1466,1473,1475,1477,1479,1501,1502,1503,1505,1511,1512,
   1514,1516,1518,1613,1614,1616,1622,1623,1625,1627,1629,1649,1651,1657,1658,1660,1662,1664,
   1685,1691,1692,1694,1696,1698,1756,1757,1759,1761,1763,1928,1930,1932,1934,1955,1957,1959,
   2004,2006,2049,2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,3501,
   3502,3503,3504,3507,3508,3509,3511,3517,3518,3520,3522,3524,3544,3545,3546,3547,3550,3551,
   3552,3554,3560,3561,3563,3565,3567,3587,3588,3589,3592,3593,3594,3596,3602,3603,3605,3607,
   3609,3629,3630,3633,3634,3635,3637,3643,3644,3646,3648,3650,3670,3673,3674,3675,3677,3683,
   3684,3688,3690,3712,3713,3714,3716,3722,3723,3727,3729,3824,3825,3827,3833,3834,3836,3838,
   3840,3860,3862,3868,3869,3871,3873,3875,3896,3902,3903,3907,3909,3967,3968,3972,3974,4139,
   4141,4143,4145,4166,4168,4170,4215,4217,4260,4510,4511,4512,4518,4528,4529,5645,5646,5647,
   5648,5649,5652,5653,5654,5656,5662,5663,5665,5667,5669,5689,5690,5691,5692,5695,5696,5697,
   5699,5705,5706,5708,5710,5712,5732,5733,5734,5737,5738,5739,5741,5747,5748,5750,5752,5754,
   5774,5775,5778,5779,5780,5782,5788,5789,5791,5793,5795,5815,5818,5819,5820,5822,5828,5829,
   5831,5833,5835,5857,5861,5867,5868,5874,5969,5970,5972,5978,5979,5981,5983,5985,6005,6007,
   6013,6014,6016,6018,6020,6041,6047,6048,6050,6052,6054,6112,6113,6115,6117,6119,6284,6286,
   6288,6290,6311,6313,6315,6360,6362,6405,7725,7726,7727,7728,7729,7732,7733,7734,7736,7742,
   7743,7745,7747,7749,7769,7770,7771,7772,7775,7776,7777,7779,7785,7786,7788,7790,7792,7812,
   7813,7814,7817,7818,7819,7821,7827,7828,7830,7832,7834,7854,7855,7858,7859,7862,7868,7869,
   7871,7873,7875,7895,7898,7899,7900,7902,7908,7909,7911,7913,7915,7937,7938,7941,7947,7948,
   7950,7952,7954,8049,8050,8052,8058,8059,8061,8063,8065,8085,8087,8093,8094,8096,8098,8100,
   8121,8127,8128,8132,8192,8193,8195,8197,8199,8364,8366,8368,8370,8391,8393,8395,8440,8442,
   8485,38205,38206,38207,38208,38211,38212,38213,38215,38221,38222,38224,38226,38228,38248,38249,
   38250,38253,38254,38255,38257,38263,38264,38266,38268,38270,38290,38291,38294,38295,38296,38298,
   38304,38305,38307,38309,38311,38331,38334,38335,38336,38338,38344,38345,38347,38349,38351,38373,
   38374,38375,38377,38383,38384,38386,38388,38390,38485,38486,38488,38494,38495,38497,38499,38501,
   38521,38523,38529,38532,38534,38536,38557,38563,38564,38566,38568,38570,38628,38629,38631,38633,
   38635,38800,38802,38804,38806,38827,38829,38831,38876,38878,38921,39151,39152,39153,39156,39157,
   39158,39160,39166,39167,39169,39171,39173,39193,39194,39197,39198,39199,39201,39207,39208,39210,
   39212,39214,39234,39237,39238,39239,39241,39247,39248,39250,39252,39254,39276,39277,39278,39280,
   39286,39287,39289,39291,39293,39388,39389,39391,39397,39398,39400,39402,39424,39426,39432,39433,
   39435,39437,39439,39460,39466,39467,39469,39471,39473,39531,39534,39536,39538,39703,39705,39707,
   39709,39730,39732,39734,39779,39781,39824,40054,40055,40058,40059,40060,40062,40068,40069,40071,
   40073,40075,40095,40098,40099,40100,40102,40109,40111,40113,40115,40137,40138,40139,40141,40147,
   40148,40150,40152,40154,40249,40250,40252,40258,40259,40261,40265,40285,40287,40293,40294,40296,
   40298,40300,40321,40327,40328,40330,40332,40334,40392,40393,40395,40397,40399,40564,40566,40568,
   40570,40591,40593,40595,40640,40642,40685,40915,40918,40919,40920,40922,40928,40929,40931,40933,
   40935,40957,40958,40959,40961,40967,40968,40970,40972,40974,41069,41070,41072,41078,41079,41081,
   41083,41085,41105,41107,41113,41114,41116,41118,41120,41141,41147,41148,41150,41152,41212,41213,
   41215,41217,41219,41384,41386,41388,41390,41411,41413,41415,41460,41462,41505,41737,41738,41739,
   41741,41747,41748,41750,41752,41754,41849,41850,41852,41858,41859,41861,41863,41865,41885,41887,
   41893,41894,41896,41898,41900,41921,41927,41928,41930,41932,41934,41992,41993,41997,41999,42164,
   42166,42168,42170,42191,42193,42195,42240,42242,42285,42590,42591,42593,42599,42600,42602,42604,
   42606,42626,42628,42634,42635,42637,42641,42662,42668,42669,42673,42675,42733,42734,42736,42738,
   42740,42905,42907,42909,42911,42932,42934,42936,42981,42983,43026,44625,44627,44633,44634,44636,
   44638,44640,44661,44667,44668,44670,44672,44674,44732,44733,44735,44737,44739,44904,44906,44908,
   44910,44931,44933,44935,44980,44982,45025,45256,45262,45263,45265,45267,45269,45327,45328,45330,
   45332,45334,45499,45501,45503,45505,45526,45528,45530,45575,45577,45620,45888,45889,45891,45893,
   45895,46060,46062,46064,46066,46087,46089,46091,46136,46138,46181,47084,47086,47088,47090,47111,
   47113,47115,47160,47162,47205,49471,49473,49475,49520,49522,49565,49820,49822,49865,50394],
 [23,26,31,32,41,42,44,89,90,91,92,93,94,107,156,158,163,166,173,177,1289,1290,1291,1292,
   1293,1296,1298,1300,1306,1309,1311,1313,1333,1334,1335,1336,1339,1340,1341,1343,1349,1350,
   1352,1354,1356,1376,1377,1378,1381,1382,1383,1385,1392,1394,1396,1398,1418,1419,1422,1423,
   1432,1433,1435,1459,1462,1463,1464,1466,1473,1475,1477,1479,1501,1502,1503,1505,1511,1512,
   1514,1516,1518,1613,1614,1616,1622,1623,1625,1627,1629,1649,1651,1657,1658,1660,1662,1664,
   1685,1691,1692,1694,1696,1698,1756,1757,1759,1761,1763,1928,1930,1932,1934,1955,1957,1959,
   2004,2006,2049,2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,3501,
   3502,3503,3504,3507,3508,3509,3511,3517,3518,3520,3522,3524,3544,3545,3546,3547,3550,3551,
   3552,3554,3560,3561,3563,3565,3567,3587,3588,3589,3592,3593,3594,3596,3602,3603,3605,3607,
   3609,3629,3630,3633,3634,3635,3637,3643,3644,3646,3648,3650,3670,3673,3674,3675,3677,3683,
   3684,3688,3690,3712,3713,3714,3716,3722,3723,3727,3729,3824,3825,3827,3833,3834,3836,3838,
   3840,3860,3862,3868,3869,3871,3873,3875,3896,3902,3903,3907,3909,3967,3968,3972,3974,4139,
   4141,4143,4145,4166,4168,4170,4215,4217,4260,4510,4511,4512,4518,4528,4529,5645,5646,5647,
   5648,5649,5652,5653,5654,5656,5662,5663,5665,5667,5669,5689,5690,5691,5692,5695,5696,5697,
   5699,5705,5706,5708,5710,5712,5732,5733,5734,5737,5738,5739,5741,5747,5748,5750,5752,5754,
   5774,5775,5778,5779,5780,5782,5788,5789,5791,5793,5795,5815,5818,5819,5820,5822,5828,5829,
   5831,5833,5835,5857,5861,5867,5868,5874,5969,5970,5972,5978,5979,5981,5983,5985,6005,6007,
   6013,6014,6016,6018,6020,6041,6047,6048,6050,6052,6054,6112,6113,6115,6117,6119,6284,6286,
   6288,6290,6311,6313,6315,6360,6362,6405,7725,7726,7727,7728,7729,7732,7733,7734,7736,7742,
   7743,7745,7747,7749,7769,7770,7771,7772,7775,7776,7777,7779,7785,7786,7788,7790,7792,7812,
   7813,7814,7817,7818,7819,7821,7827,7828,7830,7832,7834,7854,7855,7858,7859,7862,7868,7869,
   7871,7873,7875,7895,7898,7899,7900,7902,7908,7909,7911,7913,7915,7937,7938,7941,7947,7948,
   7950,7952,7954,8049,8050,8052,8058,8059,8061,8063,8065,8085,8087,8093,8094,8096,8098,8100,
   8121,8127,8128,8132,8192,8193,8195,8197,8199,8364,8366,8368,8370,8391,8393,8395,8440,8442,
   8485,38205,38206,38207,38208,38211,38212,38213,38215,38221,38222,38224,38226,38228,38248,38249,
   38250,38253,38254,38255,38257,38263,38264,38266,38268,38270,38290,38291,38294,38295,38296,38298,
   38304,38305,38307,38309,38311,38331,38334,38335,38336,38338,38344,38345,38347,38349,38351,38373,
   38374,38375,38377,38383,38384,38386,38388,38390,38485,38486,38488,38494,38495,38497,38499,38501,
   38521,38523,38529,38532,38534,38536,38557,38563,38564,38566,38568,38570,38628,38629,38631,38633,
   38635,38800,38802,38804,38806,38827,38829,38831,38876,38878,38921,39151,39152,39153,39156,39157,
   39158,39160,39166,39167,39169,39171,39173,39193,39194,39197,39198,39199,39201,39207,39208,39210,
   39212,39214,39234,39237,39238,39239,39241,39247,39248,39250,39252,39254,39276,39277,39278,39280,
   39286,39287,39289,39291,39293,39388,39389,39391,39397,39398,39400,39402,39424,39426,39432,39433,
   39435,39437,39439,39460,39466,39467,39469,39471,39473,39531,39534,39536,39538,39703,39705,39707,
   39709,39730,39732,39734,39779,39781,39824,40054,40055,40058,40059,40060,40062,40068,40069,40071,
   40073,40075,40095,40098,40099,40100,40102,40109,40111,40113,40115,40137,40138,40139,40141,40147,
   40148,40150,40152,40154,40249,40250,40252,40258,40259,40261,40265,40285,40287,40293,40294,40296,
   40298,40300,40321,40327,40328,40330,40332,40334,40392,40393,40395,40397,40399,40564,40566,40568,
   40570,40591,40593,40595,40640,40642,40685,40915,40918,40919,40920,40922,40928,40929,40931,40933,
   40935,40957,40958,40959,40961,40967,40968,40970,40972,40974,41069,41070,41072,41078,41079,41081,
   41083,41085,41105,41107,41113,41114,41116,41118,41120,41141,41147,41148,41150,41152,41212,41213,
   41215,41217,41219,41384,41386,41388,41390,41411,41413,41415,41460,41462,41505,41737,41738,41739,
   41741,41747,41748,41750,41752,41754,41849,41850,41852,41858,41859,41861,41863,41865,41885,41887,
   41893,41894,41896,41898,41900,41921,41927,41928,41930,41932,41934,41992,41993,41997,41999,42164,
   42166,42168,42170,42191,42193,42195,42240,42242,42285,42590,42591,42593,42599,42600,42602,42604,
   42606,42626,42628,42634,42635,42637,42641,42662,42668,42669,42673,42675,42733,42734,42736,42738,
   42740,42905,42907,42909,42911,42932,42934,42936,42981,42983,43026,44625,44627,44633,44634,44636,
   44638,44640,44661,44667,44668,44670,44672,44674,44732,44733,44735,44737,44739,44904,44906,44908,
   44910,44931,44933,44935,44980,44982,45025,45256,45262,45263,45265,45267,45269,45327,45328,45330,
   45332,45334,45499,45501,45503,45505,45526,45528,45530,45575,45577,45620,45888,45889,45891,45893,
   45895,46060,46062,46064,46066,46087,46089,46091,46136,46138,46181,47084,47086,47088,47090,47111,
   47113,47115,47160,47162,47205,49471,49473,49475,49520,49522,49565,49820,49822,49865,50394],
 [1377,1658,1761,7813,7818,7821,7828,7832,7899,7902,7909,7913,8087,8094,8098,8193,8197,8393,
   40099,40102,40109,40113,40287,40294,40298,40393,40397,40593,41887,41894,41898,41993,41997,42193,
   45328,45332,45528,47113],[1424,1439,1698,7860,7875,8134,41154],
 [1377,1658,1761,7813,7818,7821,7828,7832,7899,7902,7909,7913,8087,8094,8098,8193,8197,8393,
   40099,40102,40109,40113,40287,40294,40298,40393,40397,40593,41887,41894,41898,41993,41997,42193,
   45328,45332,45528,47113],[23,26,31,32,41,42,44,89,90,91,92,93,94,107,156,158,163,166,
   173,177,1289,1290,1291,1292,1293,1296,1298,1300,1306,1309,1311,1313,1333,1334,1335,1336,1339,
   1340,1341,1343,1349,1350,1352,1354,1356,1376,1377,1378,1381,1382,1383,1385,1392,1394,1396,
   1398,1418,1419,1422,1423,1432,1433,1435,1459,1462,1463,1464,1466,1473,1475,1477,1479,1501,
   1502,1503,1505,1511,1512,1514,1516,1518,1613,1614,1616,1622,1623,1625,1627,1629,1649,1651,
   1657,1658,1660,1662,1664,1685,1691,1692,1694,1696,1698,1756,1757,1759,1761,1763,1928,1930,
   1932,1934,1955,1957,1959,2004,2006,2049,2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,
   2373,2383,2384,3500,3501,3502,3503,3504,3507,3508,3509,3511,3517,3518,3520,3522,3524,3544,
   3545,3546,3547,3550,3551,3552,3554,3560,3561,3563,3565,3567,3587,3588,3589,3592,3593,3594,
   3596,3602,3603,3605,3607,3609,3629,3630,3633,3634,3635,3637,3643,3644,3646,3648,3650,3670,
   3673,3674,3675,3677,3683,3684,3688,3690,3712,3713,3714,3716,3722,3723,3727,3729,3824,3825,
   3827,3833,3834,3836,3838,3840,3860,3862,3868,3869,3871,3873,3875,3896,3902,3903,3907,3909,
   3967,3968,3972,3974,4139,4141,4143,4145,4166,4168,4170,4215,4217,4260,4510,4511,4512,4518,
   4528,4529,5645,5646,5647,5648,5649,5652,5653,5654,5656,5662,5663,5665,5667,5669,5689,5690,
   5691,5692,5695,5696,5697,5699,5705,5706,5708,5710,5712,5732,5733,5734,5737,5738,5739,5741,
   5747,5748,5750,5752,5754,5774,5775,5778,5779,5780,5782,5788,5789,5791,5793,5795,5815,5818,
   5819,5820,5822,5828,5829,5831,5833,5835,5857,5861,5867,5868,5874,5969,5970,5972,5978,5979,
   5981,5983,5985,6005,6007,6013,6014,6016,6018,6020,6041,6047,6048,6050,6052,6054,6112,6113,
   6115,6117,6119,6284,6286,6288,6290,6311,6313,6315,6360,6362,6405,7725,7726,7727,7728,7729,
   7732,7733,7734,7736,7742,7743,7745,7747,7749,7769,7770,7771,7772,7775,7776,7777,7779,7785,
   7786,7788,7790,7792,7812,7813,7814,7817,7818,7819,7821,7827,7828,7830,7832,7834,7854,7855,
   7858,7859,7862,7868,7869,7871,7873,7875,7895,7898,7899,7900,7902,7908,7909,7911,7913,7915,
   7937,7938,7941,7947,7948,7950,7952,7954,8049,8050,8052,8058,8059,8061,8063,8065,8085,8087,
   8093,8094,8096,8098,8100,8121,8127,8128,8132,8192,8193,8195,8197,8199,8364,8366,8368,8370,
   8391,8393,8395,8440,8442,8485,38205,38206,38207,38208,38211,38212,38213,38215,38221,38222,
   38224,38226,38228,38248,38249,38250,38253,38254,38255,38257,38263,38264,38266,38268,38270,38290,
   38291,38294,38295,38296,38298,38304,38305,38307,38309,38311,38331,38334,38335,38336,38338,38344,
   38345,38347,38349,38351,38373,38374,38375,38377,38383,38384,38386,38388,38390,38485,38486,38488,
   38494,38495,38497,38499,38501,38521,38523,38529,38532,38534,38536,38557,38563,38564,38566,38568,
   38570,38628,38629,38631,38633,38635,38800,38802,38804,38806,38827,38829,38831,38876,38878,38921,
   39151,39152,39153,39156,39157,39158,39160,39166,39167,39169,39171,39173,39193,39194,39197,39198,
   39199,39201,39207,39208,39210,39212,39214,39234,39237,39238,39239,39241,39247,39248,39250,39252,
   39254,39276,39277,39278,39280,39286,39287,39289,39291,39293,39388,39389,39391,39397,39398,39400,
   39402,39424,39426,39432,39433,39435,39437,39439,39460,39466,39467,39469,39471,39473,39531,39534,
   39536,39538,39703,39705,39707,39709,39730,39732,39734,39779,39781,39824,40054,40055,40058,40059,
   40060,40062,40068,40069,40071,40073,40075,40095,40098,40099,40100,40102,40109,40111,40113,40115,
   40137,40138,40139,40141,40147,40148,40150,40152,40154,40249,40250,40252,40258,40259,40261,40265,
   40285,40287,40293,40294,40296,40298,40300,40321,40327,40328,40330,40332,40334,40392,40393,40395,
   40397,40399,40564,40566,40568,40570,40591,40593,40595,40640,40642,40685,40915,40918,40919,40920,
   40922,40928,40929,40931,40933,40935,40957,40958,40959,40961,40967,40968,40970,40972,40974,41069,
   41070,41072,41078,41079,41081,41083,41085,41105,41107,41113,41114,41116,41118,41120,41141,41147,
   41148,41150,41152,41212,41213,41215,41217,41219,41384,41386,41388,41390,41411,41413,41415,41460,
   41462,41505,41737,41738,41739,41741,41747,41748,41750,41752,41754,41849,41850,41852,41858,41859,
   41861,41863,41865,41885,41887,41893,41894,41896,41898,41900,41921,41927,41928,41930,41932,41934,
   41992,41993,41997,41999,42164,42166,42168,42170,42191,42193,42195,42240,42242,42285,42590,42591,
   42593,42599,42600,42602,42604,42606,42626,42628,42634,42635,42637,42641,42662,42668,42669,42673,
   42675,42733,42734,42736,42738,42740,42905,42907,42909,42911,42932,42934,42936,42981,42983,43026,
   44625,44627,44633,44634,44636,44638,44640,44661,44667,44668,44670,44672,44674,44732,44733,44735,
   44737,44739,44904,44906,44908,44910,44931,44933,44935,44980,44982,45025,45256,45262,45263,45265,
   45267,45269,45327,45328,45330,45332,45334,45499,45501,45503,45505,45526,45528,45530,45575,45577,
   45620,45888,45889,45891,45893,45895,46060,46062,46064,46066,46087,46089,46091,46136,46138,46181,
   47084,47086,47088,47090,47111,47113,47115,47160,47162,47205,49471,49473,49475,49520,49522,49565,
   49820,49822,49865,50394],[1560,7996],[8032],
 [23,26,31,32,41,42,44,89,90,91,92,93,94,107,156,158,163,166,173,177,1289,1290,1291,1292,
   1293,1296,1298,1300,1306,1309,1311,1313,1333,1334,1335,1336,1339,1340,1341,1343,1349,1350,
   1352,1354,1356,1376,1377,1378,1381,1382,1383,1385,1392,1394,1396,1398,1418,1419,1422,1423,
   1432,1433,1435,1459,1462,1463,1464,1466,1473,1475,1477,1479,1501,1502,1503,1505,1511,1512,
   1514,1516,1518,1613,1614,1616,1622,1623,1625,1627,1629,1649,1651,1657,1658,1660,1662,1664,
   1685,1691,1692,1694,1696,1698,1756,1757,1759,1761,1763,1928,1930,1932,1934,1955,1957,1959,
   2004,2006,2049,2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,3501,
   3502,3503,3504,3507,3508,3509,3511,3517,3518,3520,3522,3524,3544,3545,3546,3547,3550,3551,
   3552,3554,3560,3561,3563,3565,3567,3587,3588,3589,3592,3593,3594,3596,3602,3603,3605,3607,
   3609,3629,3630,3633,3634,3635,3637,3643,3644,3646,3648,3650,3670,3673,3674,3675,3677,3683,
   3684,3688,3690,3712,3713,3714,3716,3722,3723,3727,3729,3824,3825,3827,3833,3834,3836,3838,
   3840,3860,3862,3868,3869,3871,3873,3875,3896,3902,3903,3907,3909,3967,3968,3972,3974,4139,
   4141,4143,4145,4166,4168,4170,4215,4217,4260,4510,4511,4512,4518,4528,4529,5645,5646,5647,
   5648,5649,5652,5653,5654,5656,5662,5663,5665,5667,5669,5689,5690,5691,5692,5695,5696,5697,
   5699,5705,5706,5708,5710,5712,5732,5733,5734,5737,5738,5739,5741,5747,5748,5750,5752,5754,
   5774,5775,5778,5779,5780,5782,5788,5789,5791,5793,5795,5815,5818,5819,5820,5822,5828,5829,
   5831,5833,5835,5857,5861,5867,5868,5874,5969,5970,5972,5978,5979,5981,5983,5985,6005,6007,
   6013,6014,6016,6018,6020,6041,6047,6048,6050,6052,6054,6112,6113,6115,6117,6119,6284,6286,
   6288,6290,6311,6313,6315,6360,6362,6405,7725,7726,7727,7728,7729,7732,7733,7734,7736,7742,
   7743,7745,7747,7749,7769,7770,7771,7772,7775,7776,7777,7779,7785,7786,7788,7790,7792,7812,
   7813,7814,7817,7818,7819,7821,7827,7828,7830,7832,7834,7854,7855,7858,7859,7862,7868,7869,
   7871,7873,7875,7895,7898,7899,7900,7902,7908,7909,7911,7913,7915,7937,7938,7941,7947,7948,
   7950,7952,7954,8049,8050,8052,8058,8059,8061,8063,8065,8085,8087,8093,8094,8096,8098,8100,
   8121,8127,8128,8132,8192,8193,8195,8197,8199,8364,8366,8368,8370,8391,8393,8395,8440,8442,
   8485,38205,38206,38207,38208,38211,38212,38213,38215,38221,38222,38224,38226,38228,38248,38249,
   38250,38253,38254,38255,38257,38263,38264,38266,38268,38270,38290,38291,38294,38295,38296,38298,
   38304,38305,38307,38309,38311,38331,38334,38335,38336,38338,38344,38345,38347,38349,38351,38373,
   38374,38375,38377,38383,38384,38386,38388,38390,38485,38486,38488,38494,38495,38497,38499,38501,
   38521,38523,38529,38532,38534,38536,38557,38563,38564,38566,38568,38570,38628,38629,38631,38633,
   38635,38800,38802,38804,38806,38827,38829,38831,38876,38878,38921,39151,39152,39153,39156,39157,
   39158,39160,39166,39167,39169,39171,39173,39193,39194,39197,39198,39199,39201,39207,39208,39210,
   39212,39214,39234,39237,39238,39239,39241,39247,39248,39250,39252,39254,39276,39277,39278,39280,
   39286,39287,39289,39291,39293,39388,39389,39391,39397,39398,39400,39402,39424,39426,39432,39433,
   39435,39437,39439,39460,39466,39467,39469,39471,39473,39531,39534,39536,39538,39703,39705,39707,
   39709,39730,39732,39734,39779,39781,39824,40054,40055,40058,40059,40060,40062,40068,40069,40071,
   40073,40075,40095,40098,40099,40100,40102,40109,40111,40113,40115,40137,40138,40139,40141,40147,
   40148,40150,40152,40154,40249,40250,40252,40258,40259,40261,40265,40285,40287,40293,40294,40296,
   40298,40300,40321,40327,40328,40330,40332,40334,40392,40393,40395,40397,40399,40564,40566,40568,
   40570,40591,40593,40595,40640,40642,40685,40915,40918,40919,40920,40922,40928,40929,40931,40933,
   40935,40957,40958,40959,40961,40967,40968,40970,40972,40974,41069,41070,41072,41078,41079,41081,
   41083,41085,41105,41107,41113,41114,41116,41118,41120,41141,41147,41148,41150,41152,41212,41213,
   41215,41217,41219,41384,41386,41388,41390,41411,41413,41415,41460,41462,41505,41737,41738,41739,
   41741,41747,41748,41750,41752,41754,41849,41850,41852,41858,41859,41861,41863,41865,41885,41887,
   41893,41894,41896,41898,41900,41921,41927,41928,41930,41932,41934,41992,41993,41997,41999,42164,
   42166,42168,42170,42191,42193,42195,42240,42242,42285,42590,42591,42593,42599,42600,42602,42604,
   42606,42626,42628,42634,42635,42637,42641,42662,42668,42669,42673,42675,42733,42734,42736,42738,
   42740,42905,42907,42909,42911,42932,42934,42936,42981,42983,43026,44625,44627,44633,44634,44636,
   44638,44640,44661,44667,44668,44670,44672,44674,44732,44733,44735,44737,44739,44904,44906,44908,
   44910,44931,44933,44935,44980,44982,45025,45256,45262,45263,45265,45267,45269,45327,45328,45330,
   45332,45334,45499,45501,45503,45505,45526,45528,45530,45575,45577,45620,45888,45889,45891,45893,
   45895,46060,46062,46064,46066,46087,46089,46091,46136,46138,46181,47084,47086,47088,47090,47111,
   47113,47115,47160,47162,47205,49471,49473,49475,49520,49522,49565,49820,49822,49865,50394],
 [1377,1658,1761,7813,7818,7821,7828,7832,7899,7902,7909,7913,8087,8094,8098,8193,8197,8393,
   40099,40102,40109,40113,40287,40294,40298,40393,40397,40593,41887,41894,41898,41993,41997,42193,
   45328,45332,45528,47113],[1424,1439,1698,7860,7875,8134,41154],[8168],
 [1377,1658,1761,7813,7818,7821,7828,7832,7899,7902,7909,7913,8087,8094,8098,8193,8197,8393,
   40099,40102,40109,40113,40287,40294,40298,40393,40397,40593,41887,41894,41898,41993,41997,42193,
   45328,45332,45528,47113],[156,158,163,166,173,177,1377,1382,1385,1392,1396,1463,1466,1473,
   1477,1540,1542,1544,1550,1551,1650,1651,1652,1658,1659,1662,1719,1725,1726,1757,1761,1788,
   1789,1954,1957,7813,7818,7821,7822,7828,7829,7832,7899,7902,7909,7913,8087,8094,8098,8193,
   8197,8224,8225,8390,8393,40099,40102,40109,40113,40287,40294,40298,40393,40397,40424,40425,
   40590,40593,41887,41894,41898,41993,41997,42193,43330,43332,43338,43339,43399,43405,43406,43468,
   43469,43634,45290,45296,45297,45328,45332,45359,45360,45525,45528,46448,46449,46614,47113,47575]
  ,[156,158,163,166,173,177,1377,1382,1385,1387,1388,1392,1396,1400,1401,1463,1466,1468,1469,
   1473,1477,1481,1482,1651,1658,1662,1757,1761,1814,1826,1827,1855,1856,1957,2126,7813,7818,
   7821,7823,7824,7828,7832,7899,7902,7909,7913,8087,8094,8098,8193,8197,8250,8254,8283,8393,
   40099,40102,40104,40105,40109,40113,40117,40118,40287,40294,40298,40393,40397,40450,40454,40462,
   40463,40483,40491,40492,40593,40762,41887,41894,41898,41993,41997,42050,42062,42063,42091,42092,
   42193,42362,45328,45332,45528,47113,47903,47911,47912,48182,48588],
 [156,158,163,166,173,177,1377,1382,1385,1387,1388,1392,1396,1400,1401,1463,1466,1468,1469,1473,
   1477,1481,1482,1651,1658,1662,1757,1761,1814,1826,1827,1855,1856,1957,2126,7813,7818,7821,
   7823,7824,7828,7832,7899,7902,7909,7913,8087,8094,8098,8193,8197,8250,8254,8283,8393,40099,
   40102,40104,40105,40109,40113,40117,40118,40287,40294,40298,40393,40397,40450,40454,40462,40463,
   40483,40491,40492,40593,40762,41887,41894,41898,41993,41997,42050,42062,42063,42091,42092,42193,
   42362,45328,45332,45528,47113,47903,47911,47912,48182,48588],[1887,8323],[1915,8351],
 [23,26,31,32,41,42,44,89,90,91,92,93,94,107,156,158,163,166,173,177,1289,1290,1291,1292,
   1293,1296,1298,1300,1306,1309,1311,1313,1333,1334,1335,1336,1339,1340,1341,1343,1349,1350,
   1352,1354,1356,1376,1377,1378,1381,1382,1383,1385,1392,1394,1396,1398,1418,1419,1422,1423,
   1432,1433,1435,1459,1462,1463,1464,1466,1473,1475,1477,1479,1501,1502,1503,1505,1511,1512,
   1514,1516,1518,1613,1614,1616,1622,1623,1625,1627,1629,1649,1651,1657,1658,1660,1662,1664,
   1685,1691,1692,1694,1696,1698,1756,1757,1759,1761,1763,1928,1930,1932,1934,1955,1957,1959,
   2004,2006,2049,2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,3501,
   3502,3503,3504,3507,3508,3509,3511,3517,3518,3520,3522,3524,3544,3545,3546,3547,3550,3551,
   3552,3554,3560,3561,3563,3565,3567,3587,3588,3589,3592,3593,3594,3596,3602,3603,3605,3607,
   3609,3629,3630,3633,3634,3635,3637,3643,3644,3646,3648,3650,3670,3673,3674,3675,3677,3683,
   3684,3688,3690,3712,3713,3714,3716,3722,3723,3727,3729,3824,3825,3827,3833,3834,3836,3838,
   3840,3860,3862,3868,3869,3871,3873,3875,3896,3902,3903,3907,3909,3967,3968,3972,3974,4139,
   4141,4143,4145,4166,4168,4170,4215,4217,4260,4510,4511,4512,4518,4528,4529,5645,5646,5647,
   5648,5649,5652,5653,5654,5656,5662,5663,5665,5667,5669,5689,5690,5691,5692,5695,5696,5697,
   5699,5705,5706,5708,5710,5712,5732,5733,5734,5737,5738,5739,5741,5747,5748,5750,5752,5754,
   5774,5775,5778,5779,5780,5782,5788,5789,5791,5793,5795,5815,5818,5819,5820,5822,5828,5829,
   5831,5833,5835,5857,5861,5867,5868,5874,5969,5970,5972,5978,5979,5981,5983,5985,6005,6007,
   6013,6014,6016,6018,6020,6041,6047,6048,6050,6052,6054,6112,6113,6115,6117,6119,6284,6286,
   6288,6290,6311,6313,6315,6360,6362,6405,7725,7726,7727,7728,7729,7732,7733,7734,7736,7742,
   7743,7745,7747,7749,7769,7770,7771,7772,7775,7776,7777,7779,7785,7786,7788,7790,7792,7812,
   7813,7814,7817,7818,7819,7821,7827,7828,7830,7832,7834,7854,7855,7858,7859,7862,7868,7869,
   7871,7873,7875,7895,7898,7899,7900,7902,7908,7909,7911,7913,7915,7937,7938,7941,7947,7948,
   7950,7952,7954,8049,8050,8052,8058,8059,8061,8063,8065,8085,8087,8093,8094,8096,8098,8100,
   8121,8127,8128,8132,8192,8193,8195,8197,8199,8364,8366,8368,8370,8391,8393,8395,8440,8442,
   8485,38205,38206,38207,38208,38211,38212,38213,38215,38221,38222,38224,38226,38228,38248,38249,
   38250,38253,38254,38255,38257,38263,38264,38266,38268,38270,38290,38291,38294,38295,38296,38298,
   38304,38305,38307,38309,38311,38331,38334,38335,38336,38338,38344,38345,38347,38349,38351,38373,
   38374,38375,38377,38383,38384,38386,38388,38390,38485,38486,38488,38494,38495,38497,38499,38501,
   38521,38523,38529,38532,38534,38536,38557,38563,38564,38566,38568,38570,38628,38629,38631,38633,
   38635,38800,38802,38804,38806,38827,38829,38831,38876,38878,38921,39151,39152,39153,39156,39157,
   39158,39160,39166,39167,39169,39171,39173,39193,39194,39197,39198,39199,39201,39207,39208,39210,
   39212,39214,39234,39237,39238,39239,39241,39247,39248,39250,39252,39254,39276,39277,39278,39280,
   39286,39287,39289,39291,39293,39388,39389,39391,39397,39398,39400,39402,39424,39426,39432,39433,
   39435,39437,39439,39460,39466,39467,39469,39471,39473,39531,39534,39536,39538,39703,39705,39707,
   39709,39730,39732,39734,39779,39781,39824,40054,40055,40058,40059,40060,40062,40068,40069,40071,
   40073,40075,40095,40098,40099,40100,40102,40109,40111,40113,40115,40137,40138,40139,40141,40147,
   40148,40150,40152,40154,40249,40250,40252,40258,40259,40261,40265,40285,40287,40293,40294,40296,
   40298,40300,40321,40327,40328,40330,40332,40334,40392,40393,40395,40397,40399,40564,40566,40568,
   40570,40591,40593,40595,40640,40642,40685,40915,40918,40919,40920,40922,40928,40929,40931,40933,
   40935,40957,40958,40959,40961,40967,40968,40970,40972,40974,41069,41070,41072,41078,41079,41081,
   41083,41085,41105,41107,41113,41114,41116,41118,41120,41141,41147,41148,41150,41152,41212,41213,
   41215,41217,41219,41384,41386,41388,41390,41411,41413,41415,41460,41462,41505,41737,41738,41739,
   41741,41747,41748,41750,41752,41754,41849,41850,41852,41858,41859,41861,41863,41865,41885,41887,
   41893,41894,41896,41898,41900,41921,41927,41928,41930,41932,41934,41992,41993,41997,41999,42164,
   42166,42168,42170,42191,42193,42195,42240,42242,42285,42590,42591,42593,42599,42600,42602,42604,
   42606,42626,42628,42634,42635,42637,42641,42662,42668,42669,42673,42675,42733,42734,42736,42738,
   42740,42905,42907,42909,42911,42932,42934,42936,42981,42983,43026,44625,44627,44633,44634,44636,
   44638,44640,44661,44667,44668,44670,44672,44674,44732,44733,44735,44737,44739,44904,44906,44908,
   44910,44931,44933,44935,44980,44982,45025,45256,45262,45263,45265,45267,45269,45327,45328,45330,
   45332,45334,45499,45501,45503,45505,45526,45528,45530,45575,45577,45620,45888,45889,45891,45893,
   45895,46060,46062,46064,46066,46087,46089,46091,46136,46138,46181,47084,47086,47088,47090,47111,
   47113,47115,47160,47162,47205,49471,49473,49475,49520,49522,49565,49820,49822,49865,50394],
 [1377,1658,1761,7813,7818,7821,7828,7832,7899,7902,7909,7913,8087,8094,8098,8193,8197,8393,
   40099,40102,40109,40113,40287,40294,40298,40393,40397,40593,41887,41894,41898,41993,41997,42193,
   45328,45332,45528,47113],[156,158,163,166,173,177,1377,1382,1385,1392,1396,1463,1466,1473,
   1477,1540,1542,1544,1550,1551,1650,1651,1652,1658,1659,1662,1719,1725,1726,1757,1761,1788,
   1789,1954,1957,7813,7818,7821,7822,7828,7829,7832,7899,7902,7909,7913,8087,8094,8098,8193,
   8197,8224,8225,8390,8393,40099,40102,40109,40113,40287,40294,40298,40393,40397,40424,40425,
   40590,40593,41887,41894,41898,41993,41997,42193,43330,43332,43338,43339,43399,43405,43406,43468,
   43469,43634,45290,45296,45297,45328,45332,45359,45360,45525,45528,46448,46449,46614,47113,47575]
  ,[23,26,31,32,41,42,44,89,90,91,92,93,94,107,156,158,163,166,173,177,1289,1290,1291,
   1292,1293,1296,1298,1300,1306,1309,1311,1313,1333,1334,1335,1336,1339,1340,1341,1343,1349,
   1350,1352,1354,1356,1376,1377,1378,1381,1382,1383,1385,1392,1394,1396,1398,1418,1419,1422,
   1423,1432,1433,1435,1459,1462,1463,1464,1466,1473,1475,1477,1479,1501,1502,1503,1505,1511,
   1512,1514,1516,1518,1613,1614,1616,1622,1623,1625,1627,1629,1649,1651,1657,1658,1660,1662,
   1664,1685,1691,1692,1694,1696,1698,1756,1757,1759,1761,1763,1928,1930,1932,1934,1955,1957,
   1959,2004,2006,2049,2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,
   3501,3502,3503,3504,3507,3508,3509,3511,3517,3518,3520,3522,3524,3544,3545,3546,3547,3550,
   3551,3552,3554,3560,3561,3563,3565,3567,3587,3588,3589,3592,3593,3594,3596,3602,3603,3605,
   3607,3609,3629,3630,3633,3634,3635,3637,3643,3644,3646,3648,3650,3670,3673,3674,3675,3677,
   3683,3684,3688,3690,3712,3713,3714,3716,3722,3723,3727,3729,3824,3825,3827,3833,3834,3836,
   3838,3840,3860,3862,3868,3869,3871,3873,3875,3896,3902,3903,3907,3909,3967,3968,3972,3974,
   4139,4141,4143,4145,4166,4168,4170,4215,4217,4260,4510,4511,4512,4518,4528,4529,5645,5646,
   5647,5648,5649,5652,5653,5654,5656,5662,5663,5665,5667,5669,5689,5690,5691,5692,5695,5696,
   5697,5699,5705,5706,5708,5710,5712,5732,5733,5734,5737,5738,5739,5741,5747,5748,5750,5752,
   5754,5774,5775,5778,5779,5780,5782,5788,5789,5791,5793,5795,5815,5818,5819,5820,5822,5828,
   5829,5831,5833,5835,5857,5861,5867,5868,5874,5969,5970,5972,5978,5979,5981,5983,5985,6005,
   6007,6013,6014,6016,6018,6020,6041,6047,6048,6050,6052,6054,6112,6113,6115,6117,6119,6284,
   6286,6288,6290,6311,6313,6315,6360,6362,6405,7725,7726,7727,7728,7729,7732,7733,7734,7736,
   7742,7743,7745,7747,7749,7769,7770,7771,7772,7775,7776,7777,7779,7785,7786,7788,7790,7792,
   7812,7813,7814,7817,7818,7819,7821,7827,7828,7830,7832,7834,7854,7855,7858,7859,7862,7868,
   7869,7871,7873,7875,7895,7898,7899,7900,7902,7908,7909,7911,7913,7915,7937,7938,7941,7947,
   7948,7950,7952,7954,8049,8050,8052,8058,8059,8061,8063,8065,8085,8087,8093,8094,8096,8098,
   8100,8121,8127,8128,8132,8192,8193,8195,8197,8199,8364,8366,8368,8370,8391,8393,8395,8440,
   8442,8485,38205,38206,38207,38208,38211,38212,38213,38215,38221,38222,38224,38226,38228,38248,
   38249,38250,38253,38254,38255,38257,38263,38264,38266,38268,38270,38290,38291,38294,38295,38296,
   38298,38304,38305,38307,38309,38311,38331,38334,38335,38336,38338,38344,38345,38347,38349,38351,
   38373,38374,38375,38377,38383,38384,38386,38388,38390,38485,38486,38488,38494,38495,38497,38499,
   38501,38521,38523,38529,38532,38534,38536,38557,38563,38564,38566,38568,38570,38628,38629,38631,
   38633,38635,38800,38802,38804,38806,38827,38829,38831,38876,38878,38921,39151,39152,39153,39156,
   39157,39158,39160,39166,39167,39169,39171,39173,39193,39194,39197,39198,39199,39201,39207,39208,
   39210,39212,39214,39234,39237,39238,39239,39241,39247,39248,39250,39252,39254,39276,39277,39278,
   39280,39286,39287,39289,39291,39293,39388,39389,39391,39397,39398,39400,39402,39424,39426,39432,
   39433,39435,39437,39439,39460,39466,39467,39469,39471,39473,39531,39534,39536,39538,39703,39705,
   39707,39709,39730,39732,39734,39779,39781,39824,40054,40055,40058,40059,40060,40062,40068,40069,
   40071,40073,40075,40095,40098,40099,40100,40102,40109,40111,40113,40115,40137,40138,40139,40141,
   40147,40148,40150,40152,40154,40249,40250,40252,40258,40259,40261,40265,40285,40287,40293,40294,
   40296,40298,40300,40321,40327,40328,40330,40332,40334,40392,40393,40395,40397,40399,40564,40566,
   40568,40570,40591,40593,40595,40640,40642,40685,40915,40918,40919,40920,40922,40928,40929,40931,
   40933,40935,40957,40958,40959,40961,40967,40968,40970,40972,40974,41069,41070,41072,41078,41079,
   41081,41083,41085,41105,41107,41113,41114,41116,41118,41120,41141,41147,41148,41150,41152,41212,
   41213,41215,41217,41219,41384,41386,41388,41390,41411,41413,41415,41460,41462,41505,41737,41738,
   41739,41741,41747,41748,41750,41752,41754,41849,41850,41852,41858,41859,41861,41863,41865,41885,
   41887,41893,41894,41896,41898,41900,41921,41927,41928,41930,41932,41934,41992,41993,41997,41999,
   42164,42166,42168,42170,42191,42193,42195,42240,42242,42285,42590,42591,42593,42599,42600,42602,
   42604,42606,42626,42628,42634,42635,42637,42641,42662,42668,42669,42673,42675,42733,42734,42736,
   42738,42740,42905,42907,42909,42911,42932,42934,42936,42981,42983,43026,44625,44627,44633,44634,
   44636,44638,44640,44661,44667,44668,44670,44672,44674,44732,44733,44735,44737,44739,44904,44906,
   44908,44910,44931,44933,44935,44980,44982,45025,45256,45262,45263,45265,45267,45269,45327,45328,
   45330,45332,45334,45499,45501,45503,45505,45526,45528,45530,45575,45577,45620,45888,45889,45891,
   45893,45895,46060,46062,46064,46066,46087,46089,46091,46136,46138,46181,47084,47086,47088,47090,
   47111,47113,47115,47160,47162,47205,49471,49473,49475,49520,49522,49565,49820,49822,49865,50394]
  ,[2033,8469],[1377,1658,1761,7813,7818,7821,7828,7832,7899,7902,7909,7913,8087,8094,8098,
   8193,8197,8393,40099,40102,40109,40113,40287,40294,40298,40393,40397,40593,41887,41894,41898,
   41993,41997,42193,45328,45332,45528,47113],[2071,8507],[1424,1439,1698,7860,7875,8134,41154]
  ,[8168],[2071,8507],[8032],[1560,7996],[2033,8469],[1887,8323],[1915,8351],
 [2215,8651],[2224,8660],[2224,8660],[2215,8651],[2254,8690],[2262,8698],[2268,8704],
 [2270,8706],[2254,8690],[2270,8706],[2262,8698],[2268,8704],
 [202,268,328,8715,8962,10854,12747],[202,268,328,8715,8962,10854,12747],[202,393,8845,14579],
 [],[202,268,328,8715,8962,10854,12747],[202,569,9021,16465],
 [202,268,328,8715,8962,10854,12747],[202,569,9021,16465],[202,393,8845,14579],[202],
 [202],[202],[202],[202],[202],[202],[202],[202],[202],[202],
 [202,1336,9788,17232],[202,1377,9829,17273],[202],[202,1377,9829,17273],
 [202,1336,9788,17232],[202],[202],[202,1625,10077,17521],[202,1658,10110,17554],
 [202,1698,10150,17594],[202],[202,1761,10213,17657],[202],[202],[202],
 [202,1887,10339,17783],[202,1915,10367,17811],[202],[202,1658,10110,17554],[202],
 [202,1625,10077,17521],[202,2033,10485,17929],[202,1761,10213,17657],[202],
 [202,1698,10150,17594],[202],[202],[202],[202],[202,2033,10485,17929],
 [202,1887,10339,17783],[202,1915,10367,17811],[202,2215,10667,18111],[202,2224,10676,18120],
 [202,2224,10676,18120],[202,2215,10667,18111],[202,2254,10706,18150],[202,2262,10714,18158],
 [202,2268,10720,18164],[202,2270,10722,18166],[202,2254,10706,18150],[202,2270,10722,18166],
 [202,2262,10714,18158],[202,2268,10720,18164],[202,268,328,8715,8962,10854,12747],
 [268,393,10796,10798,11032,14753],[202,268,328,8715,8962,10854,12747],
 [202,268,328,8715,8962,10854,12747],[268,569,10973,10974,11031,19886],[],
 [268,569,10973,10974,11031,19886],[268,393,10796,10798,11032,14753],[268,11033],[268,11034],
 [268,11035],[268,11036],[268,11037],[268,11038],[268,11039],[268,11040],[268,11041],
 [268,11042],[268,11043],[268,1336,11044,11048,11741,22192],[268,1377,11045,11047,11782,22233]
  ,[268,11046],[268,1377,11045,11047,11782,22233],[268,1336,11044,11048,11741,22192],
 [268,11049],[268,11050],[268,1625,11051,11064,12030,22481],[268,1658,11052,11062,12063,22514]
  ,[268,1698,11053,11068,12103,22554],[268,11054],[268,1761,11055,11066,12166,22617],
 [268,11056],[268,11057],[268,11058],[268,1887,11059,11074,12292,22743],
 [268,1915,11060,11075,12320,22771],[268,11061],[268,1658,11052,11062,12063,22514],
 [268,11063],[268,1625,11051,11064,12030,22481],[268,2033,11065,11073,12438,22889],
 [268,1761,11055,11066,12166,22617],[268,11067],[268,1698,11053,11068,12103,22554],
 [268,11069],[268,11070],[268,11071],[268,11072],[268,2033,11065,11073,12438,22889],
 [268,1887,11059,11074,12292,22743],[268,1915,11060,11075,12320,22771],
 [268,2215,11076,11079,12620,23071],[268,2224,11077,11078,12629,23080],
 [268,2224,11077,11078,12629,23080],[268,2215,11076,11079,12620,23071],
 [268,2254,11080,11084,12659,23110],[268,2262,11081,11086,12667,23118],
 [268,2268,11082,11087,12673,23124],[268,2270,11083,11085,12675,23126],
 [268,2254,11080,11084,12659,23110],[268,2270,11083,11085,12675,23126],
 [268,2262,11081,11086,12667,23118],[268,2268,11082,11087,12673,23124],
 [328,393,569,12685,12686,12688,12689,12805,12807,12808,12865,12866,12979,14635,14637,14638,14695,
   14696,14809,18176,18177,18290,19943],[202,268,328,8715,8962,10854,12747],[],
 [328,393,569,12685,12686,12688,12689,12805,12807,12808,12865,12866,12979,14635,14637,14638,14695,
   14696,14809,18176,18177,18290,19943],[202,268,328,8715,8962,10854,12747],
 [328,393,569,12685,12686,12688,12689,12805,12807,12808,12865,12866,12979,14635,14637,14638,14695,
   14696,14809,18176,18177,18290,19943],[328,393,569,12685,12686,12688,12689,12805,12807,12808,
   12865,12866,12979,14635,14637,14638,14695,14696,14809,18176,18177,18290,19943],[328,12809],
 [328,12810],[328,12811],[328,12812],[328,12813],[328,12814],[328,12815],[328,12816],
 [328,12817],[328,12818],[328,12819],[328,1336,12820,12824,13632,18943],
 [328,1377,12821,12823,13673,18984],[328,12822],[328,1377,12821,12823,13673,18984],
 [328,1336,12820,12824,13632,18943],[328,12825],[328,12826],[328,1625,12827,12840,13921,19232]
  ,[328,1658,12828,12838,13954,19265],[328,1698,12829,12844,13994,19305],[328,12830],
 [328,1761,12831,12842,14057,19368],[328,12832],[328,12833],[328,12834],
 [328,1887,12835,12850,14183,19494],[328,1915,12836,12851,13967,14211,19509,19522],[328,12837],
 [328,1658,12828,12838,13954,19265],[328,12839],[328,1625,12827,12840,13921,19232],
 [328,2033,12841,12849,13699,14329,19083,19640],[328,1761,12831,12842,14057,19368],[328,12843],
 [328,1698,12829,12844,13994,19305],[328,12845],[328,12846],[328,12847],[328,12848],
 [328,2033,12841,12849,13699,14329,19083,19640],[328,1887,12835,12850,14183,19494],
 [328,1915,12836,12851,13967,14211,19509,19522],
 [328,2215,2268,12852,12855,12858,12863,14511,14514,14519,14541,14546,14564,19822,19825,19830,
   19852,19857,19875,52196,52201,52219,52328],
 [328,2224,2262,12853,12854,12857,12862,14520,14523,14528,14532,14537,14558,19831,19834,19839,
   19843,19848,19869,52232,52237,52258,52294],
 [328,2224,2262,12853,12854,12857,12862,14520,14523,14528,14532,14537,14558,19831,19834,19839,
   19843,19848,19869,52232,52237,52258,52294],
 [328,2215,2268,12852,12855,12858,12863,14511,14514,14519,14541,14546,14564,19822,19825,19830,
   19852,19857,19875,52196,52201,52219,52328],
 [328,2254,2270,12856,12859,12860,12861,14549,14550,14551,14565,14566,14569,19860,19861,19862,
   19876,19877,19880,52350,52351,52354,52385],
 [328,2224,2262,12853,12854,12857,12862,14520,14523,14528,14532,14537,14558,19831,19834,19839,
   19843,19848,19869,52232,52237,52258,52294],
 [328,2215,2268,12852,12855,12858,12863,14511,14514,14519,14541,14546,14564,19822,19825,19830,
   19852,19857,19875,52196,52201,52219,52328],
 [328,2254,2270,12856,12859,12860,12861,14549,14550,14551,14565,14566,14569,19860,19861,19862,
   19876,19877,19880,52350,52351,52354,52385],
 [328,2254,2270,12856,12859,12860,12861,14549,14550,14551,14565,14566,14569,19860,19861,19862,
   19876,19877,19880,52350,52351,52354,52385],
 [328,2254,2270,12856,12859,12860,12861,14549,14550,14551,14565,14566,14569,19860,19861,19862,
   19876,19877,19880,52350,52351,52354,52385],
 [328,2224,2262,12853,12854,12857,12862,14520,14523,14528,14532,14537,14558,19831,19834,19839,
   19843,19848,19869,52232,52237,52258,52294],
 [328,2215,2268,12852,12855,12858,12863,14511,14514,14519,14541,14546,14564,19822,19825,19830,
   19852,19857,19875,52196,52201,52219,52328],[202,393,8845,14579],
 [328,393,569,12685,12686,12688,12689,12805,12807,12808,12865,12866,12979,14635,14637,14638,14695,
   14696,14809,18176,18177,18290,19943],[328,393,569,12685,12686,12688,12689,12805,12807,12808,
   12865,12866,12979,14635,14637,14638,14695,14696,14809,18176,18177,18290,19943],
 [268,393,10796,10798,11032,14753],[328,393,569,12685,12686,12688,12689,12805,12807,12808,12865,
   12866,12979,14635,14637,14638,14695,14696,14809,18176,18177,18290,19943],[],[393,14865],
 [393,14866],[393,14867],[393,14868],[393,14869],[393,14870],[393,14871],[393,14872],
 [393,14873],[393,14874],[393,14875],[393,1336,14876,14880,15462,25217],
 [393,1377,14877,14879,15503,25258],[393,14878],[393,1377,14877,14879,15503,25258],
 [393,1336,14876,14880,15462,25217],[393,14881],[393,14882],[393,1625,14883,14896,15751,25506]
  ,[393,1658,14884,14894,15784,25539],[393,1698,14885,14900,15824,25579],[393,14886],
 [393,1761,14887,14898,15788,15887,25638,25642],[393,14888],[393,14889],[393,14890],
 [393,1887,14891,14906,16013,25768],[393,1915,14892,14907,16041,25796],[393,14893],
 [393,1658,14884,14894,15784,25539],[393,14895],[393,1625,14883,14896,15751,25506],
 [393,2033,14897,14905,16159,25914],[393,1761,14887,14898,15788,15887,25638,25642],[393,14899],
 [393,1698,14885,14900,15824,25579],[393,14901],[393,14902],[393,14903],[393,14904],
 [393,2033,14897,14905,16159,25914],[393,1887,14891,14906,16013,25768],
 [393,1915,14892,14907,16041,25796],[393,2215,14908,14911,16341,26096],
 [393,2224,14909,14910,16350,26105],[393,2224,14909,14910,16350,26105],
 [393,2215,14908,14911,16341,26096],[393,2254,14912,14916,16380,26135],
 [393,2262,14913,14918,16388,26143],[393,2268,14914,14919,16394,26149],
 [393,2270,14915,14917,16396,26151],[393,2254,14912,14916,16380,26135],
 [393,2270,14915,14917,16396,26151],[393,2262,14913,14918,16388,26143],
 [393,2268,14914,14919,16394,26149],[202,268,328,8715,8962,10854,12747],[202,569,9021,16465],
 [202,268,328,8715,8962,10854,12747],[202,569,9021,16465],[202,393,8845,14579],[202],
 [202],[202],[202],[202],[202],[202],[202],[202],[202],[202],
 [202,1336,9788,17232],[202,1377,9829,17273],[202],[202,1377,9829,17273],
 [202,1336,9788,17232],[202],[202],[202,1625,10077,17521],[202,1658,10110,17554],
 [202,1698,10150,17594],[202],[202,1761,10213,17657],[202],[202],[202],
 [202,1887,10339,17783],[202,1915,10367,17811],[202],[202,1658,10110,17554],[202],
 [202,1625,10077,17521],[202,2033,10485,17929],[202,1761,10213,17657],[202],
 [202,1698,10150,17594],[202],[202],[202],[202],[202,2033,10485,17929],
 [202,1887,10339,17783],[202,1915,10367,17811],[202,2215,10667,18111],[202,2224,10676,18120],
 [202,2224,10676,18120],[202,2215,10667,18111],[202,2254,10706,18150],[202,2262,10714,18158],
 [202,2268,10720,18164],[202,2270,10722,18166],[202,2254,10706,18150],[202,2270,10722,18166],
 [202,2262,10714,18158],[202,2268,10720,18164],
 [328,393,569,12685,12686,12688,12689,12805,12807,12808,12865,12866,12979,14635,14637,14638,14695,
   14696,14809,18176,18177,18290,19943],[202,268,328,8715,8962,10854,12747],
 [328,393,569,12685,12686,12688,12689,12805,12807,12808,12865,12866,12979,14635,14637,14638,14695,
   14696,14809,18176,18177,18290,19943],[328,393,569,12685,12686,12688,12689,12805,12807,12808,
   12865,12866,12979,14635,14637,14638,14695,14696,14809,18176,18177,18290,19943],[328,12809],
 [328,12810],[328,12811],[328,12812],[328,12813],[328,12814],[328,12815],[328,12816],
 [328,12817],[328,12818],[328,12819],[328,1336,12820,12824,13632,18943],
 [328,1377,12821,12823,13673,18984],[328,12822],[328,1377,12821,12823,13673,18984],
 [328,1336,12820,12824,13632,18943],[328,12825],[328,12826],[328,1625,12827,12840,13921,19232]
  ,[328,1658,12828,12838,13954,19265],[328,1698,12829,12844,13994,19305],[328,12830],
 [328,1761,12831,12842,14057,19368],[328,12832],[328,12833],[328,12834],
 [328,1887,12835,12850,14183,19494],[328,1915,12836,12851,13967,14211,19509,19522],[328,12837],
 [328,1658,12828,12838,13954,19265],[328,12839],[328,1625,12827,12840,13921,19232],
 [328,2033,12841,12849,13699,14329,19083,19640],[328,1761,12831,12842,14057,19368],[328,12843],
 [328,1698,12829,12844,13994,19305],[328,12845],[328,12846],[328,12847],[328,12848],
 [328,2033,12841,12849,13699,14329,19083,19640],[328,1887,12835,12850,14183,19494],
 [328,1915,12836,12851,13967,14211,19509,19522],
 [328,2215,2268,12852,12855,12858,12863,14511,14514,14519,14541,14546,14564,19822,19825,19830,
   19852,19857,19875,52196,52201,52219,52328],
 [328,2224,2262,12853,12854,12857,12862,14520,14523,14528,14532,14537,14558,19831,19834,19839,
   19843,19848,19869,52232,52237,52258,52294],
 [328,2224,2262,12853,12854,12857,12862,14520,14523,14528,14532,14537,14558,19831,19834,19839,
   19843,19848,19869,52232,52237,52258,52294],
 [328,2215,2268,12852,12855,12858,12863,14511,14514,14519,14541,14546,14564,19822,19825,19830,
   19852,19857,19875,52196,52201,52219,52328],
 [328,2254,2270,12856,12859,12860,12861,14549,14550,14551,14565,14566,14569,19860,19861,19862,
   19876,19877,19880,52350,52351,52354,52385],
 [328,2224,2262,12853,12854,12857,12862,14520,14523,14528,14532,14537,14558,19831,19834,19839,
   19843,19848,19869,52232,52237,52258,52294],
 [328,2215,2268,12852,12855,12858,12863,14511,14514,14519,14541,14546,14564,19822,19825,19830,
   19852,19857,19875,52196,52201,52219,52328],
 [328,2254,2270,12856,12859,12860,12861,14549,14550,14551,14565,14566,14569,19860,19861,19862,
   19876,19877,19880,52350,52351,52354,52385],
 [328,2254,2270,12856,12859,12860,12861,14549,14550,14551,14565,14566,14569,19860,19861,19862,
   19876,19877,19880,52350,52351,52354,52385],
 [328,2254,2270,12856,12859,12860,12861,14549,14550,14551,14565,14566,14569,19860,19861,19862,
   19876,19877,19880,52350,52351,52354,52385],
 [328,2224,2262,12853,12854,12857,12862,14520,14523,14528,14532,14537,14558,19831,19834,19839,
   19843,19848,19869,52232,52237,52258,52294],
 [328,2215,2268,12852,12855,12858,12863,14511,14514,14519,14541,14546,14564,19822,19825,19830,
   19852,19857,19875,52196,52201,52219,52328],[268,569,10973,10974,11031,19886],[],
 [328,393,569,12685,12686,12688,12689,12805,12807,12808,12865,12866,12979,14635,14637,14638,14695,
   14696,14809,18176,18177,18290,19943],[569,19944],[569,19945],[569,19946],[569,19947],
 [569,19948],[569,19949],[569,19950],[569,19951],[569,19952],[569,19953],[569,19954],
 [569,1336,19955,19959,20596,23732],[569,1377,19956,19958,20637,23773],[569,19957],
 [569,1377,19956,19958,20637,23773],[569,1336,19955,19959,20596,23732],[569,19960],
 [569,19961],[569,1625,19962,19975,20885,24021],[569,1658,19963,19973,20918,24054],
 [569,1698,19964,19979,20958,24094],[569,19965],[569,1761,19966,19977,20656,21021,23862,24157],
 [569,19967],[569,19968],[569,19969],[569,1887,19970,19985,21147,24283],
 [569,1915,19971,19986,21175,24311],[569,19972],[569,1658,19963,19973,20918,24054],
 [569,19974],[569,1625,19962,19975,20885,24021],[569,2033,19976,19984,21293,24429],
 [569,1761,19966,19977,20656,21021,23862,24157],[569,19978],[569,1698,19964,19979,20958,24094],
 [569,19980],[569,19981],[569,19982],[569,19983],[569,2033,19976,19984,21293,24429],
 [569,1887,19970,19985,21147,24283],[569,1915,19971,19986,21175,24311],
 [569,2215,19987,19990,21475,24611],[569,2224,19988,19989,21484,24620],
 [569,2224,19988,19989,21484,24620],[569,2215,19987,19990,21475,24611],
 [569,2254,19991,19995,21514,24650],[569,2262,19992,19997,21522,24658],
 [569,2268,19993,19998,21528,24664],[569,2270,19994,19996,21530,24666],
 [569,2254,19991,19995,21514,24650],[569,2270,19994,19996,21530,24666],
 [569,2262,19992,19997,21522,24658],[569,2268,19993,19998,21528,24664],
 [268,569,10973,10974,11031,19886],[268,393,10796,10798,11032,14753],[268,11033],[268,11034],
 [268,11035],[268,11036],[268,11037],[268,11038],[268,11039],[268,11040],[268,11041],
 [268,11042],[268,11043],[268,1336,11044,11048,11741,22192],[268,1377,11045,11047,11782,22233]
  ,[268,11046],[268,1377,11045,11047,11782,22233],[268,1336,11044,11048,11741,22192],
 [268,11049],[268,11050],[268,1625,11051,11064,12030,22481],[268,1658,11052,11062,12063,22514]
  ,[268,1698,11053,11068,12103,22554],[268,11054],[268,1761,11055,11066,12166,22617],
 [268,11056],[268,11057],[268,11058],[268,1887,11059,11074,12292,22743],
 [268,1915,11060,11075,12320,22771],[268,11061],[268,1658,11052,11062,12063,22514],
 [268,11063],[268,1625,11051,11064,12030,22481],[268,2033,11065,11073,12438,22889],
 [268,1761,11055,11066,12166,22617],[268,11067],[268,1698,11053,11068,12103,22554],
 [268,11069],[268,11070],[268,11071],[268,11072],[268,2033,11065,11073,12438,22889],
 [268,1887,11059,11074,12292,22743],[268,1915,11060,11075,12320,22771],
 [268,2215,11076,11079,12620,23071],[268,2224,11077,11078,12629,23080],
 [268,2224,11077,11078,12629,23080],[268,2215,11076,11079,12620,23071],
 [268,2254,11080,11084,12659,23110],[268,2262,11081,11086,12667,23118],
 [268,2268,11082,11087,12673,23124],[268,2270,11083,11085,12675,23126],
 [268,2254,11080,11084,12659,23110],[268,2270,11083,11085,12675,23126],
 [268,2262,11081,11086,12667,23118],[268,2268,11082,11087,12673,23124],
 [328,393,569,12685,12686,12688,12689,12805,12807,12808,12865,12866,12979,14635,14637,14638,14695,
   14696,14809,18176,18177,18290,19943],[569,19944],[569,19945],[569,19946],[569,19947],
 [569,19948],[569,19949],[569,19950],[569,19951],[569,19952],[569,19953],[569,19954],
 [569,1336,19955,19959,20596,23732],[569,1377,19956,19958,20637,23773],[569,19957],
 [569,1377,19956,19958,20637,23773],[569,1336,19955,19959,20596,23732],[569,19960],
 [569,19961],[569,1625,19962,19975,20885,24021],[569,1658,19963,19973,20918,24054],
 [569,1698,19964,19979,20958,24094],[569,19965],[569,1761,19966,19977,20656,21021,23862,24157],
 [569,19967],[569,19968],[569,19969],[569,1887,19970,19985,21147,24283],
 [569,1915,19971,19986,21175,24311],[569,19972],[569,1658,19963,19973,20918,24054],
 [569,19974],[569,1625,19962,19975,20885,24021],[569,2033,19976,19984,21293,24429],
 [569,1761,19966,19977,20656,21021,23862,24157],[569,19978],[569,1698,19964,19979,20958,24094],
 [569,19980],[569,19981],[569,19982],[569,19983],[569,2033,19976,19984,21293,24429],
 [569,1887,19970,19985,21147,24283],[569,1915,19971,19986,21175,24311],
 [569,2215,19987,19990,21475,24611],[569,2224,19988,19989,21484,24620],
 [569,2224,19988,19989,21484,24620],[569,2215,19987,19990,21475,24611],
 [569,2254,19991,19995,21514,24650],[569,2262,19992,19997,21522,24658],
 [569,2268,19993,19998,21528,24664],[569,2270,19994,19996,21530,24666],
 [569,2254,19991,19995,21514,24650],[569,2270,19994,19996,21530,24666],
 [569,2262,19992,19997,21522,24658],[569,2268,19993,19998,21528,24664],[393,14865],
 [393,14866],[393,14867],[393,14868],[393,14869],[393,14870],[393,14871],[393,14872],
 [393,14873],[393,14874],[393,14875],[393,1336,14876,14880,15462,25217],
 [393,1377,14877,14879,15503,25258],[393,14878],[393,1377,14877,14879,15503,25258],
 [393,1336,14876,14880,15462,25217],[393,14881],[393,14882],[393,1625,14883,14896,15751,25506]
  ,[393,1658,14884,14894,15784,25539],[393,1698,14885,14900,15824,25579],[393,14886],
 [393,1761,14887,14898,15788,15887,25638,25642],[393,14888],[393,14889],[393,14890],
 [393,1887,14891,14906,16013,25768],[393,1915,14892,14907,16041,25796],[393,14893],
 [393,1658,14884,14894,15784,25539],[393,14895],[393,1625,14883,14896,15751,25506],
 [393,2033,14897,14905,16159,25914],[393,1761,14887,14898,15788,15887,25638,25642],[393,14899],
 [393,1698,14885,14900,15824,25579],[393,14901],[393,14902],[393,14903],[393,14904],
 [393,2033,14897,14905,16159,25914],[393,1887,14891,14906,16013,25768],
 [393,1915,14892,14907,16041,25796],[393,2215,14908,14911,16341,26096],
 [393,2224,14909,14910,16350,26105],[393,2224,14909,14910,16350,26105],
 [393,2215,14908,14911,16341,26096],[393,2254,14912,14916,16380,26135],
 [393,2262,14913,14918,16388,26143],[393,2268,14914,14919,16394,26149],
 [393,2270,14915,14917,16396,26151],[393,2254,14912,14916,16380,26135],
 [393,2270,14915,14917,16396,26151],[393,2262,14913,14918,16388,26143],
 [393,2268,14914,14919,16394,26149],[26160],[26160],[],[26316],[26316],[],[],[26510],
 [26510],[],[1336,26648],[1377,26689],[],[1377,26689],[1336,26648],[],[],
 [1625,26937],[1658,26970],[1698,27010],[],[1761,27073],[],[],[],[1887,27199],
 [1915,27227],[],[1658,26970],[],[1625,26937],[2033,27345],[1761,27073],[],
 [1698,27010],[],[],[],[],[2033,27345],[1887,27199],[1915,27227],[2215,27527],
 [2224,27536],[2224,27536],[2215,27527],[2254,27566],[2262,27574],[2268,27580],
 [2270,27582],[2254,27566],[2270,27582],[2262,27574],[2268,27580],[26160],[27643],
 [27643],[],[],[27841],[27841],[],[],[1336,28026],[1377,28067],[],[1377,28067],
 [1336,28026],[],[],[1625,28315],[1658,28348],[1698,28388],[],[1761,28451],[],[],
 [],[1887,28577],[1915,28605],[],[1658,28348],[],[1625,28315],[2033,28723],
 [1761,28451],[],[1698,28388],[],[],[],[],[2033,28723],[1887,28577],[1915,28605],
 [2215,28905],[2224,28914],[2224,28914],[2215,28905],[2254,28944],[2262,28952],
 [2268,28958],[2270,28960],[2254,28944],[2270,28960],[2262,28952],[2268,28958],[28970],
 [],[28970],[],[29168],[],[29168],[],[1336,29352],[1377,29393],[],[1377,29393],
 [1336,29352],[],[],[1625,29641],[1658,29674],[1698,29714],[],[1761,29777],[],[],
 [],[1887,29903],[1915,29931],[],[1658,29674],[],[1625,29641],[2033,30049],
 [1761,29777],[],[1698,29714],[],[],[],[],[2033,30049],[1887,29903],[1915,29931],
 [2215,30231],[2224,30240],[2224,30240],[2215,30231],[2254,30270],[2262,30278],
 [2268,30284],[2270,30286],[2254,30270],[2270,30286],[2262,30278],[2268,30284],[27643],
 [28970],[30394],[30394],[],[],[],[1336,30627],[1377,30668],[],[1377,30668],
 [1336,30627],[],[],[1625,30916],[1658,30949],[1698,30989],[],[1761,31052],[],[],
 [],[1887,31178],[1915,31206],[],[1658,30949],[],[1625,30916],[2033,31324],
 [1761,31052],[],[1698,30989],[],[],[],[],[2033,31324],[1887,31178],[1915,31206],
 [2215,31506],[2224,31515],[2224,31515],[2215,31506],[2254,31545],[2262,31553],
 [2268,31559],[2270,31561],[2254,31545],[2270,31561],[2262,31553],[2268,31559],[26316],
 [31620],[],[31620],[],[],[1336,31852],[1377,31893],[],[1377,31893],[1336,31852],
 [],[],[1625,32141],[1658,32174],[1698,32214],[],[1761,32277],[],[],[],
 [1887,32403],[1915,32431],[],[1658,32174],[],[1625,32141],[2033,32549],[1761,32277],
 [],[1698,32214],[],[],[],[],[2033,32549],[1887,32403],[1915,32431],[2215,32731],
 [2224,32740],[2224,32740],[2215,32731],[2254,32770],[2262,32778],[2268,32784],
 [2270,32786],[2254,32770],[2270,32786],[2262,32778],[2268,32784],[32797],[],[],
 [32797],[],[1336,33028],[1377,33069],[],[1377,33069],[1336,33028],[],[],
 [1625,33317],[1658,33350],[1698,33390],[],[1761,33453],[],[],[],[1887,33579],
 [1915,33607],[],[1658,33350],[],[1625,33317],[2033,33725],[1761,33453],[],
 [1698,33390],[],[],[],[],[2033,33725],[1887,33579],[1915,33607],[2215,33907],
 [2224,33916],[2224,33916],[2215,33907],[2254,33946],[2262,33954],[2268,33960],
 [2270,33962],[2254,33946],[2270,33962],[2262,33954],[2268,33960],[30394],[31620],
 [32797],[],[1336,34156],[1377,34197],[],[1377,34197],[1336,34156],[],[],
 [1625,34445],[1658,34478],[1698,34518],[],[1761,34581],[],[],[],[1887,34707],
 [1915,34735],[],[1658,34478],[],[1625,34445],[2033,34853],[1761,34581],[],
 [1698,34518],[],[],[],[],[2033,34853],[1887,34707],[1915,34735],[2215,35035],
 [2224,35044],[2224,35044],[2215,35035],[2254,35074],[2262,35082],[2268,35088],
 [2270,35090],[2254,35074],[2270,35090],[2262,35082],[2268,35088],[27841],[29168],[],
 [1336,35237],[1377,35278],[],[1377,35278],[1336,35237],[],[],[1625,35526],
 [1658,35559],[1698,35599],[],[1761,35662],[],[],[],[1887,35788],[1915,35816],[],
 [1658,35559],[],[1625,35526],[2033,35934],[1761,35662],[],[1698,35599],[],[],[],
 [],[2033,35934],[1887,35788],[1915,35816],[2215,36116],[2224,36125],[2224,36125],
 [2215,36116],[2254,36155],[2262,36163],[2268,36169],[2270,36171],[2254,36155],
 [2270,36171],[2262,36163],[2268,36169],[26510],[],[1336,36272],[1377,36313],[],
 [1377,36313],[1336,36272],[],[],[1625,36561],[1658,36594],[1698,36634],[],
 [1761,36697],[],[],[],[1887,36823],[1915,36851],[],[1658,36594],[],[1625,36561],
 [2033,36969],[1761,36697],[],[1698,36634],[],[],[],[],[2033,36969],[1887,36823],
 [1915,36851],[2215,37151],[2224,37160],[2224,37160],[2215,37151],[2254,37190],
 [2262,37198],[2268,37204],[2270,37206],[2254,37190],[2270,37206],[2262,37198],
 [2268,37204],[],[1336,37262],[1377,37303],[],[1377,37303],[1336,37262],[],[],
 [1625,37551],[1658,37584],[1698,37624],[],[1761,37687],[],[],[],[1887,37813],
 [1915,37841],[],[1658,37584],[],[1625,37551],[2033,37959],[1761,37687],[],
 [1698,37624],[],[],[],[],[2033,37959],[1887,37813],[1915,37841],[2215,38141],
 [2224,38150],[2224,38150],[2215,38141],[2254,38180],[2262,38188],[2268,38194],
 [2270,38196],[2254,38180],[2270,38196],[2262,38188],[2268,38194],
 [90,94,107,1291,1306,1336,1349,1377,1432,1511,5645,5646,5662,5689,5690,5691,5692,5705,5747,
   5774,5788,5828,5867,38205,38206,38207,38208,38221,38248,38249,38250,38263,38290,38291,38304,
   38331,39151,39152,39153,39166,39193,39194,39207,39234,39247,39286,40054,40055,40095,40915,40928]
  ,[90,94,107,1291,1306,1336,1349,1377,1432,1511,5645,5646,5662,5689,5690,5691,5692,5705,5747,
   5774,5788,5828,5867,38205,38206,38207,38208,38221,38248,38249,38250,38263,38290,38291,38304,
   38331,39151,39152,39153,39166,39193,39194,39207,39234,39247,39286,40054,40055,40095,40915,40928]
  ,[],[90,94,107,1291,1306,1336,1349,1377,1432,1511,5645,5646,5662,5689,5690,5691,5692,5705,
   5747,5774,5788,5828,5867,38205,38206,38207,38208,38221,38248,38249,38250,38263,38290,38291,
   38304,38331,39151,39152,39153,39166,39193,39194,39207,39234,39247,39286,40054,40055,40095,40915,
   40928],[90,94,107,1291,1306,1336,1349,1377,1432,1511,5645,5646,5662,5689,5690,5691,5692,
   5705,5747,5774,5788,5828,5867,38205,38206,38207,38208,38221,38248,38249,38250,38263,38290,
   38291,38304,38331,39151,39152,39153,39166,39193,39194,39207,39234,39247,39286,40054,40055,40095,
   40915,40928],[],[],[1625,3507,3520,3836,38497],[1658,38530],
 [1291,1306,1432,1698,1761,38304,38557,38563,38568,38570,38628,38633,38635,38804,38806,38921,45888,
   45893,45895,46064,46066,46181,47088,47090,47205,49565],[],
 [1291,1306,1432,1698,1761,38304,38557,38563,38568,38570,38628,38633,38635,38804,38806,38921,45888,
   45893,45895,46064,46066,46181,47088,47090,47205,49565],[],[],[],[1887,38759],
 [1915,38787],[],[1658,38530],[],[1625,3507,3520,3836,38497],[2033,38905],
 [1291,1306,1432,1698,1761,38304,38557,38563,38568,38570,38628,38633,38635,38804,38806,38921,45888,
   45893,45895,46064,46066,46181,47088,47090,47205,49565],[],
 [1291,1306,1432,1698,1761,38304,38557,38563,38568,38570,38628,38633,38635,38804,38806,38921,45888,
   45893,45895,46064,46066,46181,47088,47090,47205,49565],[],[],[39015],[39015],
 [2033,38905],[1887,38759],[1915,38787],[2215,39087],[2224,39096],[2224,39096],
 [2215,39087],[2254,39126],[2262,39134],[2268,39140],[2270,39142],[2254,39126],
 [2270,39142],[2262,39134],[2268,39140],
 [90,94,107,1291,1306,1336,1349,1377,1432,1511,5645,5646,5662,5689,5690,5691,5692,5705,5747,
   5774,5788,5828,5867,38205,38206,38207,38208,38221,38248,38249,38250,38263,38290,38291,38304,
   38331,39151,39152,39153,39166,39193,39194,39207,39234,39247,39286,40054,40055,40095,40915,40928]
  ,[90,94,107,1291,1306,1336,1349,1377,1432,1511,5645,5646,5662,5689,5690,5691,5692,5705,5747,
   5774,5788,5828,5867,38205,38206,38207,38208,38221,38248,38249,38250,38263,38290,38291,38304,
   38331,39151,39152,39153,39166,39193,39194,39207,39234,39247,39286,40054,40055,40095,40915,40928]
  ,[90,94,107,1291,1306,1336,1349,1377,1432,1511,5645,5646,5662,5689,5690,5691,5692,5705,5747,
   5774,5788,5828,5867,38205,38206,38207,38208,38221,38248,38249,38250,38263,38290,38291,38304,
   38331,39151,39152,39153,39166,39193,39194,39207,39234,39247,39286,40054,40055,40095,40915,40928]
  ,[],[1336,39274,39275,39313,42515],[1336,39274,39275,39313,42515],
 [1336,1625,1761,39276,39280,39289,39291,39391,39400,39402,39534,39536,39779,42593,42602,42604,
   42736,42738,42981,44735,44737,44980,47160],
 [1336,1658,1698,39277,39278,39287,39293,39424,39433,39439,39467,39473,39734,42626,42635,42641,
   42669,42675,42936,45263,45269,45530,46091],
 [1336,1658,1698,39277,39278,39287,39293,39424,39433,39439,39467,39473,39734,42626,42635,42641,
   42669,42675,42936,45263,45269,45530,46091],[1336,39279],
 [1336,1625,1761,39276,39280,39289,39291,39391,39400,39402,39534,39536,39779,42593,42602,42604,
   42736,42738,42981,44735,44737,44980,47160],[1336,39281,39283,39559,42761],[1336,39282],
 [1336,39281,39283,39559,42761],[1336,1887,39284,39299,39662,42864],
 [1336,1915,39285,39300,39690,42892],[1336,5692,5705,5867,39286],
 [1336,1658,1698,39277,39278,39287,39293,39424,39433,39439,39467,39473,39734,42626,42635,42641,
   42669,42675,42936,45263,45269,45530,46091],[1336,39288],
 [1336,1625,1761,39276,39280,39289,39291,39391,39400,39402,39534,39536,39779,42593,42602,42604,
   42736,42738,42981,44735,44737,44980,47160],[1336,2033,39290,39298,39808,43010],
 [1336,1625,1761,39276,39280,39289,39291,39391,39400,39402,39534,39536,39779,42593,42602,42604,
   42736,42738,42981,44735,44737,44980,47160],[1336,39292],
 [1336,1658,1698,39277,39278,39287,39293,39424,39433,39439,39467,39473,39734,42626,42635,42641,
   42669,42675,42936,45263,45269,45530,46091],[1336,39294],[1336,39295,39297,39902,43104],
 [1336,39296],[1336,39295,39297,39902,43104],[1336,2033,39290,39298,39808,43010],
 [1336,1887,39284,39299,39662,42864],[1336,1915,39285,39300,39690,42892],
 [1336,2215,39301,39304,39990,43192],[1336,2224,39302,39303,39999,43201],
 [1336,2224,39302,39303,39999,43201],[1336,2215,39301,39304,39990,43192],
 [1336,2254,39305,39309,40029,43231],[1336,2262,39306,39311,40037,43239],
 [1336,2268,39307,39312,40043,43245],[1336,2270,39308,39310,40045,43247],
 [1336,2254,39305,39309,40029,43231],[1336,2270,39308,39310,40045,43247],
 [1336,2262,39306,39311,40037,43239],[1336,2268,39307,39312,40043,43245],
 [90,94,107,1291,1306,1336,1349,1377,1432,1511,5645,5646,5662,5689,5690,5691,5692,5705,5747,
   5774,5788,5828,5867,38205,38206,38207,38208,38221,38248,38249,38250,38263,38290,38291,38304,
   38331,39151,39152,39153,39166,39193,39194,39207,39234,39247,39286,40054,40055,40095,40915,40928]
  ,[],[90,94,107,1291,1306,1336,1349,1377,1432,1511,5645,5646,5662,5689,5690,5691,5692,5705,
   5747,5774,5788,5828,5867,38205,38206,38207,38208,38221,38248,38249,38250,38263,38290,38291,
   38304,38331,39151,39152,39153,39166,39193,39194,39207,39234,39247,39286,40054,40055,40095,40915,
   40928],[1377,40096],[1377,40097],[1377,1625,1698,40098,40100,40111,40115,40250,40261,40265,
   40330,40334,40642,41850,41861,41865,41930,41934,42242,44670,44674,44982,46138],
 [1377,1658,1761,7813,7818,7821,7828,7832,7899,7902,7909,7913,8087,8094,8098,8193,8197,8393,
   40099,40102,40109,40113,40287,40294,40298,40393,40397,40593,41887,41894,41898,41993,41997,42193,
   45328,45332,45528,47113],[1377,1625,1698,40098,40100,40111,40115,40250,40261,40265,40330,
   40334,40642,41850,41861,41865,41930,41934,42242,44670,44674,44982,46138],[1377,40101],
 [1377,1658,1761,7813,7818,7821,7828,7832,7899,7902,7909,7913,8087,8094,8098,8193,8197,8393,
   40099,40102,40109,40113,40287,40294,40298,40393,40397,40593,41887,41894,41898,41993,41997,42193,
   45328,45332,45528,47113],[1377,1798,40103,40119,40434,42034],
 [1377,1827,1855,40104,40105,40117,40118,40450,40462,40463,40491,40492,40762,42050,42062,42063,
   42091,42092,42362,47911,47912,48182,48588],
 [1377,1827,1855,40104,40105,40117,40118,40450,40462,40463,40491,40492,40762,42050,42062,42063,
   42091,42092,42362,47911,47912,48182,48588],
 [1377,1887,1915,40106,40107,40121,40122,40509,40523,40524,40550,40551,40824,42109,42123,42124,
   42150,42151,42424,48754,48755,49028,49379],
 [1377,1887,1915,40106,40107,40121,40122,40509,40523,40524,40550,40551,40824,42109,42123,42124,
   42150,42151,42424,48754,48755,49028,49379],[1377,40108],
 [1377,1658,1761,7813,7818,7821,7828,7832,7899,7902,7909,7913,8087,8094,8098,8193,8197,8393,
   40099,40102,40109,40113,40287,40294,40298,40393,40397,40593,41887,41894,41898,41993,41997,42193,
   45328,45332,45528,47113],[1377,1984,40110,40116,40620,42220],
 [1377,1625,1698,40098,40100,40111,40115,40250,40261,40265,40330,40334,40642,41850,41861,41865,
   41930,41934,42242,44670,44674,44982,46138],[1377,2033,40112,40120,40669,42269],
 [1377,1658,1761,7813,7818,7821,7828,7832,7899,7902,7909,7913,8087,8094,8098,8193,8197,8393,
   40099,40102,40109,40113,40287,40294,40298,40393,40397,40593,41887,41894,41898,41993,41997,42193,
   45328,45332,45528,47113],[1377,40114],
 [1377,1625,1698,40098,40100,40111,40115,40250,40261,40265,40330,40334,40642,41850,41861,41865,
   41930,41934,42242,44670,44674,44982,46138],[1377,1984,40110,40116,40620,42220],
 [1377,1827,1855,40104,40105,40117,40118,40450,40462,40463,40491,40492,40762,42050,42062,42063,
   42091,42092,42362,47911,47912,48182,48588],
 [1377,1827,1855,40104,40105,40117,40118,40450,40462,40463,40491,40492,40762,42050,42062,42063,
   42091,42092,42362,47911,47912,48182,48588],[1377,1798,40103,40119,40434,42034],
 [1377,2033,40112,40120,40669,42269],[1377,1887,1915,40106,40107,40121,40122,40509,40523,40524,
   40550,40551,40824,42109,42123,42124,42150,42151,42424,48754,48755,49028,49379],
 [1377,1887,1915,40106,40107,40121,40122,40509,40523,40524,40550,40551,40824,42109,42123,42124,
   42150,42151,42424,48754,48755,49028,49379],
 [1377,2215,2224,40123,40124,40125,40126,40849,40850,40851,40860,40861,40870,42449,42450,42451,
   42460,42461,42470,52175,52176,52185,52230],
 [1377,2215,2224,40123,40124,40125,40126,40849,40850,40851,40860,40861,40870,42449,42450,42451,
   42460,42461,42470,52175,52176,52185,52230],
 [1377,2215,2224,40123,40124,40125,40126,40849,40850,40851,40860,40861,40870,42449,42450,42451,
   42460,42461,42470,52175,52176,52185,52230],
 [1377,2215,2224,40123,40124,40125,40126,40849,40850,40851,40860,40861,40870,42449,42450,42451,
   42460,42461,42470,52175,52176,52185,52230],[1377,2254,40127,40131,40890,42490],
 [1377,2262,2268,40128,40129,40133,40134,40894,40898,40899,40903,40904,40914,42494,42498,42499,
   42503,42504,42514,52363,52364,52374,52384],
 [1377,2262,2268,40128,40129,40133,40134,40894,40898,40899,40903,40904,40914,42494,42498,42499,
   42503,42504,42514,52363,52364,52374,52384],[1377,2270,40130,40132,40906,42506],
 [1377,2254,40127,40131,40890,42490],[1377,2270,40130,40132,40906,42506],
 [1377,2262,2268,40128,40129,40133,40134,40894,40898,40899,40903,40904,40914,42494,42498,42499,
   42503,42504,42514,52363,52364,52374,52384],
 [1377,2262,2268,40128,40129,40133,40134,40894,40898,40899,40903,40904,40914,42494,42498,42499,
   42503,42504,42514,52363,52364,52374,52384],
 [90,94,107,1291,1306,1336,1349,1377,1432,1511,5645,5646,5662,5689,5690,5691,5692,5705,5747,
   5774,5788,5828,5867,38205,38206,38207,38208,38221,38248,38249,38250,38263,38290,38291,38304,
   38331,39151,39152,39153,39166,39193,39194,39207,39234,39247,39286,40054,40055,40095,40915,40928]
  ,[90,94,107,1291,1306,1336,1349,1377,1432,1511,5645,5646,5662,5689,5690,5691,5692,5705,5747,
   5774,5788,5828,5867,38205,38206,38207,38208,38221,38248,38249,38250,38263,38290,38291,38304,
   38331,39151,39152,39153,39166,39193,39194,39207,39234,39247,39286,40054,40055,40095,40915,40928]
  ,[],[],[23,31,44,1291,1296,1306,1309,1432,1625,1658,3502,3507,3508,3517,3518,3520,3633,
   3634,3824,3833,3834,3836,4139,38294,38295,38304,38485,38494,38495,38497,38800,41069,41078,
   41079,41081,41113,41114,41116,41384,41386,41411,44633,44634,44636,44904,44906,44931,45499,45501,
   45526,49471],[23,31,44,1291,1296,1306,1309,1432,1625,1658,3502,3507,3508,3517,3518,3520,
   3633,3634,3824,3833,3834,3836,4139,38294,38295,38304,38485,38494,38495,38497,38800,41069,41078,
   41079,41081,41113,41114,41116,41384,41386,41411,44633,44634,44636,44904,44906,44931,45499,45501,
   45526,49471],[1698,41154],[],[1761,41217],[41239],[41239],[],[1887,41343],
 [1915,41371],[],[23,31,44,1291,1296,1306,1309,1432,1625,1658,3502,3507,3508,3517,3518,3520,
   3633,3634,3824,3833,3834,3836,4139,38294,38295,38304,38485,38494,38495,38497,38800,41069,41078,
   41079,41081,41113,41114,41116,41384,41386,41411,44633,44634,44636,44904,44906,44931,45499,45501,
   45526,49471],[],[23,31,44,1291,1296,1306,1309,1432,1625,1658,3502,3507,3508,3517,3518,
   3520,3633,3634,3824,3833,3834,3836,4139,38294,38295,38304,38485,38494,38495,38497,38800,41069,
   41078,41079,41081,41113,41114,41116,41384,41386,41411,44633,44634,44636,44904,44906,44931,45499,
   45501,45526,49471],[2033,41489],[1761,41217],[],[1698,41154],[],[],[],[],
 [2033,41489],[1887,41343],[1915,41371],[2215,41671],[2224,41680],[2224,41680],
 [2215,41671],[2254,41710],[2262,41718],[2268,41724],[2270,41726],[2254,41710],
 [2270,41726],[2262,41718],[2268,41724],
 [90,94,107,1291,1306,1336,1349,1377,1432,1511,5645,5646,5662,5689,5690,5691,5692,5705,5747,
   5774,5788,5828,5867,38205,38206,38207,38208,38221,38248,38249,38250,38263,38290,38291,38304,
   38331,39151,39152,39153,39166,39193,39194,39207,39234,39247,39286,40054,40055,40095,40915,40928]
  ,[1377,40096],[1377,40097],[1377,1625,1698,40098,40100,40111,40115,40250,40261,40265,40330,
   40334,40642,41850,41861,41865,41930,41934,42242,44670,44674,44982,46138],
 [1377,1658,1761,7813,7818,7821,7828,7832,7899,7902,7909,7913,8087,8094,8098,8193,8197,8393,
   40099,40102,40109,40113,40287,40294,40298,40393,40397,40593,41887,41894,41898,41993,41997,42193,
   45328,45332,45528,47113],[1377,1625,1698,40098,40100,40111,40115,40250,40261,40265,40330,
   40334,40642,41850,41861,41865,41930,41934,42242,44670,44674,44982,46138],[1377,40101],
 [1377,1658,1761,7813,7818,7821,7828,7832,7899,7902,7909,7913,8087,8094,8098,8193,8197,8393,
   40099,40102,40109,40113,40287,40294,40298,40393,40397,40593,41887,41894,41898,41993,41997,42193,
   45328,45332,45528,47113],[1377,1798,40103,40119,40434,42034],
 [1377,1827,1855,40104,40105,40117,40118,40450,40462,40463,40491,40492,40762,42050,42062,42063,
   42091,42092,42362,47911,47912,48182,48588],
 [1377,1827,1855,40104,40105,40117,40118,40450,40462,40463,40491,40492,40762,42050,42062,42063,
   42091,42092,42362,47911,47912,48182,48588],
 [1377,1887,1915,40106,40107,40121,40122,40509,40523,40524,40550,40551,40824,42109,42123,42124,
   42150,42151,42424,48754,48755,49028,49379],
 [1377,1887,1915,40106,40107,40121,40122,40509,40523,40524,40550,40551,40824,42109,42123,42124,
   42150,42151,42424,48754,48755,49028,49379],[1377,40108],
 [1377,1658,1761,7813,7818,7821,7828,7832,7899,7902,7909,7913,8087,8094,8098,8193,8197,8393,
   40099,40102,40109,40113,40287,40294,40298,40393,40397,40593,41887,41894,41898,41993,41997,42193,
   45328,45332,45528,47113],[1377,1984,40110,40116,40620,42220],
 [1377,1625,1698,40098,40100,40111,40115,40250,40261,40265,40330,40334,40642,41850,41861,41865,
   41930,41934,42242,44670,44674,44982,46138],[1377,2033,40112,40120,40669,42269],
 [1377,1658,1761,7813,7818,7821,7828,7832,7899,7902,7909,7913,8087,8094,8098,8193,8197,8393,
   40099,40102,40109,40113,40287,40294,40298,40393,40397,40593,41887,41894,41898,41993,41997,42193,
   45328,45332,45528,47113],[1377,40114],
 [1377,1625,1698,40098,40100,40111,40115,40250,40261,40265,40330,40334,40642,41850,41861,41865,
   41930,41934,42242,44670,44674,44982,46138],[1377,1984,40110,40116,40620,42220],
 [1377,1827,1855,40104,40105,40117,40118,40450,40462,40463,40491,40492,40762,42050,42062,42063,
   42091,42092,42362,47911,47912,48182,48588],
 [1377,1827,1855,40104,40105,40117,40118,40450,40462,40463,40491,40492,40762,42050,42062,42063,
   42091,42092,42362,47911,47912,48182,48588],[1377,1798,40103,40119,40434,42034],
 [1377,2033,40112,40120,40669,42269],[1377,1887,1915,40106,40107,40121,40122,40509,40523,40524,
   40550,40551,40824,42109,42123,42124,42150,42151,42424,48754,48755,49028,49379],
 [1377,1887,1915,40106,40107,40121,40122,40509,40523,40524,40550,40551,40824,42109,42123,42124,
   42150,42151,42424,48754,48755,49028,49379],
 [1377,2215,2224,40123,40124,40125,40126,40849,40850,40851,40860,40861,40870,42449,42450,42451,
   42460,42461,42470,52175,52176,52185,52230],
 [1377,2215,2224,40123,40124,40125,40126,40849,40850,40851,40860,40861,40870,42449,42450,42451,
   42460,42461,42470,52175,52176,52185,52230],
 [1377,2215,2224,40123,40124,40125,40126,40849,40850,40851,40860,40861,40870,42449,42450,42451,
   42460,42461,42470,52175,52176,52185,52230],
 [1377,2215,2224,40123,40124,40125,40126,40849,40850,40851,40860,40861,40870,42449,42450,42451,
   42460,42461,42470,52175,52176,52185,52230],[1377,2254,40127,40131,40890,42490],
 [1377,2262,2268,40128,40129,40133,40134,40894,40898,40899,40903,40904,40914,42494,42498,42499,
   42503,42504,42514,52363,52364,52374,52384],
 [1377,2262,2268,40128,40129,40133,40134,40894,40898,40899,40903,40904,40914,42494,42498,42499,
   42503,42504,42514,52363,52364,52374,52384],[1377,2270,40130,40132,40906,42506],
 [1377,2254,40127,40131,40890,42490],[1377,2270,40130,40132,40906,42506],
 [1377,2262,2268,40128,40129,40133,40134,40894,40898,40899,40903,40904,40914,42494,42498,42499,
   42503,42504,42514,52363,52364,52374,52384],
 [1377,2262,2268,40128,40129,40133,40134,40894,40898,40899,40903,40904,40914,42494,42498,42499,
   42503,42504,42514,52363,52364,52374,52384],[1336,39274,39275,39313,42515],
 [1336,39274,39275,39313,42515],[1336,1625,1761,39276,39280,39289,39291,39391,39400,39402,39534,
   39536,39779,42593,42602,42604,42736,42738,42981,44735,44737,44980,47160],
 [1336,1658,1698,39277,39278,39287,39293,39424,39433,39439,39467,39473,39734,42626,42635,42641,
   42669,42675,42936,45263,45269,45530,46091],
 [1336,1658,1698,39277,39278,39287,39293,39424,39433,39439,39467,39473,39734,42626,42635,42641,
   42669,42675,42936,45263,45269,45530,46091],[1336,39279],
 [1336,1625,1761,39276,39280,39289,39291,39391,39400,39402,39534,39536,39779,42593,42602,42604,
   42736,42738,42981,44735,44737,44980,47160],[1336,39281,39283,39559,42761],[1336,39282],
 [1336,39281,39283,39559,42761],[1336,1887,39284,39299,39662,42864],
 [1336,1915,39285,39300,39690,42892],[1336,5692,5705,5867,39286],
 [1336,1658,1698,39277,39278,39287,39293,39424,39433,39439,39467,39473,39734,42626,42635,42641,
   42669,42675,42936,45263,45269,45530,46091],[1336,39288],
 [1336,1625,1761,39276,39280,39289,39291,39391,39400,39402,39534,39536,39779,42593,42602,42604,
   42736,42738,42981,44735,44737,44980,47160],[1336,2033,39290,39298,39808,43010],
 [1336,1625,1761,39276,39280,39289,39291,39391,39400,39402,39534,39536,39779,42593,42602,42604,
   42736,42738,42981,44735,44737,44980,47160],[1336,39292],
 [1336,1658,1698,39277,39278,39287,39293,39424,39433,39439,39467,39473,39734,42626,42635,42641,
   42669,42675,42936,45263,45269,45530,46091],[1336,39294],[1336,39295,39297,39902,43104],
 [1336,39296],[1336,39295,39297,39902,43104],[1336,2033,39290,39298,39808,43010],
 [1336,1887,39284,39299,39662,42864],[1336,1915,39285,39300,39690,42892],
 [1336,2215,39301,39304,39990,43192],[1336,2224,39302,39303,39999,43201],
 [1336,2224,39302,39303,39999,43201],[1336,2215,39301,39304,39990,43192],
 [1336,2254,39305,39309,40029,43231],[1336,2262,39306,39311,40037,43239],
 [1336,2268,39307,39312,40043,43245],[1336,2270,39308,39310,40045,43247],
 [1336,2254,39305,39309,40029,43231],[1336,2270,39308,39310,40045,43247],
 [1336,2262,39306,39311,40037,43239],[1336,2268,39307,39312,40043,43245],
 [1336,39274,39275,39313,42515],[1625,43305,43308,43685,44981],
 [1551,1658,1719,43330,43332,43338,43339,43399,43405,43406,43468,43469,43634,45290,45296,45297,
   45359,45360,45525,46448,46449,46614,47575],[1698,43378],
 [1551,1658,1719,43330,43332,43338,43339,43399,43405,43406,43468,43469,43634,45290,45296,45297,
   45359,45360,45525,46448,46449,46614,47575],[1761,43441],
 [1551,1658,1719,43330,43332,43338,43339,43399,43405,43406,43468,43469,43634,45290,45296,45297,
   45359,45360,45525,46448,46449,46614,47575],[3756],[],[1887,43567],[1915,43595],[],
 [1551,1658,1719,43330,43332,43338,43339,43399,43405,43406,43468,43469,43634,45290,45296,45297,
   45359,45360,45525,46448,46449,46614,47575],[],[1625,43305,43308,43685,44981],[2033,43713],
 [1761,43441],[1625,43305,43308,43685,44981],[1698,43378],[],[],[],[],[2033,43713],
 [1887,43567],[1915,43595],[2215,43895],[2224,43904],[2224,43904],[2215,43895],
 [2254,43934],[2262,43942],[2268,43948],[2270,43950],[2254,43934],[2270,43950],
 [2262,43942],[2268,43948],[1625,43971],[1583,1658,44000,44004,44193,45418],
 [1698,44030,44044,44077,45863],[1698,44030,44044,44077,45863],[1761,44107,44108,44394,47204],
 [],[],[],[1887,44233],[1915,44261],[],[1583,1658,44000,44004,44193,45418],[],
 [1625,43971],[2033,44379],[1761,44107,44108,44394,47204],[1761,44107,44108,44394,47204],
 [1698,44030,44044,44077,45863],[],[],[8032],[],[2033,44379],[1887,44233],[1915,44261],
 [2215,44561],[2224,44570],[2224,44570],[2215,44561],[2254,44600],[2262,44608],
 [2268,44614],[2270,44616],[2254,44600],[2270,44616],[2262,44608],[2268,44614],
 [23,31,44,1291,1296,1306,1309,1432,1625,1658,3502,3507,3508,3517,3518,3520,3633,3634,3824,3833,
   3834,3836,4139,38294,38295,38304,38485,38494,38495,38497,38800,41069,41078,41079,41081,41113,
   41114,41116,41384,41386,41411,44633,44634,44636,44904,44906,44931,45499,45501,45526,49471],
 [1377,1625,1698,40098,40100,40111,40115,40250,40261,40265,40330,40334,40642,41850,41861,41865,
   41930,41934,42242,44670,44674,44982,46138],[1625,44703],
 [1336,1625,1761,39276,39280,39289,39291,39391,39400,39402,39534,39536,39779,42593,42602,42604,
   42736,42738,42981,44735,44737,44980,47160],[1625,44766],[1625,44795,44796,44955,48035],
 [1625,44825],[1625,1887,44853,44863,44988,48852],[1625,1915,44880,44891,44989,49204],
 [23,31,44,1291,1296,1306,1309,1432,1625,1658,3502,3507,3508,3517,3518,3520,3633,3634,3824,3833,
   3834,3836,4139,38294,38295,38304,38485,38494,38495,38497,38800,41069,41078,41079,41081,41113,
   41114,41116,41384,41386,41411,44633,44634,44636,44904,44906,44931,45499,45501,45526,49471],
 [23,31,44,1291,1296,1306,1309,1432,1625,1658,3502,3507,3508,3517,3518,3520,3633,3634,3824,3833,
   3834,3836,4139,38294,38295,38304,38485,38494,38495,38497,38800,41069,41078,41079,41081,41113,
   41114,41116,41384,41386,41411,44633,44634,44636,44904,44906,44931,45499,45501,45526,49471],
 [1625,44795,44796,44955,48035],[],[1625,2033,44979,44987,45009,50378],
 [1336,1625,1761,39276,39280,39289,39291,39391,39400,39402,39534,39536,39779,42593,42602,42604,
   42736,42738,42981,44735,44737,44980,47160],[1625,43305,43308,43685,44981],
 [1377,1625,1698,40098,40100,40111,40115,40250,40261,40265,40330,40334,40642,41850,41861,41865,
   41930,41934,42242,44670,44674,44982,46138],[1625,44983,44984,45084,50453],
 [1625,44983,44984,45084,50453],[1625,44985],[1625,44986],[1625,2033,44979,44987,45009,50378],
 [1625,1887,44853,44863,44988,48852],[1625,1915,44880,44891,44989,49204],
 [1625,2215,44990,44993,45191,50560],[1625,2224,44991,44992,45200,50569],
 [1625,2224,44991,44992,45200,50569],[1625,2215,44990,44993,45191,50560],
 [1625,2254,44994,44998,45230,50599],[1625,2262,44995,45000,45238,50607],
 [1625,2268,44996,45001,45244,50613],[1625,2270,44997,44999,45246,50615],
 [1625,2254,44994,44998,45230,50599],[1625,2270,44997,44999,45246,50615],
 [1625,2262,44995,45000,45238,50607],[1625,2268,44996,45001,45244,50613],
 [1336,1658,1698,39277,39278,39287,39293,39424,39433,39439,39467,39473,39734,42626,42635,42641,
   42669,42675,42936,45263,45269,45530,46091],
 [1551,1658,1719,43330,43332,43338,43339,43399,43405,43406,43468,43469,43634,45290,45296,45297,
   45359,45360,45525,46448,46449,46614,47575],
 [1377,1658,1761,7813,7818,7821,7828,7832,7899,7902,7909,7913,8087,8094,8098,8193,8197,8393,
   40099,40102,40109,40113,40287,40294,40298,40393,40397,40593,41887,41894,41898,41993,41997,42193,
   45328,45332,45528,47113],[1551,1658,1719,43330,43332,43338,43339,43399,43405,43406,43468,
   43469,43634,45290,45296,45297,45359,45360,45525,46448,46449,46614,47575],
 [1658,1823,45389,45394,45529,48014],[1583,1658,44000,44004,44193,45418],
 [1658,1887,2033,45446,45449,45457,45458,45527,45535,45536,45604,45605,45745,48796,48804,48805,
   48873,48874,49014,49849,49850,49990,50750],[1658,1915,45473,45486,45537,49157],
 [23,31,44,1291,1296,1306,1309,1432,1625,1658,3502,3507,3508,3517,3518,3520,3633,3634,3824,3833,
   3834,3836,4139,38294,38295,38304,38485,38494,38495,38497,38800,41069,41078,41079,41081,41113,
   41114,41116,41384,41386,41411,44633,44634,44636,44904,44906,44931,45499,45501,45526,49471],
 [],[1551,1658,1719,43330,43332,43338,43339,43399,43405,43406,43468,43469,43634,45290,45296,
   45297,45359,45360,45525,46448,46449,46614,47575],
 [23,31,44,1291,1296,1306,1309,1432,1625,1658,3502,3507,3508,3517,3518,3520,3633,3634,3824,3833,
   3834,3836,4139,38294,38295,38304,38485,38494,38495,38497,38800,41069,41078,41079,41081,41113,
   41114,41116,41384,41386,41411,44633,44634,44636,44904,44906,44931,45499,45501,45526,49471],
 [1658,1887,2033,45446,45449,45457,45458,45527,45535,45536,45604,45605,45745,48796,48804,48805,
   48873,48874,49014,49849,49850,49990,50750],
 [1377,1658,1761,7813,7818,7821,7828,7832,7899,7902,7909,7913,8087,8094,8098,8193,8197,8393,
   40099,40102,40109,40113,40287,40294,40298,40393,40397,40593,41887,41894,41898,41993,41997,42193,
   45328,45332,45528,47113],[1658,1823,45389,45394,45529,48014],
 [1336,1658,1698,39277,39278,39287,39293,39424,39433,39439,39467,39473,39734,42626,42635,42641,
   42669,42675,42936,45263,45269,45530,46091],[1658,45531],[1658,45532],[1658,45533],
 [1658,45534],[1658,1887,2033,45446,45449,45457,45458,45527,45535,45536,45604,45605,45745,48796,
   48804,48805,48873,48874,49014,49849,49850,49990,50750],
 [1658,1887,2033,45446,45449,45457,45458,45527,45535,45536,45604,45605,45745,48796,48804,48805,
   48873,48874,49014,49849,49850,49990,50750],[1658,1915,45473,45486,45537,49157],
 [1658,2215,45538,45541,45786,50031],[1658,2224,2254,45539,45540,45542,45546,45795,45797,45801,
   45806,45810,45825,50040,50042,50046,50051,50055,50070,52231,52235,52250,52286],
 [1658,2224,2254,45539,45540,45542,45546,45795,45797,45801,45806,45810,45825,50040,50042,50046,
   50051,50055,50070,52231,52235,52250,52286],[1658,2215,45538,45541,45786,50031],
 [1658,2224,2254,45539,45540,45542,45546,45795,45797,45801,45806,45810,45825,50040,50042,50046,
   50051,50055,50070,52231,52235,52250,52286],
 [1658,2262,2270,45543,45545,45547,45548,45830,45832,45833,45841,45842,45847,50075,50077,50078,
   50086,50087,50092,52366,52367,52372,52388],[1658,2268,45544,45549,45839,50084],
 [1658,2262,2270,45543,45545,45547,45548,45830,45832,45833,45841,45842,45847,50075,50077,50078,
   50086,50087,50092,52366,52367,52372,52388],
 [1658,2224,2254,45539,45540,45542,45546,45795,45797,45801,45806,45810,45825,50040,50042,50046,
   50051,50055,50070,52231,52235,52250,52286],
 [1658,2262,2270,45543,45545,45547,45548,45830,45832,45833,45841,45842,45847,50075,50077,50078,
   50086,50087,50092,52366,52367,52372,52388],
 [1658,2262,2270,45543,45545,45547,45548,45830,45832,45833,45841,45842,45847,50075,50077,50078,
   50086,50087,50092,52366,52367,52372,52388],[1658,2268,45544,45549,45839,50084],
 [1698,44030,44044,44077,45863],[1291,1306,1432,1698,1761,38304,38557,38563,38568,38570,38628,
   38633,38635,38804,38806,38921,45888,45893,45895,46064,46066,46181,47088,47090,47205,49565],
 [1698,45926],[1698,45956],[1698,45980,45985,46115,48445],[1698,1887,46013,46019,46226,48934],
 [1698,1915,46040,46047,46227,49286],[1291,1306,1432,1698,1761,38304,38557,38563,38568,38570,
   38628,38633,38635,38804,38806,38921,45888,45893,45895,46064,46066,46181,47088,47090,47205,49565]
  ,[1336,1658,1698,39277,39278,39287,39293,39424,39433,39439,39467,39473,39734,42626,42635,42641,
   42669,42675,42936,45263,45269,45530,46091],[1698,45980,45985,46115,48445],
 [1377,1625,1698,40098,40100,40111,40115,40250,40261,40265,40330,40334,40642,41850,41861,41865,
   41930,41934,42242,44670,44674,44982,46138],[1698,2033,46160,46165,46225,50669],
 [1291,1306,1432,1698,1761,38304,38557,38563,38568,38570,38628,38633,38635,38804,38806,38921,45888,
   45893,45895,46064,46066,46181,47088,47090,47205,49565],[1698,46201],[],
 [1698,46221,46223,46241,51256],[1698,46222],[1698,46221,46223,46241,51256],[1698,46224],
 [1698,2033,46160,46165,46225,50669],[1698,1887,46013,46019,46226,48934],
 [1698,1915,46040,46047,46227,49286],[1698,2215,46228,46231,46347,51362],
 [1698,2224,46229,46230,46356,51371],[1698,2224,46229,46230,46356,51371],
 [1698,2215,46228,46231,46347,51362],[1698,2254,46232,46236,46386,51401],
 [1698,2262,46233,46238,46394,51409],[1698,2268,46234,46239,46400,51415],
 [1698,2270,46235,46237,46402,51417],[1698,2254,46232,46236,46386,51401],
 [1698,2270,46235,46237,46402,51417],[1698,2262,46233,46238,46394,51409],
 [1698,2268,46234,46239,46400,51415],[1761,46421],[],[],[],[1887,46547],[1915,46575],
 [46593],[1551,1658,1719,43330,43332,43338,43339,43399,43405,43406,43468,43469,43634,45290,45296,
   45297,45359,45360,45525,46448,46449,46614,47575],
 [1551,1658,1719,43330,43332,43338,43339,43399,43405,43406,43468,43469,43634,45290,45296,45297,
   45359,45360,45525,46448,46449,46614,47575],[1625,44703],[2033,46693],[1761,46421],
 [46593],[1698,44030,44044,44077,45863],[8168],[],[],[],[2033,46693],[1887,46547],
 [1915,46575],[2215,46875],[2224,46884],[2224,46884],[2215,46875],[2254,46914],
 [2262,46922],[2268,46928],[2270,46930],[2254,46914],[2270,46930],[2262,46922],
 [2268,46928],[1761,46948],[1761,46978],[1761,47007],[1761,1887,47035,47043,47211,48895],
 [1761,1915,2033,47061,47062,47069,47071,47182,47189,47191,47210,47212,47331,49217,49224,49226,
   49245,49247,49366,50630,50632,50751,50961],
 [1291,1306,1432,1698,1761,38304,38557,38563,38568,38570,38628,38633,38635,38804,38806,38921,45888,
   45893,45895,46064,46066,46181,47088,47090,47205,49565],
 [1377,1658,1761,7813,7818,7821,7828,7832,7899,7902,7909,7913,8087,8094,8098,8193,8197,8393,
   40099,40102,40109,40113,40287,40294,40298,40393,40397,40593,41887,41894,41898,41993,41997,42193,
   45328,45332,45528,47113],[1761,47137],
 [1336,1625,1761,39276,39280,39289,39291,39391,39400,39402,39534,39536,39779,42593,42602,42604,
   42736,42738,42981,44735,44737,44980,47160],
 [1761,1915,2033,47061,47062,47069,47071,47182,47189,47191,47210,47212,47331,49217,49224,49226,
   49245,49247,49366,50630,50632,50751,50961],[],[1761,44107,44108,44394,47204],
 [1291,1306,1432,1698,1761,38304,38557,38563,38568,38570,38628,38633,38635,38804,38806,38921,45888,
   45893,45895,46064,46066,46181,47088,47090,47205,49565],[1761,47206,47209,47266,50896],
 [1761,47207],[1761,47208],[1761,47206,47209,47266,50896],
 [1761,1915,2033,47061,47062,47069,47071,47182,47189,47191,47210,47212,47331,49217,49224,49226,
   49245,49247,49366,50630,50632,50751,50961],[1761,1887,47035,47043,47211,48895],
 [1761,1915,2033,47061,47062,47069,47071,47182,47189,47191,47210,47212,47331,49217,49224,49226,
   49245,49247,49366,50630,50632,50751,50961],
 [1761,2215,2254,47213,47216,47217,47221,47371,47372,47376,47399,47403,47410,51001,51002,51006,
   51029,51033,51040,52194,52198,52205,52314],[1761,2224,47214,47215,47380,51010],
 [1761,2224,47214,47215,47380,51010],[1761,2215,2254,47213,47216,47217,47221,47371,47372,47376,
   47399,47403,47410,51001,51002,51006,51029,51033,51040,52194,52198,52205,52314],
 [1761,2215,2254,47213,47216,47217,47221,47371,47372,47376,47399,47403,47410,51001,51002,51006,
   51029,51033,51040,52194,52198,52205,52314],[1761,2262,47218,47223,47418,51048],
 [1761,2268,2270,47219,47220,47222,47224,47420,47422,47424,47426,47428,47433,51050,51052,51054,
   51056,51058,51063,52376,52378,52383,52389],
 [1761,2268,2270,47219,47220,47222,47224,47420,47422,47424,47426,47428,47433,51050,51052,51054,
   51056,51058,51063,52376,52378,52383,52389],
 [1761,2215,2254,47213,47216,47217,47221,47371,47372,47376,47399,47403,47410,51001,51002,51006,
   51029,51033,51040,52194,52198,52205,52314],
 [1761,2268,2270,47219,47220,47222,47224,47420,47422,47424,47426,47428,47433,51050,51052,51054,
   51056,51058,51063,52376,52378,52383,52389],[1761,2262,47218,47223,47418,51048],
 [1761,2268,2270,47219,47220,47222,47224,47420,47422,47424,47426,47428,47433,51050,51052,51054,
   51056,51058,51063,52376,52378,52383,52389],[41239],[1336,39281,39283,39559,42761],
 [1887,47508],[1915,47536],[],[1551,1658,1719,43330,43332,43338,43339,43399,43405,43406,43468,
   43469,43634,45290,45296,45297,45359,45360,45525,46448,46449,46614,47575],
 [1551,1658,1719,43330,43332,43338,43339,43399,43405,43406,43468,43469,43634,45290,45296,45297,
   45359,45360,45525,46448,46449,46614,47575],[1625,44766],[2033,47654],[1761,46948],[],
 [1698,45926],[],[6152],[],[],[2033,47654],[1887,47508],[1915,47536],[2215,47836],
 [2224,47845],[2224,47845],[2215,47836],[2254,47875],[2262,47883],[2268,47889],
 [2270,47891],[2254,47875],[2270,47891],[2262,47883],[2268,47889],
 [1377,1827,1855,40104,40105,40117,40118,40450,40462,40463,40491,40492,40762,42050,42062,42063,
   42091,42092,42362,47911,47912,48182,48588],[1887,47943],[1915,47971],[],
 [1658,1823,45389,45394,45529,48014],[1625,44795,44796,44955,48035],
 [1625,44795,44796,44955,48035],[2033,48089],[1761,46978],[],[1698,45956],[],
 [1377,1827,1855,40104,40105,40117,40118,40450,40462,40463,40491,40492,40762,42050,42062,42063,
   42091,42092,42362,47911,47912,48182,48588],[],[],[2033,48089],[1887,47943],
 [1915,47971],[2215,48271],[2224,48280],[2224,48280],[2215,48271],[2254,48310],
 [2262,48318],[2268,48324],[2270,48326],[2254,48310],[2270,48326],[2262,48318],
 [2268,48324],[1887,48349],[1915,48377],[],[1583,1658,44000,44004,44193,45418],
 [1698,45980,45985,46115,48445],[1625,44825],[2033,48495],[1761,47007],[],
 [1698,45980,45985,46115,48445],[],[],
 [1377,1827,1855,40104,40105,40117,40118,40450,40462,40463,40491,40492,40762,42050,42062,42063,
   42091,42092,42362,47911,47912,48182,48588],[6213],[2033,48495],[1887,48349],[1915,48377],
 [2215,48677],[2224,48686],[2224,48686],[2215,48677],[2254,48716],[2262,48724],
 [2268,48730],[2270,48732],[2254,48716],[2270,48732],[2262,48724],[2268,48730],
 [1377,1887,1915,40106,40107,40121,40122,40509,40523,40524,40550,40551,40824,42109,42123,42124,
   42150,42151,42424,48754,48755,49028,49379],[1887,48780],
 [1658,1887,2033,45446,45449,45457,45458,45527,45535,45536,45604,45605,45745,48796,48804,48805,
   48873,48874,49014,49849,49850,49990,50750],[1887,48829],[1625,1887,44853,44863,44988,48852],
 [1658,1887,2033,45446,45449,45457,45458,45527,45535,45536,45604,45605,45745,48796,48804,48805,
   48873,48874,49014,49849,49850,49990,50750],[1761,1887,47035,47043,47211,48895],[1887,48915],
 [1698,1887,46013,46019,46226,48934],[1887,48952],[1887,48969],[1887,48985],[1887,49000],
 [1658,1887,2033,45446,45449,45457,45458,45527,45535,45536,45604,45605,45745,48796,48804,48805,
   48873,48874,49014,49849,49850,49990,50750],[],
 [1377,1887,1915,40106,40107,40121,40122,40509,40523,40524,40550,40551,40824,42109,42123,42124,
   42150,42151,42424,48754,48755,49028,49379],[1887,2215,49029,49032,49055,52045],
 [1887,2224,49030,49031,49064,52054],[1887,2224,49030,49031,49064,52054],
 [1887,2215,49029,49032,49055,52045],[1887,2254,49033,49037,49094,52084],
 [1887,2262,49034,49039,49102,52092],[1887,2268,49035,49040,49108,52098],
 [1887,2270,49036,49038,49110,52100],[1887,2254,49033,49037,49094,52084],
 [1887,2270,49036,49038,49110,52100],[1887,2262,49034,49039,49102,52092],
 [1887,2268,49035,49040,49108,52098],[1915,49132],[1658,1915,45473,45486,45537,49157],
 [1915,49181],[1625,1915,44880,44891,44989,49204],
 [1761,1915,2033,47061,47062,47069,47071,47182,47189,47191,47210,47212,47331,49217,49224,49226,
   49245,49247,49366,50630,50632,50751,50961],
 [1761,1915,2033,47061,47062,47069,47071,47182,47189,47191,47210,47212,47331,49217,49224,49226,
   49245,49247,49366,50630,50632,50751,50961],[1915,49267],[1698,1915,46040,46047,46227,49286],
 [1915,49304],[1915,49321],[1915,49337],[1915,49352],
 [1761,1915,2033,47061,47062,47069,47071,47182,47189,47191,47210,47212,47331,49217,49224,49226,
   49245,49247,49366,50630,50632,50751,50961],
 [1377,1887,1915,40106,40107,40121,40122,40509,40523,40524,40550,40551,40824,42109,42123,42124,
   42150,42151,42424,48754,48755,49028,49379],[],[1915,2215,49392,49395,49406,52111],
 [1915,2224,49393,49394,49415,52120],[1915,2224,49393,49394,49415,52120],
 [1915,2215,49392,49395,49406,52111],[1915,2254,49396,49400,49445,52150],
 [1915,2262,49397,49402,49453,52158],[1915,2268,49398,49403,49459,52164],
 [1915,2270,49399,49401,49461,52166],[1915,2254,49396,49400,49445,52150],
 [1915,2270,49399,49401,49461,52166],[1915,2262,49397,49402,49453,52158],
 [1915,2268,49398,49403,49459,52164],[23,31,44,1291,1296,1306,1309,1432,1625,1658,3502,3507,
   3508,3517,3518,3520,3633,3634,3824,3833,3834,3836,4139,38294,38295,38304,38485,38494,38495,
   38497,38800,41069,41078,41079,41081,41113,41114,41116,41384,41386,41411,44633,44634,44636,44904,
   44906,44931,45499,45501,45526,49471],[],
 [23,31,44,1291,1296,1306,1309,1432,1625,1658,3502,3507,3508,3517,3518,3520,3633,3634,3824,3833,
   3834,3836,4139,38294,38295,38304,38485,38494,38495,38497,38800,41069,41078,41079,41081,41113,
   41114,41116,41384,41386,41411,44633,44634,44636,44904,44906,44931,45499,45501,45526,49471],
 [2033,49549],[1291,1306,1432,1698,1761,38304,38557,38563,38568,38570,38628,38633,38635,38804,
   38806,38921,45888,45893,45895,46064,46066,46181,47088,47090,47205,49565],[46593],
 [1291,1306,1432,1698,1761,38304,38557,38563,38568,38570,38628,38633,38635,38804,38806,38921,45888,
   45893,45895,46064,46066,46181,47088,47090,47205,49565],[],[],[],[],[2033,49549],
 [1887,48780],[1915,49132],[2215,49731],[2224,49740],[2224,49740],[2215,49731],
 [2254,49770],[2262,49778],[2268,49784],[2270,49786],[2254,49770],[2270,49786],
 [2262,49778],[2268,49784],[1551,1658,1719,43330,43332,43338,43339,43399,43405,43406,43468,
   43469,43634,45290,45296,45297,45359,45360,45525,46448,46449,46614,47575],
 [23,31,44,1291,1296,1306,1309,1432,1625,1658,3502,3507,3508,3517,3518,3520,3633,3634,3824,3833,
   3834,3836,4139,38294,38295,38304,38485,38494,38495,38497,38800,41069,41078,41079,41081,41113,
   41114,41116,41384,41386,41411,44633,44634,44636,44904,44906,44931,45499,45501,45526,49471],
 [1658,1887,2033,45446,45449,45457,45458,45527,45535,45536,45604,45605,45745,48796,48804,48805,
   48873,48874,49014,49849,49850,49990,50750],
 [1377,1658,1761,7813,7818,7821,7828,7832,7899,7902,7909,7913,8087,8094,8098,8193,8197,8393,
   40099,40102,40109,40113,40287,40294,40298,40393,40397,40593,41887,41894,41898,41993,41997,42193,
   45328,45332,45528,47113],[1658,1823,45389,45394,45529,48014],
 [1336,1658,1698,39277,39278,39287,39293,39424,39433,39439,39467,39473,39734,42626,42635,42641,
   42669,42675,42936,45263,45269,45530,46091],[1658,45531],[1658,45532],[1658,45533],
 [1658,45534],[1658,1887,2033,45446,45449,45457,45458,45527,45535,45536,45604,45605,45745,48796,
   48804,48805,48873,48874,49014,49849,49850,49990,50750],
 [1658,1887,2033,45446,45449,45457,45458,45527,45535,45536,45604,45605,45745,48796,48804,48805,
   48873,48874,49014,49849,49850,49990,50750],[1658,1915,45473,45486,45537,49157],
 [1658,2215,45538,45541,45786,50031],[1658,2224,2254,45539,45540,45542,45546,45795,45797,45801,
   45806,45810,45825,50040,50042,50046,50051,50055,50070,52231,52235,52250,52286],
 [1658,2224,2254,45539,45540,45542,45546,45795,45797,45801,45806,45810,45825,50040,50042,50046,
   50051,50055,50070,52231,52235,52250,52286],[1658,2215,45538,45541,45786,50031],
 [1658,2224,2254,45539,45540,45542,45546,45795,45797,45801,45806,45810,45825,50040,50042,50046,
   50051,50055,50070,52231,52235,52250,52286],
 [1658,2262,2270,45543,45545,45547,45548,45830,45832,45833,45841,45842,45847,50075,50077,50078,
   50086,50087,50092,52366,52367,52372,52388],[1658,2268,45544,45549,45839,50084],
 [1658,2262,2270,45543,45545,45547,45548,45830,45832,45833,45841,45842,45847,50075,50077,50078,
   50086,50087,50092,52366,52367,52372,52388],
 [1658,2224,2254,45539,45540,45542,45546,45795,45797,45801,45806,45810,45825,50040,50042,50046,
   50051,50055,50070,52231,52235,52250,52286],
 [1658,2262,2270,45543,45545,45547,45548,45830,45832,45833,45841,45842,45847,50075,50077,50078,
   50086,50087,50092,52366,52367,52372,52388],
 [1658,2262,2270,45543,45545,45547,45548,45830,45832,45833,45841,45842,45847,50075,50077,50078,
   50086,50087,50092,52366,52367,52372,52388],[1658,2268,45544,45549,45839,50084],
 [1625,44795,44796,44955,48035],[2033,50125],[1761,47137],[4193],
 [1698,45980,45985,46115,48445],[],[],[],[],[2033,50125],[1887,48829],[1915,49181],
 [2215,50307],[2224,50316],[2224,50316],[2215,50307],[2254,50346],[2262,50354],
 [2268,50360],[2270,50362],[2254,50346],[2270,50362],[2262,50354],[2268,50360],
 [1625,2033,44979,44987,45009,50378],[1336,1625,1761,39276,39280,39289,39291,39391,39400,39402,
   39534,39536,39779,42593,42602,42604,42736,42738,42981,44735,44737,44980,47160],
 [1625,43305,43308,43685,44981],[1377,1625,1698,40098,40100,40111,40115,40250,40261,40265,40330,
   40334,40642,41850,41861,41865,41930,41934,42242,44670,44674,44982,46138],
 [1625,44983,44984,45084,50453],[1625,44983,44984,45084,50453],[1625,44985],[1625,44986],
 [1625,2033,44979,44987,45009,50378],[1625,1887,44853,44863,44988,48852],
 [1625,1915,44880,44891,44989,49204],[1625,2215,44990,44993,45191,50560],
 [1625,2224,44991,44992,45200,50569],[1625,2224,44991,44992,45200,50569],
 [1625,2215,44990,44993,45191,50560],[1625,2254,44994,44998,45230,50599],
 [1625,2262,44995,45000,45238,50607],[1625,2268,44996,45001,45244,50613],
 [1625,2270,44997,44999,45246,50615],[1625,2254,44994,44998,45230,50599],
 [1625,2270,44997,44999,45246,50615],[1625,2262,44995,45000,45238,50607],
 [1625,2268,44996,45001,45244,50613],[1761,1915,2033,47061,47062,47069,47071,47182,47189,47191,
   47210,47212,47331,49217,49224,49226,49245,49247,49366,50630,50632,50751,50961],[2033,50650],
 [1698,2033,46160,46165,46225,50669],[2033,50687],[2033,50704],[2033,50720],[2033,50735],
 [],[1658,1887,2033,45446,45449,45457,45458,45527,45535,45536,45604,45605,45745,48796,48804,
   48805,48873,48874,49014,49849,49850,49990,50750],
 [1761,1915,2033,47061,47062,47069,47071,47182,47189,47191,47210,47212,47331,49217,49224,49226,
   49245,49247,49366,50630,50632,50751,50961],[2033,2215,50752,50755,50791,51967],
 [2033,2224,50753,50754,50800,51976],[2033,2224,50753,50754,50800,51976],
 [2033,2215,50752,50755,50791,51967],[2033,2254,50756,50760,50830,52006],
 [2033,2262,50757,50762,50838,52014],[2033,2268,50758,50763,50844,52020],
 [2033,2270,50759,50761,50846,52022],[2033,2254,50756,50760,50830,52006],
 [2033,2270,50759,50761,50846,52022],[2033,2262,50757,50762,50838,52014],
 [2033,2268,50758,50763,50844,52020],[1761,44107,44108,44394,47204],
 [1291,1306,1432,1698,1761,38304,38557,38563,38568,38570,38628,38633,38635,38804,38806,38921,45888,
   45893,45895,46064,46066,46181,47088,47090,47205,49565],[1761,47206,47209,47266,50896],
 [1761,47207],[1761,47208],[1761,47206,47209,47266,50896],
 [1761,1915,2033,47061,47062,47069,47071,47182,47189,47191,47210,47212,47331,49217,49224,49226,
   49245,49247,49366,50630,50632,50751,50961],[1761,1887,47035,47043,47211,48895],
 [1761,1915,2033,47061,47062,47069,47071,47182,47189,47191,47210,47212,47331,49217,49224,49226,
   49245,49247,49366,50630,50632,50751,50961],
 [1761,2215,2254,47213,47216,47217,47221,47371,47372,47376,47399,47403,47410,51001,51002,51006,
   51029,51033,51040,52194,52198,52205,52314],[1761,2224,47214,47215,47380,51010],
 [1761,2224,47214,47215,47380,51010],[1761,2215,2254,47213,47216,47217,47221,47371,47372,47376,
   47399,47403,47410,51001,51002,51006,51029,51033,51040,52194,52198,52205,52314],
 [1761,2215,2254,47213,47216,47217,47221,47371,47372,47376,47399,47403,47410,51001,51002,51006,
   51029,51033,51040,52194,52198,52205,52314],[1761,2262,47218,47223,47418,51048],
 [1761,2268,2270,47219,47220,47222,47224,47420,47422,47424,47426,47428,47433,51050,51052,51054,
   51056,51058,51063,52376,52378,52383,52389],
 [1761,2268,2270,47219,47220,47222,47224,47420,47422,47424,47426,47428,47433,51050,51052,51054,
   51056,51058,51063,52376,52378,52383,52389],
 [1761,2215,2254,47213,47216,47217,47221,47371,47372,47376,47399,47403,47410,51001,51002,51006,
   51029,51033,51040,52194,52198,52205,52314],
 [1761,2268,2270,47219,47220,47222,47224,47420,47422,47424,47426,47428,47433,51050,51052,51054,
   51056,51058,51063,52376,52378,52383,52389],[1761,2262,47218,47223,47418,51048],
 [1761,2268,2270,47219,47220,47222,47224,47420,47422,47424,47426,47428,47433,51050,51052,51054,
   51056,51058,51063,52376,52378,52383,52389],[1698,46201],[],[],[],[],[2033,50650],
 [1887,48915],[1915,49267],[2215,51191],[2224,51200],[2224,51200],[2215,51191],
 [2254,51230],[2262,51238],[2268,51244],[2270,51246],[2254,51230],[2270,51246],
 [2262,51238],[2268,51244],[1698,46221,46223,46241,51256],[1698,46222],
 [1698,46221,46223,46241,51256],[1698,46224],[1698,2033,46160,46165,46225,50669],
 [1698,1887,46013,46019,46226,48934],[1698,1915,46040,46047,46227,49286],
 [1698,2215,46228,46231,46347,51362],[1698,2224,46229,46230,46356,51371],
 [1698,2224,46229,46230,46356,51371],[1698,2215,46228,46231,46347,51362],
 [1698,2254,46232,46236,46386,51401],[1698,2262,46233,46238,46394,51409],
 [1698,2268,46234,46239,46400,51415],[1698,2270,46235,46237,46402,51417],
 [1698,2254,46232,46236,46386,51401],[1698,2270,46235,46237,46402,51417],
 [1698,2262,46233,46238,46394,51409],[1698,2268,46234,46239,46400,51415],
 [1625,44983,44984,45084,50453],[1698,46221,46223,46241,51256],[1761,47206,47209,47266,50896],
 [2033,50687],[1887,48952],[1915,49304],[2215,51515],[2224,51524],[2224,51524],
 [2215,51515],[2254,51554],[2262,51562],[2268,51568],[2270,51570],[2254,51554],
 [2270,51570],[2262,51562],[2268,51568],
 [1377,1827,1855,40104,40105,40117,40118,40450,40462,40463,40491,40492,40762,42050,42062,42063,
   42091,42092,42362,47911,47912,48182,48588],[1336,39295,39297,39902,43104],[2033,50704],
 [1887,48969],[1915,49321],[2215,51651],[2224,51660],[2224,51660],[2215,51651],
 [2254,51690],[2262,51698],[2268,51704],[2270,51706],[2254,51690],[2270,51706],
 [2262,51698],[2268,51704],[39015],[2033,50720],[1887,48985],[1915,49337],[2215,51771],
 [2224,51780],[2224,51780],[2215,51771],[2254,51810],[2262,51818],[2268,51824],
 [2270,51826],[2254,51810],[2270,51826],[2262,51818],[2268,51824],[2033,50735],
 [1887,49000],[1915,49352],[2215,51876],[2224,51885],[2224,51885],[2215,51876],
 [2254,51915],[2262,51923],[2268,51929],[2270,51931],[2254,51915],[2270,51931],
 [2262,51923],[2268,51929],[1658,1887,2033,45446,45449,45457,45458,45527,45535,45536,45604,
   45605,45745,48796,48804,48805,48873,48874,49014,49849,49850,49990,50750],
 [1761,1915,2033,47061,47062,47069,47071,47182,47189,47191,47210,47212,47331,49217,49224,49226,
   49245,49247,49366,50630,50632,50751,50961],[2033,2215,50752,50755,50791,51967],
 [2033,2224,50753,50754,50800,51976],[2033,2224,50753,50754,50800,51976],
 [2033,2215,50752,50755,50791,51967],[2033,2254,50756,50760,50830,52006],
 [2033,2262,50757,50762,50838,52014],[2033,2268,50758,50763,50844,52020],
 [2033,2270,50759,50761,50846,52022],[2033,2254,50756,50760,50830,52006],
 [2033,2270,50759,50761,50846,52022],[2033,2262,50757,50762,50838,52014],
 [2033,2268,50758,50763,50844,52020],[1377,1887,1915,40106,40107,40121,40122,40509,40523,40524,
   40550,40551,40824,42109,42123,42124,42150,42151,42424,48754,48755,49028,49379],
 [1887,2215,49029,49032,49055,52045],[1887,2224,49030,49031,49064,52054],
 [1887,2224,49030,49031,49064,52054],[1887,2215,49029,49032,49055,52045],
 [1887,2254,49033,49037,49094,52084],[1887,2262,49034,49039,49102,52092],
 [1887,2268,49035,49040,49108,52098],[1887,2270,49036,49038,49110,52100],
 [1887,2254,49033,49037,49094,52084],[1887,2270,49036,49038,49110,52100],
 [1887,2262,49034,49039,49102,52092],[1887,2268,49035,49040,49108,52098],
 [1915,2215,49392,49395,49406,52111],[1915,2224,49393,49394,49415,52120],
 [1915,2224,49393,49394,49415,52120],[1915,2215,49392,49395,49406,52111],
 [1915,2254,49396,49400,49445,52150],[1915,2262,49397,49402,49453,52158],
 [1915,2268,49398,49403,49459,52164],[1915,2270,49399,49401,49461,52166],
 [1915,2254,49396,49400,49445,52150],[1915,2270,49399,49401,49461,52166],
 [1915,2262,49397,49402,49453,52158],[1915,2268,49398,49403,49459,52164],
 [1377,2215,2224,40123,40124,40125,40126,40849,40850,40851,40860,40861,40870,42449,42450,42451,
   42460,42461,42470,52175,52176,52185,52230],
 [1377,2215,2224,40123,40124,40125,40126,40849,40850,40851,40860,40861,40870,42449,42450,42451,
   42460,42461,42470,52175,52176,52185,52230],[],
 [1761,2215,2254,47213,47216,47217,47221,47371,47372,47376,47399,47403,47410,51001,51002,51006,
   51029,51033,51040,52194,52198,52205,52314],[2215,2262,52195,52200,52213,52322],
 [328,2215,2268,12852,12855,12858,12863,14511,14514,14519,14541,14546,14564,19822,19825,19830,
   19852,19857,19875,52196,52201,52219,52328],[2215,2270,52197,52199,52221,52330],
 [1761,2215,2254,47213,47216,47217,47221,47371,47372,47376,47399,47403,47410,51001,51002,51006,
   51029,51033,51040,52194,52198,52205,52314],[2215,2270,52197,52199,52221,52330],
 [2215,2262,52195,52200,52213,52322],[328,2215,2268,12852,12855,12858,12863,14511,14514,14519,
   14541,14546,14564,19822,19825,19830,19852,19857,19875,52196,52201,52219,52328],[],
 [1377,2215,2224,40123,40124,40125,40126,40849,40850,40851,40860,40861,40870,42449,42450,42451,
   42460,42461,42470,52175,52176,52185,52230],
 [1658,2224,2254,45539,45540,45542,45546,45795,45797,45801,45806,45810,45825,50040,50042,50046,
   50051,50055,50070,52231,52235,52250,52286],
 [328,2224,2262,12853,12854,12857,12862,14520,14523,14528,14532,14537,14558,19831,19834,19839,
   19843,19848,19869,52232,52237,52258,52294],[2224,2268,52233,52238,52264,52300],
 [2224,2270,52234,52236,52266,52302],[1658,2224,2254,45539,45540,45542,45546,45795,45797,45801,
   45806,45810,45825,50040,50042,50046,50051,50055,50070,52231,52235,52250,52286],
 [2224,2270,52234,52236,52266,52302],[328,2224,2262,12853,12854,12857,12862,14520,14523,14528,
   14532,14537,14558,19831,19834,19839,19843,19848,19869,52232,52237,52258,52294],
 [2224,2268,52233,52238,52264,52300],[1377,2215,2224,40123,40124,40125,40126,40849,40850,40851,
   40860,40861,40870,42449,42450,42451,42460,42461,42470,52175,52176,52185,52230],
 [1658,2224,2254,45539,45540,45542,45546,45795,45797,45801,45806,45810,45825,50040,50042,50046,
   50051,50055,50070,52231,52235,52250,52286],
 [328,2224,2262,12853,12854,12857,12862,14520,14523,14528,14532,14537,14558,19831,19834,19839,
   19843,19848,19869,52232,52237,52258,52294],[2224,2268,52233,52238,52264,52300],
 [2224,2270,52234,52236,52266,52302],[1658,2224,2254,45539,45540,45542,45546,45795,45797,45801,
   45806,45810,45825,50040,50042,50046,50051,50055,50070,52231,52235,52250,52286],
 [2224,2270,52234,52236,52266,52302],[328,2224,2262,12853,12854,12857,12862,14520,14523,14528,
   14532,14537,14558,19831,19834,19839,19843,19848,19869,52232,52237,52258,52294],
 [2224,2268,52233,52238,52264,52300],[1761,2215,2254,47213,47216,47217,47221,47371,47372,47376,
   47399,47403,47410,51001,51002,51006,51029,51033,51040,52194,52198,52205,52314],
 [2215,2262,52195,52200,52213,52322],[328,2215,2268,12852,12855,12858,12863,14511,14514,14519,
   14541,14546,14564,19822,19825,19830,19852,19857,19875,52196,52201,52219,52328],
 [2215,2270,52197,52199,52221,52330],[1761,2215,2254,47213,47216,47217,47221,47371,47372,47376,
   47399,47403,47410,51001,51002,51006,51029,51033,51040,52194,52198,52205,52314],
 [2215,2270,52197,52199,52221,52330],[2215,2262,52195,52200,52213,52322],
 [328,2215,2268,12852,12855,12858,12863,14511,14514,14519,14541,14546,14564,19822,19825,19830,
   19852,19857,19875,52196,52201,52219,52328],[2254,2262,52341,52343,52355,52370],
 [2254,2268,52346,52349,52356,52381],[328,2254,2270,12856,12859,12860,12861,14549,14550,14551,
   14565,14566,14569,19860,19861,19862,19876,19877,19880,52350,52351,52354,52385],[],
 [328,2254,2270,12856,12859,12860,12861,14549,14550,14551,14565,14566,14569,19860,19861,19862,
   19876,19877,19880,52350,52351,52354,52385],[2254,2262,52341,52343,52355,52370],
 [2254,2268,52346,52349,52356,52381],[1377,2262,2268,40128,40129,40133,40134,40894,40898,40899,
   40903,40904,40914,42494,42498,42499,42503,42504,42514,52363,52364,52374,52384],
 [1658,2262,2270,45543,45545,45547,45548,45830,45832,45833,45841,45842,45847,50075,50077,50078,
   50086,50087,50092,52366,52367,52372,52388],[2254,2262,52341,52343,52355,52370],
 [1658,2262,2270,45543,45545,45547,45548,45830,45832,45833,45841,45842,45847,50075,50077,50078,
   50086,50087,50092,52366,52367,52372,52388],[],
 [1377,2262,2268,40128,40129,40133,40134,40894,40898,40899,40903,40904,40914,42494,42498,42499,
   42503,42504,42514,52363,52364,52374,52384],
 [1761,2268,2270,47219,47220,47222,47224,47420,47422,47424,47426,47428,47433,51050,51052,51054,
   51056,51058,51063,52376,52378,52383,52389],[2254,2268,52346,52349,52356,52381],
 [1761,2268,2270,47219,47220,47222,47224,47420,47422,47424,47426,47428,47433,51050,51052,51054,
   51056,51058,51063,52376,52378,52383,52389],
 [1377,2262,2268,40128,40129,40133,40134,40894,40898,40899,40903,40904,40914,42494,42498,42499,
   42503,42504,42514,52363,52364,52374,52384],[],
 [328,2254,2270,12856,12859,12860,12861,14549,14550,14551,14565,14566,14569,19860,19861,19862,
   19876,19877,19880,52350,52351,52354,52385],[],
 [1658,2262,2270,45543,45545,45547,45548,45830,45832,45833,45841,45842,45847,50075,50077,50078,
   50086,50087,50092,52366,52367,52372,52388],
 [1761,2268,2270,47219,47220,47222,47224,47420,47422,47424,47426,47428,47433,51050,51052,51054,
   51056,51058,51063,52376,52378,52383,52389],
 [328,2254,2270,12856,12859,12860,12861,14549,14550,14551,14565,14566,14569,19860,19861,19862,
   19876,19877,19880,52350,52351,52354,52385],[2254,2262,52341,52343,52355,52370],
 [2254,2268,52346,52349,52356,52381],[1658,2262,2270,45543,45545,45547,45548,45830,45832,45833,
   45841,45842,45847,50075,50077,50078,50086,50087,50092,52366,52367,52372,52388],
 [1761,2268,2270,47219,47220,47222,47224,47420,47422,47424,47426,47428,47433,51050,51052,51054,
   51056,51058,51063,52376,52378,52383,52389],
 [1377,2262,2268,40128,40129,40133,40134,40894,40898,40899,40903,40904,40914,42494,42498,42499,
   42503,42504,42514,52363,52364,52374,52384],[],[2279],[2279],[2279],[2279],[2279],
 [2279],[2279],[2279],[2279],[2279],[2279],[2279],[2279],[2279],[2279],[2279],
 [2279],[2279],[2279],[2279],[2279,3500,3501,3507,3517,3518,3544,3550,3592,3833,3834,4139,
   5645,5646,5662,5689,5695,5705,5706,5747,5978,5979,6284,7725,7726,7743,7769,7786,7817,7827,
   7828,8058,8059,8364,38205,38211,38221,38222,38253,38263,38264,38494,38495,38800,39156,39166,
   39167,39397,39398,39703,40258,40259,40564,44904],
 [2279,3500,3501,3507,3517,3518,3544,3550,3592,3833,3834,4139,5645,5646,5662,5689,5695,5705,5706,
   5747,5978,5979,6284,7725,7726,7743,7769,7786,7817,7827,7828,8058,8059,8364,38205,38211,38221,
   38222,38253,38263,38264,38494,38495,38800,39156,39166,39167,39397,39398,39703,40258,40259,40564,
   44904],[2279,3500,3501,3507,3517,3518,3544,3550,3592,3833,3834,4139,5645,5646,5662,5689,
   5695,5705,5706,5747,5978,5979,6284,7725,7726,7743,7769,7786,7817,7827,7828,8058,8059,8364,
   38205,38211,38221,38222,38253,38263,38264,38494,38495,38800,39156,39166,39167,39397,39398,39703,
   40258,40259,40564,44904],[23,26,31,32,41,42,44,89,90,91,92,93,94,107,156,158,163,166,
   173,177,1289,1290,1291,1292,1293,1296,1298,1300,1306,1309,1311,1313,1333,1334,1335,1336,1339,
   1340,1341,1343,1349,1350,1352,1354,1356,1376,1377,1378,1381,1382,1383,1385,1392,1394,1396,
   1398,1418,1419,1422,1423,1432,1433,1435,1459,1462,1463,1464,1466,1473,1475,1477,1479,1501,
   1502,1503,1505,1511,1512,1514,1516,1518,1613,1614,1616,1622,1623,1625,1627,1629,1649,1651,
   1657,1658,1660,1662,1664,1685,1691,1692,1694,1696,1698,1756,1757,1759,1761,1763,1928,1930,
   1932,1934,1955,1957,1959,2004,2006,2049,2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,
   2373,2383,2384,3500,3501,3502,3503,3504,3507,3508,3509,3511,3517,3518,3520,3522,3524,3544,
   3545,3546,3547,3550,3551,3552,3554,3560,3561,3563,3565,3567,3587,3588,3589,3592,3593,3594,
   3596,3602,3603,3605,3607,3609,3629,3630,3633,3634,3635,3637,3643,3644,3646,3648,3650,3670,
   3673,3674,3675,3677,3683,3684,3688,3690,3712,3713,3714,3716,3722,3723,3727,3729,3824,3825,
   3827,3833,3834,3836,3838,3840,3860,3862,3868,3869,3871,3873,3875,3896,3902,3903,3907,3909,
   3967,3968,3972,3974,4139,4141,4143,4145,4166,4168,4170,4215,4217,4260,4510,4511,4512,4518,
   4528,4529,5645,5646,5647,5648,5649,5652,5653,5654,5656,5662,5663,5665,5667,5669,5689,5690,
   5691,5692,5695,5696,5697,5699,5705,5706,5708,5710,5712,5732,5733,5734,5737,5738,5739,5741,
   5747,5748,5750,5752,5754,5774,5775,5778,5779,5780,5782,5788,5789,5791,5793,5795,5815,5818,
   5819,5820,5822,5828,5829,5831,5833,5835,5857,5861,5867,5868,5874,5969,5970,5972,5978,5979,
   5981,5983,5985,6005,6007,6013,6014,6016,6018,6020,6041,6047,6048,6050,6052,6054,6112,6113,
   6115,6117,6119,6284,6286,6288,6290,6311,6313,6315,6360,6362,6405,7725,7726,7727,7728,7729,
   7732,7733,7734,7736,7742,7743,7745,7747,7749,7769,7770,7771,7772,7775,7776,7777,7779,7785,
   7786,7788,7790,7792,7812,7813,7814,7817,7818,7819,7821,7827,7828,7830,7832,7834,7854,7855,
   7858,7859,7862,7868,7869,7871,7873,7875,7895,7898,7899,7900,7902,7908,7909,7911,7913,7915,
   7937,7938,7941,7947,7948,7950,7952,7954,8049,8050,8052,8058,8059,8061,8063,8065,8085,8087,
   8093,8094,8096,8098,8100,8121,8127,8128,8132,8192,8193,8195,8197,8199,8364,8366,8368,8370,
   8391,8393,8395,8440,8442,8485,38205,38206,38207,38208,38211,38212,38213,38215,38221,38222,
   38224,38226,38228,38248,38249,38250,38253,38254,38255,38257,38263,38264,38266,38268,38270,38290,
   38291,38294,38295,38296,38298,38304,38305,38307,38309,38311,38331,38334,38335,38336,38338,38344,
   38345,38347,38349,38351,38373,38374,38375,38377,38383,38384,38386,38388,38390,38485,38486,38488,
   38494,38495,38497,38499,38501,38521,38523,38529,38532,38534,38536,38557,38563,38564,38566,38568,
   38570,38628,38629,38631,38633,38635,38800,38802,38804,38806,38827,38829,38831,38876,38878,38921,
   39151,39152,39153,39156,39157,39158,39160,39166,39167,39169,39171,39173,39193,39194,39197,39198,
   39199,39201,39207,39208,39210,39212,39214,39234,39237,39238,39239,39241,39247,39248,39250,39252,
   39254,39276,39277,39278,39280,39286,39287,39289,39291,39293,39388,39389,39391,39397,39398,39400,
   39402,39424,39426,39432,39433,39435,39437,39439,39460,39466,39467,39469,39471,39473,39531,39534,
   39536,39538,39703,39705,39707,39709,39730,39732,39734,39779,39781,39824,40054,40055,40058,40059,
   40060,40062,40068,40069,40071,40073,40075,40095,40098,40099,40100,40102,40109,40111,40113,40115,
   40137,40138,40139,40141,40147,40148,40150,40152,40154,40249,40250,40252,40258,40259,40261,40265,
   40285,40287,40293,40294,40296,40298,40300,40321,40327,40328,40330,40332,40334,40392,40393,40395,
   40397,40399,40564,40566,40568,40570,40591,40593,40595,40640,40642,40685,40915,40918,40919,40920,
   40922,40928,40929,40931,40933,40935,40957,40958,40959,40961,40967,40968,40970,40972,40974,41069,
   41070,41072,41078,41079,41081,41083,41085,41105,41107,41113,41114,41116,41118,41120,41141,41147,
   41148,41150,41152,41212,41213,41215,41217,41219,41384,41386,41388,41390,41411,41413,41415,41460,
   41462,41505,41737,41738,41739,41741,41747,41748,41750,41752,41754,41849,41850,41852,41858,41859,
   41861,41863,41865,41885,41887,41893,41894,41896,41898,41900,41921,41927,41928,41930,41932,41934,
   41992,41993,41997,41999,42164,42166,42168,42170,42191,42193,42195,42240,42242,42285,42590,42591,
   42593,42599,42600,42602,42604,42606,42626,42628,42634,42635,42637,42641,42662,42668,42669,42673,
   42675,42733,42734,42736,42738,42740,42905,42907,42909,42911,42932,42934,42936,42981,42983,43026,
   44625,44627,44633,44634,44636,44638,44640,44661,44667,44668,44670,44672,44674,44732,44733,44735,
   44737,44739,44904,44906,44908,44910,44931,44933,44935,44980,44982,45025,45256,45262,45263,45265,
   45267,45269,45327,45328,45330,45332,45334,45499,45501,45503,45505,45526,45528,45530,45575,45577,
   45620,45888,45889,45891,45893,45895,46060,46062,46064,46066,46087,46089,46091,46136,46138,46181,
   47084,47086,47088,47090,47111,47113,47115,47160,47162,47205,49471,49473,49475,49520,49522,49565,
   49820,49822,49865,50394],[23,26,31,32,41,42,44,89,90,91,92,93,94,107,156,158,163,166,
   173,177,1289,1290,1291,1292,1293,1296,1298,1300,1306,1309,1311,1313,1333,1334,1335,1336,1339,
   1340,1341,1343,1349,1350,1352,1354,1356,1376,1377,1378,1381,1382,1383,1385,1392,1394,1396,
   1398,1418,1419,1422,1423,1432,1433,1435,1459,1462,1463,1464,1466,1473,1475,1477,1479,1501,
   1502,1503,1505,1511,1512,1514,1516,1518,1613,1614,1616,1622,1623,1625,1627,1629,1649,1651,
   1657,1658,1660,1662,1664,1685,1691,1692,1694,1696,1698,1756,1757,1759,1761,1763,1928,1930,
   1932,1934,1955,1957,1959,2004,2006,2049,2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,
   2373,2383,2384,3500,3501,3502,3503,3504,3507,3508,3509,3511,3517,3518,3520,3522,3524,3544,
   3545,3546,3547,3550,3551,3552,3554,3560,3561,3563,3565,3567,3587,3588,3589,3592,3593,3594,
   3596,3602,3603,3605,3607,3609,3629,3630,3633,3634,3635,3637,3643,3644,3646,3648,3650,3670,
   3673,3674,3675,3677,3683,3684,3688,3690,3712,3713,3714,3716,3722,3723,3727,3729,3824,3825,
   3827,3833,3834,3836,3838,3840,3860,3862,3868,3869,3871,3873,3875,3896,3902,3903,3907,3909,
   3967,3968,3972,3974,4139,4141,4143,4145,4166,4168,4170,4215,4217,4260,4510,4511,4512,4518,
   4528,4529,5645,5646,5647,5648,5649,5652,5653,5654,5656,5662,5663,5665,5667,5669,5689,5690,
   5691,5692,5695,5696,5697,5699,5705,5706,5708,5710,5712,5732,5733,5734,5737,5738,5739,5741,
   5747,5748,5750,5752,5754,5774,5775,5778,5779,5780,5782,5788,5789,5791,5793,5795,5815,5818,
   5819,5820,5822,5828,5829,5831,5833,5835,5857,5861,5867,5868,5874,5969,5970,5972,5978,5979,
   5981,5983,5985,6005,6007,6013,6014,6016,6018,6020,6041,6047,6048,6050,6052,6054,6112,6113,
   6115,6117,6119,6284,6286,6288,6290,6311,6313,6315,6360,6362,6405,7725,7726,7727,7728,7729,
   7732,7733,7734,7736,7742,7743,7745,7747,7749,7769,7770,7771,7772,7775,7776,7777,7779,7785,
   7786,7788,7790,7792,7812,7813,7814,7817,7818,7819,7821,7827,7828,7830,7832,7834,7854,7855,
   7858,7859,7862,7868,7869,7871,7873,7875,7895,7898,7899,7900,7902,7908,7909,7911,7913,7915,
   7937,7938,7941,7947,7948,7950,7952,7954,8049,8050,8052,8058,8059,8061,8063,8065,8085,8087,
   8093,8094,8096,8098,8100,8121,8127,8128,8132,8192,8193,8195,8197,8199,8364,8366,8368,8370,
   8391,8393,8395,8440,8442,8485,38205,38206,38207,38208,38211,38212,38213,38215,38221,38222,
   38224,38226,38228,38248,38249,38250,38253,38254,38255,38257,38263,38264,38266,38268,38270,38290,
   38291,38294,38295,38296,38298,38304,38305,38307,38309,38311,38331,38334,38335,38336,38338,38344,
   38345,38347,38349,38351,38373,38374,38375,38377,38383,38384,38386,38388,38390,38485,38486,38488,
   38494,38495,38497,38499,38501,38521,38523,38529,38532,38534,38536,38557,38563,38564,38566,38568,
   38570,38628,38629,38631,38633,38635,38800,38802,38804,38806,38827,38829,38831,38876,38878,38921,
   39151,39152,39153,39156,39157,39158,39160,39166,39167,39169,39171,39173,39193,39194,39197,39198,
   39199,39201,39207,39208,39210,39212,39214,39234,39237,39238,39239,39241,39247,39248,39250,39252,
   39254,39276,39277,39278,39280,39286,39287,39289,39291,39293,39388,39389,39391,39397,39398,39400,
   39402,39424,39426,39432,39433,39435,39437,39439,39460,39466,39467,39469,39471,39473,39531,39534,
   39536,39538,39703,39705,39707,39709,39730,39732,39734,39779,39781,39824,40054,40055,40058,40059,
   40060,40062,40068,40069,40071,40073,40075,40095,40098,40099,40100,40102,40109,40111,40113,40115,
   40137,40138,40139,40141,40147,40148,40150,40152,40154,40249,40250,40252,40258,40259,40261,40265,
   40285,40287,40293,40294,40296,40298,40300,40321,40327,40328,40330,40332,40334,40392,40393,40395,
   40397,40399,40564,40566,40568,40570,40591,40593,40595,40640,40642,40685,40915,40918,40919,40920,
   40922,40928,40929,40931,40933,40935,40957,40958,40959,40961,40967,40968,40970,40972,40974,41069,
   41070,41072,41078,41079,41081,41083,41085,41105,41107,41113,41114,41116,41118,41120,41141,41147,
   41148,41150,41152,41212,41213,41215,41217,41219,41384,41386,41388,41390,41411,41413,41415,41460,
   41462,41505,41737,41738,41739,41741,41747,41748,41750,41752,41754,41849,41850,41852,41858,41859,
   41861,41863,41865,41885,41887,41893,41894,41896,41898,41900,41921,41927,41928,41930,41932,41934,
   41992,41993,41997,41999,42164,42166,42168,42170,42191,42193,42195,42240,42242,42285,42590,42591,
   42593,42599,42600,42602,42604,42606,42626,42628,42634,42635,42637,42641,42662,42668,42669,42673,
   42675,42733,42734,42736,42738,42740,42905,42907,42909,42911,42932,42934,42936,42981,42983,43026,
   44625,44627,44633,44634,44636,44638,44640,44661,44667,44668,44670,44672,44674,44732,44733,44735,
   44737,44739,44904,44906,44908,44910,44931,44933,44935,44980,44982,45025,45256,45262,45263,45265,
   45267,45269,45327,45328,45330,45332,45334,45499,45501,45503,45505,45526,45528,45530,45575,45577,
   45620,45888,45889,45891,45893,45895,46060,46062,46064,46066,46087,46089,46091,46136,46138,46181,
   47084,47086,47088,47090,47111,47113,47115,47160,47162,47205,49471,49473,49475,49520,49522,49565,
   49820,49822,49865,50394],[2279,3714,3725,3905,5859,5870,6050,7939,7950,8130,42671],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,3501,3505,3506,3507,3513,
   3514,3517,3518,3527,3528,3544,3548,3549,3550,3556,3557,3560,3561,3570,3571,3590,3591,3592,
   3598,3599,3602,3603,3612,3613,3749,3750,3756,3757,3770,3771,3787,3793,3794,3829,3830,3833,
   3834,3843,3844,4025,4038,4039,4139,4354,4510,4511,4512,4518,4528,4529,5645,5646,5650,5651,
   5652,5658,5659,5662,5663,5672,5673,5689,5693,5694,5695,5701,5702,5705,5706,5715,5716,5735,
   5736,5737,5743,5744,5747,5748,5757,5758,5894,5902,5905,5916,5939,5942,5953,5978,5979,6170,
   6173,6183,6184,6202,6212,6213,6284,6293,6294,6499,7725,7726,7730,7731,7732,7738,7739,7742,
   7743,7752,7753,7769,7773,7774,7775,7781,7782,7785,7786,7795,7796,7815,7816,7817,7823,7824,
   7827,7828,7837,7838,7974,7986,7995,7996,8018,8019,8023,8032,8033,8058,8059,8250,8254,8263,
   8283,8292,8364,8398,8399,8579,38205,38209,38210,38211,38217,38218,38221,38222,38231,38232,
   38251,38252,38253,38259,38260,38263,38264,38273,38274,38410,38411,38417,38418,38431,38432,38448,
   38454,38455,38468,38469,38490,38491,38494,38495,38504,38505,38686,38699,38700,38728,38729,38800,
   39015,39154,39155,39156,39162,39163,39166,39167,39176,39177,39313,39320,39321,39324,39334,39335,
   39357,39358,39361,39371,39372,39397,39398,39589,39592,39602,39603,39621,39631,39632,39703,39712,
   39713,39918,40174,40181,40182,40186,40195,40196,40218,40219,40223,40232,40233,40258,40259,40450,
   40454,40463,40464,40483,40492,40493,40564,40598,40599,40779,43262,43263,43266,43276,43277,43298,
   43494,43507,43508,43536,43537,43643,43823,43965,44160,44173,44174,44202,44203,44308,44489,44904,
   45119,47903,47912,47913,47993,48199,48400,48605],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,3501,3505,3506,3507,3513,
   3514,3517,3518,3527,3528,3544,3548,3549,3550,3556,3557,3560,3561,3570,3571,3590,3591,3592,
   3598,3599,3602,3603,3612,3613,3749,3750,3756,3757,3770,3771,3787,3793,3794,3829,3830,3833,
   3834,3843,3844,4025,4038,4039,4139,4354,4510,4511,4512,4518,4528,4529,5645,5646,5650,5651,
   5652,5658,5659,5662,5663,5672,5673,5689,5693,5694,5695,5701,5702,5705,5706,5715,5716,5735,
   5736,5737,5743,5744,5747,5748,5757,5758,5894,5902,5905,5916,5939,5942,5953,5978,5979,6170,
   6173,6183,6184,6202,6212,6213,6284,6293,6294,6499,7725,7726,7730,7731,7732,7738,7739,7742,
   7743,7752,7753,7769,7773,7774,7775,7781,7782,7785,7786,7795,7796,7815,7816,7817,7823,7824,
   7827,7828,7837,7838,7974,7986,7995,7996,8018,8019,8023,8032,8033,8058,8059,8250,8254,8263,
   8283,8292,8364,8398,8399,8579,38205,38209,38210,38211,38217,38218,38221,38222,38231,38232,
   38251,38252,38253,38259,38260,38263,38264,38273,38274,38410,38411,38417,38418,38431,38432,38448,
   38454,38455,38468,38469,38490,38491,38494,38495,38504,38505,38686,38699,38700,38728,38729,38800,
   39015,39154,39155,39156,39162,39163,39166,39167,39176,39177,39313,39320,39321,39324,39334,39335,
   39357,39358,39361,39371,39372,39397,39398,39589,39592,39602,39603,39621,39631,39632,39703,39712,
   39713,39918,40174,40181,40182,40186,40195,40196,40218,40219,40223,40232,40233,40258,40259,40450,
   40454,40463,40464,40483,40492,40493,40564,40598,40599,40779,43262,43263,43266,43276,43277,43298,
   43494,43507,43508,43536,43537,43643,43823,43965,44160,44173,44174,44202,44203,44308,44489,44904,
   45119,47903,47912,47913,47993,48199,48400,48605],
 [2279,3500,3501,3507,3517,3518,3544,3550,3592,3833,3834,4139,5645,5646,5662,5689,5695,5705,5706,
   5747,5978,5979,6284,7725,7726,7743,7769,7786,7817,7827,7828,8058,8059,8364,38205,38211,38221,
   38222,38253,38263,38264,38494,38495,38800,39156,39166,39167,39397,39398,39703,40258,40259,40564,
   44904],[23,26,31,32,41,42,44,89,90,91,92,93,94,107,156,158,163,166,173,177,1289,1290,
   1291,1292,1293,1296,1298,1300,1306,1309,1311,1313,1333,1334,1335,1336,1339,1340,1341,1343,
   1349,1350,1352,1354,1356,1376,1377,1378,1381,1382,1383,1385,1392,1394,1396,1398,1418,1419,
   1422,1423,1432,1433,1435,1459,1462,1463,1464,1466,1473,1475,1477,1479,1501,1502,1503,1505,
   1511,1512,1514,1516,1518,1613,1614,1616,1622,1623,1625,1627,1629,1649,1651,1657,1658,1660,
   1662,1664,1685,1691,1692,1694,1696,1698,1756,1757,1759,1761,1763,1928,1930,1932,1934,1955,
   1957,1959,2004,2006,2049,2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,
   3500,3501,3502,3503,3504,3507,3508,3509,3511,3517,3518,3520,3522,3524,3544,3545,3546,3547,
   3550,3551,3552,3554,3560,3561,3563,3565,3567,3587,3588,3589,3592,3593,3594,3596,3602,3603,
   3605,3607,3609,3629,3630,3633,3634,3635,3637,3643,3644,3646,3648,3650,3670,3673,3674,3675,
   3677,3683,3684,3688,3690,3712,3713,3714,3716,3722,3723,3727,3729,3824,3825,3827,3833,3834,
   3836,3838,3840,3860,3862,3868,3869,3871,3873,3875,3896,3902,3903,3907,3909,3967,3968,3972,
   3974,4139,4141,4143,4145,4166,4168,4170,4215,4217,4260,4510,4511,4512,4518,4528,4529,5645,
   5646,5647,5648,5649,5652,5653,5654,5656,5662,5663,5665,5667,5669,5689,5690,5691,5692,5695,
   5696,5697,5699,5705,5706,5708,5710,5712,5732,5733,5734,5737,5738,5739,5741,5747,5748,5750,
   5752,5754,5774,5775,5778,5779,5780,5782,5788,5789,5791,5793,5795,5815,5818,5819,5820,5822,
   5828,5829,5831,5833,5835,5857,5861,5867,5868,5874,5969,5970,5972,5978,5979,5981,5983,5985,
   6005,6007,6013,6014,6016,6018,6020,6041,6047,6048,6050,6052,6054,6112,6113,6115,6117,6119,
   6284,6286,6288,6290,6311,6313,6315,6360,6362,6405,7725,7726,7727,7728,7729,7732,7733,7734,
   7736,7742,7743,7745,7747,7749,7769,7770,7771,7772,7775,7776,7777,7779,7785,7786,7788,7790,
   7792,7812,7813,7814,7817,7818,7819,7821,7827,7828,7830,7832,7834,7854,7855,7858,7859,7862,
   7868,7869,7871,7873,7875,7895,7898,7899,7900,7902,7908,7909,7911,7913,7915,7937,7938,7941,
   7947,7948,7950,7952,7954,8049,8050,8052,8058,8059,8061,8063,8065,8085,8087,8093,8094,8096,
   8098,8100,8121,8127,8128,8132,8192,8193,8195,8197,8199,8364,8366,8368,8370,8391,8393,8395,
   8440,8442,8485,38205,38206,38207,38208,38211,38212,38213,38215,38221,38222,38224,38226,38228,
   38248,38249,38250,38253,38254,38255,38257,38263,38264,38266,38268,38270,38290,38291,38294,38295,
   38296,38298,38304,38305,38307,38309,38311,38331,38334,38335,38336,38338,38344,38345,38347,38349,
   38351,38373,38374,38375,38377,38383,38384,38386,38388,38390,38485,38486,38488,38494,38495,38497,
   38499,38501,38521,38523,38529,38532,38534,38536,38557,38563,38564,38566,38568,38570,38628,38629,
   38631,38633,38635,38800,38802,38804,38806,38827,38829,38831,38876,38878,38921,39151,39152,39153,
   39156,39157,39158,39160,39166,39167,39169,39171,39173,39193,39194,39197,39198,39199,39201,39207,
   39208,39210,39212,39214,39234,39237,39238,39239,39241,39247,39248,39250,39252,39254,39276,39277,
   39278,39280,39286,39287,39289,39291,39293,39388,39389,39391,39397,39398,39400,39402,39424,39426,
   39432,39433,39435,39437,39439,39460,39466,39467,39469,39471,39473,39531,39534,39536,39538,39703,
   39705,39707,39709,39730,39732,39734,39779,39781,39824,40054,40055,40058,40059,40060,40062,40068,
   40069,40071,40073,40075,40095,40098,40099,40100,40102,40109,40111,40113,40115,40137,40138,40139,
   40141,40147,40148,40150,40152,40154,40249,40250,40252,40258,40259,40261,40265,40285,40287,40293,
   40294,40296,40298,40300,40321,40327,40328,40330,40332,40334,40392,40393,40395,40397,40399,40564,
   40566,40568,40570,40591,40593,40595,40640,40642,40685,40915,40918,40919,40920,40922,40928,40929,
   40931,40933,40935,40957,40958,40959,40961,40967,40968,40970,40972,40974,41069,41070,41072,41078,
   41079,41081,41083,41085,41105,41107,41113,41114,41116,41118,41120,41141,41147,41148,41150,41152,
   41212,41213,41215,41217,41219,41384,41386,41388,41390,41411,41413,41415,41460,41462,41505,41737,
   41738,41739,41741,41747,41748,41750,41752,41754,41849,41850,41852,41858,41859,41861,41863,41865,
   41885,41887,41893,41894,41896,41898,41900,41921,41927,41928,41930,41932,41934,41992,41993,41997,
   41999,42164,42166,42168,42170,42191,42193,42195,42240,42242,42285,42590,42591,42593,42599,42600,
   42602,42604,42606,42626,42628,42634,42635,42637,42641,42662,42668,42669,42673,42675,42733,42734,
   42736,42738,42740,42905,42907,42909,42911,42932,42934,42936,42981,42983,43026,44625,44627,44633,
   44634,44636,44638,44640,44661,44667,44668,44670,44672,44674,44732,44733,44735,44737,44739,44904,
   44906,44908,44910,44931,44933,44935,44980,44982,45025,45256,45262,45263,45265,45267,45269,45327,
   45328,45330,45332,45334,45499,45501,45503,45505,45526,45528,45530,45575,45577,45620,45888,45889,
   45891,45893,45895,46060,46062,46064,46066,46087,46089,46091,46136,46138,46181,47084,47086,47088,
   47090,47111,47113,47115,47160,47162,47205,49471,49473,49475,49520,49522,49565,49820,49822,49865,
   50394],[2279,3714,3725,3905,5859,5870,6050,7939,7950,8130,42671],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,3501,3507,3510,3512,3517,
   3518,3519,3523,3525,3526,3544,3550,3560,3561,3592,3602,3603,3826,3828,3833,3834,3835,3839,
   3841,3842,3930,3935,3936,3937,3941,3998,3999,4000,4004,4139,4140,4144,4146,4147,4165,4169,
   4171,4172,4193,4195,4196,4281,4282,4319,4510,4511,4512,4518,4528,4529,5645,5646,5652,5662,
   5663,5689,5695,5698,5700,5705,5706,5707,5711,5713,5714,5737,5747,5748,5971,5973,5978,5979,
   5980,5984,5986,5987,6075,6080,6081,6086,6089,6143,6144,6145,6149,6151,6152,6284,6285,6289,
   6291,6292,6310,6314,6316,6317,6340,6341,6427,6464,7725,7726,7732,7742,7743,7769,7775,7785,
   7786,7817,7820,7822,7827,7828,7829,7833,7835,7836,8051,8053,8058,8059,8060,8064,8066,8067,
   8155,8160,8161,8162,8166,8168,8169,8223,8224,8225,8231,8364,8365,8369,8371,8372,8390,8394,
   8396,8397,8420,8506,8507,8544,38205,38211,38221,38222,38253,38263,38264,38487,38489,38494,
   38495,38496,38500,38502,38503,38591,38800,38854,38980,39156,39166,39167,39397,39398,39499,39505,
   39562,39571,39703,39704,39708,39710,39711,39759,40258,40259,40361,40368,40424,40425,40564,40590,
   40594,40596,40597,40707,44695,44700,44701,44702,44706,44708,44709,44763,44764,44765,44769,44771,
   44772,44904,44905,44909,44911,44912,44930,44934,44936,44937,44958,44960,44961,45046,45047,45084,
   46447,46448,46449,46453,46455,46456,46588,46589,46593,46595,46596,46614,46618,46620,46621,46642,
   46644,46645,46730,46731,46768,47549,47550,47554,47556,47557,47575,47579,47581,47582,47603,47605,
   47606,47691,47692,47729,49470,49474,49476,49477,49498,49500,49501,49586,49587,49624,49798,49800,
   49801,49886,49887,49924,50162,50163,50200,51084],
 [23,26,31,32,41,42,44,89,90,91,92,93,94,107,156,158,163,166,173,177,1289,1290,1291,1292,
   1293,1296,1298,1300,1306,1309,1311,1313,1333,1334,1335,1336,1339,1340,1341,1343,1349,1350,
   1352,1354,1356,1376,1377,1378,1381,1382,1383,1385,1392,1394,1396,1398,1418,1419,1422,1423,
   1432,1433,1435,1459,1462,1463,1464,1466,1473,1475,1477,1479,1501,1502,1503,1505,1511,1512,
   1514,1516,1518,1613,1614,1616,1622,1623,1625,1627,1629,1649,1651,1657,1658,1660,1662,1664,
   1685,1691,1692,1694,1696,1698,1756,1757,1759,1761,1763,1928,1930,1932,1934,1955,1957,1959,
   2004,2006,2049,2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,3501,
   3502,3503,3504,3507,3508,3509,3511,3517,3518,3520,3522,3524,3544,3545,3546,3547,3550,3551,
   3552,3554,3560,3561,3563,3565,3567,3587,3588,3589,3592,3593,3594,3596,3602,3603,3605,3607,
   3609,3629,3630,3633,3634,3635,3637,3643,3644,3646,3648,3650,3670,3673,3674,3675,3677,3683,
   3684,3688,3690,3712,3713,3714,3716,3722,3723,3727,3729,3824,3825,3827,3833,3834,3836,3838,
   3840,3860,3862,3868,3869,3871,3873,3875,3896,3902,3903,3907,3909,3967,3968,3972,3974,4139,
   4141,4143,4145,4166,4168,4170,4215,4217,4260,4510,4511,4512,4518,4528,4529,5645,5646,5647,
   5648,5649,5652,5653,5654,5656,5662,5663,5665,5667,5669,5689,5690,5691,5692,5695,5696,5697,
   5699,5705,5706,5708,5710,5712,5732,5733,5734,5737,5738,5739,5741,5747,5748,5750,5752,5754,
   5774,5775,5778,5779,5780,5782,5788,5789,5791,5793,5795,5815,5818,5819,5820,5822,5828,5829,
   5831,5833,5835,5857,5861,5867,5868,5874,5969,5970,5972,5978,5979,5981,5983,5985,6005,6007,
   6013,6014,6016,6018,6020,6041,6047,6048,6050,6052,6054,6112,6113,6115,6117,6119,6284,6286,
   6288,6290,6311,6313,6315,6360,6362,6405,7725,7726,7727,7728,7729,7732,7733,7734,7736,7742,
   7743,7745,7747,7749,7769,7770,7771,7772,7775,7776,7777,7779,7785,7786,7788,7790,7792,7812,
   7813,7814,7817,7818,7819,7821,7827,7828,7830,7832,7834,7854,7855,7858,7859,7862,7868,7869,
   7871,7873,7875,7895,7898,7899,7900,7902,7908,7909,7911,7913,7915,7937,7938,7941,7947,7948,
   7950,7952,7954,8049,8050,8052,8058,8059,8061,8063,8065,8085,8087,8093,8094,8096,8098,8100,
   8121,8127,8128,8132,8192,8193,8195,8197,8199,8364,8366,8368,8370,8391,8393,8395,8440,8442,
   8485,38205,38206,38207,38208,38211,38212,38213,38215,38221,38222,38224,38226,38228,38248,38249,
   38250,38253,38254,38255,38257,38263,38264,38266,38268,38270,38290,38291,38294,38295,38296,38298,
   38304,38305,38307,38309,38311,38331,38334,38335,38336,38338,38344,38345,38347,38349,38351,38373,
   38374,38375,38377,38383,38384,38386,38388,38390,38485,38486,38488,38494,38495,38497,38499,38501,
   38521,38523,38529,38532,38534,38536,38557,38563,38564,38566,38568,38570,38628,38629,38631,38633,
   38635,38800,38802,38804,38806,38827,38829,38831,38876,38878,38921,39151,39152,39153,39156,39157,
   39158,39160,39166,39167,39169,39171,39173,39193,39194,39197,39198,39199,39201,39207,39208,39210,
   39212,39214,39234,39237,39238,39239,39241,39247,39248,39250,39252,39254,39276,39277,39278,39280,
   39286,39287,39289,39291,39293,39388,39389,39391,39397,39398,39400,39402,39424,39426,39432,39433,
   39435,39437,39439,39460,39466,39467,39469,39471,39473,39531,39534,39536,39538,39703,39705,39707,
   39709,39730,39732,39734,39779,39781,39824,40054,40055,40058,40059,40060,40062,40068,40069,40071,
   40073,40075,40095,40098,40099,40100,40102,40109,40111,40113,40115,40137,40138,40139,40141,40147,
   40148,40150,40152,40154,40249,40250,40252,40258,40259,40261,40265,40285,40287,40293,40294,40296,
   40298,40300,40321,40327,40328,40330,40332,40334,40392,40393,40395,40397,40399,40564,40566,40568,
   40570,40591,40593,40595,40640,40642,40685,40915,40918,40919,40920,40922,40928,40929,40931,40933,
   40935,40957,40958,40959,40961,40967,40968,40970,40972,40974,41069,41070,41072,41078,41079,41081,
   41083,41085,41105,41107,41113,41114,41116,41118,41120,41141,41147,41148,41150,41152,41212,41213,
   41215,41217,41219,41384,41386,41388,41390,41411,41413,41415,41460,41462,41505,41737,41738,41739,
   41741,41747,41748,41750,41752,41754,41849,41850,41852,41858,41859,41861,41863,41865,41885,41887,
   41893,41894,41896,41898,41900,41921,41927,41928,41930,41932,41934,41992,41993,41997,41999,42164,
   42166,42168,42170,42191,42193,42195,42240,42242,42285,42590,42591,42593,42599,42600,42602,42604,
   42606,42626,42628,42634,42635,42637,42641,42662,42668,42669,42673,42675,42733,42734,42736,42738,
   42740,42905,42907,42909,42911,42932,42934,42936,42981,42983,43026,44625,44627,44633,44634,44636,
   44638,44640,44661,44667,44668,44670,44672,44674,44732,44733,44735,44737,44739,44904,44906,44908,
   44910,44931,44933,44935,44980,44982,45025,45256,45262,45263,45265,45267,45269,45327,45328,45330,
   45332,45334,45499,45501,45503,45505,45526,45528,45530,45575,45577,45620,45888,45889,45891,45893,
   45895,46060,46062,46064,46066,46087,46089,46091,46136,46138,46181,47084,47086,47088,47090,47111,
   47113,47115,47160,47162,47205,49471,49473,49475,49520,49522,49565,49820,49822,49865,50394],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,3501,3507,3510,3512,3517,
   3518,3519,3523,3525,3526,3544,3550,3560,3561,3592,3602,3603,3826,3828,3833,3834,3835,3839,
   3841,3842,3930,3935,3936,3937,3941,3998,3999,4000,4004,4139,4140,4144,4146,4147,4165,4169,
   4171,4172,4193,4195,4196,4281,4282,4319,4510,4511,4512,4518,4528,4529,5645,5646,5652,5662,
   5663,5689,5695,5698,5700,5705,5706,5707,5711,5713,5714,5737,5747,5748,5971,5973,5978,5979,
   5980,5984,5986,5987,6075,6080,6081,6086,6089,6143,6144,6145,6149,6151,6152,6284,6285,6289,
   6291,6292,6310,6314,6316,6317,6340,6341,6427,6464,7725,7726,7732,7742,7743,7769,7775,7785,
   7786,7817,7820,7822,7827,7828,7829,7833,7835,7836,8051,8053,8058,8059,8060,8064,8066,8067,
   8155,8160,8161,8162,8166,8168,8169,8223,8224,8225,8231,8364,8365,8369,8371,8372,8390,8394,
   8396,8397,8420,8506,8507,8544,38205,38211,38221,38222,38253,38263,38264,38487,38489,38494,
   38495,38496,38500,38502,38503,38591,38800,38854,38980,39156,39166,39167,39397,39398,39499,39505,
   39562,39571,39703,39704,39708,39710,39711,39759,40258,40259,40361,40368,40424,40425,40564,40590,
   40594,40596,40597,40707,44695,44700,44701,44702,44706,44708,44709,44763,44764,44765,44769,44771,
   44772,44904,44905,44909,44911,44912,44930,44934,44936,44937,44958,44960,44961,45046,45047,45084,
   46447,46448,46449,46453,46455,46456,46588,46589,46593,46595,46596,46614,46618,46620,46621,46642,
   46644,46645,46730,46731,46768,47549,47550,47554,47556,47557,47575,47579,47581,47582,47603,47605,
   47606,47691,47692,47729,49470,49474,49476,49477,49498,49500,49501,49586,49587,49624,49798,49800,
   49801,49886,49887,49924,50162,50163,50200,51084],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,3501,3505,3506,3507,3513,
   3514,3517,3518,3527,3528,3544,3548,3549,3550,3556,3557,3560,3561,3570,3571,3590,3591,3592,
   3598,3599,3602,3603,3612,3613,3749,3750,3756,3757,3770,3771,3787,3793,3794,3829,3830,3833,
   3834,3843,3844,4025,4038,4039,4139,4354,4510,4511,4512,4518,4528,4529,5645,5646,5650,5651,
   5652,5658,5659,5662,5663,5672,5673,5689,5693,5694,5695,5701,5702,5705,5706,5715,5716,5735,
   5736,5737,5743,5744,5747,5748,5757,5758,5894,5902,5905,5916,5939,5942,5953,5978,5979,6170,
   6173,6183,6184,6202,6212,6213,6284,6293,6294,6499,7725,7726,7730,7731,7732,7738,7739,7742,
   7743,7752,7753,7769,7773,7774,7775,7781,7782,7785,7786,7795,7796,7815,7816,7817,7823,7824,
   7827,7828,7837,7838,7974,7986,7995,7996,8018,8019,8023,8032,8033,8058,8059,8250,8254,8263,
   8283,8292,8364,8398,8399,8579,38205,38209,38210,38211,38217,38218,38221,38222,38231,38232,
   38251,38252,38253,38259,38260,38263,38264,38273,38274,38410,38411,38417,38418,38431,38432,38448,
   38454,38455,38468,38469,38490,38491,38494,38495,38504,38505,38686,38699,38700,38728,38729,38800,
   39015,39154,39155,39156,39162,39163,39166,39167,39176,39177,39313,39320,39321,39324,39334,39335,
   39357,39358,39361,39371,39372,39397,39398,39589,39592,39602,39603,39621,39631,39632,39703,39712,
   39713,39918,40174,40181,40182,40186,40195,40196,40218,40219,40223,40232,40233,40258,40259,40450,
   40454,40463,40464,40483,40492,40493,40564,40598,40599,40779,43262,43263,43266,43276,43277,43298,
   43494,43507,43508,43536,43537,43643,43823,43965,44160,44173,44174,44202,44203,44308,44489,44904,
   45119,47903,47912,47913,47993,48199,48400,48605],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,3501,3505,3506,3507,3513,
   3514,3517,3518,3527,3528,3544,3548,3549,3550,3556,3557,3560,3561,3570,3571,3590,3591,3592,
   3598,3599,3602,3603,3612,3613,3749,3750,3756,3757,3770,3771,3787,3793,3794,3829,3830,3833,
   3834,3843,3844,4025,4038,4039,4139,4354,4510,4511,4512,4518,4528,4529,5645,5646,5650,5651,
   5652,5658,5659,5662,5663,5672,5673,5689,5693,5694,5695,5701,5702,5705,5706,5715,5716,5735,
   5736,5737,5743,5744,5747,5748,5757,5758,5894,5902,5905,5916,5939,5942,5953,5978,5979,6170,
   6173,6183,6184,6202,6212,6213,6284,6293,6294,6499,7725,7726,7730,7731,7732,7738,7739,7742,
   7743,7752,7753,7769,7773,7774,7775,7781,7782,7785,7786,7795,7796,7815,7816,7817,7823,7824,
   7827,7828,7837,7838,7974,7986,7995,7996,8018,8019,8023,8032,8033,8058,8059,8250,8254,8263,
   8283,8292,8364,8398,8399,8579,38205,38209,38210,38211,38217,38218,38221,38222,38231,38232,
   38251,38252,38253,38259,38260,38263,38264,38273,38274,38410,38411,38417,38418,38431,38432,38448,
   38454,38455,38468,38469,38490,38491,38494,38495,38504,38505,38686,38699,38700,38728,38729,38800,
   39015,39154,39155,39156,39162,39163,39166,39167,39176,39177,39313,39320,39321,39324,39334,39335,
   39357,39358,39361,39371,39372,39397,39398,39589,39592,39602,39603,39621,39631,39632,39703,39712,
   39713,39918,40174,40181,40182,40186,40195,40196,40218,40219,40223,40232,40233,40258,40259,40450,
   40454,40463,40464,40483,40492,40493,40564,40598,40599,40779,43262,43263,43266,43276,43277,43298,
   43494,43507,43508,43536,43537,43643,43823,43965,44160,44173,44174,44202,44203,44308,44489,44904,
   45119,47903,47912,47913,47993,48199,48400,48605],[2279],[2279],
 [2279,3500,3501,3507,3517,3518,3544,3550,3592,3833,3834,4139,5645,5646,5662,5689,5695,5705,5706,
   5747,5978,5979,6284,7725,7726,7743,7769,7786,7817,7827,7828,8058,8059,8364,38205,38211,38221,
   38222,38253,38263,38264,38494,38495,38800,39156,39166,39167,39397,39398,39703,40258,40259,40564,
   44904],[2279,3500,3501,3507,3517,3518,3544,3550,3592,3833,3834,4139,5645,5646,5662,5689,
   5695,5705,5706,5747,5978,5979,6284,7725,7726,7743,7769,7786,7817,7827,7828,8058,8059,8364,
   38205,38211,38221,38222,38253,38263,38264,38494,38495,38800,39156,39166,39167,39397,39398,39703,
   40258,40259,40564,44904],[2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,
   3500,3501,3507,3510,3512,3517,3518,3519,3523,3525,3526,3544,3550,3560,3561,3592,3602,3603,
   3826,3828,3833,3834,3835,3839,3841,3842,3930,3935,3936,3937,3941,3998,3999,4000,4004,4139,
   4140,4144,4146,4147,4165,4169,4171,4172,4193,4195,4196,4281,4282,4319,4510,4511,4512,4518,
   4528,4529,5645,5646,5652,5662,5663,5689,5695,5698,5700,5705,5706,5707,5711,5713,5714,5737,
   5747,5748,5971,5973,5978,5979,5980,5984,5986,5987,6075,6080,6081,6086,6089,6143,6144,6145,
   6149,6151,6152,6284,6285,6289,6291,6292,6310,6314,6316,6317,6340,6341,6427,6464,7725,7726,
   7732,7742,7743,7769,7775,7785,7786,7817,7820,7822,7827,7828,7829,7833,7835,7836,8051,8053,
   8058,8059,8060,8064,8066,8067,8155,8160,8161,8162,8166,8168,8169,8223,8224,8225,8231,8364,
   8365,8369,8371,8372,8390,8394,8396,8397,8420,8506,8507,8544,38205,38211,38221,38222,38253,
   38263,38264,38487,38489,38494,38495,38496,38500,38502,38503,38591,38800,38854,38980,39156,39166,
   39167,39397,39398,39499,39505,39562,39571,39703,39704,39708,39710,39711,39759,40258,40259,40361,
   40368,40424,40425,40564,40590,40594,40596,40597,40707,44695,44700,44701,44702,44706,44708,44709,
   44763,44764,44765,44769,44771,44772,44904,44905,44909,44911,44912,44930,44934,44936,44937,44958,
   44960,44961,45046,45047,45084,46447,46448,46449,46453,46455,46456,46588,46589,46593,46595,46596,
   46614,46618,46620,46621,46642,46644,46645,46730,46731,46768,47549,47550,47554,47556,47557,47575,
   47579,47581,47582,47603,47605,47606,47691,47692,47729,49470,49474,49476,49477,49498,49500,49501,
   49586,49587,49624,49798,49800,49801,49886,49887,49924,50162,50163,50200,51084],
 [2279,3714,3725,3905,5859,5870,6050,7939,7950,8130,42671],[2279],
 [23,26,31,32,41,42,44,89,90,91,92,93,94,107,156,158,163,166,173,177,1289,1290,1291,1292,
   1293,1296,1298,1300,1306,1309,1311,1313,1333,1334,1335,1336,1339,1340,1341,1343,1349,1350,
   1352,1354,1356,1376,1377,1378,1381,1382,1383,1385,1392,1394,1396,1398,1418,1419,1422,1423,
   1432,1433,1435,1459,1462,1463,1464,1466,1473,1475,1477,1479,1501,1502,1503,1505,1511,1512,
   1514,1516,1518,1613,1614,1616,1622,1623,1625,1627,1629,1649,1651,1657,1658,1660,1662,1664,
   1685,1691,1692,1694,1696,1698,1756,1757,1759,1761,1763,1928,1930,1932,1934,1955,1957,1959,
   2004,2006,2049,2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,3501,
   3502,3503,3504,3507,3508,3509,3511,3517,3518,3520,3522,3524,3544,3545,3546,3547,3550,3551,
   3552,3554,3560,3561,3563,3565,3567,3587,3588,3589,3592,3593,3594,3596,3602,3603,3605,3607,
   3609,3629,3630,3633,3634,3635,3637,3643,3644,3646,3648,3650,3670,3673,3674,3675,3677,3683,
   3684,3688,3690,3712,3713,3714,3716,3722,3723,3727,3729,3824,3825,3827,3833,3834,3836,3838,
   3840,3860,3862,3868,3869,3871,3873,3875,3896,3902,3903,3907,3909,3967,3968,3972,3974,4139,
   4141,4143,4145,4166,4168,4170,4215,4217,4260,4510,4511,4512,4518,4528,4529,5645,5646,5647,
   5648,5649,5652,5653,5654,5656,5662,5663,5665,5667,5669,5689,5690,5691,5692,5695,5696,5697,
   5699,5705,5706,5708,5710,5712,5732,5733,5734,5737,5738,5739,5741,5747,5748,5750,5752,5754,
   5774,5775,5778,5779,5780,5782,5788,5789,5791,5793,5795,5815,5818,5819,5820,5822,5828,5829,
   5831,5833,5835,5857,5861,5867,5868,5874,5969,5970,5972,5978,5979,5981,5983,5985,6005,6007,
   6013,6014,6016,6018,6020,6041,6047,6048,6050,6052,6054,6112,6113,6115,6117,6119,6284,6286,
   6288,6290,6311,6313,6315,6360,6362,6405,7725,7726,7727,7728,7729,7732,7733,7734,7736,7742,
   7743,7745,7747,7749,7769,7770,7771,7772,7775,7776,7777,7779,7785,7786,7788,7790,7792,7812,
   7813,7814,7817,7818,7819,7821,7827,7828,7830,7832,7834,7854,7855,7858,7859,7862,7868,7869,
   7871,7873,7875,7895,7898,7899,7900,7902,7908,7909,7911,7913,7915,7937,7938,7941,7947,7948,
   7950,7952,7954,8049,8050,8052,8058,8059,8061,8063,8065,8085,8087,8093,8094,8096,8098,8100,
   8121,8127,8128,8132,8192,8193,8195,8197,8199,8364,8366,8368,8370,8391,8393,8395,8440,8442,
   8485,38205,38206,38207,38208,38211,38212,38213,38215,38221,38222,38224,38226,38228,38248,38249,
   38250,38253,38254,38255,38257,38263,38264,38266,38268,38270,38290,38291,38294,38295,38296,38298,
   38304,38305,38307,38309,38311,38331,38334,38335,38336,38338,38344,38345,38347,38349,38351,38373,
   38374,38375,38377,38383,38384,38386,38388,38390,38485,38486,38488,38494,38495,38497,38499,38501,
   38521,38523,38529,38532,38534,38536,38557,38563,38564,38566,38568,38570,38628,38629,38631,38633,
   38635,38800,38802,38804,38806,38827,38829,38831,38876,38878,38921,39151,39152,39153,39156,39157,
   39158,39160,39166,39167,39169,39171,39173,39193,39194,39197,39198,39199,39201,39207,39208,39210,
   39212,39214,39234,39237,39238,39239,39241,39247,39248,39250,39252,39254,39276,39277,39278,39280,
   39286,39287,39289,39291,39293,39388,39389,39391,39397,39398,39400,39402,39424,39426,39432,39433,
   39435,39437,39439,39460,39466,39467,39469,39471,39473,39531,39534,39536,39538,39703,39705,39707,
   39709,39730,39732,39734,39779,39781,39824,40054,40055,40058,40059,40060,40062,40068,40069,40071,
   40073,40075,40095,40098,40099,40100,40102,40109,40111,40113,40115,40137,40138,40139,40141,40147,
   40148,40150,40152,40154,40249,40250,40252,40258,40259,40261,40265,40285,40287,40293,40294,40296,
   40298,40300,40321,40327,40328,40330,40332,40334,40392,40393,40395,40397,40399,40564,40566,40568,
   40570,40591,40593,40595,40640,40642,40685,40915,40918,40919,40920,40922,40928,40929,40931,40933,
   40935,40957,40958,40959,40961,40967,40968,40970,40972,40974,41069,41070,41072,41078,41079,41081,
   41083,41085,41105,41107,41113,41114,41116,41118,41120,41141,41147,41148,41150,41152,41212,41213,
   41215,41217,41219,41384,41386,41388,41390,41411,41413,41415,41460,41462,41505,41737,41738,41739,
   41741,41747,41748,41750,41752,41754,41849,41850,41852,41858,41859,41861,41863,41865,41885,41887,
   41893,41894,41896,41898,41900,41921,41927,41928,41930,41932,41934,41992,41993,41997,41999,42164,
   42166,42168,42170,42191,42193,42195,42240,42242,42285,42590,42591,42593,42599,42600,42602,42604,
   42606,42626,42628,42634,42635,42637,42641,42662,42668,42669,42673,42675,42733,42734,42736,42738,
   42740,42905,42907,42909,42911,42932,42934,42936,42981,42983,43026,44625,44627,44633,44634,44636,
   44638,44640,44661,44667,44668,44670,44672,44674,44732,44733,44735,44737,44739,44904,44906,44908,
   44910,44931,44933,44935,44980,44982,45025,45256,45262,45263,45265,45267,45269,45327,45328,45330,
   45332,45334,45499,45501,45503,45505,45526,45528,45530,45575,45577,45620,45888,45889,45891,45893,
   45895,46060,46062,46064,46066,46087,46089,46091,46136,46138,46181,47084,47086,47088,47090,47111,
   47113,47115,47160,47162,47205,49471,49473,49475,49520,49522,49565,49820,49822,49865,50394],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,3501,3507,3510,3512,3517,
   3518,3519,3523,3525,3526,3544,3550,3560,3561,3592,3602,3603,3826,3828,3833,3834,3835,3839,
   3841,3842,3930,3935,3936,3937,3941,3998,3999,4000,4004,4139,4140,4144,4146,4147,4165,4169,
   4171,4172,4193,4195,4196,4281,4282,4319,4510,4511,4512,4518,4528,4529,5645,5646,5652,5662,
   5663,5689,5695,5698,5700,5705,5706,5707,5711,5713,5714,5737,5747,5748,5971,5973,5978,5979,
   5980,5984,5986,5987,6075,6080,6081,6086,6089,6143,6144,6145,6149,6151,6152,6284,6285,6289,
   6291,6292,6310,6314,6316,6317,6340,6341,6427,6464,7725,7726,7732,7742,7743,7769,7775,7785,
   7786,7817,7820,7822,7827,7828,7829,7833,7835,7836,8051,8053,8058,8059,8060,8064,8066,8067,
   8155,8160,8161,8162,8166,8168,8169,8223,8224,8225,8231,8364,8365,8369,8371,8372,8390,8394,
   8396,8397,8420,8506,8507,8544,38205,38211,38221,38222,38253,38263,38264,38487,38489,38494,
   38495,38496,38500,38502,38503,38591,38800,38854,38980,39156,39166,39167,39397,39398,39499,39505,
   39562,39571,39703,39704,39708,39710,39711,39759,40258,40259,40361,40368,40424,40425,40564,40590,
   40594,40596,40597,40707,44695,44700,44701,44702,44706,44708,44709,44763,44764,44765,44769,44771,
   44772,44904,44905,44909,44911,44912,44930,44934,44936,44937,44958,44960,44961,45046,45047,45084,
   46447,46448,46449,46453,46455,46456,46588,46589,46593,46595,46596,46614,46618,46620,46621,46642,
   46644,46645,46730,46731,46768,47549,47550,47554,47556,47557,47575,47579,47581,47582,47603,47605,
   47606,47691,47692,47729,49470,49474,49476,49477,49498,49500,49501,49586,49587,49624,49798,49800,
   49801,49886,49887,49924,50162,50163,50200,51084],
 [23,26,31,32,41,42,44,89,90,91,92,93,94,107,156,158,163,166,173,177,1289,1290,1291,1292,
   1293,1296,1298,1300,1306,1309,1311,1313,1333,1334,1335,1336,1339,1340,1341,1343,1349,1350,
   1352,1354,1356,1376,1377,1378,1381,1382,1383,1385,1392,1394,1396,1398,1418,1419,1422,1423,
   1432,1433,1435,1459,1462,1463,1464,1466,1473,1475,1477,1479,1501,1502,1503,1505,1511,1512,
   1514,1516,1518,1613,1614,1616,1622,1623,1625,1627,1629,1649,1651,1657,1658,1660,1662,1664,
   1685,1691,1692,1694,1696,1698,1756,1757,1759,1761,1763,1928,1930,1932,1934,1955,1957,1959,
   2004,2006,2049,2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,3501,
   3502,3503,3504,3507,3508,3509,3511,3517,3518,3520,3522,3524,3544,3545,3546,3547,3550,3551,
   3552,3554,3560,3561,3563,3565,3567,3587,3588,3589,3592,3593,3594,3596,3602,3603,3605,3607,
   3609,3629,3630,3633,3634,3635,3637,3643,3644,3646,3648,3650,3670,3673,3674,3675,3677,3683,
   3684,3688,3690,3712,3713,3714,3716,3722,3723,3727,3729,3824,3825,3827,3833,3834,3836,3838,
   3840,3860,3862,3868,3869,3871,3873,3875,3896,3902,3903,3907,3909,3967,3968,3972,3974,4139,
   4141,4143,4145,4166,4168,4170,4215,4217,4260,4510,4511,4512,4518,4528,4529,5645,5646,5647,
   5648,5649,5652,5653,5654,5656,5662,5663,5665,5667,5669,5689,5690,5691,5692,5695,5696,5697,
   5699,5705,5706,5708,5710,5712,5732,5733,5734,5737,5738,5739,5741,5747,5748,5750,5752,5754,
   5774,5775,5778,5779,5780,5782,5788,5789,5791,5793,5795,5815,5818,5819,5820,5822,5828,5829,
   5831,5833,5835,5857,5861,5867,5868,5874,5969,5970,5972,5978,5979,5981,5983,5985,6005,6007,
   6013,6014,6016,6018,6020,6041,6047,6048,6050,6052,6054,6112,6113,6115,6117,6119,6284,6286,
   6288,6290,6311,6313,6315,6360,6362,6405,7725,7726,7727,7728,7729,7732,7733,7734,7736,7742,
   7743,7745,7747,7749,7769,7770,7771,7772,7775,7776,7777,7779,7785,7786,7788,7790,7792,7812,
   7813,7814,7817,7818,7819,7821,7827,7828,7830,7832,7834,7854,7855,7858,7859,7862,7868,7869,
   7871,7873,7875,7895,7898,7899,7900,7902,7908,7909,7911,7913,7915,7937,7938,7941,7947,7948,
   7950,7952,7954,8049,8050,8052,8058,8059,8061,8063,8065,8085,8087,8093,8094,8096,8098,8100,
   8121,8127,8128,8132,8192,8193,8195,8197,8199,8364,8366,8368,8370,8391,8393,8395,8440,8442,
   8485,38205,38206,38207,38208,38211,38212,38213,38215,38221,38222,38224,38226,38228,38248,38249,
   38250,38253,38254,38255,38257,38263,38264,38266,38268,38270,38290,38291,38294,38295,38296,38298,
   38304,38305,38307,38309,38311,38331,38334,38335,38336,38338,38344,38345,38347,38349,38351,38373,
   38374,38375,38377,38383,38384,38386,38388,38390,38485,38486,38488,38494,38495,38497,38499,38501,
   38521,38523,38529,38532,38534,38536,38557,38563,38564,38566,38568,38570,38628,38629,38631,38633,
   38635,38800,38802,38804,38806,38827,38829,38831,38876,38878,38921,39151,39152,39153,39156,39157,
   39158,39160,39166,39167,39169,39171,39173,39193,39194,39197,39198,39199,39201,39207,39208,39210,
   39212,39214,39234,39237,39238,39239,39241,39247,39248,39250,39252,39254,39276,39277,39278,39280,
   39286,39287,39289,39291,39293,39388,39389,39391,39397,39398,39400,39402,39424,39426,39432,39433,
   39435,39437,39439,39460,39466,39467,39469,39471,39473,39531,39534,39536,39538,39703,39705,39707,
   39709,39730,39732,39734,39779,39781,39824,40054,40055,40058,40059,40060,40062,40068,40069,40071,
   40073,40075,40095,40098,40099,40100,40102,40109,40111,40113,40115,40137,40138,40139,40141,40147,
   40148,40150,40152,40154,40249,40250,40252,40258,40259,40261,40265,40285,40287,40293,40294,40296,
   40298,40300,40321,40327,40328,40330,40332,40334,40392,40393,40395,40397,40399,40564,40566,40568,
   40570,40591,40593,40595,40640,40642,40685,40915,40918,40919,40920,40922,40928,40929,40931,40933,
   40935,40957,40958,40959,40961,40967,40968,40970,40972,40974,41069,41070,41072,41078,41079,41081,
   41083,41085,41105,41107,41113,41114,41116,41118,41120,41141,41147,41148,41150,41152,41212,41213,
   41215,41217,41219,41384,41386,41388,41390,41411,41413,41415,41460,41462,41505,41737,41738,41739,
   41741,41747,41748,41750,41752,41754,41849,41850,41852,41858,41859,41861,41863,41865,41885,41887,
   41893,41894,41896,41898,41900,41921,41927,41928,41930,41932,41934,41992,41993,41997,41999,42164,
   42166,42168,42170,42191,42193,42195,42240,42242,42285,42590,42591,42593,42599,42600,42602,42604,
   42606,42626,42628,42634,42635,42637,42641,42662,42668,42669,42673,42675,42733,42734,42736,42738,
   42740,42905,42907,42909,42911,42932,42934,42936,42981,42983,43026,44625,44627,44633,44634,44636,
   44638,44640,44661,44667,44668,44670,44672,44674,44732,44733,44735,44737,44739,44904,44906,44908,
   44910,44931,44933,44935,44980,44982,45025,45256,45262,45263,45265,45267,45269,45327,45328,45330,
   45332,45334,45499,45501,45503,45505,45526,45528,45530,45575,45577,45620,45888,45889,45891,45893,
   45895,46060,46062,46064,46066,46087,46089,46091,46136,46138,46181,47084,47086,47088,47090,47111,
   47113,47115,47160,47162,47205,49471,49473,49475,49520,49522,49565,49820,49822,49865,50394],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,3501,3507,3510,3512,3517,
   3518,3519,3523,3525,3526,3544,3550,3560,3561,3592,3602,3603,3826,3828,3833,3834,3835,3839,
   3841,3842,3930,3935,3936,3937,3941,3998,3999,4000,4004,4139,4140,4144,4146,4147,4165,4169,
   4171,4172,4193,4195,4196,4281,4282,4319,4510,4511,4512,4518,4528,4529,5645,5646,5652,5662,
   5663,5689,5695,5698,5700,5705,5706,5707,5711,5713,5714,5737,5747,5748,5971,5973,5978,5979,
   5980,5984,5986,5987,6075,6080,6081,6086,6089,6143,6144,6145,6149,6151,6152,6284,6285,6289,
   6291,6292,6310,6314,6316,6317,6340,6341,6427,6464,7725,7726,7732,7742,7743,7769,7775,7785,
   7786,7817,7820,7822,7827,7828,7829,7833,7835,7836,8051,8053,8058,8059,8060,8064,8066,8067,
   8155,8160,8161,8162,8166,8168,8169,8223,8224,8225,8231,8364,8365,8369,8371,8372,8390,8394,
   8396,8397,8420,8506,8507,8544,38205,38211,38221,38222,38253,38263,38264,38487,38489,38494,
   38495,38496,38500,38502,38503,38591,38800,38854,38980,39156,39166,39167,39397,39398,39499,39505,
   39562,39571,39703,39704,39708,39710,39711,39759,40258,40259,40361,40368,40424,40425,40564,40590,
   40594,40596,40597,40707,44695,44700,44701,44702,44706,44708,44709,44763,44764,44765,44769,44771,
   44772,44904,44905,44909,44911,44912,44930,44934,44936,44937,44958,44960,44961,45046,45047,45084,
   46447,46448,46449,46453,46455,46456,46588,46589,46593,46595,46596,46614,46618,46620,46621,46642,
   46644,46645,46730,46731,46768,47549,47550,47554,47556,47557,47575,47579,47581,47582,47603,47605,
   47606,47691,47692,47729,49470,49474,49476,49477,49498,49500,49501,49586,49587,49624,49798,49800,
   49801,49886,49887,49924,50162,50163,50200,51084],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,3501,3507,3510,3512,3517,
   3518,3519,3523,3525,3526,3544,3550,3560,3561,3592,3602,3603,3826,3828,3833,3834,3835,3839,
   3841,3842,3930,3935,3936,3937,3941,3998,3999,4000,4004,4139,4140,4144,4146,4147,4165,4169,
   4171,4172,4193,4195,4196,4281,4282,4319,4510,4511,4512,4518,4528,4529,5645,5646,5652,5662,
   5663,5689,5695,5698,5700,5705,5706,5707,5711,5713,5714,5737,5747,5748,5971,5973,5978,5979,
   5980,5984,5986,5987,6075,6080,6081,6086,6089,6143,6144,6145,6149,6151,6152,6284,6285,6289,
   6291,6292,6310,6314,6316,6317,6340,6341,6427,6464,7725,7726,7732,7742,7743,7769,7775,7785,
   7786,7817,7820,7822,7827,7828,7829,7833,7835,7836,8051,8053,8058,8059,8060,8064,8066,8067,
   8155,8160,8161,8162,8166,8168,8169,8223,8224,8225,8231,8364,8365,8369,8371,8372,8390,8394,
   8396,8397,8420,8506,8507,8544,38205,38211,38221,38222,38253,38263,38264,38487,38489,38494,
   38495,38496,38500,38502,38503,38591,38800,38854,38980,39156,39166,39167,39397,39398,39499,39505,
   39562,39571,39703,39704,39708,39710,39711,39759,40258,40259,40361,40368,40424,40425,40564,40590,
   40594,40596,40597,40707,44695,44700,44701,44702,44706,44708,44709,44763,44764,44765,44769,44771,
   44772,44904,44905,44909,44911,44912,44930,44934,44936,44937,44958,44960,44961,45046,45047,45084,
   46447,46448,46449,46453,46455,46456,46588,46589,46593,46595,46596,46614,46618,46620,46621,46642,
   46644,46645,46730,46731,46768,47549,47550,47554,47556,47557,47575,47579,47581,47582,47603,47605,
   47606,47691,47692,47729,49470,49474,49476,49477,49498,49500,49501,49586,49587,49624,49798,49800,
   49801,49886,49887,49924,50162,50163,50200,51084],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,3501,3505,3506,3507,3513,
   3514,3517,3518,3527,3528,3544,3548,3549,3550,3556,3557,3560,3561,3570,3571,3590,3591,3592,
   3598,3599,3602,3603,3612,3613,3749,3750,3756,3757,3770,3771,3787,3793,3794,3829,3830,3833,
   3834,3843,3844,4025,4038,4039,4139,4354,4510,4511,4512,4518,4528,4529,5645,5646,5650,5651,
   5652,5658,5659,5662,5663,5672,5673,5689,5693,5694,5695,5701,5702,5705,5706,5715,5716,5735,
   5736,5737,5743,5744,5747,5748,5757,5758,5894,5902,5905,5916,5939,5942,5953,5978,5979,6170,
   6173,6183,6184,6202,6212,6213,6284,6293,6294,6499,7725,7726,7730,7731,7732,7738,7739,7742,
   7743,7752,7753,7769,7773,7774,7775,7781,7782,7785,7786,7795,7796,7815,7816,7817,7823,7824,
   7827,7828,7837,7838,7974,7986,7995,7996,8018,8019,8023,8032,8033,8058,8059,8250,8254,8263,
   8283,8292,8364,8398,8399,8579,38205,38209,38210,38211,38217,38218,38221,38222,38231,38232,
   38251,38252,38253,38259,38260,38263,38264,38273,38274,38410,38411,38417,38418,38431,38432,38448,
   38454,38455,38468,38469,38490,38491,38494,38495,38504,38505,38686,38699,38700,38728,38729,38800,
   39015,39154,39155,39156,39162,39163,39166,39167,39176,39177,39313,39320,39321,39324,39334,39335,
   39357,39358,39361,39371,39372,39397,39398,39589,39592,39602,39603,39621,39631,39632,39703,39712,
   39713,39918,40174,40181,40182,40186,40195,40196,40218,40219,40223,40232,40233,40258,40259,40450,
   40454,40463,40464,40483,40492,40493,40564,40598,40599,40779,43262,43263,43266,43276,43277,43298,
   43494,43507,43508,43536,43537,43643,43823,43965,44160,44173,44174,44202,44203,44308,44489,44904,
   45119,47903,47912,47913,47993,48199,48400,48605],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,3501,3505,3506,3507,3513,
   3514,3517,3518,3527,3528,3544,3548,3549,3550,3556,3557,3560,3561,3570,3571,3590,3591,3592,
   3598,3599,3602,3603,3612,3613,3749,3750,3756,3757,3770,3771,3787,3793,3794,3829,3830,3833,
   3834,3843,3844,4025,4038,4039,4139,4354,4510,4511,4512,4518,4528,4529,5645,5646,5650,5651,
   5652,5658,5659,5662,5663,5672,5673,5689,5693,5694,5695,5701,5702,5705,5706,5715,5716,5735,
   5736,5737,5743,5744,5747,5748,5757,5758,5894,5902,5905,5916,5939,5942,5953,5978,5979,6170,
   6173,6183,6184,6202,6212,6213,6284,6293,6294,6499,7725,7726,7730,7731,7732,7738,7739,7742,
   7743,7752,7753,7769,7773,7774,7775,7781,7782,7785,7786,7795,7796,7815,7816,7817,7823,7824,
   7827,7828,7837,7838,7974,7986,7995,7996,8018,8019,8023,8032,8033,8058,8059,8250,8254,8263,
   8283,8292,8364,8398,8399,8579,38205,38209,38210,38211,38217,38218,38221,38222,38231,38232,
   38251,38252,38253,38259,38260,38263,38264,38273,38274,38410,38411,38417,38418,38431,38432,38448,
   38454,38455,38468,38469,38490,38491,38494,38495,38504,38505,38686,38699,38700,38728,38729,38800,
   39015,39154,39155,39156,39162,39163,39166,39167,39176,39177,39313,39320,39321,39324,39334,39335,
   39357,39358,39361,39371,39372,39397,39398,39589,39592,39602,39603,39621,39631,39632,39703,39712,
   39713,39918,40174,40181,40182,40186,40195,40196,40218,40219,40223,40232,40233,40258,40259,40450,
   40454,40463,40464,40483,40492,40493,40564,40598,40599,40779,43262,43263,43266,43276,43277,43298,
   43494,43507,43508,43536,43537,43643,43823,43965,44160,44173,44174,44202,44203,44308,44489,44904,
   45119,47903,47912,47913,47993,48199,48400,48605],[2279],[2279],[2279],[2279],[2279],
 [2279],[2279],[2279],[2279],[2279],[2279],[2279],[2279],[2279],[2279],[2279],
 [2279],[2279],[2279],[2279],[2279],[2279],[2279],[2279],[2279],[2279],[2279],
 [2279],[2279],[2279],[2279],[2279],[2279],[2279],[2279],
 [2279,3500,3501,3507,3517,3518,3544,3550,3592,3833,3834,4139,5645,5646,5662,5689,5695,5705,5706,
   5747,5978,5979,6284,7725,7726,7743,7769,7786,7817,7827,7828,8058,8059,8364,38205,38211,38221,
   38222,38253,38263,38264,38494,38495,38800,39156,39166,39167,39397,39398,39703,40258,40259,40564,
   44904],[2279,3500,3501,3507,3517,3518,3544,3550,3592,3833,3834,4139,5645,5646,5662,5689,
   5695,5705,5706,5747,5978,5979,6284,7725,7726,7743,7769,7786,7817,7827,7828,8058,8059,8364,
   38205,38211,38221,38222,38253,38263,38264,38494,38495,38800,39156,39166,39167,39397,39398,39703,
   40258,40259,40564,44904],[2279,3500,3501,3507,3517,3518,3544,3550,3592,3833,3834,4139,5645,
   5646,5662,5689,5695,5705,5706,5747,5978,5979,6284,7725,7726,7743,7769,7786,7817,7827,7828,
   8058,8059,8364,38205,38211,38221,38222,38253,38263,38264,38494,38495,38800,39156,39166,39167,
   39397,39398,39703,40258,40259,40564,44904],
 [23,26,31,32,41,42,44,89,90,91,92,93,94,107,156,158,163,166,173,177,1289,1290,1291,1292,
   1293,1296,1298,1300,1306,1309,1311,1313,1333,1334,1335,1336,1339,1340,1341,1343,1349,1350,
   1352,1354,1356,1376,1377,1378,1381,1382,1383,1385,1392,1394,1396,1398,1418,1419,1422,1423,
   1432,1433,1435,1459,1462,1463,1464,1466,1473,1475,1477,1479,1501,1502,1503,1505,1511,1512,
   1514,1516,1518,1613,1614,1616,1622,1623,1625,1627,1629,1649,1651,1657,1658,1660,1662,1664,
   1685,1691,1692,1694,1696,1698,1756,1757,1759,1761,1763,1928,1930,1932,1934,1955,1957,1959,
   2004,2006,2049,2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,3501,
   3502,3503,3504,3507,3508,3509,3511,3517,3518,3520,3522,3524,3544,3545,3546,3547,3550,3551,
   3552,3554,3560,3561,3563,3565,3567,3587,3588,3589,3592,3593,3594,3596,3602,3603,3605,3607,
   3609,3629,3630,3633,3634,3635,3637,3643,3644,3646,3648,3650,3670,3673,3674,3675,3677,3683,
   3684,3688,3690,3712,3713,3714,3716,3722,3723,3727,3729,3824,3825,3827,3833,3834,3836,3838,
   3840,3860,3862,3868,3869,3871,3873,3875,3896,3902,3903,3907,3909,3967,3968,3972,3974,4139,
   4141,4143,4145,4166,4168,4170,4215,4217,4260,4510,4511,4512,4518,4528,4529,5645,5646,5647,
   5648,5649,5652,5653,5654,5656,5662,5663,5665,5667,5669,5689,5690,5691,5692,5695,5696,5697,
   5699,5705,5706,5708,5710,5712,5732,5733,5734,5737,5738,5739,5741,5747,5748,5750,5752,5754,
   5774,5775,5778,5779,5780,5782,5788,5789,5791,5793,5795,5815,5818,5819,5820,5822,5828,5829,
   5831,5833,5835,5857,5861,5867,5868,5874,5969,5970,5972,5978,5979,5981,5983,5985,6005,6007,
   6013,6014,6016,6018,6020,6041,6047,6048,6050,6052,6054,6112,6113,6115,6117,6119,6284,6286,
   6288,6290,6311,6313,6315,6360,6362,6405,7725,7726,7727,7728,7729,7732,7733,7734,7736,7742,
   7743,7745,7747,7749,7769,7770,7771,7772,7775,7776,7777,7779,7785,7786,7788,7790,7792,7812,
   7813,7814,7817,7818,7819,7821,7827,7828,7830,7832,7834,7854,7855,7858,7859,7862,7868,7869,
   7871,7873,7875,7895,7898,7899,7900,7902,7908,7909,7911,7913,7915,7937,7938,7941,7947,7948,
   7950,7952,7954,8049,8050,8052,8058,8059,8061,8063,8065,8085,8087,8093,8094,8096,8098,8100,
   8121,8127,8128,8132,8192,8193,8195,8197,8199,8364,8366,8368,8370,8391,8393,8395,8440,8442,
   8485,38205,38206,38207,38208,38211,38212,38213,38215,38221,38222,38224,38226,38228,38248,38249,
   38250,38253,38254,38255,38257,38263,38264,38266,38268,38270,38290,38291,38294,38295,38296,38298,
   38304,38305,38307,38309,38311,38331,38334,38335,38336,38338,38344,38345,38347,38349,38351,38373,
   38374,38375,38377,38383,38384,38386,38388,38390,38485,38486,38488,38494,38495,38497,38499,38501,
   38521,38523,38529,38532,38534,38536,38557,38563,38564,38566,38568,38570,38628,38629,38631,38633,
   38635,38800,38802,38804,38806,38827,38829,38831,38876,38878,38921,39151,39152,39153,39156,39157,
   39158,39160,39166,39167,39169,39171,39173,39193,39194,39197,39198,39199,39201,39207,39208,39210,
   39212,39214,39234,39237,39238,39239,39241,39247,39248,39250,39252,39254,39276,39277,39278,39280,
   39286,39287,39289,39291,39293,39388,39389,39391,39397,39398,39400,39402,39424,39426,39432,39433,
   39435,39437,39439,39460,39466,39467,39469,39471,39473,39531,39534,39536,39538,39703,39705,39707,
   39709,39730,39732,39734,39779,39781,39824,40054,40055,40058,40059,40060,40062,40068,40069,40071,
   40073,40075,40095,40098,40099,40100,40102,40109,40111,40113,40115,40137,40138,40139,40141,40147,
   40148,40150,40152,40154,40249,40250,40252,40258,40259,40261,40265,40285,40287,40293,40294,40296,
   40298,40300,40321,40327,40328,40330,40332,40334,40392,40393,40395,40397,40399,40564,40566,40568,
   40570,40591,40593,40595,40640,40642,40685,40915,40918,40919,40920,40922,40928,40929,40931,40933,
   40935,40957,40958,40959,40961,40967,40968,40970,40972,40974,41069,41070,41072,41078,41079,41081,
   41083,41085,41105,41107,41113,41114,41116,41118,41120,41141,41147,41148,41150,41152,41212,41213,
   41215,41217,41219,41384,41386,41388,41390,41411,41413,41415,41460,41462,41505,41737,41738,41739,
   41741,41747,41748,41750,41752,41754,41849,41850,41852,41858,41859,41861,41863,41865,41885,41887,
   41893,41894,41896,41898,41900,41921,41927,41928,41930,41932,41934,41992,41993,41997,41999,42164,
   42166,42168,42170,42191,42193,42195,42240,42242,42285,42590,42591,42593,42599,42600,42602,42604,
   42606,42626,42628,42634,42635,42637,42641,42662,42668,42669,42673,42675,42733,42734,42736,42738,
   42740,42905,42907,42909,42911,42932,42934,42936,42981,42983,43026,44625,44627,44633,44634,44636,
   44638,44640,44661,44667,44668,44670,44672,44674,44732,44733,44735,44737,44739,44904,44906,44908,
   44910,44931,44933,44935,44980,44982,45025,45256,45262,45263,45265,45267,45269,45327,45328,45330,
   45332,45334,45499,45501,45503,45505,45526,45528,45530,45575,45577,45620,45888,45889,45891,45893,
   45895,46060,46062,46064,46066,46087,46089,46091,46136,46138,46181,47084,47086,47088,47090,47111,
   47113,47115,47160,47162,47205,49471,49473,49475,49520,49522,49565,49820,49822,49865,50394],
 [23,26,31,32,41,42,44,89,90,91,92,93,94,107,156,158,163,166,173,177,1289,1290,1291,1292,
   1293,1296,1298,1300,1306,1309,1311,1313,1333,1334,1335,1336,1339,1340,1341,1343,1349,1350,
   1352,1354,1356,1376,1377,1378,1381,1382,1383,1385,1392,1394,1396,1398,1418,1419,1422,1423,
   1432,1433,1435,1459,1462,1463,1464,1466,1473,1475,1477,1479,1501,1502,1503,1505,1511,1512,
   1514,1516,1518,1613,1614,1616,1622,1623,1625,1627,1629,1649,1651,1657,1658,1660,1662,1664,
   1685,1691,1692,1694,1696,1698,1756,1757,1759,1761,1763,1928,1930,1932,1934,1955,1957,1959,
   2004,2006,2049,2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,3501,
   3502,3503,3504,3507,3508,3509,3511,3517,3518,3520,3522,3524,3544,3545,3546,3547,3550,3551,
   3552,3554,3560,3561,3563,3565,3567,3587,3588,3589,3592,3593,3594,3596,3602,3603,3605,3607,
   3609,3629,3630,3633,3634,3635,3637,3643,3644,3646,3648,3650,3670,3673,3674,3675,3677,3683,
   3684,3688,3690,3712,3713,3714,3716,3722,3723,3727,3729,3824,3825,3827,3833,3834,3836,3838,
   3840,3860,3862,3868,3869,3871,3873,3875,3896,3902,3903,3907,3909,3967,3968,3972,3974,4139,
   4141,4143,4145,4166,4168,4170,4215,4217,4260,4510,4511,4512,4518,4528,4529,5645,5646,5647,
   5648,5649,5652,5653,5654,5656,5662,5663,5665,5667,5669,5689,5690,5691,5692,5695,5696,5697,
   5699,5705,5706,5708,5710,5712,5732,5733,5734,5737,5738,5739,5741,5747,5748,5750,5752,5754,
   5774,5775,5778,5779,5780,5782,5788,5789,5791,5793,5795,5815,5818,5819,5820,5822,5828,5829,
   5831,5833,5835,5857,5861,5867,5868,5874,5969,5970,5972,5978,5979,5981,5983,5985,6005,6007,
   6013,6014,6016,6018,6020,6041,6047,6048,6050,6052,6054,6112,6113,6115,6117,6119,6284,6286,
   6288,6290,6311,6313,6315,6360,6362,6405,7725,7726,7727,7728,7729,7732,7733,7734,7736,7742,
   7743,7745,7747,7749,7769,7770,7771,7772,7775,7776,7777,7779,7785,7786,7788,7790,7792,7812,
   7813,7814,7817,7818,7819,7821,7827,7828,7830,7832,7834,7854,7855,7858,7859,7862,7868,7869,
   7871,7873,7875,7895,7898,7899,7900,7902,7908,7909,7911,7913,7915,7937,7938,7941,7947,7948,
   7950,7952,7954,8049,8050,8052,8058,8059,8061,8063,8065,8085,8087,8093,8094,8096,8098,8100,
   8121,8127,8128,8132,8192,8193,8195,8197,8199,8364,8366,8368,8370,8391,8393,8395,8440,8442,
   8485,38205,38206,38207,38208,38211,38212,38213,38215,38221,38222,38224,38226,38228,38248,38249,
   38250,38253,38254,38255,38257,38263,38264,38266,38268,38270,38290,38291,38294,38295,38296,38298,
   38304,38305,38307,38309,38311,38331,38334,38335,38336,38338,38344,38345,38347,38349,38351,38373,
   38374,38375,38377,38383,38384,38386,38388,38390,38485,38486,38488,38494,38495,38497,38499,38501,
   38521,38523,38529,38532,38534,38536,38557,38563,38564,38566,38568,38570,38628,38629,38631,38633,
   38635,38800,38802,38804,38806,38827,38829,38831,38876,38878,38921,39151,39152,39153,39156,39157,
   39158,39160,39166,39167,39169,39171,39173,39193,39194,39197,39198,39199,39201,39207,39208,39210,
   39212,39214,39234,39237,39238,39239,39241,39247,39248,39250,39252,39254,39276,39277,39278,39280,
   39286,39287,39289,39291,39293,39388,39389,39391,39397,39398,39400,39402,39424,39426,39432,39433,
   39435,39437,39439,39460,39466,39467,39469,39471,39473,39531,39534,39536,39538,39703,39705,39707,
   39709,39730,39732,39734,39779,39781,39824,40054,40055,40058,40059,40060,40062,40068,40069,40071,
   40073,40075,40095,40098,40099,40100,40102,40109,40111,40113,40115,40137,40138,40139,40141,40147,
   40148,40150,40152,40154,40249,40250,40252,40258,40259,40261,40265,40285,40287,40293,40294,40296,
   40298,40300,40321,40327,40328,40330,40332,40334,40392,40393,40395,40397,40399,40564,40566,40568,
   40570,40591,40593,40595,40640,40642,40685,40915,40918,40919,40920,40922,40928,40929,40931,40933,
   40935,40957,40958,40959,40961,40967,40968,40970,40972,40974,41069,41070,41072,41078,41079,41081,
   41083,41085,41105,41107,41113,41114,41116,41118,41120,41141,41147,41148,41150,41152,41212,41213,
   41215,41217,41219,41384,41386,41388,41390,41411,41413,41415,41460,41462,41505,41737,41738,41739,
   41741,41747,41748,41750,41752,41754,41849,41850,41852,41858,41859,41861,41863,41865,41885,41887,
   41893,41894,41896,41898,41900,41921,41927,41928,41930,41932,41934,41992,41993,41997,41999,42164,
   42166,42168,42170,42191,42193,42195,42240,42242,42285,42590,42591,42593,42599,42600,42602,42604,
   42606,42626,42628,42634,42635,42637,42641,42662,42668,42669,42673,42675,42733,42734,42736,42738,
   42740,42905,42907,42909,42911,42932,42934,42936,42981,42983,43026,44625,44627,44633,44634,44636,
   44638,44640,44661,44667,44668,44670,44672,44674,44732,44733,44735,44737,44739,44904,44906,44908,
   44910,44931,44933,44935,44980,44982,45025,45256,45262,45263,45265,45267,45269,45327,45328,45330,
   45332,45334,45499,45501,45503,45505,45526,45528,45530,45575,45577,45620,45888,45889,45891,45893,
   45895,46060,46062,46064,46066,46087,46089,46091,46136,46138,46181,47084,47086,47088,47090,47111,
   47113,47115,47160,47162,47205,49471,49473,49475,49520,49522,49565,49820,49822,49865,50394],
 [2279,3714,3725,3905,5859,5870,6050,7939,7950,8130,42671],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,3501,3505,3506,3507,3513,
   3514,3517,3518,3527,3528,3544,3548,3549,3550,3556,3557,3560,3561,3570,3571,3590,3591,3592,
   3598,3599,3602,3603,3612,3613,3749,3750,3756,3757,3770,3771,3787,3793,3794,3829,3830,3833,
   3834,3843,3844,4025,4038,4039,4139,4354,4510,4511,4512,4518,4528,4529,5645,5646,5650,5651,
   5652,5658,5659,5662,5663,5672,5673,5689,5693,5694,5695,5701,5702,5705,5706,5715,5716,5735,
   5736,5737,5743,5744,5747,5748,5757,5758,5894,5902,5905,5916,5939,5942,5953,5978,5979,6170,
   6173,6183,6184,6202,6212,6213,6284,6293,6294,6499,7725,7726,7730,7731,7732,7738,7739,7742,
   7743,7752,7753,7769,7773,7774,7775,7781,7782,7785,7786,7795,7796,7815,7816,7817,7823,7824,
   7827,7828,7837,7838,7974,7986,7995,7996,8018,8019,8023,8032,8033,8058,8059,8250,8254,8263,
   8283,8292,8364,8398,8399,8579,38205,38209,38210,38211,38217,38218,38221,38222,38231,38232,
   38251,38252,38253,38259,38260,38263,38264,38273,38274,38410,38411,38417,38418,38431,38432,38448,
   38454,38455,38468,38469,38490,38491,38494,38495,38504,38505,38686,38699,38700,38728,38729,38800,
   39015,39154,39155,39156,39162,39163,39166,39167,39176,39177,39313,39320,39321,39324,39334,39335,
   39357,39358,39361,39371,39372,39397,39398,39589,39592,39602,39603,39621,39631,39632,39703,39712,
   39713,39918,40174,40181,40182,40186,40195,40196,40218,40219,40223,40232,40233,40258,40259,40450,
   40454,40463,40464,40483,40492,40493,40564,40598,40599,40779,43262,43263,43266,43276,43277,43298,
   43494,43507,43508,43536,43537,43643,43823,43965,44160,44173,44174,44202,44203,44308,44489,44904,
   45119,47903,47912,47913,47993,48199,48400,48605],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,3501,3505,3506,3507,3513,
   3514,3517,3518,3527,3528,3544,3548,3549,3550,3556,3557,3560,3561,3570,3571,3590,3591,3592,
   3598,3599,3602,3603,3612,3613,3749,3750,3756,3757,3770,3771,3787,3793,3794,3829,3830,3833,
   3834,3843,3844,4025,4038,4039,4139,4354,4510,4511,4512,4518,4528,4529,5645,5646,5650,5651,
   5652,5658,5659,5662,5663,5672,5673,5689,5693,5694,5695,5701,5702,5705,5706,5715,5716,5735,
   5736,5737,5743,5744,5747,5748,5757,5758,5894,5902,5905,5916,5939,5942,5953,5978,5979,6170,
   6173,6183,6184,6202,6212,6213,6284,6293,6294,6499,7725,7726,7730,7731,7732,7738,7739,7742,
   7743,7752,7753,7769,7773,7774,7775,7781,7782,7785,7786,7795,7796,7815,7816,7817,7823,7824,
   7827,7828,7837,7838,7974,7986,7995,7996,8018,8019,8023,8032,8033,8058,8059,8250,8254,8263,
   8283,8292,8364,8398,8399,8579,38205,38209,38210,38211,38217,38218,38221,38222,38231,38232,
   38251,38252,38253,38259,38260,38263,38264,38273,38274,38410,38411,38417,38418,38431,38432,38448,
   38454,38455,38468,38469,38490,38491,38494,38495,38504,38505,38686,38699,38700,38728,38729,38800,
   39015,39154,39155,39156,39162,39163,39166,39167,39176,39177,39313,39320,39321,39324,39334,39335,
   39357,39358,39361,39371,39372,39397,39398,39589,39592,39602,39603,39621,39631,39632,39703,39712,
   39713,39918,40174,40181,40182,40186,40195,40196,40218,40219,40223,40232,40233,40258,40259,40450,
   40454,40463,40464,40483,40492,40493,40564,40598,40599,40779,43262,43263,43266,43276,43277,43298,
   43494,43507,43508,43536,43537,43643,43823,43965,44160,44173,44174,44202,44203,44308,44489,44904,
   45119,47903,47912,47913,47993,48199,48400,48605],
 [2279,3500,3501,3507,3517,3518,3544,3550,3592,3833,3834,4139,5645,5646,5662,5689,5695,5705,5706,
   5747,5978,5979,6284,7725,7726,7743,7769,7786,7817,7827,7828,8058,8059,8364,38205,38211,38221,
   38222,38253,38263,38264,38494,38495,38800,39156,39166,39167,39397,39398,39703,40258,40259,40564,
   44904],[23,26,31,32,41,42,44,89,90,91,92,93,94,107,156,158,163,166,173,177,1289,1290,
   1291,1292,1293,1296,1298,1300,1306,1309,1311,1313,1333,1334,1335,1336,1339,1340,1341,1343,
   1349,1350,1352,1354,1356,1376,1377,1378,1381,1382,1383,1385,1392,1394,1396,1398,1418,1419,
   1422,1423,1432,1433,1435,1459,1462,1463,1464,1466,1473,1475,1477,1479,1501,1502,1503,1505,
   1511,1512,1514,1516,1518,1613,1614,1616,1622,1623,1625,1627,1629,1649,1651,1657,1658,1660,
   1662,1664,1685,1691,1692,1694,1696,1698,1756,1757,1759,1761,1763,1928,1930,1932,1934,1955,
   1957,1959,2004,2006,2049,2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,
   3500,3501,3502,3503,3504,3507,3508,3509,3511,3517,3518,3520,3522,3524,3544,3545,3546,3547,
   3550,3551,3552,3554,3560,3561,3563,3565,3567,3587,3588,3589,3592,3593,3594,3596,3602,3603,
   3605,3607,3609,3629,3630,3633,3634,3635,3637,3643,3644,3646,3648,3650,3670,3673,3674,3675,
   3677,3683,3684,3688,3690,3712,3713,3714,3716,3722,3723,3727,3729,3824,3825,3827,3833,3834,
   3836,3838,3840,3860,3862,3868,3869,3871,3873,3875,3896,3902,3903,3907,3909,3967,3968,3972,
   3974,4139,4141,4143,4145,4166,4168,4170,4215,4217,4260,4510,4511,4512,4518,4528,4529,5645,
   5646,5647,5648,5649,5652,5653,5654,5656,5662,5663,5665,5667,5669,5689,5690,5691,5692,5695,
   5696,5697,5699,5705,5706,5708,5710,5712,5732,5733,5734,5737,5738,5739,5741,5747,5748,5750,
   5752,5754,5774,5775,5778,5779,5780,5782,5788,5789,5791,5793,5795,5815,5818,5819,5820,5822,
   5828,5829,5831,5833,5835,5857,5861,5867,5868,5874,5969,5970,5972,5978,5979,5981,5983,5985,
   6005,6007,6013,6014,6016,6018,6020,6041,6047,6048,6050,6052,6054,6112,6113,6115,6117,6119,
   6284,6286,6288,6290,6311,6313,6315,6360,6362,6405,7725,7726,7727,7728,7729,7732,7733,7734,
   7736,7742,7743,7745,7747,7749,7769,7770,7771,7772,7775,7776,7777,7779,7785,7786,7788,7790,
   7792,7812,7813,7814,7817,7818,7819,7821,7827,7828,7830,7832,7834,7854,7855,7858,7859,7862,
   7868,7869,7871,7873,7875,7895,7898,7899,7900,7902,7908,7909,7911,7913,7915,7937,7938,7941,
   7947,7948,7950,7952,7954,8049,8050,8052,8058,8059,8061,8063,8065,8085,8087,8093,8094,8096,
   8098,8100,8121,8127,8128,8132,8192,8193,8195,8197,8199,8364,8366,8368,8370,8391,8393,8395,
   8440,8442,8485,38205,38206,38207,38208,38211,38212,38213,38215,38221,38222,38224,38226,38228,
   38248,38249,38250,38253,38254,38255,38257,38263,38264,38266,38268,38270,38290,38291,38294,38295,
   38296,38298,38304,38305,38307,38309,38311,38331,38334,38335,38336,38338,38344,38345,38347,38349,
   38351,38373,38374,38375,38377,38383,38384,38386,38388,38390,38485,38486,38488,38494,38495,38497,
   38499,38501,38521,38523,38529,38532,38534,38536,38557,38563,38564,38566,38568,38570,38628,38629,
   38631,38633,38635,38800,38802,38804,38806,38827,38829,38831,38876,38878,38921,39151,39152,39153,
   39156,39157,39158,39160,39166,39167,39169,39171,39173,39193,39194,39197,39198,39199,39201,39207,
   39208,39210,39212,39214,39234,39237,39238,39239,39241,39247,39248,39250,39252,39254,39276,39277,
   39278,39280,39286,39287,39289,39291,39293,39388,39389,39391,39397,39398,39400,39402,39424,39426,
   39432,39433,39435,39437,39439,39460,39466,39467,39469,39471,39473,39531,39534,39536,39538,39703,
   39705,39707,39709,39730,39732,39734,39779,39781,39824,40054,40055,40058,40059,40060,40062,40068,
   40069,40071,40073,40075,40095,40098,40099,40100,40102,40109,40111,40113,40115,40137,40138,40139,
   40141,40147,40148,40150,40152,40154,40249,40250,40252,40258,40259,40261,40265,40285,40287,40293,
   40294,40296,40298,40300,40321,40327,40328,40330,40332,40334,40392,40393,40395,40397,40399,40564,
   40566,40568,40570,40591,40593,40595,40640,40642,40685,40915,40918,40919,40920,40922,40928,40929,
   40931,40933,40935,40957,40958,40959,40961,40967,40968,40970,40972,40974,41069,41070,41072,41078,
   41079,41081,41083,41085,41105,41107,41113,41114,41116,41118,41120,41141,41147,41148,41150,41152,
   41212,41213,41215,41217,41219,41384,41386,41388,41390,41411,41413,41415,41460,41462,41505,41737,
   41738,41739,41741,41747,41748,41750,41752,41754,41849,41850,41852,41858,41859,41861,41863,41865,
   41885,41887,41893,41894,41896,41898,41900,41921,41927,41928,41930,41932,41934,41992,41993,41997,
   41999,42164,42166,42168,42170,42191,42193,42195,42240,42242,42285,42590,42591,42593,42599,42600,
   42602,42604,42606,42626,42628,42634,42635,42637,42641,42662,42668,42669,42673,42675,42733,42734,
   42736,42738,42740,42905,42907,42909,42911,42932,42934,42936,42981,42983,43026,44625,44627,44633,
   44634,44636,44638,44640,44661,44667,44668,44670,44672,44674,44732,44733,44735,44737,44739,44904,
   44906,44908,44910,44931,44933,44935,44980,44982,45025,45256,45262,45263,45265,45267,45269,45327,
   45328,45330,45332,45334,45499,45501,45503,45505,45526,45528,45530,45575,45577,45620,45888,45889,
   45891,45893,45895,46060,46062,46064,46066,46087,46089,46091,46136,46138,46181,47084,47086,47088,
   47090,47111,47113,47115,47160,47162,47205,49471,49473,49475,49520,49522,49565,49820,49822,49865,
   50394],[2279,3714,3725,3905,5859,5870,6050,7939,7950,8130,42671],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,3501,3507,3510,3512,3517,
   3518,3519,3523,3525,3526,3544,3550,3560,3561,3592,3602,3603,3826,3828,3833,3834,3835,3839,
   3841,3842,3930,3935,3936,3937,3941,3998,3999,4000,4004,4139,4140,4144,4146,4147,4165,4169,
   4171,4172,4193,4195,4196,4281,4282,4319,4510,4511,4512,4518,4528,4529,5645,5646,5652,5662,
   5663,5689,5695,5698,5700,5705,5706,5707,5711,5713,5714,5737,5747,5748,5971,5973,5978,5979,
   5980,5984,5986,5987,6075,6080,6081,6086,6089,6143,6144,6145,6149,6151,6152,6284,6285,6289,
   6291,6292,6310,6314,6316,6317,6340,6341,6427,6464,7725,7726,7732,7742,7743,7769,7775,7785,
   7786,7817,7820,7822,7827,7828,7829,7833,7835,7836,8051,8053,8058,8059,8060,8064,8066,8067,
   8155,8160,8161,8162,8166,8168,8169,8223,8224,8225,8231,8364,8365,8369,8371,8372,8390,8394,
   8396,8397,8420,8506,8507,8544,38205,38211,38221,38222,38253,38263,38264,38487,38489,38494,
   38495,38496,38500,38502,38503,38591,38800,38854,38980,39156,39166,39167,39397,39398,39499,39505,
   39562,39571,39703,39704,39708,39710,39711,39759,40258,40259,40361,40368,40424,40425,40564,40590,
   40594,40596,40597,40707,44695,44700,44701,44702,44706,44708,44709,44763,44764,44765,44769,44771,
   44772,44904,44905,44909,44911,44912,44930,44934,44936,44937,44958,44960,44961,45046,45047,45084,
   46447,46448,46449,46453,46455,46456,46588,46589,46593,46595,46596,46614,46618,46620,46621,46642,
   46644,46645,46730,46731,46768,47549,47550,47554,47556,47557,47575,47579,47581,47582,47603,47605,
   47606,47691,47692,47729,49470,49474,49476,49477,49498,49500,49501,49586,49587,49624,49798,49800,
   49801,49886,49887,49924,50162,50163,50200,51084],
 [23,26,31,32,41,42,44,89,90,91,92,93,94,107,156,158,163,166,173,177,1289,1290,1291,1292,
   1293,1296,1298,1300,1306,1309,1311,1313,1333,1334,1335,1336,1339,1340,1341,1343,1349,1350,
   1352,1354,1356,1376,1377,1378,1381,1382,1383,1385,1392,1394,1396,1398,1418,1419,1422,1423,
   1432,1433,1435,1459,1462,1463,1464,1466,1473,1475,1477,1479,1501,1502,1503,1505,1511,1512,
   1514,1516,1518,1613,1614,1616,1622,1623,1625,1627,1629,1649,1651,1657,1658,1660,1662,1664,
   1685,1691,1692,1694,1696,1698,1756,1757,1759,1761,1763,1928,1930,1932,1934,1955,1957,1959,
   2004,2006,2049,2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,3501,
   3502,3503,3504,3507,3508,3509,3511,3517,3518,3520,3522,3524,3544,3545,3546,3547,3550,3551,
   3552,3554,3560,3561,3563,3565,3567,3587,3588,3589,3592,3593,3594,3596,3602,3603,3605,3607,
   3609,3629,3630,3633,3634,3635,3637,3643,3644,3646,3648,3650,3670,3673,3674,3675,3677,3683,
   3684,3688,3690,3712,3713,3714,3716,3722,3723,3727,3729,3824,3825,3827,3833,3834,3836,3838,
   3840,3860,3862,3868,3869,3871,3873,3875,3896,3902,3903,3907,3909,3967,3968,3972,3974,4139,
   4141,4143,4145,4166,4168,4170,4215,4217,4260,4510,4511,4512,4518,4528,4529,5645,5646,5647,
   5648,5649,5652,5653,5654,5656,5662,5663,5665,5667,5669,5689,5690,5691,5692,5695,5696,5697,
   5699,5705,5706,5708,5710,5712,5732,5733,5734,5737,5738,5739,5741,5747,5748,5750,5752,5754,
   5774,5775,5778,5779,5780,5782,5788,5789,5791,5793,5795,5815,5818,5819,5820,5822,5828,5829,
   5831,5833,5835,5857,5861,5867,5868,5874,5969,5970,5972,5978,5979,5981,5983,5985,6005,6007,
   6013,6014,6016,6018,6020,6041,6047,6048,6050,6052,6054,6112,6113,6115,6117,6119,6284,6286,
   6288,6290,6311,6313,6315,6360,6362,6405,7725,7726,7727,7728,7729,7732,7733,7734,7736,7742,
   7743,7745,7747,7749,7769,7770,7771,7772,7775,7776,7777,7779,7785,7786,7788,7790,7792,7812,
   7813,7814,7817,7818,7819,7821,7827,7828,7830,7832,7834,7854,7855,7858,7859,7862,7868,7869,
   7871,7873,7875,7895,7898,7899,7900,7902,7908,7909,7911,7913,7915,7937,7938,7941,7947,7948,
   7950,7952,7954,8049,8050,8052,8058,8059,8061,8063,8065,8085,8087,8093,8094,8096,8098,8100,
   8121,8127,8128,8132,8192,8193,8195,8197,8199,8364,8366,8368,8370,8391,8393,8395,8440,8442,
   8485,38205,38206,38207,38208,38211,38212,38213,38215,38221,38222,38224,38226,38228,38248,38249,
   38250,38253,38254,38255,38257,38263,38264,38266,38268,38270,38290,38291,38294,38295,38296,38298,
   38304,38305,38307,38309,38311,38331,38334,38335,38336,38338,38344,38345,38347,38349,38351,38373,
   38374,38375,38377,38383,38384,38386,38388,38390,38485,38486,38488,38494,38495,38497,38499,38501,
   38521,38523,38529,38532,38534,38536,38557,38563,38564,38566,38568,38570,38628,38629,38631,38633,
   38635,38800,38802,38804,38806,38827,38829,38831,38876,38878,38921,39151,39152,39153,39156,39157,
   39158,39160,39166,39167,39169,39171,39173,39193,39194,39197,39198,39199,39201,39207,39208,39210,
   39212,39214,39234,39237,39238,39239,39241,39247,39248,39250,39252,39254,39276,39277,39278,39280,
   39286,39287,39289,39291,39293,39388,39389,39391,39397,39398,39400,39402,39424,39426,39432,39433,
   39435,39437,39439,39460,39466,39467,39469,39471,39473,39531,39534,39536,39538,39703,39705,39707,
   39709,39730,39732,39734,39779,39781,39824,40054,40055,40058,40059,40060,40062,40068,40069,40071,
   40073,40075,40095,40098,40099,40100,40102,40109,40111,40113,40115,40137,40138,40139,40141,40147,
   40148,40150,40152,40154,40249,40250,40252,40258,40259,40261,40265,40285,40287,40293,40294,40296,
   40298,40300,40321,40327,40328,40330,40332,40334,40392,40393,40395,40397,40399,40564,40566,40568,
   40570,40591,40593,40595,40640,40642,40685,40915,40918,40919,40920,40922,40928,40929,40931,40933,
   40935,40957,40958,40959,40961,40967,40968,40970,40972,40974,41069,41070,41072,41078,41079,41081,
   41083,41085,41105,41107,41113,41114,41116,41118,41120,41141,41147,41148,41150,41152,41212,41213,
   41215,41217,41219,41384,41386,41388,41390,41411,41413,41415,41460,41462,41505,41737,41738,41739,
   41741,41747,41748,41750,41752,41754,41849,41850,41852,41858,41859,41861,41863,41865,41885,41887,
   41893,41894,41896,41898,41900,41921,41927,41928,41930,41932,41934,41992,41993,41997,41999,42164,
   42166,42168,42170,42191,42193,42195,42240,42242,42285,42590,42591,42593,42599,42600,42602,42604,
   42606,42626,42628,42634,42635,42637,42641,42662,42668,42669,42673,42675,42733,42734,42736,42738,
   42740,42905,42907,42909,42911,42932,42934,42936,42981,42983,43026,44625,44627,44633,44634,44636,
   44638,44640,44661,44667,44668,44670,44672,44674,44732,44733,44735,44737,44739,44904,44906,44908,
   44910,44931,44933,44935,44980,44982,45025,45256,45262,45263,45265,45267,45269,45327,45328,45330,
   45332,45334,45499,45501,45503,45505,45526,45528,45530,45575,45577,45620,45888,45889,45891,45893,
   45895,46060,46062,46064,46066,46087,46089,46091,46136,46138,46181,47084,47086,47088,47090,47111,
   47113,47115,47160,47162,47205,49471,49473,49475,49520,49522,49565,49820,49822,49865,50394],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,3501,3507,3510,3512,3517,
   3518,3519,3523,3525,3526,3544,3550,3560,3561,3592,3602,3603,3826,3828,3833,3834,3835,3839,
   3841,3842,3930,3935,3936,3937,3941,3998,3999,4000,4004,4139,4140,4144,4146,4147,4165,4169,
   4171,4172,4193,4195,4196,4281,4282,4319,4510,4511,4512,4518,4528,4529,5645,5646,5652,5662,
   5663,5689,5695,5698,5700,5705,5706,5707,5711,5713,5714,5737,5747,5748,5971,5973,5978,5979,
   5980,5984,5986,5987,6075,6080,6081,6086,6089,6143,6144,6145,6149,6151,6152,6284,6285,6289,
   6291,6292,6310,6314,6316,6317,6340,6341,6427,6464,7725,7726,7732,7742,7743,7769,7775,7785,
   7786,7817,7820,7822,7827,7828,7829,7833,7835,7836,8051,8053,8058,8059,8060,8064,8066,8067,
   8155,8160,8161,8162,8166,8168,8169,8223,8224,8225,8231,8364,8365,8369,8371,8372,8390,8394,
   8396,8397,8420,8506,8507,8544,38205,38211,38221,38222,38253,38263,38264,38487,38489,38494,
   38495,38496,38500,38502,38503,38591,38800,38854,38980,39156,39166,39167,39397,39398,39499,39505,
   39562,39571,39703,39704,39708,39710,39711,39759,40258,40259,40361,40368,40424,40425,40564,40590,
   40594,40596,40597,40707,44695,44700,44701,44702,44706,44708,44709,44763,44764,44765,44769,44771,
   44772,44904,44905,44909,44911,44912,44930,44934,44936,44937,44958,44960,44961,45046,45047,45084,
   46447,46448,46449,46453,46455,46456,46588,46589,46593,46595,46596,46614,46618,46620,46621,46642,
   46644,46645,46730,46731,46768,47549,47550,47554,47556,47557,47575,47579,47581,47582,47603,47605,
   47606,47691,47692,47729,49470,49474,49476,49477,49498,49500,49501,49586,49587,49624,49798,49800,
   49801,49886,49887,49924,50162,50163,50200,51084],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,3501,3505,3506,3507,3513,
   3514,3517,3518,3527,3528,3544,3548,3549,3550,3556,3557,3560,3561,3570,3571,3590,3591,3592,
   3598,3599,3602,3603,3612,3613,3749,3750,3756,3757,3770,3771,3787,3793,3794,3829,3830,3833,
   3834,3843,3844,4025,4038,4039,4139,4354,4510,4511,4512,4518,4528,4529,5645,5646,5650,5651,
   5652,5658,5659,5662,5663,5672,5673,5689,5693,5694,5695,5701,5702,5705,5706,5715,5716,5735,
   5736,5737,5743,5744,5747,5748,5757,5758,5894,5902,5905,5916,5939,5942,5953,5978,5979,6170,
   6173,6183,6184,6202,6212,6213,6284,6293,6294,6499,7725,7726,7730,7731,7732,7738,7739,7742,
   7743,7752,7753,7769,7773,7774,7775,7781,7782,7785,7786,7795,7796,7815,7816,7817,7823,7824,
   7827,7828,7837,7838,7974,7986,7995,7996,8018,8019,8023,8032,8033,8058,8059,8250,8254,8263,
   8283,8292,8364,8398,8399,8579,38205,38209,38210,38211,38217,38218,38221,38222,38231,38232,
   38251,38252,38253,38259,38260,38263,38264,38273,38274,38410,38411,38417,38418,38431,38432,38448,
   38454,38455,38468,38469,38490,38491,38494,38495,38504,38505,38686,38699,38700,38728,38729,38800,
   39015,39154,39155,39156,39162,39163,39166,39167,39176,39177,39313,39320,39321,39324,39334,39335,
   39357,39358,39361,39371,39372,39397,39398,39589,39592,39602,39603,39621,39631,39632,39703,39712,
   39713,39918,40174,40181,40182,40186,40195,40196,40218,40219,40223,40232,40233,40258,40259,40450,
   40454,40463,40464,40483,40492,40493,40564,40598,40599,40779,43262,43263,43266,43276,43277,43298,
   43494,43507,43508,43536,43537,43643,43823,43965,44160,44173,44174,44202,44203,44308,44489,44904,
   45119,47903,47912,47913,47993,48199,48400,48605],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,3501,3505,3506,3507,3513,
   3514,3517,3518,3527,3528,3544,3548,3549,3550,3556,3557,3560,3561,3570,3571,3590,3591,3592,
   3598,3599,3602,3603,3612,3613,3749,3750,3756,3757,3770,3771,3787,3793,3794,3829,3830,3833,
   3834,3843,3844,4025,4038,4039,4139,4354,4510,4511,4512,4518,4528,4529,5645,5646,5650,5651,
   5652,5658,5659,5662,5663,5672,5673,5689,5693,5694,5695,5701,5702,5705,5706,5715,5716,5735,
   5736,5737,5743,5744,5747,5748,5757,5758,5894,5902,5905,5916,5939,5942,5953,5978,5979,6170,
   6173,6183,6184,6202,6212,6213,6284,6293,6294,6499,7725,7726,7730,7731,7732,7738,7739,7742,
   7743,7752,7753,7769,7773,7774,7775,7781,7782,7785,7786,7795,7796,7815,7816,7817,7823,7824,
   7827,7828,7837,7838,7974,7986,7995,7996,8018,8019,8023,8032,8033,8058,8059,8250,8254,8263,
   8283,8292,8364,8398,8399,8579,38205,38209,38210,38211,38217,38218,38221,38222,38231,38232,
   38251,38252,38253,38259,38260,38263,38264,38273,38274,38410,38411,38417,38418,38431,38432,38448,
   38454,38455,38468,38469,38490,38491,38494,38495,38504,38505,38686,38699,38700,38728,38729,38800,
   39015,39154,39155,39156,39162,39163,39166,39167,39176,39177,39313,39320,39321,39324,39334,39335,
   39357,39358,39361,39371,39372,39397,39398,39589,39592,39602,39603,39621,39631,39632,39703,39712,
   39713,39918,40174,40181,40182,40186,40195,40196,40218,40219,40223,40232,40233,40258,40259,40450,
   40454,40463,40464,40483,40492,40493,40564,40598,40599,40779,43262,43263,43266,43276,43277,43298,
   43494,43507,43508,43536,43537,43643,43823,43965,44160,44173,44174,44202,44203,44308,44489,44904,
   45119,47903,47912,47913,47993,48199,48400,48605],[2279],[2279],
 [2279,3500,3501,3507,3517,3518,3544,3550,3592,3833,3834,4139,5645,5646,5662,5689,5695,5705,5706,
   5747,5978,5979,6284,7725,7726,7743,7769,7786,7817,7827,7828,8058,8059,8364,38205,38211,38221,
   38222,38253,38263,38264,38494,38495,38800,39156,39166,39167,39397,39398,39703,40258,40259,40564,
   44904],[2279,3500,3501,3507,3517,3518,3544,3550,3592,3833,3834,4139,5645,5646,5662,5689,
   5695,5705,5706,5747,5978,5979,6284,7725,7726,7743,7769,7786,7817,7827,7828,8058,8059,8364,
   38205,38211,38221,38222,38253,38263,38264,38494,38495,38800,39156,39166,39167,39397,39398,39703,
   40258,40259,40564,44904],[2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,
   3500,3501,3507,3510,3512,3517,3518,3519,3523,3525,3526,3544,3550,3560,3561,3592,3602,3603,
   3826,3828,3833,3834,3835,3839,3841,3842,3930,3935,3936,3937,3941,3998,3999,4000,4004,4139,
   4140,4144,4146,4147,4165,4169,4171,4172,4193,4195,4196,4281,4282,4319,4510,4511,4512,4518,
   4528,4529,5645,5646,5652,5662,5663,5689,5695,5698,5700,5705,5706,5707,5711,5713,5714,5737,
   5747,5748,5971,5973,5978,5979,5980,5984,5986,5987,6075,6080,6081,6086,6089,6143,6144,6145,
   6149,6151,6152,6284,6285,6289,6291,6292,6310,6314,6316,6317,6340,6341,6427,6464,7725,7726,
   7732,7742,7743,7769,7775,7785,7786,7817,7820,7822,7827,7828,7829,7833,7835,7836,8051,8053,
   8058,8059,8060,8064,8066,8067,8155,8160,8161,8162,8166,8168,8169,8223,8224,8225,8231,8364,
   8365,8369,8371,8372,8390,8394,8396,8397,8420,8506,8507,8544,38205,38211,38221,38222,38253,
   38263,38264,38487,38489,38494,38495,38496,38500,38502,38503,38591,38800,38854,38980,39156,39166,
   39167,39397,39398,39499,39505,39562,39571,39703,39704,39708,39710,39711,39759,40258,40259,40361,
   40368,40424,40425,40564,40590,40594,40596,40597,40707,44695,44700,44701,44702,44706,44708,44709,
   44763,44764,44765,44769,44771,44772,44904,44905,44909,44911,44912,44930,44934,44936,44937,44958,
   44960,44961,45046,45047,45084,46447,46448,46449,46453,46455,46456,46588,46589,46593,46595,46596,
   46614,46618,46620,46621,46642,46644,46645,46730,46731,46768,47549,47550,47554,47556,47557,47575,
   47579,47581,47582,47603,47605,47606,47691,47692,47729,49470,49474,49476,49477,49498,49500,49501,
   49586,49587,49624,49798,49800,49801,49886,49887,49924,50162,50163,50200,51084],
 [2279,3714,3725,3905,5859,5870,6050,7939,7950,8130,42671],[2279],
 [23,26,31,32,41,42,44,89,90,91,92,93,94,107,156,158,163,166,173,177,1289,1290,1291,1292,
   1293,1296,1298,1300,1306,1309,1311,1313,1333,1334,1335,1336,1339,1340,1341,1343,1349,1350,
   1352,1354,1356,1376,1377,1378,1381,1382,1383,1385,1392,1394,1396,1398,1418,1419,1422,1423,
   1432,1433,1435,1459,1462,1463,1464,1466,1473,1475,1477,1479,1501,1502,1503,1505,1511,1512,
   1514,1516,1518,1613,1614,1616,1622,1623,1625,1627,1629,1649,1651,1657,1658,1660,1662,1664,
   1685,1691,1692,1694,1696,1698,1756,1757,1759,1761,1763,1928,1930,1932,1934,1955,1957,1959,
   2004,2006,2049,2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,3501,
   3502,3503,3504,3507,3508,3509,3511,3517,3518,3520,3522,3524,3544,3545,3546,3547,3550,3551,
   3552,3554,3560,3561,3563,3565,3567,3587,3588,3589,3592,3593,3594,3596,3602,3603,3605,3607,
   3609,3629,3630,3633,3634,3635,3637,3643,3644,3646,3648,3650,3670,3673,3674,3675,3677,3683,
   3684,3688,3690,3712,3713,3714,3716,3722,3723,3727,3729,3824,3825,3827,3833,3834,3836,3838,
   3840,3860,3862,3868,3869,3871,3873,3875,3896,3902,3903,3907,3909,3967,3968,3972,3974,4139,
   4141,4143,4145,4166,4168,4170,4215,4217,4260,4510,4511,4512,4518,4528,4529,5645,5646,5647,
   5648,5649,5652,5653,5654,5656,5662,5663,5665,5667,5669,5689,5690,5691,5692,5695,5696,5697,
   5699,5705,5706,5708,5710,5712,5732,5733,5734,5737,5738,5739,5741,5747,5748,5750,5752,5754,
   5774,5775,5778,5779,5780,5782,5788,5789,5791,5793,5795,5815,5818,5819,5820,5822,5828,5829,
   5831,5833,5835,5857,5861,5867,5868,5874,5969,5970,5972,5978,5979,5981,5983,5985,6005,6007,
   6013,6014,6016,6018,6020,6041,6047,6048,6050,6052,6054,6112,6113,6115,6117,6119,6284,6286,
   6288,6290,6311,6313,6315,6360,6362,6405,7725,7726,7727,7728,7729,7732,7733,7734,7736,7742,
   7743,7745,7747,7749,7769,7770,7771,7772,7775,7776,7777,7779,7785,7786,7788,7790,7792,7812,
   7813,7814,7817,7818,7819,7821,7827,7828,7830,7832,7834,7854,7855,7858,7859,7862,7868,7869,
   7871,7873,7875,7895,7898,7899,7900,7902,7908,7909,7911,7913,7915,7937,7938,7941,7947,7948,
   7950,7952,7954,8049,8050,8052,8058,8059,8061,8063,8065,8085,8087,8093,8094,8096,8098,8100,
   8121,8127,8128,8132,8192,8193,8195,8197,8199,8364,8366,8368,8370,8391,8393,8395,8440,8442,
   8485,38205,38206,38207,38208,38211,38212,38213,38215,38221,38222,38224,38226,38228,38248,38249,
   38250,38253,38254,38255,38257,38263,38264,38266,38268,38270,38290,38291,38294,38295,38296,38298,
   38304,38305,38307,38309,38311,38331,38334,38335,38336,38338,38344,38345,38347,38349,38351,38373,
   38374,38375,38377,38383,38384,38386,38388,38390,38485,38486,38488,38494,38495,38497,38499,38501,
   38521,38523,38529,38532,38534,38536,38557,38563,38564,38566,38568,38570,38628,38629,38631,38633,
   38635,38800,38802,38804,38806,38827,38829,38831,38876,38878,38921,39151,39152,39153,39156,39157,
   39158,39160,39166,39167,39169,39171,39173,39193,39194,39197,39198,39199,39201,39207,39208,39210,
   39212,39214,39234,39237,39238,39239,39241,39247,39248,39250,39252,39254,39276,39277,39278,39280,
   39286,39287,39289,39291,39293,39388,39389,39391,39397,39398,39400,39402,39424,39426,39432,39433,
   39435,39437,39439,39460,39466,39467,39469,39471,39473,39531,39534,39536,39538,39703,39705,39707,
   39709,39730,39732,39734,39779,39781,39824,40054,40055,40058,40059,40060,40062,40068,40069,40071,
   40073,40075,40095,40098,40099,40100,40102,40109,40111,40113,40115,40137,40138,40139,40141,40147,
   40148,40150,40152,40154,40249,40250,40252,40258,40259,40261,40265,40285,40287,40293,40294,40296,
   40298,40300,40321,40327,40328,40330,40332,40334,40392,40393,40395,40397,40399,40564,40566,40568,
   40570,40591,40593,40595,40640,40642,40685,40915,40918,40919,40920,40922,40928,40929,40931,40933,
   40935,40957,40958,40959,40961,40967,40968,40970,40972,40974,41069,41070,41072,41078,41079,41081,
   41083,41085,41105,41107,41113,41114,41116,41118,41120,41141,41147,41148,41150,41152,41212,41213,
   41215,41217,41219,41384,41386,41388,41390,41411,41413,41415,41460,41462,41505,41737,41738,41739,
   41741,41747,41748,41750,41752,41754,41849,41850,41852,41858,41859,41861,41863,41865,41885,41887,
   41893,41894,41896,41898,41900,41921,41927,41928,41930,41932,41934,41992,41993,41997,41999,42164,
   42166,42168,42170,42191,42193,42195,42240,42242,42285,42590,42591,42593,42599,42600,42602,42604,
   42606,42626,42628,42634,42635,42637,42641,42662,42668,42669,42673,42675,42733,42734,42736,42738,
   42740,42905,42907,42909,42911,42932,42934,42936,42981,42983,43026,44625,44627,44633,44634,44636,
   44638,44640,44661,44667,44668,44670,44672,44674,44732,44733,44735,44737,44739,44904,44906,44908,
   44910,44931,44933,44935,44980,44982,45025,45256,45262,45263,45265,45267,45269,45327,45328,45330,
   45332,45334,45499,45501,45503,45505,45526,45528,45530,45575,45577,45620,45888,45889,45891,45893,
   45895,46060,46062,46064,46066,46087,46089,46091,46136,46138,46181,47084,47086,47088,47090,47111,
   47113,47115,47160,47162,47205,49471,49473,49475,49520,49522,49565,49820,49822,49865,50394],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,3501,3507,3510,3512,3517,
   3518,3519,3523,3525,3526,3544,3550,3560,3561,3592,3602,3603,3826,3828,3833,3834,3835,3839,
   3841,3842,3930,3935,3936,3937,3941,3998,3999,4000,4004,4139,4140,4144,4146,4147,4165,4169,
   4171,4172,4193,4195,4196,4281,4282,4319,4510,4511,4512,4518,4528,4529,5645,5646,5652,5662,
   5663,5689,5695,5698,5700,5705,5706,5707,5711,5713,5714,5737,5747,5748,5971,5973,5978,5979,
   5980,5984,5986,5987,6075,6080,6081,6086,6089,6143,6144,6145,6149,6151,6152,6284,6285,6289,
   6291,6292,6310,6314,6316,6317,6340,6341,6427,6464,7725,7726,7732,7742,7743,7769,7775,7785,
   7786,7817,7820,7822,7827,7828,7829,7833,7835,7836,8051,8053,8058,8059,8060,8064,8066,8067,
   8155,8160,8161,8162,8166,8168,8169,8223,8224,8225,8231,8364,8365,8369,8371,8372,8390,8394,
   8396,8397,8420,8506,8507,8544,38205,38211,38221,38222,38253,38263,38264,38487,38489,38494,
   38495,38496,38500,38502,38503,38591,38800,38854,38980,39156,39166,39167,39397,39398,39499,39505,
   39562,39571,39703,39704,39708,39710,39711,39759,40258,40259,40361,40368,40424,40425,40564,40590,
   40594,40596,40597,40707,44695,44700,44701,44702,44706,44708,44709,44763,44764,44765,44769,44771,
   44772,44904,44905,44909,44911,44912,44930,44934,44936,44937,44958,44960,44961,45046,45047,45084,
   46447,46448,46449,46453,46455,46456,46588,46589,46593,46595,46596,46614,46618,46620,46621,46642,
   46644,46645,46730,46731,46768,47549,47550,47554,47556,47557,47575,47579,47581,47582,47603,47605,
   47606,47691,47692,47729,49470,49474,49476,49477,49498,49500,49501,49586,49587,49624,49798,49800,
   49801,49886,49887,49924,50162,50163,50200,51084],
 [23,26,31,32,41,42,44,89,90,91,92,93,94,107,156,158,163,166,173,177,1289,1290,1291,1292,
   1293,1296,1298,1300,1306,1309,1311,1313,1333,1334,1335,1336,1339,1340,1341,1343,1349,1350,
   1352,1354,1356,1376,1377,1378,1381,1382,1383,1385,1392,1394,1396,1398,1418,1419,1422,1423,
   1432,1433,1435,1459,1462,1463,1464,1466,1473,1475,1477,1479,1501,1502,1503,1505,1511,1512,
   1514,1516,1518,1613,1614,1616,1622,1623,1625,1627,1629,1649,1651,1657,1658,1660,1662,1664,
   1685,1691,1692,1694,1696,1698,1756,1757,1759,1761,1763,1928,1930,1932,1934,1955,1957,1959,
   2004,2006,2049,2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,3501,
   3502,3503,3504,3507,3508,3509,3511,3517,3518,3520,3522,3524,3544,3545,3546,3547,3550,3551,
   3552,3554,3560,3561,3563,3565,3567,3587,3588,3589,3592,3593,3594,3596,3602,3603,3605,3607,
   3609,3629,3630,3633,3634,3635,3637,3643,3644,3646,3648,3650,3670,3673,3674,3675,3677,3683,
   3684,3688,3690,3712,3713,3714,3716,3722,3723,3727,3729,3824,3825,3827,3833,3834,3836,3838,
   3840,3860,3862,3868,3869,3871,3873,3875,3896,3902,3903,3907,3909,3967,3968,3972,3974,4139,
   4141,4143,4145,4166,4168,4170,4215,4217,4260,4510,4511,4512,4518,4528,4529,5645,5646,5647,
   5648,5649,5652,5653,5654,5656,5662,5663,5665,5667,5669,5689,5690,5691,5692,5695,5696,5697,
   5699,5705,5706,5708,5710,5712,5732,5733,5734,5737,5738,5739,5741,5747,5748,5750,5752,5754,
   5774,5775,5778,5779,5780,5782,5788,5789,5791,5793,5795,5815,5818,5819,5820,5822,5828,5829,
   5831,5833,5835,5857,5861,5867,5868,5874,5969,5970,5972,5978,5979,5981,5983,5985,6005,6007,
   6013,6014,6016,6018,6020,6041,6047,6048,6050,6052,6054,6112,6113,6115,6117,6119,6284,6286,
   6288,6290,6311,6313,6315,6360,6362,6405,7725,7726,7727,7728,7729,7732,7733,7734,7736,7742,
   7743,7745,7747,7749,7769,7770,7771,7772,7775,7776,7777,7779,7785,7786,7788,7790,7792,7812,
   7813,7814,7817,7818,7819,7821,7827,7828,7830,7832,7834,7854,7855,7858,7859,7862,7868,7869,
   7871,7873,7875,7895,7898,7899,7900,7902,7908,7909,7911,7913,7915,7937,7938,7941,7947,7948,
   7950,7952,7954,8049,8050,8052,8058,8059,8061,8063,8065,8085,8087,8093,8094,8096,8098,8100,
   8121,8127,8128,8132,8192,8193,8195,8197,8199,8364,8366,8368,8370,8391,8393,8395,8440,8442,
   8485,38205,38206,38207,38208,38211,38212,38213,38215,38221,38222,38224,38226,38228,38248,38249,
   38250,38253,38254,38255,38257,38263,38264,38266,38268,38270,38290,38291,38294,38295,38296,38298,
   38304,38305,38307,38309,38311,38331,38334,38335,38336,38338,38344,38345,38347,38349,38351,38373,
   38374,38375,38377,38383,38384,38386,38388,38390,38485,38486,38488,38494,38495,38497,38499,38501,
   38521,38523,38529,38532,38534,38536,38557,38563,38564,38566,38568,38570,38628,38629,38631,38633,
   38635,38800,38802,38804,38806,38827,38829,38831,38876,38878,38921,39151,39152,39153,39156,39157,
   39158,39160,39166,39167,39169,39171,39173,39193,39194,39197,39198,39199,39201,39207,39208,39210,
   39212,39214,39234,39237,39238,39239,39241,39247,39248,39250,39252,39254,39276,39277,39278,39280,
   39286,39287,39289,39291,39293,39388,39389,39391,39397,39398,39400,39402,39424,39426,39432,39433,
   39435,39437,39439,39460,39466,39467,39469,39471,39473,39531,39534,39536,39538,39703,39705,39707,
   39709,39730,39732,39734,39779,39781,39824,40054,40055,40058,40059,40060,40062,40068,40069,40071,
   40073,40075,40095,40098,40099,40100,40102,40109,40111,40113,40115,40137,40138,40139,40141,40147,
   40148,40150,40152,40154,40249,40250,40252,40258,40259,40261,40265,40285,40287,40293,40294,40296,
   40298,40300,40321,40327,40328,40330,40332,40334,40392,40393,40395,40397,40399,40564,40566,40568,
   40570,40591,40593,40595,40640,40642,40685,40915,40918,40919,40920,40922,40928,40929,40931,40933,
   40935,40957,40958,40959,40961,40967,40968,40970,40972,40974,41069,41070,41072,41078,41079,41081,
   41083,41085,41105,41107,41113,41114,41116,41118,41120,41141,41147,41148,41150,41152,41212,41213,
   41215,41217,41219,41384,41386,41388,41390,41411,41413,41415,41460,41462,41505,41737,41738,41739,
   41741,41747,41748,41750,41752,41754,41849,41850,41852,41858,41859,41861,41863,41865,41885,41887,
   41893,41894,41896,41898,41900,41921,41927,41928,41930,41932,41934,41992,41993,41997,41999,42164,
   42166,42168,42170,42191,42193,42195,42240,42242,42285,42590,42591,42593,42599,42600,42602,42604,
   42606,42626,42628,42634,42635,42637,42641,42662,42668,42669,42673,42675,42733,42734,42736,42738,
   42740,42905,42907,42909,42911,42932,42934,42936,42981,42983,43026,44625,44627,44633,44634,44636,
   44638,44640,44661,44667,44668,44670,44672,44674,44732,44733,44735,44737,44739,44904,44906,44908,
   44910,44931,44933,44935,44980,44982,45025,45256,45262,45263,45265,45267,45269,45327,45328,45330,
   45332,45334,45499,45501,45503,45505,45526,45528,45530,45575,45577,45620,45888,45889,45891,45893,
   45895,46060,46062,46064,46066,46087,46089,46091,46136,46138,46181,47084,47086,47088,47090,47111,
   47113,47115,47160,47162,47205,49471,49473,49475,49520,49522,49565,49820,49822,49865,50394],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,3501,3507,3510,3512,3517,
   3518,3519,3523,3525,3526,3544,3550,3560,3561,3592,3602,3603,3826,3828,3833,3834,3835,3839,
   3841,3842,3930,3935,3936,3937,3941,3998,3999,4000,4004,4139,4140,4144,4146,4147,4165,4169,
   4171,4172,4193,4195,4196,4281,4282,4319,4510,4511,4512,4518,4528,4529,5645,5646,5652,5662,
   5663,5689,5695,5698,5700,5705,5706,5707,5711,5713,5714,5737,5747,5748,5971,5973,5978,5979,
   5980,5984,5986,5987,6075,6080,6081,6086,6089,6143,6144,6145,6149,6151,6152,6284,6285,6289,
   6291,6292,6310,6314,6316,6317,6340,6341,6427,6464,7725,7726,7732,7742,7743,7769,7775,7785,
   7786,7817,7820,7822,7827,7828,7829,7833,7835,7836,8051,8053,8058,8059,8060,8064,8066,8067,
   8155,8160,8161,8162,8166,8168,8169,8223,8224,8225,8231,8364,8365,8369,8371,8372,8390,8394,
   8396,8397,8420,8506,8507,8544,38205,38211,38221,38222,38253,38263,38264,38487,38489,38494,
   38495,38496,38500,38502,38503,38591,38800,38854,38980,39156,39166,39167,39397,39398,39499,39505,
   39562,39571,39703,39704,39708,39710,39711,39759,40258,40259,40361,40368,40424,40425,40564,40590,
   40594,40596,40597,40707,44695,44700,44701,44702,44706,44708,44709,44763,44764,44765,44769,44771,
   44772,44904,44905,44909,44911,44912,44930,44934,44936,44937,44958,44960,44961,45046,45047,45084,
   46447,46448,46449,46453,46455,46456,46588,46589,46593,46595,46596,46614,46618,46620,46621,46642,
   46644,46645,46730,46731,46768,47549,47550,47554,47556,47557,47575,47579,47581,47582,47603,47605,
   47606,47691,47692,47729,49470,49474,49476,49477,49498,49500,49501,49586,49587,49624,49798,49800,
   49801,49886,49887,49924,50162,50163,50200,51084],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,3501,3507,3510,3512,3517,
   3518,3519,3523,3525,3526,3544,3550,3560,3561,3592,3602,3603,3826,3828,3833,3834,3835,3839,
   3841,3842,3930,3935,3936,3937,3941,3998,3999,4000,4004,4139,4140,4144,4146,4147,4165,4169,
   4171,4172,4193,4195,4196,4281,4282,4319,4510,4511,4512,4518,4528,4529,5645,5646,5652,5662,
   5663,5689,5695,5698,5700,5705,5706,5707,5711,5713,5714,5737,5747,5748,5971,5973,5978,5979,
   5980,5984,5986,5987,6075,6080,6081,6086,6089,6143,6144,6145,6149,6151,6152,6284,6285,6289,
   6291,6292,6310,6314,6316,6317,6340,6341,6427,6464,7725,7726,7732,7742,7743,7769,7775,7785,
   7786,7817,7820,7822,7827,7828,7829,7833,7835,7836,8051,8053,8058,8059,8060,8064,8066,8067,
   8155,8160,8161,8162,8166,8168,8169,8223,8224,8225,8231,8364,8365,8369,8371,8372,8390,8394,
   8396,8397,8420,8506,8507,8544,38205,38211,38221,38222,38253,38263,38264,38487,38489,38494,
   38495,38496,38500,38502,38503,38591,38800,38854,38980,39156,39166,39167,39397,39398,39499,39505,
   39562,39571,39703,39704,39708,39710,39711,39759,40258,40259,40361,40368,40424,40425,40564,40590,
   40594,40596,40597,40707,44695,44700,44701,44702,44706,44708,44709,44763,44764,44765,44769,44771,
   44772,44904,44905,44909,44911,44912,44930,44934,44936,44937,44958,44960,44961,45046,45047,45084,
   46447,46448,46449,46453,46455,46456,46588,46589,46593,46595,46596,46614,46618,46620,46621,46642,
   46644,46645,46730,46731,46768,47549,47550,47554,47556,47557,47575,47579,47581,47582,47603,47605,
   47606,47691,47692,47729,49470,49474,49476,49477,49498,49500,49501,49586,49587,49624,49798,49800,
   49801,49886,49887,49924,50162,50163,50200,51084],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,3501,3505,3506,3507,3513,
   3514,3517,3518,3527,3528,3544,3548,3549,3550,3556,3557,3560,3561,3570,3571,3590,3591,3592,
   3598,3599,3602,3603,3612,3613,3749,3750,3756,3757,3770,3771,3787,3793,3794,3829,3830,3833,
   3834,3843,3844,4025,4038,4039,4139,4354,4510,4511,4512,4518,4528,4529,5645,5646,5650,5651,
   5652,5658,5659,5662,5663,5672,5673,5689,5693,5694,5695,5701,5702,5705,5706,5715,5716,5735,
   5736,5737,5743,5744,5747,5748,5757,5758,5894,5902,5905,5916,5939,5942,5953,5978,5979,6170,
   6173,6183,6184,6202,6212,6213,6284,6293,6294,6499,7725,7726,7730,7731,7732,7738,7739,7742,
   7743,7752,7753,7769,7773,7774,7775,7781,7782,7785,7786,7795,7796,7815,7816,7817,7823,7824,
   7827,7828,7837,7838,7974,7986,7995,7996,8018,8019,8023,8032,8033,8058,8059,8250,8254,8263,
   8283,8292,8364,8398,8399,8579,38205,38209,38210,38211,38217,38218,38221,38222,38231,38232,
   38251,38252,38253,38259,38260,38263,38264,38273,38274,38410,38411,38417,38418,38431,38432,38448,
   38454,38455,38468,38469,38490,38491,38494,38495,38504,38505,38686,38699,38700,38728,38729,38800,
   39015,39154,39155,39156,39162,39163,39166,39167,39176,39177,39313,39320,39321,39324,39334,39335,
   39357,39358,39361,39371,39372,39397,39398,39589,39592,39602,39603,39621,39631,39632,39703,39712,
   39713,39918,40174,40181,40182,40186,40195,40196,40218,40219,40223,40232,40233,40258,40259,40450,
   40454,40463,40464,40483,40492,40493,40564,40598,40599,40779,43262,43263,43266,43276,43277,43298,
   43494,43507,43508,43536,43537,43643,43823,43965,44160,44173,44174,44202,44203,44308,44489,44904,
   45119,47903,47912,47913,47993,48199,48400,48605],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,3501,3505,3506,3507,3513,
   3514,3517,3518,3527,3528,3544,3548,3549,3550,3556,3557,3560,3561,3570,3571,3590,3591,3592,
   3598,3599,3602,3603,3612,3613,3749,3750,3756,3757,3770,3771,3787,3793,3794,3829,3830,3833,
   3834,3843,3844,4025,4038,4039,4139,4354,4510,4511,4512,4518,4528,4529,5645,5646,5650,5651,
   5652,5658,5659,5662,5663,5672,5673,5689,5693,5694,5695,5701,5702,5705,5706,5715,5716,5735,
   5736,5737,5743,5744,5747,5748,5757,5758,5894,5902,5905,5916,5939,5942,5953,5978,5979,6170,
   6173,6183,6184,6202,6212,6213,6284,6293,6294,6499,7725,7726,7730,7731,7732,7738,7739,7742,
   7743,7752,7753,7769,7773,7774,7775,7781,7782,7785,7786,7795,7796,7815,7816,7817,7823,7824,
   7827,7828,7837,7838,7974,7986,7995,7996,8018,8019,8023,8032,8033,8058,8059,8250,8254,8263,
   8283,8292,8364,8398,8399,8579,38205,38209,38210,38211,38217,38218,38221,38222,38231,38232,
   38251,38252,38253,38259,38260,38263,38264,38273,38274,38410,38411,38417,38418,38431,38432,38448,
   38454,38455,38468,38469,38490,38491,38494,38495,38504,38505,38686,38699,38700,38728,38729,38800,
   39015,39154,39155,39156,39162,39163,39166,39167,39176,39177,39313,39320,39321,39324,39334,39335,
   39357,39358,39361,39371,39372,39397,39398,39589,39592,39602,39603,39621,39631,39632,39703,39712,
   39713,39918,40174,40181,40182,40186,40195,40196,40218,40219,40223,40232,40233,40258,40259,40450,
   40454,40463,40464,40483,40492,40493,40564,40598,40599,40779,43262,43263,43266,43276,43277,43298,
   43494,43507,43508,43536,43537,43643,43823,43965,44160,44173,44174,44202,44203,44308,44489,44904,
   45119,47903,47912,47913,47993,48199,48400,48605],[2279],[2279],[2279],[2279],[2279],
 [2279],[2279],[2279],[2279],[2279],[2279],[2279],[2279],[2279],[2279],[8715],
 [8715],[],[202,1625,10077,17521],[2849,2857,3507,3517,3518,3833,3834,4139,8962,22152,22478,
   22479,22784,38494,38495,38800,44904],[],
 [2849,2857,3507,3517,3518,3833,3834,4139,8962,22152,22478,22479,22784,38494,38495,38800,44904],
 [],[],[],[],[],[],[],[],[],[],[],[],[3507],
 [2429,2437,3500,3501,3507,3544,3550,3592,9741,9742,9748,9785,38205,38211,38253,39156],
 [2429,2437,3500,3501,3507,3544,3550,3592,9741,9742,9748,9785,38205,38211,38253,39156],
 [2429,2437,3502,3507,3508,3633,3634,3824,9748,9874,9875,10065,38294,38295,38485,41069],
 [3677,3714,9918,9955],[3677,3714,9918,9955],[3756],[3794,10035],[3507],
 [2429,2437,3502,3507,3508,3633,3634,3824,9748,9874,9875,10065,38294,38295,38485,41069],
 [3677,3714,9918,9955],[3930,10171],[3677,3714,9918,9955],[3930,10171],[3756],[3794,10035],
 [],[],[2429,2437,3507,3517,3518,3833,3834,4139,9748,10074,10075,10380,38494,38495,38800,44904 
  ],[2429,2437,3507,3517,3518,3833,3834,4139,9748,10074,10075,10380,38494,38495,38800,44904],
 [4193],[202,1625,10077,17521],[],[2429,2437,3507,3522,3524,3838,3840,4260,9748,9763,9765,
   10501,38499,38501,38921,45025],[4193],
 [2429,2437,3507,3522,3524,3838,3840,4260,9748,9763,9765,10501,38499,38501,38921,45025],
 [2429,2437,3507,3525,3526,3841,3842,4319,9748,10082,10083,10560,38502,38503,38980,45084],
 [2429,2437,3507,3525,3526,3841,3842,4319,9748,10082,10083,10560,38502,38503,38980,45084],
 [2429,2437,3507,3527,3528,3843,3844,4354,9748,9768,9769,10595,38504,38505,39015,45119],
 [2429,2437,3507,3527,3528,3843,3844,4354,9748,9768,9769,10595,38504,38505,39015,45119],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[8715],[],[10854],
 [10854],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[3507],
 [2492,2500,3500,3501,3507,3544,3550,3592,11694,11695,11701,11738,38205,38211,38253,39156],
 [2492,2500,3500,3501,3507,3544,3550,3592,11694,11695,11701,11738,38205,38211,38253,39156],
 [2492,2500,3502,3507,3508,3633,3634,3824,11701,11827,11828,12018,38294,38295,38485,41069],
 [3677,3714,11871,11908],[3677,3714,11871,11908],[3756],[3794,11988],[3507],
 [2492,2500,3502,3507,3508,3633,3634,3824,11701,11827,11828,12018,38294,38295,38485,41069],
 [3677,3714,11871,11908],[3930,12124],[3677,3714,11871,11908],[3930,12124],[3756],
 [3794,11988],[],[],[2492,2500,3507,3517,3518,3833,3834,4139,11701,12027,12028,12333,38494,
   38495,38800,44904],[2492,2500,3507,3517,3518,3833,3834,4139,11701,12027,12028,12333,38494,
   38495,38800,44904],[4193],[],[],[2492,2500,3507,3522,3524,3838,3840,4260,11701,11716,
   11718,12454,38499,38501,38921,45025],[4193],
 [2492,2500,3507,3522,3524,3838,3840,4260,11701,11716,11718,12454,38499,38501,38921,45025],
 [2492,2500,3507,3525,3526,3841,3842,4319,11701,12035,12036,12513,38502,38503,38980,45084],
 [2492,2500,3507,3525,3526,3841,3842,4319,11701,12035,12036,12513,38502,38503,38980,45084],
 [2492,2500,3507,3527,3528,3843,3844,4354,11701,11721,11722,12548,38504,38505,39015,45119],
 [2492,2500,3507,3527,3528,3843,3844,4354,11701,11721,11722,12548,38504,38505,39015,45119],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [2849,2857,3502,3507,3508,3633,3634,3824,12747,22152,22278,22279,22469,38294,38295,38485,41069],
 [328],[],[2849,2857,3502,3507,3508,3633,3634,3824,12747,22152,22278,22279,22469,38294,38295,
   38485,41069],[12979],[12979],[],[],[],[],[],[],[],[],[],[],[3507],
 [2554,2562,3500,3501,3507,3544,3550,3592,13585,13586,13592,13629,38205,38211,38253,39156],
 [2554,2562,3500,3501,3507,3544,3550,3592,13585,13586,13592,13629,38205,38211,38253,39156],
 [2554,2562,3502,3507,3508,3633,3634,3824,13592,13718,13719,13909,38294,38295,38485,41069],
 [3677,13762],[3714,13799],[3756],[3794,13879],[3507],
 [2554,2562,3502,3507,3508,3633,3634,3824,13592,13718,13719,13909,38294,38295,38485,41069],
 [3714,13799],[3930,14015],[3677,13762],[3930,14015],[3756],[3794,13879],[],[],
 [2554,2562,3507,3517,3518,3833,3834,4139,13592,13918,13919,14224,38494,38495,38800,44904],
 [2554,2562,3507,3517,3518,3833,3834,4139,13592,13918,13919,14224,38494,38495,38800,44904],
 [4193],[],[],[2554,2562,3507,3522,3524,3838,3840,4260,13592,13607,13609,14345,38499,38501,
   38921,45025],[4193],[2554,2562,3507,3522,3524,3838,3840,4260,13592,13607,13609,14345,38499,
   38501,38921,45025],[2554,2562,3507,3525,3526,3841,3842,4319,13592,13926,13927,14404,38502,
   38503,38980,45084],[2554,2562,3507,3525,3526,3841,3842,4319,13592,13926,13927,14404,38502,
   38503,38980,45084],[2554,2562,3507,3527,3528,3843,3844,4354,13592,13612,13613,14439,38504,
   38505,39015,45119],[2554,2562,3507,3527,3528,3843,3844,4354,13592,13612,13613,14439,38504,
   38505,39015,45119],[],[],[],[14514],[14523],[],[],[],[14523],[14514],
 [14565],[14565],[],[],[],[],[14635],[14635],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[3507],[2615,2623,3500,3501,3507,3544,3550,3592,15415,15416,15422,
   15459,38205,38211,38253,39156],[2615,2623,3500,3501,3507,3544,3550,3592,15415,15416,15422,
   15459,38205,38211,38253,39156],[2615,2623,3502,3507,3508,3633,3634,3824,15422,15548,15549,
   15739,38294,38295,38485,41069],[3677,15592],[3714,15629],[3756],[3794,15709],[3507],
 [2615,2623,3502,3507,3508,3633,3634,3824,15422,15548,15549,15739,38294,38295,38485,41069],
 [3714,15629],[3930,15845],[3677,15592],[3930,15845],[3756],[3794,15709],[],[],
 [2615,2623,3507,3517,3518,3833,3834,4139,15422,15748,15749,16054,38494,38495,38800,44904],
 [2615,2623,3507,3517,3518,3833,3834,4139,15422,15748,15749,16054,38494,38495,38800,44904],
 [4193],[],[],[2615,2623,3507,3522,3524,3838,3840,4260,15422,15437,15439,16175,38499,38501,
   38921,45025],[4193],[2615,2623,3507,3522,3524,3838,3840,4260,15422,15437,15439,16175,38499,
   38501,38921,45025],[2615,2623,3507,3525,3526,3841,3842,4319,15422,15756,15757,16234,38502,
   38503,38980,45084],[2615,2623,3507,3525,3526,3841,3842,4319,15422,15756,15757,16234,38502,
   38503,38980,45084],[2615,2623,3507,3527,3528,3843,3844,4354,15422,15442,15443,16269,38504,
   38505,39015,45119],[2615,2623,3507,3527,3528,3843,3844,4354,15422,15442,15443,16269,38504,
   38505,39015,45119],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[10854],[],[2849,2857,3502,3507,3508,3633,3634,3824,12747,22152,22278,22279,22469,38294,
   38295,38485,41069],[],[],[],[],[],[],[],[],[],[],[],[],[3507],
 [2675,2683,3500,3501,3507,3544,3550,3592,17185,17186,17192,17229,38205,38211,38253,39156],
 [2675,2683,3500,3501,3507,3544,3550,3592,17185,17186,17192,17229,38205,38211,38253,39156],
 [2675,2683,3502,3507,3508,3633,3634,3824,17192,17318,17319,17509,38294,38295,38485,41069],
 [3677,3714,17362,17399],[3677,3714,17362,17399],[3756],[3794,17479],[3507],
 [2675,2683,3502,3507,3508,3633,3634,3824,17192,17318,17319,17509,38294,38295,38485,41069],
 [3677,3714,17362,17399],[3930,17615],[3677,3714,17362,17399],[3930,17615],[3756],
 [3794,17479],[],[],[2675,2683,3507,3517,3518,3833,3834,4139,17192,17518,17519,17824,38494,
   38495,38800,44904],[2675,2683,3507,3517,3518,3833,3834,4139,17192,17518,17519,17824,38494,
   38495,38800,44904],[4193],[202,1625,10077,17521],[],
 [2675,2683,3507,3522,3524,3838,3840,4260,17192,17207,17209,17945,38499,38501,38921,45025],
 [4193],[2675,2683,3507,3522,3524,3838,3840,4260,17192,17207,17209,17945,38499,38501,38921,45025]
  ,[2675,2683,3507,3525,3526,3841,3842,4319,17192,17526,17527,18004,38502,38503,38980,45084],
 [2675,2683,3507,3525,3526,3841,3842,4319,17192,17526,17527,18004,38502,38503,38980,45084],
 [2675,2683,3507,3527,3528,3843,3844,4354,17192,17212,17213,18039,38504,38505,39015,45119],
 [2675,2683,3507,3527,3528,3843,3844,4354,17192,17212,17213,18039,38504,38505,39015,45119],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[14635],
 [2849,2857,3507,3517,3518,3833,3834,4139,8962,22152,22478,22479,22784,38494,38495,38800,44904],
 [],[],[],[],[],[],[],[],[],[],[],[],[3507],
 [2734,2742,3500,3501,3507,3544,3550,3592,18896,18897,18903,18940,38205,38211,38253,39156],
 [2734,2742,3500,3501,3507,3544,3550,3592,18896,18897,18903,18940,38205,38211,38253,39156],
 [2734,2742,3502,3507,3508,3633,3634,3824,18903,19029,19030,19220,38294,38295,38485,41069],
 [3677,19073],[3714,19110],[3756],[3794,19190],[3507],
 [2734,2742,3502,3507,3508,3633,3634,3824,18903,19029,19030,19220,38294,38295,38485,41069],
 [3714,19110],[3930,19326],[3677,19073],[3930,19326],[3756],[3794,19190],[],[],
 [2734,2742,3507,3517,3518,3833,3834,4139,18903,19229,19230,19535,38494,38495,38800,44904],
 [2734,2742,3507,3517,3518,3833,3834,4139,18903,19229,19230,19535,38494,38495,38800,44904],
 [4193],[],[],[2734,2742,3507,3522,3524,3838,3840,4260,18903,18918,18920,19656,38499,38501,
   38921,45025],[4193],[2734,2742,3507,3522,3524,3838,3840,4260,18903,18918,18920,19656,38499,
   38501,38921,45025],[2734,2742,3507,3525,3526,3841,3842,4319,18903,19237,19238,19715,38502,
   38503,38980,45084],[2734,2742,3507,3525,3526,3841,3842,4319,18903,19237,19238,19715,38502,
   38503,38980,45084],[2734,2742,3507,3527,3528,3843,3844,4354,18903,18923,18924,19750,38504,
   38505,39015,45119],[2734,2742,3507,3527,3528,3843,3844,4354,18903,18923,18924,19750,38504,
   38505,39015,45119],[],[],[],[],[],[19848],[19857],[19862],[],[],[],[],
 [19862],[19848],[19857],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [3507],[2792,2800,3500,3501,3507,3544,3550,3592,20549,20550,20556,20593,38205,38211,38253,39156]
  ,[2792,2800,3500,3501,3507,3544,3550,3592,20549,20550,20556,20593,38205,38211,38253,39156],
 [2792,2800,3502,3507,3508,3633,3634,3824,20556,20682,20683,20873,38294,38295,38485,41069],
 [3677,20726],[3714,20763],[3756],[3794,20843],[3507],
 [2792,2800,3502,3507,3508,3633,3634,3824,20556,20682,20683,20873,38294,38295,38485,41069],
 [3714,20763],[3930,20979],[3677,20726],[3930,20979],[3756],[3794,20843],[],[],
 [2792,2800,3507,3517,3518,3833,3834,4139,20556,20882,20883,21188,38494,38495,38800,44904],
 [2792,2800,3507,3517,3518,3833,3834,4139,20556,20882,20883,21188,38494,38495,38800,44904],
 [4193],[],[],[2792,2800,3507,3522,3524,3838,3840,4260,20556,20571,20573,21309,38499,38501,
   38921,45025],[4193],[2792,2800,3507,3522,3524,3838,3840,4260,20556,20571,20573,21309,38499,
   38501,38921,45025],[2792,2800,3507,3525,3526,3841,3842,4319,20556,20890,20891,21368,38502,
   38503,38980,45084],[2792,2800,3507,3525,3526,3841,3842,4319,20556,20890,20891,21368,38502,
   38503,38980,45084],[2792,2800,3507,3527,3528,3843,3844,4354,20556,20576,20577,21403,38504,
   38505,39015,45119],[2792,2800,3507,3527,3528,3843,3844,4354,20556,20576,20577,21403,38504,
   38505,39015,45119],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[3507],
 [2849,2857,3500,3501,3507,3544,3550,3592,22145,22146,22152,22189,38205,38211,38253,39156],
 [2849,2857,3500,3501,3507,3544,3550,3592,22145,22146,22152,22189,38205,38211,38253,39156],
 [2849,2857,3502,3507,3508,3633,3634,3824,12747,22152,22278,22279,22469,38294,38295,38485,41069],
 [3677,22322],[3714,22359],[3756],[3794,22439],[3507],
 [2849,2857,3502,3507,3508,3633,3634,3824,12747,22152,22278,22279,22469,38294,38295,38485,41069],
 [3714,22359],[3930,22575],[3677,22322],[3930,22575],[3756],[3794,22439],[],[],
 [2849,2857,3507,3517,3518,3833,3834,4139,8962,22152,22478,22479,22784,38494,38495,38800,44904],
 [2849,2857,3507,3517,3518,3833,3834,4139,8962,22152,22478,22479,22784,38494,38495,38800,44904],
 [4193],[],[],[2849,2857,3507,3522,3524,3838,3840,4260,22152,22167,22169,22905,38499,38501,
   38921,45025],[4193],[2849,2857,3507,3522,3524,3838,3840,4260,22152,22167,22169,22905,38499,
   38501,38921,45025],[2849,2857,3507,3525,3526,3841,3842,4319,22152,22486,22487,22964,38502,
   38503,38980,45084],[2849,2857,3507,3525,3526,3841,3842,4319,22152,22486,22487,22964,38502,
   38503,38980,45084],[2849,2857,3507,3527,3528,3843,3844,4354,22152,22172,22173,22999,38504,
   38505,39015,45119],[2849,2857,3507,3527,3528,3843,3844,4354,22152,22172,22173,22999,38504,
   38505,39015,45119],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[12979],[],[],[],[],[],[],[],[],[],[],[3507],
 [2905,2913,3500,3501,3507,3544,3550,3592,23685,23686,23692,23729,38205,38211,38253,39156],
 [2905,2913,3500,3501,3507,3544,3550,3592,23685,23686,23692,23729,38205,38211,38253,39156],
 [2905,2913,3502,3507,3508,3633,3634,3824,23692,23818,23819,24009,38294,38295,38485,41069],
 [3677,23862,24157],[3714,23899],[3756],[3794,23979],[3507],
 [2905,2913,3502,3507,3508,3633,3634,3824,23692,23818,23819,24009,38294,38295,38485,41069],
 [3714,23899],[3930,24115],[3677,23862,24157],[3930,24115],[3756],[3794,23979],[],[],
 [2905,2913,3507,3517,3518,3833,3834,4139,23692,24018,24019,24324,38494,38495,38800,44904],
 [2905,2913,3507,3517,3518,3833,3834,4139,23692,24018,24019,24324,38494,38495,38800,44904],
 [4193],[],[],[2905,2913,3507,3522,3524,3838,3840,4260,23692,23707,23709,24445,38499,38501,
   38921,45025],[4193],[2905,2913,3507,3522,3524,3838,3840,4260,23692,23707,23709,24445,38499,
   38501,38921,45025],[2905,2913,3507,3525,3526,3841,3842,4319,23692,24026,24027,24504,38502,
   38503,38980,45084],[2905,2913,3507,3525,3526,3841,3842,4319,23692,24026,24027,24504,38502,
   38503,38980,45084],[2905,2913,3507,3527,3528,3843,3844,4354,23692,23712,23713,24539,38504,
   38505,39015,45119],[2905,2913,3507,3527,3528,3843,3844,4354,23692,23712,23713,24539,38504,
   38505,39015,45119],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[3507],
 [2960,2968,3500,3501,3507,3544,3550,3592,25170,25171,25177,25214,38205,38211,38253,39156],
 [2960,2968,3500,3501,3507,3544,3550,3592,25170,25171,25177,25214,38205,38211,38253,39156],
 [2960,2968,3502,3507,3508,3633,3634,3824,25177,25303,25304,25494,38294,38295,38485,41069],
 [3677,25347],[3714,25384],[3756],[3794,25464],[3507],
 [2960,2968,3502,3507,3508,3633,3634,3824,25177,25303,25304,25494,38294,38295,38485,41069],
 [3714,25384],[3930,25600],[3677,25347],[3930,25600],[3756],[3794,25464],[],[],
 [2960,2968,3507,3517,3518,3833,3834,4139,25177,25503,25504,25809,38494,38495,38800,44904],
 [2960,2968,3507,3517,3518,3833,3834,4139,25177,25503,25504,25809,38494,38495,38800,44904],
 [4193],[],[],[2960,2968,3507,3522,3524,3838,3840,4260,25177,25192,25194,25930,38499,38501,
   38921,45025],[4193],[2960,2968,3507,3522,3524,3838,3840,4260,25177,25192,25194,25930,38499,
   38501,38921,45025],[2960,2968,3507,3525,3526,3841,3842,4319,25177,25511,25512,25989,38502,
   38503,38980,45084],[2960,2968,3507,3525,3526,3841,3842,4319,25177,25511,25512,25989,38502,
   38503,38980,45084],[2960,2968,3507,3527,3528,3843,3844,4354,25177,25197,25198,26024,38504,
   38505,39015,45119],[2960,2968,3507,3527,3528,3843,3844,4354,25177,25197,25198,26024,38504,
   38505,39015,45119],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[26160],[26160],[],[26316],[26316],[],[],[26510],[26510],[3507],
 [3014,3022,3500,3501,3507,3544,3550,3592,26601,26602,26608,26645,38205,38211,38253,39156],
 [3014,3022,3500,3501,3507,3544,3550,3592,26601,26602,26608,26645,38205,38211,38253,39156],
 [3014,3022,3502,3507,3508,3633,3634,3824,26608,26734,26735,26925,38294,38295,38485,41069],
 [3677,26778],[3714,26815],[3756],[3794,26895],[3507],
 [3014,3022,3502,3507,3508,3633,3634,3824,26608,26734,26735,26925,38294,38295,38485,41069],
 [3714,26815],[3930,27031],[3677,26778],[3930,27031],[3756],[3794,26895],[],[],
 [3014,3022,3507,3517,3518,3833,3834,4139,26608,26934,26935,27240,38494,38495,38800,44904],
 [3014,3022,3507,3517,3518,3833,3834,4139,26608,26934,26935,27240,38494,38495,38800,44904],
 [4193],[],[],[3014,3022,3507,3522,3524,3838,3840,4260,26608,26623,26625,27361,38499,38501,
   38921,45025],[4193],[3014,3022,3507,3522,3524,3838,3840,4260,26608,26623,26625,27361,38499,
   38501,38921,45025],[3014,3022,3507,3525,3526,3841,3842,4319,26608,26942,26943,27420,38502,
   38503,38980,45084],[3014,3022,3507,3525,3526,3841,3842,4319,26608,26942,26943,27420,38502,
   38503,38980,45084],[3014,3022,3507,3527,3528,3843,3844,4354,26608,26628,26629,27455,38504,
   38505,39015,45119],[3014,3022,3507,3527,3528,3843,3844,4354,26608,26628,26629,27455,38504,
   38505,39015,45119],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[26160],[27643],[27643],[],[],[27841],[27841],[],[3507],
 [3067,3075,3500,3501,3507,3544,3550,3592,27979,27980,27986,28023,38205,38211,38253,39156],
 [3067,3075,3500,3501,3507,3544,3550,3592,27979,27980,27986,28023,38205,38211,38253,39156],
 [3067,3075,3502,3507,3508,3633,3634,3824,27986,28112,28113,28303,38294,38295,38485,41069],
 [3677,28156],[3714,28193],[3756],[3794,28273],[3507],
 [3067,3075,3502,3507,3508,3633,3634,3824,27986,28112,28113,28303,38294,38295,38485,41069],
 [3714,28193],[3930,28409],[3677,28156],[3930,28409],[3756],[3794,28273],[],[],
 [3067,3075,3507,3517,3518,3833,3834,4139,27986,28312,28313,28618,38494,38495,38800,44904],
 [3067,3075,3507,3517,3518,3833,3834,4139,27986,28312,28313,28618,38494,38495,38800,44904],
 [4193],[],[],[3067,3075,3507,3522,3524,3838,3840,4260,27986,28001,28003,28739,38499,38501,
   38921,45025],[4193],[3067,3075,3507,3522,3524,3838,3840,4260,27986,28001,28003,28739,38499,
   38501,38921,45025],[3067,3075,3507,3525,3526,3841,3842,4319,27986,28320,28321,28798,38502,
   38503,38980,45084],[3067,3075,3507,3525,3526,3841,3842,4319,27986,28320,28321,28798,38502,
   38503,38980,45084],[3067,3075,3507,3527,3528,3843,3844,4354,27986,28006,28007,28833,38504,
   38505,39015,45119],[3067,3075,3507,3527,3528,3843,3844,4354,27986,28006,28007,28833,38504,
   38505,39015,45119],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[28970],[],[28970],[],[29168],[],[29168],[3507],
 [3119,3127,3500,3501,3507,3544,3550,3592,29305,29306,29312,29349,38205,38211,38253,39156],
 [3119,3127,3500,3501,3507,3544,3550,3592,29305,29306,29312,29349,38205,38211,38253,39156],
 [3119,3127,3502,3507,3508,3633,3634,3824,29312,29438,29439,29629,38294,38295,38485,41069],
 [3677,29482],[3714,29519],[3756],[3794,29599],[3507],
 [3119,3127,3502,3507,3508,3633,3634,3824,29312,29438,29439,29629,38294,38295,38485,41069],
 [3714,29519],[3930,29735],[3677,29482],[3930,29735],[3756],[3794,29599],[],[],
 [3119,3127,3507,3517,3518,3833,3834,4139,29312,29638,29639,29944,38494,38495,38800,44904],
 [3119,3127,3507,3517,3518,3833,3834,4139,29312,29638,29639,29944,38494,38495,38800,44904],
 [4193],[],[],[3119,3127,3507,3522,3524,3838,3840,4260,29312,29327,29329,30065,38499,38501,
   38921,45025],[4193],[3119,3127,3507,3522,3524,3838,3840,4260,29312,29327,29329,30065,38499,
   38501,38921,45025],[3119,3127,3507,3525,3526,3841,3842,4319,29312,29646,29647,30124,38502,
   38503,38980,45084],[3119,3127,3507,3525,3526,3841,3842,4319,29312,29646,29647,30124,38502,
   38503,38980,45084],[3119,3127,3507,3527,3528,3843,3844,4354,29312,29332,29333,30159,38504,
   38505,39015,45119],[3119,3127,3507,3527,3528,3843,3844,4354,29312,29332,29333,30159,38504,
   38505,39015,45119],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[27643],[28970],[30394],[30394],[],[],[3507],
 [3170,3178,3500,3501,3507,3544,3550,3592,30580,30581,30587,30624,38205,38211,38253,39156],
 [3170,3178,3500,3501,3507,3544,3550,3592,30580,30581,30587,30624,38205,38211,38253,39156],
 [3170,3178,3502,3507,3508,3633,3634,3824,30587,30713,30714,30904,38294,38295,38485,41069],
 [3677,30757],[3714,30794],[3756],[3794,30874],[3507],
 [3170,3178,3502,3507,3508,3633,3634,3824,30587,30713,30714,30904,38294,38295,38485,41069],
 [3714,30794],[3930,31010],[3677,30757],[3930,31010],[3756],[3794,30874],[],[],
 [3170,3178,3507,3517,3518,3833,3834,4139,30587,30913,30914,31219,38494,38495,38800,44904],
 [3170,3178,3507,3517,3518,3833,3834,4139,30587,30913,30914,31219,38494,38495,38800,44904],
 [4193],[],[],[3170,3178,3507,3522,3524,3838,3840,4260,30587,30602,30604,31340,38499,38501,
   38921,45025],[4193],[3170,3178,3507,3522,3524,3838,3840,4260,30587,30602,30604,31340,38499,
   38501,38921,45025],[3170,3178,3507,3525,3526,3841,3842,4319,30587,30921,30922,31399,38502,
   38503,38980,45084],[3170,3178,3507,3525,3526,3841,3842,4319,30587,30921,30922,31399,38502,
   38503,38980,45084],[3170,3178,3507,3527,3528,3843,3844,4354,30587,30607,30608,31434,38504,
   38505,39015,45119],[3170,3178,3507,3527,3528,3843,3844,4354,30587,30607,30608,31434,38504,
   38505,39015,45119],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[26316],[31620],[],[31620],[],[3507],
 [3220,3228,3500,3501,3507,3544,3550,3592,31805,31806,31812,31849,38205,38211,38253,39156],
 [3220,3228,3500,3501,3507,3544,3550,3592,31805,31806,31812,31849,38205,38211,38253,39156],
 [3220,3228,3502,3507,3508,3633,3634,3824,31812,31938,31939,32129,38294,38295,38485,41069],
 [3677,31982],[3714,32019],[3756],[3794,32099],[3507],
 [3220,3228,3502,3507,3508,3633,3634,3824,31812,31938,31939,32129,38294,38295,38485,41069],
 [3714,32019],[3930,32235],[3677,31982],[3930,32235],[3756],[3794,32099],[],[],
 [3220,3228,3507,3517,3518,3833,3834,4139,31812,32138,32139,32444,38494,38495,38800,44904],
 [3220,3228,3507,3517,3518,3833,3834,4139,31812,32138,32139,32444,38494,38495,38800,44904],
 [4193],[],[],[3220,3228,3507,3522,3524,3838,3840,4260,31812,31827,31829,32565,38499,38501,
   38921,45025],[4193],[3220,3228,3507,3522,3524,3838,3840,4260,31812,31827,31829,32565,38499,
   38501,38921,45025],[3220,3228,3507,3525,3526,3841,3842,4319,31812,32146,32147,32624,38502,
   38503,38980,45084],[3220,3228,3507,3525,3526,3841,3842,4319,31812,32146,32147,32624,38502,
   38503,38980,45084],[3220,3228,3507,3527,3528,3843,3844,4354,31812,31832,31833,32659,38504,
   38505,39015,45119],[3220,3228,3507,3527,3528,3843,3844,4354,31812,31832,31833,32659,38504,
   38505,39015,45119],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[32797],[],[],[32797],[3507],[3269,3277,3500,3501,3507,3544,3550,3592,32981,32982,
   32988,33025,38205,38211,38253,39156],[3269,3277,3500,3501,3507,3544,3550,3592,32981,32982,
   32988,33025,38205,38211,38253,39156],[3269,3277,3502,3507,3508,3633,3634,3824,32988,33114,
   33115,33305,38294,38295,38485,41069],[3677,33158],[3714,33195],[3756],[3794,33275],
 [3507],[3269,3277,3502,3507,3508,3633,3634,3824,32988,33114,33115,33305,38294,38295,38485,41069]
  ,[3714,33195],[3930,33411],[3677,33158],[3930,33411],[3756],[3794,33275],[],[],
 [3269,3277,3507,3517,3518,3833,3834,4139,32988,33314,33315,33620,38494,38495,38800,44904],
 [3269,3277,3507,3517,3518,3833,3834,4139,32988,33314,33315,33620,38494,38495,38800,44904],
 [4193],[],[],[3269,3277,3507,3522,3524,3838,3840,4260,32988,33003,33005,33741,38499,38501,
   38921,45025],[4193],[3269,3277,3507,3522,3524,3838,3840,4260,32988,33003,33005,33741,38499,
   38501,38921,45025],[3269,3277,3507,3525,3526,3841,3842,4319,32988,33322,33323,33800,38502,
   38503,38980,45084],[3269,3277,3507,3525,3526,3841,3842,4319,32988,33322,33323,33800,38502,
   38503,38980,45084],[3269,3277,3507,3527,3528,3843,3844,4354,32988,33008,33009,33835,38504,
   38505,39015,45119],[3269,3277,3507,3527,3528,3843,3844,4354,32988,33008,33009,33835,38504,
   38505,39015,45119],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[30394],[31620],[32797],[3507],[3317,3325,3500,3501,3507,3544,3550,3592,34109,34110,
   34116,34153,38205,38211,38253,39156],[3317,3325,3500,3501,3507,3544,3550,3592,34109,34110,
   34116,34153,38205,38211,38253,39156],[3317,3325,3502,3507,3508,3633,3634,3824,34116,34242,
   34243,34433,38294,38295,38485,41069],[3677,34286],[3714,34323],[3756],[3794,34403],
 [3507],[3317,3325,3502,3507,3508,3633,3634,3824,34116,34242,34243,34433,38294,38295,38485,41069]
  ,[3714,34323],[3930,34539],[3677,34286],[3930,34539],[3756],[3794,34403],[],[],
 [3317,3325,3507,3517,3518,3833,3834,4139,34116,34442,34443,34748,38494,38495,38800,44904],
 [3317,3325,3507,3517,3518,3833,3834,4139,34116,34442,34443,34748,38494,38495,38800,44904],
 [4193],[],[],[3317,3325,3507,3522,3524,3838,3840,4260,34116,34131,34133,34869,38499,38501,
   38921,45025],[4193],[3317,3325,3507,3522,3524,3838,3840,4260,34116,34131,34133,34869,38499,
   38501,38921,45025],[3317,3325,3507,3525,3526,3841,3842,4319,34116,34450,34451,34928,38502,
   38503,38980,45084],[3317,3325,3507,3525,3526,3841,3842,4319,34116,34450,34451,34928,38502,
   38503,38980,45084],[3317,3325,3507,3527,3528,3843,3844,4354,34116,34136,34137,34963,38504,
   38505,39015,45119],[3317,3325,3507,3527,3528,3843,3844,4354,34116,34136,34137,34963,38504,
   38505,39015,45119],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[27841],[29168],[3507],[3364,3372,3500,3501,3507,3544,3550,3592,35190,35191,35197,35234,
   38205,38211,38253,39156],[3364,3372,3500,3501,3507,3544,3550,3592,35190,35191,35197,35234,
   38205,38211,38253,39156],[3364,3372,3502,3507,3508,3633,3634,3824,35197,35323,35324,35514,
   38294,38295,38485,41069],[3677,35367],[3714,35404],[3756],[3794,35484],[3507],
 [3364,3372,3502,3507,3508,3633,3634,3824,35197,35323,35324,35514,38294,38295,38485,41069],
 [3714,35404],[3930,35620],[3677,35367],[3930,35620],[3756],[3794,35484],[],[],
 [3364,3372,3507,3517,3518,3833,3834,4139,35197,35523,35524,35829,38494,38495,38800,44904],
 [3364,3372,3507,3517,3518,3833,3834,4139,35197,35523,35524,35829,38494,38495,38800,44904],
 [4193],[],[],[3364,3372,3507,3522,3524,3838,3840,4260,35197,35212,35214,35950,38499,38501,
   38921,45025],[4193],[3364,3372,3507,3522,3524,3838,3840,4260,35197,35212,35214,35950,38499,
   38501,38921,45025],[3364,3372,3507,3525,3526,3841,3842,4319,35197,35531,35532,36009,38502,
   38503,38980,45084],[3364,3372,3507,3525,3526,3841,3842,4319,35197,35531,35532,36009,38502,
   38503,38980,45084],[3364,3372,3507,3527,3528,3843,3844,4354,35197,35217,35218,36044,38504,
   38505,39015,45119],[3364,3372,3507,3527,3528,3843,3844,4354,35197,35217,35218,36044,38504,
   38505,39015,45119],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[26510],[3507],[3410,3418,3500,3501,3507,3544,3550,3592,36225,36226,36232,36269,38205,
   38211,38253,39156],[3410,3418,3500,3501,3507,3544,3550,3592,36225,36226,36232,36269,38205,
   38211,38253,39156],[3410,3418,3502,3507,3508,3633,3634,3824,36232,36358,36359,36549,38294,
   38295,38485,41069],[3677,36402],[3714,36439],[3756],[3794,36519],[3507],
 [3410,3418,3502,3507,3508,3633,3634,3824,36232,36358,36359,36549,38294,38295,38485,41069],
 [3714,36439],[3930,36655],[3677,36402],[3930,36655],[3756],[3794,36519],[],[],
 [3410,3418,3507,3517,3518,3833,3834,4139,36232,36558,36559,36864,38494,38495,38800,44904],
 [3410,3418,3507,3517,3518,3833,3834,4139,36232,36558,36559,36864,38494,38495,38800,44904],
 [4193],[],[],[3410,3418,3507,3522,3524,3838,3840,4260,36232,36247,36249,36985,38499,38501,
   38921,45025],[4193],[3410,3418,3507,3522,3524,3838,3840,4260,36232,36247,36249,36985,38499,
   38501,38921,45025],[3410,3418,3507,3525,3526,3841,3842,4319,36232,36566,36567,37044,38502,
   38503,38980,45084],[3410,3418,3507,3525,3526,3841,3842,4319,36232,36566,36567,37044,38502,
   38503,38980,45084],[3410,3418,3507,3527,3528,3843,3844,4354,36232,36252,36253,37079,38504,
   38505,39015,45119],[3410,3418,3507,3527,3528,3843,3844,4354,36232,36252,36253,37079,38504,
   38505,39015,45119],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[3507],[3455,3463,3500,3501,3507,3544,3550,3592,37215,37216,37222,37259,38205,38211,38253,
   39156],[3455,3463,3500,3501,3507,3544,3550,3592,37215,37216,37222,37259,38205,38211,38253,
   39156],[3455,3463,3502,3507,3508,3633,3634,3824,37222,37348,37349,37539,38294,38295,38485,
   41069],[3677,37392],[3714,37429],[3756],[3794,37509],[3507],
 [3455,3463,3502,3507,3508,3633,3634,3824,37222,37348,37349,37539,38294,38295,38485,41069],
 [3714,37429],[3930,37645],[3677,37392],[3930,37645],[3756],[3794,37509],[],[],
 [3455,3463,3507,3517,3518,3833,3834,4139,37222,37548,37549,37854,38494,38495,38800,44904],
 [3455,3463,3507,3517,3518,3833,3834,4139,37222,37548,37549,37854,38494,38495,38800,44904],
 [4193],[],[],[3455,3463,3507,3522,3524,3838,3840,4260,37222,37237,37239,37975,38499,38501,
   38921,45025],[4193],[3455,3463,3507,3522,3524,3838,3840,4260,37222,37237,37239,37975,38499,
   38501,38921,45025],[3455,3463,3507,3525,3526,3841,3842,4319,37222,37556,37557,38034,38502,
   38503,38980,45084],[3455,3463,3507,3525,3526,3841,3842,4319,37222,37556,37557,38034,38502,
   38503,38980,45084],[3455,3463,3507,3527,3528,3843,3844,4354,37222,37242,37243,38069,38504,
   38505,39015,45119],[3455,3463,3507,3527,3528,3843,3844,4354,37222,37242,37243,38069,38504,
   38505,39015,45119],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[3507,38205],[3507,38205],[3507,41069],[3507,3677,3714,38331,38557,41850,42593],
 [3507,3677,3714,38331,38557,41850,42593],[3507,3756],[3507,3794,38455,43965],[],
 [3507,41069],[3507,3677,3714,38331,38557,41850,42593],[3507,3930,38591,44695],
 [3507,3677,3714,38331,38557,41850,42593],[3507,3930,38591,44695],[3507,3756],
 [3507,3794,38455,43965],[3507],[3507],[3507,44904],[3507,44904],[3507,4193],[3507],
 [3507],[3507,38921],[3507,4193],[3507,38921],[3507,45084],[3507,45084],[3507,39015],
 [3507,39015],[3507],[3507],[3507],[3507],[3507],[3507],[3507],[3507],[3507],
 [3507],[3507],[3507],[3507],[3507],[3507],[3507,38205],
 [3500,3501,3502,3503,3504,3507,3508,3509,3511,3544,3550,3592,3633,3634,3670,3673,3675,3677,3712,
   3714,3716,3824,3825,3827,3896,38205,38206,38207,38208,38211,38212,38213,38215,38248,38249,
   38250,38253,38254,38255,38257,38290,38291,38294,38295,38296,38298,38331,38334,38335,38336,38338,
   38373,38374,38375,38377,38485,38486,38488,38521,38523,38557,39151,39152,39153,39156,39157,39158,
   39160,39193,39194,39197,39198,39199,39201,39234,39237,39238,39239,39241,39276,39277,39278,39280,
   39388,39389,39391,39424,39426,39460,40054,40055,40058,40059,40060,40062,40095,40098,40099,40100,
   40102,40137,40138,40139,40141,40249,40250,40252,40285,40287,40321,40915,40918,40919,40920,40922,
   40957,40958,40959,40961,41069,41070,41072,41105,41107,41141,41737,41738,41739,41741,41849,41850,
   41852,41885,41887,41921,42590,42591,42593,42626,42628,42662,44625,44627,44661,45256],
 [3500,3501,3502,3503,3504,3507,3508,3509,3511,3544,3550,3592,3633,3634,3670,3673,3675,3677,3712,
   3714,3716,3824,3825,3827,3896,38205,38206,38207,38208,38211,38212,38213,38215,38248,38249,
   38250,38253,38254,38255,38257,38290,38291,38294,38295,38296,38298,38331,38334,38335,38336,38338,
   38373,38374,38375,38377,38485,38486,38488,38521,38523,38557,39151,39152,39153,39156,39157,39158,
   39160,39193,39194,39197,39198,39199,39201,39234,39237,39238,39239,39241,39276,39277,39278,39280,
   39388,39389,39391,39424,39426,39460,40054,40055,40058,40059,40060,40062,40095,40098,40099,40100,
   40102,40137,40138,40139,40141,40249,40250,40252,40285,40287,40321,40915,40918,40919,40920,40922,
   40957,40958,40959,40961,41069,41070,41072,41105,41107,41141,41737,41738,41739,41741,41849,41850,
   41852,41885,41887,41921,42590,42591,42593,42626,42628,42662,44625,44627,44661,45256],
 [3500,3501,3502,3503,3504,3507,3508,3509,3511,3544,3550,3592,3633,3634,3670,3673,3675,3677,3712,
   3714,3716,3824,3825,3827,3896,38205,38206,38207,38208,38211,38212,38213,38215,38248,38249,
   38250,38253,38254,38255,38257,38290,38291,38294,38295,38296,38298,38331,38334,38335,38336,38338,
   38373,38374,38375,38377,38485,38486,38488,38521,38523,38557,39151,39152,39153,39156,39157,39158,
   39160,39193,39194,39197,39198,39199,39201,39234,39237,39238,39239,39241,39276,39277,39278,39280,
   39388,39389,39391,39424,39426,39460,40054,40055,40058,40059,40060,40062,40095,40098,40099,40100,
   40102,40137,40138,40139,40141,40249,40250,40252,40285,40287,40321,40915,40918,40919,40920,40922,
   40957,40958,40959,40961,41069,41070,41072,41105,41107,41141,41737,41738,41739,41741,41849,41850,
   41852,41885,41887,41921,42590,42591,42593,42626,42628,42662,44625,44627,44661,45256],
 [3500,3501,3505,3506,3507,3513,3514,3544,3550,3592,3750,3756,3787,3794,3829,3830,38205,38209,
   38210,38211,38217,38218,38251,38252,38253,38259,38260,38410,38411,38417,38418,38448,38454,38455,
   38490,38491,38686,39154,39155,39156,39162,39163,39313,39321,39358,39589,40174,40218,40219,40450,
   43263,43298,43965,44160],[3500,3501,3505,3506,3507,3513,3514,3544,3550,3592,3750,3756,3787,
   3794,3829,3830,38205,38209,38210,38211,38217,38218,38251,38252,38253,38259,38260,38410,38411,
   38417,38418,38448,38454,38455,38490,38491,38686,39154,39155,39156,39162,39163,39313,39321,39358,
   39589,40174,40218,40219,40450,43263,43298,43965,44160],[3507,38205],
 [3500,3501,3502,3503,3504,3507,3508,3509,3511,3544,3550,3592,3633,3634,3670,3673,3675,3677,3712,
   3714,3716,3824,3825,3827,3896,38205,38206,38207,38208,38211,38212,38213,38215,38248,38249,
   38250,38253,38254,38255,38257,38290,38291,38294,38295,38296,38298,38331,38334,38335,38336,38338,
   38373,38374,38375,38377,38485,38486,38488,38521,38523,38557,39151,39152,39153,39156,39157,39158,
   39160,39193,39194,39197,39198,39199,39201,39234,39237,39238,39239,39241,39276,39277,39278,39280,
   39388,39389,39391,39424,39426,39460,40054,40055,40058,40059,40060,40062,40095,40098,40099,40100,
   40102,40137,40138,40139,40141,40249,40250,40252,40285,40287,40321,40915,40918,40919,40920,40922,
   40957,40958,40959,40961,41069,41070,41072,41105,41107,41141,41737,41738,41739,41741,41849,41850,
   41852,41885,41887,41921,42590,42591,42593,42626,42628,42662,44625,44627,44661,45256],
 [3500,3501,3502,3503,3504,3507,3508,3509,3511,3544,3550,3592,3633,3634,3670,3673,3675,3677,3712,
   3714,3716,3824,3825,3827,3896,38205,38206,38207,38208,38211,38212,38213,38215,38248,38249,
   38250,38253,38254,38255,38257,38290,38291,38294,38295,38296,38298,38331,38334,38335,38336,38338,
   38373,38374,38375,38377,38485,38486,38488,38521,38523,38557,39151,39152,39153,39156,39157,39158,
   39160,39193,39194,39197,39198,39199,39201,39234,39237,39238,39239,39241,39276,39277,39278,39280,
   39388,39389,39391,39424,39426,39460,40054,40055,40058,40059,40060,40062,40095,40098,40099,40100,
   40102,40137,40138,40139,40141,40249,40250,40252,40285,40287,40321,40915,40918,40919,40920,40922,
   40957,40958,40959,40961,41069,41070,41072,41105,41107,41141,41737,41738,41739,41741,41849,41850,
   41852,41885,41887,41921,42590,42591,42593,42626,42628,42662,44625,44627,44661,45256],
 [3500,3501,3507,3510,3512,3544,3550,3592,3826,3828,3930,38205,38211,38214,38216,38253,38256,
   38258,38487,38489,38591,39156,39159,39161,39494,40355,44695],
 [3500,3501,3502,3503,3504,3507,3508,3509,3511,3544,3550,3592,3633,3634,3670,3673,3675,3677,3712,
   3714,3716,3824,3825,3827,3896,38205,38206,38207,38208,38211,38212,38213,38215,38248,38249,
   38250,38253,38254,38255,38257,38290,38291,38294,38295,38296,38298,38331,38334,38335,38336,38338,
   38373,38374,38375,38377,38485,38486,38488,38521,38523,38557,39151,39152,39153,39156,39157,39158,
   39160,39193,39194,39197,39198,39199,39201,39234,39237,39238,39239,39241,39276,39277,39278,39280,
   39388,39389,39391,39424,39426,39460,40054,40055,40058,40059,40060,40062,40095,40098,40099,40100,
   40102,40137,40138,40139,40141,40249,40250,40252,40285,40287,40321,40915,40918,40919,40920,40922,
   40957,40958,40959,40961,41069,41070,41072,41105,41107,41141,41737,41738,41739,41741,41849,41850,
   41852,41885,41887,41921,42590,42591,42593,42626,42628,42662,44625,44627,44661,45256],
 [3500,3501,3507,3510,3512,3544,3550,3592,3826,3828,3930,38205,38211,38214,38216,38253,38256,
   38258,38487,38489,38591,39156,39159,39161,39494,40355,44695],
 [3500,3501,3505,3506,3507,3513,3514,3544,3550,3592,3750,3756,3787,3794,3829,3830,38205,38209,
   38210,38211,38217,38218,38251,38252,38253,38259,38260,38410,38411,38417,38418,38448,38454,38455,
   38490,38491,38686,39154,39155,39156,39162,39163,39313,39321,39358,39589,40174,40218,40219,40450,
   43263,43298,43965,44160],[3500,3501,3505,3506,3507,3513,3514,3544,3550,3592,3750,3756,3787,
   3794,3829,3830,38205,38209,38210,38211,38217,38218,38251,38252,38253,38259,38260,38410,38411,
   38417,38418,38448,38454,38455,38490,38491,38686,39154,39155,39156,39162,39163,39313,39321,39358,
   39589,40174,40218,40219,40450,43263,43298,43965,44160],
 [3500,3501,3507,3515,3544,3550,3592,3831,38205,38211,38219,38253,38261,38492,39156,39164],
 [3500,3501,3507,3516,3544,3550,3592,3832,38205,38211,38220,38253,38262,38493,39156,39165],
 [2279,3500,3501,3507,3517,3518,3544,3550,3592,3833,3834,4139,5645,5646,5662,5689,5695,5705,5706,
   5747,5978,5979,6284,7725,7726,7743,7769,7786,7817,7827,7828,8058,8059,8364,38205,38211,38221,
   38222,38253,38263,38264,38494,38495,38800,39156,39166,39167,39397,39398,39703,40258,40259,40564,
   44904],[2279,3500,3501,3507,3517,3518,3544,3550,3592,3833,3834,4139,5645,5646,5662,5689,
   5695,5705,5706,5747,5978,5979,6284,7725,7726,7743,7769,7786,7817,7827,7828,8058,8059,8364,
   38205,38211,38221,38222,38253,38263,38264,38494,38495,38800,39156,39166,39167,39397,39398,39703,
   40258,40259,40564,44904],[3500,3501,3507,3519,3523,3544,3550,3592,3835,3839,4193,38205,38211,
   38223,38227,38253,38265,38269,38496,38500,38854,39156,39168,39172,44958],
 [3500,3501,3507,3520,3522,3524,3544,3550,3592,3836,3838,3840,4260,38205,38211,38224,38226,38228,
   38253,38266,38268,38270,38497,38499,38501,38876,38878,38921,39156,39169,39171,39173,39779,39781,
   39824,40640,40642,40685,45025,50394],[3500,3501,3507,3521,3544,3550,3592,3837,38205,38211,
   38225,38253,38267,38498,39156,39170],[3500,3501,3507,3520,3522,3524,3544,3550,3592,3836,3838,
   3840,4260,38205,38211,38224,38226,38228,38253,38266,38268,38270,38497,38499,38501,38876,38878,
   38921,39156,39169,39171,39173,39779,39781,39824,40640,40642,40685,45025,50394],
 [3500,3501,3507,3519,3523,3544,3550,3592,3835,3839,4193,38205,38211,38223,38227,38253,38265,
   38269,38496,38500,38854,39156,39168,39172,44958],
 [3500,3501,3507,3520,3522,3524,3544,3550,3592,3836,3838,3840,4260,38205,38211,38224,38226,38228,
   38253,38266,38268,38270,38497,38499,38501,38876,38878,38921,39156,39169,39171,39173,39779,39781,
   39824,40640,40642,40685,45025,50394],[3500,3501,3507,3525,3526,3544,3550,3592,3841,3842,4319,
   38205,38211,38229,38230,38253,38271,38272,38502,38503,38980,39156,39174,39175,39405,39406,39883,
   40266,40267,40744,45084],[3500,3501,3507,3525,3526,3544,3550,3592,3841,3842,4319,38205,38211,
   38229,38230,38253,38271,38272,38502,38503,38980,39156,39174,39175,39405,39406,39883,40266,40267,
   40744,45084],[3500,3501,3507,3527,3528,3544,3550,3592,3843,3844,4354,38205,38211,38231,38232,
   38253,38273,38274,38504,38505,39015,39156,39176,39177,39918,40779,45119],
 [3500,3501,3507,3527,3528,3544,3550,3592,3843,3844,4354,38205,38211,38231,38232,38253,38273,
   38274,38504,38505,39015,39156,39176,39177,39918,40779,45119],
 [3500,3501,3507,3529,3544,3550,3592,3845,38205,38211,38233,38253,38275,38506,39156,39178],
 [3500,3501,3507,3530,3531,3544,3550,3592,3846,3847,38205,38211,38234,38235,38253,38276,38277,
   38507,38508,39060,39156,39179,39180,39963,40824],
 [3500,3501,3507,3530,3531,3544,3550,3592,3846,3847,38205,38211,38234,38235,38253,38276,38277,
   38507,38508,39060,39156,39179,39180,39963,40824],
 [3500,3501,3507,3532,3544,3550,3592,3848,38205,38211,38236,38253,38278,38509,39156,39181],
 [3500,3501,3507,3533,3544,3550,3592,3849,38205,38211,38237,38253,38279,38510,39156,39182],
 [3500,3501,3507,3534,3535,3544,3550,3592,3850,3851,38205,38211,38238,38239,38253,38280,38281,
   38511,38512,39106,39156,39183,39184,40009,40870],
 [3500,3501,3507,3534,3535,3544,3550,3592,3850,3851,38205,38211,38238,38239,38253,38280,38281,
   38511,38512,39106,39156,39183,39184,40009,40870],
 [3500,3501,3507,3536,3544,3550,3592,3852,38205,38211,38240,38253,38282,38513,39156,39185],
 [3500,3501,3507,3537,3544,3550,3592,3853,38205,38211,38241,38253,38283,38514,39156,39186],
 [3500,3501,3507,3538,3544,3550,3592,3854,38205,38211,38242,38253,38284,38515,39156,39187],
 [3500,3501,3507,3539,3544,3550,3592,3855,38205,38211,38243,38253,38285,38516,39156,39188],
 [3500,3501,3507,3540,3544,3550,3592,3856,38205,38211,38244,38253,38286,38517,39156,39189],
 [3500,3501,3507,3541,3544,3550,3592,3857,38205,38211,38245,38253,38287,38518,39156,39190],
 [3500,3501,3507,3542,3543,3544,3550,3592,3858,3859,38205,38211,38246,38247,38253,38288,38289,
   38519,38520,39150,39156,39191,39192,40053,40914],
 [3500,3501,3507,3542,3543,3544,3550,3592,3858,3859,38205,38211,38246,38247,38253,38288,38289,
   38519,38520,39150,39156,39191,39192,40053,40914],
 [3500,3501,3502,3503,3504,3507,3508,3509,3511,3544,3550,3592,3633,3634,3670,3673,3675,3677,3712,
   3714,3716,3824,3825,3827,3896,38205,38206,38207,38208,38211,38212,38213,38215,38248,38249,
   38250,38253,38254,38255,38257,38290,38291,38294,38295,38296,38298,38331,38334,38335,38336,38338,
   38373,38374,38375,38377,38485,38486,38488,38521,38523,38557,39151,39152,39153,39156,39157,39158,
   39160,39193,39194,39197,39198,39199,39201,39234,39237,39238,39239,39241,39276,39277,39278,39280,
   39388,39389,39391,39424,39426,39460,40054,40055,40058,40059,40060,40062,40095,40098,40099,40100,
   40102,40137,40138,40139,40141,40249,40250,40252,40285,40287,40321,40915,40918,40919,40920,40922,
   40957,40958,40959,40961,41069,41070,41072,41105,41107,41141,41737,41738,41739,41741,41849,41850,
   41852,41885,41887,41921,42590,42591,42593,42626,42628,42662,44625,44627,44661,45256],
 [3500,3501,3502,3503,3504,3507,3508,3509,3511,3544,3550,3592,3633,3634,3670,3673,3675,3677,3712,
   3714,3716,3824,3825,3827,3896,38205,38206,38207,38208,38211,38212,38213,38215,38248,38249,
   38250,38253,38254,38255,38257,38290,38291,38294,38295,38296,38298,38331,38334,38335,38336,38338,
   38373,38374,38375,38377,38485,38486,38488,38521,38523,38557,39151,39152,39153,39156,39157,39158,
   39160,39193,39194,39197,39198,39199,39201,39234,39237,39238,39239,39241,39276,39277,39278,39280,
   39388,39389,39391,39424,39426,39460,40054,40055,40058,40059,40060,40062,40095,40098,40099,40100,
   40102,40137,40138,40139,40141,40249,40250,40252,40285,40287,40321,40915,40918,40919,40920,40922,
   40957,40958,40959,40961,41069,41070,41072,41105,41107,41141,41737,41738,41739,41741,41849,41850,
   41852,41885,41887,41921,42590,42591,42593,42626,42628,42662,44625,44627,44661,45256],
 [3500,3501,3502,3503,3504,3507,3508,3509,3511,3544,3550,3592,3633,3634,3670,3673,3675,3677,3712,
   3714,3716,3824,3825,3827,3896,38205,38206,38207,38208,38211,38212,38213,38215,38248,38249,
   38250,38253,38254,38255,38257,38290,38291,38294,38295,38296,38298,38331,38334,38335,38336,38338,
   38373,38374,38375,38377,38485,38486,38488,38521,38523,38557,39151,39152,39153,39156,39157,39158,
   39160,39193,39194,39197,39198,39199,39201,39234,39237,39238,39239,39241,39276,39277,39278,39280,
   39388,39389,39391,39424,39426,39460,40054,40055,40058,40059,40060,40062,40095,40098,40099,40100,
   40102,40137,40138,40139,40141,40249,40250,40252,40285,40287,40321,40915,40918,40919,40920,40922,
   40957,40958,40959,40961,41069,41070,41072,41105,41107,41141,41737,41738,41739,41741,41849,41850,
   41852,41885,41887,41921,42590,42591,42593,42626,42628,42662,44625,44627,44661,45256],
 [3500,3501,3505,3506,3507,3513,3514,3544,3550,3592,3750,3756,3787,3794,3829,3830,38205,38209,
   38210,38211,38217,38218,38251,38252,38253,38259,38260,38410,38411,38417,38418,38448,38454,38455,
   38490,38491,38686,39154,39155,39156,39162,39163,39313,39321,39358,39589,40174,40218,40219,40450,
   43263,43298,43965,44160],[3500,3501,3505,3506,3507,3513,3514,3544,3550,3592,3750,3756,3787,
   3794,3829,3830,38205,38209,38210,38211,38217,38218,38251,38252,38253,38259,38260,38410,38411,
   38417,38418,38448,38454,38455,38490,38491,38686,39154,39155,39156,39162,39163,39313,39321,39358,
   39589,40174,40218,40219,40450,43263,43298,43965,44160],[3507,38205],
 [3500,3501,3502,3503,3504,3507,3508,3509,3511,3544,3550,3592,3633,3634,3670,3673,3675,3677,3712,
   3714,3716,3824,3825,3827,3896,38205,38206,38207,38208,38211,38212,38213,38215,38248,38249,
   38250,38253,38254,38255,38257,38290,38291,38294,38295,38296,38298,38331,38334,38335,38336,38338,
   38373,38374,38375,38377,38485,38486,38488,38521,38523,38557,39151,39152,39153,39156,39157,39158,
   39160,39193,39194,39197,39198,39199,39201,39234,39237,39238,39239,39241,39276,39277,39278,39280,
   39388,39389,39391,39424,39426,39460,40054,40055,40058,40059,40060,40062,40095,40098,40099,40100,
   40102,40137,40138,40139,40141,40249,40250,40252,40285,40287,40321,40915,40918,40919,40920,40922,
   40957,40958,40959,40961,41069,41070,41072,41105,41107,41141,41737,41738,41739,41741,41849,41850,
   41852,41885,41887,41921,42590,42591,42593,42626,42628,42662,44625,44627,44661,45256],
 [3500,3501,3502,3503,3504,3507,3508,3509,3511,3544,3550,3592,3633,3634,3670,3673,3675,3677,3712,
   3714,3716,3824,3825,3827,3896,38205,38206,38207,38208,38211,38212,38213,38215,38248,38249,
   38250,38253,38254,38255,38257,38290,38291,38294,38295,38296,38298,38331,38334,38335,38336,38338,
   38373,38374,38375,38377,38485,38486,38488,38521,38523,38557,39151,39152,39153,39156,39157,39158,
   39160,39193,39194,39197,39198,39199,39201,39234,39237,39238,39239,39241,39276,39277,39278,39280,
   39388,39389,39391,39424,39426,39460,40054,40055,40058,40059,40060,40062,40095,40098,40099,40100,
   40102,40137,40138,40139,40141,40249,40250,40252,40285,40287,40321,40915,40918,40919,40920,40922,
   40957,40958,40959,40961,41069,41070,41072,41105,41107,41141,41737,41738,41739,41741,41849,41850,
   41852,41885,41887,41921,42590,42591,42593,42626,42628,42662,44625,44627,44661,45256],
 [3500,3501,3507,3510,3512,3544,3550,3592,3826,3828,3930,38205,38211,38214,38216,38253,38256,
   38258,38487,38489,38591,39156,39159,39161,39494,40355,44695],
 [3500,3501,3502,3503,3504,3507,3508,3509,3511,3544,3550,3592,3633,3634,3670,3673,3675,3677,3712,
   3714,3716,3824,3825,3827,3896,38205,38206,38207,38208,38211,38212,38213,38215,38248,38249,
   38250,38253,38254,38255,38257,38290,38291,38294,38295,38296,38298,38331,38334,38335,38336,38338,
   38373,38374,38375,38377,38485,38486,38488,38521,38523,38557,39151,39152,39153,39156,39157,39158,
   39160,39193,39194,39197,39198,39199,39201,39234,39237,39238,39239,39241,39276,39277,39278,39280,
   39388,39389,39391,39424,39426,39460,40054,40055,40058,40059,40060,40062,40095,40098,40099,40100,
   40102,40137,40138,40139,40141,40249,40250,40252,40285,40287,40321,40915,40918,40919,40920,40922,
   40957,40958,40959,40961,41069,41070,41072,41105,41107,41141,41737,41738,41739,41741,41849,41850,
   41852,41885,41887,41921,42590,42591,42593,42626,42628,42662,44625,44627,44661,45256],
 [3500,3501,3507,3510,3512,3544,3550,3592,3826,3828,3930,38205,38211,38214,38216,38253,38256,
   38258,38487,38489,38591,39156,39159,39161,39494,40355,44695],
 [3500,3501,3505,3506,3507,3513,3514,3544,3550,3592,3750,3756,3787,3794,3829,3830,38205,38209,
   38210,38211,38217,38218,38251,38252,38253,38259,38260,38410,38411,38417,38418,38448,38454,38455,
   38490,38491,38686,39154,39155,39156,39162,39163,39313,39321,39358,39589,40174,40218,40219,40450,
   43263,43298,43965,44160],[3500,3501,3505,3506,3507,3513,3514,3544,3550,3592,3750,3756,3787,
   3794,3829,3830,38205,38209,38210,38211,38217,38218,38251,38252,38253,38259,38260,38410,38411,
   38417,38418,38448,38454,38455,38490,38491,38686,39154,39155,39156,39162,39163,39313,39321,39358,
   39589,40174,40218,40219,40450,43263,43298,43965,44160],
 [3500,3501,3507,3515,3544,3550,3592,3831,38205,38211,38219,38253,38261,38492,39156,39164],
 [3500,3501,3507,3516,3544,3550,3592,3832,38205,38211,38220,38253,38262,38493,39156,39165],
 [2279,3500,3501,3507,3517,3518,3544,3550,3592,3833,3834,4139,5645,5646,5662,5689,5695,5705,5706,
   5747,5978,5979,6284,7725,7726,7743,7769,7786,7817,7827,7828,8058,8059,8364,38205,38211,38221,
   38222,38253,38263,38264,38494,38495,38800,39156,39166,39167,39397,39398,39703,40258,40259,40564,
   44904],[2279,3500,3501,3507,3517,3518,3544,3550,3592,3833,3834,4139,5645,5646,5662,5689,
   5695,5705,5706,5747,5978,5979,6284,7725,7726,7743,7769,7786,7817,7827,7828,8058,8059,8364,
   38205,38211,38221,38222,38253,38263,38264,38494,38495,38800,39156,39166,39167,39397,39398,39703,
   40258,40259,40564,44904],[3500,3501,3507,3519,3523,3544,3550,3592,3835,3839,4193,38205,38211,
   38223,38227,38253,38265,38269,38496,38500,38854,39156,39168,39172,44958],
 [3500,3501,3507,3520,3522,3524,3544,3550,3592,3836,3838,3840,4260,38205,38211,38224,38226,38228,
   38253,38266,38268,38270,38497,38499,38501,38876,38878,38921,39156,39169,39171,39173,39779,39781,
   39824,40640,40642,40685,45025,50394],[3500,3501,3507,3521,3544,3550,3592,3837,38205,38211,
   38225,38253,38267,38498,39156,39170],[3500,3501,3507,3520,3522,3524,3544,3550,3592,3836,3838,
   3840,4260,38205,38211,38224,38226,38228,38253,38266,38268,38270,38497,38499,38501,38876,38878,
   38921,39156,39169,39171,39173,39779,39781,39824,40640,40642,40685,45025,50394],
 [3500,3501,3507,3519,3523,3544,3550,3592,3835,3839,4193,38205,38211,38223,38227,38253,38265,
   38269,38496,38500,38854,39156,39168,39172,44958],
 [3500,3501,3507,3520,3522,3524,3544,3550,3592,3836,3838,3840,4260,38205,38211,38224,38226,38228,
   38253,38266,38268,38270,38497,38499,38501,38876,38878,38921,39156,39169,39171,39173,39779,39781,
   39824,40640,40642,40685,45025,50394],[3500,3501,3507,3525,3526,3544,3550,3592,3841,3842,4319,
   38205,38211,38229,38230,38253,38271,38272,38502,38503,38980,39156,39174,39175,39405,39406,39883,
   40266,40267,40744,45084],[3500,3501,3507,3525,3526,3544,3550,3592,3841,3842,4319,38205,38211,
   38229,38230,38253,38271,38272,38502,38503,38980,39156,39174,39175,39405,39406,39883,40266,40267,
   40744,45084],[3500,3501,3507,3527,3528,3544,3550,3592,3843,3844,4354,38205,38211,38231,38232,
   38253,38273,38274,38504,38505,39015,39156,39176,39177,39918,40779,45119],
 [3500,3501,3507,3527,3528,3544,3550,3592,3843,3844,4354,38205,38211,38231,38232,38253,38273,
   38274,38504,38505,39015,39156,39176,39177,39918,40779,45119],
 [3500,3501,3507,3529,3544,3550,3592,3845,38205,38211,38233,38253,38275,38506,39156,39178],
 [3500,3501,3507,3530,3531,3544,3550,3592,3846,3847,38205,38211,38234,38235,38253,38276,38277,
   38507,38508,39060,39156,39179,39180,39963,40824],
 [3500,3501,3507,3530,3531,3544,3550,3592,3846,3847,38205,38211,38234,38235,38253,38276,38277,
   38507,38508,39060,39156,39179,39180,39963,40824],
 [3500,3501,3507,3532,3544,3550,3592,3848,38205,38211,38236,38253,38278,38509,39156,39181],
 [3500,3501,3507,3533,3544,3550,3592,3849,38205,38211,38237,38253,38279,38510,39156,39182],
 [3500,3501,3507,3534,3535,3544,3550,3592,3850,3851,38205,38211,38238,38239,38253,38280,38281,
   38511,38512,39106,39156,39183,39184,40009,40870],
 [3500,3501,3507,3534,3535,3544,3550,3592,3850,3851,38205,38211,38238,38239,38253,38280,38281,
   38511,38512,39106,39156,39183,39184,40009,40870],
 [3500,3501,3507,3536,3544,3550,3592,3852,38205,38211,38240,38253,38282,38513,39156,39185],
 [3500,3501,3507,3537,3544,3550,3592,3853,38205,38211,38241,38253,38283,38514,39156,39186],
 [3500,3501,3507,3538,3544,3550,3592,3854,38205,38211,38242,38253,38284,38515,39156,39187],
 [3500,3501,3507,3539,3544,3550,3592,3855,38205,38211,38243,38253,38285,38516,39156,39188],
 [3500,3501,3507,3540,3544,3550,3592,3856,38205,38211,38244,38253,38286,38517,39156,39189],
 [3500,3501,3507,3541,3544,3550,3592,3857,38205,38211,38245,38253,38287,38518,39156,39190],
 [3500,3501,3507,3542,3543,3544,3550,3592,3858,3859,38205,38211,38246,38247,38253,38288,38289,
   38519,38520,39150,39156,39191,39192,40053,40914],
 [3500,3501,3507,3542,3543,3544,3550,3592,3858,3859,38205,38211,38246,38247,38253,38288,38289,
   38519,38520,39150,39156,39191,39192,40053,40914],
 [3500,3501,3502,3503,3504,3507,3508,3509,3511,3544,3550,3592,3633,3634,3670,3673,3675,3677,3712,
   3714,3716,3824,3825,3827,3896,38205,38206,38207,38208,38211,38212,38213,38215,38248,38249,
   38250,38253,38254,38255,38257,38290,38291,38294,38295,38296,38298,38331,38334,38335,38336,38338,
   38373,38374,38375,38377,38485,38486,38488,38521,38523,38557,39151,39152,39153,39156,39157,39158,
   39160,39193,39194,39197,39198,39199,39201,39234,39237,39238,39239,39241,39276,39277,39278,39280,
   39388,39389,39391,39424,39426,39460,40054,40055,40058,40059,40060,40062,40095,40098,40099,40100,
   40102,40137,40138,40139,40141,40249,40250,40252,40285,40287,40321,40915,40918,40919,40920,40922,
   40957,40958,40959,40961,41069,41070,41072,41105,41107,41141,41737,41738,41739,41741,41849,41850,
   41852,41885,41887,41921,42590,42591,42593,42626,42628,42662,44625,44627,44661,45256],
 [3500,3501,3502,3503,3504,3507,3508,3509,3511,3544,3550,3592,3633,3634,3670,3673,3675,3677,3712,
   3714,3716,3824,3825,3827,3896,38205,38206,38207,38208,38211,38212,38213,38215,38248,38249,
   38250,38253,38254,38255,38257,38290,38291,38294,38295,38296,38298,38331,38334,38335,38336,38338,
   38373,38374,38375,38377,38485,38486,38488,38521,38523,38557,39151,39152,39153,39156,39157,39158,
   39160,39193,39194,39197,39198,39199,39201,39234,39237,39238,39239,39241,39276,39277,39278,39280,
   39388,39389,39391,39424,39426,39460,40054,40055,40058,40059,40060,40062,40095,40098,40099,40100,
   40102,40137,40138,40139,40141,40249,40250,40252,40285,40287,40321,40915,40918,40919,40920,40922,
   40957,40958,40959,40961,41069,41070,41072,41105,41107,41141,41737,41738,41739,41741,41849,41850,
   41852,41885,41887,41921,42590,42591,42593,42626,42628,42662,44625,44627,44661,45256],
 [3502,3505,3507,3508,3510,3512,3513,3633,3634,3750,3756,3824,3826,3828,3829,3930,38294,38295,
   38411,38417,38485,38487,38489,38490,38591,40995,40996,40998,41069,41071,41073,41074,41106,41108,
   41109,41175,41176,41239,43293,43295,43297,43298,43330,43332,43399,44626,44628,44629,44695,44696,
   44759,45290,45354,46443],[3502,3506,3507,3508,3514,3633,3634,3787,3794,3824,3830,38294,38295,
   38448,38455,38485,38491,41032,41033,41039,41069,41075,41110,43959,43965,44000,44630],
 [3507,41069],[3507,41069],[3500,3501,3502,3503,3504,3507,3508,3509,3511,3544,3550,3592,3633,
   3634,3670,3673,3675,3677,3712,3714,3716,3824,3825,3827,3896,38205,38206,38207,38208,38211,
   38212,38213,38215,38248,38249,38250,38253,38254,38255,38257,38290,38291,38294,38295,38296,38298,
   38331,38334,38335,38336,38338,38373,38374,38375,38377,38485,38486,38488,38521,38523,38557,39151,
   39152,39153,39156,39157,39158,39160,39193,39194,39197,39198,39199,39201,39234,39237,39238,39239,
   39241,39276,39277,39278,39280,39388,39389,39391,39424,39426,39460,40054,40055,40058,40059,40060,
   40062,40095,40098,40099,40100,40102,40137,40138,40139,40141,40249,40250,40252,40285,40287,40321,
   40915,40918,40919,40920,40922,40957,40958,40959,40961,41069,41070,41072,41105,41107,41141,41737,
   41738,41739,41741,41849,41850,41852,41885,41887,41921,42590,42591,42593,42626,42628,42662,44625,
   44627,44661,45256],[3502,3505,3507,3508,3510,3512,3513,3633,3634,3750,3756,3824,3826,3828,
   3829,3930,38294,38295,38411,38417,38485,38487,38489,38490,38591,40995,40996,40998,41069,41071,
   41073,41074,41106,41108,41109,41175,41176,41239,43293,43295,43297,43298,43330,43332,43399,44626,
   44628,44629,44695,44696,44759,45290,45354,46443],
 [3500,3501,3502,3503,3504,3507,3508,3509,3511,3544,3550,3592,3633,3634,3670,3673,3675,3677,3712,
   3714,3716,3824,3825,3827,3896,38205,38206,38207,38208,38211,38212,38213,38215,38248,38249,
   38250,38253,38254,38255,38257,38290,38291,38294,38295,38296,38298,38331,38334,38335,38336,38338,
   38373,38374,38375,38377,38485,38486,38488,38521,38523,38557,39151,39152,39153,39156,39157,39158,
   39160,39193,39194,39197,39198,39199,39201,39234,39237,39238,39239,39241,39276,39277,39278,39280,
   39388,39389,39391,39424,39426,39460,40054,40055,40058,40059,40060,40062,40095,40098,40099,40100,
   40102,40137,40138,40139,40141,40249,40250,40252,40285,40287,40321,40915,40918,40919,40920,40922,
   40957,40958,40959,40961,41069,41070,41072,41105,41107,41141,41737,41738,41739,41741,41849,41850,
   41852,41885,41887,41921,42590,42591,42593,42626,42628,42662,44625,44627,44661,45256],
 [3502,3505,3507,3508,3510,3512,3513,3633,3634,3750,3756,3824,3826,3828,3829,3930,38294,38295,
   38411,38417,38485,38487,38489,38490,38591,40995,40996,40998,41069,41071,41073,41074,41106,41108,
   41109,41175,41176,41239,43293,43295,43297,43298,43330,43332,43399,44626,44628,44629,44695,44696,
   44759,45290,45354,46443],[3502,3505,3507,3508,3510,3512,3513,3633,3634,3750,3756,3824,3826,
   3828,3829,3930,38294,38295,38411,38417,38485,38487,38489,38490,38591,40995,40996,40998,41069,
   41071,41073,41074,41106,41108,41109,41175,41176,41239,43293,43295,43297,43298,43330,43332,43399,
   44626,44628,44629,44695,44696,44759,45290,45354,46443],
 [3502,3506,3507,3508,3514,3633,3634,3787,3794,3824,3830,38294,38295,38448,38455,38485,38491,
   41032,41033,41039,41069,41075,41110,43959,43965,44000,44630],
 [3502,3507,3508,3515,3633,3634,3824,3831,38294,38295,38485,38492,41069,41076,41111,44631],
 [3502,3507,3508,3516,3633,3634,3824,3832,38294,38295,38485,38493,41069,41077,41112,44632],
 [23,31,44,1291,1296,1306,1309,1432,1625,1658,3502,3507,3508,3517,3518,3520,3633,3634,3824,3833,
   3834,3836,4139,38294,38295,38304,38485,38494,38495,38497,38800,41069,41078,41079,41081,41113,
   41114,41116,41384,41386,41411,44633,44634,44636,44904,44906,44931,45499,45501,45526,49471],
 [23,31,44,1291,1296,1306,1309,1432,1625,1658,3502,3507,3508,3517,3518,3520,3633,3634,3824,3833,
   3834,3836,4139,38294,38295,38304,38485,38494,38495,38497,38800,41069,41078,41079,41081,41113,
   41114,41116,41384,41386,41411,44633,44634,44636,44904,44906,44931,45499,45501,45526,49471],
 [3502,3507,3508,3519,3523,3633,3634,3824,3835,3839,4193,38294,38295,38485,38496,38500,38854,
   41069,41080,41084,41115,41119,44635,44639,44958],
 [23,31,44,1291,1296,1306,1309,1432,1625,1658,3502,3507,3508,3517,3518,3520,3633,3634,3824,3833,
   3834,3836,4139,38294,38295,38304,38485,38494,38495,38497,38800,41069,41078,41079,41081,41113,
   41114,41116,41384,41386,41411,44633,44634,44636,44904,44906,44931,45499,45501,45526,49471],
 [3502,3507,3508,3521,3633,3634,3824,3837,38294,38295,38485,38498,41069,41082,41117,44637],
 [3502,3507,3508,3522,3524,3633,3634,3824,3838,3840,4260,38294,38295,38309,38311,38485,38499,
   38501,38534,38536,38921,41069,41083,41085,41118,41120,41505,44638,44640,45025,45620],
 [3502,3507,3508,3519,3523,3633,3634,3824,3835,3839,4193,38294,38295,38485,38496,38500,38854,
   41069,41080,41084,41115,41119,44635,44639,44958],
 [3502,3507,3508,3522,3524,3633,3634,3824,3838,3840,4260,38294,38295,38309,38311,38485,38499,
   38501,38534,38536,38921,41069,41083,41085,41118,41120,41505,44638,44640,45025,45620],
 [3502,3507,3508,3525,3526,3633,3634,3824,3841,3842,4319,38294,38295,38485,38502,38503,38980,
   41069,41086,41087,41121,41122,41564,44641,44642,45084,45679],
 [3502,3507,3508,3525,3526,3633,3634,3824,3841,3842,4319,38294,38295,38485,38502,38503,38980,
   41069,41086,41087,41121,41122,41564,44641,44642,45084,45679],
 [3502,3507,3508,3527,3528,3633,3634,3824,3843,3844,4354,38294,38295,38314,38315,38485,38504,
   38505,38539,38540,39015,41069,41088,41089,41123,41124,41599,44643,44644,45119,45714],
 [3502,3507,3508,3527,3528,3633,3634,3824,3843,3844,4354,38294,38295,38314,38315,38485,38504,
   38505,38539,38540,39015,41069,41088,41089,41123,41124,41599,44643,44644,45119,45714],
 [3502,3507,3508,3529,3530,3633,3634,3824,3845,3846,38294,38295,38485,38506,38507,41069,41090,
   41091,41125,41126,41630,44645,44646,45150,45745],
 [3502,3507,3508,3529,3530,3633,3634,3824,3845,3846,38294,38295,38485,38506,38507,41069,41090,
   41091,41125,41126,41630,44645,44646,45150,45745],
 [3502,3507,3508,3531,3633,3634,3824,3847,38294,38295,38485,38508,41069,41092,41127,44647],
 [3502,3507,3508,3532,3633,3634,3824,3848,38294,38295,38485,38509,41069,41093,41128,44648],
 [3502,3507,3508,3533,3633,3634,3824,3849,38294,38295,38485,38510,41069,41094,41129,44649],
 [3502,3507,3508,3534,3536,3633,3634,3824,3850,3852,38294,38295,38485,38511,38513,41069,41095,
   41097,41130,41132,41691,44650,44652,45211,45806],
 [3502,3507,3508,3535,3633,3634,3824,3851,38294,38295,38485,38512,41069,41096,41131,44651],
 [3502,3507,3508,3534,3536,3633,3634,3824,3850,3852,38294,38295,38485,38511,38513,41069,41095,
   41097,41130,41132,41691,44650,44652,45211,45806],
 [3502,3507,3508,3537,3633,3634,3824,3853,38294,38295,38485,38514,41069,41098,41133,44653],
 [3502,3507,3508,3538,3633,3634,3824,3854,38294,38295,38485,38515,41069,41099,41134,44654],
 [3502,3507,3508,3539,3633,3634,3824,3855,38294,38295,38485,38516,41069,41100,41135,44655],
 [3502,3507,3508,3540,3633,3634,3824,3856,38294,38295,38485,38517,41069,41101,41136,44656],
 [3502,3507,3508,3541,3542,3633,3634,3824,3857,3858,38294,38295,38485,38518,38519,41069,41102,
   41103,41137,41138,41732,44657,44658,45252,45847],
 [3502,3507,3508,3541,3542,3633,3634,3824,3857,3858,38294,38295,38485,38518,38519,41069,41102,
   41103,41137,41138,41732,44657,44658,45252,45847],
 [3502,3507,3508,3543,3633,3634,3824,3859,38294,38295,38485,38520,41069,41104,41139,44659],
 [3507,3677,3714,38331,38557,41850,42593],[3677,3756,41779,41988],
 [3677,3794,41816,41819,41989,44099],[3507,3677,3714,38331,38557,41850,42593],
 [3500,3501,3502,3503,3504,3507,3508,3509,3511,3544,3550,3592,3633,3634,3670,3673,3675,3677,3712,
   3714,3716,3824,3825,3827,3896,38205,38206,38207,38208,38211,38212,38213,38215,38248,38249,
   38250,38253,38254,38255,38257,38290,38291,38294,38295,38296,38298,38331,38334,38335,38336,38338,
   38373,38374,38375,38377,38485,38486,38488,38521,38523,38557,39151,39152,39153,39156,39157,39158,
   39160,39193,39194,39197,39198,39199,39201,39234,39237,39238,39239,39241,39276,39277,39278,39280,
   39388,39389,39391,39424,39426,39460,40054,40055,40058,40059,40060,40062,40095,40098,40099,40100,
   40102,40137,40138,40139,40141,40249,40250,40252,40285,40287,40321,40915,40918,40919,40920,40922,
   40957,40958,40959,40961,41069,41070,41072,41105,41107,41141,41737,41738,41739,41741,41849,41850,
   41852,41885,41887,41921,42590,42591,42593,42626,42628,42662,44625,44627,44661,45256],
 [3507,3677,3714,38331,38557,41850,42593],[3677,3930,41954,41955,41987,46411],[],
 [3677,3930,41954,41955,41987,46411],[3677,3756,41779,41988],[3677,3794,41816,41819,41989,44099]
  ,[3677,41990,41991,42109,47029],[3677,41990,41991,42109,47029],
 [3503,3504,3507,3509,3511,3517,3518,3522,3524,3670,3673,3675,3677,3712,3714,3716,3825,3827,3833,
   3834,3838,3840,3896,4139,4260,38331,38334,38336,38338,38344,38345,38349,38351,38373,38375,
   38377,38383,38384,38388,38390,38486,38488,38494,38495,38499,38501,38557,38563,38564,38568,38570,
   38628,38629,38633,38635,38800,38804,38806,38829,38831,38921,41737,41739,41741,41747,41748,41752,
   41754,41850,41852,41858,41859,41863,41865,41921,41927,41928,41932,41934,41992,41993,41997,41999,
   42164,42168,42170,42193,42195,42285,42591,42593,42599,42600,42604,42606,42662,42668,42669,42673,
   42675,42733,42734,42738,42740,42905,42909,42911,42934,42936,43026,44661,44667,44668,44672,44674,
   44732,44733,44737,44739,44904,44908,44910,44933,44935,45025,45888,45889,45893,45895,46060,46064,
   46066,46089,46091,46181,47084,47088,47090,47113,47115,47205,49473,49475,49565,49865],
 [3503,3504,3507,3509,3511,3517,3518,3522,3524,3670,3673,3675,3677,3712,3714,3716,3825,3827,3833,
   3834,3838,3840,3896,4139,4260,38331,38334,38336,38338,38344,38345,38349,38351,38373,38375,
   38377,38383,38384,38388,38390,38486,38488,38494,38495,38499,38501,38557,38563,38564,38568,38570,
   38628,38629,38633,38635,38800,38804,38806,38829,38831,38921,41737,41739,41741,41747,41748,41752,
   41754,41850,41852,41858,41859,41863,41865,41921,41927,41928,41932,41934,41992,41993,41997,41999,
   42164,42168,42170,42193,42195,42285,42591,42593,42599,42600,42604,42606,42662,42668,42669,42673,
   42675,42733,42734,42738,42740,42905,42909,42911,42934,42936,43026,44661,44667,44668,44672,44674,
   44732,44733,44737,44739,44904,44908,44910,44933,44935,45025,45888,45889,45893,45895,46060,46064,
   46066,46089,46091,46181,47084,47088,47090,47113,47115,47205,49473,49475,49565,49865],
 [3677,4193,41994,41998],[3677,41995],[3677,41996],
 [3503,3504,3507,3509,3511,3517,3518,3522,3524,3670,3673,3675,3677,3712,3714,3716,3825,3827,3833,
   3834,3838,3840,3896,4139,4260,38331,38334,38336,38338,38344,38345,38349,38351,38373,38375,
   38377,38383,38384,38388,38390,38486,38488,38494,38495,38499,38501,38557,38563,38564,38568,38570,
   38628,38629,38633,38635,38800,38804,38806,38829,38831,38921,41737,41739,41741,41747,41748,41752,
   41754,41850,41852,41858,41859,41863,41865,41921,41927,41928,41932,41934,41992,41993,41997,41999,
   42164,42168,42170,42193,42195,42285,42591,42593,42599,42600,42604,42606,42662,42668,42669,42673,
   42675,42733,42734,42738,42740,42905,42909,42911,42934,42936,43026,44661,44667,44668,44672,44674,
   44732,44733,44737,44739,44904,44908,44910,44933,44935,45025,45888,45889,45893,45895,46060,46064,
   46066,46089,46091,46181,47084,47088,47090,47113,47115,47205,49473,49475,49565,49865],
 [3677,4193,41994,41998],[3503,3504,3507,3509,3511,3517,3518,3522,3524,3670,3673,3675,3677,3712,
   3714,3716,3825,3827,3833,3834,3838,3840,3896,4139,4260,38331,38334,38336,38338,38344,38345,
   38349,38351,38373,38375,38377,38383,38384,38388,38390,38486,38488,38494,38495,38499,38501,38557,
   38563,38564,38568,38570,38628,38629,38633,38635,38800,38804,38806,38829,38831,38921,41737,41739,
   41741,41747,41748,41752,41754,41850,41852,41858,41859,41863,41865,41921,41927,41928,41932,41934,
   41992,41993,41997,41999,42164,42168,42170,42193,42195,42285,42591,42593,42599,42600,42604,42606,
   42662,42668,42669,42673,42675,42733,42734,42738,42740,42905,42909,42911,42934,42936,43026,44661,
   44667,44668,44672,44674,44732,44733,44737,44739,44904,44908,44910,44933,44935,45025,45888,45889,
   45893,45895,46060,46064,46066,46089,46091,46181,47084,47088,47090,47113,47115,47205,49473,49475,
   49565,49865],[3503,3504,3507,3509,3511,3525,3526,3527,3528,3670,3673,3675,3677,3712,3714,
   3716,3825,3827,3841,3842,3843,3844,3896,4319,4354,38331,38334,38336,38338,38352,38353,38354,
   38355,38373,38375,38377,38391,38392,38393,38394,38486,38488,38502,38503,38504,38505,38557,38571,
   38572,38573,38574,38636,38637,38638,38639,38980,38981,38982,38998,38999,39015,41737,41739,41741,
   41755,41756,41757,41758,41850,41852,41866,41867,41868,41869,41921,41935,41936,41937,41938,42000,
   42001,42002,42003,42344,42345,42346,42362,42363,42379,42591,42593,42607,42608,42609,42610,42662,
   42676,42677,42678,42679,42741,42742,42743,42744,43085,43086,43087,43103,43104,43120,44661,44675,
   44676,44677,44678,44740,44741,44742,44743,45084,45085,45086,45102,45103,45119,45896,45897,45898,
   45899,46240,46241,46242,46258,46259,46275,47264,47265,47266,47282,47283,47299,51426,51427,51443,
   51579],[3503,3504,3507,3509,3511,3525,3526,3527,3528,3670,3673,3675,3677,3712,3714,3716,
   3825,3827,3841,3842,3843,3844,3896,4319,4354,38331,38334,38336,38338,38352,38353,38354,38355,
   38373,38375,38377,38391,38392,38393,38394,38486,38488,38502,38503,38504,38505,38557,38571,38572,
   38573,38574,38636,38637,38638,38639,38980,38981,38982,38998,38999,39015,41737,41739,41741,41755,
   41756,41757,41758,41850,41852,41866,41867,41868,41869,41921,41935,41936,41937,41938,42000,42001,
   42002,42003,42344,42345,42346,42362,42363,42379,42591,42593,42607,42608,42609,42610,42662,42676,
   42677,42678,42679,42741,42742,42743,42744,43085,43086,43087,43103,43104,43120,44661,44675,44676,
   44677,44678,44740,44741,44742,44743,45084,45085,45086,45102,45103,45119,45896,45897,45898,45899,
   46240,46241,46242,46258,46259,46275,47264,47265,47266,47282,47283,47299,51426,51427,51443,51579]
  ,[3503,3504,3507,3509,3511,3525,3526,3527,3528,3670,3673,3675,3677,3712,3714,3716,3825,3827,
   3841,3842,3843,3844,3896,4319,4354,38331,38334,38336,38338,38352,38353,38354,38355,38373,38375,
   38377,38391,38392,38393,38394,38486,38488,38502,38503,38504,38505,38557,38571,38572,38573,38574,
   38636,38637,38638,38639,38980,38981,38982,38998,38999,39015,41737,41739,41741,41755,41756,41757,
   41758,41850,41852,41866,41867,41868,41869,41921,41935,41936,41937,41938,42000,42001,42002,42003,
   42344,42345,42346,42362,42363,42379,42591,42593,42607,42608,42609,42610,42662,42676,42677,42678,
   42679,42741,42742,42743,42744,43085,43086,43087,43103,43104,43120,44661,44675,44676,44677,44678,
   44740,44741,44742,44743,45084,45085,45086,45102,45103,45119,45896,45897,45898,45899,46240,46241,
   46242,46258,46259,46275,47264,47265,47266,47282,47283,47299,51426,51427,51443,51579],
 [3503,3504,3507,3509,3511,3525,3526,3527,3528,3670,3673,3675,3677,3712,3714,3716,3825,3827,3841,
   3842,3843,3844,3896,4319,4354,38331,38334,38336,38338,38352,38353,38354,38355,38373,38375,
   38377,38391,38392,38393,38394,38486,38488,38502,38503,38504,38505,38557,38571,38572,38573,38574,
   38636,38637,38638,38639,38980,38981,38982,38998,38999,39015,41737,41739,41741,41755,41756,41757,
   41758,41850,41852,41866,41867,41868,41869,41921,41935,41936,41937,41938,42000,42001,42002,42003,
   42344,42345,42346,42362,42363,42379,42591,42593,42607,42608,42609,42610,42662,42676,42677,42678,
   42679,42741,42742,42743,42744,43085,43086,43087,43103,43104,43120,44661,44675,44676,44677,44678,
   44740,44741,44742,44743,45084,45085,45086,45102,45103,45119,45896,45897,45898,45899,46240,46241,
   46242,46258,46259,46275,47264,47265,47266,47282,47283,47299,51426,51427,51443,51579],
 [3677,42004,42006,42411,47331],[3677,42005],[3677,42004,42006,42411,47331],
 [3677,42007,42008,42449,47369],[3677,42007,42008,42449,47369],[3677,42009],
 [3677,42010,42011,42479,47399],[3677,42010,42011,42479,47399],[3677,42012,42013,42494,47414],
 [3677,42012,42013,42494,47414],[3677,42014],[3677,42015],[3677,42016,42018,42513,47433],
 [3677,42017],[3677,42016,42018,42513,47433],[3714,3756,42518,42664],
 [3714,3794,3930,42555,42556,42558,42560,42661,42663,42665,42696,42698,42761,44030,44032,44034,
   44065,44067,44130,45851,45853,45916,46444],[3507,3677,3714,38331,38557,41850,42593],
 [3500,3501,3502,3503,3504,3507,3508,3509,3511,3544,3550,3592,3633,3634,3670,3673,3675,3677,3712,
   3714,3716,3824,3825,3827,3896,38205,38206,38207,38208,38211,38212,38213,38215,38248,38249,
   38250,38253,38254,38255,38257,38290,38291,38294,38295,38296,38298,38331,38334,38335,38336,38338,
   38373,38374,38375,38377,38485,38486,38488,38521,38523,38557,39151,39152,39153,39156,39157,39158,
   39160,39193,39194,39197,39198,39199,39201,39234,39237,39238,39239,39241,39276,39277,39278,39280,
   39388,39389,39391,39424,39426,39460,40054,40055,40058,40059,40060,40062,40095,40098,40099,40100,
   40102,40137,40138,40139,40141,40249,40250,40252,40285,40287,40321,40915,40918,40919,40920,40922,
   40957,40958,40959,40961,41069,41070,41072,41105,41107,41141,41737,41738,41739,41741,41849,41850,
   41852,41885,41887,41921,42590,42591,42593,42626,42628,42662,44625,44627,44661,45256],[],
 [3714,3794,3930,42555,42556,42558,42560,42661,42663,42665,42696,42698,42761,44030,44032,44034,
   44065,44067,44130,45851,45853,45916,46444],[3507,3677,3714,38331,38557,41850,42593],
 [3714,3794,3930,42555,42556,42558,42560,42661,42663,42665,42696,42698,42761,44030,44032,44034,
   44065,44067,44130,45851,45853,45916,46444],[3714,3756,42518,42664],
 [3714,3794,3930,42555,42556,42558,42560,42661,42663,42665,42696,42698,42761,44030,44032,44034,
   44065,44067,44130,45851,45853,45916,46444],[3714,42666],[3714,42667],
 [3503,3504,3507,3509,3511,3517,3518,3522,3524,3670,3673,3675,3677,3712,3714,3716,3825,3827,3833,
   3834,3838,3840,3896,4139,4260,38331,38334,38336,38338,38344,38345,38349,38351,38373,38375,
   38377,38383,38384,38388,38390,38486,38488,38494,38495,38499,38501,38557,38563,38564,38568,38570,
   38628,38629,38633,38635,38800,38804,38806,38829,38831,38921,41737,41739,41741,41747,41748,41752,
   41754,41850,41852,41858,41859,41863,41865,41921,41927,41928,41932,41934,41992,41993,41997,41999,
   42164,42168,42170,42193,42195,42285,42591,42593,42599,42600,42604,42606,42662,42668,42669,42673,
   42675,42733,42734,42738,42740,42905,42909,42911,42934,42936,43026,44661,44667,44668,44672,44674,
   44732,44733,44737,44739,44904,44908,44910,44933,44935,45025,45888,45889,45893,45895,46060,46064,
   46066,46089,46091,46181,47084,47088,47090,47113,47115,47205,49473,49475,49565,49865],
 [3503,3504,3507,3509,3511,3517,3518,3522,3524,3670,3673,3675,3677,3712,3714,3716,3825,3827,3833,
   3834,3838,3840,3896,4139,4260,38331,38334,38336,38338,38344,38345,38349,38351,38373,38375,
   38377,38383,38384,38388,38390,38486,38488,38494,38495,38499,38501,38557,38563,38564,38568,38570,
   38628,38629,38633,38635,38800,38804,38806,38829,38831,38921,41737,41739,41741,41747,41748,41752,
   41754,41850,41852,41858,41859,41863,41865,41921,41927,41928,41932,41934,41992,41993,41997,41999,
   42164,42168,42170,42193,42195,42285,42591,42593,42599,42600,42604,42606,42662,42668,42669,42673,
   42675,42733,42734,42738,42740,42905,42909,42911,42934,42936,43026,44661,44667,44668,44672,44674,
   44732,44733,44737,44739,44904,44908,44910,44933,44935,45025,45888,45889,45893,45895,46060,46064,
   46066,46089,46091,46181,47084,47088,47090,47113,47115,47205,49473,49475,49565,49865],
 [3714,4193,42670,42674],[3714,42671],[3714,42672],
 [3503,3504,3507,3509,3511,3517,3518,3522,3524,3670,3673,3675,3677,3712,3714,3716,3825,3827,3833,
   3834,3838,3840,3896,4139,4260,38331,38334,38336,38338,38344,38345,38349,38351,38373,38375,
   38377,38383,38384,38388,38390,38486,38488,38494,38495,38499,38501,38557,38563,38564,38568,38570,
   38628,38629,38633,38635,38800,38804,38806,38829,38831,38921,41737,41739,41741,41747,41748,41752,
   41754,41850,41852,41858,41859,41863,41865,41921,41927,41928,41932,41934,41992,41993,41997,41999,
   42164,42168,42170,42193,42195,42285,42591,42593,42599,42600,42604,42606,42662,42668,42669,42673,
   42675,42733,42734,42738,42740,42905,42909,42911,42934,42936,43026,44661,44667,44668,44672,44674,
   44732,44733,44737,44739,44904,44908,44910,44933,44935,45025,45888,45889,45893,45895,46060,46064,
   46066,46089,46091,46181,47084,47088,47090,47113,47115,47205,49473,49475,49565,49865],
 [3714,4193,42670,42674],[3503,3504,3507,3509,3511,3517,3518,3522,3524,3670,3673,3675,3677,3712,
   3714,3716,3825,3827,3833,3834,3838,3840,3896,4139,4260,38331,38334,38336,38338,38344,38345,
   38349,38351,38373,38375,38377,38383,38384,38388,38390,38486,38488,38494,38495,38499,38501,38557,
   38563,38564,38568,38570,38628,38629,38633,38635,38800,38804,38806,38829,38831,38921,41737,41739,
   41741,41747,41748,41752,41754,41850,41852,41858,41859,41863,41865,41921,41927,41928,41932,41934,
   41992,41993,41997,41999,42164,42168,42170,42193,42195,42285,42591,42593,42599,42600,42604,42606,
   42662,42668,42669,42673,42675,42733,42734,42738,42740,42905,42909,42911,42934,42936,43026,44661,
   44667,44668,44672,44674,44732,44733,44737,44739,44904,44908,44910,44933,44935,45025,45888,45889,
   45893,45895,46060,46064,46066,46089,46091,46181,47084,47088,47090,47113,47115,47205,49473,49475,
   49565,49865],[3503,3504,3507,3509,3511,3525,3526,3527,3528,3670,3673,3675,3677,3712,3714,
   3716,3825,3827,3841,3842,3843,3844,3896,4319,4354,38331,38334,38336,38338,38352,38353,38354,
   38355,38373,38375,38377,38391,38392,38393,38394,38486,38488,38502,38503,38504,38505,38557,38571,
   38572,38573,38574,38636,38637,38638,38639,38980,38981,38982,38998,38999,39015,41737,41739,41741,
   41755,41756,41757,41758,41850,41852,41866,41867,41868,41869,41921,41935,41936,41937,41938,42000,
   42001,42002,42003,42344,42345,42346,42362,42363,42379,42591,42593,42607,42608,42609,42610,42662,
   42676,42677,42678,42679,42741,42742,42743,42744,43085,43086,43087,43103,43104,43120,44661,44675,
   44676,44677,44678,44740,44741,44742,44743,45084,45085,45086,45102,45103,45119,45896,45897,45898,
   45899,46240,46241,46242,46258,46259,46275,47264,47265,47266,47282,47283,47299,51426,51427,51443,
   51579],[3503,3504,3507,3509,3511,3525,3526,3527,3528,3670,3673,3675,3677,3712,3714,3716,
   3825,3827,3841,3842,3843,3844,3896,4319,4354,38331,38334,38336,38338,38352,38353,38354,38355,
   38373,38375,38377,38391,38392,38393,38394,38486,38488,38502,38503,38504,38505,38557,38571,38572,
   38573,38574,38636,38637,38638,38639,38980,38981,38982,38998,38999,39015,41737,41739,41741,41755,
   41756,41757,41758,41850,41852,41866,41867,41868,41869,41921,41935,41936,41937,41938,42000,42001,
   42002,42003,42344,42345,42346,42362,42363,42379,42591,42593,42607,42608,42609,42610,42662,42676,
   42677,42678,42679,42741,42742,42743,42744,43085,43086,43087,43103,43104,43120,44661,44675,44676,
   44677,44678,44740,44741,44742,44743,45084,45085,45086,45102,45103,45119,45896,45897,45898,45899,
   46240,46241,46242,46258,46259,46275,47264,47265,47266,47282,47283,47299,51426,51427,51443,51579]
  ,[3503,3504,3507,3509,3511,3525,3526,3527,3528,3670,3673,3675,3677,3712,3714,3716,3825,3827,
   3841,3842,3843,3844,3896,4319,4354,38331,38334,38336,38338,38352,38353,38354,38355,38373,38375,
   38377,38391,38392,38393,38394,38486,38488,38502,38503,38504,38505,38557,38571,38572,38573,38574,
   38636,38637,38638,38639,38980,38981,38982,38998,38999,39015,41737,41739,41741,41755,41756,41757,
   41758,41850,41852,41866,41867,41868,41869,41921,41935,41936,41937,41938,42000,42001,42002,42003,
   42344,42345,42346,42362,42363,42379,42591,42593,42607,42608,42609,42610,42662,42676,42677,42678,
   42679,42741,42742,42743,42744,43085,43086,43087,43103,43104,43120,44661,44675,44676,44677,44678,
   44740,44741,44742,44743,45084,45085,45086,45102,45103,45119,45896,45897,45898,45899,46240,46241,
   46242,46258,46259,46275,47264,47265,47266,47282,47283,47299,51426,51427,51443,51579],
 [3503,3504,3507,3509,3511,3525,3526,3527,3528,3670,3673,3675,3677,3712,3714,3716,3825,3827,3841,
   3842,3843,3844,3896,4319,4354,38331,38334,38336,38338,38352,38353,38354,38355,38373,38375,
   38377,38391,38392,38393,38394,38486,38488,38502,38503,38504,38505,38557,38571,38572,38573,38574,
   38636,38637,38638,38639,38980,38981,38982,38998,38999,39015,41737,41739,41741,41755,41756,41757,
   41758,41850,41852,41866,41867,41868,41869,41921,41935,41936,41937,41938,42000,42001,42002,42003,
   42344,42345,42346,42362,42363,42379,42591,42593,42607,42608,42609,42610,42662,42676,42677,42678,
   42679,42741,42742,42743,42744,43085,43086,43087,43103,43104,43120,44661,44675,44676,44677,44678,
   44740,44741,44742,44743,45084,45085,45086,45102,45103,45119,45896,45897,45898,45899,46240,46241,
   46242,46258,46259,46275,47264,47265,47266,47282,47283,47299,51426,51427,51443,51579],
 [3714,42680],[3714,42681],[3714,42682],[3714,42683],[3714,42684],[3714,42685],
 [3714,42686],[3714,42687],[3714,42688],[3714,42689],[3714,42690],[3714,42691],
 [3714,42692],[3714,42693],[3714,42694],
 [3500,3501,3505,3506,3507,3513,3514,3544,3550,3592,3750,3756,3787,3794,3829,3830,38205,38209,
   38210,38211,38217,38218,38251,38252,38253,38259,38260,38410,38411,38417,38418,38448,38454,38455,
   38490,38491,38686,39154,39155,39156,39162,39163,39313,39321,39358,39589,40174,40218,40219,40450,
   43263,43298,43965,44160],[3507,3756],
 [3502,3505,3507,3508,3510,3512,3513,3633,3634,3750,3756,3824,3826,3828,3829,3930,38294,38295,
   38411,38417,38485,38487,38489,38490,38591,40995,40996,40998,41069,41071,41073,41074,41106,41108,
   41109,41175,41176,41239,43293,43295,43297,43298,43330,43332,43399,44626,44628,44629,44695,44696,
   44759,45290,45354,46443],[3714,3756,42518,42664],
 [3502,3505,3507,3508,3510,3512,3513,3633,3634,3750,3756,3824,3826,3828,3829,3930,38294,38295,
   38411,38417,38485,38487,38489,38490,38591,40995,40996,40998,41069,41071,41073,41074,41106,41108,
   41109,41175,41176,41239,43293,43295,43297,43298,43330,43332,43399,44626,44628,44629,44695,44696,
   44759,45290,45354,46443],[3677,3756,41779,41988],
 [3502,3505,3507,3508,3510,3512,3513,3633,3634,3750,3756,3824,3826,3828,3829,3930,38294,38295,
   38411,38417,38485,38487,38489,38490,38591,40995,40996,40998,41069,41071,41073,41074,41106,41108,
   41109,41175,41176,41239,43293,43295,43297,43298,43330,43332,43399,44626,44628,44629,44695,44696,
   44759,45290,45354,46443],[],[3500,3501,3505,3506,3507,3513,3514,3544,3550,3592,3750,3756,
   3787,3794,3829,3830,38205,38209,38210,38211,38217,38218,38251,38252,38253,38259,38260,38410,
   38411,38417,38418,38448,38454,38455,38490,38491,38686,39154,39155,39156,39162,39163,39313,39321,
   39358,39589,40174,40218,40219,40450,43263,43298,43965,44160],[3756],[3756],
 [3505,3507,3513,3517,3518,3750,3756,3829,3833,3834,4139,38411,38417,38490,38494,38495,38800,
   43298,43302,43303,43608,44793,44794,44904,47984],
 [3505,3507,3513,3517,3518,3750,3756,3829,3833,3834,4139,38411,38417,38490,38494,38495,38800,
   43298,43302,43303,43608,44793,44794,44904,47984],[3756,4193,43685,48035],
 [3756,4193,43685,48035],[3756],[3505,3507,3513,3522,3524,3750,3756,3829,3838,3840,4260,38411,
   38417,38426,38428,38490,38499,38501,38694,38696,38921,43298,43729,45025,48105],
 [3756,4193,43685,48035],[3505,3507,3513,3522,3524,3750,3756,3829,3838,3840,4260,38411,38417,
   38426,38428,38490,38499,38501,38694,38696,38921,43298,43729,45025,48105],
 [3505,3507,3513,3525,3526,3750,3756,3829,3841,3842,4319,38411,38417,38490,38502,38503,38980,
   43298,43310,43311,43788,44801,44802,45084,48164],
 [3505,3507,3513,3525,3526,3750,3756,3829,3841,3842,4319,38411,38417,38490,38502,38503,38980,
   43298,43310,43311,43788,44801,44802,45084,48164],
 [3505,3507,3513,3527,3528,3750,3756,3829,3843,3844,4354,38411,38417,38431,38432,38490,38504,
   38505,38699,38700,39015,43298,43823,45119,48199],
 [3505,3507,3513,3527,3528,3750,3756,3829,3843,3844,4354,38411,38417,38431,38432,38490,38504,
   38505,38699,38700,39015,43298,43823,45119,48199],[3756],[3756],[3756],[3756],[3756],
 [3756],[3756],[3756],[3756],[3756],[3756],[3756],[3756],[3756],[3756],
 [3507,3794,38455,43965],[3502,3506,3507,3508,3514,3633,3634,3787,3794,3824,3830,38294,38295,
   38448,38455,38485,38491,41032,41033,41039,41069,41075,41110,43959,43965,44000,44630],
 [3714,3794,3930,42555,42556,42558,42560,42661,42663,42665,42696,42698,42761,44030,44032,44034,
   44065,44067,44130,45851,45853,45916,46444],
 [3714,3794,3930,42555,42556,42558,42560,42661,42663,42665,42696,42698,42761,44030,44032,44034,
   44065,44067,44130,45851,45853,45916,46444],[3677,3794,41816,41819,41989,44099],
 [3714,3794,3930,42555,42556,42558,42560,42661,42663,42665,42696,42698,42761,44030,44032,44034,
   44065,44067,44130,45851,45853,45916,46444],
 [3500,3501,3505,3506,3507,3513,3514,3544,3550,3592,3750,3756,3787,3794,3829,3830,38205,38209,
   38210,38211,38217,38218,38251,38252,38253,38259,38260,38410,38411,38417,38418,38448,38454,38455,
   38490,38491,38686,39154,39155,39156,39162,39163,39313,39321,39358,39589,40174,40218,40219,40450,
   43263,43298,43965,44160],[],[3794,44190],[3794,44191],
 [3506,3507,3514,3517,3518,3787,3794,3830,3833,3834,4139,38448,38455,38491,38494,38495,38800,
   43965,43968,43969,44192,44193,44274,44822,44823,44904,48390],
 [3506,3507,3514,3517,3518,3787,3794,3830,3833,3834,4139,38448,38455,38491,38494,38495,38800,
   43965,43968,43969,44192,44193,44274,44822,44823,44904,48390],
 [3506,3507,3514,3519,3522,3523,3524,3787,3794,3830,3835,3838,3839,3840,4193,4260,38448,38455,
   38460,38463,38464,38465,38491,38496,38499,38500,38501,38720,38723,38724,38725,38853,38854,38855,
   38920,38921,38941,43965,44194,44197,44198,44199,44329,44394,44395,44415,44958,45025,48443,48445,
   48510,48511,50141,50855],[3794,44195],[3794,44196],
 [3506,3507,3514,3519,3522,3523,3524,3787,3794,3830,3835,3838,3839,3840,4193,4260,38448,38455,
   38460,38463,38464,38465,38491,38496,38499,38500,38501,38720,38723,38724,38725,38853,38854,38855,
   38920,38921,38941,43965,44194,44197,44198,44199,44329,44394,44395,44415,44958,45025,48443,48445,
   48510,48511,50141,50855],[3506,3507,3514,3519,3522,3523,3524,3787,3794,3830,3835,3838,3839,
   3840,4193,4260,38448,38455,38460,38463,38464,38465,38491,38496,38499,38500,38501,38720,38723,
   38724,38725,38853,38854,38855,38920,38921,38941,43965,44194,44197,44198,44199,44329,44394,44395,
   44415,44958,45025,48443,48445,48510,48511,50141,50855],
 [3506,3507,3514,3519,3522,3523,3524,3787,3794,3830,3835,3838,3839,3840,4193,4260,38448,38455,
   38460,38463,38464,38465,38491,38496,38499,38500,38501,38720,38723,38724,38725,38853,38854,38855,
   38920,38921,38941,43965,44194,44197,44198,44199,44329,44394,44395,44415,44958,45025,48443,48445,
   48510,48511,50141,50855],[3506,3507,3514,3525,3526,3787,3794,3830,3841,3842,4319,38448,38455,
   38491,38502,38503,38980,43965,43976,43977,44200,44201,44454,44830,44831,45084,48570],
 [3506,3507,3514,3525,3526,3787,3794,3830,3841,3842,4319,38448,38455,38491,38502,38503,38980,
   43965,43976,43977,44200,44201,44454,44830,44831,45084,48570],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,3501,3505,3506,3507,3513,
   3514,3517,3518,3527,3528,3544,3548,3549,3550,3556,3557,3560,3561,3570,3571,3590,3591,3592,
   3598,3599,3602,3603,3612,3613,3749,3750,3756,3757,3770,3771,3787,3793,3794,3829,3830,3833,
   3834,3843,3844,4025,4038,4039,4139,4354,4510,4511,4512,4518,4528,4529,5645,5646,5650,5651,
   5652,5658,5659,5662,5663,5672,5673,5689,5693,5694,5695,5701,5702,5705,5706,5715,5716,5735,
   5736,5737,5743,5744,5747,5748,5757,5758,5894,5902,5905,5916,5939,5942,5953,5978,5979,6170,
   6173,6183,6184,6202,6212,6213,6284,6293,6294,6499,7725,7726,7730,7731,7732,7738,7739,7742,
   7743,7752,7753,7769,7773,7774,7775,7781,7782,7785,7786,7795,7796,7815,7816,7817,7823,7824,
   7827,7828,7837,7838,7974,7986,7995,7996,8018,8019,8023,8032,8033,8058,8059,8250,8254,8263,
   8283,8292,8364,8398,8399,8579,38205,38209,38210,38211,38217,38218,38221,38222,38231,38232,
   38251,38252,38253,38259,38260,38263,38264,38273,38274,38410,38411,38417,38418,38431,38432,38448,
   38454,38455,38468,38469,38490,38491,38494,38495,38504,38505,38686,38699,38700,38728,38729,38800,
   39015,39154,39155,39156,39162,39163,39166,39167,39176,39177,39313,39320,39321,39324,39334,39335,
   39357,39358,39361,39371,39372,39397,39398,39589,39592,39602,39603,39621,39631,39632,39703,39712,
   39713,39918,40174,40181,40182,40186,40195,40196,40218,40219,40223,40232,40233,40258,40259,40450,
   40454,40463,40464,40483,40492,40493,40564,40598,40599,40779,43262,43263,43266,43276,43277,43298,
   43494,43507,43508,43536,43537,43643,43823,43965,44160,44173,44174,44202,44203,44308,44489,44904,
   45119,47903,47912,47913,47993,48199,48400,48605],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,3501,3505,3506,3507,3513,
   3514,3517,3518,3527,3528,3544,3548,3549,3550,3556,3557,3560,3561,3570,3571,3590,3591,3592,
   3598,3599,3602,3603,3612,3613,3749,3750,3756,3757,3770,3771,3787,3793,3794,3829,3830,3833,
   3834,3843,3844,4025,4038,4039,4139,4354,4510,4511,4512,4518,4528,4529,5645,5646,5650,5651,
   5652,5658,5659,5662,5663,5672,5673,5689,5693,5694,5695,5701,5702,5705,5706,5715,5716,5735,
   5736,5737,5743,5744,5747,5748,5757,5758,5894,5902,5905,5916,5939,5942,5953,5978,5979,6170,
   6173,6183,6184,6202,6212,6213,6284,6293,6294,6499,7725,7726,7730,7731,7732,7738,7739,7742,
   7743,7752,7753,7769,7773,7774,7775,7781,7782,7785,7786,7795,7796,7815,7816,7817,7823,7824,
   7827,7828,7837,7838,7974,7986,7995,7996,8018,8019,8023,8032,8033,8058,8059,8250,8254,8263,
   8283,8292,8364,8398,8399,8579,38205,38209,38210,38211,38217,38218,38221,38222,38231,38232,
   38251,38252,38253,38259,38260,38263,38264,38273,38274,38410,38411,38417,38418,38431,38432,38448,
   38454,38455,38468,38469,38490,38491,38494,38495,38504,38505,38686,38699,38700,38728,38729,38800,
   39015,39154,39155,39156,39162,39163,39166,39167,39176,39177,39313,39320,39321,39324,39334,39335,
   39357,39358,39361,39371,39372,39397,39398,39589,39592,39602,39603,39621,39631,39632,39703,39712,
   39713,39918,40174,40181,40182,40186,40195,40196,40218,40219,40223,40232,40233,40258,40259,40450,
   40454,40463,40464,40483,40492,40493,40564,40598,40599,40779,43262,43263,43266,43276,43277,43298,
   43494,43507,43508,43536,43537,43643,43823,43965,44160,44173,44174,44202,44203,44308,44489,44904,
   45119,47903,47912,47913,47993,48199,48400,48605],[3794,44204],[3794,44205],[3794,44206],
 [3794,44207],[3794,44208],[3794,44209],[3794,44210],[3794,44211],[3794,44212],
 [3794,44213],[3794,44214],[3794,44215],[3794,44216],[3794,44217],[3794,44218],
 [3507,41069],[3507,3677,3714,38331,38557,41850,42593],[3507,3930,38591,44695],
 [3507,3677,3714,38331,38557,41850,42593],[3507,3930,38591,44695],[3507,3756],
 [3507,3794,38455,43965],[3507],[3507],[3507,44904],[3507,44904],[3507,4193],[3507],
 [3507],[3507,38921],[3507,4193],[3507,38921],[3507,45084],[3507,45084],[3507,39015],
 [3507,39015],[3507],[3507],[3507],[3507],[3507],[3507],[3507],[3507],[3507],
 [3507],[3507],[3507],[3507],[3507],[3507],
 [3500,3501,3502,3503,3504,3507,3508,3509,3511,3544,3550,3592,3633,3634,3670,3673,3675,3677,3712,
   3714,3716,3824,3825,3827,3896,38205,38206,38207,38208,38211,38212,38213,38215,38248,38249,
   38250,38253,38254,38255,38257,38290,38291,38294,38295,38296,38298,38331,38334,38335,38336,38338,
   38373,38374,38375,38377,38485,38486,38488,38521,38523,38557,39151,39152,39153,39156,39157,39158,
   39160,39193,39194,39197,39198,39199,39201,39234,39237,39238,39239,39241,39276,39277,39278,39280,
   39388,39389,39391,39424,39426,39460,40054,40055,40058,40059,40060,40062,40095,40098,40099,40100,
   40102,40137,40138,40139,40141,40249,40250,40252,40285,40287,40321,40915,40918,40919,40920,40922,
   40957,40958,40959,40961,41069,41070,41072,41105,41107,41141,41737,41738,41739,41741,41849,41850,
   41852,41885,41887,41921,42590,42591,42593,42626,42628,42662,44625,44627,44661,45256],
 [3502,3505,3507,3508,3510,3512,3513,3633,3634,3750,3756,3824,3826,3828,3829,3930,38294,38295,
   38411,38417,38485,38487,38489,38490,38591,40995,40996,40998,41069,41071,41073,41074,41106,41108,
   41109,41175,41176,41239,43293,43295,43297,43298,43330,43332,43399,44626,44628,44629,44695,44696,
   44759,45290,45354,46443],[3500,3501,3502,3503,3504,3507,3508,3509,3511,3544,3550,3592,3633,
   3634,3670,3673,3675,3677,3712,3714,3716,3824,3825,3827,3896,38205,38206,38207,38208,38211,
   38212,38213,38215,38248,38249,38250,38253,38254,38255,38257,38290,38291,38294,38295,38296,38298,
   38331,38334,38335,38336,38338,38373,38374,38375,38377,38485,38486,38488,38521,38523,38557,39151,
   39152,39153,39156,39157,39158,39160,39193,39194,39197,39198,39199,39201,39234,39237,39238,39239,
   39241,39276,39277,39278,39280,39388,39389,39391,39424,39426,39460,40054,40055,40058,40059,40060,
   40062,40095,40098,40099,40100,40102,40137,40138,40139,40141,40249,40250,40252,40285,40287,40321,
   40915,40918,40919,40920,40922,40957,40958,40959,40961,41069,41070,41072,41105,41107,41141,41737,
   41738,41739,41741,41849,41850,41852,41885,41887,41921,42590,42591,42593,42626,42628,42662,44625,
   44627,44661,45256],[3502,3505,3507,3508,3510,3512,3513,3633,3634,3750,3756,3824,3826,3828,
   3829,3930,38294,38295,38411,38417,38485,38487,38489,38490,38591,40995,40996,40998,41069,41071,
   41073,41074,41106,41108,41109,41175,41176,41239,43293,43295,43297,43298,43330,43332,43399,44626,
   44628,44629,44695,44696,44759,45290,45354,46443],
 [3502,3505,3507,3508,3510,3512,3513,3633,3634,3750,3756,3824,3826,3828,3829,3930,38294,38295,
   38411,38417,38485,38487,38489,38490,38591,40995,40996,40998,41069,41071,41073,41074,41106,41108,
   41109,41175,41176,41239,43293,43295,43297,43298,43330,43332,43399,44626,44628,44629,44695,44696,
   44759,45290,45354,46443],[3502,3506,3507,3508,3514,3633,3634,3787,3794,3824,3830,38294,38295,
   38448,38455,38485,38491,41032,41033,41039,41069,41075,41110,43959,43965,44000,44630],
 [3502,3507,3508,3515,3633,3634,3824,3831,38294,38295,38485,38492,41069,41076,41111,44631],
 [3502,3507,3508,3516,3633,3634,3824,3832,38294,38295,38485,38493,41069,41077,41112,44632],
 [23,31,44,1291,1296,1306,1309,1432,1625,1658,3502,3507,3508,3517,3518,3520,3633,3634,3824,3833,
   3834,3836,4139,38294,38295,38304,38485,38494,38495,38497,38800,41069,41078,41079,41081,41113,
   41114,41116,41384,41386,41411,44633,44634,44636,44904,44906,44931,45499,45501,45526,49471],
 [23,31,44,1291,1296,1306,1309,1432,1625,1658,3502,3507,3508,3517,3518,3520,3633,3634,3824,3833,
   3834,3836,4139,38294,38295,38304,38485,38494,38495,38497,38800,41069,41078,41079,41081,41113,
   41114,41116,41384,41386,41411,44633,44634,44636,44904,44906,44931,45499,45501,45526,49471],
 [3502,3507,3508,3519,3523,3633,3634,3824,3835,3839,4193,38294,38295,38485,38496,38500,38854,
   41069,41080,41084,41115,41119,44635,44639,44958],
 [23,31,44,1291,1296,1306,1309,1432,1625,1658,3502,3507,3508,3517,3518,3520,3633,3634,3824,3833,
   3834,3836,4139,38294,38295,38304,38485,38494,38495,38497,38800,41069,41078,41079,41081,41113,
   41114,41116,41384,41386,41411,44633,44634,44636,44904,44906,44931,45499,45501,45526,49471],
 [3502,3507,3508,3521,3633,3634,3824,3837,38294,38295,38485,38498,41069,41082,41117,44637],
 [3502,3507,3508,3522,3524,3633,3634,3824,3838,3840,4260,38294,38295,38309,38311,38485,38499,
   38501,38534,38536,38921,41069,41083,41085,41118,41120,41505,44638,44640,45025,45620],
 [3502,3507,3508,3519,3523,3633,3634,3824,3835,3839,4193,38294,38295,38485,38496,38500,38854,
   41069,41080,41084,41115,41119,44635,44639,44958],
 [3502,3507,3508,3522,3524,3633,3634,3824,3838,3840,4260,38294,38295,38309,38311,38485,38499,
   38501,38534,38536,38921,41069,41083,41085,41118,41120,41505,44638,44640,45025,45620],
 [3502,3507,3508,3525,3526,3633,3634,3824,3841,3842,4319,38294,38295,38485,38502,38503,38980,
   41069,41086,41087,41121,41122,41564,44641,44642,45084,45679],
 [3502,3507,3508,3525,3526,3633,3634,3824,3841,3842,4319,38294,38295,38485,38502,38503,38980,
   41069,41086,41087,41121,41122,41564,44641,44642,45084,45679],
 [3502,3507,3508,3527,3528,3633,3634,3824,3843,3844,4354,38294,38295,38314,38315,38485,38504,
   38505,38539,38540,39015,41069,41088,41089,41123,41124,41599,44643,44644,45119,45714],
 [3502,3507,3508,3527,3528,3633,3634,3824,3843,3844,4354,38294,38295,38314,38315,38485,38504,
   38505,38539,38540,39015,41069,41088,41089,41123,41124,41599,44643,44644,45119,45714],
 [3502,3507,3508,3529,3530,3633,3634,3824,3845,3846,38294,38295,38485,38506,38507,41069,41090,
   41091,41125,41126,41630,44645,44646,45150,45745],
 [3502,3507,3508,3529,3530,3633,3634,3824,3845,3846,38294,38295,38485,38506,38507,41069,41090,
   41091,41125,41126,41630,44645,44646,45150,45745],
 [3502,3507,3508,3531,3633,3634,3824,3847,38294,38295,38485,38508,41069,41092,41127,44647],
 [3502,3507,3508,3532,3633,3634,3824,3848,38294,38295,38485,38509,41069,41093,41128,44648],
 [3502,3507,3508,3533,3633,3634,3824,3849,38294,38295,38485,38510,41069,41094,41129,44649],
 [3502,3507,3508,3534,3536,3633,3634,3824,3850,3852,38294,38295,38485,38511,38513,41069,41095,
   41097,41130,41132,41691,44650,44652,45211,45806],
 [3502,3507,3508,3535,3633,3634,3824,3851,38294,38295,38485,38512,41069,41096,41131,44651],
 [3502,3507,3508,3534,3536,3633,3634,3824,3850,3852,38294,38295,38485,38511,38513,41069,41095,
   41097,41130,41132,41691,44650,44652,45211,45806],
 [3502,3507,3508,3537,3633,3634,3824,3853,38294,38295,38485,38514,41069,41098,41133,44653],
 [3502,3507,3508,3538,3633,3634,3824,3854,38294,38295,38485,38515,41069,41099,41134,44654],
 [3502,3507,3508,3539,3633,3634,3824,3855,38294,38295,38485,38516,41069,41100,41135,44655],
 [3502,3507,3508,3540,3633,3634,3824,3856,38294,38295,38485,38517,41069,41101,41136,44656],
 [3502,3507,3508,3541,3542,3633,3634,3824,3857,3858,38294,38295,38485,38518,38519,41069,41102,
   41103,41137,41138,41732,44657,44658,45252,45847],
 [3502,3507,3508,3541,3542,3633,3634,3824,3857,3858,38294,38295,38485,38518,38519,41069,41102,
   41103,41137,41138,41732,44657,44658,45252,45847],
 [3502,3507,3508,3543,3633,3634,3824,3859,38294,38295,38485,38520,41069,41104,41139,44659],
 [3714,3794,3930,42555,42556,42558,42560,42661,42663,42665,42696,42698,42761,44030,44032,44034,
   44065,44067,44130,45851,45853,45916,46444],[3507,3677,3714,38331,38557,41850,42593],
 [3714,3794,3930,42555,42556,42558,42560,42661,42663,42665,42696,42698,42761,44030,44032,44034,
   44065,44067,44130,45851,45853,45916,46444],[3714,3756,42518,42664],
 [3714,3794,3930,42555,42556,42558,42560,42661,42663,42665,42696,42698,42761,44030,44032,44034,
   44065,44067,44130,45851,45853,45916,46444],[3714,42666],[3714,42667],
 [3503,3504,3507,3509,3511,3517,3518,3522,3524,3670,3673,3675,3677,3712,3714,3716,3825,3827,3833,
   3834,3838,3840,3896,4139,4260,38331,38334,38336,38338,38344,38345,38349,38351,38373,38375,
   38377,38383,38384,38388,38390,38486,38488,38494,38495,38499,38501,38557,38563,38564,38568,38570,
   38628,38629,38633,38635,38800,38804,38806,38829,38831,38921,41737,41739,41741,41747,41748,41752,
   41754,41850,41852,41858,41859,41863,41865,41921,41927,41928,41932,41934,41992,41993,41997,41999,
   42164,42168,42170,42193,42195,42285,42591,42593,42599,42600,42604,42606,42662,42668,42669,42673,
   42675,42733,42734,42738,42740,42905,42909,42911,42934,42936,43026,44661,44667,44668,44672,44674,
   44732,44733,44737,44739,44904,44908,44910,44933,44935,45025,45888,45889,45893,45895,46060,46064,
   46066,46089,46091,46181,47084,47088,47090,47113,47115,47205,49473,49475,49565,49865],
 [3503,3504,3507,3509,3511,3517,3518,3522,3524,3670,3673,3675,3677,3712,3714,3716,3825,3827,3833,
   3834,3838,3840,3896,4139,4260,38331,38334,38336,38338,38344,38345,38349,38351,38373,38375,
   38377,38383,38384,38388,38390,38486,38488,38494,38495,38499,38501,38557,38563,38564,38568,38570,
   38628,38629,38633,38635,38800,38804,38806,38829,38831,38921,41737,41739,41741,41747,41748,41752,
   41754,41850,41852,41858,41859,41863,41865,41921,41927,41928,41932,41934,41992,41993,41997,41999,
   42164,42168,42170,42193,42195,42285,42591,42593,42599,42600,42604,42606,42662,42668,42669,42673,
   42675,42733,42734,42738,42740,42905,42909,42911,42934,42936,43026,44661,44667,44668,44672,44674,
   44732,44733,44737,44739,44904,44908,44910,44933,44935,45025,45888,45889,45893,45895,46060,46064,
   46066,46089,46091,46181,47084,47088,47090,47113,47115,47205,49473,49475,49565,49865],
 [3714,4193,42670,42674],[3714,42671],[3714,42672],
 [3503,3504,3507,3509,3511,3517,3518,3522,3524,3670,3673,3675,3677,3712,3714,3716,3825,3827,3833,
   3834,3838,3840,3896,4139,4260,38331,38334,38336,38338,38344,38345,38349,38351,38373,38375,
   38377,38383,38384,38388,38390,38486,38488,38494,38495,38499,38501,38557,38563,38564,38568,38570,
   38628,38629,38633,38635,38800,38804,38806,38829,38831,38921,41737,41739,41741,41747,41748,41752,
   41754,41850,41852,41858,41859,41863,41865,41921,41927,41928,41932,41934,41992,41993,41997,41999,
   42164,42168,42170,42193,42195,42285,42591,42593,42599,42600,42604,42606,42662,42668,42669,42673,
   42675,42733,42734,42738,42740,42905,42909,42911,42934,42936,43026,44661,44667,44668,44672,44674,
   44732,44733,44737,44739,44904,44908,44910,44933,44935,45025,45888,45889,45893,45895,46060,46064,
   46066,46089,46091,46181,47084,47088,47090,47113,47115,47205,49473,49475,49565,49865],
 [3714,4193,42670,42674],[3503,3504,3507,3509,3511,3517,3518,3522,3524,3670,3673,3675,3677,3712,
   3714,3716,3825,3827,3833,3834,3838,3840,3896,4139,4260,38331,38334,38336,38338,38344,38345,
   38349,38351,38373,38375,38377,38383,38384,38388,38390,38486,38488,38494,38495,38499,38501,38557,
   38563,38564,38568,38570,38628,38629,38633,38635,38800,38804,38806,38829,38831,38921,41737,41739,
   41741,41747,41748,41752,41754,41850,41852,41858,41859,41863,41865,41921,41927,41928,41932,41934,
   41992,41993,41997,41999,42164,42168,42170,42193,42195,42285,42591,42593,42599,42600,42604,42606,
   42662,42668,42669,42673,42675,42733,42734,42738,42740,42905,42909,42911,42934,42936,43026,44661,
   44667,44668,44672,44674,44732,44733,44737,44739,44904,44908,44910,44933,44935,45025,45888,45889,
   45893,45895,46060,46064,46066,46089,46091,46181,47084,47088,47090,47113,47115,47205,49473,49475,
   49565,49865],[3503,3504,3507,3509,3511,3525,3526,3527,3528,3670,3673,3675,3677,3712,3714,
   3716,3825,3827,3841,3842,3843,3844,3896,4319,4354,38331,38334,38336,38338,38352,38353,38354,
   38355,38373,38375,38377,38391,38392,38393,38394,38486,38488,38502,38503,38504,38505,38557,38571,
   38572,38573,38574,38636,38637,38638,38639,38980,38981,38982,38998,38999,39015,41737,41739,41741,
   41755,41756,41757,41758,41850,41852,41866,41867,41868,41869,41921,41935,41936,41937,41938,42000,
   42001,42002,42003,42344,42345,42346,42362,42363,42379,42591,42593,42607,42608,42609,42610,42662,
   42676,42677,42678,42679,42741,42742,42743,42744,43085,43086,43087,43103,43104,43120,44661,44675,
   44676,44677,44678,44740,44741,44742,44743,45084,45085,45086,45102,45103,45119,45896,45897,45898,
   45899,46240,46241,46242,46258,46259,46275,47264,47265,47266,47282,47283,47299,51426,51427,51443,
   51579],[3503,3504,3507,3509,3511,3525,3526,3527,3528,3670,3673,3675,3677,3712,3714,3716,
   3825,3827,3841,3842,3843,3844,3896,4319,4354,38331,38334,38336,38338,38352,38353,38354,38355,
   38373,38375,38377,38391,38392,38393,38394,38486,38488,38502,38503,38504,38505,38557,38571,38572,
   38573,38574,38636,38637,38638,38639,38980,38981,38982,38998,38999,39015,41737,41739,41741,41755,
   41756,41757,41758,41850,41852,41866,41867,41868,41869,41921,41935,41936,41937,41938,42000,42001,
   42002,42003,42344,42345,42346,42362,42363,42379,42591,42593,42607,42608,42609,42610,42662,42676,
   42677,42678,42679,42741,42742,42743,42744,43085,43086,43087,43103,43104,43120,44661,44675,44676,
   44677,44678,44740,44741,44742,44743,45084,45085,45086,45102,45103,45119,45896,45897,45898,45899,
   46240,46241,46242,46258,46259,46275,47264,47265,47266,47282,47283,47299,51426,51427,51443,51579]
  ,[3503,3504,3507,3509,3511,3525,3526,3527,3528,3670,3673,3675,3677,3712,3714,3716,3825,3827,
   3841,3842,3843,3844,3896,4319,4354,38331,38334,38336,38338,38352,38353,38354,38355,38373,38375,
   38377,38391,38392,38393,38394,38486,38488,38502,38503,38504,38505,38557,38571,38572,38573,38574,
   38636,38637,38638,38639,38980,38981,38982,38998,38999,39015,41737,41739,41741,41755,41756,41757,
   41758,41850,41852,41866,41867,41868,41869,41921,41935,41936,41937,41938,42000,42001,42002,42003,
   42344,42345,42346,42362,42363,42379,42591,42593,42607,42608,42609,42610,42662,42676,42677,42678,
   42679,42741,42742,42743,42744,43085,43086,43087,43103,43104,43120,44661,44675,44676,44677,44678,
   44740,44741,44742,44743,45084,45085,45086,45102,45103,45119,45896,45897,45898,45899,46240,46241,
   46242,46258,46259,46275,47264,47265,47266,47282,47283,47299,51426,51427,51443,51579],
 [3503,3504,3507,3509,3511,3525,3526,3527,3528,3670,3673,3675,3677,3712,3714,3716,3825,3827,3841,
   3842,3843,3844,3896,4319,4354,38331,38334,38336,38338,38352,38353,38354,38355,38373,38375,
   38377,38391,38392,38393,38394,38486,38488,38502,38503,38504,38505,38557,38571,38572,38573,38574,
   38636,38637,38638,38639,38980,38981,38982,38998,38999,39015,41737,41739,41741,41755,41756,41757,
   41758,41850,41852,41866,41867,41868,41869,41921,41935,41936,41937,41938,42000,42001,42002,42003,
   42344,42345,42346,42362,42363,42379,42591,42593,42607,42608,42609,42610,42662,42676,42677,42678,
   42679,42741,42742,42743,42744,43085,43086,43087,43103,43104,43120,44661,44675,44676,44677,44678,
   44740,44741,44742,44743,45084,45085,45086,45102,45103,45119,45896,45897,45898,45899,46240,46241,
   46242,46258,46259,46275,47264,47265,47266,47282,47283,47299,51426,51427,51443,51579],
 [3714,42680],[3714,42681],[3714,42682],[3714,42683],[3714,42684],[3714,42685],
 [3714,42686],[3714,42687],[3714,42688],[3714,42689],[3714,42690],[3714,42691],
 [3714,42692],[3714,42693],[3714,42694],[3677,3930,41954,41955,41987,46411],[],
 [3502,3505,3507,3508,3510,3512,3513,3633,3634,3750,3756,3824,3826,3828,3829,3930,38294,38295,
   38411,38417,38485,38487,38489,38490,38591,40995,40996,40998,41069,41071,41073,41074,41106,41108,
   41109,41175,41176,41239,43293,43295,43297,43298,43330,43332,43399,44626,44628,44629,44695,44696,
   44759,45290,45354,46443],[3714,3794,3930,42555,42556,42558,42560,42661,42663,42665,42696,
   42698,42761,44030,44032,44034,44065,44067,44130,45851,45853,45916,46444],[3930,46445],
 [3930,46446],[3507,3510,3512,3517,3518,3519,3523,3826,3828,3833,3834,3835,3839,3930,4139,4193,
   38487,38489,38494,38495,38496,38500,38591,38800,38854,44695,44700,44701,44702,44706,44763,44764,
   44765,44769,44904,44905,44909,44930,44934,44958,46447,46448,46449,46453,46588,46593,46614,46618,
   47549,47550,47554,47575,49470,49474],[3507,3510,3512,3517,3518,3519,3523,3826,3828,3833,3834,
   3835,3839,3930,4139,4193,38487,38489,38494,38495,38496,38500,38591,38800,38854,44695,44700,
   44701,44702,44706,44763,44764,44765,44769,44904,44905,44909,44930,44934,44958,46447,46448,46449,
   46453,46588,46593,46614,46618,47549,47550,47554,47575,49470,49474],
 [3507,3510,3512,3517,3518,3519,3523,3826,3828,3833,3834,3835,3839,3930,4139,4193,38487,38489,
   38494,38495,38496,38500,38591,38800,38854,44695,44700,44701,44702,44706,44763,44764,44765,44769,
   44904,44905,44909,44930,44934,44958,46447,46448,46449,46453,46588,46593,46614,46618,47549,47550,
   47554,47575,49470,49474],[3930,46450],[3930,46451],
 [3507,3510,3512,3522,3524,3826,3828,3838,3840,3930,4260,38487,38489,38499,38501,38591,38601,
   38603,38664,38666,38921,44695,45025,46452,46454,46709,47670],
 [3507,3510,3512,3517,3518,3519,3523,3826,3828,3833,3834,3835,3839,3930,4139,4193,38487,38489,
   38494,38495,38496,38500,38591,38800,38854,44695,44700,44701,44702,44706,44763,44764,44765,44769,
   44904,44905,44909,44930,44934,44958,46447,46448,46449,46453,46588,46593,46614,46618,47549,47550,
   47554,47575,49470,49474],[3507,3510,3512,3522,3524,3826,3828,3838,3840,3930,4260,38487,38489,
   38499,38501,38591,38601,38603,38664,38666,38921,44695,45025,46452,46454,46709,47670],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,3501,3507,3510,3512,3517,
   3518,3519,3523,3525,3526,3544,3550,3560,3561,3592,3602,3603,3826,3828,3833,3834,3835,3839,
   3841,3842,3930,3935,3936,3937,3941,3998,3999,4000,4004,4139,4140,4144,4146,4147,4165,4169,
   4171,4172,4193,4195,4196,4281,4282,4319,4510,4511,4512,4518,4528,4529,5645,5646,5652,5662,
   5663,5689,5695,5698,5700,5705,5706,5707,5711,5713,5714,5737,5747,5748,5971,5973,5978,5979,
   5980,5984,5986,5987,6075,6080,6081,6086,6089,6143,6144,6145,6149,6151,6152,6284,6285,6289,
   6291,6292,6310,6314,6316,6317,6340,6341,6427,6464,7725,7726,7732,7742,7743,7769,7775,7785,
   7786,7817,7820,7822,7827,7828,7829,7833,7835,7836,8051,8053,8058,8059,8060,8064,8066,8067,
   8155,8160,8161,8162,8166,8168,8169,8223,8224,8225,8231,8364,8365,8369,8371,8372,8390,8394,
   8396,8397,8420,8506,8507,8544,38205,38211,38221,38222,38253,38263,38264,38487,38489,38494,
   38495,38496,38500,38502,38503,38591,38800,38854,38980,39156,39166,39167,39397,39398,39499,39505,
   39562,39571,39703,39704,39708,39710,39711,39759,40258,40259,40361,40368,40424,40425,40564,40590,
   40594,40596,40597,40707,44695,44700,44701,44702,44706,44708,44709,44763,44764,44765,44769,44771,
   44772,44904,44905,44909,44911,44912,44930,44934,44936,44937,44958,44960,44961,45046,45047,45084,
   46447,46448,46449,46453,46455,46456,46588,46589,46593,46595,46596,46614,46618,46620,46621,46642,
   46644,46645,46730,46731,46768,47549,47550,47554,47556,47557,47575,47579,47581,47582,47603,47605,
   47606,47691,47692,47729,49470,49474,49476,49477,49498,49500,49501,49586,49587,49624,49798,49800,
   49801,49886,49887,49924,50162,50163,50200,51084],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,3501,3507,3510,3512,3517,
   3518,3519,3523,3525,3526,3544,3550,3560,3561,3592,3602,3603,3826,3828,3833,3834,3835,3839,
   3841,3842,3930,3935,3936,3937,3941,3998,3999,4000,4004,4139,4140,4144,4146,4147,4165,4169,
   4171,4172,4193,4195,4196,4281,4282,4319,4510,4511,4512,4518,4528,4529,5645,5646,5652,5662,
   5663,5689,5695,5698,5700,5705,5706,5707,5711,5713,5714,5737,5747,5748,5971,5973,5978,5979,
   5980,5984,5986,5987,6075,6080,6081,6086,6089,6143,6144,6145,6149,6151,6152,6284,6285,6289,
   6291,6292,6310,6314,6316,6317,6340,6341,6427,6464,7725,7726,7732,7742,7743,7769,7775,7785,
   7786,7817,7820,7822,7827,7828,7829,7833,7835,7836,8051,8053,8058,8059,8060,8064,8066,8067,
   8155,8160,8161,8162,8166,8168,8169,8223,8224,8225,8231,8364,8365,8369,8371,8372,8390,8394,
   8396,8397,8420,8506,8507,8544,38205,38211,38221,38222,38253,38263,38264,38487,38489,38494,
   38495,38496,38500,38502,38503,38591,38800,38854,38980,39156,39166,39167,39397,39398,39499,39505,
   39562,39571,39703,39704,39708,39710,39711,39759,40258,40259,40361,40368,40424,40425,40564,40590,
   40594,40596,40597,40707,44695,44700,44701,44702,44706,44708,44709,44763,44764,44765,44769,44771,
   44772,44904,44905,44909,44911,44912,44930,44934,44936,44937,44958,44960,44961,45046,45047,45084,
   46447,46448,46449,46453,46455,46456,46588,46589,46593,46595,46596,46614,46618,46620,46621,46642,
   46644,46645,46730,46731,46768,47549,47550,47554,47556,47557,47575,47579,47581,47582,47603,47605,
   47606,47691,47692,47729,49470,49474,49476,49477,49498,49500,49501,49586,49587,49624,49798,49800,
   49801,49886,49887,49924,50162,50163,50200,51084],
 [3507,3510,3512,3527,3528,3826,3828,3843,3844,3930,4354,38487,38489,38504,38505,38591,38606,
   38607,38669,38670,39015,44695,45119,46457,46458,46803,47764],
 [3507,3510,3512,3527,3528,3826,3828,3843,3844,3930,4354,38487,38489,38504,38505,38591,38606,
   38607,38669,38670,39015,44695,45119,46457,46458,46803,47764],[3930,46459],[3930,46460],
 [3930,46461],[3930,46462],[3930,46463],[3930,46464],[3930,46465],[3930,46466],
 [3930,46467],[3930,46468],[3930,46469],[3930,46470],[3930,46471],[3930,46472],
 [3930,46473],[3677,3930,41954,41955,41987,46411],[3677,3756,41779,41988],
 [3677,3794,41816,41819,41989,44099],[3677,41990,41991,42109,47029],
 [3677,41990,41991,42109,47029],[3503,3504,3507,3509,3511,3517,3518,3522,3524,3670,3673,3675,
   3677,3712,3714,3716,3825,3827,3833,3834,3838,3840,3896,4139,4260,38331,38334,38336,38338,
   38344,38345,38349,38351,38373,38375,38377,38383,38384,38388,38390,38486,38488,38494,38495,38499,
   38501,38557,38563,38564,38568,38570,38628,38629,38633,38635,38800,38804,38806,38829,38831,38921,
   41737,41739,41741,41747,41748,41752,41754,41850,41852,41858,41859,41863,41865,41921,41927,41928,
   41932,41934,41992,41993,41997,41999,42164,42168,42170,42193,42195,42285,42591,42593,42599,42600,
   42604,42606,42662,42668,42669,42673,42675,42733,42734,42738,42740,42905,42909,42911,42934,42936,
   43026,44661,44667,44668,44672,44674,44732,44733,44737,44739,44904,44908,44910,44933,44935,45025,
   45888,45889,45893,45895,46060,46064,46066,46089,46091,46181,47084,47088,47090,47113,47115,47205,
   49473,49475,49565,49865],[3503,3504,3507,3509,3511,3517,3518,3522,3524,3670,3673,3675,3677,
   3712,3714,3716,3825,3827,3833,3834,3838,3840,3896,4139,4260,38331,38334,38336,38338,38344,
   38345,38349,38351,38373,38375,38377,38383,38384,38388,38390,38486,38488,38494,38495,38499,38501,
   38557,38563,38564,38568,38570,38628,38629,38633,38635,38800,38804,38806,38829,38831,38921,41737,
   41739,41741,41747,41748,41752,41754,41850,41852,41858,41859,41863,41865,41921,41927,41928,41932,
   41934,41992,41993,41997,41999,42164,42168,42170,42193,42195,42285,42591,42593,42599,42600,42604,
   42606,42662,42668,42669,42673,42675,42733,42734,42738,42740,42905,42909,42911,42934,42936,43026,
   44661,44667,44668,44672,44674,44732,44733,44737,44739,44904,44908,44910,44933,44935,45025,45888,
   45889,45893,45895,46060,46064,46066,46089,46091,46181,47084,47088,47090,47113,47115,47205,49473,
   49475,49565,49865],[3677,4193,41994,41998],[3677,41995],[3677,41996],
 [3503,3504,3507,3509,3511,3517,3518,3522,3524,3670,3673,3675,3677,3712,3714,3716,3825,3827,3833,
   3834,3838,3840,3896,4139,4260,38331,38334,38336,38338,38344,38345,38349,38351,38373,38375,
   38377,38383,38384,38388,38390,38486,38488,38494,38495,38499,38501,38557,38563,38564,38568,38570,
   38628,38629,38633,38635,38800,38804,38806,38829,38831,38921,41737,41739,41741,41747,41748,41752,
   41754,41850,41852,41858,41859,41863,41865,41921,41927,41928,41932,41934,41992,41993,41997,41999,
   42164,42168,42170,42193,42195,42285,42591,42593,42599,42600,42604,42606,42662,42668,42669,42673,
   42675,42733,42734,42738,42740,42905,42909,42911,42934,42936,43026,44661,44667,44668,44672,44674,
   44732,44733,44737,44739,44904,44908,44910,44933,44935,45025,45888,45889,45893,45895,46060,46064,
   46066,46089,46091,46181,47084,47088,47090,47113,47115,47205,49473,49475,49565,49865],
 [3677,4193,41994,41998],[3503,3504,3507,3509,3511,3517,3518,3522,3524,3670,3673,3675,3677,3712,
   3714,3716,3825,3827,3833,3834,3838,3840,3896,4139,4260,38331,38334,38336,38338,38344,38345,
   38349,38351,38373,38375,38377,38383,38384,38388,38390,38486,38488,38494,38495,38499,38501,38557,
   38563,38564,38568,38570,38628,38629,38633,38635,38800,38804,38806,38829,38831,38921,41737,41739,
   41741,41747,41748,41752,41754,41850,41852,41858,41859,41863,41865,41921,41927,41928,41932,41934,
   41992,41993,41997,41999,42164,42168,42170,42193,42195,42285,42591,42593,42599,42600,42604,42606,
   42662,42668,42669,42673,42675,42733,42734,42738,42740,42905,42909,42911,42934,42936,43026,44661,
   44667,44668,44672,44674,44732,44733,44737,44739,44904,44908,44910,44933,44935,45025,45888,45889,
   45893,45895,46060,46064,46066,46089,46091,46181,47084,47088,47090,47113,47115,47205,49473,49475,
   49565,49865],[3503,3504,3507,3509,3511,3525,3526,3527,3528,3670,3673,3675,3677,3712,3714,
   3716,3825,3827,3841,3842,3843,3844,3896,4319,4354,38331,38334,38336,38338,38352,38353,38354,
   38355,38373,38375,38377,38391,38392,38393,38394,38486,38488,38502,38503,38504,38505,38557,38571,
   38572,38573,38574,38636,38637,38638,38639,38980,38981,38982,38998,38999,39015,41737,41739,41741,
   41755,41756,41757,41758,41850,41852,41866,41867,41868,41869,41921,41935,41936,41937,41938,42000,
   42001,42002,42003,42344,42345,42346,42362,42363,42379,42591,42593,42607,42608,42609,42610,42662,
   42676,42677,42678,42679,42741,42742,42743,42744,43085,43086,43087,43103,43104,43120,44661,44675,
   44676,44677,44678,44740,44741,44742,44743,45084,45085,45086,45102,45103,45119,45896,45897,45898,
   45899,46240,46241,46242,46258,46259,46275,47264,47265,47266,47282,47283,47299,51426,51427,51443,
   51579],[3503,3504,3507,3509,3511,3525,3526,3527,3528,3670,3673,3675,3677,3712,3714,3716,
   3825,3827,3841,3842,3843,3844,3896,4319,4354,38331,38334,38336,38338,38352,38353,38354,38355,
   38373,38375,38377,38391,38392,38393,38394,38486,38488,38502,38503,38504,38505,38557,38571,38572,
   38573,38574,38636,38637,38638,38639,38980,38981,38982,38998,38999,39015,41737,41739,41741,41755,
   41756,41757,41758,41850,41852,41866,41867,41868,41869,41921,41935,41936,41937,41938,42000,42001,
   42002,42003,42344,42345,42346,42362,42363,42379,42591,42593,42607,42608,42609,42610,42662,42676,
   42677,42678,42679,42741,42742,42743,42744,43085,43086,43087,43103,43104,43120,44661,44675,44676,
   44677,44678,44740,44741,44742,44743,45084,45085,45086,45102,45103,45119,45896,45897,45898,45899,
   46240,46241,46242,46258,46259,46275,47264,47265,47266,47282,47283,47299,51426,51427,51443,51579]
  ,[3503,3504,3507,3509,3511,3525,3526,3527,3528,3670,3673,3675,3677,3712,3714,3716,3825,3827,
   3841,3842,3843,3844,3896,4319,4354,38331,38334,38336,38338,38352,38353,38354,38355,38373,38375,
   38377,38391,38392,38393,38394,38486,38488,38502,38503,38504,38505,38557,38571,38572,38573,38574,
   38636,38637,38638,38639,38980,38981,38982,38998,38999,39015,41737,41739,41741,41755,41756,41757,
   41758,41850,41852,41866,41867,41868,41869,41921,41935,41936,41937,41938,42000,42001,42002,42003,
   42344,42345,42346,42362,42363,42379,42591,42593,42607,42608,42609,42610,42662,42676,42677,42678,
   42679,42741,42742,42743,42744,43085,43086,43087,43103,43104,43120,44661,44675,44676,44677,44678,
   44740,44741,44742,44743,45084,45085,45086,45102,45103,45119,45896,45897,45898,45899,46240,46241,
   46242,46258,46259,46275,47264,47265,47266,47282,47283,47299,51426,51427,51443,51579],
 [3503,3504,3507,3509,3511,3525,3526,3527,3528,3670,3673,3675,3677,3712,3714,3716,3825,3827,3841,
   3842,3843,3844,3896,4319,4354,38331,38334,38336,38338,38352,38353,38354,38355,38373,38375,
   38377,38391,38392,38393,38394,38486,38488,38502,38503,38504,38505,38557,38571,38572,38573,38574,
   38636,38637,38638,38639,38980,38981,38982,38998,38999,39015,41737,41739,41741,41755,41756,41757,
   41758,41850,41852,41866,41867,41868,41869,41921,41935,41936,41937,41938,42000,42001,42002,42003,
   42344,42345,42346,42362,42363,42379,42591,42593,42607,42608,42609,42610,42662,42676,42677,42678,
   42679,42741,42742,42743,42744,43085,43086,43087,43103,43104,43120,44661,44675,44676,44677,44678,
   44740,44741,44742,44743,45084,45085,45086,45102,45103,45119,45896,45897,45898,45899,46240,46241,
   46242,46258,46259,46275,47264,47265,47266,47282,47283,47299,51426,51427,51443,51579],
 [3677,42004,42006,42411,47331],[3677,42005],[3677,42004,42006,42411,47331],
 [3677,42007,42008,42449,47369],[3677,42007,42008,42449,47369],[3677,42009],
 [3677,42010,42011,42479,47399],[3677,42010,42011,42479,47399],[3677,42012,42013,42494,47414],
 [3677,42012,42013,42494,47414],[3677,42014],[3677,42015],[3677,42016,42018,42513,47433],
 [3677,42017],[3677,42016,42018,42513,47433],
 [3502,3505,3507,3508,3510,3512,3513,3633,3634,3750,3756,3824,3826,3828,3829,3930,38294,38295,
   38411,38417,38485,38487,38489,38490,38591,40995,40996,40998,41069,41071,41073,41074,41106,41108,
   41109,41175,41176,41239,43293,43295,43297,43298,43330,43332,43399,44626,44628,44629,44695,44696,
   44759,45290,45354,46443],[3714,3794,3930,42555,42556,42558,42560,42661,42663,42665,42696,
   42698,42761,44030,44032,44034,44065,44067,44130,45851,45853,45916,46444],[3930,46445],
 [3930,46446],[3507,3510,3512,3517,3518,3519,3523,3826,3828,3833,3834,3835,3839,3930,4139,4193,
   38487,38489,38494,38495,38496,38500,38591,38800,38854,44695,44700,44701,44702,44706,44763,44764,
   44765,44769,44904,44905,44909,44930,44934,44958,46447,46448,46449,46453,46588,46593,46614,46618,
   47549,47550,47554,47575,49470,49474],[3507,3510,3512,3517,3518,3519,3523,3826,3828,3833,3834,
   3835,3839,3930,4139,4193,38487,38489,38494,38495,38496,38500,38591,38800,38854,44695,44700,
   44701,44702,44706,44763,44764,44765,44769,44904,44905,44909,44930,44934,44958,46447,46448,46449,
   46453,46588,46593,46614,46618,47549,47550,47554,47575,49470,49474],
 [3507,3510,3512,3517,3518,3519,3523,3826,3828,3833,3834,3835,3839,3930,4139,4193,38487,38489,
   38494,38495,38496,38500,38591,38800,38854,44695,44700,44701,44702,44706,44763,44764,44765,44769,
   44904,44905,44909,44930,44934,44958,46447,46448,46449,46453,46588,46593,46614,46618,47549,47550,
   47554,47575,49470,49474],[3930,46450],[3930,46451],
 [3507,3510,3512,3522,3524,3826,3828,3838,3840,3930,4260,38487,38489,38499,38501,38591,38601,
   38603,38664,38666,38921,44695,45025,46452,46454,46709,47670],
 [3507,3510,3512,3517,3518,3519,3523,3826,3828,3833,3834,3835,3839,3930,4139,4193,38487,38489,
   38494,38495,38496,38500,38591,38800,38854,44695,44700,44701,44702,44706,44763,44764,44765,44769,
   44904,44905,44909,44930,44934,44958,46447,46448,46449,46453,46588,46593,46614,46618,47549,47550,
   47554,47575,49470,49474],[3507,3510,3512,3522,3524,3826,3828,3838,3840,3930,4260,38487,38489,
   38499,38501,38591,38601,38603,38664,38666,38921,44695,45025,46452,46454,46709,47670],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,3501,3507,3510,3512,3517,
   3518,3519,3523,3525,3526,3544,3550,3560,3561,3592,3602,3603,3826,3828,3833,3834,3835,3839,
   3841,3842,3930,3935,3936,3937,3941,3998,3999,4000,4004,4139,4140,4144,4146,4147,4165,4169,
   4171,4172,4193,4195,4196,4281,4282,4319,4510,4511,4512,4518,4528,4529,5645,5646,5652,5662,
   5663,5689,5695,5698,5700,5705,5706,5707,5711,5713,5714,5737,5747,5748,5971,5973,5978,5979,
   5980,5984,5986,5987,6075,6080,6081,6086,6089,6143,6144,6145,6149,6151,6152,6284,6285,6289,
   6291,6292,6310,6314,6316,6317,6340,6341,6427,6464,7725,7726,7732,7742,7743,7769,7775,7785,
   7786,7817,7820,7822,7827,7828,7829,7833,7835,7836,8051,8053,8058,8059,8060,8064,8066,8067,
   8155,8160,8161,8162,8166,8168,8169,8223,8224,8225,8231,8364,8365,8369,8371,8372,8390,8394,
   8396,8397,8420,8506,8507,8544,38205,38211,38221,38222,38253,38263,38264,38487,38489,38494,
   38495,38496,38500,38502,38503,38591,38800,38854,38980,39156,39166,39167,39397,39398,39499,39505,
   39562,39571,39703,39704,39708,39710,39711,39759,40258,40259,40361,40368,40424,40425,40564,40590,
   40594,40596,40597,40707,44695,44700,44701,44702,44706,44708,44709,44763,44764,44765,44769,44771,
   44772,44904,44905,44909,44911,44912,44930,44934,44936,44937,44958,44960,44961,45046,45047,45084,
   46447,46448,46449,46453,46455,46456,46588,46589,46593,46595,46596,46614,46618,46620,46621,46642,
   46644,46645,46730,46731,46768,47549,47550,47554,47556,47557,47575,47579,47581,47582,47603,47605,
   47606,47691,47692,47729,49470,49474,49476,49477,49498,49500,49501,49586,49587,49624,49798,49800,
   49801,49886,49887,49924,50162,50163,50200,51084],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,3501,3507,3510,3512,3517,
   3518,3519,3523,3525,3526,3544,3550,3560,3561,3592,3602,3603,3826,3828,3833,3834,3835,3839,
   3841,3842,3930,3935,3936,3937,3941,3998,3999,4000,4004,4139,4140,4144,4146,4147,4165,4169,
   4171,4172,4193,4195,4196,4281,4282,4319,4510,4511,4512,4518,4528,4529,5645,5646,5652,5662,
   5663,5689,5695,5698,5700,5705,5706,5707,5711,5713,5714,5737,5747,5748,5971,5973,5978,5979,
   5980,5984,5986,5987,6075,6080,6081,6086,6089,6143,6144,6145,6149,6151,6152,6284,6285,6289,
   6291,6292,6310,6314,6316,6317,6340,6341,6427,6464,7725,7726,7732,7742,7743,7769,7775,7785,
   7786,7817,7820,7822,7827,7828,7829,7833,7835,7836,8051,8053,8058,8059,8060,8064,8066,8067,
   8155,8160,8161,8162,8166,8168,8169,8223,8224,8225,8231,8364,8365,8369,8371,8372,8390,8394,
   8396,8397,8420,8506,8507,8544,38205,38211,38221,38222,38253,38263,38264,38487,38489,38494,
   38495,38496,38500,38502,38503,38591,38800,38854,38980,39156,39166,39167,39397,39398,39499,39505,
   39562,39571,39703,39704,39708,39710,39711,39759,40258,40259,40361,40368,40424,40425,40564,40590,
   40594,40596,40597,40707,44695,44700,44701,44702,44706,44708,44709,44763,44764,44765,44769,44771,
   44772,44904,44905,44909,44911,44912,44930,44934,44936,44937,44958,44960,44961,45046,45047,45084,
   46447,46448,46449,46453,46455,46456,46588,46589,46593,46595,46596,46614,46618,46620,46621,46642,
   46644,46645,46730,46731,46768,47549,47550,47554,47556,47557,47575,47579,47581,47582,47603,47605,
   47606,47691,47692,47729,49470,49474,49476,49477,49498,49500,49501,49586,49587,49624,49798,49800,
   49801,49886,49887,49924,50162,50163,50200,51084],
 [3507,3510,3512,3527,3528,3826,3828,3843,3844,3930,4354,38487,38489,38504,38505,38591,38606,
   38607,38669,38670,39015,44695,45119,46457,46458,46803,47764],
 [3507,3510,3512,3527,3528,3826,3828,3843,3844,3930,4354,38487,38489,38504,38505,38591,38606,
   38607,38669,38670,39015,44695,45119,46457,46458,46803,47764],[3930,46459],[3930,46460],
 [3930,46461],[3930,46462],[3930,46463],[3930,46464],[3930,46465],[3930,46466],
 [3930,46467],[3930,46468],[3930,46469],[3930,46470],[3930,46471],[3930,46472],
 [3930,46473],[3500,3501,3505,3506,3507,3513,3514,3544,3550,3592,3750,3756,3787,3794,3829,3830,
   38205,38209,38210,38211,38217,38218,38251,38252,38253,38259,38260,38410,38411,38417,38418,38448,
   38454,38455,38490,38491,38686,39154,39155,39156,39162,39163,39313,39321,39358,39589,40174,40218,
   40219,40450,43263,43298,43965,44160],[3756],[3756],
 [3505,3507,3513,3517,3518,3750,3756,3829,3833,3834,4139,38411,38417,38490,38494,38495,38800,
   43298,43302,43303,43608,44793,44794,44904,47984],
 [3505,3507,3513,3517,3518,3750,3756,3829,3833,3834,4139,38411,38417,38490,38494,38495,38800,
   43298,43302,43303,43608,44793,44794,44904,47984],[3756,4193,43685,48035],
 [3756,4193,43685,48035],[3756],[3505,3507,3513,3522,3524,3750,3756,3829,3838,3840,4260,38411,
   38417,38426,38428,38490,38499,38501,38694,38696,38921,43298,43729,45025,48105],
 [3756,4193,43685,48035],[3505,3507,3513,3522,3524,3750,3756,3829,3838,3840,4260,38411,38417,
   38426,38428,38490,38499,38501,38694,38696,38921,43298,43729,45025,48105],
 [3505,3507,3513,3525,3526,3750,3756,3829,3841,3842,4319,38411,38417,38490,38502,38503,38980,
   43298,43310,43311,43788,44801,44802,45084,48164],
 [3505,3507,3513,3525,3526,3750,3756,3829,3841,3842,4319,38411,38417,38490,38502,38503,38980,
   43298,43310,43311,43788,44801,44802,45084,48164],
 [3505,3507,3513,3527,3528,3750,3756,3829,3843,3844,4354,38411,38417,38431,38432,38490,38504,
   38505,38699,38700,39015,43298,43823,45119,48199],
 [3505,3507,3513,3527,3528,3750,3756,3829,3843,3844,4354,38411,38417,38431,38432,38490,38504,
   38505,38699,38700,39015,43298,43823,45119,48199],[3756],[3756],[3756],[3756],[3756],
 [3756],[3756],[3756],[3756],[3756],[3756],[3756],[3756],[3756],[3756],[3794,44190],
 [3794,44191],[3506,3507,3514,3517,3518,3787,3794,3830,3833,3834,4139,38448,38455,38491,38494,
   38495,38800,43965,43968,43969,44192,44193,44274,44822,44823,44904,48390],
 [3506,3507,3514,3517,3518,3787,3794,3830,3833,3834,4139,38448,38455,38491,38494,38495,38800,
   43965,43968,43969,44192,44193,44274,44822,44823,44904,48390],
 [3506,3507,3514,3519,3522,3523,3524,3787,3794,3830,3835,3838,3839,3840,4193,4260,38448,38455,
   38460,38463,38464,38465,38491,38496,38499,38500,38501,38720,38723,38724,38725,38853,38854,38855,
   38920,38921,38941,43965,44194,44197,44198,44199,44329,44394,44395,44415,44958,45025,48443,48445,
   48510,48511,50141,50855],[3794,44195],[3794,44196],
 [3506,3507,3514,3519,3522,3523,3524,3787,3794,3830,3835,3838,3839,3840,4193,4260,38448,38455,
   38460,38463,38464,38465,38491,38496,38499,38500,38501,38720,38723,38724,38725,38853,38854,38855,
   38920,38921,38941,43965,44194,44197,44198,44199,44329,44394,44395,44415,44958,45025,48443,48445,
   48510,48511,50141,50855],[3506,3507,3514,3519,3522,3523,3524,3787,3794,3830,3835,3838,3839,
   3840,4193,4260,38448,38455,38460,38463,38464,38465,38491,38496,38499,38500,38501,38720,38723,
   38724,38725,38853,38854,38855,38920,38921,38941,43965,44194,44197,44198,44199,44329,44394,44395,
   44415,44958,45025,48443,48445,48510,48511,50141,50855],
 [3506,3507,3514,3519,3522,3523,3524,3787,3794,3830,3835,3838,3839,3840,4193,4260,38448,38455,
   38460,38463,38464,38465,38491,38496,38499,38500,38501,38720,38723,38724,38725,38853,38854,38855,
   38920,38921,38941,43965,44194,44197,44198,44199,44329,44394,44395,44415,44958,45025,48443,48445,
   48510,48511,50141,50855],[3506,3507,3514,3525,3526,3787,3794,3830,3841,3842,4319,38448,38455,
   38491,38502,38503,38980,43965,43976,43977,44200,44201,44454,44830,44831,45084,48570],
 [3506,3507,3514,3525,3526,3787,3794,3830,3841,3842,4319,38448,38455,38491,38502,38503,38980,
   43965,43976,43977,44200,44201,44454,44830,44831,45084,48570],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,3501,3505,3506,3507,3513,
   3514,3517,3518,3527,3528,3544,3548,3549,3550,3556,3557,3560,3561,3570,3571,3590,3591,3592,
   3598,3599,3602,3603,3612,3613,3749,3750,3756,3757,3770,3771,3787,3793,3794,3829,3830,3833,
   3834,3843,3844,4025,4038,4039,4139,4354,4510,4511,4512,4518,4528,4529,5645,5646,5650,5651,
   5652,5658,5659,5662,5663,5672,5673,5689,5693,5694,5695,5701,5702,5705,5706,5715,5716,5735,
   5736,5737,5743,5744,5747,5748,5757,5758,5894,5902,5905,5916,5939,5942,5953,5978,5979,6170,
   6173,6183,6184,6202,6212,6213,6284,6293,6294,6499,7725,7726,7730,7731,7732,7738,7739,7742,
   7743,7752,7753,7769,7773,7774,7775,7781,7782,7785,7786,7795,7796,7815,7816,7817,7823,7824,
   7827,7828,7837,7838,7974,7986,7995,7996,8018,8019,8023,8032,8033,8058,8059,8250,8254,8263,
   8283,8292,8364,8398,8399,8579,38205,38209,38210,38211,38217,38218,38221,38222,38231,38232,
   38251,38252,38253,38259,38260,38263,38264,38273,38274,38410,38411,38417,38418,38431,38432,38448,
   38454,38455,38468,38469,38490,38491,38494,38495,38504,38505,38686,38699,38700,38728,38729,38800,
   39015,39154,39155,39156,39162,39163,39166,39167,39176,39177,39313,39320,39321,39324,39334,39335,
   39357,39358,39361,39371,39372,39397,39398,39589,39592,39602,39603,39621,39631,39632,39703,39712,
   39713,39918,40174,40181,40182,40186,40195,40196,40218,40219,40223,40232,40233,40258,40259,40450,
   40454,40463,40464,40483,40492,40493,40564,40598,40599,40779,43262,43263,43266,43276,43277,43298,
   43494,43507,43508,43536,43537,43643,43823,43965,44160,44173,44174,44202,44203,44308,44489,44904,
   45119,47903,47912,47913,47993,48199,48400,48605],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,3501,3505,3506,3507,3513,
   3514,3517,3518,3527,3528,3544,3548,3549,3550,3556,3557,3560,3561,3570,3571,3590,3591,3592,
   3598,3599,3602,3603,3612,3613,3749,3750,3756,3757,3770,3771,3787,3793,3794,3829,3830,3833,
   3834,3843,3844,4025,4038,4039,4139,4354,4510,4511,4512,4518,4528,4529,5645,5646,5650,5651,
   5652,5658,5659,5662,5663,5672,5673,5689,5693,5694,5695,5701,5702,5705,5706,5715,5716,5735,
   5736,5737,5743,5744,5747,5748,5757,5758,5894,5902,5905,5916,5939,5942,5953,5978,5979,6170,
   6173,6183,6184,6202,6212,6213,6284,6293,6294,6499,7725,7726,7730,7731,7732,7738,7739,7742,
   7743,7752,7753,7769,7773,7774,7775,7781,7782,7785,7786,7795,7796,7815,7816,7817,7823,7824,
   7827,7828,7837,7838,7974,7986,7995,7996,8018,8019,8023,8032,8033,8058,8059,8250,8254,8263,
   8283,8292,8364,8398,8399,8579,38205,38209,38210,38211,38217,38218,38221,38222,38231,38232,
   38251,38252,38253,38259,38260,38263,38264,38273,38274,38410,38411,38417,38418,38431,38432,38448,
   38454,38455,38468,38469,38490,38491,38494,38495,38504,38505,38686,38699,38700,38728,38729,38800,
   39015,39154,39155,39156,39162,39163,39166,39167,39176,39177,39313,39320,39321,39324,39334,39335,
   39357,39358,39361,39371,39372,39397,39398,39589,39592,39602,39603,39621,39631,39632,39703,39712,
   39713,39918,40174,40181,40182,40186,40195,40196,40218,40219,40223,40232,40233,40258,40259,40450,
   40454,40463,40464,40483,40492,40493,40564,40598,40599,40779,43262,43263,43266,43276,43277,43298,
   43494,43507,43508,43536,43537,43643,43823,43965,44160,44173,44174,44202,44203,44308,44489,44904,
   45119,47903,47912,47913,47993,48199,48400,48605],[3794,44204],[3794,44205],[3794,44206],
 [3794,44207],[3794,44208],[3794,44209],[3794,44210],[3794,44211],[3794,44212],
 [3794,44213],[3794,44214],[3794,44215],[3794,44216],[3794,44217],[3794,44218],
 [3677,41990,41991,42109,47029],[3507,3515,3517,3518,3521,3831,3833,3834,3837,4139,38492,38494,
   38495,38498,38800,44850,44851,44854,44904,44907,44932,48768,48771,48796,49472],
 [3507,3515,3517,3518,3521,3831,3833,3834,3837,4139,38492,38494,38495,38498,38800,44850,44851,
   44854,44904,44907,44932,48768,48771,48796,49472],[4193],[],
 [3507,3515,3517,3518,3521,3831,3833,3834,3837,4139,38492,38494,38495,38498,38800,44850,44851,
   44854,44904,44907,44932,48768,48771,48796,49472],
 [3507,3515,3522,3524,3831,3838,3840,4260,38492,38499,38501,38751,38753,38921,45025,48889],
 [4193],[3507,3515,3522,3524,3831,3838,3840,4260,38492,38499,38501,38751,38753,38921,45025,48889]
  ,[3507,3515,3525,3526,3831,3841,3842,4319,38492,38502,38503,38980,44858,44859,45084,48948],
 [3507,3515,3525,3526,3831,3841,3842,4319,38492,38502,38503,38980,44858,44859,45084,48948],
 [3507,3515,3527,3528,3831,3843,3844,4354,38492,38504,38505,38756,38757,39015,45119,48983],
 [3507,3515,3527,3528,3831,3843,3844,4354,38492,38504,38505,38756,38757,39015,45119,48983],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [3507,3516,3517,3518,3832,3833,3834,4139,38493,38494,38495,38800,44877,44878,44904,49119],
 [3507,3516,3517,3518,3832,3833,3834,4139,38493,38494,38495,38800,44877,44878,44904,49119],
 [4193],[],[3507,3516,3521,3522,3524,3832,3837,3838,3840,4260,38493,38498,38499,38501,38777,
   38778,38780,38898,38900,38921,45025,49217,49219,49240,50625],
 [3507,3516,3521,3522,3524,3832,3837,3838,3840,4260,38493,38498,38499,38501,38777,38778,38780,
   38898,38900,38921,45025,49217,49219,49240,50625],[4193],
 [3507,3516,3521,3522,3524,3832,3837,3838,3840,4260,38493,38498,38499,38501,38777,38778,38780,
   38898,38900,38921,45025,49217,49219,49240,50625],
 [3507,3516,3525,3526,3832,3841,3842,4319,38493,38502,38503,38980,44885,44886,45084,49299],
 [3507,3516,3525,3526,3832,3841,3842,4319,38493,38502,38503,38980,44885,44886,45084,49299],
 [3507,3516,3527,3528,3832,3843,3844,4354,38493,38504,38505,38783,38784,39015,45119,49334],
 [3507,3516,3527,3528,3832,3843,3844,4354,38493,38504,38505,38783,38784,39015,45119,49334],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[3507,44904],
 [3507,3510,3512,3517,3518,3519,3523,3826,3828,3833,3834,3835,3839,3930,4139,4193,38487,38489,
   38494,38495,38496,38500,38591,38800,38854,44695,44700,44701,44702,44706,44763,44764,44765,44769,
   44904,44905,44909,44930,44934,44958,46447,46448,46449,46453,46588,46593,46614,46618,47549,47550,
   47554,47575,49470,49474],[23,31,44,1291,1296,1306,1309,1432,1625,1658,3502,3507,3508,3517,
   3518,3520,3633,3634,3824,3833,3834,3836,4139,38294,38295,38304,38485,38494,38495,38497,38800,
   41069,41078,41079,41081,41113,41114,41116,41384,41386,41411,44633,44634,44636,44904,44906,44931,
   45499,45501,45526,49471],[3507,3515,3517,3518,3521,3831,3833,3834,3837,4139,38492,38494,
   38495,38498,38800,44850,44851,44854,44904,44907,44932,48768,48771,48796,49472],
 [3503,3504,3507,3509,3511,3517,3518,3522,3524,3670,3673,3675,3677,3712,3714,3716,3825,3827,3833,
   3834,3838,3840,3896,4139,4260,38331,38334,38336,38338,38344,38345,38349,38351,38373,38375,
   38377,38383,38384,38388,38390,38486,38488,38494,38495,38499,38501,38557,38563,38564,38568,38570,
   38628,38629,38633,38635,38800,38804,38806,38829,38831,38921,41737,41739,41741,41747,41748,41752,
   41754,41850,41852,41858,41859,41863,41865,41921,41927,41928,41932,41934,41992,41993,41997,41999,
   42164,42168,42170,42193,42195,42285,42591,42593,42599,42600,42604,42606,42662,42668,42669,42673,
   42675,42733,42734,42738,42740,42905,42909,42911,42934,42936,43026,44661,44667,44668,44672,44674,
   44732,44733,44737,44739,44904,44908,44910,44933,44935,45025,45888,45889,45893,45895,46060,46064,
   46066,46089,46091,46181,47084,47088,47090,47113,47115,47205,49473,49475,49565,49865],
 [3507,3510,3512,3517,3518,3519,3523,3826,3828,3833,3834,3835,3839,3930,4139,4193,38487,38489,
   38494,38495,38496,38500,38591,38800,38854,44695,44700,44701,44702,44706,44763,44764,44765,44769,
   44904,44905,44909,44930,44934,44958,46447,46448,46449,46453,46588,46593,46614,46618,47549,47550,
   47554,47575,49470,49474],[3503,3504,3507,3509,3511,3517,3518,3522,3524,3670,3673,3675,3677,
   3712,3714,3716,3825,3827,3833,3834,3838,3840,3896,4139,4260,38331,38334,38336,38338,38344,
   38345,38349,38351,38373,38375,38377,38383,38384,38388,38390,38486,38488,38494,38495,38499,38501,
   38557,38563,38564,38568,38570,38628,38629,38633,38635,38800,38804,38806,38829,38831,38921,41737,
   41739,41741,41747,41748,41752,41754,41850,41852,41858,41859,41863,41865,41921,41927,41928,41932,
   41934,41992,41993,41997,41999,42164,42168,42170,42193,42195,42285,42591,42593,42599,42600,42604,
   42606,42662,42668,42669,42673,42675,42733,42734,42738,42740,42905,42909,42911,42934,42936,43026,
   44661,44667,44668,44672,44674,44732,44733,44737,44739,44904,44908,44910,44933,44935,45025,45888,
   45889,45893,45895,46060,46064,46066,46089,46091,46181,47084,47088,47090,47113,47115,47205,49473,
   49475,49565,49865],[3507,3517,3518,3525,3526,3833,3834,3841,3842,4139,4319,38494,38495,38502,
   38503,38800,38980,44904,44911,44912,44936,44937,45084,49476,49477,49624,49924],
 [3507,3517,3518,3525,3526,3833,3834,3841,3842,4139,4319,38494,38495,38502,38503,38800,38980,
   44904,44911,44912,44936,44937,45084,49476,49477,49624,49924],
 [3507,3517,3518,3527,3528,3833,3834,3843,3844,4139,4354,38494,38495,38504,38505,38800,38809,
   38810,38834,38835,39015,44904,44913,44914,44938,44939,45119,49478,49479,49659,49959],
 [3507,3517,3518,3527,3528,3833,3834,3843,3844,4139,4354,38494,38495,38504,38505,38800,38809,
   38810,38834,38835,39015,44904,44913,44914,44938,44939,45119,49478,49479,49659,49959],
 [3507,3517,3518,3529,3833,3834,3845,4139,38494,38495,38506,38800,44904,44915,44940,49480],
 [3507,3517,3518,3530,3833,3834,3846,4139,38494,38495,38507,38800,44904,44916,44941,49481],
 [3507,3517,3518,3531,3833,3834,3847,4139,38494,38495,38508,38800,44904,44917,44942,49482],
 [3507,3517,3518,3532,3833,3834,3848,4139,38494,38495,38509,38800,44904,44918,44943,49483],
 [3507,3517,3518,3533,3540,3833,3834,3849,3856,4139,38494,38495,38510,38517,38800,44904,44919,
   44926,44944,44951,45206,49484,49491,49746,50046],
 [3507,3517,3518,3534,3833,3834,3850,4139,38494,38495,38511,38800,44904,44920,44945,49485],
 [3507,3517,3518,3535,3833,3834,3851,4139,38494,38495,38512,38800,44904,44921,44946,49486],
 [3507,3517,3518,3536,3833,3834,3852,4139,38494,38495,38513,38800,44904,44922,44947,49487],
 [3507,3517,3518,3537,3539,3833,3834,3853,3855,4139,38494,38495,38514,38516,38800,44904,44923,
   44925,44948,44950,45235,49488,49490,49775,50075],
 [3507,3517,3518,3538,3833,3834,3854,4139,38494,38495,38515,38800,44904,44924,44949,49489],
 [3507,3517,3518,3537,3539,3833,3834,3853,3855,4139,38494,38495,38514,38516,38800,44904,44923,
   44925,44948,44950,45235,49488,49490,49775,50075],
 [3507,3517,3518,3533,3540,3833,3834,3849,3856,4139,38494,38495,38510,38517,38800,44904,44919,
   44926,44944,44951,45206,49484,49491,49746,50046],
 [3507,3517,3518,3541,3833,3834,3857,4139,38494,38495,38518,38800,44904,44927,44952,49492],
 [3507,3517,3518,3542,3833,3834,3858,4139,38494,38495,38519,38800,44904,44928,44953,49493],
 [3507,3517,3518,3543,3833,3834,3859,4139,38494,38495,38520,38800,44904,44929,44954,49494],
 [3507,3510,3512,3517,3518,3519,3523,3826,3828,3833,3834,3835,3839,3930,4139,4193,38487,38489,
   38494,38495,38496,38500,38591,38800,38854,44695,44700,44701,44702,44706,44763,44764,44765,44769,
   44904,44905,44909,44930,44934,44958,46447,46448,46449,46453,46588,46593,46614,46618,47549,47550,
   47554,47575,49470,49474],[23,31,44,1291,1296,1306,1309,1432,1625,1658,3502,3507,3508,3517,
   3518,3520,3633,3634,3824,3833,3834,3836,4139,38294,38295,38304,38485,38494,38495,38497,38800,
   41069,41078,41079,41081,41113,41114,41116,41384,41386,41411,44633,44634,44636,44904,44906,44931,
   45499,45501,45526,49471],[3507,3515,3517,3518,3521,3831,3833,3834,3837,4139,38492,38494,
   38495,38498,38800,44850,44851,44854,44904,44907,44932,48768,48771,48796,49472],
 [3503,3504,3507,3509,3511,3517,3518,3522,3524,3670,3673,3675,3677,3712,3714,3716,3825,3827,3833,
   3834,3838,3840,3896,4139,4260,38331,38334,38336,38338,38344,38345,38349,38351,38373,38375,
   38377,38383,38384,38388,38390,38486,38488,38494,38495,38499,38501,38557,38563,38564,38568,38570,
   38628,38629,38633,38635,38800,38804,38806,38829,38831,38921,41737,41739,41741,41747,41748,41752,
   41754,41850,41852,41858,41859,41863,41865,41921,41927,41928,41932,41934,41992,41993,41997,41999,
   42164,42168,42170,42193,42195,42285,42591,42593,42599,42600,42604,42606,42662,42668,42669,42673,
   42675,42733,42734,42738,42740,42905,42909,42911,42934,42936,43026,44661,44667,44668,44672,44674,
   44732,44733,44737,44739,44904,44908,44910,44933,44935,45025,45888,45889,45893,45895,46060,46064,
   46066,46089,46091,46181,47084,47088,47090,47113,47115,47205,49473,49475,49565,49865],
 [3507,3510,3512,3517,3518,3519,3523,3826,3828,3833,3834,3835,3839,3930,4139,4193,38487,38489,
   38494,38495,38496,38500,38591,38800,38854,44695,44700,44701,44702,44706,44763,44764,44765,44769,
   44904,44905,44909,44930,44934,44958,46447,46448,46449,46453,46588,46593,46614,46618,47549,47550,
   47554,47575,49470,49474],[3503,3504,3507,3509,3511,3517,3518,3522,3524,3670,3673,3675,3677,
   3712,3714,3716,3825,3827,3833,3834,3838,3840,3896,4139,4260,38331,38334,38336,38338,38344,
   38345,38349,38351,38373,38375,38377,38383,38384,38388,38390,38486,38488,38494,38495,38499,38501,
   38557,38563,38564,38568,38570,38628,38629,38633,38635,38800,38804,38806,38829,38831,38921,41737,
   41739,41741,41747,41748,41752,41754,41850,41852,41858,41859,41863,41865,41921,41927,41928,41932,
   41934,41992,41993,41997,41999,42164,42168,42170,42193,42195,42285,42591,42593,42599,42600,42604,
   42606,42662,42668,42669,42673,42675,42733,42734,42738,42740,42905,42909,42911,42934,42936,43026,
   44661,44667,44668,44672,44674,44732,44733,44737,44739,44904,44908,44910,44933,44935,45025,45888,
   45889,45893,45895,46060,46064,46066,46089,46091,46181,47084,47088,47090,47113,47115,47205,49473,
   49475,49565,49865],[3507,3517,3518,3525,3526,3833,3834,3841,3842,4139,4319,38494,38495,38502,
   38503,38800,38980,44904,44911,44912,44936,44937,45084,49476,49477,49624,49924],
 [3507,3517,3518,3525,3526,3833,3834,3841,3842,4139,4319,38494,38495,38502,38503,38800,38980,
   44904,44911,44912,44936,44937,45084,49476,49477,49624,49924],
 [3507,3517,3518,3527,3528,3833,3834,3843,3844,4139,4354,38494,38495,38504,38505,38800,38809,
   38810,38834,38835,39015,44904,44913,44914,44938,44939,45119,49478,49479,49659,49959],
 [3507,3517,3518,3527,3528,3833,3834,3843,3844,4139,4354,38494,38495,38504,38505,38800,38809,
   38810,38834,38835,39015,44904,44913,44914,44938,44939,45119,49478,49479,49659,49959],
 [3507,3517,3518,3529,3833,3834,3845,4139,38494,38495,38506,38800,44904,44915,44940,49480],
 [3507,3517,3518,3530,3833,3834,3846,4139,38494,38495,38507,38800,44904,44916,44941,49481],
 [3507,3517,3518,3531,3833,3834,3847,4139,38494,38495,38508,38800,44904,44917,44942,49482],
 [3507,3517,3518,3532,3833,3834,3848,4139,38494,38495,38509,38800,44904,44918,44943,49483],
 [3507,3517,3518,3533,3540,3833,3834,3849,3856,4139,38494,38495,38510,38517,38800,44904,44919,
   44926,44944,44951,45206,49484,49491,49746,50046],
 [3507,3517,3518,3534,3833,3834,3850,4139,38494,38495,38511,38800,44904,44920,44945,49485],
 [3507,3517,3518,3535,3833,3834,3851,4139,38494,38495,38512,38800,44904,44921,44946,49486],
 [3507,3517,3518,3536,3833,3834,3852,4139,38494,38495,38513,38800,44904,44922,44947,49487],
 [3507,3517,3518,3537,3539,3833,3834,3853,3855,4139,38494,38495,38514,38516,38800,44904,44923,
   44925,44948,44950,45235,49488,49490,49775,50075],
 [3507,3517,3518,3538,3833,3834,3854,4139,38494,38495,38515,38800,44904,44924,44949,49489],
 [3507,3517,3518,3537,3539,3833,3834,3853,3855,4139,38494,38495,38514,38516,38800,44904,44923,
   44925,44948,44950,45235,49488,49490,49775,50075],
 [3507,3517,3518,3533,3540,3833,3834,3849,3856,4139,38494,38495,38510,38517,38800,44904,44919,
   44926,44944,44951,45206,49484,49491,49746,50046],
 [3507,3517,3518,3541,3833,3834,3857,4139,38494,38495,38518,38800,44904,44927,44952,49492],
 [3507,3517,3518,3542,3833,3834,3858,4139,38494,38495,38519,38800,44904,44928,44953,49493],
 [3507,3517,3518,3543,3833,3834,3859,4139,38494,38495,38520,38800,44904,44929,44954,49494],
 [3756,4193,43685,48035],[4193],[3506,3507,3514,3519,3522,3523,3524,3787,3794,3830,3835,3838,
   3839,3840,4193,4260,38448,38455,38460,38463,38464,38465,38491,38496,38499,38500,38501,38720,
   38723,38724,38725,38853,38854,38855,38920,38921,38941,43965,44194,44197,44198,44199,44329,44394,
   44395,44415,44958,45025,48443,48445,48510,48511,50141,50855],[],
 [3506,3507,3514,3519,3522,3523,3524,3787,3794,3830,3835,3838,3839,3840,4193,4260,38448,38455,
   38460,38463,38464,38465,38491,38496,38499,38500,38501,38720,38723,38724,38725,38853,38854,38855,
   38920,38921,38941,43965,44194,44197,44198,44199,44329,44394,44395,44415,44958,45025,48443,48445,
   48510,48511,50141,50855],[3507,3519,3523,3525,3526,3835,3839,3841,3842,4193,4319,38496,38500,
   38502,38503,38854,38980,44958,44960,44961,45046,45047,45084,50200,51084],
 [3507,3519,3523,3525,3526,3835,3839,3841,3842,4193,4319,38496,38500,38502,38503,38854,38980,
   44958,44960,44961,45046,45047,45084,50200,51084],
 [3507,3519,3523,3527,3528,3835,3839,3843,3844,4193,4354,38496,38500,38504,38505,38854,38858,
   38859,38944,38945,39015,44958,45119,50235,51119],
 [3507,3519,3523,3527,3528,3835,3839,3843,3844,4193,4354,38496,38500,38504,38505,38854,38858,
   38859,38944,38945,39015,44958,45119,50235,51119],[4193],[4193],[4193],[4193],[4193],
 [4193],[4193],[4193],[4193],[4193],[4193],[4193],[4193],[4193],[4193],[],
 [3500,3501,3507,3520,3522,3524,3544,3550,3592,3836,3838,3840,4260,38205,38211,38224,38226,38228,
   38253,38266,38268,38270,38497,38499,38501,38876,38878,38921,39156,39169,39171,39173,39779,39781,
   39824,40640,40642,40685,45025,50394],[3756,4193,43685,48035],
 [3500,3501,3507,3520,3522,3524,3544,3550,3592,3836,3838,3840,4260,38205,38211,38224,38226,38228,
   38253,38266,38268,38270,38497,38499,38501,38876,38878,38921,39156,39169,39171,39173,39779,39781,
   39824,40640,40642,40685,45025,50394],[3507,3520,3525,3526,3836,3841,3842,4319,38497,38502,
   38503,38980,44983,44984,45084,50453],[3507,3520,3525,3526,3836,3841,3842,4319,38497,38502,
   38503,38980,44983,44984,45084,50453],[3507,3520,3527,3528,3836,3843,3844,4354,38497,38504,
   38505,38881,38882,39015,45119,50488],[3507,3520,3527,3528,3836,3843,3844,4354,38497,38504,
   38505,38881,38882,39015,45119,50488],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[3507,3516,3521,3522,3524,3832,3837,3838,3840,4260,38493,38498,38499,38501,
   38777,38778,38780,38898,38900,38921,45025,49217,49219,49240,50625],[4193],
 [3507,3516,3521,3522,3524,3832,3837,3838,3840,4260,38493,38498,38499,38501,38777,38778,38780,
   38898,38900,38921,45025,49217,49219,49240,50625],
 [3507,3521,3525,3526,3837,3841,3842,4319,38498,38502,38503,38980,45005,45006,45084,50684],
 [3507,3521,3525,3526,3837,3841,3842,4319,38498,38502,38503,38980,45005,45006,45084,50684],
 [3507,3521,3527,3528,3837,3843,3844,4354,38498,38504,38505,38903,38904,39015,45119,50719],
 [3507,3521,3527,3528,3837,3843,3844,4354,38498,38504,38505,38903,38904,39015,45119,50719],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [3506,3507,3514,3519,3522,3523,3524,3787,3794,3830,3835,3838,3839,3840,4193,4260,38448,38455,
   38460,38463,38464,38465,38491,38496,38499,38500,38501,38720,38723,38724,38725,38853,38854,38855,
   38920,38921,38941,43965,44194,44197,44198,44199,44329,44394,44395,44415,44958,45025,48443,48445,
   48510,48511,50141,50855],[3507,38921],
 [3507,3522,3524,3525,3526,3838,3840,3841,3842,4260,4319,38499,38501,38502,38503,38921,38922,
   38923,38961,38962,38980,45025,45026,45027,45065,45066,45084,50875,50876,50894,51255],
 [3507,3522,3524,3525,3526,3838,3840,3841,3842,4260,4319,38499,38501,38502,38503,38921,38922,
   38923,38961,38962,38980,45025,45026,45027,45065,45066,45084,50875,50876,50894,51255],
 [3507,3522,3524,3527,3528,3838,3840,3843,3844,4260,4354,38499,38501,38504,38505,38921,38924,
   38925,38963,38964,39015,45025,45119,50877,50878,50929,51290],
 [3507,3522,3524,3527,3528,3838,3840,3843,3844,4260,4354,38499,38501,38504,38505,38921,38924,
   38925,38963,38964,39015,45025,45119,50877,50878,50929,51290],
 [3507,3522,3524,3529,3838,3840,3845,4260,38499,38501,38506,38921,38926,38965,45025,50879],
 [3507,3522,3524,3530,3838,3840,3846,4260,38499,38501,38507,38921,38927,38966,45025,50880],
 [3507,3522,3524,3531,3838,3840,3847,4260,38499,38501,38508,38921,38928,38967,45025,50881],
 [3507,3522,3524,3532,3540,3838,3840,3848,3856,4260,38499,38501,38509,38517,38921,38929,38937,
   38968,38976,39092,45025,50882,50890,51006,51367],
 [3507,3522,3524,3533,3838,3840,3849,4260,38499,38501,38510,38921,38930,38969,45025,50883],
 [3507,3522,3524,3534,3838,3840,3850,4260,38499,38501,38511,38921,38931,38970,45025,50884],
 [3507,3522,3524,3535,3838,3840,3851,4260,38499,38501,38512,38921,38932,38971,45025,50885],
 [3507,3522,3524,3536,3838,3840,3852,4260,38499,38501,38513,38921,38933,38972,45025,50886],
 [3507,3522,3524,3537,3838,3840,3853,4260,38499,38501,38514,38921,38934,38973,45025,50887],
 [3507,3522,3524,3538,3539,3838,3840,3854,3855,4260,38499,38501,38515,38516,38921,38935,38936,
   38974,38975,39136,45025,50888,50889,51050,51411],
 [3507,3522,3524,3538,3539,3838,3840,3854,3855,4260,38499,38501,38515,38516,38921,38935,38936,
   38974,38975,39136,45025,50888,50889,51050,51411],
 [3507,3522,3524,3532,3540,3838,3840,3848,3856,4260,38499,38501,38509,38517,38921,38929,38937,
   38968,38976,39092,45025,50882,50890,51006,51367],
 [3507,3522,3524,3541,3838,3840,3857,4260,38499,38501,38518,38921,38938,38977,45025,50891],
 [3507,3522,3524,3542,3838,3840,3858,4260,38499,38501,38519,38921,38939,38978,45025,50892],
 [3507,3522,3524,3543,3838,3840,3859,4260,38499,38501,38520,38921,38940,38979,45025,50893],
 [3506,3507,3514,3519,3522,3523,3524,3787,3794,3830,3835,3838,3839,3840,4193,4260,38448,38455,
   38460,38463,38464,38465,38491,38496,38499,38500,38501,38720,38723,38724,38725,38853,38854,38855,
   38920,38921,38941,43965,44194,44197,44198,44199,44329,44394,44395,44415,44958,45025,48443,48445,
   48510,48511,50141,50855],[3507,3519,3523,3525,3526,3835,3839,3841,3842,4193,4319,38496,38500,
   38502,38503,38854,38980,44958,44960,44961,45046,45047,45084,50200,51084],
 [3507,3519,3523,3525,3526,3835,3839,3841,3842,4193,4319,38496,38500,38502,38503,38854,38980,
   44958,44960,44961,45046,45047,45084,50200,51084],
 [3507,3519,3523,3527,3528,3835,3839,3843,3844,4193,4354,38496,38500,38504,38505,38854,38858,
   38859,38944,38945,39015,44958,45119,50235,51119],
 [3507,3519,3523,3527,3528,3835,3839,3843,3844,4193,4354,38496,38500,38504,38505,38854,38858,
   38859,38944,38945,39015,44958,45119,50235,51119],[4193],[4193],[4193],[4193],[4193],
 [4193],[4193],[4193],[4193],[4193],[4193],[4193],[4193],[4193],[4193],
 [3507,3522,3524,3525,3526,3838,3840,3841,3842,4260,4319,38499,38501,38502,38503,38921,38922,
   38923,38961,38962,38980,45025,45026,45027,45065,45066,45084,50875,50876,50894,51255],
 [3507,3522,3524,3525,3526,3838,3840,3841,3842,4260,4319,38499,38501,38502,38503,38921,38922,
   38923,38961,38962,38980,45025,45026,45027,45065,45066,45084,50875,50876,50894,51255],
 [3507,3522,3524,3527,3528,3838,3840,3843,3844,4260,4354,38499,38501,38504,38505,38921,38924,
   38925,38963,38964,39015,45025,45119,50877,50878,50929,51290],
 [3507,3522,3524,3527,3528,3838,3840,3843,3844,4260,4354,38499,38501,38504,38505,38921,38924,
   38925,38963,38964,39015,45025,45119,50877,50878,50929,51290],
 [3507,3522,3524,3529,3838,3840,3845,4260,38499,38501,38506,38921,38926,38965,45025,50879],
 [3507,3522,3524,3530,3838,3840,3846,4260,38499,38501,38507,38921,38927,38966,45025,50880],
 [3507,3522,3524,3531,3838,3840,3847,4260,38499,38501,38508,38921,38928,38967,45025,50881],
 [3507,3522,3524,3532,3540,3838,3840,3848,3856,4260,38499,38501,38509,38517,38921,38929,38937,
   38968,38976,39092,45025,50882,50890,51006,51367],
 [3507,3522,3524,3533,3838,3840,3849,4260,38499,38501,38510,38921,38930,38969,45025,50883],
 [3507,3522,3524,3534,3838,3840,3850,4260,38499,38501,38511,38921,38931,38970,45025,50884],
 [3507,3522,3524,3535,3838,3840,3851,4260,38499,38501,38512,38921,38932,38971,45025,50885],
 [3507,3522,3524,3536,3838,3840,3852,4260,38499,38501,38513,38921,38933,38972,45025,50886],
 [3507,3522,3524,3537,3838,3840,3853,4260,38499,38501,38514,38921,38934,38973,45025,50887],
 [3507,3522,3524,3538,3539,3838,3840,3854,3855,4260,38499,38501,38515,38516,38921,38935,38936,
   38974,38975,39136,45025,50888,50889,51050,51411],
 [3507,3522,3524,3538,3539,3838,3840,3854,3855,4260,38499,38501,38515,38516,38921,38935,38936,
   38974,38975,39136,45025,50888,50889,51050,51411],
 [3507,3522,3524,3532,3540,3838,3840,3848,3856,4260,38499,38501,38509,38517,38921,38929,38937,
   38968,38976,39092,45025,50882,50890,51006,51367],
 [3507,3522,3524,3541,3838,3840,3857,4260,38499,38501,38518,38921,38938,38977,45025,50891],
 [3507,3522,3524,3542,3838,3840,3858,4260,38499,38501,38519,38921,38939,38978,45025,50892],
 [3507,3522,3524,3543,3838,3840,3859,4260,38499,38501,38520,38921,38940,38979,45025,50893],
 [3507,45084],[3503,3504,3507,3509,3511,3525,3526,3527,3528,3670,3673,3675,3677,3712,3714,3716,
   3825,3827,3841,3842,3843,3844,3896,4319,4354,38331,38334,38336,38338,38352,38353,38354,38355,
   38373,38375,38377,38391,38392,38393,38394,38486,38488,38502,38503,38504,38505,38557,38571,38572,
   38573,38574,38636,38637,38638,38639,38980,38981,38982,38998,38999,39015,41737,41739,41741,41755,
   41756,41757,41758,41850,41852,41866,41867,41868,41869,41921,41935,41936,41937,41938,42000,42001,
   42002,42003,42344,42345,42346,42362,42363,42379,42591,42593,42607,42608,42609,42610,42662,42676,
   42677,42678,42679,42741,42742,42743,42744,43085,43086,43087,43103,43104,43120,44661,44675,44676,
   44677,44678,44740,44741,44742,44743,45084,45085,45086,45102,45103,45119,45896,45897,45898,45899,
   46240,46241,46242,46258,46259,46275,47264,47265,47266,47282,47283,47299,51426,51427,51443,51579]
  ,[3503,3504,3507,3509,3511,3525,3526,3527,3528,3670,3673,3675,3677,3712,3714,3716,3825,3827,
   3841,3842,3843,3844,3896,4319,4354,38331,38334,38336,38338,38352,38353,38354,38355,38373,38375,
   38377,38391,38392,38393,38394,38486,38488,38502,38503,38504,38505,38557,38571,38572,38573,38574,
   38636,38637,38638,38639,38980,38981,38982,38998,38999,39015,41737,41739,41741,41755,41756,41757,
   41758,41850,41852,41866,41867,41868,41869,41921,41935,41936,41937,41938,42000,42001,42002,42003,
   42344,42345,42346,42362,42363,42379,42591,42593,42607,42608,42609,42610,42662,42676,42677,42678,
   42679,42741,42742,42743,42744,43085,43086,43087,43103,43104,43120,44661,44675,44676,44677,44678,
   44740,44741,44742,44743,45084,45085,45086,45102,45103,45119,45896,45897,45898,45899,46240,46241,
   46242,46258,46259,46275,47264,47265,47266,47282,47283,47299,51426,51427,51443,51579],
 [3507,3525,3526,3529,3841,3842,3845,4319,38502,38503,38506,38980,45084,45087,45104,51428],
 [3507,3525,3526,3530,3841,3842,3846,4319,38502,38503,38507,38980,45084,45088,45105,51429],
 [3507,3525,3526,3531,3841,3842,3847,4319,38502,38503,38508,38980,45084,45089,45106,51430],
 [3507,3525,3526,3532,3841,3842,3848,4319,38502,38503,38509,38980,45084,45090,45107,51431],
 [3507,3525,3526,3533,3841,3842,3849,4319,38502,38503,38510,38980,45084,45091,45108,51432],
 [3507,3525,3526,3534,3841,3842,3850,4319,38502,38503,38511,38980,45084,45092,45109,51433],
 [3507,3525,3526,3535,3841,3842,3851,4319,38502,38503,38512,38980,45084,45093,45110,51434],
 [3507,3525,3526,3536,3841,3842,3852,4319,38502,38503,38513,38980,45084,45094,45111,51435],
 [3507,3525,3526,3537,3841,3842,3853,4319,38502,38503,38514,38980,45084,45095,45112,51436],
 [3507,3525,3526,3538,3841,3842,3854,4319,38502,38503,38515,38980,45084,45096,45113,51437],
 [3507,3525,3526,3539,3841,3842,3855,4319,38502,38503,38516,38980,45084,45097,45114,51438],
 [3507,3525,3526,3540,3841,3842,3856,4319,38502,38503,38517,38980,45084,45098,45115,51439],
 [3507,3525,3526,3541,3841,3842,3857,4319,38502,38503,38518,38980,45084,45099,45116,51440],
 [3507,3525,3526,3542,3841,3842,3858,4319,38502,38503,38519,38980,45084,45100,45117,51441],
 [3507,3525,3526,3543,3841,3842,3859,4319,38502,38503,38520,38980,45084,45101,45118,51442],
 [3503,3504,3507,3509,3511,3525,3526,3527,3528,3670,3673,3675,3677,3712,3714,3716,3825,3827,3841,
   3842,3843,3844,3896,4319,4354,38331,38334,38336,38338,38352,38353,38354,38355,38373,38375,
   38377,38391,38392,38393,38394,38486,38488,38502,38503,38504,38505,38557,38571,38572,38573,38574,
   38636,38637,38638,38639,38980,38981,38982,38998,38999,39015,41737,41739,41741,41755,41756,41757,
   41758,41850,41852,41866,41867,41868,41869,41921,41935,41936,41937,41938,42000,42001,42002,42003,
   42344,42345,42346,42362,42363,42379,42591,42593,42607,42608,42609,42610,42662,42676,42677,42678,
   42679,42741,42742,42743,42744,43085,43086,43087,43103,43104,43120,44661,44675,44676,44677,44678,
   44740,44741,44742,44743,45084,45085,45086,45102,45103,45119,45896,45897,45898,45899,46240,46241,
   46242,46258,46259,46275,47264,47265,47266,47282,47283,47299,51426,51427,51443,51579],
 [3503,3504,3507,3509,3511,3525,3526,3527,3528,3670,3673,3675,3677,3712,3714,3716,3825,3827,3841,
   3842,3843,3844,3896,4319,4354,38331,38334,38336,38338,38352,38353,38354,38355,38373,38375,
   38377,38391,38392,38393,38394,38486,38488,38502,38503,38504,38505,38557,38571,38572,38573,38574,
   38636,38637,38638,38639,38980,38981,38982,38998,38999,39015,41737,41739,41741,41755,41756,41757,
   41758,41850,41852,41866,41867,41868,41869,41921,41935,41936,41937,41938,42000,42001,42002,42003,
   42344,42345,42346,42362,42363,42379,42591,42593,42607,42608,42609,42610,42662,42676,42677,42678,
   42679,42741,42742,42743,42744,43085,43086,43087,43103,43104,43120,44661,44675,44676,44677,44678,
   44740,44741,44742,44743,45084,45085,45086,45102,45103,45119,45896,45897,45898,45899,46240,46241,
   46242,46258,46259,46275,47264,47265,47266,47282,47283,47299,51426,51427,51443,51579],
 [3507,3525,3526,3529,3841,3842,3845,4319,38502,38503,38506,38980,45084,45087,45104,51428],
 [3507,3525,3526,3530,3841,3842,3846,4319,38502,38503,38507,38980,45084,45088,45105,51429],
 [3507,3525,3526,3531,3841,3842,3847,4319,38502,38503,38508,38980,45084,45089,45106,51430],
 [3507,3525,3526,3532,3841,3842,3848,4319,38502,38503,38509,38980,45084,45090,45107,51431],
 [3507,3525,3526,3533,3841,3842,3849,4319,38502,38503,38510,38980,45084,45091,45108,51432],
 [3507,3525,3526,3534,3841,3842,3850,4319,38502,38503,38511,38980,45084,45092,45109,51433],
 [3507,3525,3526,3535,3841,3842,3851,4319,38502,38503,38512,38980,45084,45093,45110,51434],
 [3507,3525,3526,3536,3841,3842,3852,4319,38502,38503,38513,38980,45084,45094,45111,51435],
 [3507,3525,3526,3537,3841,3842,3853,4319,38502,38503,38514,38980,45084,45095,45112,51436],
 [3507,3525,3526,3538,3841,3842,3854,4319,38502,38503,38515,38980,45084,45096,45113,51437],
 [3507,3525,3526,3539,3841,3842,3855,4319,38502,38503,38516,38980,45084,45097,45114,51438],
 [3507,3525,3526,3540,3841,3842,3856,4319,38502,38503,38517,38980,45084,45098,45115,51439],
 [3507,3525,3526,3541,3841,3842,3857,4319,38502,38503,38518,38980,45084,45099,45116,51440],
 [3507,3525,3526,3542,3841,3842,3858,4319,38502,38503,38519,38980,45084,45100,45117,51441],
 [3507,3525,3526,3543,3841,3842,3859,4319,38502,38503,38520,38980,45084,45101,45118,51442],
 [3507,39015],[3507,3527,3528,3529,3843,3844,3845,4354,38504,38505,38506,39015,39016,39031,45119,
   51715],[3507,3527,3528,3530,3843,3844,3846,4354,38504,38505,38507,39015,39017,39032,45119,
   51716],[3507,3527,3528,3531,3843,3844,3847,4354,38504,38505,38508,39015,39018,39033,45119,
   51717],[3507,3527,3528,3532,3843,3844,3848,4354,38504,38505,38509,39015,39019,39034,45119,
   51718],[3507,3527,3528,3533,3843,3844,3849,4354,38504,38505,38510,39015,39020,39035,45119,
   51719],[3507,3527,3528,3534,3843,3844,3850,4354,38504,38505,38511,39015,39021,39036,45119,
   51720],[3507,3527,3528,3535,3843,3844,3851,4354,38504,38505,38512,39015,39022,39037,45119,
   51721],[3507,3527,3528,3536,3843,3844,3852,4354,38504,38505,38513,39015,39023,39038,45119,
   51722],[3507,3527,3528,3537,3843,3844,3853,4354,38504,38505,38514,39015,39024,39039,45119,
   51723],[3507,3527,3528,3538,3843,3844,3854,4354,38504,38505,38515,39015,39025,39040,45119,
   51724],[3507,3527,3528,3539,3843,3844,3855,4354,38504,38505,38516,39015,39026,39041,45119,
   51725],[3507,3527,3528,3540,3843,3844,3856,4354,38504,38505,38517,39015,39027,39042,45119,
   51726],[3507,3527,3528,3541,3843,3844,3857,4354,38504,38505,38518,39015,39028,39043,45119,
   51727],[3507,3527,3528,3542,3843,3844,3858,4354,38504,38505,38519,39015,39029,39044,45119,
   51728],[3507,3527,3528,3543,3843,3844,3859,4354,38504,38505,38520,39015,39030,39045,45119,
   51729],[3507,3527,3528,3529,3843,3844,3845,4354,38504,38505,38506,39015,39016,39031,45119,
   51715],[3507,3527,3528,3530,3843,3844,3846,4354,38504,38505,38507,39015,39017,39032,45119,
   51716],[3507,3527,3528,3531,3843,3844,3847,4354,38504,38505,38508,39015,39018,39033,45119,
   51717],[3507,3527,3528,3532,3843,3844,3848,4354,38504,38505,38509,39015,39019,39034,45119,
   51718],[3507,3527,3528,3533,3843,3844,3849,4354,38504,38505,38510,39015,39020,39035,45119,
   51719],[3507,3527,3528,3534,3843,3844,3850,4354,38504,38505,38511,39015,39021,39036,45119,
   51720],[3507,3527,3528,3535,3843,3844,3851,4354,38504,38505,38512,39015,39022,39037,45119,
   51721],[3507,3527,3528,3536,3843,3844,3852,4354,38504,38505,38513,39015,39023,39038,45119,
   51722],[3507,3527,3528,3537,3843,3844,3853,4354,38504,38505,38514,39015,39024,39039,45119,
   51723],[3507,3527,3528,3538,3843,3844,3854,4354,38504,38505,38515,39015,39025,39040,45119,
   51724],[3507,3527,3528,3539,3843,3844,3855,4354,38504,38505,38516,39015,39026,39041,45119,
   51725],[3507,3527,3528,3540,3843,3844,3856,4354,38504,38505,38517,39015,39027,39042,45119,
   51726],[3507,3527,3528,3541,3843,3844,3857,4354,38504,38505,38518,39015,39028,39043,45119,
   51727],[3507,3527,3528,3542,3843,3844,3858,4354,38504,38505,38519,39015,39029,39044,45119,
   51728],[3507,3527,3528,3543,3843,3844,3859,4354,38504,38505,38520,39015,39030,39045,45119,
   51729],[3502,3507,3508,3529,3530,3633,3634,3824,3845,3846,38294,38295,38485,38506,38507,
   41069,41090,41091,41125,41126,41630,44645,44646,45150,45745],[3677,42004,42006,42411,47331],
 [],[],[],[],[],[],[],[],[],[],[],[],
 [3500,3501,3507,3530,3531,3544,3550,3592,3846,3847,38205,38211,38234,38235,38253,38276,38277,
   38507,38508,39060,39156,39179,39180,39963,40824],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [3677,42007,42008,42449,47369],[],[],[],[],[14514],[],
 [3507,3522,3524,3532,3540,3838,3840,3848,3856,4260,38499,38501,38509,38517,38921,38929,38937,
   38968,38976,39092,45025,50882,50890,51006,51367],[],[],[],[],[],[],[14523],[],
 [],[3507,3517,3518,3533,3540,3833,3834,3849,3856,4139,38494,38495,38510,38517,38800,44904,
   44919,44926,44944,44951,45206,49484,49491,49746,50046],[],[],[],
 [3500,3501,3507,3534,3535,3544,3550,3592,3850,3851,38205,38211,38238,38239,38253,38280,38281,
   38511,38512,39106,39156,39183,39184,40009,40870],
 [3502,3507,3508,3534,3536,3633,3634,3824,3850,3852,38294,38295,38485,38511,38513,41069,41095,
   41097,41130,41132,41691,44650,44652,45211,45806],[],[],[],[],[],[19848],[],
 [3677,42010,42011,42479,47399],[],[],[],[],[],[],[19857],[],[],[],[],
 [19862],[],[],[3677,42012,42013,42494,47414],
 [3507,3517,3518,3537,3539,3833,3834,3853,3855,4139,38494,38495,38514,38516,38800,44904,44923,
   44925,44948,44950,45235,49488,49490,49775,50075],[],[],[],[],
 [3507,3522,3524,3538,3539,3838,3840,3854,3855,4260,38499,38501,38515,38516,38921,38935,38936,
   38974,38975,39136,45025,50888,50889,51050,51411],[],[],[],[],[14565],[],[],[],
 [],[],[],[3502,3507,3508,3541,3542,3633,3634,3824,3857,3858,38294,38295,38485,38518,38519,
   41069,41102,41103,41137,41138,41732,44657,44658,45252,45847],[3677,42016,42018,42513,47433],
 [3500,3501,3507,3542,3543,3544,3550,3592,3858,3859,38205,38211,38246,38247,38253,38288,38289,
   38519,38520,39150,39156,39191,39192,40053,40914],[2279],[2279],[2279],[2279],[2279],
 [2279],[2279],[2279],[2279],[2279],[2279],[2279],[2279],[2279],[2279],[2279],
 [2279],[2279],[2279],[2279],[2279,3500,3501,3507,3517,3518,3544,3550,3592,3833,3834,4139,
   5645,5646,5662,5689,5695,5705,5706,5747,5978,5979,6284,7725,7726,7743,7769,7786,7817,7827,
   7828,8058,8059,8364,38205,38211,38221,38222,38253,38263,38264,38494,38495,38800,39156,39166,
   39167,39397,39398,39703,40258,40259,40564,44904],
 [2279,3500,3501,3507,3517,3518,3544,3550,3592,3833,3834,4139,5645,5646,5662,5689,5695,5705,5706,
   5747,5978,5979,6284,7725,7726,7743,7769,7786,7817,7827,7828,8058,8059,8364,38205,38211,38221,
   38222,38253,38263,38264,38494,38495,38800,39156,39166,39167,39397,39398,39703,40258,40259,40564,
   44904],[2279,3500,3501,3507,3517,3518,3544,3550,3592,3833,3834,4139,5645,5646,5662,5689,
   5695,5705,5706,5747,5978,5979,6284,7725,7726,7743,7769,7786,7817,7827,7828,8058,8059,8364,
   38205,38211,38221,38222,38253,38263,38264,38494,38495,38800,39156,39166,39167,39397,39398,39703,
   40258,40259,40564,44904],[23,26,31,32,41,42,44,89,90,91,92,93,94,107,156,158,163,166,
   173,177,1289,1290,1291,1292,1293,1296,1298,1300,1306,1309,1311,1313,1333,1334,1335,1336,1339,
   1340,1341,1343,1349,1350,1352,1354,1356,1376,1377,1378,1381,1382,1383,1385,1392,1394,1396,
   1398,1418,1419,1422,1423,1432,1433,1435,1459,1462,1463,1464,1466,1473,1475,1477,1479,1501,
   1502,1503,1505,1511,1512,1514,1516,1518,1613,1614,1616,1622,1623,1625,1627,1629,1649,1651,
   1657,1658,1660,1662,1664,1685,1691,1692,1694,1696,1698,1756,1757,1759,1761,1763,1928,1930,
   1932,1934,1955,1957,1959,2004,2006,2049,2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,
   2373,2383,2384,3500,3501,3502,3503,3504,3507,3508,3509,3511,3517,3518,3520,3522,3524,3544,
   3545,3546,3547,3550,3551,3552,3554,3560,3561,3563,3565,3567,3587,3588,3589,3592,3593,3594,
   3596,3602,3603,3605,3607,3609,3629,3630,3633,3634,3635,3637,3643,3644,3646,3648,3650,3670,
   3673,3674,3675,3677,3683,3684,3688,3690,3712,3713,3714,3716,3722,3723,3727,3729,3824,3825,
   3827,3833,3834,3836,3838,3840,3860,3862,3868,3869,3871,3873,3875,3896,3902,3903,3907,3909,
   3967,3968,3972,3974,4139,4141,4143,4145,4166,4168,4170,4215,4217,4260,4510,4511,4512,4518,
   4528,4529,5645,5646,5647,5648,5649,5652,5653,5654,5656,5662,5663,5665,5667,5669,5689,5690,
   5691,5692,5695,5696,5697,5699,5705,5706,5708,5710,5712,5732,5733,5734,5737,5738,5739,5741,
   5747,5748,5750,5752,5754,5774,5775,5778,5779,5780,5782,5788,5789,5791,5793,5795,5815,5818,
   5819,5820,5822,5828,5829,5831,5833,5835,5857,5861,5867,5868,5874,5969,5970,5972,5978,5979,
   5981,5983,5985,6005,6007,6013,6014,6016,6018,6020,6041,6047,6048,6050,6052,6054,6112,6113,
   6115,6117,6119,6284,6286,6288,6290,6311,6313,6315,6360,6362,6405,7725,7726,7727,7728,7729,
   7732,7733,7734,7736,7742,7743,7745,7747,7749,7769,7770,7771,7772,7775,7776,7777,7779,7785,
   7786,7788,7790,7792,7812,7813,7814,7817,7818,7819,7821,7827,7828,7830,7832,7834,7854,7855,
   7858,7859,7862,7868,7869,7871,7873,7875,7895,7898,7899,7900,7902,7908,7909,7911,7913,7915,
   7937,7938,7941,7947,7948,7950,7952,7954,8049,8050,8052,8058,8059,8061,8063,8065,8085,8087,
   8093,8094,8096,8098,8100,8121,8127,8128,8132,8192,8193,8195,8197,8199,8364,8366,8368,8370,
   8391,8393,8395,8440,8442,8485,38205,38206,38207,38208,38211,38212,38213,38215,38221,38222,
   38224,38226,38228,38248,38249,38250,38253,38254,38255,38257,38263,38264,38266,38268,38270,38290,
   38291,38294,38295,38296,38298,38304,38305,38307,38309,38311,38331,38334,38335,38336,38338,38344,
   38345,38347,38349,38351,38373,38374,38375,38377,38383,38384,38386,38388,38390,38485,38486,38488,
   38494,38495,38497,38499,38501,38521,38523,38529,38532,38534,38536,38557,38563,38564,38566,38568,
   38570,38628,38629,38631,38633,38635,38800,38802,38804,38806,38827,38829,38831,38876,38878,38921,
   39151,39152,39153,39156,39157,39158,39160,39166,39167,39169,39171,39173,39193,39194,39197,39198,
   39199,39201,39207,39208,39210,39212,39214,39234,39237,39238,39239,39241,39247,39248,39250,39252,
   39254,39276,39277,39278,39280,39286,39287,39289,39291,39293,39388,39389,39391,39397,39398,39400,
   39402,39424,39426,39432,39433,39435,39437,39439,39460,39466,39467,39469,39471,39473,39531,39534,
   39536,39538,39703,39705,39707,39709,39730,39732,39734,39779,39781,39824,40054,40055,40058,40059,
   40060,40062,40068,40069,40071,40073,40075,40095,40098,40099,40100,40102,40109,40111,40113,40115,
   40137,40138,40139,40141,40147,40148,40150,40152,40154,40249,40250,40252,40258,40259,40261,40265,
   40285,40287,40293,40294,40296,40298,40300,40321,40327,40328,40330,40332,40334,40392,40393,40395,
   40397,40399,40564,40566,40568,40570,40591,40593,40595,40640,40642,40685,40915,40918,40919,40920,
   40922,40928,40929,40931,40933,40935,40957,40958,40959,40961,40967,40968,40970,40972,40974,41069,
   41070,41072,41078,41079,41081,41083,41085,41105,41107,41113,41114,41116,41118,41120,41141,41147,
   41148,41150,41152,41212,41213,41215,41217,41219,41384,41386,41388,41390,41411,41413,41415,41460,
   41462,41505,41737,41738,41739,41741,41747,41748,41750,41752,41754,41849,41850,41852,41858,41859,
   41861,41863,41865,41885,41887,41893,41894,41896,41898,41900,41921,41927,41928,41930,41932,41934,
   41992,41993,41997,41999,42164,42166,42168,42170,42191,42193,42195,42240,42242,42285,42590,42591,
   42593,42599,42600,42602,42604,42606,42626,42628,42634,42635,42637,42641,42662,42668,42669,42673,
   42675,42733,42734,42736,42738,42740,42905,42907,42909,42911,42932,42934,42936,42981,42983,43026,
   44625,44627,44633,44634,44636,44638,44640,44661,44667,44668,44670,44672,44674,44732,44733,44735,
   44737,44739,44904,44906,44908,44910,44931,44933,44935,44980,44982,45025,45256,45262,45263,45265,
   45267,45269,45327,45328,45330,45332,45334,45499,45501,45503,45505,45526,45528,45530,45575,45577,
   45620,45888,45889,45891,45893,45895,46060,46062,46064,46066,46087,46089,46091,46136,46138,46181,
   47084,47086,47088,47090,47111,47113,47115,47160,47162,47205,49471,49473,49475,49520,49522,49565,
   49820,49822,49865,50394],[23,26,31,32,41,42,44,89,90,91,92,93,94,107,156,158,163,166,
   173,177,1289,1290,1291,1292,1293,1296,1298,1300,1306,1309,1311,1313,1333,1334,1335,1336,1339,
   1340,1341,1343,1349,1350,1352,1354,1356,1376,1377,1378,1381,1382,1383,1385,1392,1394,1396,
   1398,1418,1419,1422,1423,1432,1433,1435,1459,1462,1463,1464,1466,1473,1475,1477,1479,1501,
   1502,1503,1505,1511,1512,1514,1516,1518,1613,1614,1616,1622,1623,1625,1627,1629,1649,1651,
   1657,1658,1660,1662,1664,1685,1691,1692,1694,1696,1698,1756,1757,1759,1761,1763,1928,1930,
   1932,1934,1955,1957,1959,2004,2006,2049,2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,
   2373,2383,2384,3500,3501,3502,3503,3504,3507,3508,3509,3511,3517,3518,3520,3522,3524,3544,
   3545,3546,3547,3550,3551,3552,3554,3560,3561,3563,3565,3567,3587,3588,3589,3592,3593,3594,
   3596,3602,3603,3605,3607,3609,3629,3630,3633,3634,3635,3637,3643,3644,3646,3648,3650,3670,
   3673,3674,3675,3677,3683,3684,3688,3690,3712,3713,3714,3716,3722,3723,3727,3729,3824,3825,
   3827,3833,3834,3836,3838,3840,3860,3862,3868,3869,3871,3873,3875,3896,3902,3903,3907,3909,
   3967,3968,3972,3974,4139,4141,4143,4145,4166,4168,4170,4215,4217,4260,4510,4511,4512,4518,
   4528,4529,5645,5646,5647,5648,5649,5652,5653,5654,5656,5662,5663,5665,5667,5669,5689,5690,
   5691,5692,5695,5696,5697,5699,5705,5706,5708,5710,5712,5732,5733,5734,5737,5738,5739,5741,
   5747,5748,5750,5752,5754,5774,5775,5778,5779,5780,5782,5788,5789,5791,5793,5795,5815,5818,
   5819,5820,5822,5828,5829,5831,5833,5835,5857,5861,5867,5868,5874,5969,5970,5972,5978,5979,
   5981,5983,5985,6005,6007,6013,6014,6016,6018,6020,6041,6047,6048,6050,6052,6054,6112,6113,
   6115,6117,6119,6284,6286,6288,6290,6311,6313,6315,6360,6362,6405,7725,7726,7727,7728,7729,
   7732,7733,7734,7736,7742,7743,7745,7747,7749,7769,7770,7771,7772,7775,7776,7777,7779,7785,
   7786,7788,7790,7792,7812,7813,7814,7817,7818,7819,7821,7827,7828,7830,7832,7834,7854,7855,
   7858,7859,7862,7868,7869,7871,7873,7875,7895,7898,7899,7900,7902,7908,7909,7911,7913,7915,
   7937,7938,7941,7947,7948,7950,7952,7954,8049,8050,8052,8058,8059,8061,8063,8065,8085,8087,
   8093,8094,8096,8098,8100,8121,8127,8128,8132,8192,8193,8195,8197,8199,8364,8366,8368,8370,
   8391,8393,8395,8440,8442,8485,38205,38206,38207,38208,38211,38212,38213,38215,38221,38222,
   38224,38226,38228,38248,38249,38250,38253,38254,38255,38257,38263,38264,38266,38268,38270,38290,
   38291,38294,38295,38296,38298,38304,38305,38307,38309,38311,38331,38334,38335,38336,38338,38344,
   38345,38347,38349,38351,38373,38374,38375,38377,38383,38384,38386,38388,38390,38485,38486,38488,
   38494,38495,38497,38499,38501,38521,38523,38529,38532,38534,38536,38557,38563,38564,38566,38568,
   38570,38628,38629,38631,38633,38635,38800,38802,38804,38806,38827,38829,38831,38876,38878,38921,
   39151,39152,39153,39156,39157,39158,39160,39166,39167,39169,39171,39173,39193,39194,39197,39198,
   39199,39201,39207,39208,39210,39212,39214,39234,39237,39238,39239,39241,39247,39248,39250,39252,
   39254,39276,39277,39278,39280,39286,39287,39289,39291,39293,39388,39389,39391,39397,39398,39400,
   39402,39424,39426,39432,39433,39435,39437,39439,39460,39466,39467,39469,39471,39473,39531,39534,
   39536,39538,39703,39705,39707,39709,39730,39732,39734,39779,39781,39824,40054,40055,40058,40059,
   40060,40062,40068,40069,40071,40073,40075,40095,40098,40099,40100,40102,40109,40111,40113,40115,
   40137,40138,40139,40141,40147,40148,40150,40152,40154,40249,40250,40252,40258,40259,40261,40265,
   40285,40287,40293,40294,40296,40298,40300,40321,40327,40328,40330,40332,40334,40392,40393,40395,
   40397,40399,40564,40566,40568,40570,40591,40593,40595,40640,40642,40685,40915,40918,40919,40920,
   40922,40928,40929,40931,40933,40935,40957,40958,40959,40961,40967,40968,40970,40972,40974,41069,
   41070,41072,41078,41079,41081,41083,41085,41105,41107,41113,41114,41116,41118,41120,41141,41147,
   41148,41150,41152,41212,41213,41215,41217,41219,41384,41386,41388,41390,41411,41413,41415,41460,
   41462,41505,41737,41738,41739,41741,41747,41748,41750,41752,41754,41849,41850,41852,41858,41859,
   41861,41863,41865,41885,41887,41893,41894,41896,41898,41900,41921,41927,41928,41930,41932,41934,
   41992,41993,41997,41999,42164,42166,42168,42170,42191,42193,42195,42240,42242,42285,42590,42591,
   42593,42599,42600,42602,42604,42606,42626,42628,42634,42635,42637,42641,42662,42668,42669,42673,
   42675,42733,42734,42736,42738,42740,42905,42907,42909,42911,42932,42934,42936,42981,42983,43026,
   44625,44627,44633,44634,44636,44638,44640,44661,44667,44668,44670,44672,44674,44732,44733,44735,
   44737,44739,44904,44906,44908,44910,44931,44933,44935,44980,44982,45025,45256,45262,45263,45265,
   45267,45269,45327,45328,45330,45332,45334,45499,45501,45503,45505,45526,45528,45530,45575,45577,
   45620,45888,45889,45891,45893,45895,46060,46062,46064,46066,46087,46089,46091,46136,46138,46181,
   47084,47086,47088,47090,47111,47113,47115,47160,47162,47205,49471,49473,49475,49520,49522,49565,
   49820,49822,49865,50394],[2279,3714,3725,3905,5859,5870,6050,7939,7950,8130,42671],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,3501,3505,3506,3507,3513,
   3514,3517,3518,3527,3528,3544,3548,3549,3550,3556,3557,3560,3561,3570,3571,3590,3591,3592,
   3598,3599,3602,3603,3612,3613,3749,3750,3756,3757,3770,3771,3787,3793,3794,3829,3830,3833,
   3834,3843,3844,4025,4038,4039,4139,4354,4510,4511,4512,4518,4528,4529,5645,5646,5650,5651,
   5652,5658,5659,5662,5663,5672,5673,5689,5693,5694,5695,5701,5702,5705,5706,5715,5716,5735,
   5736,5737,5743,5744,5747,5748,5757,5758,5894,5902,5905,5916,5939,5942,5953,5978,5979,6170,
   6173,6183,6184,6202,6212,6213,6284,6293,6294,6499,7725,7726,7730,7731,7732,7738,7739,7742,
   7743,7752,7753,7769,7773,7774,7775,7781,7782,7785,7786,7795,7796,7815,7816,7817,7823,7824,
   7827,7828,7837,7838,7974,7986,7995,7996,8018,8019,8023,8032,8033,8058,8059,8250,8254,8263,
   8283,8292,8364,8398,8399,8579,38205,38209,38210,38211,38217,38218,38221,38222,38231,38232,
   38251,38252,38253,38259,38260,38263,38264,38273,38274,38410,38411,38417,38418,38431,38432,38448,
   38454,38455,38468,38469,38490,38491,38494,38495,38504,38505,38686,38699,38700,38728,38729,38800,
   39015,39154,39155,39156,39162,39163,39166,39167,39176,39177,39313,39320,39321,39324,39334,39335,
   39357,39358,39361,39371,39372,39397,39398,39589,39592,39602,39603,39621,39631,39632,39703,39712,
   39713,39918,40174,40181,40182,40186,40195,40196,40218,40219,40223,40232,40233,40258,40259,40450,
   40454,40463,40464,40483,40492,40493,40564,40598,40599,40779,43262,43263,43266,43276,43277,43298,
   43494,43507,43508,43536,43537,43643,43823,43965,44160,44173,44174,44202,44203,44308,44489,44904,
   45119,47903,47912,47913,47993,48199,48400,48605],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,3501,3505,3506,3507,3513,
   3514,3517,3518,3527,3528,3544,3548,3549,3550,3556,3557,3560,3561,3570,3571,3590,3591,3592,
   3598,3599,3602,3603,3612,3613,3749,3750,3756,3757,3770,3771,3787,3793,3794,3829,3830,3833,
   3834,3843,3844,4025,4038,4039,4139,4354,4510,4511,4512,4518,4528,4529,5645,5646,5650,5651,
   5652,5658,5659,5662,5663,5672,5673,5689,5693,5694,5695,5701,5702,5705,5706,5715,5716,5735,
   5736,5737,5743,5744,5747,5748,5757,5758,5894,5902,5905,5916,5939,5942,5953,5978,5979,6170,
   6173,6183,6184,6202,6212,6213,6284,6293,6294,6499,7725,7726,7730,7731,7732,7738,7739,7742,
   7743,7752,7753,7769,7773,7774,7775,7781,7782,7785,7786,7795,7796,7815,7816,7817,7823,7824,
   7827,7828,7837,7838,7974,7986,7995,7996,8018,8019,8023,8032,8033,8058,8059,8250,8254,8263,
   8283,8292,8364,8398,8399,8579,38205,38209,38210,38211,38217,38218,38221,38222,38231,38232,
   38251,38252,38253,38259,38260,38263,38264,38273,38274,38410,38411,38417,38418,38431,38432,38448,
   38454,38455,38468,38469,38490,38491,38494,38495,38504,38505,38686,38699,38700,38728,38729,38800,
   39015,39154,39155,39156,39162,39163,39166,39167,39176,39177,39313,39320,39321,39324,39334,39335,
   39357,39358,39361,39371,39372,39397,39398,39589,39592,39602,39603,39621,39631,39632,39703,39712,
   39713,39918,40174,40181,40182,40186,40195,40196,40218,40219,40223,40232,40233,40258,40259,40450,
   40454,40463,40464,40483,40492,40493,40564,40598,40599,40779,43262,43263,43266,43276,43277,43298,
   43494,43507,43508,43536,43537,43643,43823,43965,44160,44173,44174,44202,44203,44308,44489,44904,
   45119,47903,47912,47913,47993,48199,48400,48605],
 [2279,3500,3501,3507,3517,3518,3544,3550,3592,3833,3834,4139,5645,5646,5662,5689,5695,5705,5706,
   5747,5978,5979,6284,7725,7726,7743,7769,7786,7817,7827,7828,8058,8059,8364,38205,38211,38221,
   38222,38253,38263,38264,38494,38495,38800,39156,39166,39167,39397,39398,39703,40258,40259,40564,
   44904],[23,26,31,32,41,42,44,89,90,91,92,93,94,107,156,158,163,166,173,177,1289,1290,
   1291,1292,1293,1296,1298,1300,1306,1309,1311,1313,1333,1334,1335,1336,1339,1340,1341,1343,
   1349,1350,1352,1354,1356,1376,1377,1378,1381,1382,1383,1385,1392,1394,1396,1398,1418,1419,
   1422,1423,1432,1433,1435,1459,1462,1463,1464,1466,1473,1475,1477,1479,1501,1502,1503,1505,
   1511,1512,1514,1516,1518,1613,1614,1616,1622,1623,1625,1627,1629,1649,1651,1657,1658,1660,
   1662,1664,1685,1691,1692,1694,1696,1698,1756,1757,1759,1761,1763,1928,1930,1932,1934,1955,
   1957,1959,2004,2006,2049,2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,
   3500,3501,3502,3503,3504,3507,3508,3509,3511,3517,3518,3520,3522,3524,3544,3545,3546,3547,
   3550,3551,3552,3554,3560,3561,3563,3565,3567,3587,3588,3589,3592,3593,3594,3596,3602,3603,
   3605,3607,3609,3629,3630,3633,3634,3635,3637,3643,3644,3646,3648,3650,3670,3673,3674,3675,
   3677,3683,3684,3688,3690,3712,3713,3714,3716,3722,3723,3727,3729,3824,3825,3827,3833,3834,
   3836,3838,3840,3860,3862,3868,3869,3871,3873,3875,3896,3902,3903,3907,3909,3967,3968,3972,
   3974,4139,4141,4143,4145,4166,4168,4170,4215,4217,4260,4510,4511,4512,4518,4528,4529,5645,
   5646,5647,5648,5649,5652,5653,5654,5656,5662,5663,5665,5667,5669,5689,5690,5691,5692,5695,
   5696,5697,5699,5705,5706,5708,5710,5712,5732,5733,5734,5737,5738,5739,5741,5747,5748,5750,
   5752,5754,5774,5775,5778,5779,5780,5782,5788,5789,5791,5793,5795,5815,5818,5819,5820,5822,
   5828,5829,5831,5833,5835,5857,5861,5867,5868,5874,5969,5970,5972,5978,5979,5981,5983,5985,
   6005,6007,6013,6014,6016,6018,6020,6041,6047,6048,6050,6052,6054,6112,6113,6115,6117,6119,
   6284,6286,6288,6290,6311,6313,6315,6360,6362,6405,7725,7726,7727,7728,7729,7732,7733,7734,
   7736,7742,7743,7745,7747,7749,7769,7770,7771,7772,7775,7776,7777,7779,7785,7786,7788,7790,
   7792,7812,7813,7814,7817,7818,7819,7821,7827,7828,7830,7832,7834,7854,7855,7858,7859,7862,
   7868,7869,7871,7873,7875,7895,7898,7899,7900,7902,7908,7909,7911,7913,7915,7937,7938,7941,
   7947,7948,7950,7952,7954,8049,8050,8052,8058,8059,8061,8063,8065,8085,8087,8093,8094,8096,
   8098,8100,8121,8127,8128,8132,8192,8193,8195,8197,8199,8364,8366,8368,8370,8391,8393,8395,
   8440,8442,8485,38205,38206,38207,38208,38211,38212,38213,38215,38221,38222,38224,38226,38228,
   38248,38249,38250,38253,38254,38255,38257,38263,38264,38266,38268,38270,38290,38291,38294,38295,
   38296,38298,38304,38305,38307,38309,38311,38331,38334,38335,38336,38338,38344,38345,38347,38349,
   38351,38373,38374,38375,38377,38383,38384,38386,38388,38390,38485,38486,38488,38494,38495,38497,
   38499,38501,38521,38523,38529,38532,38534,38536,38557,38563,38564,38566,38568,38570,38628,38629,
   38631,38633,38635,38800,38802,38804,38806,38827,38829,38831,38876,38878,38921,39151,39152,39153,
   39156,39157,39158,39160,39166,39167,39169,39171,39173,39193,39194,39197,39198,39199,39201,39207,
   39208,39210,39212,39214,39234,39237,39238,39239,39241,39247,39248,39250,39252,39254,39276,39277,
   39278,39280,39286,39287,39289,39291,39293,39388,39389,39391,39397,39398,39400,39402,39424,39426,
   39432,39433,39435,39437,39439,39460,39466,39467,39469,39471,39473,39531,39534,39536,39538,39703,
   39705,39707,39709,39730,39732,39734,39779,39781,39824,40054,40055,40058,40059,40060,40062,40068,
   40069,40071,40073,40075,40095,40098,40099,40100,40102,40109,40111,40113,40115,40137,40138,40139,
   40141,40147,40148,40150,40152,40154,40249,40250,40252,40258,40259,40261,40265,40285,40287,40293,
   40294,40296,40298,40300,40321,40327,40328,40330,40332,40334,40392,40393,40395,40397,40399,40564,
   40566,40568,40570,40591,40593,40595,40640,40642,40685,40915,40918,40919,40920,40922,40928,40929,
   40931,40933,40935,40957,40958,40959,40961,40967,40968,40970,40972,40974,41069,41070,41072,41078,
   41079,41081,41083,41085,41105,41107,41113,41114,41116,41118,41120,41141,41147,41148,41150,41152,
   41212,41213,41215,41217,41219,41384,41386,41388,41390,41411,41413,41415,41460,41462,41505,41737,
   41738,41739,41741,41747,41748,41750,41752,41754,41849,41850,41852,41858,41859,41861,41863,41865,
   41885,41887,41893,41894,41896,41898,41900,41921,41927,41928,41930,41932,41934,41992,41993,41997,
   41999,42164,42166,42168,42170,42191,42193,42195,42240,42242,42285,42590,42591,42593,42599,42600,
   42602,42604,42606,42626,42628,42634,42635,42637,42641,42662,42668,42669,42673,42675,42733,42734,
   42736,42738,42740,42905,42907,42909,42911,42932,42934,42936,42981,42983,43026,44625,44627,44633,
   44634,44636,44638,44640,44661,44667,44668,44670,44672,44674,44732,44733,44735,44737,44739,44904,
   44906,44908,44910,44931,44933,44935,44980,44982,45025,45256,45262,45263,45265,45267,45269,45327,
   45328,45330,45332,45334,45499,45501,45503,45505,45526,45528,45530,45575,45577,45620,45888,45889,
   45891,45893,45895,46060,46062,46064,46066,46087,46089,46091,46136,46138,46181,47084,47086,47088,
   47090,47111,47113,47115,47160,47162,47205,49471,49473,49475,49520,49522,49565,49820,49822,49865,
   50394],[2279,3714,3725,3905,5859,5870,6050,7939,7950,8130,42671],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,3501,3507,3510,3512,3517,
   3518,3519,3523,3525,3526,3544,3550,3560,3561,3592,3602,3603,3826,3828,3833,3834,3835,3839,
   3841,3842,3930,3935,3936,3937,3941,3998,3999,4000,4004,4139,4140,4144,4146,4147,4165,4169,
   4171,4172,4193,4195,4196,4281,4282,4319,4510,4511,4512,4518,4528,4529,5645,5646,5652,5662,
   5663,5689,5695,5698,5700,5705,5706,5707,5711,5713,5714,5737,5747,5748,5971,5973,5978,5979,
   5980,5984,5986,5987,6075,6080,6081,6086,6089,6143,6144,6145,6149,6151,6152,6284,6285,6289,
   6291,6292,6310,6314,6316,6317,6340,6341,6427,6464,7725,7726,7732,7742,7743,7769,7775,7785,
   7786,7817,7820,7822,7827,7828,7829,7833,7835,7836,8051,8053,8058,8059,8060,8064,8066,8067,
   8155,8160,8161,8162,8166,8168,8169,8223,8224,8225,8231,8364,8365,8369,8371,8372,8390,8394,
   8396,8397,8420,8506,8507,8544,38205,38211,38221,38222,38253,38263,38264,38487,38489,38494,
   38495,38496,38500,38502,38503,38591,38800,38854,38980,39156,39166,39167,39397,39398,39499,39505,
   39562,39571,39703,39704,39708,39710,39711,39759,40258,40259,40361,40368,40424,40425,40564,40590,
   40594,40596,40597,40707,44695,44700,44701,44702,44706,44708,44709,44763,44764,44765,44769,44771,
   44772,44904,44905,44909,44911,44912,44930,44934,44936,44937,44958,44960,44961,45046,45047,45084,
   46447,46448,46449,46453,46455,46456,46588,46589,46593,46595,46596,46614,46618,46620,46621,46642,
   46644,46645,46730,46731,46768,47549,47550,47554,47556,47557,47575,47579,47581,47582,47603,47605,
   47606,47691,47692,47729,49470,49474,49476,49477,49498,49500,49501,49586,49587,49624,49798,49800,
   49801,49886,49887,49924,50162,50163,50200,51084],
 [23,26,31,32,41,42,44,89,90,91,92,93,94,107,156,158,163,166,173,177,1289,1290,1291,1292,
   1293,1296,1298,1300,1306,1309,1311,1313,1333,1334,1335,1336,1339,1340,1341,1343,1349,1350,
   1352,1354,1356,1376,1377,1378,1381,1382,1383,1385,1392,1394,1396,1398,1418,1419,1422,1423,
   1432,1433,1435,1459,1462,1463,1464,1466,1473,1475,1477,1479,1501,1502,1503,1505,1511,1512,
   1514,1516,1518,1613,1614,1616,1622,1623,1625,1627,1629,1649,1651,1657,1658,1660,1662,1664,
   1685,1691,1692,1694,1696,1698,1756,1757,1759,1761,1763,1928,1930,1932,1934,1955,1957,1959,
   2004,2006,2049,2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,3501,
   3502,3503,3504,3507,3508,3509,3511,3517,3518,3520,3522,3524,3544,3545,3546,3547,3550,3551,
   3552,3554,3560,3561,3563,3565,3567,3587,3588,3589,3592,3593,3594,3596,3602,3603,3605,3607,
   3609,3629,3630,3633,3634,3635,3637,3643,3644,3646,3648,3650,3670,3673,3674,3675,3677,3683,
   3684,3688,3690,3712,3713,3714,3716,3722,3723,3727,3729,3824,3825,3827,3833,3834,3836,3838,
   3840,3860,3862,3868,3869,3871,3873,3875,3896,3902,3903,3907,3909,3967,3968,3972,3974,4139,
   4141,4143,4145,4166,4168,4170,4215,4217,4260,4510,4511,4512,4518,4528,4529,5645,5646,5647,
   5648,5649,5652,5653,5654,5656,5662,5663,5665,5667,5669,5689,5690,5691,5692,5695,5696,5697,
   5699,5705,5706,5708,5710,5712,5732,5733,5734,5737,5738,5739,5741,5747,5748,5750,5752,5754,
   5774,5775,5778,5779,5780,5782,5788,5789,5791,5793,5795,5815,5818,5819,5820,5822,5828,5829,
   5831,5833,5835,5857,5861,5867,5868,5874,5969,5970,5972,5978,5979,5981,5983,5985,6005,6007,
   6013,6014,6016,6018,6020,6041,6047,6048,6050,6052,6054,6112,6113,6115,6117,6119,6284,6286,
   6288,6290,6311,6313,6315,6360,6362,6405,7725,7726,7727,7728,7729,7732,7733,7734,7736,7742,
   7743,7745,7747,7749,7769,7770,7771,7772,7775,7776,7777,7779,7785,7786,7788,7790,7792,7812,
   7813,7814,7817,7818,7819,7821,7827,7828,7830,7832,7834,7854,7855,7858,7859,7862,7868,7869,
   7871,7873,7875,7895,7898,7899,7900,7902,7908,7909,7911,7913,7915,7937,7938,7941,7947,7948,
   7950,7952,7954,8049,8050,8052,8058,8059,8061,8063,8065,8085,8087,8093,8094,8096,8098,8100,
   8121,8127,8128,8132,8192,8193,8195,8197,8199,8364,8366,8368,8370,8391,8393,8395,8440,8442,
   8485,38205,38206,38207,38208,38211,38212,38213,38215,38221,38222,38224,38226,38228,38248,38249,
   38250,38253,38254,38255,38257,38263,38264,38266,38268,38270,38290,38291,38294,38295,38296,38298,
   38304,38305,38307,38309,38311,38331,38334,38335,38336,38338,38344,38345,38347,38349,38351,38373,
   38374,38375,38377,38383,38384,38386,38388,38390,38485,38486,38488,38494,38495,38497,38499,38501,
   38521,38523,38529,38532,38534,38536,38557,38563,38564,38566,38568,38570,38628,38629,38631,38633,
   38635,38800,38802,38804,38806,38827,38829,38831,38876,38878,38921,39151,39152,39153,39156,39157,
   39158,39160,39166,39167,39169,39171,39173,39193,39194,39197,39198,39199,39201,39207,39208,39210,
   39212,39214,39234,39237,39238,39239,39241,39247,39248,39250,39252,39254,39276,39277,39278,39280,
   39286,39287,39289,39291,39293,39388,39389,39391,39397,39398,39400,39402,39424,39426,39432,39433,
   39435,39437,39439,39460,39466,39467,39469,39471,39473,39531,39534,39536,39538,39703,39705,39707,
   39709,39730,39732,39734,39779,39781,39824,40054,40055,40058,40059,40060,40062,40068,40069,40071,
   40073,40075,40095,40098,40099,40100,40102,40109,40111,40113,40115,40137,40138,40139,40141,40147,
   40148,40150,40152,40154,40249,40250,40252,40258,40259,40261,40265,40285,40287,40293,40294,40296,
   40298,40300,40321,40327,40328,40330,40332,40334,40392,40393,40395,40397,40399,40564,40566,40568,
   40570,40591,40593,40595,40640,40642,40685,40915,40918,40919,40920,40922,40928,40929,40931,40933,
   40935,40957,40958,40959,40961,40967,40968,40970,40972,40974,41069,41070,41072,41078,41079,41081,
   41083,41085,41105,41107,41113,41114,41116,41118,41120,41141,41147,41148,41150,41152,41212,41213,
   41215,41217,41219,41384,41386,41388,41390,41411,41413,41415,41460,41462,41505,41737,41738,41739,
   41741,41747,41748,41750,41752,41754,41849,41850,41852,41858,41859,41861,41863,41865,41885,41887,
   41893,41894,41896,41898,41900,41921,41927,41928,41930,41932,41934,41992,41993,41997,41999,42164,
   42166,42168,42170,42191,42193,42195,42240,42242,42285,42590,42591,42593,42599,42600,42602,42604,
   42606,42626,42628,42634,42635,42637,42641,42662,42668,42669,42673,42675,42733,42734,42736,42738,
   42740,42905,42907,42909,42911,42932,42934,42936,42981,42983,43026,44625,44627,44633,44634,44636,
   44638,44640,44661,44667,44668,44670,44672,44674,44732,44733,44735,44737,44739,44904,44906,44908,
   44910,44931,44933,44935,44980,44982,45025,45256,45262,45263,45265,45267,45269,45327,45328,45330,
   45332,45334,45499,45501,45503,45505,45526,45528,45530,45575,45577,45620,45888,45889,45891,45893,
   45895,46060,46062,46064,46066,46087,46089,46091,46136,46138,46181,47084,47086,47088,47090,47111,
   47113,47115,47160,47162,47205,49471,49473,49475,49520,49522,49565,49820,49822,49865,50394],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,3501,3507,3510,3512,3517,
   3518,3519,3523,3525,3526,3544,3550,3560,3561,3592,3602,3603,3826,3828,3833,3834,3835,3839,
   3841,3842,3930,3935,3936,3937,3941,3998,3999,4000,4004,4139,4140,4144,4146,4147,4165,4169,
   4171,4172,4193,4195,4196,4281,4282,4319,4510,4511,4512,4518,4528,4529,5645,5646,5652,5662,
   5663,5689,5695,5698,5700,5705,5706,5707,5711,5713,5714,5737,5747,5748,5971,5973,5978,5979,
   5980,5984,5986,5987,6075,6080,6081,6086,6089,6143,6144,6145,6149,6151,6152,6284,6285,6289,
   6291,6292,6310,6314,6316,6317,6340,6341,6427,6464,7725,7726,7732,7742,7743,7769,7775,7785,
   7786,7817,7820,7822,7827,7828,7829,7833,7835,7836,8051,8053,8058,8059,8060,8064,8066,8067,
   8155,8160,8161,8162,8166,8168,8169,8223,8224,8225,8231,8364,8365,8369,8371,8372,8390,8394,
   8396,8397,8420,8506,8507,8544,38205,38211,38221,38222,38253,38263,38264,38487,38489,38494,
   38495,38496,38500,38502,38503,38591,38800,38854,38980,39156,39166,39167,39397,39398,39499,39505,
   39562,39571,39703,39704,39708,39710,39711,39759,40258,40259,40361,40368,40424,40425,40564,40590,
   40594,40596,40597,40707,44695,44700,44701,44702,44706,44708,44709,44763,44764,44765,44769,44771,
   44772,44904,44905,44909,44911,44912,44930,44934,44936,44937,44958,44960,44961,45046,45047,45084,
   46447,46448,46449,46453,46455,46456,46588,46589,46593,46595,46596,46614,46618,46620,46621,46642,
   46644,46645,46730,46731,46768,47549,47550,47554,47556,47557,47575,47579,47581,47582,47603,47605,
   47606,47691,47692,47729,49470,49474,49476,49477,49498,49500,49501,49586,49587,49624,49798,49800,
   49801,49886,49887,49924,50162,50163,50200,51084],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,3501,3505,3506,3507,3513,
   3514,3517,3518,3527,3528,3544,3548,3549,3550,3556,3557,3560,3561,3570,3571,3590,3591,3592,
   3598,3599,3602,3603,3612,3613,3749,3750,3756,3757,3770,3771,3787,3793,3794,3829,3830,3833,
   3834,3843,3844,4025,4038,4039,4139,4354,4510,4511,4512,4518,4528,4529,5645,5646,5650,5651,
   5652,5658,5659,5662,5663,5672,5673,5689,5693,5694,5695,5701,5702,5705,5706,5715,5716,5735,
   5736,5737,5743,5744,5747,5748,5757,5758,5894,5902,5905,5916,5939,5942,5953,5978,5979,6170,
   6173,6183,6184,6202,6212,6213,6284,6293,6294,6499,7725,7726,7730,7731,7732,7738,7739,7742,
   7743,7752,7753,7769,7773,7774,7775,7781,7782,7785,7786,7795,7796,7815,7816,7817,7823,7824,
   7827,7828,7837,7838,7974,7986,7995,7996,8018,8019,8023,8032,8033,8058,8059,8250,8254,8263,
   8283,8292,8364,8398,8399,8579,38205,38209,38210,38211,38217,38218,38221,38222,38231,38232,
   38251,38252,38253,38259,38260,38263,38264,38273,38274,38410,38411,38417,38418,38431,38432,38448,
   38454,38455,38468,38469,38490,38491,38494,38495,38504,38505,38686,38699,38700,38728,38729,38800,
   39015,39154,39155,39156,39162,39163,39166,39167,39176,39177,39313,39320,39321,39324,39334,39335,
   39357,39358,39361,39371,39372,39397,39398,39589,39592,39602,39603,39621,39631,39632,39703,39712,
   39713,39918,40174,40181,40182,40186,40195,40196,40218,40219,40223,40232,40233,40258,40259,40450,
   40454,40463,40464,40483,40492,40493,40564,40598,40599,40779,43262,43263,43266,43276,43277,43298,
   43494,43507,43508,43536,43537,43643,43823,43965,44160,44173,44174,44202,44203,44308,44489,44904,
   45119,47903,47912,47913,47993,48199,48400,48605],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,3501,3505,3506,3507,3513,
   3514,3517,3518,3527,3528,3544,3548,3549,3550,3556,3557,3560,3561,3570,3571,3590,3591,3592,
   3598,3599,3602,3603,3612,3613,3749,3750,3756,3757,3770,3771,3787,3793,3794,3829,3830,3833,
   3834,3843,3844,4025,4038,4039,4139,4354,4510,4511,4512,4518,4528,4529,5645,5646,5650,5651,
   5652,5658,5659,5662,5663,5672,5673,5689,5693,5694,5695,5701,5702,5705,5706,5715,5716,5735,
   5736,5737,5743,5744,5747,5748,5757,5758,5894,5902,5905,5916,5939,5942,5953,5978,5979,6170,
   6173,6183,6184,6202,6212,6213,6284,6293,6294,6499,7725,7726,7730,7731,7732,7738,7739,7742,
   7743,7752,7753,7769,7773,7774,7775,7781,7782,7785,7786,7795,7796,7815,7816,7817,7823,7824,
   7827,7828,7837,7838,7974,7986,7995,7996,8018,8019,8023,8032,8033,8058,8059,8250,8254,8263,
   8283,8292,8364,8398,8399,8579,38205,38209,38210,38211,38217,38218,38221,38222,38231,38232,
   38251,38252,38253,38259,38260,38263,38264,38273,38274,38410,38411,38417,38418,38431,38432,38448,
   38454,38455,38468,38469,38490,38491,38494,38495,38504,38505,38686,38699,38700,38728,38729,38800,
   39015,39154,39155,39156,39162,39163,39166,39167,39176,39177,39313,39320,39321,39324,39334,39335,
   39357,39358,39361,39371,39372,39397,39398,39589,39592,39602,39603,39621,39631,39632,39703,39712,
   39713,39918,40174,40181,40182,40186,40195,40196,40218,40219,40223,40232,40233,40258,40259,40450,
   40454,40463,40464,40483,40492,40493,40564,40598,40599,40779,43262,43263,43266,43276,43277,43298,
   43494,43507,43508,43536,43537,43643,43823,43965,44160,44173,44174,44202,44203,44308,44489,44904,
   45119,47903,47912,47913,47993,48199,48400,48605],[2279],[2279],
 [2279,3500,3501,3507,3517,3518,3544,3550,3592,3833,3834,4139,5645,5646,5662,5689,5695,5705,5706,
   5747,5978,5979,6284,7725,7726,7743,7769,7786,7817,7827,7828,8058,8059,8364,38205,38211,38221,
   38222,38253,38263,38264,38494,38495,38800,39156,39166,39167,39397,39398,39703,40258,40259,40564,
   44904],[2279,3500,3501,3507,3517,3518,3544,3550,3592,3833,3834,4139,5645,5646,5662,5689,
   5695,5705,5706,5747,5978,5979,6284,7725,7726,7743,7769,7786,7817,7827,7828,8058,8059,8364,
   38205,38211,38221,38222,38253,38263,38264,38494,38495,38800,39156,39166,39167,39397,39398,39703,
   40258,40259,40564,44904],[2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,
   3500,3501,3507,3510,3512,3517,3518,3519,3523,3525,3526,3544,3550,3560,3561,3592,3602,3603,
   3826,3828,3833,3834,3835,3839,3841,3842,3930,3935,3936,3937,3941,3998,3999,4000,4004,4139,
   4140,4144,4146,4147,4165,4169,4171,4172,4193,4195,4196,4281,4282,4319,4510,4511,4512,4518,
   4528,4529,5645,5646,5652,5662,5663,5689,5695,5698,5700,5705,5706,5707,5711,5713,5714,5737,
   5747,5748,5971,5973,5978,5979,5980,5984,5986,5987,6075,6080,6081,6086,6089,6143,6144,6145,
   6149,6151,6152,6284,6285,6289,6291,6292,6310,6314,6316,6317,6340,6341,6427,6464,7725,7726,
   7732,7742,7743,7769,7775,7785,7786,7817,7820,7822,7827,7828,7829,7833,7835,7836,8051,8053,
   8058,8059,8060,8064,8066,8067,8155,8160,8161,8162,8166,8168,8169,8223,8224,8225,8231,8364,
   8365,8369,8371,8372,8390,8394,8396,8397,8420,8506,8507,8544,38205,38211,38221,38222,38253,
   38263,38264,38487,38489,38494,38495,38496,38500,38502,38503,38591,38800,38854,38980,39156,39166,
   39167,39397,39398,39499,39505,39562,39571,39703,39704,39708,39710,39711,39759,40258,40259,40361,
   40368,40424,40425,40564,40590,40594,40596,40597,40707,44695,44700,44701,44702,44706,44708,44709,
   44763,44764,44765,44769,44771,44772,44904,44905,44909,44911,44912,44930,44934,44936,44937,44958,
   44960,44961,45046,45047,45084,46447,46448,46449,46453,46455,46456,46588,46589,46593,46595,46596,
   46614,46618,46620,46621,46642,46644,46645,46730,46731,46768,47549,47550,47554,47556,47557,47575,
   47579,47581,47582,47603,47605,47606,47691,47692,47729,49470,49474,49476,49477,49498,49500,49501,
   49586,49587,49624,49798,49800,49801,49886,49887,49924,50162,50163,50200,51084],
 [2279,3714,3725,3905,5859,5870,6050,7939,7950,8130,42671],[2279],
 [23,26,31,32,41,42,44,89,90,91,92,93,94,107,156,158,163,166,173,177,1289,1290,1291,1292,
   1293,1296,1298,1300,1306,1309,1311,1313,1333,1334,1335,1336,1339,1340,1341,1343,1349,1350,
   1352,1354,1356,1376,1377,1378,1381,1382,1383,1385,1392,1394,1396,1398,1418,1419,1422,1423,
   1432,1433,1435,1459,1462,1463,1464,1466,1473,1475,1477,1479,1501,1502,1503,1505,1511,1512,
   1514,1516,1518,1613,1614,1616,1622,1623,1625,1627,1629,1649,1651,1657,1658,1660,1662,1664,
   1685,1691,1692,1694,1696,1698,1756,1757,1759,1761,1763,1928,1930,1932,1934,1955,1957,1959,
   2004,2006,2049,2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,3501,
   3502,3503,3504,3507,3508,3509,3511,3517,3518,3520,3522,3524,3544,3545,3546,3547,3550,3551,
   3552,3554,3560,3561,3563,3565,3567,3587,3588,3589,3592,3593,3594,3596,3602,3603,3605,3607,
   3609,3629,3630,3633,3634,3635,3637,3643,3644,3646,3648,3650,3670,3673,3674,3675,3677,3683,
   3684,3688,3690,3712,3713,3714,3716,3722,3723,3727,3729,3824,3825,3827,3833,3834,3836,3838,
   3840,3860,3862,3868,3869,3871,3873,3875,3896,3902,3903,3907,3909,3967,3968,3972,3974,4139,
   4141,4143,4145,4166,4168,4170,4215,4217,4260,4510,4511,4512,4518,4528,4529,5645,5646,5647,
   5648,5649,5652,5653,5654,5656,5662,5663,5665,5667,5669,5689,5690,5691,5692,5695,5696,5697,
   5699,5705,5706,5708,5710,5712,5732,5733,5734,5737,5738,5739,5741,5747,5748,5750,5752,5754,
   5774,5775,5778,5779,5780,5782,5788,5789,5791,5793,5795,5815,5818,5819,5820,5822,5828,5829,
   5831,5833,5835,5857,5861,5867,5868,5874,5969,5970,5972,5978,5979,5981,5983,5985,6005,6007,
   6013,6014,6016,6018,6020,6041,6047,6048,6050,6052,6054,6112,6113,6115,6117,6119,6284,6286,
   6288,6290,6311,6313,6315,6360,6362,6405,7725,7726,7727,7728,7729,7732,7733,7734,7736,7742,
   7743,7745,7747,7749,7769,7770,7771,7772,7775,7776,7777,7779,7785,7786,7788,7790,7792,7812,
   7813,7814,7817,7818,7819,7821,7827,7828,7830,7832,7834,7854,7855,7858,7859,7862,7868,7869,
   7871,7873,7875,7895,7898,7899,7900,7902,7908,7909,7911,7913,7915,7937,7938,7941,7947,7948,
   7950,7952,7954,8049,8050,8052,8058,8059,8061,8063,8065,8085,8087,8093,8094,8096,8098,8100,
   8121,8127,8128,8132,8192,8193,8195,8197,8199,8364,8366,8368,8370,8391,8393,8395,8440,8442,
   8485,38205,38206,38207,38208,38211,38212,38213,38215,38221,38222,38224,38226,38228,38248,38249,
   38250,38253,38254,38255,38257,38263,38264,38266,38268,38270,38290,38291,38294,38295,38296,38298,
   38304,38305,38307,38309,38311,38331,38334,38335,38336,38338,38344,38345,38347,38349,38351,38373,
   38374,38375,38377,38383,38384,38386,38388,38390,38485,38486,38488,38494,38495,38497,38499,38501,
   38521,38523,38529,38532,38534,38536,38557,38563,38564,38566,38568,38570,38628,38629,38631,38633,
   38635,38800,38802,38804,38806,38827,38829,38831,38876,38878,38921,39151,39152,39153,39156,39157,
   39158,39160,39166,39167,39169,39171,39173,39193,39194,39197,39198,39199,39201,39207,39208,39210,
   39212,39214,39234,39237,39238,39239,39241,39247,39248,39250,39252,39254,39276,39277,39278,39280,
   39286,39287,39289,39291,39293,39388,39389,39391,39397,39398,39400,39402,39424,39426,39432,39433,
   39435,39437,39439,39460,39466,39467,39469,39471,39473,39531,39534,39536,39538,39703,39705,39707,
   39709,39730,39732,39734,39779,39781,39824,40054,40055,40058,40059,40060,40062,40068,40069,40071,
   40073,40075,40095,40098,40099,40100,40102,40109,40111,40113,40115,40137,40138,40139,40141,40147,
   40148,40150,40152,40154,40249,40250,40252,40258,40259,40261,40265,40285,40287,40293,40294,40296,
   40298,40300,40321,40327,40328,40330,40332,40334,40392,40393,40395,40397,40399,40564,40566,40568,
   40570,40591,40593,40595,40640,40642,40685,40915,40918,40919,40920,40922,40928,40929,40931,40933,
   40935,40957,40958,40959,40961,40967,40968,40970,40972,40974,41069,41070,41072,41078,41079,41081,
   41083,41085,41105,41107,41113,41114,41116,41118,41120,41141,41147,41148,41150,41152,41212,41213,
   41215,41217,41219,41384,41386,41388,41390,41411,41413,41415,41460,41462,41505,41737,41738,41739,
   41741,41747,41748,41750,41752,41754,41849,41850,41852,41858,41859,41861,41863,41865,41885,41887,
   41893,41894,41896,41898,41900,41921,41927,41928,41930,41932,41934,41992,41993,41997,41999,42164,
   42166,42168,42170,42191,42193,42195,42240,42242,42285,42590,42591,42593,42599,42600,42602,42604,
   42606,42626,42628,42634,42635,42637,42641,42662,42668,42669,42673,42675,42733,42734,42736,42738,
   42740,42905,42907,42909,42911,42932,42934,42936,42981,42983,43026,44625,44627,44633,44634,44636,
   44638,44640,44661,44667,44668,44670,44672,44674,44732,44733,44735,44737,44739,44904,44906,44908,
   44910,44931,44933,44935,44980,44982,45025,45256,45262,45263,45265,45267,45269,45327,45328,45330,
   45332,45334,45499,45501,45503,45505,45526,45528,45530,45575,45577,45620,45888,45889,45891,45893,
   45895,46060,46062,46064,46066,46087,46089,46091,46136,46138,46181,47084,47086,47088,47090,47111,
   47113,47115,47160,47162,47205,49471,49473,49475,49520,49522,49565,49820,49822,49865,50394],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,3501,3507,3510,3512,3517,
   3518,3519,3523,3525,3526,3544,3550,3560,3561,3592,3602,3603,3826,3828,3833,3834,3835,3839,
   3841,3842,3930,3935,3936,3937,3941,3998,3999,4000,4004,4139,4140,4144,4146,4147,4165,4169,
   4171,4172,4193,4195,4196,4281,4282,4319,4510,4511,4512,4518,4528,4529,5645,5646,5652,5662,
   5663,5689,5695,5698,5700,5705,5706,5707,5711,5713,5714,5737,5747,5748,5971,5973,5978,5979,
   5980,5984,5986,5987,6075,6080,6081,6086,6089,6143,6144,6145,6149,6151,6152,6284,6285,6289,
   6291,6292,6310,6314,6316,6317,6340,6341,6427,6464,7725,7726,7732,7742,7743,7769,7775,7785,
   7786,7817,7820,7822,7827,7828,7829,7833,7835,7836,8051,8053,8058,8059,8060,8064,8066,8067,
   8155,8160,8161,8162,8166,8168,8169,8223,8224,8225,8231,8364,8365,8369,8371,8372,8390,8394,
   8396,8397,8420,8506,8507,8544,38205,38211,38221,38222,38253,38263,38264,38487,38489,38494,
   38495,38496,38500,38502,38503,38591,38800,38854,38980,39156,39166,39167,39397,39398,39499,39505,
   39562,39571,39703,39704,39708,39710,39711,39759,40258,40259,40361,40368,40424,40425,40564,40590,
   40594,40596,40597,40707,44695,44700,44701,44702,44706,44708,44709,44763,44764,44765,44769,44771,
   44772,44904,44905,44909,44911,44912,44930,44934,44936,44937,44958,44960,44961,45046,45047,45084,
   46447,46448,46449,46453,46455,46456,46588,46589,46593,46595,46596,46614,46618,46620,46621,46642,
   46644,46645,46730,46731,46768,47549,47550,47554,47556,47557,47575,47579,47581,47582,47603,47605,
   47606,47691,47692,47729,49470,49474,49476,49477,49498,49500,49501,49586,49587,49624,49798,49800,
   49801,49886,49887,49924,50162,50163,50200,51084],
 [23,26,31,32,41,42,44,89,90,91,92,93,94,107,156,158,163,166,173,177,1289,1290,1291,1292,
   1293,1296,1298,1300,1306,1309,1311,1313,1333,1334,1335,1336,1339,1340,1341,1343,1349,1350,
   1352,1354,1356,1376,1377,1378,1381,1382,1383,1385,1392,1394,1396,1398,1418,1419,1422,1423,
   1432,1433,1435,1459,1462,1463,1464,1466,1473,1475,1477,1479,1501,1502,1503,1505,1511,1512,
   1514,1516,1518,1613,1614,1616,1622,1623,1625,1627,1629,1649,1651,1657,1658,1660,1662,1664,
   1685,1691,1692,1694,1696,1698,1756,1757,1759,1761,1763,1928,1930,1932,1934,1955,1957,1959,
   2004,2006,2049,2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,3501,
   3502,3503,3504,3507,3508,3509,3511,3517,3518,3520,3522,3524,3544,3545,3546,3547,3550,3551,
   3552,3554,3560,3561,3563,3565,3567,3587,3588,3589,3592,3593,3594,3596,3602,3603,3605,3607,
   3609,3629,3630,3633,3634,3635,3637,3643,3644,3646,3648,3650,3670,3673,3674,3675,3677,3683,
   3684,3688,3690,3712,3713,3714,3716,3722,3723,3727,3729,3824,3825,3827,3833,3834,3836,3838,
   3840,3860,3862,3868,3869,3871,3873,3875,3896,3902,3903,3907,3909,3967,3968,3972,3974,4139,
   4141,4143,4145,4166,4168,4170,4215,4217,4260,4510,4511,4512,4518,4528,4529,5645,5646,5647,
   5648,5649,5652,5653,5654,5656,5662,5663,5665,5667,5669,5689,5690,5691,5692,5695,5696,5697,
   5699,5705,5706,5708,5710,5712,5732,5733,5734,5737,5738,5739,5741,5747,5748,5750,5752,5754,
   5774,5775,5778,5779,5780,5782,5788,5789,5791,5793,5795,5815,5818,5819,5820,5822,5828,5829,
   5831,5833,5835,5857,5861,5867,5868,5874,5969,5970,5972,5978,5979,5981,5983,5985,6005,6007,
   6013,6014,6016,6018,6020,6041,6047,6048,6050,6052,6054,6112,6113,6115,6117,6119,6284,6286,
   6288,6290,6311,6313,6315,6360,6362,6405,7725,7726,7727,7728,7729,7732,7733,7734,7736,7742,
   7743,7745,7747,7749,7769,7770,7771,7772,7775,7776,7777,7779,7785,7786,7788,7790,7792,7812,
   7813,7814,7817,7818,7819,7821,7827,7828,7830,7832,7834,7854,7855,7858,7859,7862,7868,7869,
   7871,7873,7875,7895,7898,7899,7900,7902,7908,7909,7911,7913,7915,7937,7938,7941,7947,7948,
   7950,7952,7954,8049,8050,8052,8058,8059,8061,8063,8065,8085,8087,8093,8094,8096,8098,8100,
   8121,8127,8128,8132,8192,8193,8195,8197,8199,8364,8366,8368,8370,8391,8393,8395,8440,8442,
   8485,38205,38206,38207,38208,38211,38212,38213,38215,38221,38222,38224,38226,38228,38248,38249,
   38250,38253,38254,38255,38257,38263,38264,38266,38268,38270,38290,38291,38294,38295,38296,38298,
   38304,38305,38307,38309,38311,38331,38334,38335,38336,38338,38344,38345,38347,38349,38351,38373,
   38374,38375,38377,38383,38384,38386,38388,38390,38485,38486,38488,38494,38495,38497,38499,38501,
   38521,38523,38529,38532,38534,38536,38557,38563,38564,38566,38568,38570,38628,38629,38631,38633,
   38635,38800,38802,38804,38806,38827,38829,38831,38876,38878,38921,39151,39152,39153,39156,39157,
   39158,39160,39166,39167,39169,39171,39173,39193,39194,39197,39198,39199,39201,39207,39208,39210,
   39212,39214,39234,39237,39238,39239,39241,39247,39248,39250,39252,39254,39276,39277,39278,39280,
   39286,39287,39289,39291,39293,39388,39389,39391,39397,39398,39400,39402,39424,39426,39432,39433,
   39435,39437,39439,39460,39466,39467,39469,39471,39473,39531,39534,39536,39538,39703,39705,39707,
   39709,39730,39732,39734,39779,39781,39824,40054,40055,40058,40059,40060,40062,40068,40069,40071,
   40073,40075,40095,40098,40099,40100,40102,40109,40111,40113,40115,40137,40138,40139,40141,40147,
   40148,40150,40152,40154,40249,40250,40252,40258,40259,40261,40265,40285,40287,40293,40294,40296,
   40298,40300,40321,40327,40328,40330,40332,40334,40392,40393,40395,40397,40399,40564,40566,40568,
   40570,40591,40593,40595,40640,40642,40685,40915,40918,40919,40920,40922,40928,40929,40931,40933,
   40935,40957,40958,40959,40961,40967,40968,40970,40972,40974,41069,41070,41072,41078,41079,41081,
   41083,41085,41105,41107,41113,41114,41116,41118,41120,41141,41147,41148,41150,41152,41212,41213,
   41215,41217,41219,41384,41386,41388,41390,41411,41413,41415,41460,41462,41505,41737,41738,41739,
   41741,41747,41748,41750,41752,41754,41849,41850,41852,41858,41859,41861,41863,41865,41885,41887,
   41893,41894,41896,41898,41900,41921,41927,41928,41930,41932,41934,41992,41993,41997,41999,42164,
   42166,42168,42170,42191,42193,42195,42240,42242,42285,42590,42591,42593,42599,42600,42602,42604,
   42606,42626,42628,42634,42635,42637,42641,42662,42668,42669,42673,42675,42733,42734,42736,42738,
   42740,42905,42907,42909,42911,42932,42934,42936,42981,42983,43026,44625,44627,44633,44634,44636,
   44638,44640,44661,44667,44668,44670,44672,44674,44732,44733,44735,44737,44739,44904,44906,44908,
   44910,44931,44933,44935,44980,44982,45025,45256,45262,45263,45265,45267,45269,45327,45328,45330,
   45332,45334,45499,45501,45503,45505,45526,45528,45530,45575,45577,45620,45888,45889,45891,45893,
   45895,46060,46062,46064,46066,46087,46089,46091,46136,46138,46181,47084,47086,47088,47090,47111,
   47113,47115,47160,47162,47205,49471,49473,49475,49520,49522,49565,49820,49822,49865,50394],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,3501,3507,3510,3512,3517,
   3518,3519,3523,3525,3526,3544,3550,3560,3561,3592,3602,3603,3826,3828,3833,3834,3835,3839,
   3841,3842,3930,3935,3936,3937,3941,3998,3999,4000,4004,4139,4140,4144,4146,4147,4165,4169,
   4171,4172,4193,4195,4196,4281,4282,4319,4510,4511,4512,4518,4528,4529,5645,5646,5652,5662,
   5663,5689,5695,5698,5700,5705,5706,5707,5711,5713,5714,5737,5747,5748,5971,5973,5978,5979,
   5980,5984,5986,5987,6075,6080,6081,6086,6089,6143,6144,6145,6149,6151,6152,6284,6285,6289,
   6291,6292,6310,6314,6316,6317,6340,6341,6427,6464,7725,7726,7732,7742,7743,7769,7775,7785,
   7786,7817,7820,7822,7827,7828,7829,7833,7835,7836,8051,8053,8058,8059,8060,8064,8066,8067,
   8155,8160,8161,8162,8166,8168,8169,8223,8224,8225,8231,8364,8365,8369,8371,8372,8390,8394,
   8396,8397,8420,8506,8507,8544,38205,38211,38221,38222,38253,38263,38264,38487,38489,38494,
   38495,38496,38500,38502,38503,38591,38800,38854,38980,39156,39166,39167,39397,39398,39499,39505,
   39562,39571,39703,39704,39708,39710,39711,39759,40258,40259,40361,40368,40424,40425,40564,40590,
   40594,40596,40597,40707,44695,44700,44701,44702,44706,44708,44709,44763,44764,44765,44769,44771,
   44772,44904,44905,44909,44911,44912,44930,44934,44936,44937,44958,44960,44961,45046,45047,45084,
   46447,46448,46449,46453,46455,46456,46588,46589,46593,46595,46596,46614,46618,46620,46621,46642,
   46644,46645,46730,46731,46768,47549,47550,47554,47556,47557,47575,47579,47581,47582,47603,47605,
   47606,47691,47692,47729,49470,49474,49476,49477,49498,49500,49501,49586,49587,49624,49798,49800,
   49801,49886,49887,49924,50162,50163,50200,51084],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,3501,3507,3510,3512,3517,
   3518,3519,3523,3525,3526,3544,3550,3560,3561,3592,3602,3603,3826,3828,3833,3834,3835,3839,
   3841,3842,3930,3935,3936,3937,3941,3998,3999,4000,4004,4139,4140,4144,4146,4147,4165,4169,
   4171,4172,4193,4195,4196,4281,4282,4319,4510,4511,4512,4518,4528,4529,5645,5646,5652,5662,
   5663,5689,5695,5698,5700,5705,5706,5707,5711,5713,5714,5737,5747,5748,5971,5973,5978,5979,
   5980,5984,5986,5987,6075,6080,6081,6086,6089,6143,6144,6145,6149,6151,6152,6284,6285,6289,
   6291,6292,6310,6314,6316,6317,6340,6341,6427,6464,7725,7726,7732,7742,7743,7769,7775,7785,
   7786,7817,7820,7822,7827,7828,7829,7833,7835,7836,8051,8053,8058,8059,8060,8064,8066,8067,
   8155,8160,8161,8162,8166,8168,8169,8223,8224,8225,8231,8364,8365,8369,8371,8372,8390,8394,
   8396,8397,8420,8506,8507,8544,38205,38211,38221,38222,38253,38263,38264,38487,38489,38494,
   38495,38496,38500,38502,38503,38591,38800,38854,38980,39156,39166,39167,39397,39398,39499,39505,
   39562,39571,39703,39704,39708,39710,39711,39759,40258,40259,40361,40368,40424,40425,40564,40590,
   40594,40596,40597,40707,44695,44700,44701,44702,44706,44708,44709,44763,44764,44765,44769,44771,
   44772,44904,44905,44909,44911,44912,44930,44934,44936,44937,44958,44960,44961,45046,45047,45084,
   46447,46448,46449,46453,46455,46456,46588,46589,46593,46595,46596,46614,46618,46620,46621,46642,
   46644,46645,46730,46731,46768,47549,47550,47554,47556,47557,47575,47579,47581,47582,47603,47605,
   47606,47691,47692,47729,49470,49474,49476,49477,49498,49500,49501,49586,49587,49624,49798,49800,
   49801,49886,49887,49924,50162,50163,50200,51084],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,3501,3505,3506,3507,3513,
   3514,3517,3518,3527,3528,3544,3548,3549,3550,3556,3557,3560,3561,3570,3571,3590,3591,3592,
   3598,3599,3602,3603,3612,3613,3749,3750,3756,3757,3770,3771,3787,3793,3794,3829,3830,3833,
   3834,3843,3844,4025,4038,4039,4139,4354,4510,4511,4512,4518,4528,4529,5645,5646,5650,5651,
   5652,5658,5659,5662,5663,5672,5673,5689,5693,5694,5695,5701,5702,5705,5706,5715,5716,5735,
   5736,5737,5743,5744,5747,5748,5757,5758,5894,5902,5905,5916,5939,5942,5953,5978,5979,6170,
   6173,6183,6184,6202,6212,6213,6284,6293,6294,6499,7725,7726,7730,7731,7732,7738,7739,7742,
   7743,7752,7753,7769,7773,7774,7775,7781,7782,7785,7786,7795,7796,7815,7816,7817,7823,7824,
   7827,7828,7837,7838,7974,7986,7995,7996,8018,8019,8023,8032,8033,8058,8059,8250,8254,8263,
   8283,8292,8364,8398,8399,8579,38205,38209,38210,38211,38217,38218,38221,38222,38231,38232,
   38251,38252,38253,38259,38260,38263,38264,38273,38274,38410,38411,38417,38418,38431,38432,38448,
   38454,38455,38468,38469,38490,38491,38494,38495,38504,38505,38686,38699,38700,38728,38729,38800,
   39015,39154,39155,39156,39162,39163,39166,39167,39176,39177,39313,39320,39321,39324,39334,39335,
   39357,39358,39361,39371,39372,39397,39398,39589,39592,39602,39603,39621,39631,39632,39703,39712,
   39713,39918,40174,40181,40182,40186,40195,40196,40218,40219,40223,40232,40233,40258,40259,40450,
   40454,40463,40464,40483,40492,40493,40564,40598,40599,40779,43262,43263,43266,43276,43277,43298,
   43494,43507,43508,43536,43537,43643,43823,43965,44160,44173,44174,44202,44203,44308,44489,44904,
   45119,47903,47912,47913,47993,48199,48400,48605],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,3501,3505,3506,3507,3513,
   3514,3517,3518,3527,3528,3544,3548,3549,3550,3556,3557,3560,3561,3570,3571,3590,3591,3592,
   3598,3599,3602,3603,3612,3613,3749,3750,3756,3757,3770,3771,3787,3793,3794,3829,3830,3833,
   3834,3843,3844,4025,4038,4039,4139,4354,4510,4511,4512,4518,4528,4529,5645,5646,5650,5651,
   5652,5658,5659,5662,5663,5672,5673,5689,5693,5694,5695,5701,5702,5705,5706,5715,5716,5735,
   5736,5737,5743,5744,5747,5748,5757,5758,5894,5902,5905,5916,5939,5942,5953,5978,5979,6170,
   6173,6183,6184,6202,6212,6213,6284,6293,6294,6499,7725,7726,7730,7731,7732,7738,7739,7742,
   7743,7752,7753,7769,7773,7774,7775,7781,7782,7785,7786,7795,7796,7815,7816,7817,7823,7824,
   7827,7828,7837,7838,7974,7986,7995,7996,8018,8019,8023,8032,8033,8058,8059,8250,8254,8263,
   8283,8292,8364,8398,8399,8579,38205,38209,38210,38211,38217,38218,38221,38222,38231,38232,
   38251,38252,38253,38259,38260,38263,38264,38273,38274,38410,38411,38417,38418,38431,38432,38448,
   38454,38455,38468,38469,38490,38491,38494,38495,38504,38505,38686,38699,38700,38728,38729,38800,
   39015,39154,39155,39156,39162,39163,39166,39167,39176,39177,39313,39320,39321,39324,39334,39335,
   39357,39358,39361,39371,39372,39397,39398,39589,39592,39602,39603,39621,39631,39632,39703,39712,
   39713,39918,40174,40181,40182,40186,40195,40196,40218,40219,40223,40232,40233,40258,40259,40450,
   40454,40463,40464,40483,40492,40493,40564,40598,40599,40779,43262,43263,43266,43276,43277,43298,
   43494,43507,43508,43536,43537,43643,43823,43965,44160,44173,44174,44202,44203,44308,44489,44904,
   45119,47903,47912,47913,47993,48199,48400,48605],[2279],[2279],[2279],[2279],[2279],
 [2279],[2279],[2279],[2279],[2279],[2279],[2279],[2279],[2279],[2279],[8715],
 [8715],[],[202,1336,9788,17232],[4995,5012,5690,5691,5705,5774,5788,5828,8962,22190,22191,
   22205,22274,39193,39207,39247,40928],[],
 [4995,5012,5690,5691,5705,5774,5788,5828,8962,22190,22191,22205,22274,39193,39207,39247,40928],
 [],[],[],[],[],[],[],[],[],[],[],[],
 [4575,4592,5645,5646,5662,5689,5705,5747,9741,9742,9785,9801,38205,38221,38263,39166],[5705],
 [4575,4592,5645,5646,5662,5689,5705,5747,9741,9742,9785,9801,38205,38221,38263,39166],
 [4575,4592,5690,5691,5705,5774,5788,5828,9786,9787,9801,9870,39193,39207,39247,40928],
 [4575,4592,5690,5691,5705,5774,5788,5828,9786,9787,9801,9870,39193,39207,39247,40928],
 [202,1336,9788,17232],[4575,4592,5693,5694,5705,5894,5905,5942,9789,9790,9801,9990,39313,39324,
   39361,43266],[4575,4592,5693,5694,5705,5894,5905,5942,9789,9790,9801,9990,39313,39324,39361,
   43266],[4575,4592,5695,5705,5706,5978,5979,6284,9801,10074,10075,10380,39397,39398,39703,
   44904],[6018,6050,10114,10146],[6018,6050,10114,10146],
 [4575,4592,5698,5705,5711,6080,6086,6289,9801,10176,10182,10385,39499,39505,39708,46593],
 [4575,4592,5699,5705,5712,6112,6119,6290,9801,10208,10215,10386,39531,39538,39709,47090],
 [6152],[6183,10279],[6213],[],[],[5705],
 [4575,4592,5695,5705,5706,5978,5979,6284,9801,10074,10075,10380,39397,39398,39703,44904],
 [6340,10436],[6018,6050,10114,10146],[],[6018,6050,10114,10146],
 [4575,4592,5698,5705,5711,6080,6086,6289,9801,10176,10182,10385,39499,39505,39708,46593],
 [4575,4592,5699,5705,5712,6112,6119,6290,9801,10208,10215,10386,39531,39538,39709,47090],
 [6340,10436],[6152],[6183,10279],[6213],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[8715],[],[10854],[10854],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[4638,4655,5645,5646,5662,5689,5705,5747,11694,11695,11738,11754,
   38205,38221,38263,39166],[5705],[4638,4655,5645,5646,5662,5689,5705,5747,11694,11695,11738,
   11754,38205,38221,38263,39166],[4638,4655,5690,5691,5705,5774,5788,5828,11739,11740,11754,
   11823,39193,39207,39247,40928],[4638,4655,5690,5691,5705,5774,5788,5828,11739,11740,11754,
   11823,39193,39207,39247,40928],[],[4638,4655,5693,5694,5705,5894,5905,5942,11742,11743,
   11754,11943,39313,39324,39361,43266],[4638,4655,5693,5694,5705,5894,5905,5942,11742,11743,
   11754,11943,39313,39324,39361,43266],[4638,4655,5695,5705,5706,5978,5979,6284,11754,12027,
   12028,12333,39397,39398,39703,44904],[6018,6050,12067,12099],[6018,6050,12067,12099],
 [4638,4655,5698,5705,5711,6080,6086,6289,11754,12129,12135,12338,39499,39505,39708,46593],
 [4638,4655,5699,5705,5712,6112,6119,6290,11754,12161,12168,12339,39531,39538,39709,47090],
 [6152],[6183,12232],[6213],[],[],[5705],
 [4638,4655,5695,5705,5706,5978,5979,6284,11754,12027,12028,12333,39397,39398,39703,44904],
 [6340,12389],[6018,6050,12067,12099],[],[6018,6050,12067,12099],
 [4638,4655,5698,5705,5711,6080,6086,6289,11754,12129,12135,12338,39499,39505,39708,46593],
 [4638,4655,5699,5705,5712,6112,6119,6290,11754,12161,12168,12339,39531,39538,39709,47090],
 [6340,12389],[6152],[6183,12232],[6213],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[4995,5012,5645,5646,5662,5689,5705,5747,12747,22145,22146,22189,
   22205,38205,38221,38263,39166],[328],[],
 [4995,5012,5645,5646,5662,5689,5705,5747,12747,22145,22146,22189,22205,38205,38221,38263,39166],
 [12979],[12979],[],[],[],[],[],[],[],[],[],[],
 [4700,4717,5645,5646,5662,5689,5705,5747,13585,13586,13629,13645,38205,38221,38263,39166],
 [5705],[4700,4717,5645,5646,5662,5689,5705,5747,13585,13586,13629,13645,38205,38221,38263,39166]
  ,[4700,4717,5690,5691,5705,5774,5788,5828,13630,13631,13645,13714,39193,39207,39247,40928],
 [4700,4717,5690,5691,5705,5774,5788,5828,13630,13631,13645,13714,39193,39207,39247,40928],[],
 [4700,4717,5693,5694,5705,5894,5905,5942,13633,13634,13645,13834,39313,39324,39361,43266],
 [4700,4717,5693,5694,5705,5894,5905,5942,13633,13634,13645,13834,39313,39324,39361,43266],
 [4700,4717,5695,5705,5706,5978,5979,6284,13645,13918,13919,14224,39397,39398,39703,44904],
 [6018,13958],[6050,13990],[4700,4717,5698,5705,5711,6080,6086,6289,13645,14020,14026,14229,
   39499,39505,39708,46593],[4700,4717,5699,5705,5712,6112,6119,6290,13645,14052,14059,14230,
   39531,39538,39709,47090],[6152],[6183,14123],[6213],[],[],[5705],
 [4700,4717,5695,5705,5706,5978,5979,6284,13645,13918,13919,14224,39397,39398,39703,44904],
 [6340,14280],[6050,13990],[],[6018,13958],
 [4700,4717,5698,5705,5711,6080,6086,6289,13645,14020,14026,14229,39499,39505,39708,46593],
 [4700,4717,5699,5705,5712,6112,6119,6290,13645,14052,14059,14230,39531,39538,39709,47090],
 [6340,14280],[6152],[6183,14123],[6213],[],[],[],[14514],[14523],[],[],[],
 [14523],[14514],[14565],[14565],[],[],[],[],[14635],[14635],[],[],[],[],
 [],[],[],[],[],[],[],[],[],
 [4761,4778,5645,5646,5662,5689,5705,5747,15415,15416,15459,15475,38205,38221,38263,39166],
 [5705],[4761,4778,5645,5646,5662,5689,5705,5747,15415,15416,15459,15475,38205,38221,38263,39166]
  ,[4761,4778,5690,5691,5705,5774,5788,5828,15460,15461,15475,15544,39193,39207,39247,40928],
 [4761,4778,5690,5691,5705,5774,5788,5828,15460,15461,15475,15544,39193,39207,39247,40928],[],
 [4761,4778,5693,5694,5705,5894,5905,5942,15463,15464,15475,15664,39313,39324,39361,43266],
 [4761,4778,5693,5694,5705,5894,5905,5942,15463,15464,15475,15664,39313,39324,39361,43266],
 [4761,4778,5695,5705,5706,5978,5979,6284,15475,15748,15749,16054,39397,39398,39703,44904],
 [6018,15788,15887],[6050,15820],[4761,4778,5698,5705,5711,6080,6086,6289,15475,15850,15856,
   16059,39499,39505,39708,46593],[4761,4778,5699,5705,5712,6112,6119,6290,15475,15882,15889,
   16060,39531,39538,39709,47090],[6152],[6183,15953],[6213],[],[],[5705],
 [4761,4778,5695,5705,5706,5978,5979,6284,15475,15748,15749,16054,39397,39398,39703,44904],
 [6340,16110],[6050,15820],[],[6018,15788,15887],
 [4761,4778,5698,5705,5711,6080,6086,6289,15475,15850,15856,16059,39499,39505,39708,46593],
 [4761,4778,5699,5705,5712,6112,6119,6290,15475,15882,15889,16060,39531,39538,39709,47090],
 [6340,16110],[6152],[6183,15953],[6213],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[10854],[],[4995,5012,5645,5646,5662,5689,5705,5747,12747,22145,
   22146,22189,22205,38205,38221,38263,39166],[],[],[],[],[],[],[],[],[],[],
 [],[],[4821,4838,5645,5646,5662,5689,5705,5747,17185,17186,17229,17245,38205,38221,38263,
   39166],[5705],[4821,4838,5645,5646,5662,5689,5705,5747,17185,17186,17229,17245,38205,38221,
   38263,39166],[4821,4838,5690,5691,5705,5774,5788,5828,17230,17231,17245,17314,39193,39207,
   39247,40928],[4821,4838,5690,5691,5705,5774,5788,5828,17230,17231,17245,17314,39193,39207,
   39247,40928],[202,1336,9788,17232],[4821,4838,5693,5694,5705,5894,5905,5942,17233,17234,
   17245,17434,39313,39324,39361,43266],[4821,4838,5693,5694,5705,5894,5905,5942,17233,17234,
   17245,17434,39313,39324,39361,43266],[4821,4838,5695,5705,5706,5978,5979,6284,17245,17518,
   17519,17824,39397,39398,39703,44904],[6018,6050,17558,17590],[6018,6050,17558,17590],
 [4821,4838,5698,5705,5711,6080,6086,6289,17245,17620,17626,17829,39499,39505,39708,46593],
 [4821,4838,5699,5705,5712,6112,6119,6290,17245,17652,17659,17830,39531,39538,39709,47090],
 [6152],[6183,17723],[6213],[],[],[5705],
 [4821,4838,5695,5705,5706,5978,5979,6284,17245,17518,17519,17824,39397,39398,39703,44904],
 [6340,17880],[6018,6050,17558,17590],[],[6018,6050,17558,17590],
 [4821,4838,5698,5705,5711,6080,6086,6289,17245,17620,17626,17829,39499,39505,39708,46593],
 [4821,4838,5699,5705,5712,6112,6119,6290,17245,17652,17659,17830,39531,39538,39709,47090],
 [6340,17880],[6152],[6183,17723],[6213],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[14635],[4995,5012,5690,5691,5705,5774,5788,5828,8962,22190,22191,
   22205,22274,39193,39207,39247,40928],[],[],[],[],[],[],[],[],[],[],[],
 [],[4880,4897,5645,5646,5662,5689,5705,5747,18896,18897,18940,18956,38205,38221,38263,39166],
 [5705],[4880,4897,5645,5646,5662,5689,5705,5747,18896,18897,18940,18956,38205,38221,38263,39166]
  ,[4880,4897,5690,5691,5705,5774,5788,5828,18941,18942,18956,19025,39193,39207,39247,40928],
 [4880,4897,5690,5691,5705,5774,5788,5828,18941,18942,18956,19025,39193,39207,39247,40928],[],
 [4880,4897,5693,5694,5705,5894,5905,5942,18944,18945,18956,19145,39313,39324,39361,43266],
 [4880,4897,5693,5694,5705,5894,5905,5942,18944,18945,18956,19145,39313,39324,39361,43266],
 [4880,4897,5695,5705,5706,5978,5979,6284,18956,19229,19230,19535,39397,39398,39703,44904],
 [6018,19269],[6050,19301],[4880,4897,5698,5705,5711,6080,6086,6289,18956,19331,19337,19540,
   39499,39505,39708,46593],[4880,4897,5699,5705,5712,6112,6119,6290,18956,19363,19370,19541,
   39531,39538,39709,47090],[6152],[6183,19434],[6213],[],[],[5705],
 [4880,4897,5695,5705,5706,5978,5979,6284,18956,19229,19230,19535,39397,39398,39703,44904],
 [6340,19591],[6050,19301],[],[6018,19269],
 [4880,4897,5698,5705,5711,6080,6086,6289,18956,19331,19337,19540,39499,39505,39708,46593],
 [4880,4897,5699,5705,5712,6112,6119,6290,18956,19363,19370,19541,39531,39538,39709,47090],
 [6340,19591],[6152],[6183,19434],[6213],[],[],[],[],[],[19848],[19857],
 [19862],[],[],[],[],[19862],[19848],[19857],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[4938,4955,5645,5646,5662,5689,5705,5747,20549,20550,20593,20609,38205,
   38221,38263,39166],[5705],[4938,4955,5645,5646,5662,5689,5705,5747,20549,20550,20593,20609,
   38205,38221,38263,39166],[4938,4955,5690,5691,5705,5774,5788,5828,20594,20595,20609,20678,
   39193,39207,39247,40928],[4938,4955,5690,5691,5705,5774,5788,5828,20594,20595,20609,20678,
   39193,39207,39247,40928],[],[4938,4955,5693,5694,5705,5894,5905,5942,20597,20598,20609,
   20798,39313,39324,39361,43266],[4938,4955,5693,5694,5705,5894,5905,5942,20597,20598,20609,
   20798,39313,39324,39361,43266],[4938,4955,5695,5705,5706,5978,5979,6284,20609,20882,20883,
   21188,39397,39398,39703,44904],[6018,20922],[6050,20954],
 [4938,4955,5698,5705,5711,6080,6086,6289,20609,20984,20990,21193,39499,39505,39708,46593],
 [4938,4955,5699,5705,5712,6112,6119,6290,20609,21016,21023,21194,39531,39538,39709,47090],
 [6152],[6183,21087],[6213],[],[],[5705],
 [4938,4955,5695,5705,5706,5978,5979,6284,20609,20882,20883,21188,39397,39398,39703,44904],
 [6340,21244],[6050,20954],[],[6018,20922],
 [4938,4955,5698,5705,5711,6080,6086,6289,20609,20984,20990,21193,39499,39505,39708,46593],
 [4938,4955,5699,5705,5712,6112,6119,6290,20609,21016,21023,21194,39531,39538,39709,47090],
 [6340,21244],[6152],[6183,21087],[6213],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [4995,5012,5645,5646,5662,5689,5705,5747,12747,22145,22146,22189,22205,38205,38221,38263,39166],
 [5705],[4995,5012,5645,5646,5662,5689,5705,5747,12747,22145,22146,22189,22205,38205,38221,38263,
   39166],[4995,5012,5690,5691,5705,5774,5788,5828,8962,22190,22191,22205,22274,39193,39207,
   39247,40928],[4995,5012,5690,5691,5705,5774,5788,5828,8962,22190,22191,22205,22274,39193,
   39207,39247,40928],[],[4995,5012,5693,5694,5705,5894,5905,5942,22193,22194,22205,22394,
   39313,39324,39361,43266],[4995,5012,5693,5694,5705,5894,5905,5942,22193,22194,22205,22394,
   39313,39324,39361,43266],[4995,5012,5695,5705,5706,5978,5979,6284,22205,22478,22479,22784,
   39397,39398,39703,44904],[6018,22518],[6050,22550],
 [4995,5012,5698,5705,5711,6080,6086,6289,22205,22580,22586,22789,39499,39505,39708,46593],
 [4995,5012,5699,5705,5712,6112,6119,6290,22205,22612,22619,22790,39531,39538,39709,47090],
 [6152],[6183,22683],[6213],[],[],[5705],
 [4995,5012,5695,5705,5706,5978,5979,6284,22205,22478,22479,22784,39397,39398,39703,44904],
 [6340,22840],[6050,22550],[],[6018,22518],
 [4995,5012,5698,5705,5711,6080,6086,6289,22205,22580,22586,22789,39499,39505,39708,46593],
 [4995,5012,5699,5705,5712,6112,6119,6290,22205,22612,22619,22790,39531,39538,39709,47090],
 [6340,22840],[6152],[6183,22683],[6213],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[12979],[],[],[],[],[],[],[],[],[],[],
 [5051,5068,5645,5646,5662,5689,5705,5747,23685,23686,23729,23745,38205,38221,38263,39166],
 [5705],[5051,5068,5645,5646,5662,5689,5705,5747,23685,23686,23729,23745,38205,38221,38263,39166]
  ,[5051,5068,5690,5691,5705,5774,5788,5828,23730,23731,23745,23814,39193,39207,39247,40928],
 [5051,5068,5690,5691,5705,5774,5788,5828,23730,23731,23745,23814,39193,39207,39247,40928],[],
 [5051,5068,5693,5694,5705,5894,5905,5942,23733,23734,23745,23934,39313,39324,39361,43266],
 [5051,5068,5693,5694,5705,5894,5905,5942,23733,23734,23745,23934,39313,39324,39361,43266],
 [5051,5068,5695,5705,5706,5978,5979,6284,23745,24018,24019,24324,39397,39398,39703,44904],
 [6018,24058],[6050,24090],[5051,5068,5698,5705,5711,6080,6086,6289,23745,24120,24126,24329,
   39499,39505,39708,46593],[5051,5068,5699,5705,5712,6112,6119,6290,23745,24152,24159,24330,
   39531,39538,39709,47090],[6152],[6183,24223],[6213],[],[],[5705],
 [5051,5068,5695,5705,5706,5978,5979,6284,23745,24018,24019,24324,39397,39398,39703,44904],
 [6340,24380],[6050,24090],[],[6018,24058],
 [5051,5068,5698,5705,5711,6080,6086,6289,23745,24120,24126,24329,39499,39505,39708,46593],
 [5051,5068,5699,5705,5712,6112,6119,6290,23745,24152,24159,24330,39531,39538,39709,47090],
 [6340,24380],[6152],[6183,24223],[6213],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [5106,5123,5645,5646,5662,5689,5705,5747,25170,25171,25214,25230,38205,38221,38263,39166],
 [5705],[5106,5123,5645,5646,5662,5689,5705,5747,25170,25171,25214,25230,38205,38221,38263,39166]
  ,[5106,5123,5690,5691,5705,5774,5788,5828,25215,25216,25230,25299,39193,39207,39247,40928],
 [5106,5123,5690,5691,5705,5774,5788,5828,25215,25216,25230,25299,39193,39207,39247,40928],[],
 [5106,5123,5693,5694,5705,5894,5905,5942,25218,25219,25230,25419,39313,39324,39361,43266],
 [5106,5123,5693,5694,5705,5894,5905,5942,25218,25219,25230,25419,39313,39324,39361,43266],
 [5106,5123,5695,5705,5706,5978,5979,6284,25230,25503,25504,25809,39397,39398,39703,44904],
 [6018,25543],[6050,25575],[5106,5123,5698,5705,5711,6080,6086,6289,25230,25605,25611,25814,
   39499,39505,39708,46593],[5106,5123,5699,5705,5712,6112,6119,6290,25230,25637,25644,25815,
   39531,39538,39709,47090],[6152],[6183,25708],[6213],[],[],[5705],
 [5106,5123,5695,5705,5706,5978,5979,6284,25230,25503,25504,25809,39397,39398,39703,44904],
 [6340,25865],[6050,25575],[],[6018,25543],
 [5106,5123,5698,5705,5711,6080,6086,6289,25230,25605,25611,25814,39499,39505,39708,46593],
 [5106,5123,5699,5705,5712,6112,6119,6290,25230,25637,25644,25815,39531,39538,39709,47090],
 [6340,25865],[6152],[6183,25708],[6213],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[26160],[26160],[],[26316],[26316],[],[],[26510],[26510],
 [5160,5177,5645,5646,5662,5689,5705,5747,26601,26602,26645,26661,38205,38221,38263,39166],
 [5705],[5160,5177,5645,5646,5662,5689,5705,5747,26601,26602,26645,26661,38205,38221,38263,39166]
  ,[5160,5177,5690,5691,5705,5774,5788,5828,26646,26647,26661,26730,39193,39207,39247,40928],
 [5160,5177,5690,5691,5705,5774,5788,5828,26646,26647,26661,26730,39193,39207,39247,40928],[],
 [5160,5177,5693,5694,5705,5894,5905,5942,26649,26650,26661,26850,39313,39324,39361,43266],
 [5160,5177,5693,5694,5705,5894,5905,5942,26649,26650,26661,26850,39313,39324,39361,43266],
 [5160,5177,5695,5705,5706,5978,5979,6284,26661,26934,26935,27240,39397,39398,39703,44904],
 [6018,26974],[6050,27006],[5160,5177,5698,5705,5711,6080,6086,6289,26661,27036,27042,27245,
   39499,39505,39708,46593],[5160,5177,5699,5705,5712,6112,6119,6290,26661,27068,27075,27246,
   39531,39538,39709,47090],[6152],[6183,27139],[6213],[],[],[5705],
 [5160,5177,5695,5705,5706,5978,5979,6284,26661,26934,26935,27240,39397,39398,39703,44904],
 [6340,27296],[6050,27006],[],[6018,26974],
 [5160,5177,5698,5705,5711,6080,6086,6289,26661,27036,27042,27245,39499,39505,39708,46593],
 [5160,5177,5699,5705,5712,6112,6119,6290,26661,27068,27075,27246,39531,39538,39709,47090],
 [6340,27296],[6152],[6183,27139],[6213],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[26160],[27643],[27643],[],[],[27841],[27841],[],
 [5213,5230,5645,5646,5662,5689,5705,5747,27979,27980,28023,28039,38205,38221,38263,39166],
 [5705],[5213,5230,5645,5646,5662,5689,5705,5747,27979,27980,28023,28039,38205,38221,38263,39166]
  ,[5213,5230,5690,5691,5705,5774,5788,5828,28024,28025,28039,28108,39193,39207,39247,40928],
 [5213,5230,5690,5691,5705,5774,5788,5828,28024,28025,28039,28108,39193,39207,39247,40928],[],
 [5213,5230,5693,5694,5705,5894,5905,5942,28027,28028,28039,28228,39313,39324,39361,43266],
 [5213,5230,5693,5694,5705,5894,5905,5942,28027,28028,28039,28228,39313,39324,39361,43266],
 [5213,5230,5695,5705,5706,5978,5979,6284,28039,28312,28313,28618,39397,39398,39703,44904],
 [6018,28352],[6050,28384],[5213,5230,5698,5705,5711,6080,6086,6289,28039,28414,28420,28623,
   39499,39505,39708,46593],[5213,5230,5699,5705,5712,6112,6119,6290,28039,28446,28453,28624,
   39531,39538,39709,47090],[6152],[6183,28517],[6213],[],[],[5705],
 [5213,5230,5695,5705,5706,5978,5979,6284,28039,28312,28313,28618,39397,39398,39703,44904],
 [6340,28674],[6050,28384],[],[6018,28352],
 [5213,5230,5698,5705,5711,6080,6086,6289,28039,28414,28420,28623,39499,39505,39708,46593],
 [5213,5230,5699,5705,5712,6112,6119,6290,28039,28446,28453,28624,39531,39538,39709,47090],
 [6340,28674],[6152],[6183,28517],[6213],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[28970],[],[28970],[],[29168],[],[29168],
 [5265,5282,5645,5646,5662,5689,5705,5747,29305,29306,29349,29365,38205,38221,38263,39166],
 [5705],[5265,5282,5645,5646,5662,5689,5705,5747,29305,29306,29349,29365,38205,38221,38263,39166]
  ,[5265,5282,5690,5691,5705,5774,5788,5828,29350,29351,29365,29434,39193,39207,39247,40928],
 [5265,5282,5690,5691,5705,5774,5788,5828,29350,29351,29365,29434,39193,39207,39247,40928],[],
 [5265,5282,5693,5694,5705,5894,5905,5942,29353,29354,29365,29554,39313,39324,39361,43266],
 [5265,5282,5693,5694,5705,5894,5905,5942,29353,29354,29365,29554,39313,39324,39361,43266],
 [5265,5282,5695,5705,5706,5978,5979,6284,29365,29638,29639,29944,39397,39398,39703,44904],
 [6018,29678],[6050,29710],[5265,5282,5698,5705,5711,6080,6086,6289,29365,29740,29746,29949,
   39499,39505,39708,46593],[5265,5282,5699,5705,5712,6112,6119,6290,29365,29772,29779,29950,
   39531,39538,39709,47090],[6152],[6183,29843],[6213],[],[],[5705],
 [5265,5282,5695,5705,5706,5978,5979,6284,29365,29638,29639,29944,39397,39398,39703,44904],
 [6340,30000],[6050,29710],[],[6018,29678],
 [5265,5282,5698,5705,5711,6080,6086,6289,29365,29740,29746,29949,39499,39505,39708,46593],
 [5265,5282,5699,5705,5712,6112,6119,6290,29365,29772,29779,29950,39531,39538,39709,47090],
 [6340,30000],[6152],[6183,29843],[6213],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[27643],[28970],[30394],[30394],[],[],
 [5316,5333,5645,5646,5662,5689,5705,5747,30580,30581,30624,30640,38205,38221,38263,39166],
 [5705],[5316,5333,5645,5646,5662,5689,5705,5747,30580,30581,30624,30640,38205,38221,38263,39166]
  ,[5316,5333,5690,5691,5705,5774,5788,5828,30625,30626,30640,30709,39193,39207,39247,40928],
 [5316,5333,5690,5691,5705,5774,5788,5828,30625,30626,30640,30709,39193,39207,39247,40928],[],
 [5316,5333,5693,5694,5705,5894,5905,5942,30628,30629,30640,30829,39313,39324,39361,43266],
 [5316,5333,5693,5694,5705,5894,5905,5942,30628,30629,30640,30829,39313,39324,39361,43266],
 [5316,5333,5695,5705,5706,5978,5979,6284,30640,30913,30914,31219,39397,39398,39703,44904],
 [6018,30953],[6050,30985],[5316,5333,5698,5705,5711,6080,6086,6289,30640,31015,31021,31224,
   39499,39505,39708,46593],[5316,5333,5699,5705,5712,6112,6119,6290,30640,31047,31054,31225,
   39531,39538,39709,47090],[6152],[6183,31118],[6213],[],[],[5705],
 [5316,5333,5695,5705,5706,5978,5979,6284,30640,30913,30914,31219,39397,39398,39703,44904],
 [6340,31275],[6050,30985],[],[6018,30953],
 [5316,5333,5698,5705,5711,6080,6086,6289,30640,31015,31021,31224,39499,39505,39708,46593],
 [5316,5333,5699,5705,5712,6112,6119,6290,30640,31047,31054,31225,39531,39538,39709,47090],
 [6340,31275],[6152],[6183,31118],[6213],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[26316],[31620],[],[31620],[],
 [5366,5383,5645,5646,5662,5689,5705,5747,31805,31806,31849,31865,38205,38221,38263,39166],
 [5705],[5366,5383,5645,5646,5662,5689,5705,5747,31805,31806,31849,31865,38205,38221,38263,39166]
  ,[5366,5383,5690,5691,5705,5774,5788,5828,31850,31851,31865,31934,39193,39207,39247,40928],
 [5366,5383,5690,5691,5705,5774,5788,5828,31850,31851,31865,31934,39193,39207,39247,40928],[],
 [5366,5383,5693,5694,5705,5894,5905,5942,31853,31854,31865,32054,39313,39324,39361,43266],
 [5366,5383,5693,5694,5705,5894,5905,5942,31853,31854,31865,32054,39313,39324,39361,43266],
 [5366,5383,5695,5705,5706,5978,5979,6284,31865,32138,32139,32444,39397,39398,39703,44904],
 [6018,32178],[6050,32210],[5366,5383,5698,5705,5711,6080,6086,6289,31865,32240,32246,32449,
   39499,39505,39708,46593],[5366,5383,5699,5705,5712,6112,6119,6290,31865,32272,32279,32450,
   39531,39538,39709,47090],[6152],[6183,32343],[6213],[],[],[5705],
 [5366,5383,5695,5705,5706,5978,5979,6284,31865,32138,32139,32444,39397,39398,39703,44904],
 [6340,32500],[6050,32210],[],[6018,32178],
 [5366,5383,5698,5705,5711,6080,6086,6289,31865,32240,32246,32449,39499,39505,39708,46593],
 [5366,5383,5699,5705,5712,6112,6119,6290,31865,32272,32279,32450,39531,39538,39709,47090],
 [6340,32500],[6152],[6183,32343],[6213],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[32797],[],[],[32797],
 [5415,5432,5645,5646,5662,5689,5705,5747,32981,32982,33025,33041,38205,38221,38263,39166],
 [5705],[5415,5432,5645,5646,5662,5689,5705,5747,32981,32982,33025,33041,38205,38221,38263,39166]
  ,[5415,5432,5690,5691,5705,5774,5788,5828,33026,33027,33041,33110,39193,39207,39247,40928],
 [5415,5432,5690,5691,5705,5774,5788,5828,33026,33027,33041,33110,39193,39207,39247,40928],[],
 [5415,5432,5693,5694,5705,5894,5905,5942,33029,33030,33041,33230,39313,39324,39361,43266],
 [5415,5432,5693,5694,5705,5894,5905,5942,33029,33030,33041,33230,39313,39324,39361,43266],
 [5415,5432,5695,5705,5706,5978,5979,6284,33041,33314,33315,33620,39397,39398,39703,44904],
 [6018,33354],[6050,33386],[5415,5432,5698,5705,5711,6080,6086,6289,33041,33416,33422,33625,
   39499,39505,39708,46593],[5415,5432,5699,5705,5712,6112,6119,6290,33041,33448,33455,33626,
   39531,39538,39709,47090],[6152],[6183,33519],[6213],[],[],[5705],
 [5415,5432,5695,5705,5706,5978,5979,6284,33041,33314,33315,33620,39397,39398,39703,44904],
 [6340,33676],[6050,33386],[],[6018,33354],
 [5415,5432,5698,5705,5711,6080,6086,6289,33041,33416,33422,33625,39499,39505,39708,46593],
 [5415,5432,5699,5705,5712,6112,6119,6290,33041,33448,33455,33626,39531,39538,39709,47090],
 [6340,33676],[6152],[6183,33519],[6213],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[30394],[31620],[32797],
 [5463,5480,5645,5646,5662,5689,5705,5747,34109,34110,34153,34169,38205,38221,38263,39166],
 [5705],[5463,5480,5645,5646,5662,5689,5705,5747,34109,34110,34153,34169,38205,38221,38263,39166]
  ,[5463,5480,5690,5691,5705,5774,5788,5828,34154,34155,34169,34238,39193,39207,39247,40928],
 [5463,5480,5690,5691,5705,5774,5788,5828,34154,34155,34169,34238,39193,39207,39247,40928],[],
 [5463,5480,5693,5694,5705,5894,5905,5942,34157,34158,34169,34358,39313,39324,39361,43266],
 [5463,5480,5693,5694,5705,5894,5905,5942,34157,34158,34169,34358,39313,39324,39361,43266],
 [5463,5480,5695,5705,5706,5978,5979,6284,34169,34442,34443,34748,39397,39398,39703,44904],
 [6018,34482],[6050,34514],[5463,5480,5698,5705,5711,6080,6086,6289,34169,34544,34550,34753,
   39499,39505,39708,46593],[5463,5480,5699,5705,5712,6112,6119,6290,34169,34576,34583,34754,
   39531,39538,39709,47090],[6152],[6183,34647],[6213],[],[],[5705],
 [5463,5480,5695,5705,5706,5978,5979,6284,34169,34442,34443,34748,39397,39398,39703,44904],
 [6340,34804],[6050,34514],[],[6018,34482],
 [5463,5480,5698,5705,5711,6080,6086,6289,34169,34544,34550,34753,39499,39505,39708,46593],
 [5463,5480,5699,5705,5712,6112,6119,6290,34169,34576,34583,34754,39531,39538,39709,47090],
 [6340,34804],[6152],[6183,34647],[6213],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[27841],[29168],[5510,5527,5645,5646,5662,5689,5705,5747,35190,35191,
   35234,35250,38205,38221,38263,39166],[5705],
 [5510,5527,5645,5646,5662,5689,5705,5747,35190,35191,35234,35250,38205,38221,38263,39166],
 [5510,5527,5690,5691,5705,5774,5788,5828,35235,35236,35250,35319,39193,39207,39247,40928],
 [5510,5527,5690,5691,5705,5774,5788,5828,35235,35236,35250,35319,39193,39207,39247,40928],[],
 [5510,5527,5693,5694,5705,5894,5905,5942,35238,35239,35250,35439,39313,39324,39361,43266],
 [5510,5527,5693,5694,5705,5894,5905,5942,35238,35239,35250,35439,39313,39324,39361,43266],
 [5510,5527,5695,5705,5706,5978,5979,6284,35250,35523,35524,35829,39397,39398,39703,44904],
 [6018,35563],[6050,35595],[5510,5527,5698,5705,5711,6080,6086,6289,35250,35625,35631,35834,
   39499,39505,39708,46593],[5510,5527,5699,5705,5712,6112,6119,6290,35250,35657,35664,35835,
   39531,39538,39709,47090],[6152],[6183,35728],[6213],[],[],[5705],
 [5510,5527,5695,5705,5706,5978,5979,6284,35250,35523,35524,35829,39397,39398,39703,44904],
 [6340,35885],[6050,35595],[],[6018,35563],
 [5510,5527,5698,5705,5711,6080,6086,6289,35250,35625,35631,35834,39499,39505,39708,46593],
 [5510,5527,5699,5705,5712,6112,6119,6290,35250,35657,35664,35835,39531,39538,39709,47090],
 [6340,35885],[6152],[6183,35728],[6213],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[26510],[5556,5573,5645,5646,5662,5689,5705,5747,36225,36226,36269,
   36285,38205,38221,38263,39166],[5705],[5556,5573,5645,5646,5662,5689,5705,5747,36225,36226,
   36269,36285,38205,38221,38263,39166],[5556,5573,5690,5691,5705,5774,5788,5828,36270,36271,
   36285,36354,39193,39207,39247,40928],[5556,5573,5690,5691,5705,5774,5788,5828,36270,36271,
   36285,36354,39193,39207,39247,40928],[],
 [5556,5573,5693,5694,5705,5894,5905,5942,36273,36274,36285,36474,39313,39324,39361,43266],
 [5556,5573,5693,5694,5705,5894,5905,5942,36273,36274,36285,36474,39313,39324,39361,43266],
 [5556,5573,5695,5705,5706,5978,5979,6284,36285,36558,36559,36864,39397,39398,39703,44904],
 [6018,36598],[6050,36630],[5556,5573,5698,5705,5711,6080,6086,6289,36285,36660,36666,36869,
   39499,39505,39708,46593],[5556,5573,5699,5705,5712,6112,6119,6290,36285,36692,36699,36870,
   39531,39538,39709,47090],[6152],[6183,36763],[6213],[],[],[5705],
 [5556,5573,5695,5705,5706,5978,5979,6284,36285,36558,36559,36864,39397,39398,39703,44904],
 [6340,36920],[6050,36630],[],[6018,36598],
 [5556,5573,5698,5705,5711,6080,6086,6289,36285,36660,36666,36869,39499,39505,39708,46593],
 [5556,5573,5699,5705,5712,6112,6119,6290,36285,36692,36699,36870,39531,39538,39709,47090],
 [6340,36920],[6152],[6183,36763],[6213],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[5601,5618,5645,5646,5662,5689,5705,5747,37215,37216,37259,37275,38205,
   38221,38263,39166],[5705],[5601,5618,5645,5646,5662,5689,5705,5747,37215,37216,37259,37275,
   38205,38221,38263,39166],[5601,5618,5690,5691,5705,5774,5788,5828,37260,37261,37275,37344,
   39193,39207,39247,40928],[5601,5618,5690,5691,5705,5774,5788,5828,37260,37261,37275,37344,
   39193,39207,39247,40928],[],[5601,5618,5693,5694,5705,5894,5905,5942,37263,37264,37275,
   37464,39313,39324,39361,43266],[5601,5618,5693,5694,5705,5894,5905,5942,37263,37264,37275,
   37464,39313,39324,39361,43266],[5601,5618,5695,5705,5706,5978,5979,6284,37275,37548,37549,
   37854,39397,39398,39703,44904],[6018,37588],[6050,37620],
 [5601,5618,5698,5705,5711,6080,6086,6289,37275,37650,37656,37859,39499,39505,39708,46593],
 [5601,5618,5699,5705,5712,6112,6119,6290,37275,37682,37689,37860,39531,39538,39709,47090],
 [6152],[6183,37753],[6213],[],[],[5705],
 [5601,5618,5695,5705,5706,5978,5979,6284,37275,37548,37549,37854,39397,39398,39703,44904],
 [6340,37910],[6050,37620],[],[6018,37588],
 [5601,5618,5698,5705,5711,6080,6086,6289,37275,37650,37656,37859,39499,39505,39708,46593],
 [5601,5618,5699,5705,5712,6112,6119,6290,37275,37682,37689,37860,39531,39538,39709,47090],
 [6340,37910],[6152],[6183,37753],[6213],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[5705,38205],[5705,38205],
 [90,94,107,1291,1306,1336,1349,1377,1432,1511,5645,5646,5662,5689,5690,5691,5692,5705,5747,
   5774,5788,5828,5867,38205,38206,38207,38208,38221,38248,38249,38250,38263,38290,38291,38304,
   38331,39151,39152,39153,39166,39193,39194,39207,39234,39247,39286,40054,40055,40095,40915,40928]
  ,[90,94,107,1291,1306,1336,1349,1377,1432,1511,5645,5646,5662,5689,5690,5691,5692,5705,5747,
   5774,5788,5828,5867,38205,38206,38207,38208,38221,38248,38249,38250,38263,38290,38291,38304,
   38331,39151,39152,39153,39166,39193,39194,39207,39234,39247,39286,40054,40055,40095,40915,40928]
  ,[90,94,107,1291,1306,1336,1349,1377,1432,1511,5645,5646,5662,5689,5690,5691,5692,5705,5747,
   5774,5788,5828,5867,38205,38206,38207,38208,38221,38248,38249,38250,38263,38290,38291,38304,
   38331,39151,39152,39153,39166,39193,39194,39207,39234,39247,39286,40054,40055,40095,40915,40928]
  ,[5645,5646,5662,5689,5693,5694,5705,5747,5894,5905,5942,38205,38209,38210,38221,38251,38252,
   38263,38410,39154,39155,39166,39313,39324,39361,40174,43266],
 [5645,5646,5662,5689,5693,5694,5705,5747,5894,5905,5942,38205,38209,38210,38221,38251,38252,
   38263,38410,39154,39155,39166,39313,39324,39361,40174,43266],
 [2279,3500,3501,3507,3517,3518,3544,3550,3592,3833,3834,4139,5645,5646,5662,5689,5695,5705,5706,
   5747,5978,5979,6284,7725,7726,7743,7769,7786,7817,7827,7828,8058,8059,8364,38205,38211,38221,
   38222,38253,38263,38264,38494,38495,38800,39156,39166,39167,39397,39398,39703,40258,40259,40564,
   44904],[5645,5646,5662,5689,5696,5697,5699,5705,5708,5710,5712,5747,6005,6013,6016,6018,
   6047,6050,6052,6112,6119,6286,6288,6290,6360,38205,38212,38213,38215,38221,38224,38226,38228,
   38254,38255,38257,38263,38266,38268,38270,38521,38523,38529,38532,38534,38536,38557,38563,38566,
   38568,38570,38628,38631,38633,38635,38802,38804,38806,38876,38878,38921,39157,39158,39160,39166,
   39169,39171,39173,39424,39426,39432,39435,39437,39439,39460,39466,39469,39471,39473,39531,39534,
   39536,39538,39705,39707,39709,39779,39781,39824,40285,40287,40293,40296,40298,40300,40321,40327,
   40330,40332,40334,40392,40395,40397,40399,40566,40568,40570,40640,40642,40685,45256,45262,45265,
   45267,45269,45327,45330,45332,45334,45501,45503,45505,45575,45577,45620,45888,45891,45893,45895,
   46062,46064,46066,46136,46138,46181,47086,47088,47090,47160,47162,47205,49520,49522,49565,50394]
  ,[5645,5646,5662,5689,5696,5697,5699,5705,5708,5710,5712,5747,6005,6013,6016,6018,6047,6050,
   6052,6112,6119,6286,6288,6290,6360,38205,38212,38213,38215,38221,38224,38226,38228,38254,38255,
   38257,38263,38266,38268,38270,38521,38523,38529,38532,38534,38536,38557,38563,38566,38568,38570,
   38628,38631,38633,38635,38802,38804,38806,38876,38878,38921,39157,39158,39160,39166,39169,39171,
   39173,39424,39426,39432,39435,39437,39439,39460,39466,39469,39471,39473,39531,39534,39536,39538,
   39705,39707,39709,39779,39781,39824,40285,40287,40293,40296,40298,40300,40321,40327,40330,40332,
   40334,40392,40395,40397,40399,40566,40568,40570,40640,40642,40685,45256,45262,45265,45267,45269,
   45327,45330,45332,45334,45501,45503,45505,45575,45577,45620,45888,45891,45893,45895,46062,46064,
   46066,46136,46138,46181,47086,47088,47090,47160,47162,47205,49520,49522,49565,50394],
 [5645,5646,5662,5689,5698,5705,5711,5747,6080,6086,6289,38205,38214,38221,38227,38256,38263,
   38269,38596,38602,38805,39159,39166,39172,39499,39505,39708,40360,40366,40569,46593],
 [5645,5646,5662,5689,5696,5697,5699,5705,5708,5710,5712,5747,6005,6013,6016,6018,6047,6050,6052,
   6112,6119,6286,6288,6290,6360,38205,38212,38213,38215,38221,38224,38226,38228,38254,38255,
   38257,38263,38266,38268,38270,38521,38523,38529,38532,38534,38536,38557,38563,38566,38568,38570,
   38628,38631,38633,38635,38802,38804,38806,38876,38878,38921,39157,39158,39160,39166,39169,39171,
   39173,39424,39426,39432,39435,39437,39439,39460,39466,39469,39471,39473,39531,39534,39536,39538,
   39705,39707,39709,39779,39781,39824,40285,40287,40293,40296,40298,40300,40321,40327,40330,40332,
   40334,40392,40395,40397,40399,40566,40568,40570,40640,40642,40685,45256,45262,45265,45267,45269,
   45327,45330,45332,45334,45501,45503,45505,45575,45577,45620,45888,45891,45893,45895,46062,46064,
   46066,46136,46138,46181,47086,47088,47090,47160,47162,47205,49520,49522,49565,50394],
 [5645,5646,5662,5689,5700,5705,5714,5747,6143,6152,6292,38205,38216,38221,38230,38258,38263,
   38272,39161,39166,39175,39562,39571,39711,47557],
 [5645,5646,5662,5689,5701,5702,5705,5715,5716,5747,6173,6183,6202,6213,6293,6294,38205,38217,
   38218,38221,38231,38232,38259,38260,38263,38273,38274,38686,38699,38700,39015,39162,39163,39166,
   39176,39177,39589,39592,39602,39603,39621,39631,39632,39712,39713,39918,40450,40463,40492,40779,
   47912,47993,48199,48400],[5645,5646,5662,5689,5701,5702,5705,5715,5716,5747,6173,6183,6202,
   6213,6293,6294,38205,38217,38218,38221,38231,38232,38259,38260,38263,38273,38274,38686,38699,
   38700,39015,39162,39163,39166,39176,39177,39589,39592,39602,39603,39621,39631,39632,39712,39713,
   39918,40450,40463,40492,40779,47912,47993,48199,48400],
 [5645,5646,5662,5689,5703,5705,5747,6230,38205,38219,38221,38261,38263,39164,39166,39649],
 [5645,5646,5662,5689,5704,5705,5747,6257,38205,38220,38221,38262,38263,39165,39166,39676],
 [5705,38205],[2279,3500,3501,3507,3517,3518,3544,3550,3592,3833,3834,4139,5645,5646,5662,5689,
   5695,5705,5706,5747,5978,5979,6284,7725,7726,7743,7769,7786,7817,7827,7828,8058,8059,8364,
   38205,38211,38221,38222,38253,38263,38264,38494,38495,38800,39156,39166,39167,39397,39398,39703,
   40258,40259,40564,44904],[5645,5646,5662,5689,5705,5707,5713,5747,6285,6291,6340,38205,38221,
   38223,38229,38263,38265,38271,38856,39166,39168,39174,39704,39710,39759,40620,49500],
 [5645,5646,5662,5689,5696,5697,5699,5705,5708,5710,5712,5747,6005,6013,6016,6018,6047,6050,6052,
   6112,6119,6286,6288,6290,6360,38205,38212,38213,38215,38221,38224,38226,38228,38254,38255,
   38257,38263,38266,38268,38270,38521,38523,38529,38532,38534,38536,38557,38563,38566,38568,38570,
   38628,38631,38633,38635,38802,38804,38806,38876,38878,38921,39157,39158,39160,39166,39169,39171,
   39173,39424,39426,39432,39435,39437,39439,39460,39466,39469,39471,39473,39531,39534,39536,39538,
   39705,39707,39709,39779,39781,39824,40285,40287,40293,40296,40298,40300,40321,40327,40330,40332,
   40334,40392,40395,40397,40399,40566,40568,40570,40640,40642,40685,45256,45262,45265,45267,45269,
   45327,45330,45332,45334,45501,45503,45505,45575,45577,45620,45888,45891,45893,45895,46062,46064,
   46066,46136,46138,46181,47086,47088,47090,47160,47162,47205,49520,49522,49565,50394],
 [5645,5646,5662,5689,5705,5709,5747,6287,38205,38221,38225,38263,38267,39166,39170,39706],
 [5645,5646,5662,5689,5696,5697,5699,5705,5708,5710,5712,5747,6005,6013,6016,6018,6047,6050,6052,
   6112,6119,6286,6288,6290,6360,38205,38212,38213,38215,38221,38224,38226,38228,38254,38255,
   38257,38263,38266,38268,38270,38521,38523,38529,38532,38534,38536,38557,38563,38566,38568,38570,
   38628,38631,38633,38635,38802,38804,38806,38876,38878,38921,39157,39158,39160,39166,39169,39171,
   39173,39424,39426,39432,39435,39437,39439,39460,39466,39469,39471,39473,39531,39534,39536,39538,
   39705,39707,39709,39779,39781,39824,40285,40287,40293,40296,40298,40300,40321,40327,40330,40332,
   40334,40392,40395,40397,40399,40566,40568,40570,40640,40642,40685,45256,45262,45265,45267,45269,
   45327,45330,45332,45334,45501,45503,45505,45575,45577,45620,45888,45891,45893,45895,46062,46064,
   46066,46136,46138,46181,47086,47088,47090,47160,47162,47205,49520,49522,49565,50394],
 [5645,5646,5662,5689,5698,5705,5711,5747,6080,6086,6289,38205,38214,38221,38227,38256,38263,
   38269,38596,38602,38805,39159,39166,39172,39499,39505,39708,40360,40366,40569,46593],
 [5645,5646,5662,5689,5696,5697,5699,5705,5708,5710,5712,5747,6005,6013,6016,6018,6047,6050,6052,
   6112,6119,6286,6288,6290,6360,38205,38212,38213,38215,38221,38224,38226,38228,38254,38255,
   38257,38263,38266,38268,38270,38521,38523,38529,38532,38534,38536,38557,38563,38566,38568,38570,
   38628,38631,38633,38635,38802,38804,38806,38876,38878,38921,39157,39158,39160,39166,39169,39171,
   39173,39424,39426,39432,39435,39437,39439,39460,39466,39469,39471,39473,39531,39534,39536,39538,
   39705,39707,39709,39779,39781,39824,40285,40287,40293,40296,40298,40300,40321,40327,40330,40332,
   40334,40392,40395,40397,40399,40566,40568,40570,40640,40642,40685,45256,45262,45265,45267,45269,
   45327,45330,45332,45334,45501,45503,45505,45575,45577,45620,45888,45891,45893,45895,46062,46064,
   46066,46136,46138,46181,47086,47088,47090,47160,47162,47205,49520,49522,49565,50394],
 [5645,5646,5662,5689,5705,5707,5713,5747,6285,6291,6340,38205,38221,38223,38229,38263,38265,
   38271,38856,39166,39168,39174,39704,39710,39759,40620,49500],
 [5645,5646,5662,5689,5700,5705,5714,5747,6143,6152,6292,38205,38216,38221,38230,38258,38263,
   38272,39161,39166,39175,39562,39571,39711,47557],
 [5645,5646,5662,5689,5701,5702,5705,5715,5716,5747,6173,6183,6202,6213,6293,6294,38205,38217,
   38218,38221,38231,38232,38259,38260,38263,38273,38274,38686,38699,38700,39015,39162,39163,39166,
   39176,39177,39589,39592,39602,39603,39621,39631,39632,39712,39713,39918,40450,40463,40492,40779,
   47912,47993,48199,48400],[5645,5646,5662,5689,5701,5702,5705,5715,5716,5747,6173,6183,6202,
   6213,6293,6294,38205,38217,38218,38221,38231,38232,38259,38260,38263,38273,38274,38686,38699,
   38700,39015,39162,39163,39166,39176,39177,39589,39592,39602,39603,39621,39631,39632,39712,39713,
   39918,40450,40463,40492,40779,47912,47993,48199,48400],
 [5645,5646,5662,5689,5705,5717,5747,6295,38205,38221,38233,38263,38275,39166,39178,39714],
 [5645,5646,5662,5689,5705,5718,5719,5747,6296,6297,38205,38221,38234,38235,38263,38276,38277,
   39060,39166,39179,39180,39715,39716,39963,40824],
 [5645,5646,5662,5689,5705,5718,5719,5747,6296,6297,38205,38221,38234,38235,38263,38276,38277,
   39060,39166,39179,39180,39715,39716,39963,40824],
 [5645,5646,5662,5689,5705,5720,5747,6298,38205,38221,38236,38263,38278,39166,39181,39717],
 [5645,5646,5662,5689,5705,5721,5747,6299,38205,38221,38237,38263,38279,39166,39182,39718],
 [5645,5646,5662,5689,5705,5722,5723,5747,6300,6301,38205,38221,38238,38239,38263,38280,38281,
   39106,39166,39183,39184,39719,39720,40009,40870],
 [5645,5646,5662,5689,5705,5722,5723,5747,6300,6301,38205,38221,38238,38239,38263,38280,38281,
   39106,39166,39183,39184,39719,39720,40009,40870],
 [5645,5646,5662,5689,5705,5724,5747,6302,38205,38221,38240,38263,38282,39166,39185,39721],
 [5645,5646,5662,5689,5705,5725,5747,6303,38205,38221,38241,38263,38283,39166,39186,39722],
 [5645,5646,5662,5689,5705,5726,5747,6304,38205,38221,38242,38263,38284,39166,39187,39723],
 [5645,5646,5662,5689,5705,5727,5747,6305,38205,38221,38243,38263,38285,39166,39188,39724],
 [5645,5646,5662,5689,5705,5728,5747,6306,38205,38221,38244,38263,38286,39166,39189,39725],
 [5645,5646,5662,5689,5705,5729,5747,6307,38205,38221,38245,38263,38287,39166,39190,39726],
 [5645,5646,5662,5689,5705,5730,5731,5747,6308,6309,38205,38221,38246,38247,38263,38288,38289,
   39150,39166,39191,39192,39727,39728,40053,40914],
 [5645,5646,5662,5689,5705,5730,5731,5747,6308,6309,38205,38221,38246,38247,38263,38288,38289,
   39150,39166,39191,39192,39727,39728,40053,40914],[5705,38205],[5705,39193],[5705,39193],
 [5705],[5705,39313],[5705,39313],[5705,44904],[5705,6018,6050,39424,39779,45501,46064],
 [5705,6018,6050,39424,39779,45501,46064],[5705,46593],[5705,47090],[5705,6152],
 [5705,6183,39602,47993],[5705,6213],[5705],[5705],[],[5705,44904],
 [5705,6340,39759,49500],[5705,6018,6050,39424,39779,45501,46064],[5705],
 [5705,6018,6050,39424,39779,45501,46064],[5705,46593],[5705,47090],[5705,6340,39759,49500],
 [5705,6152],[5705,6183,39602,47993],[5705,6213],[5705],[5705],[5705],[5705],[5705],
 [5705],[5705],[5705],[5705],[5705],[5705],[5705],[5705],[5705],[5705],
 [90,94,107,1291,1306,1336,1349,1377,1432,1511,5645,5646,5662,5689,5690,5691,5692,5705,5747,
   5774,5788,5828,5867,38205,38206,38207,38208,38221,38248,38249,38250,38263,38290,38291,38304,
   38331,39151,39152,39153,39166,39193,39194,39207,39234,39247,39286,40054,40055,40095,40915,40928]
  ,[90,94,107,1291,1306,1336,1349,1377,1432,1511,5645,5646,5662,5689,5690,5691,5692,5705,5747,
   5774,5788,5828,5867,38205,38206,38207,38208,38221,38248,38249,38250,38263,38290,38291,38304,
   38331,39151,39152,39153,39166,39193,39194,39207,39234,39247,39286,40054,40055,40095,40915,40928]
  ,[90,94,107,1291,1306,1336,1349,1377,1432,1511,5645,5646,5662,5689,5690,5691,5692,5705,5747,
   5774,5788,5828,5867,38205,38206,38207,38208,38221,38248,38249,38250,38263,38290,38291,38304,
   38331,39151,39152,39153,39166,39193,39194,39207,39234,39247,39286,40054,40055,40095,40915,40928]
  ,[5645,5646,5662,5689,5693,5694,5705,5747,5894,5905,5942,38205,38209,38210,38221,38251,38252,
   38263,38410,39154,39155,39166,39313,39324,39361,40174,43266],
 [5645,5646,5662,5689,5693,5694,5705,5747,5894,5905,5942,38205,38209,38210,38221,38251,38252,
   38263,38410,39154,39155,39166,39313,39324,39361,40174,43266],
 [2279,3500,3501,3507,3517,3518,3544,3550,3592,3833,3834,4139,5645,5646,5662,5689,5695,5705,5706,
   5747,5978,5979,6284,7725,7726,7743,7769,7786,7817,7827,7828,8058,8059,8364,38205,38211,38221,
   38222,38253,38263,38264,38494,38495,38800,39156,39166,39167,39397,39398,39703,40258,40259,40564,
   44904],[5645,5646,5662,5689,5696,5697,5699,5705,5708,5710,5712,5747,6005,6013,6016,6018,
   6047,6050,6052,6112,6119,6286,6288,6290,6360,38205,38212,38213,38215,38221,38224,38226,38228,
   38254,38255,38257,38263,38266,38268,38270,38521,38523,38529,38532,38534,38536,38557,38563,38566,
   38568,38570,38628,38631,38633,38635,38802,38804,38806,38876,38878,38921,39157,39158,39160,39166,
   39169,39171,39173,39424,39426,39432,39435,39437,39439,39460,39466,39469,39471,39473,39531,39534,
   39536,39538,39705,39707,39709,39779,39781,39824,40285,40287,40293,40296,40298,40300,40321,40327,
   40330,40332,40334,40392,40395,40397,40399,40566,40568,40570,40640,40642,40685,45256,45262,45265,
   45267,45269,45327,45330,45332,45334,45501,45503,45505,45575,45577,45620,45888,45891,45893,45895,
   46062,46064,46066,46136,46138,46181,47086,47088,47090,47160,47162,47205,49520,49522,49565,50394]
  ,[5645,5646,5662,5689,5696,5697,5699,5705,5708,5710,5712,5747,6005,6013,6016,6018,6047,6050,
   6052,6112,6119,6286,6288,6290,6360,38205,38212,38213,38215,38221,38224,38226,38228,38254,38255,
   38257,38263,38266,38268,38270,38521,38523,38529,38532,38534,38536,38557,38563,38566,38568,38570,
   38628,38631,38633,38635,38802,38804,38806,38876,38878,38921,39157,39158,39160,39166,39169,39171,
   39173,39424,39426,39432,39435,39437,39439,39460,39466,39469,39471,39473,39531,39534,39536,39538,
   39705,39707,39709,39779,39781,39824,40285,40287,40293,40296,40298,40300,40321,40327,40330,40332,
   40334,40392,40395,40397,40399,40566,40568,40570,40640,40642,40685,45256,45262,45265,45267,45269,
   45327,45330,45332,45334,45501,45503,45505,45575,45577,45620,45888,45891,45893,45895,46062,46064,
   46066,46136,46138,46181,47086,47088,47090,47160,47162,47205,49520,49522,49565,50394],
 [5645,5646,5662,5689,5698,5705,5711,5747,6080,6086,6289,38205,38214,38221,38227,38256,38263,
   38269,38596,38602,38805,39159,39166,39172,39499,39505,39708,40360,40366,40569,46593],
 [5645,5646,5662,5689,5696,5697,5699,5705,5708,5710,5712,5747,6005,6013,6016,6018,6047,6050,6052,
   6112,6119,6286,6288,6290,6360,38205,38212,38213,38215,38221,38224,38226,38228,38254,38255,
   38257,38263,38266,38268,38270,38521,38523,38529,38532,38534,38536,38557,38563,38566,38568,38570,
   38628,38631,38633,38635,38802,38804,38806,38876,38878,38921,39157,39158,39160,39166,39169,39171,
   39173,39424,39426,39432,39435,39437,39439,39460,39466,39469,39471,39473,39531,39534,39536,39538,
   39705,39707,39709,39779,39781,39824,40285,40287,40293,40296,40298,40300,40321,40327,40330,40332,
   40334,40392,40395,40397,40399,40566,40568,40570,40640,40642,40685,45256,45262,45265,45267,45269,
   45327,45330,45332,45334,45501,45503,45505,45575,45577,45620,45888,45891,45893,45895,46062,46064,
   46066,46136,46138,46181,47086,47088,47090,47160,47162,47205,49520,49522,49565,50394],
 [5645,5646,5662,5689,5700,5705,5714,5747,6143,6152,6292,38205,38216,38221,38230,38258,38263,
   38272,39161,39166,39175,39562,39571,39711,47557],
 [5645,5646,5662,5689,5701,5702,5705,5715,5716,5747,6173,6183,6202,6213,6293,6294,38205,38217,
   38218,38221,38231,38232,38259,38260,38263,38273,38274,38686,38699,38700,39015,39162,39163,39166,
   39176,39177,39589,39592,39602,39603,39621,39631,39632,39712,39713,39918,40450,40463,40492,40779,
   47912,47993,48199,48400],[5645,5646,5662,5689,5701,5702,5705,5715,5716,5747,6173,6183,6202,
   6213,6293,6294,38205,38217,38218,38221,38231,38232,38259,38260,38263,38273,38274,38686,38699,
   38700,39015,39162,39163,39166,39176,39177,39589,39592,39602,39603,39621,39631,39632,39712,39713,
   39918,40450,40463,40492,40779,47912,47993,48199,48400],
 [5645,5646,5662,5689,5703,5705,5747,6230,38205,38219,38221,38261,38263,39164,39166,39649],
 [5645,5646,5662,5689,5704,5705,5747,6257,38205,38220,38221,38262,38263,39165,39166,39676],
 [5705,38205],[2279,3500,3501,3507,3517,3518,3544,3550,3592,3833,3834,4139,5645,5646,5662,5689,
   5695,5705,5706,5747,5978,5979,6284,7725,7726,7743,7769,7786,7817,7827,7828,8058,8059,8364,
   38205,38211,38221,38222,38253,38263,38264,38494,38495,38800,39156,39166,39167,39397,39398,39703,
   40258,40259,40564,44904],[5645,5646,5662,5689,5705,5707,5713,5747,6285,6291,6340,38205,38221,
   38223,38229,38263,38265,38271,38856,39166,39168,39174,39704,39710,39759,40620,49500],
 [5645,5646,5662,5689,5696,5697,5699,5705,5708,5710,5712,5747,6005,6013,6016,6018,6047,6050,6052,
   6112,6119,6286,6288,6290,6360,38205,38212,38213,38215,38221,38224,38226,38228,38254,38255,
   38257,38263,38266,38268,38270,38521,38523,38529,38532,38534,38536,38557,38563,38566,38568,38570,
   38628,38631,38633,38635,38802,38804,38806,38876,38878,38921,39157,39158,39160,39166,39169,39171,
   39173,39424,39426,39432,39435,39437,39439,39460,39466,39469,39471,39473,39531,39534,39536,39538,
   39705,39707,39709,39779,39781,39824,40285,40287,40293,40296,40298,40300,40321,40327,40330,40332,
   40334,40392,40395,40397,40399,40566,40568,40570,40640,40642,40685,45256,45262,45265,45267,45269,
   45327,45330,45332,45334,45501,45503,45505,45575,45577,45620,45888,45891,45893,45895,46062,46064,
   46066,46136,46138,46181,47086,47088,47090,47160,47162,47205,49520,49522,49565,50394],
 [5645,5646,5662,5689,5705,5709,5747,6287,38205,38221,38225,38263,38267,39166,39170,39706],
 [5645,5646,5662,5689,5696,5697,5699,5705,5708,5710,5712,5747,6005,6013,6016,6018,6047,6050,6052,
   6112,6119,6286,6288,6290,6360,38205,38212,38213,38215,38221,38224,38226,38228,38254,38255,
   38257,38263,38266,38268,38270,38521,38523,38529,38532,38534,38536,38557,38563,38566,38568,38570,
   38628,38631,38633,38635,38802,38804,38806,38876,38878,38921,39157,39158,39160,39166,39169,39171,
   39173,39424,39426,39432,39435,39437,39439,39460,39466,39469,39471,39473,39531,39534,39536,39538,
   39705,39707,39709,39779,39781,39824,40285,40287,40293,40296,40298,40300,40321,40327,40330,40332,
   40334,40392,40395,40397,40399,40566,40568,40570,40640,40642,40685,45256,45262,45265,45267,45269,
   45327,45330,45332,45334,45501,45503,45505,45575,45577,45620,45888,45891,45893,45895,46062,46064,
   46066,46136,46138,46181,47086,47088,47090,47160,47162,47205,49520,49522,49565,50394],
 [5645,5646,5662,5689,5698,5705,5711,5747,6080,6086,6289,38205,38214,38221,38227,38256,38263,
   38269,38596,38602,38805,39159,39166,39172,39499,39505,39708,40360,40366,40569,46593],
 [5645,5646,5662,5689,5696,5697,5699,5705,5708,5710,5712,5747,6005,6013,6016,6018,6047,6050,6052,
   6112,6119,6286,6288,6290,6360,38205,38212,38213,38215,38221,38224,38226,38228,38254,38255,
   38257,38263,38266,38268,38270,38521,38523,38529,38532,38534,38536,38557,38563,38566,38568,38570,
   38628,38631,38633,38635,38802,38804,38806,38876,38878,38921,39157,39158,39160,39166,39169,39171,
   39173,39424,39426,39432,39435,39437,39439,39460,39466,39469,39471,39473,39531,39534,39536,39538,
   39705,39707,39709,39779,39781,39824,40285,40287,40293,40296,40298,40300,40321,40327,40330,40332,
   40334,40392,40395,40397,40399,40566,40568,40570,40640,40642,40685,45256,45262,45265,45267,45269,
   45327,45330,45332,45334,45501,45503,45505,45575,45577,45620,45888,45891,45893,45895,46062,46064,
   46066,46136,46138,46181,47086,47088,47090,47160,47162,47205,49520,49522,49565,50394],
 [5645,5646,5662,5689,5705,5707,5713,5747,6285,6291,6340,38205,38221,38223,38229,38263,38265,
   38271,38856,39166,39168,39174,39704,39710,39759,40620,49500],
 [5645,5646,5662,5689,5700,5705,5714,5747,6143,6152,6292,38205,38216,38221,38230,38258,38263,
   38272,39161,39166,39175,39562,39571,39711,47557],
 [5645,5646,5662,5689,5701,5702,5705,5715,5716,5747,6173,6183,6202,6213,6293,6294,38205,38217,
   38218,38221,38231,38232,38259,38260,38263,38273,38274,38686,38699,38700,39015,39162,39163,39166,
   39176,39177,39589,39592,39602,39603,39621,39631,39632,39712,39713,39918,40450,40463,40492,40779,
   47912,47993,48199,48400],[5645,5646,5662,5689,5701,5702,5705,5715,5716,5747,6173,6183,6202,
   6213,6293,6294,38205,38217,38218,38221,38231,38232,38259,38260,38263,38273,38274,38686,38699,
   38700,39015,39162,39163,39166,39176,39177,39589,39592,39602,39603,39621,39631,39632,39712,39713,
   39918,40450,40463,40492,40779,47912,47993,48199,48400],
 [5645,5646,5662,5689,5705,5717,5747,6295,38205,38221,38233,38263,38275,39166,39178,39714],
 [5645,5646,5662,5689,5705,5718,5719,5747,6296,6297,38205,38221,38234,38235,38263,38276,38277,
   39060,39166,39179,39180,39715,39716,39963,40824],
 [5645,5646,5662,5689,5705,5718,5719,5747,6296,6297,38205,38221,38234,38235,38263,38276,38277,
   39060,39166,39179,39180,39715,39716,39963,40824],
 [5645,5646,5662,5689,5705,5720,5747,6298,38205,38221,38236,38263,38278,39166,39181,39717],
 [5645,5646,5662,5689,5705,5721,5747,6299,38205,38221,38237,38263,38279,39166,39182,39718],
 [5645,5646,5662,5689,5705,5722,5723,5747,6300,6301,38205,38221,38238,38239,38263,38280,38281,
   39106,39166,39183,39184,39719,39720,40009,40870],
 [5645,5646,5662,5689,5705,5722,5723,5747,6300,6301,38205,38221,38238,38239,38263,38280,38281,
   39106,39166,39183,39184,39719,39720,40009,40870],
 [5645,5646,5662,5689,5705,5724,5747,6302,38205,38221,38240,38263,38282,39166,39185,39721],
 [5645,5646,5662,5689,5705,5725,5747,6303,38205,38221,38241,38263,38283,39166,39186,39722],
 [5645,5646,5662,5689,5705,5726,5747,6304,38205,38221,38242,38263,38284,39166,39187,39723],
 [5645,5646,5662,5689,5705,5727,5747,6305,38205,38221,38243,38263,38285,39166,39188,39724],
 [5645,5646,5662,5689,5705,5728,5747,6306,38205,38221,38244,38263,38286,39166,39189,39725],
 [5645,5646,5662,5689,5705,5729,5747,6307,38205,38221,38245,38263,38287,39166,39190,39726],
 [5645,5646,5662,5689,5705,5730,5731,5747,6308,6309,38205,38221,38246,38247,38263,38288,38289,
   39150,39166,39191,39192,39727,39728,40053,40914],
 [5645,5646,5662,5689,5705,5730,5731,5747,6308,6309,38205,38221,38246,38247,38263,38288,38289,
   39150,39166,39191,39192,39727,39728,40053,40914],[5705,39193],
 [90,94,107,1291,1306,1336,1349,1377,1432,1511,5645,5646,5662,5689,5690,5691,5692,5705,5747,
   5774,5788,5828,5867,38205,38206,38207,38208,38221,38248,38249,38250,38263,38290,38291,38304,
   38331,39151,39152,39153,39166,39193,39194,39207,39234,39247,39286,40054,40055,40095,40915,40928]
  ,[5690,5691,5693,5694,5705,5774,5788,5828,5894,5905,5942,39193,39195,39196,39207,39235,39236,
   39247,39313,39324,39361,40916,40917,40928,40994,41774,43266],
 [5690,5691,5693,5694,5705,5774,5788,5828,5894,5905,5942,39193,39195,39196,39207,39235,39236,
   39247,39313,39324,39361,40916,40917,40928,40994,41774,43266],
 [5690,5691,5695,5696,5697,5705,5706,5708,5710,5774,5788,5828,5978,5979,6005,6013,6016,6018,6047,
   6050,6052,6284,6286,6288,6360,39193,39197,39198,39199,39207,39208,39210,39212,39237,39238,
   39239,39247,39248,39250,39252,39388,39389,39397,39398,39400,39402,39424,39432,39433,39435,39437,
   39466,39467,39469,39471,39703,39705,39707,39730,39732,39779,40918,40919,40920,40928,40929,40931,
   40933,41069,41070,41078,41079,41081,41083,41105,41113,41114,41116,41118,41147,41148,41150,41152,
   41384,41386,41388,41411,41413,41460,41849,41850,41858,41859,41861,41863,41885,41893,41894,41896,
   41898,41927,41928,41930,41932,42164,42166,42168,42191,42193,42240,44625,44633,44634,44636,44638,
   44667,44668,44670,44672,44904,44906,44908,44931,44933,44980,45262,45263,45265,45267,45499,45501,
   45503,45526,45528,45575,46060,46062,46064,46087,46089,46136,49471,49473,49520,49820],
 [5690,5691,5695,5696,5697,5705,5706,5708,5710,5774,5788,5828,5978,5979,6005,6013,6016,6018,6047,
   6050,6052,6284,6286,6288,6360,39193,39197,39198,39199,39207,39208,39210,39212,39237,39238,
   39239,39247,39248,39250,39252,39388,39389,39397,39398,39400,39402,39424,39432,39433,39435,39437,
   39466,39467,39469,39471,39703,39705,39707,39730,39732,39779,40918,40919,40920,40928,40929,40931,
   40933,41069,41070,41078,41079,41081,41083,41105,41113,41114,41116,41118,41147,41148,41150,41152,
   41384,41386,41388,41411,41413,41460,41849,41850,41858,41859,41861,41863,41885,41893,41894,41896,
   41898,41927,41928,41930,41932,42164,42166,42168,42191,42193,42240,44625,44633,44634,44636,44638,
   44667,44668,44670,44672,44904,44906,44908,44931,44933,44980,45262,45263,45265,45267,45499,45501,
   45503,45526,45528,45575,46060,46062,46064,46087,46089,46136,49471,49473,49520,49820],
 [5690,5691,5695,5696,5697,5705,5706,5708,5710,5774,5788,5828,5978,5979,6005,6013,6016,6018,6047,
   6050,6052,6284,6286,6288,6360,39193,39197,39198,39199,39207,39208,39210,39212,39237,39238,
   39239,39247,39248,39250,39252,39388,39389,39397,39398,39400,39402,39424,39432,39433,39435,39437,
   39466,39467,39469,39471,39703,39705,39707,39730,39732,39779,40918,40919,40920,40928,40929,40931,
   40933,41069,41070,41078,41079,41081,41083,41105,41113,41114,41116,41118,41147,41148,41150,41152,
   41384,41386,41388,41411,41413,41460,41849,41850,41858,41859,41861,41863,41885,41893,41894,41896,
   41898,41927,41928,41930,41932,42164,42166,42168,42191,42193,42240,44625,44633,44634,44636,44638,
   44667,44668,44670,44672,44904,44906,44908,44931,44933,44980,45262,45263,45265,45267,45499,45501,
   45503,45526,45528,45575,46060,46062,46064,46087,46089,46136,49471,49473,49520,49820],
 [5690,5691,5698,5705,5711,5774,5788,5828,6080,6086,6289,39193,39200,39207,39213,39240,39247,
   39253,39499,39505,39708,40921,40928,40934,41180,41186,41389,41960,41966,42169,46593],
 [5690,5691,5699,5705,5712,5774,5788,5828,6112,6119,6290,39193,39201,39207,39214,39241,39247,
   39254,39531,39538,39709,40922,40928,40935,41212,41219,41390,41992,41999,42170,47090],
 [5690,5691,5700,5701,5705,5714,5715,5774,5788,5828,6143,6152,6173,6183,6292,6293,39193,39202,
   39203,39207,39216,39217,39242,39243,39247,39256,39257,39558,39562,39571,39572,39592,39601,39602,
   39711,39712,39901,40923,40924,40928,40937,40938,41239,41253,41283,41582,42019,42062,42063,42362,
   47448,47557,47993,48182],[5690,5691,5700,5701,5705,5714,5715,5774,5788,5828,6143,6152,6173,
   6183,6292,6293,39193,39202,39203,39207,39216,39217,39242,39243,39247,39256,39257,39558,39562,
   39571,39572,39592,39601,39602,39711,39712,39901,40923,40924,40928,40937,40938,41239,41253,41283,
   41582,42019,42062,42063,42362,47448,47557,47993,48182],
 [5690,5691,5702,5705,5716,5774,5788,5828,6202,6213,6294,39193,39204,39207,39218,39244,39247,
   39258,39621,39632,39713,40925,40928,40939,48400],
 [5690,5691,5703,5704,5705,5774,5788,5828,6230,6257,39193,39205,39206,39207,39245,39246,39247,
   39648,39649,39676,40926,40927,40928,41329,42109],
 [5690,5691,5703,5704,5705,5774,5788,5828,6230,6257,39193,39205,39206,39207,39245,39246,39247,
   39648,39649,39676,40926,40927,40928,41329,42109],[5705,39193],
 [5690,5691,5695,5696,5697,5705,5706,5708,5710,5774,5788,5828,5978,5979,6005,6013,6016,6018,6047,
   6050,6052,6284,6286,6288,6360,39193,39197,39198,39199,39207,39208,39210,39212,39237,39238,
   39239,39247,39248,39250,39252,39388,39389,39397,39398,39400,39402,39424,39432,39433,39435,39437,
   39466,39467,39469,39471,39703,39705,39707,39730,39732,39779,40918,40919,40920,40928,40929,40931,
   40933,41069,41070,41078,41079,41081,41083,41105,41113,41114,41116,41118,41147,41148,41150,41152,
   41384,41386,41388,41411,41413,41460,41849,41850,41858,41859,41861,41863,41885,41893,41894,41896,
   41898,41927,41928,41930,41932,42164,42166,42168,42191,42193,42240,44625,44633,44634,44636,44638,
   44667,44668,44670,44672,44904,44906,44908,44931,44933,44980,45262,45263,45265,45267,45499,45501,
   45503,45526,45528,45575,46060,46062,46064,46087,46089,46136,49471,49473,49520,49820],
 [5690,5691,5705,5707,5713,5774,5788,5828,6285,6291,6340,39193,39207,39209,39215,39247,39249,
   39255,39704,39710,39759,40928,40930,40936,41440,42220,49500],
 [5690,5691,5695,5696,5697,5705,5706,5708,5710,5774,5788,5828,5978,5979,6005,6013,6016,6018,6047,
   6050,6052,6284,6286,6288,6360,39193,39197,39198,39199,39207,39208,39210,39212,39237,39238,
   39239,39247,39248,39250,39252,39388,39389,39397,39398,39400,39402,39424,39432,39433,39435,39437,
   39466,39467,39469,39471,39703,39705,39707,39730,39732,39779,40918,40919,40920,40928,40929,40931,
   40933,41069,41070,41078,41079,41081,41083,41105,41113,41114,41116,41118,41147,41148,41150,41152,
   41384,41386,41388,41411,41413,41460,41849,41850,41858,41859,41861,41863,41885,41893,41894,41896,
   41898,41927,41928,41930,41932,42164,42166,42168,42191,42193,42240,44625,44633,44634,44636,44638,
   44667,44668,44670,44672,44904,44906,44908,44931,44933,44980,45262,45263,45265,45267,45499,45501,
   45503,45526,45528,45575,46060,46062,46064,46087,46089,46136,49471,49473,49520,49820],
 [5690,5691,5705,5709,5774,5788,5828,6287,39193,39207,39211,39247,39251,39706,40928,40932],
 [5690,5691,5695,5696,5697,5705,5706,5708,5710,5774,5788,5828,5978,5979,6005,6013,6016,6018,6047,
   6050,6052,6284,6286,6288,6360,39193,39197,39198,39199,39207,39208,39210,39212,39237,39238,
   39239,39247,39248,39250,39252,39388,39389,39397,39398,39400,39402,39424,39432,39433,39435,39437,
   39466,39467,39469,39471,39703,39705,39707,39730,39732,39779,40918,40919,40920,40928,40929,40931,
   40933,41069,41070,41078,41079,41081,41083,41105,41113,41114,41116,41118,41147,41148,41150,41152,
   41384,41386,41388,41411,41413,41460,41849,41850,41858,41859,41861,41863,41885,41893,41894,41896,
   41898,41927,41928,41930,41932,42164,42166,42168,42191,42193,42240,44625,44633,44634,44636,44638,
   44667,44668,44670,44672,44904,44906,44908,44931,44933,44980,45262,45263,45265,45267,45499,45501,
   45503,45526,45528,45575,46060,46062,46064,46087,46089,46136,49471,49473,49520,49820],
 [5690,5691,5698,5705,5711,5774,5788,5828,6080,6086,6289,39193,39200,39207,39213,39240,39247,
   39253,39499,39505,39708,40921,40928,40934,41180,41186,41389,41960,41966,42169,46593],
 [5690,5691,5699,5705,5712,5774,5788,5828,6112,6119,6290,39193,39201,39207,39214,39241,39247,
   39254,39531,39538,39709,40922,40928,40935,41212,41219,41390,41992,41999,42170,47090],
 [5690,5691,5705,5707,5713,5774,5788,5828,6285,6291,6340,39193,39207,39209,39215,39247,39249,
   39255,39704,39710,39759,40928,40930,40936,41440,42220,49500],
 [5690,5691,5700,5701,5705,5714,5715,5774,5788,5828,6143,6152,6173,6183,6292,6293,39193,39202,
   39203,39207,39216,39217,39242,39243,39247,39256,39257,39558,39562,39571,39572,39592,39601,39602,
   39711,39712,39901,40923,40924,40928,40937,40938,41239,41253,41283,41582,42019,42062,42063,42362,
   47448,47557,47993,48182],[5690,5691,5700,5701,5705,5714,5715,5774,5788,5828,6143,6152,6173,
   6183,6292,6293,39193,39202,39203,39207,39216,39217,39242,39243,39247,39256,39257,39558,39562,
   39571,39572,39592,39601,39602,39711,39712,39901,40923,40924,40928,40937,40938,41239,41253,41283,
   41582,42019,42062,42063,42362,47448,47557,47993,48182],
 [5690,5691,5702,5705,5716,5774,5788,5828,6202,6213,6294,39193,39204,39207,39218,39244,39247,
   39258,39621,39632,39713,40925,40928,40939,48400],
 [5690,5691,5705,5717,5774,5788,5828,6295,39193,39207,39219,39247,39259,39714,40928,40940],
 [5690,5691,5705,5718,5774,5788,5828,6296,39193,39207,39220,39247,39260,39715,40928,40941],
 [5690,5691,5705,5719,5774,5788,5828,6297,39193,39207,39221,39247,39261,39716,40928,40942],
 [5690,5691,5705,5720,5721,5774,5788,5828,6298,6299,39193,39207,39222,39223,39247,39262,39263,
   39717,39718,39988,40928,40943,40944,41669,42449],
 [5690,5691,5705,5720,5721,5774,5788,5828,6298,6299,39193,39207,39222,39223,39247,39262,39263,
   39717,39718,39988,40928,40943,40944,41669,42449],
 [5690,5691,5705,5722,5774,5788,5828,6300,39193,39207,39224,39247,39264,39719,40928,40945],
 [5690,5691,5705,5723,5774,5788,5828,6301,39193,39207,39225,39247,39265,39720,40928,40946],
 [5690,5691,5705,5724,5774,5788,5828,6302,39193,39207,39226,39247,39266,39721,40928,40947],
 [5690,5691,5705,5725,5726,5774,5788,5828,6303,6304,39193,39207,39227,39228,39247,39267,39268,
   39722,39723,40033,40928,40948,40949,41714,42494],
 [5690,5691,5705,5725,5726,5774,5788,5828,6303,6304,39193,39207,39227,39228,39247,39267,39268,
   39722,39723,40033,40928,40948,40949,41714,42494],
 [5690,5691,5705,5727,5774,5788,5828,6305,39193,39207,39229,39247,39269,39724,40928,40950],
 [5690,5691,5705,5728,5774,5788,5828,6306,39193,39207,39230,39247,39270,39725,40928,40951],
 [5690,5691,5705,5729,5774,5788,5828,6307,39193,39207,39231,39247,39271,39726,40928,40952],
 [5690,5691,5705,5730,5774,5788,5828,6308,39193,39207,39232,39247,39272,39727,40928,40953],
 [5690,5691,5705,5731,5774,5788,5828,6309,39193,39207,39233,39247,39273,39728,40928,40954],
 [90,94,107,1291,1306,1336,1349,1377,1432,1511,5645,5646,5662,5689,5690,5691,5692,5705,5747,
   5774,5788,5828,5867,38205,38206,38207,38208,38221,38248,38249,38250,38263,38290,38291,38304,
   38331,39151,39152,39153,39166,39193,39194,39207,39234,39247,39286,40054,40055,40095,40915,40928]
  ,[5690,5691,5693,5694,5705,5774,5788,5828,5894,5905,5942,39193,39195,39196,39207,39235,39236,
   39247,39313,39324,39361,40916,40917,40928,40994,41774,43266],
 [5690,5691,5693,5694,5705,5774,5788,5828,5894,5905,5942,39193,39195,39196,39207,39235,39236,
   39247,39313,39324,39361,40916,40917,40928,40994,41774,43266],
 [5690,5691,5695,5696,5697,5705,5706,5708,5710,5774,5788,5828,5978,5979,6005,6013,6016,6018,6047,
   6050,6052,6284,6286,6288,6360,39193,39197,39198,39199,39207,39208,39210,39212,39237,39238,
   39239,39247,39248,39250,39252,39388,39389,39397,39398,39400,39402,39424,39432,39433,39435,39437,
   39466,39467,39469,39471,39703,39705,39707,39730,39732,39779,40918,40919,40920,40928,40929,40931,
   40933,41069,41070,41078,41079,41081,41083,41105,41113,41114,41116,41118,41147,41148,41150,41152,
   41384,41386,41388,41411,41413,41460,41849,41850,41858,41859,41861,41863,41885,41893,41894,41896,
   41898,41927,41928,41930,41932,42164,42166,42168,42191,42193,42240,44625,44633,44634,44636,44638,
   44667,44668,44670,44672,44904,44906,44908,44931,44933,44980,45262,45263,45265,45267,45499,45501,
   45503,45526,45528,45575,46060,46062,46064,46087,46089,46136,49471,49473,49520,49820],
 [5690,5691,5695,5696,5697,5705,5706,5708,5710,5774,5788,5828,5978,5979,6005,6013,6016,6018,6047,
   6050,6052,6284,6286,6288,6360,39193,39197,39198,39199,39207,39208,39210,39212,39237,39238,
   39239,39247,39248,39250,39252,39388,39389,39397,39398,39400,39402,39424,39432,39433,39435,39437,
   39466,39467,39469,39471,39703,39705,39707,39730,39732,39779,40918,40919,40920,40928,40929,40931,
   40933,41069,41070,41078,41079,41081,41083,41105,41113,41114,41116,41118,41147,41148,41150,41152,
   41384,41386,41388,41411,41413,41460,41849,41850,41858,41859,41861,41863,41885,41893,41894,41896,
   41898,41927,41928,41930,41932,42164,42166,42168,42191,42193,42240,44625,44633,44634,44636,44638,
   44667,44668,44670,44672,44904,44906,44908,44931,44933,44980,45262,45263,45265,45267,45499,45501,
   45503,45526,45528,45575,46060,46062,46064,46087,46089,46136,49471,49473,49520,49820],
 [5690,5691,5695,5696,5697,5705,5706,5708,5710,5774,5788,5828,5978,5979,6005,6013,6016,6018,6047,
   6050,6052,6284,6286,6288,6360,39193,39197,39198,39199,39207,39208,39210,39212,39237,39238,
   39239,39247,39248,39250,39252,39388,39389,39397,39398,39400,39402,39424,39432,39433,39435,39437,
   39466,39467,39469,39471,39703,39705,39707,39730,39732,39779,40918,40919,40920,40928,40929,40931,
   40933,41069,41070,41078,41079,41081,41083,41105,41113,41114,41116,41118,41147,41148,41150,41152,
   41384,41386,41388,41411,41413,41460,41849,41850,41858,41859,41861,41863,41885,41893,41894,41896,
   41898,41927,41928,41930,41932,42164,42166,42168,42191,42193,42240,44625,44633,44634,44636,44638,
   44667,44668,44670,44672,44904,44906,44908,44931,44933,44980,45262,45263,45265,45267,45499,45501,
   45503,45526,45528,45575,46060,46062,46064,46087,46089,46136,49471,49473,49520,49820],
 [5690,5691,5698,5705,5711,5774,5788,5828,6080,6086,6289,39193,39200,39207,39213,39240,39247,
   39253,39499,39505,39708,40921,40928,40934,41180,41186,41389,41960,41966,42169,46593],
 [5690,5691,5699,5705,5712,5774,5788,5828,6112,6119,6290,39193,39201,39207,39214,39241,39247,
   39254,39531,39538,39709,40922,40928,40935,41212,41219,41390,41992,41999,42170,47090],
 [5690,5691,5700,5701,5705,5714,5715,5774,5788,5828,6143,6152,6173,6183,6292,6293,39193,39202,
   39203,39207,39216,39217,39242,39243,39247,39256,39257,39558,39562,39571,39572,39592,39601,39602,
   39711,39712,39901,40923,40924,40928,40937,40938,41239,41253,41283,41582,42019,42062,42063,42362,
   47448,47557,47993,48182],[5690,5691,5700,5701,5705,5714,5715,5774,5788,5828,6143,6152,6173,
   6183,6292,6293,39193,39202,39203,39207,39216,39217,39242,39243,39247,39256,39257,39558,39562,
   39571,39572,39592,39601,39602,39711,39712,39901,40923,40924,40928,40937,40938,41239,41253,41283,
   41582,42019,42062,42063,42362,47448,47557,47993,48182],
 [5690,5691,5702,5705,5716,5774,5788,5828,6202,6213,6294,39193,39204,39207,39218,39244,39247,
   39258,39621,39632,39713,40925,40928,40939,48400],
 [5690,5691,5703,5704,5705,5774,5788,5828,6230,6257,39193,39205,39206,39207,39245,39246,39247,
   39648,39649,39676,40926,40927,40928,41329,42109],
 [5690,5691,5703,5704,5705,5774,5788,5828,6230,6257,39193,39205,39206,39207,39245,39246,39247,
   39648,39649,39676,40926,40927,40928,41329,42109],[5705,39193],
 [5690,5691,5695,5696,5697,5705,5706,5708,5710,5774,5788,5828,5978,5979,6005,6013,6016,6018,6047,
   6050,6052,6284,6286,6288,6360,39193,39197,39198,39199,39207,39208,39210,39212,39237,39238,
   39239,39247,39248,39250,39252,39388,39389,39397,39398,39400,39402,39424,39432,39433,39435,39437,
   39466,39467,39469,39471,39703,39705,39707,39730,39732,39779,40918,40919,40920,40928,40929,40931,
   40933,41069,41070,41078,41079,41081,41083,41105,41113,41114,41116,41118,41147,41148,41150,41152,
   41384,41386,41388,41411,41413,41460,41849,41850,41858,41859,41861,41863,41885,41893,41894,41896,
   41898,41927,41928,41930,41932,42164,42166,42168,42191,42193,42240,44625,44633,44634,44636,44638,
   44667,44668,44670,44672,44904,44906,44908,44931,44933,44980,45262,45263,45265,45267,45499,45501,
   45503,45526,45528,45575,46060,46062,46064,46087,46089,46136,49471,49473,49520,49820],
 [5690,5691,5705,5707,5713,5774,5788,5828,6285,6291,6340,39193,39207,39209,39215,39247,39249,
   39255,39704,39710,39759,40928,40930,40936,41440,42220,49500],
 [5690,5691,5695,5696,5697,5705,5706,5708,5710,5774,5788,5828,5978,5979,6005,6013,6016,6018,6047,
   6050,6052,6284,6286,6288,6360,39193,39197,39198,39199,39207,39208,39210,39212,39237,39238,
   39239,39247,39248,39250,39252,39388,39389,39397,39398,39400,39402,39424,39432,39433,39435,39437,
   39466,39467,39469,39471,39703,39705,39707,39730,39732,39779,40918,40919,40920,40928,40929,40931,
   40933,41069,41070,41078,41079,41081,41083,41105,41113,41114,41116,41118,41147,41148,41150,41152,
   41384,41386,41388,41411,41413,41460,41849,41850,41858,41859,41861,41863,41885,41893,41894,41896,
   41898,41927,41928,41930,41932,42164,42166,42168,42191,42193,42240,44625,44633,44634,44636,44638,
   44667,44668,44670,44672,44904,44906,44908,44931,44933,44980,45262,45263,45265,45267,45499,45501,
   45503,45526,45528,45575,46060,46062,46064,46087,46089,46136,49471,49473,49520,49820],
 [5690,5691,5705,5709,5774,5788,5828,6287,39193,39207,39211,39247,39251,39706,40928,40932],
 [5690,5691,5695,5696,5697,5705,5706,5708,5710,5774,5788,5828,5978,5979,6005,6013,6016,6018,6047,
   6050,6052,6284,6286,6288,6360,39193,39197,39198,39199,39207,39208,39210,39212,39237,39238,
   39239,39247,39248,39250,39252,39388,39389,39397,39398,39400,39402,39424,39432,39433,39435,39437,
   39466,39467,39469,39471,39703,39705,39707,39730,39732,39779,40918,40919,40920,40928,40929,40931,
   40933,41069,41070,41078,41079,41081,41083,41105,41113,41114,41116,41118,41147,41148,41150,41152,
   41384,41386,41388,41411,41413,41460,41849,41850,41858,41859,41861,41863,41885,41893,41894,41896,
   41898,41927,41928,41930,41932,42164,42166,42168,42191,42193,42240,44625,44633,44634,44636,44638,
   44667,44668,44670,44672,44904,44906,44908,44931,44933,44980,45262,45263,45265,45267,45499,45501,
   45503,45526,45528,45575,46060,46062,46064,46087,46089,46136,49471,49473,49520,49820],
 [5690,5691,5698,5705,5711,5774,5788,5828,6080,6086,6289,39193,39200,39207,39213,39240,39247,
   39253,39499,39505,39708,40921,40928,40934,41180,41186,41389,41960,41966,42169,46593],
 [5690,5691,5699,5705,5712,5774,5788,5828,6112,6119,6290,39193,39201,39207,39214,39241,39247,
   39254,39531,39538,39709,40922,40928,40935,41212,41219,41390,41992,41999,42170,47090],
 [5690,5691,5705,5707,5713,5774,5788,5828,6285,6291,6340,39193,39207,39209,39215,39247,39249,
   39255,39704,39710,39759,40928,40930,40936,41440,42220,49500],
 [5690,5691,5700,5701,5705,5714,5715,5774,5788,5828,6143,6152,6173,6183,6292,6293,39193,39202,
   39203,39207,39216,39217,39242,39243,39247,39256,39257,39558,39562,39571,39572,39592,39601,39602,
   39711,39712,39901,40923,40924,40928,40937,40938,41239,41253,41283,41582,42019,42062,42063,42362,
   47448,47557,47993,48182],[5690,5691,5700,5701,5705,5714,5715,5774,5788,5828,6143,6152,6173,
   6183,6292,6293,39193,39202,39203,39207,39216,39217,39242,39243,39247,39256,39257,39558,39562,
   39571,39572,39592,39601,39602,39711,39712,39901,40923,40924,40928,40937,40938,41239,41253,41283,
   41582,42019,42062,42063,42362,47448,47557,47993,48182],
 [5690,5691,5702,5705,5716,5774,5788,5828,6202,6213,6294,39193,39204,39207,39218,39244,39247,
   39258,39621,39632,39713,40925,40928,40939,48400],
 [5690,5691,5705,5717,5774,5788,5828,6295,39193,39207,39219,39247,39259,39714,40928,40940],
 [5690,5691,5705,5718,5774,5788,5828,6296,39193,39207,39220,39247,39260,39715,40928,40941],
 [5690,5691,5705,5719,5774,5788,5828,6297,39193,39207,39221,39247,39261,39716,40928,40942],
 [5690,5691,5705,5720,5721,5774,5788,5828,6298,6299,39193,39207,39222,39223,39247,39262,39263,
   39717,39718,39988,40928,40943,40944,41669,42449],
 [5690,5691,5705,5720,5721,5774,5788,5828,6298,6299,39193,39207,39222,39223,39247,39262,39263,
   39717,39718,39988,40928,40943,40944,41669,42449],
 [5690,5691,5705,5722,5774,5788,5828,6300,39193,39207,39224,39247,39264,39719,40928,40945],
 [5690,5691,5705,5723,5774,5788,5828,6301,39193,39207,39225,39247,39265,39720,40928,40946],
 [5690,5691,5705,5724,5774,5788,5828,6302,39193,39207,39226,39247,39266,39721,40928,40947],
 [5690,5691,5705,5725,5726,5774,5788,5828,6303,6304,39193,39207,39227,39228,39247,39267,39268,
   39722,39723,40033,40928,40948,40949,41714,42494],
 [5690,5691,5705,5725,5726,5774,5788,5828,6303,6304,39193,39207,39227,39228,39247,39267,39268,
   39722,39723,40033,40928,40948,40949,41714,42494],
 [5690,5691,5705,5727,5774,5788,5828,6305,39193,39207,39229,39247,39269,39724,40928,40950],
 [5690,5691,5705,5728,5774,5788,5828,6306,39193,39207,39230,39247,39270,39725,40928,40951],
 [5690,5691,5705,5729,5774,5788,5828,6307,39193,39207,39231,39247,39271,39726,40928,40952],
 [5690,5691,5705,5730,5774,5788,5828,6308,39193,39207,39232,39247,39272,39727,40928,40953],
 [5690,5691,5705,5731,5774,5788,5828,6309,39193,39207,39233,39247,39273,39728,40928,40954],
 [5692,5693,5694,5705,5867,5894,5905,5942,39274,39275,39286,39313,39324,39361,42515,43266],
 [5692,5693,5694,5705,5867,5894,5905,5942,39274,39275,39286,39313,39324,39361,42515,43266],
 [5692,5695,5699,5705,5706,5712,5867,5978,5979,6112,6119,6284,6290,39286,39397,39398,39531,39538,
   39703,39709,42593,42599,42600,42606,42733,42734,42740,42905,42911,42936,44732,44733,44739,44904,
   44910,44935,47084,47090,47115,49475],[6018,42639],[6050,42671],
 [5692,5698,5705,5711,5867,6080,6086,6289,39286,39499,39505,39708,42701,42707,42910,46593],
 [5692,5695,5699,5705,5706,5712,5867,5978,5979,6112,6119,6284,6290,39286,39397,39398,39531,39538,
   39703,39709,42593,42599,42600,42606,42733,42734,42740,42905,42911,42936,44732,44733,44739,44904,
   44910,44935,47084,47090,47115,49475],[6152,6213,42761,43104],[6183,42804],
 [6152,6213,42761,43104],[],[],[5705],
 [5692,5695,5699,5705,5706,5712,5867,5978,5979,6112,6119,6284,6290,39286,39397,39398,39531,39538,
   39703,39709,42593,42599,42600,42606,42733,42734,42740,42905,42911,42936,44732,44733,44739,44904,
   44910,44935,47084,47090,47115,49475],[6340,42961],[6050,42671],[],[6018,42639],
 [5692,5698,5705,5711,5867,6080,6086,6289,39286,39499,39505,39708,42701,42707,42910,46593],
 [5692,5695,5699,5705,5706,5712,5867,5978,5979,6112,6119,6284,6290,39286,39397,39398,39531,39538,
   39703,39709,42593,42599,42600,42606,42733,42734,42740,42905,42911,42936,44732,44733,44739,44904,
   44910,44935,47084,47090,47115,49475],[6340,42961],[6152,6213,42761,43104],[6183,42804],
 [6152,6213,42761,43104],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[5705,39313],[5693,5694,5695,5705,5706,5894,5905,5942,5978,5979,6284,39313,39314,39324,
   39325,39351,39361,39362,39397,39398,39703,43256,43266,43267,43302,43303,43608,43968,43969,44274,
   44904],[5693,5694,5696,5697,5698,5705,5708,5710,5711,5894,5905,5942,6005,6013,6016,6018,
   6047,6050,6052,6080,6086,6286,6288,6289,6360,39313,39315,39316,39317,39324,39327,39329,39330,
   39352,39353,39354,39361,39364,39366,39367,39424,39425,39432,39435,39437,39438,39459,39466,39469,
   39471,39472,39499,39502,39504,39505,39705,39707,39708,39779,39780,39823,43257,43258,43259,43266,
   43269,43271,43272,43329,43330,43337,43340,43342,43343,43364,43371,43374,43376,43377,43404,43407,
   43409,43410,43610,43612,43613,43684,43685,43728,43995,43996,44003,44006,44008,44009,44030,44037,
   44040,44042,44043,44070,44073,44075,44076,44276,44278,44279,44350,44351,44394,45255,45262,45265,
   45267,45268,45295,45298,45300,45301,45501,45503,45504,45575,45576,45619,45856,45859,45861,45862,
   46062,46064,46065,46136,46137,46180,46590,46592,46593,46664,46665,46708,49520,49521,49564,50393]
  ,[5693,5694,5696,5697,5698,5705,5708,5710,5711,5894,5905,5942,6005,6013,6016,6018,6047,6050,
   6052,6080,6086,6286,6288,6289,6360,39313,39315,39316,39317,39324,39327,39329,39330,39352,39353,
   39354,39361,39364,39366,39367,39424,39425,39432,39435,39437,39438,39459,39466,39469,39471,39472,
   39499,39502,39504,39505,39705,39707,39708,39779,39780,39823,43257,43258,43259,43266,43269,43271,
   43272,43329,43330,43337,43340,43342,43343,43364,43371,43374,43376,43377,43404,43407,43409,43410,
   43610,43612,43613,43684,43685,43728,43995,43996,44003,44006,44008,44009,44030,44037,44040,44042,
   44043,44070,44073,44075,44076,44276,44278,44279,44350,44351,44394,45255,45262,45265,45267,45268,
   45295,45298,45300,45301,45501,45503,45504,45575,45576,45619,45856,45859,45861,45862,46062,46064,
   46065,46136,46137,46180,46590,46592,46593,46664,46665,46708,49520,49521,49564,50393],
 [5693,5694,5696,5697,5698,5705,5708,5710,5711,5894,5905,5942,6005,6013,6016,6018,6047,6050,6052,
   6080,6086,6286,6288,6289,6360,39313,39315,39316,39317,39324,39327,39329,39330,39352,39353,
   39354,39361,39364,39366,39367,39424,39425,39432,39435,39437,39438,39459,39466,39469,39471,39472,
   39499,39502,39504,39505,39705,39707,39708,39779,39780,39823,43257,43258,43259,43266,43269,43271,
   43272,43329,43330,43337,43340,43342,43343,43364,43371,43374,43376,43377,43404,43407,43409,43410,
   43610,43612,43613,43684,43685,43728,43995,43996,44003,44006,44008,44009,44030,44037,44040,44042,
   44043,44070,44073,44075,44076,44276,44278,44279,44350,44351,44394,45255,45262,45265,45267,45268,
   45295,45298,45300,45301,45501,45503,45504,45575,45576,45619,45856,45859,45861,45862,46062,46064,
   46065,46136,46137,46180,46590,46592,46593,46664,46665,46708,49520,49521,49564,50393],
 [5693,5694,5699,5705,5712,5894,5905,5942,6112,6119,6290,39313,39318,39324,39331,39355,39361,
   39368,39531,39538,39709,43260,43266,43273,43436,43443,43614,44102,44109,44280,47090],
 [5693,5694,5700,5705,5714,5894,5905,5942,6143,6152,6292,39313,39319,39324,39333,39356,39361,
   39370,39562,39571,39711,43261,43266,43275,47557],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,3501,3505,3506,3507,3513,
   3514,3517,3518,3527,3528,3544,3548,3549,3550,3556,3557,3560,3561,3570,3571,3590,3591,3592,
   3598,3599,3602,3603,3612,3613,3749,3750,3756,3757,3770,3771,3787,3793,3794,3829,3830,3833,
   3834,3843,3844,4025,4038,4039,4139,4354,4510,4511,4512,4518,4528,4529,5645,5646,5650,5651,
   5652,5658,5659,5662,5663,5672,5673,5689,5693,5694,5695,5701,5702,5705,5706,5715,5716,5735,
   5736,5737,5743,5744,5747,5748,5757,5758,5894,5902,5905,5916,5939,5942,5953,5978,5979,6170,
   6173,6183,6184,6202,6212,6213,6284,6293,6294,6499,7725,7726,7730,7731,7732,7738,7739,7742,
   7743,7752,7753,7769,7773,7774,7775,7781,7782,7785,7786,7795,7796,7815,7816,7817,7823,7824,
   7827,7828,7837,7838,7974,7986,7995,7996,8018,8019,8023,8032,8033,8058,8059,8250,8254,8263,
   8283,8292,8364,8398,8399,8579,38205,38209,38210,38211,38217,38218,38221,38222,38231,38232,
   38251,38252,38253,38259,38260,38263,38264,38273,38274,38410,38411,38417,38418,38431,38432,38448,
   38454,38455,38468,38469,38490,38491,38494,38495,38504,38505,38686,38699,38700,38728,38729,38800,
   39015,39154,39155,39156,39162,39163,39166,39167,39176,39177,39313,39320,39321,39324,39334,39335,
   39357,39358,39361,39371,39372,39397,39398,39589,39592,39602,39603,39621,39631,39632,39703,39712,
   39713,39918,40174,40181,40182,40186,40195,40196,40218,40219,40223,40232,40233,40258,40259,40450,
   40454,40463,40464,40483,40492,40493,40564,40598,40599,40779,43262,43263,43266,43276,43277,43298,
   43494,43507,43508,43536,43537,43643,43823,43965,44160,44173,44174,44202,44203,44308,44489,44904,
   45119,47903,47912,47913,47993,48199,48400,48605],
 [5693,5694,5702,5705,5716,5894,5905,5942,6202,6213,6294,39313,39321,39324,39335,39358,39361,
   39372,39621,39632,39713,43263,43266,43277,48400],
 [5693,5694,5703,5705,5894,5905,5942,6230,39313,39322,39324,39359,39361,39649,43264,43266],
 [5693,5694,5704,5705,5894,5905,5942,6257,39313,39323,39324,39360,39361,39676,43265,43266],
 [5705,39313],[5693,5694,5695,5705,5706,5894,5905,5942,5978,5979,6284,39313,39314,39324,39325,
   39351,39361,39362,39397,39398,39703,43256,43266,43267,43302,43303,43608,43968,43969,44274,44904]
  ,[5693,5694,5705,5707,5713,5894,5905,5942,6285,6291,6340,39313,39324,39326,39332,39361,39363,
   39369,39704,39710,39759,43266,43268,43274,43664,44330,49500],
 [5693,5694,5696,5697,5698,5705,5708,5710,5711,5894,5905,5942,6005,6013,6016,6018,6047,6050,6052,
   6080,6086,6286,6288,6289,6360,39313,39315,39316,39317,39324,39327,39329,39330,39352,39353,
   39354,39361,39364,39366,39367,39424,39425,39432,39435,39437,39438,39459,39466,39469,39471,39472,
   39499,39502,39504,39505,39705,39707,39708,39779,39780,39823,43257,43258,43259,43266,43269,43271,
   43272,43329,43330,43337,43340,43342,43343,43364,43371,43374,43376,43377,43404,43407,43409,43410,
   43610,43612,43613,43684,43685,43728,43995,43996,44003,44006,44008,44009,44030,44037,44040,44042,
   44043,44070,44073,44075,44076,44276,44278,44279,44350,44351,44394,45255,45262,45265,45267,45268,
   45295,45298,45300,45301,45501,45503,45504,45575,45576,45619,45856,45859,45861,45862,46062,46064,
   46065,46136,46137,46180,46590,46592,46593,46664,46665,46708,49520,49521,49564,50393],
 [5693,5694,5705,5709,5894,5905,5942,6287,39313,39324,39328,39361,39365,39706,43266,43270],
 [5693,5694,5696,5697,5698,5705,5708,5710,5711,5894,5905,5942,6005,6013,6016,6018,6047,6050,6052,
   6080,6086,6286,6288,6289,6360,39313,39315,39316,39317,39324,39327,39329,39330,39352,39353,
   39354,39361,39364,39366,39367,39424,39425,39432,39435,39437,39438,39459,39466,39469,39471,39472,
   39499,39502,39504,39505,39705,39707,39708,39779,39780,39823,43257,43258,43259,43266,43269,43271,
   43272,43329,43330,43337,43340,43342,43343,43364,43371,43374,43376,43377,43404,43407,43409,43410,
   43610,43612,43613,43684,43685,43728,43995,43996,44003,44006,44008,44009,44030,44037,44040,44042,
   44043,44070,44073,44075,44076,44276,44278,44279,44350,44351,44394,45255,45262,45265,45267,45268,
   45295,45298,45300,45301,45501,45503,45504,45575,45576,45619,45856,45859,45861,45862,46062,46064,
   46065,46136,46137,46180,46590,46592,46593,46664,46665,46708,49520,49521,49564,50393],
 [5693,5694,5696,5697,5698,5705,5708,5710,5711,5894,5905,5942,6005,6013,6016,6018,6047,6050,6052,
   6080,6086,6286,6288,6289,6360,39313,39315,39316,39317,39324,39327,39329,39330,39352,39353,
   39354,39361,39364,39366,39367,39424,39425,39432,39435,39437,39438,39459,39466,39469,39471,39472,
   39499,39502,39504,39505,39705,39707,39708,39779,39780,39823,43257,43258,43259,43266,43269,43271,
   43272,43329,43330,43337,43340,43342,43343,43364,43371,43374,43376,43377,43404,43407,43409,43410,
   43610,43612,43613,43684,43685,43728,43995,43996,44003,44006,44008,44009,44030,44037,44040,44042,
   44043,44070,44073,44075,44076,44276,44278,44279,44350,44351,44394,45255,45262,45265,45267,45268,
   45295,45298,45300,45301,45501,45503,45504,45575,45576,45619,45856,45859,45861,45862,46062,46064,
   46065,46136,46137,46180,46590,46592,46593,46664,46665,46708,49520,49521,49564,50393],
 [5693,5694,5699,5705,5712,5894,5905,5942,6112,6119,6290,39313,39318,39324,39331,39355,39361,
   39368,39531,39538,39709,43260,43266,43273,43436,43443,43614,44102,44109,44280,47090],
 [5693,5694,5705,5707,5713,5894,5905,5942,6285,6291,6340,39313,39324,39326,39332,39361,39363,
   39369,39704,39710,39759,43266,43268,43274,43664,44330,49500],
 [5693,5694,5700,5705,5714,5894,5905,5942,6143,6152,6292,39313,39319,39324,39333,39356,39361,
   39370,39562,39571,39711,43261,43266,43275,47557],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,3501,3505,3506,3507,3513,
   3514,3517,3518,3527,3528,3544,3548,3549,3550,3556,3557,3560,3561,3570,3571,3590,3591,3592,
   3598,3599,3602,3603,3612,3613,3749,3750,3756,3757,3770,3771,3787,3793,3794,3829,3830,3833,
   3834,3843,3844,4025,4038,4039,4139,4354,4510,4511,4512,4518,4528,4529,5645,5646,5650,5651,
   5652,5658,5659,5662,5663,5672,5673,5689,5693,5694,5695,5701,5702,5705,5706,5715,5716,5735,
   5736,5737,5743,5744,5747,5748,5757,5758,5894,5902,5905,5916,5939,5942,5953,5978,5979,6170,
   6173,6183,6184,6202,6212,6213,6284,6293,6294,6499,7725,7726,7730,7731,7732,7738,7739,7742,
   7743,7752,7753,7769,7773,7774,7775,7781,7782,7785,7786,7795,7796,7815,7816,7817,7823,7824,
   7827,7828,7837,7838,7974,7986,7995,7996,8018,8019,8023,8032,8033,8058,8059,8250,8254,8263,
   8283,8292,8364,8398,8399,8579,38205,38209,38210,38211,38217,38218,38221,38222,38231,38232,
   38251,38252,38253,38259,38260,38263,38264,38273,38274,38410,38411,38417,38418,38431,38432,38448,
   38454,38455,38468,38469,38490,38491,38494,38495,38504,38505,38686,38699,38700,38728,38729,38800,
   39015,39154,39155,39156,39162,39163,39166,39167,39176,39177,39313,39320,39321,39324,39334,39335,
   39357,39358,39361,39371,39372,39397,39398,39589,39592,39602,39603,39621,39631,39632,39703,39712,
   39713,39918,40174,40181,40182,40186,40195,40196,40218,40219,40223,40232,40233,40258,40259,40450,
   40454,40463,40464,40483,40492,40493,40564,40598,40599,40779,43262,43263,43266,43276,43277,43298,
   43494,43507,43508,43536,43537,43643,43823,43965,44160,44173,44174,44202,44203,44308,44489,44904,
   45119,47903,47912,47913,47993,48199,48400,48605],
 [5693,5694,5702,5705,5716,5894,5905,5942,6202,6213,6294,39313,39321,39324,39335,39358,39361,
   39372,39621,39632,39713,43263,43266,43277,48400],
 [5693,5694,5705,5717,5894,5905,5942,6295,39313,39324,39336,39361,39373,39714,43266,43278],
 [5693,5694,5705,5718,5894,5905,5942,6296,39313,39324,39337,39361,39374,39715,43266,43279],
 [5693,5694,5705,5719,5894,5905,5942,6297,39313,39324,39338,39361,39375,39716,43266,43280],
 [5693,5694,5705,5720,5894,5905,5942,6298,39313,39324,39339,39361,39376,39717,43266,43281],
 [5693,5694,5705,5721,5894,5905,5942,6299,39313,39324,39340,39361,39377,39718,43266,43282],
 [5693,5694,5705,5722,5894,5905,5942,6300,39313,39324,39341,39361,39378,39719,43266,43283],
 [5693,5694,5705,5723,5894,5905,5942,6301,39313,39324,39342,39361,39379,39720,43266,43284],
 [5693,5694,5705,5724,5894,5905,5942,6302,39313,39324,39343,39361,39380,39721,43266,43285],
 [5693,5694,5705,5725,5894,5905,5942,6303,39313,39324,39344,39361,39381,39722,43266,43286],
 [5693,5694,5705,5726,5894,5905,5942,6304,39313,39324,39345,39361,39382,39723,43266,43287],
 [5693,5694,5705,5727,5894,5905,5942,6305,39313,39324,39346,39361,39383,39724,43266,43288],
 [5693,5694,5705,5728,5894,5905,5942,6306,39313,39324,39347,39361,39384,39725,43266,43289],
 [5693,5694,5705,5729,5894,5905,5942,6307,39313,39324,39348,39361,39385,39726,43266,43290],
 [5693,5694,5705,5730,5894,5905,5942,6308,39313,39324,39349,39361,39386,39727,43266,43291],
 [5693,5694,5705,5731,5894,5905,5942,6309,39313,39324,39350,39361,39387,39728,43266,43292],
 [5693,5694,5695,5705,5706,5894,5905,5942,5978,5979,6284,39313,39314,39324,39325,39351,39361,
   39362,39397,39398,39703,43256,43266,43267,43302,43303,43608,43968,43969,44274,44904],
 [5693,5694,5696,5697,5698,5705,5708,5710,5711,5894,5905,5942,6005,6013,6016,6018,6047,6050,6052,
   6080,6086,6286,6288,6289,6360,39313,39315,39316,39317,39324,39327,39329,39330,39352,39353,
   39354,39361,39364,39366,39367,39424,39425,39432,39435,39437,39438,39459,39466,39469,39471,39472,
   39499,39502,39504,39505,39705,39707,39708,39779,39780,39823,43257,43258,43259,43266,43269,43271,
   43272,43329,43330,43337,43340,43342,43343,43364,43371,43374,43376,43377,43404,43407,43409,43410,
   43610,43612,43613,43684,43685,43728,43995,43996,44003,44006,44008,44009,44030,44037,44040,44042,
   44043,44070,44073,44075,44076,44276,44278,44279,44350,44351,44394,45255,45262,45265,45267,45268,
   45295,45298,45300,45301,45501,45503,45504,45575,45576,45619,45856,45859,45861,45862,46062,46064,
   46065,46136,46137,46180,46590,46592,46593,46664,46665,46708,49520,49521,49564,50393],
 [5693,5694,5696,5697,5698,5705,5708,5710,5711,5894,5905,5942,6005,6013,6016,6018,6047,6050,6052,
   6080,6086,6286,6288,6289,6360,39313,39315,39316,39317,39324,39327,39329,39330,39352,39353,
   39354,39361,39364,39366,39367,39424,39425,39432,39435,39437,39438,39459,39466,39469,39471,39472,
   39499,39502,39504,39505,39705,39707,39708,39779,39780,39823,43257,43258,43259,43266,43269,43271,
   43272,43329,43330,43337,43340,43342,43343,43364,43371,43374,43376,43377,43404,43407,43409,43410,
   43610,43612,43613,43684,43685,43728,43995,43996,44003,44006,44008,44009,44030,44037,44040,44042,
   44043,44070,44073,44075,44076,44276,44278,44279,44350,44351,44394,45255,45262,45265,45267,45268,
   45295,45298,45300,45301,45501,45503,45504,45575,45576,45619,45856,45859,45861,45862,46062,46064,
   46065,46136,46137,46180,46590,46592,46593,46664,46665,46708,49520,49521,49564,50393],
 [5693,5694,5696,5697,5698,5705,5708,5710,5711,5894,5905,5942,6005,6013,6016,6018,6047,6050,6052,
   6080,6086,6286,6288,6289,6360,39313,39315,39316,39317,39324,39327,39329,39330,39352,39353,
   39354,39361,39364,39366,39367,39424,39425,39432,39435,39437,39438,39459,39466,39469,39471,39472,
   39499,39502,39504,39505,39705,39707,39708,39779,39780,39823,43257,43258,43259,43266,43269,43271,
   43272,43329,43330,43337,43340,43342,43343,43364,43371,43374,43376,43377,43404,43407,43409,43410,
   43610,43612,43613,43684,43685,43728,43995,43996,44003,44006,44008,44009,44030,44037,44040,44042,
   44043,44070,44073,44075,44076,44276,44278,44279,44350,44351,44394,45255,45262,45265,45267,45268,
   45295,45298,45300,45301,45501,45503,45504,45575,45576,45619,45856,45859,45861,45862,46062,46064,
   46065,46136,46137,46180,46590,46592,46593,46664,46665,46708,49520,49521,49564,50393],
 [5693,5694,5699,5705,5712,5894,5905,5942,6112,6119,6290,39313,39318,39324,39331,39355,39361,
   39368,39531,39538,39709,43260,43266,43273,43436,43443,43614,44102,44109,44280,47090],
 [5693,5694,5700,5705,5714,5894,5905,5942,6143,6152,6292,39313,39319,39324,39333,39356,39361,
   39370,39562,39571,39711,43261,43266,43275,47557],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,3501,3505,3506,3507,3513,
   3514,3517,3518,3527,3528,3544,3548,3549,3550,3556,3557,3560,3561,3570,3571,3590,3591,3592,
   3598,3599,3602,3603,3612,3613,3749,3750,3756,3757,3770,3771,3787,3793,3794,3829,3830,3833,
   3834,3843,3844,4025,4038,4039,4139,4354,4510,4511,4512,4518,4528,4529,5645,5646,5650,5651,
   5652,5658,5659,5662,5663,5672,5673,5689,5693,5694,5695,5701,5702,5705,5706,5715,5716,5735,
   5736,5737,5743,5744,5747,5748,5757,5758,5894,5902,5905,5916,5939,5942,5953,5978,5979,6170,
   6173,6183,6184,6202,6212,6213,6284,6293,6294,6499,7725,7726,7730,7731,7732,7738,7739,7742,
   7743,7752,7753,7769,7773,7774,7775,7781,7782,7785,7786,7795,7796,7815,7816,7817,7823,7824,
   7827,7828,7837,7838,7974,7986,7995,7996,8018,8019,8023,8032,8033,8058,8059,8250,8254,8263,
   8283,8292,8364,8398,8399,8579,38205,38209,38210,38211,38217,38218,38221,38222,38231,38232,
   38251,38252,38253,38259,38260,38263,38264,38273,38274,38410,38411,38417,38418,38431,38432,38448,
   38454,38455,38468,38469,38490,38491,38494,38495,38504,38505,38686,38699,38700,38728,38729,38800,
   39015,39154,39155,39156,39162,39163,39166,39167,39176,39177,39313,39320,39321,39324,39334,39335,
   39357,39358,39361,39371,39372,39397,39398,39589,39592,39602,39603,39621,39631,39632,39703,39712,
   39713,39918,40174,40181,40182,40186,40195,40196,40218,40219,40223,40232,40233,40258,40259,40450,
   40454,40463,40464,40483,40492,40493,40564,40598,40599,40779,43262,43263,43266,43276,43277,43298,
   43494,43507,43508,43536,43537,43643,43823,43965,44160,44173,44174,44202,44203,44308,44489,44904,
   45119,47903,47912,47913,47993,48199,48400,48605],
 [5693,5694,5702,5705,5716,5894,5905,5942,6202,6213,6294,39313,39321,39324,39335,39358,39361,
   39372,39621,39632,39713,43263,43266,43277,48400],
 [5693,5694,5703,5705,5894,5905,5942,6230,39313,39322,39324,39359,39361,39649,43264,43266],
 [5693,5694,5704,5705,5894,5905,5942,6257,39313,39323,39324,39360,39361,39676,43265,43266],
 [5705,39313],[5693,5694,5695,5705,5706,5894,5905,5942,5978,5979,6284,39313,39314,39324,39325,
   39351,39361,39362,39397,39398,39703,43256,43266,43267,43302,43303,43608,43968,43969,44274,44904]
  ,[5693,5694,5705,5707,5713,5894,5905,5942,6285,6291,6340,39313,39324,39326,39332,39361,39363,
   39369,39704,39710,39759,43266,43268,43274,43664,44330,49500],
 [5693,5694,5696,5697,5698,5705,5708,5710,5711,5894,5905,5942,6005,6013,6016,6018,6047,6050,6052,
   6080,6086,6286,6288,6289,6360,39313,39315,39316,39317,39324,39327,39329,39330,39352,39353,
   39354,39361,39364,39366,39367,39424,39425,39432,39435,39437,39438,39459,39466,39469,39471,39472,
   39499,39502,39504,39505,39705,39707,39708,39779,39780,39823,43257,43258,43259,43266,43269,43271,
   43272,43329,43330,43337,43340,43342,43343,43364,43371,43374,43376,43377,43404,43407,43409,43410,
   43610,43612,43613,43684,43685,43728,43995,43996,44003,44006,44008,44009,44030,44037,44040,44042,
   44043,44070,44073,44075,44076,44276,44278,44279,44350,44351,44394,45255,45262,45265,45267,45268,
   45295,45298,45300,45301,45501,45503,45504,45575,45576,45619,45856,45859,45861,45862,46062,46064,
   46065,46136,46137,46180,46590,46592,46593,46664,46665,46708,49520,49521,49564,50393],
 [5693,5694,5705,5709,5894,5905,5942,6287,39313,39324,39328,39361,39365,39706,43266,43270],
 [5693,5694,5696,5697,5698,5705,5708,5710,5711,5894,5905,5942,6005,6013,6016,6018,6047,6050,6052,
   6080,6086,6286,6288,6289,6360,39313,39315,39316,39317,39324,39327,39329,39330,39352,39353,
   39354,39361,39364,39366,39367,39424,39425,39432,39435,39437,39438,39459,39466,39469,39471,39472,
   39499,39502,39504,39505,39705,39707,39708,39779,39780,39823,43257,43258,43259,43266,43269,43271,
   43272,43329,43330,43337,43340,43342,43343,43364,43371,43374,43376,43377,43404,43407,43409,43410,
   43610,43612,43613,43684,43685,43728,43995,43996,44003,44006,44008,44009,44030,44037,44040,44042,
   44043,44070,44073,44075,44076,44276,44278,44279,44350,44351,44394,45255,45262,45265,45267,45268,
   45295,45298,45300,45301,45501,45503,45504,45575,45576,45619,45856,45859,45861,45862,46062,46064,
   46065,46136,46137,46180,46590,46592,46593,46664,46665,46708,49520,49521,49564,50393],
 [5693,5694,5696,5697,5698,5705,5708,5710,5711,5894,5905,5942,6005,6013,6016,6018,6047,6050,6052,
   6080,6086,6286,6288,6289,6360,39313,39315,39316,39317,39324,39327,39329,39330,39352,39353,
   39354,39361,39364,39366,39367,39424,39425,39432,39435,39437,39438,39459,39466,39469,39471,39472,
   39499,39502,39504,39505,39705,39707,39708,39779,39780,39823,43257,43258,43259,43266,43269,43271,
   43272,43329,43330,43337,43340,43342,43343,43364,43371,43374,43376,43377,43404,43407,43409,43410,
   43610,43612,43613,43684,43685,43728,43995,43996,44003,44006,44008,44009,44030,44037,44040,44042,
   44043,44070,44073,44075,44076,44276,44278,44279,44350,44351,44394,45255,45262,45265,45267,45268,
   45295,45298,45300,45301,45501,45503,45504,45575,45576,45619,45856,45859,45861,45862,46062,46064,
   46065,46136,46137,46180,46590,46592,46593,46664,46665,46708,49520,49521,49564,50393],
 [5693,5694,5699,5705,5712,5894,5905,5942,6112,6119,6290,39313,39318,39324,39331,39355,39361,
   39368,39531,39538,39709,43260,43266,43273,43436,43443,43614,44102,44109,44280,47090],
 [5693,5694,5705,5707,5713,5894,5905,5942,6285,6291,6340,39313,39324,39326,39332,39361,39363,
   39369,39704,39710,39759,43266,43268,43274,43664,44330,49500],
 [5693,5694,5700,5705,5714,5894,5905,5942,6143,6152,6292,39313,39319,39324,39333,39356,39361,
   39370,39562,39571,39711,43261,43266,43275,47557],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,3501,3505,3506,3507,3513,
   3514,3517,3518,3527,3528,3544,3548,3549,3550,3556,3557,3560,3561,3570,3571,3590,3591,3592,
   3598,3599,3602,3603,3612,3613,3749,3750,3756,3757,3770,3771,3787,3793,3794,3829,3830,3833,
   3834,3843,3844,4025,4038,4039,4139,4354,4510,4511,4512,4518,4528,4529,5645,5646,5650,5651,
   5652,5658,5659,5662,5663,5672,5673,5689,5693,5694,5695,5701,5702,5705,5706,5715,5716,5735,
   5736,5737,5743,5744,5747,5748,5757,5758,5894,5902,5905,5916,5939,5942,5953,5978,5979,6170,
   6173,6183,6184,6202,6212,6213,6284,6293,6294,6499,7725,7726,7730,7731,7732,7738,7739,7742,
   7743,7752,7753,7769,7773,7774,7775,7781,7782,7785,7786,7795,7796,7815,7816,7817,7823,7824,
   7827,7828,7837,7838,7974,7986,7995,7996,8018,8019,8023,8032,8033,8058,8059,8250,8254,8263,
   8283,8292,8364,8398,8399,8579,38205,38209,38210,38211,38217,38218,38221,38222,38231,38232,
   38251,38252,38253,38259,38260,38263,38264,38273,38274,38410,38411,38417,38418,38431,38432,38448,
   38454,38455,38468,38469,38490,38491,38494,38495,38504,38505,38686,38699,38700,38728,38729,38800,
   39015,39154,39155,39156,39162,39163,39166,39167,39176,39177,39313,39320,39321,39324,39334,39335,
   39357,39358,39361,39371,39372,39397,39398,39589,39592,39602,39603,39621,39631,39632,39703,39712,
   39713,39918,40174,40181,40182,40186,40195,40196,40218,40219,40223,40232,40233,40258,40259,40450,
   40454,40463,40464,40483,40492,40493,40564,40598,40599,40779,43262,43263,43266,43276,43277,43298,
   43494,43507,43508,43536,43537,43643,43823,43965,44160,44173,44174,44202,44203,44308,44489,44904,
   45119,47903,47912,47913,47993,48199,48400,48605],
 [5693,5694,5702,5705,5716,5894,5905,5942,6202,6213,6294,39313,39321,39324,39335,39358,39361,
   39372,39621,39632,39713,43263,43266,43277,48400],
 [5693,5694,5705,5717,5894,5905,5942,6295,39313,39324,39336,39361,39373,39714,43266,43278],
 [5693,5694,5705,5718,5894,5905,5942,6296,39313,39324,39337,39361,39374,39715,43266,43279],
 [5693,5694,5705,5719,5894,5905,5942,6297,39313,39324,39338,39361,39375,39716,43266,43280],
 [5693,5694,5705,5720,5894,5905,5942,6298,39313,39324,39339,39361,39376,39717,43266,43281],
 [5693,5694,5705,5721,5894,5905,5942,6299,39313,39324,39340,39361,39377,39718,43266,43282],
 [5693,5694,5705,5722,5894,5905,5942,6300,39313,39324,39341,39361,39378,39719,43266,43283],
 [5693,5694,5705,5723,5894,5905,5942,6301,39313,39324,39342,39361,39379,39720,43266,43284],
 [5693,5694,5705,5724,5894,5905,5942,6302,39313,39324,39343,39361,39380,39721,43266,43285],
 [5693,5694,5705,5725,5894,5905,5942,6303,39313,39324,39344,39361,39381,39722,43266,43286],
 [5693,5694,5705,5726,5894,5905,5942,6304,39313,39324,39345,39361,39382,39723,43266,43287],
 [5693,5694,5705,5727,5894,5905,5942,6305,39313,39324,39346,39361,39383,39724,43266,43288],
 [5693,5694,5705,5728,5894,5905,5942,6306,39313,39324,39347,39361,39384,39725,43266,43289],
 [5693,5694,5705,5729,5894,5905,5942,6307,39313,39324,39348,39361,39385,39726,43266,43290],
 [5693,5694,5705,5730,5894,5905,5942,6308,39313,39324,39349,39361,39386,39727,43266,43291],
 [5693,5694,5705,5731,5894,5905,5942,6309,39313,39324,39350,39361,39387,39728,43266,43292],
 [5690,5691,5695,5696,5697,5705,5706,5708,5710,5774,5788,5828,5978,5979,6005,6013,6016,6018,6047,
   6050,6052,6284,6286,6288,6360,39193,39197,39198,39199,39207,39208,39210,39212,39237,39238,
   39239,39247,39248,39250,39252,39388,39389,39397,39398,39400,39402,39424,39432,39433,39435,39437,
   39466,39467,39469,39471,39703,39705,39707,39730,39732,39779,40918,40919,40920,40928,40929,40931,
   40933,41069,41070,41078,41079,41081,41083,41105,41113,41114,41116,41118,41147,41148,41150,41152,
   41384,41386,41388,41411,41413,41460,41849,41850,41858,41859,41861,41863,41885,41893,41894,41896,
   41898,41927,41928,41930,41932,42164,42166,42168,42191,42193,42240,44625,44633,44634,44636,44638,
   44667,44668,44670,44672,44904,44906,44908,44931,44933,44980,45262,45263,45265,45267,45499,45501,
   45503,45526,45528,45575,46060,46062,46064,46087,46089,46136,49471,49473,49520,49820],
 [5690,5691,5695,5696,5697,5705,5706,5708,5710,5774,5788,5828,5978,5979,6005,6013,6016,6018,6047,
   6050,6052,6284,6286,6288,6360,39193,39197,39198,39199,39207,39208,39210,39212,39237,39238,
   39239,39247,39248,39250,39252,39388,39389,39397,39398,39400,39402,39424,39432,39433,39435,39437,
   39466,39467,39469,39471,39703,39705,39707,39730,39732,39779,40918,40919,40920,40928,40929,40931,
   40933,41069,41070,41078,41079,41081,41083,41105,41113,41114,41116,41118,41147,41148,41150,41152,
   41384,41386,41388,41411,41413,41460,41849,41850,41858,41859,41861,41863,41885,41893,41894,41896,
   41898,41927,41928,41930,41932,42164,42166,42168,42191,42193,42240,44625,44633,44634,44636,44638,
   44667,44668,44670,44672,44904,44906,44908,44931,44933,44980,45262,45263,45265,45267,45499,45501,
   45503,45526,45528,45575,46060,46062,46064,46087,46089,46136,49471,49473,49520,49820],
 [5695,5698,5705,5706,5711,5978,5979,6080,6086,6284,6289,39397,39398,39499,39505,39703,39708,
   44700,44701,44706,44904,44909,44934,46588,46593,46618,49474],
 [5692,5695,5699,5705,5706,5712,5867,5978,5979,6112,6119,6284,6290,39286,39397,39398,39531,39538,
   39703,39709,42593,42599,42600,42606,42733,42734,42740,42905,42911,42936,44732,44733,44739,44904,
   44910,44935,47084,47090,47115,49475],[5695,5700,5705,5706,5707,5713,5714,5978,5979,6143,6152,
   6284,6285,6291,6292,6340,39397,39398,39562,39571,39703,39704,39710,39711,39759,44763,44764,
   44765,44904,44905,44911,44912,44930,44936,44937,44960,44961,45084,47549,47550,47556,47557,47575,
   47581,47605,49470,49476,49477,49500,49501,49624,49800,49924,50200],
 [5695,5701,5705,5706,5715,5978,5979,6173,6183,6284,6293,39397,39398,39592,39602,39703,39712,
   44793,44794,44803,44904,44913,44938,47984,47993,48018,49478],
 [5695,5702,5705,5706,5716,5978,5979,6202,6213,6284,6294,39397,39398,39621,39632,39703,39713,
   44822,44823,44904,44914,44939,48390,48400,49479],
 [5695,5703,5705,5706,5709,5978,5979,6230,6284,6287,39397,39398,39649,39703,39706,44850,44851,
   44854,44904,44907,44932,48768,48771,48796,49472],
 [5695,5704,5705,5706,5978,5979,6257,6284,39397,39398,39676,39703,44877,44878,44904,49119],
 [5705,44904],[5705,44904],[5695,5700,5705,5706,5707,5713,5714,5978,5979,6143,6152,6284,6285,
   6291,6292,6340,39397,39398,39562,39571,39703,39704,39710,39711,39759,44763,44764,44765,44904,
   44905,44911,44912,44930,44936,44937,44960,44961,45084,47549,47550,47556,47557,47575,47581,47605,
   49470,49476,49477,49500,49501,49624,49800,49924,50200],
 [5690,5691,5695,5696,5697,5705,5706,5708,5710,5774,5788,5828,5978,5979,6005,6013,6016,6018,6047,
   6050,6052,6284,6286,6288,6360,39193,39197,39198,39199,39207,39208,39210,39212,39237,39238,
   39239,39247,39248,39250,39252,39388,39389,39397,39398,39400,39402,39424,39432,39433,39435,39437,
   39466,39467,39469,39471,39703,39705,39707,39730,39732,39779,40918,40919,40920,40928,40929,40931,
   40933,41069,41070,41078,41079,41081,41083,41105,41113,41114,41116,41118,41147,41148,41150,41152,
   41384,41386,41388,41411,41413,41460,41849,41850,41858,41859,41861,41863,41885,41893,41894,41896,
   41898,41927,41928,41930,41932,42164,42166,42168,42191,42193,42240,44625,44633,44634,44636,44638,
   44667,44668,44670,44672,44904,44906,44908,44931,44933,44980,45262,45263,45265,45267,45499,45501,
   45503,45526,45528,45575,46060,46062,46064,46087,46089,46136,49471,49473,49520,49820],
 [5695,5703,5705,5706,5709,5978,5979,6230,6284,6287,39397,39398,39649,39703,39706,44850,44851,
   44854,44904,44907,44932,48768,48771,48796,49472],
 [5690,5691,5695,5696,5697,5705,5706,5708,5710,5774,5788,5828,5978,5979,6005,6013,6016,6018,6047,
   6050,6052,6284,6286,6288,6360,39193,39197,39198,39199,39207,39208,39210,39212,39237,39238,
   39239,39247,39248,39250,39252,39388,39389,39397,39398,39400,39402,39424,39432,39433,39435,39437,
   39466,39467,39469,39471,39703,39705,39707,39730,39732,39779,40918,40919,40920,40928,40929,40931,
   40933,41069,41070,41078,41079,41081,41083,41105,41113,41114,41116,41118,41147,41148,41150,41152,
   41384,41386,41388,41411,41413,41460,41849,41850,41858,41859,41861,41863,41885,41893,41894,41896,
   41898,41927,41928,41930,41932,42164,42166,42168,42191,42193,42240,44625,44633,44634,44636,44638,
   44667,44668,44670,44672,44904,44906,44908,44931,44933,44980,45262,45263,45265,45267,45499,45501,
   45503,45526,45528,45575,46060,46062,46064,46087,46089,46136,49471,49473,49520,49820],
 [5695,5698,5705,5706,5711,5978,5979,6080,6086,6284,6289,39397,39398,39499,39505,39703,39708,
   44700,44701,44706,44904,44909,44934,46588,46593,46618,49474],
 [5692,5695,5699,5705,5706,5712,5867,5978,5979,6112,6119,6284,6290,39286,39397,39398,39531,39538,
   39703,39709,42593,42599,42600,42606,42733,42734,42740,42905,42911,42936,44732,44733,44739,44904,
   44910,44935,47084,47090,47115,49475],[5695,5700,5705,5706,5707,5713,5714,5978,5979,6143,6152,
   6284,6285,6291,6292,6340,39397,39398,39562,39571,39703,39704,39710,39711,39759,44763,44764,
   44765,44904,44905,44911,44912,44930,44936,44937,44960,44961,45084,47549,47550,47556,47557,47575,
   47581,47605,49470,49476,49477,49500,49501,49624,49800,49924,50200],
 [5695,5700,5705,5706,5707,5713,5714,5978,5979,6143,6152,6284,6285,6291,6292,6340,39397,39398,
   39562,39571,39703,39704,39710,39711,39759,44763,44764,44765,44904,44905,44911,44912,44930,44936,
   44937,44960,44961,45084,47549,47550,47556,47557,47575,47581,47605,49470,49476,49477,49500,49501,
   49624,49800,49924,50200],[5695,5701,5705,5706,5715,5978,5979,6173,6183,6284,6293,39397,39398,
   39592,39602,39703,39712,44793,44794,44803,44904,44913,44938,47984,47993,48018,49478],
 [5695,5702,5705,5706,5716,5978,5979,6202,6213,6284,6294,39397,39398,39621,39632,39703,39713,
   44822,44823,44904,44914,44939,48390,48400,49479],
 [5695,5705,5706,5717,5978,5979,6284,6295,39397,39398,39703,39714,44904,44915,44940,49480],
 [5695,5705,5706,5718,5978,5979,6284,6296,39397,39398,39703,39715,44904,44916,44941,49481],
 [5695,5705,5706,5719,5978,5979,6284,6297,39397,39398,39703,39716,44904,44917,44942,49482],
 [5695,5705,5706,5720,5978,5979,6284,6298,39397,39398,39703,39717,44904,44918,44943,49483],
 [5695,5705,5706,5721,5728,5978,5979,6284,6299,6306,39397,39398,39703,39718,39725,44904,44919,
   44926,44944,44951,45206,49484,49491,49746,50046],
 [5695,5705,5706,5722,5978,5979,6284,6300,39397,39398,39703,39719,44904,44920,44945,49485],
 [5695,5705,5706,5723,5978,5979,6284,6301,39397,39398,39703,39720,44904,44921,44946,49486],
 [5695,5705,5706,5724,5978,5979,6284,6302,39397,39398,39703,39721,44904,44922,44947,49487],
 [5695,5705,5706,5725,5727,5978,5979,6284,6303,6305,39397,39398,39703,39722,39724,44904,44923,
   44925,44948,44950,45235,49488,49490,49775,50075],
 [5695,5705,5706,5726,5978,5979,6284,6304,39397,39398,39703,39723,44904,44924,44949,49489],
 [5695,5705,5706,5725,5727,5978,5979,6284,6303,6305,39397,39398,39703,39722,39724,44904,44923,
   44925,44948,44950,45235,49488,49490,49775,50075],
 [5695,5705,5706,5721,5728,5978,5979,6284,6299,6306,39397,39398,39703,39718,39725,44904,44919,
   44926,44944,44951,45206,49484,49491,49746,50046],
 [5695,5705,5706,5729,5978,5979,6284,6307,39397,39398,39703,39726,44904,44927,44952,49492],
 [5695,5705,5706,5730,5978,5979,6284,6308,39397,39398,39703,39727,44904,44928,44953,49493],
 [5695,5705,5706,5731,5978,5979,6284,6309,39397,39398,39703,39728,44904,44929,44954,49494],
 [5705,6018,6050,39424,39779,45501,46064],
 [5693,5694,5696,5697,5698,5705,5708,5710,5711,5894,5905,5942,6005,6013,6016,6018,6047,6050,6052,
   6080,6086,6286,6288,6289,6360,39313,39315,39316,39317,39324,39327,39329,39330,39352,39353,
   39354,39361,39364,39366,39367,39424,39425,39432,39435,39437,39438,39459,39466,39469,39471,39472,
   39499,39502,39504,39505,39705,39707,39708,39779,39780,39823,43257,43258,43259,43266,43269,43271,
   43272,43329,43330,43337,43340,43342,43343,43364,43371,43374,43376,43377,43404,43407,43409,43410,
   43610,43612,43613,43684,43685,43728,43995,43996,44003,44006,44008,44009,44030,44037,44040,44042,
   44043,44070,44073,44075,44076,44276,44278,44279,44350,44351,44394,45255,45262,45265,45267,45268,
   45295,45298,45300,45301,45501,45503,45504,45575,45576,45619,45856,45859,45861,45862,46062,46064,
   46065,46136,46137,46180,46590,46592,46593,46664,46665,46708,49520,49521,49564,50393],
 [5645,5646,5662,5689,5696,5697,5699,5705,5708,5710,5712,5747,6005,6013,6016,6018,6047,6050,6052,
   6112,6119,6286,6288,6290,6360,38205,38212,38213,38215,38221,38224,38226,38228,38254,38255,
   38257,38263,38266,38268,38270,38521,38523,38529,38532,38534,38536,38557,38563,38566,38568,38570,
   38628,38631,38633,38635,38802,38804,38806,38876,38878,38921,39157,39158,39160,39166,39169,39171,
   39173,39424,39426,39432,39435,39437,39439,39460,39466,39469,39471,39473,39531,39534,39536,39538,
   39705,39707,39709,39779,39781,39824,40285,40287,40293,40296,40298,40300,40321,40327,40330,40332,
   40334,40392,40395,40397,40399,40566,40568,40570,40640,40642,40685,45256,45262,45265,45267,45269,
   45327,45330,45332,45334,45501,45503,45505,45575,45577,45620,45888,45891,45893,45895,46062,46064,
   46066,46136,46138,46181,47086,47088,47090,47160,47162,47205,49520,49522,49565,50394],
 [6018,6152,45363,45622],[6018,6183,45393,45398,45623,48108],[6018,6213,45422,45624],
 [6018,45450],[6018,45476,45477,45597,49217],[5705,6018,6050,39424,39779,45501,46064],
 [5690,5691,5695,5696,5697,5705,5706,5708,5710,5774,5788,5828,5978,5979,6005,6013,6016,6018,6047,
   6050,6052,6284,6286,6288,6360,39193,39197,39198,39199,39207,39208,39210,39212,39237,39238,
   39239,39247,39248,39250,39252,39388,39389,39397,39398,39400,39402,39424,39432,39433,39435,39437,
   39466,39467,39469,39471,39703,39705,39707,39730,39732,39779,40918,40919,40920,40928,40929,40931,
   40933,41069,41070,41078,41079,41081,41083,41105,41113,41114,41116,41118,41147,41148,41150,41152,
   41384,41386,41388,41411,41413,41460,41849,41850,41858,41859,41861,41863,41885,41893,41894,41896,
   41898,41927,41928,41930,41932,42164,42166,42168,42191,42193,42240,44625,44633,44634,44636,44638,
   44667,44668,44670,44672,44904,44906,44908,44931,44933,44980,45262,45263,45265,45267,45499,45501,
   45503,45526,45528,45575,46060,46062,46064,46087,46089,46136,49471,49473,49520,49820],
 [6018,6340,45552,45555,45621,50142],[5705,6018,6050,39424,39779,45501,46064],
 [6018,45476,45477,45597,49217],[],[5693,5694,5696,5697,5698,5705,5708,5710,5711,5894,5905,
   5942,6005,6013,6016,6018,6047,6050,6052,6080,6086,6286,6288,6289,6360,39313,39315,39316,39317,
   39324,39327,39329,39330,39352,39353,39354,39361,39364,39366,39367,39424,39425,39432,39435,39437,
   39438,39459,39466,39469,39471,39472,39499,39502,39504,39505,39705,39707,39708,39779,39780,39823,
   43257,43258,43259,43266,43269,43271,43272,43329,43330,43337,43340,43342,43343,43364,43371,43374,
   43376,43377,43404,43407,43409,43410,43610,43612,43613,43684,43685,43728,43995,43996,44003,44006,
   44008,44009,44030,44037,44040,44042,44043,44070,44073,44075,44076,44276,44278,44279,44350,44351,
   44394,45255,45262,45265,45267,45268,45295,45298,45300,45301,45501,45503,45504,45575,45576,45619,
   45856,45859,45861,45862,46062,46064,46065,46136,46137,46180,46590,46592,46593,46664,46665,46708,
   49520,49521,49564,50393],[5645,5646,5662,5689,5696,5697,5699,5705,5708,5710,5712,5747,6005,
   6013,6016,6018,6047,6050,6052,6112,6119,6286,6288,6290,6360,38205,38212,38213,38215,38221,
   38224,38226,38228,38254,38255,38257,38263,38266,38268,38270,38521,38523,38529,38532,38534,38536,
   38557,38563,38566,38568,38570,38628,38631,38633,38635,38802,38804,38806,38876,38878,38921,39157,
   39158,39160,39166,39169,39171,39173,39424,39426,39432,39435,39437,39439,39460,39466,39469,39471,
   39473,39531,39534,39536,39538,39705,39707,39709,39779,39781,39824,40285,40287,40293,40296,40298,
   40300,40321,40327,40330,40332,40334,40392,40395,40397,40399,40566,40568,40570,40640,40642,40685,
   45256,45262,45265,45267,45269,45327,45330,45332,45334,45501,45503,45505,45575,45577,45620,45888,
   45891,45893,45895,46062,46064,46066,46136,46138,46181,47086,47088,47090,47160,47162,47205,49520,
   49522,49565,50394],[6018,6340,45552,45555,45621,50142],[6018,6152,45363,45622],
 [6018,6183,45393,45398,45623,48108],[6018,6213,45422,45624],[6018,45625,45626,45745,50960],
 [6018,45625,45626,45745,50960],[6018,45627],[6018,45628,45636,45791,51006],[6018,45629],
 [6018,45630,45632,45806,51021],[6018,45631],[6018,45630,45632,45806,51021],[6018,45633],
 [6018,45634,45635,45835,51050],[6018,45634,45635,45835,51050],[6018,45628,45636,45791,51006],
 [6018,45637,45638,45847,51062],[6018,45637,45638,45847,51062],[6018,45639],
 [5693,5694,5696,5697,5698,5705,5708,5710,5711,5894,5905,5942,6005,6013,6016,6018,6047,6050,6052,
   6080,6086,6286,6288,6289,6360,39313,39315,39316,39317,39324,39327,39329,39330,39352,39353,
   39354,39361,39364,39366,39367,39424,39425,39432,39435,39437,39438,39459,39466,39469,39471,39472,
   39499,39502,39504,39505,39705,39707,39708,39779,39780,39823,43257,43258,43259,43266,43269,43271,
   43272,43329,43330,43337,43340,43342,43343,43364,43371,43374,43376,43377,43404,43407,43409,43410,
   43610,43612,43613,43684,43685,43728,43995,43996,44003,44006,44008,44009,44030,44037,44040,44042,
   44043,44070,44073,44075,44076,44276,44278,44279,44350,44351,44394,45255,45262,45265,45267,45268,
   45295,45298,45300,45301,45501,45503,45504,45575,45576,45619,45856,45859,45861,45862,46062,46064,
   46065,46136,46137,46180,46590,46592,46593,46664,46665,46708,49520,49521,49564,50393],
 [5645,5646,5662,5689,5696,5697,5699,5705,5708,5710,5712,5747,6005,6013,6016,6018,6047,6050,6052,
   6112,6119,6286,6288,6290,6360,38205,38212,38213,38215,38221,38224,38226,38228,38254,38255,
   38257,38263,38266,38268,38270,38521,38523,38529,38532,38534,38536,38557,38563,38566,38568,38570,
   38628,38631,38633,38635,38802,38804,38806,38876,38878,38921,39157,39158,39160,39166,39169,39171,
   39173,39424,39426,39432,39435,39437,39439,39460,39466,39469,39471,39473,39531,39534,39536,39538,
   39705,39707,39709,39779,39781,39824,40285,40287,40293,40296,40298,40300,40321,40327,40330,40332,
   40334,40392,40395,40397,40399,40566,40568,40570,40640,40642,40685,45256,45262,45265,45267,45269,
   45327,45330,45332,45334,45501,45503,45505,45575,45577,45620,45888,45891,45893,45895,46062,46064,
   46066,46136,46138,46181,47086,47088,47090,47160,47162,47205,49520,49522,49565,50394],
 [6050,6152,45922,46140],[6050,6183,6340,45951,45952,45957,45959,46111,46116,46118,46139,46141,
   46241,48035,48040,48042,48063,48065,48165,50099,50101,50201,50454],[6050,6213,45981,46142],
 [6050,46009],[6050,46036],[5705,6018,6050,39424,39779,45501,46064],
 [5690,5691,5695,5696,5697,5705,5706,5708,5710,5774,5788,5828,5978,5979,6005,6013,6016,6018,6047,
   6050,6052,6284,6286,6288,6360,39193,39197,39198,39199,39207,39208,39210,39212,39237,39238,
   39239,39247,39248,39250,39252,39388,39389,39397,39398,39400,39402,39424,39432,39433,39435,39437,
   39466,39467,39469,39471,39703,39705,39707,39730,39732,39779,40918,40919,40920,40928,40929,40931,
   40933,41069,41070,41078,41079,41081,41083,41105,41113,41114,41116,41118,41147,41148,41150,41152,
   41384,41386,41388,41411,41413,41460,41849,41850,41858,41859,41861,41863,41885,41893,41894,41896,
   41898,41927,41928,41930,41932,42164,42166,42168,42191,42193,42240,44625,44633,44634,44636,44638,
   44667,44668,44670,44672,44904,44906,44908,44931,44933,44980,45262,45263,45265,45267,45499,45501,
   45503,45526,45528,45575,46060,46062,46064,46087,46089,46136,49471,49473,49520,49820],
 [6050,6183,6340,45951,45952,45957,45959,46111,46116,46118,46139,46141,46241,48035,48040,48042,
   48063,48065,48165,50099,50101,50201,50454],[],[6050,46135],
 [5705,6018,6050,39424,39779,45501,46064],
 [5693,5694,5696,5697,5698,5705,5708,5710,5711,5894,5905,5942,6005,6013,6016,6018,6047,6050,6052,
   6080,6086,6286,6288,6289,6360,39313,39315,39316,39317,39324,39327,39329,39330,39352,39353,
   39354,39361,39364,39366,39367,39424,39425,39432,39435,39437,39438,39459,39466,39469,39471,39472,
   39499,39502,39504,39505,39705,39707,39708,39779,39780,39823,43257,43258,43259,43266,43269,43271,
   43272,43329,43330,43337,43340,43342,43343,43364,43371,43374,43376,43377,43404,43407,43409,43410,
   43610,43612,43613,43684,43685,43728,43995,43996,44003,44006,44008,44009,44030,44037,44040,44042,
   44043,44070,44073,44075,44076,44276,44278,44279,44350,44351,44394,45255,45262,45265,45267,45268,
   45295,45298,45300,45301,45501,45503,45504,45575,45576,45619,45856,45859,45861,45862,46062,46064,
   46065,46136,46137,46180,46590,46592,46593,46664,46665,46708,49520,49521,49564,50393],
 [5645,5646,5662,5689,5696,5697,5699,5705,5708,5710,5712,5747,6005,6013,6016,6018,6047,6050,6052,
   6112,6119,6286,6288,6290,6360,38205,38212,38213,38215,38221,38224,38226,38228,38254,38255,
   38257,38263,38266,38268,38270,38521,38523,38529,38532,38534,38536,38557,38563,38566,38568,38570,
   38628,38631,38633,38635,38802,38804,38806,38876,38878,38921,39157,39158,39160,39166,39169,39171,
   39173,39424,39426,39432,39435,39437,39439,39460,39466,39469,39471,39473,39531,39534,39536,39538,
   39705,39707,39709,39779,39781,39824,40285,40287,40293,40296,40298,40300,40321,40327,40330,40332,
   40334,40392,40395,40397,40399,40566,40568,40570,40640,40642,40685,45256,45262,45265,45267,45269,
   45327,45330,45332,45334,45501,45503,45505,45575,45577,45620,45888,45891,45893,45895,46062,46064,
   46066,46136,46138,46181,47086,47088,47090,47160,47162,47205,49520,49522,49565,50394],
 [6050,6183,6340,45951,45952,45957,45959,46111,46116,46118,46139,46141,46241,48035,48040,48042,
   48063,48065,48165,50099,50101,50201,50454],[6050,6152,45922,46140],
 [6050,6183,6340,45951,45952,45957,45959,46111,46116,46118,46139,46141,46241,48035,48040,48042,
   48063,48065,48165,50099,50101,50201,50454],[6050,6213,45981,46142],[6050,46143],
 [6050,46144],[6050,46145],[6050,46146],[6050,46147],[6050,46148],[6050,46149],
 [6050,46150],[6050,46151],[6050,46152],[6050,46153],[6050,46154],[6050,46155],
 [6050,46156],[6050,46157],[5698,5699,5705,5711,5712,6080,6086,6112,6119,6289,6290,39499,39505,
   39531,39538,39708,39709,46416,46422,46423,46593,46594,46729,47089,47090,47225,49585],
 [5698,5700,5705,5711,5714,6080,6086,6143,6152,6289,6292,39499,39505,39562,39571,39708,39711,
   46447,46453,46593,46596,46731,47554,47557,49587],
 [5698,5701,5705,5711,5715,6080,6086,6173,6183,6289,6293,39499,39505,39592,39602,39708,39712,
   46477,46483,46487,46593,46597,46732,47989,47993,48128,49588],
 [5698,5702,5705,5711,5716,6080,6086,6202,6213,6289,6294,39499,39505,39621,39632,39708,39713,
   46506,46512,46593,46598,46733,48395,48400,49589],
 [5698,5703,5705,5711,6080,6086,6230,6289,39499,39505,39649,39708,46534,46540,46593,48773],
 [5698,5704,5705,5711,6080,6086,6257,6289,39499,39505,39676,39708,46561,46567,46593,49124],
 [5705,46593],[5695,5698,5705,5706,5711,5978,5979,6080,6086,6284,6289,39397,39398,39499,39505,
   39703,39708,44700,44701,44706,44904,44909,44934,46588,46593,46618,49474],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,3501,3507,3510,3512,3517,
   3518,3519,3523,3525,3526,3544,3550,3560,3561,3592,3602,3603,3826,3828,3833,3834,3835,3839,
   3841,3842,3930,3935,3936,3937,3941,3998,3999,4000,4004,4139,4140,4144,4146,4147,4165,4169,
   4171,4172,4193,4195,4196,4281,4282,4319,4510,4511,4512,4518,4528,4529,5645,5646,5652,5662,
   5663,5689,5695,5698,5700,5705,5706,5707,5711,5713,5714,5737,5747,5748,5971,5973,5978,5979,
   5980,5984,5986,5987,6075,6080,6081,6086,6089,6143,6144,6145,6149,6151,6152,6284,6285,6289,
   6291,6292,6310,6314,6316,6317,6340,6341,6427,6464,7725,7726,7732,7742,7743,7769,7775,7785,
   7786,7817,7820,7822,7827,7828,7829,7833,7835,7836,8051,8053,8058,8059,8060,8064,8066,8067,
   8155,8160,8161,8162,8166,8168,8169,8223,8224,8225,8231,8364,8365,8369,8371,8372,8390,8394,
   8396,8397,8420,8506,8507,8544,38205,38211,38221,38222,38253,38263,38264,38487,38489,38494,
   38495,38496,38500,38502,38503,38591,38800,38854,38980,39156,39166,39167,39397,39398,39499,39505,
   39562,39571,39703,39704,39708,39710,39711,39759,40258,40259,40361,40368,40424,40425,40564,40590,
   40594,40596,40597,40707,44695,44700,44701,44702,44706,44708,44709,44763,44764,44765,44769,44771,
   44772,44904,44905,44909,44911,44912,44930,44934,44936,44937,44958,44960,44961,45046,45047,45084,
   46447,46448,46449,46453,46455,46456,46588,46589,46593,46595,46596,46614,46618,46620,46621,46642,
   46644,46645,46730,46731,46768,47549,47550,47554,47556,47557,47575,47579,47581,47582,47603,47605,
   47606,47691,47692,47729,49470,49474,49476,49477,49498,49500,49501,49586,49587,49624,49798,49800,
   49801,49886,49887,49924,50162,50163,50200,51084],
 [5693,5694,5696,5697,5698,5705,5708,5710,5711,5894,5905,5942,6005,6013,6016,6018,6047,6050,6052,
   6080,6086,6286,6288,6289,6360,39313,39315,39316,39317,39324,39327,39329,39330,39352,39353,
   39354,39361,39364,39366,39367,39424,39425,39432,39435,39437,39438,39459,39466,39469,39471,39472,
   39499,39502,39504,39505,39705,39707,39708,39779,39780,39823,43257,43258,43259,43266,43269,43271,
   43272,43329,43330,43337,43340,43342,43343,43364,43371,43374,43376,43377,43404,43407,43409,43410,
   43610,43612,43613,43684,43685,43728,43995,43996,44003,44006,44008,44009,44030,44037,44040,44042,
   44043,44070,44073,44075,44076,44276,44278,44279,44350,44351,44394,45255,45262,45265,45267,45268,
   45295,45298,45300,45301,45501,45503,45504,45575,45576,45619,45856,45859,45861,45862,46062,46064,
   46065,46136,46137,46180,46590,46592,46593,46664,46665,46708,49520,49521,49564,50393],
 [5698,5705,5709,5711,6080,6086,6287,6289,39499,39505,39706,39708,46591,46593,46687,49543],
 [5693,5694,5696,5697,5698,5705,5708,5710,5711,5894,5905,5942,6005,6013,6016,6018,6047,6050,6052,
   6080,6086,6286,6288,6289,6360,39313,39315,39316,39317,39324,39327,39329,39330,39352,39353,
   39354,39361,39364,39366,39367,39424,39425,39432,39435,39437,39438,39459,39466,39469,39471,39472,
   39499,39502,39504,39505,39705,39707,39708,39779,39780,39823,43257,43258,43259,43266,43269,43271,
   43272,43329,43330,43337,43340,43342,43343,43364,43371,43374,43376,43377,43404,43407,43409,43410,
   43610,43612,43613,43684,43685,43728,43995,43996,44003,44006,44008,44009,44030,44037,44040,44042,
   44043,44070,44073,44075,44076,44276,44278,44279,44350,44351,44394,45255,45262,45265,45267,45268,
   45295,45298,45300,45301,45501,45503,45504,45575,45576,45619,45856,45859,45861,45862,46062,46064,
   46065,46136,46137,46180,46590,46592,46593,46664,46665,46708,49520,49521,49564,50393],
 [5705,46593],[5698,5699,5705,5711,5712,6080,6086,6112,6119,6289,6290,39499,39505,39531,39538,
   39708,39709,46416,46422,46423,46593,46594,46729,47089,47090,47225,49585],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,3501,3507,3510,3512,3517,
   3518,3519,3523,3525,3526,3544,3550,3560,3561,3592,3602,3603,3826,3828,3833,3834,3835,3839,
   3841,3842,3930,3935,3936,3937,3941,3998,3999,4000,4004,4139,4140,4144,4146,4147,4165,4169,
   4171,4172,4193,4195,4196,4281,4282,4319,4510,4511,4512,4518,4528,4529,5645,5646,5652,5662,
   5663,5689,5695,5698,5700,5705,5706,5707,5711,5713,5714,5737,5747,5748,5971,5973,5978,5979,
   5980,5984,5986,5987,6075,6080,6081,6086,6089,6143,6144,6145,6149,6151,6152,6284,6285,6289,
   6291,6292,6310,6314,6316,6317,6340,6341,6427,6464,7725,7726,7732,7742,7743,7769,7775,7785,
   7786,7817,7820,7822,7827,7828,7829,7833,7835,7836,8051,8053,8058,8059,8060,8064,8066,8067,
   8155,8160,8161,8162,8166,8168,8169,8223,8224,8225,8231,8364,8365,8369,8371,8372,8390,8394,
   8396,8397,8420,8506,8507,8544,38205,38211,38221,38222,38253,38263,38264,38487,38489,38494,
   38495,38496,38500,38502,38503,38591,38800,38854,38980,39156,39166,39167,39397,39398,39499,39505,
   39562,39571,39703,39704,39708,39710,39711,39759,40258,40259,40361,40368,40424,40425,40564,40590,
   40594,40596,40597,40707,44695,44700,44701,44702,44706,44708,44709,44763,44764,44765,44769,44771,
   44772,44904,44905,44909,44911,44912,44930,44934,44936,44937,44958,44960,44961,45046,45047,45084,
   46447,46448,46449,46453,46455,46456,46588,46589,46593,46595,46596,46614,46618,46620,46621,46642,
   46644,46645,46730,46731,46768,47549,47550,47554,47556,47557,47575,47579,47581,47582,47603,47605,
   47606,47691,47692,47729,49470,49474,49476,49477,49498,49500,49501,49586,49587,49624,49798,49800,
   49801,49886,49887,49924,50162,50163,50200,51084],
 [5698,5700,5705,5711,5714,6080,6086,6143,6152,6289,6292,39499,39505,39562,39571,39708,39711,
   46447,46453,46593,46596,46731,47554,47557,49587],
 [5698,5701,5705,5711,5715,6080,6086,6173,6183,6289,6293,39499,39505,39592,39602,39708,39712,
   46477,46483,46487,46593,46597,46732,47989,47993,48128,49588],
 [5698,5702,5705,5711,5716,6080,6086,6202,6213,6289,6294,39499,39505,39621,39632,39708,39713,
   46506,46512,46593,46598,46733,48395,48400,49589],
 [5698,5705,5711,5717,6080,6086,6289,6295,39499,39505,39708,39714,46593,46599,46734,49590],
 [5698,5705,5711,5718,6080,6086,6289,6296,39499,39505,39708,39715,46593,46600,46735,49591],
 [5698,5705,5711,5719,6080,6086,6289,6297,39499,39505,39708,39716,46593,46601,46736,49592],
 [5698,5705,5711,5720,6080,6086,6289,6298,39499,39505,39708,39717,46593,46602,46737,49593],
 [5698,5705,5711,5721,6080,6086,6289,6299,39499,39505,39708,39718,46593,46603,46738,49594],
 [5698,5705,5711,5722,6080,6086,6289,6300,39499,39505,39708,39719,46593,46604,46739,49595],
 [5698,5705,5711,5723,6080,6086,6289,6301,39499,39505,39708,39720,46593,46605,46740,49596],
 [5698,5705,5711,5724,6080,6086,6289,6302,39499,39505,39708,39721,46593,46606,46741,49597],
 [5698,5705,5711,5725,6080,6086,6289,6303,39499,39505,39708,39722,46593,46607,46742,49598],
 [5698,5705,5711,5726,6080,6086,6289,6304,39499,39505,39708,39723,46593,46608,46743,49599],
 [5698,5705,5711,5727,6080,6086,6289,6305,39499,39505,39708,39724,46593,46609,46744,49600],
 [5698,5705,5711,5728,6080,6086,6289,6306,39499,39505,39708,39725,46593,46610,46745,49601],
 [5698,5705,5711,5729,6080,6086,6289,6307,39499,39505,39708,39726,46593,46611,46746,49602],
 [5698,5705,5711,5730,6080,6086,6289,6308,39499,39505,39708,39727,46593,46612,46747,49603],
 [5698,5705,5711,5731,6080,6086,6289,6309,39499,39505,39708,39728,46593,46613,46748,49604],
 [5699,5700,5705,5712,5714,6112,6119,6143,6152,6290,6292,39531,39538,39562,39571,39709,39711,
   46943,46950,47090,47092,47246,47555,47557,49606],
 [5699,5701,5705,5712,5715,6112,6119,6173,6183,6290,6293,39531,39538,39592,39602,39709,39712,
   46973,46980,46983,47090,47093,47247,47990,47993,48147,49607],
 [5699,5702,5705,5707,5712,5713,5716,6112,6119,6202,6213,6285,6290,6291,6294,6340,39531,39538,
   39621,39632,39704,39709,39710,39713,39759,47002,47004,47009,47085,47090,47091,47094,47139,47140,
   47143,47245,47248,47266,48391,48396,48397,48400,48445,48446,48551,49499,49500,49503,49605,49608,
   49626,50181,50202,51257],[5699,5703,5705,5712,6112,6119,6230,6290,39531,39538,39649,39709,
   47030,47037,47090,48774],[5699,5704,5705,5712,6112,6119,6257,6290,39531,39538,39676,39709,
   47057,47064,47090,49125],[5705,47090],
 [5692,5695,5699,5705,5706,5712,5867,5978,5979,6112,6119,6284,6290,39286,39397,39398,39531,39538,
   39703,39709,42593,42599,42600,42606,42733,42734,42740,42905,42911,42936,44732,44733,44739,44904,
   44910,44935,47084,47090,47115,49475],[5699,5702,5705,5707,5712,5713,5716,6112,6119,6202,6213,
   6285,6290,6291,6294,6340,39531,39538,39621,39632,39704,39709,39710,39713,39759,47002,47004,
   47009,47085,47090,47091,47094,47139,47140,47143,47245,47248,47266,48391,48396,48397,48400,48445,
   48446,48551,49499,49500,49503,49605,49608,49626,50181,50202,51257],
 [5645,5646,5662,5689,5696,5697,5699,5705,5708,5710,5712,5747,6005,6013,6016,6018,6047,6050,6052,
   6112,6119,6286,6288,6290,6360,38205,38212,38213,38215,38221,38224,38226,38228,38254,38255,
   38257,38263,38266,38268,38270,38521,38523,38529,38532,38534,38536,38557,38563,38566,38568,38570,
   38628,38631,38633,38635,38802,38804,38806,38876,38878,38921,39157,39158,39160,39166,39169,39171,
   39173,39424,39426,39432,39435,39437,39439,39460,39466,39469,39471,39473,39531,39534,39536,39538,
   39705,39707,39709,39779,39781,39824,40285,40287,40293,40296,40298,40300,40321,40327,40330,40332,
   40334,40392,40395,40397,40399,40566,40568,40570,40640,40642,40685,45256,45262,45265,45267,45269,
   45327,45330,45332,45334,45501,45503,45505,45575,45577,45620,45888,45891,45893,45895,46062,46064,
   46066,46136,46138,46181,47086,47088,47090,47160,47162,47205,49520,49522,49565,50394],
 [5699,5705,5709,5712,6112,6119,6287,6290,39531,39538,39706,39709,47087,47090,47184,49544],
 [5645,5646,5662,5689,5696,5697,5699,5705,5708,5710,5712,5747,6005,6013,6016,6018,6047,6050,6052,
   6112,6119,6286,6288,6290,6360,38205,38212,38213,38215,38221,38224,38226,38228,38254,38255,
   38257,38263,38266,38268,38270,38521,38523,38529,38532,38534,38536,38557,38563,38566,38568,38570,
   38628,38631,38633,38635,38802,38804,38806,38876,38878,38921,39157,39158,39160,39166,39169,39171,
   39173,39424,39426,39432,39435,39437,39439,39460,39466,39469,39471,39473,39531,39534,39536,39538,
   39705,39707,39709,39779,39781,39824,40285,40287,40293,40296,40298,40300,40321,40327,40330,40332,
   40334,40392,40395,40397,40399,40566,40568,40570,40640,40642,40685,45256,45262,45265,45267,45269,
   45327,45330,45332,45334,45501,45503,45505,45575,45577,45620,45888,45891,45893,45895,46062,46064,
   46066,46136,46138,46181,47086,47088,47090,47160,47162,47205,49520,49522,49565,50394],
 [5698,5699,5705,5711,5712,6080,6086,6112,6119,6289,6290,39499,39505,39531,39538,39708,39709,
   46416,46422,46423,46593,46594,46729,47089,47090,47225,49585],[5705,47090],
 [5699,5702,5705,5707,5712,5713,5716,6112,6119,6202,6213,6285,6290,6291,6294,6340,39531,39538,
   39621,39632,39704,39709,39710,39713,39759,47002,47004,47009,47085,47090,47091,47094,47139,47140,
   47143,47245,47248,47266,48391,48396,48397,48400,48445,48446,48551,49499,49500,49503,49605,49608,
   49626,50181,50202,51257],[5699,5700,5705,5712,5714,6112,6119,6143,6152,6290,6292,39531,39538,
   39562,39571,39709,39711,46943,46950,47090,47092,47246,47555,47557,49606],
 [5699,5701,5705,5712,5715,6112,6119,6173,6183,6290,6293,39531,39538,39592,39602,39709,39712,
   46973,46980,46983,47090,47093,47247,47990,47993,48147,49607],
 [5699,5702,5705,5707,5712,5713,5716,6112,6119,6202,6213,6285,6290,6291,6294,6340,39531,39538,
   39621,39632,39704,39709,39710,39713,39759,47002,47004,47009,47085,47090,47091,47094,47139,47140,
   47143,47245,47248,47266,48391,48396,48397,48400,48445,48446,48551,49499,49500,49503,49605,49608,
   49626,50181,50202,51257],[5699,5705,5712,5717,5719,6112,6119,6290,6295,6297,39531,39538,
   39709,39714,39716,47090,47095,47097,47249,47251,47331,49609,49611,49691,51322],
 [5699,5705,5712,5718,6112,6119,6290,6296,39531,39538,39709,39715,47090,47096,47250,49610],
 [5699,5705,5712,5717,5719,6112,6119,6290,6295,6297,39531,39538,39709,39714,39716,47090,47095,
   47097,47249,47251,47331,49609,49611,49691,51322],
 [5699,5705,5712,5720,6112,6119,6290,6298,39531,39538,39709,39717,47090,47098,47252,49612],
 [5699,5705,5712,5721,6112,6119,6290,6299,39531,39538,39709,39718,47090,47099,47253,49613],
 [5699,5705,5712,5722,6112,6119,6290,6300,39531,39538,39709,39719,47090,47100,47254,49614],
 [5699,5705,5712,5723,5724,6112,6119,6290,6301,6302,39531,39538,39709,39720,39721,47090,47101,
   47102,47255,47256,47399,49615,49616,49759,51390],
 [5699,5705,5712,5723,5724,6112,6119,6290,6301,6302,39531,39538,39709,39720,39721,47090,47101,
   47102,47255,47256,47399,49615,49616,49759,51390],
 [5699,5705,5712,5725,6112,6119,6290,6303,39531,39538,39709,39722,47090,47103,47257,49617],
 [5699,5705,5712,5726,6112,6119,6290,6304,39531,39538,39709,39723,47090,47104,47258,49618],
 [5699,5705,5712,5727,6112,6119,6290,6305,39531,39538,39709,39724,47090,47105,47259,49619],
 [5699,5705,5712,5728,6112,6119,6290,6306,39531,39538,39709,39725,47090,47106,47260,49620],
 [5699,5705,5712,5729,5731,6112,6119,6290,6307,6309,39531,39538,39709,39726,39728,47090,47107,
   47109,47261,47263,47433,49621,49623,49793,51424],
 [5699,5705,5712,5730,6112,6119,6290,6308,39531,39538,39709,39727,47090,47108,47262,49622],
 [5699,5705,5712,5729,5731,6112,6119,6290,6307,6309,39531,39538,39709,39726,39728,47090,47107,
   47109,47261,47263,47433,49621,49623,49793,51424],
 [5690,5691,5700,5701,5705,5714,5715,5774,5788,5828,6143,6152,6173,6183,6292,6293,39193,39202,
   39203,39207,39216,39217,39242,39243,39247,39256,39257,39558,39562,39571,39572,39592,39601,39602,
   39711,39712,39901,40923,40924,40928,40937,40938,41239,41253,41283,41582,42019,42062,42063,42362,
   47448,47557,47993,48182],[6152,6213,42761,43104],[6152],[6152],[5705,6152],
 [5695,5700,5705,5706,5707,5713,5714,5978,5979,6143,6152,6284,6285,6291,6292,6340,39397,39398,
   39562,39571,39703,39704,39710,39711,39759,44763,44764,44765,44904,44905,44911,44912,44930,44936,
   44937,44960,44961,45084,47549,47550,47556,47557,47575,47581,47605,49470,49476,49477,49500,49501,
   49624,49800,49924,50200],[5695,5700,5705,5706,5707,5713,5714,5978,5979,6143,6152,6284,6285,
   6291,6292,6340,39397,39398,39562,39571,39703,39704,39710,39711,39759,44763,44764,44765,44904,
   44905,44911,44912,44930,44936,44937,44960,44961,45084,47549,47550,47556,47557,47575,47581,47605,
   49470,49476,49477,49500,49501,49624,49800,49924,50200],[6050,6152,45922,46140],[6152],
 [6018,6152,45363,45622],[5698,5700,5705,5711,5714,6080,6086,6143,6152,6289,6292,39499,39505,
   39562,39571,39708,39711,46447,46453,46593,46596,46731,47554,47557,49587],
 [5699,5700,5705,5712,5714,6112,6119,6143,6152,6290,6292,39531,39538,39562,39571,39709,39711,
   46943,46950,47090,47092,47246,47555,47557,49606],
 [5695,5700,5705,5706,5707,5713,5714,5978,5979,6143,6152,6284,6285,6291,6292,6340,39397,39398,
   39562,39571,39703,39704,39710,39711,39759,44763,44764,44765,44904,44905,44911,44912,44930,44936,
   44937,44960,44961,45084,47549,47550,47556,47557,47575,47581,47605,49470,49476,49477,49500,49501,
   49624,49800,49924,50200],[],[5690,5691,5700,5701,5705,5714,5715,5774,5788,5828,6143,6152,
   6173,6183,6292,6293,39193,39202,39203,39207,39216,39217,39242,39243,39247,39256,39257,39558,
   39562,39571,39572,39592,39601,39602,39711,39712,39901,40923,40924,40928,40937,40938,41239,41253,
   41283,41582,42019,42062,42063,42362,47448,47557,47993,48182],[6152,6213,42761,43104],[6152],
 [6152],[6152],[6152],[6152],[6152],[6152],[6152],[6152],[6152],[6152],[6152],
 [6152],[6152],[6152],[5645,5646,5662,5689,5701,5702,5705,5715,5716,5747,6173,6183,6202,6213,
   6293,6294,38205,38217,38218,38221,38231,38232,38259,38260,38263,38273,38274,38686,38699,38700,
   39015,39162,39163,39166,39176,39177,39589,39592,39602,39603,39621,39631,39632,39712,39713,39918,
   40450,40463,40492,40779,47912,47993,48199,48400],[6183,47940],[6183,47967],
 [5705,6183,39602,47993],[5695,5701,5705,5706,5715,5978,5979,6173,6183,6284,6293,39397,39398,
   39592,39602,39703,39712,44793,44794,44803,44904,44913,44938,47984,47993,48018,49478],
 [6050,6183,6340,45951,45952,45957,45959,46111,46116,46118,46139,46141,46241,48035,48040,48042,
   48063,48065,48165,50099,50101,50201,50454],
 [6050,6183,6340,45951,45952,45957,45959,46111,46116,46118,46139,46141,46241,48035,48040,48042,
   48063,48065,48165,50099,50101,50201,50454],[6183,48087],[6018,6183,45393,45398,45623,48108],
 [5698,5701,5705,5711,5715,6080,6086,6173,6183,6289,6293,39499,39505,39592,39602,39708,39712,
   46477,46483,46487,46593,46597,46732,47989,47993,48128,49588],
 [5699,5701,5705,5712,5715,6112,6119,6173,6183,6290,6293,39531,39538,39592,39602,39709,39712,
   46973,46980,46983,47090,47093,47247,47990,47993,48147,49607],
 [6050,6183,6340,45951,45952,45957,45959,46111,46116,46118,46139,46141,46241,48035,48040,48042,
   48063,48065,48165,50099,50101,50201,50454],
 [5690,5691,5700,5701,5705,5714,5715,5774,5788,5828,6143,6152,6173,6183,6292,6293,39193,39202,
   39203,39207,39216,39217,39242,39243,39247,39256,39257,39558,39562,39571,39572,39592,39601,39602,
   39711,39712,39901,40923,40924,40928,40937,40938,41239,41253,41283,41582,42019,42062,42063,42362,
   47448,47557,47993,48182],[],[5645,5646,5662,5689,5701,5702,5705,5715,5716,5747,6173,6183,
   6202,6213,6293,6294,38205,38217,38218,38221,38231,38232,38259,38260,38263,38273,38274,38686,
   38699,38700,39015,39162,39163,39166,39176,39177,39589,39592,39602,39603,39621,39631,39632,39712,
   39713,39918,40450,40463,40492,40779,47912,47993,48199,48400],[6183,48200],[6183,48201],
 [6183,48202],[6183,48203],[6183,48204],[6183,48205],[6183,48206],[6183,48207],
 [6183,48208],[6183,48209],[6183,48210],[6183,48211],[6183,48212],[6183,48213],
 [6183,48214],[6213],[6213],[5705,6213],
 [5695,5702,5705,5706,5716,5978,5979,6202,6213,6284,6294,39397,39398,39621,39632,39703,39713,
   44822,44823,44904,44914,44939,48390,48400,49479],
 [5699,5702,5705,5707,5712,5713,5716,6112,6119,6202,6213,6285,6290,6291,6294,6340,39531,39538,
   39621,39632,39704,39709,39710,39713,39759,47002,47004,47009,47085,47090,47091,47094,47139,47140,
   47143,47245,47248,47266,48391,48396,48397,48400,48445,48446,48551,49499,49500,49503,49605,49608,
   49626,50181,50202,51257],[6050,6213,45981,46142],[6213],[6018,6213,45422,45624],
 [5698,5702,5705,5711,5716,6080,6086,6202,6213,6289,6294,39499,39505,39621,39632,39708,39713,
   46506,46512,46593,46598,46733,48395,48400,49589],
 [5699,5702,5705,5707,5712,5713,5716,6112,6119,6202,6213,6285,6290,6291,6294,6340,39531,39538,
   39621,39632,39704,39709,39710,39713,39759,47002,47004,47009,47085,47090,47091,47094,47139,47140,
   47143,47245,47248,47266,48391,48396,48397,48400,48445,48446,48551,49499,49500,49503,49605,49608,
   49626,50181,50202,51257],[5699,5702,5705,5707,5712,5713,5716,6112,6119,6202,6213,6285,6290,
   6291,6294,6340,39531,39538,39621,39632,39704,39709,39710,39713,39759,47002,47004,47009,47085,
   47090,47091,47094,47139,47140,47143,47245,47248,47266,48391,48396,48397,48400,48445,48446,48551,
   49499,49500,49503,49605,49608,49626,50181,50202,51257],[6152,6213,42761,43104],
 [5645,5646,5662,5689,5701,5702,5705,5715,5716,5747,6173,6183,6202,6213,6293,6294,38205,38217,
   38218,38221,38231,38232,38259,38260,38263,38273,38274,38686,38699,38700,39015,39162,39163,39166,
   39176,39177,39589,39592,39602,39603,39621,39631,39632,39712,39713,39918,40450,40463,40492,40779,
   47912,47993,48199,48400],[],[6213],[6213],[6213],[6213],[6213],[6213],[6213],
 [6213],[6213],[6213],[6213],[6213],[6213],[6213],[6213],
 [5690,5691,5703,5704,5705,5774,5788,5828,6230,6257,39193,39205,39206,39207,39245,39246,39247,
   39648,39649,39676,40926,40927,40928,41329,42109],[5705],
 [5695,5703,5705,5706,5709,5978,5979,6230,6284,6287,39397,39398,39649,39703,39706,44850,44851,
   44854,44904,44907,44932,48768,48771,48796,49472],[6340,48824],[6050,46009],
 [5695,5703,5705,5706,5709,5978,5979,6230,6284,6287,39397,39398,39649,39703,39706,44850,44851,
   44854,44904,44907,44932,48768,48771,48796,49472],[6018,45450],
 [5698,5703,5705,5711,6080,6086,6230,6289,39499,39505,39649,39708,46534,46540,46593,48773],
 [5699,5703,5705,5712,6112,6119,6230,6290,39531,39538,39649,39709,47030,47037,47090,48774],
 [6340,48824],[6152],[6183,47940],[6213],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[5705],[5695,5704,5705,5706,5978,5979,6257,6284,39397,39398,39676,
   39703,44877,44878,44904,49119],[6340,49175],[6050,46036],[6018,45476,45477,45597,49217],
 [6018,45476,45477,45597,49217],[5698,5704,5705,5711,6080,6086,6257,6289,39499,39505,39676,39708,
   46561,46567,46593,49124],[5699,5704,5705,5712,6112,6119,6257,6290,39531,39538,39676,39709,
   47057,47064,47090,49125],[6340,49175],[6152],[6183,47967],[6213],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[5705,44904],[5705,6340,39759,49500],
 [5705,6018,6050,39424,39779,45501,46064],[5705],[5705,6018,6050,39424,39779,45501,46064],
 [5705,46593],[5705,47090],[5705,6340,39759,49500],[5705,6152],[5705,6183,39602,47993],
 [5705,6213],[5705],[5705],[5705],[5705],[5705],[5705],[5705],[5705],[5705],[5705],
 [5705],[5705],[5705],[5705],[5705],
 [5695,5700,5705,5706,5707,5713,5714,5978,5979,6143,6152,6284,6285,6291,6292,6340,39397,39398,
   39562,39571,39703,39704,39710,39711,39759,44763,44764,44765,44904,44905,44911,44912,44930,44936,
   44937,44960,44961,45084,47549,47550,47556,47557,47575,47581,47605,49470,49476,49477,49500,49501,
   49624,49800,49924,50200],[5690,5691,5695,5696,5697,5705,5706,5708,5710,5774,5788,5828,5978,
   5979,6005,6013,6016,6018,6047,6050,6052,6284,6286,6288,6360,39193,39197,39198,39199,39207,
   39208,39210,39212,39237,39238,39239,39247,39248,39250,39252,39388,39389,39397,39398,39400,39402,
   39424,39432,39433,39435,39437,39466,39467,39469,39471,39703,39705,39707,39730,39732,39779,40918,
   40919,40920,40928,40929,40931,40933,41069,41070,41078,41079,41081,41083,41105,41113,41114,41116,
   41118,41147,41148,41150,41152,41384,41386,41388,41411,41413,41460,41849,41850,41858,41859,41861,
   41863,41885,41893,41894,41896,41898,41927,41928,41930,41932,42164,42166,42168,42191,42193,42240,
   44625,44633,44634,44636,44638,44667,44668,44670,44672,44904,44906,44908,44931,44933,44980,45262,
   45263,45265,45267,45499,45501,45503,45526,45528,45575,46060,46062,46064,46087,46089,46136,49471,
   49473,49520,49820],[5695,5703,5705,5706,5709,5978,5979,6230,6284,6287,39397,39398,39649,
   39703,39706,44850,44851,44854,44904,44907,44932,48768,48771,48796,49472],
 [5690,5691,5695,5696,5697,5705,5706,5708,5710,5774,5788,5828,5978,5979,6005,6013,6016,6018,6047,
   6050,6052,6284,6286,6288,6360,39193,39197,39198,39199,39207,39208,39210,39212,39237,39238,
   39239,39247,39248,39250,39252,39388,39389,39397,39398,39400,39402,39424,39432,39433,39435,39437,
   39466,39467,39469,39471,39703,39705,39707,39730,39732,39779,40918,40919,40920,40928,40929,40931,
   40933,41069,41070,41078,41079,41081,41083,41105,41113,41114,41116,41118,41147,41148,41150,41152,
   41384,41386,41388,41411,41413,41460,41849,41850,41858,41859,41861,41863,41885,41893,41894,41896,
   41898,41927,41928,41930,41932,42164,42166,42168,42191,42193,42240,44625,44633,44634,44636,44638,
   44667,44668,44670,44672,44904,44906,44908,44931,44933,44980,45262,45263,45265,45267,45499,45501,
   45503,45526,45528,45575,46060,46062,46064,46087,46089,46136,49471,49473,49520,49820],
 [5695,5698,5705,5706,5711,5978,5979,6080,6086,6284,6289,39397,39398,39499,39505,39703,39708,
   44700,44701,44706,44904,44909,44934,46588,46593,46618,49474],
 [5692,5695,5699,5705,5706,5712,5867,5978,5979,6112,6119,6284,6290,39286,39397,39398,39531,39538,
   39703,39709,42593,42599,42600,42606,42733,42734,42740,42905,42911,42936,44732,44733,44739,44904,
   44910,44935,47084,47090,47115,49475],[5695,5700,5705,5706,5707,5713,5714,5978,5979,6143,6152,
   6284,6285,6291,6292,6340,39397,39398,39562,39571,39703,39704,39710,39711,39759,44763,44764,
   44765,44904,44905,44911,44912,44930,44936,44937,44960,44961,45084,47549,47550,47556,47557,47575,
   47581,47605,49470,49476,49477,49500,49501,49624,49800,49924,50200],
 [5695,5700,5705,5706,5707,5713,5714,5978,5979,6143,6152,6284,6285,6291,6292,6340,39397,39398,
   39562,39571,39703,39704,39710,39711,39759,44763,44764,44765,44904,44905,44911,44912,44930,44936,
   44937,44960,44961,45084,47549,47550,47556,47557,47575,47581,47605,49470,49476,49477,49500,49501,
   49624,49800,49924,50200],[5695,5701,5705,5706,5715,5978,5979,6173,6183,6284,6293,39397,39398,
   39592,39602,39703,39712,44793,44794,44803,44904,44913,44938,47984,47993,48018,49478],
 [5695,5702,5705,5706,5716,5978,5979,6202,6213,6284,6294,39397,39398,39621,39632,39703,39713,
   44822,44823,44904,44914,44939,48390,48400,49479],
 [5695,5705,5706,5717,5978,5979,6284,6295,39397,39398,39703,39714,44904,44915,44940,49480],
 [5695,5705,5706,5718,5978,5979,6284,6296,39397,39398,39703,39715,44904,44916,44941,49481],
 [5695,5705,5706,5719,5978,5979,6284,6297,39397,39398,39703,39716,44904,44917,44942,49482],
 [5695,5705,5706,5720,5978,5979,6284,6298,39397,39398,39703,39717,44904,44918,44943,49483],
 [5695,5705,5706,5721,5728,5978,5979,6284,6299,6306,39397,39398,39703,39718,39725,44904,44919,
   44926,44944,44951,45206,49484,49491,49746,50046],
 [5695,5705,5706,5722,5978,5979,6284,6300,39397,39398,39703,39719,44904,44920,44945,49485],
 [5695,5705,5706,5723,5978,5979,6284,6301,39397,39398,39703,39720,44904,44921,44946,49486],
 [5695,5705,5706,5724,5978,5979,6284,6302,39397,39398,39703,39721,44904,44922,44947,49487],
 [5695,5705,5706,5725,5727,5978,5979,6284,6303,6305,39397,39398,39703,39722,39724,44904,44923,
   44925,44948,44950,45235,49488,49490,49775,50075],
 [5695,5705,5706,5726,5978,5979,6284,6304,39397,39398,39703,39723,44904,44924,44949,49489],
 [5695,5705,5706,5725,5727,5978,5979,6284,6303,6305,39397,39398,39703,39722,39724,44904,44923,
   44925,44948,44950,45235,49488,49490,49775,50075],
 [5695,5705,5706,5721,5728,5978,5979,6284,6299,6306,39397,39398,39703,39718,39725,44904,44919,
   44926,44944,44951,45206,49484,49491,49746,50046],
 [5695,5705,5706,5729,5978,5979,6284,6307,39397,39398,39703,39726,44904,44927,44952,49492],
 [5695,5705,5706,5730,5978,5979,6284,6308,39397,39398,39703,39727,44904,44928,44953,49493],
 [5695,5705,5706,5731,5978,5979,6284,6309,39397,39398,39703,39728,44904,44929,44954,49494],
 [6050,6183,6340,45951,45952,45957,45959,46111,46116,46118,46139,46141,46241,48035,48040,48042,
   48063,48065,48165,50099,50101,50201,50454],[6340,50121],[6018,6340,45552,45555,45621,50142],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,3501,3507,3510,3512,3517,
   3518,3519,3523,3525,3526,3544,3550,3560,3561,3592,3602,3603,3826,3828,3833,3834,3835,3839,
   3841,3842,3930,3935,3936,3937,3941,3998,3999,4000,4004,4139,4140,4144,4146,4147,4165,4169,
   4171,4172,4193,4195,4196,4281,4282,4319,4510,4511,4512,4518,4528,4529,5645,5646,5652,5662,
   5663,5689,5695,5698,5700,5705,5706,5707,5711,5713,5714,5737,5747,5748,5971,5973,5978,5979,
   5980,5984,5986,5987,6075,6080,6081,6086,6089,6143,6144,6145,6149,6151,6152,6284,6285,6289,
   6291,6292,6310,6314,6316,6317,6340,6341,6427,6464,7725,7726,7732,7742,7743,7769,7775,7785,
   7786,7817,7820,7822,7827,7828,7829,7833,7835,7836,8051,8053,8058,8059,8060,8064,8066,8067,
   8155,8160,8161,8162,8166,8168,8169,8223,8224,8225,8231,8364,8365,8369,8371,8372,8390,8394,
   8396,8397,8420,8506,8507,8544,38205,38211,38221,38222,38253,38263,38264,38487,38489,38494,
   38495,38496,38500,38502,38503,38591,38800,38854,38980,39156,39166,39167,39397,39398,39499,39505,
   39562,39571,39703,39704,39708,39710,39711,39759,40258,40259,40361,40368,40424,40425,40564,40590,
   40594,40596,40597,40707,44695,44700,44701,44702,44706,44708,44709,44763,44764,44765,44769,44771,
   44772,44904,44905,44909,44911,44912,44930,44934,44936,44937,44958,44960,44961,45046,45047,45084,
   46447,46448,46449,46453,46455,46456,46588,46589,46593,46595,46596,46614,46618,46620,46621,46642,
   46644,46645,46730,46731,46768,47549,47550,47554,47556,47557,47575,47579,47581,47582,47603,47605,
   47606,47691,47692,47729,49470,49474,49476,49477,49498,49500,49501,49586,49587,49624,49798,49800,
   49801,49886,49887,49924,50162,50163,50200,51084],
 [5699,5702,5705,5707,5712,5713,5716,6112,6119,6202,6213,6285,6290,6291,6294,6340,39531,39538,
   39621,39632,39704,39709,39710,39713,39759,47002,47004,47009,47085,47090,47091,47094,47139,47140,
   47143,47245,47248,47266,48391,48396,48397,48400,48445,48446,48551,49499,49500,49503,49605,49608,
   49626,50181,50202,51257],[],[5695,5700,5705,5706,5707,5713,5714,5978,5979,6143,6152,6284,
   6285,6291,6292,6340,39397,39398,39562,39571,39703,39704,39710,39711,39759,44763,44764,44765,
   44904,44905,44911,44912,44930,44936,44937,44960,44961,45084,47549,47550,47556,47557,47575,47581,
   47605,49470,49476,49477,49500,49501,49624,49800,49924,50200],
 [6050,6183,6340,45951,45952,45957,45959,46111,46116,46118,46139,46141,46241,48035,48040,48042,
   48063,48065,48165,50099,50101,50201,50454],
 [5699,5702,5705,5707,5712,5713,5716,6112,6119,6202,6213,6285,6290,6291,6294,6340,39531,39538,
   39621,39632,39704,39709,39710,39713,39759,47002,47004,47009,47085,47090,47091,47094,47139,47140,
   47143,47245,47248,47266,48391,48396,48397,48400,48445,48446,48551,49499,49500,49503,49605,49608,
   49626,50181,50202,51257],[6340,50203],[6340,50204],[6340,50205],[6340,50206],
 [6340,50207],[6340,50208],[6340,50209],[6340,50210],[6340,50211],[6340,50212],
 [6340,50213],[6340,50214],[6340,50215],[6340,50216],[6340,50217],[6050,46135],
 [5705,6018,6050,39424,39779,45501,46064],
 [5693,5694,5696,5697,5698,5705,5708,5710,5711,5894,5905,5942,6005,6013,6016,6018,6047,6050,6052,
   6080,6086,6286,6288,6289,6360,39313,39315,39316,39317,39324,39327,39329,39330,39352,39353,
   39354,39361,39364,39366,39367,39424,39425,39432,39435,39437,39438,39459,39466,39469,39471,39472,
   39499,39502,39504,39505,39705,39707,39708,39779,39780,39823,43257,43258,43259,43266,43269,43271,
   43272,43329,43330,43337,43340,43342,43343,43364,43371,43374,43376,43377,43404,43407,43409,43410,
   43610,43612,43613,43684,43685,43728,43995,43996,44003,44006,44008,44009,44030,44037,44040,44042,
   44043,44070,44073,44075,44076,44276,44278,44279,44350,44351,44394,45255,45262,45265,45267,45268,
   45295,45298,45300,45301,45501,45503,45504,45575,45576,45619,45856,45859,45861,45862,46062,46064,
   46065,46136,46137,46180,46590,46592,46593,46664,46665,46708,49520,49521,49564,50393],
 [5645,5646,5662,5689,5696,5697,5699,5705,5708,5710,5712,5747,6005,6013,6016,6018,6047,6050,6052,
   6112,6119,6286,6288,6290,6360,38205,38212,38213,38215,38221,38224,38226,38228,38254,38255,
   38257,38263,38266,38268,38270,38521,38523,38529,38532,38534,38536,38557,38563,38566,38568,38570,
   38628,38631,38633,38635,38802,38804,38806,38876,38878,38921,39157,39158,39160,39166,39169,39171,
   39173,39424,39426,39432,39435,39437,39439,39460,39466,39469,39471,39473,39531,39534,39536,39538,
   39705,39707,39709,39779,39781,39824,40285,40287,40293,40296,40298,40300,40321,40327,40330,40332,
   40334,40392,40395,40397,40399,40566,40568,40570,40640,40642,40685,45256,45262,45265,45267,45269,
   45327,45330,45332,45334,45501,45503,45505,45575,45577,45620,45888,45891,45893,45895,46062,46064,
   46066,46136,46138,46181,47086,47088,47090,47160,47162,47205,49520,49522,49565,50394],
 [6050,6183,6340,45951,45952,45957,45959,46111,46116,46118,46139,46141,46241,48035,48040,48042,
   48063,48065,48165,50099,50101,50201,50454],[6050,6152,45922,46140],
 [6050,6183,6340,45951,45952,45957,45959,46111,46116,46118,46139,46141,46241,48035,48040,48042,
   48063,48065,48165,50099,50101,50201,50454],[6050,6213,45981,46142],[6050,46143],
 [6050,46144],[6050,46145],[6050,46146],[6050,46147],[6050,46148],[6050,46149],
 [6050,46150],[6050,46151],[6050,46152],[6050,46153],[6050,46154],[6050,46155],
 [6050,46156],[6050,46157],[6018,45476,45477,45597,49217],
 [5698,5705,5709,5711,6080,6086,6287,6289,39499,39505,39706,39708,46591,46593,46687,49543],
 [5699,5705,5709,5712,6112,6119,6287,6290,39531,39538,39706,39709,47087,47090,47184,49544],
 [6340,50121],[6152],[6183,48087],[6213],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[5693,5694,5696,5697,5698,5705,5708,5710,5711,5894,5905,5942,6005,6013,
   6016,6018,6047,6050,6052,6080,6086,6286,6288,6289,6360,39313,39315,39316,39317,39324,39327,
   39329,39330,39352,39353,39354,39361,39364,39366,39367,39424,39425,39432,39435,39437,39438,39459,
   39466,39469,39471,39472,39499,39502,39504,39505,39705,39707,39708,39779,39780,39823,43257,43258,
   43259,43266,43269,43271,43272,43329,43330,43337,43340,43342,43343,43364,43371,43374,43376,43377,
   43404,43407,43409,43410,43610,43612,43613,43684,43685,43728,43995,43996,44003,44006,44008,44009,
   44030,44037,44040,44042,44043,44070,44073,44075,44076,44276,44278,44279,44350,44351,44394,45255,
   45262,45265,45267,45268,45295,45298,45300,45301,45501,45503,45504,45575,45576,45619,45856,45859,
   45861,45862,46062,46064,46065,46136,46137,46180,46590,46592,46593,46664,46665,46708,49520,49521,
   49564,50393],[5645,5646,5662,5689,5696,5697,5699,5705,5708,5710,5712,5747,6005,6013,6016,
   6018,6047,6050,6052,6112,6119,6286,6288,6290,6360,38205,38212,38213,38215,38221,38224,38226,
   38228,38254,38255,38257,38263,38266,38268,38270,38521,38523,38529,38532,38534,38536,38557,38563,
   38566,38568,38570,38628,38631,38633,38635,38802,38804,38806,38876,38878,38921,39157,39158,39160,
   39166,39169,39171,39173,39424,39426,39432,39435,39437,39439,39460,39466,39469,39471,39473,39531,
   39534,39536,39538,39705,39707,39709,39779,39781,39824,40285,40287,40293,40296,40298,40300,40321,
   40327,40330,40332,40334,40392,40395,40397,40399,40566,40568,40570,40640,40642,40685,45256,45262,
   45265,45267,45269,45327,45330,45332,45334,45501,45503,45505,45575,45577,45620,45888,45891,45893,
   45895,46062,46064,46066,46136,46138,46181,47086,47088,47090,47160,47162,47205,49520,49522,49565,
   50394],[6018,6340,45552,45555,45621,50142],[6018,6152,45363,45622],
 [6018,6183,45393,45398,45623,48108],[6018,6213,45422,45624],[6018,45625,45626,45745,50960],
 [6018,45625,45626,45745,50960],[6018,45627],[6018,45628,45636,45791,51006],[6018,45629],
 [6018,45630,45632,45806,51021],[6018,45631],[6018,45630,45632,45806,51021],[6018,45633],
 [6018,45634,45635,45835,51050],[6018,45634,45635,45835,51050],[6018,45628,45636,45791,51006],
 [6018,45637,45638,45847,51062],[6018,45637,45638,45847,51062],[6018,45639],
 [5698,5699,5705,5711,5712,6080,6086,6112,6119,6289,6290,39499,39505,39531,39538,39708,39709,
   46416,46422,46423,46593,46594,46729,47089,47090,47225,49585],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,3501,3507,3510,3512,3517,
   3518,3519,3523,3525,3526,3544,3550,3560,3561,3592,3602,3603,3826,3828,3833,3834,3835,3839,
   3841,3842,3930,3935,3936,3937,3941,3998,3999,4000,4004,4139,4140,4144,4146,4147,4165,4169,
   4171,4172,4193,4195,4196,4281,4282,4319,4510,4511,4512,4518,4528,4529,5645,5646,5652,5662,
   5663,5689,5695,5698,5700,5705,5706,5707,5711,5713,5714,5737,5747,5748,5971,5973,5978,5979,
   5980,5984,5986,5987,6075,6080,6081,6086,6089,6143,6144,6145,6149,6151,6152,6284,6285,6289,
   6291,6292,6310,6314,6316,6317,6340,6341,6427,6464,7725,7726,7732,7742,7743,7769,7775,7785,
   7786,7817,7820,7822,7827,7828,7829,7833,7835,7836,8051,8053,8058,8059,8060,8064,8066,8067,
   8155,8160,8161,8162,8166,8168,8169,8223,8224,8225,8231,8364,8365,8369,8371,8372,8390,8394,
   8396,8397,8420,8506,8507,8544,38205,38211,38221,38222,38253,38263,38264,38487,38489,38494,
   38495,38496,38500,38502,38503,38591,38800,38854,38980,39156,39166,39167,39397,39398,39499,39505,
   39562,39571,39703,39704,39708,39710,39711,39759,40258,40259,40361,40368,40424,40425,40564,40590,
   40594,40596,40597,40707,44695,44700,44701,44702,44706,44708,44709,44763,44764,44765,44769,44771,
   44772,44904,44905,44909,44911,44912,44930,44934,44936,44937,44958,44960,44961,45046,45047,45084,
   46447,46448,46449,46453,46455,46456,46588,46589,46593,46595,46596,46614,46618,46620,46621,46642,
   46644,46645,46730,46731,46768,47549,47550,47554,47556,47557,47575,47579,47581,47582,47603,47605,
   47606,47691,47692,47729,49470,49474,49476,49477,49498,49500,49501,49586,49587,49624,49798,49800,
   49801,49886,49887,49924,50162,50163,50200,51084],
 [5698,5700,5705,5711,5714,6080,6086,6143,6152,6289,6292,39499,39505,39562,39571,39708,39711,
   46447,46453,46593,46596,46731,47554,47557,49587],
 [5698,5701,5705,5711,5715,6080,6086,6173,6183,6289,6293,39499,39505,39592,39602,39708,39712,
   46477,46483,46487,46593,46597,46732,47989,47993,48128,49588],
 [5698,5702,5705,5711,5716,6080,6086,6202,6213,6289,6294,39499,39505,39621,39632,39708,39713,
   46506,46512,46593,46598,46733,48395,48400,49589],
 [5698,5705,5711,5717,6080,6086,6289,6295,39499,39505,39708,39714,46593,46599,46734,49590],
 [5698,5705,5711,5718,6080,6086,6289,6296,39499,39505,39708,39715,46593,46600,46735,49591],
 [5698,5705,5711,5719,6080,6086,6289,6297,39499,39505,39708,39716,46593,46601,46736,49592],
 [5698,5705,5711,5720,6080,6086,6289,6298,39499,39505,39708,39717,46593,46602,46737,49593],
 [5698,5705,5711,5721,6080,6086,6289,6299,39499,39505,39708,39718,46593,46603,46738,49594],
 [5698,5705,5711,5722,6080,6086,6289,6300,39499,39505,39708,39719,46593,46604,46739,49595],
 [5698,5705,5711,5723,6080,6086,6289,6301,39499,39505,39708,39720,46593,46605,46740,49596],
 [5698,5705,5711,5724,6080,6086,6289,6302,39499,39505,39708,39721,46593,46606,46741,49597],
 [5698,5705,5711,5725,6080,6086,6289,6303,39499,39505,39708,39722,46593,46607,46742,49598],
 [5698,5705,5711,5726,6080,6086,6289,6304,39499,39505,39708,39723,46593,46608,46743,49599],
 [5698,5705,5711,5727,6080,6086,6289,6305,39499,39505,39708,39724,46593,46609,46744,49600],
 [5698,5705,5711,5728,6080,6086,6289,6306,39499,39505,39708,39725,46593,46610,46745,49601],
 [5698,5705,5711,5729,6080,6086,6289,6307,39499,39505,39708,39726,46593,46611,46746,49602],
 [5698,5705,5711,5730,6080,6086,6289,6308,39499,39505,39708,39727,46593,46612,46747,49603],
 [5698,5705,5711,5731,6080,6086,6289,6309,39499,39505,39708,39728,46593,46613,46748,49604],
 [5699,5702,5705,5707,5712,5713,5716,6112,6119,6202,6213,6285,6290,6291,6294,6340,39531,39538,
   39621,39632,39704,39709,39710,39713,39759,47002,47004,47009,47085,47090,47091,47094,47139,47140,
   47143,47245,47248,47266,48391,48396,48397,48400,48445,48446,48551,49499,49500,49503,49605,49608,
   49626,50181,50202,51257],[5699,5700,5705,5712,5714,6112,6119,6143,6152,6290,6292,39531,39538,
   39562,39571,39709,39711,46943,46950,47090,47092,47246,47555,47557,49606],
 [5699,5701,5705,5712,5715,6112,6119,6173,6183,6290,6293,39531,39538,39592,39602,39709,39712,
   46973,46980,46983,47090,47093,47247,47990,47993,48147,49607],
 [5699,5702,5705,5707,5712,5713,5716,6112,6119,6202,6213,6285,6290,6291,6294,6340,39531,39538,
   39621,39632,39704,39709,39710,39713,39759,47002,47004,47009,47085,47090,47091,47094,47139,47140,
   47143,47245,47248,47266,48391,48396,48397,48400,48445,48446,48551,49499,49500,49503,49605,49608,
   49626,50181,50202,51257],[5699,5705,5712,5717,5719,6112,6119,6290,6295,6297,39531,39538,
   39709,39714,39716,47090,47095,47097,47249,47251,47331,49609,49611,49691,51322],
 [5699,5705,5712,5718,6112,6119,6290,6296,39531,39538,39709,39715,47090,47096,47250,49610],
 [5699,5705,5712,5717,5719,6112,6119,6290,6295,6297,39531,39538,39709,39714,39716,47090,47095,
   47097,47249,47251,47331,49609,49611,49691,51322],
 [5699,5705,5712,5720,6112,6119,6290,6298,39531,39538,39709,39717,47090,47098,47252,49612],
 [5699,5705,5712,5721,6112,6119,6290,6299,39531,39538,39709,39718,47090,47099,47253,49613],
 [5699,5705,5712,5722,6112,6119,6290,6300,39531,39538,39709,39719,47090,47100,47254,49614],
 [5699,5705,5712,5723,5724,6112,6119,6290,6301,6302,39531,39538,39709,39720,39721,47090,47101,
   47102,47255,47256,47399,49615,49616,49759,51390],
 [5699,5705,5712,5723,5724,6112,6119,6290,6301,6302,39531,39538,39709,39720,39721,47090,47101,
   47102,47255,47256,47399,49615,49616,49759,51390],
 [5699,5705,5712,5725,6112,6119,6290,6303,39531,39538,39709,39722,47090,47103,47257,49617],
 [5699,5705,5712,5726,6112,6119,6290,6304,39531,39538,39709,39723,47090,47104,47258,49618],
 [5699,5705,5712,5727,6112,6119,6290,6305,39531,39538,39709,39724,47090,47105,47259,49619],
 [5699,5705,5712,5728,6112,6119,6290,6306,39531,39538,39709,39725,47090,47106,47260,49620],
 [5699,5705,5712,5729,5731,6112,6119,6290,6307,6309,39531,39538,39709,39726,39728,47090,47107,
   47109,47261,47263,47433,49621,49623,49793,51424],
 [5699,5705,5712,5730,6112,6119,6290,6308,39531,39538,39709,39727,47090,47108,47262,49622],
 [5699,5705,5712,5729,5731,6112,6119,6290,6307,6309,39531,39538,39709,39726,39728,47090,47107,
   47109,47261,47263,47433,49621,49623,49793,51424],
 [5695,5700,5705,5706,5707,5713,5714,5978,5979,6143,6152,6284,6285,6291,6292,6340,39397,39398,
   39562,39571,39703,39704,39710,39711,39759,44763,44764,44765,44904,44905,44911,44912,44930,44936,
   44937,44960,44961,45084,47549,47550,47556,47557,47575,47581,47605,49470,49476,49477,49500,49501,
   49624,49800,49924,50200],[6050,6183,6340,45951,45952,45957,45959,46111,46116,46118,46139,
   46141,46241,48035,48040,48042,48063,48065,48165,50099,50101,50201,50454],
 [5699,5702,5705,5707,5712,5713,5716,6112,6119,6202,6213,6285,6290,6291,6294,6340,39531,39538,
   39621,39632,39704,39709,39710,39713,39759,47002,47004,47009,47085,47090,47091,47094,47139,47140,
   47143,47245,47248,47266,48391,48396,48397,48400,48445,48446,48551,49499,49500,49503,49605,49608,
   49626,50181,50202,51257],[6340,50203],[6340,50204],[6340,50205],[6340,50206],
 [6340,50207],[6340,50208],[6340,50209],[6340,50210],[6340,50211],[6340,50212],
 [6340,50213],[6340,50214],[6340,50215],[6340,50216],[6340,50217],
 [5690,5691,5700,5701,5705,5714,5715,5774,5788,5828,6143,6152,6173,6183,6292,6293,39193,39202,
   39203,39207,39216,39217,39242,39243,39247,39256,39257,39558,39562,39571,39572,39592,39601,39602,
   39711,39712,39901,40923,40924,40928,40937,40938,41239,41253,41283,41582,42019,42062,42063,42362,
   47448,47557,47993,48182],[6152,6213,42761,43104],[6152],[6152],[6152],[6152],[6152],
 [6152],[6152],[6152],[6152],[6152],[6152],[6152],[6152],[6152],[6152],
 [5645,5646,5662,5689,5701,5702,5705,5715,5716,5747,6173,6183,6202,6213,6293,6294,38205,38217,
   38218,38221,38231,38232,38259,38260,38263,38273,38274,38686,38699,38700,39015,39162,39163,39166,
   39176,39177,39589,39592,39602,39603,39621,39631,39632,39712,39713,39918,40450,40463,40492,40779,
   47912,47993,48199,48400],[6183,48200],[6183,48201],[6183,48202],[6183,48203],
 [6183,48204],[6183,48205],[6183,48206],[6183,48207],[6183,48208],[6183,48209],
 [6183,48210],[6183,48211],[6183,48212],[6183,48213],[6183,48214],[6213],[6213],[6213],
 [6213],[6213],[6213],[6213],[6213],[6213],[6213],[6213],[6213],[6213],[6213],
 [6213],[6018,45625,45626,45745,50960],
 [5699,5705,5712,5717,5719,6112,6119,6290,6295,6297,39531,39538,39709,39714,39716,47090,47095,
   47097,47249,47251,47331,49609,49611,49691,51322],[],[],[],[],[],[],[],[],[],
 [],[],[],[5645,5646,5662,5689,5705,5718,5719,5747,6296,6297,38205,38221,38234,38235,38263,
   38276,38277,39060,39166,39179,39180,39715,39716,39963,40824],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [5690,5691,5705,5720,5721,5774,5788,5828,6298,6299,39193,39207,39222,39223,39247,39262,39263,
   39717,39718,39988,40928,40943,40944,41669,42449],[],[],[],[],[14514],[],
 [6018,45628,45636,45791,51006],[],[],[],[],[],[],[14523],[],[],
 [5695,5705,5706,5721,5728,5978,5979,6284,6299,6306,39397,39398,39703,39718,39725,44904,44919,
   44926,44944,44951,45206,49484,49491,49746,50046],[],[],[],
 [5645,5646,5662,5689,5705,5722,5723,5747,6300,6301,38205,38221,38238,38239,38263,38280,38281,
   39106,39166,39183,39184,39719,39720,40009,40870],[6018,45630,45632,45806,51021],[],[],
 [],[],[],[19848],[],[5699,5705,5712,5723,5724,6112,6119,6290,6301,6302,39531,39538,
   39709,39720,39721,47090,47101,47102,47255,47256,47399,49615,49616,49759,51390],[],[],[],
 [],[],[],[19857],[],[],[],[],[19862],[],[],
 [5690,5691,5705,5725,5726,5774,5788,5828,6303,6304,39193,39207,39227,39228,39247,39267,39268,
   39722,39723,40033,40928,40948,40949,41714,42494],
 [5695,5705,5706,5725,5727,5978,5979,6284,6303,6305,39397,39398,39703,39722,39724,44904,44923,
   44925,44948,44950,45235,49488,49490,49775,50075],[],[],[],[],
 [6018,45634,45635,45835,51050],[],[],[],[],[14565],[],[],[],[],[],[],
 [6018,45637,45638,45847,51062],[5699,5705,5712,5729,5731,6112,6119,6290,6307,6309,39531,39538,
   39709,39726,39728,47090,47107,47109,47261,47263,47433,49621,49623,49793,51424],
 [5645,5646,5662,5689,5705,5730,5731,5747,6308,6309,38205,38221,38246,38247,38263,38288,38289,
   39150,39166,39191,39192,39727,39728,40053,40914],[8715],[8715],[],[202],[8962],[],
 [8962],[],[],[],[],[],[],[],[],[],[],[],[],
 [6656,6673,7725,7726,7743,7769,7786,7828,9741,9742,9785,9844,38205,38222,38264,39167],
 [6656,6673,7725,7726,7743,7769,7786,7828,9741,9742,9785,9844,38205,38222,38264,39167],[7828],
 [7875,9891],[6656,6673,7813,7828,7832,7909,7913,8393,9844,9925,9929,10409,40109,40113,40593,
   42193],[7950,9966],[7996,10012],[8032],
 [6656,6673,7817,7827,7828,8058,8059,8364,9844,10074,10075,10380,40258,40259,40564,44904],
 [6656,6673,7818,7821,7828,8087,8094,8193,9834,9837,9844,10103,40287,40294,40393,45328],[],
 [8168],[6656,6673,7818,7821,7828,8087,8094,8193,9834,9837,9844,10103,40287,40294,40393,45328],
 [6656,6673,7822,7828,7829,8224,8225,8390,9844,10240,10241,10406,40424,40425,40590,47575],
 [6656,6673,7823,7824,7828,8250,8254,8283,9839,9840,9844,10266,40450,40454,40483,47903],
 [6656,6673,7823,7824,7828,8250,8254,8283,9839,9840,9844,10266,40450,40454,40483,47903],[],
 [],[6656,6673,7817,7827,7828,8058,8059,8364,9844,10074,10075,10380,40258,40259,40564,44904],
 [7828],[6656,6673,7822,7828,7829,8224,8225,8390,9844,10240,10241,10406,40424,40425,40590,47575],
 [7950,9966],[],[6656,6673,7813,7828,7832,7909,7913,8393,9844,9925,9929,10409,40109,40113,
   40593,42193],[8507,10523],[7875,9891],[8168],[8507,10523],[8032],[7996,10012],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[8715],[],[10854],
 [10854],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [6719,6736,7725,7726,7743,7769,7786,7828,11694,11695,11738,11797,38205,38222,38264,39167],
 [6719,6736,7725,7726,7743,7769,7786,7828,11694,11695,11738,11797,38205,38222,38264,39167],
 [7828],[7875,11844],[6719,6736,7813,7828,7832,7909,7913,8393,11797,11878,11882,12362,40109,
   40113,40593,42193],[7950,11919],[7996,11965],[8032],
 [6719,6736,7817,7827,7828,8058,8059,8364,11797,12027,12028,12333,40258,40259,40564,44904],
 [6719,6736,7818,7821,7828,8087,8094,8193,11787,11790,11797,12056,40287,40294,40393,45328],[],
 [8168],[6719,6736,7818,7821,7828,8087,8094,8193,11787,11790,11797,12056,40287,40294,40393,45328]
  ,[6719,6736,7822,7828,7829,8224,8225,8390,11797,12193,12194,12359,40424,40425,40590,47575],
 [6719,6736,7823,7824,7828,8250,8254,8283,11792,11793,11797,12219,40450,40454,40483,47903],
 [6719,6736,7823,7824,7828,8250,8254,8283,11792,11793,11797,12219,40450,40454,40483,47903],[],
 [],[6719,6736,7817,7827,7828,8058,8059,8364,11797,12027,12028,12333,40258,40259,40564,44904],
 [7828],[6719,6736,7822,7828,7829,8224,8225,8390,11797,12193,12194,12359,40424,40425,40590,47575]
  ,[7950,11919],[],[6719,6736,7813,7828,7832,7909,7913,8393,11797,11878,11882,12362,40109,
   40113,40593,42193],[8507,12476],[7875,11844],[8168],[8507,12476],[8032],[7996,11965],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[12747],[],
 [],[12747],[12979],[12979],[],[],[],[],[],[],[],[],[],[],
 [6781,6798,7725,7726,7743,7769,7786,7828,13585,13586,13629,13688,38205,38222,38264,39167],
 [6781,6798,7725,7726,7743,7769,7786,7828,13585,13586,13629,13688,38205,38222,38264,39167],
 [7828],[7875,7950,13735,13810],[6781,6798,7813,7828,7832,7909,7913,8393,13688,13769,13773,
   14253,40109,40113,40593,42193],[7875,7950,13735,13810],[7996,13856],[8032],
 [6781,6798,7817,7827,7828,8058,8059,8364,13688,13918,13919,14224,40258,40259,40564,44904],
 [6781,6798,7818,7821,7828,8087,8094,8193,13678,13681,13688,13947,40287,40294,40393,45328],[],
 [8168],[6781,6798,7818,7821,7828,8087,8094,8193,13678,13681,13688,13947,40287,40294,40393,45328]
  ,[6781,6798,7822,7828,7829,8224,8225,8390,13688,14084,14085,14250,40424,40425,40590,47575],
 [6781,6798,7823,7824,7828,8250,8254,8283,13683,13684,13688,14110,40450,40454,40483,47903],
 [6781,6798,7823,7824,7828,8250,8254,8283,13683,13684,13688,14110,40450,40454,40483,47903],[],
 [],[6781,6798,7817,7827,7828,8058,8059,8364,13688,13918,13919,14224,40258,40259,40564,44904],
 [7828],[6781,6798,7822,7828,7829,8224,8225,8390,13688,14084,14085,14250,40424,40425,40590,47575]
  ,[7875,7950,13735,13810],[],[6781,6798,7813,7828,7832,7909,7913,8393,13688,13769,13773,
   14253,40109,40113,40593,42193],[8507,14367],[7875,7950,13735,13810],[8168],[8507,14367],
 [8032],[7996,13856],[],[],[],[14514],[14523,14565],[],[],[],[14523,14565],
 [14514],[14523,14565],[14523,14565],[],[],[],[],[14635],[14635],[],[],[],
 [],[],[],[],[],[],[],[],[],[],
 [6842,6859,7725,7726,7743,7769,7786,7828,15415,15416,15459,15518,38205,38222,38264,39167],
 [6842,6859,7725,7726,7743,7769,7786,7828,15415,15416,15459,15518,38205,38222,38264,39167],
 [7828],[7875,15565],[6842,6859,7813,7828,7832,7909,7913,8393,15518,40109,40113,40593,42193],
 [7950,15640],[7996,15686],[8032],[6842,6859,7817,7827,7828,8058,8059,8364,15518,15748,15749,
   16054,40258,40259,40564,44904],[6842,6859,7818,7821,7828,8087,8094,8193,15508,15511,15518,
   15777,40287,40294,40393,45328],[],[8168],
 [6842,6859,7818,7821,7828,8087,8094,8193,15508,15511,15518,15777,40287,40294,40393,45328],
 [6842,6859,7822,7828,7829,8224,8225,8390,15518,15914,15915,16080,40424,40425,40590,47575],
 [6842,6859,7823,7824,7828,8250,8254,8283,15513,15514,15518,15940,40450,40454,40483,47903],
 [6842,6859,7823,7824,7828,8250,8254,8283,15513,15514,15518,15940,40450,40454,40483,47903],[],
 [],[6842,6859,7817,7827,7828,8058,8059,8364,15518,15748,15749,16054,40258,40259,40564,44904],
 [7828],[6842,6859,7822,7828,7829,8224,8225,8390,15518,15914,15915,16080,40424,40425,40590,47575]
  ,[7950,15640],[],[6842,6859,7813,7828,7832,7909,7913,8393,15518,40109,40113,40593,42193],
 [8507,16197],[7875,15565],[8168],[8507,16197],[8032],[7996,15686],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[10854],[],[12747],[],[],[],
 [],[],[],[],[],[],[],[],[],
 [6902,6919,7725,7726,7743,7769,7786,7828,17185,17186,17229,17288,38205,38222,38264,39167],
 [6902,6919,7725,7726,7743,7769,7786,7828,17185,17186,17229,17288,38205,38222,38264,39167],
 [7828],[7875,17335],[6902,6919,7813,7828,7832,7909,7913,8393,17288,17369,17373,17853,40109,
   40113,40593,42193],[7950,17410],[7996,17456],[8032],
 [6902,6919,7817,7827,7828,8058,8059,8364,17288,17518,17519,17824,40258,40259,40564,44904],
 [6902,6919,7818,7821,7828,8087,8094,8193,17278,17281,17288,17547,40287,40294,40393,45328],[],
 [8168],[6902,6919,7818,7821,7828,8087,8094,8193,17278,17281,17288,17547,40287,40294,40393,45328]
  ,[6902,6919,7822,7828,7829,8224,8225,8390,17288,17684,17685,17850,40424,40425,40590,47575],
 [6902,6919,7823,7824,7828,8250,8254,8283,17283,17284,17288,17710,40450,40454,40483,47903],
 [6902,6919,7823,7824,7828,8250,8254,8283,17283,17284,17288,17710,40450,40454,40483,47903],[],
 [],[6902,6919,7817,7827,7828,8058,8059,8364,17288,17518,17519,17824,40258,40259,40564,44904],
 [7828],[6902,6919,7822,7828,7829,8224,8225,8390,17288,17684,17685,17850,40424,40425,40590,47575]
  ,[7950,17410],[],[6902,6919,7813,7828,7832,7909,7913,8393,17288,17369,17373,17853,40109,
   40113,40593,42193],[8507,17967],[7875,17335],[8168],[8507,17967],[8032],[7996,17456],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[14635],[8962],
 [],[],[],[],[],[],[],[],[],[],[],[],
 [6961,6978,7725,7726,7743,7769,7786,7828,18896,18897,18940,18999,38205,38222,38264,39167],
 [6961,6978,7725,7726,7743,7769,7786,7828,18896,18897,18940,18999,38205,38222,38264,39167],
 [7828],[7875,7950,19046,19121],[6961,6978,7813,7828,7832,7909,7913,8393,18999,19080,19084,
   19564,40109,40113,40593,42193],[7875,7950,19046,19121],[7996,19167],[8032],
 [6961,6978,7817,7827,7828,8058,8059,8364,18999,19229,19230,19535,40258,40259,40564,44904],
 [6961,6978,7818,7821,7828,8087,8094,8193,18989,18992,18999,19258,40287,40294,40393,45328],[],
 [8168],[6961,6978,7818,7821,7828,8087,8094,8193,18989,18992,18999,19258,40287,40294,40393,45328]
  ,[6961,6978,7822,7828,7829,8224,8225,8390,18999,19395,19396,19561,40424,40425,40590,47575],
 [6961,6978,7823,7824,7828,8250,8254,8283,18994,18995,18999,19421,40450,40454,40483,47903],
 [6961,6978,7823,7824,7828,8250,8254,8283,18994,18995,18999,19421,40450,40454,40483,47903],[],
 [],[6961,6978,7817,7827,7828,8058,8059,8364,18999,19229,19230,19535,40258,40259,40564,44904],
 [7828],[6961,6978,7822,7828,7829,8224,8225,8390,18999,19395,19396,19561,40424,40425,40590,47575]
  ,[7875,7950,19046,19121],[],[6961,6978,7813,7828,7832,7909,7913,8393,18999,19080,19084,
   19564,40109,40113,40593,42193],[8507,19678],[7875,7950,19046,19121],[8168],[8507,19678],
 [8032],[7996,19167],[],[],[],[],[],[19848,19857],[19848,19857],[19862],[],[],
 [],[],[19862],[19848,19857],[19848,19857],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[7019,7036,7725,7726,7743,7769,7786,7828,20549,20550,20593,20652,38205,38222,
   38264,39167],[7019,7036,7725,7726,7743,7769,7786,7828,20549,20550,20593,20652,38205,38222,
   38264,39167],[7828],[7875,20699],[7019,7036,7813,7828,7832,7909,7913,8393,20652,20733,
   20737,21217,40109,40113,40593,42193],[7950,20774],[7996,20820],[8032],
 [7019,7036,7817,7827,7828,8058,8059,8364,20652,20882,20883,21188,40258,40259,40564,44904],
 [7019,7036,7818,7821,7828,8087,8094,8193,20642,20645,20652,20911,40287,40294,40393,45328],[],
 [8168],[7019,7036,7818,7821,7828,8087,8094,8193,20642,20645,20652,20911,40287,40294,40393,45328]
  ,[7019,7036,7822,7828,7829,8224,8225,8390,20652,21048,21049,21214,40424,40425,40590,47575],
 [7019,7036,7823,7824,7828,8250,8254,8283,20647,20648,20652,21074,40450,40454,40483,47903],
 [7019,7036,7823,7824,7828,8250,8254,8283,20647,20648,20652,21074,40450,40454,40483,47903],[],
 [],[7019,7036,7817,7827,7828,8058,8059,8364,20652,20882,20883,21188,40258,40259,40564,44904],
 [7828],[7019,7036,7822,7828,7829,8224,8225,8390,20652,21048,21049,21214,40424,40425,40590,47575]
  ,[7950,20774],[],[7019,7036,7813,7828,7832,7909,7913,8393,20652,20733,20737,21217,40109,
   40113,40593,42193],[8507,21331],[7875,20699],[8168],[8507,21331],[8032],[7996,20820],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[7076,7093,7725,7726,7743,7769,7786,7813,7828,7832,7909,
   7913,8393,22145,22146,22189,22248,22329,22333,22813,38205,38222,38264,39167,40109,40113,40593,
   42193],[7076,7093,7725,7726,7743,7769,7786,7813,7828,7832,7909,7913,8393,22145,22146,22189,
   22248,22329,22333,22813,38205,38222,38264,39167,40109,40113,40593,42193],[7828],[7875],
 [7076,7093,7725,7726,7743,7769,7786,7813,7828,7832,7909,7913,8393,22145,22146,22189,22248,22329,
   22333,22813,38205,38222,38264,39167,40109,40113,40593,42193],[7950,22370],[7996,22416],
 [8032],[7076,7093,7817,7818,7821,7827,7828,8058,8059,8087,8094,8193,8364,22238,22241,22248,
   22478,22479,22507,22784,40258,40259,40287,40294,40393,40564,44904,45328],
 [7076,7093,7817,7818,7821,7827,7828,8058,8059,8087,8094,8193,8364,22238,22241,22248,22478,22479,
   22507,22784,40258,40259,40287,40294,40393,40564,44904,45328],[],[8168],
 [7076,7093,7817,7818,7821,7827,7828,8058,8059,8087,8094,8193,8364,22238,22241,22248,22478,22479,
   22507,22784,40258,40259,40287,40294,40393,40564,44904,45328],
 [7076,7093,7822,7823,7824,7828,7829,8224,8225,8250,8254,8283,8390,22243,22244,22248,22644,22645,
   22670,22810,40424,40425,40450,40454,40483,40590,47575,47903],
 [7076,7093,7822,7823,7824,7828,7829,8224,8225,8250,8254,8283,8390,22243,22244,22248,22644,22645,
   22670,22810,40424,40425,40450,40454,40483,40590,47575,47903],
 [7076,7093,7822,7823,7824,7828,7829,8224,8225,8250,8254,8283,8390,22243,22244,22248,22644,22645,
   22670,22810,40424,40425,40450,40454,40483,40590,47575,47903],[],[],
 [7076,7093,7817,7818,7821,7827,7828,8058,8059,8087,8094,8193,8364,22238,22241,22248,22478,22479,
   22507,22784,40258,40259,40287,40294,40393,40564,44904,45328],[7828],
 [7076,7093,7822,7823,7824,7828,7829,8224,8225,8250,8254,8283,8390,22243,22244,22248,22644,22645,
   22670,22810,40424,40425,40450,40454,40483,40590,47575,47903],[7950,22370],[],
 [7076,7093,7725,7726,7743,7769,7786,7813,7828,7832,7909,7913,8393,22145,22146,22189,22248,22329,
   22333,22813,38205,38222,38264,39167,40109,40113,40593,42193],[8507,22927],[7875],[8168],
 [8507,22927],[8032],[7996,22416],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[12979],[],[],[],[],[],[],[],[],[],[],
 [7132,7149,7725,7726,7743,7769,7786,7828,23685,23686,23729,23788,38205,38222,38264,39167],
 [7132,7149,7725,7726,7743,7769,7786,7828,23685,23686,23729,23788,38205,38222,38264,39167],
 [7828],[7875,23835],[7132,7149,7813,7828,7832,7909,7913,8393,23788,23869,23873,24353,40109,
   40113,40593,42193],[7950,23910],[7996,23956],[8032],
 [7132,7149,7817,7827,7828,8058,8059,8364,23788,24018,24019,24324,40258,40259,40564,44904],
 [7132,7149,7818,7821,7828,8087,8094,8193,23788,40287,40294,40393,45328],[],[8168],
 [7132,7149,7818,7821,7828,8087,8094,8193,23788,40287,40294,40393,45328],
 [7132,7149,7822,7828,7829,8224,8225,8390,23788,24184,24185,24350,40424,40425,40590,47575],
 [7132,7149,7823,7824,7828,8250,8254,8283,23783,23784,23788,24210,40450,40454,40483,47903],
 [7132,7149,7823,7824,7828,8250,8254,8283,23783,23784,23788,24210,40450,40454,40483,47903],[],
 [],[7132,7149,7817,7827,7828,8058,8059,8364,23788,24018,24019,24324,40258,40259,40564,44904],
 [7828],[7132,7149,7822,7828,7829,8224,8225,8390,23788,24184,24185,24350,40424,40425,40590,47575]
  ,[7950,23910],[],[7132,7149,7813,7828,7832,7909,7913,8393,23788,23869,23873,24353,40109,
   40113,40593,42193],[8507,24467],[7875,23835],[8168],[8507,24467],[8032],[7996,23956],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[7187,7204,7725,7726,7743,7769,7786,7828,25170,25171,25214,25273,
   38205,38222,38264,39167],[7187,7204,7725,7726,7743,7769,7786,7828,25170,25171,25214,25273,
   38205,38222,38264,39167],[7828],[7875,25320],
 [7187,7204,7813,7828,7832,7909,7913,8393,25273,25354,25358,25838,40109,40113,40593,42193],
 [7950,25395],[7996,25441],[8032],[7187,7204,7817,7827,7828,8058,8059,8364,25273,25503,25504,
   25809,40258,40259,40564,44904],[7187,7204,7818,7821,7828,8087,8094,8193,25263,25266,25273,
   25532,40287,40294,40393,45328],[],[8168],
 [7187,7204,7818,7821,7828,8087,8094,8193,25263,25266,25273,25532,40287,40294,40393,45328],
 [7187,7204,7822,7828,7829,8224,8225,8390,25273,25669,25670,25835,40424,40425,40590,47575],
 [7187,7204,7823,7824,7828,8250,8254,8283,25268,25269,25273,25695,40450,40454,40483,47903],
 [7187,7204,7823,7824,7828,8250,8254,8283,25268,25269,25273,25695,40450,40454,40483,47903],[],
 [],[7187,7204,7817,7827,7828,8058,8059,8364,25273,25503,25504,25809,40258,40259,40564,44904],
 [7828],[7187,7204,7822,7828,7829,8224,8225,8390,25273,25669,25670,25835,40424,40425,40590,47575]
  ,[7950,25395],[],[7187,7204,7813,7828,7832,7909,7913,8393,25273,25354,25358,25838,40109,
   40113,40593,42193],[8507,25952],[7875,25320],[8168],[8507,25952],[8032],[7996,25441],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[26160],[26160],
 [],[26316],[26316],[],[],[26510],[26510],
 [7241,7258,7725,7726,7743,7769,7786,7828,26601,26602,26645,26704,38205,38222,38264,39167],
 [7241,7258,7725,7726,7743,7769,7786,7828,26601,26602,26645,26704,38205,38222,38264,39167],
 [7828],[7875,26751],[7241,7258,7813,7828,7832,7909,7913,8393,26704,26785,26789,27269,40109,
   40113,40593,42193],[7950,26826],[7996,26872],[8032],
 [7241,7258,7817,7827,7828,8058,8059,8364,26704,26934,26935,27240,40258,40259,40564,44904],
 [7241,7258,7818,7821,7828,8087,8094,8193,26694,26697,26704,26963,40287,40294,40393,45328],[],
 [8168],[7241,7258,7818,7821,7828,8087,8094,8193,26694,26697,26704,26963,40287,40294,40393,45328]
  ,[7241,7258,7822,7828,7829,8224,8225,8390,26704,27100,27101,27266,40424,40425,40590,47575],
 [7241,7258,7823,7824,7828,8250,8254,8283,26699,26700,26704,27126,40450,40454,40483,47903],
 [7241,7258,7823,7824,7828,8250,8254,8283,26699,26700,26704,27126,40450,40454,40483,47903],[],
 [],[7241,7258,7817,7827,7828,8058,8059,8364,26704,26934,26935,27240,40258,40259,40564,44904],
 [7828],[7241,7258,7822,7828,7829,8224,8225,8390,26704,27100,27101,27266,40424,40425,40590,47575]
  ,[7950,26826],[],[7241,7258,7813,7828,7832,7909,7913,8393,26704,26785,26789,27269,40109,
   40113,40593,42193],[8507,27383],[7875,26751],[8168],[8507,27383],[8032],[7996,26872],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[26160],[27643],
 [27643],[],[],[27841],[27841],[],[7294,7311,7725,7726,7743,7769,7786,7828,27979,27980,
   28023,28082,38205,38222,38264,39167],[7294,7311,7725,7726,7743,7769,7786,7828,27979,27980,
   28023,28082,38205,38222,38264,39167],[7828],[7875,28129],
 [7294,7311,7813,7828,7832,7909,7913,8393,28082,28163,28167,28647,40109,40113,40593,42193],
 [7950,28204],[7996,28250],[8032],[7294,7311,7817,7827,7828,8058,8059,8364,28082,28312,28313,
   28618,40258,40259,40564,44904],[7294,7311,7818,7821,7828,8087,8094,8193,28072,28075,28082,
   28341,40287,40294,40393,45328],[],[8168],
 [7294,7311,7818,7821,7828,8087,8094,8193,28072,28075,28082,28341,40287,40294,40393,45328],
 [7294,7311,7822,7828,7829,8224,8225,8390,28082,28478,28479,28644,40424,40425,40590,47575],
 [7294,7311,7823,7824,7828,8250,8254,8283,28077,28078,28082,28504,40450,40454,40483,47903],
 [7294,7311,7823,7824,7828,8250,8254,8283,28077,28078,28082,28504,40450,40454,40483,47903],[],
 [],[7294,7311,7817,7827,7828,8058,8059,8364,28082,28312,28313,28618,40258,40259,40564,44904],
 [7828],[7294,7311,7822,7828,7829,8224,8225,8390,28082,28478,28479,28644,40424,40425,40590,47575]
  ,[7950,28204],[],[7294,7311,7813,7828,7832,7909,7913,8393,28082,28163,28167,28647,40109,
   40113,40593,42193],[8507,28761],[7875,28129],[8168],[8507,28761],[8032],[7996,28250],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[28970],[],
 [28970],[],[29168],[],[29168],[7346,7363,7725,7726,7743,7769,7786,7828,29305,29306,29349,
   29408,38205,38222,38264,39167],[7346,7363,7725,7726,7743,7769,7786,7828,29305,29306,29349,
   29408,38205,38222,38264,39167],[7828],[7875,29455],
 [7346,7363,7813,7828,7832,7909,7913,8393,29408,29489,29493,29973,40109,40113,40593,42193],
 [7950,29530],[7996,29576],[8032],[7346,7363,7817,7827,7828,8058,8059,8364,29408,29638,29639,
   29944,40258,40259,40564,44904],[7346,7363,7818,7821,7828,8087,8094,8193,29398,29401,29408,
   29667,40287,40294,40393,45328],[],[8168],
 [7346,7363,7818,7821,7828,8087,8094,8193,29398,29401,29408,29667,40287,40294,40393,45328],
 [7346,7363,7822,7828,7829,8224,8225,8390,29408,29804,29805,29970,40424,40425,40590,47575],
 [7346,7363,7823,7824,7828,8250,8254,8283,29403,29404,29408,29830,40450,40454,40483,47903],
 [7346,7363,7823,7824,7828,8250,8254,8283,29403,29404,29408,29830,40450,40454,40483,47903],[],
 [],[7346,7363,7817,7827,7828,8058,8059,8364,29408,29638,29639,29944,40258,40259,40564,44904],
 [7828],[7346,7363,7822,7828,7829,8224,8225,8390,29408,29804,29805,29970,40424,40425,40590,47575]
  ,[7950,29530],[],[7346,7363,7813,7828,7832,7909,7913,8393,29408,29489,29493,29973,40109,
   40113,40593,42193],[8507,30087],[7875,29455],[8168],[8507,30087],[8032],[7996,29576],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[27643],[28970],
 [30394],[30394],[],[],[7397,7414,7725,7726,7743,7769,7786,7828,30580,30581,30624,30683,
   38205,38222,38264,39167],[7397,7414,7725,7726,7743,7769,7786,7828,30580,30581,30624,30683,
   38205,38222,38264,39167],[7828],[7875,30730],
 [7397,7414,7813,7828,7832,7909,7913,8393,30683,30764,30768,31248,40109,40113,40593,42193],
 [7950,30805],[7996,30851],[8032],[7397,7414,7817,7827,7828,8058,8059,8364,30683,30913,30914,
   31219,40258,40259,40564,44904],[7397,7414,7818,7821,7828,8087,8094,8193,30673,30676,30683,
   30942,40287,40294,40393,45328],[],[8168],
 [7397,7414,7818,7821,7828,8087,8094,8193,30673,30676,30683,30942,40287,40294,40393,45328],
 [7397,7414,7822,7828,7829,8224,8225,8390,30683,31079,31080,31245,40424,40425,40590,47575],
 [7397,7414,7823,7824,7828,8250,8254,8283,30678,30679,30683,31105,40450,40454,40483,47903],
 [7397,7414,7823,7824,7828,8250,8254,8283,30678,30679,30683,31105,40450,40454,40483,47903],[],
 [],[7397,7414,7817,7827,7828,8058,8059,8364,30683,30913,30914,31219,40258,40259,40564,44904],
 [7828],[7397,7414,7822,7828,7829,8224,8225,8390,30683,31079,31080,31245,40424,40425,40590,47575]
  ,[7950,30805],[],[7397,7414,7813,7828,7832,7909,7913,8393,30683,30764,30768,31248,40109,
   40113,40593,42193],[8507,31362],[7875,30730],[8168],[8507,31362],[8032],[7996,30851],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[26316],[31620],
 [],[31620],[],[7447,7464,7725,7726,7743,7769,7786,7828,31805,31806,31849,31908,38205,38222,
   38264,39167],[7447,7464,7725,7726,7743,7769,7786,7828,31805,31806,31849,31908,38205,38222,
   38264,39167],[7828],[7875,31955],[7447,7464,7813,7828,7832,7909,7913,8393,31908,31989,
   31993,32473,40109,40113,40593,42193],[7950,32030],[7996,32076],[8032],
 [7447,7464,7817,7827,7828,8058,8059,8364,31908,32138,32139,32444,40258,40259,40564,44904],
 [7447,7464,7818,7821,7828,8087,8094,8193,31898,31901,31908,32167,40287,40294,40393,45328],[],
 [8168],[7447,7464,7818,7821,7828,8087,8094,8193,31898,31901,31908,32167,40287,40294,40393,45328]
  ,[7447,7464,7822,7828,7829,8224,8225,8390,31908,32304,32305,32470,40424,40425,40590,47575],
 [7447,7464,7823,7824,7828,8250,8254,8283,31903,31904,31908,32330,40450,40454,40483,47903],
 [7447,7464,7823,7824,7828,8250,8254,8283,31903,31904,31908,32330,40450,40454,40483,47903],[],
 [],[7447,7464,7817,7827,7828,8058,8059,8364,31908,32138,32139,32444,40258,40259,40564,44904],
 [7828],[7447,7464,7822,7828,7829,8224,8225,8390,31908,32304,32305,32470,40424,40425,40590,47575]
  ,[7950,32030],[],[7447,7464,7813,7828,7832,7909,7913,8393,31908,31989,31993,32473,40109,
   40113,40593,42193],[8507,32587],[7875,31955],[8168],[8507,32587],[8032],[7996,32076],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[32797],[],[],
 [32797],[7496,7513,7725,7726,7743,7769,7786,7828,32981,32982,33025,33084,38205,38222,38264,39167 
  ],[7496,7513,7725,7726,7743,7769,7786,7828,32981,32982,33025,33084,38205,38222,38264,39167],
 [7828],[7875,33131],[7496,7513,7813,7828,7832,7909,7913,8393,33084,33165,33169,33649,40109,
   40113,40593,42193],[7950,33206],[7996,33252],[8032],
 [7496,7513,7817,7827,7828,8058,8059,8364,33084,33314,33315,33620,40258,40259,40564,44904],
 [7496,7513,7818,7821,7828,8087,8094,8193,33074,33077,33084,33343,40287,40294,40393,45328],[],
 [8168],[7496,7513,7818,7821,7828,8087,8094,8193,33074,33077,33084,33343,40287,40294,40393,45328]
  ,[7496,7513,7822,7828,7829,8224,8225,8390,33084,33480,33481,33646,40424,40425,40590,47575],
 [7496,7513,7823,7824,7828,8250,8254,8283,33079,33080,33084,33506,40450,40454,40483,47903],
 [7496,7513,7823,7824,7828,8250,8254,8283,33079,33080,33084,33506,40450,40454,40483,47903],[],
 [],[7496,7513,7817,7827,7828,8058,8059,8364,33084,33314,33315,33620,40258,40259,40564,44904],
 [7828],[7496,7513,7822,7828,7829,8224,8225,8390,33084,33480,33481,33646,40424,40425,40590,47575]
  ,[7950,33206],[],[7496,7513,7813,7828,7832,7909,7913,8393,33084,33165,33169,33649,40109,
   40113,40593,42193],[8507,33763],[7875,33131],[8168],[8507,33763],[8032],[7996,33252],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[30394],[31620],
 [32797],[7544,7561,7725,7726,7743,7769,7786,7828,34109,34110,34153,34212,38205,38222,38264,39167 
  ],[7544,7561,7725,7726,7743,7769,7786,7828,34109,34110,34153,34212,38205,38222,38264,39167],
 [7828],[7875,34259],[7544,7561,7813,7828,7832,7909,7913,8393,34212,34293,34297,34777,40109,
   40113,40593,42193],[7950,34334],[7996,34380],[8032],
 [7544,7561,7817,7827,7828,8058,8059,8364,34212,34442,34443,34748,40258,40259,40564,44904],
 [7544,7561,7818,7821,7828,8087,8094,8193,34202,34205,34212,34471,40287,40294,40393,45328],[],
 [8168],[7544,7561,7818,7821,7828,8087,8094,8193,34202,34205,34212,34471,40287,40294,40393,45328]
  ,[7544,7561,7822,7828,7829,8224,8225,8390,34212,34608,34609,34774,40424,40425,40590,47575],
 [7544,7561,7823,7824,7828,8250,8254,8283,34207,34208,34212,34634,40450,40454,40483,47903],
 [7544,7561,7823,7824,7828,8250,8254,8283,34207,34208,34212,34634,40450,40454,40483,47903],[],
 [],[7544,7561,7817,7827,7828,8058,8059,8364,34212,34442,34443,34748,40258,40259,40564,44904],
 [7828],[7544,7561,7822,7828,7829,8224,8225,8390,34212,34608,34609,34774,40424,40425,40590,47575]
  ,[7950,34334],[],[7544,7561,7813,7828,7832,7909,7913,8393,34212,34293,34297,34777,40109,
   40113,40593,42193],[8507,34891],[7875,34259],[8168],[8507,34891],[8032],[7996,34380],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[27841],[29168],
 [7591,7608,7725,7726,7743,7769,7786,7828,35190,35191,35234,35293,38205,38222,38264,39167],
 [7591,7608,7725,7726,7743,7769,7786,7828,35190,35191,35234,35293,38205,38222,38264,39167],
 [7828],[7875,35340],[7591,7608,7813,7828,7832,7909,7913,8393,35293,35374,35378,35858,40109,
   40113,40593,42193],[7950,35415],[7996,35461],[8032],
 [7591,7608,7817,7827,7828,8058,8059,8364,35293,35523,35524,35829,40258,40259,40564,44904],
 [7591,7608,7818,7821,7828,8087,8094,8193,35283,35286,35293,35552,40287,40294,40393,45328],[],
 [8168],[7591,7608,7818,7821,7828,8087,8094,8193,35283,35286,35293,35552,40287,40294,40393,45328]
  ,[7591,7608,7822,7828,7829,8224,8225,8390,35293,35689,35690,35855,40424,40425,40590,47575],
 [7591,7608,7823,7824,7828,8250,8254,8283,35288,35289,35293,35715,40450,40454,40483,47903],
 [7591,7608,7823,7824,7828,8250,8254,8283,35288,35289,35293,35715,40450,40454,40483,47903],[],
 [],[7591,7608,7817,7827,7828,8058,8059,8364,35293,35523,35524,35829,40258,40259,40564,44904],
 [7828],[7591,7608,7822,7828,7829,8224,8225,8390,35293,35689,35690,35855,40424,40425,40590,47575]
  ,[7950,35415],[],[7591,7608,7813,7828,7832,7909,7913,8393,35293,35374,35378,35858,40109,
   40113,40593,42193],[8507,35972],[7875,35340],[8168],[8507,35972],[8032],[7996,35461],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[26510],
 [7637,7654,7725,7726,7743,7769,7786,7828,36225,36226,36269,36328,38205,38222,38264,39167],
 [7637,7654,7725,7726,7743,7769,7786,7828,36225,36226,36269,36328,38205,38222,38264,39167],
 [7828],[7875,36375],[7637,7654,7813,7828,7832,7909,7913,8393,36328,36409,36413,36893,40109,
   40113,40593,42193],[7950,36450],[7996,36496],[8032],
 [7637,7654,7817,7827,7828,8058,8059,8364,36328,36558,36559,36864,40258,40259,40564,44904],
 [7637,7654,7818,7821,7828,8087,8094,8193,36318,36321,36328,36587,40287,40294,40393,45328],[],
 [8168],[7637,7654,7818,7821,7828,8087,8094,8193,36318,36321,36328,36587,40287,40294,40393,45328]
  ,[7637,7654,7822,7828,7829,8224,8225,8390,36328,36724,36725,36890,40424,40425,40590,47575],
 [7637,7654,7823,7824,7828,8250,8254,8283,36323,36324,36328,36750,40450,40454,40483,47903],
 [7637,7654,7823,7824,7828,8250,8254,8283,36323,36324,36328,36750,40450,40454,40483,47903],[],
 [],[7637,7654,7817,7827,7828,8058,8059,8364,36328,36558,36559,36864,40258,40259,40564,44904],
 [7828],[7637,7654,7822,7828,7829,8224,8225,8390,36328,36724,36725,36890,40424,40425,40590,47575]
  ,[7950,36450],[],[7637,7654,7813,7828,7832,7909,7913,8393,36328,36409,36413,36893,40109,
   40113,40593,42193],[8507,37007],[7875,36375],[8168],[8507,37007],[8032],[7996,36496],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [7682,7699,7725,7726,7743,7769,7786,7828,37215,37216,37259,37318,38205,38222,38264,39167],
 [7682,7699,7725,7726,7743,7769,7786,7828,37215,37216,37259,37318,38205,38222,38264,39167],
 [7828],[7875,37365],[7682,7699,7813,7828,7832,7909,7913,8393,37318,37399,37403,37883,40109,
   40113,40593,42193],[7950,37440],[7996,37486],[8032],
 [7682,7699,7817,7827,7828,8058,8059,8364,37318,37548,37549,37854,40258,40259,40564,44904],
 [7682,7699,7818,7821,7828,8087,8094,8193,37308,37311,37318,37577,40287,40294,40393,45328],[],
 [8168],[7682,7699,7818,7821,7828,8087,8094,8193,37308,37311,37318,37577,40287,40294,40393,45328]
  ,[7682,7699,7822,7828,7829,8224,8225,8390,37318,37714,37715,37880,40424,40425,40590,47575],
 [7682,7699,7823,7824,7828,8250,8254,8283,37313,37314,37318,37740,40450,40454,40483,47903],
 [7682,7699,7823,7824,7828,8250,8254,8283,37313,37314,37318,37740,40450,40454,40483,47903],[],
 [],[7682,7699,7817,7827,7828,8058,8059,8364,37318,37548,37549,37854,40258,40259,40564,44904],
 [7828],[7682,7699,7822,7828,7829,8224,8225,8390,37318,37714,37715,37880,40424,40425,40590,47575]
  ,[7950,37440],[],[7682,7699,7813,7828,7832,7909,7913,8393,37318,37399,37403,37883,40109,
   40113,40593,42193],[8507,37997],[7875,37365],[8168],[8507,37997],[8032],[7996,37486],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[7828,38205],
 [7828,38205],[7725,7726,7743,7769,7786,7812,7813,7814,7828,7830,7832,7834,7855,7869,7871,7875,
   7909,7913,7948,7950,7954,8391,8393,8395,8442,38205,38206,38207,38208,38222,38224,38226,38228,
   38248,38249,38250,38264,38266,38268,38270,38290,38291,38305,38307,38309,38311,38331,38345,38347,
   38349,38351,38384,38386,38388,38390,38827,38829,38831,38876,38878,38921,39151,39152,39153,39167,
   39169,39171,39173,39193,39194,39208,39210,39212,39214,39234,39248,39250,39252,39254,39287,39289,
   39291,39293,39730,39732,39734,39779,39781,39824,40054,40055,40069,40071,40073,40075,40095,40109,
   40111,40113,40115,40148,40150,40152,40154,40591,40593,40595,40640,40642,40685,40915,40929,40931,
   40933,40935,40968,40970,40972,40974,41411,41413,41415,41460,41462,41505,41748,41750,41752,41754,
   42191,42193,42195,42240,42242,42285,42932,42934,42936,42981,42983,43026,49820,49822,49865,50394]
  ,[7725,7726,7743,7769,7786,7812,7813,7814,7828,7830,7832,7834,7855,7869,7871,7875,7909,7913,
   7948,7950,7954,8391,8393,8395,8442,38205,38206,38207,38208,38222,38224,38226,38228,38248,38249,
   38250,38264,38266,38268,38270,38290,38291,38305,38307,38309,38311,38331,38345,38347,38349,38351,
   38384,38386,38388,38390,38827,38829,38831,38876,38878,38921,39151,39152,39153,39167,39169,39171,
   39173,39193,39194,39208,39210,39212,39214,39234,39248,39250,39252,39254,39287,39289,39291,39293,
   39730,39732,39734,39779,39781,39824,40054,40055,40069,40071,40073,40075,40095,40109,40111,40113,
   40115,40148,40150,40152,40154,40591,40593,40595,40640,40642,40685,40915,40929,40931,40933,40935,
   40968,40970,40972,40974,41411,41413,41415,41460,41462,41505,41748,41750,41752,41754,42191,42193,
   42195,42240,42242,42285,42932,42934,42936,42981,42983,43026,49820,49822,49865,50394],
 [7725,7726,7743,7769,7786,7812,7813,7814,7828,7830,7832,7834,7855,7869,7871,7875,7909,7913,7948,
   7950,7954,8391,8393,8395,8442,38205,38206,38207,38208,38222,38224,38226,38228,38248,38249,
   38250,38264,38266,38268,38270,38290,38291,38305,38307,38309,38311,38331,38345,38347,38349,38351,
   38384,38386,38388,38390,38827,38829,38831,38876,38878,38921,39151,39152,39153,39167,39169,39171,
   39173,39193,39194,39208,39210,39212,39214,39234,39248,39250,39252,39254,39287,39289,39291,39293,
   39730,39732,39734,39779,39781,39824,40054,40055,40069,40071,40073,40075,40095,40109,40111,40113,
   40115,40148,40150,40152,40154,40591,40593,40595,40640,40642,40685,40915,40929,40931,40933,40935,
   40968,40970,40972,40974,41411,41413,41415,41460,41462,41505,41748,41750,41752,41754,42191,42193,
   42195,42240,42242,42285,42932,42934,42936,42981,42983,43026,49820,49822,49865,50394],
 [7725,7726,7743,7769,7786,7815,7816,7828,7837,7838,7986,7996,8023,8032,8398,8399,38205,38209,
   38210,38222,38231,38232,38251,38252,38264,38273,38274,38410,38431,38432,39015,39154,39155,39167,
   39176,39177,39313,39335,39372,39918,40174,40186,40195,40196,40223,40232,40233,40598,40599,40779,
   43277,43643,43823,44308],[7725,7726,7743,7769,7786,7815,7816,7828,7837,7838,7986,7996,8023,
   8032,8398,8399,38205,38209,38210,38222,38231,38232,38251,38252,38264,38273,38274,38410,38431,
   38432,39015,39154,39155,39167,39176,39177,39313,39335,39372,39918,40174,40186,40195,40196,40223,
   40232,40233,40598,40599,40779,43277,43643,43823,44308],
 [2279,3500,3501,3507,3517,3518,3544,3550,3592,3833,3834,4139,5645,5646,5662,5689,5695,5705,5706,
   5747,5978,5979,6284,7725,7726,7743,7769,7786,7817,7827,7828,8058,8059,8364,38205,38211,38221,
   38222,38253,38263,38264,38494,38495,38800,39156,39166,39167,39397,39398,39703,40258,40259,40564,
   44904],[7725,7726,7743,7769,7786,7818,7819,7821,7828,8087,8094,8128,8193,38205,38212,38213,
   38215,38222,38254,38255,38257,38264,38521,38523,38557,39157,39158,39160,39167,39424,39426,39460,
   40285,40287,40294,40321,40328,40393,45256,45328],
 [7725,7726,7743,7769,7786,7818,7819,7821,7828,8087,8094,8128,8193,38205,38212,38213,38215,38222,
   38254,38255,38257,38264,38521,38523,38557,39157,39158,39160,39167,39424,39426,39460,40285,40287,
   40294,40321,40328,40393,45256,45328],[7725,7726,7743,7769,7786,7820,7828,7835,8161,8168,8396,
   38205,38214,38222,38229,38256,38264,38271,39159,39167,39174,40361,40368,40596,46620],
 [7725,7726,7743,7769,7786,7818,7819,7821,7828,8087,8094,8128,8193,38205,38212,38213,38215,38222,
   38254,38255,38257,38264,38521,38523,38557,39157,39158,39160,39167,39424,39426,39460,40285,40287,
   40294,40321,40328,40393,45256,45328],[7725,7726,7743,7769,7786,7822,7828,7829,8224,8225,8390,
   38205,38216,38222,38223,38258,38264,38265,38660,38661,38826,39161,39167,39168,39563,39564,39729,
   40424,40425,40590,47575],[7725,7726,7743,7769,7786,7823,7824,7828,8250,8254,8283,38205,38217,
   38218,38222,38259,38260,38264,38686,39162,39163,39167,39589,40450,40454,40483,47903],
 [7725,7726,7743,7769,7786,7823,7824,7828,8250,8254,8283,38205,38217,38218,38222,38259,38260,
   38264,38686,39162,39163,39167,39589,40450,40454,40483,47903],
 [7725,7726,7743,7769,7786,7825,7828,7831,8311,8314,8392,38205,38219,38222,38225,38261,38264,
   38267,39164,39167,39170,40511,40514,40592,48796],
 [7725,7726,7743,7769,7786,7826,7828,8338,38205,38220,38222,38262,38264,39165,39167,40538],
 [2279,3500,3501,3507,3517,3518,3544,3550,3592,3833,3834,4139,5645,5646,5662,5689,5695,5705,5706,
   5747,5978,5979,6284,7725,7726,7743,7769,7786,7817,7827,7828,8058,8059,8364,38205,38211,38221,
   38222,38253,38263,38264,38494,38495,38800,39156,39166,39167,39397,39398,39703,40258,40259,40564,
   44904],[7828,38205],[7725,7726,7743,7769,7786,7822,7828,7829,8224,8225,8390,38205,38216,
   38222,38223,38258,38264,38265,38660,38661,38826,39161,39167,39168,39563,39564,39729,40424,40425,
   40590,47575],[7725,7726,7743,7769,7786,7812,7813,7814,7828,7830,7832,7834,7855,7869,7871,
   7875,7909,7913,7948,7950,7954,8391,8393,8395,8442,38205,38206,38207,38208,38222,38224,38226,
   38228,38248,38249,38250,38264,38266,38268,38270,38290,38291,38305,38307,38309,38311,38331,38345,
   38347,38349,38351,38384,38386,38388,38390,38827,38829,38831,38876,38878,38921,39151,39152,39153,
   39167,39169,39171,39173,39193,39194,39208,39210,39212,39214,39234,39248,39250,39252,39254,39287,
   39289,39291,39293,39730,39732,39734,39779,39781,39824,40054,40055,40069,40071,40073,40075,40095,
   40109,40111,40113,40115,40148,40150,40152,40154,40591,40593,40595,40640,40642,40685,40915,40929,
   40931,40933,40935,40968,40970,40972,40974,41411,41413,41415,41460,41462,41505,41748,41750,41752,
   41754,42191,42193,42195,42240,42242,42285,42932,42934,42936,42981,42983,43026,49820,49822,49865,
   50394],[7725,7726,7743,7769,7786,7825,7828,7831,8311,8314,8392,38205,38219,38222,38225,38261,
   38264,38267,39164,39167,39170,40511,40514,40592,48796],
 [7725,7726,7743,7769,7786,7812,7813,7814,7828,7830,7832,7834,7855,7869,7871,7875,7909,7913,7948,
   7950,7954,8391,8393,8395,8442,38205,38206,38207,38208,38222,38224,38226,38228,38248,38249,
   38250,38264,38266,38268,38270,38290,38291,38305,38307,38309,38311,38331,38345,38347,38349,38351,
   38384,38386,38388,38390,38827,38829,38831,38876,38878,38921,39151,39152,39153,39167,39169,39171,
   39173,39193,39194,39208,39210,39212,39214,39234,39248,39250,39252,39254,39287,39289,39291,39293,
   39730,39732,39734,39779,39781,39824,40054,40055,40069,40071,40073,40075,40095,40109,40111,40113,
   40115,40148,40150,40152,40154,40591,40593,40595,40640,40642,40685,40915,40929,40931,40933,40935,
   40968,40970,40972,40974,41411,41413,41415,41460,41462,41505,41748,41750,41752,41754,42191,42193,
   42195,42240,42242,42285,42932,42934,42936,42981,42983,43026,49820,49822,49865,50394],
 [7725,7726,7743,7769,7786,7828,7833,7836,8394,8397,8507,38205,38222,38227,38230,38264,38269,
   38272,38943,39167,39172,39175,39846,40594,40597,40707,49887],
 [7725,7726,7743,7769,7786,7812,7813,7814,7828,7830,7832,7834,7855,7869,7871,7875,7909,7913,7948,
   7950,7954,8391,8393,8395,8442,38205,38206,38207,38208,38222,38224,38226,38228,38248,38249,
   38250,38264,38266,38268,38270,38290,38291,38305,38307,38309,38311,38331,38345,38347,38349,38351,
   38384,38386,38388,38390,38827,38829,38831,38876,38878,38921,39151,39152,39153,39167,39169,39171,
   39173,39193,39194,39208,39210,39212,39214,39234,39248,39250,39252,39254,39287,39289,39291,39293,
   39730,39732,39734,39779,39781,39824,40054,40055,40069,40071,40073,40075,40095,40109,40111,40113,
   40115,40148,40150,40152,40154,40591,40593,40595,40640,40642,40685,40915,40929,40931,40933,40935,
   40968,40970,40972,40974,41411,41413,41415,41460,41462,41505,41748,41750,41752,41754,42191,42193,
   42195,42240,42242,42285,42932,42934,42936,42981,42983,43026,49820,49822,49865,50394],
 [7725,7726,7743,7769,7786,7820,7828,7835,8161,8168,8396,38205,38214,38222,38229,38256,38264,
   38271,39159,39167,39174,40361,40368,40596,46620],
 [7725,7726,7743,7769,7786,7828,7833,7836,8394,8397,8507,38205,38222,38227,38230,38264,38269,
   38272,38943,39167,39172,39175,39846,40594,40597,40707,49887],
 [7725,7726,7743,7769,7786,7815,7816,7828,7837,7838,7986,7996,8023,8032,8398,8399,38205,38209,
   38210,38222,38231,38232,38251,38252,38264,38273,38274,38410,38431,38432,39015,39154,39155,39167,
   39176,39177,39313,39335,39372,39918,40174,40186,40195,40196,40223,40232,40233,40598,40599,40779,
   43277,43643,43823,44308],[7725,7726,7743,7769,7786,7815,7816,7828,7837,7838,7986,7996,8023,
   8032,8398,8399,38205,38209,38210,38222,38231,38232,38251,38252,38264,38273,38274,38410,38431,
   38432,39015,39154,39155,39167,39176,39177,39313,39335,39372,39918,40174,40186,40195,40196,40223,
   40232,40233,40598,40599,40779,43277,43643,43823,44308],
 [7725,7726,7743,7769,7786,7828,7839,8400,38205,38222,38233,38264,38275,39167,39178,40600],
 [7725,7726,7743,7769,7786,7828,7840,7841,8401,8402,8624,38205,38222,38234,38235,38264,38276,
   38277,39060,39167,39179,39180,39963,40601,40602,40824,50004],
 [7725,7726,7743,7769,7786,7828,7840,7841,8401,8402,8624,38205,38222,38234,38235,38264,38276,
   38277,39060,39167,39179,39180,39963,40601,40602,40824,50004],
 [7725,7726,7743,7769,7786,7828,7842,8403,38205,38222,38236,38264,38278,39167,39181,40603],
 [7725,7726,7743,7769,7786,7828,7843,7850,8404,8411,8666,38205,38222,38237,38244,38264,38279,
   38286,39167,39182,39189,40604,40611,40866,50046],
 [7725,7726,7743,7769,7786,7828,7844,7845,8405,8406,8670,38205,38222,38238,38239,38264,38280,
   38281,39106,39167,39183,39184,40009,40605,40606,40870,50050],
 [7725,7726,7743,7769,7786,7828,7844,7845,8405,8406,8670,38205,38222,38238,38239,38264,38280,
   38281,39106,39167,39183,39184,40009,40605,40606,40870,50050],
 [7725,7726,7743,7769,7786,7828,7846,8407,38205,38222,38240,38264,38282,39167,39185,40607],
 [7725,7726,7743,7769,7786,7828,7847,7849,8408,8410,8695,38205,38222,38241,38243,38264,38283,
   38285,39167,39186,39188,40608,40610,40895,50075],
 [7725,7726,7743,7769,7786,7828,7848,8409,38205,38222,38242,38264,38284,39167,39187,40609],
 [7725,7726,7743,7769,7786,7828,7847,7849,8408,8410,8695,38205,38222,38241,38243,38264,38283,
   38285,39167,39186,39188,40608,40610,40895,50075],
 [7725,7726,7743,7769,7786,7828,7843,7850,8404,8411,8666,38205,38222,38237,38244,38264,38279,
   38286,39167,39182,39189,40604,40611,40866,50046],
 [7725,7726,7743,7769,7786,7828,7851,8412,38205,38222,38245,38264,38287,39167,39190,40612],
 [7725,7726,7743,7769,7786,7828,7852,7853,8413,8414,8714,38205,38222,38246,38247,38264,38288,
   38289,39150,39167,39191,39192,40053,40613,40614,40914,50094],
 [7725,7726,7743,7769,7786,7828,7852,7853,8413,8414,8714,38205,38222,38246,38247,38264,38288,
   38289,39150,39167,39191,39192,40053,40613,40614,40914,50094],[7828,38205],
 [7725,7726,7743,7769,7786,7812,7813,7814,7828,7830,7832,7834,7855,7869,7871,7875,7909,7913,7948,
   7950,7954,8391,8393,8395,8442,38205,38206,38207,38208,38222,38224,38226,38228,38248,38249,
   38250,38264,38266,38268,38270,38290,38291,38305,38307,38309,38311,38331,38345,38347,38349,38351,
   38384,38386,38388,38390,38827,38829,38831,38876,38878,38921,39151,39152,39153,39167,39169,39171,
   39173,39193,39194,39208,39210,39212,39214,39234,39248,39250,39252,39254,39287,39289,39291,39293,
   39730,39732,39734,39779,39781,39824,40054,40055,40069,40071,40073,40075,40095,40109,40111,40113,
   40115,40148,40150,40152,40154,40591,40593,40595,40640,40642,40685,40915,40929,40931,40933,40935,
   40968,40970,40972,40974,41411,41413,41415,41460,41462,41505,41748,41750,41752,41754,42191,42193,
   42195,42240,42242,42285,42932,42934,42936,42981,42983,43026,49820,49822,49865,50394],
 [7725,7726,7743,7769,7786,7812,7813,7814,7828,7830,7832,7834,7855,7869,7871,7875,7909,7913,7948,
   7950,7954,8391,8393,8395,8442,38205,38206,38207,38208,38222,38224,38226,38228,38248,38249,
   38250,38264,38266,38268,38270,38290,38291,38305,38307,38309,38311,38331,38345,38347,38349,38351,
   38384,38386,38388,38390,38827,38829,38831,38876,38878,38921,39151,39152,39153,39167,39169,39171,
   39173,39193,39194,39208,39210,39212,39214,39234,39248,39250,39252,39254,39287,39289,39291,39293,
   39730,39732,39734,39779,39781,39824,40054,40055,40069,40071,40073,40075,40095,40109,40111,40113,
   40115,40148,40150,40152,40154,40591,40593,40595,40640,40642,40685,40915,40929,40931,40933,40935,
   40968,40970,40972,40974,41411,41413,41415,41460,41462,41505,41748,41750,41752,41754,42191,42193,
   42195,42240,42242,42285,42932,42934,42936,42981,42983,43026,49820,49822,49865,50394],
 [7725,7726,7743,7769,7786,7812,7813,7814,7828,7830,7832,7834,7855,7869,7871,7875,7909,7913,7948,
   7950,7954,8391,8393,8395,8442,38205,38206,38207,38208,38222,38224,38226,38228,38248,38249,
   38250,38264,38266,38268,38270,38290,38291,38305,38307,38309,38311,38331,38345,38347,38349,38351,
   38384,38386,38388,38390,38827,38829,38831,38876,38878,38921,39151,39152,39153,39167,39169,39171,
   39173,39193,39194,39208,39210,39212,39214,39234,39248,39250,39252,39254,39287,39289,39291,39293,
   39730,39732,39734,39779,39781,39824,40054,40055,40069,40071,40073,40075,40095,40109,40111,40113,
   40115,40148,40150,40152,40154,40591,40593,40595,40640,40642,40685,40915,40929,40931,40933,40935,
   40968,40970,40972,40974,41411,41413,41415,41460,41462,41505,41748,41750,41752,41754,42191,42193,
   42195,42240,42242,42285,42932,42934,42936,42981,42983,43026,49820,49822,49865,50394],
 [7725,7726,7743,7769,7786,7815,7816,7828,7837,7838,7986,7996,8023,8032,8398,8399,38205,38209,
   38210,38222,38231,38232,38251,38252,38264,38273,38274,38410,38431,38432,39015,39154,39155,39167,
   39176,39177,39313,39335,39372,39918,40174,40186,40195,40196,40223,40232,40233,40598,40599,40779,
   43277,43643,43823,44308],[7725,7726,7743,7769,7786,7815,7816,7828,7837,7838,7986,7996,8023,
   8032,8398,8399,38205,38209,38210,38222,38231,38232,38251,38252,38264,38273,38274,38410,38431,
   38432,39015,39154,39155,39167,39176,39177,39313,39335,39372,39918,40174,40186,40195,40196,40223,
   40232,40233,40598,40599,40779,43277,43643,43823,44308],
 [2279,3500,3501,3507,3517,3518,3544,3550,3592,3833,3834,4139,5645,5646,5662,5689,5695,5705,5706,
   5747,5978,5979,6284,7725,7726,7743,7769,7786,7817,7827,7828,8058,8059,8364,38205,38211,38221,
   38222,38253,38263,38264,38494,38495,38800,39156,39166,39167,39397,39398,39703,40258,40259,40564,
   44904],[7725,7726,7743,7769,7786,7818,7819,7821,7828,8087,8094,8128,8193,38205,38212,38213,
   38215,38222,38254,38255,38257,38264,38521,38523,38557,39157,39158,39160,39167,39424,39426,39460,
   40285,40287,40294,40321,40328,40393,45256,45328],
 [7725,7726,7743,7769,7786,7818,7819,7821,7828,8087,8094,8128,8193,38205,38212,38213,38215,38222,
   38254,38255,38257,38264,38521,38523,38557,39157,39158,39160,39167,39424,39426,39460,40285,40287,
   40294,40321,40328,40393,45256,45328],[7725,7726,7743,7769,7786,7820,7828,7835,8161,8168,8396,
   38205,38214,38222,38229,38256,38264,38271,39159,39167,39174,40361,40368,40596,46620],
 [7725,7726,7743,7769,7786,7818,7819,7821,7828,8087,8094,8128,8193,38205,38212,38213,38215,38222,
   38254,38255,38257,38264,38521,38523,38557,39157,39158,39160,39167,39424,39426,39460,40285,40287,
   40294,40321,40328,40393,45256,45328],[7725,7726,7743,7769,7786,7822,7828,7829,8224,8225,8390,
   38205,38216,38222,38223,38258,38264,38265,38660,38661,38826,39161,39167,39168,39563,39564,39729,
   40424,40425,40590,47575],[7725,7726,7743,7769,7786,7823,7824,7828,8250,8254,8283,38205,38217,
   38218,38222,38259,38260,38264,38686,39162,39163,39167,39589,40450,40454,40483,47903],
 [7725,7726,7743,7769,7786,7823,7824,7828,8250,8254,8283,38205,38217,38218,38222,38259,38260,
   38264,38686,39162,39163,39167,39589,40450,40454,40483,47903],
 [7725,7726,7743,7769,7786,7825,7828,7831,8311,8314,8392,38205,38219,38222,38225,38261,38264,
   38267,39164,39167,39170,40511,40514,40592,48796],
 [7725,7726,7743,7769,7786,7826,7828,8338,38205,38220,38222,38262,38264,39165,39167,40538],
 [2279,3500,3501,3507,3517,3518,3544,3550,3592,3833,3834,4139,5645,5646,5662,5689,5695,5705,5706,
   5747,5978,5979,6284,7725,7726,7743,7769,7786,7817,7827,7828,8058,8059,8364,38205,38211,38221,
   38222,38253,38263,38264,38494,38495,38800,39156,39166,39167,39397,39398,39703,40258,40259,40564,
   44904],[7828,38205],[7725,7726,7743,7769,7786,7822,7828,7829,8224,8225,8390,38205,38216,
   38222,38223,38258,38264,38265,38660,38661,38826,39161,39167,39168,39563,39564,39729,40424,40425,
   40590,47575],[7725,7726,7743,7769,7786,7812,7813,7814,7828,7830,7832,7834,7855,7869,7871,
   7875,7909,7913,7948,7950,7954,8391,8393,8395,8442,38205,38206,38207,38208,38222,38224,38226,
   38228,38248,38249,38250,38264,38266,38268,38270,38290,38291,38305,38307,38309,38311,38331,38345,
   38347,38349,38351,38384,38386,38388,38390,38827,38829,38831,38876,38878,38921,39151,39152,39153,
   39167,39169,39171,39173,39193,39194,39208,39210,39212,39214,39234,39248,39250,39252,39254,39287,
   39289,39291,39293,39730,39732,39734,39779,39781,39824,40054,40055,40069,40071,40073,40075,40095,
   40109,40111,40113,40115,40148,40150,40152,40154,40591,40593,40595,40640,40642,40685,40915,40929,
   40931,40933,40935,40968,40970,40972,40974,41411,41413,41415,41460,41462,41505,41748,41750,41752,
   41754,42191,42193,42195,42240,42242,42285,42932,42934,42936,42981,42983,43026,49820,49822,49865,
   50394],[7725,7726,7743,7769,7786,7825,7828,7831,8311,8314,8392,38205,38219,38222,38225,38261,
   38264,38267,39164,39167,39170,40511,40514,40592,48796],
 [7725,7726,7743,7769,7786,7812,7813,7814,7828,7830,7832,7834,7855,7869,7871,7875,7909,7913,7948,
   7950,7954,8391,8393,8395,8442,38205,38206,38207,38208,38222,38224,38226,38228,38248,38249,
   38250,38264,38266,38268,38270,38290,38291,38305,38307,38309,38311,38331,38345,38347,38349,38351,
   38384,38386,38388,38390,38827,38829,38831,38876,38878,38921,39151,39152,39153,39167,39169,39171,
   39173,39193,39194,39208,39210,39212,39214,39234,39248,39250,39252,39254,39287,39289,39291,39293,
   39730,39732,39734,39779,39781,39824,40054,40055,40069,40071,40073,40075,40095,40109,40111,40113,
   40115,40148,40150,40152,40154,40591,40593,40595,40640,40642,40685,40915,40929,40931,40933,40935,
   40968,40970,40972,40974,41411,41413,41415,41460,41462,41505,41748,41750,41752,41754,42191,42193,
   42195,42240,42242,42285,42932,42934,42936,42981,42983,43026,49820,49822,49865,50394],
 [7725,7726,7743,7769,7786,7828,7833,7836,8394,8397,8507,38205,38222,38227,38230,38264,38269,
   38272,38943,39167,39172,39175,39846,40594,40597,40707,49887],
 [7725,7726,7743,7769,7786,7812,7813,7814,7828,7830,7832,7834,7855,7869,7871,7875,7909,7913,7948,
   7950,7954,8391,8393,8395,8442,38205,38206,38207,38208,38222,38224,38226,38228,38248,38249,
   38250,38264,38266,38268,38270,38290,38291,38305,38307,38309,38311,38331,38345,38347,38349,38351,
   38384,38386,38388,38390,38827,38829,38831,38876,38878,38921,39151,39152,39153,39167,39169,39171,
   39173,39193,39194,39208,39210,39212,39214,39234,39248,39250,39252,39254,39287,39289,39291,39293,
   39730,39732,39734,39779,39781,39824,40054,40055,40069,40071,40073,40075,40095,40109,40111,40113,
   40115,40148,40150,40152,40154,40591,40593,40595,40640,40642,40685,40915,40929,40931,40933,40935,
   40968,40970,40972,40974,41411,41413,41415,41460,41462,41505,41748,41750,41752,41754,42191,42193,
   42195,42240,42242,42285,42932,42934,42936,42981,42983,43026,49820,49822,49865,50394],
 [7725,7726,7743,7769,7786,7820,7828,7835,8161,8168,8396,38205,38214,38222,38229,38256,38264,
   38271,39159,39167,39174,40361,40368,40596,46620],
 [7725,7726,7743,7769,7786,7828,7833,7836,8394,8397,8507,38205,38222,38227,38230,38264,38269,
   38272,38943,39167,39172,39175,39846,40594,40597,40707,49887],
 [7725,7726,7743,7769,7786,7815,7816,7828,7837,7838,7986,7996,8023,8032,8398,8399,38205,38209,
   38210,38222,38231,38232,38251,38252,38264,38273,38274,38410,38431,38432,39015,39154,39155,39167,
   39176,39177,39313,39335,39372,39918,40174,40186,40195,40196,40223,40232,40233,40598,40599,40779,
   43277,43643,43823,44308],[7725,7726,7743,7769,7786,7815,7816,7828,7837,7838,7986,7996,8023,
   8032,8398,8399,38205,38209,38210,38222,38231,38232,38251,38252,38264,38273,38274,38410,38431,
   38432,39015,39154,39155,39167,39176,39177,39313,39335,39372,39918,40174,40186,40195,40196,40223,
   40232,40233,40598,40599,40779,43277,43643,43823,44308],
 [7725,7726,7743,7769,7786,7828,7839,8400,38205,38222,38233,38264,38275,39167,39178,40600],
 [7725,7726,7743,7769,7786,7828,7840,7841,8401,8402,8624,38205,38222,38234,38235,38264,38276,
   38277,39060,39167,39179,39180,39963,40601,40602,40824,50004],
 [7725,7726,7743,7769,7786,7828,7840,7841,8401,8402,8624,38205,38222,38234,38235,38264,38276,
   38277,39060,39167,39179,39180,39963,40601,40602,40824,50004],
 [7725,7726,7743,7769,7786,7828,7842,8403,38205,38222,38236,38264,38278,39167,39181,40603],
 [7725,7726,7743,7769,7786,7828,7843,7850,8404,8411,8666,38205,38222,38237,38244,38264,38279,
   38286,39167,39182,39189,40604,40611,40866,50046],
 [7725,7726,7743,7769,7786,7828,7844,7845,8405,8406,8670,38205,38222,38238,38239,38264,38280,
   38281,39106,39167,39183,39184,40009,40605,40606,40870,50050],
 [7725,7726,7743,7769,7786,7828,7844,7845,8405,8406,8670,38205,38222,38238,38239,38264,38280,
   38281,39106,39167,39183,39184,40009,40605,40606,40870,50050],
 [7725,7726,7743,7769,7786,7828,7846,8407,38205,38222,38240,38264,38282,39167,39185,40607],
 [7725,7726,7743,7769,7786,7828,7847,7849,8408,8410,8695,38205,38222,38241,38243,38264,38283,
   38285,39167,39186,39188,40608,40610,40895,50075],
 [7725,7726,7743,7769,7786,7828,7848,8409,38205,38222,38242,38264,38284,39167,39187,40609],
 [7725,7726,7743,7769,7786,7828,7847,7849,8408,8410,8695,38205,38222,38241,38243,38264,38283,
   38285,39167,39186,39188,40608,40610,40895,50075],
 [7725,7726,7743,7769,7786,7828,7843,7850,8404,8411,8666,38205,38222,38237,38244,38264,38279,
   38286,39167,39182,39189,40604,40611,40866,50046],
 [7725,7726,7743,7769,7786,7828,7851,8412,38205,38222,38245,38264,38287,39167,39190,40612],
 [7725,7726,7743,7769,7786,7828,7852,7853,8413,8414,8714,38205,38222,38246,38247,38264,38288,
   38289,39150,39167,39191,39192,40053,40613,40614,40914,50094],
 [7725,7726,7743,7769,7786,7828,7852,7853,8413,8414,8714,38205,38222,38246,38247,38264,38288,
   38289,39150,39167,39191,39192,40053,40613,40614,40914,50094],
 [7828,7875,7950,40055,40642,41411,42936],[7828,42193],[7828,7875,7950,40055,40642,41411,42936],
 [7828,7996,40196,43643],[7828,8032],[7828,44904],[7828,40287],[7828],[7828,8168],
 [7828,40287],[7828,47575],[7828,40450],[7828,40450],[7828,48796],[7828],[7828,44904],
 [],[7828,47575],[7828,7875,7950,40055,40642,41411,42936],[7828,48796],[7828,42193],
 [7828,8507,40707,49887],[7828,7875,7950,40055,40642,41411,42936],[7828,8168],
 [7828,8507,40707,49887],[7828,8032],[7828,7996,40196,43643],[7828],[7828,40824],
 [7828,40824],[7828],[7828,50046],[7828,40870],[7828,40870],[7828],[7828,50075],[7828],
 [7828,50075],[7828,50046],[7828],[7828,40914],[7828,40914],
 [7725,7726,7743,7769,7786,7812,7813,7814,7828,7830,7832,7834,7855,7869,7871,7875,7909,7913,7948,
   7950,7954,8391,8393,8395,8442,38205,38206,38207,38208,38222,38224,38226,38228,38248,38249,
   38250,38264,38266,38268,38270,38290,38291,38305,38307,38309,38311,38331,38345,38347,38349,38351,
   38384,38386,38388,38390,38827,38829,38831,38876,38878,38921,39151,39152,39153,39167,39169,39171,
   39173,39193,39194,39208,39210,39212,39214,39234,39248,39250,39252,39254,39287,39289,39291,39293,
   39730,39732,39734,39779,39781,39824,40054,40055,40069,40071,40073,40075,40095,40109,40111,40113,
   40115,40148,40150,40152,40154,40591,40593,40595,40640,40642,40685,40915,40929,40931,40933,40935,
   40968,40970,40972,40974,41411,41413,41415,41460,41462,41505,41748,41750,41752,41754,42191,42193,
   42195,42240,42242,42285,42932,42934,42936,42981,42983,43026,49820,49822,49865,50394],
 [7828,7875,7950,40055,40642,41411,42936],[7875,7996,41012,41016,41548,43772],
 [7875,8032,41049,41547],[7812,7814,7817,7818,7821,7827,7828,7830,7834,7855,7869,7871,7875,7948,
   7950,7954,8058,8059,8087,8094,8193,8364,8391,8395,8442,40055,40058,40059,40062,40068,40069,
   40071,40075,40137,40138,40141,40147,40148,40150,40154,40249,40252,40258,40259,40261,40265,40287,
   40293,40294,40296,40300,40392,40393,40395,40399,40564,40566,40570,40591,40595,40642,40957,40958,
   40961,40967,40968,40970,40974,41069,41072,41078,41079,41081,41085,41107,41113,41114,41116,41120,
   41212,41213,41215,41219,41384,41386,41390,41411,41415,41462,42590,42593,42599,42600,42602,42606,
   42628,42634,42635,42637,42641,42733,42734,42736,42740,42905,42907,42911,42932,42936,42983,44627,
   44633,44634,44636,44640,44732,44733,44735,44739,44904,44906,44910,44931,44935,44982,45327,45328,
   45330,45334,45499,45501,45505,45526,45530,45577,47084,47086,47090,47111,47115,47162,49471,49475,
   49522,49822],[7812,7814,7817,7818,7821,7827,7828,7830,7834,7855,7869,7871,7875,7948,7950,
   7954,8058,8059,8087,8094,8193,8364,8391,8395,8442,40055,40058,40059,40062,40068,40069,40071,
   40075,40137,40138,40141,40147,40148,40150,40154,40249,40252,40258,40259,40261,40265,40287,40293,
   40294,40296,40300,40392,40393,40395,40399,40564,40566,40570,40591,40595,40642,40957,40958,40961,
   40967,40968,40970,40974,41069,41072,41078,41079,41081,41085,41107,41113,41114,41116,41120,41212,
   41213,41215,41219,41384,41386,41390,41411,41415,41462,42590,42593,42599,42600,42602,42606,42628,
   42634,42635,42637,42641,42733,42734,42736,42740,42905,42907,42911,42932,42936,42983,44627,44633,
   44634,44636,44640,44732,44733,44735,44739,44904,44906,44910,44931,44935,44982,45327,45328,45330,
   45334,45499,45501,45505,45526,45530,45577,47084,47086,47090,47111,47115,47162,49471,49475,49522,
   49822],[7875,41154],[7875,8168,41187,41545],
 [7812,7814,7817,7818,7821,7827,7828,7830,7834,7855,7869,7871,7875,7948,7950,7954,8058,8059,8087,
   8094,8193,8364,8391,8395,8442,40055,40058,40059,40062,40068,40069,40071,40075,40137,40138,
   40141,40147,40148,40150,40154,40249,40252,40258,40259,40261,40265,40287,40293,40294,40296,40300,
   40392,40393,40395,40399,40564,40566,40570,40591,40595,40642,40957,40958,40961,40967,40968,40970,
   40974,41069,41072,41078,41079,41081,41085,41107,41113,41114,41116,41120,41212,41213,41215,41219,
   41384,41386,41390,41411,41415,41462,42590,42593,42599,42600,42602,42606,42628,42634,42635,42637,
   42641,42733,42734,42736,42740,42905,42907,42911,42932,42936,42983,44627,44633,44634,44636,44640,
   44732,44733,44735,44739,44904,44906,44910,44931,44935,44982,45327,45328,45330,45334,45499,45501,
   45505,45526,45530,45577,47084,47086,47090,47111,47115,47162,49471,49475,49522,49822],
 [7812,7814,7822,7823,7824,7828,7829,7830,7834,7855,7869,7871,7875,7948,7950,7954,8224,8225,8250,
   8254,8283,8390,8391,8395,8442,40055,40063,40064,40065,40069,40070,40071,40075,40142,40143,
   40144,40148,40149,40150,40154,40419,40420,40424,40425,40426,40430,40450,40454,40455,40456,40460,
   40483,40484,40485,40489,40590,40591,40595,40615,40619,40642,40962,40963,40964,40968,40969,40970,
   40974,41239,41240,41244,41245,41246,41250,41270,41274,41275,41276,41280,41303,41304,41305,41309,
   41410,41411,41415,41435,41439,41462,42760,42761,42765,42766,42767,42771,42791,42795,42796,42797,
   42801,42824,42825,42826,42830,42931,42932,42936,42956,42960,42983,47435,47439,47440,47441,47445,
   47468,47469,47470,47474,47575,47576,47580,47600,47604,47627,47903,47904,47905,47909,48010,48011,
   48015,48035,48039,48062,48416,48417,48421,48441,48445,48468,49795,49799,49822,50098],
 [7812,7814,7822,7823,7824,7828,7829,7830,7834,7855,7869,7871,7875,7948,7950,7954,8224,8225,8250,
   8254,8283,8390,8391,8395,8442,40055,40063,40064,40065,40069,40070,40071,40075,40142,40143,
   40144,40148,40149,40150,40154,40419,40420,40424,40425,40426,40430,40450,40454,40455,40456,40460,
   40483,40484,40485,40489,40590,40591,40595,40615,40619,40642,40962,40963,40964,40968,40969,40970,
   40974,41239,41240,41244,41245,41246,41250,41270,41274,41275,41276,41280,41303,41304,41305,41309,
   41410,41411,41415,41435,41439,41462,42760,42761,42765,42766,42767,42771,42791,42795,42796,42797,
   42801,42824,42825,42826,42830,42931,42932,42936,42956,42960,42983,47435,47439,47440,47441,47445,
   47468,47469,47470,47474,47575,47576,47580,47600,47604,47627,47903,47904,47905,47909,48010,48011,
   48015,48035,48039,48062,48416,48417,48421,48441,48445,48468,49795,49799,49822,50098],
 [7812,7814,7822,7823,7824,7828,7829,7830,7834,7855,7869,7871,7875,7948,7950,7954,8224,8225,8250,
   8254,8283,8390,8391,8395,8442,40055,40063,40064,40065,40069,40070,40071,40075,40142,40143,
   40144,40148,40149,40150,40154,40419,40420,40424,40425,40426,40430,40450,40454,40455,40456,40460,
   40483,40484,40485,40489,40590,40591,40595,40615,40619,40642,40962,40963,40964,40968,40969,40970,
   40974,41239,41240,41244,41245,41246,41250,41270,41274,41275,41276,41280,41303,41304,41305,41309,
   41410,41411,41415,41435,41439,41462,42760,42761,42765,42766,42767,42771,42791,42795,42796,42797,
   42801,42824,42825,42826,42830,42931,42932,42936,42956,42960,42983,47435,47439,47440,47441,47445,
   47468,47469,47470,47474,47575,47576,47580,47600,47604,47627,47903,47904,47905,47909,48010,48011,
   48015,48035,48039,48062,48416,48417,48421,48441,48445,48468,49795,49799,49822,50098],
 [7875,41337],[7875,7950,41364,42881],[7812,7814,7817,7818,7821,7827,7828,7830,7834,7855,7869,
   7871,7875,7948,7950,7954,8058,8059,8087,8094,8193,8364,8391,8395,8442,40055,40058,40059,40062,
   40068,40069,40071,40075,40137,40138,40141,40147,40148,40150,40154,40249,40252,40258,40259,40261,
   40265,40287,40293,40294,40296,40300,40392,40393,40395,40399,40564,40566,40570,40591,40595,40642,
   40957,40958,40961,40967,40968,40970,40974,41069,41072,41078,41079,41081,41085,41107,41113,41114,
   41116,41120,41212,41213,41215,41219,41384,41386,41390,41411,41415,41462,42590,42593,42599,42600,
   42602,42606,42628,42634,42635,42637,42641,42733,42734,42736,42740,42905,42907,42911,42932,42936,
   42983,44627,44633,44634,44636,44640,44732,44733,44735,44739,44904,44906,44910,44931,44935,44982,
   45327,45328,45330,45334,45499,45501,45505,45526,45530,45577,47084,47086,47090,47111,47115,47162,
   49471,49475,49522,49822],[7828,7875,7950,40055,40642,41411,42936],
 [7812,7814,7822,7823,7824,7828,7829,7830,7834,7855,7869,7871,7875,7948,7950,7954,8224,8225,8250,
   8254,8283,8390,8391,8395,8442,40055,40063,40064,40065,40069,40070,40071,40075,40142,40143,
   40144,40148,40149,40150,40154,40419,40420,40424,40425,40426,40430,40450,40454,40455,40456,40460,
   40483,40484,40485,40489,40590,40591,40595,40615,40619,40642,40962,40963,40964,40968,40969,40970,
   40974,41239,41240,41244,41245,41246,41250,41270,41274,41275,41276,41280,41303,41304,41305,41309,
   41410,41411,41415,41435,41439,41462,42760,42761,42765,42766,42767,42771,42791,42795,42796,42797,
   42801,42824,42825,42826,42830,42931,42932,42936,42956,42960,42983,47435,47439,47440,47441,47445,
   47468,47469,47470,47474,47575,47576,47580,47600,47604,47627,47903,47904,47905,47909,48010,48011,
   48015,48035,48039,48062,48416,48417,48421,48441,48445,48468,49795,49799,49822,50098],
 [7828,7875,7950,40055,40642,41411,42936],[7875,41484],
 [7725,7726,7743,7769,7786,7812,7813,7814,7828,7830,7832,7834,7855,7869,7871,7875,7909,7913,7948,
   7950,7954,8391,8393,8395,8442,38205,38206,38207,38208,38222,38224,38226,38228,38248,38249,
   38250,38264,38266,38268,38270,38290,38291,38305,38307,38309,38311,38331,38345,38347,38349,38351,
   38384,38386,38388,38390,38827,38829,38831,38876,38878,38921,39151,39152,39153,39167,39169,39171,
   39173,39193,39194,39208,39210,39212,39214,39234,39248,39250,39252,39254,39287,39289,39291,39293,
   39730,39732,39734,39779,39781,39824,40054,40055,40069,40071,40073,40075,40095,40109,40111,40113,
   40115,40148,40150,40152,40154,40591,40593,40595,40640,40642,40685,40915,40929,40931,40933,40935,
   40968,40970,40972,40974,41411,41413,41415,41460,41462,41505,41748,41750,41752,41754,42191,42193,
   42195,42240,42242,42285,42932,42934,42936,42981,42983,43026,49820,49822,49865,50394],
 [7875,8507,41525,41527,41546,51066],[],[7875,8168,41187,41545],
 [7875,8507,41525,41527,41546,51066],[7875,8032,41049,41547],[7875,7996,41012,41016,41548,43772]
  ,[7875,7950,41549,42988],[7875,41550],[7875,41551],[7875,7950,41552,42991],[7875,41553],
 [7875,41554],[7875,41555],[7875,7950,41556,42995],[7875,41557],[7875,7950,41558,42997],
 [7875,41559],[7875,41560],[7875,7950,41561,43000],[7875,41562],[7875,41563],
 [7725,7726,7743,7769,7786,7812,7813,7814,7828,7830,7832,7834,7855,7869,7871,7875,7909,7913,7948,
   7950,7954,8391,8393,8395,8442,38205,38206,38207,38208,38222,38224,38226,38228,38248,38249,
   38250,38264,38266,38268,38270,38290,38291,38305,38307,38309,38311,38331,38345,38347,38349,38351,
   38384,38386,38388,38390,38827,38829,38831,38876,38878,38921,39151,39152,39153,39167,39169,39171,
   39173,39193,39194,39208,39210,39212,39214,39234,39248,39250,39252,39254,39287,39289,39291,39293,
   39730,39732,39734,39779,39781,39824,40054,40055,40069,40071,40073,40075,40095,40109,40111,40113,
   40115,40148,40150,40152,40154,40591,40593,40595,40640,40642,40685,40915,40929,40931,40933,40935,
   40968,40970,40972,40974,41411,41413,41415,41460,41462,41505,41748,41750,41752,41754,42191,42193,
   42195,42240,42242,42285,42932,42934,42936,42981,42983,43026,49820,49822,49865,50394],
 [7813,7815,7828,7832,7838,7909,7913,7986,7996,8393,8399,40109,40113,40186,40196,40593,40599,
   41786,41790,41796,42193,42199,42289,43637,43643,43733,49869],
 [7813,7816,7828,7832,7833,7836,7837,7909,7913,8023,8032,8393,8394,8397,8398,8507,40109,40113,
   40223,40232,40593,40594,40597,40598,40707,41823,41827,41828,42193,42194,42197,42198,42284,42287,
   42288,42307,42308,42362,44303,44304,44307,44308,44394,44397,44417,49864,49867,49868,49887,49888,
   49942,50857,50912,51102],[7813,7817,7819,7827,7828,7832,7909,7913,8058,8059,8128,8364,8393,
   40109,40113,40258,40259,40328,40564,40593,41850,41858,41859,41863,41927,41928,41932,42164,42168,
   42193,44667,44668,44672,44904,44908,44933,46060,46064,46089,49473],
 [7813,7818,7821,7828,7832,7909,7913,8087,8094,8193,8393,40099,40102,40109,40113,40287,40294,
   40298,40393,40397,40593,41887,41894,41898,41993,41997,42193,45328,45332,45528,47113],
 [7813,7817,7819,7827,7828,7832,7909,7913,8058,8059,8128,8364,8393,40109,40113,40258,40259,40328,
   40564,40593,41850,41858,41859,41863,41927,41928,41932,42164,42168,42193,44667,44668,44672,44904,
   44908,44933,46060,46064,46089,49473],[7813,7820,7828,7832,7835,7909,7913,8161,8168,8393,8396,
   40109,40113,40361,40368,40593,40596,41961,41965,42193,42196,42286,46617,46620,49866],
 [7813,7818,7821,7828,7832,7909,7913,8087,8094,8193,8393,40099,40102,40109,40113,40287,40294,
   40298,40393,40397,40593,41887,41894,41898,41993,41997,42193,45328,45332,45528,47113],
 [7813,7822,7828,7829,7832,7909,7913,8224,8225,8390,8393,40109,40113,40424,40425,40590,40593,
   42024,42025,42028,42190,42193,42217,47575,47578,47602,49797],
 [7813,7823,7824,7828,7832,7909,7913,8250,8254,8283,8393,40104,40105,40109,40113,40450,40454,
   40458,40483,40487,40593,42050,42054,42058,42083,42087,42193,47903,47907,48013,48419],
 [7813,7823,7824,7828,7832,7909,7913,8250,8254,8283,8393,40104,40105,40109,40113,40450,40454,
   40458,40483,40487,40593,42050,42054,42058,42083,42087,42193,47903,47907,48013,48419],
 [7813,7825,7826,7828,7831,7832,7909,7913,8311,8314,8338,8392,8393,40109,40113,40511,40514,40538,
   40592,40593,42109,42111,42114,42115,42138,42141,42142,42192,42193,42262,48742,48745,48746,48796,
   48797,48866,49147,49148,49217,49842],[7813,7825,7826,7828,7831,7832,7909,7913,8311,8314,8338,
   8392,8393,40109,40113,40511,40514,40538,40592,40593,42109,42111,42114,42115,42138,42141,42142,
   42192,42193,42262,48742,48745,48746,48796,48797,48866,49147,49148,49217,49842],
 [7813,7817,7819,7827,7828,7832,7909,7913,8058,8059,8128,8364,8393,40109,40113,40258,40259,40328,
   40564,40593,41850,41858,41859,41863,41927,41928,41932,42164,42168,42193,44667,44668,44672,44904,
   44908,44933,46060,46064,46089,49473],[7828,42193],
 [7813,7822,7828,7829,7832,7909,7913,8224,8225,8390,8393,40109,40113,40424,40425,40590,40593,
   42024,42025,42028,42190,42193,42217,47575,47578,47602,49797],
 [7725,7726,7743,7769,7786,7812,7813,7814,7828,7830,7832,7834,7855,7869,7871,7875,7909,7913,7948,
   7950,7954,8391,8393,8395,8442,38205,38206,38207,38208,38222,38224,38226,38228,38248,38249,
   38250,38264,38266,38268,38270,38290,38291,38305,38307,38309,38311,38331,38345,38347,38349,38351,
   38384,38386,38388,38390,38827,38829,38831,38876,38878,38921,39151,39152,39153,39167,39169,39171,
   39173,39193,39194,39208,39210,39212,39214,39234,39248,39250,39252,39254,39287,39289,39291,39293,
   39730,39732,39734,39779,39781,39824,40054,40055,40069,40071,40073,40075,40095,40109,40111,40113,
   40115,40148,40150,40152,40154,40591,40593,40595,40640,40642,40685,40915,40929,40931,40933,40935,
   40968,40970,40972,40974,41411,41413,41415,41460,41462,41505,41748,41750,41752,41754,42191,42193,
   42195,42240,42242,42285,42932,42934,42936,42981,42983,43026,49820,49822,49865,50394],
 [7813,7825,7826,7828,7831,7832,7909,7913,8311,8314,8338,8392,8393,40109,40113,40511,40514,40538,
   40592,40593,42109,42111,42114,42115,42138,42141,42142,42192,42193,42262,48742,48745,48746,48796,
   48797,48866,49147,49148,49217,49842],[7828,42193],
 [7813,7816,7828,7832,7833,7836,7837,7909,7913,8023,8032,8393,8394,8397,8398,8507,40109,40113,
   40223,40232,40593,40594,40597,40598,40707,41823,41827,41828,42193,42194,42197,42198,42284,42287,
   42288,42307,42308,42362,44303,44304,44307,44308,44394,44397,44417,49864,49867,49868,49887,49888,
   49942,50857,50912,51102],[7725,7726,7743,7769,7786,7812,7813,7814,7828,7830,7832,7834,7855,
   7869,7871,7875,7909,7913,7948,7950,7954,8391,8393,8395,8442,38205,38206,38207,38208,38222,
   38224,38226,38228,38248,38249,38250,38264,38266,38268,38270,38290,38291,38305,38307,38309,38311,
   38331,38345,38347,38349,38351,38384,38386,38388,38390,38827,38829,38831,38876,38878,38921,39151,
   39152,39153,39167,39169,39171,39173,39193,39194,39208,39210,39212,39214,39234,39248,39250,39252,
   39254,39287,39289,39291,39293,39730,39732,39734,39779,39781,39824,40054,40055,40069,40071,40073,
   40075,40095,40109,40111,40113,40115,40148,40150,40152,40154,40591,40593,40595,40640,40642,40685,
   40915,40929,40931,40933,40935,40968,40970,40972,40974,41411,41413,41415,41460,41462,41505,41748,
   41750,41752,41754,42191,42193,42195,42240,42242,42285,42932,42934,42936,42981,42983,43026,49820,
   49822,49865,50394],[7813,7820,7828,7832,7835,7909,7913,8161,8168,8393,8396,40109,40113,40361,
   40368,40593,40596,41961,41965,42193,42196,42286,46617,46620,49866],
 [7813,7816,7828,7832,7833,7836,7837,7909,7913,8023,8032,8393,8394,8397,8398,8507,40109,40113,
   40223,40232,40593,40594,40597,40598,40707,41823,41827,41828,42193,42194,42197,42198,42284,42287,
   42288,42307,42308,42362,44303,44304,44307,44308,44394,44397,44417,49864,49867,49868,49887,49888,
   49942,50857,50912,51102],[7813,7816,7828,7832,7833,7836,7837,7909,7913,8023,8032,8393,8394,
   8397,8398,8507,40109,40113,40223,40232,40593,40594,40597,40598,40707,41823,41827,41828,42193,
   42194,42197,42198,42284,42287,42288,42307,42308,42362,44303,44304,44307,44308,44394,44397,44417,
   49864,49867,49868,49887,49888,49942,50857,50912,51102],
 [7813,7815,7828,7832,7838,7909,7913,7986,7996,8393,8399,40109,40113,40186,40196,40593,40599,
   41786,41790,41796,42193,42199,42289,43637,43643,43733,49869],
 [7813,7828,7832,7839,7909,7913,8393,8400,40109,40113,40593,40600,42193,42200,42290,49870],
 [7813,7828,7832,7840,7841,7909,7913,8393,8401,8402,8624,40109,40113,40593,40601,40602,40824,
   42193,42201,42202,42291,42292,49871,49872,50004],
 [7813,7828,7832,7840,7841,7909,7913,8393,8401,8402,8624,40109,40113,40593,40601,40602,40824,
   42193,42201,42202,42291,42292,49871,49872,50004],
 [7813,7828,7832,7842,7843,7850,7909,7913,8393,8403,8404,8411,8666,40109,40113,40593,40603,40604,
   40611,40866,42193,42203,42204,42211,42293,42294,42301,42449,42456,42466,49873,49874,49881,50029,
   50036,50046,50999,51006,51016,52181],[7813,7828,7832,7842,7843,7850,7909,7913,8393,8403,8404,
   8411,8666,40109,40113,40593,40603,40604,40611,40866,42193,42203,42204,42211,42293,42294,42301,
   42449,42456,42466,49873,49874,49881,50029,50036,50046,50999,51006,51016,52181],
 [7813,7828,7832,7844,7845,7909,7913,8393,8405,8406,8670,40109,40113,40593,40605,40606,40870,
   42193,42205,42206,42295,42296,49875,49876,50050],
 [7813,7828,7832,7844,7845,7909,7913,8393,8405,8406,8670,40109,40113,40593,40605,40606,40870,
   42193,42205,42206,42295,42296,49875,49876,50050],
 [7813,7828,7832,7846,7909,7913,8393,8407,40109,40113,40593,40607,42193,42207,42297,49877],
 [7813,7828,7832,7847,7848,7849,7909,7913,8393,8408,8409,8410,8695,40109,40113,40593,40608,40609,
   40610,40895,42193,42208,42209,42210,42298,42299,42300,42494,42495,42500,49878,49879,49880,50074,
   50075,50080,51044,51045,51050,52360],[7813,7828,7832,7847,7848,7849,7909,7913,8393,8408,8409,
   8410,8695,40109,40113,40593,40608,40609,40610,40895,42193,42208,42209,42210,42298,42299,42300,
   42494,42495,42500,49878,49879,49880,50074,50075,50080,51044,51045,51050,52360],
 [7813,7828,7832,7847,7848,7849,7909,7913,8393,8408,8409,8410,8695,40109,40113,40593,40608,40609,
   40610,40895,42193,42208,42209,42210,42298,42299,42300,42494,42495,42500,49878,49879,49880,50074,
   50075,50080,51044,51045,51050,52360],[7813,7828,7832,7842,7843,7850,7909,7913,8393,8403,8404,
   8411,8666,40109,40113,40593,40603,40604,40611,40866,42193,42203,42204,42211,42293,42294,42301,
   42449,42456,42466,49873,49874,49881,50029,50036,50046,50999,51006,51016,52181],
 [7813,7828,7832,7851,7909,7913,8393,8412,40109,40113,40593,40612,42193,42212,42302,49882],
 [7813,7828,7832,7852,7853,7909,7913,8393,8413,8414,8714,40109,40113,40593,40613,40614,40914,
   42193,42213,42214,42303,42304,49883,49884,50094],
 [7813,7828,7832,7852,7853,7909,7913,8393,8413,8414,8714,40109,40113,40593,40613,40614,40914,
   42193,42213,42214,42303,42304,49883,49884,50094],
 [7950,7996,8507,42529,42532,42535,42537,42982,42985,42987,43048,43050,43104,43685,43688,43690,
   43751,43753,43807,50416,50418,50472,51103],[7950,8032,42566,42986],
 [7812,7814,7817,7818,7821,7827,7828,7830,7834,7855,7869,7871,7875,7948,7950,7954,8058,8059,8087,
   8094,8193,8364,8391,8395,8442,40055,40058,40059,40062,40068,40069,40071,40075,40137,40138,
   40141,40147,40148,40150,40154,40249,40252,40258,40259,40261,40265,40287,40293,40294,40296,40300,
   40392,40393,40395,40399,40564,40566,40570,40591,40595,40642,40957,40958,40961,40967,40968,40970,
   40974,41069,41072,41078,41079,41081,41085,41107,41113,41114,41116,41120,41212,41213,41215,41219,
   41384,41386,41390,41411,41415,41462,42590,42593,42599,42600,42602,42606,42628,42634,42635,42637,
   42641,42733,42734,42736,42740,42905,42907,42911,42932,42936,42983,44627,44633,44634,44636,44640,
   44732,44733,44735,44739,44904,44906,44910,44931,44935,44982,45327,45328,45330,45334,45499,45501,
   45505,45526,45530,45577,47084,47086,47090,47111,47115,47162,49471,49475,49522,49822],
 [7812,7814,7817,7818,7821,7827,7828,7830,7834,7855,7869,7871,7875,7948,7950,7954,8058,8059,8087,
   8094,8193,8364,8391,8395,8442,40055,40058,40059,40062,40068,40069,40071,40075,40137,40138,
   40141,40147,40148,40150,40154,40249,40252,40258,40259,40261,40265,40287,40293,40294,40296,40300,
   40392,40393,40395,40399,40564,40566,40570,40591,40595,40642,40957,40958,40961,40967,40968,40970,
   40974,41069,41072,41078,41079,41081,41085,41107,41113,41114,41116,41120,41212,41213,41215,41219,
   41384,41386,41390,41411,41415,41462,42590,42593,42599,42600,42602,42606,42628,42634,42635,42637,
   42641,42733,42734,42736,42740,42905,42907,42911,42932,42936,42983,44627,44633,44634,44636,44640,
   44732,44733,44735,44739,44904,44906,44910,44931,44935,44982,45327,45328,45330,45334,45499,45501,
   45505,45526,45530,45577,47084,47086,47090,47111,47115,47162,49471,49475,49522,49822],
 [7950,42671],[7950,8168,42704,42984],[7812,7814,7817,7818,7821,7827,7828,7830,7834,7855,7869,
   7871,7875,7948,7950,7954,8058,8059,8087,8094,8193,8364,8391,8395,8442,40055,40058,40059,40062,
   40068,40069,40071,40075,40137,40138,40141,40147,40148,40150,40154,40249,40252,40258,40259,40261,
   40265,40287,40293,40294,40296,40300,40392,40393,40395,40399,40564,40566,40570,40591,40595,40642,
   40957,40958,40961,40967,40968,40970,40974,41069,41072,41078,41079,41081,41085,41107,41113,41114,
   41116,41120,41212,41213,41215,41219,41384,41386,41390,41411,41415,41462,42590,42593,42599,42600,
   42602,42606,42628,42634,42635,42637,42641,42733,42734,42736,42740,42905,42907,42911,42932,42936,
   42983,44627,44633,44634,44636,44640,44732,44733,44735,44739,44904,44906,44910,44931,44935,44982,
   45327,45328,45330,45334,45499,45501,45505,45526,45530,45577,47084,47086,47090,47111,47115,47162,
   49471,49475,49522,49822],[7812,7814,7822,7823,7824,7828,7829,7830,7834,7855,7869,7871,7875,
   7948,7950,7954,8224,8225,8250,8254,8283,8390,8391,8395,8442,40055,40063,40064,40065,40069,
   40070,40071,40075,40142,40143,40144,40148,40149,40150,40154,40419,40420,40424,40425,40426,40430,
   40450,40454,40455,40456,40460,40483,40484,40485,40489,40590,40591,40595,40615,40619,40642,40962,
   40963,40964,40968,40969,40970,40974,41239,41240,41244,41245,41246,41250,41270,41274,41275,41276,
   41280,41303,41304,41305,41309,41410,41411,41415,41435,41439,41462,42760,42761,42765,42766,42767,
   42771,42791,42795,42796,42797,42801,42824,42825,42826,42830,42931,42932,42936,42956,42960,42983,
   47435,47439,47440,47441,47445,47468,47469,47470,47474,47575,47576,47580,47600,47604,47627,47903,
   47904,47905,47909,48010,48011,48015,48035,48039,48062,48416,48417,48421,48441,48445,48468,49795,
   49799,49822,50098],[7812,7814,7822,7823,7824,7828,7829,7830,7834,7855,7869,7871,7875,7948,
   7950,7954,8224,8225,8250,8254,8283,8390,8391,8395,8442,40055,40063,40064,40065,40069,40070,
   40071,40075,40142,40143,40144,40148,40149,40150,40154,40419,40420,40424,40425,40426,40430,40450,
   40454,40455,40456,40460,40483,40484,40485,40489,40590,40591,40595,40615,40619,40642,40962,40963,
   40964,40968,40969,40970,40974,41239,41240,41244,41245,41246,41250,41270,41274,41275,41276,41280,
   41303,41304,41305,41309,41410,41411,41415,41435,41439,41462,42760,42761,42765,42766,42767,42771,
   42791,42795,42796,42797,42801,42824,42825,42826,42830,42931,42932,42936,42956,42960,42983,47435,
   47439,47440,47441,47445,47468,47469,47470,47474,47575,47576,47580,47600,47604,47627,47903,47904,
   47905,47909,48010,48011,48015,48035,48039,48062,48416,48417,48421,48441,48445,48468,49795,49799,
   49822,50098],[7812,7814,7822,7823,7824,7828,7829,7830,7834,7855,7869,7871,7875,7948,7950,
   7954,8224,8225,8250,8254,8283,8390,8391,8395,8442,40055,40063,40064,40065,40069,40070,40071,
   40075,40142,40143,40144,40148,40149,40150,40154,40419,40420,40424,40425,40426,40430,40450,40454,
   40455,40456,40460,40483,40484,40485,40489,40590,40591,40595,40615,40619,40642,40962,40963,40964,
   40968,40969,40970,40974,41239,41240,41244,41245,41246,41250,41270,41274,41275,41276,41280,41303,
   41304,41305,41309,41410,41411,41415,41435,41439,41462,42760,42761,42765,42766,42767,42771,42791,
   42795,42796,42797,42801,42824,42825,42826,42830,42931,42932,42936,42956,42960,42983,47435,47439,
   47440,47441,47445,47468,47469,47470,47474,47575,47576,47580,47600,47604,47627,47903,47904,47905,
   47909,48010,48011,48015,48035,48039,48062,48416,48417,48421,48441,48445,48468,49795,49799,49822,
   50098],[7950,42854],[7875,7950,41364,42881],
 [7812,7814,7817,7818,7821,7827,7828,7830,7834,7855,7869,7871,7875,7948,7950,7954,8058,8059,8087,
   8094,8193,8364,8391,8395,8442,40055,40058,40059,40062,40068,40069,40071,40075,40137,40138,
   40141,40147,40148,40150,40154,40249,40252,40258,40259,40261,40265,40287,40293,40294,40296,40300,
   40392,40393,40395,40399,40564,40566,40570,40591,40595,40642,40957,40958,40961,40967,40968,40970,
   40974,41069,41072,41078,41079,41081,41085,41107,41113,41114,41116,41120,41212,41213,41215,41219,
   41384,41386,41390,41411,41415,41462,42590,42593,42599,42600,42602,42606,42628,42634,42635,42637,
   42641,42733,42734,42736,42740,42905,42907,42911,42932,42936,42983,44627,44633,44634,44636,44640,
   44732,44733,44735,44739,44904,44906,44910,44931,44935,44982,45327,45328,45330,45334,45499,45501,
   45505,45526,45530,45577,47084,47086,47090,47111,47115,47162,49471,49475,49522,49822],
 [7828,7875,7950,40055,40642,41411,42936],
 [7812,7814,7822,7823,7824,7828,7829,7830,7834,7855,7869,7871,7875,7948,7950,7954,8224,8225,8250,
   8254,8283,8390,8391,8395,8442,40055,40063,40064,40065,40069,40070,40071,40075,40142,40143,
   40144,40148,40149,40150,40154,40419,40420,40424,40425,40426,40430,40450,40454,40455,40456,40460,
   40483,40484,40485,40489,40590,40591,40595,40615,40619,40642,40962,40963,40964,40968,40969,40970,
   40974,41239,41240,41244,41245,41246,41250,41270,41274,41275,41276,41280,41303,41304,41305,41309,
   41410,41411,41415,41435,41439,41462,42760,42761,42765,42766,42767,42771,42791,42795,42796,42797,
   42801,42824,42825,42826,42830,42931,42932,42936,42956,42960,42983,47435,47439,47440,47441,47445,
   47468,47469,47470,47474,47575,47576,47580,47600,47604,47627,47903,47904,47905,47909,48010,48011,
   48015,48035,48039,48062,48416,48417,48421,48441,48445,48468,49795,49799,49822,50098],[],
 [7950,42980],[7725,7726,7743,7769,7786,7812,7813,7814,7828,7830,7832,7834,7855,7869,7871,7875,
   7909,7913,7948,7950,7954,8391,8393,8395,8442,38205,38206,38207,38208,38222,38224,38226,38228,
   38248,38249,38250,38264,38266,38268,38270,38290,38291,38305,38307,38309,38311,38331,38345,38347,
   38349,38351,38384,38386,38388,38390,38827,38829,38831,38876,38878,38921,39151,39152,39153,39167,
   39169,39171,39173,39193,39194,39208,39210,39212,39214,39234,39248,39250,39252,39254,39287,39289,
   39291,39293,39730,39732,39734,39779,39781,39824,40054,40055,40069,40071,40073,40075,40095,40109,
   40111,40113,40115,40148,40150,40152,40154,40591,40593,40595,40640,40642,40685,40915,40929,40931,
   40933,40935,40968,40970,40972,40974,41411,41413,41415,41460,41462,41505,41748,41750,41752,41754,
   42191,42193,42195,42240,42242,42285,42932,42934,42936,42981,42983,43026,49820,49822,49865,50394]
  ,[7950,7996,8507,42529,42532,42535,42537,42982,42985,42987,43048,43050,43104,43685,43688,43690,
   43751,43753,43807,50416,50418,50472,51103],[7828,7875,7950,40055,40642,41411,42936],
 [7950,8168,42704,42984],[7950,7996,8507,42529,42532,42535,42537,42982,42985,42987,43048,43050,
   43104,43685,43688,43690,43751,43753,43807,50416,50418,50472,51103],[7950,8032,42566,42986],
 [7950,7996,8507,42529,42532,42535,42537,42982,42985,42987,43048,43050,43104,43685,43688,43690,
   43751,43753,43807,50416,50418,50472,51103],[7875,7950,41549,42988],[7950,42989],
 [7950,42990],[7875,7950,41552,42991],[7950,42992],[7950,42993],[7950,42994],
 [7875,7950,41556,42995],[7950,42996],[7875,7950,41558,42997],[7950,42998],[7950,42999],
 [7875,7950,41561,43000],[7950,43001],[7950,43002],
 [7725,7726,7743,7769,7786,7815,7816,7828,7837,7838,7986,7996,8023,8032,8398,8399,38205,38209,
   38210,38222,38231,38232,38251,38252,38264,38273,38274,38410,38431,38432,39015,39154,39155,39167,
   39176,39177,39313,39335,39372,39918,40174,40186,40195,40196,40223,40232,40233,40598,40599,40779,
   43277,43643,43823,44308],[7815,7817,7827,7828,7838,7986,7996,8058,8059,8364,8399,40186,40196,
   40258,40259,40564,40599,43302,43303,43313,43608,43618,43643,44904,44914,44939,49479],
 [7815,7818,7820,7821,7828,7835,7838,7986,7996,8087,8094,8161,8168,8193,8396,8399,40176,40178,
   40179,40186,40193,40196,40286,40287,40294,40301,40304,40354,40361,40368,40371,40393,40400,40403,
   40596,40599,40746,43330,43331,43348,43398,43415,43444,43447,43643,43790,45289,45306,45328,45335,
   45338,45681,46620,47266],[7996,43382],
 [7815,7818,7820,7821,7828,7835,7838,7986,7996,8087,8094,8161,8168,8193,8396,8399,40176,40178,
   40179,40186,40193,40196,40286,40287,40294,40301,40304,40354,40361,40368,40371,40393,40400,40403,
   40596,40599,40746,43330,43331,43348,43398,43415,43444,43447,43643,43790,45289,45306,45328,45335,
   45338,45681,46620,47266],[7815,7818,7820,7821,7828,7835,7838,7986,7996,8087,8094,8161,8168,
   8193,8396,8399,40176,40178,40179,40186,40193,40196,40286,40287,40294,40301,40304,40354,40361,
   40368,40371,40393,40400,40403,40596,40599,40746,43330,43331,43348,43398,43415,43444,43447,43643,
   43790,45289,45306,45328,45335,45338,45681,46620,47266],
 [7815,7822,7828,7829,7838,7986,7996,8224,8225,8390,8399,40186,40196,40424,40425,40590,40599,
   43468,43469,43478,43634,43643,43667,47575,47584,47608,49803],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,3501,3505,3506,3507,3513,
   3514,3517,3518,3527,3528,3544,3548,3549,3550,3556,3557,3560,3561,3570,3571,3590,3591,3592,
   3598,3599,3602,3603,3612,3613,3749,3750,3756,3757,3770,3771,3787,3793,3794,3829,3830,3833,
   3834,3843,3844,4025,4038,4039,4139,4354,4510,4511,4512,4518,4528,4529,5645,5646,5650,5651,
   5652,5658,5659,5662,5663,5672,5673,5689,5693,5694,5695,5701,5702,5705,5706,5715,5716,5735,
   5736,5737,5743,5744,5747,5748,5757,5758,5894,5902,5905,5916,5939,5942,5953,5978,5979,6170,
   6173,6183,6184,6202,6212,6213,6284,6293,6294,6499,7725,7726,7730,7731,7732,7738,7739,7742,
   7743,7752,7753,7769,7773,7774,7775,7781,7782,7785,7786,7795,7796,7815,7816,7817,7823,7824,
   7827,7828,7837,7838,7974,7986,7995,7996,8018,8019,8023,8032,8033,8058,8059,8250,8254,8263,
   8283,8292,8364,8398,8399,8579,38205,38209,38210,38211,38217,38218,38221,38222,38231,38232,
   38251,38252,38253,38259,38260,38263,38264,38273,38274,38410,38411,38417,38418,38431,38432,38448,
   38454,38455,38468,38469,38490,38491,38494,38495,38504,38505,38686,38699,38700,38728,38729,38800,
   39015,39154,39155,39156,39162,39163,39166,39167,39176,39177,39313,39320,39321,39324,39334,39335,
   39357,39358,39361,39371,39372,39397,39398,39589,39592,39602,39603,39621,39631,39632,39703,39712,
   39713,39918,40174,40181,40182,40186,40195,40196,40218,40219,40223,40232,40233,40258,40259,40450,
   40454,40463,40464,40483,40492,40493,40564,40598,40599,40779,43262,43263,43266,43276,43277,43298,
   43494,43507,43508,43536,43537,43643,43823,43965,44160,44173,44174,44202,44203,44308,44489,44904,
   45119,47903,47912,47913,47993,48199,48400,48605],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,3501,3505,3506,3507,3513,
   3514,3517,3518,3527,3528,3544,3548,3549,3550,3556,3557,3560,3561,3570,3571,3590,3591,3592,
   3598,3599,3602,3603,3612,3613,3749,3750,3756,3757,3770,3771,3787,3793,3794,3829,3830,3833,
   3834,3843,3844,4025,4038,4039,4139,4354,4510,4511,4512,4518,4528,4529,5645,5646,5650,5651,
   5652,5658,5659,5662,5663,5672,5673,5689,5693,5694,5695,5701,5702,5705,5706,5715,5716,5735,
   5736,5737,5743,5744,5747,5748,5757,5758,5894,5902,5905,5916,5939,5942,5953,5978,5979,6170,
   6173,6183,6184,6202,6212,6213,6284,6293,6294,6499,7725,7726,7730,7731,7732,7738,7739,7742,
   7743,7752,7753,7769,7773,7774,7775,7781,7782,7785,7786,7795,7796,7815,7816,7817,7823,7824,
   7827,7828,7837,7838,7974,7986,7995,7996,8018,8019,8023,8032,8033,8058,8059,8250,8254,8263,
   8283,8292,8364,8398,8399,8579,38205,38209,38210,38211,38217,38218,38221,38222,38231,38232,
   38251,38252,38253,38259,38260,38263,38264,38273,38274,38410,38411,38417,38418,38431,38432,38448,
   38454,38455,38468,38469,38490,38491,38494,38495,38504,38505,38686,38699,38700,38728,38729,38800,
   39015,39154,39155,39156,39162,39163,39166,39167,39176,39177,39313,39320,39321,39324,39334,39335,
   39357,39358,39361,39371,39372,39397,39398,39589,39592,39602,39603,39621,39631,39632,39703,39712,
   39713,39918,40174,40181,40182,40186,40195,40196,40218,40219,40223,40232,40233,40258,40259,40450,
   40454,40463,40464,40483,40492,40493,40564,40598,40599,40779,43262,43263,43266,43276,43277,43298,
   43494,43507,43508,43536,43537,43643,43823,43965,44160,44173,44174,44202,44203,44308,44489,44904,
   45119,47903,47912,47913,47993,48199,48400,48605],[7996,43565],[7996,43592],
 [7815,7817,7827,7828,7838,7986,7996,8058,8059,8364,8399,40186,40196,40258,40259,40564,40599,
   43302,43303,43313,43608,43618,43643,44904,44914,44939,49479],[7828,7996,40196,43643],
 [7815,7822,7828,7829,7838,7986,7996,8224,8225,8390,8399,40186,40196,40424,40425,40590,40599,
   43468,43469,43478,43634,43643,43667,47575,47584,47608,49803],
 [7950,7996,8507,42529,42532,42535,42537,42982,42985,42987,43048,43050,43104,43685,43688,43690,
   43751,43753,43807,50416,50418,50472,51103],[7996,43712],
 [7813,7815,7828,7832,7838,7909,7913,7986,7996,8393,8399,40109,40113,40186,40196,40593,40599,
   41786,41790,41796,42193,42199,42289,43637,43643,43733,49869],
 [7950,7996,8507,42529,42532,42535,42537,42982,42985,42987,43048,43050,43104,43685,43688,43690,
   43751,43753,43807,50416,50418,50472,51103],[7875,7996,41012,41016,41548,43772],
 [7815,7818,7820,7821,7828,7835,7838,7986,7996,8087,8094,8161,8168,8193,8396,8399,40176,40178,
   40179,40186,40193,40196,40286,40287,40294,40301,40304,40354,40361,40368,40371,40393,40400,40403,
   40596,40599,40746,43330,43331,43348,43398,43415,43444,43447,43643,43790,45289,45306,45328,45335,
   45338,45681,46620,47266],[7950,7996,8507,42529,42532,42535,42537,42982,42985,42987,43048,
   43050,43104,43685,43688,43690,43751,43753,43807,50416,50418,50472,51103],
 [7725,7726,7743,7769,7786,7815,7816,7828,7837,7838,7986,7996,8023,8032,8398,8399,38205,38209,
   38210,38222,38231,38232,38251,38252,38264,38273,38274,38410,38431,38432,39015,39154,39155,39167,
   39176,39177,39313,39335,39372,39918,40174,40186,40195,40196,40223,40232,40233,40598,40599,40779,
   43277,43643,43823,44308],[],[7996,43839],[7996,43840],[7996,43841],[7996,43842],
 [7996,43843],[7996,43844],[7996,43845],[7996,43846],[7996,43847],[7996,43848],
 [7996,43849],[7996,43850],[7996,43851],[7996,43852],[7996,43853],
 [7816,7817,7827,7828,7837,8023,8032,8058,8059,8364,8398,40223,40232,40258,40259,40564,40598,
   43968,43969,44274,44308,44904,44913,44938,49478],
 [7816,7818,7821,7828,7837,8023,8032,8087,8094,8193,8398,40213,40216,40223,40232,40287,40294,
   40303,40393,40402,40598,43997,44308,45328,45337],[8032,8168,44030,46241],
 [8032,8168,44030,46241],[7816,7818,7821,7828,7837,8023,8032,8087,8094,8193,8398,40213,40216,
   40223,40232,40287,40294,40303,40393,40402,40598,43997,44308,45328,45337],
 [7816,7822,7828,7829,7837,8023,8032,8224,8225,8390,8398,40223,40232,40424,40425,40590,40598,
   44134,44135,44300,44308,47575,47583,47607,49802],
 [7816,7823,7824,7828,7837,8023,8032,8250,8254,8283,8398,40218,40219,40223,40232,40450,40454,
   40463,40483,40492,40598,44160,44308,47903,47912],
 [7816,7823,7824,7828,7837,8023,8032,8250,8254,8283,8398,40218,40219,40223,40232,40450,40454,
   40463,40483,40492,40598,44160,44308,47903,47912],[8032],[8032],
 [7816,7817,7827,7828,7837,8023,8032,8058,8059,8364,8398,40223,40232,40258,40259,40564,40598,
   43968,43969,44274,44308,44904,44913,44938,49478],[7828,8032],
 [7816,7822,7828,7829,7837,8023,8032,8224,8225,8390,8398,40223,40232,40424,40425,40590,40598,
   44134,44135,44300,44308,47575,47583,47607,49802],[7950,8032,42566,42986],[8032],
 [7813,7816,7828,7832,7833,7836,7837,7909,7913,8023,8032,8393,8394,8397,8398,8507,40109,40113,
   40223,40232,40593,40594,40597,40598,40707,41823,41827,41828,42193,42194,42197,42198,42284,42287,
   42288,42307,42308,42362,44303,44304,44307,44308,44394,44397,44417,49864,49867,49868,49887,49888,
   49942,50857,50912,51102],[7813,7816,7828,7832,7833,7836,7837,7909,7913,8023,8032,8393,8394,
   8397,8398,8507,40109,40113,40223,40232,40593,40594,40597,40598,40707,41823,41827,41828,42193,
   42194,42197,42198,42284,42287,42288,42307,42308,42362,44303,44304,44307,44308,44394,44397,44417,
   49864,49867,49868,49887,49888,49942,50857,50912,51102],[7875,8032,41049,41547],
 [8032,8168,44030,46241],[7813,7816,7828,7832,7833,7836,7837,7909,7913,8023,8032,8393,8394,8397,
   8398,8507,40109,40113,40223,40232,40593,40594,40597,40598,40707,41823,41827,41828,42193,42194,
   42197,42198,42284,42287,42288,42307,42308,42362,44303,44304,44307,44308,44394,44397,44417,49864,
   49867,49868,49887,49888,49942,50857,50912,51102],[],
 [7725,7726,7743,7769,7786,7815,7816,7828,7837,7838,7986,7996,8023,8032,8398,8399,38205,38209,
   38210,38222,38231,38232,38251,38252,38264,38273,38274,38410,38431,38432,39015,39154,39155,39167,
   39176,39177,39313,39335,39372,39918,40174,40186,40195,40196,40223,40232,40233,40598,40599,40779,
   43277,43643,43823,44308],[8032],[8032],[8032],[8032],[8032],[8032],[8032],[8032],
 [8032],[8032],[8032],[8032],[8032],[8032],[8032],
 [7812,7814,7817,7818,7821,7827,7828,7830,7834,7855,7869,7871,7875,7948,7950,7954,8058,8059,8087,
   8094,8193,8364,8391,8395,8442,40055,40058,40059,40062,40068,40069,40071,40075,40137,40138,
   40141,40147,40148,40150,40154,40249,40252,40258,40259,40261,40265,40287,40293,40294,40296,40300,
   40392,40393,40395,40399,40564,40566,40570,40591,40595,40642,40957,40958,40961,40967,40968,40970,
   40974,41069,41072,41078,41079,41081,41085,41107,41113,41114,41116,41120,41212,41213,41215,41219,
   41384,41386,41390,41411,41415,41462,42590,42593,42599,42600,42602,42606,42628,42634,42635,42637,
   42641,42733,42734,42736,42740,42905,42907,42911,42932,42936,42983,44627,44633,44634,44636,44640,
   44732,44733,44735,44739,44904,44906,44910,44931,44935,44982,45327,45328,45330,45334,45499,45501,
   45505,45526,45530,45577,47084,47086,47090,47111,47115,47162,49471,49475,49522,49822],
 [7813,7817,7819,7827,7828,7832,7909,7913,8058,8059,8128,8364,8393,40109,40113,40258,40259,40328,
   40564,40593,41850,41858,41859,41863,41927,41928,41932,42164,42168,42193,44667,44668,44672,44904,
   44908,44933,46060,46064,46089,49473],[7817,7820,7827,7828,7833,7835,7836,8058,8059,8161,8168,
   8364,8394,8396,8397,8507,40258,40259,40361,40368,40564,40594,40596,40597,40707,44700,44701,
   44706,44904,44909,44911,44912,44934,44936,44937,45046,45047,45084,46588,46593,46596,46618,46620,
   46621,46731,49474,49476,49477,49587,49624,49886,49887,49924,51084],
 [7812,7814,7817,7818,7821,7827,7828,7830,7834,7855,7869,7871,7875,7948,7950,7954,8058,8059,8087,
   8094,8193,8364,8391,8395,8442,40055,40058,40059,40062,40068,40069,40071,40075,40137,40138,
   40141,40147,40148,40150,40154,40249,40252,40258,40259,40261,40265,40287,40293,40294,40296,40300,
   40392,40393,40395,40399,40564,40566,40570,40591,40595,40642,40957,40958,40961,40967,40968,40970,
   40974,41069,41072,41078,41079,41081,41085,41107,41113,41114,41116,41120,41212,41213,41215,41219,
   41384,41386,41390,41411,41415,41462,42590,42593,42599,42600,42602,42606,42628,42634,42635,42637,
   42641,42733,42734,42736,42740,42905,42907,42911,42932,42936,42983,44627,44633,44634,44636,44640,
   44732,44733,44735,44739,44904,44906,44910,44931,44935,44982,45327,45328,45330,45334,45499,45501,
   45505,45526,45530,45577,47084,47086,47090,47111,47115,47162,49471,49475,49522,49822],
 [7817,7822,7827,7828,7829,8058,8059,8224,8225,8364,8390,40258,40259,40424,40425,40564,40590,
   44763,44764,44765,44904,44905,44930,47549,47550,47575,49470],
 [7817,7823,7824,7827,7828,8058,8059,8250,8254,8283,8364,40254,40255,40258,40259,40450,40453,
   40454,40482,40483,40564,44790,44793,44794,44822,44823,44904,47902,47903,47984,48390],
 [7817,7823,7824,7827,7828,8058,8059,8250,8254,8283,8364,40254,40255,40258,40259,40450,40453,
   40454,40482,40483,40564,44790,44793,44794,44822,44823,44904,47902,47903,47984,48390],
 [7817,7825,7827,7828,7831,8058,8059,8311,8314,8364,8392,40258,40259,40511,40514,40564,40592,
   44850,44851,44854,44904,44907,44932,48768,48771,48796,49472],
 [7817,7826,7827,7828,8058,8059,8338,8364,40258,40259,40538,40564,44877,44878,44904,49119],
 [7828,44904],[7828,44904],[7817,7822,7827,7828,7829,8058,8059,8224,8225,8364,8390,40258,40259,
   40424,40425,40564,40590,44763,44764,44765,44904,44905,44930,47549,47550,47575,49470],
 [7812,7814,7817,7818,7821,7827,7828,7830,7834,7855,7869,7871,7875,7948,7950,7954,8058,8059,8087,
   8094,8193,8364,8391,8395,8442,40055,40058,40059,40062,40068,40069,40071,40075,40137,40138,
   40141,40147,40148,40150,40154,40249,40252,40258,40259,40261,40265,40287,40293,40294,40296,40300,
   40392,40393,40395,40399,40564,40566,40570,40591,40595,40642,40957,40958,40961,40967,40968,40970,
   40974,41069,41072,41078,41079,41081,41085,41107,41113,41114,41116,41120,41212,41213,41215,41219,
   41384,41386,41390,41411,41415,41462,42590,42593,42599,42600,42602,42606,42628,42634,42635,42637,
   42641,42733,42734,42736,42740,42905,42907,42911,42932,42936,42983,44627,44633,44634,44636,44640,
   44732,44733,44735,44739,44904,44906,44910,44931,44935,44982,45327,45328,45330,45334,45499,45501,
   45505,45526,45530,45577,47084,47086,47090,47111,47115,47162,49471,49475,49522,49822],
 [7817,7825,7827,7828,7831,8058,8059,8311,8314,8364,8392,40258,40259,40511,40514,40564,40592,
   44850,44851,44854,44904,44907,44932,48768,48771,48796,49472],
 [7813,7817,7819,7827,7828,7832,7909,7913,8058,8059,8128,8364,8393,40109,40113,40258,40259,40328,
   40564,40593,41850,41858,41859,41863,41927,41928,41932,42164,42168,42193,44667,44668,44672,44904,
   44908,44933,46060,46064,46089,49473],[7817,7820,7827,7828,7833,7835,7836,8058,8059,8161,8168,
   8364,8394,8396,8397,8507,40258,40259,40361,40368,40564,40594,40596,40597,40707,44700,44701,
   44706,44904,44909,44911,44912,44934,44936,44937,45046,45047,45084,46588,46593,46596,46618,46620,
   46621,46731,49474,49476,49477,49587,49624,49886,49887,49924,51084],
 [7812,7814,7817,7818,7821,7827,7828,7830,7834,7855,7869,7871,7875,7948,7950,7954,8058,8059,8087,
   8094,8193,8364,8391,8395,8442,40055,40058,40059,40062,40068,40069,40071,40075,40137,40138,
   40141,40147,40148,40150,40154,40249,40252,40258,40259,40261,40265,40287,40293,40294,40296,40300,
   40392,40393,40395,40399,40564,40566,40570,40591,40595,40642,40957,40958,40961,40967,40968,40970,
   40974,41069,41072,41078,41079,41081,41085,41107,41113,41114,41116,41120,41212,41213,41215,41219,
   41384,41386,41390,41411,41415,41462,42590,42593,42599,42600,42602,42606,42628,42634,42635,42637,
   42641,42733,42734,42736,42740,42905,42907,42911,42932,42936,42983,44627,44633,44634,44636,44640,
   44732,44733,44735,44739,44904,44906,44910,44931,44935,44982,45327,45328,45330,45334,45499,45501,
   45505,45526,45530,45577,47084,47086,47090,47111,47115,47162,49471,49475,49522,49822],
 [7817,7820,7827,7828,7833,7835,7836,8058,8059,8161,8168,8364,8394,8396,8397,8507,40258,40259,
   40361,40368,40564,40594,40596,40597,40707,44700,44701,44706,44904,44909,44911,44912,44934,44936,
   44937,45046,45047,45084,46588,46593,46596,46618,46620,46621,46731,49474,49476,49477,49587,49624,
   49886,49887,49924,51084],[7817,7820,7827,7828,7833,7835,7836,8058,8059,8161,8168,8364,8394,
   8396,8397,8507,40258,40259,40361,40368,40564,40594,40596,40597,40707,44700,44701,44706,44904,
   44909,44911,44912,44934,44936,44937,45046,45047,45084,46588,46593,46596,46618,46620,46621,46731,
   49474,49476,49477,49587,49624,49886,49887,49924,51084],
 [7816,7817,7827,7828,7837,8023,8032,8058,8059,8364,8398,40223,40232,40258,40259,40564,40598,
   43968,43969,44274,44308,44904,44913,44938,49478],
 [7815,7817,7827,7828,7838,7986,7996,8058,8059,8364,8399,40186,40196,40258,40259,40564,40599,
   43302,43303,43313,43608,43618,43643,44904,44914,44939,49479],
 [7817,7827,7828,7839,8058,8059,8364,8400,40258,40259,40564,40600,44904,44915,44940,49480],
 [7817,7827,7828,7840,7841,8058,8059,8364,8401,8402,8624,40258,40259,40564,40601,40602,40824,
   44904,44916,44917,44941,44942,49481,49482,50004],
 [7817,7827,7828,7840,7841,8058,8059,8364,8401,8402,8624,40258,40259,40564,40601,40602,40824,
   44904,44916,44917,44941,44942,49481,49482,50004],
 [7817,7827,7828,7842,8058,8059,8364,8403,40258,40259,40564,40603,44904,44918,44943,49483],
 [7817,7827,7828,7843,7850,8058,8059,8364,8404,8411,8666,40258,40259,40564,40604,40611,40866,
   44904,44919,44926,44944,44951,45206,49484,49491,49746,50046],
 [7817,7827,7828,7844,7845,8058,8059,8364,8405,8406,8670,40258,40259,40564,40605,40606,40870,
   44904,44920,44921,44945,44946,49485,49486,50050],
 [7817,7827,7828,7844,7845,8058,8059,8364,8405,8406,8670,40258,40259,40564,40605,40606,40870,
   44904,44920,44921,44945,44946,49485,49486,50050],
 [7817,7827,7828,7846,8058,8059,8364,8407,40258,40259,40564,40607,44904,44922,44947,49487],
 [7817,7827,7828,7847,7849,8058,8059,8364,8408,8410,8695,40258,40259,40564,40608,40610,40895,
   44904,44923,44925,44948,44950,45235,49488,49490,49775,50075],
 [7817,7827,7828,7848,8058,8059,8364,8409,40258,40259,40564,40609,44904,44924,44949,49489],
 [7817,7827,7828,7847,7849,8058,8059,8364,8408,8410,8695,40258,40259,40564,40608,40610,40895,
   44904,44923,44925,44948,44950,45235,49488,49490,49775,50075],
 [7817,7827,7828,7843,7850,8058,8059,8364,8404,8411,8666,40258,40259,40564,40604,40611,40866,
   44904,44919,44926,44944,44951,45206,49484,49491,49746,50046],
 [7817,7827,7828,7851,8058,8059,8364,8412,40258,40259,40564,40612,44904,44927,44952,49492],
 [7817,7827,7828,7852,7853,8058,8059,8364,8413,8414,8714,40258,40259,40564,40613,40614,40914,
   44904,44928,44929,44953,44954,49493,49494,50094],
 [7817,7827,7828,7852,7853,8058,8059,8364,8413,8414,8714,40258,40259,40564,40613,40614,40914,
   44904,44928,44929,44953,44954,49493,49494,50094],
 [7725,7726,7743,7769,7786,7818,7819,7821,7828,8087,8094,8128,8193,38205,38212,38213,38215,38222,
   38254,38255,38257,38264,38521,38523,38557,39157,39158,39160,39167,39424,39426,39460,40285,40287,
   40294,40321,40328,40393,45256,45328],[7815,7818,7820,7821,7828,7835,7838,7986,7996,8087,8094,
   8161,8168,8193,8396,8399,40176,40178,40179,40186,40193,40196,40286,40287,40294,40301,40304,
   40354,40361,40368,40371,40393,40400,40403,40596,40599,40746,43330,43331,43348,43398,43415,43444,
   43447,43643,43790,45289,45306,45328,45335,45338,45681,46620,47266],[7828,40287],
 [7818,7821,7822,7828,7829,8087,8094,8193,8224,8225,8390,40287,40288,40294,40295,40387,40393,
   40394,40424,40425,40590,45322,45328,45329,45359,45360,45525,46944,46945,47110,47575],
 [7818,7821,7823,7824,7828,8087,8094,8193,8250,8254,8283,40287,40289,40290,40294,40388,40389,
   40393,40450,40454,40483,45323,45324,45328,45385,46970,47903],
 [7818,7821,7823,7824,7828,8087,8094,8193,8250,8254,8283,40287,40289,40290,40294,40388,40389,
   40393,40450,40454,40483,45323,45324,45328,45385,46970,47903],
 [7818,7821,7825,7828,7831,8087,8094,8193,8311,8314,8392,40287,40291,40294,40297,40390,40393,
   40396,40511,40514,40592,45325,45328,45331,48796],
 [7818,7821,7826,7828,8087,8094,8193,8338,40287,40292,40294,40391,40393,40538,45326,45328],
 [7812,7814,7817,7818,7821,7827,7828,7830,7834,7855,7869,7871,7875,7948,7950,7954,8058,8059,8087,
   8094,8193,8364,8391,8395,8442,40055,40058,40059,40062,40068,40069,40071,40075,40137,40138,
   40141,40147,40148,40150,40154,40249,40252,40258,40259,40261,40265,40287,40293,40294,40296,40300,
   40392,40393,40395,40399,40564,40566,40570,40591,40595,40642,40957,40958,40961,40967,40968,40970,
   40974,41069,41072,41078,41079,41081,41085,41107,41113,41114,41116,41120,41212,41213,41215,41219,
   41384,41386,41390,41411,41415,41462,42590,42593,42599,42600,42602,42606,42628,42634,42635,42637,
   42641,42733,42734,42736,42740,42905,42907,42911,42932,42936,42983,44627,44633,44634,44636,44640,
   44732,44733,44735,44739,44904,44906,44910,44931,44935,44982,45327,45328,45330,45334,45499,45501,
   45505,45526,45530,45577,47084,47086,47090,47111,47115,47162,49471,49475,49522,49822],
 [7828,40287],[7818,7821,7822,7828,7829,8087,8094,8193,8224,8225,8390,40287,40288,40294,40295,
   40387,40393,40394,40424,40425,40590,45322,45328,45329,45359,45360,45525,46944,46945,47110,47575]
  ,[7812,7814,7817,7818,7821,7827,7828,7830,7834,7855,7869,7871,7875,7948,7950,7954,8058,8059,
   8087,8094,8193,8364,8391,8395,8442,40055,40058,40059,40062,40068,40069,40071,40075,40137,40138,
   40141,40147,40148,40150,40154,40249,40252,40258,40259,40261,40265,40287,40293,40294,40296,40300,
   40392,40393,40395,40399,40564,40566,40570,40591,40595,40642,40957,40958,40961,40967,40968,40970,
   40974,41069,41072,41078,41079,41081,41085,41107,41113,41114,41116,41120,41212,41213,41215,41219,
   41384,41386,41390,41411,41415,41462,42590,42593,42599,42600,42602,42606,42628,42634,42635,42637,
   42641,42733,42734,42736,42740,42905,42907,42911,42932,42936,42983,44627,44633,44634,44636,44640,
   44732,44733,44735,44739,44904,44906,44910,44931,44935,44982,45327,45328,45330,45334,45499,45501,
   45505,45526,45530,45577,47084,47086,47090,47111,47115,47162,49471,49475,49522,49822],
 [7818,7821,7825,7828,7831,8087,8094,8193,8311,8314,8392,40287,40291,40294,40297,40390,40393,
   40396,40511,40514,40592,45325,45328,45331,48796],
 [7813,7818,7821,7828,7832,7909,7913,8087,8094,8193,8393,40099,40102,40109,40113,40287,40294,
   40298,40393,40397,40593,41887,41894,41898,41993,41997,42193,45328,45332,45528,47113],
 [7818,7821,7828,7833,7836,8087,8094,8193,8394,8397,8507,40287,40294,40299,40302,40393,40398,
   40401,40594,40597,40707,45328,45333,45336,45642,47227,49887],
 [7812,7814,7817,7818,7821,7827,7828,7830,7834,7855,7869,7871,7875,7948,7950,7954,8058,8059,8087,
   8094,8193,8364,8391,8395,8442,40055,40058,40059,40062,40068,40069,40071,40075,40137,40138,
   40141,40147,40148,40150,40154,40249,40252,40258,40259,40261,40265,40287,40293,40294,40296,40300,
   40392,40393,40395,40399,40564,40566,40570,40591,40595,40642,40957,40958,40961,40967,40968,40970,
   40974,41069,41072,41078,41079,41081,41085,41107,41113,41114,41116,41120,41212,41213,41215,41219,
   41384,41386,41390,41411,41415,41462,42590,42593,42599,42600,42602,42606,42628,42634,42635,42637,
   42641,42733,42734,42736,42740,42905,42907,42911,42932,42936,42983,44627,44633,44634,44636,44640,
   44732,44733,44735,44739,44904,44906,44910,44931,44935,44982,45327,45328,45330,45334,45499,45501,
   45505,45526,45530,45577,47084,47086,47090,47111,47115,47162,49471,49475,49522,49822],
 [7815,7818,7820,7821,7828,7835,7838,7986,7996,8087,8094,8161,8168,8193,8396,8399,40176,40178,
   40179,40186,40193,40196,40286,40287,40294,40301,40304,40354,40361,40368,40371,40393,40400,40403,
   40596,40599,40746,43330,43331,43348,43398,43415,43444,43447,43643,43790,45289,45306,45328,45335,
   45338,45681,46620,47266],[7818,7821,7828,7833,7836,8087,8094,8193,8394,8397,8507,40287,40294,
   40299,40302,40393,40398,40401,40594,40597,40707,45328,45333,45336,45642,47227,49887],
 [7816,7818,7821,7828,7837,8023,8032,8087,8094,8193,8398,40213,40216,40223,40232,40287,40294,
   40303,40393,40402,40598,43997,44308,45328,45337],
 [7815,7818,7820,7821,7828,7835,7838,7986,7996,8087,8094,8161,8168,8193,8396,8399,40176,40178,
   40179,40186,40193,40196,40286,40287,40294,40301,40304,40354,40361,40368,40371,40393,40400,40403,
   40596,40599,40746,43330,43331,43348,43398,43415,43444,43447,43643,43790,45289,45306,45328,45335,
   45338,45681,46620,47266],[7818,7821,7828,7839,7840,7841,8087,8094,8193,8400,8401,8402,8624,
   40287,40294,40305,40306,40307,40393,40404,40405,40406,40600,40601,40602,40810,40811,40824,45328,
   45339,45340,45341,45745,45746,45759,47330,47331,47344,50004,51940],
 [7818,7821,7828,7839,7840,7841,8087,8094,8193,8400,8401,8402,8624,40287,40294,40305,40306,40307,
   40393,40404,40405,40406,40600,40601,40602,40810,40811,40824,45328,45339,45340,45341,45745,45746,
   45759,47330,47331,47344,50004,51940],[7818,7821,7828,7839,7840,7841,8087,8094,8193,8400,8401,
   8402,8624,40287,40294,40305,40306,40307,40393,40404,40405,40406,40600,40601,40602,40810,40811,
   40824,45328,45339,45340,45341,45745,45746,45759,47330,47331,47344,50004,51940],
 [7818,7821,7828,7842,8087,8094,8193,8403,40287,40294,40308,40393,40407,40603,45328,45342],
 [7818,7821,7828,7843,7850,8087,8094,8193,8404,8411,8666,40287,40294,40309,40316,40393,40408,
   40415,40604,40611,40866,45328,45343,45350,50046],
 [7818,7821,7828,7844,7845,7846,8087,8094,8193,8405,8406,8407,8670,40287,40294,40310,40311,40312,
   40393,40409,40410,40411,40605,40606,40607,40870,40871,40879,45328,45344,45345,45346,45805,45806,
   45814,47390,47391,47399,50050,52275],[7818,7821,7828,7844,7845,7846,8087,8094,8193,8405,8406,
   8407,8670,40287,40294,40310,40311,40312,40393,40409,40410,40411,40605,40606,40607,40870,40871,
   40879,45328,45344,45345,45346,45805,45806,45814,47390,47391,47399,50050,52275],
 [7818,7821,7828,7844,7845,7846,8087,8094,8193,8405,8406,8407,8670,40287,40294,40310,40311,40312,
   40393,40409,40410,40411,40605,40606,40607,40870,40871,40879,45328,45344,45345,45346,45805,45806,
   45814,47390,47391,47399,50050,52275],[7818,7821,7828,7847,7849,8087,8094,8193,8408,8410,8695,
   40287,40294,40313,40315,40393,40412,40414,40608,40610,40895,45328,45347,45349,50075],
 [7818,7821,7828,7848,8087,8094,8193,8409,40287,40294,40314,40393,40413,40609,45328,45348],
 [7818,7821,7828,7847,7849,8087,8094,8193,8408,8410,8695,40287,40294,40313,40315,40393,40412,
   40414,40608,40610,40895,45328,45347,45349,50075],
 [7818,7821,7828,7843,7850,8087,8094,8193,8404,8411,8666,40287,40294,40309,40316,40393,40408,
   40415,40604,40611,40866,45328,45343,45350,50046],
 [7818,7821,7828,7851,7852,7853,8087,8094,8193,8412,8413,8414,8714,40287,40294,40317,40318,40319,
   40393,40416,40417,40418,40612,40613,40614,40912,40913,40914,45328,45351,45352,45353,45847,45848,
   45849,47432,47433,47434,50094,52394],[7818,7821,7828,7851,7852,7853,8087,8094,8193,8412,8413,
   8414,8714,40287,40294,40317,40318,40319,40393,40416,40417,40418,40612,40613,40614,40912,40913,
   40914,45328,45351,45352,45353,45847,45848,45849,47432,47433,47434,50094,52394],
 [7818,7821,7828,7851,7852,7853,8087,8094,8193,8412,8413,8414,8714,40287,40294,40317,40318,40319,
   40393,40416,40417,40418,40612,40613,40614,40912,40913,40914,45328,45351,45352,45353,45847,45848,
   45849,47432,47433,47434,50094,52394],[8032,8168,44030,46241],
 [7725,7726,7743,7769,7786,7818,7819,7821,7828,8087,8094,8128,8193,38205,38212,38213,38215,38222,
   38254,38255,38257,38264,38521,38523,38557,39157,39158,39160,39167,39424,39426,39460,40285,40287,
   40294,40321,40328,40393,45256,45328],[7819,7822,7828,7829,8128,8224,8225,8390,40328,40424,
   40425,40590,45920,45921,46086,47575],[7819,7823,7824,7828,8128,8250,8254,8283,40323,40324,
   40328,40450,40454,40483,45946,47903],[7819,7823,7824,7828,8128,8250,8254,8283,40323,40324,
   40328,40450,40454,40483,45946,47903],[],[],
 [7813,7817,7819,7827,7828,7832,7909,7913,8058,8059,8128,8364,8393,40109,40113,40258,40259,40328,
   40564,40593,41850,41858,41859,41863,41927,41928,41932,42164,42168,42193,44667,44668,44672,44904,
   44908,44933,46060,46064,46089,49473],[7828],
 [7819,7822,7828,7829,8128,8224,8225,8390,40328,40424,40425,40590,45920,45921,46086,47575],
 [7950,42671],[],[7813,7817,7819,7827,7828,7832,7909,7913,8058,8059,8128,8364,8393,40109,
   40113,40258,40259,40328,40564,40593,41850,41858,41859,41863,41927,41928,41932,42164,42168,42193,
   44667,44668,44672,44904,44908,44933,46060,46064,46089,49473],[8507,46203],[7875,41154],
 [8032,8168,44030,46241],[8507,46203],[8032,8168,44030,46241],[7996,43382],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],
 [7815,7818,7820,7821,7828,7835,7838,7986,7996,8087,8094,8161,8168,8193,8396,8399,40176,40178,
   40179,40186,40193,40196,40286,40287,40294,40301,40304,40354,40361,40368,40371,40393,40400,40403,
   40596,40599,40746,43330,43331,43348,43398,43415,43444,43447,43643,43790,45289,45306,45328,45335,
   45338,45681,46620,47266],[7820,7822,7828,7829,7835,8161,8168,8224,8225,8390,8396,40361,40368,
   40424,40425,40590,40596,46448,46449,46614,46620,47575,47581,47605,49800],
 [7820,7823,7824,7828,7835,8161,8168,8250,8254,8283,8396,40356,40357,40361,40368,40450,40454,
   40461,40483,40490,40596,46474,46620,47903,47910],
 [7820,7823,7824,7828,7835,8161,8168,8250,8254,8283,8396,40356,40357,40361,40368,40450,40454,
   40461,40483,40490,40596,46474,46620,47903,47910],[8168],[8168],
 [7817,7820,7827,7828,7833,7835,7836,8058,8059,8161,8168,8364,8394,8396,8397,8507,40258,40259,
   40361,40368,40564,40594,40596,40597,40707,44700,44701,44706,44904,44909,44911,44912,44934,44936,
   44937,45046,45047,45084,46588,46593,46596,46618,46620,46621,46731,49474,49476,49477,49587,49624,
   49886,49887,49924,51084],[7828,8168],
 [7820,7822,7828,7829,7835,8161,8168,8224,8225,8390,8396,40361,40368,40424,40425,40590,40596,
   46448,46449,46614,46620,47575,47581,47605,49800],[7950,8168,42704,42984],[8168],
 [7813,7820,7828,7832,7835,7909,7913,8161,8168,8393,8396,40109,40113,40361,40368,40593,40596,
   41961,41965,42193,42196,42286,46617,46620,49866],
 [7817,7820,7827,7828,7833,7835,7836,8058,8059,8161,8168,8364,8394,8396,8397,8507,40258,40259,
   40361,40368,40564,40594,40596,40597,40707,44700,44701,44706,44904,44909,44911,44912,44934,44936,
   44937,45046,45047,45084,46588,46593,46596,46618,46620,46621,46731,49474,49476,49477,49587,49624,
   49886,49887,49924,51084],[7875,8168,41187,41545],[],
 [7817,7820,7827,7828,7833,7835,7836,8058,8059,8161,8168,8364,8394,8396,8397,8507,40258,40259,
   40361,40368,40564,40594,40596,40597,40707,44700,44701,44706,44904,44909,44911,44912,44934,44936,
   44937,45046,45047,45084,46588,46593,46596,46618,46620,46621,46731,49474,49476,49477,49587,49624,
   49886,49887,49924,51084],[8032,8168,44030,46241],
 [7815,7818,7820,7821,7828,7835,7838,7986,7996,8087,8094,8161,8168,8193,8396,8399,40176,40178,
   40179,40186,40193,40196,40286,40287,40294,40301,40304,40354,40361,40368,40371,40393,40400,40403,
   40596,40599,40746,43330,43331,43348,43398,43415,43444,43447,43643,43790,45289,45306,45328,45335,
   45338,45681,46620,47266],[8168],[8168],[8168],[8168],[8168],[8168],[8168],[8168],
 [8168],[8168],[8168],[8168],[8168],[8168],[8168],
 [7818,7821,7822,7828,7829,8087,8094,8193,8224,8225,8390,40287,40288,40294,40295,40387,40393,
   40394,40424,40425,40590,45322,45328,45329,45359,45360,45525,46944,46945,47110,47575],
 [7818,7821,7823,7824,7828,8087,8094,8193,8250,8254,8283,40287,40289,40290,40294,40388,40389,
   40393,40450,40454,40483,45323,45324,45328,45385,46970,47903],
 [7818,7821,7823,7824,7828,8087,8094,8193,8250,8254,8283,40287,40289,40290,40294,40388,40389,
   40393,40450,40454,40483,45323,45324,45328,45385,46970,47903],
 [7818,7821,7825,7828,7831,8087,8094,8193,8311,8314,8392,40287,40291,40294,40297,40390,40393,
   40396,40511,40514,40592,45325,45328,45331,48796],
 [7818,7821,7826,7828,8087,8094,8193,8338,40287,40292,40294,40391,40393,40538,45326,45328],
 [7812,7814,7817,7818,7821,7827,7828,7830,7834,7855,7869,7871,7875,7948,7950,7954,8058,8059,8087,
   8094,8193,8364,8391,8395,8442,40055,40058,40059,40062,40068,40069,40071,40075,40137,40138,
   40141,40147,40148,40150,40154,40249,40252,40258,40259,40261,40265,40287,40293,40294,40296,40300,
   40392,40393,40395,40399,40564,40566,40570,40591,40595,40642,40957,40958,40961,40967,40968,40970,
   40974,41069,41072,41078,41079,41081,41085,41107,41113,41114,41116,41120,41212,41213,41215,41219,
   41384,41386,41390,41411,41415,41462,42590,42593,42599,42600,42602,42606,42628,42634,42635,42637,
   42641,42733,42734,42736,42740,42905,42907,42911,42932,42936,42983,44627,44633,44634,44636,44640,
   44732,44733,44735,44739,44904,44906,44910,44931,44935,44982,45327,45328,45330,45334,45499,45501,
   45505,45526,45530,45577,47084,47086,47090,47111,47115,47162,49471,49475,49522,49822],
 [7828,40287],[7818,7821,7822,7828,7829,8087,8094,8193,8224,8225,8390,40287,40288,40294,40295,
   40387,40393,40394,40424,40425,40590,45322,45328,45329,45359,45360,45525,46944,46945,47110,47575]
  ,[7812,7814,7817,7818,7821,7827,7828,7830,7834,7855,7869,7871,7875,7948,7950,7954,8058,8059,
   8087,8094,8193,8364,8391,8395,8442,40055,40058,40059,40062,40068,40069,40071,40075,40137,40138,
   40141,40147,40148,40150,40154,40249,40252,40258,40259,40261,40265,40287,40293,40294,40296,40300,
   40392,40393,40395,40399,40564,40566,40570,40591,40595,40642,40957,40958,40961,40967,40968,40970,
   40974,41069,41072,41078,41079,41081,41085,41107,41113,41114,41116,41120,41212,41213,41215,41219,
   41384,41386,41390,41411,41415,41462,42590,42593,42599,42600,42602,42606,42628,42634,42635,42637,
   42641,42733,42734,42736,42740,42905,42907,42911,42932,42936,42983,44627,44633,44634,44636,44640,
   44732,44733,44735,44739,44904,44906,44910,44931,44935,44982,45327,45328,45330,45334,45499,45501,
   45505,45526,45530,45577,47084,47086,47090,47111,47115,47162,49471,49475,49522,49822],
 [7818,7821,7825,7828,7831,8087,8094,8193,8311,8314,8392,40287,40291,40294,40297,40390,40393,
   40396,40511,40514,40592,45325,45328,45331,48796],
 [7813,7818,7821,7828,7832,7909,7913,8087,8094,8193,8393,40099,40102,40109,40113,40287,40294,
   40298,40393,40397,40593,41887,41894,41898,41993,41997,42193,45328,45332,45528,47113],
 [7818,7821,7828,7833,7836,8087,8094,8193,8394,8397,8507,40287,40294,40299,40302,40393,40398,
   40401,40594,40597,40707,45328,45333,45336,45642,47227,49887],
 [7812,7814,7817,7818,7821,7827,7828,7830,7834,7855,7869,7871,7875,7948,7950,7954,8058,8059,8087,
   8094,8193,8364,8391,8395,8442,40055,40058,40059,40062,40068,40069,40071,40075,40137,40138,
   40141,40147,40148,40150,40154,40249,40252,40258,40259,40261,40265,40287,40293,40294,40296,40300,
   40392,40393,40395,40399,40564,40566,40570,40591,40595,40642,40957,40958,40961,40967,40968,40970,
   40974,41069,41072,41078,41079,41081,41085,41107,41113,41114,41116,41120,41212,41213,41215,41219,
   41384,41386,41390,41411,41415,41462,42590,42593,42599,42600,42602,42606,42628,42634,42635,42637,
   42641,42733,42734,42736,42740,42905,42907,42911,42932,42936,42983,44627,44633,44634,44636,44640,
   44732,44733,44735,44739,44904,44906,44910,44931,44935,44982,45327,45328,45330,45334,45499,45501,
   45505,45526,45530,45577,47084,47086,47090,47111,47115,47162,49471,49475,49522,49822],
 [7815,7818,7820,7821,7828,7835,7838,7986,7996,8087,8094,8161,8168,8193,8396,8399,40176,40178,
   40179,40186,40193,40196,40286,40287,40294,40301,40304,40354,40361,40368,40371,40393,40400,40403,
   40596,40599,40746,43330,43331,43348,43398,43415,43444,43447,43643,43790,45289,45306,45328,45335,
   45338,45681,46620,47266],[7818,7821,7828,7833,7836,8087,8094,8193,8394,8397,8507,40287,40294,
   40299,40302,40393,40398,40401,40594,40597,40707,45328,45333,45336,45642,47227,49887],
 [7816,7818,7821,7828,7837,8023,8032,8087,8094,8193,8398,40213,40216,40223,40232,40287,40294,
   40303,40393,40402,40598,43997,44308,45328,45337],
 [7815,7818,7820,7821,7828,7835,7838,7986,7996,8087,8094,8161,8168,8193,8396,8399,40176,40178,
   40179,40186,40193,40196,40286,40287,40294,40301,40304,40354,40361,40368,40371,40393,40400,40403,
   40596,40599,40746,43330,43331,43348,43398,43415,43444,43447,43643,43790,45289,45306,45328,45335,
   45338,45681,46620,47266],[7818,7821,7828,7839,7840,7841,8087,8094,8193,8400,8401,8402,8624,
   40287,40294,40305,40306,40307,40393,40404,40405,40406,40600,40601,40602,40810,40811,40824,45328,
   45339,45340,45341,45745,45746,45759,47330,47331,47344,50004,51940],
 [7818,7821,7828,7839,7840,7841,8087,8094,8193,8400,8401,8402,8624,40287,40294,40305,40306,40307,
   40393,40404,40405,40406,40600,40601,40602,40810,40811,40824,45328,45339,45340,45341,45745,45746,
   45759,47330,47331,47344,50004,51940],[7818,7821,7828,7839,7840,7841,8087,8094,8193,8400,8401,
   8402,8624,40287,40294,40305,40306,40307,40393,40404,40405,40406,40600,40601,40602,40810,40811,
   40824,45328,45339,45340,45341,45745,45746,45759,47330,47331,47344,50004,51940],
 [7818,7821,7828,7842,8087,8094,8193,8403,40287,40294,40308,40393,40407,40603,45328,45342],
 [7818,7821,7828,7843,7850,8087,8094,8193,8404,8411,8666,40287,40294,40309,40316,40393,40408,
   40415,40604,40611,40866,45328,45343,45350,50046],
 [7818,7821,7828,7844,7845,7846,8087,8094,8193,8405,8406,8407,8670,40287,40294,40310,40311,40312,
   40393,40409,40410,40411,40605,40606,40607,40870,40871,40879,45328,45344,45345,45346,45805,45806,
   45814,47390,47391,47399,50050,52275],[7818,7821,7828,7844,7845,7846,8087,8094,8193,8405,8406,
   8407,8670,40287,40294,40310,40311,40312,40393,40409,40410,40411,40605,40606,40607,40870,40871,
   40879,45328,45344,45345,45346,45805,45806,45814,47390,47391,47399,50050,52275],
 [7818,7821,7828,7844,7845,7846,8087,8094,8193,8405,8406,8407,8670,40287,40294,40310,40311,40312,
   40393,40409,40410,40411,40605,40606,40607,40870,40871,40879,45328,45344,45345,45346,45805,45806,
   45814,47390,47391,47399,50050,52275],[7818,7821,7828,7847,7849,8087,8094,8193,8408,8410,8695,
   40287,40294,40313,40315,40393,40412,40414,40608,40610,40895,45328,45347,45349,50075],
 [7818,7821,7828,7848,8087,8094,8193,8409,40287,40294,40314,40393,40413,40609,45328,45348],
 [7818,7821,7828,7847,7849,8087,8094,8193,8408,8410,8695,40287,40294,40313,40315,40393,40412,
   40414,40608,40610,40895,45328,45347,45349,50075],
 [7818,7821,7828,7843,7850,8087,8094,8193,8404,8411,8666,40287,40294,40309,40316,40393,40408,
   40415,40604,40611,40866,45328,45343,45350,50046],
 [7818,7821,7828,7851,7852,7853,8087,8094,8193,8412,8413,8414,8714,40287,40294,40317,40318,40319,
   40393,40416,40417,40418,40612,40613,40614,40912,40913,40914,45328,45351,45352,45353,45847,45848,
   45849,47432,47433,47434,50094,52394],[7818,7821,7828,7851,7852,7853,8087,8094,8193,8412,8413,
   8414,8714,40287,40294,40317,40318,40319,40393,40416,40417,40418,40612,40613,40614,40912,40913,
   40914,45328,45351,45352,45353,45847,45848,45849,47432,47433,47434,50094,52394],
 [7818,7821,7828,7851,7852,7853,8087,8094,8193,8412,8413,8414,8714,40287,40294,40317,40318,40319,
   40393,40416,40417,40418,40612,40613,40614,40912,40913,40914,45328,45351,45352,45353,45847,45848,
   45849,47432,47433,47434,50094,52394],[7812,7814,7822,7823,7824,7828,7829,7830,7834,7855,7869,
   7871,7875,7948,7950,7954,8224,8225,8250,8254,8283,8390,8391,8395,8442,40055,40063,40064,40065,
   40069,40070,40071,40075,40142,40143,40144,40148,40149,40150,40154,40419,40420,40424,40425,40426,
   40430,40450,40454,40455,40456,40460,40483,40484,40485,40489,40590,40591,40595,40615,40619,40642,
   40962,40963,40964,40968,40969,40970,40974,41239,41240,41244,41245,41246,41250,41270,41274,41275,
   41276,41280,41303,41304,41305,41309,41410,41411,41415,41435,41439,41462,42760,42761,42765,42766,
   42767,42771,42791,42795,42796,42797,42801,42824,42825,42826,42830,42931,42932,42936,42956,42960,
   42983,47435,47439,47440,47441,47445,47468,47469,47470,47474,47575,47576,47580,47600,47604,47627,
   47903,47904,47905,47909,48010,48011,48015,48035,48039,48062,48416,48417,48421,48441,48445,48468,
   49795,49799,49822,50098],[7812,7814,7822,7823,7824,7828,7829,7830,7834,7855,7869,7871,7875,
   7948,7950,7954,8224,8225,8250,8254,8283,8390,8391,8395,8442,40055,40063,40064,40065,40069,
   40070,40071,40075,40142,40143,40144,40148,40149,40150,40154,40419,40420,40424,40425,40426,40430,
   40450,40454,40455,40456,40460,40483,40484,40485,40489,40590,40591,40595,40615,40619,40642,40962,
   40963,40964,40968,40969,40970,40974,41239,41240,41244,41245,41246,41250,41270,41274,41275,41276,
   41280,41303,41304,41305,41309,41410,41411,41415,41435,41439,41462,42760,42761,42765,42766,42767,
   42771,42791,42795,42796,42797,42801,42824,42825,42826,42830,42931,42932,42936,42956,42960,42983,
   47435,47439,47440,47441,47445,47468,47469,47470,47474,47575,47576,47580,47600,47604,47627,47903,
   47904,47905,47909,48010,48011,48015,48035,48039,48062,48416,48417,48421,48441,48445,48468,49795,
   49799,49822,50098],[7822,7825,7828,7829,7831,8224,8225,8311,8314,8390,8392,40424,40425,40511,
   40514,40590,40592,47496,47497,47499,47575,47577,47601,48794,48796,48820,49796],
 [7822,7826,7828,7829,8224,8225,8338,8390,40424,40425,40538,40590,47523,47524,47575,49145],
 [7817,7822,7827,7828,7829,8058,8059,8224,8225,8364,8390,40258,40259,40424,40425,40564,40590,
   44763,44764,44765,44904,44905,44930,47549,47550,47575,49470],[7828,47575],[7828,47575],
 [7812,7814,7822,7823,7824,7828,7829,7830,7834,7855,7869,7871,7875,7948,7950,7954,8224,8225,8250,
   8254,8283,8390,8391,8395,8442,40055,40063,40064,40065,40069,40070,40071,40075,40142,40143,
   40144,40148,40149,40150,40154,40419,40420,40424,40425,40426,40430,40450,40454,40455,40456,40460,
   40483,40484,40485,40489,40590,40591,40595,40615,40619,40642,40962,40963,40964,40968,40969,40970,
   40974,41239,41240,41244,41245,41246,41250,41270,41274,41275,41276,41280,41303,41304,41305,41309,
   41410,41411,41415,41435,41439,41462,42760,42761,42765,42766,42767,42771,42791,42795,42796,42797,
   42801,42824,42825,42826,42830,42931,42932,42936,42956,42960,42983,47435,47439,47440,47441,47445,
   47468,47469,47470,47474,47575,47576,47580,47600,47604,47627,47903,47904,47905,47909,48010,48011,
   48015,48035,48039,48062,48416,48417,48421,48441,48445,48468,49795,49799,49822,50098],
 [7822,7825,7828,7829,7831,8224,8225,8311,8314,8390,8392,40424,40425,40511,40514,40590,40592,
   47496,47497,47499,47575,47577,47601,48794,48796,48820,49796],
 [7813,7822,7828,7829,7832,7909,7913,8224,8225,8390,8393,40109,40113,40424,40425,40590,40593,
   42024,42025,42028,42190,42193,42217,47575,47578,47602,49797],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,3501,3507,3510,3512,3517,
   3518,3519,3523,3525,3526,3544,3550,3560,3561,3592,3602,3603,3826,3828,3833,3834,3835,3839,
   3841,3842,3930,3935,3936,3937,3941,3998,3999,4000,4004,4139,4140,4144,4146,4147,4165,4169,
   4171,4172,4193,4195,4196,4281,4282,4319,4510,4511,4512,4518,4528,4529,5645,5646,5652,5662,
   5663,5689,5695,5698,5700,5705,5706,5707,5711,5713,5714,5737,5747,5748,5971,5973,5978,5979,
   5980,5984,5986,5987,6075,6080,6081,6086,6089,6143,6144,6145,6149,6151,6152,6284,6285,6289,
   6291,6292,6310,6314,6316,6317,6340,6341,6427,6464,7725,7726,7732,7742,7743,7769,7775,7785,
   7786,7817,7820,7822,7827,7828,7829,7833,7835,7836,8051,8053,8058,8059,8060,8064,8066,8067,
   8155,8160,8161,8162,8166,8168,8169,8223,8224,8225,8231,8364,8365,8369,8371,8372,8390,8394,
   8396,8397,8420,8506,8507,8544,38205,38211,38221,38222,38253,38263,38264,38487,38489,38494,
   38495,38496,38500,38502,38503,38591,38800,38854,38980,39156,39166,39167,39397,39398,39499,39505,
   39562,39571,39703,39704,39708,39710,39711,39759,40258,40259,40361,40368,40424,40425,40564,40590,
   40594,40596,40597,40707,44695,44700,44701,44702,44706,44708,44709,44763,44764,44765,44769,44771,
   44772,44904,44905,44909,44911,44912,44930,44934,44936,44937,44958,44960,44961,45046,45047,45084,
   46447,46448,46449,46453,46455,46456,46588,46589,46593,46595,46596,46614,46618,46620,46621,46642,
   46644,46645,46730,46731,46768,47549,47550,47554,47556,47557,47575,47579,47581,47582,47603,47605,
   47606,47691,47692,47729,49470,49474,49476,49477,49498,49500,49501,49586,49587,49624,49798,49800,
   49801,49886,49887,49924,50162,50163,50200,51084],
 [7812,7814,7822,7823,7824,7828,7829,7830,7834,7855,7869,7871,7875,7948,7950,7954,8224,8225,8250,
   8254,8283,8390,8391,8395,8442,40055,40063,40064,40065,40069,40070,40071,40075,40142,40143,
   40144,40148,40149,40150,40154,40419,40420,40424,40425,40426,40430,40450,40454,40455,40456,40460,
   40483,40484,40485,40489,40590,40591,40595,40615,40619,40642,40962,40963,40964,40968,40969,40970,
   40974,41239,41240,41244,41245,41246,41250,41270,41274,41275,41276,41280,41303,41304,41305,41309,
   41410,41411,41415,41435,41439,41462,42760,42761,42765,42766,42767,42771,42791,42795,42796,42797,
   42801,42824,42825,42826,42830,42931,42932,42936,42956,42960,42983,47435,47439,47440,47441,47445,
   47468,47469,47470,47474,47575,47576,47580,47600,47604,47627,47903,47904,47905,47909,48010,48011,
   48015,48035,48039,48062,48416,48417,48421,48441,48445,48468,49795,49799,49822,50098],
 [7820,7822,7828,7829,7835,8161,8168,8224,8225,8390,8396,40361,40368,40424,40425,40590,40596,
   46448,46449,46614,46620,47575,47581,47605,49800],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,3501,3507,3510,3512,3517,
   3518,3519,3523,3525,3526,3544,3550,3560,3561,3592,3602,3603,3826,3828,3833,3834,3835,3839,
   3841,3842,3930,3935,3936,3937,3941,3998,3999,4000,4004,4139,4140,4144,4146,4147,4165,4169,
   4171,4172,4193,4195,4196,4281,4282,4319,4510,4511,4512,4518,4528,4529,5645,5646,5652,5662,
   5663,5689,5695,5698,5700,5705,5706,5707,5711,5713,5714,5737,5747,5748,5971,5973,5978,5979,
   5980,5984,5986,5987,6075,6080,6081,6086,6089,6143,6144,6145,6149,6151,6152,6284,6285,6289,
   6291,6292,6310,6314,6316,6317,6340,6341,6427,6464,7725,7726,7732,7742,7743,7769,7775,7785,
   7786,7817,7820,7822,7827,7828,7829,7833,7835,7836,8051,8053,8058,8059,8060,8064,8066,8067,
   8155,8160,8161,8162,8166,8168,8169,8223,8224,8225,8231,8364,8365,8369,8371,8372,8390,8394,
   8396,8397,8420,8506,8507,8544,38205,38211,38221,38222,38253,38263,38264,38487,38489,38494,
   38495,38496,38500,38502,38503,38591,38800,38854,38980,39156,39166,39167,39397,39398,39499,39505,
   39562,39571,39703,39704,39708,39710,39711,39759,40258,40259,40361,40368,40424,40425,40564,40590,
   40594,40596,40597,40707,44695,44700,44701,44702,44706,44708,44709,44763,44764,44765,44769,44771,
   44772,44904,44905,44909,44911,44912,44930,44934,44936,44937,44958,44960,44961,45046,45047,45084,
   46447,46448,46449,46453,46455,46456,46588,46589,46593,46595,46596,46614,46618,46620,46621,46642,
   46644,46645,46730,46731,46768,47549,47550,47554,47556,47557,47575,47579,47581,47582,47603,47605,
   47606,47691,47692,47729,49470,49474,49476,49477,49498,49500,49501,49586,49587,49624,49798,49800,
   49801,49886,49887,49924,50162,50163,50200,51084],
 [7816,7822,7828,7829,7837,8023,8032,8224,8225,8390,8398,40223,40232,40424,40425,40590,40598,
   44134,44135,44300,44308,47575,47583,47607,49802],
 [7815,7822,7828,7829,7838,7986,7996,8224,8225,8390,8399,40186,40196,40424,40425,40590,40599,
   43468,43469,43478,43634,43643,43667,47575,47584,47608,49803],
 [7822,7828,7829,7839,8224,8225,8390,8400,40424,40425,40590,40600,47575,47585,47609,49804],
 [7822,7828,7829,7840,7841,8224,8225,8390,8401,8402,8624,40424,40425,40590,40601,40602,40824,
   47575,47586,47587,47610,47611,49805,49806,50004],
 [7822,7828,7829,7840,7841,8224,8225,8390,8401,8402,8624,40424,40425,40590,40601,40602,40824,
   47575,47586,47587,47610,47611,49805,49806,50004],
 [7822,7828,7829,7842,8224,8225,8390,8403,40424,40425,40590,40603,47575,47588,47612,49807],
 [7822,7828,7829,7843,7850,8224,8225,8390,8404,8411,8666,40424,40425,40590,40604,40611,40866,
   47575,47589,47596,47613,47620,47851,49808,49815,50046,50322],
 [7822,7828,7829,7844,7845,8224,8225,8390,8405,8406,8670,40424,40425,40590,40605,40606,40870,
   47575,47590,47591,47614,47615,49809,49810,50050],
 [7822,7828,7829,7844,7845,8224,8225,8390,8405,8406,8670,40424,40425,40590,40605,40606,40870,
   47575,47590,47591,47614,47615,49809,49810,50050],
 [7822,7828,7829,7846,8224,8225,8390,8407,40424,40425,40590,40607,47575,47592,47616,49811],
 [7822,7828,7829,7847,7849,8224,8225,8390,8408,8410,8695,40424,40425,40590,40608,40610,40895,
   47575,47593,47595,47617,47619,47880,49812,49814,50075,50351],
 [7822,7828,7829,7848,8224,8225,8390,8409,40424,40425,40590,40609,47575,47594,47618,49813],
 [7822,7828,7829,7847,7849,8224,8225,8390,8408,8410,8695,40424,40425,40590,40608,40610,40895,
   47575,47593,47595,47617,47619,47880,49812,49814,50075,50351],
 [7822,7828,7829,7843,7850,8224,8225,8390,8404,8411,8666,40424,40425,40590,40604,40611,40866,
   47575,47589,47596,47613,47620,47851,49808,49815,50046,50322],
 [7822,7828,7829,7851,8224,8225,8390,8412,40424,40425,40590,40612,47575,47597,47621,49816],
 [7822,7828,7829,7852,7853,8224,8225,8390,8413,8414,8714,40424,40425,40590,40613,40614,40914,
   47575,47598,47599,47622,47623,49817,49818,50094],
 [7822,7828,7829,7852,7853,8224,8225,8390,8413,8414,8714,40424,40425,40590,40613,40614,40914,
   47575,47598,47599,47622,47623,49817,49818,50094],[7828,40450],
 [7823,7824,7825,7828,7831,8250,8254,8283,8311,8314,8392,40450,40451,40454,40457,40480,40483,
   40486,40511,40514,40592,47900,47903,47906,48796],
 [7823,7824,7826,7828,8250,8254,8283,8338,40450,40452,40454,40481,40483,40538,47901,47903],
 [7817,7823,7824,7827,7828,8058,8059,8250,8254,8283,8364,40254,40255,40258,40259,40450,40453,
   40454,40482,40483,40564,44790,44793,44794,44822,44823,44904,47902,47903,47984,48390],
 [7828,40450],[7812,7814,7822,7823,7824,7828,7829,7830,7834,7855,7869,7871,7875,7948,7950,7954,
   8224,8225,8250,8254,8283,8390,8391,8395,8442,40055,40063,40064,40065,40069,40070,40071,40075,
   40142,40143,40144,40148,40149,40150,40154,40419,40420,40424,40425,40426,40430,40450,40454,40455,
   40456,40460,40483,40484,40485,40489,40590,40591,40595,40615,40619,40642,40962,40963,40964,40968,
   40969,40970,40974,41239,41240,41244,41245,41246,41250,41270,41274,41275,41276,41280,41303,41304,
   41305,41309,41410,41411,41415,41435,41439,41462,42760,42761,42765,42766,42767,42771,42791,42795,
   42796,42797,42801,42824,42825,42826,42830,42931,42932,42936,42956,42960,42983,47435,47439,47440,
   47441,47445,47468,47469,47470,47474,47575,47576,47580,47600,47604,47627,47903,47904,47905,47909,
   48010,48011,48015,48035,48039,48062,48416,48417,48421,48441,48445,48468,49795,49799,49822,50098]
  ,[7812,7814,7822,7823,7824,7828,7829,7830,7834,7855,7869,7871,7875,7948,7950,7954,8224,8225,
   8250,8254,8283,8390,8391,8395,8442,40055,40063,40064,40065,40069,40070,40071,40075,40142,40143,
   40144,40148,40149,40150,40154,40419,40420,40424,40425,40426,40430,40450,40454,40455,40456,40460,
   40483,40484,40485,40489,40590,40591,40595,40615,40619,40642,40962,40963,40964,40968,40969,40970,
   40974,41239,41240,41244,41245,41246,41250,41270,41274,41275,41276,41280,41303,41304,41305,41309,
   41410,41411,41415,41435,41439,41462,42760,42761,42765,42766,42767,42771,42791,42795,42796,42797,
   42801,42824,42825,42826,42830,42931,42932,42936,42956,42960,42983,47435,47439,47440,47441,47445,
   47468,47469,47470,47474,47575,47576,47580,47600,47604,47627,47903,47904,47905,47909,48010,48011,
   48015,48035,48039,48062,48416,48417,48421,48441,48445,48468,49795,49799,49822,50098],
 [7823,7824,7825,7828,7831,8250,8254,8283,8311,8314,8392,40450,40451,40454,40457,40480,40483,
   40486,40511,40514,40592,47900,47903,47906,48796],
 [7813,7823,7824,7828,7832,7909,7913,8250,8254,8283,8393,40104,40105,40109,40113,40450,40454,
   40458,40483,40487,40593,42050,42054,42058,42083,42087,42193,47903,47907,48013,48419],
 [7823,7824,7828,7833,7836,8250,8254,8283,8394,8397,8507,40450,40454,40459,40462,40483,40488,
   40491,40594,40597,40707,47903,47908,47911,48127,48533,49887],
 [7812,7814,7822,7823,7824,7828,7829,7830,7834,7855,7869,7871,7875,7948,7950,7954,8224,8225,8250,
   8254,8283,8390,8391,8395,8442,40055,40063,40064,40065,40069,40070,40071,40075,40142,40143,
   40144,40148,40149,40150,40154,40419,40420,40424,40425,40426,40430,40450,40454,40455,40456,40460,
   40483,40484,40485,40489,40590,40591,40595,40615,40619,40642,40962,40963,40964,40968,40969,40970,
   40974,41239,41240,41244,41245,41246,41250,41270,41274,41275,41276,41280,41303,41304,41305,41309,
   41410,41411,41415,41435,41439,41462,42760,42761,42765,42766,42767,42771,42791,42795,42796,42797,
   42801,42824,42825,42826,42830,42931,42932,42936,42956,42960,42983,47435,47439,47440,47441,47445,
   47468,47469,47470,47474,47575,47576,47580,47600,47604,47627,47903,47904,47905,47909,48010,48011,
   48015,48035,48039,48062,48416,48417,48421,48441,48445,48468,49795,49799,49822,50098],
 [7820,7823,7824,7828,7835,8161,8168,8250,8254,8283,8396,40356,40357,40361,40368,40450,40454,
   40461,40483,40490,40596,46474,46620,47903,47910],
 [7823,7824,7828,7833,7836,8250,8254,8283,8394,8397,8507,40450,40454,40459,40462,40483,40488,
   40491,40594,40597,40707,47903,47908,47911,48127,48533,49887],
 [7816,7823,7824,7828,7837,8023,8032,8250,8254,8283,8398,40218,40219,40223,40232,40450,40454,
   40463,40483,40492,40598,44160,44308,47903,47912],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,3501,3505,3506,3507,3513,
   3514,3517,3518,3527,3528,3544,3548,3549,3550,3556,3557,3560,3561,3570,3571,3590,3591,3592,
   3598,3599,3602,3603,3612,3613,3749,3750,3756,3757,3770,3771,3787,3793,3794,3829,3830,3833,
   3834,3843,3844,4025,4038,4039,4139,4354,4510,4511,4512,4518,4528,4529,5645,5646,5650,5651,
   5652,5658,5659,5662,5663,5672,5673,5689,5693,5694,5695,5701,5702,5705,5706,5715,5716,5735,
   5736,5737,5743,5744,5747,5748,5757,5758,5894,5902,5905,5916,5939,5942,5953,5978,5979,6170,
   6173,6183,6184,6202,6212,6213,6284,6293,6294,6499,7725,7726,7730,7731,7732,7738,7739,7742,
   7743,7752,7753,7769,7773,7774,7775,7781,7782,7785,7786,7795,7796,7815,7816,7817,7823,7824,
   7827,7828,7837,7838,7974,7986,7995,7996,8018,8019,8023,8032,8033,8058,8059,8250,8254,8263,
   8283,8292,8364,8398,8399,8579,38205,38209,38210,38211,38217,38218,38221,38222,38231,38232,
   38251,38252,38253,38259,38260,38263,38264,38273,38274,38410,38411,38417,38418,38431,38432,38448,
   38454,38455,38468,38469,38490,38491,38494,38495,38504,38505,38686,38699,38700,38728,38729,38800,
   39015,39154,39155,39156,39162,39163,39166,39167,39176,39177,39313,39320,39321,39324,39334,39335,
   39357,39358,39361,39371,39372,39397,39398,39589,39592,39602,39603,39621,39631,39632,39703,39712,
   39713,39918,40174,40181,40182,40186,40195,40196,40218,40219,40223,40232,40233,40258,40259,40450,
   40454,40463,40464,40483,40492,40493,40564,40598,40599,40779,43262,43263,43266,43276,43277,43298,
   43494,43507,43508,43536,43537,43643,43823,43965,44160,44173,44174,44202,44203,44308,44489,44904,
   45119,47903,47912,47913,47993,48199,48400,48605],
 [7823,7824,7828,7839,8250,8254,8283,8400,40450,40454,40465,40483,40494,40600,47903,47914],
 [7823,7824,7828,7840,7841,8250,8254,8283,8401,8402,8624,40450,40454,40466,40467,40483,40495,
   40496,40601,40602,40824,47903,47915,47916,48244,48650,50004],
 [7823,7824,7828,7840,7841,8250,8254,8283,8401,8402,8624,40450,40454,40466,40467,40483,40495,
   40496,40601,40602,40824,47903,47915,47916,48244,48650,50004],
 [7823,7824,7828,7842,8250,8254,8283,8403,40450,40454,40468,40483,40497,40603,47903,47917],
 [7823,7824,7828,7843,7850,8250,8254,8283,8404,8411,8666,40450,40454,40469,40476,40483,40498,
   40505,40604,40611,40866,47903,47918,47925,50046],
 [7823,7824,7828,7844,7845,8250,8254,8283,8405,8406,8670,40450,40454,40470,40471,40483,40499,
   40500,40605,40606,40870,47903,47919,47920,48290,48696,50050],
 [7823,7824,7828,7844,7845,8250,8254,8283,8405,8406,8670,40450,40454,40470,40471,40483,40499,
   40500,40605,40606,40870,47903,47919,47920,48290,48696,50050],
 [7823,7824,7828,7846,8250,8254,8283,8407,40450,40454,40472,40483,40501,40607,47903,47921],
 [7823,7824,7828,7847,7849,8250,8254,8283,8408,8410,8695,40450,40454,40473,40475,40483,40502,
   40504,40608,40610,40895,47903,47922,47924,50075],
 [7823,7824,7828,7848,8250,8254,8283,8409,40450,40454,40474,40483,40503,40609,47903,47923],
 [7823,7824,7828,7847,7849,8250,8254,8283,8408,8410,8695,40450,40454,40473,40475,40483,40502,
   40504,40608,40610,40895,47903,47922,47924,50075],
 [7823,7824,7828,7843,7850,8250,8254,8283,8404,8411,8666,40450,40454,40469,40476,40483,40498,
   40505,40604,40611,40866,47903,47918,47925,50046],
 [7823,7824,7828,7851,8250,8254,8283,8412,40450,40454,40477,40483,40506,40612,47903,47926],
 [7823,7824,7828,7852,7853,8250,8254,8283,8413,8414,8714,40450,40454,40478,40479,40483,40507,
   40508,40613,40614,40914,47903,47927,47928,48334,48740,50094],
 [7823,7824,7828,7852,7853,8250,8254,8283,8413,8414,8714,40450,40454,40478,40479,40483,40507,
   40508,40613,40614,40914,47903,47927,47928,48334,48740,50094],
 [7823,7824,7825,7828,7831,8250,8254,8283,8311,8314,8392,40450,40451,40454,40457,40480,40483,
   40486,40511,40514,40592,47900,47903,47906,48796],
 [7823,7824,7826,7828,8250,8254,8283,8338,40450,40452,40454,40481,40483,40538,47901,47903],
 [7817,7823,7824,7827,7828,8058,8059,8250,8254,8283,8364,40254,40255,40258,40259,40450,40453,
   40454,40482,40483,40564,44790,44793,44794,44822,44823,44904,47902,47903,47984,48390],
 [7828,40450],[7812,7814,7822,7823,7824,7828,7829,7830,7834,7855,7869,7871,7875,7948,7950,7954,
   8224,8225,8250,8254,8283,8390,8391,8395,8442,40055,40063,40064,40065,40069,40070,40071,40075,
   40142,40143,40144,40148,40149,40150,40154,40419,40420,40424,40425,40426,40430,40450,40454,40455,
   40456,40460,40483,40484,40485,40489,40590,40591,40595,40615,40619,40642,40962,40963,40964,40968,
   40969,40970,40974,41239,41240,41244,41245,41246,41250,41270,41274,41275,41276,41280,41303,41304,
   41305,41309,41410,41411,41415,41435,41439,41462,42760,42761,42765,42766,42767,42771,42791,42795,
   42796,42797,42801,42824,42825,42826,42830,42931,42932,42936,42956,42960,42983,47435,47439,47440,
   47441,47445,47468,47469,47470,47474,47575,47576,47580,47600,47604,47627,47903,47904,47905,47909,
   48010,48011,48015,48035,48039,48062,48416,48417,48421,48441,48445,48468,49795,49799,49822,50098]
  ,[7812,7814,7822,7823,7824,7828,7829,7830,7834,7855,7869,7871,7875,7948,7950,7954,8224,8225,
   8250,8254,8283,8390,8391,8395,8442,40055,40063,40064,40065,40069,40070,40071,40075,40142,40143,
   40144,40148,40149,40150,40154,40419,40420,40424,40425,40426,40430,40450,40454,40455,40456,40460,
   40483,40484,40485,40489,40590,40591,40595,40615,40619,40642,40962,40963,40964,40968,40969,40970,
   40974,41239,41240,41244,41245,41246,41250,41270,41274,41275,41276,41280,41303,41304,41305,41309,
   41410,41411,41415,41435,41439,41462,42760,42761,42765,42766,42767,42771,42791,42795,42796,42797,
   42801,42824,42825,42826,42830,42931,42932,42936,42956,42960,42983,47435,47439,47440,47441,47445,
   47468,47469,47470,47474,47575,47576,47580,47600,47604,47627,47903,47904,47905,47909,48010,48011,
   48015,48035,48039,48062,48416,48417,48421,48441,48445,48468,49795,49799,49822,50098],
 [7823,7824,7825,7828,7831,8250,8254,8283,8311,8314,8392,40450,40451,40454,40457,40480,40483,
   40486,40511,40514,40592,47900,47903,47906,48796],
 [7813,7823,7824,7828,7832,7909,7913,8250,8254,8283,8393,40104,40105,40109,40113,40450,40454,
   40458,40483,40487,40593,42050,42054,42058,42083,42087,42193,47903,47907,48013,48419],
 [7823,7824,7828,7833,7836,8250,8254,8283,8394,8397,8507,40450,40454,40459,40462,40483,40488,
   40491,40594,40597,40707,47903,47908,47911,48127,48533,49887],
 [7812,7814,7822,7823,7824,7828,7829,7830,7834,7855,7869,7871,7875,7948,7950,7954,8224,8225,8250,
   8254,8283,8390,8391,8395,8442,40055,40063,40064,40065,40069,40070,40071,40075,40142,40143,
   40144,40148,40149,40150,40154,40419,40420,40424,40425,40426,40430,40450,40454,40455,40456,40460,
   40483,40484,40485,40489,40590,40591,40595,40615,40619,40642,40962,40963,40964,40968,40969,40970,
   40974,41239,41240,41244,41245,41246,41250,41270,41274,41275,41276,41280,41303,41304,41305,41309,
   41410,41411,41415,41435,41439,41462,42760,42761,42765,42766,42767,42771,42791,42795,42796,42797,
   42801,42824,42825,42826,42830,42931,42932,42936,42956,42960,42983,47435,47439,47440,47441,47445,
   47468,47469,47470,47474,47575,47576,47580,47600,47604,47627,47903,47904,47905,47909,48010,48011,
   48015,48035,48039,48062,48416,48417,48421,48441,48445,48468,49795,49799,49822,50098],
 [7820,7823,7824,7828,7835,8161,8168,8250,8254,8283,8396,40356,40357,40361,40368,40450,40454,
   40461,40483,40490,40596,46474,46620,47903,47910],
 [7823,7824,7828,7833,7836,8250,8254,8283,8394,8397,8507,40450,40454,40459,40462,40483,40488,
   40491,40594,40597,40707,47903,47908,47911,48127,48533,49887],
 [7816,7823,7824,7828,7837,8023,8032,8250,8254,8283,8398,40218,40219,40223,40232,40450,40454,
   40463,40483,40492,40598,44160,44308,47903,47912],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,3501,3505,3506,3507,3513,
   3514,3517,3518,3527,3528,3544,3548,3549,3550,3556,3557,3560,3561,3570,3571,3590,3591,3592,
   3598,3599,3602,3603,3612,3613,3749,3750,3756,3757,3770,3771,3787,3793,3794,3829,3830,3833,
   3834,3843,3844,4025,4038,4039,4139,4354,4510,4511,4512,4518,4528,4529,5645,5646,5650,5651,
   5652,5658,5659,5662,5663,5672,5673,5689,5693,5694,5695,5701,5702,5705,5706,5715,5716,5735,
   5736,5737,5743,5744,5747,5748,5757,5758,5894,5902,5905,5916,5939,5942,5953,5978,5979,6170,
   6173,6183,6184,6202,6212,6213,6284,6293,6294,6499,7725,7726,7730,7731,7732,7738,7739,7742,
   7743,7752,7753,7769,7773,7774,7775,7781,7782,7785,7786,7795,7796,7815,7816,7817,7823,7824,
   7827,7828,7837,7838,7974,7986,7995,7996,8018,8019,8023,8032,8033,8058,8059,8250,8254,8263,
   8283,8292,8364,8398,8399,8579,38205,38209,38210,38211,38217,38218,38221,38222,38231,38232,
   38251,38252,38253,38259,38260,38263,38264,38273,38274,38410,38411,38417,38418,38431,38432,38448,
   38454,38455,38468,38469,38490,38491,38494,38495,38504,38505,38686,38699,38700,38728,38729,38800,
   39015,39154,39155,39156,39162,39163,39166,39167,39176,39177,39313,39320,39321,39324,39334,39335,
   39357,39358,39361,39371,39372,39397,39398,39589,39592,39602,39603,39621,39631,39632,39703,39712,
   39713,39918,40174,40181,40182,40186,40195,40196,40218,40219,40223,40232,40233,40258,40259,40450,
   40454,40463,40464,40483,40492,40493,40564,40598,40599,40779,43262,43263,43266,43276,43277,43298,
   43494,43507,43508,43536,43537,43643,43823,43965,44160,44173,44174,44202,44203,44308,44489,44904,
   45119,47903,47912,47913,47993,48199,48400,48605],
 [7823,7824,7828,7839,8250,8254,8283,8400,40450,40454,40465,40483,40494,40600,47903,47914],
 [7823,7824,7828,7840,7841,8250,8254,8283,8401,8402,8624,40450,40454,40466,40467,40483,40495,
   40496,40601,40602,40824,47903,47915,47916,48244,48650,50004],
 [7823,7824,7828,7840,7841,8250,8254,8283,8401,8402,8624,40450,40454,40466,40467,40483,40495,
   40496,40601,40602,40824,47903,47915,47916,48244,48650,50004],
 [7823,7824,7828,7842,8250,8254,8283,8403,40450,40454,40468,40483,40497,40603,47903,47917],
 [7823,7824,7828,7843,7850,8250,8254,8283,8404,8411,8666,40450,40454,40469,40476,40483,40498,
   40505,40604,40611,40866,47903,47918,47925,50046],
 [7823,7824,7828,7844,7845,8250,8254,8283,8405,8406,8670,40450,40454,40470,40471,40483,40499,
   40500,40605,40606,40870,47903,47919,47920,48290,48696,50050],
 [7823,7824,7828,7844,7845,8250,8254,8283,8405,8406,8670,40450,40454,40470,40471,40483,40499,
   40500,40605,40606,40870,47903,47919,47920,48290,48696,50050],
 [7823,7824,7828,7846,8250,8254,8283,8407,40450,40454,40472,40483,40501,40607,47903,47921],
 [7823,7824,7828,7847,7849,8250,8254,8283,8408,8410,8695,40450,40454,40473,40475,40483,40502,
   40504,40608,40610,40895,47903,47922,47924,50075],
 [7823,7824,7828,7848,8250,8254,8283,8409,40450,40454,40474,40483,40503,40609,47903,47923],
 [7823,7824,7828,7847,7849,8250,8254,8283,8408,8410,8695,40450,40454,40473,40475,40483,40502,
   40504,40608,40610,40895,47903,47922,47924,50075],
 [7823,7824,7828,7843,7850,8250,8254,8283,8404,8411,8666,40450,40454,40469,40476,40483,40498,
   40505,40604,40611,40866,47903,47918,47925,50046],
 [7823,7824,7828,7851,8250,8254,8283,8412,40450,40454,40477,40483,40506,40612,47903,47926],
 [7823,7824,7828,7852,7853,8250,8254,8283,8413,8414,8714,40450,40454,40478,40479,40483,40507,
   40508,40613,40614,40914,47903,47927,47928,48334,48740,50094],
 [7823,7824,7828,7852,7853,8250,8254,8283,8413,8414,8714,40450,40454,40478,40479,40483,40507,
   40508,40613,40614,40914,47903,47927,47928,48334,48740,50094],
 [7813,7825,7826,7828,7831,7832,7909,7913,8311,8314,8338,8392,8393,40109,40113,40511,40514,40538,
   40592,40593,42109,42111,42114,42115,42138,42141,42142,42192,42193,42262,48742,48745,48746,48796,
   48797,48866,49147,49148,49217,49842],[7817,7825,7827,7828,7831,8058,8059,8311,8314,8364,8392,
   40258,40259,40511,40514,40564,40592,44850,44851,44854,44904,44907,44932,48768,48771,48796,49472]
  ,[7828,48796],[7822,7825,7828,7829,7831,8224,8225,8311,8314,8390,8392,40424,40425,40511,
   40514,40590,40592,47496,47497,47499,47575,47577,47601,48794,48796,48820,49796],[7950,42854],
 [7828,48796],[7813,7825,7826,7828,7831,7832,7909,7913,8311,8314,8338,8392,8393,40109,40113,
   40511,40514,40538,40592,40593,42109,42111,42114,42115,42138,42141,42142,42192,42193,42262,48742,
   48745,48746,48796,48797,48866,49147,49148,49217,49842],[8507,48911],[7875,41337],[8168],
 [8507,48911],[8032],[7996,43565],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[7817,7826,7827,7828,8058,8059,8338,8364,40258,40259,40538,40564,44877,44878,
   44904,49119],[7828],[7822,7826,7828,7829,8224,8225,8338,8390,40424,40425,40538,40590,47523,
   47524,47575,49145],[7875,7950,41364,42881],
 [7813,7825,7826,7828,7831,7832,7909,7913,8311,8314,8338,8392,8393,40109,40113,40511,40514,40538,
   40592,40593,42109,42111,42114,42115,42138,42141,42142,42192,42193,42262,48742,48745,48746,48796,
   48797,48866,49147,49148,49217,49842],[7813,7825,7826,7828,7831,7832,7909,7913,8311,8314,8338,
   8392,8393,40109,40113,40511,40514,40538,40592,40593,42109,42111,42114,42115,42138,42141,42142,
   42192,42193,42262,48742,48745,48746,48796,48797,48866,49147,49148,49217,49842],[8507,49262],
 [7875,7950,41364,42881],[8168],[8507,49262],[8032],[7996,43592],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[7828,44904],
 [7817,7822,7827,7828,7829,8058,8059,8224,8225,8364,8390,40258,40259,40424,40425,40564,40590,
   44763,44764,44765,44904,44905,44930,47549,47550,47575,49470],
 [7812,7814,7817,7818,7821,7827,7828,7830,7834,7855,7869,7871,7875,7948,7950,7954,8058,8059,8087,
   8094,8193,8364,8391,8395,8442,40055,40058,40059,40062,40068,40069,40071,40075,40137,40138,
   40141,40147,40148,40150,40154,40249,40252,40258,40259,40261,40265,40287,40293,40294,40296,40300,
   40392,40393,40395,40399,40564,40566,40570,40591,40595,40642,40957,40958,40961,40967,40968,40970,
   40974,41069,41072,41078,41079,41081,41085,41107,41113,41114,41116,41120,41212,41213,41215,41219,
   41384,41386,41390,41411,41415,41462,42590,42593,42599,42600,42602,42606,42628,42634,42635,42637,
   42641,42733,42734,42736,42740,42905,42907,42911,42932,42936,42983,44627,44633,44634,44636,44640,
   44732,44733,44735,44739,44904,44906,44910,44931,44935,44982,45327,45328,45330,45334,45499,45501,
   45505,45526,45530,45577,47084,47086,47090,47111,47115,47162,49471,49475,49522,49822],
 [7817,7825,7827,7828,7831,8058,8059,8311,8314,8364,8392,40258,40259,40511,40514,40564,40592,
   44850,44851,44854,44904,44907,44932,48768,48771,48796,49472],
 [7813,7817,7819,7827,7828,7832,7909,7913,8058,8059,8128,8364,8393,40109,40113,40258,40259,40328,
   40564,40593,41850,41858,41859,41863,41927,41928,41932,42164,42168,42193,44667,44668,44672,44904,
   44908,44933,46060,46064,46089,49473],[7817,7820,7827,7828,7833,7835,7836,8058,8059,8161,8168,
   8364,8394,8396,8397,8507,40258,40259,40361,40368,40564,40594,40596,40597,40707,44700,44701,
   44706,44904,44909,44911,44912,44934,44936,44937,45046,45047,45084,46588,46593,46596,46618,46620,
   46621,46731,49474,49476,49477,49587,49624,49886,49887,49924,51084],
 [7812,7814,7817,7818,7821,7827,7828,7830,7834,7855,7869,7871,7875,7948,7950,7954,8058,8059,8087,
   8094,8193,8364,8391,8395,8442,40055,40058,40059,40062,40068,40069,40071,40075,40137,40138,
   40141,40147,40148,40150,40154,40249,40252,40258,40259,40261,40265,40287,40293,40294,40296,40300,
   40392,40393,40395,40399,40564,40566,40570,40591,40595,40642,40957,40958,40961,40967,40968,40970,
   40974,41069,41072,41078,41079,41081,41085,41107,41113,41114,41116,41120,41212,41213,41215,41219,
   41384,41386,41390,41411,41415,41462,42590,42593,42599,42600,42602,42606,42628,42634,42635,42637,
   42641,42733,42734,42736,42740,42905,42907,42911,42932,42936,42983,44627,44633,44634,44636,44640,
   44732,44733,44735,44739,44904,44906,44910,44931,44935,44982,45327,45328,45330,45334,45499,45501,
   45505,45526,45530,45577,47084,47086,47090,47111,47115,47162,49471,49475,49522,49822],
 [7817,7820,7827,7828,7833,7835,7836,8058,8059,8161,8168,8364,8394,8396,8397,8507,40258,40259,
   40361,40368,40564,40594,40596,40597,40707,44700,44701,44706,44904,44909,44911,44912,44934,44936,
   44937,45046,45047,45084,46588,46593,46596,46618,46620,46621,46731,49474,49476,49477,49587,49624,
   49886,49887,49924,51084],[7817,7820,7827,7828,7833,7835,7836,8058,8059,8161,8168,8364,8394,
   8396,8397,8507,40258,40259,40361,40368,40564,40594,40596,40597,40707,44700,44701,44706,44904,
   44909,44911,44912,44934,44936,44937,45046,45047,45084,46588,46593,46596,46618,46620,46621,46731,
   49474,49476,49477,49587,49624,49886,49887,49924,51084],
 [7816,7817,7827,7828,7837,8023,8032,8058,8059,8364,8398,40223,40232,40258,40259,40564,40598,
   43968,43969,44274,44308,44904,44913,44938,49478],
 [7815,7817,7827,7828,7838,7986,7996,8058,8059,8364,8399,40186,40196,40258,40259,40564,40599,
   43302,43303,43313,43608,43618,43643,44904,44914,44939,49479],
 [7817,7827,7828,7839,8058,8059,8364,8400,40258,40259,40564,40600,44904,44915,44940,49480],
 [7817,7827,7828,7840,7841,8058,8059,8364,8401,8402,8624,40258,40259,40564,40601,40602,40824,
   44904,44916,44917,44941,44942,49481,49482,50004],
 [7817,7827,7828,7840,7841,8058,8059,8364,8401,8402,8624,40258,40259,40564,40601,40602,40824,
   44904,44916,44917,44941,44942,49481,49482,50004],
 [7817,7827,7828,7842,8058,8059,8364,8403,40258,40259,40564,40603,44904,44918,44943,49483],
 [7817,7827,7828,7843,7850,8058,8059,8364,8404,8411,8666,40258,40259,40564,40604,40611,40866,
   44904,44919,44926,44944,44951,45206,49484,49491,49746,50046],
 [7817,7827,7828,7844,7845,8058,8059,8364,8405,8406,8670,40258,40259,40564,40605,40606,40870,
   44904,44920,44921,44945,44946,49485,49486,50050],
 [7817,7827,7828,7844,7845,8058,8059,8364,8405,8406,8670,40258,40259,40564,40605,40606,40870,
   44904,44920,44921,44945,44946,49485,49486,50050],
 [7817,7827,7828,7846,8058,8059,8364,8407,40258,40259,40564,40607,44904,44922,44947,49487],
 [7817,7827,7828,7847,7849,8058,8059,8364,8408,8410,8695,40258,40259,40564,40608,40610,40895,
   44904,44923,44925,44948,44950,45235,49488,49490,49775,50075],
 [7817,7827,7828,7848,8058,8059,8364,8409,40258,40259,40564,40609,44904,44924,44949,49489],
 [7817,7827,7828,7847,7849,8058,8059,8364,8408,8410,8695,40258,40259,40564,40608,40610,40895,
   44904,44923,44925,44948,44950,45235,49488,49490,49775,50075],
 [7817,7827,7828,7843,7850,8058,8059,8364,8404,8411,8666,40258,40259,40564,40604,40611,40866,
   44904,44919,44926,44944,44951,45206,49484,49491,49746,50046],
 [7817,7827,7828,7851,8058,8059,8364,8412,40258,40259,40564,40612,44904,44927,44952,49492],
 [7817,7827,7828,7852,7853,8058,8059,8364,8413,8414,8714,40258,40259,40564,40613,40614,40914,
   44904,44928,44929,44953,44954,49493,49494,50094],
 [7817,7827,7828,7852,7853,8058,8059,8364,8413,8414,8714,40258,40259,40564,40613,40614,40914,
   44904,44928,44929,44953,44954,49493,49494,50094],[7828,47575],
 [7828,7875,7950,40055,40642,41411,42936],[7828,48796],[7828,42193],[7828,8507,40707,49887],
 [7828,7875,7950,40055,40642,41411,42936],[7828,8168],[7828,8507,40707,49887],[7828,8032],
 [7828,7996,40196,43643],[7828],[7828,40824],[7828,40824],[7828],[7828,50046],
 [7828,40870],[7828,40870],[7828],[7828,50075],[7828],[7828,50075],[7828,50046],[7828],
 [7828,40914],[7828,40914],[7812,7814,7822,7823,7824,7828,7829,7830,7834,7855,7869,7871,7875,
   7948,7950,7954,8224,8225,8250,8254,8283,8390,8391,8395,8442,40055,40063,40064,40065,40069,
   40070,40071,40075,40142,40143,40144,40148,40149,40150,40154,40419,40420,40424,40425,40426,40430,
   40450,40454,40455,40456,40460,40483,40484,40485,40489,40590,40591,40595,40615,40619,40642,40962,
   40963,40964,40968,40969,40970,40974,41239,41240,41244,41245,41246,41250,41270,41274,41275,41276,
   41280,41303,41304,41305,41309,41410,41411,41415,41435,41439,41462,42760,42761,42765,42766,42767,
   42771,42791,42795,42796,42797,42801,42824,42825,42826,42830,42931,42932,42936,42956,42960,42983,
   47435,47439,47440,47441,47445,47468,47469,47470,47474,47575,47576,47580,47600,47604,47627,47903,
   47904,47905,47909,48010,48011,48015,48035,48039,48062,48416,48417,48421,48441,48445,48468,49795,
   49799,49822,50098],[7822,7825,7828,7829,7831,8224,8225,8311,8314,8390,8392,40424,40425,40511,
   40514,40590,40592,47496,47497,47499,47575,47577,47601,48794,48796,48820,49796],
 [7813,7822,7828,7829,7832,7909,7913,8224,8225,8390,8393,40109,40113,40424,40425,40590,40593,
   42024,42025,42028,42190,42193,42217,47575,47578,47602,49797],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,3501,3507,3510,3512,3517,
   3518,3519,3523,3525,3526,3544,3550,3560,3561,3592,3602,3603,3826,3828,3833,3834,3835,3839,
   3841,3842,3930,3935,3936,3937,3941,3998,3999,4000,4004,4139,4140,4144,4146,4147,4165,4169,
   4171,4172,4193,4195,4196,4281,4282,4319,4510,4511,4512,4518,4528,4529,5645,5646,5652,5662,
   5663,5689,5695,5698,5700,5705,5706,5707,5711,5713,5714,5737,5747,5748,5971,5973,5978,5979,
   5980,5984,5986,5987,6075,6080,6081,6086,6089,6143,6144,6145,6149,6151,6152,6284,6285,6289,
   6291,6292,6310,6314,6316,6317,6340,6341,6427,6464,7725,7726,7732,7742,7743,7769,7775,7785,
   7786,7817,7820,7822,7827,7828,7829,7833,7835,7836,8051,8053,8058,8059,8060,8064,8066,8067,
   8155,8160,8161,8162,8166,8168,8169,8223,8224,8225,8231,8364,8365,8369,8371,8372,8390,8394,
   8396,8397,8420,8506,8507,8544,38205,38211,38221,38222,38253,38263,38264,38487,38489,38494,
   38495,38496,38500,38502,38503,38591,38800,38854,38980,39156,39166,39167,39397,39398,39499,39505,
   39562,39571,39703,39704,39708,39710,39711,39759,40258,40259,40361,40368,40424,40425,40564,40590,
   40594,40596,40597,40707,44695,44700,44701,44702,44706,44708,44709,44763,44764,44765,44769,44771,
   44772,44904,44905,44909,44911,44912,44930,44934,44936,44937,44958,44960,44961,45046,45047,45084,
   46447,46448,46449,46453,46455,46456,46588,46589,46593,46595,46596,46614,46618,46620,46621,46642,
   46644,46645,46730,46731,46768,47549,47550,47554,47556,47557,47575,47579,47581,47582,47603,47605,
   47606,47691,47692,47729,49470,49474,49476,49477,49498,49500,49501,49586,49587,49624,49798,49800,
   49801,49886,49887,49924,50162,50163,50200,51084],
 [7812,7814,7822,7823,7824,7828,7829,7830,7834,7855,7869,7871,7875,7948,7950,7954,8224,8225,8250,
   8254,8283,8390,8391,8395,8442,40055,40063,40064,40065,40069,40070,40071,40075,40142,40143,
   40144,40148,40149,40150,40154,40419,40420,40424,40425,40426,40430,40450,40454,40455,40456,40460,
   40483,40484,40485,40489,40590,40591,40595,40615,40619,40642,40962,40963,40964,40968,40969,40970,
   40974,41239,41240,41244,41245,41246,41250,41270,41274,41275,41276,41280,41303,41304,41305,41309,
   41410,41411,41415,41435,41439,41462,42760,42761,42765,42766,42767,42771,42791,42795,42796,42797,
   42801,42824,42825,42826,42830,42931,42932,42936,42956,42960,42983,47435,47439,47440,47441,47445,
   47468,47469,47470,47474,47575,47576,47580,47600,47604,47627,47903,47904,47905,47909,48010,48011,
   48015,48035,48039,48062,48416,48417,48421,48441,48445,48468,49795,49799,49822,50098],
 [7820,7822,7828,7829,7835,8161,8168,8224,8225,8390,8396,40361,40368,40424,40425,40590,40596,
   46448,46449,46614,46620,47575,47581,47605,49800],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,3500,3501,3507,3510,3512,3517,
   3518,3519,3523,3525,3526,3544,3550,3560,3561,3592,3602,3603,3826,3828,3833,3834,3835,3839,
   3841,3842,3930,3935,3936,3937,3941,3998,3999,4000,4004,4139,4140,4144,4146,4147,4165,4169,
   4171,4172,4193,4195,4196,4281,4282,4319,4510,4511,4512,4518,4528,4529,5645,5646,5652,5662,
   5663,5689,5695,5698,5700,5705,5706,5707,5711,5713,5714,5737,5747,5748,5971,5973,5978,5979,
   5980,5984,5986,5987,6075,6080,6081,6086,6089,6143,6144,6145,6149,6151,6152,6284,6285,6289,
   6291,6292,6310,6314,6316,6317,6340,6341,6427,6464,7725,7726,7732,7742,7743,7769,7775,7785,
   7786,7817,7820,7822,7827,7828,7829,7833,7835,7836,8051,8053,8058,8059,8060,8064,8066,8067,
   8155,8160,8161,8162,8166,8168,8169,8223,8224,8225,8231,8364,8365,8369,8371,8372,8390,8394,
   8396,8397,8420,8506,8507,8544,38205,38211,38221,38222,38253,38263,38264,38487,38489,38494,
   38495,38496,38500,38502,38503,38591,38800,38854,38980,39156,39166,39167,39397,39398,39499,39505,
   39562,39571,39703,39704,39708,39710,39711,39759,40258,40259,40361,40368,40424,40425,40564,40590,
   40594,40596,40597,40707,44695,44700,44701,44702,44706,44708,44709,44763,44764,44765,44769,44771,
   44772,44904,44905,44909,44911,44912,44930,44934,44936,44937,44958,44960,44961,45046,45047,45084,
   46447,46448,46449,46453,46455,46456,46588,46589,46593,46595,46596,46614,46618,46620,46621,46642,
   46644,46645,46730,46731,46768,47549,47550,47554,47556,47557,47575,47579,47581,47582,47603,47605,
   47606,47691,47692,47729,49470,49474,49476,49477,49498,49500,49501,49586,49587,49624,49798,49800,
   49801,49886,49887,49924,50162,50163,50200,51084],
 [7816,7822,7828,7829,7837,8023,8032,8224,8225,8390,8398,40223,40232,40424,40425,40590,40598,
   44134,44135,44300,44308,47575,47583,47607,49802],
 [7815,7822,7828,7829,7838,7986,7996,8224,8225,8390,8399,40186,40196,40424,40425,40590,40599,
   43468,43469,43478,43634,43643,43667,47575,47584,47608,49803],
 [7822,7828,7829,7839,8224,8225,8390,8400,40424,40425,40590,40600,47575,47585,47609,49804],
 [7822,7828,7829,7840,7841,8224,8225,8390,8401,8402,8624,40424,40425,40590,40601,40602,40824,
   47575,47586,47587,47610,47611,49805,49806,50004],
 [7822,7828,7829,7840,7841,8224,8225,8390,8401,8402,8624,40424,40425,40590,40601,40602,40824,
   47575,47586,47587,47610,47611,49805,49806,50004],
 [7822,7828,7829,7842,8224,8225,8390,8403,40424,40425,40590,40603,47575,47588,47612,49807],
 [7822,7828,7829,7843,7850,8224,8225,8390,8404,8411,8666,40424,40425,40590,40604,40611,40866,
   47575,47589,47596,47613,47620,47851,49808,49815,50046,50322],
 [7822,7828,7829,7844,7845,8224,8225,8390,8405,8406,8670,40424,40425,40590,40605,40606,40870,
   47575,47590,47591,47614,47615,49809,49810,50050],
 [7822,7828,7829,7844,7845,8224,8225,8390,8405,8406,8670,40424,40425,40590,40605,40606,40870,
   47575,47590,47591,47614,47615,49809,49810,50050],
 [7822,7828,7829,7846,8224,8225,8390,8407,40424,40425,40590,40607,47575,47592,47616,49811],
 [7822,7828,7829,7847,7849,8224,8225,8390,8408,8410,8695,40424,40425,40590,40608,40610,40895,
   47575,47593,47595,47617,47619,47880,49812,49814,50075,50351],
 [7822,7828,7829,7848,8224,8225,8390,8409,40424,40425,40590,40609,47575,47594,47618,49813],
 [7822,7828,7829,7847,7849,8224,8225,8390,8408,8410,8695,40424,40425,40590,40608,40610,40895,
   47575,47593,47595,47617,47619,47880,49812,49814,50075,50351],
 [7822,7828,7829,7843,7850,8224,8225,8390,8404,8411,8666,40424,40425,40590,40604,40611,40866,
   47575,47589,47596,47613,47620,47851,49808,49815,50046,50322],
 [7822,7828,7829,7851,8224,8225,8390,8412,40424,40425,40590,40612,47575,47597,47621,49816],
 [7822,7828,7829,7852,7853,8224,8225,8390,8413,8414,8714,40424,40425,40590,40613,40614,40914,
   47575,47598,47599,47622,47623,49817,49818,50094],
 [7822,7828,7829,7852,7853,8224,8225,8390,8413,8414,8714,40424,40425,40590,40613,40614,40914,
   47575,47598,47599,47622,47623,49817,49818,50094],[7950,42980],
 [7725,7726,7743,7769,7786,7812,7813,7814,7828,7830,7832,7834,7855,7869,7871,7875,7909,7913,7948,
   7950,7954,8391,8393,8395,8442,38205,38206,38207,38208,38222,38224,38226,38228,38248,38249,
   38250,38264,38266,38268,38270,38290,38291,38305,38307,38309,38311,38331,38345,38347,38349,38351,
   38384,38386,38388,38390,38827,38829,38831,38876,38878,38921,39151,39152,39153,39167,39169,39171,
   39173,39193,39194,39208,39210,39212,39214,39234,39248,39250,39252,39254,39287,39289,39291,39293,
   39730,39732,39734,39779,39781,39824,40054,40055,40069,40071,40073,40075,40095,40109,40111,40113,
   40115,40148,40150,40152,40154,40591,40593,40595,40640,40642,40685,40915,40929,40931,40933,40935,
   40968,40970,40972,40974,41411,41413,41415,41460,41462,41505,41748,41750,41752,41754,42191,42193,
   42195,42240,42242,42285,42932,42934,42936,42981,42983,43026,49820,49822,49865,50394],
 [7950,7996,8507,42529,42532,42535,42537,42982,42985,42987,43048,43050,43104,43685,43688,43690,
   43751,43753,43807,50416,50418,50472,51103],[7828,7875,7950,40055,40642,41411,42936],
 [7950,8168,42704,42984],[7950,7996,8507,42529,42532,42535,42537,42982,42985,42987,43048,43050,
   43104,43685,43688,43690,43751,43753,43807,50416,50418,50472,51103],[7950,8032,42566,42986],
 [7950,7996,8507,42529,42532,42535,42537,42982,42985,42987,43048,43050,43104,43685,43688,43690,
   43751,43753,43807,50416,50418,50472,51103],[7875,7950,41549,42988],[7950,42989],
 [7950,42990],[7875,7950,41552,42991],[7950,42992],[7950,42993],[7950,42994],
 [7875,7950,41556,42995],[7950,42996],[7875,7950,41558,42997],[7950,42998],[7950,42999],
 [7875,7950,41561,43000],[7950,43001],[7950,43002],
 [7813,7825,7826,7828,7831,7832,7909,7913,8311,8314,8338,8392,8393,40109,40113,40511,40514,40538,
   40592,40593,42109,42111,42114,42115,42138,42141,42142,42192,42193,42262,48742,48745,48746,48796,
   48797,48866,49147,49148,49217,49842],[8507,50647],[7875,41484],[8168],[8507,50647],
 [8032],[7996,43712],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[7813,7816,7828,7832,7833,7836,7837,7909,7913,8023,8032,8393,8394,8397,8398,8507,40109,
   40113,40223,40232,40593,40594,40597,40598,40707,41823,41827,41828,42193,42194,42197,42198,42284,
   42287,42288,42307,42308,42362,44303,44304,44307,44308,44394,44397,44417,49864,49867,49868,49887,
   49888,49942,50857,50912,51102],[7725,7726,7743,7769,7786,7812,7813,7814,7828,7830,7832,7834,
   7855,7869,7871,7875,7909,7913,7948,7950,7954,8391,8393,8395,8442,38205,38206,38207,38208,
   38222,38224,38226,38228,38248,38249,38250,38264,38266,38268,38270,38290,38291,38305,38307,38309,
   38311,38331,38345,38347,38349,38351,38384,38386,38388,38390,38827,38829,38831,38876,38878,38921,
   39151,39152,39153,39167,39169,39171,39173,39193,39194,39208,39210,39212,39214,39234,39248,39250,
   39252,39254,39287,39289,39291,39293,39730,39732,39734,39779,39781,39824,40054,40055,40069,40071,
   40073,40075,40095,40109,40111,40113,40115,40148,40150,40152,40154,40591,40593,40595,40640,40642,
   40685,40915,40929,40931,40933,40935,40968,40970,40972,40974,41411,41413,41415,41460,41462,41505,
   41748,41750,41752,41754,42191,42193,42195,42240,42242,42285,42932,42934,42936,42981,42983,43026,
   49820,49822,49865,50394],[7813,7820,7828,7832,7835,7909,7913,8161,8168,8393,8396,40109,40113,
   40361,40368,40593,40596,41961,41965,42193,42196,42286,46617,46620,49866],
 [7813,7816,7828,7832,7833,7836,7837,7909,7913,8023,8032,8393,8394,8397,8398,8507,40109,40113,
   40223,40232,40593,40594,40597,40598,40707,41823,41827,41828,42193,42194,42197,42198,42284,42287,
   42288,42307,42308,42362,44303,44304,44307,44308,44394,44397,44417,49864,49867,49868,49887,49888,
   49942,50857,50912,51102],[7813,7816,7828,7832,7833,7836,7837,7909,7913,8023,8032,8393,8394,
   8397,8398,8507,40109,40113,40223,40232,40593,40594,40597,40598,40707,41823,41827,41828,42193,
   42194,42197,42198,42284,42287,42288,42307,42308,42362,44303,44304,44307,44308,44394,44397,44417,
   49864,49867,49868,49887,49888,49942,50857,50912,51102],
 [7813,7815,7828,7832,7838,7909,7913,7986,7996,8393,8399,40109,40113,40186,40196,40593,40599,
   41786,41790,41796,42193,42199,42289,43637,43643,43733,49869],
 [7813,7828,7832,7839,7909,7913,8393,8400,40109,40113,40593,40600,42193,42200,42290,49870],
 [7813,7828,7832,7840,7841,7909,7913,8393,8401,8402,8624,40109,40113,40593,40601,40602,40824,
   42193,42201,42202,42291,42292,49871,49872,50004],
 [7813,7828,7832,7840,7841,7909,7913,8393,8401,8402,8624,40109,40113,40593,40601,40602,40824,
   42193,42201,42202,42291,42292,49871,49872,50004],
 [7813,7828,7832,7842,7843,7850,7909,7913,8393,8403,8404,8411,8666,40109,40113,40593,40603,40604,
   40611,40866,42193,42203,42204,42211,42293,42294,42301,42449,42456,42466,49873,49874,49881,50029,
   50036,50046,50999,51006,51016,52181],[7813,7828,7832,7842,7843,7850,7909,7913,8393,8403,8404,
   8411,8666,40109,40113,40593,40603,40604,40611,40866,42193,42203,42204,42211,42293,42294,42301,
   42449,42456,42466,49873,49874,49881,50029,50036,50046,50999,51006,51016,52181],
 [7813,7828,7832,7844,7845,7909,7913,8393,8405,8406,8670,40109,40113,40593,40605,40606,40870,
   42193,42205,42206,42295,42296,49875,49876,50050],
 [7813,7828,7832,7844,7845,7909,7913,8393,8405,8406,8670,40109,40113,40593,40605,40606,40870,
   42193,42205,42206,42295,42296,49875,49876,50050],
 [7813,7828,7832,7846,7909,7913,8393,8407,40109,40113,40593,40607,42193,42207,42297,49877],
 [7813,7828,7832,7847,7848,7849,7909,7913,8393,8408,8409,8410,8695,40109,40113,40593,40608,40609,
   40610,40895,42193,42208,42209,42210,42298,42299,42300,42494,42495,42500,49878,49879,49880,50074,
   50075,50080,51044,51045,51050,52360],[7813,7828,7832,7847,7848,7849,7909,7913,8393,8408,8409,
   8410,8695,40109,40113,40593,40608,40609,40610,40895,42193,42208,42209,42210,42298,42299,42300,
   42494,42495,42500,49878,49879,49880,50074,50075,50080,51044,51045,51050,52360],
 [7813,7828,7832,7847,7848,7849,7909,7913,8393,8408,8409,8410,8695,40109,40113,40593,40608,40609,
   40610,40895,42193,42208,42209,42210,42298,42299,42300,42494,42495,42500,49878,49879,49880,50074,
   50075,50080,51044,51045,51050,52360],[7813,7828,7832,7842,7843,7850,7909,7913,8393,8403,8404,
   8411,8666,40109,40113,40593,40603,40604,40611,40866,42193,42203,42204,42211,42293,42294,42301,
   42449,42456,42466,49873,49874,49881,50029,50036,50046,50999,51006,51016,52181],
 [7813,7828,7832,7851,7909,7913,8393,8412,40109,40113,40593,40612,42193,42212,42302,49882],
 [7813,7828,7832,7852,7853,7909,7913,8393,8413,8414,8714,40109,40113,40593,40613,40614,40914,
   42193,42213,42214,42303,42304,49883,49884,50094],
 [7813,7828,7832,7852,7853,7909,7913,8393,8413,8414,8714,40109,40113,40593,40613,40614,40914,
   42193,42213,42214,42303,42304,49883,49884,50094],[7875,8507,41525,41527,41546,51066],
 [7817,7820,7827,7828,7833,7835,7836,8058,8059,8161,8168,8364,8394,8396,8397,8507,40258,40259,
   40361,40368,40564,40594,40596,40597,40707,44700,44701,44706,44904,44909,44911,44912,44934,44936,
   44937,45046,45047,45084,46588,46593,46596,46618,46620,46621,46731,49474,49476,49477,49587,49624,
   49886,49887,49924,51084],[],[7813,7816,7828,7832,7833,7836,7837,7909,7913,8023,8032,8393,
   8394,8397,8398,8507,40109,40113,40223,40232,40593,40594,40597,40598,40707,41823,41827,41828,
   42193,42194,42197,42198,42284,42287,42288,42307,42308,42362,44303,44304,44307,44308,44394,44397,
   44417,49864,49867,49868,49887,49888,49942,50857,50912,51102],
 [7950,7996,8507,42529,42532,42535,42537,42982,42985,42987,43048,43050,43104,43685,43688,43690,
   43751,43753,43807,50416,50418,50472,51103],[8507,51104],[8507,51105],[8507,51106],
 [8507,51107],[8507,51108],[8507,51109],[8507,51110],[8507,51111],[8507,51112],
 [8507,51113],[8507,51114],[8507,51115],[8507,51116],[8507,51117],[8507,51118],
 [7875,8168,41187,41545],[7875,8507,41525,41527,41546,51066],[7875,8032,41049,41547],
 [7875,7996,41012,41016,41548,43772],[7875,7950,41549,42988],[7875,41550],[7875,41551],
 [7875,7950,41552,42991],[7875,41553],[7875,41554],[7875,41555],[7875,7950,41556,42995],
 [7875,41557],[7875,7950,41558,42997],[7875,41559],[7875,41560],[7875,7950,41561,43000],
 [7875,41562],[7875,41563],[7817,7820,7827,7828,7833,7835,7836,8058,8059,8161,8168,8364,8394,
   8396,8397,8507,40258,40259,40361,40368,40564,40594,40596,40597,40707,44700,44701,44706,44904,
   44909,44911,44912,44934,44936,44937,45046,45047,45084,46588,46593,46596,46618,46620,46621,46731,
   49474,49476,49477,49587,49624,49886,49887,49924,51084],[8032,8168,44030,46241],
 [7815,7818,7820,7821,7828,7835,7838,7986,7996,8087,8094,8161,8168,8193,8396,8399,40176,40178,
   40179,40186,40193,40196,40286,40287,40294,40301,40304,40354,40361,40368,40371,40393,40400,40403,
   40596,40599,40746,43330,43331,43348,43398,43415,43444,43447,43643,43790,45289,45306,45328,45335,
   45338,45681,46620,47266],[8168],[8168],[8168],[8168],[8168],[8168],[8168],[8168],
 [8168],[8168],[8168],[8168],[8168],[8168],[8168],
 [7813,7816,7828,7832,7833,7836,7837,7909,7913,8023,8032,8393,8394,8397,8398,8507,40109,40113,
   40223,40232,40593,40594,40597,40598,40707,41823,41827,41828,42193,42194,42197,42198,42284,42287,
   42288,42307,42308,42362,44303,44304,44307,44308,44394,44397,44417,49864,49867,49868,49887,49888,
   49942,50857,50912,51102],[7950,7996,8507,42529,42532,42535,42537,42982,42985,42987,43048,
   43050,43104,43685,43688,43690,43751,43753,43807,50416,50418,50472,51103],[8507,51104],
 [8507,51105],[8507,51106],[8507,51107],[8507,51108],[8507,51109],[8507,51110],
 [8507,51111],[8507,51112],[8507,51113],[8507,51114],[8507,51115],[8507,51116],
 [8507,51117],[8507,51118],[7725,7726,7743,7769,7786,7815,7816,7828,7837,7838,7986,7996,8023,
   8032,8398,8399,38205,38209,38210,38222,38231,38232,38251,38252,38264,38273,38274,38410,38431,
   38432,39015,39154,39155,39167,39176,39177,39313,39335,39372,39918,40174,40186,40195,40196,40223,
   40232,40233,40598,40599,40779,43277,43643,43823,44308],[8032],[8032],[8032],[8032],
 [8032],[8032],[8032],[8032],[8032],[8032],[8032],[8032],[8032],[8032],[8032],
 [7996,43839],[7996,43840],[7996,43841],[7996,43842],[7996,43843],[7996,43844],
 [7996,43845],[7996,43846],[7996,43847],[7996,43848],[7996,43849],[7996,43850],
 [7996,43851],[7996,43852],[7996,43853],
 [7818,7821,7828,7839,7840,7841,8087,8094,8193,8400,8401,8402,8624,40287,40294,40305,40306,40307,
   40393,40404,40405,40406,40600,40601,40602,40810,40811,40824,45328,45339,45340,45341,45745,45746,
   45759,47330,47331,47344,50004,51940],[7818,7821,7828,7839,7840,7841,8087,8094,8193,8400,8401,
   8402,8624,40287,40294,40305,40306,40307,40393,40404,40405,40406,40600,40601,40602,40810,40811,
   40824,45328,45339,45340,45341,45745,45746,45759,47330,47331,47344,50004,51940],[],[],[],
 [],[],[],[],[],[],[],[],[],[7828,40824],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [7813,7828,7832,7842,7843,7850,7909,7913,8393,8403,8404,8411,8666,40109,40113,40593,40603,40604,
   40611,40866,42193,42203,42204,42211,42293,42294,42301,42449,42456,42466,49873,49874,49881,50029,
   50036,50046,50999,51006,51016,52181],[],[],[],[],[14514],[],
 [7813,7828,7832,7842,7843,7850,7909,7913,8393,8403,8404,8411,8666,40109,40113,40593,40603,40604,
   40611,40866,42193,42203,42204,42211,42293,42294,42301,42449,42456,42466,49873,49874,49881,50029,
   50036,50046,50999,51006,51016,52181],[],[],[],[],[],[],[14523,14565],[],[],
 [7828,50046],[],[],[],[7828,40870],
 [7818,7821,7828,7844,7845,7846,8087,8094,8193,8405,8406,8407,8670,40287,40294,40310,40311,40312,
   40393,40409,40410,40411,40605,40606,40607,40870,40871,40879,45328,45344,45345,45346,45805,45806,
   45814,47390,47391,47399,50050,52275],[],[],[],[],[],[19848,19857],[],
 [7818,7821,7828,7844,7845,7846,8087,8094,8193,8405,8406,8407,8670,40287,40294,40310,40311,40312,
   40393,40409,40410,40411,40605,40606,40607,40870,40871,40879,45328,45344,45345,45346,45805,45806,
   45814,47390,47391,47399,50050,52275],[],[],[],[],[],[],[19848,19857],[],[],
 [],[],[19862],[],[],[7813,7828,7832,7847,7848,7849,7909,7913,8393,8408,8409,8410,8695,
   40109,40113,40593,40608,40609,40610,40895,42193,42208,42209,42210,42298,42299,42300,42494,42495,
   42500,49878,49879,49880,50074,50075,50080,51044,51045,51050,52360],[7828,50075],[],[],
 [],[],[7813,7828,7832,7847,7848,7849,7909,7913,8393,8408,8409,8410,8695,40109,40113,40593,
   40608,40609,40610,40895,42193,42208,42209,42210,42298,42299,42300,42494,42495,42500,49878,49879,
   49880,50074,50075,50080,51044,51045,51050,52360],[],[],[],[],[14523,14565],[],[],
 [],[],[],[],[7818,7821,7828,7851,7852,7853,8087,8094,8193,8412,8413,8414,8714,40287,
   40294,40317,40318,40319,40393,40416,40417,40418,40612,40613,40614,40912,40913,40914,45328,45351,
   45352,45353,45847,45848,45849,47432,47433,47434,50094,52394],
 [7818,7821,7828,7851,7852,7853,8087,8094,8193,8412,8413,8414,8714,40287,40294,40317,40318,40319,
   40393,40416,40417,40418,40612,40613,40614,40912,40913,40914,45328,45351,45352,45353,45847,45848,
   45849,47432,47433,47434,50094,52394],[7828,40914],[],[8715],
 [202,268,328,8715,8962,10854,12747],[202,268,328,8715,8962,10854,12747],[8715],
 [202,268,328,8715,8962,10854,12747],[8715,12979],[8715,12979],[8715],[8715],[8715],
 [8715],[8715],[8715],[8715],[8715],[8715],[8715],[8715],[8715],[8715],[8715],
 [8715],[8715],[8715],[8715],[8715],[8715],[8715],[8715],[8715],[8715],[8715],
 [8715],[8715],[8715],[8715],[8715],[8715],[8715],[8715],[8715],[8715],[8715],
 [8715],[8715],[8715],[8715],[8715],[8715],[8715],[8715,14514],[8715,14523],[8715],
 [8715],[8715],[8715,14523],[8715,14514],[8715,14565],[8715,14565],[8715],[8715],
 [8715],[8715],[202,268,328,8715,8962,10854,12747],[202,268,328,8715,8962,10854,12747],
 [8715],[202,268,328,8715,8962,10854,12747],[8715,12979],[8715,12979],[8715],[8715],
 [8715],[8715],[8715],[8715],[8715],[8715],[8715],[8715],[8715],[8715],[8715],
 [8715],[8715],[8715],[8715],[8715],[8715],[8715],[8715],[8715],[8715],[8715],
 [8715],[8715],[8715],[8715],[8715],[8715],[8715],[8715],[8715],[8715],[8715],
 [8715],[8715],[8715],[8715],[8715],[8715],[8715],[8715],[8715,14514],[8715,14523],
 [8715],[8715],[8715],[8715,14523],[8715,14514],[8715,14565],[8715,14565],[8715],
 [8715],[8715],[202,393,8845,14579],[8962,14635],[8962,14635],[8962,14635],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [202,268,328,8715,8962,10854,12747],[202,569,9021,16465],[202,268,328,8715,8962,10854,12747],
 [202,569,9021,16465],[202,393,8845,14579],[202],[202],[202],[202],[202],[202],
 [202],[202],[202],[202],[202],[202,1336,9788,17232],[202,1377,9829,17273],[202],
 [202,1377,9829,17273],[202,1336,9788,17232],[202],[202],[202,1625,10077,17521],
 [202,1658,10110,17554],[202,1698,10150,17594],[202],[202,1761,10213,17657],[202],[202],
 [202],[202,1887,10339,17783],[202,1915,10367,17811],[202],[202,1658,10110,17554],[202],
 [202,1625,10077,17521],[202,2033,10485,17929],[202,1761,10213,17657],[202],
 [202,1698,10150,17594],[202],[202],[202],[202],[202,2033,10485,17929],
 [202,1887,10339,17783],[202,1915,10367,17811],[202,2215,10667,18111],[202,2224,10676,18120],
 [202,2224,10676,18120],[202,2215,10667,18111],[202,2254,10706,18150],[202,2262,10714,18158],
 [202,2268,10720,18164],[202,2270,10722,18166],[202,2254,10706,18150],[202,2270,10722,18166],
 [202,2262,10714,18158],[202,2268,10720,18164],[8962,14635],[],[8962],[8962],[8962],
 [8962],[8962],[8962],[8962],[8962],[8962],[8962],[8962],[8962],[8962],[8962],
 [8962],[8962],[8962],[8962],[8962],[8962],[8962],[8962],[8962],[8962],[8962],
 [8962],[8962],[8962],[8962],[8962],[8962],[8962],[8962],[8962],[8962],[8962],
 [8962],[8962],[8962],[8962],[8962],[8962],[8962],[8962],[8962],[8962],[8962],
 [8962,19848],[8962,19857],[8962,19862],[8962],[8962],[8962],[8962],[8962,19862],
 [8962,19848],[8962,19857],[8962,14635],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[8962],[8962],[8962],[8962],[8962],[8962],
 [8962],[8962],[8962],[8962],[8962],[8962],[8962],[8962],[8962],[8962],[8962],
 [8962],[8962],[8962],[8962],[8962],[8962],[8962],[8962],[8962],[8962],[8962],
 [8962],[8962],[8962],[8962],[8962],[8962],[8962],[8962],[8962],[8962],[8962],
 [8962],[8962],[8962],[8962],[8962],[8962],[8962],[8962],[8962,19848],[8962,19857],
 [8962,19862],[8962],[8962],[8962],[8962],[8962,19862],[8962,19848],[8962,19857],
 [8715,12979],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [26160],[26160],[],[26316],[26316],[],[],[26510],[26510],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[26160],[27643],[27643],[],[],[27841],[27841],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[28970],[],[28970],[],[29168],[],[29168],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [27643],[28970],[30394],[30394],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[26316],
 [31620],[],[31620],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[32797],[],[],[32797],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[30394],[31620],[32797],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[27841],[29168],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[26510],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[38205],[38205],[],[38331],[38331],[],[],
 [3507],[],[38557],[],[38557],[],[],[],[],[],[],[],[],[],[],[38921],
 [],[38921],[],[],[39015],[39015],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[38205],[39193],[39193],[],[39313],[39313],[],[39424],
 [39424],[],[],[],[],[],[],[],[5705],[],[],[39779],[],[39779],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [40055],[],[40055],[],[],[],[40287],[],[],[40287],[],[40450],[40450],[],
 [],[],[7828],[],[40642],[],[],[],[40642],[],[],[],[],[],[40824],
 [40824],[],[],[40870],[40870],[],[],[],[],[],[],[40914],[40914],[39193],
 [40055],[],[],[41069],[41069],[],[],[],[41239],[41239],[],[],[],[],
 [41411],[],[41411],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[38331],[],[],[41850],[],[41850],[],
 [],[],[],[],[42109],[42109],[],[42193],[],[],[],[42193],[],[],[],
 [42362],[42362],[],[],[],[],[42449],[42449],[],[],[],[42494],[42494],[],
 [],[],[],[],[],[],[42593],[],[],[],[42593],[42761],[],[42761],[],[],
 [],[42936],[],[],[],[],[],[42936],[],[43104],[],[43104],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[39313],[],[43330],[],[43330],
 [],[],[3756],[],[],[],[],[],[],[43685],[],[],[43685],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [44030],[44030],[],[],[],[],[],[],[],[],[],[],[],[44394],[44394],[],
 [],[],[8032],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[41069],[41850],[],[42593],[],[],[],[],[],[44904],[44904],[],[],[],
 [],[],[],[45084],[45084],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[39424],[43330],[40287],[],[],[],[],[],[45501],[],[],
 [45501],[],[],[],[],[],[],[],[],[45745],[45745],[],[],[],[45806],[],
 [45806],[],[],[],[],[45847],[45847],[],[44030],[38557],[],[],[],[],[],
 [46064],[],[],[],[],[46064],[],[],[46241],[],[46241],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[46593],
 [],[],[],[],[],[46593],[],[8168],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[47090],[],[],[],
 [],[],[],[47090],[47266],[],[],[47266],[47331],[],[47331],[],[],[],
 [47399],[47399],[],[],[],[],[47433],[],[47433],[41239],[42761],[],[],[],
 [47575],[47575],[],[],[],[],[],[],[6152],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[40450],[],[],[],[],[48035],[48035],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[48445],[],[],[],[],[48445],[],[],[],
 [6213],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[42109],
 [],[48796],[],[],[48796],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[49217],[49217],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[44904],[],[45501],[],[46064],[46593],[47090],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[47575],[41411],[48796],[42193],
 [],[42936],[],[],[],[],[],[],[],[],[50046],[],[],[],[50075],[],
 [50075],[50046],[],[],[],[48035],[],[],[4193],[48445],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[39779],[43685],
 [40642],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[49217],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[44394],[38921],[],[],[],[],[],[],[],[51006],
 [],[],[],[],[],[51050],[51050],[51006],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[45084],[46241],
 [47266],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[42362],
 [43104],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[39015],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[45745],[47331],[],[],[],[],
 [],[],[],[],[],[],[],[],[40824],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[42449],[],[],
 [],[],[8715,14514],[],[51006],[],[],[],[],[],[],[8715,14523],[],[],
 [50046],[],[],[],[40870],[45806],[],[],[],[],[],[8962,19848],[],[47399],
 [],[],[],[],[],[],[8962,19857],[],[],[],[],[8962,19862],[],[],
 [42494],[50075],[],[],[],[],[51050],[],[],[],[],[8715,14565],[],[],[],
 [],[],[],[45847],[47433],[40914],[8715],[202,268,328,8715,8962,10854,12747],
 [202,268,328,8715,8962,10854,12747],[8715],[202,268,328,8715,8962,10854,12747],[8715,12979],
 [8715,12979],[8715],[8715],[8715],[8715],[8715],[8715],[8715],[8715],[8715],
 [8715],[8715],[8715],[8715],[8715],[8715],[8715],[8715],[8715],[8715],[8715],
 [8715],[8715],[8715],[8715],[8715],[8715],[8715],[8715],[8715],[8715],[8715],
 [8715],[8715],[8715],[8715],[8715],[8715],[8715],[8715],[8715],[8715],[8715],
 [8715],[8715,14514],[8715,14523],[8715],[8715],[8715],[8715,14523],[8715,14514],
 [8715,14565],[8715,14565],[8715],[8715],[8715],[10854,14635],[10854,14635],
 [10854,14635],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[10854,14635],[202,268,328,8715,8962,10854,12747],[10854],[10854],
 [10854],[10854],[10854],[10854],[10854],[10854],[10854],[10854],[10854],[10854],
 [10854],[10854],[10854],[10854],[10854],[10854],[10854],[10854],[10854],[10854],
 [10854],[10854],[10854],[10854],[10854],[10854],[10854],[10854],[10854],[10854],
 [10854],[10854],[10854],[10854],[10854],[10854],[10854],[10854],[10854],[10854],
 [10854],[10854],[10854],[10854],[10854],[10854,19848],[10854,19857],[10854,19862],
 [10854],[10854],[10854],[10854],[10854,19862],[10854,19848],[10854,19857],[10854,14635],
 [202,268,328,8715,8962,10854,12747],[10854],[10854],[10854],[10854],[10854],[10854],
 [10854],[10854],[10854],[10854],[10854],[10854],[10854],[10854],[10854],[10854],
 [10854],[10854],[10854],[10854],[10854],[10854],[10854],[10854],[10854],[10854],
 [10854],[10854],[10854],[10854],[10854],[10854],[10854],[10854],[10854],[10854],
 [10854],[10854],[10854],[10854],[10854],[10854],[10854],[10854],[10854],[10854],
 [10854],[10854,19848],[10854,19857],[10854,19862],[10854],[10854],[10854],[10854],
 [10854,19862],[10854,19848],[10854,19857],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[8715,12979],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[26160],[26160],[],[26316],[26316],[],[],
 [26510],[26510],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[26160],[27643],[27643],[],[],
 [27841],[27841],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[28970],[],[28970],[],
 [29168],[],[29168],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[27643],[28970],[30394],[30394],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[26316],[31620],[],[31620],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[32797],[],[],[32797],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [30394],[31620],[32797],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[27841],[29168],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[26510],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[38205],[38205],[],[38331],[38331],[],[],[3507],[],[38557],[],
 [38557],[],[],[],[],[],[],[],[],[],[],[38921],[],[38921],[],[],
 [39015],[39015],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [38205],[39193],[39193],[],[39313],[39313],[],[39424],[39424],[],[],[],[],
 [],[],[],[5705],[],[],[39779],[],[39779],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[40055],[],[40055],[],
 [],[],[40287],[],[],[40287],[],[40450],[40450],[],[],[],[7828],[],
 [40642],[],[],[],[40642],[],[],[],[],[],[40824],[40824],[],[],[40870],
 [40870],[],[],[],[],[],[],[40914],[40914],[39193],[40055],[],[],[41069],
 [41069],[],[],[],[41239],[41239],[],[],[],[],[41411],[],[41411],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[38331],[],[],[41850],[],[41850],[],[],[],[],[],[42109],[42109],
 [],[42193],[],[],[],[42193],[],[],[],[42362],[42362],[],[],[],[],
 [42449],[42449],[],[],[],[42494],[42494],[],[],[],[],[],[],[],[42593],
 [],[],[],[42593],[42761],[],[42761],[],[],[],[42936],[],[],[],[],[],
 [42936],[],[43104],[],[43104],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[39313],[],[43330],[],[43330],[],[],[3756],[],[],[],[],
 [],[],[43685],[],[],[43685],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[44030],[44030],[],[],[],[],
 [],[],[],[],[],[],[],[44394],[44394],[],[],[],[8032],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[41069],[41850],[],[42593],
 [],[],[],[],[],[44904],[44904],[],[],[],[],[],[],[45084],[45084],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[39424],
 [43330],[40287],[],[],[],[],[],[45501],[],[],[45501],[],[],[],[],[],
 [],[],[],[45745],[45745],[],[],[],[45806],[],[45806],[],[],[],[],
 [45847],[45847],[],[44030],[38557],[],[],[],[],[],[46064],[],[],[],[],
 [46064],[],[],[46241],[],[46241],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[46593],[],[],[],[],[],
 [46593],[],[8168],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[47090],[],[],[],[],[],[],[47090],
 [47266],[],[],[47266],[47331],[],[47331],[],[],[],[47399],[47399],[],[],
 [],[],[47433],[],[47433],[41239],[42761],[],[],[],[47575],[47575],[],[],
 [],[],[],[],[6152],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[40450],[],[],[],[],[48035],[48035],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[48445],[],[],[],[],[48445],[],[],[],[6213],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[42109],[],[48796],[],[],
 [48796],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[49217],[49217],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[44904],[],
 [45501],[],[46064],[46593],[47090],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[47575],[41411],[48796],[42193],[],[42936],[],
 [],[],[],[],[],[],[],[50046],[],[],[],[50075],[],[50075],[50046],[],
 [],[],[48035],[],[],[4193],[48445],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[39779],[43685],[40642],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[49217],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[44394],[38921],[],[],[],[],[],[],[],[51006],[],[],[],[],[],
 [51050],[51050],[51006],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[45084],[46241],[47266],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[42362],[43104],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[39015],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[45745],[47331],[],[],[],[],[],[],[],[],[],
 [],[],[],[40824],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[42449],[],[],[],[],[8715,14514],
 [],[51006],[],[],[],[],[],[],[8715,14523],[],[],[50046],[],[],[],
 [40870],[45806],[],[],[],[],[],[10854,19848],[],[47399],[],[],[],[],
 [],[],[10854,19857],[],[],[],[],[10854,19862],[],[],[42494],[50075],[],
 [],[],[],[51050],[],[],[],[],[8715,14565],[],[],[],[],[],[],
 [45847],[47433],[40914],[12747],[14635],[14635],[12747],[12979],[12979],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[14514],[14523],[],[],[],[14523],[14514],[14565],[14565],[],[],
 [],[202,268,328,8715,8962,10854,12747],[12747],[],[12747,12979],[12747,12979],[12747],
 [12747],[12747],[12747],[12747],[12747],[12747],[12747],[12747],[12747],[12747],
 [12747],[12747],[12747],[12747],[12747],[12747],[12747],[12747],[12747],[12747],
 [12747],[12747],[12747],[12747],[12747],[12747],[12747],[12747],[12747],[12747],
 [12747],[12747],[12747],[12747],[12747],[12747],[12747],[12747],[12747],[12747],
 [12747],[12747],[12747,14514],[12747,14523],[12747],[12747],[12747],[12747,14523],
 [12747,14514],[12747,14565],[12747,14565],[12747],[12747],[12747],[14635],
 [202,268,328,8715,8962,10854,12747],[12979],[12979],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[14514],
 [14523],[19848],[19857],[19862],[14523],[14514],[14565],[14565],[19862],[19848],
 [19857],[12747],[12979],[12979],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[14514],[14523],[],[],[],
 [14523],[14514],[14565],[14565],[],[],[],[12747,12979],[12747,12979],[12747],
 [12747],[12747],[12747],[12747],[12747],[12747],[12747],[12747],[12747],[12747],
 [12747],[12747],[12747],[12747],[12747],[12747],[12747],[12747],[12747],[12747],
 [12747],[12747],[12747],[12747],[12747],[12747],[12747],[12747],[12747],[12747],
 [12747],[12747],[12747],[12747],[12747],[12747],[12747],[12747],[12747],[12747],
 [12747],[12747],[12747,14514],[12747,14523],[12747],[12747],[12747],[12747,14523],
 [12747,14514],[12747,14565],[12747,14565],[12747],[12747],[12747],[],[12979],[12979],
 [12979],[12979],[12979],[12979],[12979],[12979],[12979],[12979],[12979],[12979],
 [12979],[12979],[12979],[12979],[12979],[12979],[12979],[12979],[12979],[12979],
 [12979],[12979],[12979],[12979],[12979],[12979],[12979],[12979],[12979],[12979],
 [12979],[12979],[12979],[12979],[12979],[12979],[12979],[12979],[12979],[12979],
 [12979],[12979,14514],[12979,14523],[12979],[12979],[12979],[12979,14523],[12979,14514],
 [12979,14565],[12979,14565],[12979],[12979],[12979],[12979],[12979],[12979],[12979],
 [12979],[12979],[12979],[12979],[12979],[12979],[12979],[12979],[12979],[12979],
 [12979],[12979],[12979],[12979],[12979],[12979],[12979],[12979],[12979],[12979],
 [12979],[12979],[12979],[12979],[12979],[12979],[12979],[12979],[12979],[12979],
 [12979],[12979],[12979],[12979],[12979],[12979],[12979],[12979],[12979],[12979,14514],
 [12979,14523],[12979],[12979],[12979],[12979,14523],[12979,14514],[12979,14565],
 [12979,14565],[12979],[12979],[12979],[26160],[26160],[],[26316],[26316],[],[],
 [26510],[26510],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [14514],[14523],[],[],[],[14523],[14514],[14565],[14565],[],[],[],[26160],
 [27643],[27643],[],[],[27841],[27841],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[14514],[14523],[],[],[],[14523],[14514],[14565],[14565],
 [],[],[],[28970],[],[28970],[],[29168],[],[29168],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[14514],[14523],[],[],[],[14523],[14514],
 [14565],[14565],[],[],[],[27643],[28970],[30394],[30394],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[14514],[14523],[],[],[],
 [14523],[14514],[14565],[14565],[],[],[],[26316],[31620],[],[31620],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[14514],[14523],[],[],
 [],[14523],[14514],[14565],[14565],[],[],[],[32797],[],[],[32797],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[14514],[14523],[],[],[],
 [14523],[14514],[14565],[14565],[],[],[],[30394],[31620],[32797],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[14514],[14523],[],[],[],
 [14523],[14514],[14565],[14565],[],[],[],[27841],[29168],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[14514],[14523],[],[],[],[14523],[14514],
 [14565],[14565],[],[],[],[26510],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[14514],[14523],[],[],[],[14523],[14514],[14565],[14565],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[14514],
 [14523],[],[],[],[14523],[14514],[14565],[14565],[],[],[],[38205],[38205],
 [],[38331],[38331],[],[],[3507],[],[38557],[],[38557],[],[],[],[],[],
 [],[],[],[],[],[38921],[],[38921],[],[],[39015],[39015],[],[],[],
 [14514],[14523],[],[],[],[14523],[14514],[14565],[14565],[],[],[],[38205],
 [39193],[39193],[],[39313],[39313],[],[39424],[39424],[],[],[],[],[],[],
 [],[5705],[],[],[39779],[],[39779],[],[],[],[],[],[],[],[],[],
 [14514],[14523],[],[],[],[14523],[14514],[14565],[14565],[],[],[],[40055],
 [],[40055],[],[],[],[40287],[],[],[40287],[],[40450],[40450],[],[],[],
 [7828],[],[40642],[],[],[],[40642],[],[],[],[],[],[40824],[40824],
 [14514],[14523],[40870],[40870],[],[14523],[14514],[14565],[14565],[],[40914],
 [40914],[39193],[40055],[],[],[41069],[41069],[],[],[],[41239],[41239],[],
 [],[],[],[41411],[],[41411],[],[],[],[],[],[],[],[],[],[],[],
 [14514],[14523],[],[],[],[14523],[14514],[14565],[14565],[],[],[],[38331],
 [],[],[41850],[],[41850],[],[],[],[],[],[42109],[42109],[],[42193],[],
 [],[],[42193],[],[],[],[42362],[42362],[],[],[],[],
 [14514,14523,42449,42494],[14514,14523,42449,42494],[],[],[],[14514,14523,42449,42494],
 [14514,14523,42449,42494],[14565],[14565],[],[],[],[],[],[42593],[],[],[],
 [42593],[42761],[],[42761],[],[],[],[42936],[],[],[],[],[],[42936],[],
 [43104],[],[43104],[],[],[],[14514],[14523],[],[],[],[14523],[14514],
 [14565],[14565],[],[],[],[39313],[],[43330],[],[43330],[],[],[3756],[],
 [],[],[],[],[],[43685],[],[],[43685],[],[],[],[],[],[],[],[],
 [14514],[14523],[],[],[],[14523],[14514],[14565],[14565],[],[],[],[],[],
 [44030],[44030],[],[],[],[],[],[13796,13806],[],[],[],[],[],[44394],
 [44394],[],[],[],[8032],[],[],[],[],[14514],[14523],[],[],[],[14523],
 [14514],[14565],[14565],[],[],[],[41069],[41850],[],[42593],[],[],[],[],
 [],[44904],[44904],[],[],[],[],[],[],[45084],[45084],[],[],[],[],[],
 [14514],[14523],[],[],[],[14523],[14514],[14565],[14565],[],[],[],[39424],
 [43330],[40287],[],[],[],[],[],[45501],[],[],[45501],[],[],[],[],[],
 [],[],[],[45745],[45745],[],[14514],[14523],[45806],[],[45806],[14523],
 [14514],[14565],[14565],[45847],[45847],[],[44030],[38557],[],[],[],[],[],
 [46064],[],[],[],[],[46064],[],[],[46241],[],[46241],[],[],[],[],
 [14514],[14523],[],[],[],[14523],[14514],[14565],[14565],[],[],[],[],[],
 [],[],[],[],[46593],[],[],[],[],[],[46593],[],[8168],[],[],[],[],
 [],[],[14514],[14523],[],[],[],[14523],[14514],[14565],[14565],[],[],[],
 [],[],[],[],[],[47090],[],[],[],[],[],[],[47090],[47266],[],[],
 [47266],[47331],[],[47331],[14514],[14523],[],[47399],[47399],[14523],[14514],
 [14565],[14565],[47433],[],[47433],[41239],[42761],[13982,13985],[],[],[47575],
 [47575],[],[],[],[],[],[],[6152],[],[],[],[],[],[14514],[14523],[],
 [],[],[14523],[14514],[14565],[14565],[],[],[],[40450],[],[],[],[],
 [48035],[48035],[],[],[],[],[],[],[],[],[],[],[],[14514],[14523],[],
 [],[],[14523],[14514],[14565],[14565],[],[],[],[],[],[],[],[48445],[],
 [],[],[],[48445],[],[],[],[6213],[],[],[],[14514],[14523],[],[],[],
 [14523],[14514],[14565],[14565],[],[],[],[42109],[],[48796],[],[],[48796],
 [],[],[],[],[14173,14304],[],[],[],[],[],[14514],[14523],[],[],[],
 [14523],[14514],[14565],[14565],[],[],[],[],[],[],[],[49217],[49217],[],
 [],[],[],[14200,14305],[],[],[],[],[14514],[14523],[],[],[],[14523],
 [14514],[14565],[14565],[],[],[],[44904],[],[45501],[],[46064],[46593],
 [47090],[],[],[],[],[],[],[],[14514],[14523],[],[],[],[14523],[14514],
 [14565],[14565],[],[],[],[47575],[41411],[48796],[42193],[],[42936],[],[],
 [],[],[],[],[],[14514],[14523,14565,50046,50075],[],[],[],
 [14523,14565,50046,50075],[14514],[14523,14565,50046,50075],[14523,14565,50046,50075],[],
 [],[],[48035],[13989,13991],[],[4193],[48445],[],[],[],[],[],[],[],
 [14514],[14523],[],[],[],[14523],[14514],[14565],[14565],[],[],[],[],
 [39779],[43685],[40642],[],[],[],[],[],[],[],[14514],[14523],[],[],[],
 [14523],[14514],[14565],[14565],[],[],[],[49217],[13811,13813],[],[],[],[],
 [],[],[],[],[14514],[14523],[],[],[],[14523],[14514],[14565],[14565],[],
 [],[],[44394],[38921],[],[],[],[],[],[],[],[14514,14565,51006,51050],
 [14523],[],[],[],[14523],[14514,14565,51006,51050],[14514,14565,51006,51050],
 [14514,14565,51006,51050],[],[],[],[],[],[],[],[],[],[],[],[14514],
 [14523],[],[],[],[14523],[14514],[14565],[14565],[],[],[],[],[],[],[],
 [],[],[],[14514],[14523],[],[],[],[14523],[14514],[14565],[14565],[],[],
 [],[45084],[46241],[47266],[],[],[],[14514],[14523],[],[],[],[14523],
 [14514],[14565],[14565],[],[],[],[42362],[43104],[],[],[],[14514],[14523],
 [],[],[],[14523],[14514],[14565],[14565],[],[],[],[39015],[],[],[],
 [14514],[14523],[],[],[],[14523],[14514],[14565],[14565],[],[],[],[],[],
 [],[14514],[14523],[],[],[],[14523],[14514],[14565],[14565],[],[],[],
 [45745],[47331],[14514],[14523],[],[],[],[14523],[14514],[14565],[14565],[],
 [],[],[40824],[14514],[14523],[],[],[],[14523],[14514],[14565],[14565],[],
 [],[],[14514],[14523],[],[],[],[14523],[14514],[14565],[14565],[],[],[],
 [14514,14523,42449,42494],[14514],[14514],[14514],[14514,14523,42449,42494],[],
 [14514,14565,51006,51050],[14514,14565,51006,51050],[14514],[14514],[14514],[14523],
 [14523],[14523],[],[14514,14523,42449,42494],[14523,14565,50046,50075],
 [14523,14565,50046,50075],[14523],[14523],[14523],[40870],[45806],[14523],[14514],
 [14565],[14565],[],[19848],[],[47399],[14523],[14514],[14565],[14565],[],[],
 [19857],[14523],[14514],[14565],[14565],[19862],[],[],[14514,14523,42449,42494],
 [14523,14565,50046,50075],[14523,14565,50046,50075],[14523],[14523],[14523],
 [14514,14565,51006,51050],[14514,14565,51006,51050],[14514],[14514],[14514],[],[14565],
 [14565],[14565],[14565],[14565],[14565],[45847],[47433],[40914],[10854,14635],
 [10854,14635],[12747],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[8962,14635],[14635],[14635],[14635],[14635],[14635],
 [14635],[14635],[14635],[14635],[14635],[14635],[14635],[14635],[14635],[14635],
 [14635],[14635],[14635],[14635],[14635],[14635],[14635],[14635],[14635],[14635],
 [14635],[14635],[14635],[14635],[14635],[14635],[14635],[14635],[14635],[14635],
 [14635],[14635],[14635],[14635],[14635],[14635],[14635],[14635],[14635],[14635],
 [14635],[14635],[14635,19848],[14635,19857],[14635,19862],[14635],[14635],[14635],
 [14635],[14635,19862],[14635,19848],[14635,19857],[8962,14635],[14635],[14635],[14635],
 [14635],[14635],[14635],[14635],[14635],[14635],[14635],[14635],[14635],[14635],
 [14635],[14635],[14635],[14635],[14635],[14635],[14635],[14635],[14635],[14635],
 [14635],[14635],[14635],[14635],[14635],[14635],[14635],[14635],[14635],[14635],
 [14635],[14635],[14635],[14635],[14635],[14635],[14635],[14635],[14635],[14635],
 [14635],[14635],[14635],[14635],[14635,19848],[14635,19857],[14635,19862],[14635],
 [14635],[14635],[14635],[14635,19862],[14635,19848],[14635,19857],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[12979],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[26160],[26160],[],
 [26316],[26316],[],[],[26510],[26510],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[26160],
 [27643],[27643],[],[],[27841],[27841],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[28970],
 [],[28970],[],[29168],[],[29168],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[27643],
 [28970],[30394],[30394],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[26316],[31620],
 [],[31620],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[32797],[],[],[32797],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[30394],[31620],[32797],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [27841],[29168],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[26510],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[38205],[38205],[],[38331],[38331],[],[],
 [3507],[],[38557],[],[38557],[],[],[],[],[],[],[],[],[],[],[38921],
 [],[38921],[],[],[39015],[39015],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[38205],[39193],[39193],[],[39313],[39313],[],[39424],
 [39424],[],[],[],[],[],[],[],[5705],[],[],[39779],[],[39779],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [40055],[],[40055],[],[],[],[40287],[],[],[40287],[],[40450],[40450],[],
 [],[],[7828],[],[40642],[],[],[],[40642],[],[],[],[],[],[40824],
 [40824],[],[],[40870],[40870],[],[],[],[],[],[],[40914],[40914],[39193],
 [40055],[],[],[41069],[41069],[],[],[],[41239],[41239],[],[],[],[],
 [41411],[],[41411],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[38331],[],[],[41850],[],[41850],[],
 [],[],[],[],[42109],[42109],[],[6842,6859,7813,7828,7832,7909,7913,8393,15518,40109,
   40113,40593,42193],[],[],[],[6842,6859,7813,7828,7832,7909,7913,8393,15518,40109,40113,
   40593,42193],[],[],[],[42362],[42362],[],[],[],[],[42449],[42449],[],
 [],[],[42494],[42494],[],[],[],[],[],[],[],[42593],[],[],[],[42593],
 [42761],[],[42761],[],[],[],[42936],[],[],[],[],[],[42936],[],[43104],
 [],[43104],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [39313],[],[43330],[],[43330],[],[],[3756],[],[],[],[],[],[],[43685],
 [],[],[43685],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[44030],[44030],[],[],[],[],[],[],[],[],
 [],[],[],[44394],[44394],[],[],[],[8032],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[41069],[41850],[],[42593],[],[],[],[],
 [],[44904],[44904],[],[],[],[],[],[],[45084],[45084],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[39424],[43330],[40287],[],
 [],[],[],[],[45501],[],[],[45501],[],[],[],[],[],[],[],[],
 [45745],[45745],[],[],[],[45806],[],[45806],[],[],[],[],[45847],[45847],
 [],[44030],[38557],[],[],[],[],[],[46064],[],[],[],[],[46064],[],[],
 [46241],[],[46241],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[46593],[],[],[],[],[],[46593],[],[8168],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[47090],[],[],[],[],[],[],[47090],[47266],[],[],[47266],
 [47331],[],[47331],[],[],[],[47399],[47399],[],[],[],[],[47433],[],
 [47433],[41239],[42761],[],[],[],[47575],[47575],[],[],[],[],[],[],
 [6152],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [40450],[],[],[],[],[48035],[48035],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [48445],[],[],[],[],[48445],[],[],[],[6213],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[42109],[],[48796],[],[],[48796],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[16377,49091],[16377,49091],[],
 [],[],[],[],[],[],[],[],[],[49217],[49217],[],[],[],[],[],[],
 [],[],[],[16341,49406],[],[],[16341,49406],[],[],[],[],[],[],[],[],
 [44904],[],[45501],[],[46064],[46593],[47090],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[47575],[41411],[48796],
 [6842,6859,7813,7828,7832,7909,7913,8393,15518,40109,40113,40593,42193],[],[42936],[],[],
 [],[],[],[],[],[],[50046],[],[],[],[50075],[],[50075],[50046],[],[],
 [],[48035],[],[],[4193],[48445],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[39779],[43685],[40642],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[49217],[],[],
 [],[],[],[],[],[],[],[],[],[16365,50815],[],[],[],[],[],
 [16365,50815],[],[],[],[44394],[38921],[],[],[],[],[],[],[],[51006],
 [],[],[],[],[],[51050],[51050],[51006],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[45084],[46241],
 [47266],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[42362],
 [43104],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[39015],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[45745],[47331],[],[],[],[],
 [],[],[],[],[],[],[],[],[40824],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[42449],[],[],
 [],[],[14514],[],[51006],[],[],[],[],[],[],[14523],[],[],[50046],[],
 [],[],[40870],[45806],[],[],[],[],[],[14635,19848],[],[47399],[],[],
 [],[],[],[],[14635,19857],[],[],[],[],[14635,19862],[],[],[42494],
 [50075],[],[],[],[],[51050],[],[],[],[],[14565],[],[],[],[],[],
 [],[45847],[47433],[40914],[10854,14635],[202,268,328,8715,8962,10854,12747],[10854],
 [10854],[10854],[10854],[10854],[10854],[10854],[10854],[10854],[10854],[10854],
 [10854],[10854],[10854],[10854],[10854],[10854],[10854],[10854],[10854],[10854],
 [10854],[10854],[10854],[10854],[10854],[10854],[10854],[10854],[10854],[10854],
 [10854],[10854],[10854],[10854],[10854],[10854],[10854],[10854],[10854],[10854],
 [10854],[10854],[10854],[10854],[10854],[10854],[10854,19848],[10854,19857],
 [10854,19862],[10854],[10854],[10854],[10854],[10854,19862],[10854,19848],[10854,19857],
 [12747],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[12747,12979],[12747,12979],[12747],[12747],[12747],[12747],[12747],[12747],
 [12747],[12747],[12747],[12747],[12747],[12747],[12747],[12747],[12747],[12747],
 [12747],[12747],[12747],[12747],[12747],[12747],[12747],[12747],[12747],[12747],
 [12747],[12747],[12747],[12747],[12747],[12747],[12747],[12747],[12747],[12747],
 [12747],[12747],[12747],[12747],[12747],[12747],[12747],[12747,14514],[12747,14523],
 [12747],[12747],[12747],[12747,14523],[12747,14514],[12747,14565],[12747,14565],[12747],
 [12747],[12747],[12747,12979],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[26160],[26160],[],[26316],[26316],[],[],[26510],[26510],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[26160],[27643],[27643],[],[],[27841],[27841],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[28970],[],[28970],[],[29168],[],[29168],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[27643],[28970],[30394],[30394],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [26316],[31620],[],[31620],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[32797],[],[],
 [32797],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[30394],[31620],[32797],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[27841],[29168],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[26510],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[38205],[38205],[],[38331],[38331],
 [],[],[3507],[],[38557],[],[38557],[],[],[],[],[],[],[],[],[],[],
 [38921],[],[38921],[],[],[39015],[39015],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[38205],[39193],[39193],[],[39313],[39313],[],[39424],
 [39424],[],[],[],[],[],[],[],[5705],[],[],[39779],[],[39779],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [40055],[],[40055],[],[],[],[40287],[],[],[40287],[],[40450],[40450],[],
 [],[],[7828],[],[40642],[],[],[],[40642],[],[],[],[],[],[40824],
 [40824],[],[],[40870],[40870],[],[],[],[],[],[],[40914],[40914],[39193],
 [40055],[],[],[41069],[41069],[],[],[],[41239],[41239],[],[],[],[],
 [41411],[],[41411],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[38331],[],[],[41850],[],[41850],[],
 [],[],[],[],[42109],[42109],[],[42193],[],[],[],[42193],[],[],[],
 [42362],[42362],[],[],[],[],[42449],[42449],[],[],[],[42494],[42494],[],
 [],[],[],[],[],[],[42593],[],[],[],[42593],[42761],[],[42761],[],[],
 [],[42936],[],[],[],[],[],[42936],[],[43104],[],[43104],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[39313],[],[43330],[],[43330],
 [],[],[3756],[],[],[],[],[],[],[43685],[],[],[43685],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [44030],[44030],[],[],[],[],[],[],[],[],[],[],[],[44394],[44394],[],
 [],[],[8032],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[41069],[41850],[],[42593],[],[],[],[],[],[44904],[44904],[],[],[],
 [],[],[],[45084],[45084],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[39424],[43330],[40287],[],[],[],[],[],[45501],[],[],
 [45501],[],[],[],[],[],[],[],[],[45745],[45745],[],[],[],[45806],[],
 [45806],[],[],[],[],[45847],[45847],[],[44030],[38557],[],[],[],[],[],
 [46064],[],[],[],[],[46064],[],[],[46241],[],[46241],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[46593],
 [],[],[],[],[],[46593],[],[8168],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[47090],[],[],[],
 [],[],[],[47090],[47266],[],[],[47266],[47331],[],[47331],[],[],[],
 [47399],[47399],[],[],[],[],[47433],[],[47433],[41239],[42761],[],[],[],
 [47575],[47575],[],[],[],[],[],[],[6152],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[40450],[],[],[],[],[48035],[48035],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[48445],[],[],[],[],[48445],[],[],[],
 [6213],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[42109],
 [],[48796],[],[],[48796],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[49217],[49217],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[44904],[],[45501],[],[46064],[46593],[47090],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[47575],[41411],[48796],[42193],
 [],[42936],[],[],[],[],[],[],[],[],[50046],[],[],[],[50075],[],
 [50075],[50046],[],[],[],[48035],[],[],[4193],[48445],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[39779],[43685],
 [40642],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[49217],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[44394],[38921],[],[],[],[],[],[],[],[51006],
 [],[],[],[],[],[51050],[51050],[51006],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[45084],[46241],
 [47266],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[42362],
 [43104],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[39015],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[45745],[47331],[],[],[],[],
 [],[],[],[],[],[],[],[],[40824],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[42449],[],[],
 [],[],[12747,14514],[],[51006],[],[],[],[],[],[],[12747,14523],[],[],
 [50046],[],[],[],[40870],[45806],[],[],[],[],[],[10854,19848],[],[47399],
 [],[],[],[],[],[],[10854,19857],[],[],[],[],[10854,19862],[],[],
 [42494],[50075],[],[],[],[],[51050],[],[],[],[],[12747,14565],[],[],
 [],[],[],[],[45847],[47433],[40914],[8962,14635],[14635],[14635],[14635],
 [14635],[14635],[14635],[14635],[14635],[14635],[14635],[14635],[14635],[14635],
 [14635],[14635],[14635],[14635],[14635],[14635],[14635],[14635],[14635],[14635],
 [14635],[14635],[14635],[14635],[14635],[14635],[14635],[14635],[14635],[14635],
 [14635],[14635],[14635],[14635],[14635],[14635],[14635],[14635],[14635],[14635],
 [14635],[14635],[14635],[14635],[14635,19848],[14635,19857],[14635,19862],[14635],
 [14635],[14635],[14635],[14635,19862],[14635,19848],[14635,19857],[8962],[8962],
 [8962],[8962],[8962],[8962],[8962],[8962],[8962],[8962],[8962],[8962],[8962],
 [8962],[8962],[8962],[8962],[8962],[8962],[8962],[8962],[8962],[8962],[8962],
 [8962],[8962],[8962],[8962],[8962],[8962],[8962],[8962],[8962],[8962],[8962],
 [8962],[8962],[8962],[8962],[8962],[8962],[8962],[8962],[8962],[8962],[8962],
 [8962],[8962,19848],[8962,19857],[8962,19862],[8962],[8962],[8962],[8962],
 [8962,19862],[8962,19848],[8962,19857],[12979],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[19848],
 [19857],[19862],[],[],[],[],[19862],[19848],[19857],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[19848],[19857],[19862],[],[],[],[],[19862],[19848],[19857],[26160],
 [26160],[],[26316],[26316],[],[],[26510],[26510],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[19848],[19857],[19862],[],[],[],[],
 [19862],[19848],[19857],[26160],[27643],[27643],[],[],[27841],[27841],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[19848],[19857],
 [19862],[],[],[],[],[19862],[19848],[19857],[28970],[],[28970],[],[29168],
 [],[29168],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [19848],[19857],[19862],[],[],[],[],[19862],[19848],[19857],[27643],[28970],
 [30394],[30394],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[19848],[19857],[19862],[],[],[],[],[19862],[19848],[19857],
 [26316],[31620],[],[31620],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[19848],[19857],[19862],[],[],[],[],[19862],[19848],
 [19857],[32797],[],[],[32797],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[19848],[19857],[19862],[],[],[],[],[19862],[19848],
 [19857],[30394],[31620],[32797],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[19848],[19857],[19862],[],[],[],[],[19862],[19848],[19857],
 [27841],[29168],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[19848],[19857],[19862],[],[],[],[],[19862],[19848],[19857],[26510],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[19848],[19857],
 [19862],[],[],[],[],[19862],[19848],[19857],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[19848],[19857],[19862],[],[],[],[],[19862],
 [19848],[19857],[38205],[38205],[],[38331],[38331],[],[],[3507],[],[38557],
 [],[38557],[],[],[],[],[],[],[],[],[],[],[38921],[],[38921],[],
 [],[39015],[39015],[],[],[],[],[],[19848],[19857],[19862],[],[],[],[],
 [19862],[19848],[19857],[38205],[39193],[39193],[],[39313],[39313],[],[39424],
 [39424],[],[],[],[],[],[],[],[5705],[],[],[39779],[],[39779],[],[],
 [],[],[],[],[],[],[],[],[],[19848],[19857],[19862],[],[],[],[],
 [19862],[19848],[19857],[40055],[],[40055],[],[],[],[40287],[],[],[40287],
 [],[40450],[40450],[],[],[],[7828],[],[40642],[],[],[],[40642],[],[],
 [],[],[],[40824],[40824],[],[],[19848,19857,40870,40914],[19848,19857,40870,40914],
 [19862],[],[],[],[],[19862],[19848,19857,40870,40914],[19848,19857,40870,40914],
 [39193],[40055],[],[],[41069],[41069],[],[],[],[41239],[41239],[],[],[],
 [],[41411],[],[41411],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [19848],[19857],[19862],[],[],[],[],[19862],[19848],[19857],[38331],[],[],
 [41850],[],[41850],[],[],[],[],[],[42109],[42109],[],[42193],[],[],[],
 [42193],[],[],[],[42362],[42362],[],[],[],[],[42449],[42449],[19848],
 [19857],[19862],[42494],[42494],[],[],[19862],[19848],[19857],[],[],[42593],
 [],[],[],[42593],[42761],[],[42761],[],[],[],[42936],[],[],[],[],[],
 [42936],[],[43104],[],[43104],[],[],[],[],[],[19848],[19857],[19862],[],
 [],[],[],[19862],[19848],[19857],[39313],[],[43330],[],[43330],[],[],
 [3756],[],[],[],[],[],[],[43685],[],[],[43685],[],[],[],[],[],[],
 [19106,19131],[],[],[],[19848],[19857],[19862],[],[],[],[],[19862],[19848],
 [19857],[],[],[44030],[44030],[],[],[],[],[],[],[],[],[],[],[],
 [44394],[44394],[],[],[],[8032],[],[],[],[],[],[],[19848],[19857],
 [19862],[],[],[],[],[19862],[19848],[19857],[41069],[41850],[],[42593],[],
 [],[],[],[],[44904],[44904],[],[],[],[],[],[],[45084],[45084],[],[],
 [],[],[],[],[],[19848],[19857],[19862],[],[],[],[],[19862],[19848],
 [19857],[39424],[43330],[40287],[],[],[],[],[],[45501],[],[],[45501],[],
 [],[],[],[],[],[],[],[45745],[45745],[],[],[],[19848,19862,45806,45847],
 [19857],[19848,19862,45806,45847],[],[],[],[],[19848,19862,45806,45847],
 [19848,19862,45806,45847],[19857],[44030],[38557],[],[],[],[],[],[46064],[],
 [],[],[],[46064],[],[],[46241],[],[46241],[],[],[],[],[],[],[19848],
 [19857],[19862],[],[],[],[],[19862],[19848],[19857],[],[],[],[],[],[],
 [46593],[],[],[],[],[],[46593],[],[8168],[],[],[],[19111,19130],[],[],
 [],[],[19848],[19857],[19862],[],[],[],[],[19862],[19848],[19857],[],[],
 [],[],[],[47090],[],[],[],[],[],[],[47090],[47266],[],[],[47266],
 [47331],[],[47331],[],[],[19848],[19857,19862,47399,47433],[19857,19862,47399,47433],
 [],[],[],[],[19857,19862,47399,47433],[19848],[19857,19862,47399,47433],[41239],
 [42761],[],[],[],[47575],[47575],[],[],[],[],[],[],[6152],[],[],[],
 [],[],[],[],[19848],[19857],[19862],[],[],[],[],[19862],[19848],[19857],
 [40450],[],[],[],[],[48035],[48035],[],[],[],[],[],[],[],[],[],
 [19294,19311],[],[],[],[19848],[19857],[19862],[],[],[],[],[19862],[19848],
 [19857],[],[],[],[],[48445],[],[],[],[],[48445],[],[],[],[6213],[],
 [],[19295,19312],[],[],[19848],[19857],[19862],[],[],[],[],[19862],[19848],
 [19857],[42109],[],[48796],[],[],[48796],[],[],[],[],[],[],[],[],[],
 [],[],[],[19848],[19857],[19862],[],[],[],[],[19862],[19848],[19857],[],
 [],[],[],[49217],[49217],[],[],[],[],[],[],[],[],[],[],[],
 [19848],[19857],[19862],[],[],[],[],[19862],[19848],[19857],[44904],[],
 [45501],[],[46064],[46593],[47090],[],[],[],[],[],[],[],[],[],[19848],
 [19857],[19862],[],[],[],[],[19862],[19848],[19857],[47575],[41411],[48796],
 [42193],[],[42936],[],[],[],[],[],[],[],[],[50046],[19848],[19857],
 [19862],[50075],[],[50075],[50046],[19862],[19848],[19857],[48035],[],[],[4193],
 [48445],[],[],[],[],[],[],[],[],[],[19848],[19857],[19862],[],[],[],
 [],[19862],[19848],[19857],[],[39779],[43685],[40642],[],[],[],[],[],[],
 [],[],[],[19848],[19857],[19862],[],[],[],[],[19862],[19848],[19857],
 [49217],[],[],[],[],[],[],[],[],[],[],[],[19848],[19857],[19862],[],
 [],[],[],[19862],[19848],[19857],[44394],[38921],[],[],[],[],[],[],[],
 [51006],[],[19848],[19857],[19862],[],[51050],[51050],[51006],[19862],[19848],
 [19857],[],[],[],[],[],[],[],[],[],[],[19848],[19857],[19862],[],[],
 [],[],[19862],[19848],[19857],[],[],[],[],[],[],[],[],[],[19848],
 [19857],[19862],[],[],[],[],[19862],[19848],[19857],[45084],[46241],[47266],
 [19614,19618],[],[],[],[],[19848],[19857],[19862],[],[],[],[],[19862],
 [19848],[19857],[42362],[43104],[],[],[],[],[],[19848],[19857],[19862],[],
 [],[],[],[19862],[19848],[19857],[39015],[],[],[],[],[],[19848],[19857],
 [19862],[],[],[],[],[19862],[19848],[19857],[],[],[19617,19620],[],[],
 [19848],[19857],[19862],[],[],[],[],[19862],[19848],[19857],[45745],[47331],
 [],[],[19848],[19857],[19862],[],[],[],[],[19862],[19848],[19857],[40824],
 [],[],[19848],[19857],[19862],[],[],[],[],[19862],[19848],[19857],[],[],
 [19848],[19857],[19862],[],[],[],[],[19862],[19848],[19857],[42449],[19848],
 [19857],[19862],[],[14514],[],[51006],[19862],[19848],[19857],[19848],[19857],
 [19862],[14523],[],[],[50046],[19862],[19848],[19857],[19848,19857,40870,40914],
 [19848,19862,45806,45847],[19848],[19848],[19848],[19848],[19848,19862,45806,45847],[],
 [19848,19857,40870,40914],[19857,19862,47399,47433],[19857],[19857],[19857],[19857],
 [19857,19862,47399,47433],[19848,19857,40870,40914],[],[19862],[19862],[19862],[19862],
 [],[19848,19862,45806,45847],[19857,19862,47399,47433],[42494],[50075],[],[19862],
 [19848],[19857],[51050],[],[19862],[19848],[19857],[14565],[19862],[19848],[19857],
 [19862],[19848],[19857],[19848,19862,45806,45847],[19857,19862,47399,47433],
 [19848,19857,40870,40914],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[12979],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[26160],[26160],[],[26316],[26316],[],[],[26510],[26510],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[26160],[27643],[27643],[],[],[27841],[27841],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[28970],[],[28970],[],[29168],[],[29168],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[27643],[28970],[30394],[30394],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [26316],[31620],[],[31620],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[32797],[],[],
 [32797],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[30394],[31620],[32797],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[27841],[29168],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[26510],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[38205],[38205],[],[38331],[38331],
 [],[],[3507],[],[38557],[],[38557],[],[],[],[],[],[],[],[],[],[],
 [38921],[],[38921],[],[],[39015],[39015],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[38205],[39193],[39193],[],[39313],[39313],[],[39424],
 [39424],[],[],[],[],[],[],[],[5705],[],[],[39779],[],[39779],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [40055],[],[40055],[],[],[],[40287],[],[],[40287],[],[40450],[40450],[],
 [],[],[7828],[],[40642],[],[],[],[40642],[],[],[],[],[],[40824],
 [40824],[],[],[40870],[40870],[],[],[],[],[],[],[40914],[40914],[39193],
 [40055],[],[],[41069],[41069],[],[],[],[41239],[41239],[],[],[],[],
 [41411],[],[41411],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[38331],[],[],[41850],[],[41850],[],
 [],[],[],[],[42109],[42109],[],[42193],[],[],[],[42193],[],[],[],
 [42362],[42362],[],[],[],[],[42449],[42449],[],[],[],[42494],[42494],[],
 [],[],[],[],[],[],[42593],[],[],[],[42593],[42761],[],[42761],[],[],
 [],[42936],[],[],[],[],[],[42936],[],[43104],[],[43104],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[39313],[],[43330],[],[43330],
 [],[],[3756],[],[],[],[],[],[],[43685],[],[],[43685],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [44030],[44030],[],[],[],[],[],[],[],[],[],[],[],[44394],[44394],[],
 [],[],[8032],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[41069],[41850],[],[42593],[],[],[],[],[],[44904],[44904],[],[],[],
 [],[],[],[45084],[45084],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[39424],[43330],[40287],[],[],[],[],[],[45501],[],[],
 [45501],[],[],[],[],[],[],[],[],[45745],[45745],[],[],[],[45806],[],
 [45806],[],[],[],[],[45847],[45847],[],[44030],[38557],[],[],[],[],[],
 [46064],[],[],[],[],[46064],[],[],[46241],[],[46241],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[46593],
 [],[],[],[],[],[46593],[],[8168],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[47090],[],[],[],
 [],[],[],[47090],[47266],[],[],[47266],[47331],[],[47331],[],[],[],
 [47399],[47399],[],[],[],[],[47433],[],[47433],[41239],[42761],[],[],[],
 [47575],[47575],[],[],[],[],[],[],[6152],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[40450],[],[],[],[],[48035],[48035],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[48445],[],[],[],[],[48445],[],[],[],
 [6213],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[42109],
 [],[48796],[],[],[48796],[],[],[],[],[],[],[],[],[],[],[],
 [21493,49073],[],[],[],[],[],[],[],[],[],[21493,49073],[],[],[],[],
 [49217],[49217],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [21527,49458],[],[],[],[21527,49458],[],[44904],[],[45501],[],[46064],[46593],
 [47090],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[47575],[41411],[48796],[42193],[],[42936],[],[],[],[],[],[],[],
 [],[50046],[],[],[],[50075],[],[50075],[50046],[],[],[],[48035],[],[],
 [4193],[48445],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[39779],[43685],[40642],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[49217],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[21530,50846],[],[21530,50846],[],[],
 [44394],[38921],[],[],[],[],[],[],[],[51006],[],[],[],[],[],[51050],
 [51050],[51006],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[45084],[46241],[47266],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[42362],[43104],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[39015],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[45745],[47331],[],[],[],[],[],[],[],[],[],[],[],
 [],[40824],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[42449],[],[],[],[],[14514],[],[51006],
 [],[],[],[],[],[],[14523],[],[],[50046],[],[],[],[40870],[45806],[],
 [],[],[],[],[14635,19848],[],[47399],[],[],[],[],[],[],[14635,19857],
 [],[],[],[],[14635,19862],[],[],[42494],[50075],[],[],[],[],[51050],
 [],[],[],[],[14565],[],[],[],[],[],[],[45847],[47433],[40914],
 [12747,12979],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [26160],[26160],[],[26316],[26316],[],[],[26510],[26510],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[26160],[27643],[27643],[],[],[27841],[27841],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[28970],[],[28970],[],[29168],[],[29168],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [27643],[28970],[30394],[30394],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[26316],
 [31620],[],[31620],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[32797],[],[],[32797],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[30394],[31620],[32797],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[27841],[29168],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[26510],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[38205],[38205],[],[38331],[38331],[],[],
 [3507],[],[38557],[],[38557],[],[],[],[],[],[],[],[],[],[],[38921],
 [],[38921],[],[],[39015],[39015],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[38205],[39193],[39193],[],[39313],[39313],[],[39424],
 [39424],[],[],[],[],[],[],[],[5705],[],[],[39779],[],[39779],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [40055],[],[40055],[],[],[],[40287],[],[],[40287],[],[40450],[40450],[],
 [],[],[7828],[],[40642],[],[],[],[40642],[],[],[],[],[],[40824],
 [40824],[],[],[40870],[40870],[],[],[],[],[],[],[40914],[40914],[39193],
 [40055],[],[],[41069],[41069],[],[],[],[41239],[41239],[],[],[],[],
 [41411],[],[41411],[],[],[],[7875],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[38331],[],[],[41850],[],[41850],[],
 [],[],[],[],[42109],[42109],[],[42193],[],[],[],[42193],[],[],[],
 [42362],[42362],[],[],[],[],[42449],[42449],[],[],[],[42494],[42494],[],
 [],[],[],[],[],[],[42593],[],[],[],[42593],[42761],[],[42761],[],[],
 [],[42936],[],[],[],[],[],[42936],[],[43104],[],[43104],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[39313],[],[43330],[],[43330],
 [],[],[3756],[],[],[],[],[],[],[43685],[],[],[43685],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [44030],[44030],[],[],[],[],[],[],[],[],[],[],[],[44394],[44394],[],
 [],[],[8032],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[41069],[41850],[],[42593],[],[],[],[],[],[44904],[44904],[],[],[],
 [],[],[],[45084],[45084],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[39424],[43330],[40287],[],[],[],[],[],[45501],[],[],
 [45501],[],[],[],[],[],[],[],[],[45745],[45745],[],[],[],[45806],[],
 [45806],[],[],[],[],[45847],[45847],[],[44030],[38557],[],[],[],[],[],
 [46064],[],[],[],[],[46064],[],[],[46241],[],[46241],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[46593],
 [],[],[],[],[],[46593],[],[8168],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[47090],[],[],[],
 [],[],[],[47090],[47266],[],[],[47266],[47331],[],[47331],[],[],[],
 [47399],[47399],[],[],[],[],[47433],[],[47433],[41239],[42761],[],[],[],
 [47575],[47575],[],[],[],[],[],[],[6152],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[40450],[],[],[],[],[48035],[48035],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[48445],[],[],[],[],[48445],[],[],[],
 [6213],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[42109],
 [],[48796],[],[],[48796],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[49217],[49217],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[44904],[],[45501],[],[46064],[46593],[47090],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[47575],[41411],[48796],[42193],
 [],[42936],[],[],[],[],[],[],[],[],[50046],[],[],[],[50075],[],
 [50075],[50046],[],[],[],[48035],[],[],[4193],[48445],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[39779],[43685],
 [40642],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[49217],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[44394],[38921],[],[],[],[],[],[],[],[51006],
 [],[],[],[],[],[51050],[51050],[51006],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[45084],[46241],
 [47266],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[42362],
 [43104],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[39015],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[45745],[47331],[],[],[],[],
 [],[],[],[],[],[],[],[],[40824],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[42449],[],[],
 [],[],[12747,14514],[],[51006],[],[],[],[],[],[],[12747,14523],[],[],
 [50046],[],[],[],[40870],[45806],[],[],[],[],[],[8962,19848],[],[47399],
 [],[],[],[],[],[],[8962,19857],[],[],[],[],[8962,19862],[],[],
 [42494],[50075],[],[],[],[],[51050],[],[],[],[],[12747,14565],[],[],
 [],[],[],[],[45847],[47433],[40914],[12979],[12979],[12979],[12979],[12979],
 [12979],[12979],[12979],[12979],[12979],[12979],[12979],[12979],[12979],[12979],
 [12979],[12979],[12979],[12979],[12979],[12979],[12979],[12979],[12979],[12979],
 [12979],[12979],[12979],[12979],[12979],[12979],[12979],[12979],[12979],[12979],
 [12979],[12979],[12979],[12979],[12979],[12979],[12979],[12979],[12979,14514],
 [12979,14523],[12979],[12979],[12979],[12979,14523],[12979,14514],[12979,14565],
 [12979,14565],[12979],[12979],[12979],[26160],[26160],[],[26316],[26316],[],[],
 [26510],[26510],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[26160],[27643],[27643],[],[],
 [27841],[27841],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[28970],[],[28970],[],
 [29168],[],[29168],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[27643],[28970],[30394],[30394],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[26316],[31620],[],[31620],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[32797],[],[],[32797],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [30394],[31620],[32797],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[27841],[29168],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[26510],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[38205],[38205],[],[38331],[38331],[],[],[3507],[],[38557],[],
 [38557],[],[],[],[],[],[],[],[],[],[],[38921],[],[38921],[],[],
 [39015],[39015],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [38205],[39193],[39193],[],[39313],[39313],[],[39424],[39424],[],[],[],[],
 [],[],[],[5705],[],[],[39779],[],[39779],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[40055],[],[40055],[],
 [],[],[7132,7149,7818,7821,7828,8087,8094,8193,23788,40287,40294,40393,45328],[],[],
 [7132,7149,7818,7821,7828,8087,8094,8193,23788,40287,40294,40393,45328],[],[40450],[40450],
 [],[],[],[7828],[],[40642],[],[],[],[40642],[],[],[],[],[],[40824],
 [40824],[],[],[40870],[40870],[],[],[],[],[],[],[40914],[40914],[39193],
 [40055],[],[],[41069],[41069],[],[],[],[41239],[41239],[],[],[],[],
 [41411],[],[41411],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[38331],[],[],[41850],[],[41850],[],
 [],[],[],[],[42109],[42109],[],[42193],[],[],[],[42193],[],[],[],
 [42362],[42362],[],[],[],[],[42449],[42449],[],[],[],[42494],[42494],[],
 [],[],[],[],[],[],[42593],[],[],[],[42593],[42761],[],[42761],[],[],
 [],[42936],[],[],[],[],[],[42936],[],[43104],[],[43104],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[39313],[],[43330],[],[43330],
 [],[],[3756],[],[],[],[],[],[],[43685],[],[],[43685],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [44030],[44030],[],[],[],[],[],[],[],[],[],[],[],[44394],[44394],[],
 [],[],[8032],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[41069],[41850],[],[42593],[],[],[],[],[],[44904],[44904],[],[],[],
 [],[],[],[45084],[45084],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[39424],[43330],[7132,7149,7818,7821,7828,8087,8094,8193,23788,40287,
   40294,40393,45328],[],[],[],[],[],[45501],[],[],[45501],[],[],[],[],
 [],[],[],[],[45745],[45745],[],[],[],[45806],[],[45806],[],[],[],[],
 [45847],[45847],[],[44030],[38557],[],[],[],[],[],[46064],[],[],[],[],
 [46064],[],[],[46241],[],[46241],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[46593],[],[],[],[],[],
 [46593],[],[8168],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[47090],[],[],[],[],[],[],[47090],
 [47266],[],[],[47266],[47331],[],[47331],[],[],[],[47399],[47399],[],[],
 [],[],[47433],[],[47433],[41239],[42761],[],[],[],[47575],[47575],[],[],
 [],[],[],[],[6152],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[40450],[],[],[],[],[48035],[48035],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[48445],[],[],[],[],[48445],[],[],[],[6213],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[42109],[],[48796],[],[],
 [48796],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[49217],[49217],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[44904],[],
 [45501],[],[46064],[46593],[47090],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[47575],[41411],[48796],[42193],[],[42936],[],
 [],[],[],[],[],[],[],[50046],[],[],[],[50075],[],[50075],[50046],[],
 [],[],[48035],[],[],[4193],[48445],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[39779],[43685],[40642],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[49217],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[44394],[38921],[],[],[],[],[],[],[],[51006],[],[],[],[],[],
 [51050],[51050],[51006],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[45084],[46241],[47266],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[42362],[43104],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[39015],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[45745],[47331],[],[],[],[],[],[],[],
 [24666,52022],[],[24666,52022],[],[],[40824],[],[],[24633,52067],[],[],[],
 [24633,52067],[],[],[],[],[],[],[],[],[],[],[24659,52159],[],[],[],
 [],[],[24659,52159],[42449],[],[],[],[],[12979,14514],[],[51006],[],[],
 [],[],[],[],[12979,14523],[],[],[50046],[],[],[],[40870],[45806],[],
 [],[],[],[],[19848],[],[47399],[],[],[],[],[],[],[19857],[],[],
 [],[],[19862],[],[],[42494],[50075],[],[],[],[],[51050],[],[],[],[],
 [12979,14565],[],[],[],[],[],[],[45847],[47433],[40914],[26160],[26160],[],
 [26316],[26316],[],[],[26510],[26510],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[26160],
 [27643],[27643],[],[],[27841],[27841],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[28970],
 [],[28970],[],[29168],[],[29168],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[27643],
 [28970],[30394],[30394],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[26316],[31620],
 [],[31620],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[32797],[],[],[32797],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[30394],[31620],[32797],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [27841],[29168],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[26510],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[38205],[38205],[],[38331],[38331],[],[],
 [3507],[],[38557],[],[38557],[],[],[],[],[],[],[],[],[],[],[38921],
 [],[38921],[],[],[39015],[39015],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[38205],[39193],[39193],[],[39313],[39313],[],[39424],
 [39424],[],[],[],[],[],[],[],[5705],[],[],[39779],[],[39779],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [40055],[],[40055],[],[],[],[40287],[],[],[40287],[],[40450],[40450],[],
 [],[],[7828],[],[40642],[],[],[],[40642],[],[],[],[],[],[40824],
 [40824],[],[],[40870],[40870],[],[],[],[],[],[],[40914],[40914],[39193],
 [40055],[],[],[41069],[41069],[],[],[],[41239],[41239],[],[],[],[],
 [41411],[],[41411],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[38331],[],[],[41850],[],[41850],[],
 [],[],[],[],[42109],[42109],[],[42193],[],[],[],[42193],[],[],[],
 [42362],[42362],[],[],[],[],[42449],[42449],[],[],[],[42494],[42494],[],
 [],[],[],[],[],[],[42593],[],[],[],[42593],[42761],[],[42761],[],[],
 [],[42936],[],[],[],[],[],[42936],[],[43104],[],[43104],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[39313],[],[43330],[],[43330],
 [],[],[3756],[],[],[],[],[],[],[43685],[],[],[43685],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [44030],[44030],[],[],[],[],[],[],[],[],[],[],[],[44394],[44394],[],
 [],[],[8032],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[41069],[41850],[],[42593],[],[],[],[],[],[44904],[44904],[],[],[],
 [],[],[],[45084],[45084],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[39424],[43330],[40287],[],[],[],[],[],[45501],[],[],
 [45501],[],[],[],[],[],[],[],[],[45745],[45745],[],[],[],[45806],[],
 [45806],[],[],[],[],[45847],[45847],[],[44030],[38557],[],[],[],[],[],
 [46064],[],[],[],[],[46064],[],[],[46241],[],[46241],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[46593],
 [],[],[],[],[],[46593],[],[8168],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[47090],[],[],[],
 [],[],[],[47090],[47266],[],[],[47266],[47331],[],[47331],[],[],[],
 [47399],[47399],[],[],[],[],[47433],[],[47433],[41239],[42761],[],[],[],
 [47575],[47575],[],[],[],[],[],[],[6152],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[40450],[],[],[],[],[48035],[48035],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[48445],[],[],[],[],[48445],[],[],[],
 [6213],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[42109],
 [],[48796],[],[],[48796],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[49217],[49217],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[44904],[],[45501],[],[46064],[46593],[47090],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[47575],[41411],[48796],[42193],
 [],[42936],[],[],[],[],[],[],[],[],[50046],[],[],[],[50075],[],
 [50075],[50046],[],[],[],[48035],[],[],[4193],[48445],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[39779],[43685],
 [40642],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[49217],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[44394],[38921],[],[],[],[],[],[],[],[51006],
 [],[],[],[],[],[51050],[51050],[51006],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[45084],[46241],
 [47266],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[42362],
 [43104],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[39015],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[45745],[47331],[],[26107,51978],
 [],[],[26107,51978],[],[],[],[],[],[],[],[40824],[],[],[],[],[],
 [],[],[],[26155,52104],[],[26155,52104],[],[26096,52111],[],[],[26096,52111],
 [],[],[],[],[],[],[],[],[42449],[],[],[],[],[12979,14514],[],
 [51006],[],[],[],[],[],[],[12979,14523],[],[],[50046],[],[],[],
 [40870],[45806],[],[],[],[],[],[19848],[],[47399],[],[],[],[],[],[],
 [19857],[],[],[],[],[19862],[],[],[42494],[50075],[],[],[],[],[51050],
 [],[],[],[],[12979,14565],[],[],[],[],[],[],[45847],[47433],[40914],
 [],[26160,26316,27643,28970],[26160,26316,27643,28970],[26160,26316,27643,28970],[26160],
 [26160,26510,27841,29168],[26160,26510,27841,29168],[26160,26510,27841,29168],[26160],
 [26160],[26160],[26160],[26160],[26160],[26160],[26160],[26160],[26160],[26160],
 [26160],[26160],[26160],[26160],[26160],[26160],[26160],[26160],[26160],[26160],
 [26160],[26160],[26160],[26160],[26160],[26160],[26160],[26160],[26160],[26160],
 [26160],[26160],[26160],[26160],[26160],[26160],[26160],[26160],[26160],[26160],
 [26160],[26160],[26160],[26160],[26160,26316,27643,28970],[26160,26316,27643,28970],
 [26160,26316,27643,28970],[26160],[26160,26510,27841,29168],[26160,26510,27841,29168],
 [26160,26510,27841,29168],[26160],[26160],[26160],[26160],[26160],[26160],[26160],
 [26160],[26160],[26160],[26160],[26160],[26160],[26160],[26160],[26160],[26160],
 [26160],[26160],[26160],[26160],[26160],[26160],[26160],[26160],[26160],[26160],
 [26160],[26160],[26160],[26160],[26160],[26160],[26160],[26160],[26160],[26160],
 [26160],[26160],[26160],[26160],[26160],[26160],[26160],[26160],
 [26160,26316,27643,28970],[26160,26316,27643,28970],[30394],[30394],[26510],[26510],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[26316,26510,31620,32797],[26316],[26316,26510,31620,32797],
 [26316,26510,31620,32797],[26316],[26316],[26316],[26316],[26316],[26316],[26316],
 [26316],[26316],[26316],[26316],[26316],[26316],[26316],[26316],[26316],[26316],
 [26316],[26316],[26316],[26316],[26316],[26316],[26316],[26316],[26316],[26316],
 [26316],[26316],[26316],[26316],[26316],[26316],[26316],[26316],[26316],[26316],
 [26316],[26316],[26316],[26316],[26316],[26316],[26316],[26316],
 [26316,26510,31620,32797],[26316],[26316,26510,31620,32797],[26316,26510,31620,32797],
 [26316],[26316],[26316],[26316],[26316],[26316],[26316],[26316],[26316],[26316],
 [26316],[26316],[26316],[26316],[26316],[26316],[26316],[26316],[26316],[26316],
 [26316],[26316],[26316],[26316],[26316],[26316],[26316],[26316],[26316],[26316],
 [26316],[26316],[26316],[26316],[26316],[26316],[26316],[26316],[26316],[26316],
 [26316],[26316],[26316],[26316],[26316],[30394],[26316,26510,31620,32797],
 [26316,26510,31620,32797],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[26160,26510,27841,29168],
 [26160,26510,27841,29168],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[26510],[26510],[26510],
 [26510],[26510],[26510],[26510],[26510],[26510],[26510],[26510],[26510],[26510],
 [26510],[26510],[26510],[26510],[26510],[26510],[26510],[26510],[26510],[26510],
 [26510],[26510],[26510],[26510],[26510],[26510],[26510],[26510],[26510],[26510],
 [26510],[26510],[26510],[26510],[26510],[26510],[26510],[26510],[26510],[26510],
 [26510],[26510],[26510],[26510],[26510],[26510],[26510],[26510],[26510],[26510],
 [26510],[26510],[26510],[26510],[26510],[26510],[26510],[26510],[26510],[26510],
 [26510],[26510],[26510],[26510],[26510],[26510],[26510],[26510],[26510],[26510],
 [26510],[26510],[26510],[26510],[26510],[26510],[26510],[26510],[26510],[26510],
 [26510],[26510],[26510],[26510],[26510],[26510],[26510],[38205],[38205],[],[38331],
 [38331],[],[],[3507],[],[38557],[],[38557],[],[],[],[],[],[],[],[],
 [],[],[38921],[],[38921],[],[],[39015],[39015],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[38205],[39193],[39193],[],[39313],[39313],[],
 [39424],[39424],[],[],[],[],[],[],[],[5705],[],[],[39779],[],[39779],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[40055],[],[40055],[],[],[],[40287],[],[],[40287],[],[40450],
 [40450],[],[],[],[7828],[],[40642],[],[],[],[40642],[],[],[],[],[],
 [40824],[40824],[],[],[40870],[40870],[],[],[],[],[],[],[40914],[40914],
 [39193],[40055],[],[],[41069],[41069],[],[],[],[41239],[41239],[],[],[],
 [],[41411],[],[41411],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[38331],[],[],[41850],[],[41850],
 [],[],[],[],[],[42109],[42109],[],[42193],[],[],[],[42193],[],[],[],
 [42362],[42362],[],[],[],[],[42449],[42449],[],[],[],[42494],[42494],[],
 [],[],[],[],[],[],[42593],[],[],[],[42593],[42761],[],[42761],[],[],
 [],[42936],[],[],[],[],[],[42936],[],[43104],[],[43104],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[39313],[],[43330],[],[43330],
 [],[],[3756],[],[],[],[],[],[],[43685],[],[],[43685],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [44030],[44030],[],[],[],[],[],[],[],[],[],[],[],[44394],[44394],[],
 [],[],[8032],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[41069],[41850],[],[42593],[],[],[],[],[],[44904],[44904],[],[],[],
 [],[],[],[45084],[45084],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[39424],[43330],[40287],[],[],[],[],[],[45501],[],[],
 [45501],[],[],[],[],[],[],[],[],[45745],[45745],[],[],[],[45806],[],
 [45806],[],[],[],[],[45847],[45847],[],[44030],[38557],[],[],[],[],[],
 [46064],[],[],[],[],[46064],[],[],[46241],[],[46241],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[46593],
 [],[],[],[],[],[46593],[],[8168],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[47090],[],[],[],
 [],[],[],[47090],[47266],[],[],[47266],[47331],[],[47331],[],[],[],
 [47399],[47399],[],[],[],[],[47433],[],[47433],[41239],[42761],[],[],[],
 [47575],[47575],[],[],[],[],[],[],[6152],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[40450],[],[],[],[],[48035],[48035],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[48445],[],[],[],[],[48445],[],[],[],
 [6213],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[42109],
 [],[48796],[],[],[48796],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[49217],[49217],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[44904],[],[45501],[],[46064],[46593],[47090],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[47575],[41411],[48796],[42193],
 [],[42936],[],[],[],[],[],[],[],[],[50046],[],[],[],[50075],[],
 [50075],[50046],[],[],[],[48035],[],[],[4193],[48445],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[39779],[43685],
 [40642],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[49217],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[44394],[38921],[],[],[],[],[],[],[],[51006],
 [],[],[],[],[],[51050],[51050],[51006],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[45084],[46241],
 [47266],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[42362],
 [43104],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[39015],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[45745],[47331],[],[],[],[],
 [],[],[],[],[],[],[],[],[40824],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[42449],[],[],
 [],[],[14514],[],[51006],[],[],[],[],[],[],[14523],[],[],[50046],[],
 [],[],[40870],[45806],[],[],[],[],[],[19848],[],[47399],[],[],[],[],
 [],[],[19857],[],[],[],[],[19862],[],[],[42494],[50075],[],[],[],[],
 [51050],[],[],[],[],[14565],[],[],[],[],[],[],[45847],[47433],[40914],
 [26160,26316,27643,28970],[26160,26316,27643,28970],[26160,26316,27643,28970],[26160],
 [26160,26510,27841,29168],[26160,26510,27841,29168],[26160,26510,27841,29168],[26160],
 [26160],[26160],[26160],[26160],[26160],[26160],[26160],[26160],[26160],[26160],
 [26160],[26160],[26160],[26160],[26160],[26160],[26160],[26160],[26160],[26160],
 [26160],[26160],[26160],[26160],[26160],[26160],[26160],[26160],[26160],[26160],
 [26160],[26160],[26160],[26160],[26160],[26160],[26160],[26160],[26160],[26160],
 [26160],[26160],[26160],[26160],[],[26160,26316,27643,28970],[27643,27841,30394,31620],
 [27643,27841,30394,31620],[27643,27841,30394,31620],[27643],[27643],[27643],[27643],
 [27643],[27643],[27643],[27643],[27643],[27643],[27643],[27643],[27643],[27643],
 [27643],[27643],[27643],[27643],[27643],[27643],[27643],[27643],[27643],[27643],
 [27643],[27643],[27643],[27643],[27643],[27643],[27643],[27643],[27643],[27643],
 [27643],[27643],[27643],[27643],[27643],[27643],[27643],[27643],[27643],[27643],
 [27643],[27643],[26160,26316,27643,28970],[27643,27841,30394,31620],
 [27643,27841,30394,31620],[27643,27841,30394,31620],[27643],[27643],[27643],[27643],
 [27643],[27643],[27643],[27643],[27643],[27643],[27643],[27643],[27643],[27643],
 [27643],[27643],[27643],[27643],[27643],[27643],[27643],[27643],[27643],[27643],
 [27643],[27643],[27643],[27643],[27643],[27643],[27643],[27643],[27643],[27643],
 [27643],[27643],[27643],[27643],[27643],[27643],[27643],[27643],[27643],[27643],
 [27643],[27643],[32797],[27841],[27841],[32797],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [27643,27841,30394,31620],[27643,27841,30394,31620],[32797],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[26160,26510,27841,29168],[27841],[27841],[27841],[27841],[27841],[27841],
 [27841],[27841],[27841],[27841],[27841],[27841],[27841],[27841],[27841],[27841],
 [27841],[27841],[27841],[27841],[27841],[27841],[27841],[27841],[27841],[27841],
 [27841],[27841],[27841],[27841],[27841],[27841],[27841],[27841],[27841],[27841],
 [27841],[27841],[27841],[27841],[27841],[27841],[27841],[27841],[27841],
 [26160,26510,27841,29168],[27841],[27841],[27841],[27841],[27841],[27841],[27841],
 [27841],[27841],[27841],[27841],[27841],[27841],[27841],[27841],[27841],[27841],
 [27841],[27841],[27841],[27841],[27841],[27841],[27841],[27841],[27841],[27841],
 [27841],[27841],[27841],[27841],[27841],[27841],[27841],[27841],[27841],[27841],
 [27841],[27841],[27841],[27841],[27841],[27841],[27841],[27841],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[38205],[38205],[],[38331],[38331],[],[],[3507],[],[38557],[],
 [38557],[],[],[],[],[],[],[],[],[],[],[38921],[],[38921],[],[],
 [39015],[39015],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [38205],[39193],[39193],[],[39313],[39313],[],[39424],[39424],[],[],[],[],
 [],[],[],[5705],[],[],[39779],[],[39779],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[40055],[],[40055],[],
 [],[],[40287],[],[],[40287],[],[40450],[40450],[],[],[],[7828],[],
 [40642],[],[],[],[40642],[],[],[],[],[],[40824],[40824],[],[],[40870],
 [40870],[],[],[],[],[],[],[40914],[40914],[39193],[40055],[],[],[41069],
 [41069],[],[],[],[41239],[41239],[],[],[],[],[41411],[],[41411],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[38331],[],[],[41850],[],[41850],[],[],[],[],[],[42109],[42109],
 [],[42193],[],[],[],[42193],[],[],[],[42362],[42362],[],[],[],[],
 [42449],[42449],[],[],[],[42494],[42494],[],[],[],[],[],[],[],[42593],
 [],[],[],[42593],[42761],[],[42761],[],[],[],[42936],[],[],[],[],[],
 [42936],[],[43104],[],[43104],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[39313],[],[43330],[],[43330],[],[],[3756],[],[],[],[],
 [],[],[43685],[],[],[43685],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[44030],[44030],[],[],[],[],
 [],[],[],[],[],[],[],[44394],[44394],[],[],[],[8032],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[41069],[41850],[],[42593],
 [],[],[],[],[],[44904],[44904],[],[],[],[],[],[],[45084],[45084],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[39424],
 [43330],[40287],[],[],[],[],[],[45501],[],[],[45501],[],[],[],[],[],
 [],[],[],[45745],[45745],[],[],[],[45806],[],[45806],[],[],[],[],
 [45847],[45847],[],[44030],[38557],[],[],[],[],[],[46064],[],[],[],[],
 [46064],[],[],[46241],[],[46241],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[46593],[],[],[],[],[],
 [46593],[],[8168],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[47090],[],[],[],[],[],[],[47090],
 [47266],[],[],[47266],[47331],[],[47331],[],[],[],[47399],[47399],[],[],
 [],[],[47433],[],[47433],[41239],[42761],[],[],[],[47575],[47575],[],[],
 [],[],[],[],[6152],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[40450],[],[],[],[],[48035],[48035],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[48445],[],[],[],[],[48445],[],[],[],[6213],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[42109],[],[48796],[],[],
 [48796],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[49217],[49217],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[44904],[],
 [45501],[],[46064],[46593],[47090],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[47575],[41411],[48796],[42193],[],[42936],[],
 [],[],[],[],[],[],[],[50046],[],[],[],[50075],[],[50075],[50046],[],
 [],[],[48035],[],[],[4193],[48445],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[39779],[43685],[40642],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[49217],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[44394],[38921],[],[],[],[],[],[],[],[51006],[],[],[],[],[],
 [51050],[51050],[51006],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[45084],[46241],[47266],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[42362],[43104],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[39015],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[45745],[47331],[],[],[],[],[],[],[],[],[],
 [],[],[],[40824],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[42449],[],[],[],[],[14514],[],
 [51006],[],[],[],[],[],[],[14523],[],[],[50046],[],[],[],[40870],
 [45806],[],[],[],[],[],[19848],[],[47399],[],[],[],[],[],[],[19857],
 [],[],[],[],[19862],[],[],[42494],[50075],[],[],[],[],[51050],[],[],
 [],[],[14565],[],[],[],[],[],[],[45847],[47433],[40914],
 [26160,26316,27643,28970],[],[28970,29168,30394,32797],[28970,29168,30394,32797],[28970],
 [28970,29168,30394,32797],[28970],[28970],[28970],[28970],[28970],[28970],[28970],
 [28970],[28970],[28970],[28970],[28970],[28970],[28970],[28970],[28970],[28970],
 [28970],[28970],[28970],[28970],[28970],[28970],[28970],[28970],[28970],[28970],
 [28970],[28970],[28970],[28970],[28970],[28970],[28970],[28970],[28970],[28970],
 [28970],[28970],[28970],[28970],[28970],[28970],[28970],[28970],
 [26160,26316,27643,28970],[31620],[29168],[31620],[29168],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[28970,29168,30394,32797],[28970,29168,30394,32797],[28970],[28970,29168,30394,32797],
 [28970],[28970],[28970],[28970],[28970],[28970],[28970],[28970],[28970],[28970],
 [28970],[28970],[28970],[28970],[28970],[28970],[28970],[28970],[28970],[28970],
 [28970],[28970],[28970],[28970],[28970],[28970],[28970],[28970],[28970],[28970],
 [28970],[28970],[28970],[28970],[28970],[28970],[28970],[28970],[28970],[28970],
 [28970],[28970],[28970],[28970],[28970],[28970,29168,30394,32797],[31620],
 [28970,29168,30394,32797],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[26160,26510,27841,29168],[],
 [29168],[29168],[29168],[29168],[29168],[29168],[29168],[29168],[29168],[29168],
 [29168],[29168],[29168],[29168],[29168],[29168],[29168],[29168],[29168],[29168],
 [29168],[29168],[29168],[29168],[29168],[29168],[29168],[29168],[29168],[29168],
 [29168],[29168],[29168],[29168],[29168],[29168],[29168],[29168],[29168],[29168],
 [29168],[29168],[29168],[29168],[29168],[26160,26510,27841,29168],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[29168],[29168],[29168],[29168],[29168],[29168],[29168],[29168],
 [29168],[29168],[29168],[29168],[29168],[29168],[29168],[29168],[29168],[29168],
 [29168],[29168],[29168],[29168],[29168],[29168],[29168],[29168],[29168],[29168],
 [29168],[29168],[29168],[29168],[29168],[29168],[29168],[29168],[29168],[29168],
 [29168],[29168],[29168],[29168],[29168],[29168],[29168],[38205],[38205],[],[38331],
 [38331],[],[],[3507],[],[38557],[],[38557],[],[],[],[],[],[],[],[],
 [],[],[38921],[],[38921],[],[],[39015],[39015],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[38205],[39193],[39193],[],[39313],[39313],[],
 [39424],[39424],[],[],[],[],[],[],[],[5705],[],[],[39779],[],[39779],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[40055],[],[40055],[],[],[],[40287],[],[],[40287],[],[40450],
 [40450],[],[],[],[7828],[],[40642],[],[],[],[40642],[],[],[],[],[],
 [40824],[40824],[],[],[40870],[40870],[],[],[],[],[],[],[40914],[40914],
 [39193],[40055],[],[],[41069],[41069],[],[],[],[41239],[41239],[],[],[],
 [],[41411],[],[41411],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[38331],[],[],[41850],[],[41850],
 [],[],[],[],[],[42109],[42109],[],[42193],[],[],[],[42193],[],[],[],
 [42362],[42362],[],[],[],[],[42449],[42449],[],[],[],[42494],[42494],[],
 [],[],[],[],[],[],[42593],[],[],[],[42593],[42761],[],[42761],[],[],
 [],[42936],[],[],[],[],[],[42936],[],[43104],[],[43104],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[39313],[],[43330],[],[43330],
 [],[],[3756],[],[],[],[],[],[],[43685],[],[],[43685],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [44030],[44030],[],[],[],[],[],[],[],[],[],[],[],[44394],[44394],[],
 [],[],[8032],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[41069],[41850],[],[42593],[],[],[],[],[],[44904],[44904],[],[],[],
 [],[],[],[45084],[45084],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[39424],[43330],[40287],[],[],[],[],[],[45501],[],[],
 [45501],[],[],[],[],[],[],[],[],[45745],[45745],[],[],[],[45806],[],
 [45806],[],[],[],[],[45847],[45847],[],[44030],[38557],[],[],[],[],[],
 [46064],[],[],[],[],[46064],[],[],[46241],[],[46241],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[46593],
 [],[],[],[],[],[46593],[],[8168],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[47090],[],[],[],
 [],[],[],[47090],[47266],[],[],[47266],[47331],[],[47331],[],[],[],
 [47399],[47399],[],[],[],[],[47433],[],[47433],[41239],[42761],[],[],[],
 [47575],[47575],[],[],[],[],[],[],[6152],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[40450],[],[],[],[],[48035],[48035],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[48445],[],[],[],[],[48445],[],[],[],
 [6213],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[42109],
 [],[48796],[],[],[48796],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[49217],[49217],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[44904],[],[45501],[],[46064],[46593],[47090],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[47575],[41411],[48796],[42193],
 [],[42936],[],[],[],[],[],[],[],[],[50046],[],[],[],[50075],[],
 [50075],[50046],[],[],[],[48035],[],[],[4193],[48445],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[39779],[43685],
 [40642],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[49217],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[44394],[38921],[],[],[],[],[],[],[],[51006],
 [],[],[],[],[],[51050],[51050],[51006],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[45084],[46241],
 [47266],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[42362],
 [43104],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[39015],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[45745],[47331],[],[],[],[],
 [],[],[],[],[],[],[],[],[40824],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[42449],[],[],
 [],[],[14514],[],[51006],[],[],[],[],[],[],[14523],[],[],[50046],[],
 [],[],[40870],[45806],[],[],[],[],[],[19848],[],[47399],[],[],[],[],
 [],[],[19857],[],[],[],[],[19862],[],[],[42494],[50075],[],[],[],[],
 [51050],[],[],[],[],[14565],[],[],[],[],[],[],[45847],[47433],[40914],
 [26160,26316,27643,28970],[27643,27841,30394,31620],[27643,27841,30394,31620],
 [27643,27841,30394,31620],[27643],[27643],[27643],[27643],[27643],[27643],[27643],
 [27643],[27643],[27643],[27643],[27643],[27643],[27643],[27643],[27643],[27643],
 [27643],[27643],[27643],[27643],[27643],[27643],[27643],[27643],[27643],[27643],
 [27643],[27643],[27643],[27643],[27643],[27643],[27643],[27643],[27643],[27643],
 [27643],[27643],[27643],[27643],[27643],[27643],[27643],[27643],[27643],
 [28970,29168,30394,32797],[28970,29168,30394,32797],[28970],[28970,29168,30394,32797],
 [28970],[28970],[28970],[28970],[28970],[28970],[28970],[28970],[28970],[28970],
 [28970],[28970],[28970],[28970],[28970],[28970],[28970],[28970],[28970],[28970],
 [28970],[28970],[28970],[28970],[28970],[28970],[28970],[28970],[28970],[28970],
 [28970],[28970],[28970],[28970],[28970],[28970],[28970],[28970],[28970],[28970],
 [28970],[28970],[28970],[28970],[28970],[],[27643,27841,30394,31620],
 [28970,29168,30394,32797],[30394],[30394],[30394],[30394],[30394],[30394],[30394],
 [30394],[30394],[30394],[30394],[30394],[30394],[30394],[30394],[30394],[30394],
 [30394],[30394],[30394],[30394],[30394],[30394],[30394],[30394],[30394],[30394],
 [30394],[30394],[30394],[30394],[30394],[30394],[30394],[30394],[30394],[30394],
 [30394],[30394],[30394],[30394],[30394],[30394],[30394],[30394],
 [27643,27841,30394,31620],[28970,29168,30394,32797],[30394],[30394],[30394],[30394],
 [30394],[30394],[30394],[30394],[30394],[30394],[30394],[30394],[30394],[30394],
 [30394],[30394],[30394],[30394],[30394],[30394],[30394],[30394],[30394],[30394],
 [30394],[30394],[30394],[30394],[30394],[30394],[30394],[30394],[30394],[30394],
 [30394],[30394],[30394],[30394],[30394],[30394],[30394],[30394],[30394],[30394],
 [30394],[26510],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [38205],[38205],[],[38331],[38331],[],[],[3507],[],[38557],[],[38557],[],
 [],[],[],[],[],[],[],[],[],[38921],[],[38921],[],[],[39015],[39015],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[38205],[39193],
 [39193],[],[39313],[39313],[],[39424],[39424],[],[],[],[],[],[],[],
 [5705],[],[],[39779],[],[39779],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[40055],[],[40055],[],[],[],
 [40287],[],[],[40287],[],[40450],[40450],[],[],[],[7828],[],[40642],[],
 [],[],[40642],[],[],[],[],[],[40824],[40824],[],[],[40870],[40870],[],
 [],[],[],[],[],[40914],[40914],[39193],[40055],[],[],[41069],[41069],[],
 [],[],[41239],[41239],[],[],[],[],[41411],[],[41411],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [38331],[],[],[41850],[],[41850],[],[],[],[],[],[42109],[42109],[],
 [42193],[],[],[],[42193],[],[],[],[42362],[42362],[],[],[],[],[42449],
 [42449],[],[],[],[42494],[42494],[],[],[],[],[],[],[],[42593],[],[],
 [],[42593],[42761],[],[42761],[],[],[],[42936],[],[],[],[],[],[42936],
 [],[43104],[],[43104],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[39313],[],[43330],[],[43330],[],[],[3756],[],[],[],[],[],[],
 [43685],[],[],[43685],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[44030],[44030],[],[],[],[],[],[],
 [],[],[],[],[],[44394],[44394],[],[],[],[8032],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[41069],[41850],[],[42593],[],[],
 [],[],[],[44904],[44904],[],[],[],[],[],[],[45084],[45084],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[39424],[43330],
 [40287],[],[],[],[],[],[45501],[],[],[45501],[],[],[],[],[],[],
 [],[],[45745],[45745],[],[],[],[45806],[],[45806],[],[],[],[],[45847],
 [45847],[],[44030],[38557],[],[],[],[],[],[46064],[],[],[],[],[46064],
 [],[],[46241],[],[46241],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[46593],[],[],[],[],[],[46593],
 [],[8168],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[47090],[],[],[],[],[],[],[47090],[47266],
 [],[],[47266],[47331],[],[47331],[],[],[],[47399],[47399],[],[],[],[],
 [47433],[],[47433],[41239],[42761],[],[],[],[47575],[47575],[],[],[],[],
 [],[],[6152],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[40450],[],[],[],[],[48035],[48035],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[48445],[],[],[],[],[48445],[],[],[],[6213],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[42109],[],[48796],[],[],[48796],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[49217],[49217],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[44904],[],[45501],[],
 [46064],[46593],[47090],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[47575],[41411],[48796],[42193],[],[42936],[],[],[],
 [],[],[],[],[],[50046],[],[],[],[50075],[],[50075],[50046],[],[],[],
 [48035],[],[],[4193],[48445],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[39779],[43685],[40642],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[49217],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [44394],[38921],[],[],[],[],[],[],[],[51006],[],[],[],[],[],[51050],
 [51050],[51006],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[45084],[46241],[47266],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[42362],[43104],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[39015],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[45745],[47331],[],[],[],[],[],[],[],[],[],[],[],
 [],[40824],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[42449],[],[],[],[],[14514],[],[51006],
 [],[],[],[],[],[],[14523],[],[],[50046],[],[],[],[40870],[45806],[],
 [],[],[],[],[19848],[],[47399],[],[],[],[],[],[],[19857],[],[],
 [],[],[19862],[],[],[42494],[50075],[],[],[],[],[51050],[],[],[],[],
 [14565],[],[],[],[],[],[],[45847],[47433],[40914],[26316,26510,31620,32797],
 [26316],[26316,26510,31620,32797],[26316,26510,31620,32797],[26316],[26316],[26316],
 [26316],[26316],[26316],[26316],[26316],[26316],[26316],[26316],[26316],[26316],
 [26316],[26316],[26316],[26316],[26316],[26316],[26316],[26316],[26316],[26316],
 [26316],[26316],[26316],[26316],[26316],[26316],[26316],[26316],[26316],[26316],
 [26316],[26316],[26316],[26316],[26316],[26316],[26316],[26316],[26316],[26316],
 [26316],[26316],[27643,27841,30394,31620],[],[26316,26510,31620,32797],[31620],[31620],
 [31620],[31620],[31620],[31620],[31620],[31620],[31620],[31620],[31620],[31620],
 [31620],[31620],[31620],[31620],[31620],[31620],[31620],[31620],[31620],[31620],
 [31620],[31620],[31620],[31620],[31620],[31620],[31620],[31620],[31620],[31620],
 [31620],[31620],[31620],[31620],[31620],[31620],[31620],[31620],[31620],[31620],
 [31620],[31620],[31620],[27643,27841,30394,31620],[29168],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[26316,26510,31620,32797],[31620],[31620],[31620],[31620],[31620],[31620],[31620],
 [31620],[31620],[31620],[31620],[31620],[31620],[31620],[31620],[31620],[31620],
 [31620],[31620],[31620],[31620],[31620],[31620],[31620],[31620],[31620],[31620],
 [31620],[31620],[31620],[31620],[31620],[31620],[31620],[31620],[31620],[31620],
 [31620],[31620],[31620],[31620],[31620],[31620],[31620],[31620],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[38205],[38205],[],[38331],[38331],[],[],[3507],[],[38557],[],
 [38557],[],[],[],[],[],[],[],[],[],[],[38921],[],[38921],[],[],
 [39015],[39015],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [38205],[39193],[39193],[],[39313],[39313],[],[39424],[39424],[],[],[],[],
 [],[],[],[5705],[],[],[39779],[],[39779],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[40055],[],[40055],[],
 [],[],[40287],[],[],[40287],[],[40450],[40450],[],[],[],[7828],[],
 [40642],[],[],[],[40642],[],[],[],[],[],[40824],[40824],[],[],[40870],
 [40870],[],[],[],[],[],[],[40914],[40914],[39193],[40055],[],[],[41069],
 [41069],[],[],[],[41239],[41239],[],[],[],[],[41411],[],[41411],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[38331],[],[],[41850],[],[41850],[],[],[],[],[],[42109],[42109],
 [],[42193],[],[],[],[42193],[],[],[],[42362],[42362],[],[],[],[],
 [42449],[42449],[],[],[],[42494],[42494],[],[],[],[],[],[],[],[42593],
 [],[],[],[42593],[42761],[],[42761],[],[],[],[42936],[],[],[],[],[],
 [42936],[],[43104],[],[43104],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[39313],[],[43330],[],[43330],[],[],[3756],[],[],[],[],
 [],[],[43685],[],[],[43685],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[44030],[44030],[],[],[],[],
 [],[],[],[],[],[],[],[44394],[44394],[],[],[],[8032],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[41069],[41850],[],[42593],
 [],[],[],[],[],[44904],[44904],[],[],[],[],[],[],[45084],[45084],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[39424],
 [43330],[40287],[],[],[],[],[],[45501],[],[],[45501],[],[],[],[],[],
 [],[],[],[45745],[45745],[],[],[],[45806],[],[45806],[],[],[],[],
 [45847],[45847],[],[44030],[38557],[],[],[],[],[],[46064],[],[],[],[],
 [46064],[],[],[46241],[],[46241],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[46593],[],[],[],[],[],
 [46593],[],[8168],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[47090],[],[],[],[],[],[],[47090],
 [47266],[],[],[47266],[47331],[],[47331],[],[],[],[47399],[47399],[],[],
 [],[],[47433],[],[47433],[41239],[42761],[],[],[],[47575],[47575],[],[],
 [],[],[],[],[6152],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[40450],[],[],[],[],[48035],[48035],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[48445],[],[],[],[],[48445],[],[],[],[6213],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[42109],[],[48796],[],[],
 [48796],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[49217],[49217],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[44904],[],
 [45501],[],[46064],[46593],[47090],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[47575],[41411],[48796],[42193],[],[42936],[],
 [],[],[],[],[],[],[],[50046],[],[],[],[50075],[],[50075],[50046],[],
 [],[],[48035],[],[],[4193],[48445],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[39779],[43685],[40642],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[49217],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[44394],[38921],[],[],[],[],[],[],[],[51006],[],[],[],[],[],
 [51050],[51050],[51006],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[45084],[46241],[47266],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[42362],[43104],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[39015],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[45745],[47331],[],[],[],[],[],[],[],[],[],
 [],[],[],[40824],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[42449],[],[],[],[],[14514],[],
 [51006],[],[],[],[],[],[],[14523],[],[],[50046],[],[],[],[40870],
 [45806],[],[],[],[],[],[19848],[],[47399],[],[],[],[],[],[],[19857],
 [],[],[],[],[19862],[],[],[42494],[50075],[],[],[],[],[51050],[],[],
 [],[],[14565],[],[],[],[],[],[],[45847],[47433],[40914],
 [28970,29168,30394,32797],[26316,26510,31620,32797],[],[32797],[32797],[32797],[32797],
 [32797],[32797],[32797],[32797],[32797],[32797],[32797],[32797],[32797],[32797],
 [32797],[32797],[32797],[32797],[32797],[32797],[32797],[32797],[32797],[32797],
 [32797],[32797],[32797],[32797],[32797],[32797],[32797],[32797],[32797],[32797],
 [32797],[32797],[32797],[32797],[32797],[32797],[32797],[32797],[32797],[32797],
 [32797],[27841],[28970,29168,30394,32797],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [26316,26510,31620,32797],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[32797],[32797],[32797],[32797],
 [32797],[32797],[32797],[32797],[32797],[32797],[32797],[32797],[32797],[32797],
 [32797],[32797],[32797],[32797],[32797],[32797],[32797],[32797],[32797],[32797],
 [32797],[32797],[32797],[32797],[32797],[32797],[32797],[32797],[32797],[32797],
 [32797],[32797],[32797],[32797],[32797],[32797],[32797],[32797],[32797],[32797],
 [32797],[38205],[38205],[],[38331],[38331],[],[],[3507],[],[38557],[],
 [38557],[],[],[],[],[],[],[],[],[],[],[38921],[],[38921],[],[],
 [39015],[39015],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [38205],[39193],[39193],[],[39313],[39313],[],[39424],[39424],[],[],[],[],
 [],[],[],[5705],[],[],[39779],[],[39779],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[40055],[],[40055],[],
 [],[],[40287],[],[],[40287],[],[40450],[40450],[],[],[],[7828],[],
 [40642],[],[],[],[40642],[],[],[],[],[],[40824],[40824],[],[],[40870],
 [40870],[],[],[],[],[],[],[40914],[40914],[39193],[40055],[],[],[41069],
 [41069],[],[],[],[41239],[41239],[],[],[],[],[41411],[],[41411],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[38331],[],[],[41850],[],[41850],[],[],[],[],[],[42109],[42109],
 [],[42193],[],[],[],[42193],[],[],[],[42362],[42362],[],[],[],[],
 [42449],[42449],[],[],[],[42494],[42494],[],[],[],[],[],[],[],[42593],
 [],[],[],[42593],[42761],[],[42761],[],[],[],[42936],[],[],[],[],[],
 [42936],[],[43104],[],[43104],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[39313],[],[43330],[],[43330],[],[],[3756],[],[],[],[],
 [],[],[43685],[],[],[43685],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[44030],[44030],[],[],[],[],
 [],[],[],[],[],[],[],[44394],[44394],[],[],[],[8032],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[41069],[41850],[],[42593],
 [],[],[],[],[],[44904],[44904],[],[],[],[],[],[],[45084],[45084],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[39424],
 [43330],[40287],[],[],[],[],[],[45501],[],[],[45501],[],[],[],[],[],
 [],[],[],[45745],[45745],[],[],[],[45806],[],[45806],[],[],[],[],
 [45847],[45847],[],[44030],[38557],[],[],[],[],[],[46064],[],[],[],[],
 [46064],[],[],[46241],[],[46241],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[46593],[],[],[],[],[],
 [46593],[],[8168],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[47090],[],[],[],[],[],[],[47090],
 [47266],[],[],[47266],[47331],[],[47331],[],[],[],[47399],[47399],[],[],
 [],[],[47433],[],[47433],[41239],[42761],[],[],[],[47575],[47575],[],[],
 [],[],[],[],[6152],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[40450],[],[],[],[],[48035],[48035],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[48445],[],[],[],[],[48445],[],[],[],[6213],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[42109],[],[48796],[],[],
 [48796],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[49217],[49217],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[44904],[],
 [45501],[],[46064],[46593],[47090],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[47575],[41411],[48796],[42193],[],[42936],[],
 [],[],[],[],[],[],[],[50046],[],[],[],[50075],[],[50075],[50046],[],
 [],[],[48035],[],[],[4193],[48445],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[39779],[43685],[40642],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[49217],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[44394],[38921],[],[],[],[],[],[],[],[51006],[],[],[],[],[],
 [51050],[51050],[51006],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[45084],[46241],[47266],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[42362],[43104],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[39015],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[45745],[47331],[],[],[],[],[],[],[],[],[],
 [],[],[],[40824],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[42449],[],[],[],[],[14514],[],
 [51006],[],[],[],[],[],[],[14523],[],[],[50046],[],[],[],[40870],
 [45806],[],[],[],[],[],[19848],[],[47399],[],[],[],[],[],[],[19857],
 [],[],[],[],[19862],[],[],[42494],[50075],[],[],[],[],[51050],[],[],
 [],[],[14565],[],[],[],[],[],[],[45847],[47433],[40914],
 [27643,27841,30394,31620],[28970,29168,30394,32797],[30394],[30394],[30394],[30394],
 [30394],[30394],[30394],[30394],[30394],[30394],[30394],[30394],[30394],[30394],
 [30394],[30394],[30394],[30394],[30394],[30394],[30394],[30394],[30394],[30394],
 [30394],[30394],[30394],[30394],[30394],[30394],[30394],[30394],[30394],[30394],
 [30394],[30394],[30394],[30394],[30394],[30394],[30394],[30394],[30394],[30394],
 [30394],[26316,26510,31620,32797],[31620],[31620],[31620],[31620],[31620],[31620],
 [31620],[31620],[31620],[31620],[31620],[31620],[31620],[31620],[31620],[31620],
 [31620],[31620],[31620],[31620],[31620],[31620],[31620],[31620],[31620],[31620],
 [31620],[31620],[31620],[31620],[31620],[31620],[31620],[31620],[31620],[31620],
 [31620],[31620],[31620],[31620],[31620],[31620],[31620],[31620],[31620],[32797],
 [32797],[32797],[32797],[32797],[32797],[32797],[32797],[32797],[32797],[32797],
 [32797],[32797],[32797],[32797],[32797],[32797],[32797],[32797],[32797],[32797],
 [32797],[32797],[32797],[32797],[32797],[32797],[32797],[32797],[32797],[32797],
 [32797],[32797],[32797],[32797],[32797],[32797],[32797],[32797],[32797],[32797],
 [32797],[32797],[32797],[32797],[38205],[38205],[],[38331],[38331],[],[],[3507],
 [],[38557],[],[38557],[],[],[],[],[],[],[],[],[],[],[38921],[],
 [38921],[],[],[39015],[39015],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[38205],[39193],[39193],[],[39313],[39313],[],[39424],[39424],
 [],[],[],[],[],[],[],[5705],[],[],[39779],[],[39779],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[40055],
 [],[40055],[],[],[],[40287],[],[],[40287],[],[40450],[40450],[],[],[],
 [7828],[],[40642],[],[],[],[40642],[],[],[],[],[],[40824],[40824],[],
 [],[40870],[40870],[],[],[],[],[],[],[40914],[40914],[39193],[40055],[],
 [],[41069],[41069],[],[],[],[41239],[41239],[],[],[],[],[41411],[],
 [41411],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[38331],[],[],[41850],[],[41850],[],[],[],[],
 [],[42109],[42109],[],[42193],[],[],[],[42193],[],[],[],[42362],[42362],
 [],[],[],[],[42449],[42449],[],[],[],[42494],[42494],[],[],[],[],[],
 [],[],[42593],[],[],[],[42593],[42761],[],[42761],[],[],[],[42936],[],
 [],[],[],[],[42936],[],[43104],[],[43104],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[39313],[],[43330],[],[43330],[],[],[3756],
 [],[],[],[],[],[],[43685],[],[],[43685],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[44030],[44030],
 [],[],[],[],[],[],[],[],[],[],[],[44394],[44394],[],[],[],[8032],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[41069],
 [41850],[],[42593],[],[],[],[],[],[44904],[44904],[],[],[],[],[],[],
 [45084],[45084],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[39424],[43330],[40287],[],[],[],[],[],[45501],[],[],[45501],[],
 [],[],[],[],[],[],[],[45745],[45745],[],[],[],[45806],[],[45806],[],
 [],[],[],[45847],[45847],[],[44030],[38557],[],[],[],[],[],[46064],[],
 [],[],[],[46064],[],[],[46241],[],[46241],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[46593],[],[],
 [],[],[],[46593],[],[8168],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[47090],[],[],[],[],[],
 [],[47090],[47266],[],[],[47266],[47331],[],[47331],[],[],[],[47399],
 [47399],[],[],[],[],[47433],[],[47433],[41239],[42761],[],[],[],[47575],
 [47575],[],[],[],[],[],[],[6152],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[40450],[],[],[],[],[48035],[48035],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[48445],[],[],[],[],[48445],[],[],[],[6213],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[42109],[],
 [48796],[],[],[48796],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[49217],[49217],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [44904],[],[45501],[],[46064],[46593],[47090],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[47575],[41411],[48796],[42193],[],
 [42936],[],[],[],[],[],[],[],[],[50046],[],[],[],[50075],[],[50075],
 [50046],[],[],[],[48035],[],[],[4193],[48445],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[39779],[43685],[40642],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [49217],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[44394],[38921],[],[],[],[],[],[],[],[51006],[],[],
 [],[],[],[51050],[51050],[51006],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[45084],[46241],[47266],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[42362],[43104],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[39015],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[45745],[47331],[],[],[],[],[],[],
 [],[],[],[],[],[],[40824],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[42449],[],[],[],[],
 [14514],[],[51006],[],[],[],[],[],[],[14523],[],[],[50046],[],[],[],
 [40870],[45806],[],[],[],[],[],[19848],[],[47399],[],[],[],[],[],[],
 [19857],[],[],[],[],[19862],[],[],[42494],[50075],[],[],[],[],[51050],
 [],[],[],[],[14565],[],[],[],[],[],[],[45847],[47433],[40914],
 [26160,26510,27841,29168],[27841],[27841],[27841],[27841],[27841],[27841],[27841],
 [27841],[27841],[27841],[27841],[27841],[27841],[27841],[27841],[27841],[27841],
 [27841],[27841],[27841],[27841],[27841],[27841],[27841],[27841],[27841],[27841],
 [27841],[27841],[27841],[27841],[27841],[27841],[27841],[27841],[27841],[27841],
 [27841],[27841],[27841],[27841],[27841],[27841],[27841],[27841],[29168],[29168],
 [29168],[29168],[29168],[29168],[29168],[29168],[29168],[29168],[29168],[29168],
 [29168],[29168],[29168],[29168],[29168],[29168],[29168],[29168],[29168],[29168],
 [29168],[29168],[29168],[29168],[29168],[29168],[29168],[29168],[29168],[29168],
 [29168],[29168],[29168],[29168],[29168],[29168],[29168],[29168],[29168],[29168],
 [29168],[29168],[29168],[38205],[38205],[],[38331],[38331],[],[],[3507],[],
 [38557],[],[38557],[],[],[],[],[],[],[],[],[],[],[38921],[],[38921],
 [],[],[39015],[39015],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[38205],[39193],[39193],[],[39313],[39313],[],[39424],[39424],[],[],
 [],[],[],[],[],[5705],[],[],[39779],[],[39779],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[40055],[],
 [40055],[],[],[],[40287],[],[],[40287],[],[40450],[40450],[],[],[],
 [7828],[],[40642],[],[],[],[40642],[],[],[],[],[],[40824],[40824],[],
 [],[40870],[40870],[],[],[],[],[],[],[40914],[40914],[39193],[40055],[],
 [],[41069],[41069],[],[],[],[41239],[41239],[],[],[],[],[41411],[],
 [41411],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[38331],[],[],[41850],[],[41850],[],[],[],[],
 [],[42109],[42109],[],[42193],[],[],[],[42193],[],[],[],[42362],[42362],
 [],[],[],[],[42449],[42449],[],[],[],[42494],[42494],[],[],[],[],[],
 [],[],[42593],[],[],[],[42593],[42761],[],[42761],[],[],[],[42936],[],
 [],[],[],[],[42936],[],[43104],[],[43104],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[39313],[],[43330],[],[43330],[],[],[3756],
 [],[],[],[],[],[],[43685],[],[],[43685],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[44030],[44030],
 [],[],[],[],[],[],[],[],[],[],[],[44394],[44394],[],[],[],[8032],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[41069],
 [41850],[],[42593],[],[],[],[],[],[44904],[44904],[],[],[],[],[],[],
 [45084],[45084],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[39424],[43330],[40287],[],[],[],[],[],[45501],[],[],[45501],[],
 [],[],[],[],[],[],[],[45745],[45745],[],[],[],[45806],[],[45806],[],
 [],[],[],[45847],[45847],[],[44030],[38557],[],[],[],[],[],[46064],[],
 [],[],[],[46064],[],[],[46241],[],[46241],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[46593],[],[],
 [],[],[],[46593],[],[8168],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[47090],[],[],[],[],[],
 [],[47090],[47266],[],[],[47266],[47331],[],[47331],[],[],[],[47399],
 [47399],[],[],[],[],[47433],[],[47433],[41239],[42761],[],[],[],[47575],
 [47575],[],[],[],[],[],[],[6152],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[40450],[],[],[],[],[48035],[48035],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[48445],[],[],[],[],[48445],[],[],[],[6213],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[42109],[],
 [48796],[],[],[48796],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[49217],[49217],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [44904],[],[45501],[],[46064],[46593],[47090],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[47575],[41411],[48796],[42193],[],
 [42936],[],[],[],[],[],[],[],[],[50046],[],[],[],[50075],[],[50075],
 [50046],[],[],[],[48035],[],[],[4193],[48445],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[39779],[43685],[40642],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [49217],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[44394],[38921],[],[],[],[],[],[],[],[51006],[],[],
 [],[],[],[51050],[51050],[51006],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[45084],[46241],[47266],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[42362],[43104],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[39015],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[45745],[47331],[],[],[],[],[],[],
 [],[],[],[],[],[],[40824],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[42449],[],[],[],[],
 [14514],[],[51006],[],[],[],[],[],[],[14523],[],[],[50046],[],[],[],
 [40870],[45806],[],[],[],[],[],[19848],[],[47399],[],[],[],[],[],[],
 [19857],[],[],[],[],[19862],[],[],[42494],[50075],[],[],[],[],[51050],
 [],[],[],[],[14565],[],[],[],[],[],[],[45847],[47433],[40914],[26510],
 [26510],[26510],[26510],[26510],[26510],[26510],[26510],[26510],[26510],[26510],
 [26510],[26510],[26510],[26510],[26510],[26510],[26510],[26510],[26510],[26510],
 [26510],[26510],[26510],[26510],[26510],[26510],[26510],[26510],[26510],[26510],
 [26510],[26510],[26510],[26510],[26510],[26510],[26510],[26510],[26510],[26510],
 [26510],[26510],[26510],[26510],[38205],[38205],[],[38331],[38331],[],[],[3507],
 [],[38557],[],[38557],[],[],[],[],[],[],[],[],[],[],[38921],[],
 [38921],[],[],[39015],[39015],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[38205],[39193],[39193],[],[39313],[39313],[],[39424],[39424],
 [],[],[],[],[],[],[],[5705],[],[],[39779],[],[39779],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[40055],
 [],[40055],[],[],[],[40287],[],[],[40287],[],[40450],[40450],[],[],[],
 [7828],[],[40642],[],[],[],[40642],[],[],[],[],[],[40824],[40824],[],
 [],[40870],[40870],[],[],[],[],[],[],[40914],[40914],[39193],[40055],[],
 [],[41069],[41069],[],[],[],[41239],[41239],[],[],[],[],[41411],[],
 [41411],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[38331],[],[],[41850],[],[41850],[],[],[],[],
 [],[42109],[42109],[],[42193],[],[],[],[42193],[],[],[],[42362],[42362],
 [],[],[],[],[42449],[42449],[],[],[],[42494],[42494],[],[],[],[],[],
 [],[],[42593],[],[],[],[42593],[42761],[],[42761],[],[],[],[42936],[],
 [],[],[],[],[42936],[],[43104],[],[43104],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[39313],[],[43330],[],[43330],[],[],[3756],
 [],[],[],[],[],[],[43685],[],[],[43685],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[44030],[44030],
 [],[],[],[],[],[],[],[],[],[],[],[44394],[44394],[],[],[],[8032],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[41069],
 [41850],[],[42593],[],[],[],[],[],[44904],[44904],[],[],[],[],[],[],
 [45084],[45084],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[39424],[43330],[40287],[],[],[],[],[],[45501],[],[],[45501],[],
 [],[],[],[],[],[],[],[45745],[45745],[],[],[],[45806],[],[45806],[],
 [],[],[],[45847],[45847],[],[44030],[38557],[],[],[],[],[],[46064],[],
 [],[],[],[46064],[],[],[46241],[],[46241],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[46593],[],[],
 [],[],[],[46593],[],[8168],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[47090],[],[],[],[],[],
 [],[47090],[47266],[],[],[47266],[47331],[],[47331],[],[],[],[47399],
 [47399],[],[],[],[],[47433],[],[47433],[41239],[42761],[],[],[],[47575],
 [47575],[],[],[],[],[],[],[6152],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[40450],[],[],[],[],[48035],[48035],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[48445],[],[],[],[],[48445],[],[],[],[6213],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[42109],[],
 [48796],[],[],[48796],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[49217],[49217],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [44904],[],[45501],[],[46064],[46593],[47090],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[47575],[41411],[48796],[42193],[],
 [42936],[],[],[],[],[],[],[],[],[50046],[],[],[],[50075],[],[50075],
 [50046],[],[],[],[48035],[],[],[4193],[48445],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[39779],[43685],[40642],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [49217],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[44394],[38921],[],[],[],[],[],[],[],[51006],[],[],
 [],[],[],[51050],[51050],[51006],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[45084],[46241],[47266],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[42362],[43104],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[39015],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[45745],[47331],[],[],[],[],[],[],
 [],[],[],[],[],[],[40824],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[42449],[],[],[],[],
 [14514],[],[51006],[],[],[],[],[],[],[14523],[],[],[50046],[],[],[],
 [40870],[45806],[],[],[],[],[],[19848],[],[47399],[],[],[],[],[],[],
 [19857],[],[],[],[],[19862],[],[],[42494],[50075],[],[],[],[],[51050],
 [],[],[],[],[14565],[],[],[],[],[],[],[45847],[47433],[40914],[38205],
 [38205],[],[38331],[38331],[],[],[3507],[],[38557],[],[38557],[],[],[],
 [],[],[],[],[],[],[],[38921],[],[38921],[],[],[39015],[39015],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[38205],[39193],[39193],
 [],[39313],[39313],[],[39424],[39424],[],[],[],[],[],[],[],[5705],[],
 [],[39779],[],[39779],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[40055],[],[40055],[],[],[],[40287],[],
 [],[40287],[],[40450],[40450],[],[],[],[7828],[],[40642],[],[],[],
 [40642],[],[],[],[],[],[40824],[40824],[],[],[40870],[40870],[],[],[],
 [],[],[],[40914],[40914],[39193],[40055],[],[],[41069],[41069],[],[],[],
 [41239],[41239],[],[],[],[],[41411],[],[41411],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[38331],[],
 [],[41850],[],[41850],[],[],[],[],[],[42109],[42109],[],[42193],[],[],
 [],[42193],[],[],[],[42362],[42362],[],[],[],[],[42449],[42449],[],[],
 [],[42494],[42494],[],[],[],[],[],[],[],[42593],[],[],[],[42593],
 [42761],[],[42761],[],[],[],[42936],[],[],[],[],[],[42936],[],[43104],
 [],[43104],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [39313],[],[43330],[],[43330],[],[],[3756],[],[],[],[],[],[],[43685],
 [],[],[43685],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[44030],[44030],[],[],[],[],[],[],[],[],
 [],[],[],[44394],[44394],[],[],[],[8032],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[41069],[41850],[],[42593],[],[],[],[],
 [],[44904],[44904],[],[],[],[],[],[],[45084],[45084],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[39424],[43330],[40287],[],
 [],[],[],[],[45501],[],[],[45501],[],[],[],[],[],[],[],[],
 [45745],[45745],[],[],[],[45806],[],[45806],[],[],[],[],[45847],[45847],
 [],[44030],[38557],[],[],[],[],[],[46064],[],[],[],[],[46064],[],[],
 [46241],[],[46241],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[46593],[],[],[],[],[],[46593],[],[8168],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[47090],[],[],[],[],[],[],[47090],[47266],[],[],[47266],
 [47331],[],[47331],[],[],[],[47399],[47399],[],[],[],[],[47433],[],
 [47433],[41239],[42761],[],[],[],[47575],[47575],[],[],[],[],[],[],
 [6152],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [40450],[],[],[],[],[48035],[48035],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [48445],[],[],[],[],[48445],[],[],[],[6213],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[42109],[],[48796],[],[],[48796],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[49217],[49217],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[44904],[],[45501],[],[46064],
 [46593],[47090],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[47575],[41411],[48796],[42193],[],[42936],[],[],[],[],[],
 [],[],[],[50046],[],[],[],[50075],[],[50075],[50046],[],[],[],[48035],
 [],[],[4193],[48445],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[39779],[43685],[40642],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[49217],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[44394],
 [38921],[],[],[],[],[],[],[],[51006],[],[],[],[],[],[51050],[51050],
 [51006],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[45084],[46241],[47266],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[42362],[43104],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[39015],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[45745],[47331],[],[],[],[],[],[],[],[],[],[],[],[],
 [40824],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[42449],[],[],[],[],[14514],[],[51006],[],
 [],[],[],[],[],[14523],[],[],[50046],[],[],[],[40870],[45806],[],[],
 [],[],[],[19848],[],[47399],[],[],[],[],[],[],[19857],[],[],[],
 [],[19862],[],[],[42494],[50075],[],[],[],[],[51050],[],[],[],[],
 [14565],[],[],[],[],[],[],[45847],[47433],[40914],[],
 [38205,38331,39193,40055],[38205,38331,39193,40055],[38205,38331,39193,40055],[38205,39313],
 [38205,39313],[3507,38205],[38205,38557,39424,40287],[38205,38557,39424,40287],[38205],
 [38205,38557,39424,40287],[38205],[38205,40450],[38205,40450],[38205],[38205],
 [5705,38205],[7828,38205],[38205],[38205,38921,39779,40642],[38205],
 [38205,38921,39779,40642],[38205],[38205,38921,39779,40642],[38205],[38205],[38205,39015],
 [38205,39015],[38205],[38205,40824],[38205,40824],[38205],[38205],[38205,40870],
 [38205,40870],[38205],[38205],[38205],[38205],[38205],[38205],[38205,40914],
 [38205,40914],[38205,38331,39193,40055],[38205,38331,39193,40055],[38205,38331,39193,40055],
 [38205,39313],[38205,39313],[3507,38205],[38205,38557,39424,40287],[38205,38557,39424,40287],
 [38205],[38205,38557,39424,40287],[38205],[38205,40450],[38205,40450],[38205],[38205],
 [5705,38205],[7828,38205],[38205],[38205,38921,39779,40642],[38205],
 [38205,38921,39779,40642],[38205],[38205,38921,39779,40642],[38205],[38205],[38205,39015],
 [38205,39015],[38205],[38205,40824],[38205,40824],[38205],[38205],[38205,40870],
 [38205,40870],[38205],[38205],[38205],[38205],[38205],[38205],[38205,40914],
 [38205,40914],[38205,38331,39193,40055],[38205,38331,39193,40055],[],[],[3507,41069],
 [3507,41069],[38557],[],[38557],[41239],[41239],[],[],[],[],[41411],[],
 [41411],[],[38921],[],[38921],[],[],[39015],[39015],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[38331],[38331],
 [3507,3677,3714,38331,38557,41850,42593],[38331],[3507,3677,3714,38331,38557,41850,42593],
 [38331],[3507,3677,3714,38331,38557,41850,42593],[38331,42761],[38331],[38331,42761],
 [38331,42109],[38331,42109],[38331],[38331,38921,42193,42936],[38331],[38331],[38331],
 [38331,38921,42193,42936],[38331],[38331,38921,42193,42936],[38331],
 [38331,39015,42362,43104],[38331,39015,42362,43104],[38331,39015,42362,43104],[38331],
 [38331],[38331],[38331,42449],[38331,42449],[38331],[38331],[38331],[38331,42494],
 [38331,42494],[38331],[38331],[38331],[38331],[38331],[38331],[38331],
 [3507,3677,3714,38331,38557,41850,42593],[38331],[3507,3677,3714,38331,38557,41850,42593],
 [38331],[3507,3677,3714,38331,38557,41850,42593],[38331,42761],[38331],[38331,42761],
 [38331,42109],[38331,42109],[38331],[38331,38921,42193,42936],[38331],[38331],[38331],
 [38331,38921,42193,42936],[38331],[38331,38921,42193,42936],[38331],
 [38331,39015,42362,43104],[38331,39015,42362,43104],[38331,39015,42362,43104],[38331],
 [38331],[38331],[38331,42449],[38331,42449],[38331],[38331],[38331],[38331,42494],
 [38331,42494],[38331],[38331],[38331],[38331],[38331],[38205,39313],[3507,3756],
 [43330],[38557],[43330],[38557],[],[3507,3756],[],[],[],[],[],[],[43685],
 [],[38921],[43685],[38921],[],[],[39015],[39015],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[3507,3794,38455,43965],[],[38557,44030],
 [38557,44030],[38557,44030],[],[],[],[],[],[],[],[],[],[],[38921,44394],
 [38921,44394],[38921,44394],[],[],[7725,7726,7743,7769,7786,7815,7816,7828,7837,7838,7986,
   7996,8023,8032,8398,8399,38205,38209,38210,38222,38231,38232,38251,38252,38264,38273,38274,
   38410,38431,38432,39015,39154,39155,39167,39176,39177,39313,39335,39372,39918,40174,40186,40195,
   40196,40223,40232,40233,40598,40599,40779,43277,43643,43823,44308],
 [7725,7726,7743,7769,7786,7815,7816,7828,7837,7838,7986,7996,8023,8032,8398,8399,38205,38209,
   38210,38222,38231,38232,38251,38252,38264,38273,38274,38410,38431,38432,39015,39154,39155,39167,
   39176,39177,39313,39335,39372,39918,40174,40186,40195,40196,40223,40232,40233,40598,40599,40779,
   43277,43643,43823,44308],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[3507,41069],[3507,3677,3714,38331,38557,41850,42593],[3507,3930,38591,44695],
 [3507,3677,3714,38331,38557,41850,42593],[3507,3930,38591,44695],[3507,3756],
 [3507,3794,38455,43965],[3507],[3507],[3507,44904],[3507,44904],[3507,4193],[3507],
 [3507],[3507,38921],[3507,4193],[3507,38921],[3507,45084],[3507,45084],[3507,39015],
 [3507,39015],[3507],[3507],[3507],[3507],[3507],[3507],[3507],[3507],[3507],
 [3507],[3507],[3507],[3507],[3507],[3507],[38205,38557,39424,40287],[43330],
 [38205,38557,39424,40287],[],[],[],[],[],[45501],[],[],[45501],[],[38921],
 [],[38921],[],[],[39015],[39015],[45745],[45745],[],[],[],[45806],[],
 [45806],[],[],[],[],[45847],[45847],[],[38557,44030],[],[38557],[38557],
 [38557],[38557],[38557],[38557,38921,46064,47090],[38557],[38557],[38557],[38557],
 [38557,38921,46064,47090],[38557],[38557,38921,46064,47090],[38557,39015,46241,47266],
 [38557],[38557,39015,46241,47266],[38557,39015,46241,47266],[38557,47331],[38557],
 [38557,47331],[38557],[38557],[38557],[38557,47399],[38557,47399],[38557],[38557],
 [38557],[38557],[38557,47433],[38557],[38557,47433],[38557,44030],[],[],[],[],
 [],[46593],[],[],[],[],[38921],[46593],[38921],
 [7725,7726,7743,7769,7786,7820,7828,7835,8161,8168,8396,38205,38214,38222,38229,38256,38264,
   38271,39159,39167,39174,40361,40368,40596,46620],[],[39015],[39015],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[38557],[38557],[38557],[38557],
 [38557],[38557,38921,46064,47090],[38557],[38557],[38557],[38557],
 [38557,38921,46064,47090],[38557],[38557,38921,46064,47090],[38557,39015,46241,47266],
 [38557],[38557,39015,46241,47266],[38557,39015,46241,47266],[38557,47331],[38557],
 [38557,47331],[38557],[38557],[38557],[38557,47399],[38557,47399],[38557],[38557],
 [38557],[38557],[38557,47433],[38557],[38557,47433],[41239],[38331,42761],[],[],[],
 [47575],[47575],[],[],[38921],[],[38921],[],
 [5645,5646,5662,5689,5700,5705,5714,5747,6143,6152,6292,38205,38216,38221,38230,38258,38263,
   38272,39161,39166,39175,39562,39571,39711,47557],[39015],[39015],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[38205,40450],[],[],[],[],[48035],
 [48035],[],[38921],[],[38921],[],[],[39015],[39015],[],[38707,39064],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[38921,48445],[],
 [],[38921,48445],[],[38921,48445],[],[],
 [5645,5646,5662,5689,5701,5702,5705,5715,5716,5747,6173,6183,6202,6213,6293,6294,38205,38217,
   38218,38221,38231,38232,38259,38260,38263,38273,38274,38686,38699,38700,39015,39162,39163,39166,
   39176,39177,39589,39592,39602,39603,39621,39631,39632,39712,39713,39918,40450,40463,40492,40779,
   47912,47993,48199,48400],[5645,5646,5662,5689,5701,5702,5705,5715,5716,5747,6173,6183,6202,
   6213,6293,6294,38205,38217,38218,38221,38231,38232,38259,38260,38263,38273,38274,38686,38699,
   38700,39015,39162,39163,39166,39176,39177,39589,39592,39602,39603,39621,39631,39632,39712,39713,
   39918,40450,40463,40492,40779,47912,47993,48199,48400],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[38331,42109],[],[48796],[],[],[48796],
 [38921],[],[38921],[],[],[39015],[39015],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[38921,49217],[38921,49217],[],
 [38921,49217],[],[],[39015],[39015],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[3507,44904],[],[45501],[],[38557,38921,46064,47090],[46593],
 [38557,38921,46064,47090],[],[],[39015],[39015],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[47575],[41411],[48796],[38331,38921,42193,42936],[],
 [38331,38921,42193,42936],[],[],[39015],[39015],[],[],[],[],[50046],[],[],
 [],[50075],[],[50075],[50046],[],[],[],[48035],[],[38921,48445],[3507,4193],
 [38921,48445],[],[],[39015],[39015],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[38205,38921,39779,40642],[43685],[38205,38921,39779,40642],
 [],[],[39015],[39015],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[38921,49217],[38908,38949],[38921,49217],[],[],[39015],[39015],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[38921,44394],[],[38921],
 [38921],[38921,39015],[38921,39015],[38921],[38921],[38921],[38921,51006],[38921],
 [38921],[38921],[38921],[38921],[38921,51050],[38921,51050],[38921,51006],[38921],
 [38921],[38921],[38921,44394],[],[],[39015],[39015],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[38921],[38921],[38921,39015],[38921,39015],
 [38921],[38921],[38921],[38921,51006],[38921],[38921],[38921],[38921],[38921],
 [38921,51050],[38921,51050],[38921,51006],[38921],[38921],[38921],[3507,45084],
 [38557,39015,46241,47266],[38557,39015,46241,47266],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[38331,39015,42362,43104],[38331,39015,42362,43104],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[39015],[39015],
 [39015],[39015],[39015],[39015],[39015],[39015],[39015],[39015],[39015],[39015],
 [39015],[39015],[39015],[39015],[39015],[39015],[39015],[39015],[39015],[39015],
 [39015],[39015],[39015],[39015],[39015],[39015],[39015],[39015],[45745],[38557,47331],
 [],[],[],[],[],[],[],[],[],[],[],[],[38205,40824],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[38331,42449],[],[],[],[],[14514],[],[38921,51006],[],[],[],[],[],
 [],[14523],[],[],[50046],[],[],[],[38205,40870],[45806],[],[],[],[],
 [],[19848],[],[38557,47399],[],[],[],[],[],[],[19857],[],[],[],[],
 [19862],[],[],[38331,42494],[50075],[],[],[],[],[38921,51050],[],[],[],
 [],[14565],[],[],[],[],[],[],[45847],[38557,47433],[38205,40914],
 [38205,38331,39193,40055],[38205,38331,39193,40055],[38205,38331,39193,40055],[38205,39313],
 [38205,39313],[3507,38205],[38205,38557,39424,40287],[38205,38557,39424,40287],[38205],
 [38205,38557,39424,40287],[38205],[38205,40450],[38205,40450],[38205],[38205],
 [5705,38205],[7828,38205],[38205],[38205,38921,39779,40642],[38205],
 [38205,38921,39779,40642],[38205],[38205,38921,39779,40642],[38205],[38205],[38205,39015],
 [38205,39015],[38205],[38205,40824],[38205,40824],[38205],[38205],[38205,40870],
 [38205,40870],[38205],[38205],[38205],[38205],[38205],[38205],[38205,40914],
 [38205,40914],[],[38205,38331,39193,40055],[39193,39313],[39193,39313],
 [39193,39424,41069,41850],[39193,39424,41069,41850],[39193,39424,41069,41850],[39193],
 [39193],[39193,41239],[39193,41239],[39193],[39193,42109],[39193,42109],[5705,39193],
 [39193,39779,41411,42193],[39193],[39193,39779,41411,42193],[39193],
 [39193,39779,41411,42193],[39193],[39193],[39193],[39193,42362],[39193,42362],[39193],
 [39193],[39193],[39193],[39193,42449],[39193,42449],[39193],[39193],[39193],
 [39193,42494],[39193,42494],[39193],[39193],[39193],[39193],[39193],
 [38205,38331,39193,40055],[39193,39313],[39193,39313],[39193,39424,41069,41850],
 [39193,39424,41069,41850],[39193,39424,41069,41850],[39193],[39193],[39193,41239],
 [39193,41239],[39193],[39193,42109],[39193,42109],[5705,39193],[39193,39779,41411,42193],
 [39193],[39193,39779,41411,42193],[39193],[39193,39779,41411,42193],[39193],[39193],
 [39193],[39193,42362],[39193,42362],[39193],[39193],[39193],[39193],[39193,42449],
 [39193,42449],[39193],[39193],[39193],[39193,42494],[39193,42494],[39193],[39193],
 [39193],[39193],[39193],[39313],[39313],[42593],[39424],[39424],[],[42593],[42761],
 [],[42761],[],[],[5705],[42936],[],[39779],[],[39779],[],[42936],[],
 [43104],[],[43104],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[39313],[39313,39424,43330,44030],[39313,39424,43330,44030],
 [39313,39424,43330,44030],[39313],[39313],
 [3500,3501,3505,3506,3507,3513,3514,3544,3550,3592,3750,3756,3787,3794,3829,3830,38205,38209,
   38210,38211,38217,38218,38251,38252,38253,38259,38260,38410,38411,38417,38418,38448,38454,38455,
   38490,38491,38686,39154,39155,39156,39162,39163,39313,39321,39358,39589,40174,40218,40219,40450,
   43263,43298,43965,44160],[39313],[39313],[39313],[5705,39313],[39313],[39313],
 [39313,39779,43685,44394],[39313],[39313,39779,43685,44394],[39313,39779,43685,44394],
 [39313],[39313],[39313],[7725,7726,7743,7769,7786,7815,7816,7828,7837,7838,7986,7996,8023,
   8032,8398,8399,38205,38209,38210,38222,38231,38232,38251,38252,38264,38273,38274,38410,38431,
   38432,39015,39154,39155,39167,39176,39177,39313,39335,39372,39918,40174,40186,40195,40196,40223,
   40232,40233,40598,40599,40779,43277,43643,43823,44308],[39313],[39313],[39313],[39313],
 [39313],[39313],[39313],[39313],[39313],[39313],[39313],[39313],[39313],[39313],
 [39313],[39313],[39313],[39313,39424,43330,44030],[39313,39424,43330,44030],
 [39313,39424,43330,44030],[39313],[39313],
 [3500,3501,3505,3506,3507,3513,3514,3544,3550,3592,3750,3756,3787,3794,3829,3830,38205,38209,
   38210,38211,38217,38218,38251,38252,38253,38259,38260,38410,38411,38417,38418,38448,38454,38455,
   38490,38491,38686,39154,39155,39156,39162,39163,39313,39321,39358,39589,40174,40218,40219,40450,
   43263,43298,43965,44160],[39313],[39313],[39313],[5705,39313],[39313],[39313],
 [39313,39779,43685,44394],[39313],[39313,39779,43685,44394],[39313,39779,43685,44394],
 [39313],[39313],[39313],[7725,7726,7743,7769,7786,7815,7816,7828,7837,7838,7986,7996,8023,
   8032,8398,8399,38205,38209,38210,38222,38231,38232,38251,38252,38264,38273,38274,38410,38431,
   38432,39015,39154,39155,39167,39176,39177,39313,39335,39372,39918,40174,40186,40195,40196,40223,
   40232,40233,40598,40599,40779,43277,43643,43823,44308],[39313],[39313],[39313],[39313],
 [39313],[39313],[39313],[39313],[39313],[39313],[39313],[39313],[39313],[39313],
 [39313],[39313],[39193,39424,41069,41850],[39193,39424,41069,41850],[],[42593],[],[],
 [],[],[],[5705,44904],[5705,44904],[],[39779],[],[39779],[],[],[45084],
 [45084],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
 [],[39313,39424,43330,44030],[38205,38557,39424,40287],[39424],[39424],[39424],[39424],
 [39424],[5705,6018,6050,39424,39779,45501,46064],[39424],[39424],
 [5705,6018,6050,39424,39779,45501,46064],[39424],[5705,6018,6050,39424,39779,45501,46064],
 [39424],[39424],[39424,46241],[39424],[394