#############################################################################
##
#W  partitionlengths.g            GAP4 Package `RCWA'             Stefan Kohl
##
##  List of lengths of shortest respected partitions of the groups
##  generated by 3 class transpositions which interchange residue classes
##  with moduli <= 9. Unbound entries stand for wild groups.
##
return
[,,[,[]],[,[],[]],[,[],[],[]],[,[],[],[],[]],
 [,[],[],[],[],[]],[,[],[],[],[],[,,4],[]],
 [,[],[],[],[,,,4],[],[,,,5],[]],
 [,[],[],[],[],[],[,4,,5],[],[,,,5,,,5]],
 [,[],[],[],[],[],[],[],[],[]],
 [,[],[],[],[,12],[],[,13],[,,,,,13],[],[,15,,,,,,,19],[]],
 [,[],[],[],[],[],[],[,,16],[],[],[],[]],
 [,[],[],[],[,9],[,,12],[,,,15],[,,12,,,10],[,,,14,,,15],
   [,,,15,,,14,,15],[6],[,10,,,,13,17,13],[,,12,,,,48]],
 [,[],[],[],[,15],[],[,21],[,,13],[,,,,21,,27],[],
   [,,,,,,,10],[,14,,,,,19,11],[,,14,,,,46,16],[]],
 [,[],[],[],[,27,,28],[,,22],[,20,,33],[,,18],[,,,,48,,37],
   [,,,39,,,32,,61],[,,,,,,,18],[,16,,,,23,21,17],[,,18,,31,,44,24],
   [],[]],[,[],[],[],[,,,21],[],[,,,27],[,,13],[],
   [,,,27,,,21],[],[,,,,15,,,11,,23],[],[,,10,,,,22,,,,,4],
   [,,12,,17,,24,12,,,,5],[,,16,,,,26,20,,,,6]],
 [,[],[],[],[],[],[,,,39],[,,18,,,22],[,,,46,44],
   [,,,37,,,36,,49],[],[],[,,,,28,,,14],[,,16,,,22,23,22,,47,,,5],
   [,43,20,,,,30,16,,,,,6],[,45,22,51,21,32,31,22,55,55,,,7],[]],
 [,[],[],[],[],[,,13],[,,,27],[],[],[,13,,25],[,,,,16],
   [,11,,,13,14,15,,,17],[,,13,,,,40],[],[,,11,,15,,,,,,4,5,6],[],
   [8,,11,,,,20,,,,,5,,,5],[,36,17,,,23,25,,,,,,6,,6]],
 [,[],[],[],[,36],[],[],[,,16],[],[],[,,,,,,,12],
   [,20,,,,,,13],[,,18,,,,,18],[],[],[,,14,,29,,,,,,5,6,7],
   [,,16,,,,,14,,,,6,,,,6],[,73,24,,,,,18,,,,,7,,,7],[]],
 [,[],[],[],[],[],[],[,,16],[],[],[],[],[,,12,,29,,,14],
   [,,12,,,,48,,,,,,5],[,,,,,,46,16,,,,,6],[,,,,,,44,24,,,,,7],[],
   [,,,,28,,,14,,,,,5,5,6,7],[,,13,,,,40,,,,,,6,,6,,,6],
   [,,24,,31,,,18,,,,,7,,,7,,7]],
 [,[],[],[],[,,,44],[,,22],[],[,,16],[,,,46,,,41],
   [,,,35,,,30],[,,,,,,,12],[,16,,,,23,25,13],[,,18,,,,56],[],[],
   [22,15,14,31,19,22,23,18,35,33,5,6,7],[,,16,,,,30,,,,,6,,,,6],
   [,,22,55,21,32,31,22,51,51,,,7,,,7],[],
   [,24,14,,28,,,12,,,5,6,7,,,5,6,7],[,,,,,,56,,,,,,7,,,7,,7,,7]],
 [,[],[],[],[],[],[],[],[],[,,,,,,7],[12,,,,23],[],[],
   [12,,,,,,,,,,12],[],[36,,,,41,60,42,,,50,38],[16,,,,22,,27,,,27,,,,17],
   [36,,,,,,,,,80,,,,,,44],[16,,,,18,31,23,,,31,17,,,,,,16],[],
   [,,,,91,,106,,,,,,,,,42,,30,51],[36,,,,,,,,,,,,,,,30,53,48,,,46]],
 [,[],[],[],[],[],[],[,,,,,7],[],[],[],[],[],
   [,,,,,21,,21],[,,,,,,,18],[,,,,,37,,31],[,,,,,,,19,,,,,,13,14,21],
   [,,,,,,,26,,,,,,17,18,29],[,,,,,23,,,,,,,,,14,,15,19],
   [,,,,,,,27,,,,,,,,22,24],[,,,,,,,47,,,,,,39,40,47,,,39,45],
   [,,,,,37,,27,,,,,,,,19,21,29,,22,47],[]],
 [,[],[],[],[,6],[],[,7],[],[,,,,7,,8],[,7,,,,,8,,8],[],
   [,17,,,23,39,23,,23,25],[],[,17,,,18,,25,,22,,,20],
   [,21,,,29,,35,,29,,,22],[,25,,,42,86,35,,59,59,,27],
   [,,,,29,,34,,,34,,23,,24,27,31],[,51,,,62,,55,,66,,,,,46,56,56],
   [,17,,,25,42,24,,,23,,19,,,26,,23,48],[,29,,,60,,,,,,,31,,,,,41,89],
   [,,,,115,,152,,,,,,,52,47,51,,52,43,69],
   [,27,,,,,,,56,53,,30,,,,28,34,62,,36,68],[],[]],
 [,[],[],[],[,6,,7],[,,7],[,7,,8],[,,7,,,7],[,,,7,7,,8],
   [,7,,8,,,7,,8],[12,,,,,,,16],[,17,,,,21,22,16,26,24],[,,31,,,,,36],
   [12,17,14,22,17,19,22,19,22,22,12,11,24],[],[],[],
   [,79,45,82,73,57,52,40,88,84,,,28],
   [,17,16,,,21,,,,22,14,13,28,,,,,27],[,,36,,,,,31,,,,28,36,,,,,46],
   [,,31,,,,,36,,,,,26,24,,,,28,28,36],
   [,49,40,84,73,57,54,43,82,84,36,27,54,,,,,,,28,46],
   [4,,,,5,,6,,,6,12,,,12,,,,56,,,,56],[,,,,,6,,6,,,,,,11,,,,33,13,29,,31],
   [,5,,,6,,7,,6,7,,17,,17,,,,61,17,52,77,41]],
 [,[],[],[],[,9,,10],[,,10],[,10,,11],[,,10,,,10],
   [,,,10,10,,11],[,10,,11,,,10,,11],[30,,,,39,,,24],
   [,24,,,25,31,31,23,30,29],[,,34,,115,,,38],[],
   [,41,22,,,,,22,50,,25,16,33],[],[28,,31,40,29,,,31,,38,,25],
   [,95,40,90,79,48,46,34,96,90,,,26,,21],
   [28,,23,33,34,31,28,,,31,21,18,29,,16,,25,23],
   [,,50,,99,,,42,,,50,41,46,,,,72,50],[,,,,,,84,38,,,,,34,,33,,,26,29,58],
   [,69,58,94,81,84,82,58,96,94,44,41,52,,,,66,52,,44,52],
   [6,,,,7,,8,,,8,20,,,,,,23,37,22,,44,51],
   [,,,,,8,,8,,,,,,,15,,23,22,17,38,60,40],
   [,7,,,8,,9,,8,9,,21,,,27,,29,48,,64,,50],[]],
 [,[],[],[],[],[],[],[,,14],[,,,7],[],[12,,,,,,,20],
   [,,,,,,,24],[,,30,,,,,36],[12,,20,,,,,,,,12,15,20],
   [,23,27,,,,,,29,,15,18,23],[,25,36,46,,,,,58,,20,23,28],
   [,,,27,,,,27,,,,16,,15,18,23],[,,,,,,,36,,,,,20,20,23,28],
   [,25,24,,,,,,,,15,18,23,,16,,18,23],
   [,33,36,,,,,28,,,20,23,28,,,20,23,28],
   [,,28,,,,,36,,,,,20,20,23,28,,20,23,28],
   [,,36,,,,,40,,,20,23,28,,,20,23,28,,20,28],
   [4,,,,,,,,,,12,,,12,,32,16,,,,38],[],
   [,5,,,,,,,6,,,,,27,22,25,21,,23,32,51],
   [4,5,,6,,,,,6,,12,17,,12,,,,32,16,,28,34,4,,5],
   [,7,,8,,,,,8,,24,20,32,,20,,,25,21,,27,43,5,,6]],
 [,[],[],[],[],[],[],[,,7],[],[],[],[,,,,,,,20],[],
   [,,18,,,,,,,,,17],[],[,,32,,,,,,,,,29],[,,25,,,,,25,,,,21,,19,,31],
   [,,,,,,,32,,,,,,27,,39],[,,20,,,,,,,,,19,,,,,21,29],[],[],
   [,,32,,,,,,,,,29,,,,27,31,39],[],[,,,,,,,6,,,,,,15,,27,19,,17,,,27],
   [],[,,6,,,,,6,,,,15,,13,,,,39,15,,,39,,5],
   [,,8,,,,,8,,,,19,,,,,,28,19,,,48,,6],[]],
 [,[],[],[],[,6,,7],[],[],[,,18],[,,,8,7],[,7,,8,,,,,8],
   [30,,,,21,,,55],[,22,,,18,,,31,34,22],[,,46,,39,,,50],
   [,18,,26,17,,,,,22,,23],[,29,78,,21,,,36,35,,28,,69],
   [,40,86,51,33,,,,73,50,,35,39],[28,,36,32,21,,,,,27,,21,,24,24],
   [,86,,67,35,,,52,69,64,,,36,40,,38],
   [28,23,33,30,18,,,,,28,20,20,55,,23,,20],
   [,54,50,,39,,,46,,,86,,38,,,33],[,,,,39,,,103,,,,,40,52,,44,,41,,46],
   [,,52,69,35,,,100,67,48,66,54,42,,,32,58,38,,36,51],
   [6,,,,5,,,,,6,19,,,26,,37,20,,18,,77],[],
   [,6,,,6,,,,7,7,,22,,18,28,38,25,54,23,51,88],
   [,6,,7,5,,,,7,6,18,17,78,17,,,,39,20,,44,61,5,,6],
   [6,8,20,9,7,,,,9,8,23,21,38,,27,,25,44,23,52,51,56,6,,7],[],[]],
 [,[],[],[],[],[,,7],[],[],[],[],[],[,,,,,23],[,,27],
   [,,18,,,,,,,,,17],[,,18,,,,,,,,16,14,24],[,,26,,,,,,,,,19],
   [,,19,,,,,,,,,15,,19,14,21],[,,31,,,37,,,,,,,22,27,20,29],[],[],
   [,,27,,,,,,,,,,22,,24,,,22],[,,28,,,,,,,,38,23,46,,,23,23,29,,,46],[],
   [,,,,,6,,,,,,,,15,14,21,16,21,,,40,23],[],
   [,,6,,,6,,,,,13,13,29,13,,,,31,,,29,33,,5],
   [,,8,,,8,,,,,18,17,28,,15,,23,24,,,28,42,,6],[],
   [,,6,,,,,,,,,17,,13,,,19,27,,,,,,5,,5,6],[]],
 [,[],[],[],[,6,,7],[],[,7,,8],[],[],[,7,,8,,,8],[],
   [,17,,,,42,23,,,27],[,,,,60,,55],[,17,,22,18,,,,,28,,20,35],[],
   [,,,,58,,47,,,71,57,39,67],[,,,27,27,,32,,,32,,,,22,,43],
   [,79,,56,,,,,,59,,,36,28,,56],[,17,,23,23,39,24,,,23,20,19,31,,,,21,30 
    ],[],[,,,,60,,60,,,,,,35,35,,53,,32,30],
   [,49,,66,62,,57,,,,,48,89,,,46,52,62,,,60],[],[],
   [,5,,,6,16,7,,,7,,17,,17,,,21,45,17,,37,45],
   [,5,,6,6,,7,,,7,,17,48,17,,,,43,17,,,43,,,5],
   [,,,8,8,20,9,,,9,22,23,38,,,,27,32,21,,30,52,,,6],
   [,5,,6,,,,,,,,23,32,,,43,20,,,,27,,,,5,5,6],[],
   [,6,,7,6,,,,,7,,,51,18,,52,24,,22,,49,54,,,6,6,7],[]],
 [,[],[],[],[,9,,10],[,,10],[,10,,11],[,,10,,,10],
   [,,,10,10,,11],[,10,,11,,,10,,11],[,,,,,,,24],
   [,24,,,27,31,31,23,33,33],[,,42,,57,,70,46],
   [,41,32,46,41,46,46,46,46,46,30,23,72],[,,24,,37,,44,24,,,,17],
   [,,54,76,67,78,60,62,136,,50,35,46],[32,,29,,33,,38,29,,42,,21],
   [,91,48,94,51,60,54,42,64,94,,,30,,,38],
   [32,38,23,30,32,31,30,,,31,21,18,33,,17,,21,27],
   [,,46,,60,,,42,,,,33,34,,,38,,34],[,,96,,,,101,46,,,,,35,72,,42,,30,33],
   [,51,42,64,51,60,54,46,94,64,38,27,34,,,33,,28,,30,34],
   [6,,,,7,,8,,,8,,,,26,,52,21,53,22,,,33],
   [,,,,,8,,8,,,,,,23,17,39,21,30,17,34,58,30],
   [,7,,,8,20,9,,8,9,,21,,31,30,47,33,60,23,51,,40],[],
   [6,7,8,8,7,8,8,8,8,8,16,15,32,,15,,21,32,15,42,32,,5,6,6],
   [,7,,8,,,,,8,,,20,41,27,21,43,21,31,20,41,33,31,5,,6,,5],
   [,,8,,,,,8,,,,19,,28,,48,,36,19,,,36,,6,,,6],
   [6,8,,9,7,,,20,9,8,22,21,36,30,27,48,25,38,23,36,48,38,6,,7,,6],
   [,,8,,,8,,,,,18,17,34,28,17,39,21,30,,,34,30,,6,,,6,,6],
   [,,,8,8,,9,,,9,23,23,51,32,,86,,40,21,,,56,,,6,,6,6,,7]],
 [,[],[],[],[,6,,7],[],[,7,,8],[,,18],[,,,8,7,,8],[],[],
   [,22,,,,,,34,29],[,,50,,,,58,66],[,18,,,17,,22,,28,,,23,52],
   [,29,,,,,29,74,35,,,25,47],[,30,,63,,,30,96,65,,,30,82],
   [32,,,34,,,29,40,,,,,,24,27],[,,,,73,,52,68,69,,,,52,46,56,68],
   [32,24,33,,,,21,,,,,22,42,,,,23,49],[,40,54,,,,,40,,,,33,50,,,32,37,60],
   [],[,30,64,53,73,,34,,64,,,34,58,,,28,34,58],
   [6,,,,5,,6,,,,,,,,,,21,,20],[],
   [,6,,,6,,7,,7,,,22,,18,28,30,26,,23,38,,30],
   [,6,,7,5,,6,,7,,,20,77,17,,,,61,17,44,,39,5,,6],
   [6,8,,9,,,8,20,9,,,24,40,,27,,,48,21,40,,48,6,,7],[],[],
   [6,6,16,7,5,,,16,7,,,,45,17,22,39,21,51,,35,,35,5,,6,5,6],[],
   [,6,,7,6,,7,,,,,23,64,18,,40,25,48,,,,,,,6,6,7,,,6],
   [6,8,20,9,,,8,,9,,,25,52,31,30,,27,60,21,38,,40,6,,7,,6,,,6,,7]],
 [,[],[],[],[],[],[],[],[,,,,,,52],[,,,,,,38],[30,,,,,,,58],
   [],[],[30,,,,,,,,,,15],[,,,,,,185,84,,,29],[],
   [,,,,,,175,122,,217,,,,26,34],[,,,,,224,314,,,,,,,43],
   [,,,,,,132,,,,26,,,,24,,,58],[,,,,,,,92,,,37,,,,,,,53],
   [,,,,,,,176,,,,,,37,49,,,33,71,57],
   [158,,,,,362,350,136,,,,,,,,,86,49,,35,47],
   [20,,,,,98,40,,,44,60,,,60,,,86,,,,202,202],[],[],
   [20,,,,,98,,98,,54,57,,,55,,,,195,70,191,181,219,20],
   [,,,,,,61,,63,63,,,,,99,,114,196,102,271,274,330,30],
   [20,,,,,,,,44,,60,,,60,95,,93,156,93,150,168,180,20,,,20,29],
   [,,,,,,,73,,,,,,358,,,168,,147,,,289,,,,82,114],[],
   [,,,,,,,,,,129,,,358,139,,166,293,,,260,285,,,,,,,76],
   [,,,,,,52,,,60,112,,,,,,127,,108,,302,460,,,,34,35,30],
   [42,,,,,,,,,,,,,130,101,,119,212,111,,265,255,29,,,,24,29,,,,34],
   [42,,,,,,40,207,56,,,,,125,146,,134,,109,219,,335,29,,,31,34,,,,,39,34]],
 [,[],[],[],[,15,,35],[,,20],[,,,25],[,,20,,,20],[,,,22,,,25],
   [,,,25,,,22,,25],[30,,,,,,,52],[],[,,98,,540,,439,106],
   [30,45,48,72,45,54,72,54,72,72,15],[],[],[,,,,91,,,,,148,,,,29],
   [],[,,,101,68,89,,,,,,,115,,,,32],[,,106,,,,,98,,,43,,51],
   [,,,,,,,114,,,,,35,37,,,,,,47],
   [,145,102,250,175,142,206,92,272,,37,,53,,,,,,,35,49],
   [20,,,,,,48,,,42,60,,,60,,,89,,,,188,204],
   [,,,,,34,,35,,,,,,63,,,78,,147,,412,127],
   [,27,,,30,356,41,,34,39,,,,87,,,146,,100,381,462,207],
   [20,27,32,34,27,32,34,32,34,34,57,,189,45,,,,,63,189,169,,20,25,27],
   [],[20,36,,56,,,,,52,,60,,,60,,,90,,102,,,180,20,,35,20],
   [,,34,,,,,34,,,,,,69,,,143,,121,,,155,,25,,25],
   [,30,236,41,27,,,227,39,34,,,353,87,,,126,,104,,304,227,,,30,27],
   [,,,,,35,,,,,109,,211,69,,,80,,,,,143,,25,,25,,,25],
   [,27,,34,30,364,40,,,,,,380,87,,,126,,99,,,279,,,27,27,,32,,30],[],
   [,30,,,27,,34,,,,,,442,87,,,,,99,,,187,34,,30,27,,,,27,,30],
   [10,,,,,40,,,42,,15,,,15,,,32,,,,61,49,20,,,18,,20,,,76]],
 [,[],[],[],[],[],[],[],[],[,32,,52,,,,,52],[30,,,,,,,52],
   [,,,,,,,63],[,,,,,,,94],[30,,,,,,,,,165,15,20,25],[,,,,,,,,,,20,25,30],
   [,,,,,,,,,,25,30,35],[72,,,321,,,,70,,,,20,,20,25,30],
   [,,,,,,,94,,,,,25,25,30,35],[72,98,,,,,,,,128,20,25,30,,20,,25,30],
   [,139,,,,,,76,,,25,30,35,,,25,30,35],
   [,,,,,,,94,,,,,25,25,30,35,,25,30,35],
   [,,,,,,,76,,,25,30,35,,,25,30,35,,25,35],
   [20,,,,,,,,,40,60,,,60,,,95,186,92,,156,174],
   [,,,,,,,,,,,,,126,118,199,,169,117,202,,193],
   [,29,,,,,,,46,50,,,,130,125,155,,346,116,179,324],
   [20,29,,,,,,,,54,57,69,151,53,,,,159,75,161,157,151,20,,28],
   [,50,,72,,,,117,74,78,101,99,145,,103,,,,101,,148,250,29,118,35],
   [20,30,,44,,,,,46,,60,77,100,60,77,100,77,100,77,100,100,100,20,,29,20,
     29],[],[],[,,,,,,,,,,120,123,198,,,,123,199,,,202,,,,,78,112],
   [,29,,44,,,,,,56,124,125,183,,,,,,113,,160,,,,29,28,35,29],
   [,,,73,,,,,,57,104,94,176,,98,202,107,163,95,181,180,152,,,34,,24,30,,,,
     34],[,43,,62,,,,,,,,128,249,136,141,161,167,769,115,168,,180,29,,41,
     31,34,,,,,,34],[10,,,,,,,,48,42,15,,,15,24,,27,39,24,,,37,20,,,18,34,
     20,,,79,,,33],[10,,,48,,,,38,,48,15,,37,15,,,,,27,39,,,20,79,40,18,,
     20,,,,33,,,5]],
 [,[],[],[],[,15,,20],[,,20],[,20,,25],[,,20,,,20],
   [,,,20,20,,25],[,20,,25,,,20,,25],[30],[,53,,,,,74,72,101,92],
   [,,,,,,468,112],[30,45,48,72,45,54,72,54,72,72,15,,37],[],
   [,,98,,,146,140,128,,284,,86,49],[],[],
   [,53,72,111,,97,,,,72,23,,58],[,,112,,,,,90,,,31,,53,,,35],
   [,,92,,,,400,,,,,,33,37],[],[20,,,,25,64,32,,,32,60,,,60,,,,,,,188],
   [,,,,,35,,34,,,,,,63,,137,,,113,223],
   [,25,,,30,84,37,,,37,,91,,87,,263,,,91,,243],
   [20,25,32,32,25,32,32,32,32,32,57,61,183,45,,,,,61,,,,20,25,25],
   [30,,44,44,51,44,44,44,44,44,93,84,184,,,,,,84,254,184,,25,30,30],
   [20,25,64,32,,,,64,32,,60,,150,60,,,,,109,152,,,20,,25,20,25],
   [,,35,,,,,,,,,131,,69,,183,,,,,,,,25,,25,30],
   [30,30,84,37,25,,,84,37,39,,97,243,87,,,,,,227,,,25,,30,25,30],
   [,,35,,,38,,,,,,105,208,69,,149,,,,,,,,25,,25,30,,25],
   [,25,,45,30,84,37,,,37,125,91,,87,,253,,,91,,217,,,,25,25,30,25,,30],
   [30,,44,44,,44,44,44,44,44,91,84,228,,,573,,,84,206,236,,25,30,30,,20,
     25,30,30,30,30],[30,30,84,37,25,,,84,37,,,118,251,87,,219,,,98,191,,
     ,25,,30,25,30,,,25,,30,30],
   [10,,,,,,38,38,,40,15,,,15,,,,,25,35,33,,20,,,18,26,20,79,,,32,26],
   [10,15,20,23,15,20,23,20,23,23,15,,49,15,,,,,,,,,20,25,28,15,,20,25,28,
     25,28,,28,5],[10,25,,40,,,,,38,,15,25,39,15,,37,,,,33,35,,20,79,29,
     18,26,20,,,79,29,26,32,5,5]],
 [,[],[],[],[],[],[],[,,,,,10],[,,,,18,,24],[],[6,,,,15,,,8],
   [],[],[6,,,,,10,26,10,,,6],[,,,,,,30,10,,,7],[18,,,,,18,28,14,,,8],
   [8,,,,19,,,10,,,,,,7,8,9],[18,,,,,,,22,,,,,,16,17,18],
   [8,,,,16,11,24,,,,7,,,,8,,8,17],[,,,,,,,12,,,8,,,,,9,9,18],[],
   [18,,,,,18,34,12,,,8,,,,,9,9,18,,9],
   [12,,,,17,20,22,,,,12,,,12,,28,15,32,15,,,26],[],[],
   [12,,,,19,15,,15,,,11,,,10,,,,41,12,26,,26,12],
   [18,,,,23,22,32,22,,,16,,,,15,,21,48,17,38,,40,16],
   [12,,,,,,,20,24,,12,,,12,15,20,,,15,20,,20,12,,,12,18],
   [,,,,,,,17,,,,,,14,,24,17,,16,,,24,,,,12,16],
   [18,,,,17,,,28,29,,18,,,,26,,22,,20,37,,37,16,,,18,18],
   [,,,,,17,,,,,13,,,14,13,18,14,35,,,,20,,,,12,16,,14],
   [,,,,23,32,28,,,,18,,,21,,49,,,19,,,61,,,,18,22,18,,22],
   [18,,,,26,22,28,22,40,,16,,,22,16,34,19,48,17,30,,26,16,,,,14,18,16,18,
     16,23],[18,,,,19,,22,28,33,,,,,21,22,30,24,,19,27,,29,16,,,18,18,,,
     16,,23,18],[30,,,,,52,128,56,142,,27,,,30,42,,35,91,39,62,,82,60,,,
     54,,60,88,,116,105,86,91],
   [30,,,,67,50,,48,118,,27,,,30,,,36,,,70,,62,60,,,52,,60,81,97,84,98,,102,
     28],[30,,,,,,,52,142,,25,,,30,37,42,39,,37,42,,42,60,,,54,83,60,,,
     110,102,85,91,28,28],
   [30,,,,69,48,,54,,,27,,,30,,72,,,41,56,,,60,,,52,74,60,,82,88,111,74,82,
     28,28,28]],[,[],[],[],[],[],[],[],[,,,,10,,11],
   [,,,,,,11,,11],[],[],[],[,,,,,,,,24],[,,,,30,,35,,26],
   [,,,,48,,41,,36,57],[,,,,30,,35,,,31,,,,24,24,35],
   [,,,,,,45,,48,41,,,,35,38,49],[],[],[],
   [,,,,,,,,40,51,,,,,,35,38,49],[],[],[],
   [,,,,15,,16,,15,16,,,,34,,,,82,,,,82],
   [,,,,22,,23,,22,23,,,,,,,61,86,,,,96],
   [,,,,,,,,17,,,,,,39,64,39,,,,,,,,,12,16],[],
   [,,,,15,,,,18,18,,,,38,44,73,43,69,,,,,,,,13,17],[],
   [,,,,17,,18,,,18,,,,38,,,37,62,,,,64,,,,12,16,14,,15],
   [,,,,22,,23,,22,23,,,,74,50,124,52,102,,,,82,,,,,14,16,,17,,16],
   [,,,,15,,18,,18,,,,,38,40,69,46,,,,,61,,,,13,17,,,15,,15,17],[],
   [,,,,106,,55,,46,,,,,96,,,170,,,,,232,,,,54,,,,90,,68,,93],[],
   [,,,,40,,49,,58,49,,,,96,,232,,,,,,,,,,52,74,62,,71,,101,74,71,,33],[]],
 [,[],[],[],[],[],[],[,,,,,21],[,,,,35,,43],[],[],[],[],
   [,,,,,24,40,24],[,,,,,,44,20],[,,,,33,32,40,25,91],[],
   [,,,,29,24,,18,43,,,,,8,9,10],[,,,,,23,37,,,,,,,,9,,,9],
   [,,,,32,,,20,,,,,,,,10,,10],[,,,,31,,43,17,,,,,,8,9,10,,8,9,10],
   [,,,,,32,48,24,,,,,,,,10,,10,,10,10],[],
   [,,,,,28,,28,,,,,,20,20,28,,19,21,29,,27],[],[],
   [,,,,,36,58,36,,,,,,,23,,,22,25,48,26,59,,23],
   [,,,,,,,43,51,,,,,28,30,36,,27,30,35,,35,,,,,29],
   [,,,,,,,30,,,,,,27,,37,,25,27,,,35,,22,,,25],
   [,,,,39,,,58,59,,,,,64,,48,,43,90,45,43,,,,,,49],
   [,,,,,30,,,,,,,,27,22,30,,21,,,23,29,,22,,,25,,24],
   [,,,,51,60,49,,,,,,,39,,75,,39,33,,33,91,,,,,37,32,,46],
   [,,,,67,47,76,47,74,,,,,,,,,31,32,37,33,34,,31,,,36,34,34,45,34,43],
   [],[],[,,,,221,122,,140,312,,,,,65,,,,,127,77,55,,,129,,,,245,139,285,
     148,284],[,,,,,,,112,,,,,,35,42,47,,39,42,47,41,47,,168,,,139,117,,,
     202,182,175,,,51],[,,,,475,139,269,125,,,,,,86,,77,,,116,85,53,,,125,,,
     205,,137,317,139,359,,,,,54],[],[]],
 [,[],[],[],[,9,,10],[,,10],[,10,,11],[,,10,,,10],
   [,,,10,10,,11],[,10,,11,,,10,,11],[6,,,,,,,8],[,10,,,,11,13,9],
   [,,12,,,,36,14],[6,9,8,14,9,10,14,10,14,14,6,7,8],[],[],
   [8,,10,18,13,,18,10,,18,,8,,7],[,31,14,36,29,18,22,14,38,36,,,9,8],
   [8,10,9,19,11,11,,,,13,7,8,9,,,,8,9],
   [,,20,,,,,16,,,16,17,18,,,,17,18],[,,12,,,,36,14,,,,,9,8,,,,9,9,18],
   [],[12,,,,15,,16,,,16,12,,,12,,,15,30,15,,28],
   [,,,,,16,,16,,,,,,11,,,13,17,13,31,37],
   [,13,,,16,34,17,,16,17,,17,,17,,,20,41,17,57,39],
   [12,13,14,14,13,14,14,14,14,14,11,11,23,9,,,,,11,29,23,,10,11,11],
   [],[12,15,20,16,,,,,16,,12,15,20,12,,,15,20,17,,20,,12,,13,10],
   [,,16,,,,,16,,,,15,,13,,,16,23,15,,,,,13,,11],
   [,16,,17,13,,,34,17,16,,17,,17,,,19,35,18,,40,,13,,14,11],
   [,,16,,,16,,,,,13,13,21,13,,,13,19,,,21,,,13,,11,,,13],
   [,13,,16,16,,17,,,17,19,17,30,17,,,19,27,17,,30,,,,13,11,,13,,14],
   [30,31,32,32,31,32,32,32,32,32,26,23,68,18,,,,,23,66,68,,22,23,23,,,
     22,23,23,23,23],[30,16,,17,13,,16,,17,,,20,39,17,,,20,41,17,,,,13,,
     14,11,,,,13,,14,23],
   [30,,,,,60,,60,124,124,30,,,27,,,38,66,36,91,62,,54,,,45,,54,116,,121,93,
     108,79],[30,39,44,46,39,44,46,44,46,46,30,,,27,,,44,,36,95,62,,54,
     59,61,35,,54,59,61,59,61,,61,26],
   [30,63,,136,,,,,136,92,30,37,42,25,,,37,42,41,,42,,54,110,78,45,,54,,,
     136,75,108,75,26,26],
   [30,35,44,44,35,44,44,44,44,44,30,38,62,27,,,,,35,,62,,50,59,59,35,,
     50,59,59,59,59,,59,26,20,26],
   [6,,,,,8,20,8,,,6,,,6,,,7,16,7,16,,,12,,,10,,12,12,,12,18,22,18,30,30,
     30,30],[,,,,8,,9,,8,9,,,,18,,,21,34,,,,,,,,10,,12,,13,,12,22,13,,32,,
     30],[,,,,,18,32,18,,,,,,7,,,,8,8,17,8,,,20,,,,26,22,55,22,34,,,,61,
     35,80]],
 [,[],[],[],[,27,,35],[,,21],[,29,,43],[,,25,,,25],[],
   [,35,,43,,,35],[16,,,,,,,21],[,20,,,,23,33,22,,79],
   [,,20,,33,,46,27],[],[],[],[,,20,,,,44,26,,,,9],
   [,75,25,93,,32,45,30,,93,,,10],[],
   [,25,17,,31,,,18,,,8,9,10,,,,9,10],[,,,,32,,57,27,,,,,10,,,,,10,,10],
   [24,25,18,43,29,24,40,,,43,8,9,10,,,,9,10,,8,10],
   [32,,,,42,46,45,,,49,32,,,,,,,61,,,54,33],
   [,,,,,31,,39,,,,,,,,,25,31,,24,60,23],
   [,31,,,49,60,46,,,56,,33,,,,,43,75,,35,64,36],[],[],
   [,32,43,49,,,,,,,26,30,35,,,,31,35,,31,36,29,30,,30],
   [,,31,,,,,39,,,,29,,,,,32,39,,,,29,,26],
   [,45,66,56,39,,,70,,49,79,41,44,,,,,48,,37,45,40,36,,42],
   [,,29,,,29,,,,,22,22,34,,,,,35,,,34,24,,24,,,,,24],
   [,,,73,73,92,78,,,80,60,61,73,,,,68,78,,,68,69,,,51,,,51,,63],
   [52,57,53,68,67,53,,,,,43,38,43,,,,,43,,39,43,37,39,39,45,,,43,39,45,,
     85],[52,39,,56,,,39,90,,,,33,68,,,,43,79,,33,,35,36,,36,,,,,36,,59,43 
    ],[160,,,,,160,,,,,86,,,,,,133,76,,56,79,59,228,,,,,205,205,,,446,303,310 
    ],[],[,136,,629,,,,172,,474,35,42,47,,,,42,47,,39,47,,,200,172,,,117,,
     ,177,489,195,171,53],
   [,,132,,475,124,,149,,583,57,116,73,,,,,,,53,85,,,150,325,,,232,158,277,
     149,427,295,217,54],
   [16,,,,46,17,27,21,,,7,,,,,,8,17,,8,,8,28,,,,,26,23,39,21,53,37,30,80,,
     35,56],[],[,,,,31,22,54,28,,,,,,,,,,9,,9,9,9,,29,,,,31,32,44,,78,
     38,,,,40,63],[]],
 [,[],[],[],[],[],[],[,,10],[,,,18],[,18,,24,,,,,24],
   [6,,,,,,,8],[,12,,,,,,9,20],[,,12,,,,,14],[6,,8,,,,,,,,6,7,8],
   [,17,10,,,,,10,26,,7,8,9],[,19,14,,,,,,,,8,9,10],
   [8,,10,26,,,,10,,26,,7,,7,8,9],[,,,,,,,14,,,,,8,8,9,10],
   [8,14,9,20,,,,,,19,7,8,9,,7,,8,9],[,19,14,,,,,12,,,8,9,10,,,8,9,10],
   [,,12,,,,,14,,,,,8,8,9,10,,8,9,10],
   [,,14,,,,,12,,,8,9,10,,,8,9,10,,8,10],
   [12,,,,,,,,,24,12,,,12,,,15,,15,,32,30],
   [,,,,,,,17,,,,,,13,15,21,15,20,15,21,,21],
   [,17,,,,,,,22,29,,19,,27,22,28,,,20,33],
   [12,,15,26,,,,15,,,11,13,,11,,,,29,13,,29,29,12,12],
   [,25,22,28,,,,22,32,,16,19,30,,,,,24,19,,24,48,,16,18],
   [12,17,20,22,,,,20,22,,12,15,20,12,15,20,15,20,15,20,20,20,12,,16,12,
     16],[],[],[,,17,,,,,,,,13,15,21,,15,20,15,21,,,21,,,14,,12,16],
   [,,,22,,,,,,29,,20,33,,,,22,,19,,27,,,,16,18,18,16],
   [30,23,22,34,,,,22,28,40,16,19,38,26,20,38,20,28,19,38,28,28,18,16,18,
     ,14,16,,,16,18],[30,23,50,28,,,,32,28,,,19,,,23,28,,,20,33,,33,18,,
     22,18,22,,,,,22,23],
   [30,,,,,,,56,151,142,27,,,27,37,,37,59,37,57,65,,60,,,54,85,60,,,116,95,
     87,101],[30,67,48,123,,,,54,,,27,,63,27,,,38,,39,63,61,69,60,82,100,
     52,,60,,,88,99,,105,26],
   [30,89,,166,,,,52,158,124,25,32,37,25,32,37,32,37,32,37,37,37,60,108,
     96,54,85,60,,,110,96,,104,23,23],
   [30,79,48,,,,,48,104,,27,38,59,27,,71,,,37,57,57,,60,,82,52,74,60,,,89,
     82,74,96,23,26,23],
   [6,,,,,,,8,20,,5,,,6,7,8,6,,7,8,,8,12,,,11,16,12,,,13,20,16,22,27,27,
     25,27],[],[,,,,,,,17,,,,,,7,8,9,,7,8,9,7,9,,20,,,24,24,,,22,32,31,
     ,,54,30],[6,13,8,,,,,8,20,,6,7,8,5,,,7,8,6,,8,,12,12,18,10,,12,,,
     12,,22,18,27,27,25,27,6,,7],
   [,21,17,37,,,,21,,,7,8,9,,,,8,9,,7,9,7,47,23,31,,,24,,,21,,37,31,53,,
     30,51,7,,8]],
 [,[],[],[],[],[],[],[],[,,,11],[,10,,11,,,,,11],[],
   [,17,,,,,,,36],[],[,,,,,,,,,24,,25],[,26,,,,,,,31,,,22],
   [,36,,51,,,,,43,52,,33],[,,,31,,,,,,26,,22,,24,24,35],
   [,,,43,,,,,,38,,,,35,38,49],[,25,,40,,,,,,22,,23,,,25,,25,39],[],[],
   [,,,,,,,,41,48,,39,,,,35,38,49],[,,,,,,,,,17,,,,,,70,37,110,38],[],
   [,15,,,,,,,18,18,,31,,38,40,59,46,67,38],
   [,15,,16,,,,,16,15,,34,,34,,,,78,35,,,70,12,,13],
   [,22,,23,,,,,23,22,,47,,,,,,86,46,,,118,16,,17],[],[],[],[],
   [,15,,18,,,,,,18,,35,,,,65,41,,33,,,69,,,15,13,17],
   [,22,,23,,,,,23,22,,43,,74,50,,49,82,41,,,100,16,,17,,14,,,,,17],
   [,17,,18,,,,,18,,,,,36,35,62,42,66,32,,,58,14,,15,12,16,,,,,15,16],
   [,,,,,,,,,154,,,,,,,283,,,,,,146,,,162,,,,,,198,217,150],
   [,105,,53,,,,,53,46,,,,96,,,161,,172,,,210,150,,91,54,,,,,,85,,68,144],
   [],[,40,,49,,,,,49,,,112,,96,,220,,,118,,,,62,,71,52,74,,,,,71,74,134,,
     33],[],[,,,,,,,,9,9,,,,19,23,43,23,43,,,,,,,,12,17,,,,,14,17,14,,35,
     ,35],[],[,8,,9,,,,,9,8,,19,,18,,,21,34,22,,,,12,,13,10,,,,,,13,22,
     12,,32,,30,,7],[],[]],
 [,[],[],[],[,9,,10],[,,10],[,10,,11],[,,10,,,10],
   [,,,10,10,,11],[,10,,11,,,10,,11],[6,,,,,,,8],
   [,10,,,11,11,13,9,19,17],[,,16,,,,,20],
   [6,9,8,14,9,10,14,10,14,14,6,7,16],[,13,10,,13,,18,10,18,,7,8,17],
   [,15,14,36,,18,20,14,34,,8,9,18],[],[],
   [,10,9,,,11,14,,,13,7,8,17,,8],[,23,14,,,,,12,,,8,9,18,,,9],
   [,,20,,,,,20,,,,,15,16,17,18,,,17,18],
   [,15,14,38,29,18,22,12,36,38,8,9,18,,,9,,,,9,18],
   [12,,,,15,20,16,,,16,12,,,12,,40,,,,,38,36],
   [,,,,,16,,16,,,,,,11,12,19,,,13,21,,19],
   [,13,,,16,34,17,,16,17,,17,,17,20,25,,,17,33,,27],
   [12,13,14,14,13,14,14,14,14,14,11,11,29,9,,,,,11,29,29,,10,11,11],
   [18,19,20,20,19,20,20,20,20,20,16,15,40,,13,,,,15,42,40,,13,14,14],
   [12,15,26,16,,,,20,16,,12,,,12,15,20,,,15,20,,20,12,,13,10,13],
   [,,16,,,,,16,,,,15,,13,,23,,,15,,,23,,13,,11,14],
   [18,16,28,17,13,,,34,17,16,,17,57,17,20,,,,,40,,41,13,,14,11,14],
   [,,16,,,16,,,,,13,13,31,13,12,17,,,,,31,19,,13,,11,14,,13],
   [,13,,16,16,28,17,,,17,,17,,17,,37,,,17,,51,43,,,13,11,14,13,,14],
   [18,19,20,20,19,20,20,20,20,20,16,15,40,,,,,,15,42,40,,13,14,14,,10,
     13,14,14,14,14],[18,16,34,17,13,,16,28,17,,,,,17,20,25,,,17,28,,27,
     13,,14,11,14,,,13,,14,14],
   [30,,,,,56,90,,128,128,27,,,30,38,,,,38,56,95,68,54,,,45,66,54,119,,,86,
     66,82],[30,39,44,46,39,44,46,44,46,46,27,,,30,,,,,39,70,91,68,54,
     59,61,35,,54,59,61,59,61,,61,26],
   [30,,,132,,,,52,132,104,25,,101,30,37,42,,,37,42,,42,54,,,45,66,54,,,115,
     79,66,80,26,26],[30,35,44,44,35,44,44,44,44,44,27,35,91,30,,,,,38,
     62,91,,50,59,59,35,50,50,59,59,59,59,50,59,26,20,26],
   [6,,,,13,8,,8,20,,5,,,6,7,8,,,7,8,,8,12,,,10,14,12,12,17,12,,14,17,
     27,27,25,27],[,,,,8,,9,,8,9,,,,20,21,32,,,,,,34,,,,10,14,12,,13,,12,
     14,13,,32,,30],[],
   [6,7,8,8,7,8,8,8,8,8,6,7,16,6,,,,,7,16,16,,10,11,11,7,,10,11,11,
     11,11,,11,24,20,24,20,6,6],
   [,23,18,,,18,32,24,,,7,8,17,,,,,,,8,17,8,50,23,33,,,26,23,57,23,57,,33,
     ,,35,61,7],[6,,8,20,,,,8,,20,5,6,,6,7,8,,,7,8,,8,12,12,17,10,14,
     12,,,12,17,14,,27,27,25,27,5,,,6,7],
   [,8,,9,,,,,9,8,,19,,20,21,32,,,22,,,34,12,,13,10,14,,,,,13,14,12,,32,,
     30,,7,,6]],
 [,[],[],[],[],[,,25],[],[,,25,,,21],[,,,,35,,43],[],[],
   [],[,,18,,31,,37,17],[,,24,,,24,40,24,,,,,8],[,,26,,,,44,20,,,,,9],
   [,,30,,,32,40,25,,,,,10],[],[],[,,22,,,23,37,,,,,,9,,9],
   [,,27,,,,,20,,,,,10,,,10],[,,24,,30,,,17,,,,,8,8,9,10,,,9,10],
   [,,30,,31,32,48,24,93,,,,10,,,10,,,,10,10],
   [,,,,66,73,63,,,,,,,53,,63,,,,,48,65],
   [,,,,,29,,29,,,,,,20,21,,,,22,34,,35],
   [,,,,73,94,70,,73,,,,,64,65,69,,,61,73,60,78],
   [,,,,,38,,38,,,,,28,23,,,,,28,55,28,,,26],
   [,,64,,,43,60,43,116,,,,31,,26,,,,30,73,31,95,65,,71],
   [,,,,,,,43,49,,,,27,28,30,36,,,30,35,,35,45,,51,,31],
   [,,39,,,,,31,,,,,,27,,37,,,29,,,39,,24,,30,31],
   [,,70,,39,,,60,56,,,,37,,83,,,,,44,39,46,57,,63,68],
   [,,39,,,31,,,,,,,24,27,23,30,,,,,24,32,,24,,30,31,,26],
   [,,,,49,60,46,,,,,,33,39,,75,,,33,,32,79,,,53,,37,30,,42],
   [,,,,61,53,64,53,77,,,,39,,,43,,,38,43,39,,,,,,37,39,39,45,39,43],
   [,,,,,,63,98,80,,,,60,64,65,,,,58,66,,73,52,,58,,77,,,57,,59,85],
   [,,,,,142,,197,,,,,,,83,,,,125,85,56,77,334,,,287,,235,188,,384,329,288,370 
    ],[,,170,,299,131,406,144,437,,,,59,86,,,,,161,82,55,76,366,150,,221,,
     346,153,362,153,344,,534,96],
   [,,,,,,,112,583,,,,39,35,42,47,,,42,47,39,47,327,177,747,182,154,117,,,
     200,171,195,489,,53],[],[],[],
   [,,,,29,16,,16,42,,,,,7,8,9,,,8,9,7,9,,22,,,29,23,24,38,24,36,35,,,51,
     30],[,,24,,,18,32,18,,,,,8,7,,,,,8,17,8,,47,20,55,23,,26,22,,22,34,
     ,55,,80,35,,,,7],
   [,,26,,25,22,38,26,,,,,9,,,,,,,9,9,9,53,31,64,,,31,29,42,31,68,46,68,
     68,,40,,,,8],[,,21,,,,,17,37,,,,7,7,8,9,,,8,9,7,9,47,21,,27,29,24,,
     ,23,31,37,59,51,,30,,,,6,7,8],[],[]],
 [,[],[],[],[,12,,18],[,,10],[,18,,24],[],[],[,18,,24,,,18],
   [6],[,12,,,16,11,21,,,20],[,,12,,,,32],[6,,8,,,,,,,,6,7,8],
   [,,10,,19,,,,,,7,8,9],[,,22,,,,,,,,16,17,18],
   [,,10,,,,30,,,,,8,,7,8,17],[,49,14,,,18,32,,,,,,9,8,9,18],[],[],
   [,,12,,,,38,,,,,,9,8,9,18,,9],[,,22,,,,,,,,16,17,18,,,15,17,18,,,18],
   [12,,,,17,20,22,,,22,12,,,12,,56,,,,,26,48],
   [,,,,,17,,,,,,,,13,13,35,14,18,,,36,35],
   [,17,,,23,32,28,,,28,,19,,27,29,52,25,61,,,53],
   [12,,15,26,,15,26,,,,12,12,26,11,,,,26,,,26,41,12,12,18],
   [18,,22,37,25,22,28,,,32,18,17,26,,15,,21,22,,,26,60,16,16,22],
   [12,18,20,24,,,,,,,12,15,20,12,17,,15,20,,,20,,12,,18,12],
   [,,17,,,,,,,,,16,,,,,17,24,,,,,,14,,12,16],
   [18,23,28,29,17,,,,,22,20,19,37,,22,60,,37,,,46,,16,,22,,18],[],[],
   [18,32,22,40,23,22,34,,,28,18,17,30,26,16,74,19,26,,,30,48,16,16,23,,
     14,18,16,18],[18,23,30,29,,,22,,,,,22,37,,26,,24,43,,,,55,16,,22,18,
     18,,,16,,,18],[30,,,,,52,145,,,,30,,,27,35,,46,62,,,64,115,60,,,54,87,
     60,88,,,,,96],[30,,,123,,52,123,,,,30,,78,27,,,41,,,,,99,60,86,112,52,
     ,60,86,102,,,,,28],
   [30,75,,,,,,,,,30,37,42,25,,,37,42,,,42,,60,111,102,54,89,60,,,,,85,99,
     28,28],[30,,52,106,75,54,110,,,106,30,43,68,27,,87,,,,,,,60,86,,52,
     74,60,,82,,,74,82,28,28,28],
   [6,,,,11,8,16,,,,6,,,6,7,16,7,16,,,,16,12,,,11,16,12,13,16,,,16,16,30,
     30,30,30],[],[,,,,,17,32,,,,,,,7,8,17,,8,,,8,17,,20,,,24,26,22,40,,
     ,31,,,65,35,65],[6,,8,20,13,8,,,,20,6,7,8,5,,,7,8,,,8,,12,12,18,
     10,,12,12,18,,,22,,27,27,25,27,6,,7],[],
   [6,11,8,20,,,,,,20,6,7,8,5,6,,7,8,,,8,,12,13,20,11,16,12,,,,,16,20,
     27,27,25,27,6,,7,5],[],
   [6,13,8,,,8,20,,,,6,7,16,6,7,16,,,,,16,16,12,12,19,10,14,12,12,17,,,
     14,17,30,30,30,30,6,,,6,,6],
   [,,21,,46,17,27,,,,,,8,7,8,17,,,,,8,17,,21,53,27,29,26,23,39,,,37,53,
     61,89,35,,,,7,7,,7]],
 [,[],[],[],[,,,10],[],[,,,11],[],[],[,,,11,,,11],[],[],
   [],[,,,24,,,,,,25],[,,,,30,,35],[,,,,48,,41,,,57],
   [,,,26,30,,35,,,31,,,,24,24,35],[,,,38,,,,,,43,,,,35,38,49],[],[],
   [],[,,,48,,,49,,,,,,,,,35,38,49],[],[],
   [,,,,17,,18,,,18,,,,36,35,58,42,66,,,,62],
   [,,,15,15,,16,,,16,,,,34,,,,68,,,,78,,,12],
   [,,,22,22,,23,,,23,,,,,,,61,86,,,,110,,,16],
   [,,,17,,,,,,,,,,,39,64,39,,,,,,,,14,12,16],[],
   [,,,18,15,,,,,18,,,,,44,73,43,,,,,69,,,15,13,17],[],[],
   [,,,22,22,,23,,,23,,,,74,50,154,52,98,,,,96,,,16,,14,16,,17],
   [,,,18,15,,18,,,,,,,,40,69,46,67,,,,63,,,15,13,17,,,15,,,17],
   [,,,,,,168,,,,,,,,,,258,,,,,673,,,,,,150,,,,,,176],
   [,,,46,,,53,,,,,,,96,,,156,,,,,,,,68,54,,,,85],
   [,,,,,,,,,160,,,,,,,338,,,,,,,,148,,216,140,,,,,207,,,124],
   [,,,56,40,,49,,,49,,,,96,,212,,,,,,,,,,52,74,62,,71,,,74,71,114,33],[],
   [,,,,8,,9,,,9,,,,18,19,,19,40,,,,40,,,,11,16,13,,14,,,16,14,,32,,30],
   [],[,,,8,8,,9,,,9,,,,18,,,21,34,,,,,,,12,10,,12,,13,,,22,13,114,32,,30,
     ,6],[],[],[,,,9,,,,,,9,,,,19,23,49,23,,,,,43,,,14,12,17,,,,,,17,
     14,,35,,35,,7,,7],[,,,8,8,,9,,,9,,,,20,21,32,,,,,,34,,,12,10,14,12,,
     13,,,14,13,,32,,30,,6,,6,,,7],[],[]],
 [,[],[],[],[,27,,35],[,,21],[,29,,43],[],[],[,35,,43,,,35],
   [16],[,20,,,,23,33],[,,20,,,,57],[],[],
   [24,,18,41,31,24,32,,,46,8,9,10],[,,20,,,,44,,,,,9,,,,9],
   [,75,25,93,31,32,45,,,,,,10,,,10],[],[],
   [,,,,33,,46,,,,,,10,,,10,,10],
   [24,25,18,43,29,24,40,,,43,8,9,10,,,8,9,10,,,10],
   [32,,,,43,43,47,,,51,32,,,,,36,,,,,52,33],
   [,,,,,30,,,,,,,,,,22,24,29,,,57,21],
   [,31,,,51,58,49,,,59,,33,,,,37,44,91,,,75,39],
   [,,38,,,38,,,,,31,28,55,,,,,,,,57,32,,30,68],[],
   [,33,43,51,,,,,,,26,30,35,,,33,31,35,,,36,27,30,,32,49],
   [,,30,,,,,,,,,27,,,,27,30,35,,,,25,,24,,30],
   [,47,60,59,39,,,,,51,,43,45,,,42,,49,,,49,43,38,,46],
   [,,28,,,28,,,,,21,21,29,,,20,22,27,,,29,21,,22,,26,,,22],[],
   [52,63,47,80,63,47,,,,74,37,32,37,,,31,,,,,37,30,34,34,45,,,34,34,43,31 
    ],[52,41,122,59,,,41,,,,,36,77,,,36,44,91,,,,,38,,40,68,,,,38,,,43],
   [,,,,,170,,,,529,,,,,,,88,97,,,102,58,205,,,293,,198,196,,,,,357],
   [,,,595,,128,,,,,86,,82,,,,123,,,,,59,250,149,415,221,,246,147,364,138,,,,
     96],[272,136,,574,,,,,,,35,42,47,,,40,42,47,,,47,,209,202,179,185,,117,
     ,,168,,175,182,51],
   [,,125,,,136,261,,,562,57,88,97,,,58,,,,,,,,138,,346,,210,138,476,128,,,
     246,60,96,51],[16,,,,,17,35,,,,7,,,,,8,8,17,,,,8,28,,,27,,26,22,,20,,
     31,36,,80,35,56],[],
   [,,,,25,22,34,,,,,,,,,9,,9,,,9,9,,26,,,,31,28,40,26,,32,,,68,40,85],
   [],[16,,16,42,29,16,,,,42,7,8,9,,,,8,9,,,9,7,27,24,,,,23,24,38,22,,
     35,36,51,,30,49,7,,8],
   [,20,17,,,,,,,53,7,8,9,,,7,8,9,,,9,7,,22,32,27,,24,,,20,,31,33,51,54,
     30,53,7,,8,,6],[],
   [,23,18,,,18,32,,,,7,8,17,,,8,,,,,17,8,,21,35,,,26,21,,19,,,35,56,,35,,
     7,,,,7,7],[,,28,,,22,54,,,,,,9,,,9,,,,,9,9,49,,78,,,31,32,,29,,38,
     78,85,70,40,,,,8,,8,8],[],[]],
 [,[],[],[],[],[],[,10,,11],[],[,,,11,,,11],[],[],
   [,19,,,,,,,40],[],[,,,25,,,26,,25,,,25],[,26,,,,,30,,31,,,25],
   [,36,,51,,,36,,41,,,36],[,,,31,,,30,,,,,25,,24,24,35],
   [,,,41,,,42,,51,,,,,35,38,49],[,21,,36,,,24,,,,,23,,,22,,22,39],[],
   [],[,,,51,,,46,,51,,,39,,,,35,38,49],[,,,,,,17,,,,,,,,,70,37,68,38],
   [],[,15,,,,,18,,18,,,33,,,40,59,46,,35,,,65],
   [,15,,16,,,15,,16,,,35,,34,,,,82,34,,,82,12,,13],
   [,22,,23,,,22,,23,,,46,,,,,,86,47,,,98,16,,17],[],[],
   [,17,,18,,,,,18,,,,,36,39,66,39,66,38,,,66,14,,15,12,16],[],
   [,15,,18,,,18,,,,,38,,,,67,41,65,31,,,,,,15,13,17,,,15],
   [,22,,23,,,22,,23,,,41,,74,50,116,49,102,43,,,82,16,,17,,14,,,16,,17],
   [],[],[,,,55,,,46,,,,,,,96,,,,,,,,228,,,85,54,,,,68],
   [,92,,136,,,,,136,,,,,,193,,205,,265,,,,108,,132,,,,,,,140,221],
   [,40,,49,,,62,,49,,,115,,96,,268,,,109,,,,62,,71,52,74,,,129,,71,74,,,33,
     114],[],[,,,,,,9,,9,,,,,19,23,33,23,33,,,,33,,,,12,17,,,14,,14,17,,,
     35,,35],[],[,8,,9,,,8,,9,,,22,,18,,,21,34,19,,,,12,,13,10,,,,12,,
     13,22,,,32,,30,,7],[],[],
   [,8,,9,,,,,9,,,,,18,19,44,19,40,,,,40,13,,14,11,16,,,,,14,16,,,32,,30,,7,
     ,6],[,8,,9,,,8,,9,,,22,,20,21,32,,,19,,,34,12,,13,10,14,,,12,,13,
     14,,,32,114,30,,7,,6,,,6],[],[],
   [,,,9,,,9,,,,,,,19,23,43,23,43,,,,,,,14,12,17,,,14,,,17,,,35,142,35,,7,,7,
     ,,7,7],[]],
 [,[],[],[],[],[,,19],[],[,,19,,,21],[,,,,35,,43],[],[],
   [],[,,14,,30,,,17],[,,,,,24,40,24,,,,,8],[,,,,,,44,20,,,,,9],
   [,,,,,32,40,25,91,,,,10],[],[,,19,,29,24,37,18,43,,,,8,8,9,10],
   [,,16,,,23,37,,,,,,9,,9,,,9],[,,27,,32,,,20,,,,,10,,,10,,10],[],
   [,,,,31,32,48,24,93,,,,10,,,10,,10,,10],[],
   [,,,,,34,,34,,,,,,26,26,34,,,27,35,,35],[],[],
   [,,,,,38,60,38,,,,,27,,25,,,24,26,62,,,,31],
   [,,,,,,,43,51,,,,,28,30,36,,,30,35,,35,,,,,31],
   [,,31,,,,,30,,,,,,27,,37,,25,27,,,35,,28,,,27],
   [,,66,,39,,,64,59,,,,39,64,,53,,43,90,45,,49,,,,,64],
   [,,31,,,30,,,,,,,23,27,22,30,,21,,,,29,,28,,,27,,24],
   [,,,,51,58,49,,,,,,43,39,,75,,39,33,,,91,,,,,39,32,,46],
   [,,,,,44,82,44,86,,,,30,,,,,26,29,34,,31,,,,,,38,31,49,31,49],[],
   [,,,,,145,,,434,,,,,67,,,,54,,,,116,,,,,,210,203,,,331,280],[],
   [,,,,,,,112,,,,,39,35,42,47,,39,42,47,,47,,,,,144,117,,,201,176,177,,52],
   [,,128,,,127,,124,335,,,,54,,,87,,,,84,,,,153,,,,,137,,141,,238,,51],[],
   [],[,,,,23,16,30,16,34,,,,,7,8,9,,7,8,9,,9,,22,,,31,23,20,38,20,34,
     33,,,,30,49],[,,,,,18,32,18,,,,,8,7,,,,8,8,17,,,,26,,,,26,22,55,22,
     34,,,62,,35,,,,7],
   [,,,,,22,54,28,,,,,9,,,,,9,,9,,9,,51,,,,31,32,44,,78,,,92,,40,66,,,8],
   [,,15,,,,,17,,,,,7,7,8,9,,7,8,9,,9,,26,,,25,24,,,22,32,28,,53,,30,52,,,
     6,7,8],[],[],
   [,,,,29,16,,16,42,,,,7,7,8,9,,,8,9,,9,,,,,30,23,24,38,24,34,39,,49,,30,
     ,,,6,7,8,6],[,,15,,,17,32,,,,,,8,7,8,17,,8,,,,17,,26,,,25,26,22,,,,
     28,,,,35,65,,,7,7,,7,,,7],[],
   [,,26,,25,22,38,,,,,,9,,,9,,9,,,,9,,32,,,,31,28,44,26,,,,,,40,85,,,8,,8,
     8,,,8],[]],
 [,[],[],[],[,27,,35],[,,21],[,29,,43],[,,19,,,19],[],
   [,35,,43,,,35],[16,,,,,,,15],[,20,,,,23,33,16,,79],
   [,,20,,38,,45,27],[],[],[24,23,18,41,31,24,32,19,,46,8,9,10],
   [,,20,,,,44,,,,,9,,,,9],[,71,25,,31,32,45,,,93,,,10,,,10],[],
   [,22,17,,31,,,14,,,8,9,10,,,8,9,10],[,,,,,,57,27,,,,,10,,,10,,10,,10],
   [],[32,,,,42,49,45,,,49,32,,,,,36,,61,,,54],
   [,,,,,31,,31,,,,,,,,22,25,31,,24,60],
   [,31,,,49,58,46,,,56,,33,,,,34,43,79,,33,71],[],[],
   [,32,43,49,,,,41,,,26,30,35,,,,31,35,,27,36,,30,,30],
   [,,31,,,,,31,,,,29,,,,27,32,39,,,,,,26],
   [,45,58,56,39,,,66,,49,,41,43,,,40,,46,,38,49,,36,,42],
   [,,33,,,33,,,,,26,26,34,,,,29,33,,,34,,,26,,,,,26],
   [,,,73,73,,78,,,80,60,61,73,,,63,68,78,,,66,,,,53,,,51,,63],
   [60,51,53,,61,53,64,,,68,43,38,43,,,39,,,,39,43,,43,39,43,,,39,39,45],
   [60,39,,56,,,39,48,,,,33,61,,,38,43,75,,32,,,36,,36,,,,,36,,57,45],
   [136,,,,,144,446,,,,65,,,,,,116,73,,53,90,,204,,,,,,205,,321,456,342,263],
   [,,128,,,120,305,131,,332,86,,,,,,86,,,57,79,,,147,282,,,200,152,480,155,
     435,,248],[,137,,1038,,,,,,540,35,42,47,,,41,42,47,,,47,,248,203,173,,
     ,117,,,202,,195,176,53,58],
   [,,127,559,,133,254,138,,,,133,76,,,59,,,,56,85,,,153,298,,,,170,355,165,
     409,405,279,54,96,57],
   [16,,,,46,17,28,15,,,7,,,,,8,8,17,,8,,,28,,,,,26,23,53,25,53,37,33,61,
     80,35],[],[,,,,,22,54,,,,,,,,,9,,9,,9,9,,,29,,,,31,32,44,48,78,39,,
     ,63,40,68],[],[16,19,16,34,23,16,30,22,,34,7,8,9,,,,8,9,,7,9,,
     27,21,32,,,23,21,36,25,56,42,32,51,,30,51,7,,8],
   [,21,17,53,,,,15,,,7,8,9,,,7,8,9,,7,9,,47,23,32,,,24,,,25,59,37,31,,
     52,30,52,7,,8,,6],[],
   [,23,18,,,18,32,,,,7,8,17,,,8,,,,8,17,,50,23,33,,,26,23,57,25,57,,33,
     56,,35,80,7,,,,7,7],
   [,,26,,25,22,34,26,,,,,9,,,9,,,,9,9,,54,31,65,,,31,29,39,31,65,38,61,
     63,68,40,,,,8,,8,8],[],[],
   [16,29,16,42,29,16,,,,42,7,8,9,,,7,8,9,,,9,,27,24,36,,,23,24,38,,,34,,
     49,51,30,51,7,,8,,6,6,,7,8],[],
   [,,,,,22,54,,,,,,9,,,9,,9,,9,,,,51,,,,31,32,44,48,78,43,,85,,40,65,,,8,,
     8,8,,,8,,,8]],[,[],[],[],[],[],[],[,,,,,46],[,,,,40],
   [,,,,,,,,62],[42,,,,146,,,74],[],[],[42,,,,,,,,221,,21],
   [,,,,125,,,98,212,,37],[,,,,452,,,144,598,,47],
   [,,,,125,,,137,,242,,,,34,41,67],[186,,,,290,,,138,575,,,,,53,61,63],
   [],[,,,,568,,,122,,,53,,,,,45,83,61],
   [,,,,568,,,146,,,,,,53,83,63,,45,,65],
   [186,,,,290,,,132,490,,47,,,,,43,61,65,,45,61],
   [28,,,,40,114,,,,58,84,,,84,,246,,262,,,242,236],[],[],
   [28,,,,43,86,,,66,66,79,,,73,,,,243,,231,231,243,28],
   [50,,,,60,136,,,73,81,133,,,,133,,152,228,,379,277,318,40],
   [28,,,,,,,130,52,,84,,,84,132,,127,196,,192,196,,28,,,28,39],
   [,,,,,,,111,,,,,,,,721,199,,,,,,,,,,126],
   [50,,,,39,,,348,64,58,150,,,162,168,365,154,348,,379,529,386,39,,,41,46],
   [,,,,,73,,,,,129,,,,128,232,,261,,,241,289,,,,,126,,86],
   [,,,,54,,,,,83,146,,,179,,400,158,314,,,,497,,,,41,46,39,,51],
   [54,,,,64,,,136,,90,129,,,166,129,318,144,270,,333,324,246,39,,,,32,39,
     130,47,84,46],[54,,,,43,,,,70,,,,,156,171,329,170,632,,367,,,39,,,41,
     46,,,39,,55,47],[70,,,,,308,,324,318,356,105,,,105,191,,192,271,,,291,
     321,140,,,125,193,140,622,,807,226,193,220],
   [70,,,,157,224,,294,251,314,105,,,105,,,186,,,303,299,293,140,,,119,,140,
     567,223,440,231,,233,35],
   [70,,,,,,,366,317,331,105,,,105,,229,167,229,,237,235,,140,,,125,192,140,,,
     672,225,193,221,35,35],
   [70,,,,149,256,,322,248,272,105,,,105,,289,,,,297,297,,140,,,119,168,140,,
     200,,208,168,,35,35,35],
   [42,,,,99,64,,70,158,,37,,,42,56,78,47,117,,86,,78,84,,,74,113,84,132,
     123,117,136,113,124,195,195,189,195],[],[],
   [42,,,,85,68,,,108,136,42,,,37,,,52,82,,119,86,,74,,,59,,74,,103,117,100,
     140,100,180,168,174,168,42],[],
   [42,,,,,,,70,162,183,37,,,37,49,,49,71,,75,75,71,84,,,74,112,84,,,116,
     123,112,134,166,166,154,164,37,,,37],
   [,,,,,,,,125,124,,,,511,230,738,258,,,,,,130,,,,185,,,,,160,182,130,1202,,,
     558,,,,90],[42,,,,73,72,,,128,124,37,,,42,52,78,,,,,119,78,74,,,59,86,
     74,144,100,121,100,86,102,180,168,174,168,37,,,32,,37,126],
   [,,,,,160,,219,430,,,,,81,95,91,,,,105,75,95,418,,,323,292,273,262,356,
     311,331,343,473,463,466,330,,,,,76,,63],
   [42,,,,99,64,,,,185,42,,,37,47,121,54,78,,,86,117,84,,,74,112,84,132,130,,
     ,120,125,195,195,189,195,42,,,37,,37,,42,78],
   [,,,,100,,,,,146,,,,522,225,,248,739,,,,735,,,,136,175,136,,152,,,197,170,
     1202,605,1281,804,,,,126,,,111,126],
   [192,,,,,156,,,,,100,,,,,67,99,107,,,95,67,301,,,457,,238,284,454,212,,271,
     340,476,474,327,460,94,,,,,62,,75,82],
   [,,,,,,,,186,,,,,,,1033,319,,,,,,168,,,182,221,,,172,,225,260,,,,1051,638,,,,,,
     ,126,126,,,160],[,,,,588,164,,211,593,,,,,100,,93,,69,,101,,,,,,,,254,
     308,389,282,426,326,,524,,348,464,,,,94,,64,,,62,,,84],
   [164,,,,395,168,,199,,,79,,,,,69,97,97,,71,,,256,,,,,240,291,392,,487,313,,
     524,519,332,471,75,,,,,63,,77,84,,,60,,82]],
 [,[],[],[],[,21],[,,28],[,34,,35],[,,28,,,28],[,,,30,37,,35],
   [,37,,35,,,30,,35],[42,,,,192,,,68],[,75,,,,,111,88,133,126],[],
   [42,63,64,100,63,74,100,74,100,100,21,34],[],[],
   [,,91,175,117,,,88,,,,32,,37],
   [346,279,124,348,191,168,228,126,270,292,,,,47],
   [,77,90,143,88,114,,,,116,,44,,,,,44,82],
   [,,144,,296,,,108,,,47,67,,,,,70,61],[,,124,,,,452,152,,,,,,47,,,,43,,67],
   [334,173,,294,179,172,222,114,314,288,47,61,,,,,61,63,,43,71],
   [28,,,,41,,,,,54,84,,,84,,,123,268,122,,240,280],
   [,,,,,46,,,,,,,,85,,,104,157,131,,365,185],
   [,37,,,42,190,53,,46,54,,129,,121,,,176,359,133,308,387,267],
   [28,37,44,46,37,44,46,44,46,46,79,83,,63,,,,,83,213,203,227,28,35,37],
   [],[28,,120,54,,,,,60,,84,121,,84,,,,186,123,,186,188,28,,,28],
   [,,46,,,,,46,,,,147,,95,,,159,211,151,,,201,,35,,35],
   [,42,268,53,37,,,,55,46,161,131,,121,,,164,285,143,345,487,289,41,,42,37 
    ],[,,46,,,46,,,,,130,127,,95,,,104,167,,,234,169,,35,,35,,,35],
   [,37,,46,42,,55,,,53,163,132,,121,,,188,265,131,,332,353,,,37,37,,41,,42]
    ,[70,62,69,71,63,70,70,70,70,71,140,132,,167,,,157,493,132,357,388,
     331,41,48,50,,,41,48,51,48,51],
   [70,42,,,37,,46,,54,,,151,,121,,,183,355,134,342,,271,44,,42,37,,,,37,,42,
     51],[70,,,,,332,276,,336,,105,,,105,,,200,283,194,283,285,311,140,,,123,
     ,140,,,677,242,206,229],
   [70,105,140,160,105,140,160,140,160,160,105,,,105,,,191,,203,297,275,271,
     140,175,195,105,,140,175,195,175,195,,195,35],
   [70,150,,,,,,,318,249,105,165,,105,,,168,233,173,235,223,223,140,768,221,
     121,,140,,,768,228,202,228,35,35],
   [70,105,140,154,105,140,154,140,154,154,105,194,,105,,,,,196,,293,,140,
     175,189,105,,140,175,189,175,189,192,189,35,35,35],
   [42,,,,88,66,,64,145,,37,,,42,,,48,117,,78,,78,84,,,72,,84,104,128,105,
     132,119,130,195,195,189,195],
   [,,,,93,,73,,62,71,,,,132,,,197,288,,,,282,,,,74,,174,,111,,92,121,115,,230,
     ,224],[,,,,309,165,332,156,485,,,,,79,,,,68,103,91,67,105,,165,,,,264,
     181,397,179,356,401,,,485,344,493],
   [42,53,60,62,53,60,62,60,62,62,42,52,,37,,,58,78,47,121,78,,74,81,83,
     49,,74,81,83,81,83,153,83,176,140,166,140,42,44,75],[],
   [42,87,64,144,,,,64,,145,37,49,,37,,,,71,49,73,71,71,84,105,128,72,,84,,
     ,104,128,119,132,166,166,154,166,37,,63,37],
   [,107,,71,,,,,71,62,,215,,132,,,200,284,,,,274,174,,112,74,,,,,,115,121,92,
     1154,230,,224,,49,,44],
   [42,53,60,62,53,60,62,60,62,62,37,47,,42,,,,,52,78,133,84,74,81,83,49,
     ,74,81,83,81,83,,83,176,140,166,140,37,44,,28,,37,44],[],
   [42,,70,,88,64,144,,,,42,55,,37,,,54,72,,,72,115,84,110,136,72,,84,106,
     132,,,119,131,195,195,189,195,42,,70,37,,37,,42],
   [,,,62,121,,71,,,71,,,,132,,,196,274,,,,282,,,92,74,,136,,117,,,121,111,
     1481,230,1166,224,,44,,44,,,49,44],
   [,,166,,261,157,361,,,413,81,95,,,,,,91,,,103,70,277,179,351,237,,257,181,
     374,165,,401,356,540,487,344,470,76,,82,,,62,,94],
   [,90,,,,,62,,71,,,204,,132,,,,284,194,,,286,142,,117,74,,,,92,,111,121,,,
     230,729,224,,49,,44,,,44,44,,,49],
   [,,,,,,,157,675,,,,,79,,,,68,104,115,,120,,210,,,,270,187,472,181,465,,,531,
     ,338,504,,,61,75,,65,,,,70,,101],
   [284,,157,462,265,155,338,153,,,79,,,,,,96,91,,68,102,,299,190,319,,,241,
     189,369,189,527,,394,460,463,349,473,75,,82,,,64,,78,,,,60,,101],
   [14,,,,30,46,,48,,,21,,,21,,,40,59,,59,59,71,28,,,24,,28,89,46,,45,39,
     45,35,35,35,35,38,,,34,,34,,34,,38,100,,136,108,108]],
 [,[],[],[],[],[],[],[],[,,,46],[,,,62],[42],[],[,,100],
   [42,,68,,,,,,,,21,28,35],[,,90,,,,,,217,,28,35,42],
   [,,122,438,,,,,1308,,35,42,49],[84,,189,205,,,,,,,,28,,28,35,42],
   [,,,669,,,,,,,,,35,35,42,49],[84,,81,,,,,,,166,28,35,42,,28,,35,42],
   [,,122,,,,,,,,35,42,49,,,35,42,49],[,,98,,,,,,,,,,35,35,42,49,,35,42,49]
    ,[270,,122,377,,,,,843,546,35,42,49,,,35,42,49,,35,49],
   [28,,,,,,,,,56,84,,,84,,,120,238,120,,216,220],
   [,,,,,,,,,,,,,113,124,196,,181,125,200,589,191],[],
   [28,,,,,,,,66,66,79,90,201,73,,,,195,88,199,199,201,28,69],
   [,,,73,,,,,89,89,132,124,195,,121,,,168,,334,201,338,39],
   [28,,124,52,,,,,56,,84,107,140,84,107,140,107,140,107,140,140,140,28,,,28 
    ],[],[],[,,80,,,,,,,,124,126,203,,206,171,125,196,,,201,,,62,,92,126 
    ],[,,,52,,,,,,70,150,144,243,,,,156,,138,,211,444,,,,41,46,39],
   [54,,208,,,,,,79,,133,124,233,166,124,262,141,204,125,234,234,209,40,126,,
     ,32,40,,,90,46],[54,,,66,,,,,74,,,,,187,175,234,168,468,145,218,,230,
     40,,,44,49,,,,,51,47],
   [70,,,,,,,,,,105,,,105,172,,173,239,172,251,247,259,140,,,125,190,140,,,645,
     232,192,226],[70,,338,258,,,,,338,386,105,,271,105,,,178,,187,277,253,
     247,140,363,,119,,140,,,410,224,,248,35],
   [70,,,326,,,,,356,298,105,140,175,105,140,175,140,175,140,175,175,175,140,
     823,,125,193,140,,,724,221,193,223,35,35],
   [70,,256,218,,,,,345,282,105,175,243,105,,257,,,173,253,249,,140,359,,117,
     170,140,,,366,209,173,213,35,35,35],
   [42,,,,,,,,194,,35,,,42,51,58,48,,51,58,,58,84,,,74,111,84,,,114,134,113,
     127,193,191,175,193],
   [,,,,,,,,114,146,,,,,234,836,250,903,,,,695,,,,,,130,,,,134,259,164,,1043,,
     432],[,,,,,,,,,,,,,49,58,65,,53,58,65,53,65,,170,,,181,163,,,200,237,
     228,,,358,210,407],
   [42,,68,,,,,,124,124,42,51,58,35,,,51,58,,,58,,74,109,,59,,74,,,147,100,
     140,119,178,164,160,162,42,,49],
   [,,144,,,,,,,,49,58,65,,,,58,65,,53,65,56,262,206,,,,163,,,186,579,258,
     240,378,,210,,49,,56],
   [42,,68,166,,,,,174,172,35,44,51,35,44,51,44,51,44,51,51,51,84,114,,74,
     113,84,,,112,125,114,141,158,160,140,158,35,,42,35,42],[],
   [42,,,106,,,,,158,158,35,53,,42,51,58,,,51,58,,58,74,165,,59,86,74,,,114,
     103,86,108,178,164,160,162,35,89,,32,49,35],
   [,,198,,,,,,,,,,53,49,58,65,,,58,65,53,65,,183,,254,205,163,,,205,228,257,
     478,392,435,210,,,,42,49,56,42],
   [42,,68,164,,,,,,,42,51,58,35,48,137,51,58,,,58,,84,112,,74,115,84,,,,,
     114,128,193,191,175,193,42,,49,35,,35,,42,49],
   [,,,104,,,,,,146,,,,,233,,237,903,,,,,,,,,183,130,,,,,,164,1508,1043,1400,469,
     ,84,,126,,,,89],[,,144,435,,,,,,,49,58,65,,,53,58,65,,,65,53,261,200,
     ,254,,163,,,171,,227,250,346,435,210,346,49,,56,,42,42,,49,56],
   [,,,186,,,,,,,,,,604,,,,,,,,885,166,,,178,,,,,,198,239,,,784,1336,1016,,160,,
     126,,,,127,,,160],
   [,,133,,,,,,605,,,,,49,58,65,,54,58,65,,65,,364,,,188,163,,,204,238,227,,
     349,,210,385,,,42,49,56,42,,,42,49,,56],
   [464,,144,662,,,,,,,49,58,65,,,54,58,65,,53,65,,291,203,,,,163,,,201,501,
     256,233,,358,210,354,49,,56,,42,42,,49,56,,,42,,56],
   [14,,,,,,,,50,56,21,,,21,32,43,35,45,,47,49,43,28,,,24,,28,,,86,43,42,
     46,35,35,35,35,38,,,34,,31,,34,62,38,100,,156,,61],
   [14,,,50,,,,,56,50,21,32,,21,,,32,,33,49,43,49,28,,,24,,28,,,65,45,41,
     45,35,35,35,35,38,100,61,34,,31,,34,,38,,62,136,,,7]],
 [,[],[],[],[,21,,28],[,,28],[,28,,35],[,,28,,,28],
   [,,,28,28,,35],[,28,,35,,,28,,35],[42,,,,,,,68],
   [,73,,,,102,97,90,136,122],[,,,,517,,,128],
   [42,63,64,100,63,74,100,74,100,100,21,34],[,,91,,,,162,,180,,37,41,70]
    ,[],[],[],[,73,86,134,,100,109,,,100,34,41,64,,32],
   [,,128,,,,,,,,47,70,61],[,,140,,,,496,136,,,,,45,53,86,,,,83,63],
   [298,147,124,262,185,,218,114,300,250,47,64,61,,,,,,,43,63],
   [28,,,,35,88,44,,,44,84,,,84,,,,,,,262,268],
   [,,,,,46,,49,,,,,,85,,,,,141,267,,169],
   [,35,,,42,116,51,,51,51,,125,,121,,,,,125,,331,249],
   [28,35,44,44,35,44,44,44,44,44,79,83,215,63,,,,,83,215,231,387,28,35,
     35],[42,61,60,60,,60,60,60,60,60,125,114,238,,97,,,,114,310,248,320,
     35,42,42],[28,35,88,44,,,,88,44,,84,,222,84,,,,,,222,,,28,,35,28,35],
   [,,46,,,,,,,,,,,95,,,,,151,,,239,,35,,35,42],
   [42,42,116,51,35,,,116,51,,,,279,121,169,,,,,293,,269,35,,42,35,42],
   [,,49,,,47,,,,,167,141,,95,95,,,,,,,181,,35,,35,42,,35],
   [,35,,48,42,116,51,,,51,142,125,302,121,,,,,125,,279,359,,,35,35,42,35,,
     42],[42,,60,60,67,60,60,60,60,60,123,114,248,213,,,,,114,258,284,
     232,35,42,42,,28,35,42,42,42,42],
   [42,42,116,51,35,,57,116,51,,,163,337,121,169,,,,135,251,,255,35,,42,35,
     42,,,35,,42,42],[70,,,,,286,228,,305,309,105,,,105,187,,,,190,273,,293,
     140,,,121,180,140,394,,896,220,180,212],
   [70,105,140,158,105,140,158,140,158,158,105,,295,105,,,,,198,295,289,283,
     140,175,193,105,,140,175,193,175,193,,193,35],
   [70,201,,,,,,334,346,,105,170,235,105,174,,,,170,237,257,231,140,,211,123,
     176,140,,,999,209,176,216,35,35],
   [70,105,140,140,105,140,140,140,140,140,105,193,285,105,,,,,209,271,,,140,
     175,175,105,140,140,175,175,175,175,140,175,35,35,35],
   [42,,,,101,64,136,64,,,37,,,42,53,,,,54,78,,78,84,,,72,102,84,106,114,
     113,129,102,114,195,195,187,195],
   [,,,,56,,67,,,67,,,,132,198,,,,,,,278,,,,72,102,86,,97,,153,102,97,,228,,
     210],[,,,,,154,316,159,,,,,,106,96,,,,97,142,71,97,,161,,,225,407,175,,
     177,325,296,,,469,393,524],
   [42,49,60,60,49,60,60,60,60,60,42,52,80,37,,,,,47,117,86,,70,81,81,49,
     ,70,81,81,81,81,199,81,172,140,168,140,42,42,100],
   [,,157,385,,150,342,193,,,,95,93,,,,,,,67,,68,311,197,318,,,460,193,324,
     187,490,423,322,484,,348,485,,,84],
   [42,91,68,144,,,,64,144,,37,50,73,37,50,,,,,73,77,75,84,112,114,72,102,
     84,,,104,114,102,137,164,166,156,166,37,,66,37],
   [,56,,67,,,,,67,68,,141,,132,,,,,154,,,274,86,,97,72,102,,,,,97,102,125,
     1154,228,,210,,49,,42],
   [42,49,60,60,49,60,60,60,60,60,37,47,121,42,55,,,,52,82,121,78,70,81,
     81,49,70,70,81,81,81,81,70,81,172,140,168,140,37,42,,28,75,37,42],
   [],[42,93,64,142,101,64,,,,140,42,54,78,37,48,,,,,,98,119,84,111,132,
     72,102,84,104,114,,,102,114,195,195,187,195,42,,77,37,,37,,42],
   [,,,74,56,,67,,,67,,,,132,199,,,,,,,282,,,,72,102,86,,97,,,102,97,1154,228,
     1060,210,,42,,42,,,49,42],
   [,305,186,460,505,163,347,,,456,,129,114,,,,,,,,100,69,,183,377,430,,568,
     183,437,169,,,417,515,541,393,524,,,82,,63,66,,94],
   [,56,,67,,,72,,67,,,153,,132,188,,,,,,,270,86,,97,72,102,,,,,97,102,,,228,,
     210,,49,,42,,,42,42,,,49],
   [,,170,,,160,399,158,,,,,69,106,130,,,,129,93,,93,,205,,,283,,183,,183,385,
     299,,515,,429,490,,,62,100,88,66,,,,94,,86],[],
   [14,,,,31,,,48,46,,21,,,21,35,,,,,49,47,49,28,,,24,34,28,89,39,89,40,34,
     39,35,35,35,35,38,,,34,,31,90,34,,38,,66,126,65],
   [14,21,28,31,21,28,31,28,31,31,21,,,21,,,,,40,,59,59,28,35,38,21,,28,
     35,38,35,38,37,38,35,35,35,35,38,45,156,28,,34,45,28,,38,45,108,45,
     108,,7],[14,,48,,,,,,,46,21,35,49,21,,,,,32,,49,43,28,89,,24,34,28,,,
     89,,34,42,35,35,35,35,38,126,62,34,63,31,,34,,38,90,65,,66,,7,7]],
 [,[],[],[],[,27],[,,40],[,40],[],[],[,46,,,,,46],[42],
   [,88,,,115,130,151],[,,112,,420,,559],[42,,64,,,,,,,,21,31,41],
   [,,,,,,221,,,,34,44],[,,146,,,,,,,,,64,61],[],
   [,391,136,,,206,340,,,771,,,45,,98,63],[],[],
   [,,132,,,,564,,,,,,43,41,,67,,45],[218,,,,,,402,,,657,47,,61,,,43,,67,,,67 
    ],[28,,,,40,124,52,,,58,84,,,84,,246,,,,,230,236],
   [,,,,,93,,,,,,,,,226,343,,309,,,469,297],
   [,39,,,52,184,64,,,73,,136,,153,181,264,,471,,,400],
   [28,,86,,39,86,56,,,,79,88,217,71,,,,245,,,217,225,28],
   [58,,146,,64,114,76,,,90,,,310,,145,,,284,,,317,314,40,130,46],
   [28,40,132,,,,,,,,84,123,188,84,124,,,200,,,188,192,28,,39,28,39],[],
   [58,52,196,,39,,,,,58,162,142,351,,,324,,383,,,,,39,,50,38,47],[],[],
   [52,60,,,,142,,,,81,131,125,,166,135,346,,326,,,318,254,39,,46,,32,39,,46]
    ,[52,55,182,,39,,52,,,,,187,353,159,173,265,,469,,,,373,39,,53,38,47,,,
     39,,,46],[70,,,,,,328,,,,105,,,105,194,,,,,,323,323,140,,,125,195,140,,,,,
     ,223],[70,,,,,214,230,,,,105,,357,105,,,,,,,,,140,514,228,117,,140,,227,,
     ,,,35],[70,,,,,,,,,404,105,169,249,105,,233,,251,,,225,,140,,228,125,
     198,140,,,,,193,232,35,35],
   [70,,226,,155,256,,,,250,105,205,293,105,,351,,,,,325,,140,623,,119,168,140,
     ,202,,,168,,35,35,35],
   [42,,,,108,64,158,,,,37,,,42,54,,,121,,,,78,84,,,74,115,84,,128,,,115,127,
     195,195,189,195],[,,,,104,,129,,,154,,,,622,230,,,852,,,,968,,,,176,173,
     130,,154,,,241,166,,605,,690],
   [,,,,,164,,,,,,,,,149,94,,73,,,70,93,,294,,,291,252,,469,,,326,,,518,326,692 
    ],[42,,64,,77,72,96,,,,42,52,72,37,,,,84,,,72,,74,,101,59,,74,,101,,,
     140,97,180,164,174,168,42,122],
   [164,,252,,,154,691,,,493,79,117,94,,,,,95,,,103,68,253,302,,,,262,,,,,406,
     344,578,,334,511,75,,84],
   [42,91,66,,,,,,,,37,49,79,37,49,73,,,,,71,71,84,139,126,74,111,84,,,,,
     112,140,168,166,154,168,37,,65,37,63],
   [,144,,,,,,,,,,,,,355,,,1032,,,,950,168,,200,,296,,,,,,261,170,2118,1930,,1380,
     ,160],[42,,,,85,,112,,,132,37,48,109,42,52,82,,,,,119,78,74,147,102,
     59,86,74,,108,,,86,100,180,164,174,168,37,,,32,,37],
   [,,236,,508,154,,,,,,,70,71,103,91,,,,,67,96,,264,435,,352,,,404,,,399,446,
     456,667,335,,,,62,70,79],
   [42,102,66,,102,64,162,,,166,42,53,84,37,47,121,,86,,,78,117,84,138,140,
     74,114,84,,123,,,112,124,195,195,189,195,42,,94,37,,37,,42,94],[],
   [],[,146,,,,,138,,,,,297,,622,297,1112,,726,,,,,168,,213,,248,,,176,,,,,,,
     1114,1470,,160,,122,,,,126],
   [,,172,,479,158,371,,,,,,68,71,104,115,,72,,,,111,,,,,261,268,,398,,,286,,
     780,,341,573,,,63,70,101,63,,,61,75],
   [,,239,,413,158,378,,,494,,93,112,,,68,,134,,,,,,,359,,,285,,385,,,350,329,
     675,507,,854,,,108,,61,65,,76,101],
   [14,,,,31,40,,,,48,21,,,21,40,59,,,,,,59,28,,,24,34,28,,42,,,34,40,35,35,
     35,35,38,,,34,,34,126,34,108,38,,,130],
   [14,,,,30,46,,,,50,21,35,,21,,,,49,,,45,43,28,89,43,24,,28,,46,,,39,43,
     35,35,35,35,38,100,66,34,,31,156,34,,38,,,,64,63,7],
   [14,,46,,,,,,,,21,32,43,21,33,45,,47,,,43,49,28,86,,24,42,28,,,,,,,35,35,
     35,35,38,172,65,34,66,31,,34,61,38,,,156,63,64,7,7],
   [14,,40,,31,,,,,46,21,40,53,21,40,,,,,,,53,28,,40,24,34,28,,39,,,34,39,
     35,35,35,35,38,126,,34,87,34,130,34,,38,,,126,,,7,7,7]],
 [,[],[],[],[,21],[,,28],[,40,,35],[,,28,,,28],[,,,30,,,35],
   [,,,35,,,30,,35],[42,,,,118,,,56],[,76,,,,,,63,139],[,,92,,198,,,108],
   [42,63,56,100,63,70,100,70,100,100,21,28,35],
   [,109,84,,,,209,76,176,,28,35,42],
   [150,105,110,210,137,180,152,112,224,238,35,42,49],
   [56,,76,160,,,176,79,,162,,28,,28,35,42],
   [150,,,232,137,,160,114,222,234,,,35,35,42,49],
   [56,82,63,127,108,,128,,,117,28,35,42,,28,,35,42],
   [,147,108,,199,,,92,,,35,42,49,,,35,42,49],
   [,,116,,199,,406,108,,,,,35,35,42,49,,35,42,49],
   [150,105,114,222,137,,160,104,232,224,35,42,49,,,35,42,49,,35,49],
   [28,,,,48,124,,,,,84,,,84,,222,107,216,107,,,210],
   [,,,,,42,,42,,,,,,77,93,143,101,133,95,159,254],
   [,37,,,42,,56,,46,53,,133,,121,164,187,,367,131,228,434,195],
   [28,37,42,46,37,42,46,42,46,46,77,83,193,63,,,,,81,191,193,,28,35,37],
   [],[28,,,60,,,,,60,,84,107,140,84,107,140,107,140,107,140,140,140,28,,,
     28],[,,42,,,,,42,,,,,,91,,185,,193,179,,,189,,35,,35],
   [,42,,53,37,,,304,53,46,156,,264,121,,223,153,231,142,265,285,231,46,,
     42,37],[,,42,,,42,,,,,91,97,163,91,96,133,104,149,,,165,155,,35,,35,,
     ,35],[,37,,46,42,,54,,,53,156,137,228,121,,291,151,195,129,,217,375,,
     ,37,37,,,,42],[],
   [,42,,54,37,,46,,55,,,147,,121,165,187,,,133,221,,195,42,,42,37,,,,37,,42 
    ],[70,,,,,,264,,,339,105,,,105,191,,189,251,,,263,267,140,,,121,,140,391,,
     ,,,230],[70,105,140,160,105,140,160,140,160,160,105,,,105,,,175,,187,
     259,245,239,140,175,195,105,,140,175,195,175,195,,195,35],
   [70,163,,,,,,322,364,276,105,140,175,105,140,175,140,175,140,175,175,175,
     140,,226,123,,140,,,736,228,,229,35,35],
   [70,105,140,154,105,140,154,140,154,154,105,194,245,105,,271,,,,257,253,,
     140,175,189,105,,140,175,189,175,189,,189,35,35,35],
   [42,,,,79,56,130,56,129,,35,,,42,49,58,42,95,49,58,,58,84,,,70,,84,84,
     126,84,131,,,191,193,175,191],
   [,,,,,,71,,62,71,,,,128,,232,227,238,,,,238,,,,74,,136,,,,92,,111,,230,,224]
    ,[,,,,177,,223,147,251,,,,,49,56,65,,,56,65,53,65,,138,,,,163,156,269,
     182,236,,,,373,210,387],
   [42,53,56,62,53,56,62,56,62,62,42,49,58,35,,,49,58,42,95,58,,74,77,
     83,49,,74,77,83,77,83,,83,172,138,156,136,42,44,49],
   [112,146,143,251,178,156,,,,253,49,56,65,,,,56,65,,54,65,53,199,187,225,,
     ,163,,260,185,446,,226,498,,210,362,49,,56],
   [42,79,56,133,,,,56,133,133,35,42,51,35,42,51,42,51,42,51,51,51,84,84,
     130,70,,84,,,84,129,,133,160,158,140,160,35,,42,35,42],
   [,121,,,,,,,,62,,,,128,267,,265,238,,,,238,144,,117,74,,,,,,113,,92,1335,230,
     ,224,,49,,44],[42,53,56,62,53,56,62,56,62,62,35,42,95,42,49,58,,,
     49,58,95,58,74,77,83,49,,74,77,83,77,83,,83,168,138,158,140,35,44,,
     28,49,35,44],[,,,,179,157,239,140,262,,,,54,49,56,65,,,56,65,,65,463,
     ,606,,,163,180,265,199,,,,371,387,210,,,,42,49,56,42],
   [42,79,56,132,79,56,134,,,133,42,49,58,35,42,95,49,58,,,58,95,84,84,
     133,70,,84,84,129,,,,129,191,193,175,191,42,,49,35,,35,,42,49],
   [,,,62,,,71,,,,,,,128,353,234,229,242,,,,240,,,92,74,,146,,,,,,,,230,1243,
     224,,44,,44,,,49,44],
   [112,152,142,262,180,166,261,,,266,49,56,65,,,,56,65,,,65,53,199,157,243,
     418,,163,157,274,142,,,242,,357,210,473,49,,56,,42,42,,49,56],
   [,,,71,,,62,,77,,,,,128,353,242,229,248,,,,248,200,,111,74,,,,92,,121,,,,
     230,704,224,,49,,44,,,44,44,,,49],
   [,,278,,180,157,231,140,262,,,,54,49,56,65,,56,56,65,,65,,232,,,,163,157,
     274,190,238,,,472,,210,386,,,42,49,56,42,,,42,49,,56],
   [112,,,252,177,,,154,,252,49,56,65,,,53,56,65,,53,65,,199,185,,,,163,181,
     260,,526,,227,360,399,210,426,49,,56,,42,42,,49,56,,,42,,56],
   [14,,,,,,,48,,50,21,,,21,32,43,33,,,47,49,43,28,,,24,,28,89,,90,45,,43,
     35,35,35,35,38,,,34,,31,100,34,66,38,142,64,,66],
   [14,21,28,31,21,28,31,28,31,31,21,32,,21,,,32,43,33,,,45,28,35,38,21,,
     28,35,38,35,38,,38,35,35,35,35,38,45,61,28,,31,45,28,,38,45,66,45,
     66,62,7],[14,,48,,,,,,56,,21,28,35,21,28,35,28,35,28,35,35,35,28,,,
     24,,28,,,,,,,35,35,35,35,35,100,42,31,42,28,,31,42,35,142,42,142,42,
     42,7,7],[14,21,28,31,21,28,31,28,31,31,21,36,45,21,32,,,,,43,,,28,
     35,38,21,,28,35,38,35,38,,38,35,35,35,35,38,45,62,28,61,31,45,28,,
     38,45,68,45,66,,7,7,7],
   [14,30,,,,48,50,,,,21,32,43,21,36,49,,47,,,43,,28,89,43,24,,28,,45,,,,,
     35,35,35,35,38,100,65,34,62,31,156,34,64,38,,,142,64,64,7,7,7,7]],
 [,[],[],[],[],[],[],[,,,,,21],[,,,,10,,11],[,,,,,,11,,11],
   [22,,,,38,,,33],[],[],[24,,,,,57,,57,35,45,24],
   [,,,,40,,48,36,34,,27],[60,,,,62,93,57,55,,83,48],
   [24,,,,34,,39,42,,39,,,,30,24,65],[60,,,,72,,61,60,80,99,,,,54,47,60],
   [24,,,,29,52,34,,,35,24,,,,24,,24,48],[],
   [,,,,88,,82,60,,,,,,48,50,60,,44,68],
   [68,,,,,,,57,86,71,45,,,,,44,48,63,,,66],
   [6,,,,8,22,9,,,9,20,,,22,,48,22,48,22,,46,44],[],[],
   [8,,,,10,,11,22,10,11,23,,,23,,,,75,,,,75,7],
   [10,,,,12,,13,24,12,13,31,,,,29,,37,52,33,,55,82,8],
   [8,,,,,,,30,9,,23,,,23,30,45,26,47,29,,53,,7,,,8,9],
   [,,,,,,,23,,,,,,,,87,44,,43,,,,,,,21,22],
   [10,,,,8,,,36,10,10,29,,,31,38,54,30,66,28,,76,,8,,,9,10],[],
   [,,,,9,26,10,,,10,26,,,27,,105,26,51,24,,49,77,,,,8,9,8,,9],
   [10,,,,12,24,13,24,12,13,28,,,36,29,58,32,72,33,,,56,8,,,,9,9,22,10,,9 
    ],[10,,,,10,,10,34,10,,,,,,38,60,31,,27,,,52,8,,,9,10,,,9,,9,10],
   [34,,,,,150,57,180,55,65,108,,,114,135,,122,,132,,300,297,32,,,37,47,37,
     170,,,41,44,46],[38,,,,49,124,57,108,51,61,112,,,114,,,130,,141,,288,
     288,34,,,37,,37,159,46,,41,,46,36],
   [34,,,,,,,150,62,57,110,,,112,122,223,127,226,122,,226,226,32,,,37,44,37,,,
     ,41,,45,36,36],[30,,,,44,106,49,,62,49,106,,,114,,286,,,118,,272,,30,,
     ,35,42,35,186,42,,46,42,42,33,36,33],
   [18,,,,28,35,33,28,28,,20,,,23,21,39,21,50,21,,,38,18,,,22,26,22,32,26,
     ,23,26,26,98,106,98,90],[],[],
   [22,,,,26,38,27,32,26,27,23,,,22,,,25,43,25,,43,,18,,,17,,21,37,22,,21,
     28,22,94,88,94,86,21],
   [48,,,,64,71,63,66,,71,46,,,,,,,61,,,60,44,42,,,,,46,59,56,,73,63,52,291,,
     ,270,40],[22,,,,,,,31,31,33,22,,,22,29,44,26,44,26,,46,44,20,,,22,
     26,22,,,,24,28,27,106,108,104,104,21,,,21,44],
   [,,,,,,,,25,25,,,,,53,102,49,83,54,,,,19,,,21,25,,,,,22,25,22,195,127,,93,,
     ,,20],[18,,,,22,34,23,,22,23,22,,,23,21,43,,,21,,60,42,16,,,17,22,
     19,37,20,,19,22,20,87,86,86,74,18,,,17,57,21,17],
   [,,,,89,91,82,85,89,,,,,67,60,71,,,,,61,83,57,,,,72,64,102,80,,68,90,77,
     350,474,321,,,,,59,72,59],
   [18,,,,28,35,33,,,33,20,,,22,21,76,21,,,,47,66,18,,,22,26,22,34,26,,,26,
     26,100,102,100,90,18,,,21,,21,,18,65],
   [,,,,24,,25,,,25,,,,59,43,,45,78,,,,88,,,,20,24,21,,22,,,24,22,167,99,196,
     ,,,,19,,,19,16],[48,,,,65,69,64,,,72,46,,,,,45,78,76,,,73,47,42,,,120,
     ,48,64,59,,,54,55,289,368,238,268,40,,,,41,45,,45,67],
   [,,,,,,25,,25,,,,,63,53,102,49,89,49,,,91,19,,,21,25,,,22,,22,25,,,,147,
     93,,,,20,,,19,17,,,19],
   [,,,,102,76,106,64,72,,,,,50,47,58,,47,,,,64,,,,,54,66,66,94,,49,70,,390,
     ,241,267,,,,45,56,45,,,59,65,,72],
   [48,,,,65,73,64,61,,72,46,,,,,43,,74,,,72,,42,,,,,47,64,57,,76,62,53,283,
     331,257,322,40,,,,44,59,,45,68,,,41,,69],
   [46,,,,64,174,,172,67,86,148,,,158,175,339,,342,,,376,352,44,,,51,63,51,
     244,61,,54,60,62,236,248,236,224,134,,,126,,146,179,114,444,134,167,
     385,240,410,359],[50,,,,67,154,75,136,66,78,152,,,158,,,175,364,177,,
     370,378,46,,,51,,51,168,62,,55,63,63,244,250,244,238,142,,,120,,148,
     161,114,,140,130,391,180,403,385,48],
   [46,,,,,,,,73,81,150,,,156,162,,165,299,162,,314,304,44,,,51,60,51,,,,55,
     63,62,236,246,236,226,134,,,126,307,144,,115,418,134,175,296,225,321,
     312,48,48],[42,,,,62,140,67,,68,67,146,,,158,158,,,,159,,382,334,42,,,
     49,58,49,167,58,,58,58,58,230,246,228,210,126,,,118,349,144,127,102,,
     126,168,399,127,360,,45,48,45],
   [46,,,,65,178,77,,,81,146,,,158,171,351,,,,,366,355,44,,,51,60,51,,62,,,
     62,61,238,244,238,224,134,,,126,344,146,237,114,465,134,,,225,,,45,48,
     48,45],[48,,,,65,150,76,140,66,82,150,,,158,177,306,168,302,169,,324,
     308,46,,,51,,51,,63,,55,,63,242,250,244,238,140,,,120,298,148,159,114,
     447,142,131,302,170,405,302,48,48,48,48,48]],
 [,[],[],[],[,12,,13],[,,13],[,13,,14],[,,13,,,13],
   [,,,13,13,,14],[,13,,14,,,13,,14],[24,,,,,,,32],
   [,31,,,,41,40,30,43,42],[,,53,,156,,100,60],
   [24,33,26,38,33,37,38,37,38,38,24,19,46],[],[],[],
   [148,127,71,122,91,87,76,60,108,124,,,44,43],
   [,31,30,44,,41,,,,40,28,23,46,,,,,39],[,,60,,,,,53,,,,46,56,,,,,58],
   [,,61,,,,,60,,,,,42,46,,,,44,46,56],
   [,73,60,106,91,87,78,65,122,106,52,39,62,,,,,51,,44,58],
   [8,,,,10,,11,,,11,23,,,23,,,,81,,,,67],
   [,,,,,11,,11,,,,,,20,,,,49,24,48,,46],
   [,9,,,11,,12,,11,12,,28,,28,,,,90,28,55,80,58],
   [8,9,10,10,9,10,10,10,10,10,21,19,43,15,,,,41,19,43,43,41,7,8,8],
   [],[8,10,30,11,,,,,11,,23,26,47,23,,,,49,27,47,45,51,8,,9,7],
   [,,11,,,,,11,,,,29,,25,,,,59,29,,,59,,9,,8],
   [,11,30,12,9,,,,12,11,32,30,59,28,,,,60,29,,64,70,9,,10,8],
   [,,11,,,11,,,,,26,24,48,25,,,,46,,,48,51,,9,,8,,,9],
   [,9,,11,11,30,12,,,12,29,28,64,28,,,,60,28,,,72,,,9,8,,9,,10],
   [10,11,12,12,11,12,12,12,12,12,26,23,50,26,,,,46,23,60,50,,8,9,9,,,8,
     9,9,9,9],[10,11,,12,9,,11,30,12,,,30,94,28,,,,90,30,55,,56,9,,10,
     8,,,,9,,10,9],[40,,,,,142,76,146,70,76,111,,,105,,,,289,129,287,281,
     305,37,,,31,,37,119,,,46,38,46],
   [40,51,56,58,51,56,58,56,58,58,111,,297,75,,,,,111,297,263,,37,42,44,25,
     ,37,42,44,42,44,,44,34],
   [40,55,,70,,,,160,,70,111,127,227,99,,,,233,132,235,231,223,37,,45,31,,37,
     ,,130,45,38,47,34,34],
   [40,45,56,56,45,56,56,56,56,56,111,107,265,75,,,,,107,295,295,,35,42,
     42,25,,35,42,42,42,42,,42,34,25,34],
   [24,,,,34,29,,29,37,,21,,,18,,,,67,22,42,,38,22,,,18,,22,23,28,23,27,22,
     26,102,96,102,96],[,,,,29,,30,,29,30,,,,58,,,,122,,,,122,,,,18,,23,,24,
     ,23,22,24,,98,,96],[],
   [24,25,26,26,25,26,26,26,26,26,21,19,43,15,,,,43,19,51,43,,19,20,20,
     13,,19,20,20,20,20,24,20,87,65,87,65,18,18],[],
   [24,36,29,37,,,,29,,37,21,25,,21,,,,43,25,41,41,43,22,23,26,18,,22,,,
     23,28,22,27,102,96,102,96,21,,,18],
   [,29,,30,,,,,30,29,,60,,58,,,,118,61,,,110,23,,24,18,,,,,,24,22,23,246,98,
     ,96,,22,,18],[24,25,26,26,25,26,26,26,26,26,21,19,51,15,,,,,19,43,
     51,,19,20,20,13,,19,20,20,20,20,,20,87,65,87,65,18,18,,13,,18,18],
   [,,88,,,61,,61,114,,,,45,42,,,,,43,74,45,74,91,49,97,42,,,48,91,48,55,
     54,,336,292,254,,,,,42,,42],
   [24,,29,37,36,29,37,,,,24,22,42,21,,,,38,,,42,67,22,23,27,18,,22,23,26,,
     ,22,28,102,96,102,96,21,,,18,,21,,18,42],
   [,,,29,29,,30,,,30,,,,58,,,,108,,,,118,,,23,18,,23,,24,,,22,24,222,98,,96,
     ,21,,18,,,22,18],
   [152,,61,216,105,61,74,,,112,48,43,70,,,,,70,,,72,45,117,47,82,42,,49,
     47,84,42,,124,56,396,291,260,341,42,,,,,42,,65,106],
   [,29,,30,,,29,,30,,,61,,58,,,,122,60,,,122,23,,24,18,,,,23,,24,22,,,98,,
     96,,22,,18,,,21,18,,,22],
   [,,,,,81,106,81,116,,,,58,,,,,58,55,73,,75,,73,,,,66,60,75,60,71,77,,361,
     ,293,406,,,,,,54,,,60,54,,62],
   [120,97,81,112,,81,122,110,,,61,55,73,,,,,75,,58,71,,77,64,75,,,67,64,,
     77,114,83,75,380,384,300,446,54,,,,,54,,65,70,,,59,,83],
   [56,,,,77,134,,166,84,102,153,,,135,,,,355,,369,369,355,51,,,41,,51,,63,,
     61,50,62,235,217,235,217,138,,,113,,138,220,113,401,138,206,463,282,
     482,448],[56,69,76,78,69,76,78,76,78,78,153,145,,105,,,,287,145,337,
     339,303,51,58,60,35,,51,58,60,58,60,47,60,229,175,223,175,132,134,,
     91,,132,134,91,,132,134,331,134,,478,44],
   [56,,178,84,,,,,108,102,153,163,301,135,,,,293,162,301,301,289,51,114,,41,
     ,51,,,132,64,50,66,235,217,235,211,138,210,,113,,138,,113,350,138,,
     325,278,384,381,44,44],
   [56,63,76,76,63,76,76,76,76,76,153,145,335,105,,,,,145,335,355,309,49,
     58,58,35,,49,58,58,58,58,48,58,223,175,229,175,132,132,,91,,132,132,
     91,,132,132,381,132,509,,44,35,44],
   [56,,126,,73,126,93,,,99,153,163,347,129,,,,361,,,349,347,51,180,61,41,,
     51,,63,,,50,64,235,211,235,217,138,206,,113,,138,293,113,,138,,,293,
     440,440,44,44,44,44],
   [56,69,70,78,69,70,78,70,78,78,147,151,287,105,,,,,145,287,289,273,51,
     56,60,35,,51,56,60,56,60,,60,223,175,229,175,126,134,,91,,126,134,91,
     342,126,134,371,134,442,,44,35,44,35,44],
   [8,,,,10,,11,22,10,11,23,,,23,,,,61,,,,61,7,,,7,,8,20,9,,8,8,9,37,37,
     37,35,22,,,17,,22,21,17,71,22,20,107,21,69,69,51,51,51,49,51,51]],
 [,[],[],[],[],[],[],[,,21],[,,,11],[,10,,11,,,,,11],
   [24,,,,,,,36],[,,,,,,,38],[,,53,,,,,62],[24,,36,,,,,,,35,24,28,36],
   [,35,43,,,,,,40,,25,25,40],[,48,60,74,,,,,96,74,33,36,48],
   [,,,39,,,,43,,34,,24,,28,25,37],[148,110,,79,,,,62,,76,,,36,36,37,48],
   [,35,40,39,,,,,,,25,25,40,,24,,25,37],
   [,49,62,,,,,51,,,36,40,48,,,36,40,48],
   [,,51,,,,,62,,,,,36,36,34,45,,33,34,48],
   [,,62,,,,,61,79,66,36,37,48,,,36,36,45,,36,45],
   [8,,,,,,,,,9,23,,,23,,57,26,65,28,,61],
   [,,,,,,,22,,,,,,37,38,59,40,85,37,61,86,57],
   [,8,,,,,,,10,10,,,,32,33,44,31,72,32,47,76],
   [8,10,22,11,,,,,11,10,23,25,57,23,,,,57,27,57,51,59,8,21,9],
   [,12,24,13,,,,,13,12,32,29,47,,30,,,42,32,,44,74,9,22,10],
   [8,8,22,9,,,,22,9,,20,22,34,22,22,32,22,32,22,34,30,32,7,,8,7,8],
   [],[],[,,22,,,,,,,,38,35,61,,59,49,35,64,,,59,,,19,,21,22],
   [,10,,10,,,,,,10,29,35,47,,,70,30,,30,,44,72,,,9,9,10,8],
   [10,12,,13,,,,24,13,12,28,29,56,36,30,56,34,52,31,58,54,54,9,22,10,,
     9,8,,,22,10],[10,9,26,10,,,,26,10,,,26,61,27,29,37,27,69,32,41,,
     39,8,,9,8,9,,,,,9,9],
   [40,,,,,,,196,63,57,108,,,114,130,,126,243,130,252,228,266,37,,,37,46,32,,
     ,242,46,44,41],[40,49,122,59,,,,122,64,52,112,,,114,,,130,,148,282,
     258,266,37,165,46,37,,34,,,139,47,,41,36],
   [40,48,,63,,,,186,68,51,110,120,178,112,121,173,118,171,121,178,164,171,
     37,220,45,37,44,32,,,172,46,47,40,36,36],
   [40,46,104,49,,,,106,49,58,106,120,244,114,,254,,,125,244,,,35,163,42,35,
     42,30,,,146,42,42,44,33,36,33],
   [24,,,,,,,35,33,,20,,,23,25,33,,72,25,35,,35,22,,,22,28,20,,,34,27,26,
     24,106,108,106,104],
   [,,,,,,,,25,25,,,,,52,106,51,85,,,,,,,,21,25,19,,,,22,25,22,,126,,93],
   [,,,,,,,68,74,,,,,38,40,49,,39,40,51,37,50,,48,,,44,34,,,58,50,53,,,294,
     185,247],[24,26,34,27,,,,38,27,26,21,24,35,22,,,25,35,27,66,33,,21,
     35,22,17,,18,,,37,22,28,21,94,88,94,86,21,20,36],
   [,50,69,71,,,,,,64,36,39,51,,,,41,51,,38,49,38,50,61,46,,,34,,,49,73,
     65,40,283,,185,267,36,,48],
   [24,28,35,33,,,,35,33,28,22,21,34,22,22,34,21,34,22,34,30,34,22,32,
     26,22,26,18,,,32,26,26,23,98,104,98,90,21,,36,21,36],[],
   [24,22,38,23,,,,34,23,22,22,21,72,23,22,33,,,22,35,,32,19,,20,17,22,16,
     ,,37,20,22,19,87,86,86,74,21,17,,17,37,18],
   [,,,,,,,69,72,,,,40,40,43,52,,,43,53,39,53,70,60,76,,47,34,,,64,47,62,
     70,277,389,187,,,,37,37,52,36],
   [24,28,35,33,,,,,,31,21,24,35,22,27,68,25,35,,,33,66,22,34,27,22,26,20,
     ,,,,28,24,104,108,106,104,21,,36,21,,21,,21,37],
   [,,,25,,,,,,25,,,,,52,106,51,,,,,85,,,22,21,25,19,,,,,25,22,195,138,202,93,
     ,19,,20,,,,17],[152,52,68,74,,,,,,64,38,39,50,,,39,41,51,,,49,38,52,
     58,50,68,,34,,,50,,58,41,264,341,182,248,37,,45,,36,36,,37,49],
   [,24,,25,,,,,25,,,,,61,50,95,47,82,52,,,82,21,,22,20,24,,,,,22,24,,,99,
     139,,,19,,19,,,,16,,,19],
   [,,,,,,,69,72,,,,,42,43,51,,40,43,52,,53,,,,,47,34,,,62,49,58,,280,,184,
     269,,,40,38,49,36,,,37,38,,52],
   [120,51,67,72,,,,67,,65,40,41,52,,,,43,52,,41,51,,51,64,47,,,34,,,62,76,
     62,41,279,289,186,275,38,,49,,40,36,,37,46,,,37,,49],
   [56,,,,,,,192,75,78,148,,,158,176,309,167,308,,330,313,304,51,,,51,62,44,,,
     ,61,60,55,236,248,236,224,146,,,126,,134,,114,344,144,183,326,228,366,
     342],[56,64,154,76,,,,150,77,67,152,174,,158,,,173,312,189,322,302,
     314,51,193,62,51,,46,,,,62,63,55,244,250,244,238,148,161,334,120,,142,
     ,114,,148,159,333,131,362,353,48],
   [56,,186,75,,,,,83,71,150,163,246,156,167,237,161,237,164,246,227,235,51,
     210,,51,60,44,,,198,62,63,55,236,246,236,226,146,179,250,126,251,134,,
     115,255,146,185,248,207,253,255,48,48],
   [56,60,140,67,,,,140,67,,146,162,316,158,167,,,,167,316,,298,49,218,58,
     49,58,42,,,218,58,58,60,230,246,228,210,144,127,320,118,365,126,,102,,
     144,127,371,228,355,,45,48,45],
   [56,64,188,,,,,,,73,146,163,318,158,183,303,,320,,,291,313,51,,61,51,60,
     44,,,,,62,54,238,244,238,224,144,179,355,126,336,134,,114,353,146,,,
     217,377,377,45,48,48,45],
   [56,65,,75,,,,,75,67,150,168,250,158,174,242,169,244,174,250,234,244,51,
     207,62,51,,46,,,221,62,,55,242,250,244,238,148,159,261,120,260,142,,
     114,266,148,160,261,131,266,266,48,48,48,48,48],
   [8,,,,,,,20,9,9,23,,,23,28,45,25,45,27,,51,,7,,,8,9,7,,,,8,9,8,37,37,
     37,35,22,,,19,45,22,,17,62,22,19,47,19,62,47,51,51,51,49,51,51],
   [8,10,22,11,,,,,11,10,23,25,45,23,,,,49,27,47,45,51,8,20,9,7,,7,,,20,
     9,8,8,37,37,37,35,22,21,,17,,22,,17,,22,21,48,20,66,63,51,51,51,
     49,51,51,8]],
 [,[],[],[],[,9,,10],[,,10],[,10,,11],[,,10,,,10],
   [,,,10,10,,11],[,10,,11,,,10,,11],[22,,,,,,,24],
   [,24,,,28,31,31,23,33,33],[,,42,,81,,74,48],
   [24,30,24,35,30,34,36,34,35,35,21,18,41],[,,25,,,,,25,,,22,19],
   [,59,50,87,,72,56,59,109,,41,34,49],[],[],
   [,28,23,33,,31,31,,,31,21,18,37,,19],[,,48,,81,,,42,,,41,37,46,,,37],
   [,,54,,,,82,48,,,,,37,41,42,49,,,37,49],
   [148,61,50,106,89,72,66,54,104,102,44,33,56,,,33,,,,36,56],
   [6,,,,8,22,9,,,9,20,,,22,,,,,,,58,82],
   [,,,,,9,,9,,,,,,19,20,41,,,20,43,,45],
   [,7,,,9,26,10,,9,10,,24,,27,,51,,,26,,65,61],
   [8,9,10,10,9,10,10,10,10,10,21,19,55,15,,,,,19,55,55,,7,8,8],
   [10,11,12,12,11,12,12,12,12,12,26,23,50,,21,,,,23,62,50,84,8,9,9],
   [8,8,22,9,,,,22,9,,20,,46,22,,50,,,,46,,50,7,,8,7,8],
   [,,9,,,,,9,,,,25,,24,,54,,,25,,,62,,8,,8,9],
   [10,9,26,10,7,,,26,10,9,,26,65,27,,,,,,65,,85,8,,9,8,9],
   [,,9,,,9,,,,,21,20,43,24,20,42,,,,,43,50,,8,,8,9,,8],
   [,9,,9,9,26,10,,,10,29,26,,27,,63,,,24,,53,89,,,8,8,9,8,,9],
   [10,11,12,12,11,12,12,12,12,12,26,23,62,,,,,,23,62,62,78,8,9,9,,7,8,
     9,9,9,9],[10,9,26,10,9,,9,26,10,,,28,65,27,33,59,,,26,53,,59,8,,
     9,8,9,,,8,,9,9],[34,,,,,138,59,138,61,61,90,,,96,102,,,,100,230,232,
     263,32,,,31,38,32,77,,,44,38,43],
   [38,44,49,50,44,48,50,49,51,52,94,,273,72,,,,,96,273,242,226,34,39,41,
     25,,34,39,41,39,41,,41,29],
   [34,44,,59,,,,122,,55,92,94,198,92,96,190,,,96,194,195,194,32,,42,31,38,
     32,,,,42,38,42,29,29],
   [30,41,44,44,39,44,44,44,44,44,88,84,218,72,,222,,,84,204,204,,30,37,
     37,25,32,30,37,37,37,37,32,37,26,23,26],
   [18,,,,26,22,31,22,,,16,,,17,17,33,,,17,34,,32,18,,,18,22,20,19,24,19,
     25,22,24,81,82,81,74],
   [,,,,22,,23,,22,23,,,,57,50,113,,,,,,88,,,,18,22,19,,20,,19,22,20,,85,,74 
    ],[,,,,,49,66,49,132,,,,,,38,48,,,36,49,37,55,,37,,,,46,42,,42,,,,,237,
     205,205],[22,23,24,24,23,24,24,24,24,24,19,18,39,14,,,,,18,50,39,,
     18,19,19,13,,18,19,19,19,19,,19,80,62,80,62,17,17],[],
   [22,26,22,31,,,,22,31,,16,19,38,20,,38,,,19,38,36,36,20,19,24,18,22,18,
     ,,19,24,22,25,81,83,82,74,16,,35,17],
   [,22,,23,,,,,23,22,,47,,57,,95,,,49,,,98,19,,20,18,22,,,,,20,22,19,187,
     84,,74,,17,,17],[18,19,20,20,19,20,20,20,20,20,16,15,40,15,15,29,,
     ,15,30,40,,16,17,17,13,18,16,17,17,17,17,18,17,66,60,66,50,14,14,,
     13,,14,14],[],[18,,22,32,26,22,31,,,31,18,17,34,20,17,64,,,,,34,
     56,18,19,,18,22,20,19,24,,,22,24,84,84,82,74,16,,35,17,,16,,14],
   [,,,22,22,,23,,,23,,,,57,50,109,,,,,,102,,,19,18,22,19,,20,,,22,20,197,
     85,203,74,,16,,17,,,17,14],
   [,57,49,,115,49,,,,132,39,36,49,,,36,,,,,49,35,,42,55,,,,42,103,37,,,,
     254,265,205,207,35,,44,,,35,,31],
   [,22,,23,,,22,,23,,,49,,57,,119,,,47,,,90,19,,20,18,22,,,19,,20,22,,,85,
     181,74,,17,,17,,,16,14,,,17],
   [,,,,115,49,,49,,,,,37,40,38,,,,36,49,,55,,45,,,49,,42,103,42,55,79,,293,
     ,205,201,,,35,40,,35,,,,35,,47],
   [92,61,50,110,99,50,68,58,,106,38,34,64,,,34,,,,35,64,,81,43,52,,,46,
     43,87,46,87,,52,220,333,184,272,33,,66,,,33,,28,,,,36,,66],
   [46,,,,58,116,,146,71,83,122,,,124,138,296,,,,314,314,326,44,,,41,50,44,
     135,56,97,56,50,56,186,186,186,168,109,,,104,,109,171,86,,110,175,308,
     227,,295],[50,57,65,67,58,65,66,64,66,67,126,122,,100,,,,,124,294,
     303,284,46,53,55,35,,46,53,55,53,55,50,55,190,160,186,154,110,112,
     293,86,,110,112,80,,111,112,293,113,308,371,37],
   [46,,138,71,,,,,77,77,124,126,256,126,124,246,,,126,254,262,247,44,97,,
     41,50,44,,,,57,50,58,186,188,186,168,109,169,261,104,,110,,86,,109,
     175,259,225,260,236,37,37],
   [42,53,60,60,55,60,60,60,60,60,120,114,280,100,113,,,,114,280,276,,42,
     51,51,35,44,42,51,51,51,51,44,51,176,158,176,140,102,102,261,86,,
     102,102,70,,102,102,265,102,265,,34,31,34],
   [46,60,112,,,112,71,,,83,124,125,291,120,136,298,,,,,316,302,44,,57,41,
     50,44,,,,,50,56,188,184,188,168,110,,,104,,109,213,86,,109,,,231,345,
     299,34,37,37,34],
   [48,58,64,66,57,62,67,64,66,67,126,127,248,100,131,236,,,121,248,249,
     230,46,51,55,35,,46,51,55,51,55,,55,188,160,190,154,108,112,259,86,,
     110,112,80,,110,113,262,113,283,297,37,31,37,31,37],
   [6,,,,8,22,9,,8,9,20,,,22,23,42,,,21,,42,46,6,,,7,8,7,,8,,7,8,8,32,
     34,32,30,18,,,16,,20,17,14,,18,16,43,17,43,43,44,46,44,42,44,46],
   [8,9,10,10,9,10,10,10,10,10,21,19,49,15,,,,,19,49,49,61,7,8,8,5,,7,
     8,8,8,8,6,8,31,25,31,25,18,18,,13,,18,18,13,,18,18,,18,63,,41,35,
     41,35,41,35,7],[8,8,22,9,,,,22,9,8,20,21,44,22,24,40,,,24,42,44,
     44,7,,8,7,8,6,,,,8,8,7,32,34,32,30,20,17,43,16,,18,,14,,20,17,,16,
     56,43,44,46,44,42,44,46,7,7]],
 [,[],[],[],[,9,,10],[,,21],[,10,,11],[],[],[,10,,11,,,11],
   [22,,,,42],[,24,,,29,52,32],[],[24,,38,35,,,,,,,24],
   [,,39,,36,,42,,,,27,24],[,,62,,76,,59,,,97,48],
   [,,36,34,34,,39,,,39,,24,,30,24,47],[,83,61,86,81,,,,,89,,,,48,,60],
   [],[],[,,65,,76,,88,,,,,,,48,68,60,,44],
   [148,,60,82,74,125,65,,,,51,54,,,,46,46,63,,,62],
   [6,,,,8,22,9,,,9,20,,,22,,,,,,,58,82],[],
   [,7,,,9,26,10,,,10,,24,,27,27,56,27,77,,,67,53],
   [8,,22,10,10,22,11,,,11,23,27,,23,,,,59,,,59,57,7,,8],
   [10,,24,12,12,24,13,,,13,28,,,,29,,39,54,,,,72,8,,9],
   [8,8,30,9,,,,,,,23,,,23,28,51,26,,,,45,49,7,,8,8,9],
   [,,23,,,,,,,,,43,,,,101,50,,,,,,,,,21,22],
   [10,9,36,10,8,,,,,10,29,27,,,34,66,30,77,,,64,68,8,,9,9,10],[],[],
   [10,,24,12,12,,13,,,13,31,33,,34,29,70,36,54,,,73,70,8,,9,,9,9,22,10],
   [10,9,34,10,10,,10,,,,,29,,31,34,50,31,80,,,,67,8,,9,9,10,,,9,,,10],
   [34,,,,,188,57,,,69,108,,,114,127,,137,273,,,296,333,32,,,37,44,37,,,,,,48]
    ,[38,,,50,,126,61,,,,112,,,114,,,145,,,,,,34,,41,37,,37,139,48,,,,,36],
   [34,,,55,,,,,,57,110,124,,112,,245,,,,,244,,32,,40,37,51,37,,,,,44,45,36,
     36],[30,,,60,44,106,49,,,49,106,123,,114,,312,,,,,294,,30,,,35,42,35,,
     42,,,42,42,33,36,33],
   [18,,,,28,35,33,,,,20,,,23,21,45,21,66,,,,50,18,,,22,26,22,34,26,,,26,
     26,98,106,98,90],[,,,,24,,25,,,25,,,,59,43,,47,88,,,,80,,,,20,24,21,,
     22,,,24,22,,99,,152],
   [,,,,65,73,64,,,,,,,50,48,71,,45,,,46,77,,,,,55,48,62,59,,,58,,,311,344,
     283],[22,,36,26,26,34,27,,,27,23,,,22,,,26,45,,,45,,18,,21,17,,21,
     35,22,,,28,22,94,88,94,86,21,19,45],
   [,,70,74,74,93,71,,,81,,79,,,,,51,62,,,63,48,,,48,,,48,69,64,,,101,54,
     377,,316,328,,,69],
   [22,30,31,31,,,,,,33,22,26,,22,26,44,,44,,,46,46,20,,24,22,28,22,,,,,26,
     27,106,108,104,104,21,,,21,45],
   [,22,,25,,,,,,25,,48,,,50,94,51,,,,,81,19,,22,21,25,,,,,,25,22,197,133,,
     93,,19,,20],[18,19,28,22,22,38,23,,,23,22,21,,23,21,41,,,,,68,42,16,
     ,19,17,22,19,,20,,,22,20,87,86,86,74,18,16,,17,45,21,17],
   [,,65,,65,69,64,,,,,,,,48,72,,,,,45,89,,,76,69,57,47,70,57,,,65,82,299,
     420,271,,,,41,,72,45],
   [18,23,28,28,28,35,33,,,33,20,21,,22,21,56,21,38,,,41,50,18,,23,22,26,
     22,32,26,,,26,26,100,102,100,90,18,,40,21,,21,,18,40],[],[],
   [,22,,25,,,25,,,,,54,,63,50,92,51,91,,,,137,19,,22,21,25,,,22,,,25,,,,
     145,93,,19,,20,,,19,17],
   [,,,,66,,66,,,,,,,63,47,58,,46,,,,62,,,,,74,48,58,60,,,56,,350,,224,279,,,
     44,57,56,44,,,41,40],
   [92,,81,89,89,95,90,,,96,67,,,,,58,66,75,,,73,,81,,68,,,64,102,80,,,90,
     70,370,442,,376,65,,71,,62,57,,57,72,,,,,69],
   [46,,,,64,174,,,,86,148,,,158,168,341,167,344,,,386,370,44,,,51,60,51,,61,,
     ,62,62,236,248,236,224,134,,,126,,146,185,114,364,134,,,240,,492],
   [50,,136,67,65,152,75,,,82,152,171,,158,,,178,354,,,368,388,46,,55,51,,
     51,199,62,,,64,63,244,250,244,238,142,130,364,120,,148,159,114,,140,,,
     170,395,,48],[46,,232,67,,,,,,81,150,166,,156,162,307,162,307,,,320,
     334,44,,,51,62,51,,,,,60,62,236,246,236,226,134,169,345,126,321,144,,
     115,339,134,,,225,331,427,48,48],
   [42,57,158,74,62,140,67,,,67,146,159,,158,159,,,,,,396,352,42,,55,49,58,
     49,201,58,,,58,58,230,246,228,210,126,176,354,118,376,144,127,102,,126,
     ,,127,363,,45,48,45],
   [46,60,158,,65,186,77,,,81,146,164,,158,174,357,,365,,,362,355,44,,54,51,
     62,51,,62,,,60,61,238,244,238,224,134,167,401,126,413,146,235,114,357,
     134,,,225,338,,45,48,48,45],
   [48,63,140,66,65,146,78,,,78,150,168,,158,169,308,177,306,,,324,320,46,,
     55,51,,51,,63,,,,62,242,250,244,238,140,130,302,120,361,148,159,114,
     302,142,,,191,296,435,48,48,48,48,48],
   [6,,,,8,18,9,,,9,20,,,22,21,,21,50,,,52,56,6,,,7,8,7,17,8,,,8,8,32,
     34,32,30,18,,,18,47,20,19,16,62,18,,,19,47,62,44,46,44,42,44,46],
   [8,,22,10,10,22,11,,,11,23,27,,23,,,,51,,,51,49,7,,8,7,,8,20,9,,,8,9,
     37,37,37,35,22,20,,17,,22,21,17,48,22,,,21,61,62,51,51,51,49,51,51,
     7],[8,8,20,9,,,,,,9,23,,,23,27,51,25,,,,45,49,7,,8,8,9,7,,,,,9,8,
     37,37,37,35,22,19,47,19,47,22,,17,47,22,,,19,47,62,51,51,51,49,51,
     51,7,8],[6,7,,8,8,22,9,,,9,20,21,,22,,50,,,,,52,68,6,,7,7,8,7,,8,
     ,,8,8,32,34,32,30,18,16,66,16,,20,17,14,,18,,,17,,70,44,46,44,42,
     44,46,6,7,7]],
 [,[],[],[],[,12,,13],[,,13],[,13,,14],[,,13,,,13],
   [,,,13,13,,14],[,13,,14,,,13,,14],[24,,,,55,,,32],
   [,31,,,38,41,40,30,43,44],[,,45,,86,,85,50],
   [24,33,26,38,33,37,38,37,38,38,24,19,34],
   [,40,34,,,,,34,45,,25,26,35],[80,45,44,80,61,63,50,53,96,90,34,29,44 
    ],[32,,34,66,40,,45,34,,45,,26,,22,26,32],
   [80,111,53,98,67,63,58,44,82,98,,,34,25,32,35],
   [32,31,30,43,38,41,41,,,40,28,23,38,,26,,26,29],
   [,65,50,,84,,,45,,,34,38,44,,,34,35,44],
   [,,45,,86,,82,50,,,,,34,34,35,44,,34,38,44],
   [80,51,44,82,67,63,58,45,98,82,34,29,44,,,25,32,35,,34,44],
   [8,,,,10,30,11,,,11,23,,,23,,55,26,63,28,,,51],
   [,,,,,11,,11,,,,,,20,26,34,27,33,24,40,65,34],
   [,9,,,11,30,12,,11,12,,28,,28,33,42,,80,28,47,,44],
   [8,9,10,10,9,10,10,10,10,10,21,19,55,15,,,,,19,55,55,,7,8,8],
   [10,11,12,12,11,12,12,12,12,12,26,23,38,,,,33,30,23,58,38,,8,9,9],
   [8,10,,11,,,,30,11,,23,26,37,23,25,35,28,37,27,37,37,37,8,,9,7,8],
   [,,11,,,,,11,,,,29,,25,,43,,43,29,,,43,,9,,8,9],
   [10,11,,12,9,,,30,12,11,29,30,58,28,,50,32,54,29,56,60,54,9,,10,8,9],
   [,,11,,,11,,,,,26,24,40,25,26,33,27,34,,,40,37,,9,,8,9,,9],
   [,9,,11,11,,12,,,12,34,28,47,28,,72,33,44,28,,47,74,,,9,8,9,9,,10],
   [],[,11,30,12,9,,11,,12,,,30,,28,32,40,34,80,30,47,,44,9,,10,8,9,,,
     9,,10],[40,,,,,,64,,,,111,,,105,,,136,249,,,251,263,37,,,31,38,37,92,,,,
     ,51],[40,51,56,58,51,56,58,56,58,58,111,,255,75,,,131,,111,255,233,
     187,37,42,44,25,,37,42,44,42,44,,44,34],
   [40,59,,82,,,,142,82,64,111,123,173,99,123,167,123,161,124,173,173,161,
     37,136,47,31,38,37,,,174,46,,45,34,34],
   [40,45,56,56,45,56,56,56,56,56,111,107,241,75,,,,,107,243,243,,35,42,
     42,25,41,35,42,42,42,42,,42,34,25,34],
   [24,,,,35,29,37,29,37,,21,,,18,23,28,23,57,22,34,,28,22,,,18,22,22,23,
     26,23,27,,,102,96,102,96],
   [,,,,29,,30,,29,30,,,,54,62,110,,114,,,,114,,,,18,22,23,,24,,23,,24,,98,,
     96],[,,,,74,52,65,52,96,,,,,36,42,44,,34,37,49,39,45,,36,,,39,42,
     40,59,40,50,,,,301,185,280],
   [24,25,26,26,25,26,26,26,26,26,21,19,31,15,,,20,25,19,47,31,,19,20,
     20,13,,19,20,20,20,20,,20,87,65,87,65,18,18,36],
   [64,58,52,81,81,52,,,,96,39,37,49,,,,40,45,,39,49,34,52,41,48,,,40,41,
     59,39,92,,51,,,184,307,36,,45],
   [24,35,29,46,,,,29,37,37,21,25,31,21,22,31,22,31,25,31,31,31,22,23,
     29,18,22,22,,,23,26,,27,102,96,102,96,21,,36,18,36],
   [,29,,30,,,,,30,29,,56,,54,,,62,114,,,,114,23,,24,18,22,,,,,24,,23,236,98,
     ,96,,22,,18],[24,25,26,26,25,26,26,26,26,26,21,19,47,15,20,25,,,
     19,31,47,25,19,20,20,13,,19,20,20,20,20,,20,87,65,87,65,18,18,,13,
     36,18,18],[,,,,74,52,65,52,90,,,,39,33,40,44,,,37,49,39,44,,40,,,
     40,42,41,58,41,,,92,290,266,184,,,,35,33,42,36],
   [24,35,29,37,35,29,46,,,37,24,22,34,21,23,57,23,28,,,34,57,22,23,27,
     18,22,22,23,29,,,,26,102,96,102,96,21,,36,18,,21,,18,36],
   [,,,29,29,,30,,,30,,,,54,62,110,,114,,,,114,,,23,18,22,23,,24,,,,24,,98,
     252,96,,21,,18,,,22,18],
   [64,65,52,90,74,52,65,,,81,39,37,49,,,34,42,44,,,49,,49,40,48,,,42,40,
     59,36,,,49,,266,185,335,36,,42,,35,36,,36,45],
   [,29,,30,,,29,,30,,,59,,54,,110,62,114,56,,,114,23,,24,18,22,,,23,,24,,,,
     98,172,96,,22,,18,,,21,18,,,22],
   [,,50,,81,52,74,52,81,,,,39,36,42,44,,,37,49,,45,,,,,38,39,40,59,40,49,,
     ,295,,184,271,,,32,36,45,36,,,35,36,,42],
   [64,,52,96,74,52,65,50,,81,39,37,49,,,34,40,45,,39,49,,50,41,,,,42,41,
     58,,,,48,290,301,186,435,36,,45,,32,36,,36,42,,,35,,45],
   [56,,,,73,130,,152,90,,153,,,135,171,289,167,291,,335,335,291,51,,,41,50,
     51,,61,129,63,,61,235,217,235,217,138,,,113,,138,206,113,344,138,216,
     348,,376,348],[56,69,76,78,69,76,78,76,78,78,153,145,,105,,,176,,
     145,291,293,237,51,58,60,35,,51,58,60,58,60,,60,229,175,223,175,132,
     134,344,91,,132,134,91,,132,134,313,134,317,347,44],
   [56,,170,90,,,,,96,90,153,162,235,135,162,217,163,217,161,235,235,211,51,
     134,,41,50,51,,,,62,,62,235,217,235,211,138,284,244,113,245,138,,113,
     244,138,284,244,270,245,244,44,44],
   [56,63,76,76,63,76,76,76,76,76,153,145,297,105,162,,,,145,297,315,227,
     49,58,58,35,,49,58,58,58,58,,58,223,175,229,175,132,132,310,91,340,
     132,132,91,,132,132,330,132,322,,44,35,44],
   [56,77,142,,,142,,,,90,153,164,301,129,173,285,,297,,,,289,51,150,63,41,
     50,51,,,,,,61,235,211,235,217,138,226,368,113,337,138,314,113,339,138,,
     ,266,341,344,44,44,44,44],
   [56,69,70,78,69,70,78,70,78,78,147,151,223,105,146,175,148,175,145,223,
     223,175,51,56,60,35,,51,56,60,56,60,,60,223,175,229,175,126,134,218,
     91,218,126,134,91,219,126,134,219,134,219,218,44,35,44,35,44],
   [8,,,,10,22,11,22,10,11,23,,,23,28,43,25,51,27,,,45,7,,,7,8,8,20,9,,8,
     ,9,37,37,37,35,22,,,17,47,22,21,17,,22,20,45,21,66,45,51,51,51,49,
     51,51],[8,9,10,10,9,10,10,10,10,10,21,19,39,15,,,,37,19,41,39,,7,
     8,8,5,,7,8,8,8,8,,8,31,25,31,25,18,18,,13,,18,18,13,39,18,18,,18,
     ,56,41,35,41,35,41,35,7],
   [8,10,,11,,,,22,11,10,23,25,37,23,25,35,27,37,27,37,37,37,8,20,9,7,
     8,7,,,20,9,,8,37,37,37,35,22,21,41,17,39,22,,17,41,22,21,41,20,39,
     41,51,51,51,49,51,51,8,7],
   [8,9,10,10,9,10,10,10,10,10,21,19,41,15,22,,,,19,39,41,37,7,8,8,5,
     6,7,8,8,8,8,,8,31,25,31,25,18,18,56,13,,18,18,13,,18,18,39,18,,,
     41,35,41,35,41,35,7,5,7],
   [8,,22,10,10,,11,,,11,23,27,,23,27,45,,45,,,,51,7,,8,7,8,8,20,9,,,,9,
     37,37,37,35,22,20,45,17,66,22,21,17,45,22,,,21,47,,51,51,51,49,51,
     51,7,7,8,7]],
 [,[],[],[],[,9,,10],[,,21],[,10,,11],[,,21,,,21],
   [,,,11,10,,11],[],[24,,,,,,,42],[,29,,,,,,41,39],[,,57,,,,72,66],
   [24,,,46,,63,36,63,,,24,30],[],[80,68,,80,,90,56,63,114,,,55,62],
   [32,,49,39,,,34,,,,,27,,30],[80,,81,99,81,137,58,66,83,,,,44,48,,66],
   [32,,40,48,25,45,,,,,24,27,,,,,24,65],
   [,71,82,,,,,61,,,42,56,60,,,46,,60],[],
   [80,58,86,71,,93,54,63,,,42,,66,,,46,48,63,,44],
   [8,,,,8,32,9,,,,23,,,23,,63,26,55,28,,,57],
   [,,,,,23,,22,,,,,,39,,75,,,37,73,,81],
   [,8,,,9,34,10,,10,,,29,,,,60,31,,,64,,52],
   [8,10,,11,,22,10,22,11,,23,28,69,23,,,,75,25,67,,75,8,21,9],
   [10,12,,13,,24,12,24,13,,28,32,55,,,,,52,29,94,,82,9,22,10],
   [8,8,22,9,,,,22,9,,20,,46,22,,50,,,,46,,50,7,,8,7,8],[],
   [10,9,26,10,7,,,26,10,,26,,63,27,,59,26,63,25,53,,51,8,,9,8,9],
   [,,22,,,23,,,,,41,38,63,,,69,40,133,,,,,,19,,21,22],
   [,10,,10,9,36,10,,,,29,32,55,30,,74,30,54,31,,,,,,9,9,10,8,,9],
   [,12,24,13,,24,12,,13,,,33,,36,,62,34,72,29,58,,56,9,22,10,,9,8,,9,
     22,10],[],[40,,,,,,51,168,63,,108,,,114,,,125,267,125,286,,298,37,,,
     37,44,32,,,233,46,46],
   [40,,,57,,104,50,,,,112,,312,114,,,133,,,,,288,37,136,,37,,34,,41,,,,,36],
   [40,48,,63,,,,166,78,,110,,230,112,,243,128,223,127,230,,229,37,,45,37,,
     32,,,,47,44,,36,36],
   [40,46,104,49,,116,58,106,49,,106,134,284,114,,302,,,119,284,,,35,,42,35,
     42,30,,,185,42,42,,33,36,33],
   [24,,,,,31,31,35,33,,20,,,23,,41,25,56,24,41,,41,22,,,22,26,20,,24,34,
     27,,,106,108,106,104],
   [,,,,22,,25,,25,,,,,,,114,49,,,,,91,,,,21,25,19,,22,,22,25,,,151,,93],
   [,,,,109,66,58,74,120,,,,,48,,63,,47,49,60,,64,,54,,,52,46,,59,60,84,63,,
     ,322,246,270],[24,26,,27,,36,26,34,27,,21,27,43,22,,,25,43,24,68,,,
     21,37,22,17,,18,,21,35,22,28,,94,88,94,86,21,20,44],
   [64,56,,71,,66,56,91,,,43,54,60,,,,,63,,45,,44,50,69,52,,,,,50,62,79,63,
     ,293,,226,279,43,,56],
   [24,28,37,33,,,,35,33,,22,,44,22,,46,21,44,21,44,,44,22,36,26,22,26,18,
     ,,34,26,26,,98,104,98,90,21,,45,21],
   [,24,,25,,,,,25,,,,,59,,103,45,78,48,,,88,21,,22,20,24,,,,,22,24,,179,98,
     ,192,,19,,19],[24,22,38,23,19,28,22,38,23,,22,24,60,23,,49,,,21,45,
     ,42,19,,20,17,22,16,,19,,20,22,,87,86,86,74,21,17,,17,57,18,16],
   [,,184,,,85,75,87,96,,,,61,63,,81,,,64,73,,83,71,,77,,72,,,74,96,74,89,,
     ,482,328,,,,59,57,76,57],
   [24,28,37,33,30,31,31,,,,21,27,53,22,,,,47,,,,,22,36,27,22,28,20,,24,,,
     26,,104,108,106,104,21,,,21,,21,,21],
   [,,,25,22,,25,,,,,,,63,,114,49,83,,,,,,,22,21,25,19,,22,,,25,,193,,230,93,
     ,19,,20,,,19,17],
   [64,58,79,74,,60,56,,,,40,54,63,,,47,75,61,,,,44,52,68,56,114,,,,51,54,,
     58,,270,,251,308,40,,53,,40,57,,,70],[],[],
   [64,57,110,72,227,57,57,,,,43,51,72,,,48,,74,,45,,,51,,53,,,46,,51,66,
     82,62,,296,303,266,385,43,,69,,44,45,,45,68,,,41],
   [56,,,,60,,,244,75,,148,,,158,,379,163,364,,424,,,51,,,51,60,44,,54,208,
     61,67,,236,248,236,224,146,,,126,,134,167,114,499,144,179,345],
   [56,66,,,,,66,158,79,,152,196,,158,,,173,358,183,378,,396,51,172,63,51,,
     46,,55,172,64,64,,244,250,244,238,148,167,454,120,,142,130,114,,148,
     167,372,,,397,48],[56,,220,75,,,,,87,,150,,,156,,323,,303,168,310,,305,
     51,234,,51,63,44,,,,64,60,,236,246,236,226,146,179,319,126,309,134,,
     115,421,146,193,321,,,313,48,48],
   [56,60,140,67,,156,76,140,67,,146,177,364,158,,,,,163,364,,340,49,,58,49,
     58,42,,,,58,58,,230,246,228,210,144,127,410,118,355,126,184,102,,144,
     127,405,,,,45,48,45],
   [56,64,174,,66,166,73,,,,146,182,368,158,,371,,406,,,,369,51,,61,51,64,44,
     ,56,,,60,,238,244,238,224,144,179,542,126,360,134,231,114,544,146,,,,,
     395,45,48,48,45],
   [56,,162,79,61,134,67,162,79,,150,,324,158,,320,169,302,169,328,,308,51,
     180,64,51,,46,,55,,63,,,242,250,244,238,148,167,392,120,297,142,130,
     114,,148,,298,,,302,48,48,48,48,48],
   [8,,,,8,20,9,20,9,,23,,,23,,51,25,43,27,,,45,7,,,8,9,7,,8,,8,9,,37,
     37,37,35,22,,,19,45,22,19,17,63,22,19,47,,,47,51,51,51,49,51,51],
   [8,10,,11,,22,10,22,11,,23,28,61,23,,,,61,25,61,,61,8,20,9,7,,7,,8,
     20,9,8,,37,37,37,35,22,21,,17,,22,20,17,,22,21,69,,,,51,51,51,49,
     51,51,8],[8,8,18,9,,,,18,9,,20,,44,22,,44,21,42,,42,,40,7,17,8,7,
     8,6,,,17,8,8,,32,34,32,30,20,19,41,18,39,18,,16,56,20,19,39,,,41,
     44,46,44,42,44,46,7,7],
   [8,8,22,9,7,,8,22,9,,20,24,42,22,,46,,,21,44,,46,7,,8,7,8,6,,7,,8,8,
     ,32,34,32,30,20,17,43,16,,18,16,14,,20,17,56,,,43,44,46,44,42,44,
     46,7,7,6],[8,8,20,9,8,20,9,,,,23,27,,23,,61,25,53,,,,,7,,8,8,9,7,
     ,8,,,9,,37,37,37,35,22,19,68,19,53,22,19,17,68,22,,,,,68,51,51,51,
     49,51,51,7,8,7,7],
   [8,10,22,11,,22,10,,11,,23,29,47,23,,47,27,51,25,45,,45,8,20,9,7,8,7,
     ,8,20,9,,,37,37,37,35,22,21,66,17,45,22,20,17,66,22,21,47,,,47,51,
     51,51,49,51,51,8,7,7,7,8]],
 [,[],[],[],[],[],[],[,,,,,24],[],[,,,,,,46],[18,,,,43,,,20],
   [],[],[18,,,,35,36,64,36,,,9],[,,,,,,66,30,,,10],
   [,,,,45,50,56,30,,,11],[28,,,,49,,,29,,72,,,,15,16,17],
   [30,,,,42,30,,26,,68,,,,11,12,13],[28,,,,38,27,56,,,51,10,,,,12,,16,12],
   [,,,,,,,28,,,11,,,,,13,17,13],[,,,,57,,,26,,,,,,11,12,13,,11,12,13],
   [34,,,,,50,72,28,,72,11,,,,,13,17,13,,13,13],
   [36,,,,50,68,58,,,62,32,,,36,,60,46,48,45,,46,52],[],[],
   [36,,,,,65,66,44,,74,31,,,30,,,,42,36,46,46,52,34],
   [62,,,,72,72,97,60,,85,44,,,,47,,61,58,49,72,54,66,46],
   [36,,,,,,,52,,,28,,,36,43,48,50,50,43,48,44,48,34,,,34,45],[],
   [62,,,,47,,,96,,62,48,,,58,64,64,58,64,54,88,78,74,45,,,47,52],
   [,,,,,39,,,,,33,,,,40,43,38,38,,,42,45,,,,35,44],
   [,,,,62,90,70,,,74,48,,,58,,69,64,63,52,,82,81,,,,47,52,45,,56],
   [,,,,82,,81,60,,89,44,,,66,,90,56,50,49,67,58,58,45,,,,38,45,,52,44,52]
    ,[],[90,,,,,,320,142,,368,39,,,45,68,,81,55,66,61,55,65,168,,,153,
     229,164,,,285,265],[90,,,,174,130,,122,,282,39,,,45,,,78,,77,63,57,65,
     168,,,143,,160,,256,203,256,,,41],
   [90,,,,,,,136,,318,35,,,45,54,59,71,53,54,59,55,59,164,,,153,219,140,,,
     278,251,221,,41,41],
   [90,,,,173,134,,138,,246,39,,,45,,63,,,63,61,55,,168,,,143,196,164,,236,
     222,242,196,,41,41,41],
   [18,,,,35,18,,20,,,13,,,18,19,20,18,21,19,20,,20,32,,,29,40,28,,44,31,
     46,40,,75,75,65,75],[],[],
   [18,,,,31,26,44,24,,44,16,,,16,,,21,19,19,24,19,,34,,,27,,34,,46,35,45,
     60,,78,78,76,78,16],
   [36,,,,57,45,73,39,,116,17,,,,,,22,20,,20,20,20,60,,,,,62,,77,48,92,79,,
     132,,81,95,17],[18,,,,,,,20,,58,13,,,16,17,18,20,16,17,18,16,18,32,,
     ,29,40,28,,,31,47,40,,65,65,57,65,13,,,14,15],
   [,,,,,,,,,80,,,,93,85,110,,93,105,,,105,90,,,,129,,,,,115,127,,571,724,,416,,
     ,,70],[18,,,,33,18,,20,,48,13,,,18,19,20,,,19,20,21,20,32,,,27,36,
     28,,45,29,45,36,,75,75,65,75,13,,,16,17,13,76],
   [,,,,55,31,97,33,,,,,,18,19,20,,,19,20,18,20,68,,,46,69,77,,72,44,64,73,
     ,89,92,87,,,,,16,17,13],
   [18,,,,45,20,56,,,62,16,,,16,19,24,21,19,,,19,24,34,,,32,44,34,,50,,,44,
     ,78,78,76,78,16,,,16,,14,,16,16],
   [,,,,54,,62,,,68,,,,93,55,120,61,63,,,,127,,,,74,92,66,,81,,,,,519,356,
     406,330,,,,46,,,94,76],
   [32,,,,,45,80,,,100,17,,,,,20,22,20,,,20,20,58,,,49,,62,,,45,,63,,97,97,
     81,107,17,,,,17,15,,17,17],[],
   [,,,,54,31,,33,,,,,,18,19,20,,18,19,20,,20,,,,,51,,,76,41,98,52,,92,,,90,,
     ,,16,17,13,,,15,16,,17],
   [36,,,,84,45,74,35,,80,17,,,,,20,22,20,,20,20,,60,,,,,62,,101,50,88,79,,
     99,128,81,98,17,,,,17,15,,17,17,,,17,,17],
   [126,,,,255,,,180,,440,53,,,63,88,87,103,73,,85,75,85,232,,,207,300,220,,
     341,285,340,299,,285,285,273,285,101,,,106,,87,594,101,115,106,545,126,
     ,117,129],[126,,,,233,162,338,160,,368,53,,,63,,,102,73,87,83,75,87,
     232,,,197,,220,,340,242,347,314,,285,285,273,285,101,,,106,,87,716,101,,
     106,400,125,,122,139,55],
   [126,,,,,,,,,459,49,,,63,74,81,95,71,74,81,71,81,228,,,207,290,196,,,282,
     333,291,,281,277,245,281,91,,,104,111,79,,91,111,104,395,111,,117,111,
     55,55],[126,,,,243,162,,164,,326,53,,,63,88,,,,86,89,75,83,232,,,197,
     268,216,,320,292,317,268,,285,285,269,285,101,,,106,125,87,,101,,106,
     380,,,117,,55,55,55],
   [126,,,,265,180,380,,,452,53,,,63,86,83,,77,,,73,83,232,,,207,,220,,344,,,
     299,,285,285,273,285,101,,,106,125,87,786,101,119,106,,,,118,130,55,55,
     55,55],[126,,,,225,,343,148,,,49,,,63,70,81,,71,70,81,77,81,232,,,193,
     ,196,,336,217,336,,,277,281,245,277,91,,,100,111,79,593,91,111,100,
     475,111,,119,111,55,55,49,55,55],
   [58,,,,78,95,81,75,,91,52,,,68,64,86,61,71,62,,78,81,52,,,61,73,57,,71,
     ,64,70,,276,292,264,260,48,,,59,86,54,125,49,92,52,84,86,,78,88,372,
     388,360,356,372,370],
   [72,,,,,87,98,76,,112,57,,,54,,,,66,62,82,78,80,61,,,49,,57,,73,60,71,60,
     ,279,249,263,249,51,,,49,,51,163,45,75,56,111,82,,92,97,369,339,353,
     339,369,331,57],[72,,,,,,,88,,83,48,,,68,65,77,63,72,65,84,65,80,61,,
     ,61,72,44,,,85,71,70,,272,284,236,256,48,,,57,82,45,,45,77,57,90,83,
     ,78,87,360,376,324,340,360,334,57,57],
   [58,,,,70,,,60,,,44,,,49,49,63,,,49,73,60,58,52,,,49,58,52,,64,53,64,58,
     ,222,218,214,196,40,,,45,,40,136,36,,44,92,69,,61,62,294,290,286,268,
     294,288,50,47,50],
   [58,,,,78,91,81,,,91,52,,,68,63,82,64,73,,,78,81,52,,,61,70,57,,71,,,72,
     ,276,292,260,260,48,,,59,87,54,129,49,81,52,,,,77,101,372,388,356,
     356,372,370,50,57,57,50],
   [72,,,,95,63,84,68,,,53,,,54,63,68,63,62,58,80,74,68,61,,,49,60,51,,71,
     54,73,,,271,245,235,241,47,,,49,83,47,154,41,75,52,112,83,,75,83,353,
     327,317,327,357,299,57,47,51,47,57],
   [72,,,,72,,73,94,,,52,,,68,,85,65,74,62,86,,88,61,,,61,70,52,,64,83,71,
     72,,276,292,264,260,52,,,57,88,49,124,49,93,57,96,82,,,91,372,388,
     360,356,372,370,57,57,50,50,57,57]],
 [,[],[],[],[,27,,40],[,,26],[,40,,41],[,,26,,,22],
   [,,,36,40,,41],[,,,41,,,36,,41],[18,,,,58,,,30],
   [,30,,,,29,43,27,59,53],[,,28,,58,,100,36],
   [18,25,20,38,25,22,34,22,38,38,9,10,11],[],[],
   [28,,30,63,,,54,34,,63,,12,,10],
   [30,49,30,59,43,40,55,34,67,59,,,13,11],
   [28,31,25,53,34,,,,,44,15,16,17,,,,16,17],
   [,,26,,56,,,,,,11,12,13,,,,12,13],[,,28,,,,100,36,,,,,13,11,,,,13,17,13]
    ,[34,31,26,53,35,34,43,38,55,53,11,12,13,,,,12,13,,11,13],
   [36,,,,51,,60,,,70,36,,,32,,,45,52,46,,50,48],
   [,,,,,43,,43,,,,,,27,,,39,39,37,42,63,35],
   [,45,,,52,,59,,56,,,52,,45,,,60,78,49,83,76,56],
   [36,45,42,54,45,45,54,45,54,54,34,33,46,25,,,,,35,44,50,39,34,33,43],
   [],[36,51,52,64,,,,,,,36,43,48,28,,,43,48,51,,48,46,34,,47,34],
   [,,38,,,,,51,,,,37,,29,,,51,53,47,,,39,,31,,33],
   [,52,104,63,45,,,93,63,56,62,53,71,45,,,58,70,52,65,86,60,47,,48,43],
   [,,38,,,51,,,,,,33,,29,,,47,49,,,,33,,31,,33,,,29],
   [,45,,56,52,183,53,,,65,66,52,77,41,,,56,62,48,,73,64,,,43,43,,41,,48],
   [,73,64,83,73,71,80,71,84,83,58,49,88,50,,,,56,53,64,76,51,47,46,56,,
     ,47,46,56,46,57],[,52,,63,45,,52,183,65,,,59,84,45,,,60,74,51,68,,
     60,,,48,43,,,,43,,48,57],
   [90,,,,,,306,172,,,45,,,39,,,66,61,80,55,61,59,168,,,151,,164,269,,292,
     274,242,264],[90,129,122,192,129,120,188,122,192,192,45,,63,39,,,68,,
     82,57,63,55,168,157,231,129,,160,155,231,155,223,,231,41],
   [90,181,,373,,,,176,,291,45,54,59,35,,,54,59,86,59,59,53,164,276,250,149,
     ,140,,,274,232,231,257,41,41],
   [90,129,118,182,129,128,174,122,182,182,45,67,61,39,,,,,79,57,65,,168,
     157,221,129,,164,153,221,153,213,213,221,41,41,41],
   [18,,,,38,22,58,22,60,,16,,,16,,,19,24,21,19,,19,34,,,30,,34,30,51,30,
     53,46,51,78,78,76,78],
   [,,,,,,45,,44,47,,,,42,,,50,71,,,,55,,,,66,,92,,70,,60,111,68,,220,,204],
   [,,,,55,41,80,41,79,,,,,17,,,,20,22,20,20,20,,44,,,,61,50,82,50,83,,,,
     95,81,96],[18,25,20,34,25,20,30,20,34,34,18,19,20,13,,,19,20,18,
     21,20,,32,27,41,25,,28,25,41,25,37,50,41,75,75,65,75,16,38,17],
   [],[18,33,20,58,,,,24,,56,16,17,18,13,,,17,18,20,16,18,16,32,31,48,
     29,,28,,,30,46,47,49,65,65,57,65,14,,15,13],
   [,48,,57,,,,,61,46,,56,,42,,,52,69,54,,,57,72,,74,70,,,,,,73,108,70,,222,
     ,214,,47,,38],[18,25,24,34,25,24,34,24,34,34,16,19,24,16,,,,,21,
     19,24,19,34,33,43,25,,34,33,43,33,43,42,43,78,78,76,78,16,40,,16,,
     14,42],[,,40,,57,41,80,41,,,,,20,17,,,,,22,20,20,20,75,46,97,51,,
     61,52,81,52,77,77,96,96,132,81,,,,17,17,,15],
   [18,,20,58,36,24,,,,52,18,19,20,13,,,19,20,,,20,21,32,31,49,29,,28,30,
     48,,,47,50,75,75,65,75,16,,17,13,,13,,16,17],
   [,,,48,69,,49,,,51,,,,42,,,52,69,,,,59,,,68,70,,70,,98,,,115,95,,224,623,
     220,,42,,38,,,47,42],
   [34,,34,73,53,37,68,,,72,18,19,20,,,,19,20,,,20,18,56,40,99,45,,75,38,
     76,36,,57,75,92,92,93,96,16,,17,,,13,,16,17],
   [,44,,47,,,40,,49,,,63,,42,,,50,71,77,,,55,66,,68,66,,,,64,,68,111,,,216,
     374,212,,39,,38,,,42,40,,,47],
   [,,,,,41,80,41,77,,,,20,17,,,,20,22,20,,20,,48,,,,61,50,104,50,83,,,99,,
     81,,,,17,17,,15,,,17,17,,17],
   [38,47,34,73,53,37,68,39,,70,18,19,20,,,,19,20,,18,20,,58,42,68,,,55,
     40,73,40,87,73,74,94,89,90,94,16,,17,,,13,,16,17,,,15,,17],
   [126,,,,,184,,194,368,416,63,,,53,,,86,83,,75,85,75,232,,,201,,220,396,
     343,298,332,314,348,285,285,273,285,106,,,101,,87,471,106,126,101,598,
     116,,127,119],[126,179,160,260,179,162,248,160,260,260,63,86,,53,,,
     88,87,103,73,85,73,232,211,313,179,,220,203,313,203,297,308,313,285,
     285,273,285,106,284,125,101,,87,294,106,,101,294,116,286,131,115,55],
   [126,,176,366,,,,,,,63,74,81,49,,,74,81,94,71,81,71,228,273,,201,,196,,,
     283,295,305,353,281,277,245,281,104,473,111,91,,79,,104,111,91,547,
     112,535,111,111,55,55],
   [126,179,158,250,179,166,238,160,250,250,63,86,83,53,,,,,99,75,93,73,
     232,215,303,179,,216,209,303,209,291,286,303,285,285,269,285,106,280,
     126,101,,87,284,106,,101,290,121,280,166,,55,55,55],
   [126,,172,,228,180,,,,,63,83,83,53,,,,89,,,89,73,232,341,339,199,,220,,341,
     ,,309,348,285,285,273,285,106,482,127,101,,87,,106,133,101,,,537,147,
     119,55,55,55,55],[126,179,148,252,179,156,220,152,252,252,63,70,81,
     49,,,70,81,98,71,81,71,232,197,305,175,,196,187,305,189,269,,305,277,
     281,245,277,100,260,111,91,,79,274,100,111,91,276,118,262,111,111,55,
     55,49,55,55],[62,,,,78,103,84,91,80,91,64,,,58,,,66,82,65,,86,76,54,
     ,,61,,57,,72,,61,73,,284,294,272,274,55,,,54,,54,107,55,103,52,100,
     79,92,87,82,384,394,372,374,384,378],
   [72,85,70,94,85,79,86,79,94,94,66,53,82,39,,,,71,59,76,84,57,61,54,
     70,43,,57,55,70,55,66,57,70,273,207,251,207,50,106,,39,,51,114,43,
     78,51,114,70,106,93,80,351,285,335,285,345,277,57],
   [72,78,88,92,,,,105,,80,64,66,84,54,,,66,80,70,76,76,74,61,85,72,61,,
     46,,,79,62,73,65,280,286,244,270,59,90,84,50,,48,,55,88,50,107,76,
     83,89,78,372,382,336,358,372,342,57,57],
   [62,69,60,79,69,67,75,67,78,78,53,46,67,38,,,,,50,65,71,51,54,51,63,
     43,,54,54,63,54,63,,63,226,192,214,182,43,93,62,38,,43,102,37,,43,
     108,60,93,67,56,294,260,286,250,290,256,52,41,52],
   [62,,82,81,78,95,,,,89,64,66,,58,,,68,84,,,90,76,54,,65,61,,57,135,72,,,
     73,72,284,294,268,274,55,87,88,54,,54,160,55,91,52,,,94,103,96,384,
     394,368,374,384,378,52,57,57,52],
   [72,85,62,94,85,71,78,71,94,94,66,49,80,35,,,60,59,55,74,80,59,61,48,
     70,43,,51,47,70,47,60,,70,265,203,223,199,46,108,78,35,,47,114,43,
     79,47,114,72,108,78,96,335,273,299,273,333,245,57,41,51,41,57],
   [72,80,,96,,97,73,105,89,,64,72,86,58,,,68,86,66,78,,74,61,85,73,61,,
     54,,65,141,68,74,,284,294,272,274,59,96,86,54,,52,102,55,105,54,109,
     76,,,79,384,394,372,374,384,378,57,57,52,52,57,57],
   [18,,,,33,30,58,30,,,9,,,9,,,15,11,15,11,11,11,36,,,30,,36,,53,,53,49,,
     45,45,45,45,16,,,16,,14,79,16,16,16,79,16,,16,16,63,63,63,63,63,63,
     60,54,60,45,60,54,60]],
 [,[],[],[],[],[],[],[,,18],[,,,44],[,44,,49,,,,,55],
   [18,,,,,,,20],[,28,,,,,,19,51],[,,22,,,,,26],[18,,20,,,,,,,,9,10,11],
   [,43,24,,,,,24,62,,10,11,12],[,43,26,,,,,,64,72,11,12,13],
   [24,,24,62,,,,24,,62,,10,,10,11,12],[,,,,,,,26,,78,,,11,11,12,13],
   [24,36,19,51,,,,,,47,10,11,12,,10,,11,12],
   [,47,26,,,,,22,,,11,12,13,,,11,12,13],
   [,,26,,,,,26,,,,,11,11,12,13,,11,12,13],
   [,,26,82,,,,26,,,11,12,13,,,11,12,13,,11,13],
   [28,,,,,,,,,50,32,,,32,,,39,54,39,,46],
   [,,,,,,,30,,,,,,31,34,39,35,41,31,41,60,39],
   [,37,,,,,,,50,66,,43,,,55,59,,,49,69,92],
   [36,49,34,70,,,,34,62,62,31,31,49,29,,,,43,31,49,49,43,32,27,37],
   [,68,46,69,,,,46,81,,53,43,62,,,,,52,43,75,61,68,35,34,46],
   [36,40,36,50,,,,36,50,,28,35,40,28,35,40,35,40,35,40,40,40,26,,35,26,
     35],[],[],[,,30,,,,,,,,33,31,41,,34,41,35,39,,,41,,,25,,27,34],
   [,49,,50,,,,,,60,57,49,69,,,,54,,43,,65,89,,,41,43,40,35],
   [58,68,38,84,,,,38,80,77,54,39,63,66,48,78,50,52,39,63,66,52,35,28,41,
     ,30,30,,,28,41],[58,50,55,66,,,,60,60,,,49,78,62,55,,,,48,65,,71,41,
     ,44,,46,,,,,50,40],
   [78,,,,,,,110,336,337,39,,,39,,,58,61,58,55,55,,140,,,131,190,124,,,232,
     228,175,215],[86,159,92,265,,,,98,251,280,39,,61,39,,,59,,61,63,63,
     55,140,147,226,121,,128,,,157,218,,234,37],
   [86,164,,346,,,,94,346,274,35,44,49,35,44,49,44,49,44,49,49,49,132,195,
     194,119,171,100,,,195,194,,194,31,31],
   [82,171,86,214,,,,92,226,236,39,58,55,39,,57,,,58,59,59,,140,131,198,
     129,172,124,,,175,198,158,193,31,37,31],
   [14,,,,,,,16,48,,13,,,16,17,18,16,,17,18,,18,26,,,26,36,26,,,26,46,32,
     41,65,65,59,65],[,,,,,,,,40,51,,,,,47,,47,,,,,,,,,54,68,50,,,,50,,60,,
     288],[,,,,,,,34,91,,,,,17,18,19,,17,18,19,17,19,,38,,,53,51,,,42,73,
     61,,,93,64,87],[14,31,18,,,,,18,44,,16,17,18,13,,,17,18,16,,18,,26,
     27,41,25,,26,,,27,40,56,41,65,65,59,65,14,38,15],
   [,50,34,,,,,34,,69,17,18,19,,,,18,19,,17,19,17,82,45,69,,,51,,,45,94,
     77,65,94,,64,87,15,,16],
   [14,25,14,42,,,,14,42,42,13,14,15,13,14,15,14,15,14,15,15,15,24,22,
     38,22,36,20,,,22,38,38,39,50,50,40,50,11,,12,11,12],[],
   [18,31,18,44,,,,18,,44,13,16,21,16,17,18,,,17,18,,18,30,27,37,25,34,26,
     ,,27,41,34,37,65,65,59,65,13,38,,14,15,11],
   [,,34,,,,,34,78,,,,17,17,18,19,,,18,19,17,19,83,45,94,47,67,51,,,45,65,
     77,86,93,88,64,,,,14,15,16,12],
   [18,31,16,48,,,,,,48,16,17,18,13,16,21,17,18,,,18,,30,26,46,26,36,26,,,,
     ,32,44,65,65,59,65,14,,15,13,,11,,14,15],[],
   [36,50,34,,,,,,,,17,18,19,,,17,18,19,,,19,17,59,42,72,49,,51,,,38,,61,
     73,88,98,64,94,15,,16,,14,12,,15,16],
   [,40,,51,,,,,51,,,,,,47,,47,,,,,,50,,60,54,70,,,,,60,,,,356,270,256,,45,,38,
     ,,,38],[,,34,,,,,34,69,,,,17,17,18,19,,17,18,19,,19,,44,,,52,51,,,
     42,72,53,,88,,64,94,,,14,15,16,12,,,14,15,,16],
   [,46,34,70,,,,34,,,17,18,19,,,17,18,19,,17,19,,,45,66,,,51,,,43,88,77,
     70,93,85,64,94,15,,16,,14,12,,15,16,,,14,,16],
   [106,,,,,,,128,348,435,53,,,53,73,77,73,77,,75,75,77,188,,,173,247,164,,,
     209,284,228,274,227,227,203,223,87,,,87,,66,,87,116,87,,109,561,112],
   [114,197,126,307,,,,118,305,313,53,73,,53,,,79,73,73,77,77,73,188,188,
     278,163,,164,,,188,280,238,280,227,227,203,227,87,331,116,87,,66,,87,,
     87,,116,405,118,110,47],
   [114,,122,338,,,,,384,384,49,60,67,49,60,67,60,67,60,67,67,67,180,201,,
     161,228,140,,,200,257,197,264,211,215,175,211,81,318,88,81,88,56,,81,
     88,81,,88,397,88,88,41,41],
   [114,209,114,280,,,,122,310,302,53,75,73,53,75,,,,79,79,81,79,192,175,
     260,171,226,172,,,197,259,196,264,223,227,207,227,87,,109,87,110,66,,
     87,,87,,121,,121,,41,47,41],
   [106,228,120,,,,,,,,53,74,73,53,73,73,,,,,77,77,184,248,281,169,248,164,,,,
     ,224,291,231,227,203,231,87,462,112,87,110,66,,87,116,87,,,606,118,
     120,47,41,41,47],
   [98,174,106,264,,,,106,264,264,49,56,67,49,56,67,56,67,56,67,67,67,176,
     157,255,165,,140,,,159,254,,255,215,211,175,215,77,323,88,77,88,56,,
     77,88,77,,88,336,88,88,41,41,35,41,41],
   [46,,,,,,,59,73,71,56,,,58,55,78,56,78,56,,76,78,40,,,53,54,43,,,,51,52,
     61,224,234,200,208,41,,,46,82,40,,45,101,45,,80,69,81,85,296,308,272,
     284,296,280],[64,83,58,88,,,,58,100,94,57,55,77,51,,,,69,55,77,77,
     69,53,46,55,39,,43,,,46,64,44,,229,211,201,211,46,80,,43,,38,,43,77,
     46,,79,83,94,90,299,281,271,281,295,263,49],
   [64,62,62,71,,,,62,73,65,52,52,70,54,54,68,52,68,54,70,62,68,47,59,
     55,47,54,32,,,59,56,47,50,208,222,172,196,46,69,73,46,75,34,,41,77,
     46,,73,63,74,77,272,284,236,264,272,244,43,43],
   [54,64,46,75,,,,46,75,79,48,43,62,50,49,64,,,43,66,66,60,48,41,58,47,
     54,40,,,41,58,46,58,182,188,166,164,36,67,63,42,,34,,34,,36,,65,67,
     65,60,242,242,222,220,242,222,38,43,38],
   [54,66,59,71,,,,,,77,56,56,,58,56,74,56,80,,,82,82,48,,50,47,62,43,,,,,
     50,55,228,238,208,216,45,63,82,50,80,40,,41,,41,,,69,81,104,296,304,
     276,284,296,280,44,43,43,44],
   [56,71,50,89,,,,50,89,80,53,51,67,47,52,61,52,61,51,67,67,61,47,40,
     58,47,48,37,,,40,57,,55,217,195,173,199,42,93,76,39,76,34,,39,76,42,
     ,76,84,76,76,279,257,235,257,275,223,43,37,37,37,43],
   [56,68,64,71,,,,68,79,,56,,82,58,,,56,74,56,80,,74,47,63,61,53,56,40,,,
     67,56,50,,220,230,200,212,46,69,83,46,82,38,,45,97,50,,99,,,81,296,
     312,272,288,300,280,43,49,38,38,49,43],
   [18,,,,,,,20,,54,7,,,9,10,11,,9,10,11,9,11,32,,,28,43,28,,,30,47,46,,
     39,39,35,39,13,,,14,15,11,,13,13,14,,15,,13,15,53,53,49,53,53,49,
     52,48,48,41,52,44,52],
   [18,31,20,54,,,,24,48,48,9,10,11,7,,,10,11,,9,11,9,32,30,47,28,,28,,,
     29,50,43,47,39,39,35,39,14,,15,13,,11,,14,15,13,,13,,15,13,53,53,
     49,53,53,49,52,48,48,41,52,44,52,9]],
 [,[],[],[],[,27,,34],[,,28],[,28,,41],[,,26,,,24],
   [,,,34,34,,41],[,34,,41,,,34,,41],[18,,,,,,,20],
   [,26,,,36,34,42,25,51,49],[,,,,57,,,26],
   [18,27,28,43,27,32,43,32,43,43,9,15,11],
   [,37,34,,49,,50,30,,,10,16,12],[30,37,34,52,,42,44,30,,52,11,17,13],
   [],[],[,30,27,54,,27,42,,,39,10,16,12,,12],
   [,53,36,,,,,28,,,11,17,13,,,13],[,,,,57,,,26,,,,,11,11,12,13,,,12,13],
   [,33,34,67,37,42,51,28,59,57,11,17,13,,,13,,,,13,13],
   [36,,,,45,56,50,,,54,32,,,36,,52,,,,,46],[,,,,,,,38,,,,,,37,,49,,,33,,,49]
    ,[,35,,,52,62,51,,61,61,,45,,52,56,59,,,49,79,60,62],
   [36,43,45,52,43,45,52,42,52,52,31,35,44,27,,,,,33,46,48,41,34,33,41],
   [54,69,62,72,,60,68,56,72,72,53,47,68,,37,,,,43,66,54,60,41,40,48],
   [36,35,56,54,,,,52,54,,28,,48,36,43,48,,,43,48,,48,34,,35,34,41],
   [,,,,,,,40,,,,79,,41,,51,,,39,,,51,,35,,33,40],
   [54,48,78,61,43,,,72,61,,,52,60,52,62,,,,,70,74,66,41,,48,41,48],
   [,,43,,,39,,,,,33,37,42,41,36,39,,,,,42,41,,31,,33,40,,33],
   [,43,,67,52,74,57,,,61,57,49,70,52,,65,,,49,,60,74,,,41,41,48,41,,48],
   [54,,62,72,73,60,68,56,72,72,54,47,58,67,,69,,,43,70,58,54,41,40,48,,
     34,41,40,48,40,48],
   [54,42,74,61,43,,48,72,61,,,68,62,52,56,55,,,49,66,,66,41,,42,41,48,,,
     41,,48,48],[90,,,,,,266,,378,,39,,,45,63,,,,63,67,55,67,168,,,149,216,
     164,311,,292,261,216,244],
   [90,121,128,190,129,120,186,120,190,190,39,,57,45,,,,,71,63,57,61,168,
     153,221,129,,160,165,229,161,229,,221,41],
   [90,165,,352,,,,136,352,,35,73,55,45,54,59,,,54,59,55,59,164,,208,151,
     204,140,,,281,240,204,208,41,41],
   [90,121,120,168,129,114,160,122,168,168,39,81,55,45,,63,,,66,63,55,,168,
     153,199,129,168,164,161,207,159,207,168,199,41,41,41],
   [18,,,,,18,,20,48,,13,,,18,19,20,,,19,20,,20,32,,,29,40,28,47,43,31,50,
     40,39,75,75,65,75],
   [,,,,44,,49,,44,53,,,,57,49,62,,,,,,69,,,,68,94,66,,73,,93,86,69,,222,,
     198],[,,,,55,32,,34,70,,,,,18,19,20,,,19,20,18,20,,35,,,82,76,41,75,
     39,75,56,,,91,86,89],
   [18,25,24,32,25,24,32,24,32,32,16,21,19,16,,,,,19,24,19,,34,33,41,25,,
     34,33,41,33,41,65,41,78,78,76,78,16,40,16],
   [36,63,41,77,,42,71,40,,75,17,22,20,,,,,,,20,20,20,62,53,77,,,62,52,98,
     48,94,75,72,98,,81,95,17,,17],
   [18,,24,54,,,,20,,,13,,16,16,17,18,,,17,18,16,18,32,30,39,29,40,28,,,
     31,43,40,51,65,65,57,65,13,,13,14,15],
   [,46,,53,,,,,51,44,,46,,57,49,62,,,57,,,69,70,,71,74,94,,,,,75,94,89,
     538,226,,200,,47,,40],
   [18,21,20,32,25,18,28,20,32,32,13,18,21,18,19,20,,,19,20,21,20,32,25,
     35,25,32,28,27,39,27,39,32,35,75,75,65,75,13,36,,16,17,13,36],
   [],[18,35,22,60,39,20,54,,,,16,21,19,16,19,24,,,,,19,24,34,30,53,30,
     40,34,32,47,,,40,47,78,78,76,78,16,,16,16,,14,,16],
   [,,,,44,,45,,,49,,,,57,47,64,,,,,,71,,,83,70,84,60,,69,,,90,65,521,220,
     468,192,,40,,38,,,47,36],
   [,63,41,75,,42,71,,,,17,22,20,,,20,,,,,20,20,,49,83,50,,62,47,83,43,,,
     81,117,98,81,101,17,,17,,17,15,,17],
   [,40,,51,,,50,,51,,,59,,57,49,62,,,51,,,69,66,,73,68,94,,,69,,75,86,,,
     222,454,200,,41,,40,,,40,36,,,47],
   [,,39,,55,32,69,34,68,,,,18,18,19,20,,,19,20,,20,,39,,,47,,41,75,39,75,
     49,,93,,86,89,,,15,16,17,13,,,,16,,17],
   [,,41,,57,42,71,38,,75,17,22,20,,,20,,,,20,20,,,53,73,,,62,52,76,49,90,
     79,76,103,97,81,132,17,,17,,17,15,,17,,,,17,,17],
   [126,,,,239,196,,,348,400,53,,,63,87,83,,,,,75,85,232,,,201,276,220,417,
     321,279,323,276,305,285,285,273,285,101,,,106,,87,500,101,,106,462,139,
     612,118,130],[126,167,162,254,179,150,242,156,254,254,53,101,,63,,,,,
     86,83,75,83,232,209,295,179,,220,219,307,213,307,,291,285,285,273,285,
     101,288,115,106,,87,294,101,,106,278,126,290,122,127,55],
   [126,,194,334,,,,,409,,49,95,71,63,74,81,,,74,81,77,81,228,285,,199,270,
     196,,,276,318,272,290,281,277,245,281,91,430,113,104,111,79,,91,,104,
     369,111,756,119,111,55,55],
   [126,167,160,232,179,152,220,160,232,232,53,105,73,63,86,,,,87,85,75,87,
     232,207,273,179,232,216,213,285,215,285,232,269,285,285,269,285,101,
     268,115,106,125,87,266,101,,106,256,131,268,117,,55,55,55],
   [126,249,,,237,170,340,,,384,53,105,73,63,86,83,,,,,73,87,232,344,312,
     201,276,220,,323,,,276,308,285,285,273,285,101,648,117,106,125,87,868,
     101,,106,,,728,118,143,55,55,55,55],
   [126,147,152,246,179,146,214,148,246,246,49,108,71,63,70,81,,,70,81,73,
     81,232,187,263,175,,196,201,299,199,299,,263,277,281,245,277,91,268,
     111,100,111,79,268,91,,100,256,111,270,118,111,55,55,49,55,55],
   [54,,,,74,89,73,,82,81,56,,,68,59,79,,,59,,78,81,50,,,59,68,55,92,68,,
     65,68,64,270,290,256,246,46,,,57,83,54,97,46,,50,,90,95,77,88,360,
     382,350,338,360,366],
   [72,71,79,92,79,75,84,70,92,92,57,59,76,45,,,,,53,82,78,63,59,55,64,
     43,,55,57,68,54,68,58,64,267,207,257,207,51,112,,43,,51,118,39,,50,
     108,78,112,89,91,351,285,329,285,351,277,55],
   [72,62,93,81,,,,86,81,,52,64,76,68,62,77,,,62,84,,77,59,99,58,59,68,42,
     ,,85,68,68,,266,282,228,242,50,93,73,57,83,42,,42,,57,85,83,128,78,
     86,348,370,314,322,348,330,55,55],
   [54,63,62,72,65,60,68,56,72,72,48,47,60,43,44,57,,,43,68,60,,50,52,
     59,43,52,50,52,59,49,59,52,59,212,190,204,168,40,90,57,41,,40,90,32,
     ,40,84,65,90,57,62,276,254,268,232,276,250,48,41,48],
   [54,75,,86,74,85,73,,,81,56,64,,68,59,79,,,,,78,89,50,,66,59,68,55,127,
     68,,,68,64,270,290,252,246,46,,77,57,86,54,97,46,,50,,,97,76,103,360,
     382,346,338,360,366,48,55,55,48],
   [72,63,71,92,79,63,76,62,92,92,53,55,74,45,60,59,,,49,80,74,59,59,47,
     58,43,58,49,51,68,48,68,,58,259,203,229,199,47,112,72,43,78,47,112,
     35,,46,104,78,112,93,78,335,273,293,273,339,245,55,41,49,41,55],
   [72,68,95,81,69,86,,86,81,,56,72,78,68,,91,,,59,86,,79,59,,64,59,68,50,
     ,65,109,68,68,,270,290,256,246,54,97,77,57,105,46,94,46,,57,89,83,,,
     86,360,382,350,338,360,366,55,55,48,48,55,55],
   [18,,,,31,18,,20,,44,7,,,9,10,11,,,10,11,9,11,32,,,28,38,28,,43,30,46,
     38,,39,39,35,39,13,,,15,16,12,66,13,,15,40,16,,14,16,53,53,49,53,
     53,49,49,48,45,38,49,44,49],
   [18,27,28,39,27,28,39,28,39,39,9,15,11,9,,,,,15,11,11,11,36,37,48,27,
     ,36,37,48,37,48,42,48,45,45,45,45,16,49,16,16,,14,49,16,,16,49,16,
     49,16,16,63,63,63,63,63,63,60,45,60,39,60,45,60,9],
   [18,31,24,,,,,20,,44,7,14,9,9,10,11,,,10,11,9,11,32,29,39,28,38,28,,,
     30,43,38,40,39,39,35,39,13,70,13,14,15,11,,13,,14,,15,70,13,15,53,
     53,49,53,53,49,49,48,45,38,49,44,49,7,9]],
 [,[],[],[],[,33,,46],[],[,52,,68],[],[],[],[18],
   [,34,,,38,,59],[,,28,,,,116],[18,,20,,,,,,,,9,10,11],
   [,,29,,49,,91,,,,15,16,17],[30,,26,74,43,,56,,,,11,12,13],
   [,,30,86,,,78,,,,,12,,10,16,12],[,62,30,75,,,85,,,,,,13,11,17,13],
   [],[],[,,28,,59,,118,,,,,,13,11,17,13,,13],
   [38,38,26,71,42,,,,,,11,12,13,,,11,12,13,,,13],
   [36,,,,50,,62,,,,36,,,32,,48,,,,,50,48],
   [,,,,,,,,,,,,,31,37,38,42,43,,,64,38],
   [,47,,,62,,76,,,,,52,,,75,67,64,86,,,74,63],
   [36,,44,74,51,,74,,,,34,36,46,29,,,,44,,,58,42,34,35,47],
   [64,,52,91,,,79,,,,50,45,68,,,,,54,,,58,58,46,38,52],
   [36,50,52,62,,,,,,,36,43,48,28,56,,43,48,,,48,50,34,,45,34,39],
   [,,42,,,,,,,,,41,,,,43,55,91,,,,43,,35,,54,40],
   [64,62,77,74,47,,,,,,59,54,73,,64,58,61,92,,,84,64,45,,56,47,52],[],
   [],[64,72,60,89,72,,,,,,50,49,67,66,49,70,60,58,,,68,50,45,44,52,,38,
     45,,52],[64,62,78,74,51,,62,,,,,60,75,62,66,56,64,78,,,,86,45,,56,
     47,52,,,45,,,52],[90,,,,,,380,,,,45,,,39,79,,73,67,,,61,61,168,,,153,
     226,164,,,,,,267],[90,,,283,,,320,,,,45,,63,39,,,69,,,,,55,168,171,266,
     143,,160,245,268,,,,,41],
   [90,221,,,,,,,,,45,54,59,35,,57,54,59,,,59,,164,281,255,153,197,140,,,,,
     220,259,41,41],[90,,130,262,171,,304,,,,45,68,73,39,,57,,,,,61,,168,
     195,,141,,164,,241,,,,237,41,41,41],
   [18,,,,,,68,,,,16,,,16,21,19,19,24,,,,19,34,,,32,40,34,33,49,,,44,48,78,
     78,76,78],[,,,,54,,77,,,,,,,,,56,55,127,,,,63,,,,106,92,66,,81,,,151,
     77,,427,,297],[,,,,,,102,,,,,,,17,22,20,,20,,,20,20,,45,,,56,62,72,86,,
     ,63,,,95,81,123],[18,,20,56,,,52,,,,18,19,20,13,,,19,20,,,20,,32,29,
     45,27,,28,28,45,,,58,45,75,75,65,75,16,76,17],
   [34,,33,78,55,,76,,,,18,19,20,,,,19,20,,,20,18,56,44,,,,77,43,72,,,73,
     65,91,,91,89,16,,17],
   [18,33,20,58,,,,,,,16,17,18,13,,16,17,18,,,18,16,32,31,47,29,36,28,,,,,
     40,50,65,65,57,65,14,,15,13,13],
   [,78,,100,,,,,,,,87,,,99,98,85,105,,,,93,94,,115,104,128,,,,,,,94,748,457,,,
     ,94,,76],[18,33,24,44,31,,52,,,,16,19,24,16,21,19,,,,,24,19,34,35,
     47,27,38,34,51,45,,,38,45,78,78,76,78,16,46,,16,16,14,70],
   [,,39,,,,92,,,,,,20,17,22,20,,,,,20,20,,48,92,49,71,62,78,109,,,79,91,
     113,97,81,,,,17,17,17,15],
   [18,35,20,48,35,,56,,,,18,19,20,13,18,21,19,20,,,20,21,32,31,46,29,36,
     28,30,44,,,40,45,75,75,65,75,16,,17,13,,13,,16,17],[],[],
   [,50,,62,,,62,,,,,86,,,57,56,55,127,,,,63,66,,77,74,141,,,70,,,95,,,,351,,
     ,51,,76,,,76,46],[,,35,,56,,102,,,,,,20,17,22,20,,20,,,,20,,49,,,56,
     62,72,82,,,58,,102,,81,95,,,17,17,17,15,,,17,17],
   [38,46,33,72,55,,80,,,,18,19,20,,,18,19,20,,,20,,58,44,64,,,77,43,71,,,
     73,129,97,89,,91,16,,17,,15,13,,16,17,,,,,17],
   [126,,,,257,,,,,,63,,,53,103,73,86,87,,,85,75,232,,,207,292,220,407,342,,,
     300,345,285,285,273,285,106,,,101,,87,613,106,141,101,,,755,128,119],
   [126,,178,390,230,,384,,,,63,83,,53,,,83,83,,,83,73,232,229,341,197,,220,
     273,350,,,314,344,285,285,273,285,106,410,126,101,,87,558,106,,101,,,
     424,137,115,55],[126,,176,396,,,,,,,63,74,81,49,95,73,74,81,,,81,73,
     228,279,,207,254,196,,,,,290,351,281,277,245,281,104,401,111,91,111,79,
     ,104,111,91,,,488,111,111,55,55],
   [126,226,160,320,231,,356,,,,63,86,87,53,103,,,,,,85,73,232,264,321,195,
     258,216,267,320,,,270,319,285,285,269,285,106,381,145,101,115,87,587,
     106,,101,,,359,127,,55,55,55],
   [126,256,166,,257,,417,,,,63,,91,53,103,73,,87,,,83,73,232,349,342,207,
     283,220,,341,,,300,341,285,285,273,285,106,549,162,101,116,87,703,106,
     130,101,,,569,127,118,55,55,55,55],
   [126,225,148,341,223,,,,,,63,70,81,49,,71,70,81,,,81,71,232,215,333,193,,
     196,251,334,,,,333,277,281,245,277,100,368,111,91,111,79,562,100,111,
     91,,,385,111,113,55,55,49,55,55],
   [58,,,,79,,89,,,,61,,,58,65,74,62,,,,86,73,52,,,61,66,57,116,72,,,72,71,
     278,288,266,264,52,,,54,77,54,134,52,109,48,,,92,87,81,372,386,360,
     358,372,372],[72,,76,100,93,,104,,,,66,62,82,51,,,,72,,,94,66,61,60,
     71,49,,57,77,72,,,60,73,279,249,263,243,56,111,,45,,51,156,49,82,51,,
     ,114,101,88,369,339,353,333,369,331,57],
   [72,78,88,89,,,,,,,61,62,84,54,72,69,63,80,,,73,78,61,83,71,61,60,44,,,,
     ,72,64,274,280,238,260,57,92,82,50,89,45,,53,87,48,,,85,88,97,360,
     374,324,342,360,336,57,57],
   [58,71,60,85,71,,85,,,,50,49,71,50,56,59,,,,,64,54,52,53,65,49,58,52,,
     65,,,58,,224,222,216,198,44,92,67,44,,40,,38,,40,,,91,65,57,294,292,
     286,268,294,286,50,47,50],
   [58,72,77,81,79,,89,,,,61,62,,58,64,74,62,81,,,86,73,52,,64,61,68,57,,
     72,,,70,71,278,288,262,264,52,84,88,54,78,54,130,52,88,48,,,92,84,
     92,372,386,356,358,372,372,50,57,57,50],
   [72,93,68,106,97,,108,,,,66,58,80,47,67,62,63,68,,,80,62,61,54,73,49,
     50,51,54,77,,,,71,271,245,235,235,52,112,83,41,75,47,176,49,83,47,,,
     109,83,75,353,327,317,321,357,299,57,47,51,47,57],
   [72,78,90,89,74,,79,,,,61,69,86,58,,75,63,82,,,,74,61,85,71,61,68,52,,
     65,,,70,,278,288,266,264,57,92,85,54,76,49,127,53,101,52,,,,,78,372,
     386,360,358,372,372,57,57,50,50,57,57],
   [18,,,,37,,54,,,,9,,,9,15,11,15,11,,,11,11,36,,,30,42,36,,52,,,42,,45,
     45,45,45,16,,,16,16,14,78,16,16,16,,,,16,16,63,63,63,63,63,63,57,
     54,57,42,57,54,57],
   [18,,20,54,31,,,,,,9,10,11,7,,,10,11,,,11,9,32,30,,28,,28,29,47,,,43,
     49,39,39,35,39,15,43,16,13,,12,69,15,16,13,,,43,16,14,53,53,49,53,
     53,49,52,48,48,41,52,44,52,9],
   [18,31,20,54,,,,,,,9,10,11,7,14,9,10,11,,,11,9,32,30,47,28,,28,,,,,46,
     47,39,39,35,39,14,74,15,13,13,11,,14,15,13,,,74,15,13,53,53,49,53,
     53,49,52,48,48,41,52,44,52,9,7],
   [18,37,30,48,,,56,,,,9,15,11,9,15,11,,,,,11,11,36,,52,30,42,36,54,,,,
     42,49,45,45,45,45,16,76,16,16,16,14,76,16,,16,,,76,16,16,63,63,63,
     63,63,63,57,54,57,42,57,54,57,9,9,9]],
 [,[],[],[],[,21,,35],[,,16],[,32,,31],[,,18,,,16],
   [,,,34,35,,31],[,38,,31,,,28,,37],[18,,,,49,,,20],
   [,24,,,27,19,37,19,48,41],[,,22,,59,,107,26],
   [18,25,20,38,25,28,34,28,38,38,9,10,11],
   [,35,24,,31,,48,24,52,,10,11,12],
   [30,35,26,54,35,42,40,24,60,56,11,12,13],
   [24,,24,52,31,,48,24,,52,,10,,10,11,12],
   [30,,24,54,35,42,46,26,52,62,,,11,11,12,13],
   [24,28,19,48,27,19,38,,,41,10,11,12,,10,,11,12],
   [,47,26,,59,,,22,,,11,12,13,,,11,12,13],
   [,,26,,59,,107,26,,,,,11,11,12,13,,11,12,13],
   [38,31,26,58,35,42,42,26,54,52,11,12,13,,,11,12,13,,11,13],
   [28,,,,37,,48,,,,32,,,32,,48,39,48,39,,,52],
   [,,,,,26,,28,,,,,,27,28,35,31,35,27,41,71,35],
   [,35,,,36,,45,,44,55,,43,,45,56,57,54,,47,73,,55],
   [36,43,32,50,35,30,42,32,50,50,31,27,43,25,,,,,27,43,49,,32,25,33],
   [,67,50,67,56,200,63,50,74,68,62,41,68,,33,,71,52,41,97,70,,37,36,50]
    ,[36,43,36,56,,,,36,56,,28,35,40,28,35,40,35,40,35,40,40,40,26,,38,
     26,38],[,,26,,,,,26,,,,27,,35,,51,51,51,27,,,51,,21,,29,40],
   [,40,59,49,27,,,59,51,44,64,45,76,45,52,57,47,59,46,76,83,59,37,,36,
     33,45],[,,28,,,26,,,,,33,27,41,35,28,35,31,35,,,41,33,,23,,25,36,,
     21],[,43,,44,36,,45,,,,66,47,73,41,,61,51,55,43,,71,67,,,39,39,44,
     38,,36],[],[,40,,55,35,,40,64,50,,,53,,45,56,53,54,,49,71,,59,43,
     ,36,33,50,,,33,,42],
   [78,,,,,,224,,,327,39,,,39,59,,62,55,,,59,61,140,,,127,202,124,177,,,,,216]
    ,[86,115,88,162,101,88,144,88,158,160,39,,57,39,,,,,65,57,59,61,140,
     115,191,107,,128,115,177,117,185,,191,37],
   [86,150,,342,,,,94,342,290,35,44,49,35,44,49,44,49,44,49,49,49,132,195,
     200,117,186,100,,,195,207,,207,31,31],
   [82,111,90,156,95,90,134,94,158,156,39,,61,39,,61,,,60,,55,,140,119,187,
     115,188,124,117,167,121,187,,181,31,37,31],
   [14,,,,29,14,53,16,52,,13,,,16,17,18,16,21,17,18,,18,26,,,24,38,26,22,
     45,24,49,,,65,65,59,65],
   [,,,,,,,,36,39,,,,48,45,58,45,62,,,,60,,,,58,96,,,57,,54,,58,,178,,170],
   [,,,,60,38,84,32,86,,,,,17,18,19,,17,18,19,17,19,,38,,,59,51,50,79,44,
     75,,,,89,64,98],[14,23,18,26,19,20,26,18,30,26,16,17,18,13,,,17,
     18,16,21,18,,26,25,37,23,,26,27,33,25,33,,37,65,65,59,65,14,34,15],
   [32,55,32,86,60,38,,,,86,17,18,19,,,,18,19,,17,19,17,53,45,74,,,51,51,
     77,47,96,,,91,,64,96,15,,16],
   [14,25,14,45,,,,14,45,45,13,14,15,13,14,15,14,15,14,15,15,15,24,22,
     41,22,39,20,,,22,41,,41,50,50,40,50,11,,12,11,12],
   [,38,,39,,,,,39,36,,51,,42,45,,45,60,,,,,58,,58,58,96,,,,,58,,54,478,176,
     ,170,,33,,34],[18,19,18,30,19,20,26,18,26,30,13,16,27,16,17,18,,,
     17,18,21,18,30,25,33,23,,26,27,33,25,37,,33,65,65,59,65,13,34,,14,
     15,11,34],[,,,,60,38,84,32,80,,,,17,17,18,19,,,18,19,17,19,73,47,,,
     64,51,51,77,45,,,96,88,96,64,,,,14,15,16,12],
   [18,31,16,52,29,14,53,,,52,16,17,18,13,16,27,17,18,,,18,21,30,24,49,
     24,38,26,22,45,,,,48,65,65,59,65,14,,15,13,,11,,14,15],
   [,,,30,,,,,,33,,,,48,39,64,39,66,,,,66,,,44,46,66,,,49,,,,48,,156,403,158,
     ,36,,28,,,39,28],[36,55,32,80,60,38,,,,86,17,18,19,,,17,18,19,,,19,
     17,55,44,75,49,,51,50,79,38,,,75,,90,64,,15,,16,,14,12,,15,16],
   [,38,,39,,,34,,39,,,,,48,45,58,45,62,51,,,60,58,,58,58,96,,,52,,58,,,,
     178,,170,,33,,34,,,30,34,,,39],
   [,,32,,60,38,84,32,86,,,,17,17,18,19,,17,18,19,,19,,46,,,58,51,50,79,
     44,75,,,98,,64,89,,,14,15,16,12,,,14,15,,16],
   [36,,32,86,60,38,,32,,80,17,18,19,,,17,18,19,,17,19,,55,45,,,,51,51,77,,
     ,,74,96,95,64,91,15,,16,,14,12,,15,16,,,14,,16],
   [106,,,,166,,,132,304,408,53,,,53,74,73,74,73,,79,81,81,188,,,165,257,164,
     ,251,229,279,,288,227,227,203,223,87,,,87,,66,382,87,111,87,304,120,
     556,123,123],[114,151,118,210,121,110,188,114,214,216,53,75,,53,,,73,
     77,74,73,77,77,188,153,251,145,,164,151,223,153,251,,251,227,227,203,
     227,87,232,112,87,,66,232,87,,87,212,112,232,121,119,47],
   [114,,122,314,,,,,368,368,49,60,67,49,60,67,60,67,60,67,67,67,180,195,,
     155,242,140,,,196,264,,270,211,215,175,211,81,723,88,81,88,56,,81,88,
     81,319,88,745,88,88,41,41],
   [114,153,116,208,133,108,182,116,210,204,53,73,,53,73,,,,74,,75,73,192,
     157,247,153,236,172,149,227,157,247,,243,223,227,207,227,87,226,117,
     87,118,66,226,87,,87,206,120,228,114,,41,47,41],
   [106,206,128,,175,128,282,,,411,53,73,79,53,74,,,79,,,73,73,184,253,280,
     163,262,164,,257,,,,293,231,227,203,231,87,520,121,87,120,66,524,87,
     118,87,,,524,115,115,47,41,41,47],
   [98,137,106,192,105,108,160,106,192,192,49,56,67,49,56,67,56,67,56,67,
     67,67,176,141,231,149,,140,137,195,143,231,,231,215,211,175,215,77,
     214,88,77,88,56,214,77,88,77,194,88,216,88,88,41,41,35,41,41],
   [50,,,,57,,66,62,70,71,56,,,58,63,74,61,74,61,,80,78,42,,,53,57,43,,52,
     ,51,,62,232,238,206,222,44,,,46,78,40,92,48,99,48,62,82,92,84,82,
     308,314,282,302,308,286],
   [64,75,52,82,59,58,66,52,82,82,57,43,73,39,,,,,43,73,79,63,53,40,54,
     33,,43,42,50,40,60,,54,217,169,195,169,40,94,,37,,38,94,37,104,40,
     74,77,94,105,105,275,227,253,227,277,215,49],
   [64,64,62,75,,,,62,71,64,52,57,70,54,58,68,57,68,58,70,66,68,47,61,
     57,47,58,34,,,61,56,,51,216,226,178,210,46,,75,46,74,36,,44,78,46,,
     75,84,78,78,284,290,246,282,284,250,43,43],
   [58,63,46,70,52,56,59,46,70,70,52,39,70,38,43,58,,,39,70,66,52,50,39,
     57,41,54,42,37,49,39,57,,57,182,160,172,150,36,90,,36,,36,90,34,,36,
     64,,90,61,60,238,212,224,202,242,196,40,37,40],
   [58,67,62,70,55,,64,,,77,56,61,,58,61,80,61,80,,,76,76,50,,51,47,63,43,
     ,52,,,,,236,242,214,230,48,86,82,50,,40,92,44,82,44,,,92,78,98,308,
     310,286,302,308,286,46,43,43,46],
   [56,67,44,74,51,42,58,44,74,74,53,39,67,35,52,49,52,49,39,67,67,49,
     47,34,54,41,45,37,32,44,34,54,,54,205,153,167,157,36,90,68,33,68,
     34,90,33,68,36,82,68,90,68,68,255,203,217,203,257,175,43,31,37,31,
     43],[56,68,62,73,56,62,57,68,77,,56,65,76,58,,80,61,78,61,76,,78,
     47,61,62,53,57,42,,47,67,57,,,228,234,206,226,46,92,80,46,80,40,86,
     48,,50,67,78,,,82,308,318,282,306,312,286,43,49,40,40,49,43],
   [18,,,,34,,50,20,,48,7,,,9,10,11,14,9,10,11,9,11,32,,,28,43,28,,49,30,
     47,,,39,39,35,39,13,,,14,15,11,81,13,13,14,,15,,13,15,53,53,49,53,
     53,49,52,48,48,41,52,44,52],
   [18,25,20,35,25,24,31,22,35,35,9,10,11,7,,,10,11,14,9,11,9,32,27,42,
     25,,28,31,42,25,38,,42,39,39,35,39,14,41,15,13,,11,37,14,15,13,41,
     13,41,15,13,53,53,49,53,53,49,52,39,48,35,52,35,52,9],
   [14,25,14,40,,,,14,40,40,7,8,9,7,8,9,8,9,8,9,9,9,24,22,37,22,35,20,
     ,,22,37,,37,29,29,25,29,11,,12,11,12,8,,11,12,11,,12,,12,12,39,39,
     35,39,39,35,40,38,36,33,40,34,40,7,7],
   [18,21,22,35,25,24,31,20,35,35,7,,9,9,10,11,,,10,11,9,11,32,25,38,
     25,38,28,31,42,27,42,,38,39,39,35,39,13,37,13,14,15,11,41,13,,14,
     41,15,37,13,15,53,53,49,53,53,49,52,39,48,35,52,35,52,7,9,7],
   [18,31,20,48,34,,,,,,9,10,11,7,,9,10,11,,,11,9,32,30,47,28,41,28,,49,,,
     ,47,39,39,35,39,14,81,15,13,13,11,,14,15,13,,,81,15,13,53,53,49,
     53,53,49,52,48,48,41,52,44,52,9,7,7,9]],
 [,[],[],[],[,33,,46],[,,22],[,40,,59],[,,24,,,24],
   [,,,46,46,,59],[],[18,,,,49,,,20],[,31,,,,,,26,60],[,,22,,57,,,26],
   [18,35,,,,36,64,36,61,,9,15,11],[,45,,,,,66,30,86,,10,16,12],
   [30,45,,,,50,56,30,66,,11,17,13],[28,,27,72,49,,,29,,,,13,,15,16,17],
   [30,62,24,68,42,30,,26,71,,,,11,11,12,13],
   [28,37,23,64,38,27,56,,,,10,16,12,,12,,16,12],
   [,56,42,,59,,,28,,,11,17,13,,,13,17,13],[],
   [,41,,72,,50,72,28,75,,11,17,13,,,13,17,13,,13],
   [36,,,,50,,58,,,,32,,,36,,52,46,48,46,,,50],
   [,,,,,57,,59,,,,,,55,56,63,,,53,66,,63],
   [,39,,,62,92,64,,62,,,50,,59,62,65,72,81,55,80,,67],
   [36,47,,58,,,66,44,58,,31,38,44,30,,,,42,36,54,,44,34,,44],
   [62,70,,92,,110,87,60,88,,62,47,58,,47,,71,50,49,66,,66,45,76,53],
   [36,40,46,62,,,,52,62,,28,,46,36,43,48,,,43,48,,48,34,,39,34,45],[],
   [62,58,,74,47,,,78,74,,64,,65,59,72,75,63,67,60,71,,,45,,56,47,52],
   [,,39,,,39,,,,,33,37,42,,40,,38,38,,,,45,,50,,35,44],
   [,47,,62,62,,70,,,,66,54,113,60,,75,61,60,53,,,78,,,45,44,53,45,,56],
   [,70,93,,74,,87,60,89,,,49,58,66,51,78,57,50,49,66,,54,,74,52,,38,46,,
     52,44,52],[],[90,,,,,174,310,144,364,,39,,,45,66,,77,55,67,61,,73,
     168,,,153,229,164,,,282,269,229],
   [90,,,276,,124,251,,,,39,,57,45,,,79,,,,,61,168,320,251,141,,160,,259,,,,,
     41],[90,175,,404,,,,136,404,,35,,59,45,54,59,72,53,54,59,,59,164,,
     224,153,224,140,,,282,265,222,,41,41],
   [90,167,,244,175,140,246,122,246,,39,80,55,45,,71,,,66,63,,,168,,225,143,
     196,164,,232,236,,196,,41,41,41],
   [18,,,,35,18,66,20,54,,13,,,18,19,20,18,21,19,20,,20,32,,,29,46,28,,49,
     31,55,,,75,75,65,75],[],
   [,,,,55,31,97,33,78,,,,,18,19,20,,18,19,20,,20,,,,,52,55,,74,41,93,59,,,
     89,,90],[18,31,,48,,26,44,24,44,,16,22,19,16,,,21,19,19,24,,,34,51,
     46,27,,34,,45,35,48,60,,78,78,76,78,16,,16],
   [32,54,,122,,45,82,39,,,17,23,20,,,,22,20,,20,,20,58,80,74,,,61,,,48,97,
     79,,97,,81,,17,,17],
   [18,39,18,54,,,,20,52,,13,,16,16,17,18,,16,17,18,,18,32,46,41,29,48,28,
     ,,31,44,47,,65,65,57,65,13,,13,14,15],
   [,76,,102,,,,,100,,,,,93,85,110,84,93,105,,,105,98,,110,106,145,,,,,114,
     148,,681,,,556,,,,70],
   [18,,18,48,,18,44,20,48,,13,19,21,18,19,20,,,19,20,,20,32,,43,27,36,28,
     ,45,29,45,36,,75,75,65,75,13,,,16,17,13],
   [,,34,,54,31,,33,68,,,,18,18,19,20,,,19,20,,20,70,,89,46,65,,,69,44,66,
     73,,90,91,87,,,,15,16,17,13],
   [18,38,20,72,,20,60,,,,16,22,19,16,19,24,21,19,,,,24,34,48,56,32,44,34,
     ,51,,,44,,78,78,76,78,16,,16,16,,14,,16,16],
   [,,,56,54,,62,,,,,,,93,55,120,79,63,,,,127,,,66,68,94,64,,79,,,,,549,,429,,
     ,,,46,,,96],[32,60,,88,57,45,74,,,,17,23,20,,,20,22,20,,,,20,58,75,
     84,51,,61,,80,45,,65,,101,,81,103,17,,17,,17,15,,17,17],[],[],
   [32,53,,80,,45,81,35,,,17,23,20,,,20,22,20,,20,,,58,80,73,,,61,,77,50,
     91,77,,136,95,81,98,17,,17,,17,15,,17,17,,,17],
   [126,,,,261,198,,,398,,53,,,63,89,83,101,73,,85,,,232,,,207,301,220,,343,
     279,354,306,,285,285,273,285,101,,,106,,87,638,101,115,106,,125],
   [126,203,,,,,322,170,352,,53,103,,63,,,103,73,88,95,,83,232,404,326,195,,
     220,,347,253,347,310,,285,285,273,285,101,,115,106,,87,658,101,,106,
     392,153,,,125,55],[126,,,394,,,,,504,,49,,,63,74,81,,75,74,81,,81,228,
     523,,207,293,196,,,279,337,293,,281,277,245,281,91,,117,104,111,79,,91,
     117,104,427,111,,,111,55,55],
   [126,211,168,324,,166,316,164,358,,53,101,73,63,89,,,,89,89,,83,232,,303,
     197,268,216,,,,316,268,,285,285,269,285,101,,115,106,143,87,812,101,,
     106,430,137,,,,55,55,55],
   [126,239,186,,257,186,388,,,,53,101,73,63,93,89,,79,,,,83,232,484,332,
     207,305,220,,346,,,301,,285,285,273,285,101,,117,106,143,87,918,101,
     123,106,,,,,132,55,55,55,55],
   [126,,150,352,225,168,,148,352,,49,,75,63,70,81,100,75,70,81,,81,232,354,
     ,193,,196,,340,217,340,,,277,281,245,277,91,,117,100,111,79,611,91,,
     100,,111,,,111,55,55,49,55,55],
   [58,,,,78,,81,81,81,,56,,,68,62,79,65,74,63,,,82,52,,,61,72,57,,71,,64,
     70,,276,290,262,260,50,,,57,84,54,131,49,93,53,89,84,,,87,374,384,
     362,356,374,368],[72,81,,100,,,98,76,100,,57,66,76,54,,,,66,62,86,,
     72,61,,67,49,,57,,73,60,71,60,,279,243,263,249,51,,,49,,51,158,45,75,
     56,109,84,,,93,369,333,353,339,369,331,57],
   [72,65,79,91,,,,88,89,,52,,76,68,65,80,61,,65,84,,77,61,118,62,61,72,
     44,,,85,71,70,,272,282,234,256,50,,75,59,85,45,,45,80,59,90,85,,,88,
     362,372,326,340,362,332,57,57],
   [58,66,68,,70,68,79,60,83,,52,51,60,49,,67,,,49,66,,58,52,,64,49,58,52,
     ,64,53,64,58,,222,216,216,196,44,,61,45,,43,128,36,,44,,67,,,62,296,
     288,288,268,296,290,50,47,50],
   [58,70,84,83,78,91,81,,,,56,63,,68,62,83,64,76,,,,84,52,,61,61,70,57,,
     71,,,72,,276,290,258,260,50,,77,57,88,54,129,49,80,53,,,,,101,374,384,
     358,356,374,368,50,57,57,50],
   [72,81,63,106,93,63,84,68,106,,53,63,76,54,63,68,,62,58,80,,68,61,85,
     62,49,60,51,,71,54,73,,,271,239,235,241,47,,75,49,83,47,152,41,75,
     52,166,83,,,83,353,321,317,327,357,299,57,47,51,47,57],
   [72,71,91,91,72,84,73,90,89,,56,70,78,68,,86,61,71,,94,,79,61,99,68,
     61,70,52,,64,85,71,72,,276,290,262,260,54,,78,59,86,49,110,49,92,59,
     92,86,,,86,374,384,362,356,374,368,57,57,50,50,57,57],
   [18,,,,31,18,50,20,,,7,,,9,10,11,12,9,10,11,,11,32,,,28,46,28,,47,30,
     50,43,,39,39,35,39,13,,,15,16,12,82,13,14,15,44,16,,,16,53,53,49,
     53,53,49,52,48,48,41,52,44,52],
   [18,33,,,,30,58,30,52,,9,15,11,9,,,15,11,15,11,,11,36,55,53,30,,36,,53,
     ,56,47,,45,45,45,45,16,,16,16,,14,79,16,16,16,79,16,,,16,63,63,63,
     63,63,63,60,54,60,45,60,54,60,9],
   [18,31,18,44,,,,20,44,,7,,9,9,10,11,14,9,10,11,,11,32,46,42,28,38,28,,
     ,30,44,38,,39,39,35,39,13,,13,14,15,11,,13,13,14,,15,,,15,53,53,49,
     53,53,49,49,48,45,38,49,44,49,7,9],
   [18,31,,44,31,18,,20,44,,7,12,9,9,10,11,,,10,11,,11,32,,39,28,38,28,,
     44,30,43,38,,39,39,35,39,13,,14,15,16,12,66,13,,15,40,16,,,16,53,
     53,49,53,53,49,49,48,45,38,49,44,49,7,9,7],
   [18,33,30,52,33,,58,,,,9,15,11,9,15,11,15,11,,,,11,36,53,53,30,50,36,,
     53,,,,,45,45,45,45,16,,16,16,16,14,92,16,16,16,,,,,16,63,63,63,63,
     63,63,60,54,60,45,60,54,60,9,9,9,9],
   [18,,18,,34,,50,20,,,7,14,9,9,10,11,,9,10,11,,11,32,47,45,28,43,28,,
     47,30,47,,,39,39,35,39,13,,13,14,15,11,81,13,13,14,,15,,,15,53,53,
     49,53,53,49,52,48,48,41,52,44,52,7,9,7,7,9]],
 [,[],[],[],[,27,,34],[,,26],[,34,,41],[,,24,,,28],
   [,,,34,34,,41],[,34,,41,,,34,,41],[18],[,30,,,38,29,39,23],
   [,,28,,,,100],[18,25,20,38,25,28,34,28,38,38,9,10,11],
   [,53,30,,,,,28,62,,15,16,17],[30,35,26,50,35,34,36,24,48,48,11,12,13 
    ],[32,,30,,49,,50,,,62,,12,,10,16,12],
   [30,,30,71,37,40,55,38,57,59,,,13,11,17,13],
   [32,30,25,53,36,52,46,,,37,15,16,17,,13,,16,17],
   [,53,26,,57,,,22,,,11,12,13,,,11,12,13],
   [,,28,,,,100,,,,,,13,11,17,13,,13,17,13],[],
   [36,,,,45,68,48,,,52,36,,,32,,48,50,52,50,,62],
   [,,,,,43,,39,,,,,,27,32,35,39,39,37,42,63],
   [,43,,,52,86,55,,52,59,,49,,45,70,53,,,49,71,70],
   [36,43,42,50,43,45,50,45,50,50,34,33,52,25,,,,41,35,44,52,,34,33,41],
   [54,61,48,76,61,54,76,48,84,80,50,39,62,,33,,58,48,43,58,58,,41,34,48 
    ],[36,45,52,52,,,,50,52,,36,43,48,28,,,43,48,,48,48,,34,,41,34,35],
   [,,38,,,,,,,,,37,,35,,39,51,53,47,,,,,31,,33,32],
   [54,52,78,59,43,,,74,59,52,60,49,74,45,,53,58,66,55,60,,,41,,48,41,48]
    ,[,,40,,,,,,,,58,37,66,35,,47,41,45,,,66,,,33,,33,34,,35],
   [,43,,52,52,82,49,,,59,60,49,79,41,,59,53,62,45,,66,,,,41,41,42,35,,48 
    ],[54,61,56,76,61,62,,60,88,,50,43,70,,43,66,62,,47,58,62,,41,40,48,
     ,34,41,40,48,40,48],
   [54,52,78,59,43,,48,76,59,,,57,74,45,70,49,58,74,53,72,,,41,,48,41,48,,
     ,41,,48,48],[90,,,,,212,340,,372,372,45,,,39,87,,67,61,79,55,69,,168,
     ,,151,208,164,,,519,253,212,249],
   [90,129,118,188,129,126,184,122,188,188,45,,,39,,,63,,81,57,65,,168,161,
     227,129,,160,157,227,167,219,,227,41],
   [90,201,,,,,,,,270,45,54,59,35,,,54,59,,,59,,164,277,247,149,184,140,,,,,
     206,241,41,41],[90,129,116,168,129,122,160,114,168,168,45,66,61,39,,
     57,,,84,57,61,,168,159,207,129,160,164,159,207,161,199,168,207,41,41,
     41],[18,,,,,22,60,20,,,16,,,16,22,19,19,24,21,19,,,34,,,30,36,34,30,
     47,32,53,40,47,78,78,76,78],
   [,,,,44,,53,,44,47,,,,48,60,48,47,71,,,,,,,,68,100,58,,69,,58,98,65,,220,
     ,198],[,,,,,41,92,42,,,,,,17,23,20,,20,22,20,20,,,43,,,52,62,49,,47,
     83,87,,,115,81,97],
   [18,25,20,32,25,20,28,18,32,32,18,19,20,13,,,19,20,18,21,20,,32,27,
     39,25,,28,25,39,27,35,,39,75,75,65,75,16,42,17],
   [36,55,34,72,55,37,,,,68,18,19,20,,,,19,20,,18,20,,58,43,71,,,76,41,71,
     48,,73,65,93,,87,91,16,,17],
   [18,37,20,52,,,,18,56,,16,17,18,13,,16,17,18,,16,18,,32,31,43,29,36,28,
     ,,47,39,40,47,65,65,57,65,14,,15,13,13],
   [,48,,51,,,,,51,44,,51,,42,,50,49,69,66,,,,68,,75,66,96,,,,,71,94,64,
     694,218,,200,,47,,36],
   [18,25,24,32,25,24,32,24,32,32,16,19,24,16,22,19,,,21,19,24,,34,33,
     41,25,34,34,33,41,33,41,34,41,78,78,76,78,16,38,,16,16,14,40],
   [,,40,,57,41,92,42,78,,,,20,17,23,20,,,22,20,20,,76,48,,50,80,62,53,
     77,52,73,,89,96,99,81,,,,17,17,17,15],
   [18,37,20,48,,24,58,,,48,18,19,20,13,19,21,19,20,,,20,,32,31,51,29,36,
     28,30,43,,,40,43,75,75,65,75,16,,17,13,,13,,16,17],
   [,,,44,48,,53,,,51,,,,48,115,52,49,69,,,,,,,68,72,105,60,,75,,,100,71,
     678,220,,200,,40,,42,,,47,40],
   [36,55,34,68,55,37,,,,72,18,19,20,,,18,19,20,,,20,,58,39,77,46,,76,37,
     77,39,,57,,92,91,,96,16,,17,,15,13,,16,17],
   [,40,,47,,,46,,51,,,60,,48,60,48,47,71,49,,,,58,,65,68,100,,,62,,65,104,,
     ,218,373,200,,39,,42,,,40,38,,,47],
   [,,38,,,41,92,42,78,,,,20,17,23,20,,20,22,20,,,,47,,,56,62,49,119,47,
     83,52,,115,,81,95,,,17,17,17,15,,,17,17,,17],[],
   [126,,,,231,194,,,350,,63,,,53,105,73,83,83,,75,,,232,,,199,266,220,357,
     326,382,309,282,,285,285,273,285,106,,,101,,87,513,106,125,101,464,117]
    ,[126,179,162,254,179,168,242,154,254,254,63,86,,53,,,87,83,101,73,85,
     ,232,211,307,179,,220,209,307,219,291,292,307,285,285,273,285,106,278,
     139,101,,87,288,106,,101,294,115,284,134,,55],
   [126,,176,,,,,,400,400,63,74,81,49,,71,74,81,94,71,81,,228,279,,201,232,
     196,,,310,279,268,326,281,277,245,281,104,412,111,91,115,79,,104,111,
     91,490,112,,111,,55,55],
   [126,179,156,232,179,160,220,148,232,232,63,87,83,53,101,,,,104,75,85,,
     232,215,285,179,220,216,209,285,215,273,232,285,285,285,269,285,106,
     262,125,101,115,87,272,106,,101,266,124,264,127,,55,55,55],
   [126,253,164,,237,192,356,,,402,63,86,83,53,101,73,,95,,,83,,232,348,328,
     201,260,220,,325,,,276,324,285,285,273,285,106,402,128,101,115,87,598,
     106,143,101,,,514,129,,55,55,55,55],
   [126,179,148,244,179,156,212,140,244,244,63,70,81,49,94,71,70,81,98,75,
     81,,232,197,297,175,,196,189,297,203,261,,297,277,281,245,277,100,254,
     111,91,113,79,266,100,111,91,268,119,256,111,,55,55,49,55,55],
   [54,,,,70,105,75,74,74,81,61,,,58,61,71,59,79,61,,98,,50,,,59,62,55,77,
     66,,55,66,66,268,286,258,246,50,,,52,74,54,100,50,102,46,93,80,87,94,
     ,362,382,348,338,360,362],
   [72,79,70,86,79,79,78,75,86,86,66,53,88,39,,,,63,59,76,88,,59,54,66,
     43,,55,55,66,57,62,52,66,273,207,251,207,50,104,,39,,51,106,43,79,
     51,112,71,104,101,,345,285,335,285,351,277,55],
   [72,70,86,81,,,,83,81,74,61,59,84,54,,,59,77,,80,70,,59,79,66,59,56,42,
     ,,83,56,66,59,264,278,230,242,57,87,82,48,76,42,,50,88,50,92,76,80,
     88,,350,370,312,322,348,326,55,55],
   [54,61,56,72,61,62,70,60,72,72,50,43,64,38,46,53,,,47,64,64,,50,49,
     57,43,50,50,52,57,52,57,50,57,212,188,204,168,40,90,61,38,,40,97,34,
     ,40,91,61,90,61,,276,254,268,232,276,248,48,41,48],
   [54,61,72,74,70,95,75,,,81,61,59,,58,61,71,59,91,,,86,,50,,59,59,62,
     55,81,66,,,66,66,268,286,254,246,50,84,88,52,76,54,96,50,,46,,,91,82,
     ,362,382,344,338,360,362,48,55,55,48],
   [72,79,62,86,79,71,70,63,86,86,66,49,80,35,,57,60,59,55,78,80,,59,48,
     66,43,42,49,47,66,51,56,,66,265,203,223,199,46,102,79,35,95,47,106,
     43,79,47,106,,102,79,,329,273,299,273,339,245,55,41,49,41,55],
   [72,70,92,81,61,82,68,89,81,,61,70,92,58,,77,59,79,63,78,,,59,79,66,
     59,62,50,,59,87,62,66,,268,286,258,246,57,87,88,52,78,46,89,50,100,
     54,96,74,,,,362,382,348,338,360,362,55,55,48,48,55,55],
   [18,,,,,30,56,,,48,9,,,9,15,11,15,11,15,11,11,,36,,,30,42,36,,49,54,50,
     42,,45,45,45,45,16,,,16,16,14,78,16,16,16,78,16,,16,,63,63,63,63,
     63,63,57,54,57,42,57,54,57],
   [18,25,20,35,25,22,31,24,35,35,9,10,11,7,,,10,11,12,9,11,,32,27,42,
     25,,28,25,42,31,38,38,42,39,39,35,39,15,35,16,13,,12,39,15,16,13,
     39,14,35,16,,53,53,49,53,53,49,52,39,48,35,52,35,52,9],
   [18,35,20,44,,,,18,,,9,10,11,7,,9,10,11,14,9,11,,32,30,43,28,34,28,,,
     46,39,38,44,39,39,35,39,14,,15,13,13,11,,14,15,13,,13,,15,,53,53,
     49,53,53,49,49,48,45,38,49,44,49,9,7],
   [18,27,28,36,27,28,36,28,36,36,9,15,11,9,15,11,,,15,11,11,,36,37,45,
     27,36,36,37,45,37,45,36,45,45,45,45,45,16,46,16,16,16,14,46,16,,
     16,46,16,46,16,,63,63,63,63,63,63,54,45,54,36,54,45,54,9,9,9],
   [18,35,20,44,31,,,,,,9,10,11,7,12,9,10,11,,,11,,32,30,47,28,34,28,29,
     43,,,38,,39,39,35,39,15,40,16,13,14,12,68,15,16,13,,,40,16,,53,53,
     49,53,53,49,49,48,45,38,49,44,49,9,7,7,9],
   [18,25,20,35,25,24,31,18,35,35,9,10,11,7,14,9,10,11,,9,11,,32,27,42,
     25,38,28,31,42,29,38,,42,39,39,35,39,14,41,15,13,13,11,37,14,15,
     13,41,13,41,15,,53,53,49,53,53,49,52,39,48,35,52,35,52,9,7,7,9,7]
    ,[18,37,,48,,30,56,,48,,9,15,11,9,15,11,15,11,15,11,,,36,55,49,30,
     42,36,,50,54,49,42,,45,45,45,45,16,,16,16,16,14,78,16,16,16,78,16,,,
     ,63,63,63,63,63,63,57,54,57,42,57,54,57,9,9,9,9,9,9]],
 [,[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
   [,,,,,,,,,,,,,,15],[],[,,,,,,,,,,,,,,,,18],[,,,,,,,,,,,,,,,24,20],[],
   [,,,,,,,,,,,,,,,15,20],[],[],[],[,,,,,,,,,,,,,9,,,,,15,36,,27],
   [,,,,,,,,,,,,,,13,,,,,,,36],[],[],[],[],[],
   [,,,,,,,,,,,,,,18,,21,,21,,,32,,,,,4],[],[],
   [,,,,,,,,,,,,,45,,,,,111,319,,145,,,,15],[],
   [,,,,,,,,,,,,,45,,169,,,129,,,,,,,15,20,,,,,,20,,,15],[],[],[],
   [,,,,,,,,,,,,,9,,,12,,,,,,,,,9,,,,,,,21,,,45,,45],
   [,,,,,,,,,,,,,,,,23,,,23,,19,,,,,,,,,,,,,,,,161],
   [,,,,,,,,,,,,,,14,,12,,17,19,,19,,,,,18,,,,,,18,,,81,,,,,,11,21],[],
   [,,,,,,,,,,,,,9,10,15,,,13,23,,15,,,,9,12,,,,,,12,,,45,,45,,,,9,19],
   [,,,,,,,,,,,,,,47,,,,56,89,,57,,,,,61,,,,,,,,,,,,,,,39],
   [,,,,,,,,,,,,,,14,,14,,,,,,,,,12,,,,,,,18,,,,,75,,,,,,13,,11,46],[],
   [,,,,,,,,,,,,,,,20,22,,,,,17,,,,30,,,,,,,32,,,,,,,,,,26,20,,17,48],[],[],
   [,,,,,,,,,,,,,,,18,23,,,,,,,,,,,,,,,,41,,,,,,,,,,17,21,,19,46],[],
   [,,,,,,,,,,,,,63,,,,,131,246,,183,,,,21,,,,,,,40,,,105,,105,,,,63,,93,,63,,,,
     237,,,246],[,,,,,,,,,,,,,115,118,158,,,,187,,143,,,,30,46,,,,,,,,,,,,,,,84,
     147,,,,,97,,148,,,147,,30],
   [,,,,,,,,,,,,,63,73,,,,139,234,,159,,,,21,28,,,,,,28,,,105,,105,,,,63,,,,63,,
     91,,167,,,,,21],[],
   [,,,,,,,,,,,,,63,82,105,84,,105,148,,105,,,,21,,,,,,,,,,105,,105,,,,63,142,79,
     ,63,,79,,122,,,126,,21,,21],[],
   [,,,,,,,,,,,,,18,,,,,29,54,,42,,,,6,,,,,,,7,,,30,,30,,,,18,,,,18,137,23,,46,,
     ,59,,42,55,42,,42],
   [,,,,,,,,,,,,,41,38,39,26,,,61,,55,,,,9,10,,,,,,10,,,,,,,,,25,39,23,,,,32,,
     38,,,46,,63,64,,,67,,8],
   [,,,,,,,,,,,,,17,17,49,,,,,,,,,,6,7,,,,,,7,,,27,,25,,,,17,,,,15,,,,43,,,40,,
     37,,35,,37,,6],[],
   [,,,,,,,,,,,,,18,24,30,24,,29,42,,30,,,,6,7,,,,,,,,,30,,30,,,,18,39,23,,18,
     ,23,,,,,38,,42,54,42,,42,,6,8,6],
   [,,,,,,,,,,,,,,,,28,,41,,,,,,,9,10,,,,,,10,,,53,,,,,,25,50,25,,33,116,30,,46,,
     ,56,,67,66,61,,61,,8,7,,,8],[],
   [,,,,,,,,,,,,,25,,,42,,51,52,,35,,,,27,,,,,,,46,,,129,,129,,,,25,,36,,27,61,
     36,,42,,,42,,179,238,179,,179,,52,75,45,,52],
   [,,,,,,,,,,,,,40,36,46,30,,43,47,,43,,,,30,44,,,,,,38,,,160,,,,,,29,45,25,,,
     ,33,,46,,,49,,,237,,,173,,53,62,,,50,68,,34],
   [,,,,,,,,,,,,,27,30,33,,,37,57,,37,,,,27,34,,,,,,34,,,121,,125,,,,27,43,,,21,
     ,31,,41,,,47,,163,,167,,147,,48,,43,,42,65,,27],
   [,,,,,,,,,,,,,40,40,40,38,,,,,,,,,36,,,,,,,46,,,183,,165,,,,30,43,33,,33,64,
     35,,,,,,,,259,223,,226,,64,72,51,,65,74,,34,31,33],
   [,,,,,,,,,,,,,25,28,31,30,,35,47,,35,,,,21,38,,,,,,,,,109,,115,,,,25,52,25,,
     21,,29,,46,,,47,,147,186,153,,137,,40,61,43,,40,67,,25,25,21,31],
   [],[,,,,,,,,,,,,,25,30,31,38,,,,,,,,,27,34,,,,,,34,,,129,,129,,,,25,39,33,,
     27,59,,,,,,,,179,235,179,,179,,52,61,43,,52,61,,25,31,27,,25]],
 [,[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
   [,,,,,,,,,,,,,13,14,23],[,,,,,,,,,,,,,22,23,32],[],[],[],
   [,,,,,,,,,,,,,,,22,23,32],[],[],[],[,,,,,,,,,,,,,24],
   [,,,,,,,,,,,,,,,,,80,,,,147],[,,,,,,,,,,,,,,39],[],
   [,,,,,,,,,,,,,,52,,,,,,,,,,,,16],[],[],
   [,,,,,,,,,,,,,80,40,106,41,,,,,87,,,,,12],
   [,,,,,,,,,,,,,,44,,,,,,,93,,,,,,,,18,,,16],[],
   [,,,,,,,,,,,,,54,,,,,,,,164,,,,40],
   [,,,,,,,,,,,,,,95,,,190,,,,194,,,,82,142,84,,,,,,141],
   [,,,,,,,,,,,,,54,,170,,,,,,,,,,40,60,64,,86,,,60,86,,20,38],[],[],[],
   [,,,,,,,,,,,,,10,,,13,22,,,,,,,,8,,,,,,,20,,,20,38,20],[],[],[],
   [,,,,,,,,,,,,,12,13,22,,,,,,22,,,,8,12,14,,17,,,12,17,,20,,20,,,,4],[],
   [],[],[],[],[],[],[],
   [,,,,,,,,,,,,,74,,,106,198,,,,190,,,,56,,120,,203,,,116,203,,140,,140,,,,28,,,
     ,28],[,,,,,,,,,,,,,,,,117,222,,,,230,,,,80,,136,,,,,,190,,,264,208,,,,40,,,
     ,46],[,,,,,,,,,,,,,74,112,,,,,,,,,,,56,84,88,,114,,,84,114,,140,284,140,,
     ,,28,,,,28,,,,,,,,,28,46],
   [,,,,,,,,,,,,,,145,,,398,,,,284,,,,104,220,,,196,,,,,,,,,,,,,,,,46,,,,,,,,,48,46]
    ,[,,,,,,,,,,,,,70,101,154,113,160,,,,154,,,,56,,,,,,,,170,,140,,140,,,,28,,,
     ,28,,,,,,,,,28,,28,48],[],
   [,,,,,,,,,,,,,44,,,,116,,,,,,,,16,,30,,26,,,20,,,80,134,80,,,,16,,,,16,,,,,,,,,
     112,152,112,182,112],
   [,,,,,,,,,,,,,,60,109,,117,,,,,,,,22,24,22,,,,,,28,,128,134,106,,,,,,,,21,,,,,,,
     ,,154,190,142,,,,20],
   [,,,,,,,,,,,,,43,44,109,,,,,,84,,,,16,20,22,,24,,,20,24,,70,,60,,,,15,,,,12,,
     ,,,,,,,96,136,84,174,96,,16,18],
   [,,,,,,,,,,,,,63,39,93,47,,,,,90,,,,22,26,30,,32,,,28,32,,104,,,,,,21,,,,,,,,,
     ,,,,136,,,188,140,,20,22],
   [,,,,,,,,,,,,,40,,100,,102,,,,,,,,16,20,,,,,,,26,,80,,80,,,,16,,,,16,,,,,,,,,
     112,,112,,112,,16,,16,20],
   [,,,,,,,,,,,,,63,,,,93,,,,119,,,,,,22,,28,,,24,,,,142,106,,,,21,,,,21,,,,,,,,,
     158,176,142,,162,,,22,18,22,20],[],
   [,,,,,,,,,,,,,22,,,27,42,,,,30,,,,48,,52,,,,,104,,,118,,122,,,,22,,,,24,,,,,,,,
     ,150,,158,,138,,84,81,77,81,86,89],
   [,,,,,,,,,,,,,,19,,19,,,,,,,,,32,50,34,,,,,,,,,80,,,,,16,,,,16,,,,,,,,,,104,112,
     144,,,56,56,48,,,64],
   [,,,,,,,,,,,,,32,29,40,,,,,,40,,,,52,76,62,,75,,,68,73,,122,,122,,,,26,,,,22,
     ,,,,,,,,160,182,162,,152,,92,97,72,88,92,103,,28,24],
   [,,,,,,,,,,,,,,,30,27,50,,,,30,,,,54,,50,,88,,,92,85,,146,118,,,,,28,,,,24,,,,
     ,,,,,172,146,168,194,142,,88,83,69,79,92,101,,18,24,30],
   [,,,,,,,,,,,,,28,25,36,25,,,,,36,,,,44,78,,,,,,,,,102,,102,,,,22,,,,22,,,,,,,,,
     132,,134,,120,,76,,72,76,72,,,24,,20,26],[],
   [,,,,,,,,,,,,,28,34,30,27,42,,,,,,,,54,74,50,,73,,,74,71,,122,120,114,,,,28,
     ,,,24,,,,,,,,,154,154,156,208,140,,90,83,72,76,88,89,,18,,28,18,24],
   []],[,[],[],[],[],[],[],[],[],[],[],[],[],[],
   [],[],[],[,,,,,,,,,,,,,47,,55],[],[],[],[,,,,,,,,,,,,,,,35,39],
   [],[],[],[,,,,,,,,,,,,,15,,,,87,,,,87],[,,,,,,,,,,,,,,,,,40,33,,,78],
   [],[],[],[],[],[,,,,,,,,,,,,,,,52,,,33,,,50,,,,,7],[],[],
   [,,,,,,,,,,,,,72,,,92,,156,,,264,,,,25],
   [,,,,,,,,,,,,,,,,,,,,,,,,,,78,,,,,,,,,48],
   [,,,,,,,,,,,,,72,,262,,,159,,,,,,,25,32,,,,,,32,,,23,40],[],[],[],
   [,,,,,,,,,,,,,14,,,17,31,22,,,,,,,15,,,,,,,26,,,72,157,72],
   [,,,,,,,,,,,,,,,,,49,,,,30,,,,,,,,,,,63,,,,326,200],
   [,,,,,,,,,,,,,,,,19,,26,,,,,,,24,,,,,,,30,,,118,158],[],
   [,,,,,,,,,,,,,15,,39,,,,,,36,,,,15,20,,,,,,20,,,70,128,60,,,,15,43,16],
   [,,,,,,,,,,,,,71,,51,,,,,,70,,,,,65,,,,,,,,,,,,,,,43,,53],
   [,,,,,,,,,,,,,,,,,,,,,,,,,,30,,,,,,30,,,123,,106,,,,20,,20],[],
   [,,,,,,,,,,,,,,,37,59,54,,,,34,,,,84,,,,,,,50,,,297,,,,,,,35,,,,64],[],[],
   [,,,,,,,,,,,,,,,35,,,,,,,,,,,,,,,,,,,,,,,,,,,29,,,31,53,,,36],[],
   [,,,,,,,,,,,,,100,,,118,284,196,,,342,,,,35,,,,,,,47,,,160,318,154,,,,100,,145,
     ,94,,165,,290,,,332],[],
   [,,,,,,,,,,,,,100,,,,,,,,318,,,,35,44,,,,,,44,,,158,308,140,,,,100,240,,,84,,
     134,,302,,,,,31],[,,,,,,,,,,,,,181,,640,,544,,,,,,,,,66,,,,,,,,,230,,244,,,,
     154,359,160,,130,619,156,,,,,335],
   [,,,,,,,,,,,,,100,,234,113,208,162,,,228,,,,35,,,,,,,,,,160,325,154,,,,100,
     203,133,,94,388,133,,238,,,210,,31,,31,50],[],
   [,,,,,,,,,,,,,15,,,,61,,,,61,,,,5,,,,,,,6,,,25,,25,,,,15,,24,,15,,,,67,,,,,35,
     ,35,,35],[],[,,,,,,,,,,,,,14,,36,,,21,,,38,,,,5,6,,,,,,6,,,22,,20,,,,
     14,,,,12,,18,,37,,,31,,30,,28,46,30,,5],[],
   [,,,,,,,,,,,,,15,,37,25,39,27,,,37,,,,5,6,,,,,,,,,25,52,25,,,,15,41,24,,15,
     ,24,,41,,,41,,35,,35,53,35,,5,,5],[],[],
   [,,,,,,,,,,,,,38,,,46,63,66,,,51,,,,45,,,,,,,57,,,192,,182,,,,38,,58,,39,77,
     52,,62,,,55,,260,,250,353,252,,41,,36,,41],
   [,,,,,,,,,,,,,,,78,47,,62,,,,,,,59,,,,,,,60,,,251,344,232,,,,,59,42,,40,87,48,
     ,,,,,,301,,298,352,264,,55,,,,49,,,48],
   [,,,,,,,,,,,,,43,,67,,,59,,,52,,,,45,54,,,,,,54,,,190,344,168,,,,43,71,52,,
     32,,50,,70,,,57,,254,,232,354,246,,41,,34,,41,,,39],[],
   [,,,,,,,,,,,,,38,,62,41,50,52,,,52,,,,41,45,,,,,,,,,162,338,156,,,,34,63,45,
     ,36,72,46,,67,,,62,,214,,208,319,192,,37,,28,,31,,,35,40,35],
   [,,,,,,,,,,,,,61,,75,56,62,,,,72,,,,,76,,,,,,,,,272,417,,,,,57,64,58,,42,78,
     60,,140,,,64,,352,,324,402,367,,,,52,,59,,,52,44,44],
   [,,,,,,,,,,,,,38,,55,39,50,62,,,,,,,45,48,,,,,,52,,,188,,168,,,,38,48,,,36,
     70,48,,62,,,,,254,,232,344,244,,41,,34,,41,,,35,,36,,35,48],[],[]],
 [,[],[],[],[],[],[],[],[],[],[],[],[],[],
   [,,,,,,,,,,16],[],[,,,,,,,,,,,14,,10,12],[,,,,,,,,,,,,29,,,21],
   [,,,,,,,,,,,17,,,15],[,,,,,,,,,,,,,,,28,,31],[,,,,,,,,,,,,29,,,30,,29],
   [,,,,,,,,,,,,31,,,19,,21,,29],[,,,,,,,,,,22,,,,,,,41,23,,52,63],
   [,,,,,,,,,,,,,,,23,16,23,17,29,,31],[,,,,,,,,,,,29,,,,,,83,31,87,97,69],
   [,,,,,,,,,,,,,9,,,,,15,36,,27],[,,,,,,,,,,22,,,,,,,41,23,,52,63,5],
   [,,,,,,,,,,,22,46,,21,47,21,35,22,46,41,35,5,,7,,5],
   [,,,,,,,,,,,25,,,,,,43,25,,,43,,7],
   [,,,,,,,,,,41,29,57,,,73,,55,30,58,80,55,7,,9,,7],
   [,,,,,,,,,,27,17,29,,15,23,,31,,,29,31,,7,,,,,7],
   [,,,,,,,,,,36,31,87,,,,37,69,29,,61,83,,,7,,,7,,9],
   [,,,,,,,,,,,22,46,,21,47,21,35,22,46,41,35,5,,7,,5,5,,,,7],
   [,,,,,,,,,,,32,97,,32,,,87,29,61,,61,7,,9,,7,,,7,,9],
   [,,,,,,,,,,,,,,,,,,,,,,32,,,,32,33,76,,103,50,33,49],
   [,,,,,,,,,,,,,45,,,,,111,540,,,,,,15,,,53,,57,64],
   [,,,,,,,,,,,108,,,94,207,,,,,,,33,,50,,33,32,,,99,49,32,46,,24],
   [,,,,,,,,,,,,,45,,,,,,,,,25,35,41,15,25,25,35,41,35,41,25,41,25,15],
   [,,,,,,,,,,15,,,,11,,12,,15,,,,17,,,,17,18,19,23,15,28,18,26,,,81],[],
   [,,,,,,,,,,,,,,,26,,25,,,25,27,,25,,,,38,,61,25,92,38,,,,196,251],
   [,,,,,,,,,,,,,9,,,10,23,13,,,,,,,9,,24,,,13,,24,,,45,90,45],
   [,,,,,,,,,,,,,,,,,23,,30,32,21,,,,,,47,40,67,26,116,47,,,,173],[],[],
   [,,,,,,,,,,,13,,9,11,,,,,,,,15,13,25,9,15,15,17,25,17,25,15,25,,45,75,
     45,11,,,9],[,,,,,,,,,,,,30,,,24,,,,32,30,23,73,26,120,,73,45,40,68,32,
     ,45,120,253,,221,,,,26,39,22],
   [,,,,,,,,,,,15,,,13,,,,,,,,17,15,28,12,17,18,19,24,,,18,23,,,109,,13,,,11],
   [],[,,,,,,,,,,,,27,,,24,49,27,,,,25,,25,92,30,,38,,58,25,,38,87,341,227,
     164,252,,,23,,26,,,43,28],[],
   [,,,,,,,,,,,,25,,,26,,25,,27,,,,31,,,,43,,74,25,87,43,,,,157,,,,21,,28,,,,26,
     ,,23],[,,,,,,,,,,,,32,,,22,,23,,30,,,,32,,,,45,40,68,30,120,45,,,160,
     183,,,,28,,20,,,,22,,,26],
   [,,,,,,,,,,165,,,,106,,,,,,646,,42,,,,42,43,,64,82,60,43,63,216,,,,102,,,,,,,
     93,,119,,,,394,599],
   [,,,,,,,,,,,,,63,,,82,,131,398,511,185,,,,21,,41,61,,67,,41,78,,105,,105,,,,
     63,,,,63,,,,229,,313],
   [,,,,,,,,,,,136,,136,114,220,153,259,,,319,209,43,82,,30,43,42,,,92,63,42,
     64,,,216,,111,,214,87,229,,,119,213,108,,,,219,207,31,30],
   [,,,,,,,,,,,,,63,,,,,,517,435,,35,49,55,21,35,35,49,55,49,55,35,55,,105,,
     105,,,407,63,,,,63,,101,,377,,322,,,21,31],
   [,,,,,,,,,,,198,445,,124,,,537,,,545,386,42,,60,,42,43,,67,,,43,64,267,,,
     175,105,,,,293,,,,359,102,,,,382,403,31,30,,31],
   [,,,,,,,,,,119,,199,63,100,137,,137,,199,202,137,,67,,21,,,,,,77,,78,211,
     105,,105,79,,158,63,159,,,63,159,79,,160,,160,157,30,21,,21],
   [,,,,,,,,,,37,,,,29,,,62,36,,74,88,8,,,,8,10,27,12,,10,10,12,53,,54,46,
     28,,,,,,,28,79,28,,,,64,92,69,,70,62,68],
   [,,,,,,,,,,,,,18,,,,58,29,60,115,46,,,,6,,8,20,10,,,8,10,,30,,30,,,,18,,,,
     18,74,23,,51,,73,59,,42,58,42,60,42],
   [,,,,,,,,,,46,34,68,36,31,56,38,60,35,70,66,60,10,27,12,9,10,8,,,27,
     12,8,10,54,,53,46,28,,59,28,67,,,28,65,29,,62,,64,65,70,65,69,62,69,
     ,10,8],[,,,,,,,,,,24,18,44,18,20,38,,,18,44,44,32,8,10,10,6,8,8,
     10,10,10,10,8,10,32,26,32,20,16,,38,16,,,,12,,16,,38,,38,34,40,34,
     40,28,40,34,8,6,8],
   [,,,,,,,,,,36,36,,,29,81,,76,,,88,74,8,,10,,8,10,27,12,,,10,12,52,,,46,
     28,,,28,91,,,28,92,28,,,,73,81,68,70,69,62,69,65,8,,10,8],
   [,,,,,,,,,,36,27,58,18,,40,,40,27,58,57,40,8,20,10,6,8,,,,20,10,,,,30,,
     30,23,,47,18,47,,,18,46,23,,47,,48,46,,42,,42,58,42,8,6,,6,8],
   [,,,,,,,,,,39,37,74,,,74,,62,34,88,,88,10,27,12,9,10,8,,10,27,12,8,,53,
     49,52,46,31,,64,,,,,28,81,28,,73,,,92,,68,68,62,78,,10,8,8,8,10],
   [,,,,,,,,,,43,,,,38,,44,45,,,57,47,52,,,,52,53,,83,47,78,53,,252,,263,,35,,
     ,,,,,33,48,,,57,,45,50,299,,331,277,309,242,83,,84,48,82,68,83],
   [,,,,,,,,,,,,,25,,,30,,51,56,58,35,,,,27,,51,33,82,33,,51,,,129,217,129,,,,
     25,,,,27,52,36,,44,,46,40,,179,268,179,,179,,52,79,42,81,52],
   [,,,,,,,,,,60,49,69,40,42,50,39,53,49,69,70,53,39,29,56,30,39,32,,,29,
     55,32,52,217,152,,169,37,,51,30,62,,,33,62,37,,51,,52,62,263,194,219,
     211,263,,60,52,53,36,59,,58,35,34],
   [,,,,,,,,,,60,53,57,27,40,,,,53,59,57,,45,33,69,27,45,45,41,69,41,69,
     45,69,,129,,129,37,,45,27,,,,25,,37,,47,,45,53,281,179,306,179,,179,
     76,52,76,36,76,52,76,35,27,35],
   [,,,,,,,,,,,63,,40,47,44,45,47,,,,45,52,39,74,36,52,53,40,77,,,53,78,,
     202,280,,45,,,32,48,,,39,50,35,,,,59,48,314,,317,,299,242,82,66,83,48,
     83,68,84,,34,35,37],
   [,,,,,,,,,,49,31,59,25,27,35,24,35,31,59,59,35,37,23,60,21,37,,,,23,60,
     ,60,191,101,,103,25,,47,21,50,,,21,50,25,,47,,47,50,217,131,,133,218,
     105,55,36,,30,55,30,57,34,25,,25,34],
   [,,,,,,,,,,49,43,57,38,41,46,44,45,63,,,,53,,77,,53,52,,74,39,78,52,,,
     207,,207,38,,45,36,50,,,33,48,45,,,,,,410,,372,261,,242,83,,82,48,84,
     66,83,35,36,35,35,,34],
   [,,,,,,,,,,,53,59,25,38,35,30,,53,57,,,45,41,63,27,45,45,33,63,41,63,
     45,63,,129,,129,37,,47,25,39,,,27,,37,,45,,,,339,179,263,179,,179,70,
     52,70,36,70,52,70,37,25,35,27,35,25],
   [,,,,,,,,,,,,,9,,,,,15,36,,27,,,,3,,,,,,,,,,15,,15,,,,9,,,,9,,12,,30,,,,,21,
     30,21,,21,,6,9,6,,6,9,,27,30,27,36,21,,27],[],
   [,,,,,,,,,,,,,,,,13,28,21,,,,,,,,,,,,,,,,,,,20,,,,,,,,12,48,18,,,,,62,,,,28,46,,,
     ,,4,,,,,,44,34,,35,52,34]],
 [,[],[],[],[],[],[],[],[],[],[],[],[],[],[],
   [,,,,,,,,,,12],[,,,,,,,,,,,11,,13,,13],[,,,,,,,,,,,,14,22,,22],
   [,,,,,,,,,,10,12,16,,,,11,16],[,,,,,,,,,,18,22,24,,,,19,26],
   [,,,,,,,,,,,,14,,,,,14,16,24],[,,,,,,,,,,12,14,18,,,12,13,18,,,18],
   [,,,,,,,,,,22,,,,,46,26,,,,56],[],[,,,,,,,,,,,34,,,,,32,82,38,,64],
   [,,,,,,,,,,,,,24,,,,56,,,60],[,,,,,,,,,,,,,,,,,76,63,,78],[],[],[],
   [],[,,,,,,,,,,32,,64,,,73,33,,,,52,,,,18,,16],
   [,,,,,,,,,,,37,,80,,52,110,57,36,86,52,57,,,16,,12],[],
   [,,,,,,,,,,52,,,,,,66,,,126,120,,92,,,,,,,,,190],
   [,,,,,,,,,,,,,54,,,75,,81,144,114,130,,,,40],
   [,,,,,,,,,,52,70,94,,,80,63,94,,,94,88,122,,210,88,,,,,,,145,,38],
   [,,,,,,,,,,,84,102,54,,106,,,69,,136,,64,,86,40,60,,,,,86,60,,,20],
   [,,,,,,,,,,8,,,,,12,9,18,10,16,,12,20,,,,,,,,,29,36,,50,,52,54],
   [,,,,,,,,,,,,,,,,27,46,,,,,,,,,,,,,,16,16,,,,,48],
   [,,,,,,,,,,,,,,,,,16,19,27,17,23,,,,,,,,,,53,,,,,105],
   [,,,,,,,,,,,,,10,,,13,22,,,,,,,,8,,,,,,,20,,,20,38,20],
   [,,,,,,,,,,,,,,,,15,24,,21,,17,,,,,,,,,,84,55,,,,87,119],
   [,,,,,,,,,,8,10,14,,,12,9,14,10,,14,12,22,,27,26,42,,,,,29,28,,50,48,52,
     ,8,,17,,15],[,,,,,,,,,,,28,,,,,27,46,31,,,,20,,22,14,,,,,,22,21,,126,
     53,,54,,10],[,,,,,,,,,,8,10,20,12,,12,,,10,16,20,12,12,,14,8,12,,,,,
     14,12,,28,20,32,20,8,8,,4,14,8,8],
   [,,,,,,,,,,,,17,,,,,,19,27,17,23,61,,72,,,,,,,51,52,,118,142,105,,,,15,,23,
     17],[,,,,,,,,,,8,10,14,,,18,9,14,,,14,,20,,35,,,,,,,,36,,48,54,,54,8,,
     17,,,8,,8,17],[,,,,,,,,,,,,,,,,27,46,,,,,,,16,,16,,,,,,18,,128,59,,,,8,,,,
     ,10,8],[,,,,,,,,,,21,23,27,,,21,19,24,,,27,,42,,54,,,,,,,,,,,146,,137,
     21,,23,,,21,,18,25],
   [,,,,,,,,,,,31,,,,,27,46,28,,,,20,,22,14,,,,,,22,21,,,59,131,54,,10,,,,,8,8,
     ,,10],[,,,,,,,,,,,,17,,,,,16,19,27,,23,,,,,,,,,,53,,,120,,105,154,,,15,,,
     17,,,15,17,,23],[,,,,,,,,,,15,17,21,,,15,15,20,,,21,,50,,46,,,,,,,92,
     51,,116,119,,142,15,,19,,13,,,14,19,,,,,19],
   [,,,,,,,,,,68,,,,,,78,142,,164,140,124,128,,,,,,,,,,166,,272,,,222,66,,,,,66,
     108,36,144,64,108,151,142,152,136],
   [,,,,,,,,,,,,,74,,,88,126,92,162,140,132,,,,56,,,,,,203,115,,,140,,140,,,,28,
     ,64,68,28,,66,70,165,72,207],
   [,,,,,,,,,,64,84,114,,,96,75,114,145,,114,98,126,,,86,163,,,,,161,139,,284,
     244,304,206,64,108,125,40,105,64,,36,125,68,108,133,142,125,,46,40],
   [,,,,,,,,,,,89,134,74,,,,,89,158,,136,88,,114,56,84,,,,,114,84,,244,140,,
     140,,70,176,28,144,70,64,28,,64,64,185,64,166,,46,28,46],[],
   [,,,,,,,,,,56,85,114,70,,110,63,118,78,124,116,102,124,,,56,,,,,,155,,,,
     140,402,140,56,62,117,28,107,56,62,28,117,56,62,,62,117,105,48,28,,
     28],[,,,,,,,,,,38,,,,,65,40,76,48,,76,,22,,,,,,,,,28,24,,142,,166,106,
     35,,,,,37,26,18,87,35,22,71,22,91,67,190,,172,142,,154],
   [,,,,,,,,,,,,,44,,,,68,52,106,76,,,,,16,,,,,,26,20,,,80,150,80,,,,16,,42,25,
     16,162,40,22,,22,117,97,,112,156,112,,112],[],
   [,,,,,,,,,,,39,68,43,,55,,,41,103,,69,22,,24,16,20,,,,,24,20,,112,70,158,
     60,35,18,,15,,34,,12,,35,18,,18,87,56,126,96,130,84,,94,18,16],
   [,,,,,,,,,,38,45,,63,,65,38,68,,,66,69,22,,28,22,24,,,,,,,,158,,,106,37,
     22,66,21,80,35,26,18,66,35,,,22,68,82,166,154,182,142,,160,22,20,,18 
    ],[,,,,,,,,,,32,,68,40,,68,36,,48,72,68,76,32,,26,16,20,,,,,,,,136,80,,
     80,32,22,68,16,68,32,28,16,68,32,28,,22,68,68,176,112,176,112,,112,
     20,16,,16],[,,,,,,,,,,37,47,70,63,,61,33,70,,81,,63,30,,32,22,26,,,,,
     32,26,,146,104,160,116,31,22,63,21,49,30,24,16,76,31,22,55,,,63,158,
     136,164,,,134,22,20,,,22,20],
   [,,,,,,,,,,20,,,,,28,26,26,30,32,26,28,54,,,,,,,,,72,97,,128,,136,,20,,,,,
     20,88,20,31,24,60,35,,31,33,168,,164,162,,152,90,,,71,88,88,81],
   [,,,,,,,,,,,,,22,,,23,38,28,26,,22,,,,48,,,,,,69,77,,,118,148,114,,,,22,,18,
     90,20,,18,90,29,,,27,,150,158,150,,144,,84,,77,89,86,77],
   [,,,,,,,,,,20,24,26,,,26,19,26,24,,26,22,42,,56,36,,,,,,52,58,,94,88,94,
     92,18,48,33,16,33,14,,16,33,18,,31,48,33,,122,114,114,120,,110,64,64,
     ,57,68,64,53,20,18],
   [,,,,,,,,,,20,30,26,32,,28,,,30,32,26,28,58,,66,56,74,,,,,70,70,,132,122,
     136,120,20,54,30,26,32,20,54,20,,24,52,34,54,30,32,172,160,164,160,,
     152,90,92,,74,90,88,,20,28,20],
   [,,,,,,,,,,30,36,36,,,,29,38,,,36,,64,,97,60,,,,,,,90,,152,,,,26,70,41,28,
     41,24,,24,41,22,,,70,41,42,194,,216,210,,,103,104,,95,105,108,93,30,,
     24,32],[,,,,,,,,,,20,24,26,28,,26,19,26,24,26,26,22,,,60,40,70,,,,,
     54,,,,90,94,88,18,46,29,22,29,14,46,16,29,18,40,,46,29,25,126,116,
     114,116,,110,66,68,,56,68,64,60,20,18,14,20,26],
   [,,,,,,,,,,20,29,26,,,28,26,26,30,32,,28,58,,70,54,106,,,,,76,92,,128,,
     136,122,20,,31,,34,20,88,20,31,24,60,35,,,33,176,170,164,,,152,94,92,
     ,75,90,88,77,20,,20,20,30,20],
   [,,,,,,,,,,30,34,36,28,,32,27,34,37,,36,,68,,83,58,70,,,,,73,76,,168,128,
     ,122,28,74,51,28,49,,,24,51,24,80,50,74,51,,210,166,,162,,156,105,98,
     ,72,95,92,82,30,24,,28,,22,30],[],
   [,,,,,,,,,,,,,10,,,13,22,,,,,,,,8,,,,,,,20,,,20,38,20,,,,4,,,,4,,,,,,,,,28,40,
     28,,28,,16,,15,21,16,21,,22,16,26,28,22,,28],[],[]],
 [,[],[],[],[],[],[],[],[],[],[],[],[],[],[],[],
   [],[,,,,,,,,,,,,,,39],[],[],[],[,,,,,,,,,,,,,,,31],
   [,,,,,,,,,,,,,,,,,,,,,70],[,,,,,,,,,,,,,,,,,34,,,,30],
   [,,,,,,,,,,,34,,,,,,102,,,,81],[,,,,,,,,,,,,,15,,,,87,,,,87],
   [,,,,,,,,,,,,,,13,,,,,,,36],[,,,,,,,,,,,27,,,31,,,56,,,,46,6,,8],
   [,,,,,,,,,,,26,,,,,,36,,,,46,,8],[,,,,,,,,,,,34,,,,108,,110,,,,69,8,,10],
   [,,,,,,,,,,,26,,,19,,,52,,,,36,,8,,,,,8],
   [,,,,,,,,,,,37,,,,,,96,,,,93,,,8,,,8,,10],
   [,,,,,,,,,,,18,,18,14,38,,32,,,,32,6,8,8,,4,6,8,8,8,8],
   [,,,,,,,,,,,37,,,,,,110,,,,77,8,,10,,,,,8,,10,8],
   [,,,,,,,,,,,,,,,,,,,,,386,40,,,,,40,94,,124,54,28,53],
   [,,,,,,,,,,,,,72,,,,,,,,220,,,,25,,56,,83,,68,,83],[],
   [,,,,,,,,,,,159,,72,,276,,,,,,,32,44,44,25,20,32,44,44,44,44,20,44,38,23]
    ,[,,,,,,,,,,,,,,,,,,,,,,22,,,,,24,20,30,24,35,16,28,122],[],
   [,,,,,,,,,,,,,,,,,30,,,,47,,29,,,,65,29,,,75,32,,,,,198],
   [,,,,,,,,,,,,,14,,,,39,,,,,,,,15,,,22,51,,51,18,,,72,,72],[],
   [,,,,,,,,,,,26,,,19,,,,,,,,24,20,28,24,18,22,,,24,30,16,33,128,129,,104,20,
     ,,20],[],[,,,,,,,,,,,18,,15,13,31,,,,,,28,20,16,28,15,12,20,18,28,
     18,28,12,28,98,70,,60,16,,,15],
   [,,,,,,,,,,,,,50,60,54,,,,,,54,104,37,121,,61,,36,,52,79,38,116,342,272,,,,
     ,35,36],[],[],[,,,,,,,,,,,,,,,36,,56,,,,31,95,39,,84,,,39,95,,,38,,
     383,370,,260,,,37,,,37,,31],[],
   [,,,,,,,,,,,,,,,,,34,,,,,,36,,,,63,34,103,62,63,30,,,,,,,,29,,,,,,36,,,54],
   [],[,,,,,,,,,,,,,,,,,615,,,,472,52,,,,,52,138,71,100,69,36,69,286,,,,156,,,,
     ,156,,122,,,,410,,376],
   [,,,,,,,,,,,,,100,,,,338,,,,266,,,,35,,54,74,84,83,84,32,,,160,,154,,,,100,,
     146,,94,,,,333,,306],
   [,,,,,,,,,,,,,279,154,,,,,,,,56,114,,,46,58,,,114,80,40,,332,319,,315,,,376,
     196,,172,,142,,,,,,,,50,56],
   [,,,,,,,,,,,165,,100,100,,,,,,,,44,60,60,35,28,44,60,60,60,60,28,60,237,
     158,,140,136,,250,100,,,,84,,,,270,,,,46,31],[],
   [,,,,,,,,,,,170,,100,123,220,,226,,,,208,58,74,84,35,,60,74,78,83,78,,84,
     257,160,,154,129,,206,100,,133,,94,231,,,283,,218,,,31,56,31],
   [,,,,,,,,,,,,,,,,,105,,,,98,9,,,,,11,28,13,,11,10,13,59,,,49,33,,,,,33,,31,
     99,,,117,,77,,77,,81,67,,79],
   [,,,,,,,,,,,,,15,,,,61,,,,61,,,,5,,,,,,,6,,,25,,25,,,,15,,24,,15,,,,67,,,,,35,
     ,35,,35],[,,,,,,,,,,,39,,46,35,,,89,,,,74,11,28,13,,10,9,,,28,13,10,
     11,59,59,,49,35,,70,35,,33,,31,83,,,76,,86,,77,75,81,67,,77,11],
   [,,,,,,,,,,,23,,15,20,41,,,,,,39,9,11,11,5,7,9,11,11,11,11,6,11,37,25,,
     25,21,,42,15,,21,,15,,,,64,,42,,47,35,53,35,,35,9,5,9],
   [,,,,,,,,,,,42,,46,35,137,,87,,,,80,9,,11,,,11,28,13,,,10,13,57,61,,49,33,
     ,67,37,,35,,31,72,,,,,66,,75,75,83,67,,,9,,11,9],
   [,,,,,,,,,,,23,,15,23,33,,33,,,,33,9,11,11,5,7,9,11,11,11,11,,11,37,25,
     ,25,21,,37,15,,21,,15,36,,,47,,37,,47,35,53,35,,35,9,5,9,5,9],
   [,,,,,,,,,,,42,,,,,,105,,,,98,11,28,13,,10,9,,11,28,13,10,,57,61,,49,33,,,,
     ,33,,31,97,,,90,,,,75,79,,67,,79,11,,9,9,11,9],
   [,,,,,,,,,,,,,,,,,60,,,,64,62,,,,,62,,88,52,85,44,,328,,,,48,,,,,54,,42,68,,,
     67,,92,,404,,,330,,357,91,,91,55,89,51,89],
   [,,,,,,,,,,,,,38,,,,55,,,,49,,,,45,,,46,92,55,113,40,98,,192,,182,,,,38,,,,
     39,62,,,58,,,,,260,431,250,,252,,41,89,43,91,39,89],
   [,,,,,,,,,,,62,,,47,82,,64,,,,,56,40,73,59,44,50,,,40,69,32,75,280,257,,
     230,48,,,50,,42,,,72,,,65,,,,348,311,384,310,,264,77,55,71,45,73,41,
     79,54,48],[,,,,,,,,,,,62,,43,39,57,,,,,,50,54,40,74,45,34,54,44,74,
     42,74,36,74,272,190,,168,48,,49,43,,54,,32,,,,61,,55,,342,254,,232,,
     246,81,41,81,43,81,39,81,44,39,44],[],
   [,,,,,,,,,,,52,,38,41,56,,60,,,,50,58,38,82,41,38,56,34,82,,85,,82,247,
     162,,158,46,,59,38,,45,,32,67,,,,,66,,301,214,366,204,,192,77,37,75,
     33,73,29,77,48,35,40,35],[],
   [,,,,,,,,,,,62,,38,37,53,,52,,,,,52,40,74,45,34,52,40,74,48,74,36,74,,
     188,,168,52,,52,38,,52,,36,62,,,54,,,,350,254,396,232,,244,81,41,81,
     43,81,39,81,48,35,,36,,35],
   [,,,,,,,,,,,,,,13,,,,,,,36,,,,,4,,,,,,4,,,,,20,,,,,,18,,12,61,,,,,,,,,46,28,,,,,
     10,7,,7,10,,,44,34,,38,,34],[],
   [,,,,,,,,,,,,,15,,,,61,,,,61,,,,5,,,,,,,6,,,25,,25,,,,15,,24,,15,,,,67,,,,,35,
     ,35,,35,,5,,5,,5,,,41,55,41,,37,,41],[],[]],
 [,[],[],[],[],[],[],[],[],[],[],[],[],
   [,,,,,,,,,,,10,12],[,,,,,,,,,,,11,13],[,,,,,,,,,,,16,18],[],
   [,,,,,,,,,,,,,16,17,22],[,,,,,,,,,,,12,14,,11,,,20],
   [,,,,,,,,,,,16,18,,,14,,24],[,,,,,,,,,,,,12,12,13,,,,,24],
   [,,,,,,,,,,,16,18,,,14,,22,,14],[],[],[],[,,,,,,,,,,,,44,20,,,,42],
   [,,,,,,,,,,,38,44,,31,,,,34,62,114,66],
   [,,,,,,,,,,,,28,20,24,36,,,27,36,42,36],[],
   [,,,,,,,,,,,32,45,,33,46,,,62,48,,66],[],[],
   [,,,,,,,,,,,37,44,132,,76,,64,36,52,58,53,,,,,12,,,16],
   [,,,,,,,,,,,,53,,39,62,,,38,52,,,,,,,16,,,18],[],
   [,,,,,,,,,,,,98,48,,,,,72,106,,102,,,,40],[],
   [,,,,,,,,,,,,,48,,98,,,84,112,92,,,,,40,60,64,,84,,,60,84,,20],
   [,,,,,,,,,,,,,8,9,14,,14,10,14,,14,,,,26,24,22,,27,,,28,27],
   [,,,,,,,,,,,,,28,27,42,,,,,,46,,,,,24,20,,22,,,21,22,,59],
   [,,,,,,,,,,,,,14,15,20,,,17,21,15,20,,,,,55,33,,54,,,51,,,118],
   [,,,,,,,,,,,10,12,8,,,,16,10,20,12,,,,,8,,12,,14,,,20,14,,20,,20,8,8,14],
   [,,,,,,,,,,,19,21,,,,,37,,17,25,16,,,,,,40,,51,,,60,51,,,,136,17,,19],
   [,,,,,,,,,,,10,12,8,9,14,,,10,14,12,14,,,,,30,20,,,,,36,35,,54,,50,8,,,8,
     17],[,,,,,,,,,,,28,,28,27,42,,,31,,,46,,,,14,20,,,,,,16,16,,53,,50,,10,
     ,8],[,,,,,,,,,,,,,12,13,22,,,,,,22,,,,8,12,14,,17,,,12,17,,20,,20,,,,4 
    ],[,,,,,,,,,,,,,18,19,24,,,23,27,,24,,,,,62,50,,70,,,,,,140,,,,,,18,23,21 
    ],[,,,,,,,,,,,10,12,8,9,18,,18,,,12,18,,,,26,24,20,,29,,,28,27,,54,,
     52,8,,15,8,,8,,,21],
   [,,,,,,,,,,,,,28,27,42,,,,,,46,,,,,24,20,,22,,,21,22,,53,,52,,8,,8,,,10],
   [,,,,,,,,,,,19,21,,,16,,37,,,25,16,,,,,,40,,53,,,53,53,,,,,17,,19,,15,17,,,
     25],[,,,,,,,,,,,31,,28,27,42,,,28,,,46,,,,14,16,,,16,,,18,,,,,48,,10,,8,
     ,,8,,,,10],[,,,,,,,,,,,,15,14,15,24,,,,,,24,,,,,50,38,,56,,,55,,,,,118,,
     ,13,14,,15,,,,,,23],
   [,,,,,,,,,,,19,21,,,16,,37,,17,25,,,,,,,40,,53,,,57,51,,152,,142,17,,19,,
     15,17,,,23,,,15],[],
   [,,,,,,,,,,,96,,64,,,,124,,144,124,,,,,56,,120,,167,,,103,,,140,,140,64,71,
     177,28,,66,71,28,,,71,195,74,178,189],
   [,,,,,,,,,,,,100,68,81,122,,,90,122,98,122,,,,104,214,132,,,,,158,,,338,,
     256,74,120,120,40,135,68,,46,144,68,128,135,,,135],
   [,,,,,,,,,,,,,64,90,,,,88,128,140,124,,,,56,84,88,,112,,,84,112,,140,,140,,,
     ,28,194,64,64,28,,64,64,168,68,164,,,28,48],
   [,,,,,,,,,,,92,112,64,84,146,,136,,,132,,,,,86,164,116,,188,,,153,160,,,,
     226,64,104,140,36,150,66,142,46,,66,,,150,138,146,,,46,40],
   [,,,,,,,,,,,,92,56,63,110,,,78,108,116,114,,,,56,,,,158,,,,170,,140,,140,56,
     64,101,28,113,56,64,28,,56,64,113,64,111,113,,28,48,28],
   [,,,,,,,,,,,,,38,31,60,,55,39,,65,62,,,,22,28,30,,32,,,26,32,,108,,,28,,,
     18,53,31,22,,,30,24,55,22,57,57,,136,194,,162,140],
   [,,,,,,,,,,,,64,40,,,,70,52,104,,78,,,,16,,,,,,,20,26,,80,,80,42,22,,16,,,
     25,16,122,40,,129,22,97,117,,112,180,112,158,112,20],
   [,,,,,,,,,,,,51,36,40,62,,77,43,62,53,60,,,,,,22,,,,,24,28,,,,104,37,22,
     58,20,64,35,,21,75,35,26,66,22,63,66,,152,202,140,176,,22],
   [,,,,,,,,,,,,,38,,60,,,41,74,59,80,,,,16,20,22,,24,,,20,24,,70,,60,,,,14,,
     35,18,12,,34,18,,18,56,94,,94,156,84,134,96,,16,18],[],
   [,,,,,,,,,,,48,56,32,36,68,,80,,66,64,,,,,16,20,32,,26,,,,,,80,,80,32,22,,
     16,68,32,22,16,,32,28,68,28,,68,,112,200,112,156,112,20,16,20,16],
   [,,,,,,,,,,,43,61,,,70,,63,,66,,68,,,,22,24,22,,28,,,,,,122,,104,35,22,82,
     20,64,35,22,21,77,37,26,68,,,66,,,,140,174,162,22,20,22,18],[],
   [,,,,,,,,,,,30,28,20,,,,30,30,26,28,26,,,,54,,52,,74,,,102,86,,122,,118,
     24,56,32,20,,20,58,24,34,20,58,30,56,32,30,,160,176,158,172,148,82,
     90,88,76,,88,88],
   [,,,,,,,,,,,24,22,20,19,26,,,24,26,26,26,,,,42,60,36,,,,,55,52,,92,,86,
     18,48,34,16,33,14,,16,31,18,,33,48,33,33,,126,122,114,120,106,59,68,
     62,53,,64,68,,20],
   [,,,,,,,,,,,,,28,27,34,,,34,36,,34,,,,58,68,62,,75,,,76,77,,128,,120,,,,24,
     51,24,78,22,,28,74,51,,,51,,162,194,160,,152,,98,97,72,,92,97,,28,24]
    ,[,,,,,,,,,,,30,28,20,26,26,,30,,,28,26,,,,66,74,52,,72,,,91,76,,,,130,
     24,60,33,20,31,20,88,24,35,20,,,60,34,31,,178,176,160,166,148,75,98,
     88,75,,88,90,,20,20,30],
   [,,,,,,,,,,,24,22,20,19,26,,24,24,26,26,26,,,,36,66,36,,54,,,,,,88,,90,
     18,46,25,16,29,14,46,22,,18,40,29,46,29,29,,118,122,116,128,106,62,
     64,62,58,,64,68,,20,14,22,20],
   [,,,,,,,,,,,27,22,,23,,,24,,42,,,,,,48,64,50,,85,,,71,,,,,,18,,27,20,43,18,
     88,,30,26,60,43,,,43,,,,168,186,150,,84,79,73,,96,101,,,18,,30,18],
   [,,,,,,,,,,,30,28,20,25,26,,30,30,26,28,,,,,56,68,52,,72,,,72,72,,118,,
     116,24,52,32,20,30,20,54,24,34,20,54,30,52,32,,,162,176,156,164,148,
     84,96,86,68,,88,92,,20,20,28,20,20],[],
   [,,,,,,,,,,,,,12,13,22,,,,,,22,,,,8,12,14,,17,,,12,17,,20,,20,,,,4,,,,4,,,,,,
     ,,,28,46,28,46,28,,16,21,12,,16,21,,24,16,22,24,22,,24],[],[],
   [,,,,,,,,,,,13,16,12,,16,,18,13,22,16,16,,,,8,20,,,,,,,,,20,,20,10,10,17,
     4,17,10,10,4,19,10,10,19,10,17,17,,28,46,28,,28,21,16,,15,,16,21,,
     24,18,26,30,18,24,26,,4],[]],
 [,[],[],[],[],[],[],[],[],[],[],[],[],
   [,,,,,,,,,,,22,48],[,,,,,,,,,,,27,38],[,,,,,,,,,,,30,50],
   [,,,,,,,,,,,,,17,22,25],[,,,,,,,,,,,,,23,28,31],
   [,,,,,,,,,,,24,46,,,,20,26],[,,,,,,,,,,,46,48,,,,40,46],
   [,,,,,,,,,,,,,48,37,50,,,46,56],[,,,,,,,,,,,26,48,,,23,22,28,,,48],[],
   [],[],[,,,,,,,,,,,,,15,,,,45,27,,,51],[,,,,,,,,,,,33,,,23,,,30,,,66,68],
   [],[],[],[],[],
   [,,,,,,,,,,,33,88,29,29,52,41,40,33,88,88,42,,,,,7],[],
   [,,,,,,,,,,,,,,,,,,,544,517],[,,,,,,,,,,,,,72,,,,,169,543,408,,,,,25,,,,,,,,,42 
    ],[,,,,,,,,,,,206,,,,464,,256,,442,,,,,,52,66,,,,,,,,48],
   [,,,,,,,,,,,,,72,,222,,,129,380,,,,,,25,32,,,,,,32,,,23,38],
   [,,,,,,,,,,,,,20,23,28,,,22,40,,24,,,,,30,,,,,,30,,142,115,142],[],
   [,,,,,,,,,,,,,32,33,34,,,34,52,,34,,,,,36,,,,,,50,,,195,255],
   [,,,,,,,,,,,22,38,14,,,17,23,,,38,,,,,15,,,,,,,25,,164,72,172,72,20,,27],
   [,,,,,,,,,,,32,41,,,,27,33,,,42,28,,,,,,,,,,,62,,437,,,185,28,,40],[],
   [],[,,,,,,,,,,,,,15,18,23,,,18,34,,20,,,,15,20,,,,,,20,,,70,132,60,,,,15,
     23],[,,,,,,,,,,,,,26,28,34,,,29,45,37,30,,,,,44,,,,,,63,,,213,192,,,,,
     26,33],[,,,,,,,,,,,22,40,,,,18,24,,,40,,,,,24,,,,,,,30,,,135,,110,20,,32,
     ,,,,16,27],[],[,,,,,,,,,,,34,52,,,28,28,34,,,52,26,,,,55,,,,,,,49,,
     555,224,289,207,32,,34,,,,,26,39],[],
   [,,,,,,,,,,,,,26,33,35,,26,34,52,,34,,,,,36,,,,,,45,,337,,,182,,,31,26,40,,,,
     ,32,,37],[,,,,,,,,,,,29,45,,,26,25,31,,37,45,,,,,,,,,,,,63,,270,,256,
     178,27,,39,,25,,,23,29,,,,,39],
   [,,,,,,,,,,,,,250,,,,,,,699,,,,,62,78,,,,,,,,353,317,420,,162,,,162,,,,,,199,,
     380,,467],[,,,,,,,,,,,175,,100,,,130,208,182,436,487,,,,,35,,,,,,,50,,
     325,160,,154,150,,244,100,,,,94,,147,,235,,249,224],
   [,,,,,,,,,,,284,680,,,302,186,282,312,,,,,,,,78,,,,,,78,,374,,353,315,194,,
     279,,274,,,144,258,176,,299,,288,234,56,50],
   [,,,,,,,,,,,,,100,142,,,,165,420,446,,,,,35,44,,,,,,44,,,158,418,140,,,,100,
     225,,,84,,,,263,,260,,,31,46],
   [,,,,,,,,,,,,597,,267,404,,446,,,611,392,,,,62,,,,,,,78,,,,,262,,,,172,318,,,
     132,312,162,,,,387,325,48,50,,46],
   [,,,,,,,,,,,,,100,,160,128,154,,,378,154,,,,35,,,,,,,,,,160,325,154,130,,206,
     100,176,,,94,180,134,,,,202,171,50,31,,31],
   [,,,,,,,,,,,,,36,35,58,,,34,,70,60,,,,11,12,,,,,,12,,57,51,57,,28,,,30,,,,,,
     30,,61,,56,61,73,67,73,,78,67],
   [,,,,,,,,,,,23,51,15,,,,33,23,51,51,33,,,,5,,,,,,,6,,43,25,43,25,21,,,15,,,
     ,15,39,21,,38,,45,49,53,35,53,35,53,35,9],
   [,,,,,,,,,,,34,60,36,40,46,28,69,35,60,56,46,,,,11,12,,,,,,12,,57,51,57,
     52,31,,47,30,44,,,,56,31,,46,,53,56,73,67,73,,71,67,10,9],
   [,,,,,,,,,,,,,14,,36,,,21,,,38,,,,5,6,,,,,,6,,,22,,20,,,,14,,,,12,,18,,37,,,
     31,,30,,28,46,30,,5],
   [,,,,,,,,,,,34,,36,31,54,33,,,,72,58,,,,11,12,,,,,,12,,,51,55,,30,,61,30,
     57,,,,61,28,,,,59,,78,67,71,68,73,67,8,9,10],
   [,,,,,,,,,,,23,43,15,24,25,27,25,23,43,43,25,,,,5,6,,,,,,,,43,25,43,25,
     21,,32,15,33,,,15,33,21,,32,,32,33,53,35,53,35,53,35,9,5,9,5,9],
   [,,,,,,,,,,,37,70,36,,60,31,,34,72,,62,,,,11,12,,,,,,12,,55,51,62,58,31,,
     56,30,69,,,,,31,,59,,,61,71,67,,,77,67,10,9,8,,10,9],
   [,,,,,,,,,,,,,64,63,74,,,70,100,,68,,,,72,,,,,,,88,,397,313,,,56,,,58,66,,,,,
     60,,80,,,67,460,383,542,,,,79,57,73,,84,53,77],
   [,,,,,,,,,,,54,94,34,,,45,51,,,94,,,,,45,,,,,,,60,,369,184,385,174,48,,63,
     34,,,,39,56,,,63,,62,56,417,244,,234,430,220,73,39,67,36,73,35,73,58]
    ,[],[,,,,,,,,,,,,,43,54,55,,,50,90,,48,,,,45,54,,,,,,54,,,182,,160,,,,
     43,57,,,28,,44,,62,,64,53,,238,404,216,,214,,39,68,34,,35,74,,39],
   [,,,,,,,,,,,70,100,,,,60,66,,,92,,,,,72,78,,,,,,88,,696,398,,304,60,,80,,,,,
     50,67,56,,,,80,69,,422,,,460,,84,57,71,,79,53,79,56,,,54],
   [,,,,,,,,,,,48,110,34,51,46,38,44,48,110,110,44,,,,35,49,,,,,,,,333,140,,
     134,42,,65,34,58,,,32,55,42,,65,,65,55,,184,330,178,,160,58,29,52,28,
     58,25,58,56,31,,31,56],
   [,,,,,,,,,,,136,,64,64,74,69,,70,92,,68,,,,72,88,,,,,,88,,436,,,304,74,,,
     58,65,,,46,69,60,,80,,,67,610,417,,380,737,480,77,57,78,52,79,53,79,,
     58,,,64,56],[,,,,,,,,,,,50,92,34,61,,42,48,,,92,,,,,45,42,,,,,,52,,,
     180,372,160,44,,62,34,80,,,36,52,58,,66,,62,,592,238,,216,406,212,68,
     39,62,34,68,35,68,56,31,,36,,31,56],[],[],
   [,,,,,,,,,,,,,14,,36,,,21,,,38,,,,5,6,,,,,,6,,,22,,20,,,,14,,,,12,,18,,37,,,
     31,,30,,28,46,30,,5,,4,,5,,,36,,34,,28,52,34],
   [,,,,,,,,,,,21,50,,27,38,15,26,21,50,50,26,,,,,,,,,,,,,44,32,44,20,18,,41,
     21,32,,,12,27,18,,41,,41,27,52,40,52,28,52,40,10,7,10,4,10,7,10,
     58,46,,34,58,,58,34,,,4],[],
   [,,,,,,,,,,,27,,15,25,33,,39,,,,33,,,,5,,,,,,,6,,52,25,,25,24,,44,15,,,,15,,
     ,,,,44,,62,35,,35,,35,11,5,11,5,11,5,11,68,41,,41,,31,,41,,,5],[] 
  ],[,[],[],[],[],[],[],[],[],[],[],[],[],[],[],
   [],[,,,,,,,,,,,,,,17],[,,,,,,,,,,,,,,,55],[,,,,,,,,,,,,,,23],[],[],
   [,,,,,,,,,,,,,,,35,,52],[,,,,,,,,,,,,,,,80,39,50,29,,,52],
   [,,,,,,,,,,,,,,,,,36,26,,,40],[,,,,,,,,,,,,,,41,95,45,102,37,,,93],
   [,,,,,,,,,,,,,15,,,,45,27,,,51],[,,,,,,,,,,,,,,,,22,28,18,,,52,6,8,8],
   [,,,,,,,,,,,,,,28,,,50,27,,,58,6,,8,,6],
   [,,,,,,,,,,,,,,,46,40,52,26,,,38,,8,,,8],
   [,,,,,,,,,,,,,,,,49,74,35,,,101,8,,10,,8],
   [,,,,,,,,,,,,,,21,40,32,40,,,,28,,8,,,8,,8],
   [,,,,,,,,,,,,,,,,,102,34,,,105,,,8,,8,8,,10],
   [,,,,,,,,,,,,,,18,,21,,21,,,32,,,,,4],
   [,,,,,,,,,,,,,,36,,45,102,34,,,85,8,,10,,8,,,8,,10],
   [,,,,,,,,,,,,,,,,195,,,,,,46,,,,32,44,108,,,,,59],
   [,,,,,,,,,,,,,72,,,101,,,,,238,42,58,,25,,,58],
   [,,,,,,,,,,,,,157,132,,,,,,,,40,122,58,52,28,40,,,130,53,,55,42,48],
   [,,,,,,,,,,,,,72,,234,,,,,,,32,44,44,25,20,32,44,44,44,44,20,44,40,23],
   [],[],[,,,,,,,,,,,,,,56,51,,50,,,,55,,56,,,40,68,47,85,39,,,,,,408,385],
   [,,,,,,,,,,,,,14,,,21,33,22,,,,,,51,15,,,,,22,51,21,51,154,72,121,72,,,43],
   [,,,,,,,,,,,,,,,,44,58,,,,34,57,52,79,,,,36,,37,115,,,,,,255],
   [,,,,,,,,,,,,,,,,20,,26,,,,24,24,30,,16,22,,,20,28,18,35,151,,128,,,,53],
   [],[,,,,,,,,,,,,,15,15,39,,,,,,,20,18,28,15,12,20,16,28,18,28,12,28,
     126,70,106,60,,,,15,,16],[],
   [,,,,,,,,,,,,,,19,,24,,,,,,22,24,35,24,16,24,20,30,,,18,28,,,,106,,,,20,,20 
    ],[],[,,,,,,,,,,,,,,,35,40,,,,,31,43,62,66,55,,63,30,103,30,,32,67,,
     461,,,,,53,,36,,,31],[],
   [,,,,,,,,,,,,,50,39,48,,32,,,,,,,,,34,,39,95,35,,,,,,,202,,,44,36,55,37,,,,,,
     54],[,,,,,,,,,,,,,,,37,46,58,,,,,61,52,,,,,42,,52,122,41,79,692,223,403,
     ,,,64,,33,,,,,,,36],
   [,,,,,,,,,,,,,211,175,,180,620,,,,432,52,,,62,36,52,146,71,110,80,,71,345,
     250,278,216,,,,162,,,,116,,158,,,,408],
   [,,,,,,,,,,,,,100,,,133,322,209,,,302,,74,81,35,,60,83,,74,96,40,,329,160,
     243,154,,,,100,,147,,94,,163,,296,,420,296,50],[],
   [,,,,,,,,,,,,,100,122,,,,165,,,322,44,60,60,35,28,44,60,60,60,60,28,60,,
     158,,140,,,,100,263,,,84,,140,,299,,345,,46,31],
   [,,,,,,,,,,,,,207,174,,,,,,,598,52,138,71,62,36,52,,73,,,,71,,,,,,,,147,397,
     158,,134,,158,,,,437,423,46,50,,46],
   [,,,,,,,,,,,,,100,,232,128,230,161,,,226,,,,35,,60,83,,83,,,84,,160,,154,,,,
     100,223,133,,94,,132,,215,,283,225,,31,,31],
   [,,,,,,,,,,,,,46,44,77,49,83,42,,,90,9,,,11,10,11,28,13,,11,,13,63,61,
     59,49,,,,37,80,35,,31,,33,,67,,91,71,75,,,67,77],
   [,,,,,,,,,,,,,15,,,,41,23,,,41,9,11,11,5,,9,11,11,11,11,7,11,43,25,37,
     25,,,,15,,21,,15,,21,,43,,78,49,47,35,,35,47,35,9],
   [,,,,,,,,,,,,,46,36,79,,79,40,,,96,11,28,13,11,10,9,,,28,13,10,11,63,,
     59,49,,,84,35,,33,,31,,35,,70,,78,85,75,76,,67,77,77,11,9],
   [,,,,,,,,,,,,,15,18,45,,,23,,,41,9,11,11,5,6,9,11,11,11,11,7,11,43,25,
     37,25,,,52,15,,21,,15,,21,,42,,,51,47,35,,35,47,35,9,5,9],
   [,,,,,,,,,,,,,,,89,45,97,,,,114,9,,11,11,10,11,28,13,,,,13,,,57,49,,,149,,
     121,33,,31,,33,,,,92,97,77,82,,67,75,75,9,9,11,9],
   [,,,,,,,,,,,,,15,,37,25,39,27,,,37,,,,5,6,,,,,,,,,25,52,25,,,,15,41,24,,15,
     ,24,,41,,,41,,35,,35,53,35,,5,,5],
   [,,,,,,,,,,,,,46,,77,48,81,39,,,90,11,28,13,11,10,9,,11,28,13,10,,65,61,
     57,49,,,102,37,81,33,,31,,33,,66,,,72,87,82,,67,75,79,11,9,9,9,11],
   [,,,,,,,,,,,,,,64,,60,84,78,,,66,62,,,72,44,62,,83,52,85,,,401,278,312,246,
     ,,,63,140,54,,46,,64,,64,,62,80,400,365,,330,404,,89,55,89,55,91,,91]
    ,[,,,,,,,,,,,,,38,,,57,57,75,,,51,64,,95,45,,64,46,95,46,110,46,110,,
     192,286,182,,,,38,,58,,39,,58,,55,,59,61,376,260,,250,359,252,90,43,
     90,43,90,41,96],[,,,,,,,,,,,,,,50,,51,,62,,,64,50,36,71,,36,50,,,40,
     73,38,69,353,280,274,,,,79,,,42,,40,,48,,,,65,72,,313,,302,352,264,73,
     45,73,45,77,49,71,48,54],
   [,,,,,,,,,,,,,43,,67,,,,,,52,54,40,74,45,36,54,46,74,42,74,34,74,367,190,
     292,168,,,67,43,72,54,,32,,,,61,,51,62,344,254,,232,,246,81,43,81,43,
     81,41,81,50,39,50],
   [,,,,,,,,,,,,,,64,106,63,,,,,60,62,52,85,72,40,62,56,88,,,46,83,,354,336,
     262,,,79,59,94,56,,,,48,,,,63,68,400,356,,325,396,341,91,55,91,55,89,,
     89,48,54,54],[,,,,,,,,,,,,,38,41,62,48,56,52,,,60,,,,35,32,56,34,82,
     38,82,,85,,160,290,156,,,,34,67,45,,36,,46,,62,,65,67,,216,,204,316,
     192,,33,71,33,77,31,71,,35,40,35,48],
   [,,,,,,,,,,,,,67,65,111,61,84,78,,,,62,80,83,72,44,62,,83,48,85,,,374,
     280,328,,,,77,63,110,56,,46,,64,,66,,,98,396,360,,376,410,352,89,55,
     89,55,91,59,91,48,58,50,50,52,48],
   [,,,,,,,,,,,,,38,52,59,58,,62,,,,52,44,74,45,32,52,44,74,44,74,34,74,
     396,188,270,168,,,70,38,62,56,,36,,48,,52,,58,,350,254,,232,348,244,
     81,43,81,43,81,41,81,48,35,44,36,44,35],
   [,,,,,,,,,,,,,,18,,21,,21,,,32,,,,,4,,,,,,4,,,,,20,,,,21,,18,,12,,18,,32,,,41,
     ,40,,28,,,,7,10,7,,,10,,46,38,34,46,,,34],[],
   [,,,,,,,,,,,,,15,,37,25,39,27,,,37,,,,5,6,,,,,,,,,25,52,25,,,,15,41,24,,15,
     ,24,,41,,,41,,35,,35,53,35,,5,,5,,5,,,41,49,41,,31,59,41],[],[],
   [,,,,,,,,,,,,,14,16,46,,,,,,,7,10,10,5,4,7,10,10,10,10,4,10,38,22,,20,,,
     58,14,,18,,12,,,,,,,,40,30,,28,,30,11,5,11,5,11,5,11,46,36,44,34,,34,
     ,34,4,,5],[],[,,,,,,,,,,,,,15,20,,27,37,27,,,43,,,,5,6,,,,,,,,,25,
     52,25,,,50,15,53,,,15,,24,,44,,,,62,35,,35,62,35,11,5,11,5,11,5,11,
     68,41,,41,68,31,68,41,,,5,,,5]],
 [,[],[],[],[],[],[],[,,,,,13],[,,,,21,,27],[],[],[],[],
   [,,,,,16,32,16],[,,,,,,36,14],[,,,,,24,32,19],[],[],
   [,,,,,15,29,,,,,,,,7],[,,,,,,,14,,,,,,,,8],[],
   [,,,,,24,40,16,,,,,,,,8,,,,8],[],[],[],[],
   [,,,,,24,44,24,,,,,,,17,,,,18,54],
   [,,,,,,,27,29,,,,,20,22,28,,,22,27,,27,,,,,21],
   [,,,,,,,18,,,,,,17,,27,,,17,,,25,,,,,17],
   [,,,,21,,,44,35,,,,,32,,,,,36,51,,,,,,,30],
   [,,,,,18,,,,,,,,17,14,20,,,,,,21,,,,,17,,14],
   [,,,,29,36,35,,,,,,,29,,73,,,23,,,85,,,,,27,22,,28],
   [,,,,,22,,22,,,,,,,,,,,17,44,,,,,,,,,15,31,15],[],[],
   [,,,,105,,150,,167,,,,,,,,,,53,92,,80,,,,,,98,75,142,82,138],
   [,,,,,,,70,321,,,,,25,32,37,,,32,37,,37,,,,,100,77,,,122,126,113,,,27],
   [,,,,,71,129,,138,,,,,34,,77,,,41,,,,,,,,97,105,71,,71,141,80,,,32,24],
   [],[],[],[,,,,,12,24,12,,,,,,5,,,,,6,15,,,,,,,,18,14,27,14,24,,,,,25,
     34],[,,,,,16,,22,,,,,,,,,,,,7,,7,,,,,,23,24,,,69,,,,,30],
   [,,,,,,,11,,,,,,5,6,7,,,6,7,,7,,,,,17,16,,,14,22,16,,,24,20,25,,,,5,6],
   [],[],[],[,,,,14,11,27,,,,,,,5,6,15,,,,,,15,,,,,17,18,14,22,,,16,,,
     35,25,31,,,,5,,5],[],
   [,,,,,16,26,,,,,,,,,7,,,,,,7,,,,,,23,20,50,18,,,,,,30,61,,,,,6,6],[],
   [],[,,,,,16,,14,,,,,,,,7,,,,7,,,,,,,,23,24,47,40,,,,,,30,,,,,,6,6,,,,,,6],
   [],[,,,,117,91,,100,188,,,,,,,,,,63,82,,,,,,,,120,99,175,101,189,143,,,
     202,169,195,,,,,,32,,,,,,73,,,70],
   [,,,,,,,,,,,,,35,44,51,,,44,51,,51,,,,,124,107,,,124,162,125,,,,140,172,,,,
     35,42,28,,,,35,,42,,,42,,33],
   [,,,,,,171,88,,,,,,44,57,,,,53,73,,73,,,,,113,140,95,,95,171,99,,,195,171,,,
     ,,44,67,32,,,,44,,67,,,,,40,32],[],
   [,,,,103,80,176,76,160,,,,,35,42,51,,,42,51,,51,,,,,,107,90,160,93,164,,,,
     176,140,,,,,35,42,28,,,,35,,42,,,42,,33,28],[],
   [,,,,41,35,48,35,,,,,,,,,,,27,57,,,,,,,,30,26,33,26,38,31,,,118,138,134,,,,,
     ,26,,,,26,,,,,79,,158,175,174,,166],
   [,,,,,,,42,42,,,,,28,28,36,,,28,38,,38,,,,,30,22,,,34,34,,,,141,121,117,,,,
     25,33,24,,,,25,,36,,,40,,176,164,160,,169,,28],
   [,,,,,25,40,25,46,,,,,20,20,,,,20,41,,43,,,,,25,24,20,,20,,21,,,93,96,83,,
     ,,20,,19,,,,19,,39,,,42,,123,125,113,,,,21,23],
   [,,,,35,,40,,,,,,,33,28,52,,,,,,,,,,,34,28,40,33,,,31,,,148,136,123,,,,29,
     56,25,,,,24,,,,,59,,188,174,167,,174,,29,27,24],
   [,,,,40,34,45,34,66,,,,,26,32,34,,,27,39,,35,,,,,26,28,26,33,26,,,,,142,
     123,,,,,26,35,26,,,,26,,32,,,35,,166,162,,,148,,,27,,25],
   [,,,,37,36,34,,48,,,,,28,,52,,,27,,,48,,,,,30,24,,27,36,38,31,,,137,124,
     116,,,,25,,25,,,,24,,44,,,50,,193,163,162,,175,,27,21,23,28,28],[],
   [,,,,51,35,68,35,74,,,,,15,,,,,20,18,,18,,,,,,49,40,71,40,69,,,,82,67,76,,
     ,,15,,13,,,,15,,15,,,15,,108,93,102,,93,,71,69,49,75,64,70],
   [,,,,,,,28,56,,,,,15,16,17,,,16,17,,17,,,,,44,39,,,34,59,41,,,66,50,66,,,,
     13,14,10,,,,13,,14,,,14,,,70,85,,70,,66,59,49,66,62,62,,13],
   [,,,,53,28,,30,62,,,,,18,19,20,,,19,20,,20,,,,,41,,36,68,32,68,38,,,84,
     71,81,,,,16,17,,,,,16,,17,,,17,,108,96,105,,,,77,59,46,64,,62,,15,12],
   [,,,,52,,102,,,,,,,15,20,18,,,,,,18,,,,,48,50,54,74,,,44,,,79,67,77,,,,15,
     15,13,,,,15,,,,,15,,105,93,106,,93,,69,67,51,70,69,66,,14,13,15],
   [,,,,50,28,,26,70,,,,,15,16,17,,,16,17,,17,,,,,50,39,38,65,36,65,,,,70,
     50,,,,,13,14,10,,,,13,,14,,,14,,87,70,,,70,,69,58,,64,54,63,,13,10,,13 
    ],[,,,,,27,,29,72,,,,,18,19,20,,,19,20,,20,,,,,49,47,,71,37,68,55,,,
     85,72,79,,,,16,17,13,,,,16,,17,,,17,,103,98,103,,100,,72,64,56,66,,72,
     ,15,,14,15,12],[,,,,,35,,34,,,,,,15,21,18,,,20,18,,,,,,,48,50,39,,39,
     69,40,,,,67,78,,,,15,15,13,,,,15,,15,,,,,105,93,104,,93,,65,66,47,75,
     65,66,,14,13,15,14,13,15],
   [,,,,,,,,,,,,,,12,,,,16,25,,17,,,,,15,,,,,,13,,,58,,53,,,,12,22,,,,,14,,16,,,
     20,,78,90,73,,74,,23,24,17,,22,24,,35,,26,37,28,,31],[],[],
   [,,,,,,,,,,,,,,,,,,,,,,,,,,,,,46,19,33,,,,72,,,,,,12,,,,,,,,39,,,,,94,123,105,,
     83,,25,29,18,33,25,29,,38,42,38,,37,37,40],
   [,,,,,,,,,,,,,,,,,,13,21,,17,,,,,,,,,,33,,,,,63,68,,,,,13,11,,,,11,,17,,,13,,,
     75,86,,63,,,,,46,36,31,,,27,25,35,23,26,45],
   [,,,,,,,,,,,,,,16,,,,,,,,,,,,15,25,22,39,34,36,14,,,,,83,,,,,,,,,,,,74,,,,,,,,,
     118,,,34,20,35,23,34,,,,41,,50,,,15],
   [,,,,,,,,,,,,,14,15,24,,,,,,24,,,,,40,39,,44,,,,,,96,,,,,,14,,,,,,,,23,,,,,,,,,,
     ,58,54,,,,53,,36,,,42,,37,36,,,,,13],
   [,,,,,,,,,,,,,20,29,30,,,29,53,,28,,,,,27,,,,,,,,,,,,,,,20,38,,,,,27,,31,,,37,
     ,150,304,,,,,22,31,,37,,35,,54,,,75,,,54,,,,,,23],
   [,,,,,,,,,,,,,20,19,44,,,,,,,,,,,14,,17,41,19,,13,,,,121,70,,,,20,,19,,,,,,38,
     ,,,,128,,100,,,,22,,18,35,,35,,45,47,38,52,,57,40,13]],
 [,[],[],[],[],[],[],[,,,,,16],[],[],[],[],[],
   [,,,,,28,,28],[,,,,,,70,24],[,,,,,42,56,24],[],[],
   [,,,,,19,58,,,,,,,,10],[,,,,,,,22,,,,,,,,11],[],
   [,,,,,42,,,,,,,,,,11,,,,11],[],[],[],
   [,,,,59,31,,36,,,,,,36,,,,,34,74,,58],
   [,,,,67,96,70,46,,,,,,,39,,,,41,58,,58],
   [,,,,,,,36,,,,,,28,35,40,,,35,40,,40,,,,,41],[],
   [,,,,29,,,54,,,,,,,65,,,,55,88,,,,,,44,38],
   [,,,,,27,,,,,,,,,32,,,,,,,37,,,,29,34],
   [,,,,53,,64,,,,,,,52,,71,,,45,,,76,,,,77,48,41,,49],
   [,,,,45,,,38,,,,,,78,,98,,,37,86,,66,,,,,32,36,,30,28,49],
   [,,,,59,,58,62,,,,,,92,63,75,,,56,70,,86,,,,48,52,,,37,,88,40],[],[],
   [,,,,,,,94,,,,,,35,44,49,,,44,49,,49,,,,157,176,100,,,203,218,149,268],
   [,,,,,,400,106,,,,,,,,81,,,,63,,,,,,197,236,162,,233,,,,295,,,37],[],[],
   [],[,,,,,20,44,18,,,,,,14,,,,,17,22,,,,,,29,,26,,,27,39,64,47,,,64,82],
   [,,,,,39,76,33,,,,,,,,,,,,18,,18,,,,,,54,,114,46,,81,76,,,69,156],
   [,,,,,,,14,,,,,,14,15,16,,,15,16,,16,,,,,40,20,,,23,41,35,53,,,45,67,,,,
     12,13],[,,,,,,,,,,,,,81,73,98,,,93,,,93,,,,96,98,,,,,111,98,80,,,,,,,,58 
    ],[,,,,,20,,20,,,,,,20,21,22,,,21,22,,22,,,,29,40,,,51,31,,40,,,,,95,,,,
     16,17],[],[,,,,,14,64,,,,,,,14,17,22,,,,,,22,,,,28,36,26,,39,,,32,49,
     ,,64,,,,,14,,12,,16],
   [,,,,38,,53,,,,,,,81,43,108,,,,,,115,,,,,74,50,,56,,,,96,,,279,,,,,34,,,76],
   [,,,,,39,102,,,,,,,,,18,,,,,,18,,,,55,,54,,85,37,,67,97,,,69,,,,,,15,13,,17]
    ,[],[],[,,,,,39,80,35,,,,,,,,18,,,,18,,,,,,,,54,,81,42,82,81,79,,,69,
     168,,,,,15,13,,17,,,,15],[],
   [,,,,211,122,,,,,,,,61,,,,,80,,,85,,,,217,,,,285,212,363,283,427,,,233,287,,,
     ,100,,83,637,121,,104,401,145,,,220],
   [,,,,,,,,,,,,,49,60,67,,,60,67,,67,,,,195,232,140,,,203,293,196,346,,,175,
     261,,,,88,95,63,,,,88,283,95,,,95,,45],
   [,,,,,116,486,154,,,,,,75,79,,,,79,95,,93,,,,239,270,202,,261,,597,218,333,,
     ,245,321,,,,108,153,81,590,117,,110,356,,,,,,71,43],
   [,,,,305,132,564,,,,,,,,95,,,,,,,97,,,,217,330,184,,274,,,263,433,,,225,,,,,,
     165,83,840,119,,104,,,,,,,43,45],
   [,,,,146,108,,110,,,,,,49,56,67,,,56,67,,67,,,,193,,140,,218,163,283,,486,,
     ,175,273,,,,84,95,63,,95,,84,284,95,,,95,,45,35,43,45],[],
   [,,,,82,61,90,60,,,,,,56,,,,,56,88,,82,,,,43,,47,,55,48,94,46,77,,,231,
     281,,,,47,,,130,51,,48,,84,,,95,,339,299,351,349,289],
   [,,,,,,,62,,,,,,56,56,68,,,56,72,,68,,,,57,56,34,,,61,60,47,61,,,178,266,,,
     ,47,74,36,,72,,47,68,72,,,76,,,246,322,314,250,,47],
   [,,,,59,54,74,48,,,,,,53,,71,,,45,,,70,,,,55,62,46,,53,43,,50,65,,,195,,,,
     ,45,,39,108,40,,38,68,69,,,66,,298,255,264,314,248,,49,42],[],
   [,,,,62,45,82,50,,,,,,44,53,58,,,48,70,,58,,,,55,48,37,,47,40,60,,,,,173,
     261,,,,39,73,37,,47,,42,89,73,,,73,,289,235,287,,223,,41,37,39],
   [,,,,,65,70,76,,,,,,,,106,,,,90,,,,,,67,73,46,,51,73,61,,,,,228,302,,,,51,
     86,44,106,68,,61,76,99,,,94,,392,308,364,406,324,,61,42,44,,45],[],
   [,,,,,24,,24,,,,,,7,,,,,13,9,,9,,,,36,,28,,,,46,53,84,,,35,,,,,14,,12,69,
     18,,14,69,14,,,14,,61,49,71,,49,,56,48,49,,44],
   [,,,,,,,14,,,,,,7,8,9,,,8,9,,9,,,,28,30,20,,,22,41,26,52,,,25,35,,,,12,
     13,9,,,,12,,13,,,13,,45,35,43,45,35,,44,36,36,,34,44,,7],[],
   [,,,,,,44,,,,,,,7,13,9,,,,,,9,,,,,42,28,,62,,,,53,,,35,,,,,14,14,12,68,18,,
     14,,,,,14,,63,49,61,67,49,,,48,49,,44,66,,7,7],
   [,,,,24,12,,14,,,,,,7,8,9,,,8,9,,9,,,,26,35,20,,36,22,40,,,,,25,,,,,12,
     13,9,71,15,,12,,13,,,13,,43,35,43,43,35,,42,36,37,,34,,,7,5,,7],
   [],[,,,,,24,,18,,,,,,7,13,9,,,13,9,,,,,,36,34,28,,50,46,45,46,50,,,35,
     51,,,,14,14,12,68,18,,14,68,14,,,,,61,49,63,71,49,,56,48,46,,44,60,,
     7,7,,7,7],[],[,,,,,,,,,,,,,22,19,30,,,,,,30,,,,44,44,30,,39,,,44,53,,
     ,70,98,,,,16,,,,,,,,,,,,,,94,110,116,92,,64,53,,,56,57,,18,12,,18,16,,
     18],[],[,,,,,,,,,,,,,,,,,,,,,,,,,,,,,43,45,78,,57,,,,,,,,,,,,,,,,,,,,,,238,,
     ,165,,,62,44,,46,94,,,25,,,24],
   [,,,,,,,,,,,,,22,,,,,24,26,,22,,,,,,,,,,55,,,,,94,128,,,,16,,14,72,20,,18,44,
     29,,,27,,128,114,,,112,,,,68,,68,58,,18,14,,24,14,,24,,16],[],[],
   [],[],[]],[,[],[],[],[],[],[],[],[],[],[6],[],
   [],[6,,,,,,,,,,3],[,,,,,,,,,,,5],[,,,,,,,,,,,,7],[8,,,,,,,,,,,5,,,5],
   [,,,,,,,,,,,,7,,,7],[8,,,,,,,,,,,5,,,5,,5],[,,,,,,,,,,,,7,,,7,,7],
   [,,,,,,,,,,,,7,,,7,,7,,7],[,,,,,,,,,,,,7,,,7,,7,,7,7],
   [12,,,,,22,,,,,12,,,12,,,16,,16,,46,46],[],
   [,21,,,,55,,,,,,,,,,,24,,24,,78,78],
   [12,,,,,16,,,,,12,,,12,,,,54,,54,54,54,12],
   [,39,,,,24,,,,,,18,,,18,,27,62,27,62,60,60,,,23],
   [12,,,,,,,,,,12,20,28,12,20,28,18,28,18,28,28,28,12,,,12],
   [,,,,,,,,,,,,,,,,22,,22,,,,,,,13,18],[],[],
   [,,,,,39,,,,,,,,,,,23,,23,,70,70,,,20,,24,24],
   [30,,,,,24,,,,,30,20,54,30,20,54,25,42,25,42,42,42,19,,23,,16,,18,,,22],
   [30,36,,,,,,,,,,28,92,,28,92,27,70,27,70,,,20,,30,,23,,,,,28,22],
   [30,,,,,58,,,,,15,,,15,,,,53,,53,47,47,60,,,57,,60,102,,,118,100,118],
   [30,,,,,52,,,,,15,,,15,,,33,,33,,51,51,60,,,57,,60,,,,,,,15],
   [30,,,,,,,,,,15,25,35,15,25,35,25,35,25,35,35,35,60,,119,57,101,60,,,,,,,
     15,15],[30,,,,,,,,,,15,,51,15,,51,,,,,,,60,,,57,100,60,,,,,,,15,15,15],
   [6,,,,,8,,,,,6,,,6,,,8,20,8,20,,,12,,,11,,12,13,,,,26,20,30,30,30,30],
   [,,,,,,,,,,,,,,,,,,,,,,,,,,,36,,,,38,42,43,,,,178],
   [,,,,,22,,,,,,,,,,,,10,,10,10,10,,,,,,31,36,,,,46,,,,40,63],
   [6,,,,,8,,,,,6,,,6,,,8,20,8,20,,,12,,,11,,12,13,,,,26,20,30,30,30,30,6],
   [,,,,,22,,,,,,,,,,,,10,,10,10,10,,,,,,31,36,,,,46,,,,40,63,,,8],
   [6,,,,,,,,,,6,8,10,6,8,10,8,10,8,10,10,10,12,,20,12,18,12,,,,20,18,24,
     24,24,20,22,6,,8,6,8],
   [,36,,,,,,,,,,24,,,24,,27,,27,,,,32,,42,38,,,,,,43,42,38,202,168,,,,23],
   [6,,,,,8,,,,,6,8,20,6,8,20,,,,,20,20,12,,21,11,16,12,13,,,,16,21,30,30,
     30,30,6,,,6,,6],[,,,,,22,,,,,,,10,,,10,,,,,10,10,51,,90,,,31,36,,,,46,
     ,91,78,40,,,,8,,8,8],
   [6,,,,,8,,,,,6,8,20,6,8,20,,,,,20,20,12,,21,11,16,12,13,,,,16,21,30,30,
     30,30,6,,,6,,6,,6],
   [,,,,,,,,,,,,,,,,,,,,,,,,32,,50,36,,,,,39,43,202,,202,,,18,,,,,23],
   [,,,,,22,,,,,,,10,,,10,,,,,10,10,51,,90,,,31,36,,,,46,,91,78,40,,,,8,,8,8,,
     ,8],[,36,,,,,,,,,,27,,,27,,24,,24,,,,32,,42,38,,,,,,43,54,,,174,154,,,
     23,,,,,18,,,,23],[,,,,,22,,,,,,,10,,,10,,10,,10,,,,,,,,31,36,,,,53,,91,,
     40,67,,,8,,8,8,,,8,,,8],
   [,,,,,22,,,,,,,10,,,10,,10,,10,,,,,,,,31,36,,,,53,,91,,40,67,,,8,,8,8,,,8,,
     ,8,,8],[42,,,,,68,,,,,21,,,21,,,,61,,61,61,61,84,,,79,,84,153,,,154,
     132,152,105,105,105,105,42,,,42,,32,194,42,86,42,192,86,242,86,86],
   [42,,,,,68,,,,,21,,,21,,,44,61,44,61,75,75,84,,,79,,84,127,,,179,140,179,
     105,105,105,105,42,,,42,,32,,42,,42,200,,206,107,107,21],
   [42,,,,,,,,,,21,35,49,21,35,49,35,49,35,49,49,49,84,,,79,132,84,,,,165,
     136,166,105,105,105,105,42,186,56,42,56,28,,42,56,42,186,56,230,56,
     56,21,21],[42,,,,,,,,,,21,41,,21,41,,,,,,65,65,84,,142,79,125,84,,,,,
     125,160,105,105,105,105,42,204,90,42,90,32,,42,,42,,,204,,,21,21,21],
   [42,,,,,68,,,,,21,44,61,21,44,61,,,,,67,67,84,,152,79,138,84,,,,,137,162,
     105,105,105,105,42,196,90,42,90,32,244,42,,42,,,244,,,21,21,21,21],
   [42,119,,,,56,,,,,21,35,49,21,35,49,35,49,35,49,49,49,84,,161,77,,84,91,
     ,,168,,168,105,105,105,105,42,140,56,42,56,28,140,42,56,42,140,56,
     140,56,56,21,21,21,21,21],
   [22,,,,,38,,,,,24,,,24,,,26,,26,,70,70,20,,,23,,23,37,,,27,28,31,108,112,
     110,106,21,,,21,,22,43,20,73,20,40,73,45,75,75,148,152,150,146,146,
     150],[24,,,,,32,,,,,24,,,24,,,,72,,72,72,72,23,,,21,,23,26,,,30,26,32,
     111,111,111,111,21,,,21,,24,60,21,128,21,54,128,60,103,103,153,153,
     153,153,153,147,23],
   [24,,,,,,,,,,24,28,52,24,28,52,26,52,26,52,49,49,23,,,23,31,20,,,,30,28,
     29,108,112,110,106,23,45,52,23,52,20,,21,53,21,41,53,42,53,53,148,
     152,150,146,146,150,23,23],
   [22,,,,,24,,,,,21,21,57,21,21,57,,,,,68,68,20,,,21,26,20,21,,,,26,,90,94,
     92,88,19,48,,19,,18,48,16,,16,,,,78,78,122,126,124,120,124,126,20,21,
     20],[22,,,,,38,,,,,24,24,,24,24,,,,,,68,68,20,,27,23,28,23,39,,,,32,
     32,108,112,110,106,21,42,77,21,77,22,43,20,,20,,,47,77,77,148,152,
     150,146,146,150,20,23,23,20],
   [24,52,,,,32,,,,,24,29,56,24,29,56,29,56,29,56,56,56,23,,31,21,26,23,
     26,,,36,,38,111,111,111,111,21,52,57,21,57,24,46,21,57,21,52,57,58,
     57,57,153,153,153,153,153,147,23,21,23,21,23],
   [24,39,,,,37,,,,,24,,68,24,,68,24,64,24,64,,,23,,31,23,28,20,,,,30,32,,
     108,112,110,106,23,49,60,23,60,20,42,21,80,21,45,80,,,,148,152,150,
     146,146,150,23,23,20,20,23,23],
   [18,,,,,30,,,,,9,,,9,,,18,13,18,13,13,13,36,,,34,,36,,,,70,57,,45,45,45,
     45,18,,,18,,14,87,18,18,18,91,18,,18,18,63,63,63,63,63,63,64,66,64,
     53,64,66,64],[18,,,,,30,,,,,9,,,9,,,18,13,18,13,13,13,36,,,34,,36,,,,
     70,57,,45,45,45,45,18,,,18,,14,87,18,18,18,91,18,,18,18,63,63,63,
     63,63,63,64,66,64,53,64,66,64,9],
   [14,99,,,,,,,,,9,11,13,9,11,13,11,13,11,13,13,13,28,,54,27,36,20,,,,47,
     28,47,33,33,25,29,14,38,16,14,16,8,,14,16,14,,16,38,16,16,43,43,
     35,43,43,35,42,45,34,36,42,37,38,9,9],
   [18,,,,,,,,,,9,18,13,9,18,13,,,,,13,13,36,,59,34,50,36,60,,,,50,59,45,
     45,45,45,18,88,18,18,18,14,84,18,,18,,,88,18,18,63,63,63,63,63,63,
     61,66,61,50,61,66,61,9,9,9],
   [18,,,,,,,,,,9,18,13,9,18,13,,,,,13,13,36,,59,34,50,36,60,,,,50,59,45,
     45,45,45,18,88,18,18,18,14,84,18,,18,,,88,18,18,63,63,63,63,63,63,
     61,66,61,50,61,66,61,9,9,9,9],
   [14,49,,,,12,,,,,9,11,13,9,11,13,11,13,11,13,13,13,28,,50,25,38,20,19,,
     ,43,,43,33,33,25,29,14,34,16,14,16,8,34,14,16,14,28,16,34,16,16,
     43,43,35,43,43,35,44,39,36,34,44,31,40,9,9,5,9,9],
   [18,,,,,30,,,,,9,18,13,9,18,13,18,13,18,13,,,36,,63,34,50,36,,,,59,50,,
     45,45,45,45,18,,18,18,18,14,86,18,18,18,90,18,,,,63,63,63,63,63,63,
     61,66,61,50,61,66,61,9,9,9,9,9,9],
   [18,,,,,30,,,,,9,18,13,9,18,13,18,13,18,13,,,36,,63,34,50,36,,,,59,50,,
     45,45,45,45,18,,18,18,18,14,86,18,18,18,90,18,,,,63,63,63,63,63,63,
     61,66,61,50,61,66,61,9,9,9,9,9,9,9],
   [,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,118,,,,,,35,,,,99,,,49],
   [,,,,,,,,,,,,,,,,,,,,,,,,,,,20,,,,,32,39,,,48,,,,,,,,,,,,,,,,,,,64,68,74,56,,,36,
     45,33,32,42,,,12,30,30,18],[],[],[],[],[],[],[],
   [,,,,,10,,,,,,,,,,,,,,,,,,,,,,15,16,,,,,,,,20,23,,,,,,4,,,,,,,,,,,,28,34,,28,,,
     24,,27,25,24,,,12,15,15,12,15,15,16],
   [,,,,,12,,,,,,,,,,,,,,,,,,,,,,20,,,,,33,58,,,25,,,,,,,10,58,16,,16,34,,,,,,,35,
     47,47,35,,,36,41,,34,42,,,5,,,5,,,,12]],
 [,[],[],[],[],[],[,21,,27],[,,,,,13],[],[,21,,27,,,21],
   [,,,,,,,10],[,16,,,,,21,13],[,,,,,,70,24],[,,,,,16,32,16],
   [,,,,,,,10,,,4],[,,,,,38,52,31],[,,,,,,36,14,,,,6],
   [,55,,,,,46,24,,,,,8,,,13],[,,,28,,14,24,,,22,4,6,8,,4,,6,8],
   [,,,,,,,25,,,,,13,,,11,,13],[,,,,,,70,24,,,,,8,,,13,,8,8],
   [,,,,,38,60,28,,,,,13,,,11,,,,11,13],[16,,,,,,27,,,27,,,,,,,,61,22,,,75],
   [,,,,,25,,25,,,,,,,,39,22,41,18,43,64,46],
   [,21,,,,47,32,,,32,,23,,,,,32,66,22,,61,88],[],
   [32,,,,,29,38,29,,42,25,,,,25,,,,22,63,96,133,21],
   [,22,,27,,,,,,,15,22,35,20,15,40,23,35,16,42,35,42,16,,20,,21],
   [,,,,,,,19,,,,23,,17,,43,,49,18,,,45,,19,,,21],
   [32,29,,34,,,,50,,29,28,25,52,32,28,,33,50,26,58,65,58,21,,25,,27],
   [,,,,,19,,,,,16,17,34,17,16,34,17,31,,,34,38,,19,,,21,,16],
   [,,,27,,,32,,,32,,25,,29,,91,,56,22,,,89,,,20,,27,20,,25],[],
   [,27,,32,,,27,,,,,26,61,,,,32,66,22,61,,84,20,,24,,25,,,21,,24],
   [48,,,,,,,90,,,29,,,,29,,53,73,26,133,,,86,,,,113,95,,,150,132,,132],
   [,,,,,84,150,76,,,,,,,,,42,,26,134,63,,,,,,,,90,155,78,138,,138],
   [,,,,,,,,,,20,32,44,25,20,55,32,44,20,55,44,55,,,,,107,77,,,266,117,,118,
     ,24],[,,,,,76,147,81,,141,,53,73,34,,,,,26,128,,,,,127,,,105,84,132,
     87,127,,131,26,,27],
   [8,,,,,10,22,10,,,7,,,,7,,9,21,8,22,,,15,,,,23,15,15,22,15,21,,20,40,,
     37],[,,,,,,27,,,31,,,,,,,27,46,,,,,,,,,,29,,34,,29,,35,,,,193],
   [,,,,,26,48,26,,,,,,,,11,,11,10,11,11,11,,37,,,,38,32,53,32,48,,,,,49],
   [,,,,,12,24,12,,,,,,5,,,,,6,15,,,,,,,,18,14,27,14,24,,,,,25,34],
   [,,,,,30,64,38,,,,,,,,,,16,,13,16,14,,,,,,45,37,62,37,115,,,,,62,157],
   [,17,,,,,,10,,,7,9,11,5,7,11,9,11,6,11,11,11,16,17,20,,21,15,,,14,21,
     ,22,31,31,25,31,7,,9,5,13],
   [,26,,31,,,,,,26,,23,,,,,27,46,22,,,,31,,35,,65,,,,,33,,31,219,148,,,,21],
   [8,13,,18,,10,18,10,,18,7,9,21,,7,,,,8,22,21,,15,16,19,,,15,13,20,13,
     19,,19,39,41,37,44,7,21,,,,7,21],
   [,,,,,26,48,26,,,,,11,,,11,,,10,11,11,11,64,44,73,,131,38,33,51,33,47,,
     73,74,,49,,,,9,,14,9],
   [8,,,26,,10,28,,,26,7,9,11,5,7,17,9,11,,,11,17,15,17,25,,21,16,14,21,,
     ,,21,30,31,25,,7,,9,5,,5,,7,9],
   [,,,26,,,27,,,31,,,,,,,27,46,,,,,,,31,,,29,,34,,,,35,207,174,191,,,17,,,,,
     21,21],[,,,,,30,64,,,,,,16,,,14,,16,,,,14,64,42,103,,,44,35,59,33,,,
     103,156,188,62,136,,,14,,12,13,,,14],
   [,26,,31,,,22,,,,,26,,,,,27,46,20,,,,31,,35,,65,,,30,,33,,,,166,141,,,21,,,,
     ,17,21,,,21],[,,,,,26,48,26,,,,,11,,,11,,11,10,11,,11,,43,,,,38,32,
     53,32,48,,,75,,49,94,,,9,,14,9,,,9,9],
   [,,,,,30,64,32,,,,,16,,,14,,,,13,16,,,59,,,,45,37,62,40,105,,,144,126,62,,,
     ,14,,12,13,,,,,,12,,14],
   [64,,,,,,,111,,,37,,,,37,,61,,,,120,133,116,,,,147,,,178,138,160,,,200,,175,
     204,54,,,,,41,190,53,98,40,189,136,237,115,148],
   [,,,,,,190,88,,,,,,,,,57,80,32,,98,,,,,,,123,,189,104,176,,176,,202,,,,,,,,
     41,190,55,,41,182,150,200,133],
   [,,,,,,,,,,28,44,60,35,28,77,44,60,28,77,60,77,119,213,,,141,107,,,242,
     154,,165,183,181,140,,51,180,67,35,86,35,,51,67,35,181,86,215,67,86,
     35,32],[84,,,180,,90,174,96,,,37,,89,44,37,,,,34,117,120,,129,164,,,,,
     108,177,117,157,,166,205,,186,200,57,,,44,181,43,227,58,,41,227,,231,
     133,,34,,35],[68,,,,,,221,,,,34,54,80,,34,,,,,,95,118,118,,,,154,126,,
     165,,,,161,218,,,217,53,196,,,147,41,,52,96,41,,,255,97,177,40,33,,40],
   [56,110,,176,,78,,,,178,28,42,56,35,28,77,42,56,28,77,56,77,107,,161,,,
     107,103,,108,,,160,195,189,140,,49,141,63,35,84,35,141,49,63,35,141,
     84,141,63,84,36,32,28,36,32],
   [24,,,,,60,40,41,,40,27,,,,27,,33,77,26,,74,95,22,,,,31,27,,32,,27,,31,
     129,,125,134,22,,,,,25,44,22,80,22,40,83,44,61,100,173,,169,174,178,
     174],[,,,,,35,48,35,,46,,,,,,,,,24,67,77,92,,,,,,29,28,36,28,37,,33,,
     118,137,,,,,,,23,58,21,90,23,,,58,,142,,158,176,,184],
   [,35,,40,,,,67,,35,25,28,56,28,25,61,29,53,24,62,50,62,27,58,31,,33,
     22,,,,31,,27,135,,121,129,25,42,53,25,63,22,,22,54,25,42,61,38,54,
     63,179,189,165,177,185,174,27,27],
   [28,33,,38,,24,36,24,,38,22,22,56,20,22,56,,,18,50,56,,25,28,29,,,24,
     21,29,21,28,,29,95,,92,80,20,54,54,20,,17,54,,,17,54,49,54,54,,123,,
     120,108,126,131,23,,23],
   [28,,,37,,53,42,,,42,27,30,,33,27,103,31,61,,,64,99,25,,28,,33,28,50,33,
     ,,,32,139,,,149,24,39,59,29,112,25,43,23,58,23,,,43,57,106,185,203,
     187,184,188,,24,32,28,24],
   [32,40,,45,,34,,34,,54,25,27,53,26,25,56,32,50,24,59,53,56,28,,32,,28,
     26,27,,27,32,,34,,,123,128,22,46,54,26,60,23,56,20,54,23,46,60,50,
     51,62,,163,163,164,173,146,27,22,25,,28],
   [32,35,,40,,,35,52,,,,36,74,28,,,33,77,26,75,,95,27,50,31,,33,24,,28,
     46,31,,,135,143,125,130,25,44,61,25,,23,40,22,80,24,44,66,,,100,,188,
     169,178,176,174,27,27,23,23,28,25],
   [28,,,,,,66,30,,86,10,,,,10,,19,14,12,23,14,23,46,,,,57,43,,63,42,,,,71,,
     54,70,19,,,,,15,77,19,19,17,51,28,,19,28,91,,74,91,86,70,67,,65,48,
     69,63],[,,,,,37,65,37,,74,,,,15,,,24,19,14,21,19,21,,,,,,49,42,69,
     42,65,,67,,82,67,81,,,,15,,15,92,24,19,15,92,26,,19,26,,108,93,107,
     104,93,,71,72,48,77,64,72],
   [,39,,110,,,,16,,110,10,12,14,15,10,21,12,14,8,21,14,21,43,28,43,,53,
     23,,,23,51,,43,62,55,30,62,15,35,17,13,26,9,,15,17,11,,26,35,17,26,
     74,63,42,78,63,42,54,48,36,42,47,36,54,10,14],
   [,37,,59,,,50,30,,59,10,19,14,18,10,23,,,12,23,14,,46,51,53,,,43,41,
     57,39,55,,53,,66,54,71,19,47,19,16,28,15,47,19,,17,43,28,47,19,,91,
     86,74,91,86,70,64,60,62,46,66,60,64,10,15,10],
   [24,,,78,,,74,,,,15,24,19,15,15,21,24,19,,,,21,46,53,65,,59,49,,64,,,,61,
     ,81,67,85,22,80,19,15,25,15,79,22,19,15,,,83,21,25,107,,93,106,108,
     93,71,69,73,48,81,69,73,15,13,14,15],
   [24,31,,58,,,28,16,,58,10,12,14,15,10,21,12,14,8,21,14,21,41,26,41,,
     63,23,,32,21,49,,41,66,51,30,66,15,33,17,13,24,9,31,15,17,11,27,
     24,33,17,24,78,63,42,74,63,42,56,42,38,40,49,30,56,10,14,6,10,14],
   [28,45,,86,,,66,30,,,10,19,14,18,10,23,19,14,12,,,23,47,74,58,,60,43,,
     64,42,64,,,,63,54,71,19,,19,16,28,15,77,19,19,17,51,,,,28,95,,74,95,
     93,70,69,67,65,48,69,63,67,10,15,10,10,,10],
   [32,,,,,37,66,34,,,15,24,19,15,15,21,,,14,21,19,,53,56,,,63,50,43,65,
     46,63,,66,80,78,67,,24,,19,15,26,15,93,,,15,93,26,,19,,106,104,93,,
     106,93,75,65,72,,74,65,,15,13,14,,13,14,15],
   [,,,,,,,,,,,,,,,,18,,18,,,,,,,,,,,,,,,,,72,,73,,,,12,,15,,11,55,11,,57,,,,,94,
     106,,,86,,25,34,21,,25,,,38,35,33,,27],
   [,,,,,,,,,,,,,,,,15,27,,,,,,,,,,24,,32,,,,33,,,57,,,,,,,,,13,,,,,,,,,,75,,,63,,,
     40,46,34,36,42,,,13,27,33,19],
   [,,,,,,,,,,,,,,,,21,,,,,,,,,,,,,,,,,,,,,,,,,,,17,,14,62,22,,56,,,76,,,,110,153,
     127,,,,15,,25,,,,45,45,,40,,49],
   [,,,,,,,,,,16,14,30,,16,29,12,24,16,37,30,25,21,16,,,21,,16,30,,30,,,79,
     58,85,54,12,,26,12,26,,,10,25,13,,28,,26,26,99,78,105,74,100,76,29,
     23,30,14,29,22,29,36,35,22,30,43,16,36,31,,,15],[],[],
   [,,,,,,,,,,,15,19,14,,26,,21,14,34,19,28,,,,,41,,,,,,,,,,,91,11,33,20,14,
     27,11,33,13,22,11,33,29,33,20,29,,118,,,110,117,,57,66,40,,74,64,,
     36,19,29,42,19,27,36,,13],
   [,,,,,,,,,,,25,51,20,,37,17,31,22,52,51,32,,,,,42,,,,,,,,146,98,152,77,21,
     ,37,20,35,,,13,32,19,,37,,37,33,216,125,,103,219,,37,27,40,15,,,37,
     59,45,,39,60,23,59,40,,,15,13],
   [,,,,,,,,,,,,,20,,55,28,,28,,,,35,40,,,18,,32,46,,49,,,,,,103,,,55,20,72,,,
     18,,25,,,,56,66,223,134,,137,175,136,40,21,36,23,39,25,39,63,52,70,
     54,73,38,62,,,,25],
   [,,,,,12,24,12,,,,,,5,,,,,6,15,,,,,,,,18,14,27,14,24,,,,,25,34,,,,5,,5,,,,
     5,,,,,,,,35,44,,35,,,25,20,29,26,25,,15,13,16,15,13,16,15,12,,,12,,,
     14,20,20],[,,,,,,46,16,,,,,,,,,,,8,,,,,,,,,23,,37,24,,,47,,,30,115,,,,,,
     11,59,17,,13,33,,,,,,,42,,,42,,,40,50,,35,64,,,6,,,6,,,,13,,22],[]],
 [,[],[],[],[],[],[],[,,,,,22],[],[],[,,,,,,,18],
   [,25,,,,,,21],[,,,,,,,26],[,,,,,28,,28],[,,,,,,,35],[,,,,,,,18,,,5],
   [,,,,,,,35,,,,7,,,15],[,101,,,,,,30,,,,,9],[,,,,,34,,,,,,15,,,11],
   [,,,,,,,16,,,5,7,9,,,5,7,9],[,,,,,,,26,,,,,9,,,,,9,,9],
   [,20,,,,18,,18,,,5,7,9,,,5,7,9,,5,9],
   [,,,,,38,,,,,38,,,,,38,54,,56,,76,28],[],
   [,29,,,,54,,,,,,33,,,,,36,82,,33,70,29],
   [,,,,,36,,39,,,,,,36,,,,72,59,27,74,29],
   [,,,,,46,,92,,,,,,,36,,59,90,40,36,86,36],
   [,29,,,,,,,,,20,28,40,28,40,20,28,40,40,20,40,20,38,,27,28,33],
   [,,,,,,,37,,,,,,,,,34,,43,,,25,,,,29,34],[],[],
   [,,,,,52,,,,,57,,118,52,,57,49,,49,,88,41,,,35,52,36,33],
   [,,,,,50,,,,,50,36,72,78,50,50,61,58,68,36,60,32,48,,,,42,51,38],
   [,43,,,,,,,,,,,92,92,,,40,,,35,,35,78,,41,57,63,,,,,63,90],
   [,,,,,126,,132,,,,,,,,,80,,,33,79,37,200,,,,,168,188,,,262,398],[],
   [,139,,,,,,,,,25,37,49,35,55,25,37,49,55,25,49,25,162,,162,161,183,100,,,
     ,203,,225,39],[],
   [,,,,,14,,16,,,8,,,,,8,10,22,22,9,,9,26,,,,,20,21,,,50,42,32,64,,42],
   [,,,,,,,,,,,,,,,,41,,,,,34,,,,,,46,,,,48,86,73],
   [,,,,,28,,28,,,,,,,,,,12,,11,12,11,,,,,,43,44,,,125,,,,,54],
   [,,,,,18,,20,,,,,,14,,,18,30,18,14,,,,,,29,,26,27,,,35,64,48,,,64],
   [,,,,,16,,22,,,,,,,,,,,,7,,7,,,,,,23,24,,,69,,,,,30],
   [,27,,,,,,16,,,8,10,12,14,18,8,10,12,18,7,12,7,28,,28,26,34,20,,,,36,
     34,,48,,30,,8,,10,14,6],
   [,44,,,,,,,,,,38,,81,52,,,,50,,,34,82,,61,,121,,,,,59,120,70,393,,,,,43,,34 
    ],[,23,,,,14,,20,,,8,10,22,20,22,8,,,,9,22,9,32,,28,29,42,20,21,,,
     40,42,,56,,42,,8,,,16,,8],
   [,,,,,28,,32,,,,,12,,,,,,,11,12,11,71,,97,,,43,44,,,,62,,98,,54,,,,10,,,10]
    ,[,,,,,18,,,,,16,18,30,14,18,16,,,,,30,14,36,,44,,42,26,29,,,,69,51,76,
     ,64,,16,,,12,,14],[,,,,,,,,,,,,,81,67,,38,,,,,34,,,50,156,66,46,,,,,88,
     73,367,,328,,,36,,58,,,43],
   [,,,,,16,,,,,8,10,12,,,8,10,12,,,12,7,30,,34,28,,23,22,,,,35,44,49,,30,,
     8,,10,,6,6,,8,10],
   [,44,,,,,,,,,,41,,,48,,,,46,,,34,82,,61,,76,,,,,61,112,,,,242,,,35,,,,,36,,,,
     43],[,,,,,28,,28,,,,,12,,,,,12,,11,,11,,,,,,43,44,,,125,,,,,54,,,,10,,,
     10,,,10,,,10],[,27,,,,16,,22,,,8,10,12,,,8,10,12,,7,12,,30,,32,,,23,
     23,,,47,39,39,47,,30,,8,,10,,6,6,,8,10,,,6,,10],
   [,,,,,136,,194,,,47,,,,,47,73,89,,47,95,43,260,,,,,,292,,,328,328,474,283,,
     229,,78,,,,,60,345,,114,104,339,59,513,,59],
   [,,,,,156,,168,,,,,,61,,,76,87,158,43,97,43,,,,217,,194,216,,,329,386,367,,,
     ,,,,,100,,60,322,78,,104,374,59,362,151,59],
   [,,,,,,,,,,35,51,67,49,77,35,51,67,77,35,67,35,208,,,,232,140,,,,249,,271,
     ,,175,,58,297,74,88,42,42,,58,74,88,293,42,359,74,42,,43],
   [,,,,,152,,156,,,,73,85,75,121,,,,160,43,,43,278,,245,235,282,,277,,,291,
     370,,279,,247,,,356,124,114,67,70,382,78,,106,330,65,,,,43,59,45],
   [],[,154,,,,112,,120,,,35,51,67,49,77,35,51,67,77,35,67,35,,,227,195,,
     140,161,,,256,,251,257,,175,,58,227,74,84,42,42,227,58,74,84,233,42,
     229,74,42,49,43,35,49],
   [,,,,,64,,79,,,48,,,,,48,59,90,83,,90,44,46,,,,,53,63,,,63,77,98,290,,228,
     ,41,,,,,44,79,43,100,53,74,45,103,100,45,378,,306,376,,324],
   [,,,,,60,,69,,,,,,56,,,,84,78,45,88,43,,,,43,,45,48,,,73,64,68,,,235,,,,,
     47,,42,94,43,188,,130,44,,133,55,,339,,341,,291],
   [,48,,,,,,,,,33,36,64,56,60,33,37,61,61,34,58,32,61,,44,51,54,30,,,,54,
     76,,236,,167,,33,67,61,45,33,30,,30,62,45,67,33,66,62,34,288,310,224,
     ,,234,51,45],[,59,,,,48,,67,,,41,39,75,53,51,41,,,55,36,,36,58,,53,
     55,62,,43,,,65,62,,225,,194,,37,74,,45,,34,,30,,49,74,35,100,100,35,
     295,298,255,264,,249,42,49,44],
   [,,,,,82,,,,,48,53,,,66,48,48,94,,,92,48,58,,51,59,58,45,73,,,,94,68,292,
     ,258,,47,66,114,51,56,44,75,45,114,45,,,71,124,58,362,362,312,364,,
     320,52,51,45,52],
   [,65,,,,50,,61,,,34,37,70,44,59,34,39,70,57,37,70,31,,,47,55,48,37,40,,
     ,56,,52,,,173,,31,90,71,39,35,34,89,31,71,45,89,36,90,71,36,307,
     289,235,289,,223,,39,37,41],[],
   [,,,,,42,,32,,,11,,,,,11,20,15,23,13,15,13,52,,,,,48,,,,71,75,,63,,59,,20,
     ,,,,16,96,20,20,24,120,18,,20,18,85,,81,83,,81,88,,73,67,86,80],
   [,,,,,24,,24,,,,,,7,,,,,13,9,,9,,,,36,,28,,,,46,53,84,,,35,,,,,14,,12,69,
     18,,14,69,14,,,14,,61,49,71,,49,,56,48,49,,44],
   [,59,,,,,,22,,,11,13,15,7,11,11,13,15,11,9,15,9,36,,49,33,36,28,,,,41,
     44,,43,,35,,16,64,18,14,14,10,,16,18,14,,12,64,18,12,57,57,49,61,,
     49,56,55,44,44,56,47,,11,7],
   [,57,,,,,,36,,,11,20,15,,,11,,,23,13,15,13,50,,66,58,70,48,68,,,70,66,,
     61,,59,,20,98,20,28,17,16,94,20,,24,,18,98,20,18,83,89,81,83,,81,
     86,88,70,64,86,80,,11,,11],
   [,,,,,,,,,,11,13,15,7,14,11,13,15,,,15,9,36,,49,33,36,28,31,,,,44,72,43,
     ,35,,17,44,19,14,15,11,60,17,19,14,,,44,19,13,57,57,49,61,,49,56,
     55,44,44,56,47,,11,7,7,11],
   [,45,,,,24,,22,,,11,13,15,7,11,11,13,15,11,9,15,9,36,,47,31,37,28,33,,
     ,39,,71,43,,35,,16,44,18,14,14,10,38,16,18,14,44,12,44,18,12,57,
     57,49,61,,49,58,49,46,42,58,41,,11,7,7,11,7],
   [,56,,,,42,,32,,,11,20,15,,,11,20,15,23,13,,13,50,,70,54,68,48,,,,79,68,
     ,61,,59,,20,,20,,17,16,97,20,20,24,123,18,,,18,83,95,81,,,81,86,86,
     73,66,88,80,,11,,11,11,11,11],
   [,49,,,,20,,24,,,11,13,15,7,14,11,13,15,13,9,15,,36,,45,31,32,28,27,,,
     37,40,69,43,,35,,17,36,19,14,15,11,38,17,19,14,38,13,36,19,,57,57,
     49,61,,49,54,49,42,40,54,41,,11,7,7,11,7,7,11],
   [,,,,,,,,,,,,,,,,,,,35,,25,,,,,,,,,,,,,,,,,,,,,22,,,,,,,26,,,22,,,241,,,165,,,43,,
     ,44,,,,105,,63,55,,55],
   [,,,,,,,,,,,,,22,,,,,,,,18,,,,,,36,,,,,90,79,,,86,,,,,16,,,,,,,,,,,,,128,114,146,
     ,108,,,62,68,58,68,,,18,22,36,18,24,,18],[],[],
   [,,,,,,,,,,12,14,22,22,,12,15,22,25,16,22,12,42,,41,44,44,,,,,45,72,,88,
     ,76,,12,38,23,16,13,12,38,12,23,14,38,15,38,23,13,108,,94,114,,96,
     61,64,,,57,56,,28,18,18,28,22,18,28,20,,16],[],[],
   [,,,,,,,,,,,49,110,,88,,37,88,100,60,104,48,,,,,88,,,,,,,,,,,,38,,82,55,38,,
     ,34,81,64,,40,,81,37,444,528,468,410,,,70,51,56,,72,43,,118,,,96,68,
     42,112,56],[],[,,,,,16,,22,,,,,,,,,,,,7,,7,,,,,,23,24,,,69,,,,,30,,,,,,
     6,6,,,,,,6,,,6,,,42,67,,42,,,33,,56,35,,,,14,17,15,14,17,15,22,,,,13,,
     ,38],[,,,,,24,,24,,,,,,7,,,,,13,9,,9,,,,36,,28,,,,46,53,84,,,35,,,,,14,
     ,12,69,18,,14,69,14,,,14,,61,49,71,,49,,56,48,49,,44,,,7,7,,7,7,,7,
     ,18,,,18],[],[]],
 [,[],[],[],[],[],[,13],[,,13],[],[,15,,25,,,15],[],[],
   [],[,,14,20,,,20],[,16,,,,,21,13],[,17,24,,,,22,31],[],[],
   [,12,15,28,,,17,,,16,,,,,7],[,25,,,,,,15,,,,,,,,8],[],
   [,,24,39,,,28,,,,,,,,,8,,,,8],[16,,,,22,,,,,24,,,,23,,,,,23,,,51],
   [,,,,,,,20,,,,,,19,,31,,,21,34,,31],[,17,,,,,23,,,24,,,,19,26,29,,,21,35]
    ,[,17,21,26,21,,22,16,,,,,,13,,,,,15,,,35,,15,17],
   [32,24,31,39,25,,31,23,,28,,,,,25,,,,21,41,,38,22,19,21],
   [,,,,,,,24,,,,,,20,23,27,,,23,27,,28,,,,16,20],[],
   [32,,,,18,,,33,,21,,,,19,,41,,,27,52,,,20,,,17,21],
   [,,23,,,,,,,,,,,,18,,,,,,,49,,17,,13,17],
   [,17,,25,23,,23,,,24,,,,21,,39,,,21,,,45,,,17,17,23,21,,22],
   [,24,31,,28,,31,23,,31,,,,28,,48,,,21,,,38,,19,21,,15,20,,21,17],
   [,22,59,26,21,,,34,,,,,,22,30,34,,,26,36,,32,24,,22,20,25,,,20,,24,24],
   [48,,,,,,,74,,,,,,35,41,,,,47,54,,,86,,,72,95,,,,146,,97,124],
   [,57,,105,68,,,76,,,,,,31,,,,,,,,54,91,119,99,61,,92,,98,115,96,,115,38],
   [,,,,,,,63,,129,,,,25,32,37,,,32,37,,37,,,,69,97,77,,,123,125,94,128],
   [,54,91,103,73,,77,,,,,,,34,,,,,39,,,,,,93,63,87,105,,99,,93,87,,27,,26],
   [8,,,,11,,,9,,,,,,8,9,10,,,9,10,,10,15,,,13,19,,,18,15,19,19,20,35,36,,
     37],[,,,,,,,,,28,,,,21,24,33,,,,,,35,,,,,45,,,,,30,39,39,,122,,121],
   [,,,,,,,21,,,,,,11,12,13,,,12,13,,13,,28,,,32,,,,28,44,39,,,58,,61],
   [,10,11,16,,,13,9,,,,,,5,,,,,6,13,,,16,15,17,11,,16,,17,13,17,23,19,31,
     30,25,30,7,19,9],[,22,22,46,50,,30,19,,,,,,,,,,,,7,,7,40,28,32,,,24,
     ,40,21,50,38,36,52,,30,64,8,,10],
   [,,,,,,,11,,,,,,5,6,7,,,6,7,,7,,,,,17,16,,,14,22,16,,,24,20,25,,,,5,6],
   [,,,,,,,,,22,,,,21,21,30,,,23,,,33,,,,32,41,,,,,29,37,38,,99,,92,,,,17],
   [8,10,11,19,14,,13,9,,14,,,,8,9,10,,,9,10,,10,15,15,17,11,15,,,17,13,
     17,15,,36,35,,36,6,,,7,8,,19],
   [,,28,,,,,21,,,,,,11,12,13,,,12,13,,13,64,30,59,33,37,54,,65,29,43,45,,
     58,62,58,,,,8,9,10],
   [8,13,11,25,11,,19,,,22,,,,5,6,13,,,,,,13,15,16,20,12,17,16,,18,,,17,
     20,30,33,25,,7,,9,5,,5,,7,9],
   [,,,22,,,,,,28,,,,23,24,33,,,,,,33,,,30,33,39,,,,,,36,39,199,,298,,,17,,19,,
     ,22],[,22,22,46,,,30,,,,,,,,,7,,,,,,7,38,26,34,28,,24,,42,20,,34,40,
     46,50,30,,8,,10,,6,6,,8,10],
   [,22,,28,,,22,,,,,,,23,23,34,,,21,,,35,30,,32,33,39,,,29,,30,34,,,104,,98,
     ,23,,19,,,17,22,,,23],
   [,,22,,,,,21,,,,,,11,12,13,,,12,13,,13,,34,,,33,,,,28,44,36,,67,,58,67,,,
     8,9,10,,,,8,9,,10],
   [,22,22,46,50,,30,15,,,,,,,,7,,,,7,,,40,28,32,,,24,,40,23,50,38,36,44,
     44,30,68,8,,10,,6,6,,8,10,,,6,,10],
   [64,,,,111,,,97,,186,,,,43,58,69,,,,,,68,116,,,91,125,,,150,138,150,132,
     175,187,196,,207,47,,,41,,,,48,74,40,189,56,240,78,56],
   [,75,110,138,91,,111,90,,,,,,,,,,,57,73,,82,120,,129,83,,,,131,127,132,131,
     ,196,190,166,219,48,152,80,39,,32,131,47,,39,152,60,134,77,60,40],
   [,,,,,,,,,189,,,,35,44,51,,,44,51,,51,,,,94,124,107,,,126,141,124,,,179,
     140,182,,,,35,42,28,,,68,35,282,42,434,,42,,35],
   [84,73,108,,105,,97,88,,116,,,,44,,,,,60,76,,,127,143,125,83,114,137,,132,
     127,125,114,,,194,167,196,48,147,74,39,60,32,116,47,,39,147,64,125,76,
     ,33,40,32],[68,88,130,,111,,151,,,,,,,41,54,,,,,,,73,122,207,138,88,,,
     ,141,,,126,152,201,194,169,,47,189,76,39,60,,226,48,74,39,,,239,75,
     62,40,32,35],[56,76,117,136,86,,,63,,127,,,,35,42,51,,,42,51,,51,107,
     ,133,83,,107,,138,97,,,147,,183,140,,42,135,56,35,42,28,127,42,56,35,
     135,42,,56,42,32,36,28,32,36],
   [24,,,,33,,,39,,37,,,,28,30,54,,,28,,,63,22,,,28,31,,,30,,29,32,33,128,
     141,,127,22,,,25,48,,,22,80,22,42,50,45,61,52,172,178,,168,173,174],
   [,31,41,43,38,,40,30,,,,,,23,,,,,27,49,,49,30,29,28,19,,26,,30,24,28,
     23,30,129,107,127,111,25,70,,19,,26,54,19,52,22,53,42,54,66,52,165,
     145,165,145,163,151,28],
   [,,,,,,,38,,34,,,,28,29,38,,,29,39,,37,,,,25,29,22,,,35,33,29,26,,133,
     120,123,,,,23,36,24,,21,71,23,,36,43,71,38,,173,163,163,162,168,,25],
   [28,24,31,,28,,31,23,,31,,,,20,,38,,,21,42,,42,25,25,24,19,23,24,,26,
     20,26,23,,97,93,93,87,19,44,43,17,,19,43,15,,17,43,34,43,43,34,127,
     122,125,114,124,127,23,19,21],
   [28,24,39,33,29,,32,,,34,,,,28,,50,,,,,,52,25,,24,28,,27,,27,,,35,29,128,
     137,129,,21,39,51,23,44,25,40,21,51,21,,,42,50,56,168,174,167,158,,
     176,24,28,26,21],
   [32,31,41,43,38,,40,30,,41,,,,23,27,33,,,27,37,,33,28,29,28,19,23,26,,
     30,24,28,,30,136,107,123,111,25,48,46,19,34,26,48,19,46,22,48,34,,
     46,34,,145,162,145,164,151,27,19,25,19],
   [32,29,64,39,,,37,42,,,,,,28,,79,,,,72,,,25,58,29,28,31,24,,,39,32,32,,
     131,144,124,130,25,46,61,25,56,25,46,22,79,24,47,56,,,,,180,176,167,
     172,174,25,28,23,23,27,27],
   [28,,,,37,,,26,,55,,,,18,19,20,,,19,20,,20,48,,,36,47,,,54,37,58,48,,79,
     80,,81,18,,,15,16,,,19,20,15,52,16,,16,16,103,103,,103,103,108,65,64,
     ,51,65,63,68],[,32,36,52,38,,45,45,,,,,,15,,,,,21,18,,18,52,49,53,
     35,,49,,53,,54,53,60,79,77,67,81,20,55,17,15,,13,51,20,19,15,57,15,
     54,17,15,104,,93,104,102,93,72,61,69,50,69,61,72,15],
   [,,,,,,,27,,74,,,,15,16,17,,,16,17,,17,,,,36,49,39,,,36,54,52,89,,65,50,
     68,,,,13,14,10,,25,,13,,14,,14,14,,85,70,85,88,70,,62,57,47,62,55,64,
     ,13],[],[24,37,42,85,,,60,,,,,,,15,21,18,,,,,,18,46,,59,36,49,49,,,,
     ,48,64,,77,67,,20,83,17,15,15,13,76,20,19,15,,,85,17,15,108,102,93,
     104,102,93,68,65,68,51,68,65,73,15,14,13],
   [24,28,,51,37,,,23,,50,,,,15,16,17,,,16,17,,17,41,,45,35,53,39,,50,37,
     52,,51,67,,50,73,16,51,14,13,14,10,47,16,18,13,50,14,,18,14,87,,70,
     88,88,70,64,63,59,51,65,59,64,12,13,10,,13],
   [28,31,,60,37,,,26,,,,,,18,19,20,,,19,20,,20,48,60,48,38,59,,,55,38,56,
     53,,81,,,80,18,,16,15,16,13,,19,20,15,53,16,,,16,111,103,,101,101,,
     69,66,59,48,70,63,65,14,15,12,,15],
   [32,31,36,,,,40,,,49,,,,15,20,18,,,21,18,,,53,49,53,35,48,50,,53,69,53,
     48,61,80,77,67,,20,55,17,15,15,13,48,20,19,15,55,15,52,17,,103,104,
     93,103,104,93,75,61,66,48,66,61,,15,14,13,,14,13,15],[],
   [,,,,,,,,,,,,,16,15,24,,,,,,24,,,,35,37,,,,,,38,,,76,,81,,,,13,,,,,,,,,,,,,92,,
     89,,,,55,,,36,,52,,34,,,35,,,34],
   [,,,,,,,,,,,,,,,,,,,,,,,,,,33,,,,,,,,,191,,141,,,,23,56,,,18,73,26,,67,,,,,216,,
     201,259,178,,,,21,,27,,,,,,,70,62],
   [,,,,,,,,,,,,,,,,,,,,,,23,21,29,,23,22,,29,21,31,22,32,,,108,,,,,15,,,,,,,,,,,
     ,143,,140,171,,110,35,,34,18,40,27,35,53,,56,,55,50,52,,,,21],
   [,,,,,,,,,,,,,16,,16,,,14,35,,17,45,,34,35,36,,,,,38,63,,86,,70,76,10,27,
     25,13,15,11,24,10,25,10,27,17,25,25,16,109,,84,91,,78,58,52,,41,,46,
     ,29,34,28,,51,26,29,37,,13],[],[],
   [,,,,,,,,,,,,,32,27,37,,,36,37,,38,,,,27,33,,,,,,33,,240,142,206,147,,,,23,
     28,,,,,28,,36,,,30,276,175,284,165,224,,37,23,34,21,34,23,35,,65,,,74,
     ,79,66,,,21,21],[,,,,,,,,,,,,,,23,,,,,,,,29,26,34,27,18,27,,34,26,37,,
     37,,172,204,,,,73,23,67,19,,18,,26,,,,53,70,220,,,165,204,176,40,23,
     39,23,48,27,40,62,71,60,,74,70,72,,,,27,,,,,27],
   [,,,,,,,11,,,,,,5,6,7,,,6,7,,7,,,,,17,16,,,14,22,16,,,24,20,25,,,,5,6,4,,
     ,,5,,6,,,6,,32,28,32,,28,,26,24,19,25,26,25,,13,10,,13,10,13,13,,,,,
     11,,,,19],[],[,16,,,,,,,,,,,,,,,,,,,,,17,,20,14,21,15,,,,23,21,26,26,
     26,20,,7,22,10,7,10,4,21,7,10,7,21,10,22,10,10,34,34,28,34,34,28,
     27,28,24,21,24,28,,15,15,12,,,12,15,15,,10,,,,,,,,4],
   [8,14,,,,,19,11,,,,,,5,,15,,,6,,,15,16,21,21,,21,18,,23,15,,,25,31,36,
     25,33,8,21,11,5,14,5,18,8,11,5,21,14,19,11,14,41,44,35,42,44,35,
     24,26,25,17,27,26,24,16,15,13,,15,13,16,15,,11,,14,,,,19,,5],
   [,20,,,,,,19,,,,,,,,,,,,7,,7,51,,30,28,33,23,,,,51,41,,49,,30,,9,31,12,
     13,6,6,31,9,12,13,32,6,32,12,6,58,64,42,,,42,56,46,33,37,50,38,,
     17,,14,,15,14,17,15,,16,,,14,,,46,,6]],
 [,[],[],[],[],[],[],[,,22,,,18],[,,,46,41,,39],[,,,35,,,30],
   [],[],[],[,,32,59,,24,35,24,57],[,55,,,,,46,24],
   [,51,42,81,,32,39,26,75],[],[],[,44,27,,,21,37,,,,,,,,10],
   [,101,,,,,,22,,,,,,,,11],[],[,,42,,,32,43,34,,,,,,,,11,,,,11],
   [36,,,,,36,,,,112,,,,,,84],[,,,,,,,32,,,,,,39,,51,,,35,,,51],
   [,51,,,,,,,58,69,,,,60,72,70,,,60,113],
   [,79,57,88,47,45,52,40,82,84,,,,,,,,,33,72,,,56,39,43],
   [,91,60,64,51,48,54,42,94,64,,,,,29,,,,35,60,,,33,36,56],
   [,,,,,,,36,,,,,,28,35,40,,,35,40,,40,,,,34,31],
   [,,,,,,,28,,,,,,31,,41,,,29,,,41,,,,33,30],
   [,,,,27,,,64,57,50,,,,68,,,,,,,,,,,,39,40],
   [,,37,,,31,,,,,,,,31,28,41,,,,,,35,,27,,31,30,,23],
   [,79,,48,38,,43,,,,,,,42,,64,,,42,,,68,,,51,61,38,43,,38],
   [,83,48,94,39,40,46,34,82,94,,,,,,,,,31,86,,,35,28,50,,,25,24,32,24,40]
    ,[,,,69,47,,52,68,,,,,,68,72,66,,,65,82,,80,,,50,43,56,,,43,,,50],
   [,,,,,116,,158,,,,,,61,73,,,,,87,,91,188,,,207,246,,,,295,,182,393],
   [,,136,280,147,102,178,106,,,,,,47,,,,,,69,,69,,181,399,191,,182,135,229,
     139,233,,309],[,,,,,,,94,,386,,,,35,44,49,,,44,49,,49,,,,159,168,100,,,
     193,221,137,,,39],
   [,,134,238,,104,150,106,288,,,,,,,91,,,,87,,,,,321,,254,156,133,195,139,
     265,190,301,35,,33],
   [18,,,,,14,,18,,,,,,20,21,22,,,21,22,,22,32,,,37,40,,,,29,,36,,91,93,,91],
   [,,,,,,29,,36,37,,,,45,38,55,,,,,,59,,,,58,60,,,,,44,64,59,,206,,170],
   [],[,35,24,28,21,18,26,18,42,28,,,,14,,,,,17,24,,,28,31,47,,,26,25,
     35,25,33,,47,86,80,64,,16,28],
   [,97,46,,,37,68,34,,,,,,,,,,,,18,,18,115,55,99,,,54,46,120,65,94,,99,178,
     ,69,203,17],[,,,,,,,14,,,,,,14,15,16,,,15,16,,16,,,,29,32,20,,,23,37,
     28,,,75,45,73,,,,12,13],
   [,,,,,,,,41,34,,,,43,38,51,,,46,,,55,,,,62,60,,,,,47,60,58,,192,,170,,,,28]
    ,[],[],[,61,20,,,16,50,,,,,,,14,17,22,,,,,,24,,28,75,30,32,26,24,
     45,,,28,53,,98,64,80,16,,,14,,12],
   [,,,38,33,,35,,,,,,,45,40,53,,,,,,57,,,50,56,66,,,49,,,62,,,204,,186,,34,,
     30,,,37],[,97,46,,,37,68,,,,,,,,,18,,,,,,18,,47,119,,,54,39,,35,,,119,
     186,145,69,193,17,,,,15,13],
   [,,,37,,,26,,39,,,,,45,38,55,,,45,,,59,,,59,58,60,,,40,,52,64,,,178,257,
     178,,27,,28,,,32],[],
   [,89,46,,,37,68,,,,,,,,,18,,,,18,,,109,55,99,,,54,46,120,41,86,,99,196,
     156,69,178,17,,,,15,13,,,,,,15],
   [182,,,,,132,,182,,,,,,67,,99,,,,,,,242,,,247,,,,,239,,,717,275,311,,277,117,,
     ,106,,,,,,116,367,165,514],
   [,287,198,284,,146,228,126,322,320,,,,61,,,,,,101,,87,256,211,377,,,208,
     173,,169,315,357,377,295,,245,295,119,242,,104,,85,252,,,106,244,,250,,
     149,59],[,,,,,,,,809,,,,,49,60,67,,,60,67,,67,,,,203,210,140,,,196,266,
     174,525,,271,175,,,,,88,95,63,,,,88,561,95,452,,95],
   [,299,170,278,181,126,208,132,,266,,,,75,89,,,,89,97,,99,306,235,363,,
     234,222,181,281,181,319,194,357,,315,247,275,117,220,,116,165,81,222,,,
     104,244,198,226,,,45,59,43],
   [,391,206,,213,136,340,,,,,,,65,,95,,,,,,81,256,,466,245,,,,316,,,276,598,,
     349,251,337,121,,,106,,85,615,,,104,,,550,,,,47,49],
   [150,387,160,220,105,138,160,110,232,226,,,,49,56,67,,,56,67,,67,212,191,
     423,305,,140,149,195,147,231,,405,255,259,175,267,95,186,,84,95,63,200,
     ,,84,200,95,194,,95,43,49,35,43,49],
   [68,,,,,63,,76,86,71,,,,74,60,100,,,68,,,,44,,,75,56,,,,,51,54,80,278,322,
     ,264,56,,,49,96,,,,,54,70,,65,,133,356,382,,364,384,308],
   [,127,87,108,71,71,76,60,122,106,,,,,,,,,49,84,,,67,59,72,41,,51,51,56,
     46,70,,72,287,247,233,273,59,86,,,,47,90,,,46,88,,86,,120,349,301,297,
     ,361,283,61],[,,,,,,,62,79,66,,,,56,53,68,,,53,72,,65,,,,59,54,32,,,
     57,52,44,69,,280,174,228,,,,47,72,33,,,,47,67,72,54,,78,,334,238,312,,
     242,,51],[148,101,72,102,59,58,64,50,102,106,,,,61,66,83,,,41,90,,,
     82,62,89,,78,50,50,59,45,89,54,91,233,252,191,,48,72,,59,,38,76,,,
     38,72,87,72,,,307,292,247,264,335,236,46,61,44],
   [148,91,125,82,54,85,63,,,,,,,72,,88,,,,,,,82,,67,57,70,49,141,54,,,58,,
     376,352,281,312,76,64,,59,88,48,69,,,44,,,77,,105,382,408,333,388,374,
     320,56,49,49,68],[80,111,63,82,51,53,58,44,98,82,,,,35,50,49,,,39,
     70,,49,51,43,74,,52,37,37,44,34,54,,74,253,,161,235,47,78,,33,70,37,
     86,,,36,84,67,78,,70,297,245,211,231,297,175,45,,37,37,51],
   [80,124,101,71,51,61,54,86,,,,,,,,110,,,,104,,,57,,80,75,56,50,,49,81,78,
     54,,279,304,,274,56,65,,49,94,41,62,,,61,,96,,,133,359,422,316,374,
     413,308,45,61,40,46,,45],
   [30,,,,,24,,26,,83,,,,13,14,15,,,14,15,,15,46,,,44,50,,,,38,64,46,,55,59,
     ,55,21,,,22,23,,,,,22,,23,,,23,73,77,,73,75,,74,68,,54,76,62,73],
   [,33,26,44,33,22,32,20,42,44,,,,7,,,,,12,9,,9,40,33,51,37,,28,27,51,
     25,39,45,51,47,45,35,47,16,38,,14,,12,38,,,14,40,14,38,,14,61,59,
     49,61,59,49,60,45,48,46,58,35,60,11],
   [,,,,,,,14,,,,,,7,8,9,,,8,9,,9,,,,28,30,20,,,22,41,26,52,,,25,35,,,,12,
     13,9,,,,12,,13,,,13,,45,35,43,45,35,,44,36,36,,34,44,,7],
   [34,39,32,55,55,28,57,26,59,53,,,,13,14,15,,,14,15,,15,50,39,64,39,44,
     50,39,76,35,60,40,68,57,57,53,55,23,57,,22,23,27,63,,,22,53,23,57,,
     23,75,75,71,73,75,71,73,57,69,48,73,55,71,9,11],
   [30,38,26,54,43,,46,,,,,,,7,12,9,,,,,,9,40,35,53,43,32,28,33,57,,,44,
     52,47,,35,47,16,44,,14,14,12,60,,,14,,,44,,14,61,61,49,61,59,49,58,
     53,46,48,56,41,58,11,7,7,11],
   [18,27,18,30,15,14,24,14,32,30,,,,7,8,9,,,8,9,,9,26,23,41,23,28,20,
     19,29,19,33,,41,31,33,25,31,13,32,,12,13,9,30,,,12,28,13,32,,13,41,
     43,35,41,43,35,42,33,36,30,44,25,42,9,7,5,9,7],
   [30,62,30,71,,24,,26,68,,,,,13,14,15,,,14,15,,15,46,67,77,42,50,50,,86,
     38,67,46,,55,57,53,57,21,,,22,23,,,,,22,60,23,,,23,73,75,77,77,79,,
     71,66,72,56,75,62,74,9,11,,9,11,9],
   [30,33,26,42,,22,30,18,,42,,,,7,12,9,,,12,9,,,40,33,49,37,28,28,27,,
     27,37,40,49,47,45,35,47,16,36,,14,14,12,36,,,14,38,14,36,,,61,59,
     49,61,61,49,56,45,44,,,35,56,11,7,7,11,7,7,11],[],
   [,,,,,,,,,,,,,24,19,34,,,,,,34,,,,44,50,28,,,,,,,,116,78,92,,,,16,,,,,,,,,,,,,
     124,102,116,160,,,68,51,60,64,,65,,20,12,32,20,,,20],
   [,,,,,,,,,,,,,,,,,,,,,,,,,87,48,,,,,,48,,,,,,,,,41,72,,,,,,,,,,,,330,,340,,226,,
     61,,32,,37,,,46,,52,,30,60],
   [,,,,,,,,,,,,,,,,,,,,,,35,31,63,,35,25,23,43,31,53,25,63,,201,169,,,,,27,,,,,
     ,,,,,,,303,183,151,191,309,105,58,50,48,28,68,30,58,45,33,25,35,43,
     15,45,33,,,32],[,,,,,,,,,,,,,24,,34,,,24,30,,22,44,,82,62,58,,,,,66,74,
     ,114,112,94,118,22,40,,16,34,14,40,,,18,42,28,40,,26,154,132,114,146,
     ,114,68,74,,74,80,68,58,26,18,14,26,22,14,26,20,,16],
   [,,,,,,,,,,,,,57,49,85,,,,,,,70,46,93,87,,46,36,77,30,69,32,93,,234,,264,,,
     ,51,,,,,,,,,,,,384,284,478,256,,210,98,61,74,39,82,33,98,74,42,,46,,28,
     ,40,,,61],[,,,,,,,,,,,,,32,27,42,,,,,,42,,,,54,,,,93,,,,,,136,,134,,,,24,,
     ,,,,,,,,,,,198,,170,206,160,110,90,105,88,,,,,26,,32,26,18,30,26,,,,,22]
    ,[,,,,,,,,,,,,,35,45,47,,,42,80,,40,,,,45,42,,,,,,32,,261,160,189,132,,,,
     35,48,,,,,36,,54,,,44,301,200,229,172,337,152,54,33,44,32,56,25,54,
     56,30,,36,40,22,56,28,,,32,20,,33],
   [,,,,,,,,,,,,,59,,79,,,,,,,52,36,109,45,32,58,28,85,40,101,,105,,244,494,
     306,,,,43,,,,,,,,,,,,444,332,,,450,224,90,41,96,41,114,37,90,60,40,,48,
     52,30,98,38,,,37,,,,,37],[],
   [,,,,,,,14,,,,,,7,8,9,,,8,9,,9,,,,28,30,20,,,22,41,26,52,,,25,35,,,,12,
     13,9,,,,12,,13,,,13,,45,35,43,45,35,,44,36,36,,34,44,,7,5,,7,5,,7,,
     12,,25,14],[,,,,,18,,,,,,,,,,,,,,,,,,,,36,38,20,38,,,,26,64,37,43,25,
     31,16,,,16,,10,37,,,,59,,,,,47,53,35,,,35,45,52,36,44,51,34,42,11,11,
     5,11,11,5,11,11,,12,,,,,,,,,5],
   [,43,,,,20,30,16,,,,,,,,,,,8,,,,53,31,52,,,23,23,34,21,58,,52,86,86,30,
     86,17,28,,,,11,28,,,13,32,,28,,,98,98,42,98,98,42,67,56,37,,55,32,
     67,12,15,6,12,15,6,12,15,,13,,16,,,23,21,,,6],
   [,73,,,,24,,26,,,,,,7,13,,,,,9,,9,46,,60,46,34,28,46,,,42,52,,53,,35,,18,
     ,,14,,12,47,,,14,69,14,,,14,67,63,49,,,49,66,58,45,56,62,44,,13,7,
     7,13,7,7,13,7,,,,,18,,,44,,,7],[]],
 [,[],[],[],[,,,13],[,,13],[],[],[,,,,15,,23],[],[,,,,16],
   [,14,,,13,15,20,,18],[,,19,,30,,65],[,,14,20,,,20],
   [,14,14,,16,,32,,,,4,6,8],[,,28,,25,,46,,,,,,13],
   [,,15,25,14,,25,,,,,6,,,6],[,49,21,44,24,27,51,,70,,,,8,,8],
   [,,,,16,,,,,,4,,,,4],[,,,,37,,,,,,,,,,,11,,13],
   [,,19,,30,,69,,,,,,8,,8,13,,8,,13],
   [,,28,61,29,,60,,,,,,13,,,11,,13,,11],
   [,,,,21,25,,,,,17,,,23,,75,18,,17,,49],
   [,,,,,20,,,,,,,,19,16,39,19,27,,37,49,39],
   [,18,,,,33,,,21,,,23,,19,24,70,26,65,,,56],
   [,,21,22,17,16,26,,24,,14,15,34,13,,,,33,14,,34,49,17,15,17],
   [,25,31,31,24,23,43,,28,,21,21,37,,16,,26,31,21,56,37,52,22,19,21],
   [,,39,,,,,,25,,15,22,35,20,16,42,23,35,15,42,35,40,,,,,22],
   [,,23,,,,,,,,,21,,,,,22,35,,,,,,17,,13,17],
   [,,39,23,17,,,,24,,20,21,42,19,24,43,23,42,20,49,45,47,21,,,17,21],
   [],[,,,,22,33,33,,,,20,,,21,,59,,,20,,55,74,,,,19,23,21,,22],
   [,28,31,31,24,23,,,31,,21,21,41,28,18,48,22,35,21,43,41,40,21,19,21,,
     15,,17,21,,23],[,25,42,23,17,,25,,24,,,24,57,22,24,57,29,60,,,,57,
     23,,23,17,23,,,17,,23],
   [,,,,,74,163,,,,26,,,35,24,,,68,26,,63,,,,,72,95,94,112,,,119,95,116],
   [,,,97,59,93,114,,,,,,,31,,,44,,,,,105,,121,99,63,,115,147,99,,104,,100],
   [,92,,,,,,,,,20,32,44,25,20,55,32,44,20,55,44,55,105,,109,69,95,77,,,,
     119,99,120,27,26],
   [,,,70,53,68,,,83,,23,,85,34,,97,,,23,99,73,,,121,,61,84,105,115,91,,
     120,84,91,24,32],
   [,,,,12,9,23,,,,7,,,8,8,22,9,21,7,,,22,16,,,13,19,15,15,18,,18,19,18,
     40,40,37,40],[,,,,17,,28,,,,,,,21,20,46,25,53,,,,47,,,,32,41,32,,29,,
     ,37,,,104,,86],[,,,,28,21,53,,,,,,,11,10,11,,11,,11,11,11,,28,,,32,
     38,28,44,,,39,,,74,49,73],
   [,,11,13,10,9,17,,,,7,9,11,5,,,9,11,7,17,11,,16,15,17,11,,16,13,17,,
     19,23,17,31,30,25,29,7,17,9],
   [,,37,,30,27,55,,,,,,16,,,,,,,14,16,13,71,42,67,,,44,37,47,,58,49,69,128,
     ,62,125,,,14],[,15,11,19,,,,,18,,7,9,11,5,6,11,9,11,7,11,11,11,
     16,16,18,12,17,15,,,,20,17,20,31,33,25,29,7,,9,5,13],
   [,26,,24,,,,,40,,,23,,21,22,51,,,,,,53,52,,36,,45,,,,,,39,31,,121,,115,,,,
     19],[,11,11,13,10,9,19,,17,,7,9,21,8,8,22,,,7,,21,22,,15,17,11,
     15,15,13,17,,,15,17,38,39,37,38,7,19,,7,,7],
   [,,28,,28,21,53,,,,,,11,11,10,11,,,,11,11,11,,30,65,33,37,38,29,43,,64,
     45,67,88,99,49,,,,9,9,,9],
   [,,,,14,11,27,,,,,,,5,6,15,,,,,,15,,,,,17,18,14,22,,,16,,,35,25,31,,,,5,,
     5],[,,,,19,,26,,,,,,,23,22,50,28,59,,,,53,,,,33,39,28,,30,,,34,32,,
     105,193,93,,,,19,,,22,22],
   [,,,,30,27,55,,,,,,,,,13,,16,,,16,13,,,,,,45,38,50,,,45,,,,62,,,,,,12,13,,,
     14],[,26,,24,,,21,,40,,,26,,23,22,51,31,,,,,51,40,,35,33,39,,,28,,
     49,36,,,,149,112,,23,,19,,,17,,,,23],
   [,,22,,28,21,53,,,,,,11,11,10,11,,11,,11,,11,,34,,,33,38,28,44,,,36,,,,
     49,71,,,9,9,14,9,,,9,,,14],
   [,,37,,30,27,55,,,,,,16,,,13,,16,,14,,,71,42,69,,,44,37,47,,58,47,67,
     146,144,62,136,,,14,,12,13,,,14,,,12],
   [,,,,88,78,,,,,,,,43,32,131,60,81,,,101,123,134,,,88,125,,148,136,,145,
     130,148,187,213,167,188,,,,39,,39,,55,,,,,278,114,148],[],
   [,,152,135,,,,,189,,28,44,60,35,28,77,44,60,28,77,60,77,132,,,92,124,
     107,,,,147,127,151,,187,140,,51,169,67,35,86,35,,51,67,35,180,86,223,
     67,86,35],[,94,107,96,73,90,148,,117,,34,,80,44,32,,,,34,164,,118,,,
     129,83,114,,131,125,,142,114,125,197,,178,192,53,123,98,41,147,41,157,
     52,,44,131,203,,,,32,,35],
   [,,,,88,78,,,,,,,,41,32,,,99,,,,111,,,,86,133,122,,138,,,126,148,,233,,,,,,
     39,155,39,272,55,99,,,,330,114,161,,,32,40],
   [,83,,,74,63,,,118,,28,42,56,35,28,77,42,56,28,77,56,77,134,179,133,81,
     ,107,95,129,,142,,131,,187,140,,49,126,63,35,84,35,130,49,63,35,134,
     84,130,63,84,,,28,33],
   [,,,,31,38,,,,,24,,,28,24,80,27,56,24,,66,109,23,,,25,29,,35,31,,25,29,
     35,125,145,125,121,21,,,23,63,23,48,21,71,,,,50,60,76,165,,164,164,,
     181],[,,41,40,31,30,44,,41,,28,27,56,23,,,,49,28,,56,63,27,29,30,
     19,,30,24,28,,29,23,28,130,111,126,107,25,54,,19,,22,70,19,52,26,54,
     77,53,66,,163,,165,145,161,145,25],
   [,32,60,34,,,,,38,,25,28,56,28,24,62,29,53,25,60,50,58,,57,30,28,31,
     22,,,,30,32,29,132,147,124,124,25,41,53,25,61,22,,22,54,25,43,63,40,
     54,63,175,,168,168,177,174,,28],
   [,28,31,31,24,23,,,31,,21,21,45,20,18,50,,,21,55,45,60,,25,26,19,23,
     24,20,24,,27,23,26,97,96,95,84,19,43,43,17,,17,44,15,,19,43,83,43,
     43,68,125,,125,114,124,121,21,19,23],
   [,,,,29,42,37,,,,,,,28,26,72,30,71,,,74,,,,,27,31,31,39,29,,,31,32,,145,,
     123,,,,25,69,25,58,24,66,24,,,58,67,75,,,179,169,170,174,,27,31,24],
   [,38,41,40,31,30,46,,41,,28,27,48,23,24,51,27,39,28,57,48,51,27,29,
     30,19,23,28,24,28,,29,,28,,111,124,107,25,48,46,19,57,22,48,19,46,
     26,48,55,48,46,55,167,,162,145,164,145,25,19,27,19,27],
   [,29,53,35,24,31,35,,34,,24,30,59,28,,72,33,54,24,66,,70,30,43,27,28,
     ,24,,24,,28,35,,132,139,121,116,24,,54,23,63,21,41,21,73,24,44,,,,
     76,171,,165,,171,175,28,28,23,21,27],
   [,,,,34,23,62,,,,10,,,18,12,23,19,14,10,,14,23,47,,,36,49,43,,52,,54,49,
     ,66,77,54,63,19,,,17,28,15,84,19,19,,,,,19,28,87,,74,86,,70,62,62,
     65,49,,58,62],[,,36,45,32,45,54,,52,,15,24,19,15,,,,,15,21,19,21,
     53,49,53,35,,49,,53,,57,53,55,78,78,67,79,22,51,19,15,,15,55,22,21,
     15,57,25,56,19,25,103,,93,105,103,93,69,61,72,50,72,61,70,15],
   [,35,19,39,,,,,45,,10,12,14,15,8,21,12,14,10,21,14,21,34,27,39,25,31,
     23,,,,46,27,39,43,66,30,47,15,35,17,11,26,9,,15,17,13,,26,37,17,26,
     59,,42,67,59,42,41,41,36,33,56,35,41,10,14],
   [,33,29,39,30,23,54,,45,,10,19,14,,12,,,,10,23,14,23,,37,49,33,43,43,
     37,49,,58,43,49,63,71,54,68,19,47,19,17,,15,67,19,,16,56,28,69,19,
     28,86,,74,86,86,70,59,53,62,43,64,49,59,10,,10],
   [,,,,37,,75,,,,,,,15,14,21,24,19,,,19,21,,,,37,49,50,56,59,,,48,61,,85,
     67,76,,,,15,26,15,105,24,19,15,,,,19,26,,,93,104,102,93,,66,71,51,70,
     65,66,,13,14,15],[,27,19,29,16,13,27,,40,,10,12,14,15,8,21,12,14,
     10,21,14,21,34,25,37,23,31,23,19,29,,48,,37,,62,30,49,15,31,17,11,
     24,9,33,15,17,13,,24,33,17,24,61,,42,63,59,42,43,35,38,31,56,29,
     43,10,14,6,10,14],
   [,40,27,53,34,23,61,,52,,10,19,14,18,12,23,19,14,10,23,,,48,59,53,36,
     49,43,,53,,62,49,,66,70,54,67,19,,19,17,28,15,81,19,19,16,,28,,,,89,
     ,74,,89,70,66,62,65,49,67,58,64,10,15,10,10,15,10],
   [,40,36,40,31,45,54,,,,15,24,19,15,14,21,24,19,15,21,,,57,49,53,35,
     48,50,,53,,59,48,53,80,79,67,78,22,48,19,15,25,15,55,22,19,15,55,
     25,55,21,,102,,93,105,104,93,66,61,72,48,75,61,66,15,13,14,15,13,14 
    ],[,,,,,,,,,,,,,,,,20,,,,,,,,,,21,,,,,,,,,115,,,,,,15,,17,,13,62,14,,,,,,,,
     128,,,103,,29,,,,27,37,,49,39,37,,31],
   [,,,,,,,,,,,,,16,14,38,,,,,,38,,,,,37,27,,34,,,38,,,76,64,,,,,13,,,,,,,,,,,,,,
     84,104,,76,,52,43,39,,,,,34,16,34,,22,,34],[],[],
   [,,,,,,,,,,10,14,24,16,,28,13,24,10,35,24,27,31,,,,36,,,,,33,,,72,,191,
     71,10,24,25,13,28,10,27,10,25,11,25,31,27,25,26,,,127,91,,80,47,52,
     ,41,52,48,36,30,34,16,30,41,16,30,35,,13],
   [,,,,,,,,,,,,,,22,,,,,,,,29,26,34,,21,29,26,34,,35,18,37,185,156,,138,,,,23,
     ,,,,,,,65,,,,201,,241,,,160,39,,40,23,40,23,48,,71,,59,,58,,,21],[],
   [,,,,,,,,,,,36,70,32,32,60,24,42,,94,70,,,,,,33,,,,,,,,334,161,,129,30,,50,
     23,57,,,18,43,27,,55,,50,53,,,,165,259,176,34,23,37,,35,23,34,78,68,,
     50,102,28,78,,,,,,,27],[],
   [,,,,14,11,27,,,,,,,5,6,15,,,,,,15,,,,,17,18,14,22,,,16,,,35,25,31,,,,5,,
     5,,,,5,,,,,,,,35,44,,35,,26,25,19,24,26,24,,15,13,16,15,13,16,15,14,,,
     ,11,,,27],[,,,,20,13,37,,,,,,,,8,,,,,,,,,,,28,33,23,,30,,,29,43,,,30,,,,
     ,13,,11,57,17,,,,,,,,,,42,69,,42,,46,40,37,,38,50,,,6,,,6,,,,14,,,16],
   [],[,,,19,,11,,,,,4,7,10,5,4,11,7,10,4,11,10,11,21,21,23,,21,16,15,
     23,,22,,,25,25,20,25,8,18,11,5,12,5,21,8,11,5,19,12,21,11,12,33,,
     28,33,32,28,25,26,24,17,29,26,25,12,13,6,12,13,6,12,13,,11,,,,,,,,
     5,6],[],[,12,14,20,12,,20,,,,,,,5,6,,,,,15,,,21,19,19,13,18,18,,
     19,,20,18,22,33,31,25,34,8,19,11,5,14,5,19,8,11,5,20,14,20,11,14,
     42,,35,44,41,35,25,23,25,18,25,23,25,16,15,13,,15,13,16,15,,12,,,12,
     ,,24,,5,,,5],[,39,23,38,16,17,31,,74,,,,,,8,,,,,,,,,29,49,27,27,23,
     23,30,,,23,48,52,115,30,61,17,29,,13,,11,32,,,,31,,,,,67,,42,,83,42,
     50,39,37,33,86,29,44,12,15,6,12,15,6,12,15,,,,,16,,,26,,,6,,6]],
 [,[],[],[],[],[,,22],[,20,,37],[,,,,,16],[,,,,,,33],
   [,32,,37,,,32,,61],[,,,,,,,12],[,17,,,,24,22],[,,30,,,,56],
   [,,32,59,,24,35,24,57],[,,38,,,,52,28,,,,15],
   [,15,18,32,,18,20,14,32,,5,7,9],[,,24,,,,32,16,,,,7,,,,7],
   [,51,32,75,,42,39,34,81,63,,,9,,,9],[,,,,,28,36,,,58,,,,,11,,15],
   [,,,,,,,12,,,5,,,,,5],[,,42,,,,56,,,,,,9,,,9,,9],
   [,15,18,34,,18,22,12,34,34,5,7,9,,,5,7,9,,5,9],
   [36,,,,,44,40,,,50,,,,,,32,,54,,,,28],
   [,,,,,32,,,,,,,,39,39,23,27,43,,,61,23],
   [,25,,,,,35,,,55,,29,,60,86,25,37,70,,,67,27],[],
   [,,78,136,,54,60,60,76,,50,48,98,,47,,,,48,50,98,40,,48,47],
   [,25,,58,,,,28,46,,20,27,40,28,40,20,28,40,42,20,40,20,34,,25,,43],
   [,,37,,,,,27,,,,31,,31,,23,,51,37,,,23,,27,,,39],
   [,50,,81,,,,,75,70,86,43,69,68,130,37,,62,81,86,65,39,41,,46],
   [,,,,,26,,,,,,,,31,32,17,20,41,,,,19,,,,,39,,21],
   [,,,,,,41,,,75,,,,42,,33,,84,43,,,39,,,,,46,31,,56],[],
   [,30,86,57,,,30,,59,,,33,67,68,,25,37,70,55,,,27,33,,30,,51,,,41,,42],
   [142,,,,,110,,,,,37,,,61,133,,,69,,37,71,37,192,,,,381,156,191],
   [,,,240,,112,170,96,222,,43,,77,47,,,59,,118,43,67,33,200,175,189,,,164,
     137,275,153,223,,183,61],
   [,,,,,,,80,,,25,37,49,35,55,25,37,49,55,25,49,25,192,,156,,202,100,,,
     185,185,,157],[,,134,306,,118,132,92,264,,31,,75,,,37,,,106,31,87,,,
     173,,,,156,137,335,123,205,,,33,,35],
   [18,,,,,14,24,12,,,8,,,20,22,9,10,22,,8,,9,26,,,,46,20,21,40,,,,26,62,
     68,42,56],[,,,,,,33,,34,57,,,,45,50,28,38,63,,,,30,,,,,100,44,,61,,,,
     57,,188,,166],[,,,,,28,42,,,,,,,,,11,,12,,,12,11,,40,,,,43,36,66,,,,,,
     95,54,135],[,,24,40,,18,24,18,26,,16,18,30,14,,,,,18,16,30,,,31,33,,
     ,26,25,51,25,31,,37,88,78,64,,16,28],
   [24,,21,37,,16,26,21,,46,8,10,12,,,,10,12,,8,12,7,32,26,30,,,23,21,41,
     20,45,,31,49,,30,49,8,,10],
   [,19,18,46,,,,12,54,,8,10,12,14,18,7,10,12,18,8,12,7,28,24,26,,38,20,
     ,,18,34,,29,46,54,30,50,8,,10,14,6],
   [,36,,45,,,,,35,52,,34,,43,50,28,38,63,50,,,30,60,,51,,,,,,,47,,50,430,
     194,,168,,41,,26],[,15,18,34,,14,20,12,36,,8,10,22,,,9,,,22,8,22,9,
     ,23,25,,,20,19,45,17,37,,25,56,62,42,62,8,32,,,8,8,32],
   [,,39,,,28,42,,,,,,12,,,11,,,,,12,11,,46,77,,,43,37,63,57,101,,80,101,89,
     54,,,,10,,10,10],[,,,,,18,36,,,,,,,14,18,14,18,30,,,,14,,,,,42,26,29,
     48,,,,40,,86,64,80,,,,12,,14,,16],
   [,,,,,,33,,,57,,,,45,48,28,38,63,,,,30,,,,,68,44,,61,,,,57,,182,292,180,,,,
     26,,,37,32],[,,,,,16,26,,,,,,,,,7,,,,,,7,,,,,,23,20,50,18,,,,,,30,61,,,,
     ,6,6],[,36,,45,,,28,,35,,,40,,45,50,28,38,63,40,,,30,60,,51,,100,,,
     54,,47,,,,192,244,176,,29,,28,,,36,32,,,41],
   [,,45,,,28,42,,,,,,12,,,11,,12,,,,11,,46,,,,43,36,62,,,,,,,54,100,,,10,,10,
     10,,,10],[24,23,21,37,,16,26,15,,46,8,10,12,,,7,10,12,,8,12,,32,
     26,30,,,23,21,41,22,45,,,45,45,30,53,8,,10,,6,6,,8,10,,,6,,10],
   [178,,,,,134,,136,,,53,,,67,131,43,76,95,,53,87,43,240,,,,350,200,,490,,,,,
     277,287,225,265,82,,,104,,60,376,78,155,,,,416,116,59],
   [334,,170,298,,140,198,114,274,366,47,73,,61,,,82,93,,47,,43,280,221,245,,
     ,188,173,377,171,273,,261,291,273,221,,78,222,111,102,,58,252,84,,104,
     232,73,232,,57,71],
   [,,,,,,,,,,35,51,67,49,77,35,51,67,77,35,67,35,220,,,,262,140,,,171,242,,
     223,243,249,175,245,58,274,74,88,42,42,,58,74,88,278,42,363,74,42,
     45,43],[,,170,286,,130,180,120,294,,47,73,87,75,150,,,,123,47,87,43,
     ,213,227,,452,244,189,,161,259,,245,269,291,245,279,78,236,109,116,57,
     66,214,78,,100,208,67,246,109,,43,71],
   [,,,,,146,,,,,,,,65,,43,,95,,,,43,,,,,316,188,,408,,,,289,,309,233,315,,,,
     100,59,60,492,82,147,108,,,,163,61,,45,,59],
   [150,105,160,224,,114,152,,210,226,35,51,67,49,77,35,51,67,77,35,67,35,
     212,191,187,,,140,143,409,147,223,,187,,247,175,267,58,190,74,84,42,
     42,194,58,74,84,196,42,194,74,42,49,43,35,49,43],
   [68,,,,,68,59,58,,87,,,,74,78,42,48,88,,,,42,44,,,,98,51,63,70,,,,50,278,
     290,225,262,38,,,59,41,42,77,41,87,,,,73,78,43,355,370,299,334,,308],
   [],[,48,105,96,,,,51,74,88,36,38,68,56,58,34,37,68,62,36,65,34,57,
     91,44,,62,32,,,51,54,,37,244,260,173,228,35,67,68,45,35,32,,33,69,
     47,67,36,58,69,36,305,314,237,302,309,242,51],
   [,59,72,109,,50,56,52,87,,41,38,73,61,74,32,,,50,41,71,34,,54,51,,119,
     50,41,,42,63,,57,236,212,190,188,36,72,71,59,,32,72,29,,44,74,39,68,
     69,33,290,278,246,244,298,234,40,,46],
   [,,,,,76,57,,,105,,,,72,79,42,46,86,,,86,46,,,,,63,45,71,78,,,,58,,292,
     237,298,,,,47,43,42,69,43,107,44,,,65,82,56,,346,311,336,345,304,,,45,
     50],[80,45,63,96,,44,50,45,80,90,34,33,58,35,56,25,34,49,51,34,
     58,25,57,43,42,,51,35,34,,33,52,,40,,185,167,,31,82,56,33,30,28,,25,
     56,45,82,32,82,56,30,291,233,217,221,285,175,45,,35,,43],
   [80,58,,90,,58,54,65,98,,42,63,86,,,46,,86,70,42,,42,51,101,52,,,50,,
     65,59,74,,,268,286,227,274,41,85,78,,41,40,80,41,99,61,85,44,,,45,
     347,396,303,352,367,308,45,,46,40,61,45],
   [30,,,,,,56,28,,,11,,,13,23,13,20,15,,11,15,13,50,,,,74,48,,110,,,,,61,
     61,59,61,20,,,24,18,16,88,20,20,,,,,20,18,83,83,81,89,,81,79,,80,69,
     ,68,82],[30,,26,40,,20,30,22,42,50,11,13,15,7,,,13,15,14,11,15,9,
     40,33,45,,,28,25,49,27,37,,47,45,45,35,47,17,34,19,14,,11,36,17,19,
     14,36,15,34,19,13,57,59,49,61,57,49,56,,48,40,56,35,60,11],
   [30,41,26,56,,,,20,50,,11,13,15,7,11,9,13,15,11,11,15,9,40,35,47,,40,
     28,,,29,38,,50,45,,35,47,16,60,18,14,12,10,,16,18,14,,14,62,18,12,
     57,61,49,,57,49,54,,46,42,54,41,58,11,7],
   [,37,40,52,,38,44,28,60,,11,20,15,13,23,13,,,,11,15,13,,53,59,,69,48,
     45,69,39,69,,59,65,61,59,65,20,56,20,24,18,16,56,20,,28,60,17,56,
     20,18,85,83,81,87,91,81,81,,77,63,83,59,79,11,11,11],
   [,,,,,,44,,,,,,,7,13,9,,,,,,9,,,,,42,28,,62,,,,53,,,35,,,,,14,14,12,68,18,,
     14,,,,,14,,63,49,61,67,49,,,48,49,,44,66,,7,7],
   [38,33,26,40,,,30,20,42,50,11,13,15,7,11,9,13,15,11,11,15,9,40,33,45,
     ,42,28,31,49,27,37,,47,,45,35,47,16,40,18,14,12,10,34,16,18,14,40,
     14,42,18,12,57,59,49,61,57,49,56,,48,40,56,35,60,11,7,7,11,7],
   [30,45,50,66,,,56,28,,,11,20,15,13,23,13,20,15,,11,,13,50,71,63,,74,48,
     ,75,43,68,,,61,65,59,,20,,20,24,18,16,88,20,20,,,17,,,18,83,95,81,,
     89,81,82,,77,67,86,68,81,11,11,11,11,,11],
   [30,33,26,38,,20,28,20,40,,11,13,15,7,13,9,13,15,14,11,15,,40,33,43,,
     34,28,25,47,29,35,,,45,45,35,47,17,32,19,14,13,11,34,17,19,14,34,
     15,32,19,,57,59,49,61,57,49,52,,44,38,52,35,56,11,7,7,11,7,7,11],
   [,,,,,,,,,,,,,,,15,21,,,,,15,,,,,41,,,,,,,,,185,,,,,,27,19,18,,15,60,,,16,,,,,
     177,150,149,,105,,,39,47,,30,51,,31,37,37,,31],
   [,,,,,,,,,,,,,24,28,18,24,42,,,,18,,,,,90,36,,62,,,,58,,110,86,106,,,,18,,,,
     22,,,,,,,,,134,114,140,150,110,,,62,58,60,72,86,,18,22,34,18,26,,18],
   [,,,,,,,,,,,,,,,36,,85,,,,34,,,,,,,,,,,,,,244,,,,,,,29,56,,31,79,,,,,,33,,300,,
     272,,226,,,,30,,35,,,44,52,67,,44,,42],
   [,,,,,,,,,,,65,,,,27,,39,83,,,27,,,,,,,43,,,,,,,219,,,49,,49,41,28,,,35,40,
     61,,39,,43,28,865,313,690,,662,387,,,110,100,,,124,,33,39,45,,33,,33],
   [,,,,,,,,,,18,19,24,24,,14,31,26,31,18,24,14,36,,61,,80,,,,,,,,120,96,,
     104,14,44,25,18,15,14,44,16,27,16,44,17,44,25,15,140,128,140,134,,
     138,63,,,65,89,76,61,30,20,20,32,24,20,30,22,,18],
   [,,,,,,,,,,,,,57,,36,,,,,,34,,61,95,,41,,,,40,,,95,699,284,,288,,,,41,,48,,
     39,,,,74,,114,,701,310,1572,288,,232,,,,45,99,33,,,44,58,73,,44,,,41],
   [,,,,,,,,,,,24,30,32,,18,,32,38,,42,18,,,,,106,,,,,,,,,,,134,18,52,31,24,
     19,18,52,22,33,20,52,23,52,35,19,,170,,170,,160,93,,,93,,104,101,,26,
     26,40,,26,50,26,,22],
   [,,,,,,,,,,,37,77,35,46,24,34,47,60,,77,22,,,,,46,,,,,,,,339,168,464,150,
     32,,54,35,24,,,23,49,50,,31,,54,23,,232,302,206,502,160,54,,46,30,58,
     25,54,85,32,,55,,32,85,30,,,30,,,39],
   [,,,,,,,,,,,,,59,63,36,42,73,,,,34,112,,,,38,,40,,,105,,,,220,,238,,,79,51,
     33,56,,31,,,,38,,79,33,592,296,,278,481,220,71,,69,41,83,35,71,72,44,
     52,59,,44,72,42,,,35,,,46],
   [,,,,,16,26,,,,,,,,,7,,,,,,7,,,,,,23,20,50,18,,,,,,30,61,,,,,6,6,,,,,,6,,,6,
     ,73,42,67,,42,,,36,39,,32,44,,15,14,17,,14,17,15,16,,,39,17,74,23,
     31,38],[,,,,,,44,,,,,,,7,13,9,,,,,,9,,,,,42,28,,62,,,,53,,,35,,,,,14,
     14,12,68,18,,14,,,,,14,,63,49,61,67,49,,,48,49,,44,66,,7,7,,7,7,,7,,
     18,,,24],[],[],[,,,,,14,,,,,5,8,11,7,11,5,8,11,11,5,11,5,28,,,,
     38,20,22,,,33,,33,33,,25,,9,30,12,12,6,6,30,9,12,12,30,6,30,12,6,
     43,43,35,43,,35,44,,33,37,44,34,,13,7,7,13,7,7,13,7,25,14,,,,,,,,6,
     7],[,16,23,,,,21,13,,,,,,,,7,,,,,,7,,29,27,,35,23,,45,19,,,30,43,43,
     30,86,9,28,12,13,6,6,25,9,12,13,28,6,26,12,6,58,61,42,61,64,42,
     53,,36,34,47,29,67,17,15,14,,,14,17,15,,16,,43,20,,,30,,6,,,,6],
   [,45,32,55,,22,31,22,51,,,,,7,13,9,,,13,,,9,,39,56,,,28,29,60,29,38,,
     60,57,47,35,,18,39,,14,14,12,35,,,14,39,,39,,14,67,61,49,71,63,49,
     66,,48,53,62,35,,13,7,7,13,7,7,13,7,,22,,45,22,51,32,31,55,,7,,,7]
    ,[]],[,[],[],[],[],[],[],[,,,,,16],[],[],[],[],
   [],[,,,,,22,,22],[,,,,,,70,24],[,,,,,30,56,24],[],[],
   [,,,,,19,58,,,,,,,,10],[,,,,,,,22,,,,,,,,11],[],
   [,,,,,30,,,,,,,,,,11,,,,11],[,,,,77,42,66,,,,,,,,,74,,,59],[],
   [,,,,133,50,152,,,,,,,92,63,67,,,57,83,,92],
   [,,,,,31,,36,,,,,,36,,,,,34,,,60,,,48],
   [,,,,,42,101,46,,,,,,,39,,,,41,70,,54,52],
   [,,,,,,,36,,,,,,28,35,40,,,35,40,,40,28,,51,38,33],
   [,,,,,,,30,,,,,,51,,75,,,31,,,81,,,,,58],
   [,,,,31,,,143,,,,,,92,,,,,,136,,,57,,90,78,63],
   [,,,,,27,,,,,,,,51,32,,,,,,,37,,,,29,34,,25],
   [,,,,,46,70,,,,,,,52,,58,,,42,,,72,,,45,,36,33,,63],
   [,,,,,34,78,38,,,,,,78,,98,,,37,,,66,,,,,32,27,,41,28],[],
   [,,,,,98,443,118,,,,,,55,85,,,,,63,,81,216,,,201,298,162,309],
   [,,,,,,,112,,,,,,53,,,,,73,,,,184,,,165,,158,214,301,196,270,,,49],
   [,,,,,,,94,,,,,,35,44,49,,,44,49,,49,160,,262,151,186,100,,,200,183,149,,
     37],[],[],[,,,,78,,,,,,,,,81,73,86,,,,,,93,,,,96,98,74,,97,,74],
   [],[,,,,,16,44,18,,,,,,14,,,,,17,22,,,32,,47,29,,26,40,48,27,35,64,,86,
     80,64,,,58],[,,,,,31,,35,,,,,,,,,,,,18,,18,70,,80,,,52,70,,46,82,81,,
     171,,69],[,,,,,,,14,,,,,,14,15,16,,,15,16,,16,30,,,29,32,20,,,23,33,
     28,,67,65,45,,,,,12,13],
   [,,,,,,,,,,,,,81,43,120,,,68,,,115,62,,96,,74,,,,,62,120,,805,,,,,76,,34],
   [,,,,,16,,20,,,,,,20,21,22,,,21,22,,22,44,,,29,40,,34,,31,57,40,,95,95,
     101,,,,,16,17],[],
   [,,,,,14,64,,,,,,,14,17,24,,,,,,22,36,,59,28,36,26,25,80,,,32,,,78,64,,,,,
     14,,12,,16],[],[,,,,,31,76,,,,,,,,,18,,,,,,18,72,,89,55,,52,64,,37,,
     67,,,182,69,,,,,,15,13,,17],
   [,,,,,,,,,,,,,81,73,98,,,75,,,93,102,,197,,123,,,94,,,,,,,,,,73,,58,,,58],
   [],[,,,,,31,108,35,,,,,,,,18,,,,18,,,70,,,,,52,70,165,44,82,81,,156,143,
     69,,,,,,15,13,,17,,,,15],
   [,,,,366,112,,144,,,,,,67,,85,,,,,,85,264,,,233,312,192,374,395,254,300,,,
     307,281,227,,,,,108,,81,417,115,,100,,172,879,,154],
   [,,,,,114,477,152,,,,,,67,,,,,98,,,,240,,380,203,,186,241,413,233,363,293,,
     315,279,225,,,627,,106,,83,414,133,,,,165,,,238,59],
   [,,,,,,,,,,,,,49,60,67,,,60,67,,67,212,,,199,234,140,,,200,245,197,,261,
     255,175,,,,,88,95,63,,149,,88,,95,951,,95,43,49],
   [,,,,640,108,,132,,,,,,61,86,,,,,93,,91,256,,321,233,260,248,250,584,247,
     285,224,,289,277,231,,,,,100,169,83,358,121,,102,,168,678,,,49,59,43],
   [,,,,,112,559,,,,,,,65,80,,,,,,,85,220,,358,217,298,,,469,,,272,,,281,249,,,
     723,,104,149,83,,109,,100,,,755,,,53,43],
   [,,,,165,96,,108,,,,,,49,56,67,,,56,67,,67,,,,195,,140,193,249,161,258,,,,
     245,175,,,,,84,95,63,281,95,,84,,95,487,,95,,49,35,43,49],
   [,,,,78,61,75,70,,,,,,72,60,86,,,74,,,,46,,,,58,45,,68,,53,,,322,288,228,,,
     ,,53,84,48,76,68,,53,,95,127,,94,372,372,308,364,356],
   [,,,,,53,,60,,,,,,56,,,,,56,,,84,,,64,43,,53,58,98,48,,46,,297,263,227,,,
     130,,47,,47,,51,,48,,84,133,,99,353,339,301,339,347,291],
   [,,,,,,,62,,,,,,56,50,65,,,50,72,,65,51,,74,59,54,30,,,62,54,44,,259,256,
     162,,,105,,45,74,30,,,,45,,74,96,,77,290,302,222,272,,234,45,51],
   [,,,,,42,82,48,,,,,,53,61,73,,,45,75,,70,58,,65,55,62,,60,,43,65,50,,
     268,238,194,,,108,,45,,38,68,40,,38,,67,,,66,297,303,256,278,291,249,
     44,49,38],[,,,,112,57,117,,,,,,,72,74,,,,,,,92,58,,59,51,,53,79,98,,,
     55,,,304,254,,,102,,57,123,48,92,62,,45,,,111,,107,356,,314,354,378,
     318,52,45,51,52],
   [,,,,70,45,85,50,,,,,,44,53,58,,,48,70,,58,,,,55,48,37,40,52,40,58,,,,
     237,173,,,,,39,73,37,89,47,,42,,73,132,,73,,293,235,293,301,223,,41,
     37,39],[],[,,,,53,22,,26,,,,,,13,14,15,,,14,15,,15,46,,,44,63,,,69,
     42,61,,,57,55,,,,,,22,23,27,134,23,,22,,23,,,23,73,73,71,75,75,,78,
     76,65,65,80],[,,,,53,20,46,20,,,,,,7,,,,,12,9,,9,36,,47,31,,28,41,
     69,27,39,46,,45,43,35,,,62,,14,,12,60,16,,14,,14,62,,14,57,61,49,57,
     57,49,58,49,46,42,58,41,,11],
   [,,,,,,,14,,,,,,7,8,9,,,8,9,,9,26,,39,25,32,20,,,23,34,28,,33,31,25,,,,,
     12,13,9,,13,,12,,13,,,13,41,41,35,41,41,35,42,43,32,34,42,37,,9,7],
   [,,,,53,22,,26,,,,,,13,14,15,,,14,15,,15,46,,62,48,58,,68,71,42,60,68,,
     57,57,53,,,,,22,23,,,21,,22,,23,,,23,73,75,77,73,73,71,78,78,,60,78,
     74,,9,11,9],[,,,,65,,68,,,,,,,7,12,9,,,,,,9,36,,49,33,36,28,,75,,,44,
     ,,43,35,,,96,,14,14,12,112,16,,14,,,96,,14,57,61,49,57,57,49,56,55,
     44,44,56,47,,11,7,7,11],
   [,,,,24,12,,14,,,,,,7,8,9,,,8,9,,9,,,,26,35,20,,36,22,40,,,,,25,,,,,12,
     13,9,71,15,,12,,13,,,13,,43,35,43,43,35,,42,36,37,,34,,,7,5,,7],
   [,,,,52,22,,26,,,,,,13,14,15,,,14,15,,15,48,,82,44,58,44,,73,42,65,72,,
     59,55,59,,,,,22,23,27,137,21,,22,,23,,,23,77,73,77,73,73,77,80,76,
     65,60,78,76,,9,11,9,9,11],
   [,,,,55,20,56,18,,,,,,7,12,9,,,12,9,,,36,,45,31,32,28,42,69,29,37,40,,
     45,43,35,,,62,,14,14,12,62,16,,14,,14,62,,,57,61,49,57,57,49,54,49,
     42,40,54,41,,11,7,7,11,7,7,11],[],
   [,,,,,,,,,,,,,28,25,36,,,,,,36,,,,,86,,,,,,,,,142,,,,,,22,,,,,,,,,,,,,162,,,192,
     120,,106,,103,89,72,,,24,,,26,16,,24],[],
   [,,,,,,,,,,,,,,,,,,,,,,55,,56,,55,29,28,56,35,52,29,,,,161,,,,,,,,,,,,,,,,,328,
     ,194,321,,154,59,74,48,36,63,43,,52,44,35,53,59,24,53,49],
   [,,,,,,,,,,,,,28,,,,,24,26,,22,38,,64,,46,,,,,48,,,110,110,94,,,72,,22,,14,
     44,20,,18,,33,72,,27,130,144,114,134,,112,64,104,,74,82,66,,26,18,14,
     26,22,14,26,20,,22],[],[],[],[],[],
   [,,,,24,12,,14,,,,,,7,8,9,,,8,9,,9,,,,26,35,20,,36,22,40,,,,,25,,,,,12,
     13,9,71,15,,12,,13,,,13,,43,35,43,43,35,,42,36,37,,34,,,7,5,,7,5,,7,
     ,16,,24,14],[,,,,,12,,,,,,,,,,,,,,,,,38,,66,36,44,20,24,,,64,26,,,37,
     25,,,59,,,,10,37,16,,16,,,59,,,53,47,35,53,47,35,54,46,33,44,48,34,,
     11,11,5,11,11,5,11,11,,18,,,,,,,,,5],
   [,,,,,14,46,16,,,,,,,,,,,8,,,,,,47,,128,23,21,,24,,,,115,58,30,,,59,,,,11,
     33,17,,13,,,59,,,,,42,83,,42,64,79,34,50,56,35,,12,15,6,12,15,6,12,
     15,,19,,20,,,,,,,6],
   [,,,,,18,,24,,,,,,7,13,,,,13,9,,9,40,,50,36,34,28,46,,,38,46,,49,,35,,,
     66,,14,,12,66,18,,14,,14,66,,14,61,67,49,67,,49,60,56,42,46,60,44,,
     13,7,7,13,7,7,13,7,,24,,,18,,,,,,7],[],
   [,,,,25,,,14,,,,,,7,8,9,,,8,9,,9,28,,52,28,30,20,,38,22,36,26,,35,35,
     25,,,,,12,13,9,42,,,12,,13,,,13,43,45,35,43,45,35,44,44,33,36,46,34,
     ,11,7,5,11,7,5,11,7,,,,,14,,,,,,5,5,6,7],
   [,,,,22,13,38,,,,,,,,8,,,,,,,,39,,42,28,33,23,23,33,,55,29,,,71,30,,,59,,
     13,,11,33,17,,,,,57,,,64,,42,70,64,42,50,46,34,37,64,38,,12,15,6,12,
     15,6,12,15,,22,,,16,,,,,,6,,6,,,6],
   [,,,,,18,44,,,,,,,7,,9,,,13,,,9,46,,51,,42,28,,,,,,,47,49,35,,,68,,14,14,
     12,,18,,14,,,68,,14,61,71,49,63,61,49,60,,45,49,60,44,,13,7,7,13,7,
     7,13,7,,26,,73,24,,,,,,7,,,7,,7]],
 [,[],[],[],[],[],[],[,,,,,16],[],[],[,,,,,,,12],
   [,,,,,,,15],[,,,,,,,22],[,,,,,22,,22],[,,,,,,,25],
   [,25,,,,18,,14,,,5,7,9],[,,,,,,,14,,,,7,,,15,7],[,,,,,,,22,,,,,9,,,9],
   [,,,,,,,,,,,15,,,11],[,35,,,,,,12,,,5,7,9,,,5,7,9],
   [,,,,,,,22,,,,,9,,,9,,9,,9],[,,,,,,,12,,,5,,,,,5,,,,5],[],[],
   [,31,,,,143,,,,,,39,,92,,33,,,102,45,92],
   [,,,,,36,,31,,,36,35,82,36,,,,74,,27,,36,,,57],
   [,,,,,46,,42,,,44,,,,36,,59,90,49,36,,44,,,63],
   [,,,,,,,30,,,20,27,40,28,42,20,27,40,42,20,40,20,,,36,,41],
   [,,,,,,,27,,,,34,,51,,25,34,,41,,,,,,,29,34],
   [,133,,,,,,50,,,66,44,62,92,75,35,61,65,73,37,108,66,,,90,77],
   [,,,,,47,,,,,38,31,56,51,46,34,52,61,,,55,38,,,,,58,,40],
   [,,,,,63,,,,,,58,,52,,41,61,,51,,104,,,,,44,48,41,,88],
   [,,,,,50,,42,,,38,41,60,78,50,40,61,68,83,36,68,38,,,90,,42,,38,48,,88]
    ,[,46,,,,,,40,,,,36,72,,,27,34,82,72,29,,,,,41,,,,,37,,49],
   [,,,,,118,,98,,,,,,55,97,,92,,131,37,,,,,,201,298,162,225,,423,499,497,253]
    ,[,,,,,112,,90,,,37,,63,53,,,,,132,37,71,37,,,366,157,,,234,359,400,483]
    ,[,240,,,,,,78,,,25,37,49,35,55,25,37,49,55,25,49,25,,,218,159,177,
     100,,,,234,,176,39,33],
   [,,,,,128,,98,,,,92,,,,,,,128,37,91,,,,,197,204,162,220,281,519,,248,217,37 
    ],[,,,,,14,,12,,,8,,,,,9,10,22,22,9,,8,,,,31,42,20,21,38,33,,32,28,
     86,62,42],[,,,,,,,,,,,,,81,50,32,,,,,,,,,,,,52,,87,,54,112,61,,,,254],
   [,,,,,28,,24,,,,,,,,11,,12,,11,12,,,,,,,43,44,69,58,,65,,,135,54,115],
   [,,,,,18,,16,,,,,,14,,,18,30,18,14,,,,,48,29,,26,27,47,40,39,64,,86,82,
     64,82,,34],[,33,,,,16,,18,,,8,10,12,,,,10,12,,7,12,8,,,39,,,23,23,
     39,37,54,39,32,,,30,62,8,,10],
   [,,,,,,,12,,,8,10,12,14,18,7,10,12,18,7,12,8,,,34,26,34,20,,,32,42,34,
     30,64,58,30,64,8,,10,14,6],
   [,56,,,,,,,,,,38,,81,,32,41,,55,,,,,,73,156,64,,,,,65,76,50,504,413,,,,43,,
     58],[,,,,,14,,12,,,8,10,22,20,22,9,,,,9,22,8,,,,29,42,20,21,40,37,,
     42,28,,64,42,,8,,,16,8,8],
   [,,,,,28,,24,,,,,12,,,11,,,,11,12,,,,,,248,43,44,65,65,,,97,115,,54,,,,10,,
     10,10],[,,,,,18,,,,,16,18,30,14,18,14,,,,,30,16,,,,45,34,26,29,48,,,
     52,38,,84,64,,16,,,12,,14],
   [,,,,,,,,,,,,,,52,32,,,,,,,,,70,,121,52,,87,,,144,61,388,404,320,362,,36,,,,,
     43],[,33,,,,16,,,,,8,10,12,,,7,10,12,,,12,8,,,44,28,,23,22,40,33,,
     35,34,64,53,30,64,8,,10,,6,6,,8,10],
   [,56,,,,,,,,,,41,,81,67,32,38,,46,,,,,,73,86,96,,,54,,57,86,,,332,242,,,35,
     ,34,,,36,,,,43],[,,,,,28,,24,,,,,12,,,11,,12,,11,,,,,,,,43,44,67,58,,
     67,,,,54,,,,10,,10,10,,,10,,,10],
   [,,,,,16,,14,,,,,,,,7,,,,7,,,,,,,,23,24,47,40,,,,,,30,,,,,,6,6,,,,,,6],
   [,,,,,144,,116,,,47,,,67,121,43,73,89,,47,,47,,,,229,318,190,392,400,370,
     717,391,,293,293,231,283,78,,,108,,62,392,78,120,112,464,61],
   [,402,,,,134,,108,,,47,73,,67,,,73,89,,43,,47,,,393,213,,,314,458,486,337,
     400,298,,275,,291,78,322,116,104,,60,340,78,,104,328,59,,163,70,59],
   [,,,,,,,,,,35,51,67,49,77,35,51,67,77,35,67,35,,,,199,234,140,,,,300,,
     218,261,261,175,265,58,295,74,88,42,42,,58,74,88,295,42,372,74,42,
     49,43],[,,,,,130,,108,,,47,79,85,61,134,,,,131,43,87,47,,,,229,264,
     194,238,309,463,,322,259,293,281,233,293,78,330,118,100,59,64,,78,,
     108,330,63,500,116,,43,59,49],
   [,,,,,142,,,,,47,73,85,65,,43,,81,,,,47,,,,217,,180,,398,,,335,312,331,317,
     ,325,78,397,109,104,57,58,568,78,109,102,,,573,,,,45,43,59],
   [,165,,,,112,,92,,,35,51,67,49,77,35,51,67,77,35,67,35,,,247,193,,140,
     161,,274,283,,226,271,239,175,273,58,228,74,84,42,42,228,58,74,84,
     232,42,230,74,42,45,43,35,45],
   [,,,,,70,,46,,,45,,,72,68,40,51,83,89,,84,45,,,,67,70,47,62,70,,98,68,
     52,301,310,217,246,36,,,57,39,40,81,38,93,56,102,42,81,73,,339,356,
     288,320,342,296],[,92,,,,60,,53,,,52,52,114,56,,,,90,83,45,,52,,,70,
     43,,,48,94,77,61,64,,309,265,229,281,45,94,,47,,42,130,43,,59,,44,94,
     ,79,359,337,303,345,343,289,61],
   [,,,,,,,53,,,36,39,72,56,60,36,39,72,62,38,72,36,,,49,,56,34,,,,60,,41,
     268,,178,266,35,69,76,47,37,34,,35,76,47,71,37,64,76,40,318,322,246,
     314,310,250,47],[,,,,,48,,42,,,44,,90,53,51,34,,,70,36,75,44,,,,55,
     62,46,43,65,60,,62,53,268,247,196,,38,,96,45,,34,74,30,,60,94,35,76,
     ,42,308,294,256,264,290,248,38,49,44],
   [,83,,,,84,,,,,51,57,,72,93,40,46,81,,,82,51,,,78,57,58,47,102,78,,,78,
     56,327,,245,,48,70,111,49,41,40,69,40,,40,,,73,75,59,371,342,296,330,
     332,296,66,47,45,66],
   [,64,,,,50,,45,,,34,37,70,44,59,31,39,70,57,37,70,34,,,49,55,48,37,40,
     ,65,60,,47,277,231,173,261,31,89,71,39,36,34,89,31,71,45,90,36,90,
     71,35,315,291,235,291,305,223,47,39,37,41,45],
   [,94,,,,58,,57,,,42,,116,,,48,50,,83,46,,42,,,57,,,46,,59,105,94,82,,290,
     288,236,302,41,79,102,,43,42,74,43,100,61,103,43,,,50,,378,310,358,
     374,324,45,,44,42,61],
   [,,,,,42,,28,,,11,,,13,23,13,20,15,23,13,15,11,,,,48,66,48,,76,64,84,68,
     ,,63,59,63,20,,,24,18,16,97,20,20,24,123,18,,20,,87,85,81,83,83,81,
     79,84,84,64,75,80,90],
   [,53,,,,20,,20,,,11,13,15,7,,,13,15,13,9,15,11,,,69,31,,28,27,47,42,
     43,45,47,47,47,35,45,17,38,19,14,,11,40,17,19,14,40,13,38,19,15,
     61,57,49,57,59,49,58,49,50,42,56,41,58,11],
   [,105,,,,,,18,,,11,13,15,7,11,9,13,15,11,9,15,11,,,86,33,36,28,,,41,
     46,44,49,47,47,35,47,16,64,18,14,12,10,,16,18,14,,12,64,18,14,61,
     57,49,57,61,49,56,55,48,44,,47,56,11,7],
   [,,,,,,,28,,,11,20,15,13,23,13,,,23,13,15,11,,,,46,66,48,68,70,69,80,
     68,66,,61,59,65,20,98,20,24,18,16,94,20,,24,,18,98,20,17,87,83,81,
     85,85,81,76,82,84,68,74,80,86,11,11,11],
   [,65,,,,,,,,,11,13,15,7,13,9,13,15,,,15,11,,,75,33,36,28,31,49,,,44,49,
     ,47,35,45,17,44,19,14,13,11,60,17,19,14,,,44,19,15,61,57,49,57,59,
     49,56,55,48,44,54,47,56,11,7,7,11],
   [,55,,,,24,,18,,,11,13,15,7,11,9,13,15,11,9,15,11,,,71,31,36,28,33,
     47,39,43,,47,47,47,35,45,16,44,18,14,12,10,38,16,18,14,44,12,44,
     18,14,61,57,49,57,59,49,58,49,50,42,56,41,58,11,7,7,11,7],
   [,,,,,42,,28,,,11,20,15,13,23,13,20,15,23,13,,11,,,81,46,,48,,73,63,79,
     72,,73,61,59,63,20,,20,24,18,16,96,20,20,24,120,18,,,17,,83,81,83,
     83,81,75,82,84,67,75,80,86,11,11,11,11,11,11],
   [,,,,,24,,18,,,,,,7,13,9,,,13,9,,,,,,36,34,28,,50,46,45,46,50,,,35,51,,,,
     14,14,12,68,18,,14,68,14,,,,,61,49,63,71,49,,56,48,46,,44,60,,7,7,,
     7,7],[,,,,,,,,,,,,,,,20,33,,,,,,,,,,,,,,,,,,,,,,,,,,19,27,,23,62,,,,,,20,,
     301,178,,,146,,74,65,59,,40,,,44,59,57,,45],
   [,,,,,,,,,,,,,28,34,18,,,,,,,,,,60,58,36,,64,,,60,52,,,86,106,,,,16,,,,,,,,,,,,
     ,134,114,134,174,110,,76,62,,58,68,76,,18,22,36,18,24,,18],[],
   [],[,,,,,,,,,,12,,32,28,,12,15,,29,20,32,12,,,60,,58,,,,,,,,,104,74,,12,
     42,27,16,13,12,42,12,27,14,42,15,42,27,13,132,122,94,128,,108,69,,,
     59,65,64,65,28,24,22,28,30,22,28,24,,16],[],[],
   [,,,,,,,,,,,37,108,,88,34,33,88,72,60,110,,,,,,88,,,,,,,,698,444,442,400,32,
     ,81,55,34,,,34,81,64,,40,,82,37,,518,,372,,,74,51,60,,106,43,70,116,
     42,,96,68,42,118],[],
   [,,,,,16,,14,,,,,,,,7,,,,7,,,,,,,,23,24,47,40,,,,,,30,,,,,,6,6,,,,,,6,,,6,,
     70,42,,,42,,79,40,42,59,35,50,,15,14,17,15,14,17,,20,,,,13,,,37],
   [,,,,,24,,18,,,,,,7,13,9,,,13,9,,,,,,36,34,28,,50,46,45,46,50,,,35,51,,,,
     14,14,12,68,18,,14,68,14,,,,,61,49,63,71,49,,56,48,46,,44,60,,7,7,,
     7,7,,7,,18,,,24],[],[],
   [,24,,,,14,,16,,,5,8,11,7,11,5,8,11,11,5,11,5,,,36,26,35,20,22,,,40,
     47,36,35,,25,,9,33,12,12,6,6,33,9,12,12,33,6,33,12,6,43,43,35,43,
     ,35,44,42,36,37,44,34,,13,7,7,13,7,7,13,7,24,14,,,12,,,,,6,7],
   [,22,,,,,,13,,,,,,,,7,,,,7,,,,,33,28,33,23,,42,39,47,41,33,,50,30,115,9,
     32,12,13,6,6,31,9,12,13,31,6,32,12,6,69,70,42,67,67,42,59,46,40,
     37,41,38,64,17,15,14,,15,14,17,,,16,,,,,,46,,6,,,,6],
   [,,,,,24,,18,,,,,,7,,9,,,13,9,,,,,,46,34,28,46,58,47,51,52,60,55,55,35,,
     18,,,14,14,12,47,,,14,69,14,,,,,63,49,67,61,49,67,58,48,64,57,44,66,
     13,7,7,13,7,7,13,7,,,,,,,,44,,,7,,,7],[],
   [,25,,,,14,,12,,,5,8,11,7,11,5,8,11,11,5,11,5,,,33,,38,20,22,52,,37,,
     ,35,33,25,35,9,30,12,12,6,6,30,9,12,12,30,6,30,12,6,43,43,35,43,
     43,35,41,,36,37,41,34,44,13,7,7,13,7,7,13,7,,14,,,,,,,,6,7,,,5,6,7 
    ],[,,,,,18,,18,,,,,,7,13,9,,,,9,,,,,84,36,39,28,45,84,45,46,53,,51,
     53,35,,,69,,14,14,12,69,18,,14,,14,69,,,67,67,49,61,63,49,62,56,48,
     49,62,44,,13,7,7,13,7,7,13,7,,24,,,24,,,,,,7,,,7,,7,,7]],
 [,[],[],[],[],[],[],[],[],[,,,,,,10],[],[],[],[],
   [,,,,25,,30],[,,,,43,,36,,,52],[,,,,25,,30,,,26,,,,17,19,29],
   [,,,,,,,,,46,,,,27,29,39],[],[],[],[,,,,,,,,,,,,,,,27,29,39],[],
   [],[],[,,,,14,,15,,,15,,,,29,,,,71,,,,63],
   [,,,,21,,22,,,22,,,,,,,57,79,,,,107],[,,,,,,,,,,,,,,34,57,35,,,,,,,,,11,15],
   [],[,,,,14,,,,,17,,,,38,39,66,39,70,,,,,,,,12,16],[],
   [,,,,20,,21,,,21,,,,,,,,71,,,,75,,,,,,15,,16],
   [,,,,21,,22,,,22,,,,69,45,162,47,91,,,,89,,,,,13,15,,16],
   [,,,,14,,17,,,,,,,,35,62,42,,,,,54,,,,12,16,,,14,,16,16],[],
   [,,,,53,,,,,58,,,,69,,,125,,,,,167,,,,47,,120,,74,,93],
   [,,,,,,,,,122,,,,,224,,220,,,,,,,,,,228,112,,,,,190,155,,79],
   [,,,,35,,44,,,44,,,,69,,181,,,,,,,,,,45,72,55,,64,,97,74,64,,25,79],[],
   [],[],[,,,,7,,8,,,8,,,,13,,,17,27,,,,,,,,9,,11,,12,,,21,12,,25,,25],
   [],[],[,,,,,,,,,8,,,,28,19,28,19,,,,,40,,,,11,16,,,,,17,16,13,,,,30,,,,
     6],[,,,,7,,8,,,8,,,,15,17,27,,,,,,27,,,,9,13,11,,12,,15,13,12,,25,,
     25,,,,5,,,6],[],[],[],[],
   [,,,,,,8,,,,,,,,19,,19,40,,,,,,,,11,16,,,13,,17,16,,,39,112,30,,,,6,,,6,6],
   [],[],[],[,,,,71,,95,,,89,,,,95,,,153,205,,,,205,,,,65,,117,,100,,111,
     112,104,,175,643,175,,,,35,,,49,35,,,,,53],
   [,,,,,,,,,,,,,,222,708,219,,,,,,,,,139,198,134,,,,207,212,188,,649,1164,498,,,
     ,86],[,,,,49,,60,,,60,,,,95,,,,,,,,225,,,,63,98,77,,88,,,103,88,,175,
     725,175,,,,35,,,42,35,,,,,42,,,,35,89],
   [,,,,79,,100,,,114,,,,287,173,467,,368,,,,,,,,133,211,110,,134,,,,139,,418,
     1660,437,,,,62,,,126,65,,,,,122,,,,,86,65],
   [,,,,67,,74,,,74,,,,91,,189,161,189,,,,183,,,,65,,,,94,,,,94,,175,887,175,,,
     ,35,,,51,35,,,,,48,,,,35,89,35],[],
   [,,,,28,,29,,,29,,,,53,,,,111,,,,103,,,,17,,22,,23,,31,21,23,,91,211,85,,,,
     17,,,21,17,,,,,21,,,,125,239,119,217,125],
   [,,,,,,,,,24,,,,,48,95,47,86,,,,,,,,20,24,18,,,,26,24,21,,111,166,88,,,,19,,
     ,,16,,,,,18,,,,147,198,120,162,,,20],
   [,,,,21,,22,,,22,,,,52,45,90,,,,,,95,,,,17,21,18,,19,,23,21,19,,77,152,69,
     ,,,16,,,16,13,,,,,16,,,,104,176,95,148,103,,17,16],
   [,,,,27,,28,,,28,,,,,43,,,101,,,,87,,,,,,22,,23,,,,23,,139,,145,,,,,,,22,19,,,
     ,,22,,,,201,,201,202,,,,20,17],
   [,,,,28,,29,,,29,,,,49,58,,,107,,,,107,,,,17,21,22,,23,,,,23,,91,227,85,,,,
     17,,,21,17,,,,,21,,,,125,,119,,125,,17,20,17],
   [,,,,21,,24,,,,,,,82,,103,45,78,,,,96,,,,20,24,18,,21,,26,24,,,110,174,88,,
     ,,19,,,18,16,,,,,,,,,198,200,120,160,146,,20,18,16,20,20],[],
   [,,,,39,,,,,46,,,,29,,,37,53,,,,39,,,,57,,,,62,,55,102,58,,153,274,159,,,,
     29,,,46,31,,,,,,,,,207,316,209,277,187,,97,82,84,,99,84],[],
   [,,,,41,,40,,,44,,,,41,39,51,,,,,,51,,,,65,91,53,,66,,75,93,62,,165,398,
     159,,,,33,,,34,29,,,,,40,,,,215,,213,372,201,,105,85,84,,99,89,,37],
   [,,,,42,,62,,,,,,,,48,43,41,85,,,,43,,,,,102,55,,70,,,,66,,245,384,212,,,,,,
     ,74,35,,,,,40,,,,304,325,269,352,,,119,82,80,82,,82,,29,,54],
   [,,,,,,,,,34,,,,35,27,51,27,51,,,,51,,,,39,59,,,,,,,40,,115,,115,,,,21,,,40,
     21,,,,,40,,,,149,228,149,,135,,67,62,57,,75,59,,31,,31],[],
   [,,,,37,,46,,,40,,,,35,47,39,37,53,,,,,,,,61,81,51,,62,,57,81,58,,151,,
     153,,,,35,,,40,31,,,,,32,,,,209,,207,,189,,97,76,79,83,95,76,,25,,37,
     29,31],[],[],[],[],
   [,,,,,,,,,,,,,,,,20,32,,,,,,,,,14,,,,,16,15,,,,97,,,,,,,,8,6,,,,,8,,,,,93,46,,
     42,,,,16,22,22,20,,,,40,49,26,,51],[],
   [,,,,,,,,,,,,,18,20,32,,,,,,32,,,,,20,16,,18,,,18,18,,34,,,,,,6,,,8,,,,,,8,,,,
     ,111,,73,42,,,20,,,22,20,,38,,,42,26,,38,,,,,7],[],[],[],[],
   [,,,,,,,,,,,,,,,,,,,,,,,,,,,27,,,,36,34,37,,,120,115,,,,,,,18,,,,,,18,,,,,146,,
     129,91,,,38,43,39,45,42,,,,60,60,19],
   [,,,,,,22,,,26,,,,,,,21,35,,,,,,,,,,25,,30,,28,,31,,,117,,,,,,,,17,17,,,,,17,,,
     ,,143,169,140,97,,,38,50,38,42,40,,,,37,58,19,,,,,,,,,23],
   [,,,,,,,,,,,,,,37,,34,,,,,25,,,,,57,39,,,,43,87,66,,,200,,,,,,,,28,,,,,,34,,,,,
     243,267,,159,,,60,69,65,80,,,,,68,31,33,,27,,,,,27],
   [,,,,,,,,,22,,,,17,17,25,,,,,,27,,,,31,34,,,,,25,30,,,75,,76,,,,14,,,15,,,,,,
     17,,,,103,,95,130,96,,49,,40,34,39,40,,40,,,54,38,,39,,,,,18,,,,,,,16,
     14,24],[,,,,23,,,,,,,,,31,29,41,,,,,,41,,,,51,59,,,42,,51,55,54,,143,,
     133,,,,23,,,,,,,,,41,,,,193,,165,234,143,,83,,65,59,77,74,,27,,,31,19,,
     27,,,,,28,,,,,,,37,23,45],
   [,,,,16,,27,,,,,,,17,18,45,23,49,,,,43,,,,30,36,25,,29,,,31,,,79,123,80,,,
     ,16,,,23,19,,,,,21,,,,,147,115,,,,51,38,40,,,,,42,,41,,,,43,,,,,19,,,,,,,,
     15,,14,23],[,,,,,,28,,,52,,,,31,39,23,31,51,,,,23,,,,,80,37,,54,,41,,
     50,,135,201,137,,,,21,,,24,27,,,,,30,,,,183,237,185,,,,,62,67,,,80,,25,,
     45,,,,25,,,,,31,,37,,,,,,,22,20,29],
   [,,,,26,,50,,,,,,,51,31,81,,,,,,75,,,,47,53,44,,46,,,45,,,204,203,,,,,25,,,
     48,,,,,,58,,,,,241,,,,,76,62,61,,,,,41,,68,,,,42,,,,,30,,,,,,,23,23,46,,,
     21],[,,,,,,,,,,,,,51,41,25,,,,,,,,,,,,42,,70,,62,127,52,,295,202,187,,,,
     40,,,28,,,,,,34,,,,249,241,211,239,159,,,61,,62,82,73,,27,,68,31,33,,,,,,
     ,27,,,,,,,,,22,24,45,,22,45]],
 [,[],[],[],[],[],[],[],[],[,,,,,,10],[],[],[],[],
   [,,,,31,,37],[,,,,69,,44,,,102],[,,,,29,,34,,,34,,,,23,19],
   [,,,,,,,,,,,,,40,39,56],[,,,,29,44,37,,,,,,,,26,,22,44],
   [,,,,87,,,,,,,,,,,36,34,67],[,,,,85,,86,,,,,,,52,43,68,,43,47,69],
   [,,,,,,58,,,,,,,,,28,27,49,,,53],[],[],[],
   [,,,,9,,10,,,10,,,,18,,,,66,28,61,102,50],
   [,,,,11,,12,,,12,,,,,23,,35,47,,76,,65],
   [,,,,,,,,,,,,,30,23,32,22,,,38,50,39,,,,7,8],
   [,,,,,,,,,,,,,,,71,39,,38,,,,,,,16,17],
   [,,,,7,,,,,9,,,,,29,55,26,,29,72,73,,,,,8,9],[],[],
   [,,,,11,,12,,,12,,,,31,24,59,32,63,34,72,,49,,,,,8,8,17,9],
   [,,,,9,,9,,,,,,,,29,37,27,,41,47,,,,,,8,9,,,8,,,9],[],
   [,,,,64,,83,,,,,,,87,,,106,,150,380,387,199,,,,30,,,93,57,,,,51],[],
   [,,,,39,86,44,,,44,,,,87,,255,,,135,,243,,,,,30,37,30,,37,,,37,37,,28],
   [],[],[],[,,,,25,34,26,,,26,,,,17,,,22,38,,67,43,,,,,16,,20,25,21,,,
     27,21,,81,,77],[,,,,57,52,50,,,64,,,,,,,33,51,,34,54,29,,,,,,34,46,50,
     ,,57,40,,,,211],[,,,,,,,,,28,,,,27,20,,19,,22,33,,28,,,,,28,18,,,,,28,
     23,,99,,82,,,,20,31],
   [,,,,,,,,,24,,,,,46,95,47,,57,,,84,,,,20,24,,,,,,24,21,,,,84,,,,19],
   [,,,,21,30,22,,,22,,,,18,17,28,,,20,32,63,25,,,,16,21,18,,19,,,21,19,,79,
     ,65,,,,16,30,16,16],
   [,,,,82,,75,,,,,,,56,56,76,,,66,103,58,69,,,,,66,58,70,74,,,,71,,389,,,,,,
     51,61],[,,,,28,29,35,,,33,,,,27,20,88,19,39,,,41,,,,,22,27,23,26,26,,
     ,26,27,,,,101,,,,22,,18,,17,57],[],
   [,,,,57,54,50,,,64,,,,,,32,35,51,,,61,29,,,,53,,34,43,51,,,52,41,,248,,
     209,,,,,33,32,,29,66],
   [,,,,,,24,,,,,,,,46,95,47,,55,,,84,,,,20,24,,,21,,,24,,,256,,84,,,,19,,,18,
     16],[,,,,95,56,99,,,,,,,41,41,55,,39,48,65,,51,,,,,47,59,47,87,,,61,,,
     ,,225,,,,38,51,,,,50,41,,50],
   [,,,,58,53,51,,,65,,,,,,30,34,61,,,61,,,,,,,35,45,51,,,64,41,,228,,337,,,,,
     31,32,,30,61,,,,,62],[],
   [,,,,,185,,,,,,,,121,,,142,309,182,312,399,261,,,,42,,51,119,,,,55,65,,195,,
     189,,,,111,,130,206,105,,138,,265,,308,284],
   [,,,,,,,,,73,,,,166,141,229,143,322,163,258,342,203,,,,53,63,46,,,,,,60,,
     229,,200,,,,131,215,128,,106,,137,,218,211,327,221,,43],
   [,,,,55,112,60,,,60,,,,121,125,,,,171,302,331,233,,,,42,51,42,,51,,,51,51,
     ,193,,175,,,,107,282,114,116,91,,130,,267,116,303,,,38,40],
   [,,,,63,,80,,,75,,,,153,146,319,,446,,,443,,,,,52,,46,,59,,,63,56,,238,,203,
     ,,,130,278,123,237,107,442,135,,,219,443,,,45,45,39],
   [,,,,,134,81,,,,,,,121,137,195,135,295,160,228,385,189,,,,42,,53,121,,,,,69,
     ,195,,189,,,,111,209,128,,105,371,133,,210,223,314,213,,38,43,38,43],
   [],[,,,,9,,10,,,10,,,,18,,,,52,28,51,88,42,,,,6,,7,16,8,,,7,8,,30,,30,,
     ,,16,,,20,16,65,22,,46,20,63,55,,42,53,42,52,42],
   [,,,,,,,,,8,,,,30,23,32,21,,,38,48,39,,,,7,8,6,,,,,8,7,,,,30,,,,18,33,18,
     ,16,56,23,,33,18,56,35,,51,46,42,46,53,,7],
   [,,,,7,18,8,,,8,,,,17,17,45,,,,,37,41,,,,6,7,6,,7,,,7,7,,27,,25,,,,15,,
     16,16,13,,,,35,16,35,37,,37,39,35,40,37,,6,6],[],
   [,,,,9,,10,,,10,,,,18,23,30,22,48,28,39,,30,,,,6,7,7,16,8,,,,8,,30,,30,,
     ,,16,35,22,20,16,,22,,,20,60,37,,42,51,42,52,42,,6,7,6],
   [,,,,7,16,8,,,,,,,,,,21,88,27,64,,,,,,7,8,6,,7,,,8,,,43,,30,,,,18,39,18,
     18,16,57,22,,39,,,41,,54,46,42,46,50,,7,6,6,,7],[],
   [,,,,83,,102,,,98,,,,45,,,54,66,71,69,82,56,,,,52,,57,83,75,,,65,81,,231,
     ,221,,,,45,,51,,46,86,51,,61,97,73,64,,313,337,303,341,305,,48,57,43,
     ,48],[,,,,,,,,,73,,,,62,49,74,45,64,55,69,94,59,,,,51,63,40,,,,,53,
     54,,219,,196,,,,49,64,38,,,,44,,68,64,94,71,,276,256,262,293,253,,47,
     40,41,,44,46,,47],
   [,,,,67,63,60,,,74,,,,52,49,62,,,56,78,66,59,,,,52,61,42,,61,,,61,51,,
     221,,203,,,,50,64,39,84,35,,47,,67,88,65,72,,291,276,273,308,263,,48,
     42,41,,42,48,,48,40],
   [,,,,73,,81,,,,,,,62,57,60,53,69,,,73,,,,,61,68,52,,67,,,71,67,,270,,237,,,
     ,52,61,44,130,46,88,47,,,86,74,,,,336,319,340,334,,57,52,45,,59,52,,
     49,47,49],[,,,,60,,71,,,82,,,,45,47,55,49,61,56,73,,57,,,,40,56,44,,
     55,,,,,,185,,185,,,,43,61,41,94,37,83,45,,65,94,66,67,,247,260,247,
     293,231,,36,44,39,,36,50,,42,37,38,47],[],
   [,,,,63,77,68,,,74,,,,45,49,56,49,63,,,74,,,,,52,55,48,63,59,,,59,59,,
     227,,207,,,,45,57,43,89,43,85,,,,80,73,,,307,319,285,,297,,48,48,41,,
     48,48,,42,44,45,,42],
   [,,,,,,,,,,,,,17,17,27,19,,21,29,,25,,,,6,7,,,,,,7,,,27,,25,,,,17,28,17,,
     15,51,17,,27,,,28,,37,39,35,,37,,6,7,5,,6,7,,45,37,35,47,35,,43],
   [],[],[,,,,,,,,,,,,,18,,,,58,29,60,115,46,,,,6,,8,20,10,,,8,10,,30,,30,
     ,,,18,,,,18,74,23,,51,,73,59,,42,58,42,60,42,,6,8,6,,6,8,,52,52,52,
     66,36,,52,6],[,,,,,,,,,,,,,,,,31,84,74,,62,80,,,,,,,,,,,,,,,,84,,,,,43,
     28,24,16,76,50,,51,20,80,47,,,196,116,,236,,,,16,,,20,,,60,72,178,64,,
     86],[,,,,,,,,,,,,,,23,,,59,,,,59,,,,,7,9,21,11,,,8,11,,,,37,,,,,,29,,23,
     67,,,,,53,,,,70,51,,,,,9,7,,7,9,,,66,61,,55,,59,7],[],
   [,,,,,,,,,,,,,22,25,34,21,,29,48,58,30,,,,8,9,,,,,,9,,,34,,,,,,22,33,,,,,24,
     ,35,,58,38,,46,56,,58,46,,7,8,,,7,8,,52,,,64,40,,48,,,,7,,8],
   [,,,,,,,,,,,,,28,27,59,31,71,35,,,57,,,,8,8,9,21,11,,,7,11,,,,37,,,,25,
     58,29,,23,,28,,52,,67,56,,56,,51,68,,,7,9,7,,,9,,66,60,61,74,,,59,7,,
     ,,,8,,8],[,,,,29,,34,,,,,,,21,21,29,,,26,35,,29,,,,,25,22,27,27,,,23,,
     ,99,,91,,,,20,30,,,,,21,,30,,,31,,133,138,125,,129,,23,21,17,,22,21,,
     55,54,45,56,45,,53,17,,,25,31,25,,24,23],[],
   [,,,,,39,,,,,,,,,,,25,,25,,88,88,,,,,,,36,,,,35,27,,,,116,,,,,,20,42,19,82,
     19,,82,42,95,95,,,176,,157,166,,,24,20,,30,26,,,47,59,59,43,,,21,,,,,,,,
     ,23],[,,,,,42,35,,,35,,,,21,,,23,56,22,,57,78,,,,,,23,33,28,,,,27,,
     104,,109,,,,20,,19,40,18,71,18,,76,40,52,89,,140,148,,152,144,,23,23,
     19,,23,23,,57,43,52,61,40,,,18,,,23,,,,28,29,20],
   [,,,,,52,,,,,,,,,,,33,81,,32,68,27,,,,,,30,47,,,,,43,,,,,,,,,30,28,68,27,77,
     46,,29,66,79,31,,,213,255,,222,,,30,35,,39,,,,49,62,48,47,,45,31,,,,40,
     ,,42,,30],[],[,,,,,,,,,,,,,68,61,70,,,66,100,,73,,,,54,65,,53,,,,55,,
     ,297,,335,,,,54,67,,,,,53,,73,,,93,,371,,357,529,409,,46,,59,,48,,,49,,
     59,50,39,,47,,,,50,110,75,,50,81,,,,48,62],
   [,,,,,33,,,,,,,,,22,88,23,57,,,61,,,,,25,28,,30,,,,29,35,,140,,120,,,,22,
     59,20,46,19,71,21,,,47,55,,,,152,157,158,150,,25,,20,,24,25,,67,43,
     53,61,41,,,21,,,,,32,,27,,21,,,20,,,51],
   [,,,,,,44,,,82,,,,68,78,29,29,68,,,86,27,,,,,60,32,47,65,,,,37,,219,,195,,,
     ,46,29,28,70,28,84,,,30,66,66,,,271,225,253,,195,,,32,35,,30,40,,49,
     51,66,,49,,,27,,,,87,64,,34,53,30,,,,34,,60],
   [,,,,109,53,114,,,,,,,80,57,90,,,63,83,,67,,,,74,,50,57,93,,,,,,345,,,,,,
     67,82,,96,63,,49,,103,114,,77,,449,315,321,,,,64,48,45,,,,,47,39,66,48,
     ,,45,,,,74,66,,,,,,,58,45,50,,52,47,58],
   [,,,,,64,,,,,,,,80,84,32,37,85,,,83,,,,,74,72,39,59,76,,,76,47,,,,,,,,63,
     32,31,93,32,81,,,,93,78,31,,316,242,,,228,,64,39,46,,38,51,,60,67,78,
     ,61,,,29,,,,99,,,48,,31,,,,33,,94,,,69],[]],
 [,[],[],[],[],[],[],[,,14],[],[,,,,,,7],[12,,,,22,,,22],
   [,,,,18,,,30],[,,42,,52,,66,56],[12,,,,,,,,,,12],
   [,,,,22,,27,36,,,,16],[,,44,,,,40,,,92,,,46],[],
   [,,36,,,,,60,,,,,28,32,53],[],[,,38,,91,,,34,,,38,51,40,,,28,,46],
   [],[,,36,,,,,46,,,38,,42,,,30,,48,,30],
   [4,,,,5,,6,,,6,12,,,12,,,,56,,,,56],[,,,,,,,16,,,,,,,,,,39,,46,,43],
   [,,,,8,,9,,,9,,22,,,30,,,54,,74,,76],
   [4,,,,5,,6,,,6,12,,,12,,,,56,,,,56,4],
   [,,,,8,,9,,,9,,22,,,30,,,54,,74,,76,,,6],
   [4,,,,,,,,,,12,16,28,12,16,28,,28,,28,,28,4,,6,4,6],
   [,,16,,,,,16,,,,30,,,,,,49,,,,65,,11],
   [,,,,5,,,,,6,19,18,43,21,21,37,,49,,51,,43,5,,7,5,7],
   [,,16,,,,,,,,26,30,66,,29,,,55,,,,49,,11,,,,,11],
   [,,,,8,,9,,,9,23,23,61,32,,,,46,,,,68,,,6,,6,6,,7],
   [,,,,8,,9,,,9,23,23,61,32,,,,46,,,,68,,,6,,6,6,,7,,6],
   [,,,,5,,6,,,,,21,,23,21,37,,69,,45,,39,5,,7,5,7,,,5,,7,7],
   [20,,,,,,40,98,,46,60,,,60,,,,202,,184,,214,20,,,20,,20,86,,111,34,34,29],
   [20,,,,34,,,100,,42,60,,,60,,,,,,,,210,20,,,20,,20,112,29,95,,,29,20],
   [20,,,,,,,,,40,60,,160,60,,192,,,,162,,,20,111,35,20,35,20,,,114,34,34,29,
     20,20],[20,,64,,25,,32,64,,32,60,,202,60,,,,,,188,,,20,55,30,20,30,
     20,55,25,55,30,30,25,20,20,20],
   [12,,,,18,,24,22,,,12,,,12,,,,,,38,,38,12,,,12,,12,23,17,25,23,23,17,60,
     60,60,60],[],[,,,,42,,45,,,,,,,,,,,33,,54,,61,,39,,,,28,45,39,,48,48,
     ,,,239],[12,,,,15,,16,,,16,12,,,12,,,,30,,36,,,10,,,10,,12,25,13,,25,
     25,13,54,54,54,50,12],[],
   [12,,20,,,,,26,,22,12,15,32,12,15,,,,,32,,34,12,22,18,12,18,12,,,26,18,
     18,17,60,60,60,60,12,,,12],
   [,,,,,,,,,17,,38,,,37,54,,,,,,,12,,19,12,19,,,,,19,19,14,140,150,,62,,,,12]
    ,[12,,20,,15,,16,26,,16,12,15,44,12,15,,,,,32,,34,10,21,16,10,16,12,
     25,13,25,16,16,13,54,54,54,50,12,,,10,,12,12],
   [,,53,,43,,47,85,,,,,32,53,,79,,,,54,,59,,40,80,,80,28,41,39,72,48,48,
     53,203,250,,,,,27,47,,50],
   [12,,20,,20,,28,,,28,12,15,26,12,15,32,,26,,,,32,12,24,22,12,22,12,24,
     19,,,,19,60,60,60,60,12,,28,12,,12,,12,28],[],
   [,,69,,66,,71,,,73,,,57,,,49,,67,,,,51,,69,,,,42,71,53,,,,49,452,366,296,,,
     ,54,,,50,,50,49],[,,,,,,17,,,,,39,,,37,58,,,,,,68,12,,19,12,19,,,14,,
     19,19,,,162,108,62,,,,12,,,13,12],
   [,,,,42,,45,,,,,,32,,,,,33,,54,,71,,49,,,,28,41,39,,54,54,,,,244,291,,,27,,,
     ,,,27,28,,53],[],
   [28,,,,40,,,130,,56,84,,,84,,,,236,,242,,262,28,,,28,,28,132,39,108,46,46,
     39,140,140,140,140,84,,,74,,84,132,74,257,84,,416,166,282],
   [28,,,,44,,60,,,54,84,,,84,,,,248,,236,,264,28,,,28,,28,,39,134,51,51,39,
     140,140,140,140,84,,,74,,84,,74,,84,,423,142,281,,28],
   [28,,,,,,,,,58,84,119,214,84,125,238,,,,210,,248,28,110,,28,,28,,,112,46,
     46,41,140,140,140,140,84,,291,74,,84,,74,261,84,,,176,262,,28,28],
   [28,,88,,35,,44,88,,44,84,125,248,84,129,,,,,248,,280,28,77,42,28,42,28,
     77,35,77,42,42,35,140,140,140,140,84,,338,70,,84,86,70,,84,,471,86,,,
     28,28,28],[28,,124,,40,,52,,,56,84,122,220,84,118,,,256,,,,246,28,
     134,46,28,46,28,,39,,,,39,140,140,140,140,84,,294,74,,84,168,74,258,
     84,,,168,,,28,28,28,28],
   [28,,,,43,,,,,,84,107,,84,107,210,,208,,,,216,28,115,,28,,28,142,41,,,,41,
     140,140,140,140,84,,199,74,,84,144,74,199,84,,,,199,,28,28,28,28,28],
   [8,,,,10,,11,30,,11,23,,,23,,,,67,,,,81,7,,,7,,8,22,9,,9,9,9,37,37,37,
     35,22,,,19,,22,23,19,77,22,,,23,77,,51,51,51,49,51,51],
   [8,,,,10,,11,30,,11,23,,,23,,,,67,,,,81,7,,,7,,8,22,9,,9,9,9,37,37,37,
     35,22,,,19,,22,23,19,77,22,,,23,77,,51,51,51,49,51,51,7],
   [8,,40,,,,,40,,8,22,23,50,24,24,50,,50,,50,,44,8,21,10,8,10,6,,,21,10,
     10,7,34,38,34,30,22,,39,20,,18,,16,40,20,,61,18,40,,46,50,46,42,46,
     48,8,8],[8,,16,,7,,8,16,,8,18,20,58,20,19,59,,,,46,,41,7,11,9,7,
     9,6,11,7,11,9,9,7,28,29,28,25,17,,41,17,,16,16,13,,18,,65,16,39,,
     38,39,38,35,38,40,7,7,6],
   [8,,30,,10,,11,,,11,23,28,,23,28,57,,51,,,,63,7,,9,7,9,8,22,9,,,,9,37,
     37,37,35,22,,50,19,,22,23,19,49,22,,,23,52,,51,51,51,49,51,51,7,7,
     8,7],[8,,30,,10,,11,,,11,23,28,,23,28,57,,51,,,,63,7,,9,7,9,8,22,
     9,,,,9,37,37,37,35,22,,50,19,,22,23,19,49,22,,,23,52,,51,51,51,49,
     51,51,7,7,8,7,7],
   [8,,,,7,,8,,,,22,26,58,24,,62,,58,,58,,56,8,21,10,8,10,6,,7,21,10,10,,
     34,38,34,30,22,,47,20,,18,18,16,56,20,,65,,,,46,50,46,42,46,48,8,8,
     6,6,8,8],[36,,,,50,,58,54,,62,32,,,36,,,,46,,50,,54,34,,,34,,32,,47,
     56,56,56,,168,168,164,168,32,,,34,,32,96,32,56,34,,75,,56,,232,232,
     228,232,232,232,61,61,50,46,61,61,54],
   [36,,,,,,60,58,,,36,,,32,,,,50,,46,,50,34,,,34,,32,55,47,,61,61,47,168,
     168,164,168,34,,,32,,32,74,34,61,32,,72,96,61,,232,232,228,232,232,
     232,61,61,54,47,61,61,58,36],
   [36,,42,,,,,36,,56,32,39,52,32,39,50,,,,46,,54,32,44,50,32,50,24,,,40,
     45,45,37,140,140,132,140,30,,82,30,,24,,26,83,26,,75,50,59,,188,188,
     180,192,184,176,53,53,38,36,47,47,42,32,32],
   [36,,60,,45,,50,58,,54,32,46,50,36,46,50,,,,56,,58,34,51,52,34,52,32,
     61,43,53,52,52,39,168,168,164,168,32,,60,34,,32,66,32,,34,,82,66,56,
     ,232,232,228,232,232,232,59,59,46,43,59,59,50,32,36,32],
   [36,,52,,50,,64,,,,36,46,54,32,46,46,,56,,,,50,34,60,56,34,56,32,55,47,,
     ,,47,168,168,164,168,34,,62,32,,32,96,34,62,32,,,70,58,,232,232,228,
     232,232,232,61,61,50,46,61,61,54,36,32,32,36],
   [36,,42,,37,,48,,,58,32,39,,32,39,46,,46,,,,52,32,45,54,32,54,24,39,33,,
     ,,37,140,140,132,140,30,,55,30,,24,58,26,53,26,,,58,55,,188,188,180,
     192,184,176,53,53,42,37,47,47,46,32,32,24,32,32],
   [36,,,,50,,58,58,,,32,48,48,36,47,50,,46,,50,,,34,75,57,34,57,32,,47,
     56,56,56,,168,168,164,168,32,,58,34,,32,94,32,56,34,,74,,,,232,232,
     228,232,232,232,61,61,50,46,61,61,54,32,36,32,32,36,32],
   [36,,64,,45,,48,52,,52,36,50,60,32,51,46,,50,,46,,,34,53,52,34,52,32,
     51,43,61,52,52,43,168,168,164,168,34,,,32,,32,68,34,62,32,,72,58,92,
     ,232,232,228,232,232,232,59,59,46,43,59,59,50,36,32,32,36,32,32,36]
    ,[,,,,,,,,,,,,,,,,,,,53,,,,,,,,,,,,,,,,,,25,,,,,,17,,15,60,20,,,,,,,,40,35,,43,
     ,,7,5,,,7,,,46,41,50,47,,45],
   [,,,,,,,,,,,,,,,,,,,,,60,,,,,,,,,,,,,,,104,64,,,,,,,,14,,,,,,,,,,120,88,130,,,,40,
     28,32,32,,,,46,58,50,48,,52],
   [,,,,,,,,,,,,,,,,,70,,,,,,,,,,,,,,,,,,,46,32,,,,,,22,,20,,28,,,,,,,,,44,52,,,,,7,,
     ,,,,56,54,,58,62,52],[],[],[],
   [,,,,,,,,,,,,34,,26,60,,,,56,,,,,,,,,,,,,,,,100,,64,20,,50,12,,26,20,14,42,
     20,,61,20,,,,124,,88,128,,30,30,40,28,,,,,60,38,66,58,,50,64,,14],
   [,,,,,,,,,,,29,106,,33,,,44,,66,,42,,,,,,,,,,,,,46,42,44,32,24,,51,,,,,20,,
     28,,,,54,,58,54,56,44,58,,9,9,8,7,9,9,8,64,60,,50,64,48,62,48,,,7]
    ,[],[,,,,22,,27,,,,,,,,,,,,,54,,65,,,,,,16,29,21,,,,,,,95,132,,,,,,,,,,16,,
     ,,,,,,131,,,107,,,23,19,26,26,23,,,55,48,46,41,46,,21,,,,,,,32],
   [,,,,55,,106,38,,,,,,,,,,,,76,,78,,,,,,28,,45,44,55,55,,,,156,,,,,,,28,142,
     38,,28,,,,,,,,214,234,230,236,,,50,46,,,58,,,30,,42,,,40,,42],
   [12,,,,,,,,,,12,16,46,12,16,46,,46,,46,,,12,,23,12,23,12,26,,,22,22,21,
     60,60,60,60,12,,,12,,12,32,12,51,12,,51,32,,,84,84,84,84,84,84,23,
     23,22,18,23,23,22,36,36,28,36,36,28,36,36,22,22,,,,,,,,,38],[],
   [],[],[,,,,52,,,44,,,,,,48,61,54,,,,,,,56,65,68,56,68,28,49,39,49,60,
     60,63,222,,186,342,,,,38,,,,,,34,,97,60,,,258,284,242,,,220,81,81,44,
     41,63,63,56,48,40,30,52,38,28,48,38,,48,98,,,,60,42,,,30,38],
   [,,,,21,,32,,,,,,,,,75,,,,56,,,17,33,22,17,22,16,27,19,,23,23,19,84,96,
     90,132,,,50,16,,18,,18,,16,,,,50,,114,,120,138,115,107,26,26,24,19,27,
     27,23,46,50,43,46,46,41,,,22,,,,,,,27,,16],
   [,,60,,,,42,48,,98,38,,74,48,,32,,84,,38,,,,84,59,,59,28,,57,48,,,33,
     198,220,,342,38,,,32,,40,42,40,,34,,,48,,,254,264,256,278,246,220,,,44,
     51,55,55,56,52,38,38,58,42,40,52,38,52,44,,,,,,,,,42,,,,,44],[],
   [,,,,,,,42,,,38,38,76,,56,28,,82,,28,,38,,,81,,81,28,66,,102,102,102,39,
     216,224,168,,38,,,32,,32,54,32,89,28,,43,54,,,236,236,212,238,224,236,
     69,69,50,58,57,57,58,58,36,36,56,36,36,50,40,55,38,,,,,,106,,,40,,,,,
     42,,30],[],[,,,,7,,8,,,8,,,,,,,,35,,48,,,,,,,,6,15,7,,,,7,,,,25,,,,,,
     16,16,13,56,19,,,16,39,,,,39,35,39,42,,,6,5,,,6,,,41,41,45,43,,41,5,,
     ,,,,,6,,21,,20,,,,53,20,52,,52]],
 [,[],[],[],[],[],[],[],[],[,,,,,,10],[,,,,27],[,,,,,,17],
   [,,,,29,,40],[],[],[,,,,23,,24,,,36,,18],
   [,,,,17,,22,,,26,,14,,17,,19],[,,,,23,,34,,,,,,22,27,,29],
   [,,,,15,,,,,19,16,13,24,,,,14,20],[],[,,,,37,,40,,,,,,22,,,,,22,24],
   [,,,,,,,,,,37,24,45,,,23,23,29,,,45],[],[],
   [,,,,20,,21,,,21,,25,,,,33,29,59,27,,53,47],
   [,,,,14,,15,,,15,,,,29,,,,67,31,,,51],
   [,,,,21,,22,,,22,,,,,,,51,75,48,,,69],
   [,,,,,,,,,,27,25,42,,,39,25,43,,,39,,,,15,11,15],[],
   [,,,,14,,,,,17,34,,49,38,,40,29,42,27,,58,52,,,16,12,16],[],[],
   [,,,,21,,22,,,22,,42,67,69,,63,,55,34,,57,59,,,,,13,15,,16],
   [,,,,14,,17,,,,,29,70,,,36,30,58,,,,42,,,16,12,16,,,14,,,16],
   [,,,,,,92,,,106,102,,,,,,118,,108,,216,212,,,,,,92,,,,,146,108],
   [,,,,,,,,,58,,,,69,,,105,,77,,186,133,,,,47,,93,,,,,,70],[],
   [,,,,35,,44,,,44,,79,,69,,153,,,,,269,,,,101,45,74,55,,64,,,75,64,79,25],
   [,,,,19,,20,,,,13,,,,,,15,29,15,,,35,,,,,,23,,29,,,38,28,93,,,88],
   [,,,,10,,11,,,11,,,,,,,24,39,,,,,,,,,15,13,,14,,,16,14],
   [,,,,27,,34,,,,,,,,,,,23,26,,23,55,,,,,,42,,49,,,65,,,,,193],
   [,,,,7,,8,,,8,,,,13,,,17,27,,,,,,,,9,,11,,12,,,21,12,,25,,25],
   [,,,,27,,30,,,34,21,,,,,,23,33,,,36,,,,,,,37,,45,,,57,41,200,,,,20],
   [,,,,,,,,,24,13,15,21,,,20,15,21,15,,21,,,,24,27,,22,,,,,34,27,93,82,,81,
     12,,22,,21],[,,,,,,,,,8,,21,,28,,34,21,36,24,,,56,,,15,11,16,,,,,,16,
     13,98,34,,30,,8,,6],
   [,,,,7,,8,,,8,13,12,33,15,,17,,,12,,33,21,,,13,9,13,11,,12,,,13,12,47,
     25,,25,13,7,,5,21,13,6],
   [,,,,27,,34,,,,,,23,,,,,,26,,24,55,,,67,,113,41,,47,,,55,62,187,195,,,,,24,
     ,31,23],[,,,,15,,24,,,20,13,15,21,,,32,15,21,,,21,,,,32,,,25,,27,,,
     38,29,88,86,,88,12,,23,,,12,,13,22],
   [,,,,10,,11,,,11,,,,,,,24,39,,,,,,,17,12,,14,,15,,,19,15,122,42,,39,,7,,,,,
     8,7],[,,,,27,,30,,,34,22,24,30,,,23,23,29,,,29,,,,40,,,36,,47,,,61,
     47,178,189,,175,21,,27,,24,20,,21,31],
   [,,,,,,8,,,,,24,,,,34,21,36,21,,,,,,15,11,16,,,13,,,16,,,34,,30,,8,,6,,,6,
     6,,,8],[,,,,31,,34,,,,,,24,,,,,23,26,,,55,,,,,,42,,53,,,,,210,,,,,,21,,,
     22,,,24,23,,27],[,,,,31,,38,,,38,27,30,35,,,29,27,33,,,34,,,,58,,,43,
     ,53,,,,49,227,191,,203,26,,47,,25,25,,25,31,,,,,47],
   [,,,,81,,,,,124,128,,,,,,133,247,,,245,,,,,,,112,,136,,,152,139,562,,,,117,,,,
     ,116,82,59,229,114,96,215,110,252,240],
   [,,,,,,80,,,,,,,95,,,135,169,98,,304,177,,,,65,,146,,96,,,112,98,,175,,175,,,
     ,35,,104,47,35,,104,55,213,47,323],
   [,,,,,,,,,114,124,123,200,,,,126,196,155,,202,241,,,,,152,112,,,,,,144,530,
     393,,366,114,94,206,86,186,112,,57,206,120,96,179,110,206,203,65,86],
   [,,,,49,,60,,,60,135,,267,95,,,,,95,,261,171,,,,63,99,77,,88,,,105,88,387,
     175,,175,104,56,257,35,213,112,42,35,,,53,239,42,245,,89,35],
   [,,,,81,,108,,,114,127,,246,287,,262,,237,,,251,,,,187,107,150,112,,134,,,
     156,137,815,343,,590,116,94,252,62,232,117,110,59,229,113,,,110,234,
     230,89,86,86,89],[,,,,67,,92,,,,91,96,163,91,,145,95,145,92,,163,151,
     ,,125,65,,154,,100,,,,98,423,175,,175,84,51,161,35,152,84,48,35,162,
     84,51,154,48,162,201,90,35,90,35,90],
   [,,,,27,,28,,,28,37,,,,,,37,71,36,,73,69,,,,,,22,,23,,,,23,172,,,,32,,,,55,
     36,20,17,82,34,21,63,20,67,71,,,207,219,212,184],
   [,,,,28,,29,,,29,,,,53,,,,79,49,,98,83,,,,17,,22,,23,,,21,23,,91,,85,,,,17,
     ,45,21,17,109,61,22,,21,92,98,,125,,119,193,125],
   [,,,,,,,,,24,36,40,61,,,63,37,61,,,60,64,,,26,20,24,18,,,,,24,21,132,114,
     ,89,34,20,63,19,55,34,,16,62,37,19,55,18,62,64,162,148,167,121,167,
     194,20,20],[,,,,21,,22,,,22,,41,,52,,64,,,40,,69,65,,,23,17,21,18,,
     19,,,21,19,125,77,,70,,17,93,16,,36,16,13,,37,,59,16,,68,152,104,151,
     96,172,104,17,17,16],[],
   [,,,,28,,29,,,29,45,39,82,49,,67,46,77,39,,82,77,,,33,17,21,22,,23,,,,
     23,153,91,,85,40,23,79,17,70,40,21,17,79,40,23,,21,76,,225,125,195,
     119,205,125,,17,20,17],
   [,,,,21,,24,,,,40,49,73,82,,67,39,72,39,,,,,,26,20,24,18,,21,,,24,,132,
     118,,89,34,20,91,19,57,36,18,16,77,35,19,59,,,68,160,198,167,121,
     167,160,20,20,18,16,,20],
   [,,,,37,,48,,,52,33,,,,,,38,38,40,,42,45,,,,,,56,,66,,,87,,226,,,,31,,,,47,
     31,64,31,43,37,53,48,,44,49,284,,282,264,287,217,83,,84,102,,103,88],
   [,,,,33,,42,,,55,,,,29,,,33,49,31,,,33,,,,57,,70,,58,,,82,58,,153,,159,,,,
     29,,30,44,27,,30,65,41,40,,43,,207,259,209,299,189,,97,82,84,,99,82],
   [,,,,,,,,,40,33,34,41,,,41,31,39,34,,41,39,,,51,,61,40,,,,,64,52,171,151,
     ,148,28,43,44,,44,22,,25,44,28,,41,34,44,46,210,189,200,197,215,159,
     61,96,61,62,,75,63,30,29],
   [,,,,37,,40,,,42,33,32,42,41,,39,,,36,,42,41,,,59,63,85,53,,62,,,85,60,
     232,159,,161,31,47,43,33,47,31,40,27,,37,45,47,40,43,49,281,215,276,
     215,287,199,86,99,84,85,,95,86,30,37,30],[],
   [,,,,23,,34,,,,33,28,41,35,,35,27,35,28,,41,39,,,49,43,77,42,,42,,,,46,
     175,115,,121,28,39,45,21,47,22,34,21,45,28,33,44,34,45,45,,155,196,
     157,209,143,63,75,61,63,,75,62,30,25,22,27],
   [,,,,41,,48,,,,33,37,42,,,43,37,38,40,,,45,,,63,61,87,56,,70,,,117,,226,
     210,,236,31,,43,,49,31,64,31,44,37,53,47,,,50,279,,279,280,299,217,
     83,105,84,86,,103,86,30,,30,30,,30],
   [,,,,37,,44,,,48,58,40,66,35,,47,37,45,,,66,,,,75,65,77,57,,64,,,83,68,
     391,165,,161,52,58,77,35,,47,36,31,77,,,,40,77,,,221,,215,,203,93,105,
     84,79,,99,84,54,31,46,37,,29,54],[],
   [,,,,,,,,,,,,,,,,23,37,,,,,,,,,,16,,18,,,20,18,,,,34,,,,,,,,7,,,,,,,,,,73,46,
     80,42,,,20,,,22,20,,,26,43,,36,,58],[],[],[],[],
   [,,,,,,,,,,,18,27,18,,26,,31,18,,27,28,,,,11,20,16,,18,,,,18,,35,,37,17,
     9,29,6,28,17,8,7,33,17,9,28,8,29,30,,49,84,49,73,42,23,21,22,,,
     22,22,,38,30,43,,28,39,40,,7],[],[],
   [,,,,21,,22,,,,,,,,,,,,18,,,47,,,,,,26,,35,,,,,,,,,,,,,,14,,,,15,,19,,,39,,,
     124,127,,95,,,39,43,,46,41,,,36,37,,37,37,69,,,,,,,23],
   [,,,,35,,40,,,,,,,,,,,,32,,,37,,,,,,42,,52,,,,70,,,,242,,,,,,23,52,33,,29,39,
     40,,,41,,,203,,251,163,,,62,,,82,63,,,22,,,22,,46,,27],[],[],[],
   [,,,,19,,17,,,34,,,,17,,19,,,14,,,23,,,25,,42,25,,29,,,,29,135,75,,72,13,
     22,30,14,20,14,17,12,30,13,22,20,18,30,22,155,100,123,95,,95,57,,
     40,41,,39,54,37,40,34,,,36,37,39,,18,,,,,,,,14],
   [,,,,,,34,,,40,,,,31,,39,,,28,,,33,,,59,67,57,43,,50,,,75,62,221,131,,143,
     35,33,,23,45,23,30,,,29,35,39,30,,43,242,177,194,181,237,151,61,79,
     58,85,,77,117,38,25,22,35,,19,38,27,,27,,,,,37,,,,22],
   [,,,,,,,,,,16,16,34,17,,35,17,31,16,,34,37,,,31,30,40,44,,35,,,46,32,
     117,85,,83,14,21,33,16,36,14,21,13,33,15,22,34,21,33,39,133,,,108,
     138,104,35,51,59,39,,45,37,42,42,23,39,,21,42,46,,19,,,,,,,,15,24,,,,
     14,21],[,,,,,,24,,,34,,19,,31,,17,,39,31,,,19,,,33,,63,31,,60,,,,40,,
     141,,129,18,32,37,21,19,18,26,17,37,22,32,19,26,37,21,587,163,208,
     163,262,141,165,,55,64,,67,63,43,27,29,39,,27,43,29,,26,,,,,,,,19,,,,,
     18,29],[,,,,45,,40,,,,,,,51,,,,,32,,,53,,,53,,57,39,,66,,,,,186,191,,,,
     65,,25,62,23,32,33,,29,,39,52,,42,231,,199,244,246,165,65,117,60,67,,
     82,,42,27,23,42,,22,42,29,,37,,,,,,,,,22,,,,,22,24],
   [,,,,,,,,,,37,49,56,51,,35,34,55,46,,59,37,,,89,73,101,,,149,,,,74,315,
     318,,,36,52,57,40,36,32,52,33,57,39,55,34,52,61,39,358,,,475,344,
     265,137,118,136,,,111,128,63,42,41,63,,39,68,46,,47,,,,,,,,39,46,,,,40,
     47,,,45],[,,,,7,,8,,,8,,,,13,,,17,27,,,,,,,,9,,11,,12,,,21,12,,25,,25,,
     ,,5,,,6,5,,,,,6,,,,35,86,35,62,35,,17,19,16,,17,19,,29,,33,,21,,35,,,,
     ,,,6,,,,,,,,14,23,16,21,25,40],[],[]],
 [,[],[],[],[],[],[],[,,17],[],[,,,,,,10],[30,,,,36,,,39],
   [,,,,,,47,33],[,,45,,58,,62,48],[],[,,,,29,,34,32,,,23],
   [,,,,55,,50,,,74],[28,,34,,31,,37,38,,37,,22,,20,19,38],
   [,,,,73,,82,46,,,,,33,46,35,38],[28,,33,,,,32,,,,,25,69,,22,,26],
   [,,50,,57,,,45,,,64,69,38,,,36,51,39],
   [,,,,72,,75,67,,,,,40,52,47,47,,38,,50],
   [,,46,,,,,69,,,49,,39,,,32,,35,,33,43],
   [6,,,,7,,8,,,8,20,,,,,,23,37,22,,44,51],
   [,,,,,,,18,,,,,,,,42,29,40,31,49,96,44],
   [,,,,10,,11,,,11,,27,,,,,,71,29,72,85,57],
   [,,,,9,,10,,,10,,,,18,,,,66,28,61,102,50],
   [6,,,,7,,8,,,8,20,,,,,,23,37,22,,44,51,5],
   [,,,,,,,,,,29,21,35,,18,35,19,29,21,35,35,29,5,,7,7,5],
   [,,18,,,,,18,,,,39,,,,70,50,66,39,,,62,,12,,16],
   [6,,24,,7,,,,,8,24,23,38,30,23,44,24,44,24,38,50,43,6,,8,8,6],
   [,,18,,,,,,,,37,31,49,,27,40,32,48,,,50,48,,12,,,,,12],
   [,,,,10,,11,,,11,32,29,72,,,,32,55,27,,55,69,,,7,,,7,,8],
   [6,,14,,7,,8,14,,8,19,20,35,21,19,39,19,33,20,35,39,33,5,13,7,,5,5,
     13,6,13,7],[6,,,,9,,8,24,,,,26,44,,23,40,28,56,23,34,,39,6,,8,8,6,
     ,,6,,8,6],[,,,,,,54,,,60,118,,,,119,,126,261,173,,,357,30,,,,30,31,
     116,,158,45,29,35],
   [,,,,,,68,,,,,,,87,,,96,,146,353,423,205,,,,30,,31,74,,76,57,,44],
   [,,,,,,,,,55,,125,190,136,112,231,113,182,121,190,,182,29,,42,,29,29,,,
     155,43,28,34,,33],
   [30,,84,,39,,44,86,,44,,139,207,87,,265,,,143,249,389,,25,64,37,30,25,
     25,64,30,64,37,25,30,32,28,29],
   [18,,,,23,,30,27,,,19,,,,18,,18,,21,38,,34,16,,,,16,17,29,18,27,26,16,
     18,93,,91,82],[],
   [,,,,57,,56,54,,,,,,,,39,,33,,44,41,40,,43,,,,32,,43,45,82,35,,,,209,232],
   [,,,,25,,26,34,,26,,,,17,,,20,36,24,,47,,,,,16,,19,,20,24,,19,20,,81,113,
     77],[,,,,57,,56,68,,64,,,,,,,37,39,,37,47,33,,,,,,33,61,43,45,110,39,
     39,,,204,247],[],
   [,,,,,,,,,24,,,,,47,99,48,,56,,,,16,,23,20,16,,,,,23,16,18,,,,84,,,,19],
   [18,,26,,21,,22,30,,22,,20,55,18,17,36,,,,35,,35,13,24,21,16,13,15,26,
     16,26,21,13,16,,79,82,65,16,,,16,37,,16],
   [,,71,,59,,59,54,,,,,37,39,63,39,,,,43,40,39,65,45,105,,65,33,56,44,51,
     ,41,66,268,,209,,,,35,37,40],
   [18,,27,,24,,28,,,30,21,21,38,,18,92,18,34,,,41,,16,27,26,22,16,17,29,
     18,,,16,18,,104,99,82,17,,51,20,,,,16],[],
   [,,56,,57,,56,,,64,71,,42,,,33,37,39,,,,34,,45,82,53,,32,,43,43,,35,39,
     348,254,197,303,51,,37,,35,,,50,41],
   [,,,,,,24,,,,,56,,,47,99,48,,,,,,16,,23,20,16,,,18,,23,16,,,,172,84,,,,19,,
     ,18,16],[,,,,58,,57,59,,,,,38,41,,42,,36,,44,,41,,53,,,,33,77,44,45,
     81,39,,302,,194,288,,,35,38,42,,,,36,53,,41],
   [,,54,,59,,59,73,,67,,,43,,,33,37,39,,37,46,,,51,,,,33,56,44,51,105,41,
     40,358,227,205,,,,41,,34,,,,37,,,35,,42],
   [50,,,,60,,,,,76,156,,,,148,,150,,,,534,,40,,,,40,41,186,48,134,57,39,47,
     231,,228,211,125,,,,,,176,109,330,129,,333,228,432,389],
   [,,,,78,,84,161,,,,,,121,,,130,287,178,353,455,273,,,,42,,39,94,56,94,65,
     39,54,,195,227,189,,,,111,,,206,105,,,,277,288,329,293],
   [,,,,,,,,,85,167,163,264,162,143,271,146,245,161,250,307,240,39,137,,53,
     39,39,,,139,57,38,48,232,,222,204,124,,269,133,267,,,107,261,123,,261,
     242,257,264,46,43],
   [42,,112,,55,,60,112,,60,154,169,293,121,,,,,,279,454,,35,88,51,42,35,35,
     88,42,88,51,35,42,225,193,,175,114,,358,107,,,116,91,,114,,363,116,361,
     ,,38,39],[58,,192,,56,,70,,,75,178,179,315,,151,346,,428,,,433,373,
     40,190,57,52,40,41,,47,,,39,48,256,,231,206,133,,423,131,334,,230,109,
     384,125,,,227,429,426,41,45,46,42],
   [,,170,,79,,,218,,,169,173,264,121,146,231,133,225,,269,285,225,,98,65,42,
     ,39,,52,,69,,54,238,195,228,189,126,,242,111,242,,206,105,248,129,,
     246,302,254,241,45,38,45,38,45],
   [10,,,,12,,13,32,,13,31,,,,27,,35,54,34,,61,74,8,,,,8,9,23,10,,10,9,10,
     47,,45,42,26,,,,,,27,24,72,26,,,27,57,82,63,,61,58,62],
   [,,,,9,,10,,,10,,,,18,,,,52,28,51,88,42,,,,6,,7,16,8,,,7,8,,30,,30,,,,16,
     ,,20,16,65,22,,46,20,63,55,,42,53,42,52,42],
   [,,28,,,,,,,10,28,28,44,26,26,39,26,45,29,45,45,44,9,22,11,7,9,7,,,
     22,11,8,8,41,40,41,35,23,,43,19,43,,,19,44,23,,43,22,44,44,55,54,
     55,49,54,55,9,7],
   [10,,18,,9,,10,18,,10,25,25,49,18,21,40,,,25,49,48,42,8,12,10,6,8,7,
     12,8,12,10,7,8,37,30,38,30,21,,45,16,,,20,16,,21,,43,20,43,54,49,
     42,50,42,49,42,8,6,7],
   [10,,32,,12,,13,,,13,30,34,,31,27,77,,66,,,76,62,8,,10,,8,9,23,10,,,9,
     10,46,48,,42,26,,,26,85,,27,24,82,26,,,27,64,74,62,62,62,58,63,62,8,
     ,9,8],[10,,18,,9,,10,18,,10,25,25,41,18,23,34,,34,25,41,42,34,8,
     12,10,6,8,7,12,8,12,10,,8,37,30,38,30,21,,40,16,38,,20,16,39,21,,
     40,20,39,39,49,42,50,42,49,42,8,6,7,6,8],
   [10,,,,11,,10,28,,,26,31,55,26,,47,26,51,28,52,,52,9,22,11,7,9,7,,8,
     22,11,8,,40,40,41,35,23,,51,19,47,,22,19,60,23,,47,,,48,54,54,55,
     49,56,,9,7,7,7,9,7],
   [62,,,,74,,76,79,,84,51,,,,55,,57,60,,82,73,65,46,,,,46,45,,56,73,70,47,
     ,271,,258,,45,,,,,,128,44,68,49,,81,,66,74,357,,342,327,363,348,73,,
     59,57,72,53,62],[,,,,93,,,115,,98,,,,45,,,52,68,68,65,82,56,,,,52,,
     43,58,60,58,,47,,,231,257,221,,,,45,,,159,46,69,50,,61,97,71,61,,313,
     339,303,,305,,48,58,50,72,46,62],
   [,,50,,,,,50,,69,62,53,66,63,45,78,46,61,53,66,82,60,35,50,48,51,35,
     29,,,50,49,28,38,222,210,171,183,38,,74,50,82,,,37,77,38,,74,88,68,
     77,275,262,223,239,276,237,51,47,41,42,52,38,45,50,47],
   [54,,81,,67,,66,66,,74,62,68,60,52,49,70,,,62,66,74,69,41,58,61,52,41,
     39,66,50,62,61,43,46,263,229,238,207,43,,62,50,71,,92,39,,44,,68,92,
     66,75,335,307,319,285,332,299,68,48,53,50,68,46,57,46,48,43],
   [64,,79,,70,,82,,,,59,75,78,63,58,68,55,66,,,,59,46,67,67,61,46,45,67,
     55,,,47,56,284,289,261,,49,,91,53,69,,132,48,74,45,,,87,80,68,360,
     369,344,,357,343,72,57,58,57,73,53,63,51,49,50,52],
   [,,54,,,,,54,,82,67,52,76,45,45,59,43,57,52,76,83,57,37,42,55,40,37,
     31,,,42,55,,44,225,177,,173,40,,64,39,66,,,37,65,40,,64,,69,65,280,
     231,231,227,285,195,52,36,43,34,52,30,45,49,42,,42,49],
   [62,,,,72,,77,72,,,67,62,61,58,54,70,62,58,64,89,,,45,,67,,45,43,,54,
     68,66,46,,270,268,255,233,49,,65,54,70,,132,42,64,47,,,,,72,369,363,
     338,320,,345,72,,59,58,71,54,63,50,53,44,43,,47],
   [54,,66,,63,,68,71,,74,65,70,66,45,50,60,49,73,70,60,,,41,68,59,52,41,
     39,58,50,68,59,43,50,265,227,246,207,44,,67,45,61,,93,43,77,43,,61,
     80,,,346,307,324,285,344,297,66,48,53,50,66,46,57,53,42,43,45,47,42,
     49],[,,,,,,,,,,,,,18,,,,,29,54,,42,,,,6,,,,,,,7,,,30,,30,,,,18,,,,18,137,
     23,,46,,,59,,42,55,42,,42,,6,8,6,,6,8,,52,53,48,64,40,,52],
   [,,,,,,,,,,,,,,,,44,,,,,,,,,,,,,24,,,20,,,,270,84,,,,,,,,18,,,,,,,,,,246,116,,308,
     ,,36,32,34,32,,,,80,86,83,,,70],
   [,,,,,,,,,,,,,,,,23,51,35,,,73,,,,,,,,,,,9,,,,,37,,,,,,,,23,69,29,,,,,80,,,,51,
     66,,,,,8,,8,,,,66,61,,51,80,59],
   [,,,,,,,,,,21,21,39,17,18,35,17,33,21,39,39,33,5,14,7,6,5,5,14,7,14,
     7,5,7,31,27,31,25,17,,36,17,35,,,15,35,17,,36,,36,35,41,37,41,35,
     41,37,8,6,8,6,8,6,8,49,45,31,43,49,27,49,43,6,,7],[],[],
   [,,,,,,,,,,,36,46,,31,52,,,75,50,,82,,,,,,,,,,,18,24,,227,,84,28,,49,18,53,
     ,24,18,57,30,,53,20,55,57,,,,116,198,,36,,,32,,32,36,,82,54,86,80,
     59,108,84,,18],[,,,,,,,,,,,35,70,,35,43,24,43,35,70,64,41,,,,8,,,,,,,
     9,,61,42,62,37,29,,54,26,44,,,23,43,29,,54,,52,43,75,56,76,51,75,
     53,10,7,9,8,10,7,9,81,62,,57,81,39,82,55,,,8,7],
   [,,,,,,,,,,,,,22,22,64,25,50,29,,,,6,17,9,8,6,6,17,8,17,9,7,8,,34,40,,,
     ,64,22,61,,,27,,22,,72,,52,62,56,46,,,56,46,10,7,9,7,10,8,9,66,56,
     50,64,66,44,62,52,7,,8,,,,,8],
   [,,,,30,,35,42,,,,,,21,,,,,,64,,47,,,,,,19,42,24,31,33,21,,,104,109,,,,,20,,
     ,,,,25,,53,,,45,,140,143,141,,139,,23,25,21,32,24,25,,57,54,56,62,55,
     59,62,23,,,18,,,54,32,26],
   [,,,,42,,54,52,,,,,,,,,,,65,88,,,,,,,,,,30,53,58,27,38,,,162,231,,,,,,,90,49,
     ,38,,104,,,,,,215,271,,226,,,40,47,,37,65,,,29,,62,33,,50,,40,,31],
   [],[32,,,,,,34,,,34,23,23,42,21,23,43,21,39,24,49,45,43,21,32,,,21,
     19,29,25,35,30,,23,112,99,113,93,19,,41,20,45,,37,17,41,18,,47,37,
     42,45,146,133,147,127,142,133,29,23,25,24,29,22,25,55,55,30,49,57,
     29,52,53,25,31,25,17,,,39,23,23,20,30],[],
   [32,,44,,33,,45,39,,36,,,,32,27,,,,,51,,66,22,35,27,,22,21,,23,35,29,20,
     26,148,,124,140,26,,,24,,,71,,68,23,,46,62,,46,176,,167,169,176,165,33,
     ,28,25,38,25,29,66,72,64,,67,65,69,77,,67,35,21,,,,35,29,,,,22],
   [,,,,53,,58,54,,,,,,60,43,76,,,,,,,33,54,55,54,33,25,42,34,46,47,25,50,,
     245,158,,,,,42,73,,63,,,38,,102,103,,,316,273,206,241,354,187,52,46,39,
     38,60,30,47,61,45,29,53,47,27,57,43,,70,55,25,,,86,35,59,,29,,27],
   [,,,,30,,,,,,,34,53,32,22,58,25,,,54,,60,22,42,27,25,22,23,30,25,,28,
     20,28,157,146,167,129,24,,49,22,57,,47,21,49,25,,56,49,51,59,176,,
     177,165,185,186,31,25,30,24,32,24,35,,72,33,57,66,32,64,70,29,46,,,,,
     ,34,,25,37,,23,,27,31],
   [,,,,,,64,,,102,64,85,74,60,59,41,50,64,109,64,124,39,,,,,,47,58,122,,,,
     50,502,267,,321,43,,71,56,41,,74,44,66,53,,53,70,69,41,501,353,503,
     369,446,423,,,51,62,,46,67,96,51,52,74,62,51,,49,,68,,51,,,,55,66,53,
     62,,,,56,56],[,,,,57,,68,64,,,,,,80,65,,,,,118,,,52,,51,74,52,29,48,
     40,56,51,29,,,262,184,,,,,63,,,64,,,45,,,101,,126,370,,255,328,,236,55,
     64,39,42,59,36,,72,60,35,70,64,33,66,63,,,,29,,,,,,,33,,31,,,,41,89],
   [,,,,,,,53,,,49,69,60,80,72,37,47,66,75,37,78,49,,,91,74,,45,70,,149,
     107,51,40,399,338,,,37,,62,67,37,,92,37,65,47,,37,72,67,45,431,385,
     335,321,412,,78,64,60,72,70,54,68,73,47,48,78,49,47,76,50,74,62,,,,,
     ,152,,45,50,,,,47,51,,52,69],[],
   [,,,,9,,10,,,10,,,,18,,,,52,28,51,88,42,,,,6,,7,16,8,,,7,8,,30,,30,,,,16,
     ,,20,16,65,22,,46,20,63,55,,42,53,42,52,42,,6,7,6,,6,7,,48,47,48,
     57,36,,48,6,,,6,,,,7,7,23,,,23,,,46,25,,64,64],[],[]],
 [,[],[],[],[,3],[,,8],[,,,5],[,,8,,,8],[,,,5,,,5],
   [,,,5,,,5,,5],[12],[,12,,,12,,,,20,20],[,,44],
   [12,9,20,15,9,24,15,24,15,15,12,,24],[,15,,,15,,,35,,,14,13,28],
   [,27,62,45,27,54,45,42,93,93,36,,46],[,,35,27,,,27,,,,,13,,11,13,27],
   [],[],[,36,,,36,,,44,,,36,,36,,,28,28],
   [,,,,,,,,,,,,26,24,28,46,,,,36],[],[4,,,,,,,,,,12,,,12,,32,16,,,,38],
   [,,,,,,,,,,,,,25,,67,29,,,69],[,6,,,6,,,,8,8,,23,,18,28,50,25,,,61,102],
   [4,6,8,8,6,8,8,8,8,8,12,18,36,12,,,,,,36,,,4,10,6],
   [,9,11,11,9,11,11,11,11,11,19,25,45,,19,,23,,,,45,,5,11,7],
   [4,,,,,,,,,,12,,,12,,32,16,,,,38,,4,,,4,5],
   [,,,,,,,11,,,,,,29,,71,32,,,,,,,9,,10,11],
   [,6,,,6,,,,8,8,,23,,18,28,50,25,,,61,102,,,,6,6,7],
   [,,11,,,11,,,,,29,,,29,,51,30,,,,,,,9,,10,11,,9],
   [,6,,8,6,,8,,,,,,74,18,,54,25,,,,,,,,6,6,7,,,6],
   [,9,11,11,9,11,11,11,11,11,19,25,51,21,19,43,19,,,43,43,,5,11,7,,5,
     5,11,7,11,7],[,6,,8,6,,8,,,,,,74,18,,54,25,,,,,,,,6,6,7,,,6,,6,7],
   [20,,,,,,,,,,57,,,55,66,,70,,,,183,,20,,,20,29,20,,,121,39,29,39],
   [20,15,40,25,15,40,25,40,25,25,57,,189,45,,,61,,,189,169,,20,47,30,20,,
     20,47,30,47,30,,30,18],
   [20,,,,,,,,52,52,57,,,53,73,149,73,,,,,,20,,,20,27,20,,,,,27,,18,18],
   [20,15,40,25,15,40,25,40,25,25,57,,183,45,,,,,,,,,20,45,30,20,25,20,45,
     30,45,30,25,30,18,15,18],
   [12,,,,,,,26,,,11,,,11,13,33,13,,,31,,,12,,,12,17,12,,,27,23,17,23,54,52,
     54,52],[,,,,,,,,11,11,,,,19,23,57,23,,,,,,,,,12,17,,,,,16,17,16,,35,,
     35],[,,,,,,,48,,,,,,23,27,41,,,,34,26,,,39,,,32,,43,,43,,35,,,145,,153]
    ,[12,9,20,11,9,20,11,20,11,11,12,11,24,9,,,11,,,,24,,12,25,14,8,,
     12,25,14,25,14,17,14,51,25,45,25,11,7,23],
   [,27,42,47,27,48,47,50,,,,,34,,,,27,,,27,35,,30,47,46,,,30,45,46,41,63,
     41,63,196,,153,153,,,30],
   [12,,,,,,,,24,24,11,,,11,13,29,13,,,,29,,12,,,12,17,12,,,27,22,17,22,54,
     52,54,52,10,,,11],
   [,,,,,,,,11,11,,,,19,23,57,23,,,,,,,,,12,17,,,,,16,17,16,,35,,35,,7,,7],
   [12,9,20,11,9,20,11,20,11,11,11,11,51,9,11,23,,,,24,51,,12,23,14,8,
     11,12,23,14,23,14,11,14,49,25,47,25,11,7,,5,23,11,7],
   [,,50,,,48,,42,,,,,26,23,27,49,,,,35,27,,45,41,67,46,33,45,45,67,47,63,
     41,63,177,147,153,,,,24,23,27,27],
   [12,12,26,24,12,,24,,,,11,,31,11,13,37,13,,,,,,12,,22,12,17,12,27,22,,,
     17,,54,52,54,52,10,,,11,,10,,11,27],
   [,,,11,,,11,,,,,,,19,23,57,23,,,,,,,,16,12,17,,,16,,,17,,,35,152,35,,7,,7,,
     ,7,7],[,27,48,47,27,45,47,,,,31,,35,,,27,27,,,,,,30,43,50,46,,30,
     43,50,39,,35,,210,147,,155,27,,27,,24,27,,23,30],
   [,,,11,,,11,,,,,,,19,23,57,23,,,,,,,,16,12,17,,,16,,,17,,,35,152,35,,7,,7,,
     ,7,7,,,7],[,,38,,,42,,,,,,,27,23,27,41,,,,,,,,51,,,33,,49,,43,,38,,
     210,,146,157,,,21,23,30,,,,24,,,27],
   [,27,,47,27,42,47,38,,,,,,,,27,27,,,27,35,,30,45,46,,,30,47,46,45,61,
     41,61,177,145,183,159,,,30,,21,,,23,27,,,24,,30],
   [28,,,,,,,,62,62,79,,,73,88,235,89,,,241,241,,28,,,28,39,28,,,,55,39,55,
     125,119,125,119,74,,,61,,74,,61,,74,172,202,172,223,248],
   [28,21,56,35,21,56,35,56,35,35,79,87,,63,,,83,,,213,203,,28,65,42,28,,
     28,65,42,65,42,39,42,123,105,121,105,72,49,187,35,,72,49,35,,72,49,
     187,49,185,183,24],
   [28,,,,,,,,,,79,,,73,88,195,,,,,197,,28,,,28,39,28,,,111,51,39,51,125,119,
     125,117,74,,,61,234,74,,59,,74,172,186,172,194,188,24,24],
   [28,21,56,35,21,56,35,56,35,35,79,,215,63,83,,,,,215,231,,28,63,42,28,
     35,28,63,42,63,42,35,42,121,105,123,105,72,49,191,35,191,72,49,35,,
     72,49,201,49,201,,24,21,24],
   [28,27,,,27,,,,,,79,,213,71,89,219,,,,,,,28,,50,28,39,28,,50,,,39,,125,
     117,125,119,74,174,229,55,198,74,174,57,196,74,,,,,227,24,24,24,24],
   [28,21,56,35,21,56,35,56,35,35,77,,193,63,83,,81,,,191,193,,28,65,42,
     28,,28,65,42,65,42,,42,121,105,123,105,70,49,167,35,167,70,49,35,
     168,70,49,168,49,168,167,24,21,24,21,24],
   [8,,,,,,,22,11,11,23,,,23,28,57,25,,,,59,,7,,,8,9,7,,,,9,9,9,37,37,37,
     35,22,,,19,49,22,,17,66,22,21,51,21,68,51,51,51,51,49,51,51],
   [8,12,14,14,12,14,14,14,14,14,24,32,58,18,,,,,,58,66,,8,10,10,6,,8,
     10,10,10,10,7,10,38,30,36,30,22,22,,14,,22,22,14,45,22,22,45,22,
     52,52,50,42,50,42,48,42,8],
   [8,,,,,,,22,11,11,23,,,23,28,57,25,,,,59,,7,,,8,9,7,,,,9,9,9,37,37,37,
     35,22,,,19,49,22,,17,66,22,21,51,21,68,51,51,51,51,49,51,51,7,8],
   [8,9,11,11,9,11,11,11,11,11,17,25,46,17,17,41,,,,58,58,,7,9,9,6,7,
     7,9,9,9,9,7,9,29,27,29,25,17,17,39,13,,17,17,11,,17,17,39,17,39,
     38,39,37,39,35,37,37,7,6,7],
   [8,9,22,11,9,22,11,,,,23,,,23,,77,25,,,,,,7,,9,8,9,7,,9,,,9,,37,37,37,
     35,22,21,74,19,57,22,21,17,72,22,,,,,72,51,51,51,49,51,51,7,8,7,7]
    ,[8,12,14,14,12,14,14,14,14,14,24,32,50,18,23,38,23,,,50,50,,8,10,
     10,6,7,8,10,10,10,10,,10,38,30,36,30,22,22,39,14,39,22,22,14,39,
     22,22,39,22,39,39,50,42,50,42,48,42,8,6,8,6,8],
   [8,9,22,11,9,22,11,,,,23,,,23,,77,25,,,,,,7,,9,8,9,7,,9,,,9,,37,37,37,
     35,22,21,74,19,57,22,21,17,72,22,,,,,72,51,51,51,49,51,51,7,8,7,7,
     7,8],[36,,,,,,,54,,,31,,,30,36,46,36,,,46,46,,34,,,36,47,34,,,61,,47,
     ,153,143,153,143,29,,,30,48,29,,29,44,29,,46,,46,,207,197,207,197,
     207,193,61,58,61,47,61,54,61],
   [36,27,54,45,27,52,45,52,45,45,34,36,46,25,,,33,,,44,50,,34,63,52,36,,
     34,57,52,57,52,47,52,151,129,149,129,29,51,45,25,,29,51,27,49,29,
     51,43,51,49,43,201,179,201,179,199,175,61,50,61,45,61,46,61,30],
   [36,,,,,,,,59,59,31,,,29,31,47,31,,,,,,26,,,28,37,26,,,48,54,33,54,131,
     121,119,129,26,,,25,49,22,,25,45,26,,49,,49,45,173,163,161,171,169,
     165,47,46,47,37,53,42,53,28,28],
   [36,27,58,45,27,54,45,48,45,45,31,36,44,27,33,,,,,46,48,,34,61,52,36,
     43,34,65,52,63,52,43,52,149,129,151,129,29,51,43,27,53,29,51,25,,
     29,51,45,51,47,45,201,179,199,179,201,175,59,50,59,43,59,46,59,28,
     27,28],[36,33,,72,33,,72,,,,34,,46,29,36,44,36,,,,,,34,61,60,36,43,
     34,62,60,,,47,,153,143,153,141,29,102,46,29,46,29,102,30,46,29,,,,,
     44,207,197,207,195,207,193,61,58,61,47,61,54,61,30,28,28,30],
   [36,21,36,35,21,32,35,36,41,41,31,29,43,25,27,,27,,,43,49,,26,43,40,
     28,37,26,39,40,43,46,,46,127,107,117,115,26,37,45,21,49,22,37,21,
     49,26,43,45,43,49,49,165,145,155,153,163,149,47,38,47,35,53,34,53,
     28,25,22,25,28],
   [36,33,48,63,33,48,63,,,,31,,44,30,36,46,38,,,,,,34,84,60,36,45,34,,60,,
     ,45,,153,141,153,143,29,,44,30,49,29,,29,45,29,,,,,47,207,195,207,
     197,207,193,61,56,61,47,61,52,61,28,30,28,28,30,28],
   [36,27,56,45,27,58,45,54,45,45,34,,52,25,35,43,33,,,44,52,,34,59,52,
     36,39,34,61,52,65,52,43,52,151,129,149,129,29,51,49,25,47,29,51,27,
     45,29,51,43,51,49,,199,179,201,179,201,175,59,50,59,43,59,46,59,30,
     25,28,27,28,25,30],
   [,,,,,,,,,,,,,17,17,49,,,,,,,,,,6,7,,,,,,7,,,27,,25,,,,17,,,,15,,,,43,,,40,,
     37,,35,,37,,6,,5,,6,,,45,,43,51,43,,43],
   [,,,,,,,,,,,,,19,21,57,21,,,,,,,,,8,15,,,,,,,,,32,,32,,,,7,,,,7,,,,,,,,,44,,44,
     ,42,,16,,14,22,16,22,,45,,45,65,38,,45],
   [,,,,,,,,,,,,,22,,82,22,,,,,,,,,8,9,,,,,,9,,,34,,32,,,,22,54,,,20,,,,,,,,,46,,
     44,56,46,,8,,7,,8,,,54,,52,,50,74,50],
   [,,,,,,,,,,,,114,17,20,73,17,,,,,,5,14,9,6,5,5,14,9,14,9,5,9,37,27,,
     25,19,,75,17,67,,,15,,,,,,,,47,37,,35,47,37,10,6,10,6,10,6,10,55,45,
     45,43,55,35,,43,6,,7],
   [,,,,,,,,,,16,18,36,19,,43,16,,,39,36,,,,,8,15,,,,,,15,,90,32,,32,15,10,
     34,7,35,15,10,6,34,15,10,37,10,34,35,102,44,102,44,,42,,16,,14,22,
     16,22,44,45,34,42,65,32,44,45,,7],
   [,,,,,,,,,,,,,22,22,84,,,,,,,6,15,10,8,7,6,15,10,15,10,6,10,,34,,32,,,
     54,22,,,,20,,,,54,,82,,66,46,66,44,,46,11,8,11,7,11,7,11,66,54,,52,,
     50,,50,7,,8],[,,,,,,,,,,,18,31,14,16,40,,,,36,31,,,,,8,,,,,,,15,,,32,,
     32,15,10,35,6,34,15,10,7,37,15,10,34,10,35,34,,44,,44,78,42,22,16,
     22,14,,16,,,42,34,45,44,32,69,42,,7,,,7],
   [,,,,,,,,,,,,,22,,52,23,,,,,,,,,8,9,,,,,,9,,54,34,,32,,,53,22,45,,,20,44,26,
     ,,,,44,66,46,66,44,,46,10,7,10,7,10,7,10,,54,,52,74,42,74,50,,,7,7,
     ,8],[,,,,,,,,,,,,,22,,84,,,,,,,6,15,10,8,6,6,15,10,15,10,7,10,,34,
     38,32,,,,22,74,26,,20,,26,,,,54,,58,46,,44,,46,11,7,11,7,11,8,11,,54,
     ,52,74,50,58,50,7,,8,,,7,,8],
   [,,,,,,,,,,,,,13,15,35,,,,,,,,,,,19,,,,31,,20,,,61,,61,,,,13,28,,,,,,,27,,,28,
     ,83,,83,,81,,22,,17,28,23,28,,35,,35,37,35,36,35,17,,,,16,24,21,26,
     22],[,,,,,,,60,,,,,,36,34,60,,,,74,,,,,,36,43,,,,,102,39,102,,,,197,,,,
     28,,,,51,,45,,73,,,,,217,,239,,193,,58,,58,,50,,,36,,,46,26,,36,,31,,,36 
    ],[12,,,,,,,,,,12,15,54,12,15,54,,,,,,,12,,,12,19,12,29,,,28,19,28,57,
     57,57,57,12,23,34,12,34,12,23,12,34,12,23,34,23,34,34,79,79,79,79,
     79,77,23,24,23,17,23,24,23,34,34,27,34,34,25,34,34,,16,,,,,,,,14,36]
    ,[,,,27,,35,27,35,,,14,14,34,13,14,49,15,,,,34,,16,32,25,,19,16,30,
     25,30,24,,24,72,61,,63,12,21,29,13,35,12,21,11,29,12,21,35,21,29,
     35,94,83,92,85,93,83,27,22,27,18,28,23,28,36,35,25,33,36,23,36,35,
     21,16,,17,,,21,22,26,13,28],
   [,,,,,,,,,,36,41,,36,61,36,35,,,27,74,,38,,,,43,38,,,,81,,81,185,,,,26,49,
     46,28,28,26,49,24,48,28,49,25,49,46,25,219,217,201,235,,195,59,66,
     59,58,,50,,54,36,33,58,33,31,,31,,36,,,31,,,,,28,36],[],[],[],
   [,,54,45,,62,45,44,87,87,36,,58,,49,,35,,,36,60,,34,75,54,,43,34,69,
     54,51,50,,50,193,173,149,,26,49,41,25,25,28,49,23,41,30,49,27,49,
     43,25,233,227,195,375,219,305,59,,59,41,75,38,75,44,37,43,41,46,37,
     46,37,47,40,84,79,45,82,57,52,88,27,46,,,28],
   [,,,,,44,,,,,,,,36,34,58,,,,,,,28,,102,,51,28,47,102,,,45,,195,165,,,,80,,
     28,73,29,80,51,,,,,,,77,229,203,205,233,213,195,51,66,51,46,,50,,44,
     31,25,48,33,26,44,31,,39,,,36,,,,,,26,,28,36,,,,46],
   [,,,,,,,44,,,,41,82,36,,29,,,,27,,,,,102,36,51,,,102,73,55,,55,195,157,,
     197,26,49,48,28,25,26,49,24,46,28,49,25,49,46,28,225,213,205,229,
     219,193,57,58,57,46,67,50,67,48,31,33,46,33,31,46,36,59,36,,,31,,,,,
     28,36,,,26,,,,28,36],
   [,,,,,,,,,,,,,13,15,39,15,,,,,,,,,10,15,,,,,16,15,16,,25,,25,,,,5,,,,5,,,,,,,,
     ,35,,35,63,35,,20,,15,21,20,21,,33,,33,54,29,,33,,,,,6,,6,,,,,13,13,
     29,,,,31,,29],[,,,,,,,,,,,,,17,17,41,17,,,52,77,,,,,6,7,,,,,,7,,,27,,25,
     ,,,17,33,,,15,56,18,,33,,45,35,,37,,35,38,37,,6,,5,,6,,,43,,41,47,33,
     ,41,5,,,6,,7,,6,7,17,,,20,,,,,43,57,48],
   [4,,,,,,,,,,12,,,12,17,56,,,,,,,4,11,7,4,7,4,11,7,11,7,7,7,20,20,20,
     20,12,,51,12,,12,,12,,12,,51,,51,,28,28,28,28,28,28,8,8,8,5,8,8,8,
     34,34,32,34,34,32,34,34,5,,6,,,,,6,,17,,12,,,,,,56,,,,5],
   [,,,,,,,,,,13,14,29,13,,29,13,,,,29,,,,16,10,15,,,16,,,15,,82,25,,25,12,
     8,27,5,25,12,8,5,27,12,8,27,8,27,27,,35,69,35,92,35,21,20,21,15,,
     20,,35,33,27,33,,25,35,33,,6,,,,,6,,,13,29,,,,,,,33,29,,5],
   [,,,,,,,,,,,30,52,17,17,61,17,,,,44,,5,12,8,6,5,5,12,8,12,8,5,8,34,
     27,28,25,18,,33,17,45,,,15,33,,,41,,35,,44,37,,35,44,37,9,6,9,6,9,
     6,9,50,43,37,41,50,33,44,41,6,,7,5,,,,7,6,19,44,,17,,,,,61,52,77,,
     6]],[,[],[],[],[],[],[,4],[,,12,,,20],[,,,6],
   [,4,,6,,,4,,6],[30,,,,23,,,40],[,13,,,,,13,31,23],[,,72,,,,,62],
   [,,132,,,,,,,18,30,19,72],[,21,,,,,21,38,,,21,16,41],
   [,20,76,40,41,80,20,,50,28,26,21,50],
   [28,,,33,22,,,33,,18,,16,,23,18,23],[],[28,,,,18,,,,,16,22,,,,19,,19],
   [,,,,,,,44,,,26,33,46,,,26,29],[,,,,91,,,104,,,,,47,72,41,50,,,74,53],
   [,,130,,,202,,68,64,38,38,27,80,,,30,31,,,34,80],
   [6,,,,5,,,,,6,19,,,26,,37,20,,18,,77],
   [,,,,,14,,20,,,,,,71,,75,41,,,,,127],
   [,7,,,,,7,,9,8,,23,,29,34,35,29,,,47,135],
   [,7,15,9,5,15,7,,9,6,17,19,,21,,,,,17,39,,39,5,15,7],
   [6,10,12,12,7,18,10,12,12,8,28,25,42,,25,,23,,23,42,72,48,6,16,8],
   [,,,,,,,,,,,,,30,23,32,22,,,38,50,39,,,,7,8],
   [,,,,,,,20,,,,,,69,,79,48,,,,,107,,,,15,16],
   [6,,,,5,,,,,6,19,,,26,,37,20,,18,,77,,5,,,5,6],
   [,,18,,,14,,,,,34,37,127,69,38,45,31,,,,87,83,,13,,15,16,,21],
   [,7,,9,,,7,,,8,,23,76,29,,47,29,,25,,,57,,,7,7,8],
   [6,10,12,12,7,18,10,12,12,8,23,25,44,30,24,40,23,,23,34,72,40,6,16,
     8,,6,8,16,6,16,8],
   [6,7,18,9,5,,7,20,9,,,,51,21,20,25,20,,17,27,,31,5,,7,5,6,,,5,,7,6],
   [,,,,,,,,,32,100,,,130,96,,106,,,,351,439,,,,29,36,,,,174,,35,28],[],
   [,,,,,,,153,,28,,,,,95,128,99,,,147,,173,,,,29,34,,,,190,,34,28],
   [30,20,60,32,25,60,20,60,32,20,,75,246,,,234,,,99,204,230,,25,73,37,25,
     30,30,75,25,,37,30,25,26,,26],
   [18,,,,17,,,24,30,,16,,,26,19,24,19,,19,24,,34,16,,,17,18,,,16,32,26,18,
     16,85,,,74],[,,,,,,,,12,10,,,,32,27,38,27,,,,,50,,,,13,18,,,,,17,18,15,
     ,,,42],[,,,,,54,,56,55,,,,,60,37,46,,,,47,36,68,,52,,,39,,,,68,58,44,,
     ,,,192],[,10,34,12,15,34,10,,12,8,18,13,34,18,,,15,,16,50,34,,13,
     35,15,9,,20,35,13,31,15,18,11,66,,66,30,16,8,30],
   [,29,59,51,42,58,29,,,30,26,33,44,,,,29,,,26,49,32,36,60,42,,,34,64,
     36,45,64,40,29,,,143,178,24,,41],
   [,,,,,,,30,30,16,,,,26,19,24,19,,,30,48,34,,,,17,22,18,,,28,28,24,17,,,
     85,74,,,,16,29],[,,,,,,,,,8,,,,28,19,28,19,,,,,40,,,,11,16,,,,,17,16,
     13,,,,30,,,,6],[18,10,28,12,15,28,10,24,12,8,,13,,18,15,20,,,16,26,
     ,26,13,37,15,9,12,18,37,13,,15,12,11,,,70,30,16,8,,6,26,16,6],
   [,,66,,66,61,,58,55,,,,34,60,37,46,,,45,43,41,68,57,58,67,61,40,58,57,
     57,,52,47,48,248,,206,,,,33,30,40],
   [18,18,28,30,17,36,18,,,16,16,21,32,26,19,36,19,,,,42,46,16,38,26,17,
     18,23,38,16,,,18,16,,,85,74,14,,37,16,,22,,16,28],
   [,,,12,,,,,,10,,,,30,27,38,27,,,,,44,,,17,13,18,,,,,,18,15,,,190,42,,8,,8,,
     ,,8],[,29,59,51,43,58,29,,,30,33,33,49,,,26,29,,,,44,32,38,58,48,
     57,,34,63,38,44,,39,30,192,,146,187,29,,35,,29,24,,26,41],
   [,10,,12,,,10,,12,,,,,22,19,28,19,,,,,34,14,,16,10,14,,,14,,16,14,,,,70,
     30,,8,,6,,,6,6,,,8],
   [,,52,,,65,,58,55,,,,41,60,37,46,,,,47,,68,,87,,,40,59,54,,87,58,47,,264,
     ,216,188,,,32,30,41,53,,,33,37,,40],
   [,29,58,51,42,59,29,,,30,28,33,42,,,26,29,,,27,49,,36,64,42,,,35,60,
     36,58,64,45,29,218,,145,186,25,,41,,31,29,,26,35,,,29,,41],
   [50,,,,40,,,,66,40,132,,,166,126,216,133,,,,470,387,39,,,39,48,,,39,298,
     65,50,38,193,,,168,112,,,78,,,,78,300,120,130,261,108,311,260],
   [,34,109,47,41,108,34,,47,32,138,111,,170,,,132,,142,291,355,,41,112,54,
     39,,51,111,41,113,55,50,39,206,,203,184,119,61,291,46,,119,49,46,,
     120,61,267,46,292,272,41],
   [,,,,,,,,,40,,,,166,125,168,142,,,190,,226,,,,39,47,46,,,150,61,48,39,,,
     193,173,,,,78,196,112,,,264,113,130,188,108,,190,,39],
   [42,28,84,44,35,84,28,84,44,28,,97,310,,114,,,,126,238,312,,35,99,51,
     35,42,42,98,35,,51,42,35,180,,176,140,102,58,248,42,222,102,42,42,,
     102,58,230,42,256,,34,,34],
   [58,40,176,,40,176,40,,,40,140,133,339,166,134,230,,,,,361,366,39,202,61,
     37,48,46,,39,,,46,38,202,,194,168,112,,299,78,261,117,126,82,274,113,,
     ,110,273,245,34,41,41,34],
   [,40,120,49,48,123,40,,50,34,168,,329,,145,186,141,,169,220,325,273,46,
     121,57,41,,53,119,46,121,57,,41,222,,218,,137,63,253,48,205,134,51,
     48,255,,64,211,48,255,209,46,37,42,38,42],
   [10,,,,8,,,28,12,10,28,,,36,35,52,29,,27,,80,,8,,,9,10,,,8,,10,10,9,44,,
     ,42,26,,,20,51,,,18,78,26,22,53,20,91,53,60,63,,58,62,65],
   [,13,15,15,10,15,13,,15,10,29,31,68,27,,,,,30,47,,49,9,14,11,7,,7,15,
     9,14,11,8,8,41,,39,35,23,23,,15,,23,21,15,60,24,23,47,18,59,55,55,
     53,54,49,53,55,9],
   [,,,,,,,,,8,,,,30,23,32,21,,,38,48,39,,,,7,8,6,,,,,8,7,,,,30,,,,18,33,18,
     ,16,56,23,,33,18,56,35,,51,46,42,46,53,,7],
   [10,10,15,12,8,12,10,16,12,8,,25,72,26,23,38,,,24,44,46,44,8,16,10,
     7,8,6,16,8,,10,8,7,33,,33,30,21,18,46,14,,18,16,12,,22,18,49,14,
     53,40,45,48,45,42,45,50,8,7,6],
   [10,10,26,12,8,,10,,,10,28,29,,34,,54,29,,,,82,74,8,,10,9,10,,,8,,,10,
     9,44,,50,42,26,22,57,20,53,28,22,18,57,26,,,20,59,69,60,63,62,58,,
     66,8,9,,8],[10,13,15,15,10,15,13,16,15,10,27,31,61,27,24,35,27,,
     30,39,60,41,9,14,11,7,8,7,15,9,14,11,,8,40,,39,35,23,23,45,15,38,
     23,21,15,45,,23,41,18,42,42,54,53,55,49,53,55,9,7,7,7,9],
   [10,10,21,12,8,18,10,24,12,,22,,64,26,,40,21,,24,42,,48,8,19,10,7,8,
     6,,8,21,10,8,,33,,33,30,21,20,45,16,37,18,18,14,53,22,20,37,,,38,
     45,48,45,42,45,50,8,7,6,6,8,7],
   [62,,,,50,,,78,,40,40,,,66,45,54,53,,49,62,65,74,45,,,43,52,,,45,74,67,
     51,,221,,,188,36,,,36,60,,,36,56,42,62,65,,57,58,284,302,,256,291,292,
     66,59,,49,66,54,49],
   [,40,94,60,51,94,40,,57,40,57,41,87,50,,,48,,48,87,71,62,47,101,64,47,
     ,57,82,47,102,64,58,47,242,,231,,48,63,78,36,,45,46,38,68,47,64,78,
     40,64,56,314,309,305,280,309,359,73,61,57,56,73,57,56,49],
   [,,,,,,,60,70,36,,,,66,43,52,43,,,62,71,74,,,,37,42,40,,,65,63,38,36,,,
     172,172,,,,34,61,36,,34,,42,,60,34,61,56,,271,227,226,251,258,,47,40,
     41,62,43,41,,43],[54,28,64,50,45,66,28,68,50,32,,37,66,78,39,48,,,
     44,62,58,86,41,85,51,39,46,42,87,41,,57,46,35,207,,176,160,36,50,
     58,30,60,36,34,28,,42,48,60,34,52,56,260,276,,220,264,286,64,53,42,
     46,64,49,46,34,45,34],
   [64,52,92,76,50,,52,,,,50,47,68,66,48,58,49,,,,72,66,45,,73,47,50,52,
     81,45,,,54,46,232,,221,208,42,122,67,40,83,45,74,40,62,40,,,42,65,
     52,299,315,295,270,,332,72,61,52,53,72,57,53,42,45,43,42],
   [,32,78,45,37,56,32,66,51,32,,33,97,67,41,52,41,,45,68,82,75,37,77,
     50,37,46,44,59,37,67,56,,37,204,,186,,,52,78,30,65,39,40,30,74,,53,
     65,34,65,61,259,269,242,236,262,256,57,47,44,44,63,43,44,41,38,35,,
     43],[62,40,82,72,50,82,40,74,72,,,,67,66,45,54,44,,50,68,,74,45,,
     61,43,50,,,45,74,67,50,,222,,192,188,42,,55,36,65,36,,36,59,48,62,61,
     ,,61,286,298,,256,288,294,66,57,,49,66,53,49,39,47,34,34,47,39],
   [54,34,78,52,45,72,34,58,52,36,50,37,76,67,47,44,43,,50,58,66,,41,79,
     59,43,46,48,73,41,83,59,50,43,212,,206,168,42,58,68,32,56,40,40,34,
     68,40,58,56,36,60,,279,302,268,232,276,355,66,57,48,50,66,53,50,42,
     42,38,36,38,42,42],
   [,,,,,,,,,,,,,41,38,39,26,,,61,,55,,,,9,10,,,,,,10,,,,,,,,,25,39,23,,,,32,,
     38,,,46,,63,64,,,67,,8,7,,,8,7,,75,62,,72,61,,61],
   [,,,,,,,,,,,,,46,31,48,31,,,,,66,,,,11,12,,,,,,12,14,,,,44,,,,10,,,,10,,,,,,,,
     ,69,,60,,,,18,,16,24,,20,,69,,54,72,,,60],
   [,,,,,,,,,,,,,46,,90,31,,,,,,,,,11,12,,,,,,12,,,,,44,,,,30,71,,,28,91,40,,89,,
     ,,,72,,60,89,78,,11,,10,,11,,,83,,72,,67,91],
   [,,,,,,,,,,32,,99,41,25,79,38,,,115,,,7,21,11,9,7,8,21,7,21,11,8,7,46,
     ,52,,23,,69,25,74,,,33,,26,,87,,98,112,60,63,,,66,67,12,8,8,8,12,9,
     8,72,75,60,79,78,56,76,61,9,,10],
   [,,,,,,,,,,24,22,50,46,,34,23,,25,92,50,48,,,,11,18,,,,,,18,,124,,,44,22,
     12,45,10,37,22,8,8,45,22,12,43,8,45,37,126,70,108,60,,76,,19,,12,,,
     16,52,69,46,48,76,50,52,62,,10],
   [,,,,,,,,,,,50,,46,31,96,,,,,,136,8,22,12,11,10,9,22,8,22,12,8,8,,,,44,
     32,,59,30,,37,,28,61,,,73,,65,,82,71,82,60,,74,13,11,9,9,13,9,9,94,
     84,77,72,,74,,76,10,,11],
   [,,,,,,,,,,,22,42,32,23,34,,,25,38,96,46,,,,11,12,,,,,,12,14,,,,44,22,12,
     49,8,37,22,8,10,51,22,12,37,8,45,37,,70,139,60,124,,24,19,,16,,18,
     20,,64,46,54,60,50,48,56,,10,,,10],
   [,,,,,,,,,,,,,46,39,46,28,,,78,,60,,,,11,12,,,,,,12,,69,,63,44,,,74,30,44,,
     ,28,59,40,,46,,,47,85,71,79,60,81,76,12,9,8,10,12,9,8,85,80,,60,
     89,64,89,84,,,10,10,,11],
   [,,,,,,,,,,,,,46,29,90,39,,46,,,124,8,22,12,11,8,9,22,8,22,12,10,8,,,,
     44,,,91,30,78,,,28,,34,,,,73,95,76,71,,60,77,76,13,9,9,9,13,11,9,
     88,83,,72,89,68,85,,10,,11,,,10,,11],
   [,,,,,,,36,33,,,,,28,21,26,,,,31,,36,,,,,24,22,,,30,34,27,,,,99,84,,,,18,
     29,16,,,,25,,23,,,29,,133,128,114,,141,,26,21,22,31,27,21,,54,48,43,
     53,55,44,48,24,,,34,23,37,31,31,31],
   [,,,,,,,66,,,,,,78,49,58,,,,68,,86,,,,,44,,,,127,107,42,51,,,,,,,,40,76,,,,,
     54,82,91,,,64,,387,,,361,333,,68,,72,,60,62,,53,,,50,47,,46,,42,,107,
     50],[,,,,,54,,,,,30,18,62,30,18,62,21,,21,,92,92,,,,17,22,,,,,,23,19,
     99,,104,91,18,28,49,18,49,18,18,18,49,18,28,49,18,49,49,130,138,
     137,125,136,,28,28,24,22,28,26,22,58,58,36,50,50,38,50,50,,24,,,,,,,,
     21,38],[32,21,,,,,21,34,,18,21,17,49,28,21,52,21,,18,71,49,78,21,
     48,28,,23,23,41,21,40,29,,19,108,,95,87,17,25,38,18,47,17,17,15,38,
     17,25,47,17,38,47,132,133,126,117,134,145,32,26,23,22,32,24,22,45,
     54,35,39,55,37,45,48,34,23,37,24,,,31,31,30,18,41],
   [,,,,,,,96,,,26,26,87,78,71,26,31,,51,28,68,32,,,,39,44,30,102,,,,60,31,
     204,,147,,26,42,61,28,29,26,28,26,61,32,42,27,28,61,27,255,297,194,
     226,,238,,47,30,36,55,39,,62,53,44,62,44,46,68,40,43,38,,,34,,,,,29,
     53],[32,13,,23,22,,13,31,,14,,,,,17,22,,,19,26,,,20,,23,19,25,,,20,
     37,23,25,,,,,76,15,23,32,13,24,16,15,13,32,15,23,24,16,32,24,140,
     111,,97,133,,30,31,,25,29,31,28,45,47,37,,44,,,40,,22,50,41,22,,,,50,
     16,,25,16,33],[],
   [,,,,21,65,,,,,22,23,,,22,,25,,22,65,100,,21,,,23,29,,61,21,,,27,23,114,,
     136,135,21,33,57,19,60,21,23,22,57,25,32,60,21,57,60,152,,170,,167,
     225,33,28,,24,,29,25,58,,47,58,65,53,69,77,,31,,,31,40,,,,25,,,25],
   [,20,80,50,,76,20,68,40,28,26,22,58,,52,20,26,,,26,58,30,41,79,35,,
     40,32,75,41,45,45,,25,180,,128,186,22,34,47,22,23,22,24,20,47,28,
     34,23,24,47,23,216,,168,,230,186,54,,32,38,52,35,38,54,,44,48,50,48,
     54,40,39,34,96,95,40,90,48,46,96,23,50,,,26,21],
   [,,,,77,72,,110,,,,,,78,49,58,,,84,87,,86,57,,135,,72,50,,57,95,,60,,328,,
     ,,,,,40,91,46,48,,,69,,76,46,,91,427,380,367,302,339,347,64,,48,46,
     94,61,,58,45,36,60,44,47,67,40,,,,,50,,,,,,47,50,41,46,,,72,50],
   [,,,,,,,44,,,38,26,70,78,,24,29,,51,28,100,38,,,51,49,34,39,,,109,58,42,
     27,242,,153,218,26,42,57,28,27,26,28,26,57,32,42,27,28,57,29,256,
     316,193,240,269,,58,65,39,47,52,40,47,66,45,44,58,44,46,58,46,65,38,
     ,,,,,84,,29,46,,,34,33,,,26,58],
   [,,,,,,,,,8,,,,28,19,28,19,,,,,40,,,,11,16,,,,,17,16,13,,,,30,,,,6,,,6,6,,,,
     ,6,,,,49,,42,126,51,,21,,16,22,21,18,,46,,34,74,40,,40,,,,,8,,8,,,,,
     18,17,28,15,,23,24,48,28],
   [,,,,,,,,,8,,,,30,23,32,21,,,38,48,39,,,,7,8,6,,,,,8,7,,,,30,,,,18,33,18,
     ,16,56,23,,33,18,56,35,,51,46,42,46,53,,7,6,6,,7,6,,57,40,42,52,
     44,,48,7,,,8,,9,,8,9,21,,24,23,30,,,,32,48,39],
   [,,,,5,,,,,6,19,20,57,25,21,41,,,,,,,5,15,8,5,8,6,15,5,15,8,8,5,29,,,
     25,18,,36,13,,16,,13,38,,,52,14,36,,39,41,39,35,39,45,9,9,6,6,9,9,
     6,45,47,41,41,45,43,45,41,7,,8,,,,,8,,20,77,20,,,,,23,37,,44,,6],
   [,,,,,,,,,8,18,15,38,28,,22,17,,18,,38,34,,,17,11,16,,,,,,16,13,,,,30,16,
     9,33,6,25,16,6,6,33,16,9,25,6,33,27,84,49,84,42,,54,22,21,,16,,
     21,18,38,46,34,34,,36,38,40,,8,,,,,8,,,17,38,,,,15,,23,22,38,60,6],
   [6,,16,,7,,,,,8,22,27,52,31,21,44,23,,25,38,88,61,6,16,9,7,6,7,16,6,
     16,9,6,6,34,,34,30,18,,47,18,39,,,16,,18,,39,18,62,41,46,51,47,42,
     47,55,10,7,7,7,10,7,7,52,57,40,48,53,45,52,48,8,20,9,7,,,,9,8,
     24,40,,21,,27,,29,48,64,,,7],[]],
 [,[],[],[],[],[],[],[],[],[,,,,,,10],[],[,,,,15,,,,,21],
   [,,,,31,,50],[,,,,,,22,,,,,12],[,,,,17,,22,,,,,14,23],
   [,,,,23,,28,,,28,,20],[],[,,,,,,,,,39,,,,21,23,29],
   [,,,,,,18,,,,,13,21,,14,,,24],[,,,,37,,,,,,,24,46,,,22,,45],[],
   [,,,,23,,34,,,,,20,,,,19,,29,,22],[],[],[],
   [,,,,14,,15,,,15,,31,47,25,,,,51,,,,67],
   [,,,,21,,22,,,22,,30,97,,37,,,63,36,103,,71],
   [,,,,,,,,,,,,38,27,26,37,,,25,42,,43,,,,11,15],[],
   [,,,,14,,,,,17,,27,50,,31,42,,52,46,51,,42,,,,12,16],[],
   [,,,,20,,21,,,21,,27,41,25,,57,,47,25,,,59,,,,,,15,,16],
   [,,,,21,,22,,,22,,34,63,71,,,,59,42,,,57,,,,,13,15,,16],
   [,,,,14,,17,,,,,,77,,35,54,,,29,52,,50,,,,12,16,,,14,,16,16],
   [,,,,,,122,,,,,,,,132,,,,202,282,,265,,,,,188,110,,,,234,194,152],
   [,,,,,,,,,,,,,63,,,,,78,244,,137,,,,47,,124,,72,,91,,74,76],
   [,,,,,,,,,130,,,203,126,117,201,,,118,200,,198,,,,,183,115,,,,192,,,79],
   [,,,,35,,44,,,44,,,,63,,149,,,79,269,,,,,,45,78,55,,64,,101,75,64,,25,79],
   [,,,,15,,24,,,,,,,13,15,21,,,15,21,,21,,,,27,32,25,,27,,32,38,28,108,86,
     123],[,,,,10,,11,,,11,,,,23,24,37,,,,,,39,,,,,21,14,,15,,17,19,15,,42]
    ,[,,,,27,,34,,,,,,,21,23,33,,,,36,,33,,,,,62,36,,47,,42,59,,,215,165],
   [,,,,7,,8,,,8,,12,21,11,,,,21,12,33,,,,,,9,,11,,12,,13,21,12,65,25,65,
     25,13,7,21],[,,,,27,,34,,,38,,26,42,,,,,55,,23,,23,,,,,,41,,47,,67,
     65,47,251,,203,193,22],
   [,,,,,,,,,20,,15,20,13,15,21,,,15,21,,21,,,,,29,22,,,,24,32,31,116,,108,
     80,12,,20,13,23],
   [,,,,,,,,,8,,21,,22,21,32,,36,24,,,36,,,,11,16,,,,,15,16,13,,36,,30,,8,,6 
    ],[,,,,7,,8,,,8,,,,15,17,27,,,,,,27,,,,9,13,11,,12,,15,13,12,,25,,25,,,
     ,5,,,6],[,,,,31,,34,,,,,,,25,27,33,,,30,35,,33,,,,,67,43,,53,,58,,50,
     258,,213,,,,,25,31,25],
   [,,,,19,,20,,,24,,15,23,13,15,29,,35,,,,29,,,,27,32,23,,29,,,38,27,,,111,
     88,12,,23,13,,12,,,26],
   [,,,,10,,11,,,11,,,,23,24,37,,,,,,39,,,,12,15,13,,14,,,16,14,147,41,131,
     42,,7,,7,,,8],[,,,,31,,34,,,34,,26,44,,,23,,55,,,,23,,,,,,42,,53,,,63,
     49,285,285,206,,23,,31,,24,22,,,47],
   [,,,,,,8,,,,,24,,22,21,32,,,21,,,36,,,,11,16,,,13,,15,16,,,36,98,30,,8,,6,
     ,,6,6,,,8],[,,,,27,,30,,,,,,23,21,23,29,,,24,30,,29,,,,,57,40,,47,,
     40,65,,221,,167,173,,,19,21,31,20,,,,21,,27],
   [,,,,27,,34,,,34,,26,42,,,23,,55,,23,,,,,,,,41,,47,,67,65,47,233,235,200,
     205,22,,,,21,23,,,31,,,24,,31],
   [,,,,81,,,,,114,,,,155,133,231,,,,245,,247,,,,,162,112,,134,,191,211,139,
     726,385,707,,112,,,59,,117,82,,225,118,94,243,110,235,250],
   [,,,,,,80,,,,,98,,85,,,,177,104,219,,175,,,,65,,,,98,,117,113,96,847,175,
     684,175,,55,211,35,,105,47,35,,112,,235,47,,237,86],[],
   [,,,,49,,60,,,60,,,,85,131,,,,95,246,,165,,,,63,105,77,,88,,115,99,88,,175,
     ,175,,,,35,267,106,42,35,,104,53,237,42,227,,,35],
   [,,,,75,,100,,,122,,130,,113,140,,,234,,,,225,,,,133,167,108,,130,,,198,141,,
     ,1660,482,112,93,239,57,227,117,110,65,237,117,,,110,234,230,65,86],
   [,,,,67,,,,,92,,102,183,77,97,157,,,92,163,,149,,,,65,,121,,100,,,,98,653,
     175,,175,84,51,152,35,161,84,48,35,259,84,51,162,48,181,161,,35,,35,
     90],[],[,,,,28,,29,,,29,,49,76,49,,,,83,,98,,79,,,,17,,22,,23,,,21,
     23,,91,,85,45,,,17,,61,21,17,83,45,22,163,21,102,86,,125,,119,213,125 
    ],[,,,,,,,,,24,,,57,38,38,62,,64,39,61,,62,,,,20,24,18,,,,26,24,21,
     169,115,174,89,37,18,55,18,61,34,,16,64,34,20,63,18,58,62,165,,,120,
     160,163,,20],[,,,,21,,22,,,22,,,,41,,67,,,41,93,,85,,,,17,21,18,,19,,
     23,21,19,,78,,70,,,,15,,36,16,13,,37,17,,16,59,100,,104,,95,,104,,17,
     16],[,,,,27,,28,,,28,,36,,39,37,,,69,,,,75,,,,,,22,,23,,,,23,,173,,,34,
     19,61,19,67,36,20,19,71,32,,,20,59,82,212,172,,,,182,,,20,17],
   [,,,,28,,29,,,29,,39,,41,42,,,77,39,80,,77,,,,17,21,22,,23,,33,,23,207,
     91,227,85,40,23,106,17,76,40,21,17,,40,23,79,21,74,79,229,125,,119,,
     125,,17,20,17],[,,,,21,,24,,,,,38,74,42,,68,,64,,64,,66,,,,20,24,18,,
     21,,26,24,,173,,178,89,36,18,83,18,61,34,18,16,65,36,20,63,,,64,174,
     156,,120,160,,,20,18,16,20,20],
   [,,,,38,,50,,,50,,,,,37,,,,53,82,,,,,,62,90,53,,66,,104,81,,467,229,257,,
     30,,,31,74,30,66,,42,51,51,76,,41,74,,274,,,352,,,103,81,,108,124,83],
   [,,,,33,,46,,,55,,36,52,27,,,,41,33,42,,35,,,,63,,57,,60,,61,101,,337,
     159,276,159,37,47,47,27,,31,44,31,49,31,49,43,42,47,43,306,215,,211,
     286,199,,103,85,83,85,101,86],
   [,,,,,,,,,40,,34,44,31,31,39,,39,34,41,,39,,,,,58,40,,,,51,63,52,207,,
     195,148,28,43,44,25,44,22,,,46,28,,44,34,41,44,210,190,,194,216,159,,
     96,60,64,61,75,64,29,30],
   [,,,,37,,42,,,44,,,,37,37,45,,,40,66,,45,,,,59,93,53,,64,,79,91,60,,161,,
     161,,,,31,77,47,36,29,,52,58,77,36,,77,,215,,213,428,203,,99,85,84,,
     99,89,,37,46],[,,,,41,,52,,,,,40,52,31,37,38,,45,,,,38,,,,63,82,56,,
     68,,,83,70,330,,281,,37,53,49,31,43,31,64,35,49,31,,,44,48,43,286,,,
     240,284,217,,107,84,83,83,103,86,54,30,30,54],
   [,,,,23,,34,,,38,,28,44,27,27,35,,39,28,41,,35,,,,47,59,42,,42,,49,,42,,
     121,195,117,28,39,47,21,45,22,34,21,45,28,33,45,34,44,45,213,157,,
     153,205,143,,79,62,61,61,75,65,29,27,22,29,30],[],
   [,,,,37,,40,,,44,,36,,27,37,35,,41,32,42,,,,,,63,75,53,,64,,59,79,64,
     311,157,277,159,37,45,47,27,43,31,40,31,49,31,47,43,38,47,,277,215,,
     209,274,199,,103,80,75,79,95,84,,27,30,37,30,27],[],
   [,,,,,,,,,,,,,21,23,37,,,,,,37,,,,11,18,16,,18,,,20,18,,,84,,,,,7,,,,,,,,,,,,,
     46,,,80,42,,21,22,,23,22,22,,39,26,,39,36,,39],[],[],
   [,,,,,,,,,,,18,30,21,,27,,28,18,37,,27,,,,11,14,,,,,16,17,,83,34,,,17,9,
     28,7,29,17,8,6,30,17,9,33,8,28,29,73,48,,46,,42,,21,,16,22,22,20,
     42,39,30,40,49,28,,43,,7],[],[],[],[],
   [,,,,21,,30,,,,,,,19,21,31,,,,34,,31,,,,,45,34,,35,,46,,,,,220,,,,,19,,,,,,
     21,,29,,,,,161,,,,,,64,47,,49,,47,,49,42,,52,,,49,,,,,20],[],[],
   [,,,,,,30,,,26,,17,31,19,,39,,29,16,37,,39,,,,,47,35,,42,,,,37,173,129,
     224,141,16,27,29,19,41,16,21,17,31,16,27,39,21,29,41,191,,,159,173,,
     ,64,50,44,63,58,48,41,49,27,39,52,25,,49,,20,,,,,,,,19],[],[],
   [,,,,31,,,,,,,,,39,35,51,,,,,,51,,,,71,75,,,54,,79,71,78,,,,167,,,,29,,,,,,,,
     ,42,,,,225,,203,368,199,,111,,81,89,107,96,43,33,,41,35,23,,33,,,,,32,,
     ,,,,,,29],[,,,,16,,,,,,,20,45,,18,43,,38,,46,,39,,,,32,38,,,32,,42,43,
     38,,125,227,112,17,27,43,16,43,17,35,19,40,21,28,46,35,38,41,236,,,
     146,193,347,,58,,46,50,59,49,55,55,28,48,56,26,,54,,25,,,25,,,,,21,,,
     21,,,31],[,,,,,,36,,,36,,25,81,39,,23,,41,37,,,23,,,,,,57,,70,,,,54,,
     169,,167,24,42,45,29,25,24,32,27,43,28,42,29,32,41,25,,247,,201,467,
     191,,,95,90,,,87,91,33,35,51,,33,,33,,32,,,,,,,,29,,,,,,39],[],[],
   [,,,,7,,8,,,8,,,,15,17,27,,,,,,27,,,,9,13,11,,12,,15,13,12,,25,,25,,,,5,,
     ,6,5,,,,,6,,,,35,,35,65,35,,17,16,13,19,17,16,,31,,29,35,21,,31,,,,,
     6,,,,,,,,17,,,,19,27],[],[],
   [,,,,7,,8,,,8,,14,25,15,,21,,23,14,,,23,,,,9,21,11,,12,,,,12,76,25,,25,
     14,8,23,5,23,14,6,5,25,14,8,23,6,23,25,65,35,,35,62,35,,17,19,16,
     ,17,19,35,31,25,33,,23,,33,,6,,,,,,,,17,,,,,,27,19,,,,5],[],
   [,,,,,,,,,,,14,40,11,13,31,,,,29,,,,,,10,15,,,,,16,15,16,,25,78,25,12,8,
     27,5,27,12,8,5,27,12,8,27,8,25,27,92,35,,35,,35,,20,,15,21,20,21,
     54,33,27,33,35,25,,33,,6,,,6,,,,,15,,,15,,,,,39,,,5,,,5],
   [,,,,,,,,,8,,15,48,23,17,24,,,18,28,,33,,,,11,16,,,,,17,16,13,,,,30,16,9,
     31,6,27,16,6,6,33,16,9,27,6,33,27,122,49,,42,126,,,21,,16,22,21,
     18,40,46,34,34,44,36,,40,,8,,,8,,,,,19,,,19,,,,,28,,,6,,,6]],
 [,[],[],[],[],[],[],[],[],[,,,,,,10],[,,,,32],
   [,,,,,44,45,,,41],[,,,,87,,68],[,,,,,,,,,,,24,35],
   [,,,,29,,34,,,,23,22,31],[,,,,83,,64,,,102,64,56,89],
   [,,,,30,,35,,,35,,,,21,20,53],[,,,,,,58,,,95,,,,28,27,56],[],[],
   [,,,,60,,54,,,,,,33,40,30,62,,29],[,,,,,,,,,,,50,94,,,,48,53,,,62],[],
   [,,,,,16,,,,,,,,25,25,59,,33,,,,57],[],
   [,,,,9,,10,,,10,,,74,18,,,,54,,,,54,,16],
   [,,,,11,,12,,,12,40,34,47,,23,,32,35,,,,69,,17],
   [,,,,,,,,,,,,38,,22,,23,39,,,30,,,,,7,8],[],
   [,,,,7,,,,,9,26,,72,,27,71,27,,,,54,,,,,8,9],
   [,,,,,16,,,,,36,36,59,,27,55,33,,,,47,53,,15,,16,17],[],
   [,,,,11,,12,,,12,,34,72,29,25,,,47,,,,65,,17,,,8,8,,9,17],
   [,,,,9,,9,,,,,,76,,27,53,28,,,,,,,,,8,9,,,8,,,9],
   [,,,,,210,55,,,57,118,,,,106,,117,,,,232,501,,,,41,,34,,,,,49,44],
   [,,,,,,83,,,,,,381,87,,,102,,,,259,311,,,,30,,42,,,85,,,51],
   [,,,,,,,,,57,,124,184,,113,,109,158,,,162,,,192,,,55,35,,,,,,43,33],
   [,,,,39,86,44,,,44,,,,87,,,,,,,197,,,,,30,37,30,,37,,,37,37,,28,32],
   [,,,,28,29,35,,,,19,,,20,19,50,18,,,,,43,,,,23,26,23,,26,32,,26,26,103,
     98,105],[],[,,,,59,54,53,,,,,,,31,31,55,,29,,,35,53,,35,,,37,35,,
     53,47,,50,,,200,170],
   [,,,,25,,26,,,26,22,24,34,17,,,21,28,,,32,,,25,,16,,20,,21,27,,26,21,99,
     81,,77,20,,30],[,,,,82,67,83,,,89,68,66,103,,,,62,64,,,70,65,,72,,,,
     58,,74,,,83,68,350,,448,,57,,58],
   [,,,,,,,,,30,,22,33,,19,,20,28,,,27,,,24,,22,,18,,,26,,28,24,91,100,96,
     82,18,,32],[,,,,,,,,,24,,55,,,43,115,48,84,,,,,,,,20,24,,,,,,24,21,228,
     174,,84,,,,19],[,,,,21,26,22,,,22,,,,18,17,44,,,,,49,39,,,,16,21,18,,
     19,,,21,19,,79,82,65,,,,16,50,16,16],
   [,,,,57,52,50,,,,,,,29,31,55,,,,,33,53,,,,,44,34,,50,51,,65,67,,264,163,,,,
     ,29,61,31],[],[],
   [,,,,95,56,111,,,113,47,48,65,,,45,44,49,,,55,43,,51,,61,,59,,87,41,,63,
     77,,292,284,223,41,,45,,50,,,37,51],
   [,,,,,,24,,,,,57,,,43,129,48,84,,,,,,,,20,24,,,21,,,24,,,,168,84,,,,19,,,18,
     16],[,,,,57,54,50,,,,,,33,29,31,,,29,,,,59,,,,,38,34,,51,59,,47,,302,,
     ,213,,,30,29,76,32,,,31,,,54],
   [,,,,67,62,64,,,74,49,48,67,,,45,45,50,,,53,,,54,,,,42,,58,53,,,48,271,
     300,,278,42,,49,,53,59,,38,45,,,41],
   [,,,,59,188,,,,75,152,,,155,138,461,148,,,,296,473,,,,50,61,48,,57,149,,
     62,57,219,220,224,,135,,,127,,124,181,,,,,358,219,,337],
   [,,,,78,,84,,,96,173,172,,121,,,138,235,,,,377,,111,,42,,55,,71,,,54,65,
     228,195,229,189,132,,250,111,,131,206,105,,,,359,288,263,364,43],
   [,,,,,,,,,75,,164,237,182,138,,145,204,,,220,475,,191,,51,61,46,,,154,,62,
     58,220,,222,204,136,,216,132,497,126,,106,216,,,318,217,220,,43,46],
   [,,,,55,112,60,,,60,,,,121,125,,,,,,267,359,,,,42,51,42,,51,117,,51,51,,
     193,209,175,,,,107,431,114,116,91,,,,301,116,291,,,38],
   [,,,,60,192,70,,,,178,176,,164,142,446,,354,,,,558,,,,52,65,49,,57,,,62,54,
     ,,231,206,141,,370,132,449,128,232,109,324,,,,,,369,42,46,45,41],
   [,,,,79,179,96,,,,169,165,228,121,133,,139,189,,,223,,,115,,42,,51,,73,117,
     ,,,238,195,228,189,131,,206,111,365,130,206,105,212,,,336,,213,313,46,
     38,43,38],[,,,,10,28,11,,,11,27,,,27,24,67,25,,,,51,65,,,,9,10,9,,
     10,,,10,10,40,41,41,,23,,,23,70,24,23,,,,,56,23,52,58,54,55,55,,56,
     55],[,,,,9,18,10,,,10,25,25,42,18,,,,38,,,47,50,,14,,6,,7,,8,14,,7,
     8,36,30,38,30,21,,,16,,21,20,16,40,,,49,20,48,84,48,42,48,42,49,42,
     8],[,,,,,,,,,8,,23,36,26,22,44,22,34,,,30,66,,,,7,8,6,,,,,8,7,33,
     37,33,30,21,,34,18,51,18,,16,34,,,50,18,34,40,45,49,45,42,46,49,8,
     7],[,,,,7,18,8,,,8,,,,17,17,45,,,,,37,41,,,,6,7,6,,7,,,7,7,,27,,25,,
     ,,15,,16,16,13,,,,35,16,35,37,,37,39,35,40,37,,6,6],
   [,,,,10,28,11,,,11,28,27,,27,24,77,26,56,,,49,77,,,,9,10,9,,10,,,10,10,
     42,41,40,,24,,49,23,84,24,23,28,52,,,,23,44,100,55,55,54,55,55,55,
     7,8,8],[,,,,9,18,10,,,10,25,25,36,18,22,46,24,30,,,37,42,,14,,6,
     7,7,,8,14,,,8,36,30,38,30,21,,35,16,52,21,20,16,36,,,42,20,34,48,
     48,42,48,42,49,42,8,6,7,6,8],
   [,,,,7,24,8,,,,22,26,44,26,,52,22,42,,,,82,,,,7,8,6,,7,,,8,,33,37,33,
     30,21,,42,18,55,18,18,16,51,,,54,,,44,45,49,45,42,,49,8,7,6,6,8,7]
    ,[,,,,73,79,79,,,83,51,,,58,53,80,55,,,,57,81,,,,60,74,52,,67,63,,,,
     257,256,253,,47,,,53,92,44,130,,,,,72,,60,77,340,340,334,,356,338,64,
     56,49,,65,52,53],[,,,,83,123,,,,98,70,60,77,41,,,55,62,,,69,62,,61,,
     52,,,,75,55,,64,,262,223,232,213,50,,69,41,,,,46,67,,,61,,63,61,330,
     297,297,291,338,269,61,46,49,43,61,42,53,53],
   [,,,,,,,,,69,,55,69,69,43,107,51,59,,,,,,51,,54,,40,,,51,,53,59,222,224,
     196,,44,,68,50,,38,,40,68,,,70,66,64,92,287,283,258,261,290,254,57,
     44,37,41,50,40,41,47,46],
   [,,,,67,71,66,,,74,,,,52,49,78,,,,,56,69,,,,52,61,48,,61,59,,61,57,,229,
     238,207,,,,50,92,43,88,39,,,,69,88,57,72,,307,316,285,331,299,,50,46,
     41,67,46,50,,48,44],
   [,,,,74,,73,,,,64,62,80,69,50,71,58,65,,,64,83,,63,,63,61,46,,68,,,71,
     67,257,268,,227,52,,71,54,81,41,126,47,73,,,,103,69,71,328,331,297,
     304,335,,61,52,45,45,60,48,49,50,43,46,49],
   [,,,,60,,71,,,,67,56,73,41,43,,50,57,,,72,65,,49,,46,50,44,,55,43,,,65,
     223,191,206,187,45,,65,39,87,41,94,41,64,,,66,94,,69,287,253,265,247,
     297,231,57,38,40,39,51,34,44,47,38,37,42],
   [,,,,76,,77,,,,67,69,66,,52,,59,57,,,,73,,,,,79,52,,70,63,,77,,258,,255,
     233,53,,70,,,47,125,42,67,,,78,,,77,344,361,336,318,,348,64,58,49,,65,
     54,53,47,,43,44,53,50],
   [,,,,63,73,62,,,74,59,56,75,41,45,80,52,59,,,62,,,59,,52,49,42,,59,69,,
     59,59,,219,223,199,47,,67,41,,39,89,43,67,,,59,76,63,,,291,284,273,
     325,261,55,46,42,41,55,42,46,49,38,45,45,39,38,53],
   [,,,,,,,,,,,,,17,17,49,,,,,,,,,,6,7,,,,,,7,,,27,,25,,,,17,,,,15,,,,43,,,40,,
     37,,35,,37,,6,,5,,6,,,45,,43,51,43,,43],[],
   [,,,,,,,,,,,,,22,,58,,,,,,78,,,,8,9,,,,,,9,,,34,46,,,,,22,78,22,,,,,,52,,,46,
     ,46,,,56,46,,8,,,,8,,,56,56,,,50,62,52],
   [,,,,,,,,,,36,29,60,18,23,62,22,42,,,,68,,20,,6,,8,,10,20,,8,10,44,30,,
     30,23,,49,18,,,,18,,,,,,55,72,56,42,58,42,60,42,9,6,8,6,9,6,8,66,
     52,52,52,66,36,,52,6,,7],
   [,,,,,,,,,,36,44,93,,,80,35,,,,54,,,,,,,,,,,,,,184,208,252,84,32,,55,,70,30,
     20,16,53,,,83,24,53,55,180,,193,116,,238,26,30,,16,26,32,24,78,74,
     57,78,90,60,96,86],
   [,,,,,,,,,,,35,,,23,69,,55,,,,75,,21,,8,7,9,,11,21,,8,11,50,41,,37,28,,
     47,25,,29,,23,58,,,71,,53,,64,55,70,51,,55,10,8,9,7,10,7,9,74,65,
     60,61,,49,,59,7,,8],[],[],
   [,,,,,,,,,,,,,,25,,30,59,,,,77,,21,,,8,9,,11,21,,7,11,59,39,56,37,,,,25,
     69,29,,23,,,,53,,57,79,64,53,,51,66,53,10,7,9,7,10,8,9,74,63,66,
     61,74,55,80,59,7,,8,,,8],
   [,,,,31,34,37,,,,,,,19,21,50,,,,,,43,,,,,24,23,,29,27,,23,,,98,113,91,,,,
     19,51,22,,,,,,38,,,47,,132,139,125,,,,22,22,17,29,,22,,53,54,49,57,,
     62,53,17,,,23,33,27,,,23],
   [,,,,66,,75,,,,,,,54,45,124,,,,,,75,,,,102,59,48,,58,50,,58,107,,,,,,,,50,,
     41,114,,,,,65,,,76,,365,321,,433,283,,50,42,,,42,48,,50,38,,47,40,,,,,,
     63,65],[,,,,,32,,,,,,,,,,,,,,,78,78,,,,,,22,,,,,,32,112,,124,114,,,60,,
     60,20,59,,61,,,61,56,,,146,154,157,142,163,163,26,26,21,20,27,26,21,
     66,66,54,58,58,50,60,60,,,,,,,,,,20],
   [,,,,,,34,,,34,23,27,65,19,23,59,,43,,,,57,,,,,37,22,,27,28,,,26,111,100,
     112,103,21,,41,19,79,18,37,17,41,,,51,37,41,67,148,134,140,132,151,
     140,32,24,22,19,,23,22,54,53,37,49,58,35,54,53,21,,23,22,,,,,34,19,
     47],[,,,,,50,,,,,64,51,118,54,49,64,64,,,,88,39,,,,61,67,36,,,,,,58,,,
     190,,44,,95,44,51,36,66,35,,,,35,62,82,35,310,,248,301,,264,53,49,34,
     35,63,41,,77,50,41,74,40,39,89,37,,,,,46,,,,,51,50],
   [,,,,43,,47,,,37,,,,29,23,85,,,,,,,,46,,,34,27,,38,30,,,34,137,140,125,,25,
     ,48,24,98,22,47,20,48,,,58,41,48,58,179,172,162,,179,169,29,25,23,,
     27,25,24,68,68,59,,68,63,62,73,,,29,29,78,,,,35,22,,28,,69],
   [,,,,,,82,,,,,,,42,39,64,,,,,,61,,,,66,47,48,,,49,,45,,288,243,182,249,,,,
     40,76,37,79,,,,,65,73,,61,344,293,250,277,428,223,71,42,40,59,53,34,
     48,59,37,38,53,41,31,58,35,,,,40,86,51,,,73,,38,,35,39],
   [,,,,30,31,41,,,,,,,29,22,87,,53,,,,142,,,,24,28,26,,30,,,28,,122,,117,114,
     ,,,22,61,21,,21,55,,,86,,,61,156,,153,155,168,154,26,23,24,20,27,23,
     23,64,67,51,55,63,49,,63,,,,,36,32,,,,,,,21,,24],
   [,,,,,,50,,,110,,,,42,43,41,,76,,,,39,,79,,,51,38,,83,45,,,49,337,231,231,,
     ,,70,40,48,36,62,36,102,,,38,64,,35,,289,275,313,346,231,51,,36,35,
     63,34,42,73,39,40,66,47,39,70,37,47,,48,86,,67,,,69,38,47,,,36,,38],
   [,,,,58,45,62,,,,,,,52,42,74,,,,,,64,,,,,67,36,,58,43,,,,336,,190,,,,,44,
     84,33,60,55,,,,67,,,63,351,,249,279,315,259,63,47,34,45,53,41,,65,39,
     34,60,40,40,61,37,,,,54,50,,,,,,40,86,,38,,33],
   [,,,,,55,,,,,,,,52,51,47,,,,,104,,,,,55,59,48,,107,,,107,58,412,578,229,,,,
     95,48,48,42,70,,95,,,41,72,,47,413,367,301,,,283,61,48,42,46,98,42,
     50,,45,46,,48,45,100,,59,,,,,,,,,47,,,,40,,44,,41,46],[],
   [,,,,7,18,8,,,8,,,,17,17,45,,,,,37,41,,,,6,7,6,,7,,,7,7,,27,,25,,,,15,,
     16,16,13,,,,35,16,35,37,,37,39,35,40,37,,6,6,5,,6,6,,43,41,41,45,
     39,,41,5,,,6,16,7,,,7,17,,20,19,35,,59,20,35,45,46],
   [,,,,7,,8,,,8,20,22,52,25,21,,,33,,,,53,,15,,,,6,,7,15,,,7,29,34,29,25,
     18,,39,22,,16,16,13,38,,,79,16,,,39,44,39,35,40,45,8,8,6,5,8,8,6,
     45,50,35,41,45,40,45,41,5,,6,,,,,,,23,44,19,,,,37,20,,,77,,5],[],
   [,,,,9,,10,,,10,28,28,51,18,22,54,22,38,,,51,56,,16,,6,,7,,8,16,,7,8,
     39,30,,30,22,,42,16,,,20,16,,,,,20,48,63,51,42,53,42,52,42,9,6,7,6,
     9,6,7,57,48,47,48,57,36,,48,6,,7,6,,,,,7,22,51,,22,,28,38,25,54,
     51,88,,6],[,,,,,,,,,,,,48,17,17,43,20,,,,,,,,,6,7,,,,,,7,,31,27,31,25,
     18,,,17,52,18,,15,35,,,39,,41,35,41,37,41,35,,37,8,6,8,5,8,6,8,47,
     43,43,41,47,39,47,41,5,,6,6,,7,,,7,17,77,18,17,78,,,,39,,44,,5,5,,
     6],[,,,,,16,,,,8,22,27,64,32,21,48,24,,,,40,,,,,7,8,6,,,,,8,7,34,,
     34,30,22,,41,18,57,18,,16,39,,,,18,39,41,46,51,46,42,47,54,9,7,6,
     6,9,7,6,52,57,46,48,52,50,52,48,,,8,8,20,9,,,9,23,88,23,21,38,27,
     ,25,44,52,51,,6,6,,7],[]],
 [,[],[],[],[],[],[],[,,17],[],[,,,,,,10],[],[],
   [,,53,,85,,114,64],[,,,,,,,,,,,,52],[,,42,,30,,35,50,,,,,45],
   [,,,,61,,44,64,,,,,58],[32,,,,29,,34,34,,34,,,,20,20,30],
   [,,,,,,,62,,,,,52,46,48,60],[32,,39,,,,,,,,,,47,,,,22,50],
   [,,52,,60,,,39,,,,,50,,,34,30,62],[],
   [,,54,,,,58,,,,,,51,,,28,27,53,,29],
   [6,,,,7,,8,,,8,,,,26,,52,21,53,22,,,33],
   [,,,,,,,18,,,,,,,31,50,,60,35,53,,46],
   [,,,,10,,11,,,11,,,,,31,53,30,65,29,46,,39],
   [,,,,9,,10,,,10,,,74,18,,,,54,,,,54,,16],
   [6,,14,,7,,8,14,,8,,,37,,21,,21,37,20,39,,41,5,13,7],
   [,,,,,,,,,,,,45,,19,31,19,41,21,,,25,5,,7,7,5],
   [,,18,,,,,18,,,,,,38,,54,32,70,35,,,54,,12,,,13],
   [6,,,,7,,,24,,8,,,46,,24,40,23,70,24,34,,38,6,,8,8,6],
   [,,18,,,,,,,,,,70,38,42,40,29,54,,,,42,,12,,16,13,,12],
   [,,,,10,,11,,,11,,,76,,,,,65,27,,,55,,,7,,7,7,,8],
   [6,,,,7,,8,,,8,,,,26,,52,21,53,22,,,33,5,,,,5,5,,6],
   [6,,24,,9,,8,,,,,,,30,24,36,25,,23,30,,34,6,,8,8,6,,,6,,8,6],
   [42,,,,,,53,,,64,,,,,119,,112,457,139,,,,29,,,41,28,29,115,,,40,29,34],
   [,,,,54,,,,,68,,,393,87,,,95,,150,354,,215,,74,51,30,,31,74,40,,59,,40,36 
    ],[],[30,,84,,39,,44,86,,44,,,,87,,229,,,,197,,,25,64,37,30,25,25,
     64,30,64,37,25,30,32,28],
   [18,,,,26,,28,27,,,,,,22,19,32,18,,21,28,,26,16,,,23,16,17,28,18,28,26,
     16,18,92,99,,82],[],
   [,,,,82,,75,79,,,,,,54,62,68,,65,66,70,,64,,69,,,47,45,61,56,62,76,,,,
     349],[30,,,,25,,26,,,26,,,43,17,,,20,42,,,,,22,,,16,,19,24,20,28,,22,
     20,103,81,,77,22,,50],
   [52,,60,,59,,53,77,,67,,,57,,,,31,53,,35,,29,39,52,49,,,29,47,40,47,,39,
     36,303,,,,36,,58],
   [30,,35,,,,,29,,33,,,63,,21,33,19,,23,,,28,18,31,24,22,17,17,,,27,23,18,
     22,100,102,,,18,,,20,31],
   [,,,,,,,,,24,,,,,48,87,43,,52,,,84,16,,23,20,16,,,,,23,16,18,231,,,84,,,,
     19],[18,,30,,21,,22,26,,22,,,63,18,18,28,,,20,27,,25,13,26,21,16,
     13,15,26,16,24,21,13,16,81,79,,65,16,,,16,29,,16],[],
   [18,,29,,23,,30,,,28,,,38,,21,,18,40,,,,50,16,29,27,,16,17,27,18,,,16,18,
     ,97,,82,17,,53,,,18,,16],[],
   [52,,,,58,,51,,,65,,,,,,30,32,75,,,,30,34,,,61,,29,45,40,39,,34,36,,,,203,
     30,,,,35,33,,30],[,,,,,,24,,,,,,,,48,87,43,,55,,,84,16,,23,20,16,,,18,
     ,23,16,,,183,,84,,,,19,,,18,16],
   [,,,,67,,60,66,,,,,44,39,45,51,,43,48,53,,50,,,,,41,36,62,47,65,,,,273,,,,
     ,,53,37,49,,,,,39,,65],
   [60,,72,,57,,50,56,,64,,,61,,,33,31,55,,35,,,43,57,,,,29,47,39,47,,43,
     35,284,214,,,38,,66,,30,31,,29,,,,32,,54],
   [54,,,,59,,,183,,75,,,,157,148,331,138,473,,296,,,39,,,50,38,39,164,46,
     132,59,39,46,220,220,,,123,,,128,,135,171,111,,125,,337,219,355,297],
   [70,,143,,68,,,152,,,,,,121,,,129,353,177,340,,245,41,94,,42,,39,94,52,94,
     73,41,52,231,195,,189,130,,425,111,,132,249,105,,129,,286,215,344,287,
     43],[54,,266,,,,,,,76,,,410,187,146,238,145,523,165,,,214,40,134,,51,
     39,41,,,144,57,40,48,226,246,,213,127,,491,130,226,141,,,,128,,226,230,
     335,222,45,46],[42,,112,,55,,60,112,,60,,,313,121,142,,,,167,233,,215,
     35,88,51,42,35,35,88,42,88,51,35,42,210,193,,175,114,,461,107,241,
     130,116,91,,114,,333,116,333,,42,38,41],
   [52,,,,58,,80,,,73,,,,150,152,,,529,,,,246,39,194,57,52,38,39,,46,,,39,46,
     ,220,,203,127,,541,131,281,136,258,107,,123,,,211,495,297,39,45,45],
   [,,,,,,81,158,,81,,,,121,144,195,129,449,160,221,,189,,,,42,,39,,50,110,69,
     ,52,,195,,189,,,,111,205,133,,105,,129,,,223,309,206,,38,46,38,45],
   [10,,,,12,,13,32,,13,,,,31,28,52,31,78,34,,,52,8,,,9,9,9,23,10,,10,8,
     10,45,,,42,26,,,26,57,28,27,24,,26,,50,27,69,54,61,62,63,58,62],
   [10,,18,,9,,10,18,,10,,,62,18,,,,50,25,47,,38,8,12,10,6,,7,12,8,12,10,
     8,8,38,30,,30,22,,,16,,21,20,16,,21,,46,20,84,48,48,42,49,42,49,42,
     8],[10,,,,,,,28,,10,,,60,26,26,35,25,71,29,,,39,9,22,11,7,8,7,,,22,
     11,9,8,41,39,,35,24,,55,19,40,23,,19,,23,,39,22,55,39,53,53,55,49,
     55,53,9,7],[10,,18,,9,,10,18,,10,,,72,18,21,38,,,25,47,,38,8,12,
     10,6,7,7,12,8,12,10,8,8,38,30,,30,22,,72,16,,21,20,16,,21,,39,20,
     59,50,48,42,49,42,49,42,8,6,7],
   [10,,32,,12,,13,,,13,,,,,30,52,31,72,,,,60,8,,10,9,9,9,23,10,,,8,10,,47,
     ,42,26,,78,,,27,27,24,,26,,,27,61,,62,63,62,58,61,63,8,8,9,8],
   [,,,,9,,10,,,10,,,,18,23,30,22,48,28,39,,30,,,,6,7,7,16,8,,,,8,,30,,30,,
     ,,16,35,22,20,16,,22,,,20,60,37,,42,51,42,52,42,,6,7,6],
   [,,28,,11,,10,,,,,,68,26,,43,25,81,28,46,,47,9,22,11,7,8,7,,8,22,11,9,
     ,41,39,,35,,,78,19,44,23,22,19,,23,,43,,,43,53,53,54,49,54,53,9,7,
     7,7,9,7],[,,,,73,,71,70,,85,,,,58,56,73,48,106,60,66,,63,45,,,60,
     42,39,,50,66,63,45,,253,254,,,40,,,55,74,45,113,40,,47,,68,,66,76,
     330,329,304,302,326,,67,52,53,52,68,,57],
   [,,,,,,87,108,,92,,,76,45,,,52,74,71,62,,70,47,60,73,52,,43,58,58,62,
     75,47,60,,231,,221,49,,84,45,,49,107,46,,48,,60,91,71,87,340,313,354,
     303,340,305,72,50,57,50,,48,61,53],
   [58,,50,,,,,56,,73,,,91,62,51,71,43,,55,,,59,35,48,56,54,36,33,,,52,58,
     35,42,224,222,,,37,,,49,68,39,,37,,41,,67,64,70,68,287,283,263,263,
     282,253,56,44,43,44,61,44,47,46,47],
   [54,,75,,67,,60,66,,74,,,60,52,52,66,,,56,62,,59,41,56,51,52,39,35,62,
     46,60,57,41,42,240,225,,199,39,,78,50,67,48,84,35,,44,,70,90,65,67,
     312,295,,269,309,263,64,46,49,46,64,42,53,42,48,39],
   [64,,72,,72,,86,,,,,,74,62,59,70,52,118,,,,57,45,68,67,63,42,43,69,54,,,
     45,54,,268,,,47,,93,54,70,46,125,48,,44,,,85,77,70,341,352,349,320,
     341,336,72,58,59,58,71,59,63,49,50,47,52],
   [,,,,60,,71,60,,82,,,,45,50,59,43,,56,72,,57,,,,46,37,35,40,44,46,65,,
     46,,189,,187,,,,43,65,41,94,37,,44,,,94,,65,,251,270,249,285,231,,38,
     43,38,62,36,47,,42,37,38,50],[],
   [54,,72,,63,,68,73,,74,,,70,45,60,80,49,75,70,56,,,41,60,59,52,39,39,
     58,50,64,59,41,50,250,227,,207,44,,85,45,71,47,89,43,,43,,61,80,73,,
     324,307,326,285,324,297,66,50,53,50,66,48,57,50,42,43,45,44,42],
   [,,,,,,,,,,,,,18,24,30,24,,29,42,,30,,,,6,7,,,,,,,,,30,,30,,,,18,39,23,,18,
     ,23,,,,,38,,42,54,42,,42,,6,8,6,,6,8,,52,50,42,65,40,,52],
   [,,,,,,,,,,,,,,54,,39,,,,,86,,,,,18,,,,,,,24,,201,,84,,,,,,,,18,,,,,,,,,226,,116,
     ,,,30,,32,34,,36,,134,,86,108,,,74],
   [,,,,,,,,,,,,,26,,57,23,75,35,,,55,,,,8,9,,,,,,,,,39,,37,,,,26,47,28,,23,,
     29,,,,,52,,,,51,68,,,8,,8,,,,,63,60,61,,,,59],
   [,,,,,,,,,,,,114,17,20,73,17,,,,,,5,14,9,6,5,5,14,9,14,9,5,9,37,27,,
     25,19,,75,17,67,,,15,,,,,,,,47,37,,35,47,37,10,6,10,6,10,6,10,55,45,
     45,43,55,35,,43,6,,7],[],
   [,,,,,,,,,,,,,22,,50,,70,,,,,6,17,9,8,7,6,17,8,17,9,6,8,40,34,,,22,,72,
     22,,24,,27,,,,,,46,,52,46,60,,,46,10,8,9,7,10,7,9,62,56,56,61,,50,,
     52,7,,8],[,,,,,,,,,,,,50,,35,64,,,,54,,,,,,,20,,,24,,,,,,190,,84,28,,76,
     18,55,50,20,18,,28,,55,24,55,53,,,,116,242,264,34,30,36,32,,,,,81,73,
     82,77,60,,72,,18],
   [,,,,,,,,,,,,152,,34,41,24,61,35,,,35,,,,,9,,,,,,,,,39,,37,33,,72,26,38,,,
     23,,29,,42,,,37,73,53,74,51,83,,10,7,9,8,10,7,9,73,59,,51,,45,,55,,
     ,8,7,,8],[],[,,,,29,,34,32,,,,,,19,23,29,,,26,33,,30,,,,,19,18,31,
     23,30,,,,,116,,,,,,19,34,,,,,21,,,,,30,,138,146,,,131,,28,27,,29,22,28,,
     53,,,61,47,,53,22,,,,,22],
   [,,,,72,,86,64,,,,,,80,57,86,,,63,68,,67,,,,102,41,45,,40,70,107,,,,,,281,,
     ,,67,97,53,120,63,,48,,,,,103,,403,351,335,443,,,64,61,72,,,68,,69,43,
     ,68,,,50,,50],[30,,,,,,,,,,,,76,,,76,,78,,78,,,19,,29,,18,25,34,,,26,
     19,24,115,,,114,23,,60,23,60,24,56,20,,20,,,59,,,146,159,154,147,150,
     158,29,26,27,26,31,30,27,62,62,54,60,60,50,,,35,53,,,,,,,,,66],
   [,,,,,,37,38,,37,,,57,19,,78,21,61,24,,,,,38,35,,19,19,,28,32,,,24,120,
     97,,93,20,,64,19,51,20,42,17,,18,,,42,49,55,152,131,154,127,146,137,
     32,22,26,24,32,23,26,55,53,39,49,57,37,,53,25,35,26,17,,,42,23,,19,
     43],[,,,,,,,,,,,,83,80,,,35,100,,32,,31,48,,40,61,33,29,56,,,51,48,
     40,335,,,,34,,81,63,34,37,93,32,,58,,30,93,78,,311,320,241,,,228,64,
     44,39,42,70,39,,80,69,67,79,63,61,,,44,93,,,,,,55,,34,69],[],
   [,,,,,,,58,,,,,,60,56,68,,,60,81,,65,35,60,65,66,39,35,46,52,50,69,35,
     82,,259,,273,,,,50,69,,,,,44,,69,,,67,366,319,429,357,446,293,62,52,57,
     46,74,48,67,69,45,43,61,47,35,,43,,,59,,,,,47,,,43,57,39,67],
   [,,,,,,,,,,,,61,,20,84,23,65,,82,,,21,37,26,24,19,21,31,23,,27,21,24,
     124,133,,117,22,,71,22,97,22,47,19,,21,,,46,53,,157,,161,152,156,151,
     30,23,28,23,31,24,29,59,,43,53,65,41,,69,27,42,,,,27,,32,,21,47,,,,,
     43],[,,,,,,44,47,,98,,,90,60,,29,29,70,,,,27,,66,53,,35,31,,74,36,,,
     34,,211,,213,29,,84,48,29,30,74,28,,47,,,70,,29,,267,235,243,319,195,
     52,,35,36,54,30,41,67,51,53,62,68,51,,49,30,68,53,79,,56,,,,,68,,,36,
     ,56],[],[,,,,,,,41,,,,,72,,80,29,33,110,,29,,,,,50,55,31,31,52,42,
     76,58,,30,313,,,217,27,,81,,29,30,66,27,,39,,31,66,68,30,273,,225,
     247,261,223,56,42,39,44,52,38,47,68,47,49,66,49,47,,50,40,54,,,,,,60,
     ,30,50,,,35,,53,,32],[],
   [,,,,9,,10,,,10,,,,18,23,30,22,48,28,39,,30,,,,6,7,7,16,8,,,,8,,30,,30,,
     ,,16,35,22,20,16,,22,,,20,60,37,,42,51,42,52,42,,6,7,6,,6,7,,48,
     44,42,59,36,,48,6,,,6,,7,,7,,22,,30,23,39,,48,24,30,,38],[],[],
   [6,,18,,7,,8,18,,8,,,45,17,19,35,17,59,22,35,,,5,14,8,6,5,5,14,6,14,
     8,5,6,30,27,,25,16,,64,15,35,,16,13,,16,,,16,,39,40,37,40,35,40,37,
     9,6,7,6,9,6,7,46,43,35,41,46,33,,41,6,16,7,5,,,16,7,,,37,,17,,,,
     21,45,,37,,6],[,,,,,,,,,,,,77,17,19,39,17,,,44,,,5,12,8,6,5,5,12,8,
     12,8,5,8,31,27,,25,18,,56,17,33,18,,15,,18,,35,,41,33,41,37,,35,41,
     37,9,6,9,6,9,6,9,47,43,40,41,47,33,,41,6,,7,5,,6,,7,,17,57,,17,
     48,,,,43,,,,6,,,5],[6,,,,7,,,16,,8,,,48,30,23,32,21,,25,30,,39,6,16,
     9,7,6,7,16,6,16,9,6,6,35,,,30,18,,56,18,35,22,,16,,18,,35,18,41,
     33,47,50,46,42,46,53,10,7,7,7,10,7,7,47,56,40,42,52,44,,48,8,,9,,
     ,8,20,9,,21,48,22,23,38,,,27,32,,30,,7,,,6],[],
   [,,,,9,,10,,,10,,,64,18,23,,23,46,,,,46,,16,,6,7,7,,8,16,,,8,41,30,,30,
     23,,56,16,56,22,20,16,,,,42,20,,,50,42,51,42,52,42,9,6,7,6,9,6,7,
     56,48,50,48,59,42,,48,6,,7,6,,7,,,,,88,,,51,,52,24,,,49,,6,,,6,6,7] 
  ],[,[],[],[],[],[,,20],[,4,,6],[,,12],[,,,6,,,6],
   [,4,,,,,4],[,,,,22],[,15,,,18,,,66,,15],[,,36,,52,,32],[],
   [,,38,,22,,18,,33,,21,19,29],[],[32,,34,,,,18,,,,,19,,,18],
   [,,78,,,102,26,162,44,,,,34,,31],
   [32,13,31,23,,,14,,,13,25,,33,,16,,16,27],
   [,,,,91,,,72,,,38,74,46,,,,41,80],[,,,,,,32,,,,,,,,29,,,34,33,53],[],
   [6,,,,5,,6,,,,,,,,,,21,,20],[,,,,,15,,18,,,,,,,38,,31,,37,87,65],
   [,7,,,8,,8,,9,7,,25,,,,,29,,23,76],
   [,7,,9,5,15,6,15,9,7,17,17,45,,,,,39,19,,39,,5,15,7],
   [6,10,12,12,8,18,8,12,12,10,24,24,30,,25,,24,36,25,,40,,6,16,8],
   [,,,,,,,,,,,,38,,22,,23,39,,,30,,,,,7,8],
   [,,20,,,,,,,,,,,,,,48,,,,,,,21,,15,16],
   [6,7,20,9,5,,,18,9,7,18,17,31,,20,,19,35,21,41,35,,5,,7,5,6],
   [,,20,,,17,,,,,,47,,,,,41,183,,,102,,,13,,15,16],
   [,7,,9,8,,8,,,7,,26,47,,,,28,41,23,,,,,,7,7,8,,,7],
   [6,10,12,12,8,18,8,12,12,10,22,24,34,,24,,23,40,25,44,44,,6,16,8,,6,
     8,16,6,16,8],[6,,,,5,,6,,,,,,,,,,21,,20,,,,5,,,5,6,,,5,,,6],
   [42,,,,,,28,,78,,97,,,,99,,104,298,112,306,,,29,,,29,36,34,185,,162,51,36,
     29],[,,,38,34,96,26,100,40,,118,,342,,,,110,,98,,317,,34,95,43,31,,
     42,93,31,95,43,,34,34],
   [,32,,66,,,,,78,32,101,,140,,101,,96,176,103,,147,,29,183,47,29,34,35,,,
     228,55,34,29,,34],[30,20,60,32,25,60,20,60,32,20,91,99,188,,,,,,75,
     230,204,,25,,37,25,30,30,75,25,75,37,30,25,26,,26],
   [18,,,,18,36,16,28,30,,16,,,,19,,19,46,21,32,,,16,,,17,18,23,38,16,38,
     26,18,16,85,98,84,74],
   [,,,,,,10,,12,,,,,,27,,27,50,,,,,,,,13,18,,,15,,17,18,,,50,,42],
   [,,,,42,59,26,59,51,,,,,,29,,,32,33,49,26,,,52,,,35,35,63,34,58,48,40,,,
     274,144,178],[30,10,,12,15,34,8,34,12,10,18,16,26,,,,15,26,13,,26,,
     13,31,15,9,,20,35,11,35,15,18,13,66,36,62,30,16,8,26],
   [52,35,,55,,,30,69,,35,37,,42,,,,37,68,,36,47,,36,55,52,,,58,62,37,54,
     67,43,36,247,,206,192,31,,41],
   [30,18,30,30,,,,,,18,26,,30,,19,,19,34,,,24,,18,29,28,17,22,18,,,55,,24,
     18,84,100,85,74,22,,25,16],
   [,10,,12,,,,,12,10,,,,,19,,19,34,,,,,14,,16,10,14,,,,,16,14,14,98,36,,30,
     ,8,,6],[18,10,24,12,15,28,8,28,12,10,26,16,44,,15,,,,13,34,44,,13,
     ,15,9,12,18,37,11,37,15,12,13,70,36,66,30,16,8,,6,30,16,6],
   [,,68,,43,58,26,58,51,,,,27,,29,,,,33,42,31,,52,,64,53,36,34,60,33,64,
     42,45,52,241,308,144,,,,29,26,43,29],
   [18,18,24,30,20,,16,,,18,16,24,24,,19,,19,34,,,30,,16,32,26,17,18,,,16,,
     ,18,16,88,102,89,74,14,,29,16,,,,16,25],
   [,,,12,,,10,,,,,,,,27,,27,44,,,,,,,17,13,18,,,15,,,18,,,48,,42,,8,,8,,,8,8 
    ],[52,35,,55,66,61,30,,,35,43,45,47,,,,37,68,,,42,,38,54,58,61,,59,
     77,38,52,,43,38,205,306,302,189,37,,35,,33,53,,30,41],
   [,,,,,,8,,,,,,,,19,,19,40,,,,,,,,11,16,,,13,,17,16,,,39,112,30,,,,6,,,6,6],
   [,,,,42,58,26,58,51,,,,,,29,,,32,33,49,,,,,,,36,34,58,34,63,48,43,,,,144,
     180,,,,26,41,24,,,29,29,,40],
   [60,35,,55,,54,30,52,,35,34,,43,,,,37,68,,34,47,,36,62,52,,,42,57,37,
     64,67,47,36,222,252,399,194,28,,41,,32,,,30,35,,,33,,41],
   [54,,,,40,139,,,,,132,,,,133,,126,387,,470,,,39,,,39,46,48,220,38,172,64,
     48,39,194,224,197,168,114,,,78,,112,78,78,237,112,,299],
   [70,37,,,44,114,34,120,50,37,146,137,,,,,142,511,126,482,344,,44,119,56,
     41,,55,119,41,121,57,52,44,218,234,222,197,126,63,284,48,,128,48,48,,
     130,64,336,53,289,308,42],
   [54,,,,,,,,78,,133,,,,126,,129,226,121,334,195,,40,156,,39,46,46,,,,61,46,
     40,199,228,195,173,113,206,189,82,290,113,,84,189,112,140,,,192,289,
     41,42],[42,28,84,44,35,84,28,84,44,28,126,123,226,,114,,,,97,298,
     260,,35,,51,35,42,42,98,35,99,51,42,35,180,233,176,140,102,58,220,
     42,246,102,42,42,,102,58,256,42,230,,34,38,34],
   [52,46,,,40,133,36,,,46,131,137,254,,135,,,,,,260,,39,,64,37,52,49,,38,,,
     47,39,196,240,199,168,115,200,351,74,293,114,108,78,264,112,,,122,236,
     357,34,46,39,34],
   [,,,47,43,109,32,109,47,,,,213,,135,,131,276,115,306,206,,42,112,54,39,,
     51,113,39,113,54,,42,204,,206,,,61,195,46,233,123,46,46,197,,64,240,
     48,197,235,39,37,41,,41],
   [10,,,,10,24,10,26,12,,,,,,35,,29,72,29,,,,8,,,9,10,9,,9,,10,10,8,46,
     50,44,42,26,,,20,55,26,20,18,69,26,22,57,,,57,62,65,60,58,60,64],
   [10,13,,15,10,15,10,15,15,13,26,30,47,,,,,49,31,,47,,9,14,11,7,,7,15,
     8,14,11,8,9,41,41,41,35,24,23,,15,,23,18,15,58,23,23,51,21,55,59,
     55,55,53,49,56,53,9],
   [10,10,24,12,,,,21,12,10,22,,36,,22,,21,36,28,54,30,,8,21,10,7,8,6,,,
     19,10,8,8,33,38,34,30,22,20,33,16,37,18,,14,34,21,20,37,18,34,38,
     47,50,45,42,45,48,8,7],
   [10,10,16,12,7,12,8,15,12,10,22,23,44,,23,,,,25,72,38,,8,,10,7,8,6,
     16,7,16,10,8,8,33,38,34,30,22,18,42,14,,18,14,12,,21,18,53,16,49,
     44,47,50,45,42,45,48,8,7,6],
   [10,10,28,12,10,24,10,,,10,31,32,,,33,,29,54,,,55,,8,,10,9,10,9,,9,,,
     10,8,47,50,44,42,26,22,53,20,63,26,20,18,53,26,,,22,55,78,62,68,
     60,58,60,63,8,9,8,8],
   [,13,16,15,10,15,10,15,15,13,,30,39,,24,,27,41,31,61,39,,9,14,11,7,
     8,7,15,8,14,11,,9,41,41,40,35,,23,41,15,42,23,18,15,42,23,23,45,
     21,38,45,57,55,53,49,54,53,9,7,7,7,9],
   [,,,,7,16,8,,,,,,,,,,21,88,27,64,,,,,,7,8,6,,7,,,8,,,43,,30,,,,18,39,18,
     18,16,57,22,,39,,,41,,54,46,42,46,50,,7,6,6,,7],
   [,,,,50,71,40,92,,,44,,,,49,,53,66,47,68,,,,,,47,54,52,,46,,73,54,,228,
     264,220,196,40,,,40,63,45,64,40,52,42,122,67,,,60,299,334,294,268,
     299,311,,61,49,53,72,57],[],
   [58,44,60,70,,,,58,76,44,51,,62,,43,,43,74,,71,62,,41,66,63,37,42,40,,,
     ,58,38,41,194,238,171,172,42,,61,34,,36,,34,57,38,,,,60,61,,296,227,
     226,249,242,60,47,37,41,54,43,46,43],
   [54,34,76,54,45,66,32,74,54,34,51,49,58,,43,,,,37,74,58,,41,,61,43,50,
     48,89,43,90,61,50,41,216,271,204,168,40,60,56,34,62,40,38,32,,42,
     60,66,40,56,60,276,,270,232,276,286,68,57,46,50,68,53,48,38,,38],
   [64,,70,72,50,,40,,,,50,50,62,,43,,45,74,,,68,,45,82,,43,48,46,110,42,,,
     51,45,224,262,202,200,42,62,65,36,54,42,62,36,58,36,,,40,65,54,286,
     324,,,284,269,66,59,45,49,66,54,52,42,,39,42],
   [,38,66,51,37,56,28,,45,38,,45,68,,41,,41,74,33,,68,,43,67,56,37,46,
     44,59,33,71,50,,43,203,227,186,,,56,65,30,65,39,34,30,61,62,53,74,
     40,65,78,262,297,242,,263,,63,47,40,44,57,43,50,43,,35,41,41],
   [,,,,50,72,40,79,76,,,,,,49,,47,66,47,74,,,,,,47,54,52,,46,117,74,54,,,
     268,223,196,,,,40,67,40,64,40,57,47,122,62,,,65,,351,293,268,,312,,61,
     49,53,72,57,,,,38,38,47,43],
   [54,34,60,48,45,70,28,74,48,34,50,44,62,,43,,39,,33,64,62,,41,75,55,
     39,42,42,81,39,77,49,46,41,204,261,180,160,42,46,60,28,56,36,34,30,
     56,36,48,56,32,60,,,308,232,220,260,,62,53,42,46,62,49,48,42,,34,36,
     34,,42],[,,,,,,,,,,,,,,,,28,,41,,,,,,,9,10,,,,,,10,,,53,,,,,,25,50,25,,
     33,116,30,,46,,,56,,67,66,61,,61,,8,7,,,8,7,,,68,65,74,67,,61],
   [,,,,,,,,,,,,,,31,,31,66,,,,,,,,11,12,,,14,,,12,,,58,,44,,,,10,,,,10,,,,,,,,,
     72,142,60,,,,19,20,16,24,18,,,,,62,48,120,,48],
   [,,,,,,,,,,,,,,,,31,136,50,,,,,,,11,12,,,,,,12,,,60,70,44,,,,30,59,28,,28,
     101,37,,65,,,65,,76,,60,,71,,11,,10,,11,,,,77,72,,74,,76],
   [,,,,,,,,,,,,115,,28,,,,,99,,,7,21,11,9,7,8,21,7,21,11,8,7,,53,50,,26,,
     87,25,,,,,112,23,,69,,,,66,67,64,69,60,63,12,8,8,8,12,9,8,,,58,,72,
     56,78,61,9,,10],[,,,,,,,,,,24,25,38,,,,23,46,22,,38,,,,,11,18,,,,,,18,,
     ,58,137,44,22,12,37,10,45,22,8,8,37,22,12,51,8,37,49,,74,172,60,,,
     24,18,,12,24,18,20,60,,46,56,,50,60,54,,10],
   [,,,,,,,,,,,,,,31,,,,,,,,8,22,12,11,10,9,22,8,22,12,8,8,60,58,,44,28,,
     71,30,,,,28,80,,,73,,,,73,74,,60,,70,13,11,9,9,13,9,9,91,,73,72,,67,
     ,76,10,,11],[,,,,,,,,,,,25,34,,23,,,54,22,50,,,,,,11,12,,,14,,,12,,,58,
     ,44,22,12,37,8,45,22,8,10,43,22,12,45,8,37,45,,76,144,60,106,84,
     24,18,20,16,,,,,,46,62,52,50,,48,,10,,,10],
   [,,,,,,,,,,,,,,,,31,58,,,56,,,,,11,12,,,,,,12,,65,60,88,44,40,,46,30,81,,,
     28,47,,,74,,53,59,,76,,60,85,72,12,9,8,10,12,9,8,,,,68,85,64,87,,,,
     10,10,,11],[,,,,,,,,,,,,,,31,,,,50,,,,8,22,12,11,8,9,22,8,22,12,10,
     8,74,62,57,44,,,101,30,60,37,,28,,28,,65,,73,65,,76,,60,76,71,13,9,
     9,9,13,11,9,89,,77,72,88,74,89,88,10,,11,,,10,,11],
   [,,,,22,37,18,36,33,,,,,,21,,,,25,41,,,,,,,24,23,42,20,34,34,27,,,112,96,
     84,,,,18,33,17,,,,21,,27,,,33,,142,125,114,,129,,26,21,22,31,28,21,,,
     49,47,53,53,47,48,24,,,,23,,31,35,31],
   [,,,,55,58,36,52,,,,,,,41,,,,39,60,,,,,,43,38,48,,31,101,59,34,,,,178,236,,
     ,,32,54,40,50,48,,34,98,63,,,55,,345,231,260,,252,,55,41,49,,44,,,,38,
     ,34,35,,34,,42,,83,46],
   [30,,,,,,,,,,,21,,,21,,18,92,18,92,,,20,,42,17,24,22,,,,40,28,20,102,118,
     101,91,18,28,49,18,49,18,18,18,49,18,28,49,18,49,49,130,146,134,
     126,132,148,31,28,21,21,,,26,,,36,50,50,38,50,50,,24,,,,,,,,21],
   [,21,,33,,36,18,37,,21,21,20,37,,21,,21,39,16,56,37,,20,50,28,,23,22,
     35,20,40,28,,20,113,112,93,87,17,25,34,18,47,17,17,15,34,17,25,47,
     17,34,47,137,142,123,117,135,139,31,26,22,22,33,24,23,49,,31,43,55,
     31,49,48,,23,,24,,,31,31,33,18,33],
   [,,,,,52,,86,,,,47,,,40,,,134,36,36,86,,78,,,43,50,36,55,,,67,72,78,255,,
     183,,30,52,61,32,33,34,32,30,61,36,52,31,34,61,31,308,404,234,272,,
     250,75,52,34,42,,44,,68,,36,66,36,36,,32,,46,,,42,,,70,,33],
   [,15,40,25,,,14,,,15,,,,,18,,,,17,54,,,24,45,24,19,24,27,,19,,25,24,24,
     113,106,94,85,16,24,39,14,44,17,16,14,39,17,25,44,17,39,44,132,130,
     126,111,135,150,30,29,24,24,30,29,,49,,44,,48,50,49,48,,24,,,24,,,44,
     ,17,,,17],[,,144,70,52,80,30,54,,,,,,,43,,,,35,66,,,,211,75,43,44,
     48,85,35,63,57,40,,,,202,,74,50,,32,90,40,32,,,42,55,58,41,,66,423,,
     262,,398,330,80,53,40,48,,45,,70,,38,65,38,34,70,34,,60,,,54,76,78,
     60,136,,38,50,35,46],
   [,,42,31,21,,20,,,,25,,96,,22,,,,25,63,,,23,45,30,19,24,26,61,19,,29,
     24,23,113,155,107,121,19,30,49,17,52,21,19,18,49,21,29,52,21,49,52,
     144,,141,169,148,167,36,28,24,23,33,28,25,57,,53,,59,63,60,63,37,29,,
     ,29,,,38,,21,112,,21],
   [,32,106,46,,,24,50,,32,38,,66,,40,,38,,32,38,66,,33,75,47,,44,38,67,
     41,53,45,,33,196,,156,196,26,44,47,26,27,30,28,24,47,32,44,27,30,
     47,27,258,,204,224,260,221,54,,36,42,72,39,40,58,,32,,34,,58,28,51,
     42,64,91,48,94,60,54,64,27,34,,,30,,38],
   [,,,,,44,36,,,,,,,,41,,,,39,72,,,,,,51,50,36,54,35,74,67,44,,,285,176,,,98,
     ,32,61,32,32,48,,42,,54,58,,63,295,372,225,266,290,249,,51,34,42,58,
     45,,58,,32,58,36,35,63,32,,92,,,46,,,,,,35,,33,34,,38,,34],
   [,,,,,,,44,,,,47,,,49,,,150,36,36,,,,,102,51,38,48,67,41,101,59,46,,281,,
     186,,30,52,61,32,31,34,32,30,61,36,52,31,34,61,33,,335,227,264,325,
     251,58,51,41,49,70,44,51,67,,36,62,36,37,62,34,,46,,,96,,,101,,33,34,
     ,,35,,42,,30],[,,,,,,8,,,,,,,,19,,19,40,,,,,,,,11,16,,,13,,17,16,,,39,
     112,30,,,,6,,,6,6,,,,,6,,,,53,,42,122,48,,21,18,16,22,21,,,,,40,40,40,
     ,32,,,,,8,,8,,,,,18,17,34,17,41,21,30,58,34],
   [,,,,7,16,8,,,,,,,,,,21,88,27,64,,,,,,7,8,6,,7,,,8,,,43,,30,,,,18,39,18,
     18,16,57,22,,39,,,41,,54,46,42,46,50,,7,6,6,,7,6,,,46,48,52,50,,48,
     7,,,8,20,9,,8,9,21,,26,23,,,,25,40,,51],
   [,,,,5,,6,,,,20,18,44,,20,,,,,77,,,5,15,8,5,8,6,15,5,15,8,8,5,29,34,
     29,25,18,,36,13,,16,14,13,38,19,,57,,36,,39,44,39,35,39,42,9,9,6,
     6,9,9,6,45,,,41,45,37,45,41,7,,8,,,,,8,,20,52,,,,,52,21,53,,,,6],
   [,,,,,,8,,,,18,18,28,,,,17,33,15,,28,,,,17,11,16,,,13,,,16,,,39,,30,16,9,
     27,6,31,16,6,6,27,16,9,33,6,27,33,122,52,90,42,84,51,22,21,18,16,
     ,21,,44,,34,40,,36,44,34,,8,,,,,8,,,17,34,,,,17,39,21,30,34,58,6],
   [6,,,,,,8,16,,,23,27,38,,21,,,,27,52,49,,6,16,9,7,6,7,16,6,16,9,6,6,
     36,42,34,30,18,,39,18,51,,18,16,41,18,,47,,41,,47,55,46,42,46,51,
     10,7,7,7,10,7,7,53,,40,48,52,45,52,48,8,,9,7,,,20,9,8,23,38,,21,,
     30,47,33,60,51,,,7],[],
   [6,4,12,7,5,12,4,12,7,4,16,,34,,15,,15,,,34,34,,5,13,8,5,6,6,13,5,
     13,8,6,5,24,,24,20,14,9,29,6,29,14,6,6,29,14,9,29,6,29,29,32,37,
     32,28,32,37,9,7,6,6,9,7,6,38,,36,34,38,38,38,34,7,8,8,7,8,8,8,
     8,8,15,42,16,15,32,15,,21,32,42,32,6,6,5,6,6],
   [,,,,,,8,,,,,18,,,17,,,34,15,38,,,,,,11,16,,,13,,17,16,,118,40,118,30,16,
     9,25,6,33,16,6,6,27,16,9,33,6,25,33,84,52,,42,84,51,,21,18,16,22,
     21,,,,34,40,38,36,,34,,8,,,8,,,,,19,,,19,,,48,,36,,,6,,,6,,,6],
   [,,,,7,,8,,,,24,25,38,,21,,23,39,,,30,,,,,7,8,6,,7,,,8,,34,42,35,30,23,
     ,35,18,56,18,18,16,33,,,56,,33,41,47,55,46,42,49,51,9,7,6,6,9,7,
     6,52,,40,48,46,44,52,42,,,8,8,,9,,,9,23,48,22,21,36,27,48,25,38,
     36,48,,6,6,,7,,6],
   [6,,16,,,,8,,,,,,40,,24,,21,,27,40,,,6,16,9,7,6,7,16,6,16,9,6,6,35,41,
     ,30,18,,57,18,41,22,18,16,,18,,41,,41,39,46,53,47,42,47,50,10,7,7,
     7,10,7,7,52,,46,48,53,50,,48,8,20,9,,,8,,9,,21,52,23,23,51,,86,,40,
     ,,,7,,,6,,6,,7]],
 [,[],[],[],[,24,,38],[],[],[],[,,,32,38],[,38,,52,,,,,52],
   [30,,,,135],[,72,,,,103,,,147],[,,92],[30,,,,115,,,,,,15],[],
   [,,,,,224,,,610,,,,53],[48,,91,174,126,,,,,213,,25,,29,,71],[],
   [48,,79,161,86,,,,,152,26,32,50,,,,31],[],
   [,,,,687,,,,,,,,33,43,,47,,,49],[,,142,557,,262,,,,,37,61,,,,33,86,,,,53],
   [20,,,,32,,,,,46,60,,,60,,,86,,86,,200,188],
   [,,,,,68,,,,,,,,,,,119,,112,,315,234],
   [,29,,,44,204,,,40,59,,106,,,,,131,,116,,288,242],
   [20,,,,,,,,,54,57,,,55,,,,,72,,,207,20],
   [,46,,,46,140,,,63,,,96,,,,,117,,95,,228,299,,,34],
   [20,30,112,40,,,,,40,,60,98,150,60,,156,95,,,,168,,20,,29,20,29],[],
   [,42,267,52,31,,,,52,,112,119,,135,,261,125,,119,,354,323,30,,39,,34],
   [,,68,,,72,,,,,102,106,240,,,237,,,,,188,,,52,,82,72],[],
   [,,,57,52,,,,,,,,279,130,,306,113,,95,,,246,30,114,34,,24,29,,35,114],
   [],[10,,,,,40,,,42,,15,,,15,,,32,,,,61,49,20,,,18,,20,,,76],
   [10,,,,,40,,,42,,15,,,15,,,32,,,,61,49,20,,,18,,20,,,76,,,,5],
   [10,,,60,,,,,60,60,15,24,31,15,,33,24,,23,,33,31,20,165,35,19,28,20,,,
     165,,28,,5,5],[10,,36,32,25,36,,,30,36,15,27,45,15,,39,,,27,,45,,
     20,49,28,17,24,20,,29,50,,24,,5,5,5],
   [30,,,,85,52,,,124,,27,,,30,,,36,,39,,,62,60,,,54,,60,,93,92,,84,,28,28,
     27,29],[,,,,148,,,,124,,,,,,,,297,,,,,,,,,,,144,,187,,,203,,,,,94],
   [,,,,,150,,,,,,,,,,,,,70,,53,83,,214,,,,225,,425,,,264,,,,45,62],
   [30,,,,85,56,,,,,30,,,27,,,39,,36,,68,,54,,,45,,54,,91,,,108,,26,26,26,24,
     30],[,,,,639,140,,,,,,,,,,,124,,,,95,56,,378,,,,227,,313,201,,289,,,,46,
     72,,,85],[30,76,56,128,,,,,126,151,27,37,57,27,,59,38,,37,,59,57,60,
     93,91,54,,60,,,95,,86,,26,26,22,24,27,,51,27,51],
   [,130,,162,,,,,168,150,,276,,,,,342,,285,,,,140,,187,162,,,,,,,203,,144,144,,
     90,,,,114],[30,,,96,68,,,,96,,27,36,91,30,,56,,,38,,91,56,54,119,82,
     45,66,54,,86,88,,66,,26,26,26,24,27,,,24,56,27],
   [,,,,,164,,,,,,,57,67,,93,,,81,,54,,452,201,470,293,239,207,,281,378,,289,,
     96,96,46,,,,49,62,,53],
   [30,,,173,106,52,,,,,30,43,,27,,,,,,,62,91,60,108,112,54,88,60,,112,,,89,,
     28,28,27,29,30,,61,27,,27,,30],[],
   [136,,195,394,,140,,,,595,65,86,83,,,53,127,,,,73,53,203,,285,287,,291,,,
     214,,264,,96,96,45,72,61,,63,,49,,,56,85],
   [,94,,111,,,,,111,,,368,,,,,209,,,,,,108,,134,118,156,,,114,,,,,,,,66,,142,,
     114,,,114],[,,,,,158,,,579,,,,56,,,76,,,,,,112,,356,,,,210,,528,242,,,,,,
     46,74,,,51,,92,52,,,51,,,68],[],
   [70,,,,188,302,,,286,353,105,,,105,,,196,,,,279,279,140,,,125,,140,,225,622,
     ,195,,35,35,35,35,195,,,180,,166,,180,480,195,,503,1276,514],
   [70,,,,196,308,,,,325,105,,,105,,,196,,193,,277,297,140,,,123,,140,,241,,,
     206,,35,35,35,35,195,,,176,,166,,176,,195,,,716,528,,35],
   [70,,,274,,,,,332,374,105,180,,105,,,182,,174,,241,241,140,515,,125,191,140,
     ,,549,,191,,35,35,35,35,193,1508,,178,349,158,,178,346,193,,392,1100,
     378,,35,35],[70,,,230,,286,,,237,,105,187,273,105,,,,,195,,285,269,140,
     387,,121,180,140,,225,429,,179,,35,35,35,35,195,1298,416,172,,164,,172,
     ,195,,489,734,,,35,35,35],
   [70,,,,,,,,,,105,,301,105,,277,,,,,,315,140,835,227,125,,140,,,,,192,,35,35,
     35,35,195,1874,573,180,,168,,180,583,195,,,1058,,,35,35,35,35],
   [70,,,253,,370,,,257,,105,,251,105,,,,,,,,251,140,391,230,121,,140,,,383,,,,
     35,35,35,35,191,,365,172,445,160,1711,168,,191,,365,,,,35,35,35,35,35]
    ,[34,,,,52,,,,51,68,108,,,114,,,123,,123,,290,278,32,,,37,,37,,46,,,44,,
     36,36,34,32,98,,,94,,106,187,87,498,100,,285,153,384,,236,244,236,230,
     238,242],[40,,,,,,,,64,82,111,,,105,,,,,130,,,287,37,,,31,,37,,,116,,38,
     ,34,34,37,31,102,,,87,,102,240,87,340,102,,393,184,586,,235,229,235,
     223,235,223,37],[40,49,166,59,,,,,57,62,108,125,248,114,,245,129,,130,
     ,236,,37,182,46,37,46,32,,,176,,44,,36,36,34,32,106,206,257,94,263,
     98,,87,281,104,,340,143,299,,236,244,236,230,238,242,37,37],
   [34,46,142,59,46,,,,57,,90,94,,96,,230,,,100,,225,233,32,117,43,31,38,32,
     ,43,117,,38,,29,29,28,24,81,,247,80,,81,,66,,84,,247,151,300,,186,
     190,186,176,188,188,32,31,32],
   [34,,172,57,52,,,,,,108,127,,114,,273,131,,,,292,376,32,,42,37,44,37,,46,,
     ,47,,36,36,34,32,98,,300,94,342,106,197,87,,100,,,159,363,,236,244,
     236,230,238,242,32,37,37,32],
   [40,55,,73,63,,,,73,,111,129,253,105,,243,131,,133,,,253,37,112,47,31,38,
     37,,46,92,,,,34,34,37,31,102,,290,87,295,102,236,87,,102,,290,,,,235,
     229,235,223,235,223,37,31,37,31,37],
   [40,49,,59,50,158,,,57,,108,141,292,114,,287,129,,128,,,279,37,248,46,37,
     44,32,,41,174,,,,36,36,34,32,106,214,315,94,275,98,183,87,399,104,,
     307,,,,236,244,236,230,238,242,37,37,32,32,37,37],
   [90,,,,227,134,,,,412,39,,,45,,,82,,66,,55,63,168,,,153,,164,,265,226,,229,
     ,41,41,39,43,75,,,78,,65,614,75,92,78,,95,,92,,285,285,281,285,285,
     277,276,279,272,222,276,271,276],
   [90,,,,221,160,,,320,396,45,,,39,,,71,,78,,61,57,168,,,151,,164,,279,,,242,
     ,41,41,39,43,78,,,75,,65,537,78,99,75,,90,459,98,,285,285,281,285,
     285,277,284,273,280,226,284,265,284,45],
   [78,186,108,290,,,,,282,353,39,61,59,39,,59,,,57,,55,59,140,175,221,131,
     193,124,,,171,,177,,37,37,29,33,65,,,65,94,50,,65,96,65,,87,,88,,227,
     227,211,223,231,215,224,229,208,182,228,217,220,39,39],
   [90,189,172,276,232,152,,,276,367,39,78,57,45,,61,,,63,,55,65,168,268,
     244,149,217,164,,260,232,,215,,41,41,39,43,75,681,93,78,99,65,542,75,
     ,78,,114,388,91,,285,285,281,285,285,277,270,267,266,212,270,259,270,
     39,45,39],[90,,,391,246,,,,,,45,69,,39,,55,75,,,,61,59,168,241,265,
     153,225,164,,281,,,229,,41,41,39,43,78,870,105,75,94,65,660,78,140,75,
     ,,,97,,285,285,281,285,285,277,278,279,274,224,278,271,278,45,39,39,
     45],[78,166,,249,191,,,,252,,39,59,,39,,55,61,,,,,61,140,175,223,127,
     204,124,,225,175,,,,37,37,29,33,65,474,98,65,92,50,474,65,92,65,,98,,,
     ,227,227,211,223,231,215,232,217,216,182,236,205,228,39,39,29,39,39],
   [90,199,,324,240,,,,324,,39,75,57,45,,61,83,,66,,,67,168,322,256,153,232,
     164,,268,226,,,,41,41,39,43,75,,94,78,101,65,682,75,92,78,,96,,,,285,
     285,281,285,285,277,276,279,272,222,276,271,276,39,45,39,39,45,39],
   [90,,144,308,220,,,,312,396,45,66,63,39,,55,77,,83,,65,,168,257,261,151,
     204,164,,260,391,,212,,41,41,39,43,78,466,100,75,92,65,,78,99,75,,90,
     418,132,,285,285,281,285,285,277,268,273,264,212,268,265,268,45,39,39,
     45,39,39,45],[,,,,,,,,,,,,,,,,118,,,,,,,,,,,,,,,,,,,,,25,,,,,,83,,105,,,,253,
     ,,,,,,,,188,,,52,,,48,,,,222,222],
   [,,,,,,,,,,,,,,,,97,,,,,194,,,,,,122,,136,,,,,,,,30,,,,,,,,38,,,,,,,,,,272,242,,
     260,,,140,116,142,136,158,,,104,148,,134,,162],
   [,,,,,,,,,,,,,,,,128,,205,,,662,,,,,,,,,,,66,,,,60,32,,,,,,124,,98,,173,,322,,,,,
     ,,228,328,290,,,,32,,52,,,,282,276,,256,320],[],[],[],
   [,,,,,,,,,,,84,92,,,,,,,,,142,,,,,,,,,,,145,,,,,36,52,166,165,32,136,56,,38,
     139,68,,124,131,135,,,,,,,,180,168,180,,,160,182,,,108,172,,,,144,,38],
   [,,,,,,,,,,,,,,,,,,,,466,,,,,52,54,,,,,,66,,42,42,60,30,124,,298,,306,,,98,,
     145,,335,,,,304,,339,235,367,290,51,37,53,32,57,37,51,344,,,275,380,
     234,368,,,,32],[,,,,,,,,,,,,,,,,183,,268,,,,44,106,57,52,32,46,,60,98,,,,
     ,,60,36,,,,,695,142,,,,,,331,,,,345,359,,309,,350,63,43,63,43,69,52,68,
     372,376,337,357,543,327,362,,,,52,,,,,52],
   [,,,,,91,,,174,,,,,,,,,,39,,,,,,,,,,,,,,119,,,,24,30,,,,,,25,,,,,,71,,,,,,182,,,
     191,,,126,103,133,131,,,,68,81,89,75,83,80,79,,,,,,,,174],
   [,,,,,,,,,,,,,,,,,,68,,,75,,,,,,152,,271,210,,240,,,,33,39,,,,,,69,717,91,,76,
     ,142,,,,,,239,261,,247,,,248,221,,,272,,,,,47,33,,53,,88],
   [30,122,,,,58,,,,,15,,53,15,,53,31,,31,,53,53,60,,112,57,99,60,,,,,98,,
     15,15,15,15,30,202,91,30,91,24,202,30,91,30,,91,160,,,105,105,105,
     105,105,105,108,111,108,90,108,111,108,45,45,33,45,45,33,45,45,,52,,,,
     ,,,,29],[],[],
   [,72,103,147,94,,,,,,,,,34,,70,,,45,,,,85,142,103,,95,,,118,105,,,,38,38,
     24,30,35,200,62,29,50,25,192,36,61,29,,48,,60,,189,196,175,185,,190,
     126,127,,95,,129,131,81,78,66,,77,71,75,76,,80,195,,,,,185,,25,,29],
   [],[,81,,,80,,,,136,,26,41,,34,,,39,,26,,64,106,96,147,109,69,111,106,,
     108,,,102,,,,24,27,40,,,31,,31,,38,111,,,126,204,,,209,,175,187,,,125,
     128,138,98,136,135,127,66,79,51,63,81,55,,80,141,121,,,,,,175,,,58,,,,
     34],[,,224,610,,,,,,,,70,79,,,33,,,95,,,33,202,,230,,288,,,508,218,,,,
     61,61,33,45,,376,98,76,49,48,393,56,,78,,71,452,104,,285,287,241,261,
     277,263,281,,243,230,293,243,269,61,43,43,65,47,43,61,43,357,,545,,,,
     224,314,,71,47],[,,,,,92,,,,,,,,61,,79,,,,,,87,184,,292,,283,,,428,231,,,
     ,49,49,31,,,749,,88,193,73,790,91,,80,,219,467,,,271,283,243,273,301,
     253,282,,235,238,300,253,,55,47,31,55,47,33,57,47,,126,,,,,,,,,33,37,,,,
     ,,53],[,,,,,176,,,,,37,59,,61,,33,92,,106,,69,37,,,,183,311,154,,,371,
     ,292,,,,33,39,62,511,95,88,48,46,407,56,,78,,45,328,83,,275,285,241,
     281,295,251,268,287,248,248,312,259,276,65,47,47,67,51,47,73,53,429,
     120,,,,,,,,,53,,,,49,,,33,57],
   [,,,,76,,,,,108,,,,,,,166,,,,,345,,,,,,88,,116,,,132,,,,165,49,,,,,,,114,52,,,,
     ,72,,,,,1012,394,,392,,,133,142,,153,139,,,,253,,177,,296,,,,,,,73,,,,,102,
     ,,110,,,219,,199],[,,,,50,,,,,,,,,,,,116,,157,,334,311,,,,,,36,,45,,,50,,,
     ,,29,,,,,,95,198,86,386,109,,270,144,458,,,,,220,241,234,,,35,,,40,37,,,
     228,251,,,,,31,,,,,,,44,60,112,,118,,,,,131,279,357,427],
   [20,,,,33,,,,,44,60,85,184,60,,202,,,,,,222,20,88,34,20,34,20,,31,86,,,,
     20,20,20,20,60,,204,54,,60,146,54,205,60,,334,108,228,,140,140,140,
     140,140,140,37,37,34,28,37,37,34,168,168,140,168,168,140,168,168,32,
     92,40,,,,98,40,,86,200,60,,,,,86,,,202,,30],[],[],
   [20,24,,,24,,,,52,52,57,85,191,55,,195,72,,,,185,,20,,39,20,29,20,,39,,,
     29,,18,18,19,17,54,,160,51,,54,,49,,54,,160,,181,,125,123,125,121,125,
     121,37,38,37,29,37,38,37,153,151,131,149,153,127,153,151,,90,,,,,98,,,
     71,185,57,,,,,,195,191,181,,,20],
   [,,134,66,32,134,,,66,32,98,99,271,130,,196,103,,107,,306,326,30,,,29,
     36,36,,30,132,,34,,,,28,24,84,190,223,70,218,85,114,72,215,89,,201,
     70,243,,193,206,195,180,192,222,44,39,35,33,44,39,33,225,242,192,210,
     228,202,224,212,52,,,,,,,61,63,103,306,,,,99,,114,196,271,274,114,35,30 
    ],[,,,,76,,,,,98,,110,,,,219,,,135,,,221,,,,,176,92,,116,,,,,76,76,165,
     50,89,123,178,49,194,93,98,52,212,108,,203,70,197,,561,516,,383,,420,,
     183,135,122,,153,135,313,,171,252,231,170,,,,61,,,,,,,,166,,,,,,,168,,,,52,
     ,,,,82,114],[],[,,,,46,,,,,59,,,357,135,,279,112,,148,,,,30,116,43,,
     29,31,,36,116,,30,,36,36,,29,93,,359,100,282,108,198,86,,112,,265,149,
     340,,225,239,237,220,241,238,46,37,40,37,49,40,41,259,279,232,252,
     281,234,,259,48,164,52,,,,,52,,116,334,112,,,,,127,,,302,,40,,,,34,35],
   [,38,,54,33,,,,,38,99,107,206,,,,108,,,,204,,,176,50,29,36,,,29,,,36,,34,
     34,28,24,86,184,202,66,263,83,96,69,198,88,,213,72,235,,192,218,195,
     179,198,204,,40,33,33,47,41,37,229,,194,215,226,205,234,204,,102,73,,,,
     ,,,,250,,,,101,,119,212,,265,72,37,29,,,,24,,,34]],
 [,[],[],[],[,15],[,,20],[,,,25],[,,20,,,20],[,,,22,29,,25],
   [,,,25,,,22,,25],[30],[,57,,,71,,,78,105],[,,,,,,,110],
   [30,45,48,72,45,54,72,54,72,72,15,26],[,,84,,,,150,71,,,,36,58],
   [,,112,222,167,,170,96,240,312,43,43,49],[,,,167,,,150,,,174,,24,,26],
   [,,102,,155,136,178,112,280,288,,,35,,86,47],
   [,57,70,115,71,89,106,,,92,26,31,49,,24,,36],[],[],
   [,161,112,242,155,174,200,116,268,262,43,,53,,,35,86,51],
   [20,,,,,,,,,42,60,,,60,,220,,,91],[,,,,,,,37,,,,,,63,80,,80,145,,,,147],
   [,27,,,30,,,,34,,,96,,87,138,189,,399,98,,,233],
   [20,27,32,34,27,32,34,32,34,34,57,61,165,45,,,,191,61,,,191,20,25,27],
   [,53,58,60,53,58,58,58,60,62,118,110,280,,100,,218,,114,,,492,34,40,43]
    ,[20,,,,,,,,46,,60,,,60,98,170,,172,92,,,182,20,,,20,35],
   [,,,,,,,35,,,,,,69,,173,,175,119,,,181,,25,,25,39],
   [,30,,,27,,,201,40,34,,98,,87,142,229,,233,105,,,233,,,30,27,41],
   [,,,,,34,,,,,,103,173,69,75,121,90,131,,,,135,,25,,25,39,,25],
   [,27,,34,30,,39,,,42,,99,232,87,,249,,233,99,,,399,,,27,27,42,35,,30],
   [],[,30,364,39,27,,34,,41,,,,357,87,142,219,155,303,98,,,229,,,30,27,
     42,,,27,,30],[10,,,,,,,,48,42,15,,,15,24,,27,39,24,,,37,20,,,18,34,20,
     ,,79,,,33],[10,15,20,24,15,20,24,20,24,24,15,,45,15,,,30,,30,,,45,
     20,25,29,15,,20,25,29,25,29,,29,5],
   [10,,,,,,,,48,42,15,,,15,24,,27,39,24,,,37,20,,,18,34,20,,,79,,,33,5,5],
   [10,15,20,22,15,20,22,20,22,22,15,28,45,15,,45,,,28,,,,20,25,27,15,28,
     20,25,27,25,27,,27,5,5,5],
   [30,,,,,,,,,,27,,,30,39,68,36,93,40,,,70,60,,,52,98,60,,,82,98,,101,28,
     29,28,29],[,,,,,,,,46,55,,,,96,182,216,182,256,,,,256,,,,54,102,,,,,68,
     ,85,,34,,32],[,,,,,,,127,593,,,,,86,144,79,,59,,,,100,,138,,,527,,147,,
     149,,,,,60,,74],[30,39,44,46,39,44,46,44,46,46,30,38,64,27,,,41,,35,
     ,,,54,59,61,35,,54,59,61,59,61,,61,26,20,26,20,30,32,80],
   [,,127,433,,139,454,160,,,86,,76,,,,144,100,,,,59,257,153,308,,,,153,416,
     150,534,,344,53,,53,74,80,,70],
   [30,,,,,,,,132,,27,,,27,37,61,,63,39,,,63,60,,,52,100,60,,,86,100,,103,23,
     24,23,24,27,,,27,54],
   [,,,,,,,,57,46,,,,96,,216,194,236,179,,,240,,,,54,102,,,,,93,,68,,34,,32,,
     35,,32],[30,39,44,46,39,44,46,44,46,46,27,35,95,30,41,62,,,38,,,
     70,54,59,61,35,,54,59,61,59,61,,61,26,20,26,20,27,32,,20,,27,32],
   [],[30,,52,134,71,,123,,,135,30,,68,27,37,91,,78,,,,99,60,,109,52,102,
     60,86,97,,,,104,28,29,28,29,30,,89,27,,27,,30],
   [,,,46,74,,57,,,53,,,,96,,220,192,226,,,,236,,,68,54,102,,,91,,,,92,,34,,
     32,,32,,32,,,35,32],
   [,173,132,312,249,133,,,,,86,69,73,,,56,125,77,,,,57,228,148,251,193,,
     200,139,323,129,,,284,51,60,51,61,80,,68,,51,52],
   [,,,,,,46,,55,,,,,96,192,224,,248,194,,,252,162,,,54,102,,,68,,90,,,,34,,32,
     ,35,,32,,,32,32,,,35],
   [,,114,,,126,363,128,,,,,54,,,102,,58,74,,,101,,165,,,,333,147,,143,265,,,
     52,,52,72,,,51,,92,53,,,,89,,85],
   [,,121,,,127,305,123,,353,,71,77,,,53,,77,,,,,252,149,,,,202,152,,149,440,,
     268,53,,53,60,,,69,,50,53,,64,,,,49,,85],
   [70,,,,,,,288,,317,105,,,105,189,279,189,303,,,,303,140,,,119,224,140,,,,226,
     ,229,35,35,35,35,195,,,168,,166,,168,,195,592,,1192,516,498],
   [70,105,140,160,105,140,160,140,160,160,105,189,,105,,,192,293,,,,321,140,
     175,195,105,,140,175,195,175,195,,195,35,35,35,35,195,230,487,140,,
     166,230,140,,195,230,485,230,505,465,35],
   [70,,,,,,,,319,,105,,,105,186,255,182,273,182,,,269,140,,,119,228,140,,,394,
     232,,242,35,35,35,35,191,,,164,441,160,,164,,191,,359,764,,356,35,35],
   [70,105,140,158,105,140,158,140,158,158,105,198,,105,194,,,,204,,,303,140,
     175,193,105,222,140,175,193,175,193,,193,35,35,35,35,195,228,671,140,,
     166,228,140,,195,228,473,228,571,,35,35,35],
   [70,,214,,143,,230,,,,105,194,281,105,,309,,349,,,,349,140,603,,117,242,140,
     ,221,,,,248,35,35,35,35,195,593,611,164,873,166,,164,,195,,,,581,507,
     35,35,35,35],[70,105,140,160,105,140,160,140,160,160,105,,239,105,
     180,245,177,259,181,,,,140,175,195,105,,140,175,195,175,195,,195,35,35,
     35,35,193,230,356,140,355,158,230,140,,193,230,377,230,378,,35,35,35,
     35,35],[38,,,,,,,104,50,60,112,,,114,134,292,137,302,135,,,322,34,,,
     37,50,37,,,,41,,,36,38,36,34,106,,,88,338,108,,86,,102,99,319,149,321,
     312,248,250,246,246,244,250],
   [40,51,56,58,51,56,58,56,58,58,111,107,263,75,,,,247,107,,,247,37,42,
     44,25,,37,42,44,42,44,,44,34,25,34,25,96,98,,65,,96,98,65,,96,98,
     263,98,512,400,217,175,217,175,211,175,37],
   [40,,,,,,,,61,51,112,,,114,142,262,142,280,141,,,280,37,,,37,50,34,,,136,
     48,,41,36,38,36,34,108,,,88,,104,,86,,108,,268,99,338,290,248,250,246,
     246,244,250,37,37],
   [38,44,48,51,43,49,50,49,50,51,94,93,238,72,93,214,,,93,,,252,34,39,
     41,25,42,34,39,41,39,41,,41,29,24,29,22,82,84,265,62,,83,85,60,,84,
     85,237,85,283,339,186,160,188,158,184,160,34,25,34],
   [38,,104,51,50,,61,,,64,112,,,114,134,298,150,324,,,,352,34,,41,37,52,37,
     139,47,,,,47,36,38,36,34,106,98,377,88,,108,,86,,102,,,136,352,442,
     248,250,246,246,244,250,34,37,37,34],
   [40,51,56,58,51,56,58,56,58,58,111,107,237,75,,185,142,,107,,,,37,42,
     44,25,38,37,42,44,42,44,,44,34,25,34,25,96,98,307,65,273,96,98,65,,
     96,98,,98,267,,217,175,217,175,211,175,37,25,37,25,37],
   [40,49,,60,,114,50,128,61,,112,,282,114,,332,142,302,133,,,304,37,139,46,
     37,52,34,,41,165,47,,,36,38,36,34,108,,348,88,355,104,99,86,,108,136,
     295,,,303,248,250,246,246,244,250,37,37,34,34,37,37],
   [90,,,,,,,136,,297,39,,,45,67,63,77,57,66,,,71,168,,,143,264,160,,,,256,,,
     41,43,41,43,75,,,78,101,65,,75,,78,,96,,96,,285,285,277,285,285,281,
     292,249,284,218,292,245,292],
   [90,129,118,192,129,122,188,122,192,192,45,66,61,39,,,66,,79,,,57,168,
     159,231,129,,160,153,231,153,223,,231,41,43,41,43,78,218,97,75,,65,
     224,78,,75,224,89,218,101,89,285,285,277,285,285,281,294,207,286,192,
     294,203,294,45],[86,,,,,,,98,247,271,39,,,39,62,59,62,57,,,,57,140,,,
     121,244,128,,,151,225,,219,31,33,31,33,65,,,65,,50,,65,,65,,95,356,,
     86,227,227,215,227,227,211,234,211,222,188,238,195,230,39,39],
   [90,121,126,190,129,114,186,120,190,190,39,79,55,45,66,67,,,68,,,63,168,
     161,221,129,266,160,165,229,159,229,,221,41,43,41,43,75,220,91,78,,
     65,228,75,,78,214,97,222,96,95,285,285,277,285,285,281,290,207,282,
     190,290,203,290,39,45,39],
   [90,,132,,168,,320,,,,45,75,61,39,79,59,73,63,,,,57,168,198,,143,262,160,
     245,263,,,,270,41,43,41,43,78,521,97,75,99,65,,78,,75,,,461,,89,285,
     285,277,285,285,281,288,249,280,222,288,245,288,45,39,39,45],
   [86,109,86,158,95,88,144,90,162,164,39,57,55,39,58,,58,61,57,,,,140,
     117,191,107,251,128,115,173,115,191,,185,31,33,31,33,65,176,90,65,96,
     50,178,65,,65,156,89,176,98,,227,227,215,227,227,211,238,169,226,160,
     242,153,234,39,39,29,39,39],
   [90,,124,,159,,251,,276,,39,,55,45,63,65,85,57,63,,,63,168,,,141,270,160,
     ,257,210,260,,,41,43,41,43,75,,91,78,107,65,510,75,,78,379,115,,,95,
     285,285,277,285,285,281,290,243,282,216,290,239,290,39,45,39,39,45,39 
    ],[90,129,116,188,129,122,184,114,188,188,45,63,67,39,75,57,63,63,79,
     ,,,168,163,227,129,265,160,151,227,165,219,,227,41,43,41,43,78,210,,
     75,95,65,220,78,,75,220,89,220,108,,285,285,277,285,285,281,286,207,
     278,188,286,203,286,45,39,39,45,39,39,45],
   [,,,,,,,,,,,,,45,57,153,,,97,,,,,,,15,29,,,,,,,,,15,,15,,,,45,,,,45,,71,,,,,
     153,,105,,105,,105,,30,,27,,30,,,129,,125,169,113,,129],
   [,,,,,,,,,,,,,54,,172,93,158,,,,,,,,40,90,,,,,,,,,20,,20,,,,20,,,,20,,,,,,,,,
     140,,140,,140,,80,,70,104,80,128,,114,,122,,102,,114],
   [,,,,,,,,,,,,,72,,280,120,252,,,,,,,,25,38,,,,,,,,,24,,22,,,,72,250,,,70,,135,
     ,235,,,,,160,,158,246,160,,25,,22,,25,,,192,,190,,164,290,188],
   [,,,,,,,,,,,103,,45,66,161,57,171,99,,,145,34,,64,15,34,,47,63,,,,,,15,,
     15,66,,220,45,187,,,45,,,,232,,,190,168,105,,105,,105,54,30,52,26,62,
     30,49,184,129,156,129,199,91,,129,15],
   [,,,,,,,,,,52,,112,54,,96,72,106,71,,,132,,,,40,104,,,,,,,,38,20,38,20,48,
     58,191,20,,50,,20,,,,171,55,,,234,140,,140,,140,118,80,,70,126,80,114,
     126,114,98,122,,90,,122,,20],
   [,,,,,,,,,,,,,72,95,248,,,,,,264,48,,,25,29,46,,,,83,,68,,24,,22,,,,72,,132,
     ,70,,,,267,,,,249,160,313,158,,160,59,25,57,25,61,25,61,277,192,267,
     190,,162,,188,29,,25],
   [,,,,,,,,,,,68,,48,72,112,,102,74,,,112,,,,40,,,,,,,,,,20,,20,50,,131,20,
     142,52,52,20,,52,54,136,56,121,,,140,,140,214,140,104,80,,72,,80,,,118,
     ,126,132,86,124,116,,20,,,20],
   [,,,,,,,,,,,145,402,72,107,166,112,174,,,,176,,,,25,37,,,,,,,,48,24,48,22,,,
     232,72,249,,,70,,123,,207,,222,,,160,313,158,344,160,50,25,50,22,50,
     25,50,,188,,186,320,144,320,184,,,22,,,25],
   [,,,,,,,,,,,,,72,,240,106,,,,,224,48,,80,25,26,,58,77,,,,,42,24,42,22,,,,
     72,400,,,70,,134,,,,306,218,253,160,,158,268,160,63,25,,25,,25,60,283,
     192,,190,,158,274,188,,,25,,,22,,25],
   [,,,,,,,69,,,,,,,42,59,,,45,,,77,,,,,,,,,,135,,,,30,,30,,,,,,,,,,31,,,,,49,,192,
     ,193,,176,,118,,90,137,131,131,,76,,80,76,69,79,79,55,,,69,79,98,,
     107,99],[,,,,,,,114,,,,,,47,63,67,,,63,,,,,,,169,334,,,,184,421,,430,,,,
     45,,,,78,,,,91,,,364,127,,,143,,277,,291,,243,,263,,242,,233,292,,47,,,,
     35,,51,,86,,,114],[30,,,,,52,,,,,15,38,51,15,38,51,38,,38,,,,60,,121,
     57,118,60,,,,,,,15,15,15,15,30,168,78,30,78,24,,30,,30,174,,174,91,
     91,105,105,105,105,105,105,112,111,112,94,112,111,112,45,45,33,45,45,
     33,45,45,,,,,,,,,,26,43],[],
   [,,,,,106,,144,,,43,,,47,134,43,92,69,140,,,,,,,189,,186,192,,,,,541,39,,39,
     ,70,349,140,78,,72,,70,,,376,62,407,,62,291,307,,315,,261,306,297,276,
     273,342,255,,71,47,47,73,,47,,47,,,,,98,,,439,,,47],[],[],
   [,69,,99,55,79,107,,98,,26,42,80,,24,136,,85,26,,,97,104,121,97,61,112,
     ,105,95,,102,,96,27,27,27,30,39,101,90,29,122,29,116,38,,31,102,125,
     119,76,,191,,177,195,189,176,136,107,137,92,136,107,131,66,76,49,,76,
     47,63,79,,69,,,,,,,,31,49],[],
   [,,,,,98,439,,,,,,,47,,77,,,94,,,69,,,518,189,370,186,,,187,,,,37,45,37,,,
     659,,78,168,,447,,,,,156,,,,287,293,269,,357,261,,297,276,273,,255,,57,
     45,33,59,45,35,57,47,,144,,,106,,,,,,35,43,,51],
   [,,,,,114,,86,,,43,56,69,47,,33,,77,107,,,43,,,363,169,,,200,327,,,,,39,
     41,39,45,66,306,83,78,49,,377,62,,,431,45,,,49,295,281,253,283,311,
     243,290,263,,242,,233,292,63,45,45,61,45,47,61,51,,114,,,,,,,,49,51,,,
     35,,,,,47],[,,,,,,,,,,,,,69,129,169,,,,,,189,,,,47,95,,,,,85,,76,,25,,25,,
     ,,25,,,,25,,,,,,,,,175,,175,,175,,91,,78,173,91,115,,155,,161,257,117,,
     155,,,,,34,,36,,,,,109,,244,,,78],
   [,,,,,,,,,77,,,,87,97,211,116,259,134,,,249,,,,30,43,,,,,,,49,,29,,27,,,,81,
     400,,,79,,110,,209,183,242,222,,195,,193,220,195,,30,,27,,30,,,231,,225,
     260,189,,227,27,,,30,190,39,,34,39,95,,129,,354,,,,,393,276],
   [20,,,,,,48,96,,48,60,91,184,60,,200,,,,,,,20,124,43,20,43,20,,29,112,,,
     29,20,20,20,20,60,,257,54,,60,118,54,,60,,346,,227,,140,140,140,140,
     140,140,37,37,38,29,37,37,38,168,168,140,168,168,140,168,168,,96,48,,,
     ,,48,,89,188,60,,,,,89,,,188],
   [,,,,53,,,,,58,,75,191,69,,141,,131,75,,,143,,,,47,93,120,,74,,,,74,,25,,
     25,82,41,,25,191,80,34,25,,86,42,173,34,269,191,418,175,394,175,343,
     175,159,91,118,77,,91,114,186,155,152,159,,115,210,165,,34,,,,,34,,,
     105,186,,,,,,78,,,412,25],
   [,,,,55,,83,,,,,140,,87,100,231,98,243,136,,,233,34,74,57,30,34,,70,40,,
     51,,44,,29,,27,99,,256,81,259,,,79,,,,263,,,243,234,195,236,193,,195,
     46,30,40,30,47,30,40,268,231,211,229,284,169,,227,30,236,39,27,,,356,
     41,34,102,259,,,,,,146,,381,462,,30],
   [20,15,40,25,15,40,25,40,25,25,57,64,165,45,61,173,61,,,,,,20,47,30,
     20,31,20,47,30,47,30,,30,18,15,18,15,52,35,147,25,147,52,35,25,,52,
     35,145,35,147,141,119,105,119,105,117,105,37,30,37,27,37,30,37,143,
     129,121,129,143,107,141,129,27,32,34,27,32,34,32,34,34,61,169,57,,
     189,,,,,189,169,25,27,20,25,27],[],
   [,,,,53,,,,,,,75,204,63,,135,,143,75,,,131,,,,47,95,93,,74,,,,,79,25,79,25,
     ,41,191,25,,87,34,25,,86,,231,34,,197,418,175,,175,418,175,,91,110,
     77,139,91,111,,157,152,159,209,117,,155,,34,,,34,,,,,125,,,,,,,143,,,,25,,
     ,25,,25],[,,,,65,,68,,,,,,262,87,99,267,104,245,,,,297,,91,,30,43,,,
     59,93,,,57,33,29,33,27,98,,256,81,,,,79,,,,240,,261,272,220,195,227,
     193,,195,41,30,37,27,41,30,37,256,223,220,229,276,189,268,219,27,,34,
     30,236,41,,,39,96,423,,,353,,,126,,,304,,27,,,30,27],
   [,,,,65,,83,,,80,,,345,87,104,219,99,297,,,,245,,72,59,30,31,31,,40,74,,,,
     ,29,,27,101,,,81,256,102,,79,,102,,250,256,288,240,220,195,242,193,
     238,195,46,30,43,30,47,30,41,250,231,220,221,274,189,,227,30,,,27,,
     34,364,40,,106,387,,,380,,,126,,,,,30,,,27,27,,,30],[],
   [10,,40,42,25,,,,,42,15,38,49,15,,61,,,38,,,,20,76,36,18,34,20,,36,,,,,
     5,5,5,5,28,144,96,26,96,26,,26,,28,,,,96,,35,35,35,35,35,35,36,34,
     36,29,36,34,36,41,41,37,41,41,37,41,41,25,,42,,,,40,,42,32,61,15,,,,
     ,32,,,61,76,36,20,,,18]],
 [,[],[],[],[],[],[,44,,52],[,,,,,38],[],[,,,52],
   [30,,,,,,,48],[,85,,,,,152,57],[,,,,,,,86],[30,,,157,,,,,,,15,20,25],
   [,,,,,,176,155,,,20,25,30],[338,167,,352,,234,189,120,,,25,30,35],
   [,,,,,,,64,,208,,20,,20,25,30],[,,,,,,,86,,,,,25,25,30,35],
   [,,,170,,109,,,,,20,25,30,,20,,25,30],
   [,152,,,,,,70,,,25,30,35,,,25,30,35],
   [,,,,,,461,86,,,,,25,25,30,35,,25,30,35],
   [,,,,,274,261,78,,,25,30,35,,,25,30,35,,25,35],
   [20,,,,,122,46,,,44,60,,,60,,200,,,,,162],
   [,,,,,73,,61,,,,,,94,97,156,,,99,161,,161],
   [,31,,,,,61,,,60,,111,,,140,173,130,,116,182,339,183],
   [20,,,38,,,,,,,57,75,155,53,,,,151,69,157,161,159,20,78],
   [46,,,,,,,102,,,103,103,142,,95,,,124,96,,149,293,29,,35],
   [20,32,,40,,,,84,,,60,77,100,60,77,100,77,100,77,100,100,100,20,,30,20,
     29],[,,,,,,,83,,,,189,,,,,,,,,,,,76],
   [46,48,,54,,,,168,,44,,107,190,132,122,187,115,200,110,186,230,204,29,,
     40,31,35],[],[,,,40,,201,59,,,56,119,105,187,,,,,172,,,162,,,,30,28,
     34,29,,39],[,,,74,,140,79,,,,101,100,169,137,100,201,107,152,97,176,
     183,168,29,112,,,24,29,118,34,,35],[],
   [10,,,,,,38,38,,40,15,,,15,,,,,25,35,33,,20,,,18,26,20,79,,,32,26],
   [10,21,,34,,36,38,30,,34,15,,33,15,,,23,,24,33,31,31,20,51,31,17,,20,
     65,31,,30,,,5],[10,,,60,,,,,,60,15,20,25,15,20,25,20,25,20,25,25,
     25,20,165,32,19,28,20,,,,35,28,,5,5],
   [10,,,,,,38,38,,40,15,,,15,,,,,25,35,33,,20,,,18,26,20,79,,,32,26,,5,5,5 
    ],[30,,,,,58,142,48,,,25,,,30,37,42,,,37,42,,42,60,,,54,85,60,123,92,,
     100,84,,28,27,25,28],[],
   [,,,,,,,102,,,,,,35,42,47,,,42,47,39,47,,136,,,137,117,,211,,179,174,,,46,
     30],[30,69,,84,,,108,,,,30,37,42,25,,,37,42,43,,42,,54,88,85,45,,54,
     136,75,,82,108,,26,22,24,26,30,,35],
   [272,164,,,,279,248,150,,,35,42,47,,,,42,47,,41,47,39,239,165,182,,,117,,
     204,,,196,,54,,30,54,35,,40],
   [30,85,,128,,,,48,,158,25,32,37,25,32,37,32,37,32,37,37,37,60,88,95,
     54,84,60,,,,96,90,,23,22,20,23,25,,30,25,30],
   [,,,168,,,,,,148,,275,,,,,271,,313,,,,142,,196,,218,,,,,176,250,,,96],
   [30,,,,,64,140,48,,,25,,,30,37,42,,,37,42,105,42,54,,,45,66,54,137,78,,
     82,66,,26,22,24,26,25,,,24,35,25],
   [,,,,,197,270,102,,,,,,35,42,47,,,42,47,40,47,,145,,214,154,117,315,211,,
     172,197,,,46,30,,,,30,35,40,30],
   [30,109,,,,,,,,,30,37,42,25,,,37,42,,,42,,60,88,110,54,,60,,94,,,88,,28,
     27,25,28,30,,35,25,,25,,30,35],
   [,,,88,,,140,,,136,,,,,274,,211,,,,,,,,114,102,197,110,,140,,,156,,114,68,,
     114,,,,,,,142,114],
   [,161,,474,,,283,,,,35,42,47,,,42,42,47,,,47,42,,164,193,224,,117,,216,,,
     176,,60,45,30,60,35,,40,,30,30,,35,40],
   [,148,,160,,,156,,,,,353,,,281,,322,,251,,,,148,,187,,,,,152,,187,,,,92,,,,,,,,
     ,,114,,,142],[,,,,,279,282,102,,,,,,35,42,47,,39,42,47,,47,,,,,146,117,
     ,214,,179,179,,51,,30,51,,,30,35,40,30,,,30,35,,40],
   [,,,531,,,,101,,,35,42,47,,,39,42,47,,41,47,,237,163,,,,117,,207,,,196,,
     54,44,30,54,35,,40,,30,30,,35,40,,,30,,40],
   [70,,,,,332,,312,,420,105,,,105,167,229,,,,235,237,229,140,,,125,195,140,
     998,224,,223,193,,35,35,35,35,189,,,174,,154,1254,174,,189,884,349,
     1471,345,329],[70,,,249,,310,318,,,,105,166,,105,,,173,227,167,233,225,
     229,140,380,234,121,,140,,223,,223,202,,35,35,35,35,189,,331,166,,154,
     1311,166,,189,,361,1151,,336,35],
   [70,,,286,,,,,,353,105,140,175,105,140,175,140,175,140,175,175,175,140,626,
     ,125,193,140,,,,220,195,,35,35,35,35,175,,210,160,210,140,,160,210,
     175,866,210,1847,210,210,35,35],
   [70,,,,,306,308,260,,418,105,,,105,171,,,,172,233,257,237,140,,,123,176,
     140,725,214,,208,176,,35,35,35,35,187,,,168,352,156,1502,168,,187,762,
     410,1264,394,,35,35,35],
   [70,,,,,364,,,,,105,,,105,173,237,,,,,,233,140,1107,249,125,197,140,,224,,,
     197,,35,35,35,35,189,,323,174,345,154,1686,174,335,189,,,1686,352,352,
     35,35,35,35],[70,,,,,402,325,,,325,105,140,175,105,140,175,140,175,
     140,175,175,175,140,,,123,,140,705,231,,,,,35,35,35,35,175,,210,158,
     210,140,1162,158,210,175,704,210,1243,210,210,35,35,35,35,35],
   [34,,,,,162,68,132,,63,110,,,112,125,223,,,121,,228,,32,,,37,44,37,186,46,
     ,41,46,,33,36,34,33,98,,,94,235,104,201,86,,100,143,226,195,243,239,
     236,244,236,228,238,244],
   [40,59,,64,,156,82,,,82,111,132,231,99,,,,223,127,231,235,233,37,112,46,
     31,,37,,46,,45,38,,34,31,37,34,102,,,87,,102,242,87,280,102,172,295,
     242,296,296,235,223,235,229,235,229,37],
   [40,52,,57,,,,134,,55,110,119,178,112,126,174,119,174,120,178,167,174,37,
     166,46,37,44,32,,,,46,46,,33,36,34,33,106,,182,94,182,98,,86,187,106,
     155,184,183,185,189,236,244,236,228,238,244,37,37],
   [34,,,,,136,67,108,,59,92,,,92,99,191,,,,195,194,191,32,,,31,38,32,123,42,
     ,,38,,26,26,28,26,81,,,80,,82,185,66,,82,181,202,203,199,182,186,186,
     186,176,188,190,32,31,32],
   [34,50,,51,,194,,,,63,110,126,,112,126,265,125,261,,,258,281,32,,41,37,
     51,37,,51,,,44,,33,36,34,33,98,,294,94,349,104,291,86,271,100,,,195,
     264,366,236,244,236,228,238,244,32,37,37,32],
   [40,,,76,,142,,118,,70,111,124,173,99,123,161,123,161,123,173,173,161,37,
     119,,31,38,37,134,51,,46,,,34,31,37,34,102,,184,87,185,102,,87,184,
     102,184,186,226,185,185,235,223,235,229,235,229,37,31,37,31,37],
   [40,52,,57,,160,62,142,,,110,137,230,112,,,127,230,125,228,,,37,,46,37,
     47,32,,41,,47,44,,33,36,34,33,106,,241,94,233,98,185,86,324,106,161,
     261,,,246,236,244,236,228,238,244,37,37,32,32,37,37],
   [90,,,,,118,325,124,,359,35,,,45,54,59,,,54,59,,59,164,,,153,220,140,,250,
     ,250,221,,41,39,35,41,65,,,76,81,57,976,65,,76,323,81,,91,81,273,
     273,245,269,273,245,264,263,236,214,260,235,264],
   [90,216,,286,,156,385,146,,,45,54,59,35,,,54,59,,57,59,55,164,218,264,
     149,,140,274,250,,223,232,,41,39,35,41,76,,81,65,,57,,76,81,65,,,438,
     81,,273,273,245,269,273,245,272,251,244,214,268,223,272,45],
   [86,188,,274,,,,86,,344,35,44,49,35,44,49,44,49,44,49,49,49,132,158,
     199,119,172,100,,,,193,150,,31,29,25,31,59,,64,59,64,40,,59,64,59,,
     64,333,64,64,203,203,175,207,203,175,200,201,172,166,208,173,200,35,
     35],[90,,,,,122,324,124,,,35,,,45,54,59,,,54,59,53,59,164,,,151,204,
     140,398,237,,238,204,,41,39,35,41,65,,,76,81,57,,65,,76,,81,590,85,
     81,273,273,245,269,273,245,256,257,228,204,252,229,256,35,45,35],
   [90,251,,336,,,,,,,45,54,59,35,,59,54,59,,,59,59,164,221,273,153,,140,
     384,253,,,225,,41,39,35,41,76,,81,65,,57,,76,81,65,,,,81,,273,273,245,
     269,273,245,266,263,238,216,262,235,266,45,35,35,45],
   [86,,,290,,,,86,,338,35,44,49,35,44,49,44,49,44,49,49,49,132,160,,117,
     186,100,,191,,200,,,31,29,25,31,59,,64,59,64,40,,59,64,59,,64,,64,64,
     203,203,175,207,203,175,206,195,178,172,214,167,206,35,35,25,35,35],
   [90,237,,330,,122,426,124,,,35,,,45,54,59,,53,54,59,,59,164,,238,153,223,
     140,,256,,255,223,,41,39,35,41,65,,92,76,81,57,954,65,85,76,345,81,,,
     81,273,273,245,269,273,245,262,263,234,216,258,235,262,35,45,35,35,
     45,35],[90,,,270,,,372,120,,,45,54,59,35,72,55,54,59,,57,59,,164,218,
     ,149,,140,,245,,,210,,41,39,35,41,76,,81,65,,57,712,76,81,65,,,,81,,
     273,273,245,269,273,245,258,251,230,204,254,223,258,45,35,35,45,35,
     35,45],[],[,,,,,,,,,,,,,,130,274,,,,,,234,,,,,,,,,,,,,,36,,,,,,,,,,,,,,,,,,,
     296,320,,460,322,,150,186,,164,184,166,,132,84],
   [,,,,,,,,,,,,,165,,576,,,200,,,,,,,52,,,,,,,66,,,34,60,,,,,116,309,124,,,,,,403,
     ,,,,243,,,344,276,,52,,,,52,,,291,274,,,290,333,270],
   [,,,,,,,,,,,97,227,,78,147,82,151,99,202,,152,30,65,46,,30,30,98,47,,48,
     30,,25,20,,25,74,,157,66,157,,,69,156,75,,145,,156,157,197,157,180,,,
     163,48,42,49,28,54,43,48,233,184,160,193,231,,232,201,,,32],[],
   [,,,,,,,,,,,234,,,,,,,,,,,44,106,60,52,,46,164,59,,59,32,,38,38,,38,142,,,,,
     158,,,455,,,,,,,319,,353,322,,364,63,52,63,43,79,43,78,364,,346,,,342,,,,
     ,52],[],[],[,,,,,,,,,,,,,,,,197,,,,,,46,98,,,32,44,,67,,63,,,40,34,
     60,40,,,754,,,166,,,,,,,,,,320,,,338,,,68,43,65,43,63,52,63,360,373,346,
     354,,342,396,,,,52],
   [,,,,,191,,64,,,,,,25,32,37,,,32,37,,37,,,,,98,77,,154,,124,,,,23,20,,,,,
     25,30,20,,,,25,,30,,,30,,171,140,,,140,,136,121,,,123,121,,67,50,,67,50,
     ,67,,,,92],[,,,,,74,442,86,,,,,,35,44,49,,,44,49,,49,,,,,185,100,,163,
     ,227,,,,,25,,,,,64,69,45,,,,64,228,69,,,69,,237,175,,227,175,,,178,,,
     173,236,,35,25,,35,25,,35,,78,,240],
   [30,,,,,52,,,,,15,25,35,15,25,35,25,35,25,35,35,35,60,,130,57,106,60,
     120,,,133,,,15,15,15,15,30,,40,30,40,20,202,30,40,30,154,40,202,40,
     40,105,105,105,105,105,105,110,111,110,92,110,111,110,45,45,25,45,45,
     25,45,45,,52,,,,,,,,20,25],
   [,108,,204,,70,206,,,,20,32,44,25,20,55,32,44,20,55,44,55,93,,121,,106,
     77,126,,,119,,,26,24,20,26,37,,49,25,62,25,178,37,49,25,149,62,180,
     49,62,175,167,140,,167,140,124,135,120,90,167,122,124,54,67,30,54,67,
     30,54,67,,63,129,,,,,,,25,30],
   [,161,,,,94,,,,,25,37,49,35,55,25,37,49,55,25,49,25,160,,168,,172,100,
     202,,,188,,,,,25,,42,,54,64,30,30,314,42,54,64,244,30,304,54,30,229,
     231,175,255,,175,228,235,162,191,256,173,,59,35,35,59,35,35,59,35,,94,
     ,,,,,,,30,35],[,85,,,,,152,57,,,,,,25,32,37,,,32,37,,37,93,156,111,,
     101,77,,109,,103,102,,27,24,20,27,,,58,25,30,20,,39,,25,,30,,,30,166,
     173,140,167,173,140,127,129,119,93,,124,125,72,67,50,,67,50,86,67,,,,,,
     ,,,,20,,20,25,30],
   [,,,,,,464,86,,,,,,35,44,49,,,44,49,,49,192,,,149,156,100,490,171,,215,128,
     ,35,33,25,35,,,,64,69,45,358,,,64,,69,316,,69,229,241,175,,245,175,
     225,227,173,188,263,167,227,55,35,25,53,35,25,,35,,80,,,,,,,,,25,25,
     30,35],[,,,121,,63,,,,,20,32,44,25,20,55,32,44,20,55,44,55,,146,116,
     ,102,77,118,111,,110,,,24,24,20,24,37,,49,25,62,25,197,37,49,25,147,
     62,199,49,62,165,,140,176,168,140,122,,126,94,,124,124,54,67,30,54,
     67,30,54,67,,70,,,,321,,,,25,30,,20,,25,30],
   [,169,,494,,94,189,78,,,25,37,49,35,55,25,37,49,55,25,49,25,,355,182,,
     202,100,194,,,191,,,33,31,25,33,42,,54,64,30,30,313,42,54,64,227,30,
     309,54,30,231,229,175,241,241,175,,,174,191,251,161,,59,35,35,59,35,
     35,59,35,,94,386,,,,,,,30,35,,,25,30,35],
   [,,,,,76,,86,,,,,,35,44,49,,,44,49,,49,162,,,,183,100,,208,,187,151,,,31,
     25,,,,,64,69,45,345,105,,64,,69,,,69,231,225,175,237,231,175,232,,167,
     202,,173,,53,35,25,53,35,25,,35,,,,139,,,,,,,25,25,30,35,,25,30,35],
   [,,,,,94,,70,,,25,37,49,35,55,25,37,49,55,25,49,25,,,,,181,100,201,266,,
     240,,,37,33,25,37,42,,54,64,30,30,305,42,54,64,249,30,303,54,30,229,
     233,175,243,221,175,212,,178,,226,173,228,59,35,35,59,35,35,59,35,,94,
     ,,,,,,,30,35,,,25,30,35,,25,35],
   [,,,,,,110,,,98,,,,,,375,,,,,,,,,,83,,86,,110,,161,148,,,51,165,,,,,76,,,112,,,
     ,,,114,,,,385,626,,701,,,153,128,,228,,130,,210,,,224,,,233,,,,,,,,,,,,101,
     99,163,254,408,99,156,147,161],
   [,,,,,232,74,,,57,,,,134,112,187,,,121,175,,157,,,,39,51,34,143,44,,,53,,,
     31,,,,,,100,164,93,237,,,106,,167,187,,166,,225,218,,222,230,,39,34,,,
     43,34,,251,192,,258,212,,243,,,,42,,64,,,69,111,,139,108,154,,397,117,
     180,336,174],[20,,,,,,44,104,,46,60,92,166,60,95,170,,174,,156,,186,
     20,90,36,20,36,20,111,29,,35,35,,20,20,20,20,60,,,54,,60,148,54,238,
     60,,297,142,237,,140,140,140,140,140,140,37,37,34,28,37,37,34,164,
     164,132,164,164,132,164,164,,,40,,,,,,,90,168,60,,,,,95,186,,156,,29],
   [,,,,,,166,,,,120,118,198,,,197,117,198,,,200,,,,212,,,112,,170,,,228,,79,65,
     ,79,110,,203,76,165,110,,65,195,,106,195,126,201,212,707,692,724,884,
     2174,762,245,,171,152,,219,205,278,,195,281,,195,282,649,,99,,,,,,,,118,
     200,,,,118,199,,169,202,,76],
   [46,,,,,,57,,,69,133,123,187,,106,196,107,174,121,194,244,183,29,108,43,
     39,29,29,156,34,,46,28,,32,30,35,32,92,,194,100,202,,199,81,191,94,,
     196,236,195,192,226,224,220,214,233,229,45,39,39,36,50,36,39,256,250,
     168,241,263,,254,247,,204,50,29,,,,,46,108,167,,,,125,155,,346,179,324,,
     39],[20,,,52,,88,52,82,,,57,,183,53,,163,,,,,,,20,115,40,20,27,20,,40,
     ,,27,,18,17,19,18,54,,146,45,,54,,47,149,54,152,,152,153,199,125,121,
     125,123,125,123,37,36,37,29,37,36,37,153,149,119,151,153,117,153,149,,
     ,54,29,,,,,,69,159,57,69,151,,,,159,161,157,78,31,20,,28],
   [46,44,,66,,,44,140,,32,,103,,145,96,133,101,,,147,,176,29,126,51,29,38,
     34,193,29,,47,36,,26,,28,26,85,,206,62,144,84,112,66,,86,114,147,94,,
     148,197,203,194,176,202,218,46,41,34,33,,41,33,195,231,171,176,223,
     186,,207,,,63,50,,72,,,74,,490,101,99,145,103,,,,,148,112,34,29,118,35]
    ,[],[],[,,,,,,64,136,,59,,,257,,109,171,113,,124,162,,158,29,115,40,
     ,28,29,,34,,42,29,,32,31,,32,91,,448,,170,104,251,,,96,,177,181,300,
     181,224,,223,211,234,229,46,38,41,38,45,43,41,224,265,196,,254,206,,
     243,,,56,29,,44,,,,112,,124,125,183,,,,,,160,,43,,,29,28,35],
   [,,,66,,145,32,,,,104,,144,,99,,95,173,,,147,,,,50,29,36,,,28,,,34,,26,32,
     28,26,85,,143,66,,85,98,70,143,85,,269,114,146,300,,220,193,176,193,
     206,44,39,33,33,44,39,34,223,,172,204,194,186,222,178,,,,,,73,,,,99,
     180,104,94,176,98,202,107,163,181,180,114,34,,,34,,24,,,34],
   [10,24,,48,,,,,,48,15,27,39,15,,33,,,,,39,,20,97,35,18,33,20,,35,,,34,,
     5,5,5,5,28,,,26,51,23,,26,52,28,,53,124,54,,35,35,35,35,35,35,36,
     34,36,29,36,34,36,41,41,31,41,41,31,41,41,,38,48,,,,,,48,26,33,15,,,
     24,,27,39,,,97,35,20,,,18,34],
   [10,,,42,,38,48,,,,15,24,33,15,27,39,24,37,,,,39,20,76,36,18,38,20,79,
     35,,40,,,5,5,5,5,28,,53,26,,23,124,26,,28,,58,,,54,35,35,35,35,35,
     35,36,34,36,29,36,34,36,41,41,31,41,41,31,41,41,,,42,,,48,,,,27,39,
     15,,37,,,,,39,,76,35,20,79,40,18,,,,33,,5]],
 [,[],[],[],[],[],[],[,,,,,10],[],[],[],[],[],
   [,,,,,36,,36],[,,,,,,,27],[,,,,,58,,49],[,,,,,,,24,,,,,,19,19,29],
   [,,,,,,,38,,,,,,29,43,39],[,,,,,33,,,,,,,,,21,,18,29],
   [,,,,,,,38,,,,,,,,33,31,66],[,,,,,,,44,,,,,,,33,,,,33,69],
   [,,,,,52,,38,,,,,,,,27,25,36,,30],[],[],[],
   [,,,,,10,,10,,,,,,17,,,,49,21,49,80,49],
   [,,,,,12,,12,,,,,,,23,,33,34,25,60,,64],[],
   [,,,,,,,9,,,,,,26,,44,27,,27,,,42,,,,8,9],[],
   [,,,,,9,,,,,,,,26,22,34,21,33,,,39,36,,,,8,9,,8],[],
   [,,,,,12,,12,,,,,,28,24,50,30,44,25,52,98,46,,,,,9,,9,,9],[],[],
   [,,,,,56,,55,,,,,,90,,,99,,218,389,349,184,,,,35,,,42,,42],
   [,,,,,,,112,,,,,,162,153,252,,403,145,238,246,232,,,,152,114,,,,106],
   [,,,,,,,48,,,,,,90,,192,,,,,422,,,,,35,42,,42,,39,,42,,,33,114],[],[],
   [],[,,,,,26,,26,,,,,,16,,,19,27,20,52,,,,,,17,,,21,,21,,28,,,86,144,86],
   [,,,,,40,,54,,,,,,,,,27,38,,30,,26,,,,,,,35,,34,,57,,,,231,175],
   [,,,,,,,24,,,,,,22,20,32,19,,21,32,28,28,,,,20,24,,,,21,,24,,,131,136,122,,
     ,,19,28],[],[,,,,,22,,22,,,,,,17,17,27,,,17,28,48,24,,,,17,22,,19,,
     19,,22,,,84,,74,,,,17,27,16],
   [,,,,,43,,43,,,,,,46,32,56,,,32,43,38,40,,,,,79,,36,,36,,,,,243,235,,,,,46,
     41,31],[,,,,,24,,,,,,,,22,19,58,17,26,,,30,48,,,,20,24,,21,,,,24,,,
     144,132,122,,,,19,,18,,16,31],[],
   [,,,,,43,,,,,,,,,,30,32,39,,,,29,,,,49,,,36,,33,,50,,,229,241,193,,,,,31,31,
     ,29,70],[],[,,,,,43,,43,,,,,,27,32,54,,30,31,57,,,,,,,36,,36,,36,,
     74,,,,223,209,,,,27,,30,,,,30,,56],
   [,,,,,41,,43,,,,,,,,30,28,37,,31,,,,,,,,,36,,39,,56,,,200,234,194,,,,,29,29,
     ,27,38,,,32],[],
   [,,,,,71,,70,,,,,,122,,,131,226,190,340,414,252,,,,49,,,55,,,,61,,,230,699,
     224,,,,118,,154,,112,,173,,265,,262,250],
   [,,,,,,,,,,,,,196,179,294,,386,181,298,290,287,,,,,140,,,,96,,140,,,1250,866,
     469,,,,178,281,164,,176,276,165,,294,,274,287,,100],
   [,,,,,68,,64,,,,,,122,151,,,,174,340,,210,,,,49,58,,55,,53,,58,,,228,,210,,,
     ,118,229,,,102,,144,,267,,293,,,45,126],
   [,,,,,108,,,,,,,,202,233,503,,359,,,429,362,,,,174,130,,,,,,206,,,644,1434,
     742,,,,193,408,169,,166,,169,,,,,,,100,172,126],
   [,,,,,62,,64,,,,,,114,138,198,123,192,135,228,315,194,,,,49,,,51,,51,,,,,
     230,699,224,,,,114,226,124,,108,479,124,,220,,,232,,45,100,45,100],
   [],[,,,,,10,,10,,,,,,17,,,,41,21,43,76,41,,,,7,,,8,,8,,8,,,35,142,35,,,,
     17,,20,,17,,20,,42,,93,55,,49,,49,160,49],[],
   [,,,,,8,,8,,,,,,16,17,34,,,17,36,,36,,,,7,8,,7,,7,,8,,,32,,30,,,,16,,16,,
     14,,16,,35,,,35,,44,84,42,,44,,7],[],
   [,,,,,10,,10,,,,,,17,23,29,23,29,21,35,39,29,,,,7,8,,8,,8,,,,,35,,35,,,,
     17,35,20,,17,,20,,35,,37,35,,49,160,49,160,49,,7,,7],[],[],
   [,,,,,65,,65,,,,,,40,,,49,57,52,61,80,47,,,,51,,,48,,48,,63,,,222,328,214,,
     ,,40,,45,,45,82,45,,55,,63,54,,292,406,286,433,270,,47,,42,,41],
   [,,,,,,,42,,,,,,52,46,62,43,,43,60,67,52,,,,45,52,,,,37,,42,,,,238,210,,,,
     44,53,34,,36,56,36,,61,,64,56,,276,290,268,310,222,,41,,34,,35,,,43],
   [,,,,,86,,54,,,,,,53,67,63,,,47,94,,56,,,,51,60,,,,47,,60,,,222,454,200,,,,
     49,60,68,,34,,42,,65,,62,61,,294,428,268,506,268,,47,,40,,41,,,49,66],
   [,,,,,,,,,,,,,52,52,57,51,88,,,76,50,,,,57,56,,50,,,,66,,,,326,288,,,,46,
     52,42,,46,65,42,,,,69,55,,410,408,354,408,300,,53,,44,,47,,,43,43,76],
   [,,,,,44,,42,,,,,,40,45,50,41,52,39,64,72,48,,,,39,49,,33,,35,,,,,168,
     244,166,,,,38,55,36,,36,,36,,58,,63,58,,216,296,216,327,196,,35,,32,,
     29,,,37,33,39,43],[,,,,,64,,60,,,,,,,85,,45,84,51,122,,,,,,106,,,,,53,,
     122,,,318,345,,,,,,,45,,38,60,46,,,,,,,392,427,598,877,416,,96,,,,51,,,,
     40,,79,44],[,,,,,60,,54,,,,,,40,48,51,45,54,49,58,,,,,,51,48,,46,,50,
     ,58,,,216,326,198,,,,40,48,42,,42,62,42,,55,,,,,288,392,266,392,262,,
     47,,40,,41,,,37,40,46,40,37],[],[],[],
   [,,,,,,,,,,,,,,,,17,36,22,48,44,28,,,,,,,10,,10,,,,,,98,40,,,,,29,,,16,35,20,
     ,38,,35,31,,,124,56,114,93,,,,8,,,,,,40,48,60,34,56,40],[],
   [,,,,,,,,,,,,,,,39,,33,,,,37,,,,,,,11,,11,,10,,,,,49,,,,,,25,,19,55,,,48,,39,,,
     ,146,67,,73,,,,9,,9,,,,49,51,,37,,51],[],
   [,,,,,,,,,,,,,18,21,30,,,22,40,50,28,,,,11,12,,,,,,12,,,46,110,,,,,18,30,,,,
     ,20,,32,,31,31,,62,114,,124,62,,9,,,,9,,,42,,,52,30,62,40,,,,10,,11],
   [,,,,,,,,,,,,,,,45,,45,31,,,45,,,,11,10,,11,,11,,,,,,111,49,,,,,53,29,,21,,
     29,,70,,,53,,71,,67,129,,,9,,9,,,,,47,45,53,59,,68,47,,,,,,11,,11],
   [],[],[],[,,,,,31,,31,,,,,,,,,23,45,22,55,68,50,,,,,,,25,,25,,,,,,282,
     128,,,,,47,21,,19,48,21,,54,,53,53,,,260,166,278,,,,,20,,,,,,35,57,67,
     33,80,62,,,,19,,,,,39],[],
   [,,,,,,,27,,,,,,26,,40,,,27,41,,38,,,,23,27,,,,24,,27,,,176,,174,,,,21,32,,,
     19,40,21,,34,,40,34,,200,,200,,267,,23,,19,,23,,,64,,,82,,61,62,,,,26,,,
     ,30,31,,,,25],[,,,,,,,42,,,,,,53,,67,,,43,,,60,,,,57,52,,,,37,,40,,,232,
     ,,,,,45,56,,,,,36,,63,,,64,,274,,288,510,236,,49,,44,,33,,,42,,50,44,
     30,56,40,,,,36,,51,,36,41,,,,36],
   [,,,,,27,,,,,,,,26,22,52,21,37,,,43,50,,,,23,27,,24,,,,27,,,166,269,148,,,,
     21,51,21,,19,40,,,49,,40,53,,,254,204,,227,,23,,19,,23,,,64,35,49,,33,
     55,62,,,,,,31,,30,,,,,25,,24,35],
   [,,,,,46,,,,,,,,53,53,32,33,57,,,115,30,,,,,62,,39,,,,,,,212,,224,,,,45,31,
     32,,31,60,,,,,92,33,,274,903,276,,240,,,,40,,33,,,44,46,69,,44,127,42,,,
     ,,,41,,42,51,,,,,,38,49],[],[],[],[],
   [,,,,,,,20,,,,,,,,,,44,,54,,42,,,,,,,13,,14,,,,,,108,62,,,,,,26,,26,52,30,,82,
     ,48,,,,130,86,130,144,,,,13,,,,,,52,66,66,54,66,68,,,,,,,,17,,,,,,,,70,
     37],[],[,,,,,,,22,,,,,,,,,29,57,36,61,59,47,,,,,,,14,,15,,15,,,,140,
     71,,,,,49,,,29,54,32,,56,,51,51,,,168,97,156,115,,,,14,,14,,,,60,75,83,
     51,83,67,,,,15,,,,18,18,,,,33,,40,59,46],
   [,,,,,,,,,,,,,30,,76,32,,,156,,,,,,12,13,,,,,,13,,,54,,52,,,,30,50,,,28,50,,,
     71,,48,50,,74,,72,134,74,,12,,11,,12,,,72,,74,,50,72,70,,,,15,,16,,15,
     16,,,,35,,,,,70,,,,,12,,13],
   [,,,,,,,24,,,,,,76,63,82,45,,,,,204,,,,17,18,,15,,21,,18,,,,,74,,,,40,67,,,
     38,65,44,,69,,61,69,,121,,102,,130,,17,,16,,17,,,106,,82,97,84,136,98,,
     ,,22,,23,,22,23,,,,51,,,,,86,,,,,16,,17],[],
   [,,,,,16,,,,,,,,28,28,58,,,,,42,54,,,,16,17,,,,17,,17,,,68,106,,,,,28,76,26,
     ,,43,,,54,,41,52,,92,130,,138,92,,14,,,,14,,,64,52,,66,50,66,60,,,,17,
     ,18,,,18,,,,42,,39,66,39,66,,,,,14,,15,12,16],
   [,,,,,,,22,,,,,,,36,53,,69,40,63,,51,,,,16,15,,14,,15,,,,,91,,71,,,,,53,35,
     ,31,,34,,,,,61,,113,164,97,160,,,14,,14,,,,,,56,71,82,,,71,,,,15,,18,,
     18,,,,,38,,,65,41,65,,,,,,,15,13,17,,15],
   [,,,,,16,,21,,,,,,,35,,37,86,43,144,,,,,,17,18,,16,,19,,18,,,102,156,74,,,,
     36,75,32,,34,56,37,,81,,52,,,128,,102,,120,,17,,16,,17,,,,73,94,83,74,,
     ,,,,22,,23,,22,23,,,,51,,50,154,49,98,,,,,16,,17,,14,,16,17],
   [,,,,,112,,,,,,,,,,,157,,164,,690,361,,,,,,,,,79,,,,,,,66,,,,,,139,,174,,178,,
     398,,471,,,,848,734,966,860,,,,114,,142,,,,258,,353,283,641,338,,,,,,,,88,
     136,,,,,,,,184,,,,,,108,,,118,203,,,130,213],
   [,,,,,,,59,,,,,,90,127,228,108,204,,,,188,,,,35,50,,,,42,,,,,34,,32,,,,86,
     237,,,84,,,,215,,214,204,,230,,228,667,230,,35,,32,,35,,,224,,228,354,
     166,379,216,,,,106,,57,,46,53,,,,,,,,178,,,,,,162,,93,54,,,68,92],
   [,,,,,,,128,,,,,,196,197,323,,,178,305,345,313,,,,,192,,131,,,,,,,92,,,,,,178,
     297,168,,,,174,,309,,273,307,,1311,1400,,,1278,,,,,,,,,426,298,,434,324,
     429,426,,,,130,,197,,,,,,,313,,271,,,,,,,,148,,187,,,,,,207,124]],
 [,[],[],[],[],[],[],[,,,,,17],[,,,,41,,53],[,,,,,,31,,67],
   [],[],[],[,,,,,25,37,25,,66],[,,,,,,44,25],[,,,,,35,38,25,,53],
   [,,,,33,,,25,,53,,,,10,11,12],[],[,,,,29,20,36,,,42,,,,,11,,11],
   [,,,,,,,23,,,,,,,,12,12],[],[,,,,,35,45,27,,79,,,,,,12,12,,,12],[],
   [],[],[,,,,40,35,,34,69,54,,,,27,,,,,29,46,,41],
   [,,,,,49,61,45,86,65,,,,,32,,57,,38,61,,55],
   [,,,,,,,40,,,,,,31,38,43,54,,38,43,,43,,,,45,36],
   [,,,,,,,28,,,,,,31,,41,43,,29,,,41,,,,27,31],
   [,,,,28,,,55,54,,,,,69,,96,46,,45,99,,,,,,35,56],
   [,,,,,29,,,,,,,,31,30,37,33,,,,,35,,,,27,33,,23],
   [,,,,59,55,47,,,55,,,,44,,57,,,41,,,66,,,,,41,39,,55],
   [,,,,46,37,51,37,78,73,,,,55,39,67,49,,34,61,,47,,,,,29,30,25,35,27,41]
    ,[,,,,40,,62,61,82,,,,,71,58,55,53,,51,68,,84,,,,35,47,,,37,,63,41],
   [],[,,,,212,118,,165,231,280,,,,70,,,58,,94,,,,,,,141,,239,,228,229,235,,
     335],[,,,,,,,105,,255,,,,40,49,54,,,49,54,,54,,,,199,179,117,,,201,200,
     146,300,,54],[,,,,160,156,169,134,,202,,,,91,,,,,88,105,,,,,,157,198,
     236,173,227,,225,180,,,,51],[],[],[],
   [,,,,,19,26,19,,27,,,,15,,,18,,18,23,,,,,,25,,29,25,50,27,33,53,39,,86,
     71,88],[,,,,,36,65,34,,77,,,,,,,19,,,19,,19,,,,,,56,42,,44,87,72,71,,,
     76,159],[,,,,,,,15,40,,,,,15,16,17,15,,16,17,,17,,,,25,35,23,,,25,36,
     31,48,,80,52,,,,,13,14],
   [,,,,,,,,55,38,,,,48,40,53,40,,48,,,60,,,,50,69,,,,,55,73,53,,238,,178,,,,
     31],[,,,,21,17,,19,30,31,,,,17,18,19,,,18,19,,19,,,,25,33,,27,34,27,
     41,33,35,,87,129,83,,,,15,16,12,31],[],
   [,,,,32,15,48,,,55,,,,15,18,23,18,,,,,23,,,,26,35,29,24,40,,,31,45,,103,
     71,103,,,,15,,13,,15],
   [,,,,35,,35,,,,,,,66,40,85,40,,,,,92,,,,48,61,44,,51,,,52,,,214,273,209,,,,
     31,,,93,31],[,,,,,36,65,,,79,,,,,,19,19,,,,,19,,,,46,,56,39,158,37,,
     58,81,,181,76,,,,,,16,14,,16],
   [,,,,,,30,,37,,,,,47,36,49,36,,38,,,59,,,,46,61,,,42,,47,69,,,195,217,171,,
     ,,27,,,35,27,,,49],[],
   [,,,,,36,65,34,,77,,,,,,19,19,,,19,,,,,,,,56,42,,42,83,72,75,,159,76,181,,,
     ,,16,14,,16,,,,16],[],[],
   [,,,,,,,,639,516,,,,56,67,74,78,,67,74,,74,,,,234,229,163,,,206,256,192,
     335,,361,210,385,,,,97,104,72,,,,97,274,104,321,,104],
   [,,,,272,150,227,,276,254,,,,,91,,,,99,,,147,,,,191,246,405,211,299,287,
     285,214,331,,439,364,505,,,,112,187,104,230,107,,130,269,217,219,,,,,63]
    ,[,,,,218,135,,,,,,,,79,,114,,,,,,147,,,,198,352,240,,297,,,241,360,,520,
     343,511,,,,122,193,101,489,110,,117,,,,,167,,,66,87],
   [,,,,128,105,176,113,225,266,,,,56,63,74,56,,63,74,,74,,,,167,,163,149,
     213,161,241,,293,,385,210,360,,,,91,102,70,368,84,,91,226,102,214,,102,,
     ,42,61,62],[],
   [,,,,65,59,91,56,98,92,,,,43,,,,,47,80,,61,,,,37,,64,45,52,44,62,41,60,,
     231,250,235,,,,41,,45,83,41,,44,77,73,76,,85,,,337,297,335,255],
   [,,,,,,,66,85,73,,,,60,54,69,71,,54,76,,69,,,,66,57,34,,,61,58,47,,,295,
     188,269,,,,49,74,34,,58,,49,63,74,62,,79,,,256,333,348,266,,62],
   [,,,,,47,58,45,77,73,,,,42,43,56,,,38,65,,51,,,,45,51,46,41,,40,60,43,
     60,,208,194,184,,,,40,,35,65,33,,35,63,62,61,,56,,,242,242,273,217,,
     41,41],[,,,,54,64,73,,,90,,,,,58,,50,,,,,88,,,,51,,65,59,52,,,55,61,,
     298,264,279,,,,,137,46,70,41,,41,,,62,,,,,331,347,339,297,,47,61,47],
   [,,,,56,49,61,48,78,84,,,,39,54,53,54,,43,74,,53,,,,45,45,41,37,46,38,
     54,,60,,219,186,219,,,,37,71,41,113,37,,40,91,71,80,,71,,,244,275,313,
     215,,35,41,35,47],
   [,,,,76,57,53,72,121,,,,,82,,82,58,,60,102,,99,,,,57,57,46,,68,67,87,53,,
     ,338,241,310,,,,50,81,41,68,47,,54,,79,,,85,,,322,,405,363,,53,43,41,
     69,47],[],[,,,,46,23,33,23,,54,,,,8,,,10,,14,10,,10,,,,27,,31,27,
     61,27,40,40,65,,66,40,85,,,,15,,13,41,15,,15,56,15,39,,15,,,56,,79,
     56,,43,52,38,,39,72],
   [,,,,,,,15,36,,,,,8,9,10,8,,9,10,,10,,,,24,33,23,,,24,36,29,,,50,30,,,,,
     13,14,10,,12,,13,,14,39,,14,,,42,63,,42,,42,37,33,41,38,,,8],[],
   [,,,,,,46,,,,,,,8,14,10,10,,,,,10,,,,30,37,31,31,,,,41,49,,68,40,66,,,,15,
     15,13,70,15,,15,,,45,,15,,,56,88,101,56,,52,49,41,56,48,56,,8,8],
   [,,,,17,13,25,15,33,44,,,,8,9,10,8,,9,10,,10,,,,21,32,23,19,31,21,34,,
     53,,,30,49,,,,13,14,10,33,12,,13,,14,,,14,,,42,,61,42,,33,40,30,44,
     29,62,,8,6,,8],[],
   [,,,,46,23,30,19,,37,,,,8,14,10,10,,14,10,,,,,,27,31,31,27,61,31,37,35,
     45,,65,40,,,,,15,15,13,38,15,,15,54,15,33,,,,,56,82,,56,,43,46,35,53,
     39,53,,8,8,,8,8],[],[],[],
   [,,,,,,,,,,,,,,,,28,,35,,,,,,,,,32,23,44,27,51,32,57,,,160,,,,,,,,,25,,29,,,,,,
     ,,210,,,,,,51,30,58,39,64,,,29,,,19],
   [,,,,,,,,,,,,,,,,21,,26,28,,24,,,,,58,,,,,,59,,,,112,125,,,,,,16,43,18,,20,
     43,31,38,,29,,,134,155,,,,,,57,79,98,,,,16,,28,16,,26],
   [,,,,,,,,,,,,,,,,,,,,,,,,,,,49,34,65,38,67,30,74,,,,339,,,,,,46,,34,,,,,,,,,,
     730,351,,254,,,72,41,74,37,81,,,42,,,34],
   [,,,,,,,,,,,,,22,21,28,,,26,28,,28,,,,42,168,,,53,,,58,68,,123,,,,,,18,33,
     16,43,,,20,43,33,38,,33,,,,,,143,,74,107,,,92,93,,22,16,,22,16,,22,,,,,
     21],[,,,,,,,,,,,,,42,53,54,,,48,90,,46,,,,,55,,,,,,45,,,272,248,,,,,42,
     56,,,,,42,,62,,,51,,,300,,406,,,37,51,,56,33,64,,38,,,54,30,,34,,,,29,,
     43],[],[],[],[,,,,,,,,,,,,,,,,11,,11,,,,,,,,,28,21,,,,28,49,,,35,55,
     ,,,,,12,33,16,,16,33,,28,,,,,49,,79,49,,,40,39,47,39,44,,,7,,,7],
   [,,,,,,32,19,,,,,,,,,12,,10,,,,,,,,,30,23,32,25,53,,45,,,42,,,,,,,13,32,17,,
     15,31,,27,,,,,58,116,108,56,,,43,44,54,37,60,,,8,,,8,,,,,,20,,,23,33],
   [,,,,,,,27,,,,,,,11,,13,,11,11,,11,,,,,34,36,29,,,,44,,,,47,,,,,,,14,43,18,,
     16,57,16,38,,16,,,65,101,,65,,,51,45,60,47,,,,9,,9,9,,9,,,,,20,,,57],
   [],[,,,,18,,,16,37,36,,,,10,11,12,,,11,12,,12,,,,27,30,,,30,23,34,26,
     45,,61,,53,,,,14,15,,,,,14,32,15,30,,15,,,,67,71,53,,41,,34,47,33,44,,
     9,,,9,7,,9,,,,23,18,41,24,32,,,,8,9,10],
   [,,,,19,15,25,,,,,,,,10,,12,,,,,,,,,27,33,30,23,32,,,29,41,,,42,101,,,,15,,
     13,32,17,,,28,,27,,,,,58,108,,56,,43,43,35,,37,47,,,8,,,8,,,,,,,20,,,44,
     ,,,,9,,,9],[,,,,,24,32,,,56,,,,10,11,11,13,,11,,,11,,,,,40,35,29,71,,
     39,,51,,77,47,88,,,,16,16,14,40,18,,,,,34,,16,,,65,105,,65,,,53,44,,
     43,64,,9,9,,,9,,9,,,,71,25,,32,45,,,,,,10,,10],
   [,,,,27,15,,17,,,,,,10,11,12,,,11,12,,12,,,,27,31,,22,39,23,37,26,,,54,
     42,,,,,15,16,,38,17,,15,,16,,,16,,,56,67,67,,,44,39,35,45,,,,9,7,,9,,,
     9,,,,23,17,,,,,,,8,9,10,,8,9,10],
   [,,,,,,,21,,,,,,10,11,11,13,,11,11,,,,,,35,,35,30,61,39,46,49,52,,84,47,
     77,,,,17,16,14,43,18,,16,57,16,38,,,,,65,91,95,65,,56,53,43,63,47,61,
     ,9,9,,9,9,,,,,,,,,,45,,,,,,10,,10,,10,10],
   [,,,,25,,26,,,,,,,30,28,40,28,,,,,40,,,,39,52,35,,43,,41,44,,,129,164,125,,
     ,,22,,,46,22,,,,,29,,,,,198,161,,138,,65,52,52,54,65,,,26,,,29,18,,26,,,
     ,,28,,28,,,,,21,21,29,,23,22,27,23,29],[],
   [,,,,39,,43,40,,95,,,,,,,,,,89,,,,,,,,28,40,33,42,45,45,40,,,207,288,,,,,,
     27,52,29,,29,,,46,,,,,,,258,199,,,40,38,52,52,47,,,27,,54,27,,,,,,,,,51,
     47,,,,32,,,,36,,59,,54],
   [,,,,,,30,,,39,,,,30,,,28,,29,,,34,,,,43,,41,,72,,,63,65,,141,,141,,,,22,,
     25,32,22,,31,36,42,27,,44,,,204,181,297,,,73,63,65,,75,90,,26,24,,,20,
     ,32,,,,,,,30,,,,,,,,,22,24,29,23,57,22],
   [,,,,,,51,53,,,,,,,,,44,,51,129,,,,,,,,31,43,36,49,49,30,47,,,182,293,,,,,,,
     71,38,,39,,,,,,,,240,341,,,,,43,41,56,37,54,,,34,,,34,,,,,,31,,,60,49,,,,
     ,33,,,34,44,95,35],
   [,,,,,,,,84,84,,,,,33,,33,,,,,,,,,46,61,,,,,99,57,99,,219,,,,,,27,,,,27,,,64,
     ,64,,,,,,,309,580,,76,,61,114,72,114,,,,,,25,,,,,,,38,,38,,,,,31,28,57,,,,
     ,28,55,26,,,30,74],
   [,,,,,,,141,93,,,,,,63,77,63,,,158,,,,,,79,105,,,,167,87,101,,,,,815,,,,47,
     157,,46,47,,123,89,157,,,161,,,,591,643,,,131,,105,113,127,,,63,,,128,,,,,
     ,,,72,270,72,,,,,55,54,63,,,78,68,56,63,46,,96,52],
   [,,,,25,,58,,,39,,,,28,28,36,,,29,44,,36,,,,49,54,,,45,,53,58,62,,146,,
     137,,,,22,46,25,32,22,,31,36,46,27,,46,,,,177,226,179,,77,87,58,58,
     75,91,,28,24,,32,20,,28,,,,,30,,,,,,,,27,,,27,30,35,,,22,,,24,,30,52],
   [,,,,53,56,58,,,87,,,,48,44,72,,,,,,66,,,,,58,50,,51,48,,54,112,,,,,,,,46,
     86,38,70,,,,,66,63,,70,,,282,,396,269,,45,40,,51,41,47,,44,38,,44,38,,
     40,,,,47,58,59,,,,,,,43,45,,42,,49,39,,,,38,,46,,130],[],
   [,,,,39,55,26,,45,,,,,,36,,36,,30,,,,,,,38,47,50,65,35,,47,43,,,,179,238,,,
     ,27,64,41,36,27,,,74,,29,,62,,,227,256,328,229,,56,44,47,56,52,,,,39,,
     ,33,,29,,,,,44,,44,,,,,34,29,34,,36,,30,30,34,29,,38,31,,,,31,49],
   [,,,,,154,,,355,,,,,,,,67,,74,,,105,,,,,,,,333,206,,205,,,,44,62,,,,,,,,86,,99,
     ,165,283,,,,,381,420,446,362,,,,206,301,277,303,,,50,,68,50,,85,,,,,,,
     156,617,,,,86,,,,,,75,53,102,214,,247,,,293,713,200,,,231],
   [,,,,,,,183,268,,,,,91,79,,59,,,,,,,,,147,257,,,,269,266,,288,,61,,72,,,,87,
     261,,,84,,131,214,184,229,,241,,,,541,690,348,,237,,210,352,223,357,,85,,
     ,92,51,,,,,,205,130,,122,395,,,,69,,116,,,,,58,101,136,,274,143,276,,,
     147,514,,,96],[,,,,,86,,95,,340,,,,40,49,54,,,49,54,,54,,,,149,171,
     117,167,167,,195,144,,,46,30,,,,,71,76,52,,,,71,223,76,271,,76,,,210,,
     334,210,,233,187,,224,185,240,,40,30,,40,30,,40,,,,136,,,,,,,,35,42,47,,
     39,42,47,40,47,136,,238,201,179,214,698,,,,177,,52],[]],
 [,[],[],[],[],[],[,18,,24],[,,,,,10],[],[,18,,24,,,18],
   [6,,,,,,,8],[,14,,,,,19,11],[,,,,,,56,18],[6,,,,,10,26,10,,,6],
   [,14,,,,,19,11,,,,5],[,,,,,20,44,16,,,,,14],
   [8,,,26,,,28,10,,26,,5,,7,5,13],[,45,,,,,40,18,,,,,12,16,,14],
   [8,,,25,,11,17,,,19,7,5,13,,5,,5,13],[,,,,,,,14,,,16,,14,,,12,13,14],
   [,,,,,,56,18,,,,,12,,,14,,12,13,14],
   [,,,,,20,50,14,,,,,14,,,12,13,14,,12,14],
   [12,,,,,22,24,,,24,12,,,12,,,15,,15,,40,40],[],
   [,17,,,,28,29,,,29,,22,,,22,,21,58,18,58,48,47],
   [12,,,,,15,,15,,26,11,,,10,,,,43,12,28,45,30,12],
   [,23,,,,22,37,22,,,,16,,,16,,21,46,17,40,52,46,,,18],
   [12,17,,22,,,,26,,,12,18,26,12,18,26,17,26,17,26,26,26,12,,16,12,16],
   [,,,,,,,17,,,,,,14,,28,17,,16,,,28,,,,12,16],[],
   [,,,,,17,,,,,13,14,29,14,14,22,14,29,,,29,24,,,,12,16,,14],
   [,,,22,,30,29,,,29,19,,45,21,,59,21,,18,,38,53,,,16,18,18,16],
   [30,25,,28,,22,,22,,37,26,17,44,22,17,40,21,34,17,36,34,32,18,,18,,14,
     16,16,,16,18],[30,23,,28,,,24,50,,,,25,49,21,25,46,22,56,20,46,,,18,
     ,22,18,22,,,,,22,22],
   [30,,,,,56,124,52,,142,30,,,30,,,31,84,31,80,78,80,60,,,54,,60,93,,108,
     93,85,103],[30,,,,,48,,48,,118,30,,,30,,,29,,31,,80,78,60,,,52,,60,,,
     86,,,98,28],[30,78,,142,,,,58,,132,30,25,64,30,25,64,25,64,25,64,
     64,64,60,,92,54,86,60,,,123,91,,105,28,28],
   [30,,,108,,,,48,,116,30,,80,30,,82,,,31,,,,60,,82,52,74,60,88,,,82,74,,
     28,28,28],[6,,,,,8,20,8,,,6,,,6,,,7,16,7,16,,,12,,,10,,12,12,,12,
     18,22,18,30,30,30,30],
   [,,,,,,25,,,29,,,,,,,21,39,,,,,,,,,,26,,,,26,32,35,,,,122],
   [,,,,,20,42,20,,,,,,,,,,14,15,16,15,17,,,,,,29,31,,31,39,37,,,,71,103],
   [6,,,,,8,20,8,,,6,,,6,,,7,16,7,16,,,12,,,10,,12,12,,12,18,22,18,30,30,
     30,30,6],[,,,,,18,54,20,,,,,,,,,15,16,,14,17,15,,,,,,29,26,,24,72,39,,
     ,,71,92,,,15],[6,15,,,,,,8,,,6,8,12,6,8,12,7,12,7,12,12,12,12,,
     17,11,16,12,,,13,17,16,21,30,30,30,30,6,,14,6,14],
   [,24,,29,,,,,,24,,22,,,22,,21,39,21,,,,30,,34,32,,,,,,32,37,32,177,120,,,,
     20],[6,11,,16,,8,16,8,,16,6,8,18,6,8,12,,,7,12,18,12,12,,16,10,
     14,12,12,,12,16,14,17,30,30,30,30,6,18,,6,14,6,18],
   [,,,,,20,42,20,,,,,15,,,17,,,15,16,15,17,47,,56,,,29,31,,31,38,38,62,91,
     108,71,,,,13,,15,14],
   [6,,,24,,8,24,,,24,6,8,12,6,8,18,7,12,,,12,18,12,,19,11,16,12,13,,,,
     16,19,30,30,30,30,6,,14,6,,6,,6,14],
   [,,,24,,,25,,,29,,,,,,,21,39,,,,,,,28,,40,26,,,,,34,35,175,130,171,122,,16,,
     ,,,20,18],[,,,,,18,54,,,,,,17,,,15,15,16,,,17,15,47,,68,28,,29,25,,
     23,,35,,123,95,71,95,,,15,,13,14,,14,15],
   [,24,,29,,,20,,,,,25,,,25,,21,39,19,,,,30,,34,32,,,,,,32,37,,,128,133,,,20,
     ,,,,16,18,,,20],[,,,,,20,42,20,,,,,15,,,17,,14,15,16,,,,,,,,29,31,,31,
     39,43,,90,,71,105,,,13,,15,14,,,13,14,,15],
   [,,,,,18,54,16,,,,,17,,,15,15,16,,14,,,,,,,,29,26,,26,72,39,,120,91,71,98,
     ,,15,,13,14,,14,15,,,13,,15],
   [42,,,,,66,,68,,164,42,,,42,,,39,102,,102,102,102,84,,,74,,84,138,,113,
     123,111,135,195,195,189,195,42,,,42,,42,169,42,115,42,169,126,211,117,
     128],[42,,,,,64,147,,,144,42,,,42,,,39,100,41,102,108,112,84,,,72,,84,
     104,,104,129,119,132,195,195,189,195,42,,,42,,42,154,42,,42,152,115,
     160,149,117,38],[42,,,160,,,,,,194,42,35,88,42,35,88,35,88,35,88,88,
     88,84,,,74,111,84,,,121,123,112,139,193,191,175,193,42,163,97,42,97,
     42,,42,97,42,165,97,199,97,97,38,38],
   [42,91,,,,66,,64,,134,42,41,,42,41,,,,39,,108,100,84,,114,72,102,84,,,
     111,114,102,135,195,195,187,195,42,152,132,42,117,42,,42,,42,144,121,
     146,,,38,38,38],[42,,,,,66,158,,,195,42,44,100,42,44,102,,,,,104,108,
     84,,125,74,113,84,,,,,112,134,195,195,189,195,42,170,121,42,130,42,
     212,42,115,42,,,210,118,,38,38,38,38],
   [42,79,,129,,56,131,56,,130,42,35,84,42,35,84,35,84,35,84,84,84,84,,
     126,70,,84,84,,84,126,,131,191,193,175,191,42,122,91,42,91,42,122,42,
     91,42,122,91,122,91,91,38,38,35,38,38],
   [22,,,,,37,33,31,,35,23,,,23,,,23,,23,,61,61,20,,,22,,22,36,,,24,26,28,
     106,108,106,104,21,,,21,,22,40,20,67,20,38,67,42,71,71,146,148,146,
     144,144,148],[24,,,,,29,37,29,,43,21,,,18,,,,57,22,48,59,46,22,,,18,,
     22,23,,23,26,22,28,102,96,102,96,18,,,18,,21,48,18,104,21,48,46,51,
     83,62,138,132,138,132,138,126,22],
   [24,28,,33,,,,37,,30,21,25,43,23,25,41,21,41,23,43,38,40,22,,26,22,26,
     18,,,36,26,26,24,98,106,98,90,21,38,41,21,41,18,,18,42,20,38,41,36,
     42,42,134,142,134,126,134,140,22,22],
   [22,26,,31,,22,,22,,,19,19,49,17,19,39,,,17,38,56,38,20,,24,18,22,18,
     19,,19,24,22,,81,82,81,74,17,40,,17,,16,40,14,,16,40,37,,65,38,109,
     110,109,102,110,108,20,18,18],
   [22,,,31,,35,33,,,39,23,24,,23,24,49,23,49,,,49,55,20,,24,22,26,22,34,,,
     ,29,29,106,108,106,104,21,36,49,21,66,22,38,20,49,20,,,42,49,66,
     146,148,146,144,144,148,20,22,22,20],
   [24,35,,37,,29,37,29,,46,21,26,45,18,26,36,23,45,22,42,45,36,22,,26,
     18,22,22,23,,23,29,,29,102,96,102,96,18,42,46,18,41,21,42,18,46,21,
     48,41,48,46,41,138,132,138,132,138,126,22,18,22,18,22],
   [24,28,,33,,34,28,35,,,21,,53,23,,53,21,51,21,53,,,22,,26,22,26,18,,,
     32,26,26,,98,106,98,90,21,42,49,21,49,18,38,18,63,20,42,47,,,,134,
     142,134,126,134,140,22,22,18,18,22,22],
   [18,,,,,26,56,24,,60,16,,,18,,,15,22,17,24,22,24,34,,,29,,34,,,37,47,48,
     ,78,78,76,78,16,,,16,,16,70,16,27,18,46,29,,27,29,106,106,104,106,
     106,100,59,55,53,45,59,55,53],
   [18,,,,,22,56,22,,60,18,,,16,,,17,24,15,22,24,22,34,,,30,,34,30,,30,50,
     45,53,78,78,76,78,16,,,16,,16,76,18,29,16,76,27,,29,27,106,106,104,
     106,106,100,59,50,55,43,59,46,55,16],
   [14,33,,,,,,14,,,16,11,22,16,11,22,9,22,9,22,22,22,28,,36,24,34,20,,,
     22,35,26,40,57,55,35,53,14,34,27,14,27,10,,12,27,12,,27,34,27,27,
     71,71,49,69,71,49,42,40,32,32,38,34,36,15,15],
   [18,31,,50,,,44,24,,,16,16,22,18,16,24,,,17,,22,24,34,,44,29,42,34,52,,
     37,44,42,47,78,78,76,78,16,42,26,16,28,16,42,16,,18,40,30,42,26,
     28,106,106,104,106,106,100,57,55,50,42,57,55,50,14,16,15],
   [18,,,68,,,56,,,,18,16,24,16,16,22,17,,,,24,22,34,,49,32,40,34,33,,,,44,
     51,78,78,76,78,16,74,28,16,26,16,70,18,30,16,,,74,28,26,106,106,
     104,106,106,100,57,56,52,44,57,52,52,16,14,15,16],
   [14,25,,46,,12,26,14,,46,16,11,22,16,11,22,9,22,9,22,22,22,28,,34,22,
     36,20,18,,20,34,,37,55,57,35,51,14,32,25,14,25,10,30,12,25,12,26,
     25,32,25,25,69,71,49,71,71,49,44,34,34,30,40,28,38,15,15,7,15,15],
   [18,37,,64,,26,56,24,,,16,16,22,18,16,24,15,22,17,24,,,34,,47,29,42,34,
     ,,37,48,42,,78,78,76,78,16,,27,16,29,16,70,16,27,18,46,29,,,,106,
     106,104,106,106,100,57,55,52,42,57,55,52,14,16,15,14,16,15],
   [18,39,,64,,22,56,20,,,18,16,24,16,16,22,17,24,15,22,,,34,,47,30,36,
     34,30,,32,47,40,,78,78,76,78,16,,29,16,27,16,76,18,29,16,76,27,,,,
     106,106,104,106,106,100,57,50,50,40,57,46,50,16,14,15,16,14,15,16],
   [,,,,,,,,,,,,,,,,17,,,,,,,,,,,,,,,,18,,,,,,,,,,,15,,13,38,,,,,,,,,95,89,,79,,,25,,
     ,23,23,,,39,37,41,33,,35],
   [,,,,,,,,,,,,,,,,11,20,,,,,,,,,,20,,,,,30,35,,,48,,,,,,,,,10,,,,,,,,,,64,64,72,
     56,,,35,35,31,32,41,,,12,22,26,18],
   [,,,,,,,,,,,,,,,,19,,26,,,,,,,,,,,,,,30,,,,142,116,,,,,,,,18,58,24,,60,,,,,,,
     138,156,130,,,,18,,24,,,,,,,46,64,52],[],[],[],
   [,,,,,,,,,,,11,14,8,11,18,,16,10,18,14,18,,,,,30,26,,,,,,29,,48,,,8,24,
     15,8,19,8,24,10,17,8,24,19,24,15,19,,64,74,64,64,56,31,40,37,35,,
     32,35,,24,14,22,24,14,20,24,,10],
   [,,,,,,,,,,,27,64,20,27,40,19,48,28,56,64,36,,,,24,30,,,,,,,,146,112,141,,
     20,,46,20,38,,,18,45,24,,42,,45,37,168,144,185,136,186,131,31,21,30,
     18,31,21,28,72,48,,56,64,26,72,44,,,18],
   [,,,,,,,,,,,,,,,,25,,26,,,,24,,28,24,16,22,24,,20,30,18,33,144,118,128,108,
     ,,55,,60,,,18,,24,,,,55,60,156,158,,134,157,129,33,21,33,21,39,24,33,
     68,54,,58,60,46,64,52,18,,24,,,,,24],
   [,,,,,10,22,10,,,,,,,,,,,9,18,,,,,,,,15,15,,15,21,,,,,37,41,,,,,,8,,,,8,,17,,
     ,,,,51,54,,49,,,21,,25,22,21,,,21,21,22,19,22,24,12,,,,,,11,22,21],
   [,,,,,12,40,14,,,,,,,,,,,11,30,,,,,,,,20,,,21,41,30,41,,,42,,,,,,,10,54,14,,
     12,30,,,,,,,58,78,78,58,,,35,37,,31,41,,,9,,18,9,,,,12],
   [6,15,,,,8,,,,,6,5,14,6,5,14,5,14,5,14,14,14,12,,18,11,16,12,13,,,19,
     16,19,27,27,25,27,6,18,15,6,15,6,18,6,15,6,18,15,18,15,15,37,37,
     35,37,37,35,20,21,20,16,20,21,20,16,16,7,16,16,7,16,16,15,8,,,,,,,,
     7,8],[],[],[,12,,24,,,17,9,,,,,,8,,18,,,9,,,18,17,,18,13,19,15,,
     ,15,18,19,21,40,39,37,41,7,19,18,7,16,8,17,7,18,7,19,16,18,18,
     16,54,53,51,53,54,49,27,25,21,19,24,25,,21,22,21,,,19,21,22,,10,,,,,
     ,30,,8,,7],[,37,,,,18,28,14,,,,,,20,,30,,,11,,,30,,,46,33,36,20,36,,
     21,,24,50,62,70,42,56,16,27,,16,30,10,27,,,12,29,30,27,,30,78,86,
     58,80,98,58,45,47,33,40,41,31,39,19,17,9,19,17,8,19,17,,12,,,,,18,
     28,,,9,8],[,11,,17,,9,,,,,7,6,17,8,6,18,6,17,7,18,17,18,16,,18,
     13,19,,15,,,19,19,20,35,37,36,36,7,17,18,7,19,7,19,7,18,8,18,19,
     19,18,19,47,,,48,47,42,26,25,24,19,25,25,21,19,20,8,19,20,8,19,20,
     ,10,,,,,,,,8,9,,,,8,9],
   [,,,,,18,,18,,,16,15,22,20,15,14,13,24,17,16,22,14,,,50,,50,,29,,32,,,,
     99,91,,91,16,48,23,16,15,14,48,14,25,18,48,17,48,23,15,121,119,127,
     115,117,95,76,,60,50,56,47,66,24,16,15,26,18,15,24,16,,22,,,,,,,,17,
     18,,,,17,18],[,,,,,12,40,14,,,,,,,,,,,11,30,,,38,,38,31,42,20,23,,21,
     38,24,,86,62,42,,,54,,,,10,30,14,,12,,,54,,,84,78,58,82,78,58,53,41,
     30,38,41,31,,19,17,8,19,17,9,19,17,,18,,,,,,,,,9,8,,,,9,9,18],[],
   [,,,,,,20,,,24,,,,,,,16,28,,,,,,,,,,22,,,,24,29,31,,,109,86,,,,,,,16,14,,,,,
     16,,,,,133,,116,84,,,34,36,34,40,38,,,,32,51,18,,,,,,,,,17,,,,,13,,,13,
     20,14,35,21],[,,,,,27,28,,,30,,,,,,,18,59,23,45,49,40,,,,,,18,24,,,,
     28,24,,,,82,,,,,,17,36,16,58,19,,42,38,62,55,,,123,114,126,125,,,18,16,
     ,22,18,,,35,47,48,34,,44,17,,,,,,,22,29,19,,19,,,,48,,55,37],
   [12,,,,,,22,20,,22,12,16,28,12,16,30,,30,,28,,30,12,,18,12,18,12,22,,
     22,18,18,17,60,60,60,60,12,,29,12,,12,26,12,29,12,,42,26,29,,84,84,
     84,84,84,84,22,22,18,16,22,22,18,34,34,24,34,34,24,34,34,17,20,22,,
     ,,20,22,,15,26,12,,,,28,15,32,,,,16],[],[],
   [12,,,24,,26,24,,,,12,13,28,11,13,43,12,,,,28,,12,,,12,17,12,27,,,22,17,
     22,54,52,54,52,11,20,26,11,29,11,20,10,26,11,20,29,20,26,29,74,72,
     74,72,74,70,22,22,22,17,22,22,22,32,29,24,30,29,22,32,29,,15,26,,,,
     15,,,12,26,11,,,,,,41,26,,12,,12],
   [,18,,,,42,18,30,,16,18,16,40,26,16,46,17,,17,,40,72,,,28,17,22,18,,,
     29,,22,17,84,,84,74,16,24,35,16,41,16,16,14,35,16,24,41,16,35,41,
     112,119,111,102,112,128,26,23,18,18,26,23,18,40,48,34,36,42,36,40,
     42,25,22,28,,,,22,32,,17,38,16,,,15,,21,48,38,,16,18,16],
   [,,,,,,24,,,20,,14,25,13,14,29,,24,13,29,,29,,,,27,28,26,,,,26,55,27,
     108,80,124,88,13,21,24,13,31,13,18,14,26,13,21,31,18,24,31,113,108,,
     ,114,84,,45,36,36,34,40,34,33,37,22,32,37,20,,37,,17,,,,,,,,16,,,,,,
     24,17,,,,14,,,,,12,16],
   [,,,,,29,30,,,28,22,22,58,20,22,58,20,,,,39,48,,,,22,28,18,,,24,,,23,91,
     ,91,82,20,,40,20,56,17,36,16,39,,,42,34,39,46,123,129,123,114,133,
     126,24,21,18,16,24,21,18,51,48,36,47,47,34,49,44,,,22,,,,,,29,20,46,
     18,,,26,,22,,37,,,16,16,,,18,18],
   [30,,,,,,33,35,,35,,,59,22,,50,20,68,,44,,,18,,23,22,17,17,27,,31,24,18,
     22,106,98,,99,22,,51,22,44,21,51,18,,19,,,51,51,,136,132,138,133,135,
     131,27,21,23,21,29,22,23,56,52,47,53,51,45,,,23,50,28,,,,32,28,,21,
     53,18,,,,49,,,,,,22,,,,18,22,,22],
   [30,18,,30,,28,16,36,,18,18,19,32,,19,,17,36,15,78,32,,18,,28,17,24,
     18,34,,32,28,24,18,84,100,86,74,16,24,31,16,41,16,16,14,31,16,24,
     41,16,31,41,113,126,114,102,114,124,28,25,18,18,,,18,44,,30,40,42,
     30,44,42,23,22,34,,,,22,28,40,17,30,16,,,16,34,19,48,30,,16,18,16,,,
     ,14,16,18,23],[30,75,,124,,54,,,,144,30,,80,30,,84,30,,30,,80,82,60,
     ,91,54,84,60,,,89,,84,,28,28,27,29,30,177,91,30,123,30,175,30,90,30,
     ,120,139,91,,195,195,193,195,195,191,106,102,98,81,106,102,98,78,78,
     57,78,78,55,78,78,,50,122,,,,52,128,142,40,64,27,,,42,,35,91,62,,93,
     93,60,,,54,,88,,105,86],
   [30,66,,118,,48,,48,,115,30,36,80,30,36,80,31,82,31,,,82,60,,96,52,100,
     60,82,,,99,,98,28,29,28,29,30,120,108,30,95,30,130,30,,30,128,91,
     122,123,91,195,195,191,195,195,193,108,96,106,82,108,96,106,78,78,55,
     78,78,57,78,78,68,50,115,,,,50,,118,40,66,27,,,,,36,,70,,81,96,60,,,
     52,,81,97,98,,28],
   [30,101,,128,,52,141,52,,142,30,25,64,30,25,64,25,64,25,64,64,64,60,,
     95,54,84,60,110,,,92,85,,28,27,25,28,30,,71,30,71,30,171,30,71,30,
     133,71,171,71,71,189,189,175,187,189,175,106,102,98,81,106,102,98,76,
     76,35,76,76,35,76,76,,52,132,,,,,,142,37,42,25,,,37,42,39,,42,,90,92,
     60,,,54,83,,,102,85,28,28],[],
   [,,,,,,28,17,,,,,,,,,9,,9,,,,,,,,,26,20,,22,,25,42,,,35,55,,,,,,12,31,14,,
     14,30,,26,,,,,49,,75,49,,,37,35,43,36,42,,,7,,,7,,,,,,,,,17,35,,,,7,,,,
     8,8,17,8,,20,,28,,,27,53,22,40,,28,80,63,35]],
 [,[],[],[],[],[],[],[,,,,,10],[],[],[],[],[,,,,,,,44],
   [,,,,,36,,36],[,,,,,,,24],[,,,,,58,,49],[,,,,,,,27,,,,,,21,19,31],
   [,,,,,,,36,,,,,40,25,23,35],[,,,,,33,,,,,,,33,,18,,21,25],
   [,,,,,,,38,,,,,66,,,33,32,46],[,,,,,,,72,,,,,71,72,59,82,,,59,69],
   [,,,,,52,,38,,,,,,,,27,28,32,,30,68],[,,,,,20,,,,,,,,,,,35,48,35,,114,62],
   [,,,,,8,,8,,,,,,,15,,23,22,17,38,60,40],
   [,,,,,24,,,,,,,,,,,53,,42,93,162,74],
   [,,,,,10,,10,,,,,,17,,,,49,21,49,80,49],
   [,,,,,8,,8,,,,,,,15,,23,22,17,38,60,40,,6],
   [,,,,,,,20,,,,,50,36,32,54,,,29,52,74,44,12,,16],
   [,,,,,,,8,,,,,,24,,38,35,42,21,,,32,,6,,8,6],
   [,,,,,,,24,,,,,64,,,77,44,57,38,62,114,68,16,,20],
   [,,,,,8,,,,,,,32,24,17,30,21,26,,,52,28,,6,,8,6,,6],
   [,,,,,20,,,,,,,75,52,,108,,53,37,,90,74,,,16,,,16,,20],
   [,,,,,8,,8,,,,,32,20,16,34,19,26,17,32,50,28,14,6,18,,6,14,6,18,6,18]
    ,[,,,,,,,20,,,,,74,,,,57,,39,66,,70,16,,20,,,,,16,,20,18],
   [,,,,,131,,131,,,,,,,,,152,597,170,339,602,303,108,,,,,110,70,,98,144,66,
     159],[,,,,,54,,,,,,,,90,,,118,,,328,888,182,,,,35,,,34,,38,256],
   [,,,,,,,,,,,,287,196,187,308,,363,189,324,,300,142,118,211,152,118,140,,,,
     193,98,251,124],[,,,,,48,,54,,,,,,90,,198,,,156,300,564,,62,30,84,35,
     30,62,30,84,30,84,30,84,,33],[],[],
   [,,,,,38,,38,,,,,,,25,,,24,27,42,,41,,23,,,23,,27,63,27,89,30,,,,311,173],
   [,,,,,26,,26,,,,,,16,,,20,25,20,52,67,,,,,17,,32,20,,20,44,20,,,86,178,86 
    ],[,,,,,43,,56,,,,,,,,,32,37,,33,89,29,,,,,,49,33,67,32,110,35,,,,306,
     192],[,,,,,,,24,,,,,33,22,19,32,19,,21,32,,28,30,16,36,20,16,26,,,
     18,36,16,51,139,,168,114,,,26,19,31],[],
   [,,,,,22,,22,,,,,48,17,15,27,,,17,28,,24,30,14,40,17,14,30,16,36,16,40,
     14,40,174,84,,74,,,,17,29,16],[],
   [,,,,,24,,,,,,,30,22,17,58,19,24,,,54,48,30,16,51,20,16,28,18,34,,,16,
     38,178,,174,,,,26,19,,18,,16],[],
   [,,,,,40,,,,,,,,,,29,29,34,,,76,27,80,,115,49,,48,29,,27,,31,115,,237,297,
     180,,,37,,31,28,,27],[],
   [,,,,,43,,43,,,,,38,46,32,56,,33,32,43,,39,,31,,,31,48,32,73,32,67,36,,,,
     ,178,,,33,46,70,31,,,,31,,41],
   [,,,,,43,,43,,,,,,,,29,32,37,,33,89,,,,,,,50,33,69,44,111,35,,398,215,309,,
     ,,,,31,31,,29,,,,31,,70],
   [,,,,,104,,128,,,,,,,,,196,,,382,643,340,132,,,,,132,110,179,82,171,78,189,
     854,,1340,548,,,,,,169,,164,,176,,378,,402,446],
   [,,,,,71,,68,,,,,,122,,,152,240,,322,627,222,,,,49,,174,46,273,46,206,46,
     206,,230,1761,224,,,,118,,152,,112,,173,,239,,,283],[],
   [,,,,,,,66,,,,,360,122,116,,,,,354,620,210,86,42,116,49,42,86,42,116,42,
     116,42,116,,228,1060,210,,,211,118,242,152,,102,,146,,226,,236,,90,45],
   [,,,,,150,,,,,,,,,374,,,490,,,775,432,168,130,219,174,130,170,,211,,,110,
     274,1058,,2195,1380,,,571,,484,211,,206,,209,,,,415,670,126,156,,130],
   [,,,,,62,,64,,,,,282,114,127,198,130,182,135,230,449,192,144,,206,49,,174,
     46,249,48,,,206,824,230,,224,,,221,114,216,124,,108,,124,,228,,347,216,
     100,45,,45,156],[,,,,,26,,22,,,,,,,,,47,66,46,,116,85,19,,,,,23,20,27,
     ,23,20,27,153,,191,93,,,,,,40,,41,,40,,100,,69,100,187,,,127,225,167],
   [,,,,,10,,10,,,,,,17,,,,41,21,43,76,41,,,,7,,,8,,8,,8,,,35,142,35,,,,17,,
     20,,17,,20,,42,,93,55,,49,,49,160,49],
   [,,,,,,,26,,,,,68,45,41,73,,60,42,69,105,67,23,22,27,,22,19,,,20,27,20,
     23,153,126,187,93,,,,41,71,38,,41,,38,,66,,71,67,187,161,,127,229,161,
     21],[,,,,,10,,10,,,,,44,17,21,35,,,21,41,65,37,19,9,23,7,9,19,8,
     23,8,23,8,23,83,35,125,35,,,40,17,,20,,17,,20,,39,,46,50,101,49,,49,
     139,49,19,7,19],[,,,,,22,,,,,,,,47,43,95,48,72,,,111,75,19,,23,,,23,
     20,27,,,20,27,145,136,291,93,,,63,43,100,40,,39,,38,,,,70,84,179,159,,
     127,240,161,17,,21,19],
   [,,,,,10,,10,,,,,36,17,23,29,22,27,21,35,61,29,21,9,25,7,9,21,8,25,8,
     25,,25,83,35,125,35,,,35,17,34,20,,17,,20,,35,,63,34,97,49,,49,139,
     49,19,7,19,7,19],
   [,,,,,22,,22,,,,,80,,,,45,66,43,103,,85,23,22,27,,22,19,,23,20,27,20,,
     149,136,230,93,,,71,,,40,,41,,42,,74,,,100,179,167,,127,257,167,21,,17,
     19,21,19],[,,,,,62,,60,,,,,,,,,53,54,51,123,93,,66,,,,,66,,87,44,88,
     42,,449,,406,468,,,,,,42,,38,,46,,,,56,,565,,,380,749,390,94,,92,52,92,
     48,96],[,,,,,65,,65,,,,,,40,,,55,53,52,61,98,47,,,,51,,68,42,97,42,
     97,42,100,,222,426,214,,,,40,,45,,45,,45,,51,,63,55,,292,,282,545,270,,
     47,95,45,95,41,97],
   [,,,,,,,42,,,,,67,52,43,62,46,,43,60,97,52,52,34,64,45,34,48,,,32,69,
     28,68,258,199,298,204,,,53,44,61,34,,36,,36,,53,,56,61,312,250,,258,
     388,222,69,41,67,39,73,35,69,43,43],
   [,,,,,86,,54,,,,,102,53,47,63,,,47,98,,56,66,40,90,51,40,66,36,88,40,
     92,38,88,388,222,,200,,,51,49,65,,,34,,42,,59,,54,65,448,288,,266,728,
     268,95,47,93,45,97,41,97,70,49],
   [,,,,,,,,,,,,77,52,45,57,55,62,,,94,50,70,38,101,57,38,66,44,101,,,42,
     89,378,311,434,288,,,58,46,59,42,,46,,42,,,,63,59,416,328,,386,512,
     300,95,53,93,51,97,47,95,76,43,43,76],
   [,,,,,44,,42,,,,,72,40,41,50,45,44,39,64,137,48,54,36,,39,36,52,30,73,
     32,74,,76,256,168,324,162,,,59,38,58,36,,36,,36,,55,,60,58,304,218,,
     212,396,196,71,35,71,33,73,29,,44,37,33,39,43],
   [,,,,,90,,88,,,,,128,96,79,106,89,,77,94,,88,98,76,119,106,76,90,,130,
     64,116,64,,515,,954,556,,,,89,115,71,,,,70,,98,,,115,638,658,,812,854,
     611,137,96,130,81,129,77,125,81,92,66,,79,82],
   [,,,,,60,,54,,,,,78,40,39,51,52,50,49,58,94,,68,34,92,51,34,60,38,88,
     40,84,38,84,330,222,426,200,,,54,40,55,42,,42,,42,,48,,60,,406,286,,
     266,530,262,99,47,91,45,95,41,91,,37,40,46,40,37,78],
   [,,,,,,,,,,,,,,,,,,26,44,,36,,,,,,,,,,,10,,,,,40,,,,,,24,,20,,24,,37,,,,,,,56,,
     107,,,22,15,,17,22,,,36,40,52,,,44],[],
   [,,,,,,,,,,,,,,,,26,37,31,,,57,,,,,,,,,,,12,,,,197,49,,,,,,29,,21,,29,,53,,,70,
     ,,,67,178,71,,,,11,,11,,,,49,51,,33,102,51],[],[],[],[],
   [,,,,,,,,,,,,63,19,28,33,,29,27,51,,33,,,,11,,,,,,,12,,138,59,,49,,,42,19,
     38,,,21,,25,,39,,53,38,156,71,,67,,71,25,9,25,11,25,9,25,77,47,,49,
     65,33,,47,,,11],[,,,,,,,,,,,,,20,25,42,22,36,26,,,,17,8,24,11,8,17,
     8,24,8,24,10,24,108,46,130,66,,,,20,44,24,,,,24,,,,38,44,106,62,,74,
     146,62,25,9,25,9,25,11,25,56,44,40,50,52,32,80,44,10,,11,,,,,11],
   [,,,,,31,,31,,,,,,,,,,,26,41,,37,,,,,,40,24,57,24,54,28,,,,,116,,,,,,25,,,,
     25,,39,,,,,,,154,,,,,56,39,52,58,56,,,53,55,64,,,63,19,,,,,,,45,25],
   [],[],[],[],[,,,,,,,27,,,,,,26,25,40,,,27,,,38,35,19,43,23,19,39,,
     45,21,48,19,53,202,163,,157,,,36,21,34,25,,19,,21,,32,,40,34,240,197,
     ,188,296,,48,23,51,23,53,23,52,57,64,,,64,,,62,,,31,,,,,35,26,25],
   [,,,,,,,42,,,,,,53,47,67,,,43,,,60,60,36,123,57,36,64,30,93,32,105,28,
     113,,232,,208,,,,45,63,,,,,36,,58,,,63,,300,,268,666,232,102,49,106,41,
     114,33,98,56,42,,52,44,30,86,40,,,45,,,,,41,36],
   [,,,,,27,,,,,,,43,26,20,50,24,35,,50,73,50,42,19,45,23,19,39,21,43,,50,
     19,46,202,181,260,168,,,36,21,49,21,,19,,25,,51,,40,55,,,,196,327,265,
     51,23,52,23,52,23,53,55,64,35,49,64,33,85,62,26,,,,,,,35,,25,,,,,24,
     35],[,,,,,46,,,,,,,115,53,47,32,35,55,,,93,30,,48,84,,48,,36,,38,,,
     84,672,242,,212,,,62,45,33,32,,31,,,,39,,60,33,1147,282,,270,1014,242,,,
     ,43,131,33,,127,44,46,69,,44,105,42,40,,,,,,,45,48,39,,,,,38,49],
   [],[],[],[,,,,,22,,,,,,,,,,,37,61,40,63,199,57,,,,,,19,15,23,,,16,23,,
     ,,71,,,,,,34,,31,,35,,57,,67,79,,,,97,225,112,,,17,15,,15,17,,,56,69,
     80,,,71,15,,,,,,,18,18,33,,,,,,91,41,63],[],[],[],
   [,,,,,14,,14,,,,,,30,32,82,,,,,96,,12,11,20,12,11,12,11,20,11,20,10,20,,
     54,,52,,,46,30,,32,,28,,32,,50,,50,53,,74,,72,,74,21,12,21,11,21,11,
     21,74,72,56,68,70,54,,66,15,,16,,,,,16,15,35,,,,,,,,82,,,,13],
   [,,,,,,,20,,,,,,76,45,82,63,,53,74,,124,16,16,24,17,16,19,16,16,16,24,
     14,16,174,,,74,,,61,40,69,,,38,,36,,67,,69,65,204,121,,102,221,128,25,
     17,17,15,25,15,17,100,110,70,88,,78,,,22,,23,,,,,23,22,51,,,,,,,61,86,,
     ,,17],[],[,,,,,22,,,,,,,52,31,29,61,47,41,,,102,61,,17,,16,17,19,,
     23,15,,16,23,132,,206,71,,,43,30,65,32,,31,,,,55,,53,79,154,115,,97,
     213,115,22,14,19,15,22,13,19,79,71,60,73,76,54,130,67,15,,18,,,,,,
     18,41,,,,,44,73,43,69,,,,15,,,,13,17],
   [,,,,,,,16,,,,,56,30,34,50,30,,35,50,,,14,13,21,16,13,14,13,18,13,21,
     14,18,106,68,,134,,,,30,51,32,,,,28,,,,53,54,134,92,,125,172,92,22,14,
     19,13,22,15,19,66,64,50,,66,46,,60,17,,18,,,,,18,,36,,,,,,,37,62,,,,15,
     ,,,12,16,,15],[,,,,,21,,16,,,,,96,,37,,35,70,43,102,122,,16,16,24,
     17,16,19,16,16,16,24,14,16,156,102,250,74,,,65,36,73,37,,34,,34,,71,
     ,73,70,173,128,,102,,121,25,17,17,15,25,15,17,95,,67,94,93,66,148,
     90,22,,23,,,,,23,22,53,,,,,50,124,52,102,,,,17,,,,,14,,17,16],[],
   [,,,,,53,,59,,,,,349,90,124,210,120,192,,,,188,,40,,35,40,,34,,34,256,,,
     124,34,124,32,,,237,86,241,121,,84,,,,195,,,221,639,230,,228,1542,230,
     146,35,151,35,,35,,356,222,199,222,311,168,510,222,99,,59,,,,,55,46,
     206,,,,,,,170,,,,,92,,,,54,,,90,68],[],
   [,,,,,10,,10,,,,,,17,,,,41,21,43,76,41,,,,7,,,8,,8,,8,,,35,142,35,,,,17,,
     20,,17,,20,,42,,93,55,,49,,49,160,49,,7,,7,,7,,,47,41,47,53,35,96,47,
     ,,,,,,,9,9,,,,,,23,49,23,,,,,,,,,12,17,,14,14,17,,35],[],[]],
 [,[],[],[],[,,,59],[],[,21],[,,,,,19],[],[,32,,41,,,31],
   [16,,,,,,,21],[,16,,,,23,21,17],[,,,,64,,60,29],[,,,,,25,37,25,,66],
   [,,,,48,,53,31],[,16,,,,23,21,17,,,,6],
   [,,,67,90,,30,17,,,,6,,10,14,6],[,85,,76,,,45,28,,,,,13],
   [,,,66,71,29,37,,,71,,,,,12,,14],[,,,,38,,,15,,,8,6,14,,,6,6,14],
   [,,,,80,,60,33,,,,,13,,,,,13,,14],
   [24,16,,33,35,19,23,15,,33,8,6,14,,,6,6,14,,6,14],
   [32,,,,63,40,,,,46,32,,,,,,62,107,67,,68,32],[],
   [,27,,,,55,37,,,48,,27,,,,27,32,73,51,33,97,29],
   [,,,,77,34,44,37,,,,,,27,,,,67,35,25,73,25],
   [,,,,86,45,55,51,,74,,,,,35,,46,72,43,35,,35],
   [,31,,,,,,50,,,26,23,54,31,44,23,24,52,45,23,52,23,,,31,30,36],
   [,,,,,,,33,,,,29,,31,,29,28,,41,,,25,,,,27,33],
   [,,,80,51,,,53,,45,79,35,63,69,67,35,50,71,72,35,76,35,41,,,41,47],
   [,,,,,28,,,,,22,19,40,31,31,19,22,39,,,39,21,,,,25,31,,23],
   [,,,61,142,59,43,,,62,60,39,,44,,39,50,,45,,,41,,,35,33,39,43,,90],
   [52,58,,61,115,45,59,51,,59,43,35,63,55,42,35,50,52,47,31,57,27,38,,
     41,,35,51,33,41,33,51],
   [52,36,,54,77,,38,63,,,,30,,71,116,30,36,84,85,31,,32,34,,35,52,58,,,37,
     ,61,41],[160,,,,,134,311,,,,86,,,,,,52,152,,49,146,62,247,,,,,202,203,,
     212,283,245,281],[,,,,665,,224,,,233,,,,70,,,48,,105,62,143,47,,,,141,,
     202,231,280,213,255,,214],
   [,126,,,,,,139,,425,35,30,69,40,62,30,30,69,62,30,69,30,,,164,183,181,
     117,,,195,204,269,177,58,53],
   [,,,246,,,180,,,260,57,86,,91,,86,,,,53,198,,,,205,155,189,210,,,175,235,
     189,203,51,96,60],
   [16,,,,46,17,27,21,,,7,,,,,,8,17,,8,,8,28,,,,,26,23,39,21,53,37,30,80,,
     35,56],[,,,,57,,39,,,70,,,,,49,,34,63,,,,33,,,,,61,49,,79,,48,62,83,,,
     ,192],[,,,,58,33,47,31,,,,,,,,,,15,,16,16,16,,,,,,57,46,66,42,,65,,,,
     76,146],[,,,,42,19,25,19,,47,,,,15,,,16,30,19,15,,,,,,25,,29,27,39,
     25,33,53,52,,86,71,87],
   [16,,,,46,17,27,21,,,7,,,,,,8,17,,8,,8,28,,,,,26,23,39,21,53,37,30,80,,
     35,56,7],[,20,,,,,,15,,35,7,9,13,15,19,9,8,13,19,8,13,8,30,,28,
     24,33,23,,,20,36,29,28,57,59,35,59,7,,15,15,7],
   [,37,,53,,,,,,,,33,,48,51,33,32,59,47,,,31,80,,53,50,65,,,,,49,71,,,191,,
     180,,,,27],[,16,,36,40,15,21,15,,,7,9,19,17,21,9,,,21,8,19,8,48,,
     27,25,35,25,21,37,19,39,35,30,53,57,35,58,7,31,,15,7,7,29],
   [,,,,66,33,47,31,,,,,16,,,,,,,16,16,16,62,,79,,111,56,45,67,41,101,53,68,
     ,137,76,,,,14,,,15],
   [,,,60,50,19,37,,,,,17,,15,19,17,16,30,,,,15,50,,44,29,37,29,31,46,,,
     41,57,110,93,71,94,,,,13,,15,,15],
   [,,,44,59,,39,,,70,,,,66,55,,34,65,,,,33,,,51,53,,50,,79,,,81,,605,221,
     309,193,,35,,46,,,42,31],
   [16,,,40,38,17,27,,,32,7,9,13,,,9,8,13,,,13,8,28,,34,25,,26,22,38,20,,
     30,34,59,72,35,59,7,,15,,7,7,,7,15],
   [,41,,53,,,31,,,,,36,,47,52,36,34,65,47,,,33,78,,54,50,61,,,51,,52,60,,,
     204,234,182,,35,,30,,,35,31,,,55],
   [,,,,66,33,47,35,,,,,16,,,,,15,,16,,16,,,,,,57,46,70,42,,,,255,,76,,,,14,,,
     15,,,14,,,15],[16,24,,40,38,17,27,17,,34,7,9,13,,,9,8,13,,8,13,,28,
     ,32,,,26,23,37,23,47,34,30,57,57,35,73,7,,15,,7,7,,7,15,,,7,,15],
   [,,,,416,148,,161,,482,,,,,,,60,153,,74,149,57,257,,,,,,282,343,215,365,261,
     ,465,,354,460,,,,,,71,,71,,126,414,71,504,211,73],[],
   [,,,403,,,,,,514,49,42,95,56,86,42,42,95,86,42,95,42,261,,,,224,163,,,
     179,263,,226,,357,210,346,49,292,104,97,49,49,,49,104,97,294,49,363,
     104,49,62],[],[164,,,,408,144,,,,383,79,64,164,79,150,64,,149,,,169,
     59,258,,304,196,274,244,,335,,,273,343,456,445,,922,75,413,178,122,75,
     71,581,71,174,126,,,446,223,73,108,,61],
   [112,128,,229,298,117,196,135,,217,49,42,95,56,84,42,42,95,84,42,95,42,
     199,,212,168,,163,160,310,154,246,,222,396,394,210,,49,222,102,91,49,
     49,209,49,102,91,225,49,240,102,49,66,,42,,64],
   [48,,,,95,66,58,55,,66,46,,,,,,44,84,63,,84,41,42,,,,,,59,61,,62,59,50,
     299,,252,,40,,,,40,41,74,39,92,47,70,42,76,109,42,339,,313,,350,297],
   [,,,,125,56,70,65,,,,,,43,,,,73,59,41,96,37,,,,37,,46,44,66,43,54,51,53,
     ,231,259,237,,,,41,,38,84,37,109,53,85,39,83,90,49,,,,,333,258],
   [,51,,,,,,79,,65,36,36,72,60,61,36,36,72,63,37,74,35,,,49,49,55,34,,,
     49,63,57,39,261,275,185,251,36,71,75,48,36,33,,33,74,49,70,36,64,
     75,37,,,250,,321,261,,45],
   [,54,,77,98,45,57,51,,71,,34,,42,46,34,,,47,33,73,31,,,50,45,51,46,40,
     60,41,78,51,,232,208,209,191,,67,97,40,,31,69,27,,41,,32,67,,31,286,,
     248,,268,221,39,41,41],[],
   [64,49,,78,117,48,60,57,,77,39,29,71,39,57,29,34,65,55,35,71,29,52,,
     44,45,45,40,38,60,37,54,,45,281,219,187,225,36,87,71,37,36,32,86,
     29,71,49,85,34,,69,34,319,,243,,316,218,47,35,39,35],
   [64,57,,72,100,57,61,79,,,43,55,93,82,,55,46,92,95,45,,45,52,,54,72,
     78,46,,58,61,88,57,,,303,266,,43,100,105,67,43,41,,41,81,71,100,42,,,
     40,386,,313,,377,302,47,68,43,41,,47],
   [36,,,,64,43,59,35,,103,17,,,,,,16,23,28,18,23,18,60,,,,,62,,73,48,72,67,
     ,100,,81,99,17,,,,17,17,98,17,28,29,,19,,28,19,129,,111,,125,111,86,,
     82,61,,79,91],[,,,,46,23,33,23,,54,,,,8,,,10,,14,10,,10,,,,27,,31,
     27,61,27,40,40,65,,66,40,85,,,,15,,13,41,15,,15,56,15,39,,15,,,56,,
     79,56,,43,52,38,,39,72],
   [,38,,,,,,21,,51,17,12,23,8,12,12,10,23,12,10,23,10,50,,47,29,35,31,,,
     29,41,39,56,61,62,40,76,15,63,28,15,15,11,,13,28,15,,13,63,28,13,
     77,,56,,77,56,53,49,47,39,,45,64,16,8],
   [36,41,,,67,,49,34,,57,17,17,23,,,17,,,28,18,23,18,62,,67,53,64,62,77,
     74,47,71,60,68,95,115,81,97,17,65,27,30,17,17,60,17,,28,67,19,64,
     27,19,126,,111,,127,111,83,79,83,60,,75,92,15,,16],
   [34,,,62,40,,41,,,,18,12,24,8,15,12,10,24,,,24,10,47,,47,29,35,31,30,
     47,,,39,58,63,64,40,79,16,43,28,15,16,12,57,14,28,15,,,40,28,14,77,
     ,56,,77,56,53,49,47,39,,45,63,16,8,8,16],
   [32,30,,45,38,23,31,21,,46,17,12,23,8,12,12,10,23,12,10,23,10,47,,45,
     27,36,31,31,45,27,39,,58,62,61,40,78,15,43,26,15,15,11,35,13,26,
     15,43,13,58,26,13,78,,56,,77,56,55,43,49,37,,39,66,16,8,8,16,8],
   [32,50,,,72,43,59,39,,,17,17,23,,,17,16,23,28,18,,18,58,,74,51,65,61,,
     77,47,,62,,97,113,81,103,17,,28,,17,17,98,17,28,29,,19,,,19,125,,111,
     ,135,111,82,84,85,65,,79,88,15,,16,15,16,16],
   [36,30,,46,40,21,29,21,,46,18,12,24,8,15,12,10,24,14,10,24,,49,,43,
     27,31,31,27,43,29,37,35,56,61,59,40,75,16,35,28,15,16,12,35,14,28,
     15,37,14,35,28,,75,,56,,77,56,51,43,45,35,,39,62,16,8,8,16,8,8,16]
    ,[,,,,,,,,,,,,,,,,28,,,27,,23,,,,,,,,,,,35,,,,,,,,,,,25,,23,57,,,24,,,21,,,
     171,,,,,,49,,,41,,,,55,53,51,47,,47],
   [,,,,,,,,,,,,,,,,22,46,,,,21,,,,,,43,,66,,,56,,,,102,130,,,,,,,,21,,,,,,,,,,134,
     ,266,140,,,67,57,,,113,,,26,43,22,40,,21],
   [,,,,,,,,,,,,,,,,38,,,,,46,,,,,,,,,,,55,,,,998,562,,,,,,,,35,73,,,40,,,34,,,,,
     456,263,,,,35,,43,,,,82,77,,74,88,68],[],[],[],
   [,,,,,,,,,,,16,31,22,27,16,,37,30,16,39,16,,,,45,56,,,62,,,61,53,,139,,
     138,17,43,32,18,17,16,40,21,37,18,43,17,41,36,17,,,230,,164,140,58,
     77,,63,,98,72,,22,22,43,22,22,45,22,,21],
   [,,,,,,,,,,,30,84,42,55,30,28,70,64,46,94,26,,,,47,55,,,,,,,,362,,,249,28,
     ,65,42,28,,,29,65,54,,32,,67,27,,,298,,544,235,56,37,50,35,,33,57,
     92,38,,78,54,36,102,34,,,35],
   [,,,,,,,,,,,,,,,,46,,,,,37,51,,67,47,34,49,34,74,34,64,35,65,,332,540,,,,
     73,,,,,35,,,,34,,77,40,477,,,,,258,74,41,71,41,,43,72,146,,,,108,74,
     116,72,35,,43,,,,,43],
   [,,,,56,19,29,23,,,,,,,,,,,,10,,10,,,,,,31,26,48,24,,,,,,42,,,,,,,9,,,,,,9,,,
     9,,,58,,,56,,,41,41,,40,50,,,22,22,22,20,23,22,20,,,,,,23,33,39],
   [,,,,89,25,45,27,,,,,,,,,,,16,12,,12,,,,,,35,,52,30,,47,,,,47,100,,,,,,11,
     76,15,,17,,13,,,13,,,65,,101,65,,,50,43,,47,75,,,10,,10,10,,10,,20],
   [],[],[],[,18,,44,50,,23,19,,64,,,,,,,,,,10,,10,41,,31,27,33,31,,
     42,23,37,37,36,71,73,42,110,8,32,19,15,8,9,27,8,19,15,32,8,30,19,
     8,85,,58,,,56,52,43,41,35,,37,80,22,,22,,22,20,22,22,,20,,,,,,44,,9],
   [,49,,55,53,37,36,24,,,,,,10,16,,,,,12,,12,,,60,41,34,36,57,51,29,39,46,
     ,88,77,47,,17,40,,16,17,11,37,,,16,39,13,40,,13,106,,65,,95,65,67,
     53,48,50,,43,,20,9,10,20,9,9,20,9,,24,,,,,32,40,91,,10],[],
   [24,17,,34,,16,22,21,,34,8,7,18,10,13,7,7,18,14,8,18,7,33,,29,,36,
     29,23,43,23,33,,31,53,53,41,57,8,29,19,14,8,8,26,8,19,15,29,9,28,
     19,8,67,,53,,67,57,46,,38,34,,33,47,20,9,9,20,10,9,20,9,23,18,43,,,
     ,24,,43,9,10,,,,9,10],
   [,,,,,21,45,27,,,,,,10,16,,,,16,12,,12,52,,57,35,34,36,42,,29,43,43,,77,
     75,47,,,89,,17,,11,,15,,,,13,79,,13,91,,65,,96,65,60,56,49,45,,47,,
     20,9,9,20,9,10,20,9,,41,,,,,,,,,10,,,,,10,,10],
   [,26,,,,17,,,,,8,7,18,10,14,7,7,18,13,7,18,8,,,35,27,35,31,24,44,39,
     41,41,33,61,53,,58,8,33,19,15,8,8,30,8,19,14,33,8,31,19,9,67,,54,
     ,67,53,42,44,38,34,,37,45,20,9,9,20,9,9,20,10,23,17,,,,,,43,,9,10,,
     ,,9,10,,8,10],[,,,,46,,29,,,62,,,,30,,,26,49,,,,24,,,,43,,41,,65,,43,
     87,80,,141,202,140,,,,22,,,25,24,,,,,34,,,,,240,,278,157,,73,64,65,,75,
     94,,26,,47,30,32,,26,,,,,,,30,,,,,,,,22,31,,21,,23],
   [,,,,,53,63,,,67,,,,,,,34,97,,38,85,34,,,,,,38,48,,,,58,45,,,,,,,,,,33,,32,
     80,,,36,117,,32,,,238,,555,245,,,37,38,,40,45,,,71,77,69,68,,66,31,,,,,,
     ,41,59,33,,,,,,136,,37,79,34],[],
   [,,,,,,25,,,30,21,18,37,30,,18,20,36,30,,37,20,,,35,39,52,39,,,,,52,39,
     214,129,,128,20,33,37,22,20,19,27,18,37,23,33,20,28,37,22,213,,171,,
     212,142,54,65,55,52,,65,56,45,26,28,43,,26,45,28,,28,,,,,28,,,21,29,,,
     ,20,28,,19,29,,22],[],[],
   [,21,,47,63,,21,57,,26,26,21,56,,,21,24,,75,25,56,31,41,,37,32,39,38,,
     41,48,47,39,29,194,,139,229,24,37,51,23,24,23,25,21,51,29,37,24,26,
     51,24,227,,177,,,206,54,46,37,39,,42,40,56,63,43,58,45,47,56,39,49,
     36,,,,,36,58,,25,48,,,,23,,,22,48,26,25,37,,23],
   [,,,,,,,,,34,,20,64,28,38,20,,40,32,22,,20,,,,43,87,,,61,,61,77,45,242,
     144,,138,22,36,43,22,22,21,29,24,41,25,36,22,30,39,22,230,,,,224,161,
     ,73,,61,,77,63,72,28,30,47,30,28,,28,,30,,,,,,,,27,,,,,,37,,25,,,24,,,
     22,,,25],[,,,,,59,67,,,103,68,56,,48,50,56,60,118,,,,42,,,,50,58,45,,
     112,48,,,79,325,328,216,,57,,,46,57,39,97,38,79,,,38,65,153,38,389,,
     278,,377,276,51,45,39,38,,41,44,82,44,45,,43,42,,40,,,51,,,,,,59,,,,,,,
     48,,43,45,43,,38,,,,,49],
   [52,,,,112,,55,54,,62,,,97,,,,34,116,,34,,32,38,,43,50,34,31,49,43,47,
     47,38,36,282,291,,246,36,,81,,36,36,115,32,,68,,34,112,81,,417,,250,,
     303,237,56,41,42,41,,40,47,82,,69,83,65,66,,70,41,122,59,,,,60,49,,
     37,77,,,,,75,,39,,33,,40,,,,,37,,46],
   [52,32,,49,,55,,,,32,37,,67,,49,,34,,37,35,67,,34,,51,35,43,45,63,39,
     61,52,43,34,220,347,176,,31,49,58,30,31,33,31,27,58,35,50,30,34,58,
     30,301,,227,,300,237,53,52,40,44,,48,45,65,,35,,35,35,65,31,,47,80,,,
     ,47,76,74,32,37,,,,,,,31,37,33,34,45,,31,,,36,34,45,43],[],
   [,166,,,347,154,224,137,,255,86,43,139,91,123,43,52,174,136,,,62,228,,
     218,145,246,200,231,281,173,237,,250,58,,58,61,80,201,,88,80,59,195,
     57,,93,215,57,200,184,57,450,,359,,445,,301,233,275,206,,219,303,128,
     85,62,,64,61,115,59,,134,,,,,122,,312,83,89,,,,,,,,77,55,144,318,,129,,,
     ,139,285,284],[272,146,,,,105,,103,,,35,30,69,40,62,30,30,69,62,30,
     69,30,209,,172,,178,117,206,266,,199,302,,51,45,30,51,35,,76,71,35,
     35,297,35,76,71,241,35,299,76,35,331,,210,,339,210,245,,182,190,,186,
     243,81,40,40,81,40,40,81,40,,112,531,,,,,,,42,47,,,,42,47,,39,47,41,
     161,180,,168,,,139,,,182,175,,51],[],
   [,,,,46,23,33,23,,54,,,,8,,,10,,14,10,,10,,,,27,,31,27,61,27,40,40,65,,
     66,40,85,,,,15,,13,41,15,,15,56,15,39,,15,,,56,,79,56,,43,52,38,,39,
     72,,8,8,,8,8,,8,,,,,,,22,38,,,,,,,,9,,9,9,9,26,,,26,,,63,28,44,,,,85,
     40],[],[]],[,[],[],[],[,9],[,,4],[,,,15],[,,4,,,4],
   [,,,14,21,,15],[,21,,15,,,14,,15],[6,,,,,,,8],[],[,,,,,,,20],
   [6,9,12,15,9,12,15,12,15,15,6,,16],[,13,,,,,22,10,,,7,,17],
   [,15,22,31,23,22,23,16,39,33,8,,18],[8,,,22,13,,,10,,22,,,,7,8,9],
   [],[8,10,13,21,11,13,17,,,17,7,,17,,8,,8],
   [,22,,,,,,12,,,8,,18,,,9,9],[,,,,,,,20,,,,,15,16,17,18,,,17,18],
   [,15,22,31,25,22,23,12,,31,8,,18,,,9,9,,,9,18],
   [12,,,,,,,,,,12,,,12,,30,15,,15,,44,28],[,,,,,,,6,,,,,,15,,27,19,,17,,,27]
    ,[,17,,,18,,,,22,25,,,,18,24,28,24,,20,34,101,28],
   [12,17,7,22,17,7,22,6,22,22,11,,,9,,,,,11,24,,23,12,5,17],
   [,25,10,30,25,10,30,8,30,30,16,,50,,13,,22,,15,34,48,32,13,6,18],
   [12,,,,,,,12,,,12,,,12,15,20,17,,15,20,44,20,10,,,12,13],
   [,,,,,,,6,,,,,,15,,27,19,,17,,,27,,5,,5,6],
   [,18,,,17,,,18,26,22,,,,18,,36,22,,21,,89,36,,,16,17,18],
   [,,7,,,7,,,,,13,,33,15,12,17,13,,,,33,21,,5,,5,6,,5],
   [,17,,22,18,,25,,,25,,,67,18,,38,24,,20,,,44,,,15,17,18,22,,16],
   [30,25,10,30,25,10,30,8,30,30,16,,58,18,14,30,18,,15,30,58,24,13,6,
     18,,6,13,6,18,6,18],
   [30,18,,26,17,,22,18,26,,,,101,18,24,28,24,,21,31,,28,22,,16,17,18,,,15,
     ,16,18],[30,,,,,,,32,,,27,,,30,,,36,,38,,89,70,54,,,51,70,54,,,65,,
     66,99],[30,45,20,72,45,20,72,20,72,72,27,,95,30,,,35,,44,,99,,54,
     25,81,25,,54,25,81,25,81,,81,26],
   [30,,,,,,,32,,116,25,,,30,37,42,,,37,42,,42,54,,,45,62,54,,,65,113,66,,
     26,26],[30,45,20,72,45,20,72,20,72,72,27,,95,30,,70,,,,62,,,50,25,
     77,25,30,50,25,77,25,77,30,77,26,20,26],
   [6,,,,,,,8,20,,5,,,6,7,8,6,,7,8,,8,12,,,11,16,12,,,13,20,16,22,27,27,
     25,27],[,,,,,,,,18,,,,,19,22,31,22,,,,,31,,,,30,40,,,,,28,36,,,86,,86],
   [,,,,,,,18,42,,,,,16,17,18,,,17,18,17,18,,22,,,23,,22,,22,46,30,,,83,,83]
    ,[6,9,10,14,9,10,14,8,14,14,6,,14,6,,,7,,7,14,14,,12,13,17,9,,12,
     13,17,11,17,18,17,30,30,30,30,6,18,14],
   [,21,21,37,27,21,31,18,,37,7,,15,,,,8,,,8,15,8,30,26,32,,,24,26,38,
     19,50,31,32,71,,35,57,7,,15],
   [6,,,,,,,8,20,,5,,,6,7,8,6,,7,8,,8,12,,,11,16,12,,,13,20,16,22,27,27,
     25,27,5,,,6,7],[,,,,,,,,19,20,,,,19,22,31,22,,22,,,31,,,,30,40,,,,,
     30,36,30,,86,,86,,17,,18],
   [6,9,10,14,9,10,14,8,14,14,5,,,6,7,8,,,7,8,,8,12,13,17,9,12,12,13,
     17,11,17,12,17,27,27,25,27,5,18,,6,7,5,18],
   [,,25,,,25,,18,42,,,,17,16,17,18,,,17,18,17,18,47,24,60,27,28,45,24,
     62,23,44,36,62,88,87,125,,,,12,14,15],
   [6,12,10,20,12,10,20,,,20,6,,14,6,7,14,7,,,,14,14,12,14,20,10,14,12,
     14,18,,,14,18,30,30,30,30,6,,14,6,,6,,6,14],
   [,,,20,,,21,,,21,,,,19,22,31,22,,,,,31,,,30,30,40,,,32,,,36,32,,86,263,86,
     ,16,,18,,,17,18],[,21,21,37,27,21,31,,,37,7,,15,,,8,8,,,,15,8,30,
     24,34,23,,24,24,40,18,,27,34,59,71,35,58,7,,15,,7,7,,7,15],
   [,,,21,,,20,,19,,,,,19,22,31,22,,22,,,31,,,32,30,40,,,30,,30,36,,,86,262,
     86,,17,,18,,,16,18,,,17],
   [,,19,,,19,,18,42,,,,17,16,17,18,,,17,18,,18,,28,,,24,,28,,22,46,27,,87,
     ,98,85,,,12,14,15,,,,12,14,,15],
   [,21,21,37,27,21,31,14,,37,7,,15,,,8,8,,,8,15,,30,26,32,,,24,26,38,
     21,50,31,32,57,57,35,71,7,,15,,7,7,,7,15,,,7,,15],
   [42,,,,,,,40,168,162,37,,,42,55,80,48,,,86,119,82,74,,,61,82,74,,,59,134,
     78,133,180,168,174,168,37,,,42,,37,,37,110,42,194,71,258,114,73],
   [42,63,28,100,63,28,100,28,100,100,37,,,42,,,47,,55,78,117,78,74,35,
     111,35,,74,35,111,35,111,46,111,176,140,166,140,37,118,107,42,,37,
     118,37,,42,118,71,118,108,71,34],
   [42,,,,,,,,,,35,,,42,51,58,,,51,58,121,58,74,,,61,82,74,,,59,128,82,131,
     178,164,160,162,35,,,42,49,35,,35,,42,281,49,278,153,49,34,34],
   [42,63,28,100,63,28,100,28,100,100,37,,117,42,52,,,,55,80,121,84,70,35,
     107,35,42,70,35,107,35,107,42,107,172,140,168,140,37,118,107,42,71,
     37,118,37,,42,118,85,118,111,,34,28,34],
   [42,79,40,,81,40,,,,,37,,115,42,52,72,,,,,115,72,74,,127,55,74,74,,129,,,
     78,147,180,164,174,168,37,194,116,42,67,37,261,37,110,42,,,,111,69,
     34,34,34,34],[42,63,28,100,63,28,100,28,100,100,35,,95,42,49,58,42,
     ,49,58,95,58,74,35,111,35,,74,35,111,35,111,,111,172,138,158,136,35,
     114,84,42,49,35,114,35,84,42,114,49,114,84,49,34,28,31,28,34],
   [22,,,,,,,18,30,37,22,,,23,27,43,24,,24,,68,41,18,,,19,20,19,,,,23,20,
     26,94,88,94,86,21,,,22,41,21,,20,67,20,40,43,43,71,43,126,120,126,
     118,126,120],[24,33,13,38,33,13,38,10,38,38,21,,73,15,,,,,19,40,73,
     33,21,9,26,7,,21,9,26,8,26,8,26,89,35,79,35,21,50,,15,,21,50,15,
     40,18,50,35,50,47,44,103,49,103,49,93,49,19],
   [24,,,,,,,20,,30,22,,,23,25,35,24,,25,35,66,33,19,,,19,20,18,,,19,27,20,
     23,94,88,94,86,21,,,22,35,21,,20,65,22,43,35,40,67,37,126,120,126,
     118,126,120,17,19],
   [22,25,10,30,25,10,30,8,30,30,16,,64,14,16,28,,,15,32,64,28,18,8,23,
     7,8,18,8,23,7,23,8,23,66,32,66,30,16,40,34,14,,16,40,12,,14,40,
     29,40,34,28,82,44,78,42,78,44,18,7,18],
   [22,25,21,30,28,21,,,,,22,,,23,,45,24,,,,60,,18,,23,19,20,19,,26,,,20,
     26,94,88,94,86,21,38,49,22,43,21,41,20,49,20,,,41,49,55,126,120,
     126,118,126,120,16,19,17,18],
   [24,33,13,38,33,13,38,10,38,38,21,,57,15,22,25,22,,19,34,57,25,21,9,
     26,7,8,21,9,26,8,26,,26,85,35,83,35,21,46,34,15,30,21,46,15,34,
     18,46,30,46,34,30,99,49,103,49,97,49,19,7,19,7,19],
   [24,29,21,37,25,21,30,20,,,22,,66,23,,45,24,,25,43,,41,19,,27,19,20,18,
     ,23,19,27,20,,94,88,94,86,21,,71,22,41,21,40,20,67,22,43,41,,,43,
     126,120,126,118,126,120,17,19,16,18,17,19],
   [18,,,,,,,20,,59,13,,,18,19,20,19,,19,20,23,20,32,,,29,40,28,,,31,,40,,
     75,75,65,75,13,,,16,17,13,,13,24,16,47,17,,26,17,101,101,91,101,101,
     91,54,51,50,40,54,47,54],
   [18,27,26,43,27,26,43,24,43,43,16,,24,16,,,19,,22,19,26,19,34,31,50,
     27,,34,31,50,27,50,38,50,78,78,76,78,14,49,26,16,,14,49,16,26,16,
     49,16,49,28,16,106,106,104,106,106,100,59,41,59,36,59,37,59,16],
   [14,,,,,,,16,50,,13,,,16,17,18,16,,17,18,,18,26,,,25,34,26,,,25,49,30,
     50,65,65,59,65,11,,,14,15,11,,13,26,14,,15,,,15,87,87,81,87,87,77,
     46,43,46,34,50,39,46,13,14],
   [18,21,28,38,25,28,34,20,38,38,13,,21,18,19,20,,,19,20,27,20,32,35,
     41,25,32,28,35,45,27,45,32,41,75,75,65,75,13,40,23,16,17,13,40,13,
     ,16,38,17,40,27,17,101,101,91,101,101,91,52,39,48,32,52,35,52,13,
     16,13],[18,32,,57,33,,63,,,,16,,24,16,22,19,19,,,,26,19,34,35,55,
     30,36,34,35,54,,,40,53,78,78,76,78,14,77,26,16,16,14,77,16,26,16,,,
     77,28,16,106,106,104,106,106,100,57,50,59,40,57,46,59,16,15,14,16],
   [14,21,16,34,21,16,34,16,38,34,13,,21,16,17,18,16,,17,18,27,18,26,21,
     39,21,30,26,21,39,21,43,,39,65,65,59,65,11,36,22,14,15,11,40,13,
     26,14,40,15,36,26,15,87,87,81,87,87,77,46,31,46,28,50,27,46,13,14,
     11,13,14],[18,27,22,53,30,22,52,20,53,,13,,21,18,19,20,21,,19,20,,
     20,32,,49,27,36,28,,52,29,52,36,,75,75,65,75,13,,25,16,17,13,,13,
     25,16,47,17,,,17,101,101,91,101,101,91,54,45,50,36,54,41,54,13,16,
     13,13,16,13],[18,27,26,43,27,26,43,20,43,43,16,,24,16,21,19,19,,
     22,19,26,,34,31,50,27,30,34,31,50,31,50,34,50,78,78,76,78,14,49,
     26,16,16,14,49,16,26,16,49,16,49,28,,106,106,104,106,106,100,57,41,
     57,34,57,37,57,16,15,14,16,15,14,16],
   [,,,,,,,,,,,,,9,10,15,,,13,23,,15,,,,9,10,,,,,,10,,,39,,35,,,,9,19,,,9,,11,
     ,16,,,19,,53,,49,,53,,16,,13,,16,31,,25,,21,31,19,,25],
   [,,,,,,,,,,,,,10,11,18,11,,,,,18,,,,20,34,,,,,,,,,44,,44,,,,10,,,,10,,,,,,,,,
     60,,60,76,56,,36,,32,32,32,,,24,,20,26,16,,24],
   [,,,,,,,,,,,,,14,,36,13,,18,,,,,,,11,12,,,,,,12,,,46,,44,,,,14,31,,,12,47,16,
     ,36,,,,,62,,60,96,62,,11,,10,,11,,,34,,32,,26,40,32],
   [,,,,,,,,,,,,,9,,29,10,,13,,,,15,7,25,9,15,15,7,25,7,25,15,25,85,39,73,
     35,,,42,9,28,,,9,,11,,,,42,28,83,53,,49,85,53,26,16,26,8,26,16,26,
     37,25,31,25,,19,,25,9,,10],
   [,,,,,,,,,,8,,20,10,,12,9,,10,20,20,12,,,34,20,34,,,,,,34,,,44,52,44,8,
     26,19,10,13,8,26,8,19,8,26,15,26,19,13,72,60,64,60,,56,38,36,,32,
     38,32,36,20,24,18,20,30,18,20,24,,10],
   [,,,,,,,,,,,,,14,13,38,,,,,,36,16,8,26,11,10,16,8,26,8,26,8,26,116,46,,
     44,20,,25,14,,20,,12,31,,,31,,26,,112,62,124,60,,62,27,11,27,9,27,9,
     27,56,34,44,32,,30,,32,10,,11],
   [,,,,,,,,,,,,16,8,9,14,,,10,14,20,14,,,,20,,,,34,,,34,,,44,,44,8,26,19,8,
     15,8,26,10,19,8,26,15,26,17,15,,60,,60,68,56,32,36,,32,,32,34,,24,
     18,20,24,18,18,24,,10,,,10],
   [,,,,,,,,,,,,,14,19,22,,,18,36,,20,,,,11,12,,,,,,12,,140,46,108,44,,,,14,24,
     ,,12,27,16,,24,,,21,136,62,124,60,158,62,26,9,26,10,26,9,26,,34,,
     28,48,26,,32,,,10,10,,11],
   [,,,,,,,,,,,,,14,,36,19,,18,,,34,16,8,26,11,8,16,8,26,8,26,10,26,,46,
     84,44,,,47,14,36,,,12,,16,,,,31,36,116,62,,60,100,62,27,9,27,9,27,
     11,27,48,34,,32,44,26,40,32,10,,11,,,10,,11],
   [,,,,,,,10,22,,,,,8,9,10,,,9,10,,10,,,,,14,,,,12,24,13,,,35,,35,,,,8,9,,,,
     ,8,,9,,,9,,47,,47,,42,,21,,16,25,22,27,,20,,18,20,16,21,20,10,,,14,
     9,14,11,,13],[,,,,,,,20,,,,,,20,21,22,,,21,22,,22,,,,,58,,,,33,89,50,,,
     ,,95,,,,18,19,,,,,18,61,19,,,19,,121,,125,115,95,,73,,64,,57,62,,18,,,
     18,15,,18,,16,,,20],
   [6,,,,,,,,,,6,,20,6,,20,8,,8,,20,20,12,,,12,18,12,,,,,18,22,30,30,30,30,
     6,21,17,6,17,6,21,6,17,6,21,17,21,17,17,42,42,42,42,42,42,21,24,
     23,18,21,24,23,18,18,14,18,18,14,18,18,,8,,,,,,,,7,16],
   [,13,,,,,22,10,,,7,,21,8,7,22,9,,8,,21,22,17,19,22,,18,15,19,24,13,24,
     ,22,44,38,37,39,7,20,18,8,21,7,20,7,18,7,20,21,20,18,21,58,52,
     51,53,52,49,27,21,25,14,27,22,27,19,22,15,19,,15,19,22,11,9,17,10,,
     ,11,13,,8,17],[,22,,,,,,16,,,8,,22,20,,8,10,,22,9,22,9,,,31,24,30,
     20,,,,,34,38,68,,42,,8,31,19,12,9,8,31,8,19,12,31,8,31,19,8,78,82,
     58,78,,58,45,40,33,32,43,34,,20,18,16,20,17,16,20,17,,14,,,12,,,36,,
     9,18],[],[],[,11,13,18,10,13,21,,17,,7,,21,,8,,9,,7,22,21,,16,
     17,21,11,15,15,17,20,,21,15,20,38,44,37,41,7,19,18,7,21,7,20,7,
     18,8,19,21,20,18,21,52,,51,,52,49,26,19,25,15,25,19,24,19,24,15,
     19,22,15,19,,13,10,,,10,18,,18,,8,17,,8],
   [,15,22,39,,22,23,12,31,39,8,,22,,22,9,10,,,8,22,9,30,27,28,,30,20,
     27,42,17,36,,28,62,62,42,62,8,27,19,12,8,8,27,8,19,12,27,9,27,19,
     8,78,78,58,78,72,58,45,,35,28,43,25,45,20,17,16,20,18,16,20,17,15,
     14,38,31,14,36,18,22,38,9,18,,,9],
   [,,,,,,,20,,,,,,20,21,22,,,21,22,,22,36,,,,58,44,,77,33,,50,,101,91,,,,,,
     18,19,,61,,,18,,19,,,19,117,117,131,,115,95,60,73,68,64,66,57,,21,16,
     13,27,16,15,21,16,,16,,,20,,,,,,15,16,17,18,,,17,18],
   [,,,,,,,12,,,8,,22,20,,9,10,,22,9,22,8,,,38,24,30,20,,43,33,47,34,31,
     70,62,42,70,8,31,19,12,8,8,31,8,19,12,31,8,31,19,9,78,78,58,82,
     72,58,43,40,35,32,41,34,45,20,17,16,20,17,16,20,18,23,14,,,12,,,36,
     ,9,18,,,9,,,,9,18],
   [,,,,,,,,,,,,,13,15,23,15,,,,,23,,,,25,35,,,,,25,31,,,59,,59,,,,13,,,,13,,,,,
     23,,,,81,,81,,77,,45,,35,35,41,,,33,,27,48,27,,33,,,,,16,,16,,,,,13,13,
     21,,,13,19,34,21],
   [,,,,,,,,,51,,,,17,17,27,17,,20,30,,25,,,,14,15,,,,,,15,,,61,,59,,,,17,27,,
     ,15,50,17,,27,,41,29,,83,,81,97,83,,14,,13,,14,23,,43,,35,46,33,,41,
     13,,,16,34,17,,16,17,17,,,18,30,,,19,27,,30],
   [12,,,,24,,,12,,,12,,36,12,17,30,,,,,,,12,11,20,12,20,12,11,19,11,20,20,
     19,54,54,54,50,12,,29,12,,12,32,12,29,12,,42,32,29,,74,74,74,70,74,
     74,21,21,20,11,21,21,20,32,34,30,32,34,30,32,34,15,20,16,,,,,16,,
     15,44,12,,,,,15,30,,28,,13],
   [,,,,,,22,,,,13,,31,13,,17,13,,12,,31,19,,,25,25,35,25,,,,,35,24,,59,,59,
     12,21,27,13,19,12,20,11,27,12,21,19,20,27,21,149,81,110,81,111,77,
     37,45,35,35,,41,,29,33,27,27,,25,29,33,,16,,,,,16,,,13,31,,,,,,13,17,
     31,37,13],[,,,,,,51,14,,,,,,17,17,35,17,,20,,77,35,13,12,21,14,13,
     13,12,20,12,21,11,20,91,61,75,59,,,39,17,33,,,15,,16,,33,,52,33,107,
     83,101,81,106,83,22,14,21,12,22,12,21,48,43,37,39,46,33,42,41,16,,
     17,13,,,34,17,16,20,,,17,,,,20,41,57,39,,14],
   [12,9,8,15,9,8,15,8,15,15,11,,29,9,11,,11,,,23,29,,10,9,16,8,9,10,
     9,16,9,16,9,16,45,35,45,35,10,17,25,9,21,10,17,9,25,10,17,21,17,
     25,21,59,49,59,49,59,49,17,10,17,9,17,10,17,27,25,25,25,27,23,27,
     25,13,14,14,13,14,14,14,14,14,11,29,11,11,23,,,,,29,23,11,11,10,11,
     11],[],[,,,,13,,,,,22,,,34,11,13,19,,,12,21,,19,,,,25,31,,,24,,27,
     35,28,117,59,,59,12,21,25,11,21,12,20,13,27,12,21,21,20,27,21,117,
     81,,81,,77,,45,39,35,37,41,35,28,33,27,27,35,25,,33,,16,,,16,,,,,15,,
     ,15,,,,16,23,,,13,,,13,,11],
   [,,,,,,51,,,51,,,57,17,17,41,20,,,,,41,,,,14,15,25,,,13,,15,,,61,75,59,18,
     ,33,17,47,18,44,15,33,,,35,44,33,35,100,83,100,81,106,83,21,12,20,
     13,21,12,20,45,43,41,39,46,37,42,41,13,,16,16,,17,,,17,17,77,,17,,,,
     19,35,,40,,13,13,,14,11],
   [30,,,,,,,14,,51,,,,17,18,27,17,,20,30,,25,13,12,21,14,11,13,12,20,12,
     21,13,20,79,61,,59,18,,52,17,27,18,,15,,16,,29,,35,27,100,83,119,81,
     97,83,22,12,21,12,22,14,21,44,43,40,35,45,33,,41,16,,17,13,,16,,17,
     ,17,,19,17,30,,,19,27,,30,,14,,,13,11,,,14],
   [30,21,20,26,24,20,18,20,25,21,26,,66,,23,,23,,19,68,66,,22,21,27,17,
     18,25,21,19,21,26,18,22,108,,108,,22,28,53,18,55,22,20,18,53,22,27,
     55,23,53,55,140,160,140,218,140,,28,19,20,18,27,19,23,58,,56,66,60,
     64,58,,31,32,32,31,32,32,32,32,32,23,66,26,23,68,,,,,66,68,23,23,
     22,23,23,,,23,23,23],
   [30,65,,144,,,,,144,154,27,,91,30,,66,37,,38,,91,64,54,,99,51,66,54,,,49,
     ,70,,26,26,26,24,27,,88,30,59,27,,27,87,30,,57,164,90,,180,176,178,
     172,180,172,94,89,94,66,94,85,94,75,78,65,75,78,65,75,78,99,52,116,,
     ,,60,,124,37,91,30,,,,,38,66,91,62,116,93,54,,,45,,116,,93,108],
   [30,45,20,72,45,20,72,20,72,72,27,,91,30,38,62,35,,41,,,,54,25,81,25,
     36,54,25,81,25,81,,81,26,20,26,20,27,86,87,30,71,27,86,27,,30,86,
     57,86,86,57,168,140,164,140,164,138,88,35,88,32,88,35,88,75,78,65,
     75,78,65,75,78,39,44,46,39,44,46,44,46,46,35,99,30,,,,,44,,95,62,
     59,61,54,59,61,35,,59,61,61,,26],
   [30,,,121,,,172,28,,157,25,,,30,37,42,,,37,42,,42,54,76,103,45,62,54,76,
     100,,100,62,,26,22,24,26,25,,125,30,35,25,263,25,98,30,262,35,,129,
     35,174,166,160,168,174,156,94,79,94,66,94,83,94,65,76,59,65,76,59,
     65,76,,,92,63,,136,,,136,41,,30,37,42,,,37,42,,42,133,75,54,110,78,45,
     ,,,75,108,26,26],
   [,,,,,,,8,,,,,,20,,34,19,,21,,,32,,,,7,8,,,,7,,8,,,32,,30,,,,18,29,,,16,
     31,18,,31,,31,31,,44,,42,122,44,,7,,6,,7,,,42,,42,,28,42,40,,,,8,,9,,
     8,9,,,,22,,,,21,34,,,,,12,,13,10,,,12,13,22,114,32],[],
   [6,11,,,,,20,8,,,6,,16,6,,16,7,,7,,16,16,12,,20,11,16,12,,,13,,16,20,
     30,30,30,30,6,19,15,6,15,6,19,6,15,6,19,15,19,15,15,42,42,42,42,
     42,42,21,21,21,16,21,21,21,16,16,14,16,16,14,16,16,13,8,,,,,8,20,,
     7,16,6,,,,,7,16,16,,12,18,12,,,10,,12,,18,22,30,30,30],
   [,,,,,,,8,,,,,,20,19,34,,,21,,,32,12,6,19,7,6,12,6,19,6,19,6,19,114,32,
     ,30,,,27,18,31,,,16,,18,,29,,31,31,90,44,,42,,44,20,7,20,7,20,7,20,
     ,40,38,36,46,34,,38,8,,9,,,,,9,8,22,,,,,,,21,34,,,,13,,,,10,,,13,12,
     22,,32,,7],[,18,,36,39,,28,18,,,7,,17,,,,8,,,8,17,8,47,,29,23,30,
     26,,37,21,51,30,30,62,80,35,61,7,29,16,14,7,7,29,7,16,14,30,7,30,
     16,7,76,,49,,70,49,44,37,36,30,,33,,17,,15,17,16,15,17,16,23,18,,,,,
     18,32,,8,17,,,,,,,8,17,8,22,34,,20,,,,22,55,34,,,61,35]],
 [,[],[],[],[],[],[],[,,,,,19],[,,,,32,,44],[],[],[],[],
   [,,,66,,25,44,25,66],[,62,,,,,50,25],[,60,,51,,33,42,27],
   [,,,53,32,,,25,,,,,,10,11,12],[],[,51,,56,28,22,41,,,,,,,,11,,11],
   [,62,,,,,,23,,,,,,,,12,12],[],[,,,79,,33,52,27,118,,,,,,,12,12,,,12],
   [,,,,,,,,,,,,,57,,63,63,,63,,,75],[],
   [,51,,,,53,,,45,,,,,69,58,59,53,,49,78],
   [,,,54,,37,,34,80,,,,,27,,,,,29,48,,41,51,,35],
   [,86,,65,,51,56,45,74,,,,,,32,,57,,38,63,,53,51,,47],
   [,,,,,,,40,63,,,,,31,38,43,,,38,43,,43,,,,,38],
   [,,,,,,,30,,,,,,33,,43,40,,31,,,43,,,,27,33],
   [,,,,27,,,55,48,,,,,,64,,45,,44,95,,70,,,,33],
   [,,,,,33,,,,,,,,33,30,37,33,,,,,37,,,,27,33,,25],
   [,,,52,44,65,50,,,,,,,45,,58,58,,42,,,75,,,,56,41,34,,42],
   [,96,,73,50,43,46,37,92,,,,,55,39,67,49,,34,61,,47,52,,41,,29,32,27,
     35,27,41],[],[,,,,,,,134,,,,,,,79,,60,,80,100,,,348,,,162,,,201,,248,
     320,193],[,347,,313,185,137,202,,251,,,,,91,,,61,,89,,,,352,,310,147,,
     333,197,219,,233,,,96],
   [,,,,,,,105,330,,,,,40,49,54,52,,49,54,,54,,,,146,170,117,,,195,194,143,,,
     52],[],[],[,,,,25,,,,30,,,,,48,36,53,36,,,,,62,,,,46,61,,,43,,46,
     65,,,215],[],[,42,,27,,19,30,19,47,,,,,15,,,18,,18,25,,,45,,39,25,,
     29,27,,27,34,53,,,87,71,,,27],
   [,61,,77,,37,63,34,,,,,,,,,19,,,19,,19,58,,75,,,57,47,133,44,85,72,,192,,
     76],[,,,,,,,15,40,,,,,15,16,17,15,,16,17,,17,,,,25,35,23,,,25,36,31,,,
     ,52,,,,,13,14],[],
   [,,,31,20,19,,19,26,,,,,17,18,19,,,18,19,,19,50,,35,25,33,,27,33,27,55,
     33,,86,84,,,,27,,15,16,12],[],
   [,38,,55,31,17,46,,,,,,,15,18,23,18,,,,,25,50,,51,26,35,29,26,40,,,31,,
     99,131,71,,,,,15,,13,,15],
   [,,,38,31,,51,,,,,,,48,40,53,40,,,,,60,,,51,50,65,48,,50,,,56,,,,,,,,,31,,,
     ,31],[,58,,79,,37,61,,,,,,,,,19,19,,,,,19,62,,81,48,,57,41,,37,,58,,,
     261,76,,,,,,16,14,,16],
   [,,,,,,29,,39,,,,,66,40,91,40,,60,,,92,,,,48,65,,,42,,52,89,,,214,223,,,37,
     ,31,,,,31,,,93],[],
   [,57,,77,,37,63,34,,,,,,,,19,19,,,19,,,62,,71,,,57,47,133,42,89,72,,165,
     184,76,,,,,,16,14,,16,,,,16],
   [,,,,,,,162,374,,,,,90,99,116,74,,,164,,107,416,,,202,294,,266,,227,375,273,
     ,525,492,,,,,,131,,,,112,,117,342,174,,,173],
   [,476,,307,155,194,251,162,311,,,,,107,,,80,,,116,,111,423,,346,187,,264,
     229,252,239,,258,,442,504,335,,,,,114,,101,,109,,129,270,195,248,,171],
   [,,,,,,,,514,,,,,56,67,74,74,,67,74,,74,,,,186,224,163,,,206,258,189,,,,210,
     ,,,,97,104,72,,149,,97,276,104,324,,104,,62],
   [,413,,258,191,170,257,168,,,,,,94,110,,,,112,116,,110,471,,329,201,258,,
     241,281,337,377,236,,490,571,429,,,251,,118,175,,,111,,134,236,249,293,,
     ,66,108,65],[],[,328,,332,,151,201,113,215,,,,,56,63,74,56,,63,74,
     ,74,,,303,168,,163,,,162,253,,,359,350,210,,,206,,91,102,70,,84,,91,,
     102,279,,102,64,66,42,68],
   [,,,,,,,61,,,,,,82,58,80,58,,58,,,99,57,,,57,57,,59,,,51,53,,326,343,,,,,,
     50,81,,,47,,47,70,85,,,85,405,431,,400,,377],
   [,,,92,61,65,76,56,107,,,,,43,,,,,47,82,,61,73,,60,37,,,47,50,44,63,41,,
     275,237,228,,,76,,41,,45,,41,,44,83,75,77,,85,339,299,294,311,,258,53]
    ,[,,,,,,,66,70,,,,,60,53,69,,,53,76,,68,,,,,59,34,,,59,54,49,,,372,184,,,
     ,,49,75,33,,45,,49,68,75,54,,79,,334,248,,,261],
   [,98,,73,54,51,61,45,71,,,,,42,43,56,,,38,63,,53,,,60,45,51,,43,50,40,
     88,43,,232,210,,,,61,,40,,35,,33,,35,67,60,61,,58,,260,248,246,,221,
     41,41,39],[,108,,,57,79,66,,,,,,,82,73,115,51,,,,,138,,,58,51,78,49,
     71,54,,,53,,299,359,271,,,62,,67,104,46,,42,,42,,,64,,146,363,378,339,
     395,,302,,47,48,62],
   [,117,,84,49,57,62,48,77,,,,,39,54,53,54,,43,74,,53,67,,60,45,45,42,
     41,44,38,55,,,262,223,185,,,80,,37,71,41,,37,,40,86,71,,,71,335,273,
     243,287,,218,47,35,41,35,47],[],
   [,,,,,,,31,,,,,,18,19,20,20,,19,20,,20,68,,,46,57,,,,43,69,52,,89,96,,,,,,
     27,28,,,24,,27,56,28,,,28,115,119,,117,,,78,75,,59,79],
   [,40,,37,32,23,34,21,48,,,,,8,,,10,,13,10,,10,49,,45,27,,31,29,45,27,
     40,39,,61,75,40,,,37,,15,,13,,15,,15,40,15,51,,15,77,77,56,79,,56,
     55,43,49,37,65,39,,16],
   [,,,,,,,15,36,,,,,8,9,10,8,,9,10,,10,,,,24,33,23,,,24,36,29,,,50,30,,,,,
     13,14,10,,12,,13,,14,39,,14,,,42,63,,42,,42,37,33,41,38,,,8],
   [,53,,53,,29,62,30,55,,,,,18,19,20,,,19,20,,20,80,,63,43,56,76,73,,43,
     66,52,,94,92,87,,,51,,26,27,28,,23,,26,49,27,60,,27,119,115,111,117,,
     120,79,69,73,56,77,67,,13,16],
   [,40,,47,,,48,,,,,,,8,13,10,10,,,,,10,48,,47,29,35,31,32,47,,,39,,63,79,
     40,,,43,,15,15,13,,15,,15,,,,,15,77,75,56,79,,56,53,49,47,39,63,45,,
     16,8,8,16],[,32,,29,16,15,27,15,28,,,,,8,9,10,8,,9,10,,10,40,,35,
     21,31,23,21,29,21,34,,,46,46,30,,,31,,13,14,10,,12,,13,30,14,36,,14,
     58,57,42,59,,42,43,33,37,29,42,29,,14,8,6,14,8],
   [,75,,62,,36,,31,60,,,,,18,19,20,16,,19,20,,20,70,,66,44,61,75,,88,44,
     66,57,,89,93,85,,,,,27,28,,,26,,27,60,28,,,28,115,115,117,125,,,78,73,
     91,59,80,73,,13,16,,13,16,14],
   [,42,,35,34,23,32,19,46,,,,,8,13,10,10,,13,10,,,50,,43,27,31,31,29,43,
     29,38,35,,61,75,40,,,35,,15,15,13,,15,,15,38,15,50,,,75,77,56,81,,
     56,51,43,45,35,62,39,,16,8,8,16,8,8,16],[],
   [,,,,,,,,,,,,,31,22,45,22,,,,,45,,,,38,52,,,,,,,,,,,,,,,19,,,,19,,,,,,,,,147,,
     157,,,,66,,51,61,,,,27,,39,,,,27],[],
   [,,,,,,,,,,,,,,,,28,,35,,,,56,,53,,56,33,27,45,27,50,33,,,,166,,,,,,,,,25,,
     29,,,,,,326,273,192,,,152,60,63,52,30,57,41,,49,49,29,55,61,19,54,55]
    ,[,,,,,,,,,,,,,31,,,21,,26,32,,24,,,66,42,60,,,,,59,59,,,126,112,,,38,,19,
     ,16,,18,,20,43,31,43,,29,222,153,134,159,,157,87,74,,63,113,94,,33,
     21,16,34,24,16,33,22,,19],
   [,,,,,,,,,,,,,,,,,,,,,,73,,74,,,51,38,67,34,65,30,,,621,,,,,,,,46,,34,,,,,,,,
     410,468,499,,,258,81,,74,41,72,37,,72,67,42,68,,32,,72],
   [,,,,,,,,,,,,,22,21,28,,,26,28,,28,,,,48,,77,,54,,,58,,,136,,,,38,,18,33,16,
     ,19,,20,43,33,43,,33,,173,222,156,,142,68,80,73,57,,98,,,22,16,37,
     22,16,31,22,,19,,,21],
   [,,,,,,,,,,,,,42,53,54,,,48,90,,46,,,,,55,,,,,,45,,,282,258,,,,,42,56,,,,,42,
     ,62,,,51,801,318,326,353,,260,64,37,50,,57,33,,,36,,66,46,28,80,34,,,
     ,29,,43],[],[],
   [,,,,,,,17,,,,,,10,11,12,,,11,12,,12,,,,27,30,,,,23,37,27,,,,,,,,,15,16,,,
     17,,15,38,16,,,16,,67,,69,,56,,44,,35,,39,,,10,,,10,8,,10,,14,,21,17],
   [,,,,,21,,,,,,,,,,,11,,11,,,,,,79,31,,28,26,,,,33,,86,69,35,,,28,,,,12,,16,,
     16,33,,33,,,100,81,49,,,49,65,48,40,,44,39,,18,18,7,18,18,7,18,18,,
     15,,,,,,,,,8],[,56,,,,23,34,19,,,,,,,,,12,,10,,,,79,,45,,55,30,27,35,
     25,,,,,88,42,,,27,,,,13,,17,,15,32,,31,,,119,103,58,177,,56,60,50,40,
     44,51,40,,19,22,8,19,22,8,19,22,,16,,20,,,23,33,,,9],
   [,89,,,,27,,27,,,,,,10,11,,13,,11,11,,11,,,52,35,39,36,34,,,44,49,,78,,
     47,,,42,,17,,14,,18,,16,43,16,57,,16,93,93,65,103,,65,60,56,48,44,
     75,47,,20,10,9,20,9,9,20,9,,27,,,20,,,46,,,10],[],[],
   [,50,,31,18,19,33,,64,,,,,,10,,12,,,,,,63,,42,27,33,30,27,31,,73,29,,71,
     110,42,,,25,,15,,13,,17,,,32,,32,,,,,58,160,,56,51,43,40,35,80,37,,19,
     22,8,19,22,8,19,22,,,,,20,,,44,,,9,,9],
   [,57,,,,24,34,,,,,,,,11,11,13,,11,,,11,65,,50,,44,35,33,53,,41,,,77,120,
     47,,,41,,16,16,14,,18,,17,39,,,,16,91,105,65,97,,65,62,,50,44,74,43,,
     20,9,9,20,10,9,20,9,,,,75,25,93,32,45,,,10,,,10],
   [,,,,26,,,17,,,,,,10,11,12,,,11,12,,12,47,,44,26,35,,29,35,24,38,31,,61,
     54,40,,,,,15,16,12,,17,,15,,16,,,16,70,67,54,71,,53,49,43,37,34,46,
     39,,18,9,7,18,9,8,18,9,,,,25,17,,,,,,8,8,9,10,,,9,10],
   [,,,,,27,,21,,,,,,10,11,11,13,,11,11,,,,,,34,34,35,35,57,42,,44,,77,,47,,
     ,42,,17,16,14,,18,,16,43,16,57,,,101,91,65,114,,65,60,55,51,45,85,
     47,,20,9,9,20,9,9,20,10,,27,,,,,,57,,,10,,,10,,,,10,10],
   [,,,,,,,,,,,,,34,32,44,32,,,,,44,,,,45,60,43,,,,47,51,,,154,193,,,,,26,,,,26,
     ,,,,,,,,195,227,201,,289,,78,61,62,66,,,,30,,47,30,23,,30,,,,,33,,33,,,,
     ,26,26,34,,,29,33,30,34],
   [,,,,,,,,,,,,,72,67,82,63,,75,111,,80,,,,61,73,,,,,,64,,,463,,,,,,62,75,,,53,
     ,62,,82,,,72,,529,,506,,668,,57,,57,,58,,,57,,84,59,48,,56,,,,63,98,80,
     ,71,,,,,63,66,,,68,73,58,73],
   [,,,,41,,54,40,,,,,,57,50,95,,,,,,,51,,52,51,52,28,47,33,41,45,45,,202,
     227,244,,,,,47,,27,,29,,29,,117,48,,,256,,,,,199,58,58,39,37,51,51,,56,
     46,27,60,47,27,56,49,,,,,,,46,45,,,32,32,,,,,,61,,54,,57],
   [,,,,36,,36,,,,,,,34,,57,29,,30,,,35,,,54,47,62,42,,52,,,64,,244,148,,,,33,
     ,26,59,25,,23,,31,36,41,32,,45,,191,205,208,,199,61,80,61,60,,81,,
     44,28,24,43,,21,44,29,,31,,,,,31,,,,24,,,,,,25,31,24,60,26],
   [,,,,54,,55,51,,,,,,72,63,104,43,,50,,,97,51,,48,61,51,31,49,36,47,47,
     29,,,,171,,,,,60,97,,,37,,38,,93,65,,93,336,346,228,347,,231,54,57,42,
     39,53,35,,68,56,34,70,60,31,68,57,,54,,31,,,60,46,,,32,,33,,,,43,75,
     35,64,,57],[],[],
   [,,,,26,,48,,,,,,,29,29,37,,,30,44,,37,,,,45,55,70,,47,,,60,,224,150,315,,
     ,33,,23,45,25,,26,,31,36,45,32,,45,247,189,,201,,193,,78,65,64,70,
     101,,43,29,24,46,31,21,,29,,31,,,31,,,,,,,,29,,,,32,39,,,26,,,26],
   [,,,,58,70,71,,,,,,,46,43,68,58,,,,,69,,,,67,52,45,,54,48,,48,,338,,200,,,,
     ,44,78,38,,55,,,,65,63,,67,404,376,266,352,,266,58,43,39,57,51,39,,
     69,41,38,70,43,35,71,39,,,,45,66,56,,,,,39,79,41,44,,,,48,37,45,,57,
     36,,42],[,,,,,,,72,,,,,,74,71,84,59,,75,95,,77,52,,67,67,48,49,50,
     62,62,76,52,,367,446,,,,,,62,79,,,53,,56,,68,,,82,451,518,478,534,,514,
     73,54,68,54,82,58,,89,57,,93,58,48,,56,,,,,,73,92,78,,,58,60,61,73,,,
     68,78,,68,,58,,,51,,,,63],
   [,,,,41,,34,57,,,,,,,45,,45,,45,69,,,,,,41,47,45,,37,55,64,45,,287,837,
     197,,,,,36,67,37,,36,,,,53,,,67,347,665,257,479,,292,101,49,39,44,65,
     45,,73,,39,71,39,35,73,35,,,,57,53,68,53,,,,39,43,38,43,,,,43,39,43,,
     ,39,39,45,,,39,45,85],
   [,323,,348,410,133,,,,,,,,74,,110,63,,100,,,,348,,302,181,285,210,,316,212,
     ,243,,96,96,46,,,525,,109,133,83,,92,,,,,471,,,500,,354,,,450,350,308,
     278,248,368,331,,92,65,50,95,65,48,94,63,,168,,,,,160,,,,59,86,,,,,133,
     76,56,79,251,,228,,,,,205,,446,303],[],
   [,,,,,,277,95,,,,,,40,49,54,58,,49,54,,54,327,,297,146,176,117,213,161,,
     199,144,,,46,30,,,,,71,76,52,,117,,71,235,76,284,,76,327,331,210,,,210,
     242,229,182,192,271,185,,86,40,30,,40,30,87,40,,,,136,,629,,,,,39,35,
     42,47,,,42,47,39,47,161,,,200,172,,,,,489,195,53],[],
   [,,,,,,,15,36,,,,,8,9,10,8,,9,10,,10,,,,24,33,23,,,24,36,29,,,50,30,,,,,
     13,14,10,,12,,13,,14,39,,14,,,42,63,,42,,42,37,33,41,38,,,8,6,,8,6,,
     8,,,,29,16,42,16,,,,,7,8,9,,,8,9,7,9,,,27,24,34,,,24,38,,39,50,,30],
   [,46,,,,21,32,17,,,,,,,,,9,,9,,,,,,39,27,,26,25,,23,53,29,,80,63,35,,,26,,
     ,,12,,14,,14,31,,30,,,94,76,49,,,49,65,42,37,,40,36,,16,16,7,16,16,
     7,16,16,,15,,,,,17,27,,,8,7,,,,,8,17,8,,25,53,28,,,,,23,39,53,37,80,,
     35,,7],[],[,48,,55,48,25,45,25,,,,,,8,14,,10,,,10,,10,49,,49,30,
     37,31,47,49,31,42,41,,66,85,40,,,,,15,,13,,15,,15,70,15,,,15,82,,56,,
     ,56,56,52,48,41,,48,,17,8,8,17,8,8,17,8,,,,,,,22,54,,,9,,,,,,,9,9,
     9,48,82,,29,,,,32,44,78,38,,,40,,8],[]],
 [,[],[],[],[,12,,18],[],[],[,,,,,10],[,,,18,18],
   [,18,,24,,,,,24],[6,,,,,,,8],[,,,,15,,,11,,23],[,,,,31,,,14],
   [6,12,,20,12,10,,10,20,20,6,4,10],[,17,,,19,,,10,,,7,5,11],
   [,19,,54,33,18,,14,46,,8,6,12],[,,,,15,,,11,,23,,4,,4,5,6],
   [,,,,30,,,14,,,,,9,10,11,12],[,13,,,11,11,,,,19,7,5,11,,5,,5,11],
   [,27,,,43,,,12,,,8,6,12,,,6,6,12],
   [,,,,30,,,14,,,,,9,10,11,12,,9,11,12],
   [,18,,56,28,18,,12,48,56,8,6,12,,,6,6,12,,6,12],
   [12,,,,17,20,,,,22,12,,,12,,40,,,,,28,36],[],
   [,17,,,23,50,,,24,28,,23,,20,24,28,23,,20,37,53,30],
   [12,,,,,15,,15,26,26,11,,29,10,,,,29,12,26,,28,12,,18],
   [18,32,,40,26,22,,22,40,34,16,25,28,,15,,25,28,17,34,34,34,16,,23],
   [12,20,,28,,,,20,28,,12,16,20,12,15,20,16,20,15,20,20,20,12,,19,12],
   [,,,,,,,17,,,,21,,14,,24,21,,16,,,24,,,,12,16],
   [18,23,,29,17,,,30,29,22,,21,33,18,23,34,21,37,20,36,41,36,16,,22,,18]
    ,[,,,,,17,,,,,13,15,23,14,13,18,15,23,,,23,20,,,,12,16,,14],[],
   [18,30,,37,23,22,,22,,28,16,21,32,22,17,38,21,32,17,34,40,30,16,,22,,
     14,19,16,18,16],[18,23,,29,,,,28,29,,,,47,18,21,26,,,18,28,,28,16,,
     22,18,18,,,16,,,18],
   [30,,,,,54,,54,142,151,27,,,24,29,,,,31,50,65,64,60,,,54,86,60,93,,116,,,
     91],[30,,,132,81,,,,,136,27,,,24,,,,,33,72,,52,60,,105,52,,60,82,99,,,
     ,100,26],[30,89,,158,,,,52,166,128,25,20,45,20,25,30,20,45,25,30,
     45,30,60,,106,54,86,60,,,108,,85,96,23,23],
   [30,,,,,50,,,108,,27,,,24,,64,,,31,50,,,60,,,52,74,60,81,82,80,,74,82,23,
     26,23],[6,,,,13,8,,8,20,,5,,,6,7,8,,,7,8,,8,12,,,10,14,12,12,17,
     12,,14,17,27,27,25,27],
   [,,,,20,,,,20,29,,,,20,21,30,,,,,,32,,,,,44,30,,32,,,37,34],
   [,,,,31,16,,16,46,,,,,12,13,14,,,13,14,,14,,,,,31,23,25,38,25,,37,,,84,
     52],[6,11,,16,11,8,,8,16,16,6,8,10,6,,,8,10,7,14,10,,12,,17,10,,
     12,12,16,12,,22,16,30,30,30,30,6,18,12],
   [,25,,,33,16,,18,,,7,9,11,,,,9,11,,8,11,8,48,,33,,,23,22,38,20,,37,31,
     73,,35,57,7,,13],[6,,,24,,,,8,24,24,5,7,9,6,7,8,7,9,7,8,9,8,12,
     ,19,11,16,12,,,13,,16,19,27,27,25,27,5,,11,6,7],
   [,24,,29,,,,,25,24,,22,,20,21,30,22,,21,,,32,30,,35,32,36,,,,,,34,28,
     181,144,,112,,20,,18],
   [6,,,,13,8,,8,20,,5,,,6,7,8,,,7,8,,8,12,,,10,14,12,12,17,12,,14,17,
     27,27,25,27,5,,,6,7,5],
   [,,,,31,16,,16,46,,,,,12,13,14,,,13,14,12,14,,,,,32,23,25,38,25,,41,,,,
     52,,,,10,12,13,11],
   [6,15,,,15,8,,,,,6,8,10,6,7,14,8,10,,,10,14,12,,21,11,16,12,13,17,,,
     16,17,30,30,30,30,6,,12,6,,6,,6,12],
   [,,,24,20,,,,,29,,,,20,21,30,,,,,,32,,,32,,44,30,,32,,,37,34,183,143,164,
     120,,16,,18,,,20],[,25,,,33,16,,,,,7,9,11,,,8,9,11,,,11,8,,,36,27,,
     23,21,39,19,,33,33,59,81,35,59,7,,13,,7,7,,7,13],
   [,24,,29,,,,,25,,,25,,20,21,30,25,,19,,,32,30,,35,32,40,,,26,,,32,,,143,
     136,114,,20,,18,,,16,,,,20],
   [,,,,31,16,,16,46,,,,12,12,13,14,,12,13,14,,14,,,,,32,23,25,38,25,,41,,
     82,,52,83,,,10,12,13,11,,,10,12,,13],
   [,25,,,33,16,,14,,,7,9,11,,,8,9,11,,8,11,,48,,33,,,23,22,38,22,,37,31,
     57,61,35,73,7,,13,,7,7,,7,13,,,7,,13],
   [42,,,,100,66,,72,158,,37,,,32,39,60,,,,76,85,58,84,,,74,113,84,138,124,
     116,,113,123,166,166,154,164,37,,,42,,37,169,37,,42,173,71,211,103,73]
    ,[42,88,,,88,64,,64,148,146,37,32,,32,,,32,87,41,60,83,58,84,,132,72,
     ,84,104,129,106,,119,,166,166,154,166,37,154,,42,,37,152,37,,42,152,
     71,152,102,71,34],
   [42,,,154,,,,,172,174,35,28,63,28,35,42,28,63,35,42,63,42,84,,,74,,84,,,
     114,,112,127,158,160,140,158,35,164,72,42,49,35,,35,72,42,164,49,204,
     72,49,31,31],[42,,,,,68,,66,144,134,37,,,32,39,,,,39,64,,64,84,,,72,
     102,84,110,114,112,,102,114,164,166,156,166,37,,,42,73,37,144,37,,42,
     146,91,154,105,,31,34,31],
   [42,91,,,97,66,,,,,37,,83,30,41,60,,85,,,83,60,84,,137,74,115,84,,123,,,
     112,123,168,166,154,168,37,169,103,42,71,37,213,37,101,42,,,213,102,
     73,34,31,31,34],
   [42,79,,133,79,56,,56,133,133,35,28,63,28,35,42,28,63,35,42,63,42,84,,
     133,70,,84,84,129,84,,,130,160,158,140,160,35,124,70,42,49,35,124,35,
     70,42,124,49,124,70,49,31,31,28,31,31],
   [18,,,,28,35,,30,30,33,22,,,22,21,40,,,21,,44,40,18,,,22,26,22,34,26,,,
     26,26,98,104,98,90,18,,,20,39,20,40,18,,18,38,41,40,41,41,134,142,
     134,126,134,142],[24,,,37,36,29,,29,43,43,21,,47,18,,,,47,22,42,,40,
     22,,27,18,,22,23,26,23,,22,28,102,96,102,96,18,48,,18,,21,48,18,64,
     21,,41,51,63,51,138,132,138,132,138,126,22],
   [24,28,,33,,,,35,39,31,22,24,38,24,24,34,24,38,24,36,38,34,22,,27,22,
     26,20,,,34,,29,24,106,108,104,104,21,38,42,22,35,20,,21,42,22,42,35,
     36,42,36,146,148,144,144,146,148,22,22],
   [18,,,,26,22,,22,,31,16,,,16,17,32,,,17,34,39,34,18,,,18,22,20,19,24,19,
     ,22,24,81,83,82,74,14,,,16,,16,40,14,,16,40,33,40,38,33,109,110,
     110,102,109,110,18,18,20],
   [18,23,,28,28,41,,,,33,22,24,,22,21,44,24,41,,,44,52,18,,23,22,26,22,
     38,26,,,26,26,98,104,98,90,18,34,38,20,43,20,38,18,38,18,,,38,37,
     57,134,142,134,126,134,142,18,22,22,18],
   [24,35,,37,35,29,,29,46,37,21,26,37,18,23,28,26,37,22,34,37,28,22,,
     27,18,22,22,23,29,23,,,26,102,96,102,96,18,42,38,18,33,21,48,18,38,
     21,48,33,42,38,33,138,132,138,132,138,126,22,18,22,18,22],
   [24,28,,33,32,31,,37,35,,22,27,46,24,,46,27,46,23,44,,42,22,,27,22,28,
     20,,24,36,,26,,106,108,104,104,21,40,65,22,41,20,38,21,65,22,42,41,,
     ,43,146,148,144,144,146,148,22,22,20,20,22,22],
   [18,,,,33,18,,20,,58,13,,,14,15,16,,,15,16,27,16,32,,,29,40,28,,47,31,,
     40,,65,65,57,65,13,,,16,17,13,71,13,,16,45,17,,28,17,87,87,79,87,
     87,79,49,51,50,40,49,47,54],
   [18,34,,52,34,20,,20,52,52,16,12,24,8,,,12,24,13,10,24,10,32,,50,30,,
     28,26,46,26,,43,46,64,60,40,64,16,36,28,14,,12,38,16,28,14,38,14,
     36,28,14,80,80,56,76,78,56,54,46,48,40,50,38,56,14],
   [18,,,48,,,,14,60,48,13,10,21,8,9,10,10,21,9,10,21,10,28,,49,24,30,20,
     ,,22,,26,38,46,49,30,46,13,34,26,12,13,9,,13,26,12,,13,34,26,13,
     58,58,42,61,58,42,38,40,34,32,40,34,40,12,8],
   [18,,,,33,18,,20,54,52,13,,,14,15,16,,,15,16,,16,32,,,29,40,28,,43,31,,
     40,39,65,65,57,65,13,,,16,17,13,68,13,,16,42,17,,28,17,87,87,79,87,
     87,79,46,51,50,40,46,47,54,11,14,12],
   [18,43,,68,41,,,,,,16,12,24,8,13,10,12,24,,,24,10,32,,54,32,34,28,30,
     48,,,42,47,66,62,40,64,16,42,28,14,14,12,58,16,28,14,,,42,28,14,80,
     78,56,76,80,56,52,52,46,42,48,44,54,14,8,8,14],
   [18,29,,34,17,12,,14,50,34,13,10,21,8,9,10,10,21,9,10,21,10,28,,41,
     22,30,20,18,28,20,,,36,47,48,30,47,13,32,24,12,13,9,30,13,24,12,
     26,13,32,24,13,59,58,42,60,58,42,40,34,36,30,42,28,42,12,8,6,12,8 
    ],[18,39,,52,33,18,,20,54,,13,13,27,14,15,16,13,,15,16,,16,32,,45,
     29,46,28,,44,31,,45,,65,65,57,65,13,,,16,17,13,68,13,28,16,42,17,,,
     17,87,87,79,87,87,79,49,51,50,43,49,47,54,11,14,12,11,14,12],
   [18,,,52,35,20,,18,52,52,16,12,24,8,13,10,12,24,13,10,24,,32,,,30,30,
     28,26,44,28,,38,44,64,58,40,64,16,34,28,14,14,12,36,16,28,14,36,
     14,34,28,,78,80,56,76,80,56,50,46,44,38,46,38,52,14,8,8,14,8,8,14 
    ],[,,,,,,,,,,,,,12,13,18,,,17,27,,19,,,,12,18,,,,,,18,,,,,,,,,12,17,,,,,15,
     ,20,,,17,,88,,,,79,,23,,,,23,32,,34,,,41,29,,35],
   [,,,,,,,,,,,,,10,11,18,,,,,,18,,,,26,28,20,,27,,,24,29,,,48,,,,,10,,,,,,,,,,,,,
     ,64,,72,56,,40,35,,28,32,37,,18,12,,18,18,,18],
   [,,,,,,,,,,,,,20,,48,,,,,,,,,,24,30,,,,,,30,,,129,166,,,,,20,37,24,,,,,,,,,38,,
     146,,,156,133,,24,,,,24,,,52,60,,,50,58,52],
   [,,,,,,,,,,,14,31,12,11,28,14,31,19,,30,,17,,28,12,17,20,15,24,19,,20,
     23,82,,89,,11,,28,12,29,,,11,28,15,,31,,28,29,109,88,111,101,120,79,
     28,23,31,16,28,23,28,37,34,23,37,,17,36,,12,,18],
   [,,,,,,,,,,8,11,14,10,,12,11,14,10,16,14,12,20,,29,,36,,,,,,,,50,48,52,
     50,8,24,15,10,13,8,24,8,15,8,24,15,24,15,13,66,64,64,,,56,35,40,,
     35,41,32,31,20,18,14,20,22,14,20,20,,10],
   [,,,,,,,,,,,,,20,19,56,,,,,,54,22,,35,24,18,28,24,28,20,,16,30,124,118,,
     108,16,,39,20,,24,,16,40,,,49,,40,,166,145,174,148,,133,33,24,33,21,
     33,21,35,52,52,48,,,34,,52,18,,24],[],[],
   [,,,,,,,,,,,,,20,25,48,,,,,,46,22,,33,,16,28,20,30,24,,18,28,140,136,124,,,
     ,,20,,24,,,,,,35,,,,160,144,,134,168,133,33,21,39,21,33,24,33,54,52,
     60,54,68,50,58,52,18,,24,,,18],
   [,,,,17,10,,10,26,,,,,8,9,10,,,9,10,,10,,,,,20,15,15,22,15,,,,,,32,,,,,8,
     9,7,,,,8,,9,,,9,,49,44,,,42,,28,26,,22,22,29,,20,18,,20,16,,20,12,,,
     14,9,20],[,,,,19,12,,14,,,,,,10,11,12,,,11,12,,12,,,,29,28,20,,27,21,
     ,24,51,,,37,,,,,12,13,9,,,,12,28,13,,,13,,,51,,71,51,,41,34,,,31,44,,
     10,8,,10,8,,10,,12,,,14],
   [6,,,,,8,,,,,6,5,14,6,5,14,5,14,5,14,14,14,12,,18,11,26,12,13,,,,,,27,
     27,25,27,6,18,15,6,15,6,18,6,15,6,18,15,18,15,15,37,37,35,37,37,
     35,22,21,22,20,22,21,22,16,16,7,16,16,7,16,16,,8,,,,,,,,7,8],
   [8,17,,26,,10,,10,,26,7,6,15,8,7,18,6,15,6,18,15,18,15,,23,,19,15,15,
     ,15,,,22,,37,32,,7,21,16,8,19,7,21,7,16,7,21,19,21,16,19,50,49,
     44,51,49,42,22,27,26,18,,22,26,17,20,8,17,20,8,17,20,14,9,20,12,,,,
     ,20,8,9],[,19,,,,14,,,,,8,7,16,10,11,8,7,16,11,7,16,7,32,,33,,
     38,20,21,,,,,37,59,,37,,8,32,17,12,9,8,32,8,17,12,32,8,32,17,8,79,
     ,51,,,51,44,41,34,38,46,31,,18,10,9,18,9,9,18,9,,14,,,12,,,,,9,10],
   [8,12,,20,14,,,9,,20,,,,8,9,10,,,9,10,,10,15,,19,13,19,15,,19,15,,19,
     23,37,,32,,6,20,15,7,8,7,19,6,15,7,19,8,20,15,8,49,50,44,50,49,
     42,22,25,26,19,21,25,26,20,20,18,,20,16,,20,,10,26,17,10,,,,26,7,,
     7,8,9],[,,,,19,,,14,,,,,,10,11,12,,,11,12,,12,,,,29,28,20,,33,21,,24,
     ,57,63,37,57,,33,,12,13,9,,,,12,,13,33,,13,73,85,51,81,,51,44,43,
     34,36,48,31,44,16,9,8,16,9,7,16,9,,12,,19,14,,,,,,8,8,9,10],
   [,14,,,12,9,,,20,,7,6,15,8,6,18,6,15,7,18,15,18,,,20,13,19,15,15,19,,
     ,19,20,37,39,32,,7,19,16,7,19,7,19,7,16,8,20,19,20,16,19,49,,44,
     49,,42,21,25,26,19,22,25,29,17,20,8,17,20,8,17,20,17,10,,,10,26,,,,
     8,9,,7,,8,9],[,19,,,,14,,12,,,8,7,16,10,11,7,7,16,11,8,16,7,,,28,
     ,38,20,21,,20,,,28,,61,37,57,8,28,17,12,8,8,28,8,17,12,28,9,28,
     17,8,73,71,51,87,73,51,,,34,38,46,31,44,18,9,9,18,10,9,18,9,19,14,
     ,,,,,,,9,10,,,8,9,10],
   [,,,,,12,,14,,,,,,10,11,12,,,11,12,,12,32,,,,38,20,20,37,21,,30,,71,,37,,,
     ,,12,13,9,33,,,12,,13,,,13,73,71,51,73,79,51,44,,34,38,46,31,,16,9,
     7,16,9,8,16,9,,,,19,14,,,,,,8,8,9,10,,8,9,10],
   [,,,,,14,,12,,,8,7,16,10,11,7,7,16,11,7,16,8,,,,29,28,20,21,51,,,,27,
     71,,37,,8,28,17,12,8,8,28,8,17,12,28,8,28,17,9,73,73,51,75,71,51,
     40,43,34,,44,31,44,18,9,9,18,9,9,18,10,19,14,,,12,,,,,9,10,,,8,9,
     10,,8,10],[,,,,15,,,,,24,,,,14,16,24,,,,,,24,,,,,38,24,,27,,,32,29,,
     87,108,,,,,14,,,16,,,,,,16,,,,108,132,,117,84,,,34,,32,40,36,,26,,,30,18,
     ,26,,,,,17,,,,,,,13,15,21,15,,15,21,20,21],
   [,,,,28,35,,,,35,,,,20,20,30,,,24,37,53,29,,,,22,26,22,32,26,,,26,27,,
     102,,,,,,20,30,19,51,,,21,,31,51,48,28,,132,136,,136,133,,22,22,,,22,
     23,,50,47,,52,41,,49,17,,,23,32,28,,,28,19,,26,21,,,,23,33,63,29],
   [12,,,,18,,,20,,24,12,,30,12,16,28,,,,28,,32,12,,23,12,23,12,25,17,23,,,
     17,60,60,60,60,12,,27,12,,12,28,12,27,12,,42,28,27,,84,84,84,84,84,
     84,22,22,22,17,22,22,22,32,36,26,32,36,26,32,36,18,20,24,,,,,,,15,
     32,12,,,,,15,,,32,,18],
   [,,,,19,,,,,20,13,14,23,14,,18,14,23,13,,23,20,,,26,27,38,24,,29,,,,27,
     95,80,,87,13,21,25,14,20,13,18,13,25,13,21,20,18,25,22,117,108,114,
     ,117,84,34,45,36,,,40,35,31,26,22,31,,20,31,28,,17,,,,,,,,15,21,,,,
     15,21,15,20,21,,14],
   [18,,,,24,,,29,,30,,22,33,18,18,36,22,37,23,36,41,34,16,,26,22,16,19,
     27,18,29,,16,18,95,,96,82,16,,35,18,36,,34,16,36,17,,36,36,36,36,
     127,128,128,114,128,130,26,22,23,21,26,21,23,46,46,29,43,48,28,47,
     44,23,28,29,17,,,,,22,20,27,,19,,22,28,,,33,,,22],
   [12,12,,,12,,,26,24,24,11,13,29,10,12,28,13,,,26,,,12,,22,12,17,12,,22,
     27,,17,,54,52,54,52,11,20,25,10,24,11,20,11,25,11,20,24,20,25,24,
     74,72,74,72,74,70,22,22,22,17,22,22,22,29,30,24,29,32,22,29,30,,
     15,26,,15,26,,,,13,29,11,13,,,,,29,,29,12,18,12,12],
   [18,,,30,17,,,24,,16,,16,46,22,17,22,16,,17,26,,30,16,,27,17,18,22,,16,
     32,,18,16,85,,85,74,16,24,35,14,25,16,16,16,35,16,24,25,16,35,25,
     113,118,113,102,117,134,26,23,22,21,26,23,21,43,43,34,36,42,36,36,
     38,,22,37,25,22,28,,,32,19,48,16,19,30,,,,24,,24,16,22,,16,18],[],
   [],[18,,,,23,,,27,,28,,,,18,19,28,,,21,28,,26,16,,27,,16,19,29,18,27,,
     16,18,92,,,82,16,,55,18,28,19,38,16,,17,,30,36,,28,124,130,127,114,
     123,128,26,21,23,21,26,22,23,42,46,38,39,48,36,,44,23,30,29,,,22,,,,
     19,,,20,33,,,22,,,27,,22,,,16,18,18],
   [18,18,,30,18,36,,28,30,18,26,19,28,,17,,19,36,15,34,36,,16,,26,17,18,
     ,38,16,38,,18,16,86,102,86,74,16,24,31,14,29,16,16,16,31,16,24,29,
     16,31,29,113,126,,102,122,,26,25,22,22,26,24,23,47,,30,40,34,30,40,
     30,32,22,40,23,22,34,,,28,19,28,16,19,38,20,38,20,28,38,28,16,23,
     18,16,18,,14,,,18],
   [30,76,,126,83,56,,,128,140,27,25,73,24,,48,25,,31,,69,50,60,,101,54,
     87,60,,95,93,,85,,26,26,22,24,27,181,,30,59,27,183,27,82,30,,57,139,
     84,,166,166,158,164,168,160,98,102,106,81,98,102,106,65,64,46,65,66,
     47,65,64,80,50,128,,,,,,151,38,59,27,,,37,,37,59,57,65,93,108,60,,,
     54,85,,,95,87],[30,67,,,,48,,54,123,,27,24,65,24,31,54,24,75,,,,72,
     60,,103,52,102,60,80,,87,,,,23,24,23,24,27,144,,30,81,27,143,27,,30,
     143,61,,85,61,166,166,160,166,166,158,104,96,108,83,104,96,108,65,60,
     49,65,62,48,65,58,,54,,67,48,123,,,,38,61,27,,63,,,38,,63,61,,102,60,
     82,100,52,,,,99,,26],
   [30,89,,124,,52,,48,,166,25,20,45,20,25,30,20,45,25,30,45,30,60,,107,
     54,,60,110,93,,,84,,23,22,20,23,25,,52,30,35,25,164,25,52,30,136,35,
     168,52,35,154,154,140,156,154,140,98,102,104,82,98,102,104,57,40,30,
     57,40,30,57,40,,52,128,89,,166,,,158,32,37,25,32,37,32,37,32,37,37,
     37,88,102,60,108,96,54,85,,,96,,23,23],[],
   [,,,,21,15,,17,,37,,,,8,9,10,,,9,10,,10,,,,,37,24,23,32,23,,29,59,,53,
     30,,,,,14,15,11,31,,,14,30,15,26,,15,,,42,,63,42,,,39,,46,36,44,,8,6,
     ,8,6,,8,,,,20,17,,,,,,,7,8,9,,7,8,9,7,9,20,,,22,32,27,53,,,,28,52,,
     30],[6,13,,20,,8,,8,,20,6,5,12,6,5,14,5,12,5,14,12,14,12,,18,10,
     22,12,12,,12,,,18,27,27,25,27,6,18,13,6,15,6,18,6,13,6,18,15,18,
     13,15,37,37,35,37,37,35,21,18,21,17,21,18,21,14,16,7,14,16,7,14,
     16,11,8,20,,,,,,20,7,8,5,,,7,8,6,,8,,13,20,12,,,11,16,,,20,16,27,
     27,25,,7],[],[,20,,,,17,,21,,,7,6,13,8,13,6,6,13,13,6,13,6,50,,
     31,27,37,24,23,59,23,,,32,,52,30,51,7,31,14,14,7,7,28,7,14,14,31,
     7,29,14,7,63,,42,,,42,57,42,39,,,36,59,15,8,8,15,8,8,15,8,21,17,
     53,,,,,,,8,9,,,,8,9,,7,9,7,22,33,,20,,,24,,,32,31,,54,30,,8],
   [6,,,20,11,,,8,,20,5,,,6,7,8,,,7,8,,8,12,,22,11,16,12,,20,13,,16,,27,
     27,25,27,5,19,12,6,7,5,19,5,12,6,19,7,19,12,7,37,37,35,37,37,35,
     21,21,21,16,21,21,21,13,16,13,13,16,13,13,16,,8,20,13,8,,,,20,6,,
     6,7,8,,,7,8,,8,12,18,12,12,18,10,,,,,22,27,27,25,,,6,,7],
   [,,,37,20,21,,17,,,,,,8,9,10,,,9,10,,10,50,,,27,28,24,26,32,22,,25,,52,
     ,30,,,26,,14,15,11,,,,14,31,15,30,,15,62,62,42,66,,42,45,42,36,35,,
     36,,13,8,6,13,8,6,13,8,,15,,21,17,37,,,,,7,7,8,9,,,8,9,7,9,25,,
     47,23,31,,,,,,37,53,,30,,6,7,,8]],
 [,[],[],[],[],[],[],[,,,,,10],[],[],[],[],[,,,,,,,72],
   [,,,,,36,,36,,,,,72],[,,,,,,,27,,,,,60],[,,,,,58,,49,,,,,82],
   [,,,,,,,25,,,,,,19,20,29],[,,,,,,,36,,,,,,25,,39],
   [,,,,,33,,,,,,,59,,21,,19,25],[,,,,,,,38,,,,,66,,,33,32],[],
   [,,,,,52,,38,,,,,68,,,27,26,36,,30],[],[],[],
   [,,,,,10,,10,,,,,,17,,,,51,21,49,,49],
   [,,,,,12,,12,,,,,102,,23,,32,32,25,60,,64],[],
   [,,,,,,,9,,,,,,26,,44,28,,27,,,42,,,,8,9],[],
   [,,,,,9,,,,,,,65,26,22,34,22,31,,,,36,,,,8,9,,8],[],
   [,,,,,12,,12,,,,,98,27,25,53,29,44,25,52,,46,,,,,9,,9,,9],[],[],
   [,,,,,52,,,,,,,894,90,,,102,,,,,182,,,,35,,,,,42],[],
   [,,,,,48,,48,,,,,,90,,200,,,138,270,,,,,,35,42,,,,,,42,,,33],[],[],
   [,,,,,61,,61,,,,,,46,47,54,,,47,58,,56,,,,,56,,53,,53,,94,,,280],
   [,,,,,26,,26,,,,,67,16,,,19,25,20,52,,,,,,17,,,21,,21,,27,,,86,,86,,,46],
   [,,,,,41,,55,,,,,79,,,,30,37,,31,,28,,,,,,,36,,35,,56,,,,,179,,,72],
   [,,,,,,,24,,,,,,22,19,32,20,28,21,32,,28,,,,20,24,,,,21,,24,,,121,,112,,,
     46,19,29],[],[,,,,,22,,22,,,,,,17,17,27,,,17,28,,24,,,,17,22,,19,,
     19,,22,,,84,,74,,,,17,27,16],
   [,,,,,38,,38,,,,,,,27,,,,27,42,,38,,,,54,,,33,,33,,,,,237,,,,,,,41,26],
   [,,,,,24,,,,,,,54,22,19,58,18,24,,,,48,,,,20,24,,21,,,,24,,,,,120,,,46,19,,
     18,,16,26],[],[,,,,,43,,,,,,,89,,,29,31,39,,,,29,,,,49,,,36,,33,,49,,
     ,241,,192,,,53,,32,31,,29],[],[],
   [,,,,,40,,42,,,,,76,,,29,29,37,,30,,,,,,,,,35,,38,,57,,,195,,176,,,69,,29,
     28,,27,37,,,31],[,,,,,108,,120,,,,,,226,217,396,,,,334,,432,,,,172,140,,
     121,,94,,,,,639,,,,,,213,,173,,,,170,,462,,,438],
   [,,,,,71,,,,,,,,122,,,134,226,182,,,232,,,,49,,,56,,55,,61,,,230,,224,,,352,
     118,,152,,112,,173,,255,,,241,100],
   [,,,,,,,,,,,,,196,179,298,426,288,176,298,,281,,,,172,140,,,,94,,206,,,,,432,,
     ,708,178,285,164,,176,,169,,292,,,279,100],
   [,,,,,64,,64,,,,,,122,147,,,,168,298,,208,,,,49,58,,53,,53,,58,,,228,,210,,,
     ,118,232,154,,102,,144,,258,,,,,45,90],[],
   [,,,,,62,,64,,,,,460,114,138,200,134,184,135,232,,196,,,,49,,,51,,51,,,,,
     230,,224,,,410,114,,124,,108,239,124,,221,,,207,142,45,142,45],
   [,,,,,22,,24,,,,,,42,41,72,,,39,,,76,,,,21,22,,21,,,,22,,,99,,,,,,40,72,38,,
     ,,38,,95,,,,167,130,173,,,131],
   [,,,,,10,,10,,,,,65,17,,,,35,21,41,,37,,,,7,,,8,,8,,8,,,35,,35,,,,17,,20,,
     17,41,20,,39,,,52,101,49,101,49,,49,19],
   [,,,,,,,22,,,,,98,40,40,62,40,,38,64,,58,,,,21,22,,,,19,,22,,,99,,176,,,
     80,38,61,34,,,58,36,,61,,,66,175,130,167,176,,131,20,19],
   [,,,,,8,,8,,,,,,16,17,34,,,17,36,,36,,,,7,8,,7,,7,,8,,,32,,30,,,,16,,16,,
     14,,16,,35,,,35,,44,84,42,,44,,7],
   [,,,,,22,,,,,,,,42,39,64,40,71,,,,58,,,,21,22,,19,,,,22,,,99,,152,,,94,40,,
     36,,40,62,34,,,,,101,175,130,169,208,,131,16,19,20],
   [,,,,,10,,10,,,,,61,17,22,29,23,27,21,35,,29,,,,7,8,,8,,8,,,,,35,,35,,,
     62,17,35,20,,17,35,20,,34,,,35,97,49,101,49,,49,19,7,19,7,19],
   [,,,,,24,,22,,,,,104,42,,74,40,,39,74,,76,,,,21,22,,,,21,,22,,,99,,176,,,
     87,40,68,38,,,,38,,70,,,,167,130,181,184,,131,20,19,16,,20,19],
   [,,,,,86,,88,,,,,,96,81,106,,,77,97,,88,,,,,126,,,,79,,122,,,,,,,,,89,103,68,
     ,,,70,,115,,,98,588,697,804,,,,110,81,123,,120,77,124],
   [,,,,,65,,65,,,,,98,40,,,51,53,52,61,,47,,,,51,,,48,,48,,63,,,224,,212,,,
     80,40,,45,,45,58,45,,56,,,51,404,294,406,284,,272,88,45,88,42,90,41,
     90,92],[,,,,,,,42,,,,,99,52,46,62,46,56,43,60,,52,,,,45,52,,,,37,,42,,
     ,245,,204,,,79,44,56,34,,36,53,36,,61,,,53,310,,290,266,,224,64,39,
     62,34,66,35,66,69,43],
   [,,,,,,,52,,,,,,53,,67,,,43,,,60,,,,51,60,,58,,45,,60,,,220,,194,,,,49,63,
     42,,32,,40,,67,,,61,,282,369,258,,256,,43,,40,88,39,116,,49,40],
   [,,,,,,,,,,,,97,52,53,57,54,58,,,,50,,,,57,56,,49,,,,66,,,354,,276,,,82,46,
     55,42,,46,58,42,,,,,52,408,410,408,326,,302,88,51,86,44,86,47,90,76,
     43,43],[,,,,,44,,42,,,,,137,40,45,50,42,48,39,64,,48,,,,39,49,,33,,
     35,,,,,168,,158,,,79,38,58,36,,36,59,36,,58,,,55,328,218,296,210,,198,
     66,33,64,32,68,29,66,82,37,33,35,43],[],
   [,,,,,60,,54,,,,,94,40,48,51,48,50,49,58,,,,,,51,48,,46,,50,,58,,,216,,
     198,,,78,40,52,42,,42,54,42,,55,,,,402,286,392,266,,264,84,45,84,40,
     88,41,88,78,37,40,46,40,37],[],[],
   [,,,,,,,,,,,,,20,,42,,,26,,,52,,,,11,12,,,,,,12,,,46,,,,,,20,40,24,,,,24,,44,,
     ,,,62,,,,62,,11,,,,11,,,42,36,,,32,,40],
   [,,,,,,,,,,,,,,,35,19,28,22,40,,36,,,,,,,10,,10,,,,,,,40,,,51,,31,,,16,29,20,
     ,34,,,35,124,93,124,56,,,24,17,24,8,24,17,24,,47,40,40,60,34,,48,,,
     10],[],[,,,,,,,,,,,,,21,,35,,39,,,,35,,,,11,,,11,,11,,10,,,57,,49,,,
     55,21,,25,,19,40,,,52,,,,129,71,146,67,,71,25,11,25,9,25,9,25,100,
     47,49,47,,37,,51,,,11],[],[],
   [,,,,,,,,,,,,,21,28,,28,41,31,,,45,,,,,10,,11,,11,,,,,53,,49,,,98,21,53,29,
     ,21,,29,,70,,,53,129,71,,67,,77,25,9,25,9,25,11,25,102,49,49,47,63,
     33,,51,,,11,,,11],[],[],[],
   [,,,,,28,,28,,,,,75,,,62,21,39,20,44,,42,,,,,,,23,,23,,,,,156,,111,,,60,,
     47,19,,17,40,19,,43,,,47,286,187,235,145,,,48,41,52,20,,,48,87,74,33,
     51,58,31,,54,,,20,17,,,,,36],[],
   [,,,,,,,27,,,,,,26,31,40,,,27,38,,38,,,,23,27,,,,24,,27,,,157,,165,,,58,21,
     34,,,19,36,21,,34,,,32,232,194,254,186,,353,46,23,47,19,43,23,48,96,
     64,74,,,91,,62,,,26,26,,,,,31,,,,22],
   [,,,,,,,42,,,,,,53,,67,,,43,,,60,,,,57,52,,,,37,,40,,,,,188,,,,45,64,,,,,36,,
     63,,,56,,324,645,250,,238,87,41,95,44,103,33,87,98,42,,48,44,30,,40,,
     ,36,36,,51,,,43,,,,33],
   [,,,,,27,,,,,,,73,26,22,52,23,35,,70,,48,,,,23,27,,24,,,,27,,,183,,153,,,
     58,21,53,21,,19,36,,,55,,,49,230,,,196,,229,47,23,50,19,48,23,43,85,
     64,35,47,82,33,,62,,,,,,31,,,,,,,22,,24,35],
   [,,,,,46,,,,,,,93,53,51,32,35,59,,,,30,,,,,56,,39,,,,,,,230,,222,,,78,45,
     33,32,,31,62,,,,,,31,,282,,284,,250,88,,82,40,78,33,88,105,44,46,71,,
     44,,42,,,48,,,43,,,,,,,,,38,49],[],[],[],
   [,,,,,16,,,,,,,,30,31,50,,,35,58,,50,,,,16,17,,17,,,,17,,,68,,,,,,30,49,28,,
     ,,32,,54,,,,,92,130,,,92,,15,16,,,15,16,,64,52,,66,46,,60,,,,17,,18,,,
     18,,,,34,,,,37,58],
   [,,,,,,,20,,,,,142,,,76,,46,,56,,54,,,,,,,14,,13,,,,,118,,62,,,66,,,26,,26,
     46,30,,80,,,,130,136,132,86,,,21,21,18,13,21,21,18,96,70,52,60,70,54,
     ,68,,,17,,,,,,,,,,,,,70,37,110,,,,14],[],
   [,,,,,,,22,,,,,,33,,49,30,47,36,59,,49,,,,16,,,15,,14,,15,,,,,71,,,70,32,
     50,,,29,47,32,,53,,,53,164,115,168,97,,111,22,15,19,14,22,13,19,131,
     71,60,67,83,50,,75,,,18,15,,,,,18,,,,31,,40,59,46,67,,,,15],
   [,,,,,,,,,,,,96,30,33,70,32,,,,,,,,,12,13,,12,,12,,13,,,54,,52,,,69,30,52,,
     ,28,46,,,51,,,50,176,74,,72,,74,20,11,20,11,20,11,20,,66,58,70,,54,,
     66,,,15,15,,16,,,16,,,,34,,,,,78,,,,12,12,,13],
   [,,,,,16,,24,,,,,,76,,82,44,,,,,172,,,,17,18,,,,15,,18,,,,,74,,,86,40,65,40,
     ,38,61,44,,65,,,67,181,121,173,102,,130,24,15,16,16,24,15,16,143,97,
     70,90,93,74,,103,,,22,22,,23,,,23,,,,47,,,,,86,,,,16,16,,17],[],[],
   [,,,,,,,22,,,,,225,33,37,,32,67,40,63,,51,,,,,15,,15,,14,,,,,87,,71,,,116,
     32,54,35,,31,,34,,83,,,57,156,113,164,97,,122,22,13,19,14,22,15,19,
     110,72,60,65,82,,,71,,,18,15,,18,,,,,,,35,,,65,41,,,,,15,,,15,13,17],
   [,,,,,18,,21,,,,,,,39,,34,70,43,104,,,,,,17,18,,19,,16,,18,,,102,,74,,,71,
     36,60,34,,34,65,37,,62,,,63,194,130,259,102,,122,24,15,16,16,24,15,
     16,,,75,76,93,74,,90,,,22,22,,23,,,23,,,,43,,50,,49,82,,,,16,16,,17,,
     14,,,17],[,,,,,,,,,,,,719,286,,434,242,,219,,,545,,,,,,,,,123,,190,,,,,94,,
     ,922,258,,183,,180,421,,,,,,,1372,1234,1334,,,1594,167,125,200,114,203,
     123,183,614,454,362,521,538,471,,,,,128,,,,,,,,,,,,,,283,,,,,158,146,,,162,,
     ,,198,217],[,,,,,53,,53,,,,,,90,128,190,105,186,159,,,190,,,,35,47,,41,
     ,41,,,,,34,,32,,,284,86,219,123,,84,,142,,201,,,191,583,230,,228,,230,
     98,35,98,32,98,35,98,724,222,244,220,336,166,,220,,,46,105,,53,,,53,,,,
     ,,,,161,,,,,68,150,,91,54,,,,85,,144],[],
   [,,,,,8,,8,,,,,,16,17,34,,,17,36,,36,,,,7,8,,7,,7,,8,,,32,,30,,,,16,,16,,
     14,,16,,35,,,35,,44,84,42,,44,,7,,6,,7,,,42,34,40,44,32,,40,,,,8,,9,,
     ,9,,,,20,,19,44,19,40,,,,,13,,14,11,16,,,14,16,114,32],[],[],
   [,,,,,10,,10,,,,,76,17,22,37,22,35,21,43,,37,,,,7,,,8,,8,,8,,,35,,35,,,
     51,17,42,20,,17,,20,,,,,42,111,49,,49,,49,19,7,19,7,19,7,19,94,47,
     41,47,53,35,,47,,,9,,,,,,9,,,,,,23,43,23,43,,,,14,,,,12,17,,,14,17,,35,
     ,7],[],[,,,,,,,8,,,,,,20,,34,22,,21,,,32,,,,7,8,,,,7,,8,,,32,,30,,,
     46,18,31,,,16,27,18,,31,,,29,126,44,126,42,,44,19,7,19,6,19,7,19,,
     42,,42,70,34,,40,,,8,8,,9,,,9,,,,19,,,,21,34,,,,12,12,,13,10,,,,13,22,
     ,32,,6,,,7],[],[]],
 [,[],[],[],[,9,,12],[,,4],[,12,,15],[,,4,,,4],[,,,12,12,,15],
   [,12,,15,,,12,,15],[6],[,11,,,13,14,15,,,17],[,,16,,,,44,16],
   [6,9,12,15,9,12,15,12,15,15,6,,16],[,,13,,17,,21,13,21,,7,5,13],
   [,,18,,21,24,28,18,34,48,16,,14],[,,13,21,17,,21,13,,21,,5,,7,5,13],
   [,37,18,39,21,24,31,18,47,37,,,12,,13,14],
   [,11,,,13,14,15,,,17,,5,,,5,,5],[,,16,,31,,,16,,,,,14,,,12,13,14],
   [,,16,,31,,44,16,,,,,12,16,13,14,,12,,14],
   [,,16,47,21,24,31,16,37,47,16,,14,,,12,13,14,,12,14],
   [12,,,,15,12,20,,,20,12,,,12,,42,,,,,30,42],
   [,,,,,6,,,,,,,,15,14,21,16,21,,,40,23],
   [,15,,,18,16,23,,,23,,19,,18,22,35,20,52,19,,45,44],
   [12,15,7,20,15,6,20,7,20,20,12,13,28,9,,,,25,13,28,28,25,12,5,15],
   [18,,10,28,33,8,28,10,28,28,18,18,28,,13,,19,22,18,40,28,34,13,6,16],
   [12,15,14,20,,,,14,20,,12,18,26,12,17,26,17,26,18,26,26,26,10,,13,12,
     13],[,,7,,,,,7,,,,19,,15,,29,16,29,19,,,29,,5,,5,6],
   [18,18,18,23,15,,,18,23,27,20,20,35,18,22,33,20,36,20,35,41,36,13,,
     16,15,16],[,,,,,6,,,,,,,,15,14,21,16,21,,,40,23,,5,,5,6,,5],
   [,15,,,18,16,23,,,23,,19,,18,,45,20,44,19,,39,52,,,13,15,16,13,,16],
   [18,33,10,28,,8,28,10,28,28,18,18,32,18,14,32,17,26,18,32,32,26,13,
     6,16,,6,13,6,16,6,16],
   [18,18,18,23,15,,27,18,23,,,22,45,18,22,35,20,52,22,39,,42,13,,16,15,
     16,,,13,,16,16],[30,,,,,32,98,,,,30,,,30,29,,31,76,,,82,82,54,,,49,
     72,54,47],[30,45,20,70,45,20,70,20,70,70,30,,82,30,,,29,,,82,84,,
     54,25,79,25,,54,25,79,25,79,,79,26],
   [30,69,,,,,,,,,30,25,64,30,25,64,25,64,25,64,64,64,54,,81,47,66,54,,,,
     82,70,82,26,26],
   [30,45,20,60,45,20,60,20,60,60,30,,80,30,,80,,,,82,82,,50,25,65,25,30,
     50,25,65,25,65,30,65,26,20,26],
   [6,,,,11,8,16,,,,6,,,6,7,16,7,16,,,,16,12,,,11,16,12,13,16,,,16,16,30,
     30,30,30],[,,,,16,,19,,,21,,,,19,19,38,19,41,,,,41,,,,28,38,26,,29,,,
     34,31,,84,,74],[,,,,25,18,34,,,,,,,16,15,16,,14,,,15,16,,22,,,23,29,
     22,38,22,,30,,,86,71,88],
   [6,9,10,12,9,8,12,10,12,12,6,8,12,6,,,7,12,8,18,12,,12,13,15,9,,12,
     11,15,13,15,18,15,30,30,30,30,6,16,14],
   [,,25,,25,18,34,25,,,,,17,,,,15,16,,15,,14,50,24,53,,,29,23,37,24,55,
     36,55,102,,71,88,,,15],
   [6,13,10,18,,,,10,18,18,6,8,12,6,7,12,7,12,8,12,12,12,12,14,16,10,
     14,12,,,14,16,14,18,30,30,30,30,6,,14,6,14],
   [,20,,21,,,,,21,,,23,,19,19,38,19,41,23,,,41,30,,31,28,38,,,,,31,34,,,84,
     ,74,,17,,16],[6,9,10,12,9,8,12,10,12,12,6,8,18,6,7,12,,,8,12,
     18,12,12,13,15,9,12,12,11,15,13,15,12,15,30,30,30,30,6,16,,6,14,
     6,16],[,,25,,25,18,34,25,,,,,15,16,15,16,,,,17,15,16,,24,55,27,28,
     29,23,37,24,55,36,55,96,92,71,,,,13,14,15,14],
   [6,,,,11,8,16,,,,6,,,6,7,16,7,16,,,,16,12,,,11,16,12,13,16,,,16,16,30,
     30,30,30,6,,,6,,6,,6],
   [,,,,16,,19,,,21,,,,19,19,38,19,41,,,,41,,,,28,38,26,,29,,,34,31,,84,170,
     74,,14,,16,,,17,16],
   [,,,,25,18,34,,,,,,,,,14,15,16,,,17,14,,22,,27,,29,22,38,22,,30,,,92,71,
     87,,,15,,13,14,,14,15],
   [,20,,21,,,16,,21,,,23,,19,19,38,19,41,23,,,41,30,,31,28,38,,,28,,31,34,
     ,,84,130,74,,17,,16,,,14,16,,,17],
   [,,19,,25,18,34,19,,,,,15,16,15,16,,14,,17,,16,,28,,,24,29,22,38,28,,27,
     ,,,71,86,,,13,14,15,14,,,13,,,15],
   [,,19,,25,18,34,19,,,,,17,,,14,15,16,,15,17,,50,26,55,,,29,23,37,26,55,
     36,53,96,86,71,88,,,15,,13,14,,14,15,,,13,,15],
   [42,,,,87,36,,,,,42,,,42,39,104,39,106,,,,106,74,,,61,82,74,75,107,,,78,
     106,180,168,174,168,42,,,42,,42,214,42,131,42,,,218,135,135],
   [42,63,28,94,63,28,94,28,94,94,42,44,,42,,,39,106,44,100,106,106,74,
     35,105,35,,74,35,105,35,105,46,105,176,140,166,140,42,112,112,42,,42,
     112,42,,42,112,112,112,117,112,34],
   [42,,,120,,,,,,,42,35,88,42,35,88,35,88,35,88,88,88,74,62,,59,84,74,,,
     62,109,84,112,178,164,160,162,42,154,97,42,97,42,,42,97,42,154,97,
     196,97,97,34,34],[42,63,28,84,63,28,84,28,84,84,42,41,100,42,39,,,
     ,41,100,102,,70,35,91,35,42,70,35,91,35,91,42,91,172,140,168,140,
     42,102,112,42,114,42,102,42,,42,102,114,102,114,,34,28,34],
   [42,,,,83,36,128,,,132,42,,,42,41,104,,108,,,,100,74,,,57,78,74,,106,,,82,
     108,180,164,174,168,42,,,42,133,42,222,42,152,42,,,222,154,154,34,34,
     34,34],[42,63,28,94,63,28,94,28,94,94,42,35,84,42,35,84,35,84,35,
     84,84,84,74,35,105,35,,74,35,105,35,105,,105,172,140,158,136,42,108,
     91,42,91,42,108,42,91,42,108,91,108,91,91,34,28,31,28,34],
   [18,,,,28,18,31,,,31,20,,,23,21,54,21,43,,,47,57,16,,,17,18,19,17,24,,,
     18,24,87,86,86,74,18,,,20,47,20,41,18,58,18,,,41,45,60,114,114,115,
     102,114,114],[24,27,13,36,27,10,36,13,36,36,24,23,44,15,,,,35,23,
     44,44,35,19,9,24,7,,19,8,24,9,24,8,24,83,35,85,35,21,48,,15,,18,
     48,15,40,21,48,40,48,47,47,103,49,97,49,99,49,17],
   [24,28,21,31,,,,21,31,,21,25,43,23,23,40,21,41,25,43,38,41,19,19,24,
     17,18,16,,,19,24,18,28,87,86,86,74,21,39,41,20,41,18,,18,42,21,39,
     41,40,42,42,114,114,115,102,114,114,17,17],
   [18,25,10,28,25,8,28,10,28,28,18,18,36,14,15,30,,,18,36,36,30,16,8,
     21,7,8,16,7,21,8,21,8,21,66,32,70,30,16,38,34,14,,14,38,12,,16,
     38,34,38,34,30,82,44,78,42,82,44,16,7,16],
   [18,,,,28,18,31,,,31,20,,,23,21,42,21,51,,,53,49,16,,,17,18,19,17,24,,,
     18,24,87,86,86,74,18,,,20,43,20,41,18,60,18,,,41,49,60,114,114,115,
     102,114,114,14,17,17,16],
   [24,27,13,36,27,10,36,13,36,36,24,23,36,15,20,27,20,27,23,36,36,27,
     19,9,24,7,8,19,8,24,9,24,,24,79,35,89,35,21,44,34,15,34,18,44,15,
     34,21,44,34,44,34,34,99,49,97,49,103,49,17,7,17,7,17],
   [24,28,21,31,33,16,,21,31,,21,27,47,23,,52,21,43,27,53,,57,19,19,24,
     17,18,16,,28,19,24,18,,87,86,86,74,21,41,45,20,47,18,,18,58,21,41,
     49,,,60,114,114,115,102,114,114,17,17,14,16,17,17],
   [18,,,,35,20,46,,,48,16,,,18,17,24,15,22,,,22,24,34,,,30,40,34,,48,,,40,
     ,78,78,76,78,16,,,18,29,16,72,16,27,16,,,,27,29,106,106,104,106,106,
     100,52,50,53,40,52,46,53],
   [18,27,26,39,27,24,39,26,39,39,18,16,24,16,,,17,24,16,22,28,22,34,31,
     46,27,,34,27,46,31,46,38,46,78,78,76,78,16,45,28,16,,16,45,18,28,
     16,45,26,45,30,26,106,106,104,106,106,100,55,41,55,36,55,37,55,16],
   [18,31,18,38,,,,18,38,38,16,11,22,16,9,22,9,22,11,22,22,22,28,25,35,
     21,28,20,,,25,35,24,35,53,55,35,57,14,34,27,12,27,10,,12,27,14,,27,
     34,27,27,71,71,49,69,71,49,38,35,32,28,38,31,38,15,15],
   [18,27,26,36,27,20,36,26,36,36,16,16,22,18,17,24,,,16,24,22,,34,31,
     43,27,34,34,31,43,31,43,34,43,78,78,76,78,16,42,26,18,28,16,42,16,
     ,16,42,28,42,26,30,106,106,104,106,106,100,50,41,50,34,50,37,50,14,
     16,15],[18,,,,33,,50,,,,18,,,16,15,22,17,24,,,24,22,34,,,30,36,34,
     31,47,,,40,47,78,78,76,78,16,,,16,27,16,72,18,29,16,,,,29,27,106,
     106,104,106,106,100,52,50,53,40,52,46,53,16,14,15,16],
   [18,23,18,28,15,12,22,18,28,28,16,11,22,16,9,22,9,22,11,22,22,22,28,
     23,33,19,28,20,17,27,23,33,,33,51,57,35,55,14,30,25,12,25,10,30,
     12,25,14,24,25,30,25,25,69,71,49,71,71,49,40,29,34,26,40,25,40,15,
     15,7,15,15],[18,33,24,54,33,20,46,24,46,,16,16,22,18,17,28,15,22,
     16,24,,24,34,50,46,30,40,34,,46,50,47,40,,78,78,76,78,16,,27,18,,
     16,72,16,27,16,,29,,,29,106,106,104,106,106,100,53,50,52,40,53,46,
     52,14,16,15,14,16,15],
   [18,27,24,36,27,24,36,24,36,36,18,16,24,16,15,22,17,,16,22,24,,34,33,
     43,27,30,34,27,43,33,43,34,43,78,78,76,78,16,42,28,16,26,16,42,18,
     30,16,42,26,42,28,,106,106,104,106,106,100,50,41,50,34,50,37,50,16,
     14,15,16,14,15,16],
   [,,,,,,,,,,,,,9,10,21,12,,,,,,,,,9,10,,,,,,10,,,39,,35,,,,9,,11,,9,42,,,,,,,,
     53,71,49,,53,,16,19,13,,16,19,,25,27,25,,23,,25],
   [,,,,,,,,,,,,,10,11,24,11,24,,,,24,,,,20,28,20,,26,,,24,30,,44,48,44,,,,10,
     ,,,10,,,,,,,,,60,64,60,,56,,36,34,28,,32,38,,24,12,24,,20,,24],
   [,,,,,,,,,,,,,14,,42,13,26,,,,,,,,11,12,,,,,,12,,,46,,44,,,,14,31,16,,12,,,,,,
     ,47,,62,,60,,62,,11,,10,,11,,,34,36,32,,30,44,32],
   [,,,,,,,,,,,17,,9,13,19,10,19,17,29,29,19,15,7,21,9,15,15,7,21,7,21,
     15,21,70,39,,35,13,,21,9,20,,,9,20,13,,21,,21,20,113,53,,49,83,53,
     22,16,22,8,22,16,22,,25,21,25,35,15,35,25,9,,10],
   [,,,,,,,,,,8,12,18,10,,18,9,18,12,20,18,16,20,,30,20,28,,,,,26,28,,,44,
     64,44,8,22,19,10,19,8,22,8,19,8,22,19,22,19,17,68,60,84,60,,56,
     34,36,,28,38,32,28,24,24,14,24,26,14,24,24,,10],
   [,,,,,,,,,,,,,14,13,28,,,,,,26,16,8,22,11,10,16,8,22,8,22,8,22,94,46,,
     44,,,31,14,,16,,12,,,,27,,47,,116,62,,60,,62,23,11,23,9,23,9,23,,34,
     36,32,,30,,32,10,,11],
   [,,,,,,,,,,,12,16,8,9,18,,18,12,18,20,18,,,,20,24,26,,30,,,28,26,,44,,
     44,8,22,17,8,19,8,22,10,19,8,22,19,22,19,19,,60,82,60,68,56,,36,
     38,28,,32,38,,24,14,24,24,14,26,24,,10,,,10],
   [,,,,,,,,,,,24,44,14,17,26,16,24,24,44,44,24,,,,11,12,,,,,,12,,,46,140,
     44,20,,30,14,26,,,12,25,20,,30,,30,25,124,62,,60,,62,22,9,22,10,22,
     9,22,52,34,,32,52,22,52,32,,,10,10,,11],
   [,,,,,,,,,,,,,14,15,42,16,,,,,40,16,8,22,11,8,16,8,22,8,22,10,22,,46,,
     44,,,,14,,16,,12,,,,47,,27,,120,62,,60,112,62,23,9,23,9,23,11,23,44,
     34,36,32,44,30,44,32,10,,11,,,10,,11],
   [,,,,13,10,18,,,,,,,8,9,18,,,,,,18,,,,,14,15,12,20,,,13,,,38,37,38,,,,8,
     17,8,,,,,,,,,17,,52,51,52,,49,,21,21,16,,22,21,,22,21,21,,19,22,22,10,
     ,,11,9,17,11,19,13],
   [,,,,23,12,34,,,,,,,20,11,30,,,,,,30,,,,24,30,20,,27,,,26,37,,,42,,,,,12,,
     10,54,14,,,,,,,,,78,58,78,,58,,40,35,32,,34,43,,18,9,,,9,,18,,12,,,14]
    ,[6,,,,,8,,,,,6,5,14,6,5,14,5,14,5,14,14,14,12,,18,11,26,12,13,,,,,,
     27,27,25,27,6,18,15,6,15,6,18,6,15,6,18,15,18,15,15,37,37,35,37,
     37,35,22,21,22,20,22,21,22,16,16,7,16,16,7,16,16,,8,,,,,,,,7,8],
   [8,,,18,,10,,,,18,7,6,17,8,7,18,6,17,6,18,17,18,15,19,21,,18,,13,21,
     19,19,,21,37,35,39,36,7,17,18,8,19,7,17,7,18,7,17,19,17,18,19,49,
     47,53,48,48,42,22,21,24,14,24,22,22,19,20,8,19,20,8,19,20,14,9,
     14,10,,,11,13,19,8,9],
   [,,,,,20,,,,,16,15,22,20,17,16,13,22,15,14,24,14,44,,47,51,48,,33,,,55,,
     ,91,,105,,16,42,23,18,17,14,42,14,23,16,42,15,42,25,15,115,121,141,
     117,,95,68,77,,64,62,57,,24,18,15,24,16,15,26,16,,20,,,16,,,,,17,18],
   [8,10,13,18,11,,13,13,,14,,,,,9,,,,,18,,,15,17,17,11,15,15,,17,17,17,
     15,19,38,44,37,44,7,17,18,7,16,8,15,7,18,7,17,16,16,18,16,52,55,
     51,58,52,49,22,19,21,15,21,19,22,21,24,21,,22,19,21,,,10,18,13,10,,
     ,18,18,8,,7,8,17],
   [,35,22,31,15,16,23,22,39,31,,,,,11,,,,,30,,,,27,44,23,24,20,21,28,27,
     36,20,44,56,70,42,62,16,25,,12,30,10,25,,,16,27,30,25,,30,78,86,58,
     78,86,58,41,33,33,28,49,25,41,19,17,9,19,17,8,19,17,,12,,15,14,36,
     18,20,34,,9,8,9,18],[],[],
   [,,,,,12,34,,,,,,,20,11,30,,,,,,30,32,,37,24,30,20,21,,,35,26,,,66,42,,,
     54,,12,,10,,14,,,,,54,,,78,78,58,78,78,58,43,40,30,32,45,34,,19,17,
     8,19,17,9,19,17,,20,,23,14,,,,,,9,8,9,18,,9],
   [,,,,,20,,,,,16,15,22,20,17,14,13,24,15,14,22,16,,,,51,48,,33,59,,,,47,
     95,103,,95,16,42,23,18,15,14,42,14,25,16,42,15,42,23,17,123,121,
     149,117,117,95,60,77,72,64,52,57,68,24,16,15,26,16,15,24,18,,20,,,
     20,,,,,17,18,,,15,17,18,,,18],
   [,,,,13,,16,,,18,,,,13,15,31,15,31,,,,31,,,,23,37,21,,24,,,,26,,59,115,59,
     ,,,13,,,14,13,,,,,14,,,,81,136,81,,77,,39,36,35,,35,38,,33,,33,,17,,33,
     ,,,,16,,16,,,,,13,13,31,12,19,,,,31],
   [,,,,25,14,28,,,28,,,,17,17,35,17,41,,,44,,,,,14,15,16,13,21,,,15,21,,61,
     ,59,,,,17,35,16,40,15,55,,,,40,41,,,83,102,81,,83,,14,14,13,,14,14,,
     43,36,41,,35,,41,13,,,16,34,17,,16,17,17,,26,21,53,,45,,,40],
   [12,,14,,15,,20,14,,20,12,,36,12,,28,,42,,30,,,12,11,18,12,18,12,11,15,
     11,18,18,15,54,54,54,50,12,,50,12,,12,30,12,,12,,,30,50,,74,74,74,
     70,74,74,19,19,16,11,19,19,16,34,34,28,34,34,28,34,34,15,26,16,,,,
     20,16,,18,32,12,,,,40,,,,38,,13],
   [,,,,17,,18,,,16,13,13,27,13,,25,13,25,13,,27,25,,,,23,37,25,,26,,,37,
     26,94,59,,59,12,19,27,13,27,12,16,11,27,12,19,25,16,27,27,116,81,
     130,81,,77,37,39,38,35,,35,36,35,33,21,33,,19,35,33,,16,,,,,16,,,13,
     21,,,,12,19,,,21,,13],
   [18,,17,,25,,28,17,,28,21,25,34,17,17,33,17,31,25,34,41,31,13,12,19,
     14,13,13,12,16,12,19,11,16,86,61,80,59,17,,33,17,33,,36,15,33,17,,
     33,36,34,33,109,83,,81,105,83,20,14,17,12,20,12,17,47,43,28,41,47,
     27,46,41,16,28,17,13,,,34,17,16,18,28,,17,,20,25,,,33,,,14],
   [12,9,8,15,9,8,15,8,15,15,11,,29,9,11,,11,,,29,29,,10,9,16,8,9,10,
     9,16,9,16,9,16,45,35,45,35,10,17,25,9,25,10,17,9,25,10,17,25,17,
     25,25,59,49,59,49,59,49,17,10,17,9,17,10,17,27,25,25,25,27,23,27,
     25,13,14,14,13,14,14,14,14,14,11,29,11,11,29,,,,,29,29,11,11,10,11,
     11],[18,12,12,20,15,12,12,12,20,12,16,,38,,15,,15,,,38,38,,13,13,
     21,11,12,16,13,13,13,21,12,13,66,,66,50,14,22,33,12,33,14,14,12,
     33,14,22,33,14,33,33,86,117,86,70,86,143,22,13,14,12,22,13,14,38,
     42,36,34,38,38,38,34,19,20,20,19,20,20,20,20,20,15,42,16,15,40,13,,
     ,,42,40,14,14,13,14,14],
   [,,,,17,,18,,,18,,13,43,11,13,25,,25,13,27,,25,,,,23,,25,,26,,,37,24,
     127,59,,59,12,19,27,11,27,12,16,13,27,12,19,27,16,25,27,116,81,,81,
     145,77,,39,38,35,37,35,38,51,33,21,33,35,19,,33,,16,,,16,,,,,15,,,15,,
     ,23,,,,,13,,,13,,11,14],
   [,,,,25,14,28,,,28,,,,17,17,49,,33,,,38,47,,15,,14,15,16,,21,15,,15,21,
     81,61,79,59,,,37,17,55,16,40,15,35,,,41,40,,39,100,83,104,81,105,83,
     19,12,16,13,19,12,16,46,43,36,41,46,35,45,41,13,,16,16,28,17,,,17,
     17,,,17,57,20,,,,40,,,13,13,,14,11,14],
   [18,,17,,25,,28,17,,28,,,44,17,,35,17,47,,38,,33,13,12,19,14,11,13,12,
     16,12,19,13,16,,61,,59,17,,55,17,37,17,40,15,,17,,,40,39,,100,83,
     108,81,102,83,20,12,17,12,20,14,17,45,43,36,41,45,35,,41,16,34,17,
     13,,16,28,17,,17,40,,17,,,37,,,,51,,14,,,13,11,14,,14],
   [18,12,12,20,15,12,12,12,20,12,16,,38,,15,,15,,,38,38,,13,13,21,11,12,
     16,13,13,13,21,12,13,66,,66,50,14,22,33,12,33,14,14,12,33,14,22,
     33,14,33,33,86,115,86,70,86,122,22,13,14,12,22,13,14,38,,36,34,38,
     38,38,34,19,20,20,19,20,20,20,20,20,15,42,16,15,40,,,,,42,40,14,14,
     13,14,14,,10,14,14,14],
   [30,,,96,105,32,,,96,126,30,32,,30,,76,31,,32,,80,82,54,52,82,49,69,54,
     ,86,52,,72,,26,26,26,24,30,,96,30,,30,,30,,30,,96,130,102,,180,176,
     178,172,180,172,87,83,87,66,87,79,87,78,78,53,78,78,51,78,78,,48,94,
     ,,,56,90,128,,56,27,,,38,,,,56,95,88,86,54,,,45,66,119,,86,66],
   [30,45,20,70,45,20,70,20,70,70,30,31,76,30,31,92,31,88,31,,,88,54,25,
     79,25,36,54,25,79,25,79,,79,26,20,26,20,30,84,92,30,92,30,84,30,,
     30,84,86,84,89,90,168,140,164,140,164,140,86,35,86,32,86,35,86,78,
     78,55,78,78,57,78,78,39,44,46,39,44,46,44,46,46,38,62,27,,,,,,,70,
     91,59,61,54,59,61,35,,59,61,61,,26],
   [30,75,,106,,32,132,,,128,30,25,64,30,25,64,25,64,25,64,64,64,54,,83,
     47,66,54,65,,,81,66,,26,22,24,26,30,,71,30,71,30,170,30,71,30,130,
     71,170,71,71,174,166,160,168,174,158,86,85,86,70,86,89,86,76,76,35,
     76,76,35,76,76,,52,104,,,132,,,132,37,42,25,,101,37,42,,,42,,94,78,54,
     ,,45,66,,,79,66,26,26],
   [,,,,,8,,,,,,,,20,19,30,17,28,,,34,26,,,,7,8,,7,,,,8,,,32,114,30,,,,18,
     29,18,,16,31,,,,,31,29,,44,89,42,,44,,7,,6,,7,,,42,32,40,,30,46,38,,,
     ,8,,9,,8,9,,,,22,,21,32,,,,,,,12,,13,10,14,,12,13,14,,32,114],
   [,,,,19,14,23,,,31,,,,,9,,9,,,,,,,,,23,30,26,21,30,,,26,38,,64,35,80,,,,
     14,,12,29,14,,,,,25,,,,,49,75,,49,,37,37,30,,33,45,,,7,,,7,,,,,,23,18,,
     18,32,,,,7,8,17,,8,,,8,17,19,,,21,35,,,21,,,,55,64,35],
   [6,,,16,,8,,,,16,6,5,14,6,5,12,5,14,5,12,14,12,12,,16,11,16,12,13,,,
     16,16,,27,27,25,27,6,16,15,6,13,6,16,6,15,6,16,13,16,15,13,37,37,
     35,37,37,35,21,21,18,16,21,21,18,16,14,7,16,14,7,16,14,,8,20,,,,8,
     ,20,7,8,5,,,7,8,,,8,,12,17,12,,,10,14,12,17,,14,27,27,25,,7],
   [,,,,,8,,,,,,,34,20,17,28,19,26,,58,58,26,12,6,16,7,6,12,6,16,6,16,6,
     16,,32,114,30,,,27,18,31,18,,16,,,,29,,31,,126,44,,42,,44,17,7,17,7,
     17,7,17,46,40,32,40,70,30,70,40,8,,9,,,,,9,8,22,,,,,21,32,,,,,,13,,,,
     10,14,,13,12,14,,32,,7],[],
   [6,9,4,15,9,4,15,4,15,15,6,,16,6,7,,7,,,16,16,,10,5,16,5,6,10,5,
     16,5,16,6,16,24,20,24,20,6,17,15,6,15,6,17,6,15,6,17,15,17,15,
     15,32,28,32,28,32,28,17,7,17,6,17,7,17,16,16,14,16,16,14,16,16,7,
     8,8,7,8,8,8,8,8,7,16,6,7,16,,,,,16,16,11,11,10,11,11,7,,11,11,11,
     ,24,20,24,6,,6,6],
   [,43,,31,17,18,26,,31,,,,,,9,,9,,,,,,50,,38,23,30,26,25,29,,38,26,,55,
     64,35,,,27,,14,,12,,14,,,29,,,,,75,94,49,94,,49,45,37,37,30,45,33,,
     16,16,7,16,16,7,16,16,,,,23,18,,18,32,,,8,7,8,17,,,,,8,17,25,57,50,
     23,33,,,23,57,57,,,,35,,7,7],
   [6,11,,,,8,,,16,,6,5,12,6,5,14,5,12,5,14,12,14,12,,17,11,16,12,13,16,
     ,,16,16,27,27,25,27,6,16,13,6,15,6,16,6,13,6,16,15,16,13,15,37,
     37,35,37,37,35,18,21,21,16,18,21,21,14,16,7,14,16,7,14,16,13,8,,,
     8,20,,,,7,8,5,6,,7,8,,,8,,12,19,12,12,17,10,14,,,17,14,27,27,25,,
     7,5,,,6,7],[,,,,,8,,,,,,,58,20,19,28,19,26,,34,,28,,,,7,8,,7,,,,8,,,
     32,,30,,,46,18,30,18,,16,27,,,31,,,29,126,44,89,42,,44,16,7,16,6,16,
     7,16,70,42,32,38,46,30,,40,,,8,8,,9,,,9,,,,19,,21,32,,,,,,12,12,,13,
     10,14,,,13,14,,32,,6,,,7,,6]],
 [,[],[],[],[],[],[,32,,47],[,,,,,17],[],[,41,,41,,,40,,67],
   [16],[,20,,,,,,13],[],[,,,66,,25,44,25,66],[,,,,,,55,28,65],
   [24,,,31,,19,25,15,33,34,8,6,14],[,,,,,,40,15,,70,,6,,10,14,6],
   [,73,,,,,,34,87,72,,,13,,,14],[,,,,,29,37,,,50,,,,,12,,14],
   [,20,,,,,,13,,,,6,,,,6,6],[,,,,,,,,,,,,13,,,14,,13],
   [24,20,,33,,19,27,13,35,33,8,6,14,,,6,6,14,,6,14],
   [32,,,,,40,63,,,57,32,,,57,,32,,,,,70,32],[],
   [,28,,,,55,44,,,54,,31,,69,110,29,36,88,,31,77,33],
   [,,,,,34,,35,54,,31,28,73,27,,,,63,35,28,,25,51,,50],
   [,,,74,,45,63,49,65,86,,41,105,,35,,46,72,43,41,,35,57,,56],
   [,31,,63,,,,32,,,26,23,54,31,45,23,24,52,44,23,52,23,49,,31,30,38],
   [,,,,,,,29,,,,,,33,,25,28,,39,,,25,,,,27,33],[],
   [,,,,,28,,,,,21,,,33,33,19,21,47,,,62,21,,,,27,33,,23],
   [,,,,,53,,,,,,,,45,,35,44,,47,,104,41,,,,33,39,38],
   [52,56,,59,,45,,45,73,58,37,33,52,55,42,33,50,60,47,33,63,27,36,,41,,
     35,,33,,31,47],[52,37,,48,,,37,46,69,,,33,97,,,27,32,73,51,33,,29,
     39,,35,,,,,,,42,41],[],
   [,,,308,,132,,157,287,231,86,,156,91,,,48,,157,,125,47,,,228,145,,200,,,
     215,,,200],[272,115,,,,,,103,462,,35,30,69,40,62,30,30,69,62,30,69,
     30,239,,166,,172,117,,,165,209,,170,,51],
   [,,,265,,173,233,120,231,,57,,143,,,62,,,126,,196,,,,,153,188,,193,,,232,
     192,,,,54],[16,,,,,17,35,,,,7,,,,,8,8,17,,,,8,28,,,27,,26,22,,20,,31,
     36,,80,35,56],[,,,,,,40,,,53,,,,48,53,31,34,65,,,,33,,,,52,63,46,,,,
     45,60,54,,201,,179],
   [,,,,,33,63,,,,,,,,,16,,15,,,16,16,,,,,,57,46,,,,59,,,230,76,246],
   [,,,47,,19,31,19,27,,,17,,15,,,16,30,19,17,,,47,,50,25,,29,27,,27,33,53,
     ,,88,71,90,,31],[16,20,,34,,17,31,22,,40,7,9,13,,,,8,13,,9,13,8,
     28,,30,,,26,23,,22,47,34,32,,,35,57,7,,15],
   [,17,,38,,,,13,49,,7,9,13,15,19,8,8,13,19,9,13,8,30,,30,24,33,23,,,
     20,36,29,30,,59,35,57,7,,15,15,7],
   [,,,70,,,,,48,44,,,,,55,31,34,65,51,,,33,,,81,51,,,,,,54,73,51,,201,,192,,
     42],[,19,,,,15,25,13,31,36,7,9,19,17,21,8,,,21,9,19,8,,,30,25,35,
     25,21,,19,37,35,27,,57,35,57,7,31,,15,7,7,31],
   [,,,,,33,63,,,,,,16,,,16,,,,,16,16,58,,72,,,56,45,,59,97,67,79,,,76,,,,14,
     ,15,15],[,,,,,19,43,,,60,,,,15,19,15,16,30,,,,15,,,,29,37,29,31,,,,
     41,38,,93,71,93,,,,13,,15,,15],
   [,,,,,,42,,,53,,,,48,49,29,32,59,,,,31,,,,50,63,48,,,,,75,53,,195,297,175,,
     ,,27,,,,29],[16,,,,,17,35,,,,7,,,,,8,8,17,,,,8,28,,,27,,26,22,,20,,
     31,36,,80,35,56,7,,,,7,7,,7],
   [,,,70,,,33,,48,,,,,66,55,31,34,63,43,,,33,,,79,71,65,,,,,53,61,,,215,
     241,192,,35,,46,,,35,31,,,42],
   [,,,,,33,63,,,,,,16,,,16,,15,,,,16,,,,,,57,46,,,,64,,,,76,159,,,14,,15,15,,,
     14],[16,20,,34,,17,31,16,,40,7,9,13,,,8,8,13,,9,13,,28,,30,,,26,23,
     ,24,47,34,32,,57,35,72,7,,15,,7,7,,7,15,,,7,,15],
   [192,,,,,152,,,,609,100,,,90,148,63,64,,,,,61,282,,,223,305,306,295,,237,,
     301,357,,489,349,466,94,,,135,,87,391,85,220,,,94,654,258,90],
   [,,,303,,,305,,321,327,81,67,,107,,,62,154,182,67,,61,281,,,185,,268,311,,
     211,283,305,266,,487,339,469,76,252,174,113,,73,258,72,,119,244,76,
     276,264,72,108],[,,,,,,,,516,639,49,42,95,56,86,42,42,95,86,42,95,
     42,262,,,194,229,163,,,186,255,290,226,,382,210,,49,285,104,97,49,49,,
     49,104,97,281,49,363,104,49],
   [,216,,307,,,281,158,,322,,70,174,94,141,,,,149,70,,63,,,310,201,256,568,
     243,,,338,264,281,,473,393,471,,267,,118,86,95,258,85,,123,226,,267,249,
     ,65,108,66],[,,,,,148,392,,,487,,,,,182,61,,158,,,,61,,,,,333,286,,,,,
     265,340,,507,348,573,,,,,73,73,,73,211,149,,,670,224,71,,64,63],
   [112,130,,215,,117,,107,332,235,49,42,95,56,84,42,42,95,84,42,95,42,199,
     ,217,168,,163,160,,154,246,,211,,384,210,369,49,232,102,91,49,49,221,
     49,102,91,215,49,224,102,49,66,66,42,66,64],
   [48,,,,,66,69,,,72,46,,,82,76,43,46,92,,,93,45,42,,,72,78,67,63,,,,57,54,
     ,331,241,263,40,,,67,42,43,100,41,81,,,40,100,105,40,395,399,313,461,
     ,302],[152,,,,,56,81,59,92,104,48,46,100,43,,,,77,59,46,,37,74,,53,
     37,,48,44,,45,56,51,52,,233,251,233,42,85,,41,,38,83,37,,53,84,42,
     101,,49,374,301,301,311,348,258,68],
   [152,47,,86,,,,57,,82,38,40,76,60,63,36,38,76,63,40,77,36,72,,46,51,
     57,34,,,59,58,74,42,,295,185,262,37,69,79,49,37,34,,35,79,49,68,37,
     64,79,38,424,386,253,361,388,266,65,47],
   [,,,71,,45,67,47,73,77,39,37,73,42,46,31,,,47,37,,31,,,,45,51,,40,,41,
     60,51,50,,206,192,188,35,67,,40,,31,67,27,,41,69,35,67,97,31,296,
     264,242,246,313,221,41,41],
   [,,,,,72,,,,121,,,,82,63,43,44,98,,,88,47,,,,51,57,,67,,,,63,,,430,349,328,
     ,,,50,44,43,100,41,104,45,,,102,137,57,,424,321,,410,,,47,,47],
   [64,56,,77,,48,64,49,84,78,39,38,71,39,57,29,34,65,55,38,71,29,51,,
     45,45,45,42,38,,37,56,,44,,219,186,221,36,,69,37,34,32,85,29,69,49,
     86,36,85,71,34,,279,244,287,317,218,47,35,41,35,47],
   [64,51,,66,,53,62,64,90,,40,56,84,,,43,44,84,63,56,,41,52,,50,,,,,,55,
     63,59,,,295,251,275,40,76,109,,40,39,70,39,92,54,74,40,,,42,,428,357,
     405,521,298,47,,56,39,69,47],
   [32,,,,,43,83,,,98,17,,,18,28,18,16,23,,,23,18,58,,,46,60,62,,,47,,61,,,
     96,81,104,17,,,29,19,17,115,17,28,,,17,,28,19,127,129,111,,,111,86,
     79,86,69,,79,82],
   [34,,,49,,21,35,23,37,45,18,12,24,8,,,10,24,15,12,24,10,46,,57,27,,31,
     27,,29,39,39,45,,61,40,61,16,37,28,15,,12,39,14,28,15,37,16,37,28,
     14,79,91,56,81,91,56,65,43,50,37,55,39,55,16],
   [36,37,,51,,,,21,45,,17,12,23,8,12,10,10,23,12,12,23,10,48,,54,29,35,
     31,,,31,40,39,47,,63,40,61,15,60,28,15,13,11,,13,28,15,,15,63,28,
     13,79,92,56,101,92,56,64,49,48,39,53,45,53,16,8],
   [,45,,57,,,62,32,59,,17,17,23,18,28,18,,,,17,23,18,,,74,45,60,62,77,,
     47,76,64,67,,97,81,109,17,64,27,28,19,17,65,17,,30,61,17,65,27,19,
     131,131,111,162,143,111,88,75,86,64,88,75,83,15,16,16],
   [,,,,,,46,,,,,,,8,14,10,10,,,,,10,,,,30,37,31,31,,,,41,49,,68,40,66,,,,15,
     15,13,70,15,,15,,,45,,15,,,56,88,101,56,,52,49,41,56,48,56,,8,8],
   [36,37,,46,,23,35,21,37,45,17,12,23,8,12,10,10,23,12,12,23,10,47,,56,
     27,36,31,31,,29,39,,45,,61,40,63,15,58,26,15,13,11,37,13,26,15,41,
     15,43,26,13,82,92,56,81,92,56,66,43,50,37,55,39,55,16,8,8,16,8],
   [32,48,,66,,43,83,34,,,17,17,23,18,28,18,16,23,,17,,18,58,,72,48,65,61,
     ,,49,90,67,,,103,81,,17,,28,29,19,17,115,17,28,,,17,,,19,127,,111,
     171,170,111,87,81,88,,88,79,86,15,16,16,15,,16],
   [36,41,,46,,21,33,21,35,46,18,12,24,8,14,10,10,24,15,12,24,,49,,56,
     27,31,31,27,,31,37,35,43,,59,40,61,16,35,28,15,14,12,37,14,28,15,
     35,16,35,28,,77,91,56,81,91,56,64,43,46,35,51,39,51,16,8,8,16,8,
     8,16],[,,,,,,,,,,,,,,,21,28,,,,,,,,,,,,,,,,35,,,349,,,,,,,22,25,,23,58,,,,,
     ,20,,,172,,,147,,63,51,,,39,57,,49,59,57,,51],
   [,,,,,,,,,,,,,31,37,21,22,46,,,,21,,,,48,59,43,,,,,56,60,,128,102,128,,,,25,
     ,,,21,,,,,,,,,156,134,,,,,80,69,57,,94,79,,21,26,43,,40,,21],
   [,,,,,,,,,,,,,,,39,38,,,,,46,,,,,,,,,,,55,,,622,,601,,,,,34,,,35,83,,,,,,32,,
     499,,615,,263,,,,35,,43,,,71,,,,74,112,72],[],
   [,,,,,,,,,,21,22,33,31,,21,19,34,38,22,35,18,57,,,50,71,,,,,78,70,,,,,,
     21,55,34,25,22,18,59,18,34,20,54,21,56,36,19,233,178,183,197,,,91,
     86,,69,,,76,39,27,24,40,28,24,41,26,,25],[],
   [,,,,,,,,,,,16,31,22,27,16,,37,30,16,39,16,,,,48,56,77,,,,,65,54,,127,,
     120,17,41,32,18,17,16,43,21,37,18,40,17,43,36,17,,168,,156,155,150,
     57,80,100,57,,92,76,,22,22,43,22,22,45,22,,21,,,25],
   [,,,,,,,,,,,46,94,42,55,28,32,70,64,46,84,26,,,,47,55,,,,,,,,,287,274,,32,
     ,67,42,28,,,29,65,54,,32,,65,27,516,361,306,301,483,231,57,37,53,35,
     60,33,56,102,36,,78,54,36,92,34,,,35],
   [,,,,,,,,,,,,,,,39,46,,,,,37,49,,65,47,34,51,34,,34,64,35,67,,332,,,,,83,,
     40,,,35,,,,,,77,40,512,,,456,438,258,72,41,72,41,81,43,74,76,67,,77,,
     70,88,68,35,,43,,,,,43],
   [,,,,,19,37,,,,,,,,,10,,,,,,10,,,,,,31,26,,,,,,,116,42,83,,,,,9,9,,,,,,,,,9,,
     104,58,129,,56,,50,43,,,37,51,,22,22,22,,20,23,22,20,,,,22,,23,35,39]
    ,[,,,,,25,61,,,,,,,10,16,12,,,,,,12,,,,35,35,35,,,,,42,57,,,47,,,,,17,13,
     11,89,15,,,,,,,13,,111,65,,,65,,56,52,45,,47,60,,10,10,,,10,,10,,20,,,
     27],[],[],[,,,,,17,,21,,,8,7,18,10,14,8,7,18,13,7,18,7,32,,36,
     27,35,30,24,,,36,41,35,,,42,,8,31,19,15,9,8,33,8,19,14,30,8,33,19,
     8,73,68,53,70,,,46,44,41,33,49,37,,20,10,9,20,9,9,20,9,21,17,,,18,,
     ,37,,9,10],[,19,,40,,,32,15,,,,,,,,10,,,,,,10,40,,32,27,33,31,,,23,
     37,37,33,,70,42,133,8,30,19,15,8,9,32,8,19,15,29,8,31,19,8,,93,58,
     ,96,56,53,43,43,35,47,37,,22,22,22,,,20,22,22,,20,,,26,,,44,,9,,,,9]
    ,[,69,,,,37,36,24,48,55,,,,,16,12,,,16,,,12,,,85,49,34,36,57,,33,39,
     46,60,,,47,83,17,40,,16,13,11,37,,,16,39,17,40,,13,103,135,65,103,
     118,65,,57,51,50,60,43,67,20,9,10,20,9,9,20,9,,24,,,30,,32,40,,,10,,
     ,10],[],[],[,,,,,21,61,,,,,,,10,,12,,,16,,,12,54,,61,34,,36,44,,
     36,42,47,,,73,47,,,79,,17,13,11,,15,,17,,,89,,13,114,,65,94,112,65,
     75,55,51,43,60,47,,20,9,9,20,9,10,20,9,,41,,,27,,,,,,10,,,10,,10],
   [,27,,,,17,,15,,,8,7,18,10,14,7,7,18,13,7,18,8,,,39,26,31,27,23,,37,
     41,34,,,53,,57,8,31,19,15,8,8,33,8,19,14,30,8,33,19,9,70,68,56,
     69,69,53,44,43,40,35,47,37,44,20,9,9,20,9,9,20,10,25,17,,,24,,,,,
     9,10,,,8,9,10,,,10],
   [,,,,,,39,,,52,,,,34,42,26,28,53,,,,26,,,,45,62,42,,,,,,52,,148,205,154,,,,
     24,,,31,26,,,,,39,,,,191,248,221,352,,,78,62,61,61,,69,,28,,54,29,,,28,,
     ,,,39,,31,,,,,,,24,23,30,,,,24],
   [,,,,,51,58,,,79,,,,72,67,32,32,99,,,80,,,,,61,67,39,46,,,,52,49,,354,,
     264,,,,60,32,31,,30,75,,,,,92,30,,,229,329,,229,,57,39,36,,36,45,,56,
     59,76,,57,,,31,,,,84,,,39,56,33,,,,34,,89,,,64,35],
   [,,,,,,,67,,,,51,,57,58,43,,,,51,,,51,,64,51,64,42,56,,54,67,67,55,,346,
     296,512,,,117,45,,46,80,46,,50,,,82,117,,,428,408,471,385,,76,76,60,
     48,67,67,65,75,47,46,82,54,48,74,50,56,69,73,,,,73,63,,79,57,,,,,63,,
     ,,48,,51],[,,,,,,36,,,37,22,,46,34,,20,21,,34,,46,21,,,37,41,53,35,,,
     ,,54,47,,140,,149,21,35,44,24,22,20,32,19,44,24,34,21,32,44,23,292,
     182,186,199,256,177,64,70,54,56,,76,57,48,30,31,48,,29,48,31,,29,,,,,
     29,,,22,34,,,,21,,,,34,,24],
   [,,,,,,,84,,121,71,69,86,72,65,47,50,87,110,69,108,45,57,,70,61,57,49,
     62,,60,73,48,62,,439,573,411,51,,84,62,47,,111,48,83,72,,51,110,85,
     47,525,551,753,553,509,610,82,57,66,54,73,50,72,107,57,57,90,,56,96,
     58,63,104,80,,,,94,70,73,63,70,,,,65,69,,,73,60,,57],
   [,,,65,,,65,,84,84,31,,55,,,34,28,,,,57,,49,,,46,61,49,,,,53,61,53,,193,
     185,,27,49,46,27,25,27,49,23,46,28,49,27,49,48,25,401,234,,430,315,
     396,72,76,72,61,114,72,114,49,46,49,50,,47,51,45,,38,,,,,38,,,28,55,,
     ,28,,,,,55,28,30,,,26],
   [,32,,,,212,32,57,68,30,33,33,75,,,,30,,,33,75,43,,,47,33,39,39,,,49,,
     39,29,,,156,291,29,43,64,28,28,29,31,25,64,33,44,29,29,64,28,,370,
     206,,357,274,,46,39,40,82,42,40,71,,65,73,128,75,71,67,51,43,,,64,,
     43,60,116,30,73,,,31,26,,,,73,31,31,39,65,,71],
   [,,,,,,,,,,,24,70,29,37,21,,45,34,24,,21,,,,45,,69,,,,57,62,47,,147,,158,
     23,36,46,23,23,22,33,26,47,26,35,23,33,42,23,246,194,,201,273,191,,
     78,89,62,69,101,62,78,29,31,54,32,29,,29,,31,,,39,,,,,29,,,,,,37,,,,,
     26,,,24,,30,31],[,,,,,51,,,,,47,,151,46,47,43,42,,,,114,41,,,,46,52,
     46,,,56,,73,54,,,208,257,41,,133,44,49,38,65,36,75,,,41,71,,37,368,
     584,264,347,375,269,51,43,40,36,58,39,43,75,41,42,76,44,41,78,39,,,
     49,,70,,,,56,71,45,,,37,83,,,,44,39,,36,57,,63,68],
   [52,,,,,,63,,,76,,,76,74,,32,32,,,,,30,36,,41,46,33,31,47,,41,46,36,36,,,
     ,217,30,,71,62,32,33,,30,,,,30,,71,33,366,315,240,341,334,231,53,39,
     42,39,54,36,46,70,58,61,73,,59,,57,39,,56,,,,60,46,,35,68,,,33,,75,,,
     ,32,,36,,,53,,37,,42],
   [52,41,,62,,,,50,,41,43,74,81,,47,,38,,41,74,81,,39,,56,41,44,46,65,,
     57,57,43,39,,,196,295,37,56,72,36,34,37,35,31,72,39,57,37,39,72,34,
     367,,258,479,471,287,62,50,42,45,101,45,45,79,,39,,,42,79,35,57,53,
     68,,,,53,64,77,38,43,,,39,,43,,,43,39,39,45,,,,,37,39,45,43],
   [136,,,347,,124,,,,654,65,,203,74,,47,64,,137,,142,49,204,,274,160,246,291,
     ,,178,,223,,,,45,62,61,,242,105,59,57,,53,195,110,,61,398,,,471,465,,
     489,675,397,283,273,303,208,328,262,307,95,61,61,103,68,63,96,61,,
     157,575,,,,142,,,133,73,,,,83,,,,85,56,,352,334,,,287,,188,,329,288],
   [,193,,,,,,146,295,285,86,,182,,171,49,60,171,128,,,,257,,265,147,302,246,,
     ,191,256,,256,,60,,74,80,219,,88,,77,241,71,,,237,80,229,261,72,498,
     637,441,541,,361,361,241,361,226,,229,,97,63,85,98,92,63,107,61,259,
     141,,,170,,131,406,437,119,79,,,59,,,,,82,55,162,319,366,150,,221,,153,
     362,344,,96],[,128,,,,105,399,79,,455,35,30,69,40,62,30,30,69,62,
     30,69,30,,,170,146,171,117,203,,,194,206,,,46,30,,35,,76,71,35,35,306,
     35,76,71,231,35,310,76,35,,334,210,,341,210,234,230,184,189,316,185,
     245,81,40,40,81,40,40,81,40,,112,662,,,,,,583,42,47,,,39,42,47,,,47,
     39,163,172,327,177,747,182,154,,,171,195,,53],[],
   [,,,,,,46,,,,,,,8,14,10,10,,,,,10,,,,30,37,31,31,,,,41,49,,68,40,66,,,,15,
     15,13,70,15,,15,,,45,,15,,,56,88,101,56,,52,49,41,56,48,56,,8,8,,8,
     8,,8,,,,,28,,22,54,,,,,,9,,9,,,9,9,29,,54,,,,128,32,44,,,68,92,40],
   [],[],[16,,,36,,15,,,,36,7,6,15,8,12,6,6,15,12,6,15,6,27,,,24,33,
     23,24,,24,35,33,35,,49,30,49,7,32,16,13,7,7,31,7,16,13,31,7,32,
     16,7,62,,42,,61,42,41,42,37,33,,38,41,17,8,8,17,8,8,17,8,29,16,42,
     ,,,16,,42,8,9,,,,8,9,,,9,7,24,37,,22,,,29,24,38,36,35,,51,30,,8],
   [,18,,,,,28,14,36,43,7,,17,,,8,8,,,,17,8,,,30,23,30,26,,,21,,30,30,,61,
     35,80,7,30,16,14,7,7,29,7,16,14,29,7,30,16,7,94,75,49,100,70,49,
     45,37,37,30,45,33,57,17,16,15,17,,15,17,16,23,18,,,24,,18,32,,8,17,,
     ,8,,,,,17,8,22,34,47,20,55,23,,22,,34,,,80,35,,,,,7],
   [,46,,56,,23,39,23,54,,,,,8,14,10,10,,14,,,10,53,,61,27,,31,31,,31,41,
     43,,,85,40,,,41,,15,15,13,,15,,15,41,,56,,15,84,101,56,86,,56,72,43,
     52,38,72,39,,17,8,8,17,8,8,17,8,,26,,,26,,22,38,,,9,,,9,,,,,9,9,31,
     64,53,31,64,,,29,42,68,46,68,,40,,8,,,8],
   [,21,,,,17,,15,37,,7,6,13,8,13,6,6,13,13,6,13,6,,,33,,31,24,22,,20,,,
     32,,54,30,,7,29,14,14,7,7,31,7,14,14,28,7,31,14,7,64,65,42,66,63,
     42,45,54,36,35,46,36,,15,8,8,15,8,8,15,8,20,17,,,21,,,,37,8,9,,,7,
     8,9,,,9,7,23,31,47,21,,27,29,,,31,37,51,,30,,8,,,6,7,8],[],[]],
 [,[],[],[],[],[],[],[,,,,,10],[],[],[],[],[],
   [,,,,,36,,36],[,,,,,,,25],[,,,,,58,,49],[,,,,,,,27,,,,,,21,20,31],
   [,,,,,,,38,,,,,,29,28,39],[,,,,,33,,,,,,,,,19,,21,29],
   [,,,,,,,38,,,,,,,,33,31,68],[,,,,,,,44,,,,,,,,,,,33,69],
   [,,,,,52,,38,,,,,,,,27,28,36,,30],[,,,,,20,,,,,,,,,,,36,54,35,,62,62],
   [,,,,,8,,8,,,,,,23,17,39,21,30,17,34,58,30],
   [,,,,,20,,,,,,,,,43,,69,83,42,93,74,74],
   [,,,,,10,,10,,,,,,17,,,,51,21,49,,49],
   [,,,,,8,,8,,,,,,,16,,21,24,17,36,28,40,14,6,18],
   [,,,,,,,20,,,,,,36,29,54,,48,29,52,42,44,12,,16,,14],
   [,,,,,,,8,,,,,,24,,38,35,30,21,,,32,,6,,8,6],
   [,,,,,,,20,,,,,,,70,123,43,75,38,64,67,62,16,,20,,18],
   [,,,,,8,,,,,,,,24,18,30,21,28,,,32,28,,6,,8,6,,6],
   [,,,,,24,,,,,,,,52,,108,,71,37,,56,74,,,16,,18,16,,20],
   [,,,,,8,,8,,,,,,23,17,39,21,30,17,34,58,30,,6,,,6,,6,,6],
   [,,,,,,,24,,,,,,,40,,53,83,39,66,,70,16,,20,,18,,,16,,20],
   [,,,,,168,,,,,,,,286,223,,213,658,,,,,140,,,,98,150,98,,,,,228],
   [,,,,,,,58,,,,,,90,,,,,214,291,,182,150,,174,35,,,34,,36,,,174,144],[],
   [,,,,,,,,,,,,,90,,192,,,138,,,,62,30,84,35,30,62,30,84,30,84,30,84,,33],
   [],[],[,,,,,41,,41,,,,,,27,30,37,,31,30,41,35,37,,31,,,26,45,30,61,
     30,61,31,,,206,,207],
   [,,,,,26,,26,,,,,,16,,,20,27,20,52,,,,23,,17,,32,20,,20,44,23,,258,86,,86,
     ,,27],[,,,,,43,,59,,,,,,,,,32,39,,33,,29,,39,,,,50,33,69,32,111,39,,
     611,,,227,,,42],[,,,,,,,24,,,,,,22,20,32,20,,21,32,28,28,30,16,38,20,
     16,26,,,18,34,16,51,183,123,,120,,,29,19,31],[],
   [,,,,,22,,22,,,,,,17,16,27,,,17,28,48,24,30,14,40,17,14,30,16,36,16,40,
     14,40,180,84,,74,,,,17,29,16],
   [,,,,,61,,61,,,,,,46,50,56,,,47,58,58,56,,,,54,42,62,44,95,44,93,,,922,
     284,,,,,,46,56,46],
   [,,,,,24,,,,,,,,22,18,58,19,26,,,30,48,30,16,51,20,16,28,18,36,,,16,36,,
     142,,122,,,29,19,,18,,16,46],[],
   [,,,,,41,,,,,,,,,,30,30,39,,,,27,77,34,112,49,,46,30,65,28,,34,113,,219,,
     181,,,36,,32,29,,27,72],[],
   [,,,,,38,,38,,,,,,,31,,,26,27,42,,41,,,,,24,,27,63,27,,,,421,,,162,,,30,,,
     26,,,,26,,41],[,,,,,43,,42,,,,,,,,30,32,39,,33,,,,39,,,,49,33,67,44,
     113,39,,,201,,208,,,43,,31,31,,29,53,,,32],
   [,,,,,154,,,,,,,,,309,511,234,504,,558,870,474,166,,,172,110,168,,223,110,
     269,,238,1807,1402,,680,,,,,,209,,202,713,210,,446,,571,806],
   [,,,,,,,68,,,,,,122,,,151,234,182,418,507,258,142,48,297,49,,186,46,,46,,
     48,288,1199,230,,224,,,256,118,,160,,112,,175,,257,,261,255,136],
   [,,,,,,,,,,,,,224,216,372,,903,212,370,352,347,176,126,,172,110,168,,,110,
     249,126,228,1631,715,,,,,412,208,359,204,,234,,199,,353,,311,362,156,136 
    ],[,,,,,64,,68,,,,,,122,127,,,,184,330,434,210,86,42,116,49,42,86,42,
     116,42,116,42,116,1147,228,,210,,,255,118,263,154,,102,,152,,267,,251,,
     126,45],[,,,,,142,,,,,,,,,287,627,,492,,,619,,168,,219,,110,168,,234,,,,
     225,,1930,,1380,,,,,687,215,,,993,211,,,,467,,130,,156,126],
   [,,,,,62,,64,,,,,,114,142,206,130,,135,232,390,196,,,,49,,146,46,313,48,
     223,,302,,230,,224,,,,114,220,124,,108,507,124,,245,,253,241,,45,142,45,
     142],[,,,,,22,,22,,,,,,47,44,75,46,80,46,,80,85,19,,,21,20,23,20,27,
     ,23,,27,187,127,,93,,,,43,,42,,41,136,40,,99,,71,100,225,180,244,127,
     237],[,,,,,10,,10,,,,,,17,,,,37,21,41,44,37,21,9,25,7,,21,8,25,8,
     25,9,25,125,35,,35,,,,17,,20,,17,45,20,,40,,51,48,139,49,139,49,139,
     49,19],[,,,,,,,22,,,,,,45,41,65,,74,42,71,62,67,23,22,27,21,20,19,,,
     20,27,22,23,195,133,,93,,,61,41,69,38,,41,91,40,,68,,59,69,225,183,
     237,127,240,160,21,19],
   [,,,,,10,,10,,,,,,17,21,37,,,21,41,44,37,19,9,23,7,8,19,8,23,8,23,9,
     23,125,35,,35,,,40,17,,20,,17,,20,,39,,40,50,139,49,137,49,139,49,19,
     7,19],[,,,,,26,,,,,,,,,44,69,49,72,,,92,73,19,,23,21,20,23,20,27,,,,
     27,,133,,93,,,67,,106,38,,39,88,38,,,,63,81,239,,225,127,225,160,17,
     19,21,19],[,,,,,10,,10,,,,,,17,23,29,23,29,21,35,39,29,,,,7,8,,8,,8,
     ,,,,35,,35,,,,17,35,20,,17,,20,,35,,37,35,,49,160,49,160,49,,7,,7],
   [,,,,,22,,26,,,,,,47,,77,47,80,43,79,,85,23,22,27,21,20,19,,23,20,27,22,
     ,203,,,93,,,74,43,,40,,41,143,40,,76,,,100,,,229,127,231,170,21,19,17,
     19,21],[],[,,,,,65,,65,,,,,,40,,,55,55,52,61,80,47,98,46,137,51,,
     68,42,137,42,97,46,,477,220,,214,,,61,40,,45,,45,80,45,,54,,58,56,,
     294,496,284,545,272,97,45,95,45,125,41,99],
   [,,,,,,,42,,,,,,52,46,62,46,,43,60,67,52,50,28,68,45,32,48,,,32,67,28,
     64,356,225,,210,,,57,44,61,34,,36,75,36,,56,,53,61,382,284,358,234,
     416,224,71,39,69,39,71,35,69,,43],
   [,,,,,86,,54,,,,,,53,50,63,,,47,94,,56,70,40,84,51,38,62,36,88,40,92,
     40,84,542,226,,200,,,55,49,65,68,,34,,42,,61,,54,65,590,290,1159,268,
     868,270,97,45,91,45,97,41,95,,49,66],
   [,,,,,,,,,,,,,52,48,57,56,60,,,74,50,70,44,103,57,38,66,44,90,,,44,89,,
     336,,288,,,65,46,59,42,,46,82,42,,,,58,59,516,,498,332,512,302,97,51,
     95,51,95,47,95,,43,43,76],
   [,,,,,44,,42,,,,,,40,42,50,45,46,39,64,72,48,,,,39,32,52,30,73,32,74,,,,
     164,,164,,,,38,58,36,,36,,36,,58,,59,58,,220,364,214,436,198,,33,69,
     33,73,29,71,,37,33,39,43],
   [,,,,,64,,60,,,,,,,,,53,52,51,120,,,70,74,85,,42,64,,86,44,103,74,,549,
     331,,322,,,59,,,45,,38,78,46,,,,,,,,745,446,1037,,96,52,90,52,94,51,94,,
     ,40,,79,44],[,,,,,60,,54,,,,,,40,44,51,52,52,49,58,78,,68,40,92,51,
     34,60,38,88,40,84,40,88,704,214,,198,,,62,40,55,42,,42,78,42,,52,,54,
     ,508,290,494,266,498,264,99,45,91,45,91,41,95,,37,40,46,40,37],
   [,,,,,,,,,,,,,,22,,32,,26,44,,36,,,,,10,,,,,,,,,77,,40,,,,,,24,,20,,24,,41,,,,,
     ,138,56,,,,17,22,15,,,22,,65,40,44,52,,,44],[],
   [,,,,,,,,,,,,,21,,45,26,41,31,,,57,,,,11,12,,,,,,,,,,,49,,,,21,,29,,21,95,29,
     ,53,,,70,,75,,67,180,,,11,,11,,,,,49,49,53,,,68,51],[],[],
   [,,,,,,,,,,,,,20,22,32,,28,,,,46,17,8,24,11,10,17,8,24,8,24,8,24,122,46,
     ,,,,32,20,,20,,16,50,,,33,,30,,144,62,,78,,62,25,11,25,9,25,9,25,,
     44,40,44,,34,,44,10,,11],[],
   [,,,,,,,,,,,,,19,26,33,,35,27,51,63,33,,,,,12,,,,,,,,,55,,49,,,33,19,38,,,
     21,53,25,,39,,42,38,215,71,225,67,215,79,25,9,25,11,25,9,25,,47,,
     51,65,33,77,47,,,11,,,11],[],
   [,,,,,28,,28,,,,,,,27,,,,23,38,,37,,,,,20,,21,55,21,,,,,157,,,,,,,,22,,,,22,,
     39,,,,,194,,,,,,39,,,51,,45,,74,47,,58,,56,54,17,,,,,20],[],[],[],
   [],[,,,,,,,27,,,,,,26,28,40,,,27,,,38,35,19,43,23,19,39,,45,21,48,19,
     53,230,,,172,,,39,21,34,22,,19,58,21,,34,,36,34,,208,319,,,353,48,23,
     51,23,53,23,52,,64,74,,62,,,62,,,31,,,,,35,,22],
   [,,,,,,,42,,,,,,53,56,67,,,43,,,60,56,28,117,57,32,64,30,93,32,105,28,
     123,,234,,192,,,,45,63,,,,,36,,62,,,63,810,288,1011,258,1091,238,98,41,
     106,41,114,33,102,,42,,50,44,30,56,40,,,41,,,,,41],
   [,,,,,27,,,,,,,,26,22,52,24,37,,51,43,50,42,19,45,23,19,39,21,43,,50,
     19,46,,176,,,,,39,21,55,21,,19,58,22,,52,,36,55,299,,,,,,51,23,52,23,
     52,23,53,,64,35,49,62,33,55,62,26,,,,,26,,35,,22,,,,,24,35],
   [,,,,,46,,,,,,,,53,53,32,33,57,,,115,30,,,84,,38,,36,,38,,,84,,212,,220,,,
     59,45,33,32,,31,78,,,39,,62,33,812,272,,298,,242,91,,85,39,81,33,91,,
     44,46,69,,44,127,42,40,,51,,,38,,,,39,,,,,38,49],[],[],[],
   [,,,,,22,,,,,,,,33,32,53,38,51,40,63,96,57,,,,16,16,19,15,23,,,,23,,89,,
     71,,,,32,,34,,31,115,35,,61,,55,81,,,205,97,218,,,15,17,15,,,17,,73,
     58,71,80,,,71,15,,,,,18,,18,,31,,,,,,85,41,61],[],[],
   [,,,,,,,16,,,,,,30,29,46,30,50,31,48,56,48,14,13,21,16,14,14,13,18,13,
     21,13,18,,68,,,,,44,30,46,,,28,67,26,,50,,46,47,182,92,172,158,186,
     92,22,15,19,13,22,14,19,,66,48,,74,46,66,60,17,,18,,,,,18,,34,,,,,35,
     58,42,66,,,,15],[,,,,,14,,14,,,,,,30,32,76,33,,,,58,,12,11,20,12,10,
     12,11,20,11,20,11,20,,54,,52,,,47,30,51,32,,28,69,32,,52,,46,,,74,
     178,72,,74,21,11,21,11,21,12,21,,72,58,74,74,50,68,70,15,,16,,,15,,
     16,,34,,,,,,,,68,,,,13,,,12],
   [,,,,,,,16,,,,,,76,44,82,,,53,,,140,16,16,24,17,14,19,16,16,16,24,16,16,,
     ,,74,,,60,40,65,,,38,99,40,,69,,61,71,242,122,,102,,132,25,15,17,15,
     25,17,17,,106,76,82,138,84,92,98,22,,23,,,22,,23,,47,,,,,,,61,86,,,,17,
     ,,16],[],[,,,,,22,,,,,,,,31,30,91,49,47,,,56,61,,17,,,16,19,,23,15,
     ,17,23,187,86,,71,,,48,30,67,32,,31,71,,,57,,43,79,206,111,211,97,
     220,123,22,13,19,15,22,14,19,,70,60,75,76,54,81,67,15,,18,,,18,,,,,,,,
     ,44,73,43,,,,,15,,,15,13,17],[],
   [,,,,,21,,18,,,,,,,34,,39,88,43,88,,,16,16,24,17,14,19,16,16,16,24,16,
     16,232,102,,74,,,51,36,76,37,,34,109,32,,,,53,81,265,132,,102,264,121,
     25,15,17,15,25,17,17,,,73,94,86,74,,,22,,23,,,22,,23,,43,,,,,50,154,
     52,98,,,,17,,,16,,14,,17],
   [,,,,,160,,,,,,,,286,,459,221,,200,,545,675,146,114,219,,98,144,,198,98,,
     114,,144,144,,90,,,394,258,629,181,,176,,286,,,,525,,1915,1294,1482,1298,
     2118,1594,195,125,191,125,219,142,214,,525,334,538,538,356,,704,,,160,,,,
     ,168,,,,,,,,,258,,,,,194],
   [,,,,,59,,,,,,,,90,,196,123,204,169,,,200,118,,256,35,36,,34,,34,,,,,34,,32,
     ,,232,86,230,131,,84,,144,,201,,215,,1060,230,729,228,1542,230,146,35,,
     35,,35,151,,222,238,222,354,168,348,216,99,,,,,46,,53,,195,,,,,,,156,,,,,
     92,,,68,54,,,85],[,,,,,166,,126,,,,,,196,193,323,,,178,303,475,311,148,
     112,,,98,144,,237,,199,112,,,96,,,,,369,178,302,164,,,567,174,,310,,265,
     307,2148,1095,1911,,2195,1316,210,123,203,125,195,,195,,426,298,706,434,
     324,486,426,,,168,,,,,,,,,,,,,,338,,,,,199,,,148,,216,,,,207,,124],
   [,,,,,10,,10,,,,,,17,23,29,23,29,21,35,39,29,,,,7,8,,8,,8,,,,,35,,35,,,,
     17,35,20,,17,,20,,35,,37,35,,49,160,49,160,49,,7,,7,,7,,,41,35,41,
     47,29,51,41,,,,,,9,,9,,,,,,,23,33,23,33,,,,,,,14,12,17,,14,,17,142,35],
   [],[],[,,,,,8,,8,,,,,,16,17,34,17,36,17,36,58,,13,6,18,7,6,13,6,
     18,6,18,6,18,114,32,,30,,,34,16,35,16,,14,,16,,,,,35,126,44,,42,,44,
     19,7,19,7,19,7,19,,42,34,40,44,32,74,40,8,,9,,,,,9,,,,,,,19,,19,40,,,
     ,14,,,,11,16,,14,,16,,32,,7],[],
   [,,,,,,,8,,,,,,20,22,34,,,21,,,32,12,6,19,7,6,12,6,19,6,19,6,19,,32,,
     30,,,30,18,31,,,16,46,18,,31,,27,31,,44,126,42,122,44,20,7,20,7,20,
     7,20,,42,,42,,28,42,40,8,,9,,,8,,9,,19,,,,,,,21,34,,,,13,,,12,10,,,13,
     ,22,114,32,,7,,,6],[],[],
   [,,,,,10,,10,,,,,,17,23,,23,43,21,43,,41,,,,7,8,,8,,8,,,,,35,,35,,,60,17,
     55,20,,17,51,20,,42,,,,160,49,160,49,,49,19,7,19,7,19,7,19,,47,41,
     47,53,35,,47,,,9,,,9,,,,,,,,,23,49,23,,,,,14,,,14,12,17,,,,17,,35,,7,,,
     7,,7],[,,,,,8,,,,,,,,20,19,30,19,28,,,34,26,12,6,16,7,6,12,6,16,6,
     16,6,16,,32,,30,,,30,18,46,18,,16,46,,,30,,27,31,126,44,127,42,126,
     44,17,7,17,7,17,7,17,,42,32,40,,30,46,38,8,,9,,,8,,9,,19,,,,,21,32,,
     ,,,,13,,,12,10,14,,13,,14,,32,,7,,,6,,6,,,7],[]],
 [,[],[],[],[],[],[],[,,,,,17],[],[],[],[],[],
   [,,,,,23,37,23],[,,,,,,43,25],[,,,,,31,37,25],
   [,,,,33,,,25,,73,,,,10,11,12],[],[,,,,29,20,35,,,55,,,,,11,,11],
   [,,,,,,,23,,,,,,,,12,12],[],[,,,,,31,45,27,,79,,,,,,12,12,,,12],[],
   [],[,,,,49,76,,,52,89,,,,58,56,61,59,,51,78,,62],
   [,,,,,35,44,34,,,,,,27,,,,,29,46,,43,,,39],
   [,,,,80,45,55,45,,,,,,,32,,57,,38,63,,51,,,62],
   [,,,,,,,40,,,,,,31,38,43,,,38,43,,43,,,,45,36],
   [,,,,,,,28,,,,,,33,,45,38,,29,,,45,,,,25,33],
   [,,,,28,,,53,64,100,,,,67,,63,45,,44,,,102,,,42,33,41],
   [,,,,,29,,,,,,,,33,30,37,33,,,,,35,,,,27,33,,23],
   [,,,,,49,43,,,70,,,,44,,55,,,41,,,70,,,49,45,39,43],
   [,,,,39,37,47,37,89,121,,,,55,39,67,49,,34,61,,47,,,,,29,30,25,33,27,39 
    ],[,,,,,,,76,64,,,,,67,75,76,,,64,81,,84,,,60,52,62,,,,,,57],
   [,,,,,124,,,,,,,,74,,,66,,,,,140,,,,196,261,240,200,,251,,,350],[],
   [,,,,,,,105,,,,,,40,49,54,,,49,54,,54,,,245,153,174,117,,,203,204,143,448,
     53],[,,,,161,,190,154,224,342,,,,,,119,,,,127,,,,,235,153,192,,,211,193,
     247,178,,54],[],
   [,,,,57,,51,,50,95,,,,66,58,71,58,,,,,78,,,,69,86,62,,68,,64,71,116],
   [],[,,,,,17,25,19,,,,,,15,,,18,,18,23,,,,,43,25,,29,27,35,27,33,53,52,
     109,,71,90,,46],[,,,,,32,61,36,,73,,,,,,,19,,,19,,19,,,95,,,56,46,75,
     44,81,72,71,,,76,246],
   [,,,,,,,15,39,,,,,15,16,17,15,,16,17,,17,,,55,25,35,23,,,25,35,31,,83,,
     52,82,,,,13,14],[,,,,,,,,40,,,,,48,36,53,36,,49,,,62,,,55,46,61,,,,,
     47,65,,525,,,173,,51,,27],
   [,,,,21,19,27,19,30,47,,,,17,18,19,,,18,19,,19,,,37,25,33,,25,33,27,,33,
     ,92,,117,83,,46,,15,16,12,27],[],
   [,,,,32,15,45,,,55,,,,15,18,25,18,,,,,23,,,56,26,35,29,24,39,,,31,58,,,
     71,103,,,,15,,13,,15],[],
   [,,,,,32,61,,,83,,,,,,19,19,,,,,19,,,88,46,,56,43,79,37,,58,81,133,,76,
     146,,,,,16,14,,16],
   [,,,,,,29,,55,,,,,48,40,53,40,,42,,,60,,,,50,69,,,48,,55,,,,,235,183,,,,31,,
     ,,31],[],[,,,,,32,61,34,,77,,,,,,19,19,,,19,,,,,,,,56,46,75,44,89,
     72,75,,,76,237,,,,,16,14,,16,,,,16],
   [,,,,225,146,,164,371,1014,,,,115,108,118,74,,,,,111,,,,248,320,,255,291,
     266,,,425,493,,,416,,,,164,,99,313,110,,115,,203,,,184],
   [,,,,186,176,272,160,281,,,,,86,,,74,,106,114,,109,,,305,183,,281,211,257,
     233,293,250,434,514,,328,451,,352,,112,,99,236,107,,131,,171,271,,,108],
   [,,,,,,,,447,666,,,,56,67,74,68,,67,74,,74,,,,188,224,163,,,206,259,189,
     491,353,,210,407,,708,,97,104,72,,122,,97,,104,,,104,61],[],
   [,,,,252,136,279,,,,,,,,129,171,,,,,,151,,,391,227,339,,,297,,,242,733,,,341,
     573,,680,,,,,467,113,,116,,,415,,224,,63,64],
   [,,,,134,,177,113,223,339,,,,56,63,74,56,,63,74,,74,,,,167,,163,150,208,
     161,242,,373,,,210,358,,,,91,102,70,202,84,,91,,102,,,102,,62,42,,64],
   [,,,,,82,62,63,74,90,,,,84,54,95,60,,60,,,78,,,,74,85,49,61,,,50,,85,384,
     ,237,269,,,,67,109,65,71,49,,49,,109,69,,105,425,397,319],
   [,,,,90,59,70,56,,,,,,43,,,,,47,80,,63,,,62,37,,48,43,52,44,64,41,77,321,
     ,233,233,,113,,41,,45,76,41,,44,,73,83,,89,377,297,296,,361,255,68],
   [,,,,,,,64,,87,,,,60,53,68,54,,53,76,,69,,,,51,55,34,,,59,61,45,102,275,,
     184,280,,95,,48,73,33,,43,,48,,73,58,,77,316,365,251,,329,260,48,47],
   [,,,,52,47,57,45,,,,,,42,43,58,,,38,63,,51,,,60,45,51,,41,50,40,,43,,248,
     ,173,188,,93,,40,,35,61,33,,35,,60,65,,56,266,258,228,,298,217,41,41,
     39],[,,,,54,67,60,,,,,,,84,73,105,51,,,,,,,,56,51,80,,61,52,,,53,78,,,
     294,283,,94,,71,,46,63,42,,42,,,72,,,369,362,345,,363,302,66,47],
   [,,,,56,49,60,48,78,122,,,,39,54,53,54,,43,74,,53,,,,45,45,40,37,46,38,
     54,,76,,,185,221,,,,37,71,41,80,37,,40,,71,,,71,,281,243,,317,215,,35,
     39,35,47],[,,,,,72,,87,97,,,,,86,,97,73,,73,100,,,,,85,72,72,,,,82,
     71,69,,410,,328,372,,143,,67,92,,,60,,67,,92,,,81,,532,421,,650,442,66,
     68,,56,,63],[,,,,43,27,61,31,,77,,,,18,19,20,16,,19,20,,20,,,,44,61,
     77,,61,44,64,,,92,,87,93,,,,27,28,28,,26,,27,,28,,,28,115,116,,,122,,
     78,73,72,59,81,,93],
   [,,,,41,21,31,21,45,,,,,8,,,10,,13,10,,10,,,45,27,,31,29,45,27,39,40,
     56,63,,40,61,,52,,15,,13,39,15,,15,,15,39,,15,79,77,56,,91,56,55,43,
     49,37,67,39,66,16],
   [,,,,,,,15,36,44,,,,8,9,10,8,,9,10,,10,,,37,23,31,23,,,23,34,27,45,47,,
     30,45,,,,13,14,10,,12,,13,,14,35,,14,57,57,42,,58,42,41,39,35,31,40,
     35,53,14,8],[,,,,39,27,63,30,58,71,,,,18,19,20,,,19,20,,20,,,61,47,
     56,76,73,58,43,61,62,,91,,,89,,103,,26,27,,54,23,,26,,27,54,,27,116,
     119,118,,118,113,77,71,89,56,77,67,96,13,16,14],
   [,,,,41,,41,,,,,,,8,13,10,10,,,,,10,,,47,29,35,31,32,47,,,39,57,,,40,61,,
     86,,15,15,13,63,15,,15,,,41,,15,81,75,56,,91,56,53,49,47,39,63,45,
     64,16,8,8,16],[,,,,17,13,25,15,33,44,,,,8,9,10,8,,9,10,,10,,,,21,
     32,23,19,31,21,34,,53,,,30,49,,,,13,14,10,33,12,,13,,14,,,14,,,42,,
     61,42,,33,40,30,44,29,62,,8,6,,8],
   [,,,,43,27,61,31,94,,,,,18,19,20,20,,19,20,,20,,,82,45,57,55,,61,43,68,,
     ,98,,92,90,,,,27,28,28,,24,,27,,28,,,28,123,115,117,,120,117,78,74,
     75,59,77,73,92,13,16,14,13,16],
   [,,,,41,21,29,19,40,47,,,,8,13,10,10,,13,10,,,,,43,27,31,31,29,43,29,
     37,35,55,63,,40,61,,51,,15,15,13,37,15,,15,,15,37,,,77,77,56,,91,56,
     51,43,45,35,62,39,,16,8,8,16,8,8,16],[],
   [,,,,,,,,,,,,,31,28,39,28,,,,,39,,,,50,71,,,,,,,,,,,156,,,,25,,,,25,,,,,,,,,180,
     ,,,,,86,,69,73,,,,27,,,30,,,27],[],
   [,,,,,,,,,,,,,,,,28,,35,,,,,,81,,,32,27,43,27,49,32,68,,,158,,,,,,,,,25,,29,,,
     ,,,,341,184,,391,149,88,,50,30,57,39,75,54,49,29,55,61,19,49,55],
   [,,,,,,,,,,,,,31,,,21,,26,28,,24,,,62,48,61,,,,,54,58,,167,,112,128,,61,,25,
     ,16,38,18,,20,,35,43,,29,197,160,134,,,160,70,78,,57,106,,83,33,21,
     16,34,24,16,33,22,,25],
   [,,,,,,,,,,,,,,,,,,,,,,,,113,,,49,34,64,34,64,30,89,454,,,,,,,,,46,,34,,,,,,,,
     529,404,,,,251,120,,71,41,72,37,96,72,71,38,70,,34,,68],
   [,,,,,,,,,,,,,22,21,28,,,26,28,,28,,,,,,,,52,,,59,,,,,124,,61,,18,33,16,38,
     25,,20,,33,43,,33,,157,,,161,,66,76,,63,,94,95,,22,16,37,22,16,31,22,
     ,25,,,21],[,,,,,,,,,,,,,42,53,54,,,48,90,,46,,,,,55,,,,,,45,,599,,320,
     297,,,,42,56,,,,,42,,62,,,51,616,,,,438,230,58,37,50,,59,33,83,76,36,,
     66,46,30,102,34,,,,29,,43],[],[],
   [,,,,23,15,37,17,,,,,,10,11,12,,,11,12,,12,,,,26,35,27,,32,24,41,,58,,,,
     57,,,,15,16,12,,17,,15,,16,,,16,,67,53,,71,,,43,38,33,,,61,,10,8,,10,,
     ,10,,18,,26,17],[,,,,,15,,,,,,,,,,,11,,11,,,,,,,,55,28,21,,,,26,68,86,,
     35,57,,48,,,,12,28,16,,16,,,33,,,79,79,49,,,49,48,61,40,39,47,39,,18,
     18,7,18,18,7,18,18,,21,,,,,,,,,8],
   [,,,,,17,29,19,,,,,,,,,12,,10,,,,,,45,,,30,25,35,25,55,,62,166,,42,127,,47,
     ,,,13,27,17,,15,,,32,,,,103,58,,,56,60,,40,44,51,37,92,19,22,8,19,
     22,8,19,22,,22,,20,,,23,33,,,9],
   [,,,,,21,,27,,,,,,10,11,,13,,11,11,,11,,,53,34,35,36,,,,43,42,,76,,47,,,
     58,,17,,14,42,18,,16,,16,43,,16,93,91,65,,,65,61,55,48,45,72,47,,20,
     10,9,20,9,9,20,9,,27,,,20,,,57,,,10],[],
   [,,,,18,,26,16,34,45,,,,10,11,12,,,11,12,,12,,,50,27,30,,,29,23,33,26,,
     56,,39,53,,47,,14,15,12,28,,,14,,15,,,15,67,75,53,,72,53,45,41,36,
     34,45,33,61,18,9,8,18,9,7,18,9,,,,,18,41,24,32,,,8,8,9,10],
   [,,,,19,15,28,,,,,,,,10,,12,,,,,,,,43,27,33,30,23,31,,,29,56,,,42,86,,48,,
     15,,13,27,17,,,,,32,,,97,,58,,96,56,51,43,40,35,,37,60,19,22,8,19,
     22,8,19,22,,26,,,20,,,44,,,9,,9,,,9],
   [,,,,,20,30,,54,70,,,,10,11,11,13,,11,,,11,,,49,,40,35,33,53,,39,,69,,,
     47,83,,56,,16,16,14,38,18,,17,,,40,,16,142,95,65,,111,65,62,,50,44,
     72,43,83,20,9,9,20,10,9,20,9,,30,,75,25,93,32,45,,,10,,,10,,10],
   [],[,,,,,21,,21,,,,,,,11,11,13,,11,11,,,,,89,35,39,35,36,54,39,,49,68,
     83,,47,77,,58,,,16,14,42,18,,16,,16,43,,,105,95,65,,120,65,60,56,50,
     44,73,47,77,20,9,9,20,9,9,20,10,,27,,,,,,46,,,10,,,10,,10,,10],
   [,,,,21,,27,,,56,,,,36,28,52,28,,,,,52,,,,39,58,39,,39,,,,73,,,173,133,,,,
     22,,,,22,,,,,,,,,178,210,,,150,,65,59,56,,73,90,,32,,41,,18,,32,,,,,28,,
     28,,,,,21,21,35,,23,,,,35],[],
   [,,,,34,,,46,,,,,,,,,,,,85,,,,,69,,69,28,40,32,46,44,44,49,231,,,326,,,,,,
     27,46,29,,29,,,52,,,258,295,262,,266,199,76,76,39,38,52,52,56,56,46,
     27,56,49,27,58,49,,53,,,,,43,47,,,32,32,,,,36,,,,52],
   [,,,,,,29,,,,,,,36,,,28,,29,,,38,,,51,43,64,41,,,,,58,62,,,,139,,53,,22,,
     25,27,22,,31,,42,32,,44,299,186,200,,345,179,62,73,61,58,,75,74,41,
     26,22,39,,20,41,28,,43,,,,,30,,,,23,,,,,22,24,29,,57,22],
   [,,,,,,57,53,,,,,,,,,44,,51,125,,,,,77,,,31,47,35,49,47,30,52,415,,176,285,
     ,,,,,,,38,,39,,,69,,,530,357,236,,381,233,84,,42,41,55,37,59,75,64,35,
     75,70,34,73,68,,77,,31,,,58,49,,,33,,33,,,37,44,91,,75],
   [,,,,,,,,,,,,,,33,,33,,,,,,,,59,46,61,,,59,,,57,,351,,182,,,54,,27,,,54,27,,,,
     ,,,,,,224,,315,,70,76,70,61,,72,,46,46,25,50,46,25,46,51,,,,,38,,38,,,
     ,28,31,28,55,,,,,,57,,,,30,68],[],
   [,,,,25,,,,,47,,,,28,28,36,,,29,44,,36,,,,43,60,,,45,,61,63,61,272,,,137,,
     53,,22,46,25,27,22,,31,,46,32,,46,252,184,,,225,,,73,,61,62,77,79,40,
     28,22,39,30,20,,28,,43,,,30,,,,,,,,27,,,27,30,35,,,22,,,24,,30],
   [,,,,,54,67,,,88,,,,48,44,78,,,,,,62,,,,,58,44,,,48,,54,,,,211,319,,,,46,
     90,38,63,,,,,68,71,,66,404,374,279,,431,269,59,45,39,,53,41,56,74,42,
     37,75,43,38,76,40,,,,47,60,59,,,,,43,,43,45,,42,,49,,49,,,38,,46],
   [],[,,,,34,50,28,80,49,,,,,,39,,39,,35,96,,,,,79,35,44,44,59,31,65,49,
     40,,270,,174,,,94,,30,59,36,30,30,,39,,65,,,61,298,397,228,,306,238,
     87,52,40,43,58,48,,59,,31,56,35,33,59,31,,,,63,47,80,47,,,,33,37,32,
     37,,31,,,,37,,,34,34,45,,,34,43],
   [,,,,,131,,,335,,,,,,,,62,,75,,,153,,,390,,454,207,,,194,,218,,,,46,72,,,,,,
     82,421,87,,100,,195,,,,548,525,346,,780,474,390,322,270,221,357,340,
     399,92,75,46,93,79,50,96,75,,196,,,,,170,,,,54,,,,,,88,97,,102,,,205,,,
     293,,196],[,,,,,130,208,136,259,410,,,,,,89,64,,,,,120,,,295,147,308,
     346,191,400,,259,,,53,,53,74,,284,,88,,85,237,87,,133,,,243,,137,495,,,,
     ,356,344,241,425,226,377,229,482,92,63,48,95,65,51,91,63,,,,,,595,128,
     ,,,55,86,,82,,,123,,,,156,,250,149,415,221,,147,364,,,96],
   [,,,,,92,216,95,,,,,,40,49,54,62,,49,54,,54,,,,,172,117,165,164,,202,144,,
     54,,30,54,,,,71,76,52,311,100,,71,,76,301,,76,339,,210,,348,210,240,
     239,185,177,344,186,,89,40,30,91,40,30,,40,,,,136,,574,,,,,,35,42,47,,
     40,42,47,,47,145,,209,202,179,185,,,,,175,51],[],
   [,,,,17,13,25,15,33,44,,,,8,9,10,8,,9,10,,10,,,,21,32,23,19,31,21,34,,
     53,,,30,49,,,,13,14,10,33,12,,13,,14,,,14,,,42,,61,42,,33,40,30,44,
     29,62,,8,6,,8,6,,8,,,,19,16,34,16,30,,,,7,8,9,,7,8,9,,9,18,,27,20,
     34,25,,20,38,,33,50,51,30],
   [,,,,,15,27,17,,,,,,,,,9,,9,,,,,,40,,53,26,20,,22,,24,57,80,,35,56,,46,,,,
     12,26,14,,14,,,31,,,75,75,49,,,49,48,54,37,35,43,36,,16,16,7,16,16,
     7,16,16,,21,,,,,17,35,,,8,7,,,,8,8,17,,,20,,28,,,27,,22,,,31,,80,35,,
     7],[],[,,,,,19,29,23,,,,,,8,14,,10,,14,10,,10,,,45,27,31,31,31,45,
     27,37,35,,65,,40,85,,53,,15,,13,37,15,,15,,15,38,,15,84,,56,,101,56,
     53,43,45,35,,39,68,17,8,8,17,8,8,17,8,,26,,,,,22,34,,,9,,,,,9,,9,,
     9,32,,,26,,,,28,40,,32,,68,40,,8],[],
   [,,,,26,,,15,36,,,,,8,9,10,8,,9,10,,10,,,41,24,33,23,,31,24,36,29,,50,,
     30,,,,,13,14,10,,12,,13,,14,,,14,60,60,42,,,42,44,42,36,33,41,38,,15,
     8,6,15,8,6,15,8,,,,,16,42,16,,,,7,7,8,9,,,8,9,,9,,,27,24,,,,24,38,,
     35,51,,30,,6,7,,8],
   [,,,,21,,,17,,53,,,,8,9,10,,,9,10,,10,,,59,,37,24,21,31,23,,29,,53,,30,
     51,,46,,14,15,11,26,,,14,,15,31,,15,63,64,42,,65,42,45,54,39,33,62,
     36,59,13,8,6,13,8,6,13,8,,21,,20,17,,,,,,7,7,8,9,,7,8,9,,9,20,,,
     22,32,27,,,,,31,51,54,30,,6,7,,8,,6],[],
   [,,,,19,14,23,,,43,,,,,9,,9,,,,,,,,37,23,30,26,21,30,,37,26,50,,,35,61,,
     46,,14,,12,27,14,,,,,29,,,77,78,49,,76,49,45,37,37,30,45,33,57,16,
     16,7,16,16,7,16,16,,24,,23,18,,18,32,,,8,7,8,17,,8,,,,17,19,,,21,35,
     ,,21,,,,56,,35,,7,7,,,,7,7],
   [,,,,,19,45,,55,64,,,,8,,10,10,,14,,,10,,,62,30,37,31,,,,,41,58,,,40,63,,
     72,,15,15,13,,15,,15,,,70,,15,82,101,56,,,56,69,52,49,41,69,48,70,
     17,8,8,17,8,8,17,8,,28,,,28,,22,54,,,9,,,9,,9,,,,9,,,49,,78,,,32,,,
     38,85,70,40,,8,,,8,,8,8],[]],
 [,[],[],[],[,,,59],[],[,23,,77],[,,,,,17],[],[,27,,41],
   [16,,,,,,,15],[,16,,,,23,25,13],[,,,,80,,60,27],[,,,,,23,37,23],
   [,,,,51,,57,26],[24,16,,31,36,19,22,15,,29,8,6,14],
   [,,,67,78,,28,16,,56,,6,,10,14,6],[,,,,55,,58,26,,,,,13,,,14],
   [,,,72,61,27,39,,,,,,,,12,,14],[,23,,,37,,,13,,,8,6,14,,,6,6,14],
   [,,,,,,68,27,,,,,13,,,14,,13,,14],[,16,,,,23,25,13,,,,6,,,,6,6,,,6],
   [32,,,,60,46,71,,,53,32,,,,,32,62,107,65,,72],[],
   [,27,,,112,53,39,,,47,,30,,58,105,27,32,,57,34,,30],
   [,45,,69,,34,45,35,,54,,27,,27,,,,63,35,25,73,27,,,41],
   [,68,,,100,45,61,45,,71,,41,,,35,,46,72,43,35,105,41,,,47],
   [,31,,,,,,,,,26,23,54,31,44,23,24,52,45,23,52,23,,,31,30,36],
   [,,,,,,,29,,,,29,,33,,25,28,,41,,,29,,,,27,33],
   [,58,,64,51,,,76,,72,,54,84,67,70,44,78,74,86,46,,54,56,,58,56,62],
   [,,,,,30,,,,,26,23,42,33,33,21,23,41,,,45,23,,,,27,33,,25],
   [,45,,62,137,55,,,,59,60,48,126,44,,35,44,85,45,,,48,,,41,33,41,39,,65]
    ,[60,46,,67,,45,,49,,59,43,27,63,55,42,33,50,60,47,31,52,27,38,,39,,
     35,51,33,56,33],[60,,,61,,,34,43,,,,34,84,67,63,27,32,77,,29,,34,38,
     ,,35,41,,,,,,39],[136,,,,,145,,118,,310,65,,,74,131,,52,139,123,49,121,
     ,203,,,177,239,,187,,258,268,248],
   [,,,292,,142,,,,,86,,142,,,,52,,,,,,250,,273,147,,,195,389,,,,264,96],
   [,115,,,,,,,,,35,30,69,40,62,30,30,69,62,30,69,30,,,166,153,175,117,,,
     213,209,206,163,,53],[],
   [16,,,,46,17,28,15,,,7,,,,,8,8,17,,8,,,28,,,,,26,23,53,25,53,37,33,61,
     80,35],[,,,,57,,40,,,,,,,66,55,31,34,65,,,,,,,,51,,50,,65,,47,65,,,230 
    ],[,,,,66,33,52,29,,,,,,,,16,,15,,16,16,,,,,,,57,46,90,44,,59,,,253,76]
    ,[,,,,42,19,26,17,,31,,,,15,,,16,30,19,15,,,,,41,25,,29,27,52,27,33,
     53,35,105,88,71,,,31],
   [16,26,,40,38,17,28,19,,34,7,9,13,,,,8,13,,8,13,9,28,,34,,,26,23,49,
     23,47,34,32,72,,35,,7,,15],
   [,21,,,,,,13,,37,7,9,13,15,19,8,8,13,19,8,13,9,30,,28,24,33,23,,,22,
     36,29,30,57,77,35,,7,,15,15,7],
   [,46,,53,,,,,,40,,39,,48,52,31,34,65,56,,,39,77,,66,52,67,,,,,53,77,51,,
     219,,,,55,,31],[,16,,36,40,15,24,13,,31,7,9,19,17,21,8,,,21,8,19,
     9,48,,27,25,35,25,21,51,21,37,35,27,53,71,35,,7,31,,15,7,7,31],
   [,,,,58,33,52,29,,,,,16,,,16,,,,16,16,,62,,82,,111,56,45,78,43,97,,79,
     242,,76,,,,14,,15,15],
   [,,,60,50,19,38,,,,,17,,15,19,15,16,30,,,,17,50,,,29,37,29,31,56,,,41,,
     110,,71,,,,,13,,15,,15],
   [,,,44,59,,40,,,,,,,,55,31,34,63,,,,,,,58,,65,49,,67,,,75,,,241,306,,,35,,,,
     ,42,31],[16,26,,40,38,17,28,,,34,7,9,13,,,8,8,13,,,13,9,28,,38,25,
     ,26,22,49,22,,30,34,59,,35,,7,,15,,7,7,,7,15],
   [,,,53,,,30,,,,,39,,48,51,29,32,59,47,,,39,80,,,50,65,,,76,,49,63,,,237,
     231,,,35,,27,,,,29],
   [,,,,66,33,52,29,,,,,16,,,16,,15,,16,,,,,,,,57,46,86,48,,62,,195,,76,,,,14,
     ,15,15,,,14,,,15],
   [16,,,,46,17,28,15,,,7,,,,,8,8,17,,8,,,28,,,,,26,23,53,25,53,37,33,61,
     80,35,,7,,,,7,7,,7,,,,7],
   [164,,,,386,148,,167,,,79,,,115,161,61,62,159,,76,,,257,,,248,341,273,291,
     446,230,405,264,,487,524,316,,75,,,158,,73,,73,167,149,517,73,,,75],
   [284,162,,283,368,191,259,147,,253,79,61,,86,,,60,,150,59,165,61,300,,
     259,183,,285,235,418,,277,301,262,462,500,337,,75,252,207,112,,71,249,
     71,,118,254,71,245,212,75,108],
   [464,,,,,,,,,587,49,42,95,56,86,42,42,95,86,42,95,42,295,,,205,225,163,,,
     205,262,,226,380,,210,,49,293,104,97,49,49,,49,104,97,290,49,353,104,
     49,68,63],[,169,,288,659,160,274,155,,248,,64,145,,,,,,136,59,,64,,,
     263,191,250,460,235,612,287,285,246,280,419,,348,,,263,179,112,71,75,
     232,71,,115,242,86,229,175,,63],[],
   [112,,,225,310,117,184,101,,205,49,42,95,56,84,42,42,95,84,42,95,42,199,
     ,207,167,,163,159,373,211,241,,207,360,356,210,,49,218,102,91,49,49,
     230,49,102,91,241,49,207,102,49,64,,42,62],
   [48,,,,92,72,63,55,,73,46,,,84,99,43,46,121,78,,96,,42,,,74,80,67,63,80,
     ,77,57,54,285,368,220,,40,,,71,42,43,99,41,85,60,95,40,100,109,40,
     363,414,299,,,302],
   [120,67,,98,148,56,70,59,,88,61,39,115,43,,,,77,59,41,100,39,76,,58,37,
     ,47,44,81,47,54,51,54,286,241,233,,54,83,,41,,38,85,37,107,53,85,
     39,84,90,54,361,297,310,297,,255,68],
   [120,45,,83,,,,60,,,40,37,78,60,63,36,38,74,63,38,77,37,67,,45,51,57,
     34,,,67,58,72,44,279,360,187,,38,68,79,49,37,34,,35,79,49,69,37,66,
     79,38,351,377,253,369,,266,63,47],
   [92,56,,,96,45,60,47,,71,38,33,86,42,46,31,,,47,33,71,33,81,,56,45,51,
     ,40,86,43,60,51,50,213,226,173,,33,86,97,40,,31,66,27,,41,67,32,69,
     ,33,,260,231,242,,217,41,41,56],
   [92,,,83,115,91,65,,,76,67,54,,84,95,43,44,86,,,,54,81,,56,68,87,49,67,
     85,,,91,53,401,457,254,,65,67,141,67,44,43,67,41,106,43,,,72,,65,,
     416,323,346,,383,66,62,48,47],
   [64,49,,78,117,48,61,49,,76,39,29,71,39,57,29,34,65,55,35,71,29,52,,
     44,45,45,41,38,76,41,54,,46,279,229,185,,36,85,71,37,34,32,86,29,
     71,49,85,34,86,69,36,339,275,244,275,,215,47,35,41,35],
   [64,,,81,92,53,56,75,,,43,,103,86,,43,44,,,43,,,49,,,57,63,,,73,65,,55,,
     286,355,226,,43,,111,54,40,39,68,39,92,,,40,,,43,,364,356,355,,297,45,
     53,,39,,45],[36,,,,72,43,61,33,,64,17,,,18,28,18,16,23,28,18,23,,60,
     ,,48,69,62,,93,50,70,67,,109,101,81,,17,,,29,19,17,103,17,28,29,,19,
     ,28,17,141,129,111,125,,111,88,81,87,61,87,79,88],
   [38,32,,42,40,21,32,21,,37,18,12,24,8,,,10,24,14,10,24,12,48,,49,27,,
     31,27,56,29,39,39,45,61,63,40,,16,37,28,15,,12,38,14,28,15,39,14,
     35,28,16,91,77,56,77,,56,67,43,50,37,55,39,55,16],
   [,42,,56,,,,19,,47,17,12,23,8,12,10,10,23,12,10,23,12,,,53,29,35,31,,,
     31,40,39,47,61,64,40,,15,63,28,15,13,11,,13,28,15,,13,61,28,15,92,
     77,56,78,,56,66,49,48,39,53,45,53,16,8],
   [,37,,70,59,,53,32,,53,17,17,23,18,28,18,,,28,18,23,17,,,63,45,62,62,
     77,84,49,67,62,68,114,98,81,,17,65,27,28,19,17,61,17,,28,67,19,59,
     27,17,,125,111,129,,111,90,75,86,64,88,75,83,15,16,16],
   [38,39,,52,40,,42,,,,18,12,24,8,14,10,10,24,,,24,12,49,,53,29,35,31,
     30,54,,,39,47,64,65,40,,16,43,28,15,14,12,58,14,28,15,,,41,28,16,
     91,75,56,77,,56,65,49,48,39,53,45,53,16,8,8,16],
   [36,32,,45,38,23,32,19,,37,17,12,23,8,12,10,10,23,12,10,23,12,49,,49,
     27,35,31,31,55,29,39,,45,62,65,40,,15,43,26,15,13,11,36,13,26,15,
     43,13,41,26,15,96,77,56,77,,56,68,43,50,37,55,39,55,16,8,8,16,8],
   [32,,,80,101,43,59,33,,,17,17,23,18,28,18,16,23,28,18,,17,58,,,47,,61,,
     92,53,73,61,,136,99,81,,17,,28,29,19,17,103,17,28,29,,19,,,17,,125,
     111,125,,111,84,80,88,63,85,79,84,15,16,16,15,16,16],
   [,,,,46,23,30,19,,37,,,,8,14,10,10,,14,10,,,,,,27,31,31,27,61,31,37,35,
     45,,65,40,,,,,15,15,13,38,15,,15,54,15,33,,,,,56,82,,56,,43,46,35,53,
     39,53,,8,8,,8,8],
   [,,,,,,,,,,,,,,,21,28,,,,,,,,,,,,,,,,35,,,,,,,,,,20,25,,23,61,,,,,,,,273,172,317,
     ,145,,,51,,,41,69,,49,59,57,,51],
   [,,,,,,,,,,,,,31,37,21,22,46,,,,,,,,42,60,43,,79,,,58,,,133,102,,,,,19,,,,21,
     ,,,,,,,,150,134,159,,142,,74,69,63,64,98,,,21,26,43,22,40],
   [,,,,,,,,,,,,,,,39,38,,,,,,,,,,,,,,,,55,,,,,,,,,,34,,,35,77,,,40,,,,,398,,450,,
     252,,,,35,,43,,,67,,75,,70,88],[],
   [,,,,,,,,,,15,14,35,31,,15,15,,32,22,35,14,56,,48,38,52,,,,,73,53,,,153,
     96,,15,42,34,19,16,14,43,14,34,16,43,17,42,34,15,,137,122,149,,,77,
     66,,51,108,,64,35,27,24,,32,24,35,26,,19],[],
   [,,,,,,,,,,,16,31,22,27,16,,37,30,16,39,16,,,,42,58,,,67,,,54,52,,133,,,
     17,43,32,18,17,16,41,21,37,18,43,17,40,36,17,,156,,152,,,61,74,107,
     57,,,67,,22,22,43,22,22,45,22,,21,,,19],
   [,,,,,,,,,,,26,84,42,55,28,28,70,64,38,94,26,,,,47,55,,,,,,,,,308,262,,27,
     ,65,42,28,,,29,65,54,,30,,67,27,402,352,358,292,,229,59,37,51,35,58,
     33,56,92,36,,78,46,36,102,34,,,35],
   [,,,,,,,,,,,,,,,39,46,,,,,,51,,64,47,34,49,38,89,38,67,35,64,593,,,,,,77,,
     40,,,35,,,,34,,79,,,,,,,252,72,41,72,41,120,43,71,88,67,82,75,76,74,
     80,,35,,43,,,,,43],[,,,,56,19,32,17,,,,,,,,10,,,,10,,,,,,,,31,26,66,30,,
     ,,,133,42,,,,,,9,9,,,,,,9,,,,,103,58,116,,56,,,43,41,75,40,51,,22,22,
     22,22,20,23,,20,,,,16,,23,33,39],
   [,,,,89,25,41,21,,,,,,10,16,12,,,16,12,,,,,,34,39,35,,68,34,46,47,54,,,
     47,,,,,17,13,11,79,15,,17,,13,,,,,91,65,95,,65,,55,53,44,,47,63,,10,
     10,,10,10,,,,20,,,27],[],[],
   [,22,,,,17,,,,,8,7,18,10,14,8,7,18,13,7,18,7,32,,33,26,30,30,23,,,37,
     36,38,53,,39,,8,33,19,15,9,8,31,8,19,14,33,8,30,19,8,68,69,54,67,
     ,53,45,43,39,35,46,37,,20,10,9,20,9,9,20,9,26,17,,,14,,,,,9,10],
   [,18,,44,50,,25,15,,61,,,,,,10,,,,10,,,41,,31,27,33,31,,58,27,37,37,35,
     69,,42,,8,32,19,15,8,9,28,8,19,15,32,8,29,19,8,86,102,58,,,56,54,
     43,43,35,47,37,77,22,22,22,,22,20,22,,,20,,,,,,44,,9,,,,9],
   [,,,54,53,37,42,20,,,,,,10,,12,,,16,12,,,79,,67,41,34,36,57,69,33,42,
     46,55,83,83,47,,17,39,,16,13,11,39,,,16,41,13,39,,17,,95,65,103,,65,
     93,53,52,58,,43,64,20,9,10,20,9,9,20,9,,24,,,,,32,40,91,,10,,,10],
   [],[24,17,,34,,16,24,15,,30,8,7,18,10,13,7,7,18,14,8,18,7,33,,29,,
     36,27,23,65,29,33,,29,55,55,,,8,29,19,14,8,8,28,8,19,15,29,9,26,
     19,8,68,67,55,70,,53,45,,41,34,47,33,44,20,9,9,20,10,9,20,9,,18,
     43,,19,,24,37,43,9,10,,,8,9,10],
   [,,,,,21,45,21,,,,,,,16,12,,,,12,,,52,,,35,35,36,42,,35,,42,,77,,47,,,89,,
     ,13,11,,15,,17,,13,76,,,112,103,65,91,,65,70,56,51,45,61,47,,20,9,
     9,20,9,10,20,9,,41,,,27,,,,,,10,,,10,,10,,10],[],
   [,,,,46,,30,,,,,,,36,48,24,26,49,,,,,,,,49,54,41,,62,,45,70,,,143,200,,,,,
     28,,,27,24,,,,,31,,,,188,242,175,,156,,79,60,58,60,77,,,26,,47,30,32,,
     26,,,,,31,,30,,,,,,,23,22,31,,21],
   [,,,,112,53,48,,,75,,,,,,34,34,95,,,97,,,,,,,39,48,76,,,58,55,,439,,,,,,,
     34,33,112,32,81,,,,115,91,,,354,239,327,,233,,,39,38,,40,49,,64,69,81,
     ,66,,,31,,,,54,,,41,59,33,,,,33,,108,,,77],[],
   [,,,,,,36,,,35,27,24,41,36,,24,24,42,34,,41,24,,,,51,87,45,,104,,,87,49,
     294,170,,,26,43,41,28,26,23,32,22,43,27,43,24,31,41,26,325,208,272,
     197,,,91,85,79,81,,81,85,49,32,32,51,,30,49,32,,34,,,,,34,,,27,35,,,,
     26,34,,,35,,28],[],[],
   [,23,,60,60,,23,50,,26,28,27,58,,,24,26,,,27,58,27,56,,39,33,40,39,,
     56,59,46,40,29,208,,144,,25,39,50,24,25,25,27,22,50,30,38,25,26,50,
     25,265,321,188,239,,201,76,47,39,40,53,43,40,56,50,54,60,53,48,56,,
     51,38,,,,,38,60,,26,62,,,27,25,,,24,62,,27,39,,31],
   [,,,,44,,,,,29,,20,64,28,38,20,,40,32,22,,20,,,,49,68,,,60,,53,58,45,
     286,158,316,,22,36,43,22,22,21,30,24,41,25,36,22,29,39,22,246,186,,
     177,,160,,77,87,58,66,75,63,72,28,30,47,30,28,,28,,30,,,31,,,,,27,,,,,
     ,37,,25,,,24,,,28,,,27],
   [,,,,,53,,,,,49,50,,48,50,44,44,118,,,85,50,,,,50,58,50,,,50,,,,321,341,
     208,,42,,,46,49,39,63,38,79,,,38,,153,42,408,398,288,,,270,53,45,40,
     38,59,41,43,85,42,43,83,43,42,86,40,,,51,,66,,,,59,,48,,,39,,53,,43,
     45,,,38,,,,,64],[60,,,,,,51,52,,75,,,89,,,34,34,116,,34,,,38,,41,50,
     34,31,49,52,47,49,38,35,399,333,,,38,,84,,34,36,113,32,,68,,32,115,
     81,38,343,352,251,301,,234,55,41,43,41,84,40,46,84,66,69,83,65,66,,,
     41,122,59,,,,58,49,,37,75,,,43,,75,,39,,,,40,,,,,39,,46],
   [60,27,,46,,57,26,55,,27,34,,60,,,,32,,33,33,60,,38,,47,38,47,50,69,55,
     ,47,47,38,215,,173,,28,47,51,27,28,31,30,25,51,33,47,28,31,51,28,,
     354,227,256,,266,58,56,44,47,70,52,49,56,,33,53,33,34,56,29,69,44,,,,
     ,44,82,86,29,34,,,30,,,,26,34,,31,49,,,,,,31,49,49],
   [,,,337,,140,,,,,,61,193,,,49,,,,,,61,205,,,,322,227,,386,212,,215,,96,96,
     46,,,629,139,,57,59,,55,,,,59,,133,,505,519,350,,,474,289,322,283,271,
     424,292,275,,75,76,117,79,78,115,85,,,408,,,,145,,434,110,93,,,,,,,54,,,
     305,376,,,,,,203,,331,280],[],
   [,,,,,105,206,84,,,35,30,69,40,62,30,30,69,62,30,69,30,238,,172,149,
     171,117,195,,,191,,,,46,30,,35,,76,71,35,35,305,35,76,71,237,35,301,
     76,35,316,330,210,,,210,220,233,187,173,254,185,228,81,40,40,81,40,
     40,81,40,,112,,,,,,,,42,47,,,39,42,47,,39,47,,160,178,,,,,144,,,176,177,
     52],[],[,,,,46,23,30,19,,37,,,,8,14,10,10,,14,10,,,,,,27,31,31,27,
     61,31,37,35,45,,65,40,,,,,15,15,13,38,15,,15,54,15,33,,,,,56,82,,56,,
     43,46,35,53,39,53,,8,8,,8,8,,8,,,,,26,,22,34,,,,,,9,,9,,9,9,,26,,,32,
     ,,,28,40,,29,85,,40],[],[],
   [16,16,,33,38,15,25,19,,29,7,6,15,8,12,6,6,15,12,6,15,6,27,,30,21,
     32,23,21,53,25,34,32,31,49,50,30,,7,31,16,13,7,7,29,7,16,13,31,7,
     29,16,7,62,,42,,,42,44,33,40,30,,29,44,17,8,8,17,8,8,17,8,19,16,
     34,,,,16,30,34,8,9,,,,8,9,,7,9,,20,34,,22,,,31,20,38,34,33,,,30,,8],
   [,18,,43,39,,30,14,,,7,,17,,,8,8,,,8,17,,47,,30,23,30,26,,51,25,37,30,
     29,,80,35,,7,30,16,14,7,7,30,7,16,14,29,7,29,16,7,77,94,49,78,,
     49,59,37,38,30,44,33,44,17,16,15,17,16,15,17,,23,18,,,,,18,32,,8,17,
     ,,8,,,,8,17,,22,34,,26,,,,22,55,34,,62,,35,,,,,7],
   [,,,55,48,25,48,19,,,,,,8,,10,10,,14,10,,,54,,,30,37,31,47,58,47,42,41,
     ,68,92,40,,,,,15,15,13,,15,,15,70,15,,,,101,79,56,88,,56,69,52,49,
     41,69,48,,17,8,8,17,8,8,17,8,,,,,,,22,54,,,9,,,9,,,,9,9,,48,78,,51,,,
     ,32,44,78,,92,,40,,8,,,8],
   [,20,,,,17,,,,,7,6,13,8,13,6,6,13,13,6,13,6,50,,31,27,37,24,23,,25,,,
     31,51,,30,,7,31,14,14,7,7,29,7,14,14,31,7,28,14,7,63,62,42,64,,
     42,45,42,39,33,46,36,44,15,8,8,15,8,8,15,8,21,17,37,,15,,,,,8,9,,,
     7,8,9,,7,9,,22,32,,26,,,25,,,32,28,53,,30,,8,,,6,7,8],[],[],
   [16,25,,36,,15,,13,,35,7,6,15,8,12,6,6,15,12,6,15,6,27,,34,24,33,23,
     24,,,35,33,,,51,30,,7,32,16,13,7,7,32,7,16,13,31,7,31,16,7,63,61,
     42,63,,42,41,42,37,33,44,38,40,17,8,8,17,8,8,17,8,,16,42,,,,16,,
     42,8,9,,,7,8,9,,,9,,24,,,,,,30,24,38,34,39,49,,30,,8,,,6,7,8,6],
   [],[,,,,,19,33,19,,54,,,,8,14,10,10,,,10,,,,,54,27,36,31,31,61,31,40,
     40,61,68,,40,,,56,,15,15,13,41,15,,15,,15,41,,,105,82,56,,,56,72,43,
     52,38,72,39,76,17,8,8,17,8,8,17,8,,26,,,26,,22,38,,,9,,,9,,9,,9,,,
     32,,,32,,,,28,44,,,,,40,,8,,,8,,8,8,,,8]],
 [,[],[],[],[,27,,46],[,,46],[,40,,62],[,,46],[],[],
   [42,,,,142,,,74],[,88,,,102,125,151,87],[,,108,,418,,610,142],
   [42,,,,,,228,,,,21],[,148,,,128,,,,,,,41],[],
   [64,,92,267,144,,213,,,,,32,,34,42],
   [170,425,140,,330,,373,150,,,,,43,47,64],
   [64,,80,,104,149,149,,,,37,42,89,,33,,41,83],
   [,,142,,,,,116,,,47,67,67,,,,69,67],
   [,,,,420,,551,144,,,,,43,47,64,,,43,,67],
   [178,,162,,,236,,136,,,53,70,61,,,,58,61,,43,61],
   [28,,,,40,122,52,,,,84,,,84,,,114,246,115,,264,240],
   [,,,,,80,,80,,,,,,,,,136,262,132,251,418,245],
   [,39,,,52,284,64,,,,,138,,,179,,169,469,150,360,411,330],
   [28,,,,47,110,58,110,,,79,,,73,,,,237,94,225,229,233,28],
   [,,,,,,85,,,,,126,,,133,,152,230,128,361,255,322,,,46],
   [28,40,116,58,,,,,,,84,123,190,84,,,,,,190,192,200,28,,39,28,39],
   [,,93,,,,,109,,,,193,,,,,324,,200,,,441,,86,,92,126],
   [,52,228,73,39,,,284,,,148,145,311,,175,,162,360,148,340,406,377,39,,50,
     44,46],[],[,,,58,55,,70,,,,147,,,168,,,157,374,142,,278,597,,,39,41,
     46,39,,53],[50,64,116,86,73,153,,164,,,134,133,279,166,126,,147,240,
     135,322,285,252,39,84,47,,32,39,130,46,,47],
   [50,54,,83,47,,52,380,,,,160,,161,168,,169,556,158,303,,288,39,,51,41,46,,
     ,39,,55,46],[70,,,,,,288,,,,105,,,105,,,,283,195,275,277,307,140,,,125,
     ,140,659,,,225,195,219],
   [70,,,,149,,249,272,,,105,,,105,,,190,,224,311,287,281,140,,,119,,140,,226,,
     229,,226,35],[70,185,,420,,,,,,,105,166,243,105,166,,168,229,175,,225,
     227,140,672,220,125,191,140,,,,221,193,225,35,35],
   [70,,228,272,155,,248,,,,105,187,271,105,,,,,195,277,265,,140,375,204,119,
     168,140,809,200,,201,168,206,35,35,35],
   [42,,,,97,68,,72,,,37,,,42,,,47,121,54,78,,82,84,,,74,,84,130,123,,136,
     112,123,195,195,189,195],
   [,,,,104,,125,,,,,,,,,,240,,,,,1147,,,,,,132,,156,,130,182,160,,,,530],
   [,,,,508,164,,266,,,,,,,,,,67,119,101,70,91,,212,,,,,284,399,,340,271,,,,
     327,434],[42,,,,,76,112,76,,,42,,,37,,,52,78,49,117,78,,74,,,59,,74,
     139,,,100,140,100,180,168,174,168,42],
   [,,,,541,206,394,284,,,,,,,,,85,93,,67,91,67,,311,,,,,262,356,,473,343,331,,
     ,330,442,,,82],[42,98,66,198,,,,72,,,37,,79,37,49,,49,,,73,73,73,84,
     116,123,74,112,84,,,,123,113,137,166,166,154,164,37,,62,37,62],[],
   [42,77,,124,,72,,,,,37,48,117,42,52,,,,58,78,115,78,74,115,104,59,86,74,
     148,,,101,86,100,180,168,174,168,37,90,,32,94,37],[],
   [42,,66,187,105,68,176,,,,42,53,78,37,47,,54,82,,,78,129,84,118,135,74,
     113,84,134,130,,,,125,195,195,189,195,42,,78,37,,37,,42],
   [,,,114,104,,129,,,,,,,511,243,,218,,,,,710,,,136,,225,130,,154,,,200,164,,,
     1254,542,,90,,90,,,,126],[],
   [,100,,146,,,104,,,,,246,,522,228,,,727,,,,,130,,152,176,,,,134,,170,197,,,
     592,884,,,105,,126,,,,126,,,111],
   [,,,,,168,,236,,,,,67,81,99,,,68,119,102,,93,,333,,,259,278,286,414,,351,
     259,,480,,,441,,,61,76,82,63,,,,78],
   [192,401,191,,392,184,456,240,,,100,117,92,,,,85,91,,67,96,,256,267,340,,,
     240,305,407,,475,360,,503,,349,,94,,84,,61,62,,75,,,,,,82],
   [14,,,,30,46,,48,,,21,,,21,,,40,59,,59,59,71,28,,,24,,28,89,46,,45,39,
     45,35,35,35,35,38,,,34,,34,,34,,38,100,,136,108,108],
   [14,,,,30,46,,48,,,21,,,21,,,40,59,,59,59,71,28,,,24,,28,89,46,,45,39,
     45,35,35,35,35,38,,,34,,34,,34,,38,100,,136,108,108,7],
   [14,,,56,,,,,,,21,32,41,21,31,,31,43,32,41,43,43,28,103,,25,36,28,,,,43,
     36,42,35,35,35,35,37,154,56,34,55,30,,34,,37,154,,130,55,56,7,7],
   [14,25,40,40,29,40,40,44,,,21,35,55,21,34,,,,35,49,49,51,28,60,38,23,
     32,28,73,39,,39,32,39,35,35,35,35,39,78,71,32,84,32,,32,,39,78,,74,
     70,,7,7,7],[14,,68,,33,48,,,,,21,34,51,21,35,,,55,,,49,55,28,121,
     42,25,36,28,,43,,,36,41,35,35,35,35,39,154,70,36,86,32,,36,,39,,,
     282,71,84,7,7,7,7],
   [14,25,40,42,26,56,40,40,,,21,31,41,21,36,,33,43,32,41,41,43,28,60,
     40,23,,28,77,41,,41,,40,35,35,35,35,37,80,57,32,55,30,,32,,37,76,,
     84,58,57,7,7,7,7,7],
   [46,,,,64,186,75,188,,,148,,,158,,,162,345,165,,378,351,44,,,51,,51,202,61,
     ,54,60,62,236,248,236,224,134,,,126,,146,,114,,134,167,,185,398,357,
     48,48,46,44,46,48],
   [56,,,,79,170,90,166,,,153,,,135,,,,351,171,353,353,347,51,,,41,,51,150,65,
     ,61,50,62,235,217,235,217,138,,,113,,138,,113,,138,208,,218,446,462,
     44,44,47,41,47,41,51],
   [56,65,174,86,,,,214,,,148,169,320,158,175,,,307,179,318,290,305,51,,62,
     51,62,44,,,,61,60,55,236,248,236,224,146,187,,126,,134,,114,,144,179,,
     177,341,341,48,48,46,44,46,48,51,51],
   [46,58,132,83,58,164,75,164,,,122,124,301,124,,,,,132,298,287,294,44,97,
     56,41,50,44,135,56,,56,50,56,186,186,186,168,109,171,308,104,,109,,86,
     ,110,205,,,392,294,37,37,36,32,36,34,44,41,44],
   [46,,160,78,64,216,75,,,,148,166,,158,168,,172,349,,,358,367,44,,55,51,
     60,51,,61,,,62,62,236,248,236,224,134,173,370,126,395,146,,114,,134,,,
     185,345,456,48,48,46,44,46,48,44,51,51,44],
   [56,81,126,,73,152,84,,,,153,166,311,135,171,,168,291,171,,311,295,51,
     129,62,41,50,51,146,61,,63,,61,235,217,235,217,138,280,346,113,342,
     138,,113,,138,280,,204,342,346,44,44,47,41,47,41,51,41,51,41,51],
   [56,70,,,60,228,67,,,,148,192,364,158,,,,349,,,,347,51,208,66,51,60,44,,
     54,,61,,,236,248,236,224,146,207,389,126,368,134,,114,,144,179,,,,386,
     48,48,46,44,46,48,51,51,44,44,51,51],
   [126,,,,256,194,,182,,,53,,,63,,,103,73,91,83,73,85,232,,,207,,220,,341,,
     341,303,,285,285,273,285,101,,,106,,87,,101,,106,549,,,115,130,55,55,
     53,57,57,53,372,369,360,294,372,353,372],
   [126,,,,234,,354,224,,,63,,,53,,,86,83,104,73,83,75,232,,,201,,220,477,346,
     ,336,314,347,285,285,273,285,106,,,101,,87,,106,,101,486,,486,126,120,
     55,55,53,57,57,53,384,351,372,294,384,335,384,63],
   [106,230,122,421,,,,138,,,53,75,77,53,73,,73,77,81,73,73,79,188,213,284,
     173,246,164,,,,275,228,282,227,227,203,223,87,458,115,87,116,66,,87,,
     87,,,466,110,115,47,47,39,43,43,39,296,299,272,242,296,279,296,53,53]
    ,[126,235,188,436,,184,,,,,53,102,75,63,86,,,,91,87,73,85,232,,316,201,
     276,220,420,323,,322,276,306,285,285,273,285,101,448,119,106,126,87,,
     101,,106,494,,534,115,129,55,55,53,57,57,53,360,351,348,276,360,335,
     360,53,63,53],[126,,166,495,,,431,,,,63,89,85,53,102,,86,91,,,83,75,
     232,289,342,207,292,220,,342,,,,342,285,285,273,285,106,531,131,101,
     116,87,,106,,101,,,529,125,119,55,55,53,57,57,53,372,369,360,294,372,
     353,372,63,53,53,63],
   [106,199,128,397,166,136,272,164,,,53,75,79,53,76,,75,73,77,77,79,79,
     188,229,283,165,257,164,,251,,288,,279,227,227,203,223,87,382,120,87,
     111,66,,87,,87,310,,374,121,122,47,47,39,43,43,39,308,275,284,238,
     308,255,308,53,53,39,53,53],
   [126,245,,492,261,190,376,212,,,53,104,77,63,89,,103,73,95,83,,95,232,
     396,333,207,301,220,,343,,354,305,,285,285,273,285,101,,123,106,125,87,
     ,101,,106,,,,,153,55,55,53,57,57,53,374,369,362,296,374,353,374,53,
     63,53,53,63,53],
   [126,,164,,241,214,,186,,,63,83,87,53,103,,83,83,108,73,89,,232,293,,199,
     266,220,,334,,316,283,325,285,285,273,285,106,429,133,101,115,87,,106,,
     101,526,,383,143,,55,55,53,57,57,53,362,345,350,276,362,329,362,63,
     53,53,63,53,53,63],
   [,,,,,,,,,,,,,,,,135,,,,,,,,,,,,,,,,46,,,,,,,,,,,111,,93,,110,,,,,286,,,35,31,,29,
     ,,,47,,60,,,,258,255,295,,,276],
   [,,,,,,,,,,,,,,,,110,,,,,248,,,,,,120,,152,,,168,166,,,280,,,,,,,,,40,,,,,,,,,,
     52,38,56,40,,,174,126,160,176,174,,,,180,184,164,,170],
   [,,,,,,,,,,,,,,,,139,476,206,,,700,,,,,,,,,,,66,,,,317,232,,,,,,166,,122,,158,,,,
     ,356,,,,40,,40,,,,,,53,,,,346,346,,,398,350],[],[],[],
   [,,,,,,,,,,,92,108,,78,,,140,189,142,,162,,,,,168,126,,166,,,133,,,,,228,64,
     108,142,36,148,66,,40,,66,104,,108,139,146,,,,40,68,40,166,160,178,132,
     ,164,206,,,122,188,166,128,,164,,40],[],
   [,,,,,,,,,,,,,221,189,,183,822,,,,512,52,100,69,,36,52,138,71,,74,46,75,
     326,250,272,232,,,627,168,370,158,,,,164,,,,456,370,50,50,,36,52,40,75,
     47,75,47,77,53,87,396,366,346,348,,299,396,350,46,,53],
   [,,,,,110,,,,,,,,,,,,,54,,,99,,,,,,132,165,173,,,128,,,,,190,,,,,,33,,,,44,,,,,
     127,,,32,35,,32,,,168,131,175,174,176,,,88,104,107,93,107,106,99,,,,,,
     119,,143],[,,,,262,140,550,146,,,,,,,,,,,89,85,,99,,,,,,186,,302,,350,
     250,374,,,,289,,,,,,81,,115,,104,488,,,,242,,,43,49,47,41,,,314,,,307,356,
     ,,43,,63,45,,67,,108],
   [42,142,,,,74,,,,,21,41,,21,41,,41,67,41,67,61,61,84,,148,79,,84,153,,,
     152,132,154,105,105,105,105,42,194,86,42,86,32,,42,,42,194,,192,86,
     86,21,21,21,21,21,21,148,153,148,122,148,153,148,63,63,43,63,63,43,
     63,63,165,68,,,,,,,,37,47],[],[],
   [,88,,216,101,,151,84,,,,,,41,60,,,,61,73,,76,115,164,136,89,125,127,,144,
     ,153,130,164,190,195,166,199,47,196,74,39,60,33,,48,,39,192,,204,74,
     60,40,40,31,35,,31,170,164,167,125,,164,177,103,102,,,105,87,104,102,,
     92,243,,,,,,212,33,,37],
   [,428,,657,,144,,162,,,,,,65,86,,,,89,91,,85,,436,447,235,258,188,315,,,
     334,234,535,271,,,289,117,435,,102,149,83,,,,106,528,,,,,59,59,41,47,
     49,43,351,347,303,298,369,295,345,73,57,43,75,57,41,73,57,,,570,,,,,,
     598,,43,47],[,101,110,175,88,84,181,,,,37,55,80,41,32,,58,86,37,121,
     ,131,128,164,144,88,125,132,154,136,,145,127,143,190,218,167,186,56,,
     99,39,,39,,,,44,217,,271,99,136,,,31,34,35,31,164,163,176,125,176,167,
     171,88,102,59,87,105,61,89,102,170,116,,,,,,,,44,70,,,,41,67],
   [186,,,,,138,,132,,,47,73,93,65,123,,68,93,133,47,85,43,236,352,259,,430,,
     ,428,,,,253,273,295,227,279,78,340,107,104,57,58,,78,,106,348,,368,
     107,57,71,71,41,51,49,41,350,,304,296,352,,,83,59,59,85,63,61,83,59,
     ,142,521,,,,,,575,,63,,,,61,63],
   [,,,,,122,592,146,,,,,,69,101,,,,120,,,87,242,,374,241,323,196,,,,331,318,,,
     283,237,,,643,,110,149,85,,119,,106,,,588,,149,59,59,43,55,49,43,380,
     365,313,342,382,,,75,59,43,75,61,45,79,59,,164,,,,,,,,,45,53,,,,45,83,
     61],[,,,,,146,,122,,,53,85,91,69,,,,91,,47,,53,,,,241,323,192,325,374,
     ,458,432,308,,295,243,,86,382,164,110,74,76,,,,106,334,,364,139,127,
     59,59,43,49,49,43,369,379,330,342,373,335,424,93,61,61,,61,65,103,67,
     ,140,,,,,,,,127,67,,,,83,63,,45,65],
   [,,,,75,,104,,,,,,,,,,167,,,,,,,,,,,112,,130,,133,199,134,,,715,479,,,,,,,,86,,,
     ,,84,,,,,,57,175,60,,,165,,212,229,174,,,,377,349,257,,301,,,,,,,73,,,,,
     128,,,132,236,198,227,329,246],
   [,,,,60,234,70,,,,,,,,,,150,389,194,386,376,323,,,,,,48,,57,,,62,54,,,,,,,,,,
     127,,109,,138,,,174,396,349,,,42,39,45,41,,,47,40,,52,,,,289,319,352,,,
     342,41,,,,,,,,66,146,,156,,,,737,168,355,543,449],
   [28,,124,,40,,52,122,,,84,115,236,84,114,,,246,,236,,254,28,108,46,28,46,
     28,129,39,,47,47,39,140,140,140,140,84,,256,74,,84,,74,,84,,,130,,,28,
     28,28,28,28,28,51,51,46,38,51,51,46,232,232,188,232,232,188,232,232,
     42,128,52,,,,114,,,116,260,84,,,,246,,262,,242,,40],[],[],
   [28,27,98,62,27,,62,,,,79,107,227,73,88,,91,,,229,233,,28,,50,28,39,28,,
     50,,55,39,55,125,119,125,119,74,,202,61,,74,,61,,74,119,,119,200,217,
     24,24,25,23,25,23,51,50,51,39,51,50,51,207,201,173,201,207,165,207,
     199,47,102,58,,,,86,,66,93,219,79,,,,,,243,231,231,92,44,28],
   [,40,,78,40,169,40,,,,131,133,351,166,126,,131,,142,263,342,326,39,156,
     61,39,46,48,180,39,,,46,38,193,,194,168,111,206,273,82,252,,,82,,,,,
     82,274,257,41,41,36,32,36,40,60,53,47,45,60,53,45,288,314,249,264,
     299,257,288,278,,136,79,,,,136,,73,133,339,133,,,133,,152,228,379,277,,
     47,40],[,,,,98,,138,,,,,154,325,159,149,,,301,239,,,277,,,,139,,133,,
     170,,216,195,190,911,686,911,809,130,119,297,75,272,140,,86,,140,118,,
     110,245,268,86,86,,73,89,71,,239,199,,,251,,343,355,274,421,347,,,,,95,,
     ,,,,,,203,,,,,,721,199,,,,86,,,,,,126],
   [,,,,62,214,71,,,,152,178,332,155,138,,153,,,,281,432,,187,,51,61,47,,60,,
     ,61,56,220,224,,201,137,,304,128,456,124,,107,,,,,187,300,333,43,43,
     42,38,42,41,54,48,45,40,55,48,45,341,333,289,321,329,283,344,319,47,
     ,52,,,,,,64,148,,150,,,168,365,154,348,379,529,,40,39,,,41,46],
   [50,,154,,63,,69,,,,,,,160,149,,147,458,181,297,,250,39,138,56,51,38,39,
     190,46,,57,39,46,220,227,,206,123,,442,132,279,136,,108,,125,,,201,336,
     301,43,43,42,38,41,41,61,49,54,49,62,52,,326,349,289,308,342,288,,
     325,60,182,68,,,,,,,147,,146,,,,400,158,314,,,,52,,,,41,46,,51],
   [50,,,,40,216,36,187,,,134,134,255,,129,,136,368,143,358,272,,39,156,,39,
     46,47,195,38,,69,46,39,192,224,192,168,112,130,266,78,277,114,,78,,
     112,130,,84,269,272,42,42,36,32,36,36,62,54,46,46,62,57,,300,,244,
     276,284,258,305,263,,106,,,,,,,,142,282,129,,,129,318,144,270,333,324,84,
     ,39,,,,32,130,47,46],
   [70,169,308,304,195,324,,,,,105,192,271,105,,,204,,193,,285,271,140,622,
     220,125,193,140,,226,,,195,,35,35,35,35,195,,503,180,480,166,,180,,195,,
     ,842,,,35,35,35,35,35,35,236,235,236,186,236,235,236,285,285,227,285,
     285,227,285,285,216,272,286,,,,308,,318,200,283,105,,,191,,192,271,,291,
     562,231,140,,,125,193,622,,226,193],
   [70,150,224,317,151,294,,,,,105,197,275,105,192,,193,291,197,,,287,140,
     440,228,119,224,140,567,230,,233,,231,35,35,35,35,195,,474,168,466,166,
     ,168,,195,638,,576,461,461,35,35,35,35,35,35,248,217,248,186,248,217,
     248,285,285,227,285,285,227,285,285,157,,251,,,,224,,251,194,277,105,,,,
     ,186,,303,299,407,228,140,,,119,,567,223,231,,35],
   [70,214,,331,,366,317,312,,,105,166,229,105,165,,166,229,175,229,231,231,
     140,568,227,125,194,140,911,220,,220,192,,35,35,35,35,189,,327,174,
     331,154,,174,,189,848,,1299,334,332,35,35,35,35,35,35,236,235,236,186,
     236,235,236,273,273,203,273,273,203,273,273,,,272,,,,,,317,175,237,105,,,
     ,229,167,229,237,235,547,227,140,,,125,192,,,225,193,35,35],
   [,,,,,132,,144,,,,,,,,,,426,190,392,417,376,,,,,,,118,,,,130,,,,848,542,,,,,,
     171,,164,,170,,,,392,,,,154,78,154,80,,,,90,,105,,,,312,500,410,356,,386,,
     ,,,,,,,129,,,,,,258,658,230,,,,,,132,,,,175,,132,164,200,854,638,1254],
   [,,,,,150,,166,,,,,,,,,74,,98,120,,155,,,,,,273,245,325,,,269,336,,,334,441,,,
     ,,,103,,112,,115,392,,389,,219,,,55,84,86,55,,,344,268,345,320,386,,,,,
     82,61,,85,,,,,,,166,,,,,,,,,67,95,95,75,105,213,,257,,,323,837,286,394,,
     259,465,461],[42,97,,166,,72,166,68,,,42,41,100,42,41,,40,108,40,
     104,100,102,84,,123,74,,84,138,,,124,114,135,195,195,189,195,42,171,
     115,42,126,42,,42,,42,169,,169,115,126,38,38,37,39,39,37,146,138,134,
     109,146,138,134,106,106,71,106,106,69,106,106,102,66,156,,,,64,,158,
     54,78,37,,,56,78,47,117,86,,117,125,84,,,74,113,132,123,136,113,195,
     195,189],[],[],
   [42,81,46,162,82,46,150,40,,,37,,115,42,58,,48,,53,78,117,78,74,86,129,
     61,82,74,86,131,,134,78,133,180,168,174,168,37,196,112,42,71,37,,37,,
     42,,,194,110,71,34,34,34,32,36,32,126,103,126,82,126,99,126,101,106,
     87,101,106,87,101,106,83,72,112,,,,68,,108,49,117,42,,,,,52,82,119,86,
     ,107,74,,,59,,,103,100,140,180,168,174,,,42],[],
   [42,96,,183,96,70,,70,,,37,32,83,32,39,,32,81,41,62,81,60,84,,134,74,
     112,84,143,123,,,112,123,166,166,154,164,37,171,101,42,71,37,,37,,42,
     169,,173,,71,34,34,30,32,32,30,134,138,146,109,134,138,146,87,80,58,
     87,80,59,87,78,104,66,156,,,,,,162,,79,37,,,49,,49,71,75,75,116,138,
     84,,,74,112,,,123,112,166,166,154,,62,37,,,37],
   [,,,,,144,,132,,,,,599,,226,,190,382,189,437,,400,,,,119,,,119,,,,130,,,639,,
     530,,,612,,361,169,,164,,176,,,,,378,100,100,154,78,,76,169,101,175,90,
     173,97,167,588,408,306,394,410,331,,406,,,106,,,,,,125,,,,,,230,738,258,,,
     ,,138,130,,,,185,,,160,182,1202,,,90,,,,,90],
   [42,,46,176,95,40,120,46,,,42,42,108,42,39,,41,100,42,108,102,100,74,,
     106,61,82,74,75,106,,106,78,,180,168,174,168,42,214,,42,131,42,,42,,
     42,214,,,131,,34,34,34,32,36,32,114,103,114,82,114,99,114,106,106,71,
     106,106,69,106,106,99,,116,,,,72,,128,58,,37,,,52,78,,,,119,155,111,74,,
     ,59,86,144,100,100,86,180,168,174,90,94,37,,,32,,37,126],
   [,,,483,,166,405,150,,,,67,145,,136,,56,,136,67,226,59,,,325,200,,271,272,,
     ,336,277,279,,450,331,442,,361,193,,71,71,,71,,126,,,414,,71,108,108,
     55,70,71,58,359,337,347,268,395,335,345,125,77,77,130,82,78,125,75,
     326,186,483,,,,160,,430,119,94,,,,95,91,,,105,75,274,349,418,,,323,292,
     262,356,331,343,463,466,330,,82,,,,76,,63],
   [,,,,,132,,142,,,,,,226,207,,192,467,189,393,399,366,130,84,173,119,82,
     134,110,173,,177,84,185,1372,583,,728,,,481,213,450,173,,,,170,,,,,462,
     136,136,130,74,282,84,179,101,181,101,187,105,207,,439,316,,408,320,,
     382,124,,129,,,,,,,,,,,,225,,248,739,,,,164,,,,136,175,,152,,197,1202,605,
     1281,105,,,,,126,,,111,126],
   [,,,,273,154,311,167,,,,,,90,93,,74,,92,,,114,,,362,217,294,265,297,276,,
     336,266,442,500,,327,434,,612,,131,193,,,112,,117,,,342,,174,108,108,56,
     ,84,57,403,350,317,266,370,318,498,115,77,57,115,77,61,123,75,,220,,,,
     ,156,,,,67,100,,,,67,99,107,,95,,,301,,,457,,284,454,,271,476,474,327,,
     61,94,,,,,62,,75,82],
   [192,,,,386,,350,148,,,100,70,214,90,163,,62,168,148,65,174,70,285,,335,
     238,329,,305,477,,426,310,338,471,498,,,94,482,,135,86,87,,85,,,391,,,
     220,94,108,108,57,71,,57,401,387,369,294,496,393,447,162,81,81,162,
     81,101,188,85,,,586,,,,164,,593,182,,,,,,93,,69,101,,283,480,,,,,,308,
     389,426,326,524,,348,,85,,,,94,,64,,,62,,84]],
 [,[],[],[],[,21],[,,28],[,,,35],[,,28,,,28],[,,,30,37,,35],
   [,37,,35,,,30,,35],[42,,,,,,,68],[,77,,,90],[,,122],
   [42,63,64,100,63,74,100,74,100,100,21,34,53],[,117,98,,119,,,,,,34,43]
    ,[,135,128,272,203,166,204,126,284,312,,58,63],
   [,,101,195,,,,92,,,,33,,37,41],
   [,,126,304,183,166,222,128,294,288,,,45,53,58,61],
   [,77,93,133,90,100,128,,,115,34,44,83,,32,,42,64],
   [,,,,355,,,122,,,53,,65,,,45,127,63],
   [,,118,,411,,,142,,,,,45,47,55,63,,43,67,61],
   [,153,134,300,193,170,252,122,356,298,47,69,,,,43,98,67,,45,71],
   [28,,,,,,,,,,84,,,84,,268,126,268,124,,246,254],
   [,,,,,,,46,,,,,,85,99,167,111,155,131,,369,173],
   [,37,,,42,,,,46,55,,130,,121,176,235,190,389,131,398,453,249],
   [28,37,44,46,37,44,46,44,46,46,79,83,217,63,,,,219,83,217,203,223,28,
     35,37],[],[28,,,,,,,120,54,,84,,,84,121,194,123,194,121,,184,184,28,,
     ,28],[,,,,,,,49,,,,,,95,,231,157,211,153,,,205,,35,,35],
   [,42,,,37,,,190,54,46,,132,,121,174,283,,277,138,361,426,291,,,42,37],
   [,,46,,,48,,,,,,139,279,95,100,161,105,171,,,,165,,35,,35,,,35],
   [,37,,46,42,248,53,,,53,160,132,430,121,,309,171,263,129,,306,355,,,37,
     37,,44,,42],[70,67,74,74,65,72,76,74,76,74,146,140,430,186,134,,171,
     ,140,410,469,345,44,51,54,,,44,52,53,52,53],
   [70,42,190,,37,,46,,53,,,,399,121,175,275,182,353,131,319,,251,41,,42,37,,
     ,,37,,42,53],[70,,,,,,,332,,336,105,,,105,192,,,,193,295,291,315,140,,,
     123,,140,,,,239,218,223],
   [70,105,140,160,105,140,160,140,160,160,105,,,105,,,197,,194,,273,279,140,
     175,195,105,,140,175,195,175,195,,195,35],
   [70,,,,,,,312,357,247,105,,,105,167,233,171,,167,245,221,225,140,,,121,,140,
     ,,692,232,220,,35,35],
   [70,105,140,154,105,140,154,140,154,154,105,195,283,105,,287,,,189,295,,,
     140,175,189,105,,140,175,189,175,189,197,189,35,35,35],
   [42,,,,,,,64,144,,37,,,42,53,80,49,115,54,86,,78,84,,,72,,84,,,,132,126,
     130,195,195,189,195],
   [,,,,,,,,62,71,,,,132,201,278,204,282,,,,286,,,,74,,,,,,92,130,113,,230,,224 
    ],[,,,,,,,165,,,,,,,86,91,,67,99,95,67,106,,163,,,,,184,,186,332,397,,,
     463,,451],[42,53,60,62,53,60,62,60,62,62,42,52,86,37,,,58,84,47,
     121,78,,74,81,83,49,,74,81,83,81,83,172,83,176,140,166,140,42,44],
   [,,164,,387,162,,,,675,81,86,118,,,,126,114,,72,119,71,281,192,,,,241,194,
     403,182,528,,315,528,,334,469,76,,101],
   [42,,,,,,,64,146,148,37,,,37,,79,50,79,50,,71,71,84,,,72,,84,,,108,,128,
     132,166,166,154,166,37,,,37,63],
   [,,,,,,,,71,62,,,,132,195,308,206,278,199,,,272,,,,74,,,,,,111,128,92,,230,,
     224,,49,,44],[42,53,60,62,53,60,62,60,62,62,37,47,121,42,55,78,,,
     52,86,,78,74,81,83,49,,74,81,83,81,83,,83,176,140,166,140,37,44,,28,
     75,37,44],[,,190,,,154,389,161,417,,,,71,79,92,96,,,116,95,69,101,
     423,177,530,237,,239,189,,191,396,665,518,,487,331,,,,60,75,101,63],
   [42,91,,159,88,64,159,,,,42,55,,37,48,115,55,72,,,72,115,84,110,138,72,,
     84,109,128,,,130,,195,195,189,195,42,,69,37,,37,,42,70],
   [,,,62,86,,71,,,71,,,,132,,264,,276,,,,278,,,92,74,,136,,111,,,128,113,,
     230,1311,224,,44,,44,,,49,44],[],
   [,93,,71,,,62,,71,,,,,132,199,272,204,290,,,,290,136,,115,74,,,,92,,111,
     128,,,230,,224,,49,,44,,,44,44,,,49],[],
   [,203,158,402,,150,361,151,,485,81,89,,,,67,119,94,,71,95,,,192,296,,,,
     193,424,195,518,,,,485,361,495,76,,82,,61,62,,94,82],
   [14,,,,,,,,50,56,21,,,21,32,43,35,45,,47,49,43,28,,,24,,28,,,86,43,42,
     46,35,35,35,35,38,,,34,,31,,34,62,38,100,,156,,61],
   [14,21,28,32,21,28,32,28,32,32,21,36,,21,,,38,49,35,49,49,49,28,35,
     39,21,,28,35,39,35,39,42,39,35,35,35,35,39,46,71,28,,32,46,28,,39,
     46,,46,,71,7],[14,,,,,,,,50,56,21,,,21,32,43,35,45,,47,49,43,28,,,24,
     ,28,,,86,43,42,46,35,35,35,35,38,,,34,,31,,34,62,38,100,,156,,61,7,
     7],[14,21,28,30,21,28,30,28,30,30,21,38,55,21,38,,,,36,55,49,49,
     28,35,37,21,,28,35,37,35,37,34,37,35,35,35,35,39,44,82,28,88,32,
     44,28,,39,44,,44,,,7,7,7],
   [14,26,38,,26,38,40,,,42,21,36,49,21,34,51,,49,,,51,49,28,73,41,23,,28,
     ,40,,,40,41,35,35,35,35,39,84,71,32,71,32,108,32,86,39,,,100,,71,7,
     7,7,7],[14,21,28,32,21,28,32,28,32,32,21,,43,21,31,41,32,43,33,
     43,41,41,28,35,39,21,,28,35,39,35,39,,39,35,35,35,35,37,46,58,26,
     58,30,46,28,55,37,46,,46,,60,7,7,7,7,7],
   [50,,,,,,,140,67,,152,,,158,175,362,181,362,172,,372,364,46,,,51,,51,,,,55,
     66,62,244,250,244,238,142,,,120,376,148,,114,508,140,130,,159,,377,48,
     50,48,46,48,50],[56,69,76,78,69,76,78,76,78,78,153,145,353,105,,,,
     295,145,353,333,299,51,58,60,35,,51,58,60,58,60,50,60,229,175,223,
     175,132,134,,91,,132,134,91,334,132,134,,134,,466,44,35,44,35,41,35,
     51],[56,,,,,,,158,78,66,152,,,158,185,322,175,314,181,342,300,310,51,,
     ,51,,46,,,170,63,66,55,244,250,244,238,148,,,120,339,142,,114,355,148,
     159,,130,,355,48,50,48,46,48,50,51,51],
   [50,58,65,66,57,64,67,65,67,66,126,123,323,100,122,274,,,122,323,304,
     288,46,53,55,35,,46,53,55,53,55,54,55,190,160,186,154,110,112,,86,,
     110,112,80,,111,112,,112,,,37,32,37,30,34,32,46,35,46],
   [50,62,146,66,64,154,78,,,79,152,175,,158,175,350,182,350,,,364,386,46,,
     55,51,,51,172,62,,,68,63,244,250,244,238,142,130,362,120,424,148,159,
     114,378,140,,,167,,522,48,50,48,46,48,50,46,51,51,46],
   [56,69,76,78,69,76,78,76,78,78,153,145,307,105,168,223,175,225,145,307,
     299,229,51,58,60,35,,51,58,60,58,60,,60,229,175,223,175,132,134,347,
     91,317,132,134,91,313,132,134,,134,,344,44,35,44,35,41,35,51,35,51,
     35,51],[56,,,79,61,136,67,,82,,152,,,158,,400,181,362,173,426,,398,
     51,172,,51,,46,,55,,63,68,,244,250,244,238,148,167,434,120,433,142,
     130,114,,148,167,,,,397,48,50,48,46,48,50,51,51,46,46,51,51],
   [126,,,,,,,162,,356,53,,,63,86,85,107,73,86,85,75,87,232,,,197,,220,,,250,
     338,334,,285,285,273,285,101,,,106,133,87,,101,115,106,458,,,,140,55,
     57,55,57,57,53,388,339,376,290,388,327,388],
   [126,179,162,260,179,160,244,162,260,260,63,86,85,53,,,91,91,105,75,85,
     73,232,211,313,179,,220,203,313,203,301,332,313,285,285,273,285,106,
     284,125,101,,87,294,106,139,101,294,,286,,116,55,57,55,57,57,53,394,
     285,382,260,394,273,394,63],
   [114,,,,,,,120,307,,53,,,53,75,77,76,73,74,79,77,73,188,,,163,,164,,,209,
     280,274,280,227,227,203,227,87,,,87,120,66,,87,110,87,,,,,110,41,43,
     41,43,43,39,308,281,284,242,304,257,312,53,53],
   [126,163,168,254,179,156,238,160,254,254,53,103,75,63,86,89,,,88,85,75,
     83,232,207,291,179,,220,221,307,215,307,308,295,285,285,273,285,101,
     288,115,106,145,87,294,101,,106,276,,288,,126,55,57,55,57,57,53,382,
     285,370,254,382,273,382,53,63,53],
   [126,230,178,352,,,391,,,,63,83,85,53,102,75,90,83,,,83,73,232,229,350,
     197,,220,278,341,,,340,345,285,285,273,285,106,434,125,101,123,87,564,
     106,126,101,,,412,,115,55,57,55,57,57,53,386,339,374,292,386,327,386,
     63,53,53,63],[114,147,116,214,125,108,194,116,216,214,53,73,75,53,
     73,77,,77,73,75,77,77,188,153,253,145,,164,149,227,157,251,,251,227,
     227,203,227,87,232,113,87,121,66,232,87,120,87,212,,232,,118,41,43,
     41,43,43,39,314,227,290,212,310,203,318,53,53,39,53,53],
   [126,208,166,352,217,154,323,174,359,,53,,75,63,87,93,116,73,86,,,83,
     232,404,329,195,,220,,340,,340,351,,285,285,273,285,101,,115,106,,87,
     658,101,115,106,392,,,,125,55,57,55,57,57,53,384,333,372,288,384,321,
     384,53,63,53,53,63,53],
   [126,179,162,254,179,166,238,156,254,254,63,88,,53,105,75,91,83,103,75,
     85,,232,211,307,179,,220,209,307,215,295,322,307,285,285,273,285,106,
     284,158,101,122,87,288,106,125,101,294,,282,,,55,57,55,57,57,53,382,
     285,370,254,382,273,382,63,53,53,63,53,53,63],
   [,,,,,,,,,,,,,63,83,161,,,121,338,,153,,,,21,,,,,,,37,,,105,,105,,,,63,233,,,
     63,,,,,,,,,21,,21,,21,,42,,37,,42,61,,179,,167,227,151,,179],
   [,,,,,,,,,,,,,74,100,174,,,,,,182,,,,56,,,,,,,,,,140,,140,,,,28,,,,28,,,,,,,,,28,
     ,28,40,28,,112,,96,136,112,162,,152,,160,158,132,,156],
   [,,,,,,,,,,,,,100,,312,,250,182,,,,,,,35,,,,,,,50,,,160,,154,,,,100,,,,94,480,
     159,,,,,,,32,,30,40,32,,35,,30,,35,,,260,,254,,210,,254],
   [,,,,,,,,,,,119,355,63,90,183,79,203,,,,235,,61,69,21,,44,,,65,,44,65,189,
     105,,105,87,,235,63,301,,,63,239,89,,,,,,31,21,31,21,29,21,64,42,64,
     32,64,42,66,243,179,185,179,256,125,264,179,21,,34],
   [,,,,,,,,,,68,98,134,74,,116,,132,89,,142,,,,185,56,,,,,,143,130,,254,140,,
     140,64,69,,28,145,64,69,28,164,,69,,,,,46,28,46,28,,28,152,112,,94,
     158,112,136,166,152,116,162,200,118,168,168,,28],
   [,,,,,,,,,,,,,100,,262,,326,,,,262,54,83,,35,,,,81,,81,34,,276,160,,154,,,
     256,100,,,,94,271,,,,,,,50,32,50,30,,32,78,35,78,35,81,35,,354,260,
     319,254,,210,,254,,,35],
   [,,,,,,,,,,,,122,64,,128,,126,92,,118,134,,,,56,,120,,143,,,113,158,,140,,
     140,64,69,144,28,,64,,28,164,70,69,,69,,162,,28,,28,38,28,140,112,
     152,94,,112,162,,162,,168,178,116,166,162,,28,,,28],
   [,,,,,,,,,,,174,585,100,144,222,122,216,181,,,206,,,,35,,,,,,,49,,,160,,154,
     147,,251,100,247,,,94,276,,,,,,,56,32,56,30,42,32,66,35,66,30,66,35,
     66,,248,,242,,188,388,242,,,30,34,,35],
   [,,,,,,,,,,,,,100,,288,130,312,181,,,292,,83,84,35,,54,80,,80,78,37,,,160,
     243,154,,,414,100,328,148,,94,,,,,,,,,32,,30,40,32,75,35,75,35,79,35,
     79,353,260,,254,355,214,346,254,37,,35,,,30,,35],
   [,,,,,,,95,175,,,,,41,60,73,,,53,,,76,,,,,,,,,98,174,,,,209,,197,,,,41,,,,,,
     41,,,,,67,,35,,36,,33,,164,,122,181,,176,,102,,104,102,88,103,106,75,,,
     91,88,131,102,139],
   [,,,,,,,134,,,,,,,80,87,,,86,91,,91,,,,203,,,,,234,363,351,382,,,,,,,,100,155,
     ,,117,,102,347,,,,220,,49,,51,49,43,,331,,296,,297,382,,,,,61,43,,67,,
     108,,,140],[42,192,,,,68,,,,,21,45,65,21,45,65,43,65,43,65,75,75,84,
     ,161,79,,84,135,,,167,146,168,105,105,105,105,42,200,107,42,107,32,,
     42,,42,,,200,,,21,21,21,21,21,21,152,153,152,126,152,153,152,63,63,
     43,63,63,43,63,63,211,,,,,,,,,34,53],
   [,117,,,,88,175,91,,216,34,55,105,41,34,111,51,80,32,123,79,121,119,
     154,164,,,119,104,180,104,,,162,196,193,167,212,54,180,93,41,161,39,
     176,,99,39,182,,176,,,35,34,35,35,35,35,180,158,180,133,,164,180,86,
     102,59,87,104,59,86,102,91,86,121,75,,,,111,133,41,64],[],[],
   [],[,91,110,125,75,90,142,,,,34,60,99,,32,134,58,,34,119,79,121,136,,
     131,83,,120,139,129,,138,138,130,196,196,168,187,53,129,89,39,156,39,
     151,52,89,41,134,,150,,152,35,,35,35,34,31,176,145,181,122,179,145,
     176,86,102,59,86,102,59,86,105,,91,,,91,175,,,,41,67,,32],
   [346,135,168,286,,126,206,122,260,322,53,70,87,,123,43,94,85,134,53,93,
     43,248,221,235,,,190,169,353,157,281,,251,283,271,,289,84,228,118,,61,
     60,226,,147,100,228,,232,,59,45,51,45,51,49,41,366,,318,268,350,231,,
     83,57,57,83,61,57,93,57,153,126,,279,124,348,168,228,270,,61],
   [,,,,402,108,,134,,,,,,67,80,93,,,,91,,87,236,,458,213,,192,218,393,215,,
     320,,,283,239,,,625,,104,151,,345,121,,104,,,,,169,43,51,43,49,51,43,
     366,337,312,294,360,291,,73,57,41,75,57,43,73,57,,162,,,144,,,,,,43,
     47,67,,,,70,61],
   [,,,,,152,,114,,,47,68,,67,,43,,85,168,47,89,47,,,413,203,,182,368,380,
     367,457,394,,315,275,237,311,78,374,125,106,65,62,466,78,120,,,,378,,
     67,49,51,49,49,51,43,354,339,316,303,344,293,,85,61,61,83,61,61,83,
     67,,140,,,124,,,452,,67,67,,,,,,,43,67],
   [,,,,,,,,,80,,,,95,,211,159,231,,,,205,,,,65,,,,,,,121,96,,175,,175,,,,35,,,,
     35,,,,,49,,,,35,,35,56,35,,125,,104,172,125,156,,205,,215,,149,,211,,,,,
     46,,49,,,,,135,131,,,,104,171,234],
   [,,,,,,,,,78,,,,121,132,263,136,309,174,430,393,247,,,,42,,,,,,,57,,,195,,
     189,,,,111,281,,,105,424,136,,,249,,,,39,,37,41,39,,42,,37,,42,50,,313,,
     295,345,251,,307,37,,,42,228,53,,46,53,129,,167,138,,,,,253,421,321],
   [28,,114,,41,,54,,,60,84,120,246,84,124,,,,,246,,,28,134,,28,,28,117,39,
     117,53,53,39,140,140,140,140,84,,299,74,,84,174,74,277,84,,,174,,,28,
     28,28,28,28,28,51,51,50,39,51,51,50,232,232,188,232,232,188,232,232,
     41,130,,,,,,,,119,238,84,,,,,123,268,,240,,41],
   [,,,,61,,74,,,83,130,99,,95,,155,169,167,97,,226,177,,,111,65,,,,94,,,121,
     94,524,175,,175,105,55,233,35,211,,46,35,239,104,,,46,,233,65,35,65,
     35,58,35,193,125,,103,,125,146,243,205,191,213,,153,253,219,,46,,,,,46,,
     ,131,212,,,,,,104,157,,365,35],
   [,,158,,,,81,143,,,,174,361,121,132,277,133,283,,,443,307,,94,65,42,,39,,
     50,96,,41,50,240,195,,189,128,,303,111,315,,249,105,287,128,,,,,296,46,
     39,46,37,41,39,62,42,53,42,62,42,53,350,313,258,307,364,227,349,307,
     42,226,53,37,,,190,53,46,138,,,129,,,,176,359,308,387,,42],
   [28,21,56,35,21,56,35,56,35,35,79,86,217,63,83,219,85,,,217,203,,28,
     65,42,28,,28,65,42,65,42,41,42,123,105,121,105,72,49,183,35,185,72,
     49,35,187,72,49,,49,,187,24,21,24,21,23,21,51,42,51,37,51,42,51,
     197,179,163,179,197,145,195,179,37,44,46,37,44,46,44,46,46,83,203,
     79,83,,,,,,213,203,35,37,28,35,37],[],
   [,,,,67,,83,,,74,,97,366,85,129,167,,183,97,230,,175,,,,65,,134,,94,,109,
     119,94,855,175,,175,104,56,211,35,311,,46,35,229,111,55,,46,,269,,35,,
     35,58,35,,125,143,103,199,125,146,297,211,,213,268,155,,213,,47,,,46,,,,
     ,,,,147,,,,159,211,,,35,,,35,,35],
   [,,,,69,203,,,,84,,176,398,121,130,389,141,235,,,295,375,,111,,42,,51,,65,
     117,,57,73,224,195,233,189,132,,251,111,427,,206,105,271,,,,,,418,43,
     39,43,37,41,39,55,42,49,37,55,42,49,339,297,285,307,,253,,291,37,,
     46,42,268,53,,,55,131,365,161,131,,,,164,285,345,487,,37,41,,42,37],
   [70,,185,,79,,,167,,,,,448,121,139,253,132,355,172,350,,253,44,,,42,,39,
     96,52,98,63,44,52,228,195,,189,130,,434,111,266,132,206,105,,,,,273,,
     273,45,39,45,37,40,39,62,42,54,42,63,42,54,327,313,280,291,,247,,
     307,42,,53,37,,46,,55,,136,396,163,132,,,,188,265,,332,,42,,,37,37,,,42 
    ],[70,37,,47,41,111,32,107,47,37,140,145,359,,133,,134,407,111,420,
     297,,41,111,55,39,,51,113,39,112,54,52,41,206,223,202,192,119,61,250,
     46,305,119,46,46,258,119,61,,49,,288,41,42,41,34,37,,63,53,48,48,64,
     53,50,314,,272,295,302,272,310,276,61,68,72,62,69,71,70,70,70,130,
     349,140,132,,,,157,493,357,388,49,50,41,48,50,,,48,51,51],
   [70,158,332,291,189,,,,276,,105,192,295,105,,,214,,199,,287,283,140,524,
     224,123,,140,,240,482,,218,,35,35,35,35,195,1481,460,176,531,166,1154,
     176,540,195,,,691,,,35,35,35,35,35,35,244,229,244,190,244,229,244,285,
     285,227,285,285,227,285,285,198,,283,,,,332,276,336,196,283,105,,,,,200,
     283,283,285,,239,140,,,123,,,,242,206],
   [70,105,140,160,105,140,160,140,160,160,105,187,279,105,,277,195,307,187,,
     ,293,140,175,195,105,,140,175,195,175,195,,195,35,35,35,35,195,230,,
     140,637,166,230,140,,195,230,,230,,505,35,35,35,35,35,35,250,175,250,
     160,250,175,250,285,285,227,285,285,227,285,285,105,140,160,105,140,
     160,140,160,160,,271,105,,,,,191,,297,275,175,195,140,175,195,105,,175,
     195,195,,35],[70,188,,242,,,,242,,,105,171,249,105,167,237,171,231,
     168,241,229,225,140,391,234,121,,140,684,220,,223,222,,35,35,35,35,189,
     ,328,166,339,154,1761,166,335,189,699,,,,,35,35,35,35,35,35,244,223,
     244,186,244,223,244,273,273,203,273,273,203,273,273,,,243,150,,,,,318,
     167,227,105,165,,,,168,233,235,223,434,221,140,768,221,121,,,,228,202,
     35,35],[,,,,,,,71,,,,,,122,156,234,147,226,,,387,232,,,,49,,,,,55,,64,,,
     230,,224,,,,118,244,,,112,270,176,,,,,248,,46,,44,84,46,,49,,44,,49,,,
     292,,294,410,216,392,288,,,,107,,71,,62,,,,,233,,,,194,274,,,,,174,,112,
     74,,,92,111,121,691,230,1166],
   [,,,,,,,,327,321,,,,107,93,153,78,,114,199,,,,,,185,,,,,323,322,289,344,,467,
     ,504,,,,113,264,,,108,,,262,,241,,,,,,88,71,58,,301,,264,395,279,523,,
     101,,,,61,,,,,,321,160,505,160,441,,,,81,100,,,,93,112,68,,170,,328,181,
     377,234,,187,,,,468,505,338],
   [42,88,,145,,64,144,66,,145,42,43,108,42,43,100,41,100,39,108,112,106,
     84,,128,72,,84,104,,105,127,126,132,195,195,189,195,42,154,146,42,116,
     42,,42,,42,154,,152,,115,38,39,38,39,39,37,148,132,142,110,148,132,
     142,106,106,71,106,106,71,106,106,88,66,147,,,,66,,145,54,82,37,,,,,
     48,117,78,,104,127,84,,,72,,104,128,132,119,195,195,189,,76],
   [,,,,,68,,71,,,,,482,122,146,232,161,,176,354,,234,174,,273,49,,136,47,,47,
     ,48,249,,230,1311,224,,,236,118,258,154,,112,,173,,,,,265,,46,,44,108,
     46,161,49,159,49,159,49,167,458,292,250,288,328,218,658,286,86,,73,,,,
     ,73,62,199,,,,,,,197,288,,,,111,,,,74,,,111,92,121,,230,,49],
   [,155,,292,476,162,240,194,,311,81,58,,107,139,58,76,149,136,74,153,61,
     277,,252,187,,,235,346,213,301,336,286,442,505,361,470,76,255,171,114,
     76,71,239,71,195,118,265,,248,,71,62,,62,,86,55,357,299,,260,,273,397,
     140,101,77,166,75,77,153,77,303,152,369,,,,165,332,485,116,93,,,,,,,68,
     91,67,182,348,,165,,,,181,397,356,401,,485,344,,101],
   [42,63,28,100,63,28,100,28,100,100,37,,121,42,52,84,48,,,86,117,78,74,
     35,111,35,,74,35,111,35,111,48,111,176,140,166,140,37,118,107,42,72,
     37,118,37,107,42,118,,118,,71,34,28,34,28,32,26,120,49,120,44,120,
     49,120,101,106,87,101,106,87,101,106,53,60,62,53,60,62,60,62,62,47,
     117,42,52,,,,58,78,121,78,81,83,74,81,83,49,,81,83,83,153,176,140,
     166,44,,42,44,75],[],
   [42,91,,143,,66,,64,145,,37,33,85,32,41,60,33,83,39,76,81,62,84,,132,
     72,,84,104,,104,,126,128,166,166,154,166,37,,99,42,73,37,154,37,,42,
     152,,152,,71,31,32,31,32,32,30,142,132,148,110,142,132,148,87,80,58,
     87,78,58,87,80,,64,157,87,64,144,,,,50,71,37,49,,,,,71,73,71,108,132,
     84,105,128,72,,,,128,119,166,166,154,,63,37,,63,37],
   [,,,,,70,,71,,,,,700,122,158,234,150,216,176,369,,240,,,,49,,,55,,,,63,,,
     230,,224,,,352,118,252,152,,112,,173,,,,,239,100,46,100,44,,46,130,49,
     130,44,130,49,130,,294,276,282,410,218,,286,,,62,107,,71,,,71,,,,215,,,,
     200,284,,,,92,174,,112,74,,,,115,121,1154,230,,44,,,49,,44],
   [42,63,28,94,63,28,94,28,94,94,42,44,106,42,40,108,40,108,44,106,102,
     108,74,35,105,35,,74,35,105,35,105,48,105,176,140,166,140,42,112,112,
     42,117,42,112,42,112,42,112,,112,,112,34,28,34,28,32,28,114,49,114,
     44,114,49,114,106,106,71,106,106,71,106,106,53,60,62,53,60,62,60,62,
     62,52,80,37,47,,,,,,78,133,81,83,74,81,83,49,,81,83,83,,176,140,166,
     44,75,37,44,,28,,37,44],[],
   [,,,,,68,,74,,,,,,122,149,232,158,240,176,347,355,234,174,51,206,49,,,47,
     194,47,249,51,,1234,230,,224,,,250,118,253,152,,112,352,173,,,,,255,156,
     46,156,44,100,46,161,49,,49,169,49,167,,292,278,294,413,216,392,288,,,
     71,,,62,,71,,,,,,,,,196,274,,,,,,,92,74,,,117,,121,1481,230,1166,49,,,44,,
     44,,,49,44],[,,,,192,140,252,189,300,395,,,,107,92,,77,,99,135,,125,,,
     313,187,,239,211,263,,291,284,425,,,331,493,,352,,114,174,101,,109,,129,,
     ,270,,195,61,71,61,,71,60,408,299,333,260,364,273,,115,77,57,119,75,
     61,115,77,,,,,166,,157,361,,,68,81,95,,,,,91,,103,179,,277,179,351,237,,
     181,374,,401,540,487,344,,61,76,,82,,,62,,94],
   [,181,,356,449,213,313,184,,265,81,69,,107,,61,,,,76,159,69,328,,260,185,
     ,241,323,425,241,309,305,,465,637,334,,76,253,178,113,73,73,252,72,
     174,119,258,,244,,76,68,69,68,88,,56,421,301,356,264,406,279,433,133,
     91,92,131,90,92,131,,285,152,,,,,,,675,96,111,,,,,,,68,115,,195,361,,210,
     ,,,187,472,465,,531,,338,,,,,61,75,,65,,,,,101],
   [14,30,46,56,,48,50,46,,,21,40,59,21,40,,,,40,59,71,59,28,,46,24,,28,
     86,,,46,42,43,35,35,35,35,38,100,108,34,108,34,,34,,38,,,100,,,7,7,
     7,7,7,7,48,44,48,37,48,44,48,55,55,47,55,55,47,55,55,31,,50,,,,46,,
     ,40,59,21,,,,,40,59,59,59,86,46,28,,,24,,89,46,45,39,35,35,35,100,
     108,38,,,34,,34,,34,,100,,108]],
 [,[],[],[],[,30,,46],[],[,40,,53],[],[,,,40,46,,53],[],
   [42,,,,,,,68],[,90,,,114,,145,81],[,,,,,,499,122],
   [42,119,,254,,,,,254,,21,28,35],[,126,,,136,,,,211,,28,35,42],
   [,153,,,259,,212,,560,,35,42,49],[,,,,178,,224,90,,,,28,,28,35,42],
   [,,,,220,,,122,527,,,,35,35,42,49],
   [,104,,,124,,179,,,,28,35,42,,28,,35,42],
   [,181,,,,,,100,,,35,42,49,,,35,42,49],
   [,,,,329,,,122,,,,,35,35,42,49,,35,42,49],
   [,144,,435,227,,264,100,524,,35,42,49,,,35,42,49,,35,49],
   [28,,,,43,,52,,,,84,,,84,,238,,,,,214,222],
   [,,,,,,,84,,,,,,115,123,196,,,124,200,,192],
   [,39,,,58,,64,,52,,,138,,172,164,204,201,,141,237,,225],
   [28,43,,,47,,,,,,79,88,,73,,,,195,88,,209,197,28,92,41],
   [,62,,73,,,76,139,77,,133,125,190,,,,175,168,128,,193,342,,84,46],
   [28,40,,52,,,,132,52,,84,107,140,84,107,140,107,140,107,140,140,140,28,,
     39,28,39],[,,,,,,,111,,,,222,,,,,248,708,224,,,,,86,,92],
   [,55,,70,41,,,,70,,,143,250,163,163,245,152,271,148,264,305,275,39,,53,
     41,47],[,,,,,,,,,,146,141,236,,307,212,146,237,,,237,487,,84,,,122],
   [,43,,52,58,,64,,,,159,141,258,,,322,156,229,138,,213,445,,,39,41,46,39,,
     53],[54,,,,67,,80,131,73,,133,124,234,166,124,262,140,204,126,236,
     229,200,39,84,46,,32,39,130,47,124,46],
   [54,54,,68,47,,52,,68,,,170,332,,167,208,179,480,141,224,,226,39,,51,44,
     50,,,39,,51,47],[70,,,,,,270,,312,,105,,,105,180,,,,,,243,261,140,,,125,
     195,140,1012,,,,194,220],
   [70,,,250,,,247,338,270,,105,,277,105,,,178,,186,271,249,255,140,393,,119,,
     140,649,,572,229,,233,35],
   [70,167,,318,,,,,318,,105,140,175,105,140,175,140,175,140,175,175,175,140,
     742,220,125,194,140,,,949,220,195,220,35,35],
   [70,,,,187,,215,,218,,105,,,105,,261,,,173,,245,,140,,,117,171,140,573,205,
     573,201,174,204,35,35,35],
   [42,,,,108,,154,68,,,35,,,42,51,58,,,51,58,,58,84,,,74,114,84,148,124,
     133,135,113,124,193,191,175,193],
   [,,,,172,,180,,138,,,,,,390,,,,,,,,,,,178,227,168,,232,,166,,248,,729],
   [,,,,233,,266,144,898,,,,,49,58,65,,,58,65,53,65,,171,,,177,163,356,278,
     238,238,226,,,381,210],
   [42,73,,116,,,,,116,,42,51,58,35,,,51,58,48,,58,,74,110,100,59,,74,,101,,
     ,140,102,178,164,160,162,42,126,49],
   [464,172,,458,266,,312,206,,,49,58,65,,,,58,65,,56,65,53,263,206,228,,,
     163,,272,212,733,259,229,358,,210,381,49,,56],
   [42,105,,154,,,,68,166,,35,44,51,35,44,51,44,51,44,51,51,51,84,112,126,
     74,112,84,,,132,128,114,136,158,160,140,158,35,,42,35,42],
   [,100,,129,,,,,129,,,,,,233,949,263,,306,,,695,130,,152,,182,,,,,152,256,
     134,1508,,,437,,160],
   [42,,,,84,,102,68,,,35,,,42,51,58,,,51,58,,58,74,,,59,86,74,,106,136,102,
     86,104,178,164,160,162,35,,,32,49,35,89],
   [,,,,230,,,144,474,,,,,49,58,65,,,58,65,54,65,,183,,224,204,163,,268,243,
     229,258,641,,,210,,,,42,49,56,42],
   [42,97,,172,112,,160,,,,42,51,58,35,51,,51,58,,,58,,84,112,135,74,113,
     84,150,123,,,114,126,193,191,175,193,42,,49,35,,35,,42,49],[],
   [,172,,555,239,,264,,,,49,58,65,,,55,58,65,,,65,53,,200,238,,,163,,277,
     198,,227,238,349,441,210,374,49,,56,,42,42,,49,56],
   [,100,,129,,,106,,129,,,,,,241,940,234,903,,,,,132,,152,,198,,,134,,154,192,,
     ,,866,437,,160,,126,,,84,89],
   [,,,,244,,278,144,,,,,53,49,58,65,,53,58,65,,65,,,,,188,163,357,282,240,
     237,223,,346,,210,380,,,42,49,56,42,,,42,49,,56],
   [,170,,,248,,286,128,,,49,58,65,,,53,58,65,,54,65,,,204,230,,,163,348,
     269,227,449,256,231,392,359,210,353,49,,56,,42,42,,49,56,,,42,,56],
   [14,,,,31,,,48,46,,21,,,21,35,,,,,49,47,49,28,,,24,34,28,89,39,89,40,34,
     39,35,35,35,35,38,,,34,,31,90,34,,38,,66,126,65],
   [14,26,,38,27,,40,40,42,,21,31,,21,,,32,41,31,41,41,43,28,59,41,23,,
     28,73,40,71,40,36,41,35,35,35,35,37,108,58,30,,30,80,30,,37,,55,76,
     56,57,7],[14,,,,,,,,56,,21,28,35,21,28,35,28,35,28,35,35,35,28,121,
     ,25,36,28,,,121,42,36,42,35,35,35,35,35,282,42,32,42,28,,32,42,35,,
     42,282,42,42,7,7],
   [14,,,,31,,,48,46,,21,,,21,35,,,,,49,47,49,28,,,24,34,28,89,39,89,40,34,
     39,35,35,35,35,38,,,34,,31,90,34,,38,,66,126,65,,7,7,7],
   [14,33,,,35,,52,,,,21,32,41,21,31,41,,43,,,43,43,28,,43,25,36,28,,42,,,
     36,41,35,35,35,35,37,282,58,34,55,30,130,34,57,37,,,130,58,58,7,7,
     7,7],[14,25,,38,27,,40,40,40,,21,28,35,21,28,35,28,35,28,35,35,
     35,28,56,40,23,,28,69,40,69,41,,40,35,35,35,35,35,112,42,30,42,28,
     82,30,42,35,,42,84,42,42,7,7,7,7,7],
   [46,,,,69,,77,194,69,,150,,,156,166,299,,,163,,306,302,44,,,51,60,51,291,
     62,,55,62,61,236,246,236,226,134,,,126,306,144,185,115,,134,,313,181,
     317,309,45,48,46,45,46,48],
   [56,77,,84,81,,96,178,,,153,162,,135,,,,293,162,301,303,289,51,132,61,41,
     ,51,152,62,220,64,50,65,235,217,235,211,138,254,,113,,138,222,113,
     324,138,,330,222,381,381,44,41,47,44,47,41,51],
   [56,64,,75,,,,198,77,,150,160,246,156,170,237,162,237,164,246,224,235,51,
     198,61,51,60,44,,,246,62,62,54,236,246,236,226,146,227,248,126,251,
     134,,115,255,146,,251,167,252,255,45,48,46,45,46,48,51,51],
   [46,,,,76,,71,132,73,,124,,,126,125,246,,,126,254,255,248,44,,,41,50,44,,
     56,129,57,50,58,186,188,186,168,109,,,104,,110,169,86,,109,,261,175,
     258,236,34,34,36,34,36,34,44,41,44],
   [46,,,67,69,,77,,,,150,162,,156,166,307,,307,,,312,338,44,,54,51,62,51,,
     62,,,60,61,236,246,236,226,134,203,,126,328,144,187,115,,134,,,185,296,
     428,45,48,46,45,46,48,44,51,51,44],
   [56,77,,90,81,,96,166,90,,153,161,235,135,163,217,162,217,161,235,235,
     211,51,,63,41,50,51,152,64,,62,,61,235,217,235,211,138,294,244,113,
     245,138,238,113,244,138,,245,214,244,244,44,41,47,44,47,41,51,41,51,
     41,51],[56,64,,75,,,73,220,81,,150,181,310,156,,319,168,303,168,310,,
     305,51,,61,51,,44,,56,325,64,60,,236,246,236,226,146,229,320,126,356,
     134,181,115,421,146,,357,,,313,45,48,46,45,46,48,51,51,44,44,51,51],
   [126,,,,308,,348,176,,,49,,,63,74,81,,,74,81,71,81,228,,,207,292,196,,334,
     336,334,291,,281,277,245,281,91,,,104,111,79,804,91,,104,,111,,,111,55,
     53,49,55,53,49,360,353,324,286,356,317,360],
   [126,231,,372,272,,327,214,363,,63,74,81,49,,,74,81,96,71,81,71,228,274,
     334,201,,196,346,338,346,299,305,342,281,277,245,281,104,489,111,91,,
     79,709,104,111,91,,115,,111,113,55,53,49,55,53,49,372,335,336,286,
     368,299,372,63],[114,223,,338,,,,122,338,,49,60,67,49,60,67,60,67,
     60,67,67,67,180,200,258,161,227,140,,,235,256,193,256,211,215,175,211,
     81,397,88,81,88,56,,81,88,81,,88,318,88,88,41,39,35,41,39,35,272,
     271,236,222,276,235,272,49,49],
   [126,,,,,,282,176,,,49,,,63,74,81,,,74,81,75,81,228,,,199,271,196,418,319,
     333,315,272,277,281,277,245,281,91,,,104,111,79,426,91,,104,,111,430,
     117,111,55,53,49,55,53,49,350,329,314,268,346,293,350,49,63,49],
   [126,266,,394,286,,,,,,63,74,81,49,95,71,74,81,,,81,71,228,281,335,207,
     255,196,315,333,,,293,337,281,277,245,281,104,475,111,91,117,79,826,
     104,111,91,,,401,111,111,55,53,49,55,53,49,360,353,324,286,356,317,
     360,63,49,49,63],[114,195,,314,,,283,122,314,,49,60,67,49,60,67,60,
     67,60,67,67,67,180,196,265,155,242,140,228,231,235,260,,268,211,215,
     175,211,81,,88,81,88,56,716,81,88,81,,88,716,88,88,41,39,35,41,39,
     35,282,253,246,224,286,217,282,49,49,35,49,49],
   [126,225,,394,322,,364,176,394,,49,98,,63,74,81,98,75,74,81,,81,228,,
     304,207,295,196,,341,339,337,300,,281,277,245,281,91,,117,104,111,79,,
     91,117,104,,111,,,111,55,53,49,55,53,49,362,353,326,288,358,317,362,
     49,63,49,49,63,49],
   [126,,,352,257,,372,158,352,,63,74,81,49,95,71,74,81,95,71,81,,228,279,,
     201,232,196,312,318,390,283,268,318,281,277,245,281,104,470,111,91,
     111,79,454,104,111,91,,111,376,111,,55,53,49,55,53,49,348,335,312,
     268,344,299,348,63,49,49,63,49,49,63],
   [,,,,,,,,,,,,,,104,,,,,184,,147,,,,,40,,,,,,46,,,155,,,,,,86,149,,,,,100,,150,,,
     149,,26,,,,27,,,,,,52,66,,237,,,260,184,,237],
   [,,,,,,,,,,,,,,117,,,,,,,,,,,86,142,116,,174,,,164,,,246,274,,,,,46,,,,,,,,,,,,,
     40,56,,,40,,158,178,,166,,186,,154,102,,146,,,150],
   [,,,,,,,,,,,,,242,,,,,,,,,,,,53,66,,,,,,66,,,247,345,,,,,140,478,160,,,,,,456,,,,
     ,40,,,52,40,,53,,,,62,,,363,340,,,318,394],[],
   [,,,,,,,,,,68,90,122,,,104,81,122,,,122,118,,,214,,216,,,,,194,184,,364,,,,
     68,182,135,46,121,68,132,40,135,74,,151,142,135,113,46,44,56,46,,40,,
     180,,164,192,200,214,176,166,122,176,,122,176,204,,46],
   [,,,,,,,,,,,,,,139,,,,,,,,52,104,69,53,40,52,138,71,138,74,36,75,276,250,,
     213,160,,410,,,154,,120,456,,,333,,447,,46,42,56,46,,40,75,53,75,47,
     77,47,81,402,,338,334,,314,,352,40,,53],[],[],
   [,,,,,,,,,,,,,,,,200,,232,,,,56,114,75,,40,58,,85,164,73,46,75,374,386,304,,
     ,,,,,172,,,,,,514,,406,619,46,42,,46,56,46,83,53,86,53,81,62,81,468,
     449,384,425,456,368,486,396,46,,62,,,46],
   [,,,,145,,224,90,,,,,,35,44,51,,,44,51,,51,,,,,122,107,,167,144,162,,,,180,
     140,,,,,35,42,28,,,,35,,42,,,42,,31,28,,,28,,174,162,,174,162,163,,93,
     70,,93,70,98,93,90,,,,81,147],
   [,,,,182,,,122,,,,,,49,60,67,,,60,67,,67,,,,209,233,140,,210,243,294,194,,,
     ,175,,,,,88,95,63,1884,,,88,,95,,,95,,43,35,,43,35,,303,246,,,235,308,,
     49,35,,49,35,,49,,94,,,122],
   [42,,,,,,,,,,21,35,49,21,35,49,35,49,35,49,49,49,84,,157,79,137,84,146,,
     ,176,142,169,105,105,105,105,42,230,56,42,56,28,186,42,56,42,,56,
     186,56,56,21,21,21,21,21,21,150,153,150,124,150,153,150,63,63,35,63,
     63,35,63,63,,64,,,,,,,,28,35],
   [,126,,211,,,,,,,28,44,60,35,28,77,44,60,28,77,60,77,122,,159,,141,107,
     147,177,,153,,158,183,178,140,186,51,222,67,35,86,35,180,51,67,35,,
     86,176,67,86,34,32,28,34,31,28,172,176,165,120,187,163,176,74,93,42,
     74,93,42,74,93,98,75,147,,,,,,,35,42],
   [,181,,,,,,,,,35,51,67,49,77,35,51,67,77,35,67,35,214,,219,,237,140,244,,
     ,254,368,266,243,,175,,58,370,74,88,42,42,300,58,74,88,,42,298,74,
     42,43,41,35,43,,35,308,301,227,,324,235,,81,49,49,81,49,49,81,49,
     255,114,,,100,,,,,42,49],
   [,90,,,111,,145,81,,,,,,35,44,51,,,44,51,,51,127,170,138,88,125,107,,146,
     141,139,124,170,172,,140,181,51,,,35,42,28,211,,68,35,,42,228,,42,33,
     32,28,33,32,28,170,162,160,123,163,161,168,94,93,70,,93,70,98,93,,,
     219,,90,,,,217,28,,28,35,42],
   [,,,527,180,,,122,,,,,,49,60,67,,,60,67,,67,238,,446,195,204,140,349,242,
     237,266,168,493,239,,175,245,,359,,88,95,63,331,,,88,,95,,,95,45,43,
     35,45,43,35,299,293,237,244,329,217,303,71,49,35,73,49,35,75,49,,96,,
     ,122,438,,,1308,,35,35,42,49],
   [,104,,147,105,,,,154,,28,44,60,35,28,77,44,60,28,77,60,77,,199,143,90,
     128,107,143,147,,148,131,146,175,,140,173,51,213,67,35,86,35,183,51,
     67,35,,86,183,67,86,32,,28,32,31,28,164,163,168,125,181,162,169,74,
     93,42,74,93,42,74,93,,84,,,189,205,,,,35,42,,28,,35,42],
   [,153,,560,,,212,104,,,35,51,67,49,77,35,51,67,77,35,67,35,,,201,,262,
     140,233,466,,242,,203,239,,175,245,58,348,74,88,42,42,280,58,74,88,,
     42,274,74,42,43,43,35,43,41,35,,,237,246,309,217,303,81,49,49,81,49,
     49,81,49,148,114,542,,,669,,,,42,49,,,35,42,49],
   [,,,,,,499,122,,,,,,49,60,67,,,60,67,,67,210,,318,,225,140,211,277,241,
     252,194,,261,249,175,,,961,,88,95,63,342,,,88,,95,,,95,49,41,35,49,41,
     35,308,,222,259,314,235,,73,49,35,,49,35,,49,,,,,122,,,,,,35,35,42,49,,
     35,42,49],[,,,,,,,102,,,35,51,67,49,77,35,51,67,77,35,67,35,,,,197,
     237,140,248,,,324,,221,259,267,175,265,58,368,74,88,42,42,298,58,74,
     88,,42,300,74,42,43,43,35,43,41,35,289,301,246,,297,235,,81,49,49,
     81,49,49,81,49,183,114,,,98,,,,,42,49,,,35,42,49,,35,49],[],
   [,,,,63,,71,,,,,,,166,144,,,,163,243,321,198,,,,,61,46,207,57,,,63,56,,224,,
     ,,,,128,216,125,179,,,138,,219,173,316,222,,41,42,,45,41,,,46,,,50,46,,
     335,257,,335,264,,316,39,,,,290,64,,,70,138,,165,148,212,,,,225,309,243]
    ,[28,,,,42,,52,,,,84,127,210,84,122,,,238,,214,,254,28,112,46,28,46,28,
     132,39,137,46,46,39,140,140,140,140,84,,348,74,,84,132,74,262,84,,
     408,130,,,28,28,28,28,28,28,51,51,46,38,51,51,46,228,228,180,228,
     228,180,228,228,40,128,52,,,,,,,,214,84,,,,,120,238,,216,,39],
   [,,,,82,,112,,,,125,124,200,,,181,125,196,206,,203,286,,,191,111,,108,,137,,
     ,157,140,515,363,,410,114,136,206,,182,114,82,57,204,120,,180,82,205,
     203,89,58,121,89,103,56,204,197,163,149,,,167,283,258,201,277,,195,
     279,356,,73,,,,,,,,125,203,,,,124,196,,181,200,589],[],
   [28,30,,53,30,,53,104,,,79,102,199,73,91,195,88,,,201,197,,28,111,53,28,
     39,28,,53,,51,39,51,125,119,125,117,74,172,192,61,205,74,172,59,188,
     74,,194,,186,,24,23,25,24,25,23,51,50,51,39,51,50,51,207,201,161,
     199,207,155,207,201,,,,,,,,,66,88,197,79,90,201,,,,195,199,199,,41,28,
     69],[,40,,,43,,40,214,,,,121,334,166,124,168,,,133,195,335,225,39,
     152,61,39,47,46,198,39,,63,48,38,191,,,172,,,260,82,193,113,,84,,114,,
     188,82,267,188,34,37,36,34,36,40,62,53,46,45,62,53,45,255,305,228,
     235,291,242,256,268,,124,89,,,73,,,89,,335,132,124,195,121,,,168,334,
     201,,46,39],[],[],
   [54,,,,60,,71,178,,,,,309,161,148,225,138,,161,212,,196,39,132,60,,38,39,
     172,46,172,56,39,46,220,225,,205,123,,696,129,216,140,179,,,123,,222,
     173,,216,42,40,42,42,45,40,62,48,53,48,61,50,53,297,335,258,280,334,
     267,,316,52,,64,,,52,,,,,321,150,144,243,,,156,,,211,,50,,,,41,46],
   [54,,,,42,,36,,66,,134,132,192,,127,,125,226,121,365,192,,39,,,39,48,,198,
     38,234,61,48,39,194,228,191,172,114,206,189,82,338,112,82,84,189,,,
     276,,188,,34,38,36,34,36,36,60,53,45,45,60,53,46,292,,227,270,256,
     242,293,232,66,,73,,208,,,,79,125,231,133,124,233,124,262,141,204,234,
     234,,46,40,126,,,32,,,46],
   [70,173,,276,,,,,276,,105,172,251,105,,239,183,,172,,241,243,140,530,220,
     125,,140,,232,833,,193,,35,35,35,35,193,1482,369,178,350,158,1334,178,
     346,193,,,848,354,,35,35,35,35,35,35,236,235,236,186,236,235,236,281,
     281,211,281,281,211,281,281,184,284,270,,,,,,,183,241,105,,,172,,173,
     239,251,247,,232,140,,,125,190,,,232,192],
   [70,,,270,174,,247,,250,,105,,249,105,178,,180,,180,,,269,140,,229,119,228,
     140,573,231,573,235,,233,35,35,35,35,191,715,477,164,,160,,164,,191,,
     382,1250,,357,35,35,35,35,35,35,246,217,246,188,246,217,246,277,277,
     215,277,277,215,277,277,,244,276,,338,258,,,338,178,249,105,,271,,,178,,
     277,253,,225,140,363,,119,,,,224,,35],
   [70,188,,288,,,345,288,,,105,140,175,105,140,175,140,175,140,175,175,175,
     140,574,225,125,193,140,949,219,,219,192,,35,35,35,35,175,,210,160,
     210,140,1200,160,210,175,,210,1200,210,210,35,35,35,35,35,35,236,235,
     236,186,236,235,236,245,245,175,245,245,175,245,245,,304,298,,,326,,,
     356,140,175,105,140,175,140,175,140,175,175,175,,219,140,823,,125,193,,
     ,221,193,35,35],[,,,,,,,,,,,,,224,225,368,,,212,368,335,358,,,,172,208,,
     ,,161,,204,,,764,1336,,,,,208,353,200,,,,201,,363,,324,363,,108,282,,282,
     112,,160,,,,160,,,496,358,,498,364,,494,,,,,,178,,,215,,,,362,,300,,386,,,,,
     ,176,,,178,233,,,209,,1100,784,1911],
   [,,,,166,,224,135,,,,,,56,67,74,,,67,74,,74,,,,205,233,163,211,225,241,
     257,194,342,,361,210,,,,,97,104,72,284,,,97,,104,295,,104,,,42,,55,42,,
     310,256,,297,244,,,56,42,,56,42,,56,,,,,144,529,,,,,,49,58,65,,55,58,
     65,53,65,,,295,204,,,582,,,,227,375,429,210],
   [42,97,,,,,154,74,,,42,35,88,42,35,88,35,88,35,88,88,88,84,,123,74,111,
     84,133,,148,123,112,135,193,191,175,193,42,203,97,42,97,42,163,42,97,
     42,,97,165,97,97,38,37,35,38,37,35,146,138,134,109,146,138,134,104,
     104,49,104,104,49,104,104,95,64,160,,,,,,194,51,58,35,,,51,58,48,,58,,
     ,123,84,,,74,111,,,134,113,193,191,175,,49],
   [,,,,,,,128,,,,,310,196,169,294,332,,176,294,,274,132,84,187,172,84,130,
     110,171,110,197,78,201,848,,1400,437,,,283,178,290,164,,176,,165,,281,,
     276,294,90,80,,90,130,82,181,160,179,97,191,101,193,395,406,290,430,
     408,296,,392,100,,129,,,,,,114,306,,,,,234,836,250,903,,,,152,,,,,,,,134,
     259,,1043,,160],[464,156,,455,,,217,,,,49,42,95,56,86,42,42,95,86,42,
     95,42,262,,216,188,224,163,243,350,209,256,270,223,381,356,210,346,49,
     362,104,97,49,49,279,49,104,97,,49,287,104,49,,,42,,57,42,314,294,
     251,244,,243,313,111,56,56,111,56,56,111,56,170,134,,,,,,,,58,65,,,,58,
     65,,53,65,53,,237,,170,,,181,,,237,228,,358,210,,56],
   [42,85,,144,87,,142,40,144,,35,,,42,51,58,48,,51,58,137,58,74,86,132,
     61,78,74,86,133,75,131,78,131,178,164,160,162,35,278,141,42,49,35,,
     35,,42,,49,281,,49,34,30,32,34,34,30,126,103,126,78,126,103,126,91,
     104,81,91,104,81,91,104,,80,116,,68,,,,124,48,137,42,51,58,,,51,58,,
     58,,100,74,109,,59,,,,100,140,178,164,160,126,,42,,49],
   [,,,313,163,,257,135,381,,,,,56,67,74,72,,67,74,,74,408,,392,194,232,163,
     237,224,244,260,190,,381,,210,,,311,,97,104,72,,,,97,,104,274,,104,66,
     55,42,66,,42,322,300,248,,341,244,,117,56,42,116,56,42,,56,,119,,,144,,
     ,,,,55,49,58,65,,,58,65,53,65,,,262,206,,,,,,579,258,378,,210,,42,49,,
     56],[42,105,,166,111,,,68,154,,35,28,63,28,35,42,28,63,35,42,63,42,
     84,,138,74,114,84,132,128,130,,113,125,158,160,140,158,35,200,72,42,
     49,35,164,35,72,42,,49,164,72,49,31,30,28,31,30,28,134,138,144,110,
     134,138,144,79,56,42,79,56,42,79,56,,64,160,,68,166,,,174,44,51,35,
     44,51,44,51,44,51,51,51,,140,84,114,,74,113,,,125,114,158,160,140,,
     42,35,,42,35,42],[],
   [42,83,,122,,,128,,122,,42,35,88,42,35,88,35,88,35,88,88,88,74,84,106,
     59,82,74,74,107,84,106,82,106,178,164,160,162,42,196,97,42,97,42,
     154,42,97,42,,97,154,97,97,34,30,32,34,34,30,115,97,115,78,115,97,
     115,104,104,49,104,104,49,104,104,73,64,102,,,106,,,158,51,58,35,53,,
     51,58,,,58,,,104,74,165,,59,86,,,103,86,178,164,160,,49,35,89,,32,49,
     35],[,147,,435,,,,113,305,,49,42,95,56,86,42,42,95,86,42,95,42,,,
     220,186,225,163,237,,208,255,270,217,,359,210,381,49,353,104,97,49,49,
     292,49,104,97,,49,294,104,49,65,56,42,65,58,42,309,294,252,241,320,
     243,321,111,56,56,111,56,56,111,56,174,134,511,,198,,,,,58,65,,,53,58,
     65,,,65,53,,231,,183,,254,205,,,228,257,392,435,210,,56,,,42,49,56,42],
   [,,,,,,,120,,,,,,196,180,294,248,405,181,298,289,274,130,84,179,,78,130,
     110,177,110,191,84,171,1334,,,437,,,274,178,293,164,,176,708,169,,285,,,
     292,126,76,282,126,130,84,185,101,185,97,181,160,179,,406,290,426,408,
     296,427,392,104,,129,,,104,,,,,,,,,233,,237,903,,,,156,,,,,183,,,,,1508,
     1043,1400,160,,,84,,126,,,,89],
   [,,,,162,,221,135,500,,,,,56,67,74,74,,67,74,,74,,,315,,224,163,208,217,
     237,262,190,,354,,210,381,,,,97,104,72,,149,,97,,104,276,,104,,57,42,,
     58,42,317,297,247,228,353,243,421,111,56,42,117,56,42,117,56,,,,,144,
     435,,,,,,49,58,65,,53,58,65,,65,,,261,200,,254,,,,,227,346,435,210,,42,
     49,,56,,42,42,,49,56],
   [,147,,429,,,214,122,,,49,42,95,56,86,42,42,95,86,42,95,42,,,222,234,
     224,163,244,,237,258,287,220,,441,210,,49,359,104,97,49,49,285,49,104,
     97,,49,281,104,49,63,55,42,63,,42,313,311,257,231,323,244,309,111,56,
     56,111,56,56,111,56,173,134,480,,133,,,,605,58,65,,,,58,65,,54,65,,,
     238,,364,,,188,,,238,227,349,,210,,56,,,42,49,56,42,,,42,,56],
   [14,30,,50,30,,50,,,,21,,49,21,32,,33,,34,,45,43,28,86,46,24,39,28,,43,
     ,43,39,50,35,35,35,35,38,136,62,34,63,31,,34,,38,,,100,62,,7,7,7,
     7,7,7,48,44,48,37,48,44,48,55,55,41,55,55,41,55,55,30,46,50,,,,,,
     50,34,43,21,,,32,43,35,45,47,49,,45,28,,,24,,,,43,42,35,35,35,136,
     63,38,,,34,,31,,34,62,100],
   [14,30,,,31,,50,,50,,21,32,47,21,,45,34,43,33,,43,49,28,65,43,24,,28,,
     46,,,42,45,35,35,35,35,38,156,61,34,68,31,100,34,61,38,,,,,62,7,7,
     7,7,7,7,48,44,48,37,48,44,48,55,55,41,55,55,41,55,55,,40,50,,,50,,
     ,56,33,45,21,32,,,,32,,49,43,,43,28,,,24,,,,45,41,35,35,35,156,68,
     38,100,61,34,,31,,34,,,62,,7]],
 [,[],[],[],[,21,,28],[,,28],[,28,,35],[,,28,,,28],
   [,,,28,28,,35],[,28,,35,,,28,,35],[42],[,73,,,94,108,97,,,120],
   [,,108,,,,,134],[42,63,64,100,63,74,100,74,100,100,21,34,47],
   [,,90,,132,,174,,180,,37,42,83],
   [,,130,294,211,170,180,134,286,,47,61,63],
   [,,,,,,171,95,,171,,32,,34,44,67],
   [,299,126,,207,170,208,146,278,302,,,43,47,98,71],[],
   [,,152,,,,,114,,,,,67,,,43,67],[,,116,,372,,486,,,,,,43,47,,61,,43,,71],
   [406,,124,272,181,186,222,120,288,262,53,70,61,,,43,64,67,,43,63],
   [28,,,,35,88,44,,,44,84,,,84,,278,,,,,234,288],
   [,,,,,49,,,,,,,,85,96,181,108,165,,,434,171],
   [,35,,,42,116,51,,,51,,125,,121,192,227,164,363,,,,273],
   [28,35,44,44,35,44,44,44,44,44,79,83,233,63,,,,,,235,239,,28,35,35],
   [42,,60,60,67,60,60,60,60,60,124,114,240,,102,,175,218,,306,252,,35,42,
     42],[28,35,88,44,,,,88,44,,84,,204,84,,220,,216,,204,,210,28,,35,28,
     35],[,,49,,,,,46,,,,169,,95,,205,147,209,,,,,,35,,35,42],
   [42,42,116,51,35,,,116,51,51,,132,289,121,170,269,158,315,,299,500,271,
     35,,42,35,42],[,,,,,46,,,,,,,,95,100,153,106,175,,,242,187,,35,,35,42,
     ,35],[,35,,,42,116,51,,,51,,125,,121,,295,152,261,,,237,357,,,35,35,
     42,35,,42],[42,57,60,60,67,60,60,60,60,60,124,114,248,,113,,153,238,
     ,274,258,238,35,42,42,,28,35,42,42,42,42],
   [42,42,116,51,35,,,116,51,,,154,317,121,180,251,168,353,,245,,255,35,,42,
     35,42,,,35,,42,42],
   [70,,,,,,228,,,,105,,,105,190,,190,279,,,269,289,140,,,121,178,140,407,,,,,
     210],[70,105,140,158,105,140,158,140,158,158,105,,,105,,,193,,,315,
     291,277,140,175,193,105,,140,175,193,175,193,,193,35],
   [70,201,,346,,,,,,286,105,167,231,105,186,245,171,247,,247,245,231,140,,
     209,123,176,140,,,725,213,176,209,35,35],
   [70,105,140,140,105,140,140,140,140,140,105,192,283,105,,321,,,,275,279,,
     140,175,175,105,140,140,175,175,175,175,140,175,35,35,35],
   [42,,,,85,,,,,,37,,,42,54,78,48,117,,,,84,84,,,72,102,84,111,114,,,102,
     114,195,195,187,195],
   [,,,,56,,67,,,67,,,,132,,256,192,272,,,,274,,,,72,102,86,,97,,,102,97,,228,
     ,210],[,,,,,160,393,,,,,,,82,126,120,,71,,,69,113,,162,,,269,,180,,176,
     ,320,,,473,386,487],
   [42,49,60,60,49,60,60,60,60,60,42,52,78,37,,,55,78,,117,78,,70,81,81,
     49,,70,81,81,81,81,,81,172,140,168,140,42,42,78],
   [,,156,,431,151,,183,,,81,99,91,,,,,101,,67,107,67,,196,293,,,,202,353,182,
     ,399,371,462,,356,503,76,,101],
   [42,,68,144,,,,64,,148,37,50,73,37,51,87,,81,,,,73,84,,114,72,102,84,,,,
     114,102,131,164,166,156,166,37,,,37,66],
   [,56,,67,,,,,67,82,,148,,132,210,254,189,286,,,,284,86,,97,72,102,,,,,97,
     102,124,1298,228,,210,,49,,42],
   [42,49,60,60,49,60,60,60,60,60,37,47,121,42,58,78,,,,78,117,78,70,81,
     81,49,70,70,81,81,81,81,70,81,172,140,168,140,37,42,,28,94,37,42],
   [,,,,407,151,,165,638,,,,67,106,,97,,,,105,67,114,,187,480,418,,436,198,
     348,193,290,,492,416,671,,,,,62,100,84,66],
   [42,,,,,,134,,,,42,,,37,49,109,53,78,,,78,117,84,,,72,102,84,104,114,,,
     102,114,195,195,187,195,42,,,37,,37,,42,77],
   [,,,,56,,67,,,67,,,,132,195,256,,280,,,,296,,,,72,102,86,,97,,,102,97,,228,
     1502,210,,42,,42,,,49,42],
   [,,,,311,154,318,,,448,,,,,,70,117,101,,,95,67,,177,,,,,177,353,161,,,,,,
     352,504,,,101,,61,,,75,84],
   [,56,,67,,,68,,67,,,153,,132,195,286,186,266,,,,260,86,,97,72,102,,,155,,
     97,102,,,228,762,210,,49,,42,,,42,42,,,49],[],
   [,,159,,,158,439,,,,,,94,,,69,130,133,,70,97,,,203,,,,364,207,343,201,,,
     324,489,473,410,514,,,108,,62,66,,94,82,,,63],
   [14,,,,31,40,,,,48,21,,,21,40,59,,,,,,59,28,,,24,34,28,,42,,,34,40,35,35,
     35,35,38,,,34,,34,126,34,108,38,,,130],
   [14,21,28,30,21,28,30,28,30,30,21,36,,21,,,35,51,,49,47,,28,35,37,21,,
     28,35,37,35,37,32,37,35,35,35,35,39,44,69,28,,32,44,28,,39,44,88,
     44,,86,7],[14,,44,38,,,,,44,44,21,32,41,21,32,43,31,43,,41,43,41,
     28,57,,23,32,28,,,59,38,32,39,35,35,35,35,37,82,56,30,55,30,,30,56,
     37,78,55,98,,58,7,7],
   [14,21,28,28,21,28,28,28,28,28,21,35,55,21,35,,,,,47,49,47,28,35,35,
     21,28,28,35,35,35,35,28,35,35,35,35,35,39,42,71,28,84,32,42,28,,
     39,42,70,42,,,7,7,7],
   [14,,,,31,40,,,,48,21,,,21,40,59,,,,,,59,28,,,24,34,28,,42,,,34,40,35,35,
     35,35,38,,,34,,34,126,34,108,38,,,130,,,7,7,7,7],
   [14,21,28,30,21,28,30,28,30,30,21,31,41,21,32,41,34,43,,43,41,41,28,
     35,37,21,,28,35,37,35,37,,37,35,35,35,35,37,44,58,28,57,30,44,26,
     55,37,44,55,44,,59,7,7,7,7,7],
   [42,,,,62,140,67,,,67,146,,,158,161,336,161,382,,,354,338,42,,,49,58,49,
     180,58,,,58,58,230,246,228,210,126,,,118,373,144,127,102,465,126,,,127,
     ,461,45,46,44,42,45,46],
   [56,63,76,76,63,76,76,76,76,76,153,145,339,105,,,,,,341,351,301,49,58,
     58,35,,49,58,58,58,58,51,58,223,175,229,175,132,132,,91,,132,132,91,
     491,132,132,356,132,,509,44,35,41,35,44,35,49],
   [56,60,140,67,,,,142,67,,146,162,314,158,,300,166,304,,322,,294,49,218,
     58,49,58,42,,,173,58,58,57,230,246,228,210,144,127,319,118,331,126,,
     102,341,144,127,331,224,,355,45,46,44,42,45,46,49,49],
   [42,53,60,60,55,60,60,60,60,60,120,114,278,100,115,244,,,,264,264,252,
     42,51,51,35,44,42,51,51,51,51,44,51,176,158,176,140,102,102,257,86,,
     102,102,70,,102,102,261,102,,307,34,30,32,28,34,30,42,35,42],
   [42,,,,62,140,67,,,67,146,,,158,162,346,,352,,,370,352,42,,,49,58,49,178,
     58,,,58,58,230,246,228,210,126,,,118,380,144,127,102,355,126,,,127,,
     526,45,46,44,42,45,46,42,49,49,42],
   [56,63,76,76,63,76,76,76,76,76,153,145,293,105,164,221,,231,,289,287,
     231,49,58,58,35,48,49,58,58,58,58,,58,223,175,229,175,132,132,,91,
     313,132,132,91,306,132,132,,132,,322,44,35,41,35,44,35,49,35,49,35,
     49],[56,60,140,67,,184,76,142,67,,146,177,358,158,,370,163,370,,374,,
     338,49,,58,49,58,42,,,177,58,58,,230,246,228,210,144,127,,118,355,126,
     ,102,475,144,127,353,,,405,45,46,44,42,45,46,49,49,42,42,49,49],
   [126,,,,,164,,,,324,53,,,63,91,83,103,75,,,73,83,232,,,197,268,216,,,,,268,
     ,285,285,269,285,101,,,106,126,87,514,101,119,106,,,,,128,55,57,53,57,
     55,53,356,339,340,268,356,327,356],
   [126,179,158,250,179,166,238,162,250,250,63,86,83,53,,,86,85,,75,87,73,
     232,213,303,179,,216,209,303,209,287,285,303,285,285,269,285,106,280,
     130,101,,87,286,106,130,101,290,119,272,,117,55,57,53,57,55,53,374,
     285,358,250,374,273,374,63],
   [114,205,114,284,,,,,,294,53,74,73,53,77,73,76,77,,,81,77,192,206,260,
     171,222,172,,,195,262,206,262,223,227,207,227,87,310,113,87,110,66,,
     87,115,87,,120,362,,117,47,43,39,43,47,39,284,281,264,220,284,257,
     288,53,53],[126,167,160,232,179,152,220,162,232,232,53,103,73,63,91,
     83,,,,85,73,87,232,203,273,179,232,216,215,285,211,285,232,273,285,
     285,269,285,101,266,118,106,126,87,268,101,,106,258,129,266,,162,55,
     57,53,57,55,53,338,285,322,232,338,273,338,53,63,53],
   [126,,,,233,,,,,,63,,,53,106,73,86,85,,,83,73,232,,,195,256,216,306,321,,,
     272,318,285,285,269,285,106,,,101,115,87,699,106,131,101,,,353,,118,55,
     57,53,57,55,53,358,333,342,268,358,321,358,63,53,53,63],
   [114,153,116,210,121,112,182,120,208,208,53,,77,53,76,77,74,77,,77,73,
     73,192,157,247,153,241,172,149,217,155,249,,247,223,227,207,227,87,
     226,120,87,118,66,228,87,117,87,206,118,226,,114,47,43,39,43,47,39,
     302,227,282,202,302,203,306,53,53,39,53,53],
   [126,211,166,358,,168,316,,324,,53,101,73,63,95,,103,77,,,,83,232,,303,
     197,268,216,,324,267,,268,,285,285,269,285,101,,119,106,143,87,,101,
     123,106,430,135,,,127,55,57,53,57,55,53,356,339,340,268,356,327,356,
     53,63,53,53,63,53],
   [126,179,156,232,179,160,220,150,232,232,63,86,83,53,104,73,89,89,,75,
     83,,232,215,285,179,216,216,203,285,213,269,232,285,285,285,269,285,
     106,254,131,101,116,87,268,106,148,101,266,119,260,,,55,57,53,57,55,
     53,338,285,322,232,338,273,338,63,53,53,63,53,53,63],
   [,,,,,,,,,,,,,63,74,139,,,,,,,,,,21,28,,,,,,28,,,105,,105,,,,63,180,85,,63,
     457,,,,,,,,21,31,21,,21,,42,,35,,42,,,179,203,163,,149,,179],
   [,,,,,,,,,,,,,74,114,180,102,176,,,,,,,,56,84,88,,114,,,84,114,,140,,140,,,,
     28,,,,28,,,,,,,,,28,36,28,,28,,112,142,84,,112,142,,156,,162,,134,,150],
   [,,,,,,,,,,,,,100,,290,100,274,,,,,,,,35,44,,,,,,44,,,158,,140,,,,100,247,148,
     ,84,418,,,,,,376,,30,,28,,30,,35,,28,,35,,,250,286,232,,208,324,232],
   [,,,,,,,,,,,,,63,93,,73,223,,,,,35,49,53,21,35,35,49,53,49,53,35,53,207,
     105,188,105,91,,,63,201,,,63,217,,,361,,,,31,21,27,21,31,21,60,42,60,
     28,60,42,60,263,179,191,179,,125,247,179,21,,28],
   [,,,,,,,,,,68,91,132,74,,120,,132,,156,154,132,88,,112,56,84,,,,,112,84,,
     236,140,334,140,64,,207,28,142,68,68,28,178,,64,165,66,,154,,28,38,28,
     ,28,140,112,,84,140,112,184,156,148,120,158,,114,164,160,,28],
   [,,,,,,,,,,,162,,100,100,264,,328,,,,286,44,60,60,35,28,44,60,60,60,60,
     28,60,230,158,,140,,,322,100,,,,84,288,,,250,,,,,30,44,28,,30,67,35,67,
     35,67,35,67,324,250,312,232,,208,,232,28,,35],
   [,,,,,,,,,,,88,108,64,111,130,,126,,152,116,124,,,,56,84,88,,112,,,84,112,,
     140,,140,64,66,,28,194,64,64,28,160,,64,160,,,,,28,44,28,,28,,112,140,
     84,,112,140,,158,114,160,,116,166,156,,28,,,28],
   [,,,,,,,,,,,,398,100,,206,,188,,446,,192,,,,35,44,,,,,,44,,310,158,,140,,,
     246,100,,,,84,199,134,,,,,209,48,30,44,28,48,30,74,35,72,28,74,35,76,
     352,238,,220,,182,350,220,,,28,28,,35],
   [,,,,,,,,,,,,,100,,302,139,,,,,,44,60,60,35,28,44,60,60,60,60,28,60,,158,
     260,140,,,,100,300,144,,84,,,,272,,,,46,30,,28,46,30,67,35,67,35,67,
     35,67,324,250,310,232,,210,356,232,28,,35,,,28,,35],[],
   [,,,,,140,496,,,,,,,65,120,87,,,,,,95,,,,231,276,222,,307,,,260,355,,,257,,,,
     ,106,149,,848,121,,,,,,,,,49,43,49,,43,,355,342,276,,315,400,,63,,,,45,,
     65,,122,,,136],[42,,,,,68,,,,,21,43,65,21,43,65,,,,,65,65,84,,144,79,
     123,84,167,,,154,124,153,105,105,105,105,42,232,107,42,107,32,204,42,
     90,42,,90,,,,21,21,21,21,21,21,146,153,146,120,146,153,146,63,63,43,
     63,63,43,63,63,,,,,,,,,,,53],
   [80,,,180,,91,162,89,,201,37,,86,,37,150,57,89,,121,79,134,129,152,158,,,
     145,108,166,107,152,,151,203,194,174,194,56,168,122,,136,39,180,55,
     114,39,172,,168,,148,40,35,31,35,40,31,167,175,169,109,177,162,167,
     88,102,61,86,102,59,89,106,87,93,119,73,,,102,97,136,,86],
   [,,,,,128,,158,,,47,76,93,65,117,47,73,97,,43,95,43,248,,257,215,260,,
     256,,,267,318,,263,,237,,78,,151,100,,64,370,82,122,102,300,59,296,,63,
     ,55,41,47,,41,354,335,274,280,352,297,,83,63,57,83,57,57,89,57,322,
     134,,,,,,,,,63],[80,73,102,136,87,,97,93,,119,,,,,,73,,,,73,,73,125,
     165,125,83,114,145,,132,,125,114,153,191,198,170,194,48,148,75,39,60,,
     117,47,76,39,,60,125,,64,40,36,31,35,40,31,167,145,168,114,158,145,
     167,102,102,88,,102,89,101,106,,89,201,,91,,,162,180,,,37,41,70],[],
   [],[],[,,,,322,,,134,,,,,,65,89,87,,,,85,,,248,,329,215,274,,236,373,
     212,277,232,,,,235,,,762,,100,169,,352,121,,102,,145,570,,168,53,47,41,
     55,53,41,354,335,274,280,352,297,,75,57,41,73,57,45,73,57,,158,,,128,,
     ,,,,45,47,70,61],
   [,,,,,136,,122,,,53,85,91,65,,47,,,,47,,53,,,,231,292,222,296,337,409,,
     344,263,309,295,,,86,318,199,106,74,84,334,86,,,314,74,,,,,49,43,55,,
     43,342,355,342,276,356,315,400,85,59,61,87,59,59,85,65,,,,,140,,,496,,
     ,65,,,45,86,,,,63],
   [,,,,49,,60,,,60,,,,95,159,201,,203,,,,225,,,,63,97,77,,88,,,,88,,175,,175,,
     ,,35,,,42,35,,,,,42,,,,35,73,35,,35,,119,120,95,,119,120,,201,,213,,151,
     ,201,,,,,47,,46,,,,,131,131,246,,,,,,225],
   [,,,,55,112,60,,,60,,,,121,127,243,,357,,,335,,,,,42,51,42,,51,,,51,51,,
     193,,175,,,,107,262,114,116,91,498,,,,116,,,,37,39,35,,37,,42,42,35,,
     42,42,,303,260,269,,243,,285,35,,,42,116,51,,51,51,,,158,142,233,,,,,
     313],[28,,88,,35,,44,88,,44,84,127,256,84,129,,,306,,278,,326,28,77,
     42,28,42,28,77,35,77,42,42,35,140,140,140,140,84,,416,70,,84,86,70,
     400,84,,513,86,,,28,28,28,28,28,28,49,49,42,35,49,49,42,232,232,192,
     232,232,192,232,232,35,88,44,,,,88,44,,,262,84,,,,,,,,262,,35],
   [,,,,49,,60,,,60,135,95,244,95,,163,127,181,,,,,,,,63,101,77,,88,,,101,88,
     381,175,,175,111,54,,35,269,,42,35,,113,53,,42,,,89,35,57,35,89,35,
     180,119,121,96,,119,121,263,209,206,213,,159,280,215,,,,,,,46,,,,261,,,,,,
     ,,267,,35],[42,,112,,55,,60,114,,60,,,279,121,132,313,125,277,,301,,
     263,35,88,51,42,35,35,88,42,88,51,35,42,221,193,209,175,114,,325,
     107,289,,116,91,293,114,,355,116,,,41,37,38,35,41,37,58,42,49,42,58,
     42,49,328,303,232,285,329,221,318,285,42,116,51,35,,,116,51,51,,267,,
     125,,,,,,,331,,42],[28,21,56,35,21,56,35,56,35,35,79,,233,63,85,375,
     83,,,235,239,,28,63,42,28,35,28,63,42,63,42,35,42,121,105,123,105,
     72,49,197,35,195,72,49,35,191,72,49,191,49,,201,24,21,23,21,24,21,
     49,42,49,35,49,42,49,197,179,171,179,195,153,197,179,35,44,44,35,44,
     44,44,44,44,,231,79,83,215,,,,,215,231,35,35,28,35,35],
   [42,28,84,44,35,84,28,84,44,28,,97,302,,117,,114,,,226,,443,35,100,51,
     35,42,42,101,35,100,51,42,35,181,,176,140,102,58,247,42,218,102,42,
     42,246,102,58,220,42,,234,34,34,32,28,34,36,58,49,42,42,58,49,42,
     256,,226,220,270,,256,232,,60,60,61,60,60,60,60,60,,312,125,114,238,
     97,,,,310,248,42,42,35,42,42],
   [,,,,49,,60,,,60,,95,,85,169,185,,165,,267,,165,,,,63,,77,,88,,115,99,88,
     682,175,725,175,104,53,215,35,235,,42,35,233,106,,235,42,,247,65,35,,
     35,65,35,,119,120,95,,119,120,273,211,195,213,242,153,,209,,46,,,46,,,,,
     ,,,,,,,,,,,35,,,35,,35,42],
   [,,,,55,112,60,,,60,154,169,328,121,127,369,141,241,,,271,399,,131,,42,
     51,42,,51,119,,51,51,210,193,,175,130,,259,107,524,114,116,91,269,,,
     299,116,,367,42,37,38,35,42,37,55,42,42,35,,42,42,317,287,260,285,
     301,243,320,269,35,,57,42,116,51,,,51,,454,,,279,169,,,,293,,,35,35,,
     42,35,42],[42,,112,,55,,60,114,,60,,,321,121,,253,125,357,,255,,233,
     35,88,51,42,35,35,88,42,88,51,35,42,,193,,175,114,,501,107,251,,116,
     91,,114,,,116,,267,39,37,39,35,39,37,58,42,49,42,58,42,49,303,303,
     260,273,321,247,,285,42,116,51,35,,48,116,51,,,331,142,125,302,,,,,,279,
     ,42,,,35,35,42,,42],
   [42,28,84,44,35,84,28,84,44,28,126,123,220,,117,,114,,,290,218,,35,102,
     51,35,42,42,101,35,97,51,42,35,181,,176,140,102,58,217,42,240,102,
     42,42,210,102,58,240,42,,258,34,36,32,28,34,33,58,49,42,42,58,49,
     42,268,,228,232,255,243,268,216,,60,60,,60,60,60,60,60,,270,123,114,
     248,,,,,258,284,42,42,35,42,42,,28,42,42,42],
   [70,,286,237,,,,,230,310,105,185,273,105,,261,,,,,261,273,140,407,210,121,,
     140,,,387,,178,,35,35,35,35,195,1208,459,172,471,164,1147,172,463,195,,
     419,,,,35,35,35,35,35,35,230,223,230,176,230,223,230,285,285,223,285,
     285,223,285,285,206,244,228,,,,286,228,305,,285,105,,,187,,,,273,,383,
     220,140,,,121,180,394,,220,180],
   [70,105,140,158,105,140,158,140,158,158,105,194,277,105,,291,195,315,,,,,
     140,175,193,105,,140,175,193,175,193,,193,35,35,35,35,195,228,530,140,
     537,166,228,140,,195,228,,228,,471,35,35,35,35,35,35,246,175,246,158,
     246,175,246,285,285,227,285,285,227,285,285,105,140,158,105,140,158,
     140,158,158,,289,105,,295,,,,,295,289,175,193,140,175,193,105,,175,193,
     193,,35],[70,188,,260,,334,,,,,105,167,231,105,185,,169,255,,,241,237,
     140,732,216,123,176,140,999,208,,209,176,,35,35,35,35,187,,424,168,
     357,156,1264,168,355,187,762,358,1502,,394,35,35,35,35,35,35,228,229,
     228,176,228,229,228,269,269,207,269,269,207,269,269,,,286,201,,,,,346,,,
     105,170,235,174,,,,237,257,707,208,140,,211,123,176,,,209,176,35,35],
   [,,,,,66,,,,,,,,122,151,238,116,212,,,,206,,,,49,58,,53,,,,58,,,228,746,210,,
     ,,118,222,152,,102,229,,,,,,241,,44,82,42,,44,,49,,42,,49,,,282,232,266,
     ,212,430,262,,,,56,,67,,74,67,,,,155,,188,,,,,,,,86,,97,72,102,,,97,102,
     622,228,1048],[,,,,,140,228,,,248,,,,90,92,107,74,,,,,147,,,,195,240,
     358,283,,,,224,315,,462,336,525,,,,116,171,102,232,107,,,,,216,,,,,55,84,
     ,57,,299,332,238,,275,400,,84,61,,,62,,84,,,,,150,443,154,322,,,,81,
     116,91,,,,,69,95,159,,336,181,335,365,584,177,353,,308,434,520,335],
   [42,,,,,64,136,64,,132,42,42,104,42,42,104,39,112,,116,104,102,84,,114,
     72,102,84,113,,106,114,102,130,195,195,187,195,42,146,149,42,117,42,
     152,42,132,42,,117,144,,121,38,39,37,39,38,37,144,132,126,102,144,
     132,126,106,106,69,106,106,71,106,106,,64,132,,,,64,136,,,86,37,,,53,,,
     ,78,,104,114,84,,,72,102,106,114,129,102,195,195,187,,76],
   [,,,,,68,,64,,,,,,122,120,244,151,214,,,682,212,86,42,116,49,42,86,42,
     116,42,116,42,116,734,228,,210,,,221,118,244,,,102,,144,,229,,,267,126,
     44,,42,126,44,127,49,127,49,127,49,127,402,284,358,268,356,214,882,
     268,56,,67,,,,,67,,,,,,,198,,,,,,,97,,,,72,102,,97,153,102,,228,,49],
   [,,,301,374,176,207,160,,302,81,61,151,90,148,61,60,,,61,177,59,400,,,
     191,246,364,,317,221,275,252,,415,460,,548,76,242,,112,76,,237,72,185,
     115,243,72,230,,88,108,,56,,108,55,353,297,359,242,,275,372,125,84,80,
     125,79,81,137,79,307,165,451,,,,154,316,,,97,,,,96,,,,142,71,193,329,,
     161,,,225,175,,325,296,,469,393,,84],
   [42,63,28,100,63,28,100,28,100,100,37,,,42,53,78,47,,,78,125,78,70,35,
     107,35,42,70,35,107,35,107,42,107,172,140,168,140,37,118,112,42,71,
     37,118,37,107,42,118,71,118,,85,34,28,30,28,34,26,118,49,118,42,118,
     49,118,101,106,87,101,106,87,101,106,49,60,60,49,60,60,60,60,60,,
     121,42,52,80,,,,,117,86,81,81,70,81,81,49,,81,81,81,199,172,140,168,
     42,,42,42,100],[,383,,,145,156,,162,368,,,,,,92,111,76,,,120,,116,513,
     ,319,191,240,326,287,241,235,338,236,,420,541,,,,212,,112,203,104,,107,
     ,130,230,187,269,,217,,88,55,70,,55,384,297,316,242,351,275,,116,77,
     61,116,77,57,123,77,,151,,,157,385,150,342,,,71,,95,93,,,,,67,,197,,
     311,197,318,,,193,324,490,423,484,,348,,61,,,84],
   [42,91,,144,87,68,,64,144,132,37,32,83,32,43,66,32,81,,70,81,64,84,,
     131,72,102,84,,114,104,,102,114,164,166,156,166,37,144,100,42,73,37,,
     37,,42,144,73,146,,91,34,32,30,32,34,30,126,132,144,102,126,132,144,
     87,76,61,87,76,60,87,76,87,64,132,91,68,144,,,144,,77,37,50,73,50,,,
     ,73,77,106,130,84,112,114,72,102,,,114,102,164,166,156,,66,37,,66,37]
    ,[,,,,,64,,64,,,,,,122,150,240,125,200,,326,,208,,,,49,58,,53,,53,,58,,,
     228,,210,,,379,118,231,152,,102,211,146,,242,,,226,,44,78,42,,44,168,
     49,224,42,168,49,184,510,284,264,256,324,210,,266,,,,56,,67,,,67,,,,141,
     ,,,,,,,,155,86,,97,72,102,,,97,102,1154,228,,42,,,49,,42],
   [42,63,28,84,63,28,84,28,84,84,42,,104,42,40,102,39,108,,106,102,108,
     70,35,91,35,42,70,35,91,35,91,42,91,172,140,168,140,42,102,113,42,
     112,42,102,42,112,42,102,114,102,,114,34,28,30,28,34,28,102,49,102,
     42,102,49,102,106,106,69,106,106,71,106,106,49,60,60,49,60,60,60,60,
     60,,86,37,47,121,55,,,,82,121,81,81,70,81,81,49,70,81,81,81,70,172,
     140,168,42,94,37,42,,28,75,37,42],[],
   [,,,,,64,,64,,,,,,122,126,230,149,210,,326,324,210,86,42,116,49,42,86,42,
     116,42,116,42,116,,228,,210,,,232,118,279,154,,102,,144,,232,,,258,130,
     44,98,42,130,44,127,49,127,49,127,49,127,,282,232,266,324,212,430,
     262,56,,67,,,74,,67,,,,,,,199,,,,,,,97,,,,72,102,,97,,102,1154,228,1060,
     49,,,42,,42,,,49,42],
   [,,,,260,154,209,170,324,380,,,,94,115,103,76,,,122,,,,,301,201,260,411,,
     289,243,313,242,471,,,,471,,358,,118,165,,251,111,,134,,175,236,,249,,
     86,58,,,59,360,311,365,246,389,287,517,121,81,60,117,79,62,117,79,,
     197,,305,186,460,163,347,,,73,,129,114,,,,,,100,183,,,183,377,430,,183,
     437,,,515,541,393,,62,,,82,,63,66,,94],
   [,,,,,168,245,159,,,,70,168,94,152,61,64,204,,65,,70,,,291,201,266,364,
     337,,241,289,266,269,489,541,,,,253,,118,86,95,267,85,,123,258,86,226,,,
     ,71,57,70,,59,399,311,355,246,364,287,402,128,79,82,131,79,79,127,84,
     ,,,,170,,160,399,,,100,,,69,130,,,,93,,185,,,205,,,283,183,,385,299,515,,
     429,,84,,,62,100,88,66,,,,,86],
   [14,,,,31,48,,46,,,21,32,43,21,35,,32,43,,45,43,49,28,89,40,24,34,28,
     89,39,,42,34,39,35,35,35,35,38,90,63,34,66,31,,34,,38,90,,,,66,7,7,
     7,7,7,7,45,44,45,34,45,44,45,55,55,41,55,55,41,55,55,,46,,,,,,,46,,
     49,21,,,35,,,,49,47,,41,28,,,24,34,89,39,40,34,35,35,35,90,66,38,,,
     34,,31,90,34,,,66,65],
   [14,21,28,31,21,28,31,28,31,31,21,40,59,21,,71,40,59,,59,71,59,28,35,
     38,21,,28,35,38,35,38,,38,35,35,35,35,38,45,108,28,108,34,45,28,
     156,38,45,,45,,108,7,7,7,7,7,7,48,35,48,31,48,35,48,55,55,47,55,
     55,47,55,55,21,28,31,21,28,31,28,31,31,,59,21,,,,,,,,59,35,38,28,35,
     38,21,,35,38,38,37,35,35,35,45,108,38,45,156,28,,34,45,28,,45,108,
     108,7],[14,,,46,,,,46,,,21,33,49,21,34,43,,45,,43,,43,28,89,39,24,
     34,28,89,42,89,39,34,40,35,35,35,35,38,130,64,34,63,31,126,34,62,
     38,,63,90,,65,7,7,7,7,7,7,45,44,45,34,45,44,45,55,55,41,55,55,41,
     55,55,31,46,,,48,,,,,,47,21,35,49,,,,,,49,,42,28,89,,24,34,,,,34,35,
     35,35,130,63,38,126,62,34,63,31,,34,,90,65,66,7,7]],
 [,[],[],[],[],[],[,52,,62],[,,46],[],[,46,,53,,,46],
   [42,,,,,,,74],[,99,,,,,216,88],[,,108,,,,508,158],
   [42,,64,207,,,,,,181,21,,41],[,,,,,,269,98,,,34,44,64],
   [,303,146,454,,,301,,,,47,98,67],[68,,92,213,,,228,,,220,,33,,31,42],
   [],[68,,78,,,,197,,,148,,42,67,,32,,44],[,,140,,,,,122,,,,127,67,,,45],
   [,,148,,,,444,144,,,,,43,41,67,67,,,70,63],
   [194,,138,,,,526,132,,592,47,,61,,,43,58,,,45,61],
   [28,,,,,,56,,,52,84,,,84,,260,116,,121,,224,224],[],
   [,41,,,,,76,,,70,,142,,,173,300,175,,148,376,375,318],
   [28,47,78,,,,,,,56,79,97,223,71,,,,,88,,219,217,28,,41],
   [,66,,73,,,79,160,,77,131,132,253,,133,,167,,126,375,,322,39,,46],
   [28,43,116,52,,,,,,,84,125,188,84,120,186,128,,124,202,196,,28,,39,28],
   [,,93,,,,,109,,,,200,,,,430,,,,,,496,,,,92],[],
   [,,70,,,,,,,,129,132,227,,132,207,174,,,,234,294,,,,63,,,86],
   [,47,,52,,,70,,,64,162,,358,,,343,157,,138,,281,486,,,39,44,46,39],
   [,67,,,,,94,162,,73,,135,,166,129,395,151,,133,346,299,242,,,47,,32,39,
     130,,84,47],[,58,240,64,,,56,,,,,168,411,,178,,164,,,327,,306,39,,53,
     38,46,,,,,50,46],[70,,,,,,367,,,,105,,,105,190,,214,,,,,,140,,,125,192,
     140,835,,,,,227],[70,,230,245,,,344,272,,,105,,349,105,,,188,,233,349,
     309,281,140,,,117,,140,514,,469,227,,228,35],
   [70,,,,,,,460,,344,105,170,,105,166,225,,,168,251,233,249,140,,,125,198,140,
     ,,2514,228,193,,35,35],
   [70,175,226,,,,262,,,244,105,213,287,105,,,,,215,337,315,,140,,204,119,168,
     140,662,,751,206,168,208,35,35,35],
   [42,,,,,,,70,,,37,,,42,54,78,47,,53,102,,78,84,,,74,112,84,133,,116,137,,,
     195,195,189,195],[,,,,,,146,,,131,,,,369,258,,,,,,,,,,,134,177,130,,,,130,
     ,152,,475,,526],[,,,,,,389,,,,,,,71,97,105,,,95,,67,94,,,,,237,242,264,
     ,390,332,,,,499,,460],
   [42,,64,100,,,158,72,,96,42,,72,37,,,52,,48,121,72,,74,,97,59,,74,142,,,
     100,140,,180,164,174,168,42,84,70],
   [212,330,252,414,,,544,241,,477,100,119,91,,,,85,,,75,96,67,263,,313,,,,
     279,,258,515,,322,803,,331,456,94,,84],
   [42,116,66,158,,,,70,,160,37,50,71,37,49,71,49,,,85,73,,84,,123,74,112,
     84,,,117,123,115,137,168,166,154,168,37,,62,37],
   [,114,,125,,,,,,106,,224,,622,243,770,240,,360,,,1147,130,,166,134,177,,,,,
     158,274,136,1874,593,,,,105,,122],
   [42,83,68,112,,,,,,,37,49,119,42,52,80,,,55,86,119,78,74,,100,59,86,74,
     147,,,108,86,102,180,164,174,168,37,126,,32,76,37],
   [,,217,,,,496,210,,,,,69,,129,103,,,,101,73,114,388,,503,395,360,285,319,,
     329,414,408,463,573,611,323,,,,62,,81,65],
   [42,102,66,158,,,162,,,156,42,54,78,37,47,117,54,,,,78,121,84,,136,74,
     112,84,130,,,,112,123,195,195,189,195,42,,75,37,,37,,42,94],
   [,,,140,,,215,,,180,,,,,275,807,328,,,,,,,,174,,,168,,,,,248,211,,,1686,1470,,
     126,,,,,160],[164,560,,499,,,,,,453,79,119,93,,,67,89,,,,91,67,258,,
     407,309,,,285,,,,272,,,873,345,589,75,,88,,60,63,,,84],[],
   [,,171,,,,402,,,,,,67,71,116,103,,,102,95,,91,,,,,325,292,302,,278,324,271,
     ,583,,335,533,,,60,70,82,,,,62,94,,79],[],
   [14,,,,,,,48,,50,21,,,21,32,43,33,,,47,49,43,28,,,24,,28,89,,90,45,,43,
     35,35,35,35,38,,,34,,31,100,34,66,38,142,64,,66],
   [14,27,36,38,,,46,44,,38,21,35,,21,,,38,,35,49,49,49,28,,40,23,,28,71,,
     58,41,37,40,35,35,35,35,39,84,69,32,,32,80,32,,39,100,68,,71,,7],
   [14,,56,52,,,,,,56,21,32,41,21,31,41,31,,32,43,41,41,28,,,25,36,28,,,
     175,43,36,42,35,35,35,35,37,154,58,34,57,30,,34,57,37,130,58,,56,,
     7,7],[14,27,38,38,,,44,40,,38,21,38,51,21,35,,,,,49,55,55,28,,38,
     23,32,28,69,,57,39,32,38,35,35,35,35,39,78,82,32,86,32,78,32,,39,
     106,71,,70,,7,7,7],
   [14,35,,,,,56,,,56,21,35,49,21,34,51,,,,,51,49,28,,42,25,36,28,,,,,36,
     42,35,35,35,35,39,154,71,36,71,32,130,36,86,39,,,,69,,7,7,7,7],
   [14,,,,,,,48,,50,21,,,21,32,43,33,,,47,49,43,28,,,24,,28,89,,90,45,,43,
     35,35,35,35,38,,,34,,31,100,34,66,38,142,64,,66,,7,7,7,7,7],
   [46,,,,,,83,200,,75,146,,,158,167,362,167,,170,,356,345,44,,,51,60,51,218,,
     ,55,,61,238,244,238,224,134,,,126,364,146,185,114,484,134,230,366,,412,
     ,48,48,46,44,46,48],
   [56,85,126,84,,,99,,,93,153,172,349,129,,,,,163,,353,339,51,,61,41,,51,
     150,,108,67,50,64,235,211,235,217,138,204,,113,,138,227,113,494,138,,
     380,,438,,44,41,47,41,47,44,51],
   [56,70,176,75,,,,,,67,146,169,318,158,176,299,164,,181,340,292,309,51,,
     61,51,60,44,,,204,62,62,54,238,244,238,224,144,179,322,126,318,134,,
     114,402,146,240,319,,385,,48,48,46,44,46,48,51,51],
   [46,66,,71,,,,152,,,124,133,291,120,129,311,,,124,338,299,300,44,,56,41,
     50,44,137,,105,57,50,56,188,184,188,168,110,171,351,104,,109,173,86,,
     109,231,346,,312,,37,34,36,32,36,37,44,41,44],
   [46,60,166,67,,,83,,,75,146,165,,158,164,354,167,,,,378,361,44,,54,51,63,
     51,202,,,,60,61,238,244,238,224,134,167,363,126,386,146,185,114,395,
     134,,,,373,,48,48,46,44,46,48,44,51,51,44],
   [56,,,,,,108,,,84,153,,,129,169,281,172,,164,319,307,289,51,,,41,50,51,,,
     132,62,,61,235,211,235,217,138,,,113,340,138,308,113,434,138,290,343,,
     335,,44,41,47,41,47,44,51,41,51,41,51],
   [56,78,174,75,,,77,,,,146,202,366,158,,385,,,169,,,,51,,61,51,63,44,,,,64,
     60,,238,244,238,224,144,179,,126,360,134,181,114,659,146,,369,,,,48,48,
     46,44,46,48,51,51,44,44,51,51],
   [126,,,,,,436,184,,,53,,,63,86,83,105,,,,73,83,232,,,207,299,220,,,289,344,,
     ,285,285,273,285,101,,,106,126,87,616,101,122,106,605,143,,115,,55,57,
     53,57,57,55,372,369,360,294,372,357,372],
   [126,271,172,359,,,430,200,,353,63,91,83,53,,,83,,103,77,89,73,232,,347,
     199,,220,341,,315,328,309,339,285,285,273,285,106,414,125,101,,87,516,
     106,135,101,731,119,,144,,55,57,53,57,57,55,384,345,372,290,384,333,
     384,63],[106,259,120,354,,,,130,,342,53,76,73,53,73,73,75,,76,79,77,
     77,184,,278,169,248,164,,,216,284,228,287,231,227,203,231,87,464,109,
     87,110,66,,87,118,87,,116,,,,41,43,39,43,43,41,296,295,272,242,296,
     275,300,53,53],[126,,206,360,,,374,192,,,53,106,73,63,88,83,,,86,87,
     73,87,232,,312,201,276,220,,,287,330,276,311,285,285,273,285,101,472,
     115,106,125,87,,101,,106,,129,,115,,55,57,53,57,57,55,360,351,348,276,
     360,339,360,53,63,53],
   [126,274,166,396,,,460,,,,63,91,87,53,105,73,86,,,,83,73,232,,342,207,
     287,220,343,,,,300,341,285,285,273,285,106,545,141,101,115,87,594,106,
     131,101,,,,126,,55,57,53,57,57,55,372,369,360,294,372,357,372,63,53,
     53,63],[106,,,,,,374,132,,308,53,,,53,,79,73,,73,79,73,73,184,,,163,
     262,164,,,211,291,,290,231,227,203,231,87,,,87,119,66,406,87,,87,400,
     118,,112,,41,43,39,43,43,41,308,277,284,242,308,257,312,53,53,39,53,
     53],[126,292,,402,,,526,192,,,53,107,73,63,89,93,111,,89,91,,83,232,,
     331,207,301,220,,,299,343,306,,285,285,273,285,101,,115,106,143,87,670,
     101,125,106,1037,135,,,,55,57,53,57,57,55,374,369,362,296,374,357,374,
     53,63,53,53,63,53],
   [126,,164,348,,,406,208,,344,63,,83,53,102,73,86,,103,77,83,,232,,327,
     201,264,220,389,,372,313,276,323,285,285,273,285,106,512,126,101,116,
     87,456,106,170,101,628,119,,125,,55,57,53,57,57,55,360,351,348,276,
     360,339,360,63,53,53,63,53,53,63],
   [,,,,,,,,,,,,,,,199,106,,148,,,,,,,27,,,,,,,,,,144,,155,,,,,323,95,,83,371,102,,
     ,,,,,26,33,27,,,,52,62,39,,,66,,233,229,225,256,,,237],[],
   [,,,,,,,,,,,,,,,676,,,,,,,,,,,78,,,,,,,,,344,,250,,,,,476,,,132,1020,166,,455,,,,
     ,46,,44,56,,,,,46,,,,,,490,384,,,518,402],
   [,,,,,,,,,,,,524,,,324,,,125,568,,,40,,60,27,40,40,98,,81,59,40,58,233,144,
     ,,,,392,79,276,,,,375,102,,320,,,,30,26,35,25,35,30,64,52,65,36,65,
     55,64,,228,214,243,270,173,291,253,27,,46],
   [,,,,,,,,,,68,,130,,,120,82,,,168,132,,124,,178,,,,,,,156,142,,328,228,364,
     256,66,108,148,,139,66,104,36,152,64,142,,,146,,48,38,68,36,,48,174,
     156,,144,182,164,166,164,188,122,168,188,120,170,192],[],
   [,,,,,,,,,,,96,108,64,78,146,,,116,140,148,138,,,,,146,132,,,,,,165,,230,,
     226,64,110,134,36,150,66,108,,149,66,152,144,,,,,36,56,38,,,158,,188,
     144,,156,174,,172,120,206,166,,,164,,,,,40],
   [,,,,,,,,,,,221,485,,195,,148,,210,572,,,,,,,,,,,,,66,,,246,,,158,,,,303,,,128,
     317,162,,,,371,,50,38,56,38,56,50,69,47,67,46,67,47,73,442,,,356,417,
     290,444,356,,,46,40],[],
   [,,,,,,259,,,,,,,41,,73,,,54,85,,76,,,,,,122,152,,143,166,,,,,168,,,,,41,64,
     32,,,,,,83,,,,,35,32,,,,,176,168,,170,,171,,102,85,,,,104,104,88,,,,78],
   [,,,,,,,174,,,,,,65,79,89,,,79,,,97,,,,219,301,180,,,252,,,348,,,221,325,,,,
     104,153,81,597,117,,102,499,151,,,,,49,43,51,49,,,353,310,298,,,374,,
     63,43,,61,,,71,,,,,142],
   [42,,,,,,,,,,21,44,67,21,44,67,44,,44,,61,61,84,,153,79,,84,160,,,159,
     139,158,105,105,105,105,42,204,90,42,90,32,196,42,90,42,244,90,,,,21,
     21,21,21,21,21,146,153,146,124,146,153,146,63,63,43,63,63,43,63,63,,,
     ,,,,,,,,47],[68,,,204,,,224,,,259,34,,86,41,34,160,55,,32,,,134,115,,
     158,,148,,,,133,156,,155,219,200,173,,53,184,92,41,133,39,190,52,110,
     39,237,133,,89,,36,34,31,35,35,36,174,176,,120,192,170,172,86,102,59,
     86,102,59,89,104,111,,,88,,,130,151,,41,67],
   [,,,,,,,192,,,47,121,85,65,111,47,70,,134,47,99,43,220,,325,213,312,,291,,
     ,313,345,395,277,,231,,78,335,122,104,64,60,339,78,116,100,415,59,,
     116,,49,47,43,49,,49,354,347,,315,372,301,,83,63,57,83,57,57,89,57,,,,
     ,112,,,559,,64,63],
   [68,100,110,175,,,219,,,153,,,,,,88,,,59,106,,82,119,,146,93,131,126,,,143,
     163,134,155,199,,167,217,47,193,74,41,64,32,180,48,82,41,238,64,,74,,
     32,35,32,34,35,32,177,168,164,128,170,169,176,101,104,87,,108,87,101,
     106,,,,,,,,221,,32,,34,44],
   [,662,,481,,,502,150,,,,,,65,86,85,,,86,91,,99,,,569,219,258,188,407,,245,
     391,242,477,297,,241,315,117,347,,100,,,362,,,108,537,161,,,,43,49,43,
     47,49,43,351,341,309,296,355,287,367,73,57,43,73,57,41,77,57,,,,,146,,
     ,,,,43,,64,61],[],
   [,309,206,450,,,337,160,,,,114,93,65,119,47,,,123,,91,47,256,,329,,380,,
     303,,226,324,,311,,,245,337,98,357,,106,74,76,359,86,,104,439,83,,164,,
     49,55,43,49,49,49,376,,,315,356,295,413,,61,61,93,61,61,97,61,213,,,
     391,136,,206,340,,83,61,,,45,98,63],[],
   [,,,,,,,116,,,47,,91,,121,43,68,,121,47,85,47,,,399,,,184,375,,358,413,
     368,278,335,289,227,,78,422,124,,61,62,396,,,104,,61,,,,45,49,41,47,
     49,45,351,345,314,326,339,307,406,83,61,61,85,61,61,83,71,305,,,,132,,
     ,564,,,71,,,43,,67,,45],
   [,,,,,,114,,,100,,,,,158,,161,,,,,,,,,133,,108,,,,,,136,,418,2514,437,,,,86,,,
     84,,,,,,,,,,57,121,61,,,,213,160,,,,160,,315,,367,,,,398,,,,,70,,72,,,,,
     129,131,231,131,351,,,,248],
   [,,,,,,80,,,69,,,,155,142,291,143,,177,436,369,,,,,50,62,47,,,,,,57,,228,,
     200,,,,128,286,124,177,107,430,137,,328,,340,,,40,43,38,43,,,50,47,39,,
     ,46,,339,286,310,341,,,324,39,,,52,220,,,52,,136,,158,152,299,,472,,314,
     ,328],[28,,128,,,,58,130,,52,84,118,228,84,117,232,,,,250,,252,28,,
     46,28,46,28,141,,112,47,47,39,140,140,140,140,84,,254,74,,84,134,74,
     291,84,,374,,257,,28,28,28,28,28,28,51,51,46,38,51,51,46,232,232,
     184,232,232,184,232,232,40,,56,,,,124,52,,115,224,84,,,,246,,,,230,,39],
   [,,,,,,164,,,144,160,239,317,,,,172,,156,,285,299,,,216,137,,133,,,,,195,
     170,835,514,,,139,118,264,86,260,140,110,75,311,130,161,245,,274,,90,
     73,89,69,121,90,218,237,199,194,,253,,348,341,269,395,,273,,438,,,,,,,
     93,,,154,326,,,,226,343,,309,,469,86],
   [,,146,,,,75,214,,73,158,176,308,,,376,150,,168,379,474,,39,,58,50,39,39,
     170,,136,57,38,46,241,227,,208,125,,342,127,330,,187,109,423,123,,341,,
     359,,45,41,43,38,42,45,61,50,53,48,62,48,53,350,339,254,324,347,256,
     348,328,52,,70,39,,,184,64,,151,298,,136,,181,264,,471,,400,,50],
   [28,,86,62,,,62,104,,,79,109,219,71,86,233,93,,,233,219,,28,,,28,39,28,,,
     101,50,39,50,125,117,125,119,74,109,212,55,196,74,109,57,229,74,,204,
     ,202,,24,23,25,23,25,24,51,48,51,37,51,48,51,207,199,169,201,207,
     163,207,201,39,,,,86,,86,56,,86,217,79,88,217,,,,245,,217,,38,28],
   [,52,133,66,,,52,206,,36,139,143,346,166,130,250,125,,137,276,363,346,,,
     69,37,46,47,195,,,64,46,38,198,,193,168,113,186,270,74,253,114,84,78,
     303,112,216,268,,268,,46,37,36,32,36,46,,54,47,46,62,55,46,287,309,
     243,260,303,258,286,276,62,,104,,146,,114,76,,129,355,,,310,145,,,284,,
     317,84,47,40,130,46],[],
   [,,,,,,73,,,71,159,177,313,,136,415,155,,,,306,455,,,,,61,46,,,,,64,57,231,
     229,228,,136,,290,127,440,123,173,106,310,,,373,,352,,46,41,42,39,45,
     46,55,48,45,39,54,48,45,343,328,278,323,330,,348,318,39,,56,52,196,,,,
     ,,443,162,142,351,,324,,383,,,,39,39,,50,38,47],[],
   [,46,,,,,40,169,,46,,139,,,125,,127,,133,379,267,,39,,67,37,46,46,,,,61,
     46,39,199,240,198,168,,140,243,78,263,,82,82,277,112,,275,,237,,39,38,
     36,32,36,39,60,53,45,45,60,53,46,298,,247,276,290,261,301,264,66,,,
     60,,,142,,,129,317,131,125,,135,346,,326,,318,,46,39,,46,,32,,46],
   [70,,,352,,,,,,,105,207,315,105,,,,,,,277,301,140,,223,125,,140,,,,,195,,35,
     35,35,35,195,,511,180,678,168,1853,180,843,195,,446,,585,,35,35,35,35,
     35,35,238,235,238,188,238,235,238,285,285,231,285,285,231,285,285,258,
     ,367,,,,,328,,216,291,105,,,194,,,,,323,,241,140,,,125,195],
   [70,,214,268,,,344,,,246,105,,,105,,,197,,,,,357,140,,239,117,240,140,514,,
     418,229,,227,35,35,35,35,195,468,728,164,,166,,164,,195,,520,,,,35,35,
     35,35,35,35,244,211,244,184,244,211,244,285,285,227,285,285,227,285,
     285,143,,,,,,214,230,,189,311,105,,357,,,,,,,469,225,140,514,228,117,,,
     227,,,35],[70,,,,,,,,,,105,171,233,105,166,227,170,,167,245,241,231,140,
     ,,125,,140,,,,224,197,,35,35,35,35,189,,311,174,349,154,1486,174,323,
     189,1114,,,349,,35,35,35,35,35,35,238,235,238,188,238,235,238,273,273,
     203,273,273,203,273,273,,,404,,,,,,,,,105,169,249,,233,,251,,225,701,224,
     140,,228,125,198,,,,193,35,35],
   [,,,,,,,132,,,,,,196,228,442,218,,184,384,506,320,,,,109,206,,121,,96,,,,,
     475,978,,,,,190,399,169,,164,438,169,,,,,,,84,154,78,154,,,105,,126,,,,,
     431,308,510,406,,877,400,,,,100,,,,104,,,,,274,,271,,,,,,,,134,,152,132,
     240,,132,,175,1577,475,2133],
   [,,,,,,451,156,,,,,,83,93,120,74,,89,139,,147,,,,196,,242,250,,231,356,,343,
     ,450,337,456,,,,124,,99,354,110,,115,560,178,,,,,,57,86,71,,,333,350,
     269,339,,385,,81,60,,82,,,101,,,,,188,,160,431,,,,100,102,91,,68,,105,,
     102,213,,314,312,,,651,,389,,,549,598,331],
   [42,106,,157,,,186,68,,156,42,44,104,42,44,106,40,,39,106,100,102,84,,
     126,74,112,84,144,,114,128,114,135,195,195,189,195,42,174,115,42,130,
     42,170,42,121,42,212,130,,115,,38,39,37,39,39,38,144,138,134,110,144,
     138,134,106,106,71,106,106,71,106,106,100,,195,,,,64,158,,53,78,37,,,
     54,,,121,,,118,125,84,,,74,115,,128,,115,195,195,189,,94],
   [,,,,,,,132,,,,,397,202,202,397,193,,188,358,645,348,134,,171,109,,136,110,
     ,82,177,78,179,966,667,,,,,313,193,444,169,,166,,169,,408,,,,100,80,,
     78,130,100,181,105,185,101,187,101,193,545,433,316,510,414,327,670,
     408,106,,146,,,,,129,,360,,,,,230,,,852,,,,156,,,,176,173,,154,,241,,605,,
     105],[212,358,,,,,384,167,,430,100,98,214,83,144,98,64,,141,,174,63,
     291,,357,229,,251,295,,236,,301,379,573,518,329,,94,,,128,94,87,461,85,
     258,128,675,86,,,,66,,57,,86,66,378,380,344,298,,351,,127,81,79,128,
     79,81,137,79,,,765,,,,164,,,,97,,,,149,94,,73,,70,265,,,294,,,291,,469,,
     326,,518,326,,81],[42,112,,147,,,172,40,,154,37,,121,42,52,72,48,,52,
     ,117,72,74,,147,55,78,74,,,57,129,74,127,180,164,174,168,37,191,110,
     42,67,37,194,37,116,42,261,67,,110,,34,32,34,32,36,34,126,93,126,78,
     126,97,126,101,106,87,101,106,87,101,106,73,,,,64,,72,96,,48,115,42,
     52,72,,,,84,,72,116,97,74,,101,59,,,101,,140,180,164,174,84,,42,122],
   [,487,,356,,,407,154,,,,,,79,99,120,74,,89,135,,,374,,358,204,284,238,289,
     ,248,,279,,446,690,334,,,316,,122,174,101,,110,,117,489,193,,,,64,68,
     58,71,,64,382,339,323,268,359,312,,115,75,60,117,77,57,123,77,,,,,252,
     ,154,691,,,70,79,117,94,,,,95,,103,265,451,253,302,,,,,,,406,578,,334,,
     60,75,,84],[42,120,,168,,,,72,,156,37,33,87,30,39,62,33,,39,76,87,
     60,84,,140,74,112,84,139,,118,,111,126,168,166,154,168,37,169,101,42,
     71,37,169,37,103,42,213,71,,101,,31,32,30,32,32,31,134,138,146,109,
     134,138,146,87,78,58,87,80,58,87,80,97,,,91,66,,,,,,71,37,49,79,49,
     73,,,,71,118,134,84,139,126,74,111,,,,112,168,166,154,,,37,,65,37,63],
   [,,,,,,,,,,,,693,,318,650,238,,233,589,,542,,,,,206,,,,132,,204,,,1542,,,,,701,
     ,,211,,206,571,209,,484,,,,142,100,130,106,,142,213,139,217,126,203,139,
     ,750,,388,504,512,374,,514,,,170,144,,,,,,,,,,,355,,,1032,,,,174,168,,200,
     ,296,,,,261,2118,1930,,126,,,160],
   [42,,46,134,,,132,46,,130,42,42,106,42,39,,41,,42,110,106,100,74,,,57,
     82,74,75,,,106,78,109,180,164,174,168,42,214,137,42,129,42,,42,,42,
     222,133,,152,,34,32,34,32,36,34,114,99,114,82,114,103,114,106,106,71,
     106,106,71,106,106,85,,132,,,,,112,,55,78,37,48,109,52,82,,,,119,,100,
     74,147,102,59,86,,108,,86,180,164,174,126,76,37,,,32,,37],
   [164,286,,374,,,433,190,,387,79,127,,79,136,61,56,,133,127,226,59,257,,
     305,202,294,248,326,,230,,257,,,445,339,533,75,417,203,122,71,71,413,
     71,178,126,581,75,,174,,66,71,56,70,69,66,363,337,352,273,405,,369,
     143,75,77,141,82,77,143,77,261,,,,236,,154,,,102,108,,,70,103,91,,,,67,
     ,306,,264,435,,352,,404,,399,456,667,335,,82,,,62,70,79],[],[],
   [,,,419,,,327,167,,316,,,154,,161,65,58,,156,76,154,,266,,376,227,330,285,
     274,,239,346,282,,675,,341,,,517,175,,73,73,,73,,149,,73,,211,,64,71,
     56,69,,64,371,361,377,269,422,319,376,130,91,92,133,91,92,132,101,307,
     ,664,,172,,158,371,,93,120,,,68,104,115,,72,,,,339,,,,,261,,398,,286,780,
     ,341,,101,,,63,70,101,63,,,61],
   [14,31,40,46,,,46,,,,21,40,53,21,40,,,,40,,,53,28,,39,24,34,28,,,,39,34,
     40,35,35,35,35,38,162,108,34,87,34,,34,,38,126,,,108,,7,7,7,7,7,7,
     45,44,45,34,45,44,45,55,55,47,55,55,47,55,55,31,,46,,,,40,,,40,59,
     21,,,40,59,,,,,65,42,28,,,24,34,,42,,34,35,35,35,162,87,38,,,34,,34,
     126,34,108],[14,,46,,,,,46,,,21,35,49,21,32,43,35,,32,47,45,43,28,,,
     24,,28,86,,,,42,,35,35,35,35,38,100,66,34,63,31,100,34,66,38,156,,,,,
     7,7,7,7,7,7,48,44,48,37,48,44,48,55,55,41,55,55,41,55,55,,,,,,,46,,
     ,32,43,21,35,,,,,49,,45,86,45,28,89,43,24,,,46,,39,35,35,35,100,63,
     38,100,66,34,,31,156,34,,,,64,7],
   [14,30,,50,,,50,48,,,21,34,43,21,35,45,32,,,49,,,28,,43,24,39,28,89,,
     86,46,,43,35,35,35,35,38,136,61,34,66,31,172,34,65,38,,66,,61,,7,7,
     7,7,7,7,48,44,48,37,48,44,48,55,55,41,55,55,41,55,55,30,,50,,46,,,,
     ,,45,21,32,43,33,45,,47,,43,,43,28,86,,24,42,,,,,35,35,35,136,66,38,
     172,65,34,66,31,,34,61,,,63,7,7],
   [14,31,,46,,,48,,,,21,40,59,21,40,,40,,,,59,,28,,40,24,34,28,,,65,42,34,
     ,35,35,35,35,38,90,,34,108,34,126,34,,38,130,87,,,,7,7,7,7,7,7,45,
     44,45,34,45,44,45,55,55,47,55,55,47,55,55,31,,48,,40,,,,,,,21,40,53,
     40,,,,,,,39,28,,40,24,34,,39,,34,35,35,35,90,108,38,126,,34,87,34,
     130,34,,,,,7,7,7]],
 [,[],[],[],[,9],[],[,10],[,,21],[,,,,10,,11],
   [,10,,,,,11,,11],[24,,,,36,,,38],[,24,,,29,,32,42,30,32],
   [,,61,,74,,88,82],[24,,,,,,43,,35,,24],[,41,,,34,,39,49,34,,,24],
   [,,68,,80,,59,89,114,97,,,60],[,,42,,40,,48,48,,48,,24,,30,24,44],
   [148,95,63,,,,57,86,68,,,,44,48,48,66],[],
   [,,64,,88,,,57,,,48,68,60,,,44,50,66],[],
   [,69,70,,72,,,65,74,83,48,48,60,,,44,47,63,,44],
   [8,,,,10,,11,,,11,23,,,23,,,,81,,,,67],[,,,,,,,20,,,,,,,,,37,63,,65,,60],
   [,7,,,8,,9,,8,9,,21,,,27,,29,48,,64,,50],
   [8,,,,10,,11,22,10,11,23,,,23,,,,75,,,,75,7],
   [,7,,,8,,9,,8,9,,21,,,27,,29,48,,64,,50,,,6],
   [8,7,40,,,,,40,8,,22,23,44,22,23,44,23,44,,44,,42,8,,6,8,6],
   [,,20,,,,,22,,,,45,,82,,96,49,87,,,,97,,19,,21],
   [,8,36,,8,,,,9,9,27,25,55,26,28,53,29,45,,52,,45,9,,7,9,7],
   [,,22,,,,,,,,39,41,73,82,42,,,80,,,,75,,16,,,,,19],
   [,,,,8,,9,,,9,21,22,44,26,,,23,38,,,,50,,,6,8,6,6,,7],
   [10,7,20,,8,,9,20,8,9,22,21,49,26,24,48,24,42,,47,,44,8,18,6,,6,6,
     18,7,18,6],[10,8,,,10,,9,36,9,,,27,68,26,28,53,35,67,,45,,41,9,,
     7,9,7,,,7,,7,7],[40,,,,,,59,156,57,63,108,,,114,,,130,283,,286,,292,
     37,,,37,,34,128,,167,34,34,39],
   [40,,,,54,,,122,51,61,112,,,114,,,133,,,306,,286,37,,,37,,36,114,41,115,37,
     ,40,36],[40,50,,,,,,176,57,59,110,121,228,112,,225,125,,,228,,,37,
     170,35,37,35,34,,,168,33,33,41,36,36],
   [40,,104,,44,,49,106,,49,106,118,268,114,,296,,,,272,,,35,88,30,35,30,30,
     89,35,89,30,30,35,33,36,33],
   [24,,,,28,,35,37,31,,20,,,23,,,24,72,,47,,47,22,,,22,,22,34,23,37,21,22,
     24,106,108,106,104],[],
   [,,,,64,,63,,64,,,,,,,,,44,,60,,61,,57,,,,39,66,50,,39,44,,,,235,270],
   [24,,,,26,,27,,26,27,21,,,22,,,24,45,,60,,,19,,,17,,20,35,21,39,20,20,
     21,94,88,94,86,21],[],
   [24,25,35,,,,,37,30,33,22,21,44,22,21,,21,44,,44,,44,22,34,18,22,18,18,
     ,,36,18,18,23,98,104,98,90,21,,,21],
   [,22,,,,,,,25,25,,48,,63,49,92,53,91,,,,,23,,17,21,17,,,,,19,17,19,202,
     127,,93,,,,20],[24,19,34,,22,,23,38,22,23,22,21,68,23,21,41,,,,43,,
     40,19,36,14,17,14,16,38,17,38,16,14,17,87,86,86,74,21,,,17,,18,17],
   [,,87,,66,,66,79,64,,,,44,48,75,58,,,,63,,61,91,57,71,,71,39,61,50,71,
     39,44,72,265,322,,,,,40,44,,57],
   [24,,35,,31,,33,,,39,21,25,41,22,25,56,24,41,,,,56,22,34,22,22,22,22,
     36,23,,,22,23,104,108,106,104,21,,40,21,,21,,21,43],
   [,,,,24,,25,,,25,,,,59,45,,43,88,,,,80,,,16,20,16,18,,19,,,16,19,185,99,
     185,,,,,19,,,19,16],
   [152,,91,,74,,71,,,81,65,79,61,,,45,47,64,,,,47,117,91,,120,,43,94,54,,,
     48,50,355,391,239,313,65,,53,,,45,,45,56],
   [,22,,,,,25,,25,,,49,,,49,94,53,,,,,81,23,,17,21,17,,,19,,19,17,,,128,
     153,93,,,,20,,,19,17,,,19],
   [,,,,65,,64,110,65,,,,45,50,,72,,47,,72,,74,,83,,,,40,60,51,94,40,48,,
     288,,236,261,,,44,45,,45,,,41,40,,72],
   [120,,74,,102,,118,104,,120,48,,60,,,44,47,64,,49,,,77,64,,,,43,67,61,65,
     65,45,57,373,320,241,287,48,,56,,,45,,45,53,,,44,,69],
   [56,,,,64,,,196,67,81,148,,,158,,,175,352,,376,,342,51,,,51,,46,196,53,
     163,45,45,55,236,248,236,224,146,,,126,,134,187,114,339,144,167,405,
     225,395,425],[56,,,,66,,77,150,66,78,152,,,158,,,173,364,,366,,370,51,,
     ,51,,50,,54,143,49,48,55,244,250,244,238,148,,,120,,142,,114,,148,130,
     431,180,399,397,48],
   [56,,214,,,,,,78,86,150,163,312,156,166,301,167,301,,308,,299,51,162,,51,,
     46,,,162,45,45,55,236,246,236,226,146,,304,126,,134,,115,313,146,173,,
     244,313,319,48,48],
   [56,61,140,,62,,67,140,74,67,146,162,354,158,164,,,,,354,,336,49,121,42,
     49,42,42,120,49,121,42,42,49,230,246,228,210,144,,353,118,,126,127,
     102,,144,,400,127,461,,45,48,45],
   [56,,178,,65,,75,,,83,146,170,356,158,168,,,384,,,,357,51,198,46,51,46,46,
     ,53,,,45,55,238,244,238,224,144,,372,126,,134,225,114,350,146,,,237,,,
     45,48,48,45],[56,,158,,64,,82,,66,76,150,169,320,158,169,308,177,306,
     ,,,302,51,146,,51,,50,143,53,156,48,,54,242,250,244,238,148,,298,120,,
     142,167,114,297,148,131,377,,302,,48,48,48,48,48],
   [8,,,,10,,11,22,10,11,23,,,23,,,,61,,,,61,7,,,7,,8,20,9,,8,8,9,37,37,
     37,35,22,,,17,,22,21,17,71,22,20,107,21,69,69,51,51,51,49,51,51],
   [8,,,,10,,11,22,10,11,23,,,23,,,,61,,,,61,7,,,7,,8,20,9,,8,8,9,37,37,
     37,35,22,,,17,,22,21,17,71,22,20,107,21,69,69,51,51,51,49,51,51,7],
   [8,12,28,,,,,28,11,11,24,30,46,24,30,48,31,46,,48,,46,8,34,10,8,10,8,,
     ,34,9,9,9,40,40,40,40,24,,50,20,,24,,20,50,24,23,62,23,50,61,56,
     56,56,56,56,56,8,8],
   [8,11,18,,10,,11,18,10,11,23,26,57,23,26,51,,,,53,,51,7,18,9,7,9,8,
     18,9,18,8,8,9,37,37,37,35,22,,60,17,,22,21,17,,22,20,66,21,50,62,
     51,51,51,49,51,51,7,7,8],
   [8,,26,,10,,11,,,11,23,27,,23,25,51,26,49,,,,51,7,,9,7,9,8,20,9,,,8,
     9,37,37,37,35,22,,48,19,,22,23,19,47,22,,,23,47,60,51,51,51,49,51,
     51,7,7,8,7],[8,11,18,,10,,11,18,10,11,23,26,43,23,27,43,24,43,,
     43,,45,7,17,9,7,9,8,16,9,17,8,,9,37,37,37,35,22,,43,17,,22,21,17,
     42,22,20,57,21,45,44,51,51,51,49,51,51,7,7,8,7,7],
   [8,12,,,12,,11,24,11,,24,32,54,24,,60,31,56,,54,,52,8,34,10,8,10,8,,
     9,34,9,9,,40,40,40,40,24,,65,20,,24,23,20,66,24,23,66,,,65,56,56,
     56,56,56,56,8,8,8,8,8,8],
   [72,,,,78,,83,90,,89,52,,,68,,,72,74,,86,,84,61,,,61,,50,,61,85,53,53,,
     276,292,264,260,52,,,57,,49,135,49,74,57,85,85,,77,86,372,388,360,
     356,372,370,57,57,60,59,59,55,64],
   [72,,,,,,84,95,80,89,64,,,58,,,67,82,,78,,76,61,,,61,,54,82,61,86,53,56,
     62,284,294,272,274,59,,,54,,52,107,55,84,54,102,79,122,88,80,384,394,
     372,374,384,378,57,57,60,59,59,55,64,60],
   [64,68,68,,,,,62,67,79,56,56,80,58,56,78,55,78,,76,,78,53,64,46,53,46,
     38,,,60,41,38,47,224,234,200,208,50,,82,50,,38,,41,99,46,,80,71,81,
     83,296,308,272,284,296,280,49,49,44,45,45,41,48,52,52],
   [72,69,97,,74,,73,90,88,81,56,62,80,68,59,79,,,,90,,81,59,80,48,59,48,
     46,91,57,84,50,50,53,270,290,256,246,54,,77,57,,46,95,46,,57,84,87,
     95,77,87,360,382,350,338,360,366,55,55,60,57,57,53,64,49,60,49],
   [72,,88,,79,,87,,,,61,63,88,58,66,71,62,86,,,,76,61,86,52,61,52,50,83,
     61,,,53,61,278,288,266,264,57,,84,54,,49,129,53,86,52,,,98,84,80,372,
     386,360,358,372,372,57,57,60,59,59,55,64,57,52,52,57],
   [64,67,68,,55,,66,,64,77,56,61,80,58,61,74,63,74,,,,78,53,65,50,53,50,
     40,59,44,66,44,,47,232,238,206,222,50,,80,50,,40,92,44,78,46,62,84,
     92,82,84,308,314,282,302,308,286,49,49,44,45,45,41,48,52,52,40,52,
     52],[72,70,,,78,,83,94,81,,56,66,80,68,62,82,67,71,,86,,79,61,113,
     53,61,53,50,,61,85,53,53,,276,290,262,260,54,,78,59,,49,134,49,76,
     59,84,86,,,86,374,384,362,356,374,368,57,57,60,59,59,55,64,52,60,49,
     49,60,52],[72,61,98,,70,,75,85,74,81,61,59,96,58,63,71,59,79,,78,,
     ,59,80,48,59,48,46,76,57,88,46,50,57,268,286,258,246,57,,92,52,,46,
     100,50,82,54,93,76,87,118,,362,382,348,338,360,362,55,55,60,57,57,
     53,64,57,52,49,54,49,52,57],
   [,,,,,,,,,,,,,,,,39,,,63,,56,,,,,,,,,,,10,,,,,44,,,,,,28,,28,87,28,,,,,78,,,64,
     60,,66,,,12,10,,9,12,,,68,66,78,68,,70],
   [,,,,,,,,,,,,,,,,53,,,,,93,,,,,,40,,28,,,24,,,,140,106,,,,,,,,21,,,,,,,,,,172,
     142,196,,,,28,22,28,24,,,,64,95,91,78,,85],
   [,,,,,,,,,,,,,,,,32,98,,,,109,,,,,,,,,,,12,,,,63,49,,,,,,33,,31,,33,,121,,,77,,,
     ,67,75,,,,,11,,11,,,,77,81,,77,91,81],[],[],[],
   [,,,,,,,,,,,,57,,40,78,,81,,82,,,,,,22,,40,,,,,21,28,,116,,104,35,,75,20,,
     37,26,21,71,35,22,72,22,64,91,,152,216,140,176,158,20,20,28,22,,20,
     24,,96,64,101,90,66,91,98,,21],
   [,,,,,,,,,,,42,117,,43,57,34,66,,88,,59,,,,11,,,,,,,12,,63,58,65,49,33,,70,
     ,,,,31,,39,,,,63,60,81,76,83,67,86,81,9,9,11,11,9,9,11,87,82,,73,
     92,67,87,75,,,11],
   [,,,,,,,,,,,,,35,35,86,33,116,,,,,9,24,8,11,8,8,24,10,24,8,10,10,57,52,
     53,66,,,109,30,,30,,,,31,,70,,,83,67,67,,,69,66,9,9,11,9,9,11,11,81,
     81,73,82,83,70,81,74,10,,11,,,,,11],
   [,,,,35,,40,63,35,,,,,,,,,,,65,,64,,,,,,24,43,29,51,24,28,,,,129,124,,,,,,
     25,,,,27,,61,,,64,,,168,167,,174,,,30,27,26,25,31,,,64,65,71,64,68,,29,
     ,,,,,64,40],[,,,,59,,117,64,,,,,,,,,,,,90,,94,,,,,,44,,47,63,48,42,68,,
     ,226,296,,,,,,44,181,60,,49,65,117,,,90,,,308,354,366,320,,,48,53,,43,
     54,,,44,,60,,,60,,61],
   [24,39,,,,,,,,,24,26,64,24,26,64,,70,,70,,,23,,23,23,23,22,38,,,22,22,
     26,108,112,110,106,23,,,23,,20,45,21,60,21,40,60,43,75,75,148,152,
     150,146,146,150,23,23,24,23,23,23,24,64,64,42,61,61,44,61,61,37,38,,
     ,,,,,,27,48],[],[],
   [,24,53,,29,,32,41,,31,,,,26,27,50,,,,48,,52,30,47,21,28,21,23,,25,41,
     22,21,28,131,135,122,120,24,,50,23,,25,40,21,50,23,37,44,40,51,44,
     171,173,165,158,,,28,28,31,27,,27,31,72,68,62,,71,65,66,66,,42,48,,,,
     ,48,34,25,,27],[,91,,,52,,,66,74,83,,,,68,62,88,,,,90,,101,67,97,
     56,75,56,42,75,41,60,42,44,53,267,302,226,290,72,,,57,,,,,,51,62,100,
     65,,100,343,380,302,382,,304,61,61,46,51,51,45,52,71,56,44,73,54,42,
     74,52,,65,107,,,,93,57,,,44,48],
   [,25,,,31,,48,,28,,,33,,26,24,81,27,,,66,,64,27,45,21,25,21,23,39,25,,
     22,21,26,120,139,123,122,,,58,23,,21,,21,,27,40,63,,73,93,162,,166,
     163,163,168,25,25,30,25,26,25,31,63,68,43,59,68,45,62,66,34,,,,,,,39,
     ,27,,,,,24,65],[,,93,,,,57,65,139,107,48,,86,68,64,42,52,100,,48,,
     42,,104,47,,47,42,72,81,62,48,,45,270,292,223,290,47,,111,47,,40,71,
     43,84,51,,61,65,107,43,345,370,299,336,351,304,,,46,51,51,41,56,82,
     56,54,81,60,56,79,52,63,66,,,,,,61,80,61,60,,,,47,60],[],
   [,,,,,,,61,,,48,50,108,,66,44,48,114,,46,,48,,,63,67,63,44,73,68,128,50,
     64,47,312,324,234,296,47,,,51,,42,71,45,118,49,68,45,73,116,64,366,
     366,308,354,360,320,61,61,48,51,53,45,54,90,58,56,90,56,58,86,60,
     73,64,,,,,,82,,64,60,,,,50,60,,44],
   [,,,,27,,28,,,28,,,,,,,43,101,,,,87,,,,,,21,,22,,,21,22,,,186,175,,,,,,,22,
     19,,,,,22,,,,,220,,268,213,,,34,33,,33,34,,,,92,116,,,77,,,,,,,22,,,,,37,,
     ,34,59,40,133,,63],
   [,,,,12,,13,,,13,,,,,,,27,62,,59,,54,,,,,,10,26,11,,,10,11,,,,42,,,,,,26,
     27,24,73,27,,,27,61,72,,,61,58,61,63,,,10,9,,9,10,,,61,64,71,62,,66,
     8,,,,,,,10,10,29,,31,,,,78,30,63,,70],
   [8,,22,,8,,9,22,,9,20,22,46,22,22,44,,44,,46,,48,7,18,6,7,6,6,18,7,
     18,6,6,7,32,34,32,30,20,,42,18,,18,19,16,42,20,,57,19,42,,44,46,
     44,42,44,46,7,7,8,7,7,7,8,52,54,40,50,52,42,52,50,8,22,9,,,,22,9,
     ,22,46,20,,,,48,22,48,,46,,8],[],[],
   [8,9,22,,9,,,,11,11,23,34,69,23,25,77,28,,,67,,,8,20,7,8,7,8,20,7,
     20,7,7,7,37,37,37,35,22,,57,19,,22,,17,,22,21,57,21,72,74,51,51,
     51,49,51,51,8,8,8,8,8,8,8,61,61,53,59,61,53,61,59,10,22,11,,,,,
     11,10,28,67,23,,,,,,75,,,21,9,7],
   [,10,24,,10,,10,,12,10,30,29,82,34,29,54,35,,,,,72,9,24,8,9,8,10,24,
     9,24,8,8,8,46,,44,42,28,,55,20,,26,22,18,59,26,22,53,20,57,,62,63,
     60,58,60,66,9,9,10,9,9,9,9,68,73,60,64,70,63,68,66,12,24,13,,,,,
     13,12,31,94,31,,,29,,37,52,,55,22,10,8],
   [,,,,27,,28,,,28,,36,79,39,37,,,69,,73,,71,,,,,,21,,22,,,19,22,170,136,
     245,,34,,55,19,,36,20,19,61,34,19,67,20,61,67,,170,,197,201,185,,,34,
     33,,33,34,82,87,61,93,87,63,,91,,22,,,,,,,,58,,,,,,87,44,,,,19,,,,,21,
     22],[,,,,12,,13,,,13,30,34,70,32,31,80,28,52,,,,78,,26,,9,,10,,11,
     26,,10,11,45,47,46,42,27,,57,27,,26,27,24,49,,,101,27,54,69,61,63,
     62,58,63,62,8,8,9,9,8,8,9,71,69,56,68,68,56,71,62,10,,10,,,,,,10,
     32,64,29,,,38,54,30,66,,76,,9,8,,,9,10],
   [10,,28,,10,,11,28,,11,,,59,27,25,49,24,65,,51,,,8,21,7,9,7,7,21,8,
     21,7,8,8,40,41,,,24,,70,23,,24,23,28,,24,,72,23,58,54,54,55,56,55,
     55,55,8,8,9,8,8,9,9,60,65,57,61,65,57,,59,9,26,10,,,,26,10,,30,
     67,26,,,,105,26,51,,49,,9,,,,8,9,,9],
   [10,10,,,8,,10,24,12,10,28,27,55,,29,,35,,,80,,,9,24,8,9,8,10,24,8,
     24,8,8,9,44,50,46,42,26,,51,20,,26,20,18,55,29,22,63,22,53,91,60,
     65,62,58,62,63,9,9,9,9,9,9,10,70,,,68,68,57,70,62,12,,13,,,,24,13,
     12,31,58,28,,,29,58,32,72,,,22,10,8,,,,9,22,10,9],
   [40,46,,,54,,,,51,63,108,122,282,114,,281,133,,,,,267,37,133,34,37,34,34,
     ,41,131,,33,,36,36,34,32,106,,267,94,,98,205,87,268,104,,346,147,319,
     ,236,244,236,230,238,242,37,37,40,37,37,37,40,276,284,224,270,278,
     232,276,268,53,142,59,,,,150,57,55,129,290,108,,,135,,122,,,300,172,47,
     32,,,37,47,170,,41,44],
   [40,53,124,,,,59,118,50,63,112,135,288,114,137,290,134,322,,,,302,37,154,
     43,37,43,36,,39,111,37,,40,36,38,36,34,108,,338,88,,104,126,86,,108,
     99,345,146,323,319,248,250,246,246,244,250,37,37,40,37,37,37,40,292,
     294,234,290,288,238,290,286,48,118,58,,,,124,57,51,136,288,112,,,,,130,,
     ,288,165,46,34,,,37,,159,46,41,,36],
   [40,,,,,,63,140,,68,110,122,228,112,127,226,122,226,,226,,226,37,130,35,
     37,35,34,167,40,,33,34,,33,36,34,33,106,,,94,,98,195,86,265,106,143,
     243,201,239,243,236,244,236,228,238,244,37,37,40,37,37,37,40,264,272,
     200,256,266,206,262,258,,176,57,,,,,,62,128,234,110,,,122,223,127,226,,
     226,179,45,32,,,37,44,,,41,,36,36],
   [,,,,,,,22,,,,,,,,,40,75,,71,,71,,,,,,,20,,18,,20,,,,147,93,,,,,,38,,39,72,
     38,,103,,67,69,,,179,127,179,167,,,,19,,19,,,,71,95,93,73,94,99,,,,,,,,
     25,25,,,,,,53,102,49,,,,,,19,,,21,25,,22,22,25,153,149,195],
   [,,,,51,,60,66,61,90,,,,,,,50,,,118,,84,,,,,,39,59,43,63,42,37,59,,,243,
     268,,,,,,37,72,41,,49,59,137,62,,,,,,347,348,297,,,50,48,49,44,66,,,40,
     ,69,44,,53,,,,,,,72,66,,,,46,,,,42,75,61,,63,54,,42,,,,119,58,60,,56,
     299,325,265],[24,23,,,,,33,35,,33,21,24,45,23,24,45,21,45,,45,,44,
     22,,18,22,18,18,34,,34,18,18,23,98,106,98,90,21,,41,21,,18,38,18,
     41,20,34,45,38,42,43,134,142,134,126,134,140,22,22,24,22,22,22,24,
     53,55,36,50,52,38,52,50,28,35,33,,,,35,33,28,22,41,20,,,21,39,21,50,
     ,,32,26,18,,,22,26,32,26,23,26,98,106,98,,40],[],[],
   [24,25,,,28,,35,20,30,35,22,,60,23,24,45,27,,,45,,47,21,19,18,19,18,
     20,19,19,18,18,16,19,94,88,94,86,21,,48,22,,21,41,20,49,22,38,43,
     41,49,43,126,120,126,118,126,120,19,19,20,17,19,17,20,54,59,50,52,
     59,50,54,57,26,34,27,,,,38,27,26,25,68,23,,,,,25,43,,43,35,22,18,,,
     17,,37,22,21,28,94,88,94,20,,21],
   [,86,,,61,,70,64,58,,,,,84,58,84,50,,,,,111,73,,47,57,47,39,65,44,61,
     42,37,,267,303,228,,,,,54,,37,,41,,48,63,83,69,,83,341,,,,,297,53,53,
     50,47,48,43,,75,55,40,77,53,41,76,51,,,,,,,71,63,,,44,46,,,,,,61,,60,
     63,79,42,,,,,59,56,73,63,291,,,,40,40],
   [24,32,,,29,,,35,31,35,22,24,48,24,23,42,24,,,44,,42,22,,23,22,23,20,
     37,23,34,,21,23,106,108,104,104,21,,46,22,,20,38,21,46,22,36,43,40,
     46,43,146,148,144,144,146,148,22,22,24,22,22,22,24,54,56,40,54,54,
     42,54,52,28,35,33,,,,,,31,26,46,22,,,29,44,26,44,,46,34,27,20,,,22,
     26,,,24,28,106,108,104,,,21,,,21,44],
   [,,,,,,,26,,,,,181,47,,67,42,68,,75,,65,,,,21,,,19,,20,,20,,,146,,93,,,99,
     43,,38,,39,63,42,,106,,,68,179,159,187,127,,,19,19,23,19,19,17,23,
     129,95,73,87,97,73,,99,,,25,,,,,,25,,,,,,53,102,49,83,,,,22,19,,,21,25,,
     ,22,25,195,127,,19,,,,,20],
   [24,,21,,28,,31,21,,31,21,,53,23,21,42,21,57,,47,,43,19,16,16,17,16,
     16,16,19,16,16,14,19,87,86,86,74,21,,47,20,,18,41,18,49,21,,43,41,
     60,45,114,114,115,102,114,114,17,17,20,15,17,15,20,53,55,38,50,53,
     40,52,50,22,38,23,,,,34,23,22,24,45,22,,,21,43,,,,60,,20,16,,,17,22,
     37,20,19,22,87,86,86,17,,18,,,17,57,21,17],
   [152,,,,,,80,88,123,,65,68,,84,80,56,56,,,68,,56,74,,56,72,56,52,77,,73,
     55,53,56,,408,323,367,65,,100,65,,53,76,53,,66,103,65,78,140,57,466,
     517,424,482,461,479,68,68,61,59,63,55,66,99,66,63,103,69,67,102,65,
     75,91,96,,,,91,82,89,92,75,,,,60,71,,,,61,96,70,57,,,,72,102,80,68,
     90,350,474,321,,69,,,,59,72,59],
   [,,,,,,,22,,,,,,42,42,64,39,67,,66,,158,21,18,18,21,18,18,18,22,18,18,
     18,22,185,98,,196,,,62,40,,36,,40,81,36,,62,,62,67,203,131,228,224,
     213,131,19,19,23,17,19,19,23,,90,68,92,88,68,84,92,24,,25,,,,,25,,48,
     ,,,,43,,45,78,,,,22,,,,20,24,,22,,24,167,99,196,19,,,,,19,,,19,16],
   [,,,,51,,60,72,67,149,,,,84,73,107,51,,,112,,,,,62,74,62,40,58,44,66,42,
     38,59,325,,220,264,,,,71,,38,63,42,,49,,,75,,141,363,410,296,,371,302,
     68,68,50,48,49,44,65,78,65,40,77,65,44,82,64,,87,,,,,69,64,,,45,46,,,
     ,45,78,76,,73,,,42,,,120,,64,59,,54,289,368,238,,44,40,,,,41,45,,45,
     67],[120,68,,,159,,66,82,,76,48,48,,84,93,43,44,,,45,,48,76,,47,74,
     47,43,91,78,95,46,45,47,373,344,237,,48,,83,67,,41,70,41,,50,67,44,
     68,106,48,422,410,318,348,,,68,68,61,61,,55,65,88,55,53,87,53,55,86,
     53,88,,120,,,,76,106,72,60,,,,,47,58,,47,,,60,84,,,,,54,66,94,49,70,
     390,,241,,53,,,,45,56,45,,,59,,72],
   [56,,182,,64,,77,192,,,148,164,362,158,162,,171,355,,366,,345,51,163,46,
     51,46,46,198,53,,45,46,54,236,248,236,224,146,,341,126,,134,,114,,144,
     169,,179,359,403,48,48,46,44,46,48,51,51,56,51,51,51,56,372,384,296,
     360,372,308,374,362,69,190,77,,,,174,,67,173,378,148,,,175,339,,342,,
     376,,63,44,,,51,63,244,61,54,60,236,248,236,187,339,134,,,126,,146,
     179,114,444,167,385,410],
   [56,,152,,64,,76,,67,75,152,174,386,158,177,360,182,362,,386,,360,51,143,
     ,51,,50,159,53,147,48,50,53,244,250,244,238,148,,388,120,,142,161,
     114,357,148,130,,161,,408,48,50,48,46,48,50,51,51,56,51,51,51,56,
     388,394,308,382,386,314,384,382,64,160,78,,,,154,75,66,180,366,152,,,,,
     175,364,,370,170,62,46,,,51,,168,62,55,63,244,250,244,161,398,142,,,
     120,,148,161,114,,130,391,403,48],
   [56,62,,,69,,75,204,69,,150,163,308,156,165,,162,299,,308,,301,51,162,46,
     51,46,46,201,55,206,45,45,55,236,246,236,226,146,,301,126,,134,181,
     115,314,146,,322,185,309,317,45,48,46,45,46,48,51,51,56,51,51,51,56,
     360,372,272,350,360,282,362,348,64,176,75,,,,,,73,168,306,150,,,162,,
     165,299,,314,,61,44,,,51,60,,,55,63,236,246,236,229,348,134,,,126,307,
     144,,115,418,175,296,321,48,48],
   [56,,140,,62,,67,142,,67,146,159,364,158,166,334,158,364,,376,,344,49,
     121,42,49,42,42,121,49,120,42,42,49,230,246,228,210,144,,380,118,,
     126,127,102,353,144,168,384,127,,360,45,46,44,42,45,46,49,49,56,49,
     49,49,56,356,374,284,338,358,302,356,338,62,142,67,,,,140,67,68,,382,
     146,,,158,,,,,382,197,58,42,,,49,58,167,58,58,58,230,246,228,127,366,
     126,,,118,349,144,127,102,,168,399,360,45,48,45],
   [56,66,176,,,,81,196,,77,146,172,362,158,167,347,182,,,388,,349,51,,46,
     51,46,46,203,,164,45,46,53,238,244,238,224,144,,344,126,,134,181,114,
     378,146,213,382,,363,,48,48,46,44,46,48,51,51,56,51,51,51,56,372,
     384,296,360,372,308,374,360,64,,81,,,,178,77,,174,360,146,,,171,351,,,,
     366,201,61,44,,,51,60,,62,,62,238,244,238,183,388,134,,,126,344,146,
     237,114,465,,,,45,48,48,45]],
 [,[],[],[],[,6],[,,16],[,,,5],[,,16,,,16],[,,,5,7,,5],
   [,7,,5,,,5,,5],[24],[,22,,,23,,,55,20,19],[,,64,,,,,104],
   [24,18,40,15,18,44,15,44,15,15,24,22,46],
   [,29,,,29,,,55,23,,28,24,46],[,40,78,33,42,88,33,68,45,39,46,,62],
   [,,52,27,29,,27,52,,23,,24,,19,23,37],
   [148,86,68,39,62,88,39,70,41,39,,,42,43,37,53],
   [,23,,27,25,58,27,,,23,,29,,,26,,26,50],
   [,54,104,,60,,,64,,,52,58,56,,,42,46,56],
   [,,,,115,,,,,,,,42,46,46,62,,42,79,56],[],
   [8,,,,,,,,,9,23,,,23,,57,26,65,28,,61],
   [,,,,,,,,,,,,,49,47,91,50,69,54,99],
   [,6,,,6,,,,7,7,,22,,18,28,38,25,54,23,51,88],
   [8,6,16,8,6,16,8,16,7,7,24,21,58,18,,,,44,22,58,66,,8,20,6],
   [,8,18,11,8,19,11,19,9,9,27,25,47,,31,,27,41,27,,53,,9,21,7],
   [8,,,,,,,30,9,,23,,,23,30,45,26,47,29,,53,,7,,,8,9],
   [,,,,,,,21,,,,,,53,,107,58,101,60,,,,,17,,20,21],
   [,6,,,6,,,,7,7,,22,,18,28,38,25,54,23,51,88,,,,6,6,7],
   [,,21,,,21,,,,,49,63,,53,,75,51,77,,,98,,,17,,20,21,,17],
   [,6,,8,6,30,8,,,7,26,21,42,18,,50,23,42,22,,44,,,,6,6,7,8,,6],
   [10,8,19,11,8,18,11,18,9,9,26,25,51,27,29,51,28,45,27,52,55,,9,21,7,
     ,7,9,21,7,21,7],[10,6,30,8,6,,8,30,7,,,,62,18,25,36,24,56,24,44,
     ,,8,,6,6,7,,,6,,6,7],
   [40,,,,,,,,43,43,111,,,105,125,,129,269,139,289,279,,37,,,38,39,37,,,205,
     37,40,36],[40,30,80,25,30,80,25,80,25,25,111,,297,75,,,107,,,297,
     263,,37,91,30,30,,37,91,30,91,30,,30,34],
   [40,,,,,,,150,43,37,111,,,99,130,213,130,213,137,229,229,,37,,,36,40,37,,,
     ,38,39,38,34,34],
   [40,30,80,25,30,80,25,80,25,25,111,116,265,75,,,,,129,295,295,,35,85,
     30,30,35,35,85,30,85,30,35,30,34,25,34],
   [24,,,,,,,42,21,,21,,,21,25,41,25,57,,45,,,22,,,22,23,22,,,45,21,24,22,
     102,96,102,96],[,,,,,,,,9,9,,,,19,23,43,23,43,,,,,,,,12,17,,,,,14,17,
     14,,35,,35],[,,,,,,,80,41,,,,,41,43,55,,39,50,55,43,,,65,,,46,,73,,
     73,41,52,,,233,,233],
   [24,16,36,11,16,36,11,36,9,9,24,20,40,15,,,19,31,21,73,40,,21,45,14,
     10,,21,45,14,45,12,19,12,89,35,79,35,21,7,37],
   [,45,74,43,49,78,43,86,,41,,47,55,,,,43,51,,44,56,,50,80,42,,,46,78,
     42,70,54,50,39,319,,237,233,,,52],
   [24,,,,,,,40,21,21,21,,,21,25,41,25,41,28,41,41,,22,,,22,23,22,,,45,21,
     25,21,102,96,102,96,18,,,21],
   [,,,,,,,,9,9,,,,19,23,43,23,43,,,,,,,,12,17,,,,,14,17,14,,35,,35,,7,,7],
   [24,16,36,11,16,36,11,36,9,9,21,20,77,15,19,31,,,21,40,77,,19,39,14,
     10,13,19,39,14,39,12,13,12,83,35,85,35,21,7,,7,37,21,7],
   [,,86,,73,78,,74,41,,,,43,41,43,55,,,,56,44,,70,70,63,76,46,64,78,63,
     80,39,50,54,286,241,237,,,,42,37,43,42],
   [24,23,40,24,23,40,24,,,21,21,29,41,21,25,57,25,41,,,,,22,,22,22,23,
     22,45,22,,,25,21,102,96,102,96,18,,,21,,18,,21,42],
   [,,,11,17,,11,,,9,,,,19,23,43,23,43,,,,,,,15,11,15,21,,15,,,15,13,125,
     35,123,35,,7,,7,,,7,7],
   [152,47,80,43,51,76,43,,,41,48,55,56,,,39,43,51,,,57,,52,73,46,76,,48,
     73,46,65,,52,41,314,241,,237,42,,43,,42,42,,37,52],
   [,17,,11,,,11,,9,,,,,19,23,39,23,39,39,,,,21,,15,11,15,,,15,,13,15,,,35,
     83,35,,7,,7,,,7,7,,,7],
   [,,66,,,74,,76,41,,,,44,41,43,55,,39,50,57,,,,85,,,47,66,77,,73,41,56,,
     320,,230,235,,,33,37,52,54,,,42,54,,43],
   [120,45,,43,49,74,43,66,,41,61,47,,,,39,43,51,,44,56,,51,78,42,,,47,80,
     42,78,54,49,39,286,233,260,245,54,,52,,33,54,,37,43,,,42,,52],
   [56,,,,,,,192,47,53,153,,,135,163,333,164,337,,379,365,,51,,,50,53,51,,,,
     49,54,50,235,217,235,217,138,,,103,,138,,103,,138,101,339,139,374,377],
   [56,42,112,35,42,112,35,112,35,35,153,145,,105,,,145,277,158,337,339,,
     51,125,42,42,,51,125,42,125,42,53,42,229,175,223,175,132,49,299,49,,
     132,49,49,,132,49,299,49,301,297,44],
   [56,,,,,,,,53,53,153,,,135,162,275,165,275,175,301,301,,51,,,50,53,51,,,
     197,48,53,49,235,217,235,211,138,,,103,337,138,,97,,138,101,294,139,
     301,296,44,44],[56,42,112,35,42,112,35,112,35,35,153,,335,105,145,,,
     ,174,335,355,,49,119,42,42,49,49,119,42,119,42,49,42,223,175,229,
     175,132,49,297,49,297,132,49,49,,132,49,311,49,311,,44,35,44],
   [56,52,,,52,156,,,,53,153,180,339,129,164,321,,341,,,,,51,,50,48,54,51,,
     50,,,53,50,235,211,235,217,138,160,378,93,335,138,160,99,333,138,,,
     139,348,361,44,44,44,44],
   [56,42,112,35,42,112,35,112,35,35,147,,287,105,151,,145,243,166,287,289,
     ,51,125,42,42,,51,125,42,125,42,,42,223,175,229,175,126,49,255,49,
     255,126,49,49,258,126,49,258,49,258,255,44,35,44,35,44],
   [8,,,,,,,20,9,9,23,,,23,28,45,25,45,27,,51,,7,,,8,9,7,,,,8,9,8,37,37,
     37,35,22,,,19,45,22,,17,62,22,19,47,19,62,47,51,51,51,49,51,51],
   [8,11,16,14,11,16,14,16,11,11,24,31,54,24,,,,54,31,54,56,,8,19,10,8,,
     8,19,10,19,9,9,9,40,40,40,40,24,22,,16,,24,22,16,66,24,19,65,19,
     65,65,56,56,56,56,56,56,8],
   [8,,,,,,,20,9,9,23,,,23,28,45,25,45,27,,51,,7,,,8,9,7,,,,8,9,8,37,37,
     37,35,22,,,19,45,22,,17,62,22,19,47,19,62,47,51,51,51,49,51,51,7,8 
    ],[8,9,16,11,9,16,11,16,9,9,23,27,53,23,28,49,,,26,57,51,,7,17,9,
     8,9,7,17,9,17,8,9,8,37,37,37,35,22,17,60,15,,22,17,13,,22,15,60,
     15,60,50,51,51,51,49,51,51,7,8,7],
   [8,9,22,11,9,22,11,,,9,23,27,,23,26,53,25,51,,,53,,7,,9,8,9,7,31,9,,
     ,9,8,37,37,37,35,22,19,48,17,49,22,19,15,48,22,,,17,48,59,51,51,
     51,49,51,51,7,8,7,7],
   [8,11,16,14,11,16,14,16,11,11,24,31,46,24,28,46,28,46,31,48,48,,8,
     19,10,8,9,8,19,10,19,9,,9,40,40,40,40,24,22,48,16,48,24,22,16,48,
     24,19,48,19,48,48,56,56,56,56,56,56,8,8,8,8,8],
   [8,9,22,11,9,22,11,20,9,,23,,53,23,,51,25,47,28,53,,,7,31,9,8,9,7,,
     9,31,8,9,,37,37,37,35,22,19,59,17,47,22,19,15,59,22,17,48,,,48,51,
     51,51,49,51,51,7,8,7,7,7,8],
   [72,,,,,,,94,,55,57,,,54,62,72,64,64,67,82,78,,61,,,58,61,57,,,105,56,61,
     ,279,249,263,249,51,,,50,81,51,,51,73,55,52,79,,75,97,369,339,353,
     339,369,331,57,64,57,59,59,60,59],
   [72,52,90,41,52,92,41,92,43,43,66,58,82,39,,,53,69,59,76,84,,61,103,
     48,50,,57,97,48,97,46,61,50,273,207,251,207,55,47,75,39,,51,47,41,
     77,51,45,69,43,77,69,351,285,335,285,345,277,57,64,57,59,59,60,59,
     54],[64,,,,,,,68,45,45,57,,,51,55,71,55,67,67,77,,,47,,,46,47,43,,,
     80,44,45,44,229,211,201,211,46,,,43,79,38,,43,75,46,,79,43,79,75,
     299,281,271,281,295,263,43,48,43,45,45,44,45,48,48],
   [72,48,98,41,52,88,41,88,43,43,57,58,76,45,53,67,,,60,82,78,,59,95,
     48,50,57,55,105,48,99,50,57,46,267,207,257,207,51,47,69,41,79,51,
     47,39,,55,43,75,45,71,75,351,285,329,285,351,277,55,64,55,57,57,60,
     57,48,45,48],[72,62,,68,62,,68,,,,66,68,82,51,64,66,62,70,,,,,61,
     105,56,58,57,57,103,56,,,61,56,279,249,263,243,55,94,79,51,75,51,94,
     50,79,51,,,52,101,73,369,339,353,333,369,331,57,64,57,59,59,60,59,
     54,48,48,54],[64,40,64,31,36,56,31,64,33,33,57,49,73,39,43,59,43,
     61,66,73,79,,47,75,36,38,47,43,67,36,75,38,,38,217,169,195,169,46,
     33,77,31,79,38,33,31,79,46,31,77,35,81,81,275,227,253,227,277,215,
     43,48,43,45,45,44,45,48,39,38,39,48],
   [72,58,84,59,62,84,59,,55,,57,,76,54,62,72,66,64,69,,,,61,139,56,56,
     65,57,,56,139,56,61,,279,243,263,249,51,,73,50,82,51,,51,74,55,52,97,
     ,,80,369,333,353,339,369,331,57,64,57,59,59,60,59,48,54,48,48,54,48 
    ],[72,52,96,41,52,98,41,90,43,43,66,,88,39,59,59,53,61,71,76,88,,
     59,99,48,50,53,55,97,48,105,46,57,50,273,207,251,207,55,47,79,39,
     73,51,47,41,75,51,45,69,43,79,,345,285,335,285,351,277,55,64,55,57,
     57,60,57,54,39,48,45,48,39,54],
   [,,,,,,,,,,,,,33,31,67,,,41,,,,,,,12,13,,,,,,13,,,51,,45,,,,33,,,,27,,,,65,,,
     65,,69,,63,,69,,11,,9,,11,11,,85,,71,93,75,,79],
   [,,,,,,,,,,,,,37,41,81,41,81,,,,,,,,14,15,,,,,,,18,,56,,56,,,,13,,,,13,,,,,,,,
     ,76,,76,,70,,16,,14,18,16,18,,75,,79,83,66,,75],
   [,,,,,,,,,,,,,38,,116,40,100,46,,,,,,,14,15,,,,,,15,,,58,,56,,,,38,88,,,36,,
     37,,,,,,,78,,76,93,78,,14,,13,,14,,,94,,92,,82,106,86],
   [,,,,,,,,,,,39,134,33,37,97,31,97,51,,,,10,28,9,12,10,10,28,9,28,9,10,
     9,67,51,,45,34,,102,33,89,,,27,81,36,,105,,103,,85,69,,63,81,69,10,
     11,10,10,10,11,10,101,85,75,79,97,59,93,79,12,,13],
   [,,,,,,,,,,32,33,60,37,,59,30,56,35,69,60,,,,,14,15,,,,,18,15,,134,56,
     156,56,29,10,56,13,59,29,10,10,56,29,10,65,10,56,59,142,76,142,76,,
     70,,16,,14,18,16,18,76,75,58,70,103,52,76,79,,13],
   [,,,,,,,,,,,46,,38,40,112,,,,,,,11,29,10,14,13,11,29,10,29,10,10,10,,58,,
     56,,,88,38,,37,,36,104,,,92,,109,,108,78,90,76,,78,11,14,11,11,11,11,
     11,112,94,88,92,,82,,86,13,,14],
   [,,,,,,,,,,,33,53,26,30,56,,67,35,60,61,,,,,14,,30,,,,,15,18,,56,,56,29,
     10,59,10,56,29,10,13,65,29,10,56,10,59,56,,76,170,76,126,70,22,16,
     22,14,,16,18,,70,58,79,76,52,85,70,,13,,,13],
   [,,,,,,,,,,,,90,38,47,72,40,70,48,100,100,,,,,14,15,,,,,,15,,76,58,,56,37,
     ,78,38,70,,,36,70,43,,,,,70,96,78,96,76,,78,10,11,10,13,10,11,10,,
     86,,84,110,66,110,78,,,13,13,,14],
   [,,,,,,,,,,,,,38,,118,44,158,,,,,11,29,10,14,10,11,29,10,29,10,13,10,70,
     58,64,56,,,,38,101,43,,36,,43,,,,92,104,84,78,,76,,78,11,11,11,11,11,
     14,11,100,94,,92,124,82,100,86,13,,14,,,13,,14],
   [,,,,,,,,23,,,,,23,27,43,,,26,,,,,,,,29,,,,49,25,34,,,107,,107,,,,23,46,,,,,,
     ,39,,,46,,145,,145,,145,,31,,28,26,28,27,,61,,59,66,63,64,61,31,,,39,
     30,41,41,44,40],[,,,,,,,76,,,,,,56,56,78,,,,88,,,,,,58,55,,,,,50,47,64,
     ,,,281,,,,44,115,,,77,,59,44,100,,,,,339,,351,345,289,,54,,57,,48,53,,
     56,,,58,42,,56,,53,,,60],
   [24,,,,,,,,,,24,28,74,24,28,74,29,68,29,68,,,23,,,24,27,23,49,,,25,27,
     25,111,111,111,111,24,23,64,24,64,24,23,24,64,24,23,64,23,64,64,
     153,153,153,153,153,147,23,24,23,23,23,24,23,66,66,45,66,66,39,66,
     66,41,32,,,,,,,,28,52],
   [,29,,27,,55,27,52,,23,28,25,56,23,28,63,27,47,24,83,56,,27,58,25,,
     28,27,51,25,51,23,,23,133,107,,111,22,21,47,23,59,22,21,19,47,22,
     21,59,21,47,59,171,145,165,149,168,151,27,31,27,26,27,28,26,62,61,
     41,53,65,35,62,61,38,30,42,31,,,41,40,43,23,46],
   [,,,,,104,,106,,,46,52,,56,82,46,52,90,67,45,88,,61,,,66,52,53,,,,49,,
     50,279,,,,42,43,80,44,46,42,43,40,82,48,41,41,41,80,41,347,339,303,
     341,,291,51,56,51,51,53,48,,86,56,55,88,55,49,86,49,,60,,,53,,,100,,
     46,56],[],[],[],
   [,50,90,37,,74,37,68,45,41,52,,82,,63,37,49,83,92,52,84,,57,115,46,,
     53,51,85,46,79,42,,38,281,229,227,273,38,41,61,35,37,40,41,33,61,
     46,37,39,37,63,37,347,303,293,305,341,283,51,,51,51,57,48,51,72,45,
     53,63,58,45,74,45,71,60,106,127,71,122,87,76,108,39,58,,,44],
   [,,,,133,64,,,,,,,,56,56,76,,,77,,,,51,,90,66,51,45,76,90,117,47,47,,301,
     263,235,,,76,,44,96,47,76,77,,,,109,65,,102,353,339,301,339,347,291,
     45,56,45,49,53,48,,76,49,43,78,55,42,76,49,,69,,,60,,,,,,42,,46,56,,,
     ,58],[,133,,,,,,64,,,,52,114,56,,39,49,88,67,45,,,,,90,58,51,47,,90,
     118,48,,42,301,265,,281,42,43,82,44,41,42,43,40,80,48,41,41,41,80,
     46,353,337,301,345,353,289,47,54,47,49,49,48,49,84,49,55,82,55,49,
     82,56,79,60,,,61,,,,,46,56,,,42,,,,44,56],
   [,,,,,,,,,11,,,,25,29,57,29,57,,,,,,,,10,14,,,,,14,14,12,,42,,42,,,,9,,,,9,,
     ,,,9,,,,58,,58,108,56,,19,,15,19,19,17,,55,,57,77,42,,55,,,,,11,,11,,,,
     ,26,24,48,,,,46,,48],
   [,,,,,,,,,11,,,,28,28,56,30,76,33,70,94,,,,,10,11,,,,,,11,10,,44,,42,,,,
     26,52,,,24,78,27,,50,25,68,52,,60,,58,64,60,,10,,9,,10,9,,70,,64,73,
     54,,66,9,,,11,,12,,11,12,28,,32,31,,,,,60,82,59],
   [8,,30,,8,,,,,9,23,29,67,23,26,75,,79,,69,,,8,22,7,8,7,8,22,7,22,7,
     7,7,37,37,37,35,22,,58,21,,22,,19,,22,,73,21,74,,51,51,51,49,51,51,
     8,8,8,8,8,8,8,61,61,53,59,61,53,61,59,10,30,11,,,,,11,,28,69,23,,,,
     ,,81,,,,9],[,,,,20,,,,,11,26,25,48,25,,43,24,44,26,,48,,,,16,10,15,
     22,,16,,,15,12,116,42,,42,23,8,44,9,43,23,8,8,44,23,8,45,8,44,47,
     134,58,114,58,129,56,20,19,20,14,,19,16,60,55,46,54,,40,60,57,,11,,,,
     ,11,,,24,48,,,,,,,49,48,,9],
   [,,26,,10,,,,,11,,32,73,28,30,78,28,54,38,,61,,9,23,8,10,9,9,23,8,23,
     8,8,8,51,44,45,42,28,,56,26,64,,,24,54,26,,64,25,56,,67,60,61,58,
     62,60,9,10,9,9,9,9,9,77,70,51,68,72,50,71,66,11,30,12,9,,,,12,11,
     30,55,,28,,,,,90,55,80,,10],
   [8,6,16,5,6,16,5,16,5,5,21,20,43,15,19,41,19,,,43,43,,7,17,6,6,7,
     7,17,6,17,6,7,6,31,25,31,25,18,7,37,7,37,18,7,7,37,18,7,37,7,
     37,37,41,35,41,35,41,35,7,8,7,7,7,8,7,49,43,39,43,49,33,49,43,9,
     10,10,9,10,10,10,10,10,19,43,21,19,43,,,,41,43,43,8,8,7,8,8],
   [],[,,,,,,,,,11,,25,67,20,24,44,,49,26,48,,,,,,10,14,,,,,14,14,12,174,
     42,132,42,23,8,45,8,44,23,8,9,47,23,8,44,8,43,44,132,58,,58,134,
     56,,19,,15,19,19,17,75,54,46,57,60,40,,54,,11,,,11,,,,,29,,,29,,,,,59,,
     ,9,,,9,,8],[,,,,,26,,,,11,,40,59,28,28,72,29,54,,,,,,31,,10,11,9,,,,
     ,11,10,47,44,46,42,27,,52,26,74,26,,24,54,,,62,25,56,60,63,60,62,
     58,64,60,8,9,8,9,8,9,8,73,66,62,68,68,60,73,62,9,,11,11,30,12,,,
     12,28,76,32,30,59,,,,60,,64,,9,9,,10,8],
   [10,,,,10,,,26,,11,,,80,28,29,54,28,96,35,55,,,9,23,8,10,8,9,23,8,23,
     8,9,8,45,44,,42,26,,78,26,50,28,,24,,28,,52,25,66,50,61,60,,58,64,
     60,9,9,9,9,9,10,9,67,70,61,64,74,54,,66,11,,12,9,,11,30,12,,30,
     64,29,28,64,,,,60,,,,10,,,9,8,,,10],
   [10,7,20,6,8,20,6,20,6,7,26,28,48,,23,,23,82,25,56,48,,8,21,7,7,8,
     9,21,7,21,7,8,8,38,38,38,39,22,8,41,8,45,22,8,8,41,22,8,45,9,
     41,45,50,49,50,48,50,47,8,9,8,8,8,9,9,60,,54,,56,51,60,48,11,12,
     12,11,12,12,12,12,12,23,60,26,23,50,,,,46,60,50,9,9,8,9,9,,,9,9,9 
    ],[40,42,184,,44,168,,,37,43,111,130,291,105,,273,129,,136,,279,,37,
     235,39,38,41,37,,39,235,,39,,34,34,37,31,102,,273,89,,102,,83,,102,,
     273,87,308,,235,229,235,223,235,223,37,40,37,37,37,40,37,279,273,229,
     267,279,217,279,273,77,118,76,,,,142,76,70,129,287,111,,,,,,289,287,281,
     ,47,37,,,31,,119,,46,38],
   [40,30,80,25,30,80,25,80,25,25,111,108,263,75,107,223,107,249,,,,,37,
     91,30,30,41,37,91,30,91,30,,30,34,25,34,25,96,35,241,35,241,96,35,
     35,,96,35,233,35,237,231,217,175,217,175,211,175,37,40,37,37,37,40,
     37,249,207,211,207,249,169,243,207,51,56,58,51,56,58,56,58,58,107,
     263,111,,297,,,,,297,263,42,44,37,42,44,25,,42,44,44,,34],
   [40,48,,52,,150,52,134,,43,111,131,239,99,,219,129,,135,,,,37,179,40,36,
     40,37,247,40,,36,43,,34,31,37,34,102,,229,79,,102,,85,233,102,83,,
     123,236,278,235,223,235,229,235,229,37,40,37,37,37,40,37,263,251,201,
     257,263,195,263,251,,160,76,55,,70,,,,126,229,111,127,227,,,,233,235,
     231,113,47,37,,45,31,,,,45,38,34,34],
   [,,,,,,,22,,,,,,54,70,96,54,84,58,130,,,,,,22,23,,,,,,23,,,98,,96,,,,50,84,,
     ,48,83,48,,101,,77,83,,134,,132,227,134,,22,,21,,22,,,112,,118,,82,
     112,110,,,,29,,30,,29,30,,,,61,,,,,110,,,,,23,,24,18,,,23,24,22,184,98,
     242],[,,,,,,,,42,55,,,,,52,118,52,,90,,,,,,,45,51,,,,,45,47,74,,264,,
     320,,,,40,109,,,40,,,40,,43,,107,,,,,449,372,,66,,62,60,62,89,,,,,,38,,
     71,,,,67,61,114,61,,,,,48,43,74,,,,74,45,74,42,,77,47,56,42,,47,,,,339,
     ,280],[24,,,24,,42,24,,,21,24,24,48,21,24,57,22,44,23,57,48,,22,,,
     22,23,22,45,,61,21,23,21,102,96,102,96,21,20,44,21,53,21,20,18,44,
     21,20,53,20,44,53,138,132,138,132,138,126,22,24,22,22,22,24,22,56,
     55,40,50,55,34,56,55,36,29,37,,,,29,,37,22,42,21,,,,,,67,42,,23,26,
     22,,,18,,23,28,27,22,102,96,102,,42],
   [,,,,,25,,25,,,,,,54,54,96,70,86,,94,130,,23,21,20,22,21,23,21,20,21,
     20,18,20,,98,224,96,,,76,50,,48,,48,,48,,84,,83,85,,134,,132,260,134,
     21,22,21,19,21,19,21,117,112,82,112,110,84,,106,29,,30,,,,,30,29,61,,,
     ,,,,,122,,,,24,,,,18,,,24,23,22,,98,,22],[],
   [24,18,16,15,18,16,15,16,15,15,21,,51,15,19,,19,,21,43,51,,19,17,16,
     14,15,19,17,16,17,16,15,16,87,65,87,65,18,17,41,15,37,18,17,15,41,
     18,17,37,17,41,37,113,91,113,91,113,91,17,16,17,15,17,16,17,45,43,
     43,39,49,37,45,43,25,26,26,25,26,26,26,26,26,19,51,21,19,43,,,,43,
     51,43,20,20,19,20,20,13,,20,20,20,24,87,65,87,18,,18,18],[],
   [24,23,,,23,40,,40,21,21,21,24,45,18,22,36,24,45,23,42,45,,22,,22,22,
     24,22,61,22,45,,23,21,102,96,102,96,21,20,45,18,38,21,20,21,45,21,
     20,38,20,45,38,138,132,138,132,138,126,22,24,22,22,22,24,22,51,46,
     40,51,52,34,51,46,,29,37,36,29,37,,,,25,43,21,25,,,,,43,41,41,23,27,
     22,23,26,18,,,,28,22,102,96,102,,42,21,,,18],
   [,,,,,22,,,,,,,130,54,53,98,53,80,58,,,,,,,22,23,,22,,22,,23,,,98,,96,,,
     113,50,85,48,,48,76,,,83,,,84,266,134,,132,,134,20,19,20,21,20,19,20,
     ,114,87,108,,86,,106,,,29,29,,30,,,30,,,,60,,,,,118,,,,23,23,,24,18,,,,
     24,22,246,98,,21,,,22,,18],
   [24,18,16,15,18,16,15,16,15,15,21,29,47,15,19,,19,,29,47,47,,19,17,
     16,14,15,19,17,16,17,16,15,16,87,65,87,65,18,17,41,15,41,18,17,15,
     41,18,17,41,17,41,41,113,91,113,91,113,91,17,16,17,15,17,16,17,49,
     43,39,43,49,33,49,43,25,26,26,25,26,26,26,26,26,19,43,21,19,51,,,,,
     43,51,20,20,19,20,20,13,,20,20,20,,87,65,87,18,,18,18,,13,,18,18],
   [152,,,47,,,47,,55,42,48,58,84,,,40,42,90,90,58,86,,72,,,45,51,67,,,,46,
     51,41,,266,258,,42,42,73,40,39,41,42,35,73,46,40,42,39,75,39,520,
     334,,400,462,378,65,66,65,62,89,62,60,82,58,65,78,,60,84,59,,61,,,88,
     ,61,,114,43,74,,,45,,,,,74,45,48,,91,49,97,42,,48,91,55,54,336,292,
     254,,,,,,42,,42],[,,,,,22,,22,,,,,,54,53,96,53,78,,,87,,23,21,20,22,
     18,23,21,20,21,20,21,20,222,98,,96,,,77,50,83,51,,48,113,51,,85,,76,
     85,258,134,296,132,,134,21,19,21,19,21,22,21,,112,93,118,120,82,109,
     110,29,,30,,,29,,30,,60,,,,,,,,108,,,,24,,,23,18,,,24,,22,222,98,,22,,,
     21,,18,,,22,18],[,,,,49,97,,115,42,,,,,64,52,,52,,,131,,,,,42,45,59,
     49,71,42,107,43,55,59,418,,256,295,,51,,40,151,63,51,40,,83,,99,45,,
     155,,329,322,,387,338,48,65,48,49,50,61,65,75,56,41,73,62,38,75,63,,,
     ,,61,216,61,74,,,45,48,43,70,,,,70,,72,48,,117,47,82,42,,47,84,,124,
     396,291,260,,38,42,,,,,42,,65,106],
   [120,58,,77,112,,77,98,,53,61,,99,64,,49,52,,122,55,95,,67,,58,52,58,67,
     ,58,102,52,58,52,380,412,295,,54,55,89,47,49,51,55,44,85,62,48,49,
     52,85,54,452,484,385,494,,,63,65,63,59,61,61,63,97,57,62,91,63,62,
     93,71,97,81,,,,,81,106,116,55,71,,,58,,,,58,73,,60,74,,73,,,,60,75,71,
     77,361,,293,,71,,,,,,54,,,60,,62],
   [56,52,162,62,52,188,62,188,,,153,167,355,135,163,,165,327,,359,353,,51,,
     50,50,53,51,,50,,50,54,49,235,217,235,217,138,,339,103,,138,,103,,138,
     101,,101,337,350,44,44,47,41,47,41,51,56,51,51,51,56,51,369,351,299,
     351,369,275,369,345,81,146,90,,,,134,,84,167,351,153,,,,,,355,369,369,
     132,63,51,,,41,,,63,61,50,235,217,235,220,401,138,,,113,,138,220,113,
     401,206,463,482],[56,42,112,35,42,112,35,112,35,35,153,146,353,105,
     145,281,149,305,164,353,333,,51,125,42,42,,51,125,42,125,42,55,42,
     229,175,223,175,132,49,297,49,301,132,49,49,299,132,49,,49,,299,44,
     35,44,35,41,35,51,56,51,51,51,56,51,339,285,281,285,339,227,333,285,
     69,76,78,69,76,78,76,78,78,145,331,153,145,,,,,287,337,339,58,60,51,
     58,60,35,,58,60,60,47,229,175,223,134,334,132,134,,91,,132,134,91,,
     134,331,,44],[56,55,,53,58,,53,184,47,,153,169,303,135,164,275,162,
     275,174,303,299,,51,197,53,50,54,51,293,53,,48,55,49,235,217,235,211,
     138,160,298,103,310,138,160,97,294,138,,300,101,294,297,44,41,47,44,
     47,41,51,56,51,51,51,56,51,353,335,271,329,353,253,353,335,,,96,,178,
     84,,,108,162,301,153,163,301,,,,293,301,301,,63,51,114,,41,,,,64,50,
     235,217,235,272,332,138,210,,113,,138,,113,350,,325,384,44,44],
   [56,42,112,35,42,112,35,112,35,35,153,153,339,105,149,321,145,281,,341,
     351,,49,119,42,42,49,49,119,42,119,42,49,42,223,175,229,175,132,49,
     303,49,299,132,49,49,297,132,49,297,49,,311,44,35,41,35,44,35,49,56,
     49,49,49,56,49,339,285,281,285,333,227,339,285,63,76,76,63,76,76,76,
     76,76,,355,153,145,335,,,,,335,355,58,58,49,58,58,35,,58,58,58,48,
     223,175,229,132,353,132,132,,91,,132,132,91,,132,381,509,44,35,44],
   [56,,158,62,,,62,182,,47,153,179,341,129,161,319,167,,176,373,349,,51,,,
     48,53,51,241,,187,48,55,48,235,211,235,217,138,105,344,93,333,138,
     105,99,380,138,139,339,,337,,44,41,47,41,47,44,51,56,51,51,51,56,51,
     369,345,295,351,369,277,369,351,73,,,,126,,126,93,,161,343,153,163,347,,
     ,,361,,349,134,64,51,180,61,41,,,63,,50,235,211,235,225,,138,206,,113,
     ,138,293,113,,,,440,44,44,44,44],
   [8,8,20,,8,,,,9,9,23,27,61,23,25,61,28,59,,61,,,8,20,7,8,7,8,20,7,
     20,7,7,7,37,37,37,35,22,,53,19,,22,,17,,22,19,53,19,68,68,51,51,
     51,49,51,51,8,8,8,8,8,8,8,57,57,49,55,57,49,57,55,10,22,11,,,,,
     11,10,28,61,23,,,,,,61,,,20,9,7,,,7,,20,9,8,8,37,37,37,21,71,22,,,
     17,,22,21,17,71,20,107,69,51,51,51,49,51]],
 [,[],[],[],[],[,,21],[],[],[,,,,10,,11],[,,,,,,11,,11],
   [22],[,,,,31,60,,,36,38],[,,40,,66,,63],[24,,34,,,,,,35,,24,28,36],
   [,,35,,35,,40,,37,,25,26,34],[,,54,,60,117,49,,,79,36,37,45],
   [,,,,35,,40,,,40,,24,,28,26,37],[,,75,,56,,49,,66,,,,33,36,37,48],
   [,,31,,30,54,34,,,35,24,25,33,,27,,25,36],
   [,,50,,66,,,,,,33,34,42,,,33,34,45],
   [,,49,,70,,69,,,,,,36,36,40,48,,36,40,48],
   [148,,52,,66,109,,,76,69,33,37,45,,,36,37,45,,33,48],
   [6,,,,8,22,9,,,9,20,,,22,,,,,,,58,82],
   [,,,,,22,,,,,,,,37,38,59,,,35,62,,57],[],
   [8,,22,,10,22,11,,10,11,23,28,51,23,,,,57,27,59,,59,7,21],
   [10,,24,,12,,13,,12,13,31,31,44,,30,,36,42,,74,47,74,8,22],
   [8,,32,,,,,,9,,23,26,37,23,28,37,27,35,28,37,37,35,7,,,8,9],[],
   [10,,34,,8,,,,10,10,,29,54,32,33,52,31,52,29,54,60,62,8,,,9,10],
   [,,23,,,22,,,,,38,39,59,,59,51,40,64,,,61,,,19,,21,22],
   [,,,,9,26,10,,,10,28,29,43,27,,,27,39,24,,41,69,,,,8,9,8,,9],
   [10,,24,,12,24,13,,12,13,28,31,54,34,31,60,31,52,33,54,56,54,8,22,,,
     9,9,,10,22,9],[10,,34,,10,,10,,10,,,,76,32,33,42,32,,27,44,,42,8,,,
     9,10,,,9,,9,10],
   [34,,,,,196,59,,57,63,108,,,114,131,,,,131,243,248,263,32,,,37,46,37,,,
     185,42,44,45],[38,,110,,49,118,59,,51,,112,,284,114,,,139,,151,284,
     264,258,34,136,,37,,37,,46,,41,,48,36],
   [34,,,,,,,,57,59,110,123,162,112,124,173,121,174,120,167,178,174,32,172,,
     37,44,37,,,220,40,47,46,36,36],
   [30,,,,44,106,49,,52,49,106,,,114,,250,,,119,212,244,,30,,,35,42,35,,42,
     185,44,42,42,33,36,33],
   [18,,,,28,37,33,,30,,20,,,23,22,33,,,21,30,,32,18,,,22,26,22,,26,34,24,
     26,26,98,106,98,90],[],
   [,,,,66,73,60,,64,,,,,40,40,48,,,41,48,38,50,,50,,,44,42,,60,58,41,58,,,
     268,182],[22,,32,,26,38,27,,26,27,23,25,33,22,,,25,35,,66,35,,18,35,
     ,17,,21,,22,37,21,27,22,94,88,94,86,21,,37],
   [,,57,,65,104,58,,,72,40,43,51,,,,43,52,,39,52,41,,64,,,,41,,57,60,70,
     62,47,326,,187,289,37,,49],
   [22,,31,,,,,,31,39,22,26,34,22,26,34,26,34,26,34,34,34,20,34,,22,26,22,
     ,,34,24,,29,106,108,104,104,21,,36,21,39],
   [,,,,,,,,25,25,,,,,52,96,54,85,56,,,,19,,,21,25,,,,,22,25,22,205,,,93,,,,
     20],[18,,,,22,38,23,,22,23,22,,,23,22,33,,,21,30,72,32,16,,,17,22,
     19,,20,37,19,22,20,87,86,86,74,18,,,17,37,21,17],
   [,,,,64,,57,,64,,,,,38,40,49,,,41,48,39,50,,49,,,50,40,,56,61,40,65,73,,
     ,185,,,,36,36,52,39],
   [18,,28,,28,41,33,,,33,20,22,30,22,,74,22,32,,,35,,18,32,,22,26,22,,26,,
     ,26,26,100,102,100,90,18,,36,21,,21,,18,36],
   [,,,,24,,25,,,25,,,,61,50,,50,82,,,,82,,,,20,24,21,,22,,,24,22,181,99,183,
     ,,,,19,,,19,16],[,,58,,66,73,60,,,74,40,41,49,,,36,41,51,,,50,38,,
     58,,69,,42,,60,48,,53,50,260,,185,246,37,,45,,37,36,,37,48],
   [,,,,,,25,,25,,,57,,,52,96,54,,,,,85,19,,,21,25,,,22,,22,25,,,136,155,93,,,
     ,20,,,19,17,,,19],[,,51,,65,105,58,,67,,,,,40,43,51,,40,43,51,,53,,,,
     ,46,42,,59,62,43,58,,280,,184,,,,40,37,49,36,,,37,38,,52],
   [92,,58,,64,,57,,,71,40,41,49,,,,41,51,,36,51,,81,61,,,,40,,56,57,67,63,
     46,249,301,185,261,37,,48,,40,39,,37,45,,,36,,49],
   [46,,,,65,174,,,69,81,148,,,158,175,301,,,,313,330,310,44,,,51,,51,,62,,
     55,60,61,236,248,236,224,134,,,126,,146,187,114,,134,175,,225,424,316],
   [50,,136,,,158,75,,66,78,152,178,,158,,,179,312,176,310,316,310,46,,,51,,
     51,,,193,55,63,62,244,250,244,238,142,,333,120,,148,161,114,,140,130,
     334,183,386,365,48],
   [46,,190,,,,,,71,83,150,168,227,156,167,237,165,237,164,222,246,238,44,
     210,,51,60,51,,,,54,62,63,236,246,236,226,134,,250,126,256,144,,115,
     250,134,167,248,237,253,251,48,48],
   [42,,,,62,140,67,,,67,146,,,158,,,,,160,,342,294,42,,,49,58,49,,58,,,58,
     58,230,246,228,210,126,,,118,333,144,127,102,,126,176,,127,361,,45,48,
     45],[46,,160,,64,194,75,,,86,146,181,296,158,182,307,,325,,,314,,44,,,
     51,60,51,,61,,,,62,238,244,238,224,134,,343,126,348,146,229,114,321,
     134,,,240,388,329,45,48,48,45],
   [48,,140,,,146,76,,66,76,150,174,238,158,174,242,174,244,169,238,250,244,
     46,176,,51,,51,,,,55,,,242,250,244,238,140,,260,120,266,148,161,114,
     261,142,131,261,160,266,260,48,48,48,48,48],
   [6,,,,8,22,9,,8,9,20,,,22,23,42,,,21,,42,46,6,,,7,8,7,,8,,7,8,8,32,
     34,32,30,18,,,16,,20,17,14,,18,16,43,17,43,43,44,46,44,42,44,46],
   [8,,18,,10,18,11,,10,11,23,26,43,23,,,,45,26,43,43,45,7,19,,7,,8,,9,
     19,8,8,9,37,37,37,35,22,,,17,,22,21,17,46,22,20,55,21,55,58,51,51,
     51,49,51,51,7],[8,,28,,,,,,9,9,23,26,37,23,27,37,26,35,25,37,37,
     35,7,,,8,9,7,,,,8,9,8,37,37,37,35,22,,41,19,40,22,,17,40,22,19,41,
     19,41,40,51,51,51,49,51,51,7,8],
   [6,,,,8,22,9,,8,9,20,,,22,23,42,,,21,,42,46,6,,,7,8,7,,8,,7,8,8,32,
     34,32,30,18,,,16,,20,17,14,,18,16,43,17,43,43,44,46,44,42,44,46,6,
     7,7],[6,,,,8,22,9,,,9,20,22,,22,22,38,22,38,,,40,40,6,,,7,8,7,,8,,
     ,8,8,32,34,32,30,18,,38,18,40,20,19,16,38,18,,,19,38,51,44,46,44,
     42,44,46,6,7,7,6],
   [8,,18,,10,18,11,,10,11,23,26,37,23,27,35,25,37,26,37,37,37,7,19,,7,
     8,8,,9,19,8,,9,37,37,37,35,22,,38,17,41,22,21,17,39,22,20,38,21,
     41,39,51,51,51,49,51,51,7,7,8,7,7],
   [8,,28,,8,28,9,,9,,23,28,45,23,,45,26,43,25,43,,41,7,,,8,9,7,,8,,8,9,
     ,37,37,37,35,22,,57,19,44,22,19,17,57,22,19,45,,,44,51,51,51,49,
     51,51,7,8,7,7,7,8],
   [58,,,,79,79,77,,,89,48,,,68,65,80,,,62,73,76,77,52,,,61,72,51,,72,85,
     65,70,,272,284,236,256,44,,,59,88,50,134,45,,52,84,85,,78,85,360,376,
     324,340,360,334,50,55,51,50,48,51,55],
   [62,,78,,79,,78,,80,,64,68,76,54,,,68,80,61,68,84,72,54,85,,61,,51,,73,
     79,55,73,72,280,286,244,270,55,,85,50,,50,105,55,84,48,98,75,90,88,
     76,372,382,336,358,372,342,52,55,51,52,50,51,55,60],
   [54,,53,,,,,,65,73,52,54,62,54,54,68,54,68,52,62,70,68,48,59,,47,54,37,
     ,,59,50,,56,208,222,172,196,41,,73,46,77,36,,41,75,41,,73,71,74,75,
     272,284,236,264,272,244,38,41,37,38,36,37,41,48,48],
   [54,,,,74,81,67,,82,81,52,,,68,62,77,,,59,70,76,77,50,,,59,68,49,,68,
     85,65,68,58,266,282,228,242,42,,,57,86,50,93,42,,50,112,83,91,76,83,
     348,370,314,322,348,330,48,53,49,48,46,49,53,45,60,45],
   [58,,75,,78,,81,,,,61,65,73,54,68,72,65,77,,,84,,52,83,,61,60,51,,71,,,
     72,72,274,280,238,260,52,,84,50,79,50,125,52,84,44,,,92,89,78,360,
     374,324,342,360,336,50,55,51,50,48,51,55,57,48,48,57],
   [58,,56,,,54,,,64,71,52,58,66,54,58,68,58,68,57,66,70,68,50,61,,47,58,
     37,,47,61,51,,56,216,226,178,210,44,,75,46,78,36,,44,74,44,60,75,93,
     78,74,284,290,246,282,284,250,40,41,37,40,38,37,41,48,48,36,48,48],
   [58,,68,,79,79,77,,83,,52,65,65,68,65,77,65,72,63,73,,80,52,,,61,72,51,
     ,72,85,65,70,,272,282,234,256,46,,,57,87,50,135,45,72,53,85,83,,,82,
     362,372,326,340,362,332,50,55,51,50,48,51,55,48,60,45,45,60,48],
   [54,,72,,70,91,69,,74,81,61,62,70,54,,73,62,77,57,,84,,50,79,,59,56,49,
     ,66,89,49,66,66,264,278,230,242,50,,82,48,,50,92,50,82,42,89,76,87,
     88,,350,370,312,322,348,326,48,53,49,48,46,49,53,57,48,45,54,45,48,
     57],[,,,,,,,,,,,,,41,38,39,,,35,46,,45,,,,9,10,,,,,,10,,,53,,,,,,25,46,,,
     ,,23,,38,,,41,,,,,,,,9,,,,9,,,74,,,72,60,,61],
   [,,,,,,,,,,,,,,50,,,,,,,96,,,,22,26,30,,32,,,28,32,,104,130,,,,,21,,,,,,,,,,,,,
     136,170,,212,140,,22,26,,,24,26,,73,48,,67,88,,68],
   [,,,,,,,,,,,,,35,,76,,,34,,,88,,,,11,12,,,,,,12,,,50,57,,,,,30,,31,,,,28,,64,,
     ,60,,66,,,67,67,,11,,,,11,,,80,65,,,64,83,74],
   [,,,,,,,,,,39,35,66,36,31,56,34,60,36,66,70,60,8,27,,9,8,10,,12,27,10,
     10,12,53,49,54,46,28,,59,28,61,,,28,69,28,,59,,59,69,69,65,70,62,
     68,70,8,9,10,8,8,8,10,83,79,54,76,82,,83,70,9,,10],
   [,,,,,,,,,,36,43,62,,,55,40,60,45,,62,51,22,,,22,,,,,,28,24,,144,118,150,
     106,35,,66,21,59,35,22,18,64,41,22,67,26,66,,178,150,186,142,,,18,22,
     ,18,22,20,26,88,85,62,86,123,62,88,91,,21],
   [,,,,,,,,,,,40,,,35,69,,89,,,,74,9,28,,11,10,11,,13,28,11,10,13,59,57,,
     49,33,,70,,,33,,31,,,,76,,83,,77,75,81,67,,77,9,11,11,9,9,9,11,91,
     89,71,81,,75,,81,10,,11],[],[],
   [,,,,,,,,,,,,,,38,,41,79,42,,,96,9,28,,,10,11,,13,28,11,10,13,63,,59,49,,
     ,98,,85,39,,31,,33,,67,,78,,75,78,,67,77,,9,9,11,9,9,11,11,89,92,
     73,81,91,71,89,81,10,,11,,,11],
   [,,,,36,45,42,,34,,,,,26,28,37,,,29,36,,38,,,,,29,28,,34,34,27,,,,137,121,
     ,,,,24,40,27,,,,24,,36,,,33,,,162,,,169,,27,27,,22,24,29,,68,59,,68,
     58,63,66,24,,,32,40,32],
   [,,,,48,51,63,,,,,,,56,50,65,,,47,58,,65,,,,59,54,37,,44,62,53,44,74,,,
     164,,,,,45,77,38,99,,,38,64,74,,,74,,314,224,,291,238,,43,37,,,37,43,,
     48,33,,45,36,,42,,40,,52,62],
   [22,,,,,36,,,,,24,28,49,24,28,49,28,49,28,49,52,52,20,,,23,32,23,,,,29,
     28,30,108,112,110,106,21,,53,21,53,22,45,20,52,20,42,52,41,53,53,
     148,152,150,146,146,150,20,23,23,20,20,23,23,64,64,34,61,61,36,61,
     61,,31,,,,,,,,25,33],
   [28,,,,,43,39,,,39,25,29,47,26,25,54,31,50,24,58,54,56,25,56,,,32,26,,
     31,37,26,,30,129,136,119,127,21,,50,24,59,23,41,21,50,21,37,57,41,
     51,59,168,177,161,172,,168,23,29,26,23,23,27,26,63,68,35,59,66,37,
     62,66,28,31,29,,,,,,,24,33],
   [,,,,,62,,,,,36,40,72,56,62,36,41,72,56,34,72,36,58,,,,58,37,,,,51,,49,
     248,,178,,35,,76,47,40,36,71,35,76,43,64,37,69,76,37,314,320,246,322,
     ,250,42,43,37,42,40,37,,84,48,48,84,48,50,84,46,,56,,,53,,,,,40,48],
   [28,,50,,32,,,,,38,,,,28,31,40,,,29,39,,40,25,57,,27,31,26,,30,39,28,31,
     ,132,145,123,127,24,,63,25,36,27,,,63,24,57,38,61,,38,175,181,168,
     167,176,174,23,26,26,23,22,26,26,65,72,61,,71,62,68,72,,59,37,35,43,
     ,,,40,27,,25,25,40],
   [148,,109,,49,75,69,,76,69,,,,56,53,68,,,50,61,,65,82,,,59,54,35,,49,57,
     49,44,72,246,280,171,228,68,,,47,78,38,75,,,40,64,72,59,,72,310,334,
     235,304,322,242,46,45,35,46,40,37,41,72,48,33,69,46,36,69,44,,48,
     88,48,60,74,,,96,,33,33,36,48],
   [,,47,,,38,,,34,,24,31,47,28,26,58,29,51,24,54,54,58,,,,25,29,28,,,,26,
     29,35,,139,121,122,21,,50,23,58,23,43,21,50,24,41,59,45,51,57,166,,
     163,166,162,169,21,25,26,21,22,25,25,62,69,35,59,68,37,63,66,,36,,,,
     39,,,,24,33,,24,,25,37],
   [,,,,,60,49,,,89,33,40,65,56,58,34,39,68,58,33,68,34,,91,,,56,37,,74,
     49,57,,42,248,264,173,230,32,,68,45,36,34,67,33,69,40,68,36,63,69,
     35,303,306,237,306,,242,40,,37,40,40,35,43,77,48,46,77,45,48,80,44,
     39,52,66,110,,79,,,,36,45,,,36,37,48],
   [,,,,,53,68,,,,,,,56,56,68,,,54,64,,68,58,,,,56,37,,49,61,51,47,,268,258,
     178,,,,,47,76,38,66,72,,43,,72,,,74,312,316,246,314,318,250,44,43,37,
     44,40,37,,76,50,36,76,48,36,78,46,,99,,49,62,,,,,,36,36,40,48,,36,
     40,48],[,,,,,62,,,,,33,39,58,56,61,32,39,61,54,30,64,33,,,,51,54,37,
     ,74,,53,74,44,259,264,167,228,30,,61,45,34,32,67,30,61,38,62,33,67,
     62,33,293,312,222,272,282,238,38,43,37,38,38,37,43,73,46,44,70,44,
     46,73,42,45,50,,,51,,,,,33,42,,,36,34,45,,33,48],[],
   [,,,,10,28,11,,,11,,,,27,29,39,,,27,43,61,37,,,,9,10,9,,10,,,10,10,,41,,,
     ,,,23,44,24,23,,,23,,38,23,77,40,,55,54,,54,55,,9,9,,,9,9,,65,50,,
     64,51,,59,7,,,9,26,10,,,10,24,,29,27,41,,,26,39,61,43],
   [8,,30,,10,,11,,,11,23,28,59,23,31,55,,53,,51,,57,7,22,,7,,8,,9,22,9,
     9,9,37,37,37,35,22,,53,19,,22,23,19,,22,,,23,72,,51,51,51,49,51,51,
     7,7,8,7,7,7,8,61,61,47,59,61,47,61,59,8,30,9,,,,,,,27,51,23,,,,57,
     26,65,,61,,8],[,,,,27,,28,,,28,38,38,62,,,,37,59,36,,61,63,,,,,,22,,
     23,,,,23,176,136,,185,34,,59,,51,34,20,17,59,38,19,51,20,63,65,214,
     171,,,204,182,17,31,20,17,,33,20,85,79,59,85,,61,85,83,,23,,,,,,,,35,
     59,,,,38,59,40,85,61,86],
   [10,,32,,12,,13,,,13,33,33,54,31,29,52,31,52,34,54,60,54,8,23,,9,8,9,
     ,10,23,10,9,10,47,46,45,42,26,,53,26,57,,27,24,61,26,,53,27,54,61,
     63,62,61,58,62,62,8,9,9,8,8,8,9,73,72,45,68,72,47,72,66,9,36,10,
     8,,,,,10,30,44,,,,33,44,31,72,47,76,,9],
   [8,,22,,,22,,,11,11,23,31,51,23,27,59,28,,,61,57,,7,,,8,9,7,,,,9,9,9,
     37,37,37,35,22,,51,19,66,22,,17,49,22,21,,21,51,51,51,51,51,49,51,
     51,7,8,7,7,7,8,7,61,61,47,59,61,47,61,59,,22,10,10,22,11,,,11,27,
     61,23,25,57,,,,57,57,51,,8,8,21,9],
   [10,,26,,8,24,,,12,10,,30,74,36,31,42,32,,27,44,,55,8,,,9,10,9,,8,,10,
     10,9,46,,44,42,26,,,20,47,26,,18,57,26,22,49,20,74,45,62,63,60,58,
     60,65,8,9,9,8,8,9,8,62,73,54,58,70,58,62,66,,24,12,12,24,13,,,13,
     ,76,32,29,47,30,,,42,,44,,9,9,22,10],[],[],
   [10,,32,,12,,13,,,13,,,74,31,31,53,30,74,34,44,,44,8,23,,,9,9,,10,23,
     10,8,10,45,47,,42,26,,75,26,47,29,27,24,,26,,45,27,92,47,61,62,63,
     58,62,62,8,8,9,8,8,9,9,61,72,56,58,72,56,,66,9,34,10,10,,10,,,,
     27,76,29,35,47,,70,30,,,44,,9,,,9,9,10],
   [10,,28,,10,,10,,12,,28,32,44,,32,,31,51,29,76,46,,8,,,9,10,,,9,,10,10,
     8,44,52,46,42,26,,49,20,72,29,20,18,45,26,22,,,47,57,60,65,62,58,
     62,63,8,9,8,8,8,9,9,70,,56,68,,57,70,56,,24,12,12,,13,,,13,33,54,
     28,29,56,30,56,34,52,58,54,,9,9,22,10,,9,,,10],
   [34,,170,,53,160,,,53,63,108,131,243,114,,,132,,125,,248,246,32,176,,37,
     46,37,,47,182,,44,,36,36,34,32,98,,340,94,281,106,206,87,263,100,,
     257,147,307,,236,244,236,230,238,242,32,37,37,32,32,37,37,272,280,
     208,266,274,216,272,264,,130,53,,,,,,63,131,232,108,,,130,,126,243,252,
     228,,42,37,,,37,46,,,46,44],
   [38,,104,,49,,57,,50,,112,136,258,114,144,262,149,290,134,,,280,34,139,,
     37,49,37,,47,165,41,,47,36,38,36,34,106,,341,88,389,108,126,86,,102,
     99,294,,307,287,248,250,246,246,244,250,34,37,37,34,34,37,37,284,286,
     222,282,280,226,282,278,,104,51,49,122,59,,,64,131,,112,,,,,130,,282,
     258,,41,37,165,46,37,,,,47,,36],
   [34,,,,,158,63,,,65,110,121,162,112,124,171,121,171,122,164,178,171,32,
     174,,37,44,37,,45,,40,46,,33,36,34,33,98,,184,94,189,104,193,86,184,
     100,139,184,202,185,182,236,244,236,228,238,244,32,37,37,32,32,37,37,
     236,244,172,228,238,178,234,230,,140,51,48,,63,,,68,121,167,110,120,
     178,121,173,118,171,178,164,,40,37,220,45,37,44,,,46,47,36,36],
   [,,,,,22,,,,,,,,40,40,62,,,37,66,61,62,,,,21,22,,,,19,,22,,,99,139,,,,,38,
     66,36,,,,34,,61,,60,60,,130,167,,167,130,,19,,,,19,,,88,62,,86,64,85,
     84,,,,24,,25,,,25,,,,53,,50,95,47,82,,,,,21,,22,20,24,,,22,24,143,99,
     183],[,,,,47,57,53,,82,,,,,60,54,69,,,51,62,,69,,,,68,57,40,,46,63,
     53,47,92,,293,185,,,,,49,79,42,68,,,42,60,75,61,,75,,,253,,,266,,44,40,
     ,38,40,56,,52,37,,49,40,,46,,,,51,69,72,,,,,,38,41,53,,41,43,52,40,
     51,,,52,62,49,72,,,,,58,279,307,184],
   [22,,,,,35,35,,,33,23,26,45,23,26,45,25,45,23,45,47,47,20,,,22,28,22,,,
     36,24,26,27,106,108,106,104,21,,49,21,49,22,40,20,48,20,36,48,38,
     49,49,146,148,146,144,144,148,20,22,22,20,20,22,22,59,59,34,57,57,
     36,57,57,30,31,31,,,,,,33,25,33,20,,,25,33,,72,35,,,24,22,,,22,28,,,
     27,26,106,108,106,,37],
   [,,,,,26,,,,,,,70,45,41,65,60,58,44,67,,67,19,22,,21,22,23,,27,20,23,
     20,27,153,148,193,93,,,77,41,67,38,,41,,38,,66,,68,71,185,159,,127,
     225,,19,19,23,19,19,17,23,92,95,67,91,93,71,135,91,22,,25,,,,,,25,52,
     ,,,,52,106,51,85,,,,22,,,,21,25,,,22,25,,126,,19],
   [,,,,,66,50,,,70,40,37,74,60,63,37,38,70,57,33,74,35,,,,51,59,42,,,51,
     48,,45,,272,184,246,37,,75,49,37,35,66,33,73,41,61,36,68,75,36,324,,
     248,,357,260,39,44,39,39,,40,43,85,52,47,83,47,49,83,45,47,58,64,,,,,
     ,74,41,49,,,,40,49,,39,51,37,,41,,48,,,44,,,50,53,,294,185,,52],
   [22,,21,,28,21,37,,30,,22,,66,23,25,35,27,,24,33,66,33,18,,,19,20,19,,
     26,19,23,20,,94,88,94,86,21,,,22,37,21,43,20,50,20,40,35,,67,35,
     126,120,126,118,126,120,18,17,19,18,18,17,19,50,59,46,48,57,46,50,
     57,,36,26,26,34,27,,,27,,68,21,24,35,,,25,35,66,33,,21,21,35,22,17,,,
     ,22,28,94,88,94,19,,21,20,36],
   [,,,,51,79,66,,65,,,,,60,53,68,63,,50,61,,69,,,,51,55,39,,49,59,51,45,,
     261,327,184,,,,,48,77,42,,43,,41,,73,65,,73,323,,250,370,,261,41,43,
     39,41,38,39,,75,49,37,89,47,37,72,45,,56,,50,69,71,,,,,37,36,39,51,,
     ,41,51,38,49,,67,50,61,46,,,,,73,65,283,,185,,37,36,,48],
   [18,,,,28,35,,,28,33,22,24,30,22,22,32,24,33,21,30,36,32,18,,,22,26,22,
     ,26,32,,26,26,98,104,98,90,18,,33,20,34,20,38,18,33,18,34,33,38,
     34,33,134,142,134,126,134,142,18,22,22,18,18,22,22,45,46,32,42,44,
     34,45,42,23,28,28,28,35,33,,,33,21,30,22,21,34,22,34,21,34,34,30,,
     23,22,32,26,22,26,,,26,26,98,104,98,,36,21,,36,21,36],[],
   [18,,,,28,18,31,,,31,20,25,38,23,23,40,23,41,25,38,43,41,16,19,,17,18,
     19,,24,19,28,18,24,87,86,86,74,18,,41,20,42,20,39,18,41,18,40,41,
     39,42,41,114,114,115,102,114,114,16,15,19,16,16,15,19,52,55,32,50,
     52,34,53,50,19,28,22,22,38,23,,,23,21,30,22,21,72,22,33,,,35,,,19,
     19,,20,17,22,,,20,22,87,86,86,16,37,21,17,,17,37,18],
   [,,,,,66,57,,73,85,40,34,77,60,63,36,36,74,59,34,78,36,,,,51,57,42,,,
     51,56,72,47,,300,189,289,37,,79,49,38,36,67,35,77,42,66,37,69,79,
     37,366,,256,355,,266,41,44,40,41,40,40,43,88,50,48,86,49,50,87,46,
     51,57,65,,,,,,72,43,51,,,40,43,52,,,53,39,,41,70,60,76,,47,,,47,62,
     277,389,187,,49,,,37,37,52,36],
   [,,,,,22,,,,,,,,45,43,71,,74,44,67,66,67,19,22,,,20,23,,27,20,23,22,27,
     191,133,,93,,,64,41,69,42,,41,86,38,,65,,63,70,225,160,244,127,239,
     188,19,17,23,19,19,19,23,,95,69,93,95,69,90,91,22,,25,,,25,,,,,,,,,
     52,106,51,,,,,22,,,22,21,25,,,,25,195,138,202,19,,,19,,20,,,,17],
   [,,,,45,60,52,,65,88,,,,60,53,69,63,,50,61,,68,,,,,59,42,,43,59,48,49,
     75,290,,184,,,,,49,79,42,77,45,,41,,75,67,,75,327,345,250,,328,261,41,
     44,39,41,38,40,54,91,49,35,73,47,40,,45,,,,52,68,74,,,,,39,38,39,50,
     ,39,41,51,,49,,,52,58,50,68,,,,,58,264,341,182,,40,37,,45,,36,36,,37,
     49],[92,,,,,66,49,,,85,40,37,77,60,63,36,36,76,58,34,76,37,81,,,51,
     57,40,,,61,53,74,45,269,377,184,,37,,79,49,38,36,67,35,77,42,64,37,
     68,79,37,342,352,253,333,,266,41,44,40,41,40,40,44,88,50,48,86,48,
     50,86,46,51,57,67,,,,,,72,43,51,,,,43,51,,40,52,,,43,,,,,47,,,49,58,
     280,,184,,46,,,40,38,49,36,,,37,,52],
   [46,,160,,65,214,77,,,,148,174,290,158,174,,174,301,168,295,312,305,44,,,
     51,62,51,,62,,55,60,61,236,248,236,224,134,,326,126,344,146,,114,,134,
     175,,181,347,317,48,48,46,44,46,48,44,51,51,44,44,51,51,360,372,272,
     348,360,284,362,350,66,160,69,,,,,,75,176,306,148,,,176,309,167,308,
     330,313,,56,51,,,51,62,,,61,60,236,248,236,175,347,146,,,126,,134,,114,
     344,183,326,366],[50,,140,,64,150,76,,67,77,152,180,328,158,180,314,
     184,314,,328,314,314,46,193,,51,,51,,62,171,55,65,62,244,250,244,238,
     142,,345,120,,148,159,114,,140,130,,,,333,48,50,48,46,48,50,46,51,51,
     46,46,51,51,376,382,284,370,374,290,372,370,,136,67,64,154,76,,,77,
     173,308,152,174,,,,173,312,322,302,,55,51,193,62,51,,,,62,63,244,250,
     244,130,386,148,161,334,120,,142,,114,,159,333,362,48],
   [46,,,,70,,75,,67,,150,167,222,156,168,237,164,237,162,227,246,238,44,,,
     51,60,51,,61,204,54,62,62,236,246,236,226,134,,248,126,256,144,179,
     115,251,134,,248,185,252,247,45,48,46,45,46,48,44,51,51,44,44,51,51,
     324,336,236,314,324,246,326,312,64,170,67,,186,75,,,83,164,224,150,
     163,246,167,237,161,237,246,227,,54,51,210,,51,60,,,62,63,236,246,236,
     215,253,146,179,250,126,251,134,,115,255,185,248,253,48,48],
   [42,,,,62,140,67,,72,67,146,167,280,158,171,312,167,302,,284,322,298,42,,
     ,49,58,49,,58,205,,58,58,230,246,228,210,126,,340,118,332,144,127,
     102,359,126,224,316,127,,365,45,46,44,42,45,46,42,49,49,42,42,49,49,
     340,358,264,322,342,282,340,322,67,,72,60,140,67,,,67,,302,146,162,
     316,167,,,,316,,,60,49,218,58,49,58,,,58,58,230,246,228,176,343,144,
     127,320,118,365,126,,102,,127,371,355,45,48,45],
   [46,,172,,,,81,,,77,146,,294,158,177,306,,,168,325,318,303,44,,,51,60,51,,
     ,224,54,62,62,238,244,238,224,134,,316,126,350,146,185,114,344,134,
     217,323,,352,,48,48,46,44,46,48,44,51,51,44,44,51,51,360,372,272,
     348,360,284,362,348,,,71,64,188,,,,,,282,146,163,318,183,303,,320,,291,,
     54,51,,61,51,60,,,,62,238,244,238,167,375,144,179,355,126,336,134,,
     114,353,,,377,45,48,48,45],
   [8,,22,,10,,11,,10,11,23,27,51,23,29,43,26,47,,45,,45,7,20,,7,,8,,9,
     20,8,8,9,37,37,37,35,22,,48,17,,22,21,17,,22,20,,21,65,48,51,51,
     51,49,51,51,7,7,8,7,7,7,8,57,57,43,55,57,43,57,55,8,20,9,,,,,,9,
     26,45,23,,,28,45,25,45,,51,,8,7,,,8,9,,,8,9,37,37,37,19,47,22,,,19,
     45,22,,17,62,19,47,62,51,51,51,49,51],
   [8,,20,,,20,,,9,9,23,29,45,23,27,47,28,43,28,51,45,,7,,,8,9,7,,,,8,9,
     8,37,37,37,35,22,,47,19,62,22,,17,45,22,19,,19,47,47,51,51,51,49,
     51,51,7,8,7,7,7,8,7,57,57,43,55,57,43,57,55,,22,10,10,22,11,,,11,
     27,51,23,25,45,,,,49,47,45,,8,8,20,9,7,,,,9,8,37,37,37,20,65,22,21,
     ,17,,22,,17,,21,48,66,51,51,51,49,51,8]],
 [,[],[],[],[,6,,4],[,,15],[,7,,5],[,,12,,,15],[,,,4,4,,5],
   [,7,,5,,,5,,5],[22,,,,24],[,17,,,20,,21,,,18],[,,,,44,,51,74],
   [24,17,38,14,18,43,15,43,14,15,21,19,41],[,,,,18,,23,,,,21,19,37],
   [],[,,41,,18,,23,41,,23,,19,,18,18],
   [,79,65,46,38,93,31,60,46,45,,,37,41,34],
   [,17,,,20,,22,,,20,,17,,,19,,19,39],[,,74,,44,,,,,,,,46,,,,37,49],
   [,,59,,44,,51,68,,,,,37,41,37,,,37,42,49],
   [148,49,58,46,38,109,31,55,46,41,41,39,49,,,,34,43,,37,49],
   [6,,,,8,22,9,,,9,20,,,22,,,,,,,58,82],
   [,,,,,16,,,,,,,,41,41,,40,64,,,93,65],
   [,5,,,6,16,7,,,7,,17,,17,,,21,45,17,,37,45],
   [8,5,14,7,6,14,7,14,7,7,19,17,46,17,,,,41,17,58,58,41,7,15,5],
   [10,,16,10,8,12,9,16,10,9,21,23,44,,25,,25,38,23,72,40,50,8,16,6],
   [8,5,28,7,,,,28,7,,21,19,38,21,20,,19,39,19,38,33,39,7,,5,5,6],
   [,,,,,,,,,,,45,,52,,,43,90,45,,,114,,16,,15,16],
   [10,6,32,8,6,,,32,8,7,26,21,49,18,25,,23,40,21,49,48,40,8,,6,6,7],
   [,,,,,16,,,,,,,,52,41,,40,67,,,69,74,,13,,15,16,,16],
   [,5,,,6,16,7,,,7,,17,,17,,,21,45,17,,37,45,,,5,5,6,5,,6],
   [10,,16,10,8,12,9,16,10,9,22,23,49,26,24,,24,42,23,49,40,42,8,16,6,,
     6,6,16,7,16,6],[10,6,32,8,6,,7,32,8,,,23,72,18,25,,24,62,21,44,,
     38,8,,6,6,7,,,6,,6,7],
   [34,,,,,140,37,,,43,90,,,96,94,,100,230,,,238,251,32,,,29,33,28,142,,,,,36 
    ],[38,27,70,22,26,72,25,70,22,25,94,,273,72,,,92,,96,273,242,216,34,
     77,27,27,,30,77,30,78,27,,30,29],
   [34,29,,,,,,168,,37,92,95,191,92,97,,95,193,96,198,191,189,32,224,29,27,
     34,28,,,152,29,33,38,29,29],
   [30,25,60,20,20,60,25,60,20,25,88,83,218,72,,,,,83,204,204,,30,69,25,
     25,30,25,70,30,70,25,30,30,26,23,26],
   [18,,,,16,35,21,,,,16,,,18,19,,19,50,,,,36,18,,,17,21,17,,21,,,22,22,81,
     82,81,74],[,,,,8,,9,,,9,,,,18,19,,19,40,,,,40,,,,11,16,13,,14,,,16,
     14,,32,,30],[,,,,34,61,37,,,,,,,36,35,,,34,,,35,44,,52,,,39,34,61,45,
     58,,43,,,206,177,188],
   [22,13,32,10,8,32,9,32,10,9,18,16,32,14,,,15,28,16,64,32,,18,35,13,9,
     ,11,35,12,35,13,18,12,66,32,66,30,16,6,30],
   [,,61,,34,57,37,63,,41,39,41,45,,,,35,44,,35,44,34,,62,51,,,33,62,43,
     56,51,45,39,242,,189,188,35,,41],
   [22,,35,18,,,,35,18,21,20,,38,20,19,,19,38,,38,36,38,20,36,16,17,18,16,
     ,,36,16,18,21,81,83,82,74,17,,35,16],
   [,15,,11,,,,,11,9,,41,,19,23,,23,39,39,,,39,19,,15,11,15,,,,,15,15,13,
     125,35,,35,,7,,7],
   [18,13,28,10,8,28,9,28,10,9,20,16,64,14,15,,,,16,32,64,28,16,35,13,
     9,12,11,35,12,35,13,12,12,66,32,70,30,16,6,,6,30,16,7],
   [,,63,,34,57,37,61,,,,,35,36,35,,,,41,45,33,44,,54,53,61,39,33,64,43,
     60,53,44,54,232,226,192,,,,33,30,38],
   [18,,,,16,35,21,,,21,16,,,20,19,,19,36,,,37,50,18,,,17,21,17,,21,,,22,
     21,84,84,82,74,14,,,16,,17,,16,35],
   [,,,,8,,9,,,9,,,,18,19,,19,40,,,,40,,,,11,16,13,,14,,,16,14,,32,,30,,6,,
     6,,,7,6],[,,,,34,61,37,,,41,,,,,,,35,44,,,45,34,,58,,61,,34,61,45,52,
     ,44,41,,226,190,191,,,35,,33,35,,30,41],
   [,15,,11,,,9,,11,,,39,,19,23,,23,43,,,,43,19,,15,11,15,,,13,,15,15,,,35,
     87,35,,7,,7,,,7,7,,,7],
   [,,51,,34,59,37,57,,,,,34,36,35,,,34,,44,,44,,81,,,40,34,58,45,65,,47,,
     211,,,184,,,30,30,41,35,,,33,33,,38],
   [92,,57,,34,,37,51,,41,39,41,45,,,,35,44,,35,43,,81,62,53,,,33,62,43,
     60,53,44,39,214,206,179,192,35,,41,,30,33,,30,35,,,33,,41],
   [46,,,,36,132,,,,53,122,,,124,124,,124,296,,,,296,44,,,39,45,38,178,48,,,
     45,50,186,186,186,168,109,,,82,,109,101,82,286,110,,,139,296,266],
   [50,37,94,30,34,94,35,96,30,35,126,,,100,,,122,,123,294,303,272,46,103,
     37,37,,39,103,42,103,37,48,42,190,160,186,154,110,44,260,44,,110,49,
     44,,111,44,260,49,264,258,37],
   [46,,,46,,,,,46,53,124,125,254,126,,,124,246,125,,254,249,44,149,,39,45,
     38,,,151,,45,49,186,188,186,168,109,84,228,78,242,110,,78,248,109,84,
     248,137,242,228,37,37],
   [42,35,84,28,28,84,35,84,28,35,120,113,280,100,114,,,,113,280,276,244,
     42,96,35,35,42,35,95,42,96,35,42,42,176,158,176,140,102,42,242,42,
     242,102,49,42,,102,42,246,49,246,,34,31,34],
   [46,,,,36,,47,,,53,124,,,120,126,,,315,,,,292,44,,,39,45,38,,48,,,45,50,
     188,184,188,168,110,,,78,273,109,139,82,268,109,,,139,313,298,34,37,
     37,34],[48,37,96,30,32,94,35,96,30,35,126,132,248,100,127,,121,236,
     ,248,249,,46,103,37,37,,39,103,42,104,37,,42,188,160,190,154,108,44,
     217,44,217,110,49,44,221,110,44,221,49,221,217,37,31,37,31,37],
   [6,,,,8,18,9,,,9,20,,,22,21,,21,50,,,52,56,6,,,7,8,7,17,8,,,8,8,32,
     34,32,30,18,,,18,47,20,19,16,62,18,,,19,47,62,44,46,44,42,44,46],
   [8,9,14,13,10,14,11,14,13,11,23,28,49,23,,,,51,28,51,57,51,7,15,9,7,
     ,8,14,9,15,9,8,9,37,37,37,35,22,21,,15,,22,19,15,49,22,21,61,19,
     58,58,51,51,51,49,51,51,7],
   [8,10,22,11,,,,22,11,9,23,26,43,23,26,,25,41,26,43,43,41,7,33,9,8,9,
     7,,,33,9,9,8,37,37,37,35,22,19,44,17,43,22,,15,44,22,19,44,17,44,
     44,51,51,51,49,51,51,7,8],
   [6,9,12,10,8,14,9,12,10,9,20,22,50,22,22,,,,22,50,46,46,6,15,8,7,8,
     7,15,8,15,8,8,8,32,34,32,30,18,16,55,14,,20,15,12,,18,16,44,15,
     44,44,44,46,44,42,44,46,6,7,7],
   [6,,,,8,18,9,,,9,20,,,22,21,,21,50,,,52,56,6,,,7,8,7,17,8,,,8,8,32,
     34,32,30,18,,,18,47,20,19,16,62,18,,,19,47,62,44,46,44,42,44,46,6,
     7,7,6],[8,9,14,13,10,14,11,14,13,11,23,28,43,23,26,,24,43,28,43,
     43,43,7,15,9,7,8,8,14,9,15,9,,9,37,37,37,35,22,21,42,15,44,22,
     19,15,42,22,21,42,19,44,42,51,51,51,49,51,51,7,7,8,7,7],
   [8,10,22,11,8,20,9,22,11,,23,28,51,23,,,25,51,26,49,,51,7,33,9,8,9,
     7,,8,33,9,9,,37,37,37,35,22,19,61,17,47,22,17,15,59,22,19,48,,,48,
     51,51,51,49,51,51,7,8,7,7,7,8],
   [58,,,,44,73,51,,,55,44,,,49,49,,48,61,,,63,63,52,,,47,53,42,,56,,,53,,
     222,218,214,196,40,,,40,63,43,81,40,61,42,,,,57,63,294,290,286,268,
     294,288,50,59,55,52,50,55,59],
   [62,45,76,36,40,89,39,83,36,43,53,47,67,38,,,46,59,49,65,71,53,54,83,
     43,45,,43,84,50,84,43,56,50,226,192,214,182,44,42,62,34,,43,45,36,
     64,43,42,60,43,64,58,294,260,286,250,290,256,52,59,55,54,52,55,59,
     45],[54,49,53,44,,,,59,44,45,48,46,62,50,43,,43,68,49,68,68,68,48,
     60,41,37,41,32,,,,41,38,44,182,188,166,164,39,,59,34,59,34,,34,63,39,
     ,,43,63,63,242,242,222,220,242,222,44,45,41,40,44,41,45,41,41],
   [54,43,72,34,36,66,39,68,34,43,48,46,60,43,43,,,,44,68,60,63,50,77,
     41,43,50,39,84,50,85,41,50,46,212,190,204,168,40,40,56,34,60,40,45,
     32,,42,40,64,45,56,64,276,254,268,232,276,250,48,57,53,50,48,53,57,
     38,39,38],[58,,,,44,,57,,,,50,,,50,51,,49,65,,,67,59,52,,,47,49,42,
     82,56,,,53,56,224,222,216,198,42,,,40,59,43,83,40,65,40,,,52,62,59,
     294,292,286,268,294,286,50,59,55,52,50,55,59,42,41,41,42],
   [58,43,58,34,30,52,29,58,34,33,52,43,70,38,39,,39,58,43,70,66,52,50,
     63,39,35,44,34,57,34,63,39,,38,182,160,172,150,42,36,65,28,65,36,
     35,28,65,42,36,65,35,63,63,238,212,224,202,242,196,46,45,41,42,46,
     41,45,41,35,33,35,41],
   [58,47,76,46,44,76,51,77,46,,52,53,63,49,49,,51,61,50,69,,63,52,113,
     45,45,54,42,,56,86,45,53,,222,216,216,196,44,,59,40,,40,81,40,59,45,
     ,65,,,61,296,288,288,268,296,290,50,59,55,52,50,55,59,41,45,38,38,
     45,41],[54,43,68,34,36,72,39,72,34,43,50,44,64,38,47,,43,69,46,
     64,64,,50,83,41,43,46,39,79,50,79,41,50,50,212,188,204,168,42,40,
     60,32,56,40,45,34,68,40,40,60,43,60,,276,254,268,232,276,248,48,57,
     53,50,48,53,57,42,35,38,36,38,35,42],
   [,,,,,,,,,,,,,30,28,,30,,,,,,,,,9,10,,,,,,10,,,44,,39,,,,25,52,26,,25,,,,,,,,,
     58,59,53,,57,,9,11,9,,9,11,,70,64,61,,63,,61],
   [,,,,,,,,,,,,,34,31,,31,72,,,,72,,,,11,15,16,,18,,,16,18,,49,104,44,,,,10,,,
     ,10,,,,,,,,,64,100,60,,64,,16,18,12,,16,18,,64,,62,,64,,60],
   [,,,,,,,,,,,,,35,,,31,87,,,,174,,,,11,12,,,,,,12,,,50,,44,,,,30,71,31,,28,
     103,,,,,,,,66,,60,,67,,11,,10,,11,,,78,75,72,,70,83,72],
   [,,,,,,,,,,33,,81,30,28,,29,,,81,,77,8,21,7,9,8,7,21,9,21,7,7,9,46,
     44,58,41,26,,66,25,,,,25,70,26,,66,,94,70,,58,76,55,60,58,8,9,10,8,
     8,8,10,72,70,60,67,73,52,78,61,9,,10],
   [,,,,,,,,,,24,25,48,34,,,23,50,25,67,48,53,22,,18,11,12,,,,,18,12,,100,
     49,,44,22,8,45,10,47,22,10,8,45,22,8,51,10,45,47,120,64,104,60,,
     62,22,16,,14,22,16,18,60,64,46,56,,46,60,62,,10],
   [,,,,,,,,,,,46,,35,31,,,,,,,87,9,22,8,11,10,8,22,10,22,8,8,10,55,50,,
     44,31,,71,30,,,,28,77,,,73,,99,,75,66,75,60,,66,9,11,11,9,9,9,11,
     83,78,79,72,,70,,72,10,,11],
   [,,,,,,,,,,,25,42,24,23,,,59,25,48,54,50,,,,11,16,16,,18,,,15,18,,49,,44,
     22,8,47,8,45,22,10,10,51,22,8,45,10,47,45,,65,132,60,116,64,,16,
     18,12,,16,18,,60,46,62,60,46,,56,,10,,,10],
   [,,,,,,,,,,,40,,36,33,,31,63,40,,74,,,,,11,12,,,,,,12,,67,51,59,44,,,61,
     30,57,,,28,57,,,61,,,57,83,67,75,60,83,67,8,9,10,10,8,9,10,91,75,,
     68,,60,83,70,,,10,10,,11],
   [,,,,,,,,,,,,,35,33,,33,,46,,,107,9,22,8,11,8,8,22,10,22,8,10,10,,52,,
     44,,,103,30,77,,,28,,31,,,,73,84,75,67,,60,71,66,9,9,11,9,9,11,11,
     83,79,79,72,87,70,83,72,10,,11,,,10,,11],
   [,,,,18,41,23,,,,,,,20,21,,,,,,,38,,,,,24,20,41,25,,,27,,,94,95,84,,,,18,
     37,19,,,,,,,,,37,,124,124,114,,121,,27,26,23,,24,27,,50,47,47,,51,51,
     48,24,,,28,23,,31,35,31],
   [,,,,36,59,51,,,,,,,53,45,,,,,,,71,,,,58,49,38,,44,,,44,72,,,191,,,,,36,71,
     39,65,64,,,,,,,71,,298,251,264,,248,,51,43,50,,43,49,,49,37,,,37,,46,,
     42,,67,48],[22,,,,,45,,,,,21,21,,21,21,,21,57,21,57,57,57,20,,20,19,
     22,21,43,,,20,23,25,90,94,92,88,18,18,49,18,49,18,23,18,49,18,18,
     49,23,49,49,122,126,124,120,124,126,20,23,23,20,20,23,23,53,53,36,
     50,50,34,50,50,,24,,,,,,,,21],
   [28,,,,,,23,41,,23,21,20,45,20,21,,21,42,18,55,45,50,25,43,20,,24,19,
     40,24,39,20,,23,99,94,97,87,17,17,38,18,47,17,21,15,38,17,17,47,
     21,38,47,126,124,126,117,126,127,24,27,26,22,24,26,26,49,50,33,43,
     50,31,49,48,,23,31,24,,,31,31,33,18,37],
   [,,,,,74,,103,,,,41,75,53,55,,,75,51,36,,34,58,,35,58,42,33,69,,,35,46,
     44,231,,198,,34,36,63,36,37,34,41,32,63,38,36,33,41,65,33,295,298,
     255,264,,249,52,57,43,46,52,43,,64,49,44,64,44,42,69,40,67,48,,,42,,
     ,74,,37,49],[28,17,,,18,,21,39,,20,,,,,20,,,,20,41,,46,25,,17,17,22,
     19,,21,43,17,22,24,,96,95,85,17,17,43,15,34,19,21,16,43,17,17,34,
     21,43,34,135,119,125,113,,,24,28,28,23,24,28,27,54,49,49,,51,48,53,
     47,,25,46,,25,,,,,19,,22,19],
   [148,79,93,46,32,65,31,58,46,41,,,,,42,,,,51,75,,91,82,114,51,41,42,39,
     74,36,63,51,38,62,235,234,193,188,62,34,,30,64,39,33,,,44,34,64,35,,
     66,299,284,255,244,315,232,56,51,41,46,56,43,51,59,40,37,53,42,30,
     61,38,,52,158,59,50,87,72,56,109,,37,41,34,49],[],[],
   [,,,,44,,51,68,,,,,,53,45,,,,61,75,,71,58,,45,46,42,33,61,44,67,45,36,,,
     238,191,,,,,36,90,38,44,64,,49,,71,65,,,285,303,257,278,,249,52,53,43,
     46,52,43,,62,42,34,60,44,37,63,40,,67,,,48,,,,,,37,41,37,46,,37],
   [,,,,,68,,,,,41,41,90,53,,,39,77,51,36,75,41,,,,46,49,38,,72,,,72,44,
     244,247,,,34,36,63,36,33,34,41,32,65,38,36,33,41,63,37,300,294,257,
     264,298,248,66,53,45,50,66,45,57,67,42,44,68,44,42,64,46,,48,,,54,,,
     82,,37,46,,,37,42,49,,,49],
   [,,,,10,,11,,,11,,,,24,25,,25,54,,,,54,,,,9,16,11,,12,,,,12,,39,123,37,,,,
     8,,,9,8,,,,,9,,,,53,,51,,51,,17,18,15,,17,18,,54,,52,,37,,52,,,,,9,,9,,
     ,,,21,20,43,20,44,,,,43],
   [,,,,10,24,11,,,11,,,,27,26,,26,63,,,65,,,,,9,10,9,23,10,,,10,10,,41,,37,
     ,,,23,50,24,23,21,,,,,23,60,,,55,57,51,,55,,9,9,8,,9,9,,63,58,59,,
     57,,57,7,,,9,26,10,,9,10,24,,,,53,,89,,,65],
   [8,,22,,8,,9,22,,9,20,25,58,22,25,,,82,,58,,,7,18,6,7,6,6,18,7,18,6,
     6,7,32,34,32,30,20,,81,18,,18,19,16,,20,,,19,,,44,46,44,42,44,46,7,
     7,8,7,7,7,8,52,54,48,50,52,50,52,50,8,22,9,,,,22,9,,,58,20,,,,,,,,
     58,,8],[,,,,10,,11,,,11,21,20,43,24,,,20,41,20,,43,44,,,,9,16,11,,
     12,,,16,12,117,39,,37,19,7,40,8,41,19,8,7,40,19,7,41,8,40,43,99,
     53,,51,,51,,17,18,15,,17,18,53,54,41,49,,39,53,52,,9,,,,,9,,,20,43,,,
     ,20,41,,,43,,8],[10,,24,,10,,11,24,,11,30,,65,27,26,,26,,,65,,63,8,
     19,7,9,8,7,19,8,19,7,7,8,43,41,43,37,24,,60,23,,,23,21,60,24,,60,
     23,86,60,,55,56,51,57,55,8,9,9,8,8,8,9,65,63,50,59,66,49,64,57,
     9,26,10,7,,,26,10,9,28,53,,24,,,51,,,,65,,9],
   [8,6,16,5,6,16,5,16,5,5,21,,55,15,19,,19,,,55,55,,7,17,6,6,7,7,17,
     6,17,6,7,6,31,25,31,25,18,7,45,7,45,18,7,7,45,18,7,45,7,45,45,
     41,35,41,35,41,35,7,8,7,7,7,8,7,49,43,47,43,49,41,49,43,9,10,10,
     9,10,10,10,10,10,19,55,21,19,55,,,,,55,55,8,8,7,8,8],
   [10,7,20,6,8,20,7,20,6,6,26,21,62,,23,,23,,,50,62,,8,21,7,7,8,9,21,
     8,21,7,8,7,38,,38,32,22,8,51,8,43,22,9,8,51,22,8,43,8,51,43,50,,
     50,44,50,,8,9,9,8,8,9,8,58,62,54,52,58,54,58,50,11,12,12,11,12,
     12,12,12,12,23,62,26,23,50,21,,,,62,50,9,9,8,9,9],
   [,,,,10,,11,,,11,,20,,19,20,,,44,20,43,,41,,,,9,,11,,12,,,16,12,,39,123,
     37,19,7,41,7,40,19,8,8,43,19,7,40,8,41,40,131,53,,51,,51,,17,18,
     15,,17,18,82,51,41,52,53,39,,49,,9,,,9,,,,,25,,,25,,,54,,,,,8,,,8,,8,
     9],[,,,,10,24,11,,,11,30,,,27,24,,28,51,,,53,89,,23,,9,10,9,,10,23,
     ,10,10,43,41,43,37,25,,50,23,86,24,23,21,50,,,60,23,,60,56,55,,51,
     57,55,7,8,8,8,7,8,8,64,63,58,59,65,57,64,57,9,,9,9,26,10,,,10,26,
     ,,26,65,,,,,65,,,8,8,,9,8,9],
   [10,,24,,10,,11,24,,11,,,65,27,,,24,89,33,53,,51,8,19,7,9,7,7,19,8,
     19,7,8,8,,41,,37,24,,,23,50,,23,21,,24,,,23,60,54,56,55,58,51,,55,
     8,8,9,8,8,9,9,64,63,,59,64,57,,57,9,26,10,9,,9,26,10,,26,65,29,
     26,,,63,,,,53,,9,,,8,8,9,,9],
   [10,7,20,6,8,20,6,20,6,7,26,26,50,,23,,23,,21,62,50,,8,21,7,7,8,9,
     21,7,21,7,8,8,38,,38,32,22,8,43,8,51,22,8,8,43,22,8,51,9,43,51,
     50,54,50,44,50,,8,9,8,8,8,9,9,58,,54,52,58,,58,50,11,12,12,11,12,
     12,12,12,12,23,62,26,23,62,,,,,62,62,9,9,8,9,9,,7,9,9,9],
   [34,,132,32,32,132,,,32,43,90,102,230,96,,,98,,102,,231,235,32,125,,29,
     33,28,,37,127,,33,,29,29,28,24,81,,214,66,211,81,125,66,,84,,232,83,
     242,,186,190,186,176,188,188,32,37,37,32,32,37,37,222,226,182,212,
     224,182,222,212,47,100,57,,,,138,59,61,98,231,90,,,102,,,,230,232,77,
     44,32,,,31,38,77,,44,38],
   [38,27,72,22,24,70,25,70,22,25,94,96,238,72,94,,94,234,100,,,234,34,
     78,27,27,38,30,77,30,77,27,,30,29,24,29,22,82,32,226,32,226,83,35,
     32,,84,32,206,35,210,208,186,160,188,158,184,160,34,37,37,34,34,37,
     37,218,192,188,190,222,160,216,188,43,49,51,44,49,50,48,50,51,92,
     242,94,,273,,,,,273,242,39,41,34,39,41,25,,39,41,41,,29],
   [34,,,,,158,43,112,,43,92,,200,92,96,,95,189,99,191,198,193,32,,30,27,
     33,28,,37,,30,34,,26,26,28,26,81,,173,66,192,82,125,70,,82,,209,125,
     194,192,186,186,186,176,188,190,32,37,37,32,32,37,37,214,214,166,204,
     216,172,216,204,,122,,44,,59,,,,96,194,92,94,198,96,190,,,194,195,,42,
     32,,42,31,38,,,42,38,29,29],
   [,,,,,18,,,,,,,,46,43,,43,80,,,69,72,,,,17,18,,17,,,,18,,,85,181,74,,,,40,
     69,40,,38,67,,,,,63,65,,112,175,102,,112,,17,,16,,17,,,92,68,90,,70,,
     86,,,,22,,23,,22,23,,,,46,,,103,,,,,,,19,,20,18,22,,19,20,22,151,85,203 
    ],[,,,,34,,38,,,64,,,,51,43,,43,,,,,69,,,,39,53,35,59,39,,,49,59,,226,
     199,201,,,,34,97,,46,34,,,,,42,,97,,,260,261,,,,60,46,44,,56,66,,47,,,,
     35,,44,,,,,49,136,49,66,,,,39,36,49,,34,,,37,49,37,,81,42,,,,42,,,79,
     279,283,205],[22,,,,,34,21,35,,21,18,19,38,18,19,,17,39,17,49,38,
     44,20,,16,17,18,16,36,,36,16,18,21,81,82,81,74,16,16,35,16,41,16,
     20,14,35,16,16,41,20,35,41,109,110,109,102,110,108,20,22,22,20,20,
     22,22,44,44,32,40,42,30,44,42,26,22,31,,,,22,31,,17,34,16,,,17,33,,,
     34,,19,24,18,,,18,22,19,24,25,22,81,82,81,,35],
   [,,,,,,,18,,,,,69,46,43,,43,79,49,76,,72,19,16,16,17,16,16,16,20,16,16,
     14,20,,85,185,74,,,61,40,67,40,,38,,40,,69,,65,67,171,112,,102,,112,
     17,17,21,15,17,15,21,125,92,70,90,96,70,128,94,22,,23,,,,,23,22,46,,,
     ,,50,113,,,,,,20,,,,18,22,,20,19,22,,85,,17],
   [,,,,70,83,41,66,,42,39,,67,51,,,34,,50,35,69,33,,,35,39,53,35,,59,59,
     35,53,39,247,,202,207,35,35,60,34,35,33,39,29,60,37,35,32,39,62,32,
     355,,259,,344,320,,60,46,44,,56,50,65,47,43,61,43,41,67,39,57,49,,,,,
     49,66,132,36,49,,,,38,48,,,49,37,42,55,,37,,,,42,,,,,237,205,,47],
   [22,17,15,14,16,15,15,14,14,15,20,,50,15,18,,18,,18,39,50,41,18,16,
     15,13,14,17,16,16,15,15,14,16,80,62,80,62,17,16,40,14,33,17,17,14,
     40,16,16,33,17,40,33,104,86,104,86,104,86,16,15,17,14,16,15,17,44,
     41,42,38,45,36,44,41,23,24,24,23,24,24,24,24,24,18,50,19,18,39,,,,,
     50,39,19,19,18,19,19,13,,19,19,19,,80,62,80,17,,17,17],[],
   [18,,,18,16,35,,34,18,21,20,19,38,16,17,,19,39,17,34,39,32,18,,,17,22,
     18,37,21,37,,21,21,81,83,82,74,16,16,35,14,31,16,20,16,35,16,16,
     31,20,35,31,109,110,110,102,109,110,18,22,22,18,18,22,22,43,40,32,
     40,42,30,40,38,,22,32,26,22,31,,,31,19,36,16,19,38,,38,,,38,36,19,,
     20,19,24,18,22,,,24,22,81,83,82,,35,16,,35,17],
   [,,,,,18,,18,,,,,,46,,,43,69,,94,,70,,,,17,18,,,,17,,18,,,85,,74,,,93,40,
     67,40,,38,61,40,,67,,,69,211,112,169,102,,113,16,15,20,16,16,15,20,
     124,94,72,84,94,68,,94,,,22,22,,23,,,23,,,,47,,,95,,,,,,19,19,,20,18,
     22,,,20,22,187,84,,16,,,17,,17],
   [18,15,12,12,12,12,15,12,12,15,16,17,38,15,15,,15,41,17,38,38,41,16,
     13,13,11,12,13,13,16,13,13,12,16,66,60,66,50,14,14,33,12,33,14,17,
     12,33,14,14,33,17,33,33,86,80,86,70,86,80,14,13,17,12,14,13,17,38,
     37,28,34,38,26,38,34,19,20,20,19,20,20,20,20,20,15,30,16,15,40,15,
     29,,,30,40,17,17,16,17,17,13,18,17,17,17,18,66,60,66,14,31,14,14,,
     13,,14,14],[],[,,,,,18,,18,,,,,,46,43,,,75,49,74,68,72,19,16,16,
     17,14,16,16,20,16,16,16,20,,84,,74,,,63,40,69,,,38,86,40,,65,,61,66,
     209,113,,102,213,113,17,15,21,15,17,17,21,,92,70,90,94,70,92,86,22,,
     23,,,22,,23,,47,,,,,50,109,,,,,,20,,,19,18,22,,20,,22,197,85,203,17,,,
     16,,17,,,17,14],[,,,,40,56,38,83,,54,,,,51,43,,43,,63,96,,69,,,49,
     39,46,37,,43,93,49,42,72,,,,205,,,,34,,38,40,34,,67,,97,46,,,312,,261,,
     ,,66,60,56,55,66,56,86,63,41,33,57,43,35,61,39,,,,57,49,,49,,,,37,
     39,36,49,,36,,,,49,37,,,42,55,,,42,103,,,254,265,205,,35,35,,44,,,35,,
     31],[92,45,,,70,,44,,,42,39,39,67,51,83,,34,96,50,35,67,39,81,,41,
     39,46,37,93,72,,41,46,41,277,249,,,35,35,60,34,32,33,39,29,62,37,
     35,32,39,60,35,349,280,262,261,,254,66,60,55,55,66,56,60,65,41,43,
     65,43,41,65,44,,49,136,,,,49,,,36,49,,,37,38,,,,49,,42,,,45,,,49,42,
     103,55,79,293,,205,,44,,,35,40,,35,,,,,47],
   [46,,130,,36,162,47,162,,,122,131,293,124,124,,128,292,131,306,293,290,44,
     ,39,39,45,38,,48,,39,46,49,186,186,186,168,109,90,266,82,268,109,,82,
     ,110,90,,101,268,266,37,37,36,32,36,34,44,51,51,44,44,51,51,294,
     294,242,276,294,238,296,276,60,120,71,,,,116,,71,125,295,122,,,138,296,,
     ,314,314,131,57,44,,,41,50,135,56,56,50,186,186,186,205,392,109,,,104,
     ,109,171,86,,175,308],
   [50,37,94,30,32,96,35,94,30,35,126,122,323,100,123,,126,274,122,323,
     304,270,46,103,37,37,,39,104,42,104,37,50,42,190,160,186,154,110,44,
     258,44,264,110,49,44,260,111,44,,49,,260,37,32,37,30,34,32,46,51,51,
     46,46,51,51,290,260,242,254,292,212,288,254,57,64,67,57,65,67,65,66,
     66,122,296,126,122,,,,,,294,303,53,55,46,53,55,35,,53,55,55,50,190,
     160,186,112,308,110,112,293,86,,110,112,80,,112,293,308,37],
   [46,43,,40,40,,47,156,40,,124,124,254,126,126,,124,246,,256,251,245,44,
     151,39,39,45,38,176,50,,39,45,49,186,188,186,168,109,,228,78,,110,97,
     78,244,109,,,97,241,228,34,34,36,34,36,34,44,51,51,44,44,51,51,286,
     286,222,268,286,224,288,268,59,110,73,,138,71,,,77,124,251,124,126,
     256,124,246,,,254,262,,57,44,97,,41,50,,,57,50,186,188,186,,262,109,
     169,261,104,,110,,86,,175,259,260,37,37],
   [42,35,84,28,28,84,35,84,28,35,120,113,278,100,117,,114,244,,264,264,
     254,42,96,35,35,42,35,96,42,95,35,42,42,176,158,176,140,102,42,241,
     42,238,102,49,42,242,102,42,242,49,,246,34,30,32,28,34,30,42,49,49,
     42,42,49,49,268,250,220,232,268,202,268,232,55,60,60,53,60,60,60,60,
     60,,276,120,114,280,113,,,,280,276,51,51,42,51,51,35,44,51,51,51,44,
     176,158,176,102,257,102,102,261,86,,102,102,70,,102,265,265,34,31,34],
   [46,47,134,,,,53,174,,47,124,131,301,120,125,,128,,,310,285,294,44,,39,
     39,45,38,194,,150,39,46,48,188,184,188,168,110,126,292,78,269,109,
     101,82,298,109,126,268,,273,,37,34,36,32,36,37,44,51,51,44,44,51,51,
     294,290,242,276,294,242,296,276,58,,75,60,112,,112,71,,126,290,124,
     125,291,136,298,,,,316,,56,44,,57,41,50,,,,50,188,184,188,205,316,110,,
     ,104,,109,213,86,,,,345,34,37,37,34],
   [8,,18,,8,,9,18,,9,20,24,42,22,21,,21,40,,44,,42,7,16,6,7,6,6,16,7,
     16,6,6,7,32,34,32,30,20,,39,18,,18,19,16,39,20,,41,19,41,41,44,46,
     44,42,44,46,7,7,8,7,7,7,8,50,52,38,48,50,40,50,48,8,22,9,,,,22,
     9,8,23,44,20,,,23,42,,,,42,,8,6,,,7,8,,8,7,8,32,34,32,17,56,18,,,
     16,,20,17,14,,16,43,43,44,46,44,42,44],
   [8,6,16,5,6,16,5,16,5,5,21,,49,15,19,,19,,21,49,49,,7,17,6,6,7,7,
     17,6,17,6,7,6,31,25,31,25,18,7,41,7,41,18,7,7,41,18,7,41,7,41,
     41,41,35,41,35,41,35,7,8,7,7,7,8,7,47,41,43,41,47,37,47,41,9,10,
     10,9,10,10,10,10,10,19,49,21,19,49,,,,,49,49,8,8,7,8,8,5,,8,8,8,
     6,31,25,31,18,63,18,18,,13,,18,18,13,,18,,63,41,35,41,35,41,7],
   [6,,,,8,18,9,,,9,20,23,,22,,,23,42,23,,44,40,6,17,,7,8,7,,8,17,,8,8,
     32,34,32,30,18,,41,18,41,20,19,16,41,18,,39,19,,39,44,46,44,42,44,
     46,6,7,7,6,6,7,7,50,52,38,48,50,40,50,48,7,,8,8,22,9,,,9,21,,20,
     21,44,24,40,,,42,44,,7,7,,8,7,8,,,8,8,32,34,32,16,43,20,17,43,16,,
     18,,14,,17,,56,44,46,44,42,44,7,7]],
 [,[],[],[],[,9],[,,21],[,10],[,,21,,,21],[,,,,10,,11],
   [,10,,,,,11,,11],[24,,,,41,,,38],[,24,,,32,39,32,41,33,36],
   [,,57,,88,,117,64],[24,41,,,34,63,,63,35,45,24,30],
   [,,53,,37,,42,47,37,,27,27,56],[80,,76,,62,,57,63,,81,,47,60],
   [32,,,,35,,40,61,,40,,25,,30,29],
   [80,91,85,,,125,63,62,82,103,,,46,,55,62],
   [32,38,46,,32,42,35,,,35,27,25,56,,28,,24],
   [,,82,,74,,,61,,,48,50,60,,,44,56,62],[],
   [80,51,78,,60,93,,65,86,71,48,44,60,,,44,53,63,,44],
   [8,,,,10,30,11,,,11,23,,,23,,55,26,63,28,,,51],
   [,,,,,20,,20,,,,,,,49,72,,67,42,86,,68],
   [,7,,,8,20,9,,8,9,,21,,31,30,47,33,60,23,51,,40],
   [8,,22,,10,22,11,,10,11,23,28,51,23,,,,57,27,59,,59,7,21],
   [10,7,20,,8,16,9,20,8,9,21,21,42,,,,26,40,22,64,,58,8,18,6],
   [8,7,,,,,,,8,,22,23,44,22,26,42,24,44,24,44,,44,8,,6,8,6],
   [,,20,,,,,22,,,,47,,,,104,51,103,44,,,87,,19,,,18],
   [10,8,,,8,,,36,9,9,27,25,52,26,31,51,28,47,26,55,,47,9,,7,9,7],
   [,,22,,,20,,,,,40,41,64,,41,58,54,68,,,,67,,16,,21,18,,19],
   [,,,,8,24,9,,,9,21,22,42,26,,,24,40,22,,,50,,,6,8,6,6,,7],
   [,7,,,8,20,9,,8,9,,21,,31,30,47,33,60,23,51,,40,,,6,,6,6,,7,,6],
   [,8,36,,10,,9,,9,,,28,68,26,31,47,30,67,26,47,,41,9,,7,9,7,,,7,,7,7]
    ,[40,,,,,184,57,,,,108,,,114,135,,,309,,,,314,37,,,37,33,34,128,,,,,39],
   [40,,,,,104,61,,51,,112,,,114,,,137,,145,342,,296,37,114,,37,,36,114,,,37,,
     40,36],[40,,,,,,,206,55,57,110,129,254,112,,237,136,281,,258,,261,37,
     252,34,37,34,34,,,178,33,34,41,36,36],
   [40,,104,,44,,49,106,,49,106,,284,114,,302,,,126,294,,,35,88,30,35,30,30,
     89,35,89,30,30,35,33,36,33],
   [24,,,,31,31,33,35,31,,20,,,23,26,39,25,56,25,41,,41,22,,,22,21,22,34,
     23,36,21,,,106,108,106,104],[],
   [,,,,89,85,82,89,89,,,,,63,72,71,,65,,77,,73,,82,,,54,52,79,63,76,52,,,,
     442,372,392],[24,31,,,26,36,27,34,26,27,21,27,43,22,,,25,45,25,68,,
     ,19,,23,17,,20,,21,35,20,23,21,94,88,94,86,21,,57],
   [64,57,79,,66,58,66,87,,74,47,51,63,,,,52,62,,44,,46,52,69,45,,,39,65,
     50,57,63,45,46,363,,224,279,43,,69],
   [24,23,41,,,,,35,28,33,22,21,46,22,,46,22,48,22,46,,46,22,38,18,22,18,
     18,,,34,18,18,23,98,104,98,90,21,,62,21,46],
   [,22,,,,,,,25,25,,44,,,57,102,48,81,52,,,,23,,17,21,17,,,,,19,17,19,197,
     133,,93,,,,20],[24,19,38,,22,28,23,38,22,23,22,21,62,23,23,43,,,,45,
     ,46,19,38,14,17,14,16,36,17,38,16,14,17,87,86,86,74,21,,,17,,18,17 
    ],[],[24,32,37,,28,31,35,,,33,21,27,47,22,26,72,27,53,,,,76,22,36,
     23,22,21,22,35,23,,,23,23,104,108,106,104,21,,65,21,,21,,21],
   [,,,,24,,25,,,25,,,,59,53,,46,78,,,,88,,,16,20,16,18,,19,,,16,19,,99,175,,
     ,,,19,,,19,16],[64,63,110,,65,63,64,,,72,44,50,72,,,43,53,79,,,,45,
     49,91,45,69,,40,63,51,56,,45,47,,420,286,362,40,,72,,41,,,45],
   [,22,,,,,25,,25,,,44,,63,57,102,48,137,51,,,91,23,,17,21,17,,,19,,19,17,,
     ,136,145,93,,,,20,,,19,17,,,19],
   [,,,,74,68,67,91,74,,,,46,50,55,60,,48,,61,,62,,,,,48,43,91,54,94,43,,,
     342,,316,328,,,62,45,56,46,,,,65,,72],
   [64,51,111,,65,57,64,77,,72,47,48,73,,,45,54,,,46,,,50,93,43,,,40,62,
     50,68,66,43,46,300,311,,342,43,,71,,44,62,,45,,,,41,,69],
   [56,,,,65,162,,,69,83,148,,,158,181,353,171,370,,386,,344,51,,,51,45,46,
     202,53,165,45,,55,236,248,236,224,146,,,126,,134,179,114,,144,175,363,
     239,,369],[56,62,,,68,140,,164,66,,152,174,,158,,,181,398,188,362,,
     348,51,150,50,51,,50,142,54,146,49,50,57,244,250,244,238,148,,522,120,
     ,142,159,114,,148,130,378,,424,362,48],
   [56,,198,,,,,,73,81,150,163,320,156,187,305,,,174,314,,307,51,164,,51,45,
     46,,,162,45,,54,236,246,236,226,146,,427,126,331,134,,115,,146,169,339,
     225,321,345,48,48],
   [56,,140,,62,,67,140,,67,146,158,352,158,177,,,,167,352,,342,49,121,42,
     49,42,42,120,49,121,42,42,49,230,246,228,210,144,,472,118,347,126,
     127,102,,144,208,395,127,,,45,48,45],
   [56,60,186,,64,158,77,,,81,146,,378,158,188,345,,374,,,,,51,196,46,51,45,
     46,,53,,,46,55,238,244,238,224,144,,466,126,339,134,240,114,,146,,,225,
     410,363,45,48,48,45],
   [56,,,,,134,76,,66,,150,,,158,,304,174,320,174,320,,308,51,,,51,,50,142,
     53,163,48,,54,242,250,244,238,148,,,120,297,142,161,114,,148,131,302,
     160,,302,48,48,48,48,48],
   [8,,,,10,22,11,22,10,11,23,,,23,28,43,25,51,27,,,45,7,,,7,8,8,20,9,,8,
     ,9,37,37,37,35,22,,,17,47,22,21,17,,22,20,45,21,66,45,51,51,51,49,
     51,51],[8,11,18,,10,18,11,18,10,11,23,27,49,23,,,,53,26,51,,51,7,
     17,9,7,,8,16,9,17,8,9,9,37,37,37,35,22,,,17,,22,21,17,,22,20,61,
     21,90,59,51,51,51,49,51,51,7],
   [8,12,,,,,,24,11,11,24,31,48,24,31,46,30,48,30,48,,48,8,34,10,8,9,8,,
     ,34,9,10,9,40,40,40,40,24,,62,20,50,24,,20,,24,23,50,23,61,50,56,
     56,56,56,56,56,8,8],
   [8,11,18,,10,18,11,18,10,11,23,27,53,23,28,51,,,26,57,,51,7,18,9,7,
     8,8,18,9,18,8,9,9,37,37,37,35,22,,86,17,,22,21,17,,22,20,50,21,
     66,61,51,51,51,49,51,51,7,7,8],
   [8,,26,,10,26,11,,,11,23,29,,23,26,51,28,51,,,,51,7,,9,7,8,8,20,9,,,
     9,9,37,37,37,35,22,,60,19,58,22,23,19,,22,,,23,58,60,51,51,51,49,
     51,51,7,7,8,7],[8,,,,10,22,11,22,10,11,23,,,23,28,43,25,51,27,,,
     45,7,,,7,8,8,20,9,,8,,9,37,37,37,35,22,,,17,47,22,21,17,,22,20,45,
     21,66,45,51,51,51,49,51,51,7,7,8,7,7],
   [8,12,28,,12,24,11,28,11,,24,34,56,24,,54,30,54,30,56,,52,8,34,10,8,
     9,8,,9,34,9,10,,40,40,40,40,24,,92,20,54,24,23,20,,24,23,54,,,54,
     56,56,56,56,56,56,8,8,8,8,8,8],
   [72,,,,79,89,81,90,,91,52,,,68,69,79,68,78,67,92,,82,61,,,61,53,50,,61,
     87,53,,,276,292,260,260,52,,,57,84,49,131,49,,57,91,88,,76,87,372,
     388,356,356,372,370,57,59,60,59,59,57,64],
   [72,73,88,,78,93,84,97,80,89,64,67,86,58,,,70,86,67,80,,74,61,,56,61,,
     54,100,61,82,53,56,62,284,294,268,274,59,,101,54,,52,107,55,,54,100,
     81,92,89,80,384,394,368,374,384,378,57,59,60,59,59,57,64,60],
   [56,68,62,,,,,68,71,71,56,55,76,58,64,74,58,82,58,82,,80,47,60,41,47,
     41,38,,,64,41,41,47,228,238,208,216,46,,96,46,77,38,,45,,50,,85,69,
     82,106,296,304,276,284,296,280,43,45,44,45,45,43,48,52,52],
   [72,,101,,74,,73,90,86,81,56,62,78,68,66,79,,,65,88,,87,59,80,48,59,
     50,46,91,57,84,50,48,53,270,290,252,246,54,,92,57,83,46,97,46,,57,
     88,88,97,77,90,360,382,346,338,360,366,55,57,60,57,57,55,64,49,60,
     49],[72,72,88,,78,,92,,,,61,64,90,58,70,71,67,86,,,,74,61,86,52,61,
     49,50,83,61,,,52,61,278,288,262,264,57,,107,54,74,49,135,53,,52,,,92,
     85,78,372,386,356,358,372,372,57,59,60,59,59,57,64,57,52,52,57],
   [56,,,,55,62,66,68,70,73,56,,,58,65,78,62,80,62,80,,74,47,,,47,44,40,
     59,44,65,44,,47,236,242,214,230,46,,,46,80,40,92,48,,50,62,82,92,80,
     80,308,310,286,302,308,286,43,45,44,45,45,43,48,52,52,40,52,52],
   [72,70,91,,79,84,81,88,83,,56,70,78,68,69,86,66,75,67,88,,79,61,115,
     52,61,54,50,,61,87,53,52,,276,290,258,260,54,,95,59,88,49,131,49,,
     59,90,91,,,89,374,384,358,356,374,368,57,59,60,59,59,57,64,52,60,49,
     49,60,52],[72,61,86,,70,88,75,89,74,81,61,59,86,58,74,71,,99,65,
     82,,,59,84,48,59,46,46,80,57,84,46,48,57,268,286,254,246,57,,100,52,
     74,46,96,50,,54,89,82,87,84,,362,382,344,338,360,362,55,57,60,57,57,
     55,64,57,52,49,54,49,52,57],
   [,,,,,,,,,,,,,34,35,54,33,,35,73,,54,,,,9,10,,,,,,,,,52,,44,,,,29,51,28,,28,
     ,28,,53,,,51,,,64,60,,,,9,12,10,,,12,,79,62,66,78,,,70],
   [,,,,,,,,,,,,,63,69,,52,99,,,,137,,,,22,21,,,,,,,28,,,,106,,,,21,,,,21,,,,,,,,,
     154,,142,186,,,22,,22,28,,28,,89,,103,95,,,89],
   [,,,,,,,,,,,,,45,,77,41,80,40,,,87,,,,11,12,,,,,,,,,61,63,49,,,,37,64,33,,
     31,,33,,69,,,67,,79,,67,75,,,11,,11,,,,,89,71,81,,,91,81],
   [,,,,,,,,,,,,,41,,75,38,,29,,,,8,21,7,9,8,7,21,11,21,7,7,11,57,53,,,,,
     98,25,70,,,33,,32,,,,84,95,,,68,,67,,8,9,12,8,8,8,12,78,74,62,79,
     79,56,78,61,9,,10],
   [,,,,,,,,,,33,42,70,63,,,39,74,39,81,,71,32,,16,22,18,,,,,24,16,,142,104,
     194,,31,,76,21,49,34,22,16,,31,24,65,22,61,55,160,136,170,142,,134,
     20,22,,20,28,20,24,75,81,59,72,85,56,75,88,,21],
   [,,,,,,,,,,,34,,35,40,80,,124,,,,,9,24,8,11,10,8,24,10,24,8,8,10,57,50,,
     ,31,,118,30,,28,,,,,,,,70,,69,66,71,68,,66,9,11,11,9,9,9,11,83,80,
     71,86,,70,,74,10,,11],
   [,,,,,,,,,,,42,61,,41,70,,63,58,64,,64,,,,,24,,,28,,,,,,126,,104,35,,82,20,
     68,35,22,21,,37,22,66,26,82,66,,152,244,140,176,,20,20,24,22,,20,28,
     ,96,68,101,90,68,95,86,,21,,,21],
   [,,,,,,,,,,,48,75,,34,,36,66,40,82,,65,,,,,12,,,,,,,,63,,79,49,33,,78,,60,,
     ,31,,35,,66,,,,81,81,83,67,86,76,9,9,11,11,9,9,11,87,84,,73,92,67,
     87,75,,,11,10,,11],[],
   [,,,,34,36,39,47,34,,,,,26,31,46,,,,48,,54,,,,,24,23,44,28,43,23,,,,150,,,
     ,,,24,,24,,,,24,,47,,,50,,184,162,,,,,33,32,,28,,34,,68,61,,66,,64,66,
     31,,,28,31,31],[,,,,63,65,88,76,,,,,,,64,86,,,74,92,,86,,,,59,49,44,,
     47,86,50,,68,,,244,324,,,,51,99,44,127,68,,57,71,96,,,93,,362,314,370,
     362,,,51,48,57,,,56,,,44,,60,,,60,,57,,,58],
   [24,,,,,33,,,,,24,29,64,24,29,64,24,68,24,68,,,23,,23,23,22,22,38,,,23,
     23,29,108,112,110,106,23,,77,23,77,20,43,21,,21,42,,47,77,77,148,
     152,150,146,146,150,23,23,24,23,23,23,24,64,64,42,61,61,44,61,61,
     41,38,,,,,,,,27,48],
   [32,,,,,39,42,,,42,27,,74,26,27,79,28,,26,66,,,28,49,,,24,23,39,32,41,
     23,,28,140,134,,122,25,,73,24,63,21,46,21,,23,39,,46,58,80,172,,,162,
     174,169,27,27,30,28,26,27,30,63,68,43,59,68,45,62,66,32,42,34,24,,,
     52,32,,24,68],[],
   [32,24,52,,32,,32,42,,34,,,,26,30,,,,30,53,,51,28,45,21,27,21,23,,25,
     41,22,21,27,135,,124,122,24,,73,23,44,24,44,21,,23,40,46,41,60,46,
     173,170,163,,164,169,27,26,30,26,29,27,30,67,68,63,,68,62,63,66,,,42,
     ,39,,,42,,24,,27,24],
   [80,83,,,54,61,,78,86,71,,,,68,61,86,,,,94,,109,51,87,50,59,42,44,67,
     43,68,42,50,53,285,324,,298,56,,,49,,41,,,,57,70,92,65,,94,,376,310,
     352,365,306,45,51,48,51,51,45,52,71,56,44,71,54,42,76,52,,,87,,62,,,
     59,,,44,48],[,28,,,31,31,,,31,,27,31,66,26,26,80,29,60,27,85,,64,
     27,47,21,25,21,23,37,26,,22,21,28,,,,,26,,73,23,95,21,50,21,,24,40,
     76,52,54,,167,,163,162,164,,25,25,31,25,26,25,34,65,68,41,59,66,43,
     62,66,34,47,,,36,34,,39,,24,50,,24,,24,47],
   [80,,,,,62,59,,,87,48,50,,68,103,42,52,88,72,48,,42,57,96,,,48,44,,85,
     62,50,,47,,298,245,298,41,,87,55,41,44,77,41,,57,,47,73,93,43,341,
     348,,346,357,306,45,,46,51,51,45,52,88,56,54,87,60,56,83,52,54,78,
     71,83,61,86,,,,47,60,,,,,60],[],
   [,,,,,58,,57,,,48,,108,,73,44,55,86,74,46,,48,,,90,51,47,44,64,68,96,
     48,90,47,322,,,324,41,,100,,43,46,79,43,,57,74,45,103,102,50,374,362,
     316,362,372,,47,49,46,49,49,47,56,86,58,56,88,56,58,86,60,63,76,,,
     65,,,88,,50,60,,,,68,60,,44],
   [,,,,27,,28,,,28,,,,,63,,49,89,,,,101,,,,,19,21,,22,,,,22,,139,,145,,,,,,,
     22,19,,,,,22,,,,173,222,,,,,31,34,33,,,34,,135,,127,,,,81,,,,,23,,22,,,,,
     39,37,,36,69,,,,73],
   [,,,,12,32,13,,,13,,,,31,32,54,29,74,33,70,,50,,,,9,10,10,26,11,,,,11,,
     47,,42,,,,27,49,26,27,24,,27,,53,27,101,50,,,61,58,61,,,9,10,9,,,10,,
     72,55,64,71,,,66,8,,,9,34,10,,10,,31,,32,30,,,72,30,52,,59],
   [8,,22,,8,,9,22,,9,20,25,58,22,25,,,82,,58,,,7,18,6,7,6,6,18,7,18,6,
     6,7,32,34,32,30,20,,81,18,,18,19,16,,20,,,19,,,44,46,44,42,44,46,7,
     7,8,7,7,7,8,52,54,48,50,52,50,52,50,8,22,9,,,,22,9,,,58,20,,,,,,,,
     58,,8],[],[10,,28,,10,,11,28,,11,28,27,53,27,,63,29,53,29,63,,,8,
     21,7,9,8,7,21,8,21,7,7,8,43,41,40,,24,,78,23,60,,23,28,,24,,,23,
     52,77,56,55,54,,55,55,8,9,9,8,8,8,9,66,65,46,70,65,47,65,59,9,
     26,10,7,,,26,10,,26,49,,24,,27,56,27,77,,67,,9],
   [8,9,,,9,22,,22,11,11,23,30,61,23,28,57,27,,,51,,,8,20,7,8,7,8,20,7,
     20,7,7,7,37,37,37,35,22,,66,19,51,22,,17,,22,21,51,21,51,51,51,51,
     51,49,51,51,8,8,8,8,8,8,8,61,61,47,59,61,47,61,59,10,,11,,22,10,
     22,11,,25,51,23,27,,,,,59,,59,21,9,7,,8],
   [10,10,,,10,26,10,24,12,10,28,29,94,36,32,52,31,,32,55,,99,9,24,8,9,
     8,10,24,9,24,8,8,8,44,,50,42,26,,78,20,55,26,22,18,,28,22,53,20,
     63,53,60,63,62,58,,65,9,9,10,9,9,9,9,66,73,56,64,73,57,66,66,12,,
     13,,24,12,24,13,,29,82,28,,,29,,39,54,,,22,10,8,,9],
   [,,,,27,,28,,,28,,34,,39,38,,,59,57,65,,61,,,,,21,21,,22,,,,22,,173,,,34,,
     82,19,59,32,20,19,,36,21,63,20,61,63,198,,,,202,183,,31,34,33,,,34,
     89,87,65,123,85,67,,79,,22,,,23,,,,,,,,43,,,101,50,,,,19,,,,,21,22],
   [,,,,12,32,13,,,13,30,38,59,32,29,,32,60,,,,72,,26,,,10,10,,11,26,,,11,
     45,47,,42,27,,73,27,71,26,27,24,,,,61,27,,65,61,62,62,58,63,,8,8,9,
     9,8,8,9,71,68,62,68,68,62,71,62,10,,10,9,36,10,,,,,76,29,27,,34,
     66,30,77,,64,,9,8,,9,9,10],[],
   [,10,24,,8,26,10,,12,10,,27,,,32,,32,,30,64,,,9,24,8,9,8,10,24,8,24,
     8,8,9,48,52,44,42,,,69,20,59,26,20,18,,26,22,57,22,53,57,62,66,60,
     58,60,63,9,9,9,9,9,9,10,72,,60,68,66,63,,62,12,24,13,,24,12,,13,,
     29,,31,33,,29,70,36,54,,73,22,10,8,,9,,9,22,10],
   [40,,,,,172,,,57,69,108,,300,114,,293,133,,134,,,285,37,135,34,37,33,34,,
     40,135,,34,,36,36,34,32,106,,370,94,350,98,197,87,,104,,299,159,377,,
     236,244,236,230,238,242,37,37,40,37,37,37,40,276,284,228,270,278,236,
     276,268,55,158,63,,,,188,57,,131,292,108,,,127,,137,273,,296,,49,32,,,
     37,44],[40,,126,,50,,61,,50,,112,137,304,114,,292,148,352,144,,,324,
     37,124,,37,38,36,114,39,114,37,,40,36,38,36,34,108,,645,88,375,104,
     136,86,,108,99,321,,462,311,248,250,246,246,244,250,37,37,40,37,37,
     37,40,292,294,238,290,288,242,290,286,50,,,,,50,126,61,,145,,112,,,,,
     145,,,,173,47,34,,41,37,,139,48,,,36],
   [40,,,,,194,79,,,63,110,139,282,112,,,142,,133,244,,,37,128,,37,33,34,,,,
     33,,,33,36,34,33,106,,352,94,,98,,86,,106,135,,203,323,452,236,244,
     236,228,238,244,37,37,40,37,37,37,40,260,268,208,252,262,214,258,254,
     ,206,57,,,55,,,,,,110,124,,,245,,,,244,228,45,32,,40,37,51,,,,44,36,36]
    ,[,,,,,22,,22,,,,,,,50,75,,87,46,103,,77,,,,21,20,,20,,18,,,,,,145,93,,,,
     ,74,42,,41,,40,,98,,,99,,167,181,127,179,,,19,,19,,,,,97,67,97,93,,98,
     91,,,,22,,25,,25,,,,,49,,50,92,51,91,,,,,19,,22,21,25,,22,,25,159,136,
     195],[,,,,57,57,62,91,74,88,,,,84,61,95,61,,61,102,,78,,,,68,45,43,
     83,47,91,46,,78,,395,267,298,,,,67,109,41,76,49,,71,66,110,78,,102,,,
     323,346,413,,,59,61,61,61,,92,,72,44,,69,,,53,,,,,60,72,76,118,,,,67,,,
     ,44,51,62,,60,54,,81,,49,71,117,66,94,,70,401,662,254],
   [24,25,,,,30,33,35,,33,21,27,53,23,27,51,22,53,22,53,,,22,,18,22,18,
     18,36,,34,18,18,23,98,106,98,90,21,,60,21,47,18,40,18,,20,38,,40,
     47,60,134,142,134,126,134,140,22,22,24,22,22,22,24,53,55,40,50,52,
     42,52,50,28,37,33,,,,35,33,,21,47,20,,,21,45,21,66,,,36,26,18,,,22,
     26,34,26,,26,98,106,98,,65],
   [,,,,,24,,22,,,,,71,42,51,72,42,65,44,74,,,21,18,18,21,18,18,18,22,18,
     18,18,22,149,99,175,,,,,40,69,38,,,,38,,,,66,95,179,130,,208,213,130,
     19,19,23,17,19,19,23,91,90,66,130,88,66,122,88,24,,25,,,,,25,,47,,,,,
     43,,47,88,,,,22,,,,20,24,,22,,24,,99,,19],
   [64,58,,,98,55,,71,,63,47,47,92,84,,47,50,95,84,45,,43,52,,41,51,42,
     40,66,59,58,42,41,44,300,311,,302,43,,85,71,43,,100,41,,67,95,40,99,
     87,40,366,,353,,385,302,47,48,50,48,,47,54,87,72,65,86,63,68,91,62,
     57,106,72,,,,73,64,,47,70,,,,48,71,,45,,46,103,55,,,,,55,62,59,,58,,
     311,344,,72],[24,25,21,,,21,,20,30,37,22,,66,23,27,43,25,,25,43,,
     41,21,19,18,19,16,20,19,19,18,18,18,19,94,88,94,86,21,,67,22,41,21,
     ,20,,22,40,43,43,54,43,126,120,126,118,126,120,19,17,20,17,19,19,
     20,54,59,46,52,59,46,54,57,26,,27,,36,26,34,27,,24,60,23,,,,,26,45,,
     45,37,22,18,,21,17,,35,22,,28,94,88,94,20,,21,19,45],
   [,96,,,,53,,72,85,,,,,82,61,78,61,,61,102,,95,67,,41,51,43,43,61,56,67,
     44,41,,328,462,316,,,,,50,79,41,,47,,54,66,85,,,87,403,410,320,,,404,
     47,49,62,49,50,47,,76,55,44,77,53,43,82,51,,,,,70,74,93,71,,,49,,79,,
     ,,51,62,,63,65,73,,,48,,,69,64,,101,377,,316,,44,,,69],
   [24,30,,,28,31,,37,31,33,22,25,48,24,25,42,25,48,25,44,,42,22,,22,22,
     22,20,35,23,36,,22,23,106,108,104,104,21,,65,22,41,20,42,21,,22,38,
     43,40,,43,146,148,144,144,146,148,22,22,24,22,22,22,24,54,56,40,54,
     54,42,54,52,28,37,33,30,31,31,,,,,46,22,26,,26,44,,44,,46,36,27,20,,
     24,22,28,,,,26,106,108,104,,44,21,,,21,45],
   [,,,,,22,,26,,,,,116,47,48,,45,72,46,79,,73,,,,,20,,19,,20,,,,,136,,93,,,
     143,43,76,42,,41,,42,,100,,,100,179,159,191,127,,188,19,17,23,19,19,
     19,23,131,97,71,87,97,71,,95,,,25,22,,25,,,,,,,48,,50,94,51,,,,,22,19,
     ,22,21,25,,,,25,197,133,,19,,,19,,20],
   [24,33,21,,28,16,31,21,,31,21,25,47,23,23,54,23,49,25,53,,51,19,16,
     16,17,14,16,16,19,16,16,16,19,87,86,86,74,21,,60,20,49,18,41,18,,
     21,,60,41,43,,114,114,115,102,114,114,17,15,20,15,17,17,20,53,55,38,
     50,53,40,52,50,22,38,23,19,28,22,38,23,,21,43,22,21,,21,41,,,,68,,
     20,16,,19,17,22,,20,,22,87,86,86,17,45,18,16,,17,45,21,17],
   [64,56,,,,57,70,64,,69,44,50,95,82,90,43,52,,,50,,43,51,,41,51,42,40,
     62,,58,42,41,44,,321,286,283,40,,81,67,42,59,100,41,,71,,40,98,85,
     40,415,,341,395,358,302,47,48,50,48,50,47,54,88,65,65,90,69,66,91,
     62,57,113,72,,65,,69,64,,47,75,,,,48,72,,,,45,,53,,,76,69,57,70,57,,
     65,299,420,271,,69,,,41,,72,45],[],[],
   [64,46,,,95,53,60,67,,64,47,44,84,,,41,48,123,66,43,,44,52,,39,51,41,
     39,63,59,65,42,39,43,301,375,224,,43,,92,,40,43,76,39,,54,69,42,74,
     79,43,354,363,297,347,,297,47,48,50,48,61,47,54,84,55,53,85,53,55,
     86,53,58,79,74,,,,,66,,45,60,,,,47,58,,46,,,68,56,,,,,74,58,60,,56,350,
     ,224,,53,,,44,57,56,44,,,41],
   [56,64,176,,65,208,75,212,,,148,173,356,158,181,,180,375,175,374,,341,51,
     165,47,51,45,46,202,53,,45,47,55,236,248,236,224,146,,456,126,345,134,
     ,114,,144,173,,187,395,370,48,48,46,44,46,48,51,51,56,51,51,51,56,
     372,384,296,360,372,308,374,362,69,166,77,,,,174,,,166,362,148,,,168,
     341,167,344,,386,198,63,44,,,51,60,,61,,62,236,248,236,185,417,134,,,
     126,,146,185,114,364],
   [56,67,,,66,136,76,,67,79,152,176,394,158,194,348,191,378,181,,,356,51,
     146,54,51,,50,147,53,164,48,54,53,244,250,244,238,148,,,120,395,142,
     159,114,,148,130,,169,,364,48,50,48,46,48,50,51,51,56,51,51,51,56,
     388,394,304,382,386,310,384,382,66,,82,,136,67,152,75,,179,392,152,171,
     ,,,178,354,,368,,63,46,,55,51,,199,62,,64,244,250,244,169,406,142,130,
     364,120,,148,159,114,,,,395,48],
   [56,,,,68,,77,,67,,150,163,314,156,187,309,174,329,174,324,,305,51,162,
     46,51,45,46,201,55,210,45,46,54,236,246,236,226,146,,431,126,297,134,
     191,115,,146,,341,181,320,353,45,48,46,45,46,48,51,51,56,51,51,51,
     56,356,368,276,346,356,286,358,344,64,186,75,,232,67,,,,,312,150,166,,
     162,307,162,307,,320,,61,44,,,51,62,,,,60,236,246,236,225,323,134,169,
     345,126,321,144,,115,339,,,331,48,48],
   [56,57,140,,62,158,67,142,74,67,146,158,354,158,184,336,167,388,,364,,
     340,49,121,42,49,42,42,121,49,120,42,42,49,230,246,228,210,144,,478,
     118,,126,127,102,,144,168,351,127,,389,45,46,44,42,45,46,49,49,56,49,
     49,49,56,356,374,284,338,358,302,356,338,62,142,67,57,158,74,140,67,,
     ,396,146,159,,159,,,,,396,,58,42,,55,49,58,201,58,,58,230,246,228,127,
     348,126,176,354,118,376,144,127,102,,,,363,45,48,45],
   [56,67,176,,,,86,186,,75,146,175,362,158,186,343,172,,170,380,,355,51,,
     47,51,45,46,195,,162,45,47,53,238,244,238,224,144,,487,126,339,134,
     187,114,,146,203,359,,405,,48,48,46,44,46,48,51,51,56,51,51,51,56,
     372,384,296,360,372,308,374,360,64,,81,60,158,,186,77,,164,372,146,164,
     ,174,357,,365,,362,202,61,44,,54,51,62,,62,,60,238,244,238,179,398,
     134,167,401,126,413,146,235,114,357,,,338,45,48,48,45],
   [8,7,22,,8,,9,22,8,9,20,21,52,22,24,50,24,68,,52,,,7,18,6,7,6,6,18,
     7,18,6,6,7,32,34,32,30,20,,70,16,,18,17,14,,20,16,,17,,66,44,46,
     44,42,44,46,7,7,8,7,7,7,8,50,52,44,48,50,46,50,48,8,18,9,,,,18,9,
     ,,52,20,,,21,,21,50,,52,17,8,6,,,7,8,17,8,,8,32,34,32,19,47,18,,,
     18,47,20,19,16,62,,,47,44,46,44,42,44],
   [8,8,,,8,20,,20,9,9,23,26,51,23,28,45,27,49,29,45,,,8,20,7,8,7,8,
     20,7,20,7,7,7,37,37,37,35,22,,62,19,47,22,,17,,22,19,47,19,47,47,
     51,51,51,49,51,51,8,8,8,8,8,8,8,57,57,43,55,57,43,57,55,10,,11,,
     22,10,22,11,,25,45,23,27,,,,,51,,51,20,9,7,,8,7,,20,9,,8,37,37,37,
     21,48,22,20,,17,,22,21,17,48,,,61,51,51,51,49,51,7],
   [8,,22,,10,22,11,,10,11,23,28,45,23,32,,29,49,27,51,,51,7,20,,7,8,8,,
     9,20,8,,9,37,37,37,35,22,,62,17,61,22,21,17,,22,20,48,21,,,51,51,
     51,49,51,51,7,7,8,7,7,7,8,57,57,43,55,57,43,57,55,8,20,9,8,20,9,
     ,,,,51,23,,,27,51,25,,,45,,8,7,,8,8,9,,,,9,37,37,37,19,62,22,19,47,
     19,47,22,,17,47,,,47,51,51,51,49,51,7,8],
   [8,,18,,8,,9,18,,9,20,24,52,22,24,,,56,24,52,,50,7,16,6,7,6,6,16,7,
     16,6,6,7,32,34,32,30,20,,62,18,47,18,19,16,,20,,62,19,47,,44,46,
     44,42,44,46,7,7,8,7,7,7,8,50,52,44,48,50,46,50,48,8,22,9,7,,8,
     22,9,,21,52,20,21,,,50,,,,52,,8,6,,7,7,8,,8,,8,32,34,32,17,66,18,
     16,66,16,,20,17,14,,,,,44,46,44,42,44,6,7,7]],
 [,[],[],[],[,6],[,,16],[,7,,5],[,,16,,,16],[,,,5,7,,5],
   [,,,5,,,5,,5],[24,,,,35,,,32],[,22,,,,,,36,22],[,,56,,58,,43,66],
   [24,18,32,15,18,40,15,40,15,15,24,22,34],
   [,29,,,27,,23,46,23,,28,26,38],[80,30,,39,40,100,25,,33,39,34,32,44],
   [32,,,27,29,,23,46,,27,,26,,19,23,29],
   [80,,,37,40,102,25,72,31,37,,,34,25,29,35],
   [32,24,36,25,,,27,,,25,25,26,35,,26,,26,32],
   [,40,66,,58,,,56,,,34,35,44,,,34,38,44],
   [,,64,,57,,43,68,,,,,34,34,38,44,,34,35,44],
   [80,30,72,35,40,100,25,68,33,35,34,32,44,,,25,29,35,,34,44],
   [8,,,,8,32,9,,,,23,,,23,,63,26,55,28,,,57],
   [,,,,,22,,22,,,,,,41,39,77,,,42,82,,77],
   [,6,,,6,,7,,7,,,22,,18,28,30,26,,23,38,,30],
   [8,6,16,8,6,16,7,16,7,8,24,23,50,18,,,,38,23,50,50,38,8,20,6],
   [10,8,,11,9,,9,18,9,11,,27,39,,31,,29,35,24,61,,47,9,21,7],
   [8,,32,,,,,,9,,23,26,37,23,28,37,27,35,28,37,37,35,7,,,8,9],
   [,,22,,,,,22,,,,,,49,,107,56,107,58,,,105,,17,,20,21],
   [10,6,32,8,6,,,32,7,8,26,,41,18,25,34,23,34,23,41,42,34,8,,6,6,7],
   [,,22,,,22,,,,,45,46,82,49,39,71,47,,,,82,79,,17,,20,21,,17],
   [,6,,8,6,32,7,,,8,26,23,36,18,,40,23,30,22,,36,46,,,6,6,7,8,,6],
   [,8,18,11,9,18,9,,9,11,,28,44,27,29,45,28,39,24,45,45,39,9,21,7,,7,
     9,21,7,21,7],[,6,,,6,,7,,7,,,22,,18,28,30,26,,23,38,,30,,,6,6,7,,
     ,6,,6,7],[40,,,,,164,37,164,43,,111,,,105,128,,,249,136,285,,261,37,,
     ,38,39,37,191,,,37,40],
   [40,30,80,25,30,80,25,80,25,25,111,,255,75,,,107,,,255,233,183,37,91,
     30,30,,37,91,30,91,30,,30,34],
   [40,43,,52,,,,184,43,52,111,122,173,99,124,167,124,161,123,173,173,161,
     37,,41,36,41,37,,,275,38,39,41,34,34],
   [40,30,80,25,30,80,25,80,25,25,111,,241,75,,215,,,132,243,243,,35,85,
     30,30,35,35,85,30,85,30,35,30,34,25,34],
   [24,,,,23,32,21,32,21,,21,,,21,25,31,25,47,22,31,,31,22,,,22,23,22,40,
     21,40,21,,,102,96,102,96],
   [,,,,,,9,,9,,,,,19,23,33,23,33,,,,33,,,,12,17,,,14,,14,17,,,35,,35],
   [,,,,49,92,33,98,37,,,,,33,37,43,,33,37,47,,43,,65,,,42,42,77,41,75,37,
     48,,,219,186,221],
   [24,16,32,11,16,32,9,32,9,11,24,22,34,15,,,19,25,22,57,34,,21,41,14,
     10,,21,41,12,41,12,19,14,85,35,83,35,21,7,33],
   [64,39,,43,51,94,33,134,,43,39,37,47,,,,37,43,,37,47,33,50,,36,,,41,81,
     39,97,50,45,36,371,,185,221,36,,48],
   [24,23,32,24,,,,32,21,24,21,22,31,21,25,31,25,31,22,31,31,31,22,40,
     22,22,23,22,,,40,21,,22,102,96,102,96,18,,36,21,36],
   [,17,,11,,,,,9,11,,,,19,23,33,23,33,58,,,33,21,,15,11,15,,,,,13,15,15,
     123,35,,35,,7,,7],[24,16,32,11,16,32,9,32,9,11,21,22,57,15,19,25,,
     ,22,34,57,25,19,35,14,10,13,19,35,12,35,12,13,14,79,35,89,35,21,7,
     ,7,33,21,7],[,,94,,51,,33,92,37,,,,39,33,37,43,,,40,47,39,43,71,,
     58,72,42,40,81,39,101,35,46,58,279,229,185,,,,38,33,39,36],
   [24,23,32,24,23,32,21,,,24,21,22,31,21,25,47,25,31,,,31,47,22,40,22,
     22,23,22,40,21,,,24,22,102,96,102,96,18,,36,21,,18,,21,36],
   [,,,11,17,,9,,,11,,,,19,23,33,23,33,,,,33,,,15,11,15,21,,13,,,15,15,123,
     35,125,35,,7,,7,,,7,7],
   [64,41,92,43,49,,33,,,43,39,40,47,,,33,37,43,,,47,33,52,75,40,72,,42,
     77,41,65,,48,40,,229,186,225,36,,39,,38,36,,33,48],
   [,,,,,,9,,9,,,,,19,23,33,23,33,,,,33,,,,12,17,,,14,,14,17,,,35,,35,,7,,7,,
     ,7,7,,,7],[,,,,49,94,33,,37,,,,,33,37,43,,33,37,47,,43,,81,,,43,42,
     75,41,75,37,52,,,,185,219,,,29,33,48,36,,,38,36,,39],
   [64,39,98,43,51,92,33,,,43,39,37,47,,,33,37,43,,,47,,51,81,36,,,40,,39,
     81,50,45,36,279,219,187,237,36,,48,,29,36,,33,39,,,38,,48],
   [56,,,,52,168,,196,47,,153,,,135,167,291,164,299,,335,,,51,,,50,53,51,257,
     48,193,49,54,,235,217,235,217,138,,,99,,138,97,99,319,138,97,335],
   [56,42,112,35,42,112,35,112,35,35,153,161,,105,,,145,235,166,291,293,
     233,51,125,42,42,,51,125,42,125,42,53,42,229,175,223,175,132,49,273,
     49,,132,49,49,,132,49,273,49,279,281,44],
   [56,,208,62,,,,,53,62,153,163,235,135,161,217,162,217,162,235,235,211,51,
     197,,50,53,51,,,,48,53,,235,217,235,211,138,160,243,103,244,138,,97,
     243,138,101,243,160,244,243,44,44],
   [56,42,112,35,42,112,35,112,35,35,153,162,297,105,145,,,,,297,315,,49,
     119,42,42,49,49,119,42,119,42,49,42,223,175,229,175,132,49,275,49,
     275,132,49,49,,132,49,287,49,287,,44,35,44],
   [56,55,156,,,164,47,,,,153,172,303,129,169,289,,299,,,307,287,51,309,53,
     48,54,51,,48,,,53,53,235,211,235,217,138,160,351,97,313,138,139,103,
     316,138,,,160,317,317,44,44,44,44],
   [56,42,112,35,42,112,35,112,35,35,147,146,223,105,151,175,145,175,148,
     223,223,175,51,125,42,42,,51,125,42,125,42,,42,223,175,229,175,126,
     49,215,49,215,126,49,49,218,126,49,218,49,218,215,44,35,44,35,44],
   [8,,,,8,20,9,20,9,,23,,,23,,51,25,43,27,,,45,7,,,8,9,7,,8,,8,9,,37,
     37,37,35,22,,,19,45,22,19,17,63,22,19,47,,,47,51,51,51,49,51,51],
   [8,11,16,14,11,16,11,16,11,14,24,28,48,24,,,,48,28,46,46,48,8,19,10,
     8,,8,19,9,19,9,9,10,40,40,40,40,24,22,,16,,24,19,16,62,24,19,61,
     22,61,61,56,56,56,56,56,56,8],
   [8,9,24,11,,,,20,9,11,23,25,37,23,26,37,25,35,27,37,37,35,7,33,9,8,
     9,7,,,33,8,9,9,37,37,37,35,22,19,40,17,39,22,,15,40,22,17,40,19,
     40,40,51,51,51,49,51,51,7,8],
   [8,9,16,11,8,16,9,16,9,11,23,24,45,23,28,43,,,26,45,45,43,7,17,9,8,
     9,7,17,8,17,8,9,9,37,37,37,35,22,17,56,15,,22,15,13,,22,15,56,17,
     56,46,51,51,51,49,51,51,7,8,7],
   [8,9,24,11,8,20,9,,,11,23,24,,23,26,43,25,41,,,43,43,7,,9,8,9,7,33,
     8,,,9,9,37,37,37,35,22,19,44,17,45,22,17,15,44,22,,,19,44,55,51,
     51,51,49,51,51,7,8,7,7],
   [8,11,16,14,11,16,11,16,11,14,24,28,40,24,28,40,28,40,28,40,40,40,8,
     19,10,8,9,8,19,9,19,9,,10,40,40,40,40,24,22,44,16,44,24,19,16,44,
     24,19,44,22,44,44,56,56,56,56,56,56,8,8,8,8,8],
   [8,,,,8,20,9,20,9,,23,,,23,,51,25,43,27,,,45,7,,,8,9,7,,8,,8,9,,37,
     37,37,35,22,,,19,45,22,19,17,63,22,19,47,,,47,51,51,51,49,51,51,7,
     8,7,7,7,8],[72,,,,62,92,47,88,,,53,,,54,58,68,61,62,63,80,,68,61,,
     ,54,57,51,,52,103,52,57,,271,245,235,241,47,,,46,79,47,77,47,,55,48,
     79,,,79,353,327,317,327,357,299,57,60,51,55,55,56,57],
   [72,52,88,41,52,92,35,92,39,41,66,60,80,35,,,49,59,73,74,80,57,61,
     101,48,46,,51,99,46,99,42,57,48,265,203,223,199,55,39,75,35,,47,41,
     37,75,47,41,67,39,75,69,335,273,299,273,333,245,57,60,51,55,55,56,
     57,54],[56,50,64,49,,,,64,41,49,53,52,67,47,51,61,51,61,52,67,67,
     61,47,77,44,42,43,37,,,77,40,40,44,217,195,173,199,42,45,71,39,69,
     34,,39,69,42,,71,45,71,69,279,257,235,257,275,223,43,44,37,41,41,40,
     43,44,44],[72,42,92,41,52,84,35,88,39,41,53,68,74,45,49,59,,,60,
     80,74,59,59,91,42,46,53,49,99,46,95,46,53,42,259,203,229,199,47,41,
     67,37,75,47,41,35,,55,39,75,41,67,75,335,273,293,273,339,245,55,60,
     49,53,53,56,55,44,45,44],
   [72,62,88,,62,,53,,,,66,63,80,47,61,62,58,68,,,80,62,61,103,56,54,53,
     51,124,52,,,57,56,271,245,235,235,55,51,79,47,73,47,77,46,79,47,,,
     51,79,87,353,327,317,321,357,299,57,60,51,55,55,56,57,54,44,44,54],
   [56,40,64,31,30,64,25,64,29,31,53,52,67,35,39,49,39,49,52,67,67,49,
     47,75,36,34,43,37,75,30,75,34,,36,205,153,167,157,42,33,73,27,73,
     34,31,27,73,42,27,73,33,73,73,255,203,217,203,257,175,43,44,37,41,
     41,40,43,44,35,34,35,44],
   [72,,,,62,88,47,88,51,,53,,,54,58,68,61,62,63,80,,68,61,,,52,58,51,,52,
     103,52,57,,271,239,235,241,47,,,46,79,47,77,47,,55,48,79,,,79,353,
     321,317,327,357,299,57,60,51,55,55,56,57,44,54,44,44,54,44],
   [72,52,88,41,52,92,35,88,39,41,66,60,80,35,55,59,49,59,,78,80,,59,95,
     48,46,49,49,95,46,99,42,53,48,265,203,223,199,55,39,75,35,69,47,41,
     37,75,47,41,69,39,75,,329,273,299,273,339,245,55,60,49,53,53,56,55,
     54,35,44,45,44,35,54],
   [,,,,,,,,,,,,,33,31,51,41,,40,60,,45,,,,12,13,,,,,,13,,,51,,45,,,,33,56,35,
     ,27,117,35,,49,,,56,,69,,63,,69,,11,11,9,,11,,,85,75,63,93,67,,79],
   [,,,,,,,,,,,,,37,41,63,41,63,,,,63,,,,14,15,30,,18,,,16,,,56,118,56,,,,13,,,
     ,13,,,,,,,,,76,146,76,,70,,16,18,14,18,16,,,63,42,71,63,58,,63],
   [,,,,,,,,,,,,,38,,98,40,80,45,,,90,,,,14,15,,,,,,15,,,58,70,56,,,,38,76,37,
     ,36,122,37,,78,,,77,,78,,76,84,78,,14,,13,,14,,,94,80,92,,74,,86],
   [,,,,,,,,,,52,40,84,33,38,67,31,61,,86,84,61,10,28,9,12,10,10,28,9,28,
     9,10,9,59,51,,45,35,,72,33,65,,,27,65,35,,72,,72,65,81,69,85,63,,
     69,10,11,10,10,10,11,10,97,85,,79,101,51,97,79,12,,13],
   [,,,,,,,,,,32,34,50,37,,45,30,44,34,61,50,45,30,,,14,15,,,,,18,15,,116,
     56,142,56,29,10,48,13,49,29,10,10,48,29,10,57,10,48,49,122,76,,76,,
     70,22,16,,14,18,16,22,68,63,50,62,87,44,68,71,,13],
   [,,,,,,,,,,,45,,38,40,82,,90,,,,80,11,29,10,14,13,11,29,10,29,10,10,10,
     73,58,,56,37,,76,38,,37,,36,78,,,84,,77,,,78,102,76,,78,11,14,11,11,
     11,11,11,106,94,89,92,,74,,86,13,,14],
   [,,,,,,,,,,,34,45,26,30,44,,53,34,50,45,44,,,,14,16,,,18,,,15,,,56,,56,
     29,10,49,10,48,29,10,13,57,29,10,48,10,49,48,,76,,76,,70,22,16,18,
     14,,16,22,,62,50,71,68,44,63,62,,13,,,13],
   [,,,,,,,,,,,,85,38,46,58,41,56,45,82,85,50,,,,14,15,,,,,,15,,70,58,,56,37,
     ,62,38,61,,,36,60,46,,63,,63,60,90,78,,76,108,78,10,11,10,13,10,11,
     10,90,78,,76,108,58,90,70,,,13,13,,14],
   [,,,,,,,,,,,,,38,44,98,43,90,66,,,96,11,29,10,14,10,11,29,10,29,10,13,
     10,79,58,76,56,,,122,38,78,46,,36,,37,,77,,84,78,90,78,,76,,78,11,
     11,11,11,11,14,11,,94,89,92,106,74,106,86,13,,14,,,13,,14],
   [,,,,27,48,23,,23,,,,,23,27,33,,,27,37,,33,,,,,29,28,39,25,39,25,34,,,
     107,124,107,,,,23,38,26,,,,26,,29,,,38,,145,161,145,,145,,31,26,28,26,
     28,,,61,57,55,65,59,,61,31,,,38,30,41,41,46,40],
   [,,,,40,64,43,68,,,,,,44,48,58,,,53,70,,58,,,,50,44,37,,36,82,42,39,,,,
     173,261,,,,36,71,37,61,57,,45,36,71,,,71,,289,235,287,307,223,,46,37,
     45,,40,,,44,34,,44,34,,44,,45,,64,50],
   [24,36,,,,32,,,,,24,29,56,24,29,56,29,56,29,56,56,56,23,,30,24,26,23,
     45,,,25,31,30,111,111,111,111,24,23,60,24,60,24,23,24,60,24,23,60,
     23,60,60,153,153,153,153,153,147,23,24,23,23,23,24,23,66,66,37,66,
     66,31,66,66,55,32,,,,,,,,28,34],
   [32,27,,27,,46,23,,,27,28,27,48,23,28,51,27,39,24,57,48,51,27,56,24,,
     28,26,,24,45,23,,24,132,107,124,111,22,21,43,23,55,22,21,19,43,22,
     21,55,21,43,55,169,145,162,149,169,151,27,31,26,26,27,28,27,58,61,
     35,49,65,29,58,61,38,30,41,31,,,41,40,43,23,38],
   [,43,,,,66,,72,,,34,39,70,44,57,34,37,70,59,37,70,31,,,41,50,44,37,80,,
     ,41,60,41,255,,173,,34,35,74,36,38,34,35,34,74,42,35,35,35,74,35,
     309,289,235,289,,223,,46,37,45,43,40,,80,44,47,80,47,41,80,41,70,50,,
     ,45,,,85,,38,44],
   [32,22,74,25,25,,,36,,25,,,,26,27,34,,,30,39,,34,25,,22,23,28,26,,24,
     46,24,27,22,132,132,122,128,23,23,54,20,34,26,23,22,54,23,22,34,23,
     54,34,172,,163,162,170,146,25,28,25,24,24,28,25,,64,62,,69,54,63,65,
     ,34,54,40,34,,,,45,26,,25,26,35],
   [80,,104,35,30,76,25,72,33,35,,,,35,39,49,,,50,70,,49,57,105,50,38,39,
     35,79,30,73,34,35,50,243,195,161,,57,27,,27,65,37,27,,,45,29,65,27,,
     65,299,235,211,223,295,175,45,48,35,43,43,40,45,62,35,34,,41,25,62,
     35,,45,90,45,44,80,63,50,96,,34,34,29,44],
   [,25,,,22,36,,,23,,25,32,53,26,24,53,30,50,25,59,53,56,30,58,23,23,
     24,28,42,22,,23,24,23,128,,123,,23,23,54,20,57,23,22,22,54,26,23,
     57,23,54,57,167,,163,161,,148,28,28,27,26,27,28,28,63,64,36,60,69,
     30,63,65,40,34,,,34,66,,45,,26,35,,26,,26,32],
   [80,30,,37,,68,25,,33,37,34,34,58,35,51,25,33,49,56,34,58,25,51,107,
     30,,45,37,77,42,77,34,,30,243,,167,235,28,29,53,27,29,28,29,25,53,
     36,29,29,29,53,29,295,237,217,225,287,175,45,,37,43,45,40,45,68,35,
     41,59,44,35,68,35,51,44,82,111,53,98,63,58,82,29,44,,,34,32,35],
   [,,,,44,56,43,68,,,,,,44,48,58,,,53,70,,58,,,,50,45,37,,38,82,41,39,,
     275,237,173,,,73,,36,71,37,36,57,,45,,71,73,,71,311,293,235,293,301,
     223,,46,37,45,43,40,,76,41,37,74,47,34,74,41,,61,,65,50,,,,,,34,34,
     38,44,,34,35,44],
   [,46,,,,68,,56,,,34,39,70,44,57,31,37,70,59,37,70,34,,,41,50,44,37,82,
     54,111,42,60,41,275,231,173,261,34,35,74,36,35,34,35,34,74,42,35,
     35,35,74,38,,291,235,291,,223,45,46,37,43,43,40,45,80,41,47,80,47,
     41,80,44,62,50,,,45,,,82,,38,44,,,34,35,44,,34,44],
   [,,,,20,,11,,,,,,,25,29,43,29,43,,,,43,,,,10,14,,,12,,14,14,,,42,134,42,,,
     ,9,,,9,9,,,,,,,,,58,190,58,135,56,,19,17,15,19,19,,,47,,51,54,32,,47,,
     ,,,11,,11,,,,,26,24,40,26,37,27,34,40,40],
   [,,,,10,26,11,,,,,,,28,28,44,30,74,33,48,,40,,,,10,11,9,33,10,,,11,,,44,
     ,42,,,,26,46,26,25,24,72,27,,44,,,46,,60,61,58,61,60,,10,9,9,,10,,,
     70,55,58,71,54,,66,9,,,11,30,12,,11,12,28,,38,30,46,,,32,44,,48],
   [8,,,,,,9,32,,,23,28,57,23,26,51,,59,,57,,55,8,22,7,8,7,8,22,7,22,7,
     7,7,37,37,37,35,22,,50,21,,22,21,19,52,22,,67,,51,,51,51,51,49,51,
     51,8,8,8,8,8,8,8,61,61,47,59,61,47,61,59,10,,11,,,,30,11,,27,57,
     23,,,,55,26,63,,,,9],
   [,,,,,,11,,,,26,26,40,25,,33,24,34,26,,40,37,,,16,10,15,22,,12,,,15,16,
     92,42,,42,23,8,38,9,37,23,8,8,38,23,8,37,8,38,41,,58,132,58,114,
     56,20,19,16,14,,19,20,54,47,40,48,,34,54,51,,11,,,,,11,,,24,40,,,,26,
     34,27,33,40,65,9],
   [10,,,,,,11,26,,,32,33,56,28,30,54,28,50,,58,60,52,9,23,8,10,9,9,23,
     8,23,8,8,8,48,44,,42,26,,56,26,54,,25,24,54,29,,56,,56,54,63,60,
     63,58,,60,9,10,9,9,9,9,9,73,70,48,68,76,44,72,66,11,,12,9,,,30,
     12,11,30,47,,28,,33,42,,80,47,,,10],
   [8,6,16,5,6,16,5,16,5,5,21,,55,15,19,,19,,,55,55,,7,17,6,6,7,7,17,
     6,17,6,7,6,31,25,31,25,18,7,45,7,45,18,7,7,45,18,7,45,7,45,45,
     41,35,41,35,41,35,7,8,7,7,7,8,7,49,43,47,43,49,41,49,43,9,10,10,
     9,10,10,10,10,10,19,55,21,19,55,,,,,55,55,8,8,7,8,8],
   [10,7,20,6,8,20,7,20,6,6,26,,58,,23,30,23,,,38,58,,8,21,7,7,8,9,21,
     8,21,7,8,7,38,,38,,22,8,45,8,35,22,9,8,45,22,8,35,8,45,35,50,47,
     50,51,50,49,8,9,9,8,8,9,8,50,57,48,48,60,45,50,52,11,12,12,11,
     12,12,12,12,12,23,58,26,23,38,,,33,30,58,38,9,9,8,9,9],
   [,,,,20,,11,,,,,26,40,20,24,34,,37,26,40,,34,,,,10,14,,,12,,14,14,,,42,,
     42,23,8,37,8,38,23,8,9,41,23,8,38,8,37,38,108,58,,58,114,56,,19,
     17,15,19,19,,54,48,40,51,54,34,,48,,11,,,11,,,,,29,,,29,,,43,,43,,,9,,
     ,9,,8,9],[,,,,10,,11,,,,30,35,48,28,28,80,29,42,,,47,,,,,10,11,,,
     10,33,,11,,45,44,48,42,27,,44,26,72,29,25,24,46,,,64,,44,60,61,60,
     67,58,67,60,8,9,8,9,8,9,8,71,60,58,68,64,54,71,56,9,,11,11,,12,,,
     12,28,60,29,30,58,,50,32,54,56,60,,9,9,,10,8,9],
   [,,26,,,,11,,,,,,,28,29,44,28,,35,46,,42,9,23,8,10,8,9,23,8,23,8,9,8,
     48,44,,42,,,72,26,44,29,25,24,,26,,46,,60,44,65,60,63,58,62,60,9,9,
     9,9,9,10,9,63,70,57,58,72,54,,66,11,30,12,9,,11,,12,,30,,34,28,47,
     ,72,33,44,,47,,10,,,9,8,9,,10],[],
   [40,,,52,,160,,,37,52,111,127,257,105,,245,138,,128,,255,243,37,191,,38,
     40,37,,37,183,,39,,34,34,37,31,102,142,262,85,292,102,123,79,340,102,
     ,262,142,331,,235,229,235,223,235,223,37,40,37,37,37,40,37,271,265,
     217,259,271,205,271,265,67,,88,,,,,64,,133,251,111,,,,,136,249,,251,113,
     51,37,,,31,38,92],
   [40,30,80,25,30,80,25,80,25,25,111,,237,75,107,187,107,195,128,,,195,
     37,91,30,30,41,37,91,30,91,30,,30,34,25,34,25,96,35,229,35,229,96,
     35,35,,96,35,219,35,223,219,217,175,217,175,211,175,37,40,37,37,37,
     40,37,245,203,195,203,245,153,239,203,51,56,58,51,56,58,56,58,58,
     107,233,111,,255,,,131,,255,233,42,44,37,42,44,25,,42,44,44,,34],
   [40,,,52,,,43,,,52,111,123,173,99,124,161,124,161,122,173,173,161,37,,,
     36,41,37,275,37,,36,40,,34,31,37,34,102,,185,83,186,102,125,89,185,
     102,87,187,,186,186,235,223,235,229,235,229,37,40,37,37,37,40,37,235,
     223,173,229,235,167,235,223,,142,64,59,,82,,,82,124,173,111,123,173,
     123,167,123,161,173,173,116,45,37,136,47,31,38,,,46,,34,34],
   [,,,,,22,,22,,,,,,46,48,84,48,82,46,90,,,,,,22,23,,23,,23,,23,,,98,172,96,
     ,,,46,86,42,,44,,42,,85,,,,,134,214,132,214,134,,22,,21,,22,,,110,82,
     112,110,82,,102,,,,29,,30,,29,30,,,,62,,,114,62,114,,,,,23,,24,18,22,,
     23,24,,,98,226],[,,,,37,62,33,68,36,,,,,42,46,56,46,,54,71,,56,,,,
     39,45,40,76,36,79,39,41,,,261,185,257,,,,34,69,38,63,34,,46,34,71,,,
     69,,,245,328,344,218,,48,39,42,42,44,,,42,35,,45,32,,42,,,,58,52,81,
     52,,,,,39,37,49,,,42,44,39,49,36,,52,40,49,,,40,59,,,282,257,184],
   [24,23,,24,,32,21,32,,24,24,26,42,21,26,45,22,36,23,45,42,45,22,,22,
     22,23,22,40,,40,21,23,22,102,96,102,96,21,20,40,21,49,21,20,18,40,
     21,20,49,20,40,49,138,132,138,132,138,126,22,24,22,22,22,24,22,52,
     55,34,46,55,28,52,55,35,29,46,,,,29,37,37,22,34,21,,,23,28,23,57,34,
     ,23,29,22,,,18,22,23,26,27,,102,96,102,,36],
   [,,,,,28,,22,,,,,,46,48,84,48,,50,90,126,82,23,21,20,22,21,23,21,20,21,
     20,18,20,201,98,252,96,,,80,46,85,42,,44,,48,,86,,86,85,218,134,,132,
     290,134,21,22,21,19,21,19,21,112,110,88,112,113,82,,102,29,,30,,,,,
     30,29,59,,,,,62,110,,114,,,,24,,,,18,22,,24,23,,,98,,22],
   [64,36,,41,,68,,,,41,39,32,73,42,55,32,34,67,62,36,73,30,52,,35,39,42,
     42,76,50,70,38,42,35,282,,186,,36,35,71,34,36,33,35,30,71,41,34,34,
     35,71,34,341,,244,,338,219,47,48,41,44,,44,47,83,42,46,78,46,40,83,
     40,58,52,81,,,,52,65,96,37,49,,,,42,44,,34,49,39,40,49,,36,,,39,40,
     59,50,,,301,185,,42],
   [24,18,16,15,18,16,15,16,15,15,21,,47,15,19,25,19,,20,31,47,25,19,17,
     16,14,15,19,17,16,17,16,15,16,87,65,87,65,18,17,37,15,29,18,17,15,
     37,18,17,29,17,37,29,113,91,113,91,113,91,17,16,17,15,17,16,17,41,
     43,39,35,49,33,41,43,25,26,26,25,26,26,26,26,26,19,47,21,19,31,,,
     20,25,47,31,20,20,19,20,20,13,,20,20,20,,87,65,87,18,,18,18,36],
   [,,,,36,,32,68,37,,,,,42,46,56,46,,54,71,,56,,,,39,45,39,,35,79,40,42,,
     285,267,184,,,37,,34,69,38,,34,,46,63,71,37,,69,348,316,244,322,,219,,
     48,38,42,43,44,,75,40,35,72,46,30,75,40,,50,,58,52,81,52,,,,39,39,
     37,49,,,40,45,39,49,,,52,41,48,,,41,59,92,,,,184,,35,36,,45],
   [24,23,,24,23,32,,32,21,24,21,26,37,18,22,28,26,37,23,34,37,28,22,,
     22,22,,22,40,21,40,,23,22,102,96,102,96,21,20,41,18,32,21,20,21,41,
     21,20,32,20,41,32,138,132,138,132,138,126,22,24,22,22,22,24,22,47,
     38,34,47,44,28,47,38,35,29,37,35,29,46,,,37,25,31,21,25,31,22,31,
     22,31,31,31,23,27,22,23,29,18,22,,,26,,102,96,102,,36,21,,36,18,36],
   [,,,,,28,,28,,,,,126,46,48,84,48,88,46,89,,78,,,,22,23,,23,,23,,23,,,98,,
     96,,,112,46,86,48,,44,80,48,,85,,,86,204,134,238,132,,134,20,19,20,
     21,20,19,20,154,110,88,104,116,82,,102,,,29,29,,30,,,30,,,,56,,,,62,
     114,,,,23,23,,24,18,22,,,24,,236,98,,21,,,22,,18],
   [24,18,16,15,18,16,15,16,15,15,21,26,39,15,19,33,19,33,26,39,39,33,
     19,17,16,14,15,19,17,16,17,16,15,16,87,65,87,65,18,17,37,15,37,18,
     17,15,37,18,17,37,17,37,37,113,91,113,91,113,91,17,16,17,15,17,16,
     17,49,43,31,43,49,25,49,43,25,26,26,25,26,26,26,26,26,19,31,21,19,
     47,20,25,,,31,47,20,20,19,20,20,13,,20,20,20,,87,65,87,18,36,18,18,
     ,13,36,18,18],[64,37,,41,,68,34,68,47,41,39,35,73,42,55,30,34,67,
     60,35,73,30,52,,35,39,42,42,76,,70,39,42,35,,,185,261,36,35,71,34,
     34,33,34,30,71,41,35,36,35,71,34,374,351,245,330,341,219,47,48,41,
     44,56,44,47,83,40,46,78,45,40,83,40,58,52,81,,,,52,65,90,37,49,,,
     39,40,44,,,49,39,41,48,,40,,,40,41,58,,,290,266,184,,45,,,35,33,42,36 
    ],[,,,,,22,,28,,,,,,46,,84,48,,56,89,128,82,23,21,20,22,18,23,21,20,
     21,20,21,20,275,98,,96,,,,46,85,48,,44,,42,,,,80,87,294,134,294,132,
     290,134,21,19,21,19,21,22,21,,110,88,112,113,82,112,102,29,,30,,,29,,
     30,,56,,,,,62,110,,114,,,,24,,,23,18,22,,24,,,,98,252,22,,,21,,18,,,22,
     18],[,,,,,62,33,68,36,,,,,42,46,56,46,,51,71,,56,,,60,39,42,42,70,
     35,76,38,38,60,318,,184,261,,,,34,71,38,35,34,,46,,69,,,71,349,,244,,
     341,218,66,48,41,44,45,44,66,75,40,36,72,46,32,75,40,,,,65,52,90,
     52,65,,,39,39,37,49,,34,42,44,,49,38,,49,40,48,,,40,59,,,,266,185,,
     32,36,,42,,35,36,,36,45],
   [64,,,41,92,68,37,62,,41,39,32,73,42,57,30,34,67,60,36,73,32,49,,,39,
     45,40,79,50,,39,45,,293,273,184,,36,35,71,34,34,33,35,30,71,41,34,
     34,35,71,36,,,245,340,,218,45,48,39,42,44,44,45,83,40,46,78,46,40,
     83,42,71,52,96,,50,,52,74,81,37,49,,,39,42,44,,,49,,40,50,,,,,38,40,
     59,49,,295,,184,,42,,,32,36,45,36,,,35,,42],
   [56,54,,,,196,47,196,,,153,169,311,135,167,,168,293,174,315,,291,51,193,
     51,50,53,51,,48,,50,55,51,235,217,235,217,138,105,335,99,320,138,,99,
     ,138,97,,105,335,318,44,44,47,41,47,41,51,56,51,51,51,56,51,353,
     335,279,335,353,255,353,329,,122,84,,,,130,,90,176,307,153,,,171,289,
     167,291,335,335,108,,51,,,41,50,,61,63,,235,217,235,206,341,138,,,113,,
     138,206,113,344,216,348,376],
   [56,42,112,35,42,112,35,112,35,35,153,,307,105,145,241,149,233,,307,299,
     231,51,125,42,42,,51,125,42,125,42,55,42,229,175,223,175,132,49,281,
     49,279,132,49,49,273,132,49,,49,,273,44,35,44,35,41,35,51,56,51,51,
     51,56,51,327,273,257,273,327,203,321,273,69,76,78,69,76,78,76,78,78,
     145,297,153,145,,,,176,,291,293,58,60,51,58,60,35,,58,60,60,,229,175,
     223,134,317,132,134,344,91,,132,134,91,,134,313,317,44],
   [56,54,,,56,,47,208,47,,153,162,235,135,162,217,161,217,162,235,235,211,
     51,,51,50,55,51,253,50,253,48,55,51,235,217,235,211,138,160,243,103,
     244,138,101,97,243,138,,244,160,243,243,44,41,47,44,47,41,51,56,51,
     51,51,56,51,317,299,235,293,317,217,317,299,79,138,84,,170,90,,,96,
     161,235,153,162,235,162,217,163,217,235,235,,61,51,134,,41,50,,,62,,
     235,217,235,270,245,138,284,244,113,245,138,,113,244,284,244,245,44,44 
    ],[56,42,112,35,42,112,35,112,35,35,153,,293,105,149,229,145,227,,
     289,287,,49,119,42,42,49,49,119,42,119,42,49,42,223,175,229,175,132,
     49,279,49,275,132,49,49,275,132,49,275,49,,287,44,35,41,35,44,35,49,
     56,49,49,49,56,49,327,273,257,273,321,203,327,273,63,76,76,63,76,76,
     76,76,76,,315,153,145,297,162,,,,297,315,58,58,49,58,58,35,,58,58,58,
     ,223,175,229,132,,132,132,310,91,340,132,132,91,,132,330,322,44,35,44 
    ],[56,58,156,53,,,53,,,53,153,175,309,129,,283,165,,,319,,283,51,,53,
     48,53,51,309,,205,48,54,53,235,211,235,217,138,,313,97,,138,101,103,
     351,138,139,312,,,,44,41,47,41,47,44,51,56,51,51,51,56,51,357,333,
     275,339,357,257,357,339,,,90,77,142,,142,,,164,305,153,164,301,173,285,
     ,297,,,114,61,51,150,63,41,50,,,,,235,211,235,218,344,138,226,368,113,
     337,138,314,113,339,,,341,44,44,44,44],
   [8,8,,,,,9,20,9,,23,27,47,23,25,45,,53,,45,,43,8,20,7,8,7,8,20,7,20,
     7,7,7,37,37,37,35,22,,45,19,,22,19,17,47,22,19,47,,47,,51,51,51,
     49,51,51,8,8,8,8,8,8,8,57,57,43,55,57,43,57,55,10,,11,,,,22,11,
     10,27,45,23,,,28,43,25,51,,,20,9,7,,,7,8,20,9,8,,37,37,37,21,47,22,
     ,,17,47,22,21,17,,20,45,66,51,51,51,49,51],
   [8,6,16,5,6,16,5,16,5,5,21,,39,15,19,39,19,33,,41,39,,7,17,6,6,7,
     7,17,6,17,6,7,6,31,25,31,25,18,7,35,7,35,18,7,7,35,18,7,35,7,
     35,35,41,35,41,35,41,35,7,8,7,7,7,8,7,47,41,37,41,47,31,47,41,9,
     10,10,9,10,10,10,10,10,19,41,21,19,39,,,,37,41,39,8,8,7,8,8,5,,8,
     8,8,,31,25,31,18,60,18,18,,13,,18,18,13,39,18,,,41,35,41,35,41,7],
   [8,,20,,8,,9,,9,,23,25,37,23,27,37,27,35,27,37,37,35,7,,,8,9,7,,8,,
     8,9,,37,37,37,35,22,,41,19,41,22,19,17,39,22,19,41,,41,39,51,51,
     51,49,51,51,7,8,7,7,7,8,7,51,51,37,49,51,37,51,49,,22,10,10,,11,,
     ,11,27,37,23,25,37,25,35,27,37,37,37,,8,8,20,9,7,8,,,9,,37,37,37,
     20,39,22,21,41,17,39,22,,17,41,21,41,39,51,51,51,49,51,8,7],
   [8,6,16,5,6,16,5,16,5,5,21,21,41,15,19,,19,43,,39,41,,7,17,6,6,7,
     7,17,6,17,6,7,6,31,25,31,25,18,7,35,7,35,18,7,7,35,18,7,35,7,
     35,35,41,35,41,35,41,35,7,8,7,7,7,8,7,47,41,37,41,47,31,47,41,9,
     10,10,9,10,10,10,10,10,19,39,21,19,41,22,,,,39,41,8,8,7,8,8,5,6,
     8,8,8,,31,25,31,18,39,18,18,56,13,,18,18,13,,18,39,,41,35,41,35,
     41,7,5,7],[8,8,20,,,20,9,,9,,23,28,45,23,29,51,27,47,25,47,,45,
     8,20,7,8,7,8,20,7,20,7,7,7,37,37,37,35,22,,63,19,47,22,19,17,,
     22,19,47,,47,47,51,51,51,49,51,51,8,8,8,8,8,8,8,57,57,43,55,57,
     43,57,55,10,22,11,,22,10,,11,,25,47,23,27,,27,45,,45,,,20,9,7,,8,7,
     8,20,9,,,37,37,37,21,66,22,20,45,17,66,22,21,17,45,,,47,51,51,51,
     49,51,7,7,8,7]],
 [,[],[],[],[,33,,46],[,,24],[,52,,68],[,,28,,,30],
   [,,,46,46,,68],[],[18,,,,58,,,30],[,37,,,38,,60,35],
   [,,18,,31,,44,24],[18,,,,35,36,64,36,,,9],[,52,,,44,,65,41,82,,,15],
   [,,18,,31,,44,24,,,,,7],[24,,35,80,44,,76,51,,,,13,,15,15],
   [30,38,20,50,25,26,42,22,54,,,,7,11,15,7],
   [24,,33,85,38,42,53,,,,15,15,,,13,,15,15],
   [,,18,,35,,,22,,,11,15,7,,,7,15,7],
   [,,,,35,,68,22,,,,,7,11,15,7,,7,15,7],
   [30,38,18,52,25,26,42,26,54,,11,15,7,,,7,15,7,,7,7],
   [36,,,,46,52,62,,,,36,,,36,,,46,38,46,,36,40],
   [,,,,,42,,49,,,,,,,,,60,32,58,31,61,30],
   [,47,,,58,77,76,,62,,,59,,,74,,64,53,58,,49,53],
   [36,,,,,44,,65,66,,34,,,30,,,,43,,33,33,43,34],
   [,72,,,68,60,,76,85,,,48,,,44,,65,48,53,44,44,44,,,52],
   [36,50,46,62,,,,76,62,,36,49,28,36,49,28,50,28,50,28,28,28,34,,45,34,
     45],[,,39,,,,,49,,,,53,,,,,53,35,51,,,35,,35,,35,44],
   [,62,92,74,39,,,90,74,,62,59,39,58,69,39,60,40,58,40,48,40,45,,56,50,
     52],[],[,,,62,58,78,76,,,,66,,67,58,,67,61,52,56,,49,52,,,45,47,
     52,45,,56],[62,74,62,85,60,52,82,,101,,58,49,46,66,48,46,59,32,53,
     36,36,32,45,40,52,,38,39,38,47,,52],
   [62,64,,76,,,66,156,76,,,66,82,,67,82,67,53,60,49,,51,46,,57,50,53,,,46,
     ,57,52],[90,,,,,140,338,156,368,,45,,,45,,,84,43,82,47,45,45,168,,,
     153,,164,226,,,265,220,263],
   [90,,,,160,120,310,168,277,,45,,,45,,,76,,81,45,45,43,168,,,143,,160,186,
     250,,256,,268,41],
   [90,209,,360,,,,202,364,,45,67,35,45,67,35,67,35,67,35,35,35,164,257,
     250,153,220,140,,,,253,,258,41,41],
   [90,,128,246,,148,,150,,,45,79,49,45,,49,,,79,47,47,,168,221,233,143,196,
     164,222,227,,233,188,242,41,41,41],
   [18,,,,37,24,64,26,60,,16,,,18,,,20,16,22,17,,17,34,,,29,,34,37,48,,56,
     49,48,78,78,76,78],
   [,,,,48,,65,,48,,,,,,,,,46,,,,46,,,,,,66,,76,,70,91,77,,,,226],
   [,,,,31,22,54,28,,,,,,,,,,9,,9,9,9,,29,,,,31,32,44,,78,38,,,,40,63],
   [18,,,,31,24,48,26,44,,18,,,16,,,22,17,20,16,17,,34,,,27,,34,35,45,,46,
     60,46,78,78,76,78,16],
   [,,,,31,22,54,28,,,,,,,,,,9,,9,9,9,,29,,,,31,32,44,,78,38,,,,40,63,,,8],
   [18,43,18,68,,,,22,,,16,20,10,16,20,10,20,9,20,9,9,9,36,30,48,32,42,
     28,,,,47,34,54,64,60,40,62,16,,8,16,8],
   [,48,,59,,,,,63,,,58,,93,62,,64,46,64,,,46,66,,76,72,138,,,,,80,94,74,
     434,272,,350,,53,,46],
   [18,31,26,44,31,24,52,30,,,16,20,18,18,22,18,,,24,17,16,17,34,51,46,
     27,38,34,35,45,,46,38,47,78,78,76,78,14,46,,16,,16],
   [,,30,,29,22,46,24,108,,,,10,18,22,10,,,22,9,9,9,47,30,58,48,67,31,
     31,42,,60,39,61,61,65,40,,,,8,16,8,8],
   [18,,26,64,37,24,60,,,,18,22,18,16,20,18,24,17,,,17,16,34,51,51,29,42,
     34,37,47,,,42,49,78,78,76,78,16,,,14,,16,,16,16],
   [,,,52,48,,65,,,,,,,93,79,,82,46,,,,46,,,68,106,95,66,,76,,,85,83,434,
     282,428,300,,44,,70,,,53,70],
   [34,,22,108,31,22,46,,,,18,22,10,,,10,22,9,,,9,9,46,30,67,46,,31,30,43,
     ,,35,70,75,63,40,74,16,,8,,8,8,,16,8],
   [,52,,63,,,52,,59,,,67,,,65,,62,46,58,,,46,68,,78,74,96,,,66,,80,100,,,
     304,328,270,,47,,,,,44,46,,,53],
   [,,,,31,22,54,24,76,,,,10,18,22,10,,9,22,9,,9,,51,,,53,31,30,45,,,33,,
     75,,40,59,,,8,16,8,8,,,8,16,,8],
   [34,51,22,76,29,22,46,32,,,18,22,10,,,10,22,9,,9,9,,46,28,59,,,31,31,
     42,,59,39,60,61,61,40,61,16,,8,,8,8,,16,8,,,8,,8],
   [126,,,,251,166,,204,406,,63,,,63,,,,59,,59,59,59,232,,,207,,220,341,332,,
     340,286,347,285,285,273,285,106,,,106,,80,408,106,77,106,406,77,512,
     79,79],[126,,,,211,166,386,214,356,,63,,,63,,,104,57,105,57,61,61,232,
     ,,197,,220,242,327,,342,302,352,285,285,273,285,106,,,106,,80,352,106,,
     106,346,77,376,91,77,55],
   [126,,158,394,,,,,459,,63,93,49,63,93,49,93,49,93,49,49,49,228,270,,207,
     291,196,,,,334,256,352,281,277,245,281,104,402,56,104,56,56,,104,56,
     104,402,56,500,56,56,55,55],
   [126,227,,324,227,174,348,192,,,63,102,,63,102,,,,102,57,61,57,232,272,
     316,197,268,216,,301,,317,252,328,285,285,269,285,106,332,84,106,84,
     76,348,106,,106,348,81,332,81,,55,55,55],
   [126,,182,,246,168,442,,,,63,104,61,63,105,61,,59,,,61,57,232,373,341,
     207,305,220,,331,,,289,350,285,285,273,285,106,402,84,106,84,80,524,
     106,77,106,,,502,91,91,55,55,55,55],
   [126,233,146,,201,152,,186,357,,63,93,49,63,93,49,93,49,93,49,49,49,
     232,254,340,193,,196,215,303,,337,,346,277,281,245,277,100,302,56,100,
     56,56,302,100,56,100,304,56,304,56,56,55,55,49,55,55],
   [58,,,,70,88,87,85,81,,64,,,68,,,68,54,68,,56,58,52,,,61,,57,83,67,,64,
     66,73,276,292,264,260,53,,,57,,54,93,52,64,52,88,63,97,53,63,372,
     388,360,356,372,370],
   [72,,,,89,76,110,99,100,,66,,,54,,,,53,,55,55,53,61,,,49,,57,60,71,,71,
     56,73,279,249,263,249,55,,,49,,52,115,49,64,55,112,62,117,63,65,369,
     339,353,339,369,331,57],
   [72,79,79,91,,,,111,89,,64,69,48,68,72,48,67,46,70,48,44,46,61,78,72,
     61,72,44,,,,71,60,66,272,284,236,256,59,95,48,59,48,44,,53,48,57,93,
     47,88,48,48,360,376,324,340,360,334,57,57],
   [58,,68,83,66,60,83,,,,53,51,49,49,51,49,,,50,44,44,48,52,,,49,58,52,
     53,64,,64,58,,222,218,214,196,45,90,,45,,42,94,38,,42,124,43,92,43,
     55,294,290,286,268,294,288,50,47,50],
   [58,,80,83,70,90,87,,,,64,66,,68,66,,70,54,,,56,56,52,,65,61,70,57,87,
     67,,,68,73,276,292,260,260,53,88,69,57,69,54,95,52,63,52,,,95,53,64,
     372,388,356,356,372,370,50,57,57,50],
   [72,97,63,,,68,90,87,106,,66,65,44,54,69,44,69,41,65,47,47,41,61,54,
     72,49,60,51,54,61,,73,,77,271,245,235,241,55,113,45,49,45,44,110,49,
     46,55,113,46,116,46,46,353,327,317,327,357,299,57,47,51,47,57],
   [72,79,,91,68,81,77,103,89,,64,,62,68,,62,66,54,66,56,,58,61,86,72,61,
     70,52,,60,,71,68,,276,292,264,260,59,99,56,59,56,52,90,53,67,57,93,
     53,,,64,372,388,360,356,372,370,57,57,50,50,57,57],
   [18,,,,33,30,58,30,,,9,,,9,,,15,11,15,11,11,11,36,,,30,,36,,53,,53,49,,
     45,45,45,45,16,,,16,,14,79,16,16,16,79,16,,16,16,63,63,63,63,63,63,
     60,54,60,45,60,54,60],
   [18,,,,33,30,58,30,,,9,,,9,,,15,11,15,11,11,11,36,,,30,,36,,53,,53,49,,
     45,45,45,45,16,,,16,,14,79,16,16,16,79,16,,16,16,63,63,63,63,63,63,
     60,54,60,45,60,54,60,9],
   [18,41,28,64,,,,28,56,,9,13,13,9,13,13,13,11,13,11,11,11,36,50,52,31,
     44,36,,,,53,44,52,45,45,45,45,16,90,16,16,16,12,,16,14,16,,14,90,
     14,14,63,63,63,63,63,63,58,57,58,44,58,57,58,9,9],
   [18,31,30,46,31,26,48,28,48,,9,16,13,9,13,13,,,13,11,11,11,36,52,48,
     29,40,36,37,48,,48,40,49,45,45,45,45,16,48,17,17,17,13,48,16,,17,
     48,15,48,15,15,63,63,63,63,63,63,56,51,56,40,56,51,56,9,9,9],
   [18,,28,76,37,,60,,,,9,13,13,9,16,13,13,11,,,11,11,36,49,52,31,44,36,
     49,51,,,44,52,45,45,45,45,17,70,17,16,17,13,70,17,15,16,,,70,15,15,
     63,63,63,63,63,63,58,57,58,44,58,57,58,9,9,9,9],
   [18,31,28,48,31,24,50,28,48,,9,13,13,9,13,13,13,11,13,11,11,11,36,
     48,50,29,45,36,35,50,,50,,51,45,45,45,45,16,48,16,16,16,12,48,16,
     14,16,48,14,48,14,14,63,63,63,63,63,63,60,51,60,42,60,51,60,9,9,
     9,9,9],[18,37,,76,37,28,64,28,56,,9,16,13,9,13,13,15,11,13,11,,
     11,36,79,51,31,44,36,,53,,53,44,,45,45,45,45,16,,17,17,17,13,70,16,
     15,17,70,15,,,15,63,63,63,63,63,63,58,57,58,44,58,57,58,9,9,9,9,
     9,9],[18,31,28,48,31,26,48,32,48,,9,13,13,9,16,13,13,11,15,11,11,
     ,36,48,48,29,40,36,37,48,,48,40,49,45,45,45,45,17,48,17,16,17,13,
     48,17,15,16,48,15,48,15,,63,63,63,63,63,63,56,51,56,40,56,51,56,9,
     9,9,9,9,9,9],[,,,,,,,,,,,,,,,,,,55,59,,43,,,,,,,,,,,,,,,,205,,,,,,49,,37,
     43,41,,40,,,42,,,287,,,239,,,78,55,,66,80,,,41,37,41,35,,37],
   [,,,,,,,,,,,,,,,,,26,,,,26,,,,,,52,,70,,,76,71,,,124,128,,,,,,,,24,,,,,,,,,,164,
     162,178,148,,,88,71,75,88,94,,,32,26,28,24,,26],
   [,,,,,,,,,,,,,,,,54,52,72,,,72,,,,,,,,,,,72,,,,359,246,,,,,,68,,48,80,62,,52,,
     ,51,,,,332,,,,,,46,,,,,,56,48,,48,56,48],[],[],[],
   [,,,,,,,,,,,35,18,,33,18,,20,,18,,18,,,,,92,50,,67,,,77,162,,,,128,20,54,
     19,20,19,18,54,24,21,20,54,19,54,21,19,,,158,,182,146,79,88,79,73,,
     96,83,,,28,30,28,28,,28,,24],
   [,,,,,,,,,,,73,50,64,71,50,53,38,66,56,56,44,,,,,88,,,,,,66,,360,269,325,,
     60,,40,54,40,,,46,39,56,,42,,42,39,412,338,,316,436,343,73,51,69,46,
     75,47,73,58,58,,46,64,46,64,52,,,46],[],
   [,,,,45,30,78,36,86,,,,,,,,,,24,13,,13,,,,,,43,40,62,,,49,,,,54,63,,,,,,12,,
     ,,16,,12,,,12,,,74,86,,70,,,62,48,67,63,62,,,12,14,13,12,14,13,36,,,,,
     ,27,62],[,,,,57,28,116,36,,,,,,,,,,,19,15,,15,,,,,,48,,68,,83,69,78,,,
     59,63,,,,,,24,96,24,,24,74,24,,,24,,,81,83,83,81,,,84,67,,80,92,,,13,,
     13,13,,13,,28],[18,43,,,,20,,,,,9,15,7,9,15,7,15,7,15,7,7,7,32,,
     48,31,44,28,33,,,51,40,51,39,39,35,39,16,46,8,16,8,8,46,16,8,16,
     46,8,46,8,8,53,53,49,53,53,49,52,57,48,44,52,53,52,9,9,9,9,9,9,
     9,9,43,20,,,,,,,,10,11],[],[],
   [,34,27,64,40,,59,29,,,,,,18,24,,,,,13,,13,45,41,52,36,49,43,,54,,54,
     45,62,66,66,54,70,19,56,10,17,10,12,51,19,10,17,55,10,54,10,10,86,
     86,74,86,86,70,67,62,62,49,62,58,69,15,15,12,,13,12,14,13,,30,78,,,,
     ,66,,12,,10],[,73,50,72,44,30,85,38,75,,,,,13,19,,,,,15,,15,,91,
     102,46,54,48,45,71,,,50,80,65,65,59,61,24,65,,24,,24,67,,,24,67,24,,
     ,24,87,87,81,83,85,81,83,74,80,58,81,68,86,11,11,13,11,11,11,11,
     11,,28,72,,,,50,56,,,13,11],
   [,37,,57,31,26,,,61,,15,20,13,18,14,13,21,12,15,14,12,13,48,48,54,36,
     47,,37,50,,61,46,60,79,83,74,78,21,45,14,15,14,13,53,22,13,16,48,
     15,52,13,14,105,,95,103,99,104,68,64,,51,67,63,67,15,15,14,14,16,
     14,14,15,52,29,,,,,,,,16,17,,,,16,17],
   [30,,30,98,,26,56,,62,,11,18,9,13,21,9,18,9,21,11,9,9,46,43,67,,70,,
     38,74,,58,,61,55,55,53,57,19,50,10,22,10,10,50,19,10,22,50,12,50,
     10,10,73,73,71,75,75,71,74,,69,61,76,62,71,11,11,11,11,13,11,11,
     11,45,26,71,,,,30,,,12,13,,,,12,13],
   [,,,,64,28,118,36,,,,,,13,19,,,,19,15,,15,50,,74,46,68,48,52,87,,71,62,,
     63,61,59,,,97,,24,,24,77,26,,28,,24,103,,24,83,83,81,95,89,81,86,82,
     73,76,92,80,,11,11,11,11,11,13,11,11,,32,,,,,,,,,13,11,,,,13,17,13],
   [,53,,,,26,,30,,,11,18,9,13,21,9,18,9,21,9,9,11,,,69,46,63,46,42,68,,
     73,68,64,57,57,53,57,19,58,10,22,10,10,58,19,10,22,58,10,58,10,12,
     73,75,71,73,73,75,67,78,78,63,67,74,80,11,11,11,11,11,11,11,13,52,
     26,,,,,,,,12,13,,,,12,13,,11,13],
   [,,,,37,,52,,,,,,,,,,53,35,,,,35,,,,,,56,,66,,63,74,73,,,278,210,,,,,,,44,,,,,
     ,44,,,,,336,258,289,215,,,85,86,87,103,85,,,,37,49,35,,37,,,,,,,39,,,,,
     33,,,40,61,38,38,51,42],
   [,,,,66,79,82,,,,,,,,,,59,47,65,64,49,49,,,,,,54,72,63,,,69,65,,,,240,,,,,,
     48,88,47,58,51,,49,90,47,57,,,343,,349,344,,,53,46,,57,55,,,52,49,52,
     51,,49,49,,,,,,,62,,55,,51,,,,81,61,66,87,72],
   [36,,58,,46,,64,64,,,36,46,46,36,46,46,,40,,36,,38,34,55,56,34,56,32,
     58,43,,56,56,49,168,168,164,168,34,,,34,,32,68,34,46,34,,47,68,46,,
     232,232,228,232,232,232,61,61,50,46,61,61,54,36,36,36,36,36,36,36,
     36,52,54,62,,,,68,58,,46,52,32,,,,60,46,48,,46,,46],[],[],
   [36,33,54,72,33,54,72,,,,34,37,46,30,36,46,37,,,33,33,,34,82,60,36,47,
     34,61,60,,61,43,61,153,143,153,143,32,57,30,30,30,32,57,30,29,32,
     57,29,57,29,29,207,197,207,197,207,193,61,58,61,47,61,54,61,30,30,
     31,29,31,29,31,29,55,44,74,,,,65,66,,36,54,31,,,,,,42,46,46,35,50,34 
    ],[,52,72,,46,77,52,96,88,,57,44,50,66,48,50,49,,51,44,44,64,45,
     81,73,47,54,54,87,45,,,51,47,229,,221,196,44,66,41,40,41,42,44,40,
     39,44,66,39,42,39,39,300,314,293,268,300,336,70,61,53,53,70,57,53,
     49,49,44,40,44,45,44,40,78,60,85,,,,72,97,,49,68,44,,,47,,61,58,72,
     54,44,53,46],[],
   [,,,,65,72,81,,,,70,,89,58,59,89,65,47,,,49,53,,104,,60,73,52,,63,,,67,
     70,257,256,251,238,60,,58,55,58,48,103,,47,,,47,88,53,47,340,340,333,
     317,358,342,64,56,49,46,65,52,53,53,53,52,48,51,51,52,48,55,,62,,,,,,
     ,55,100,48,,,64,64,58,64,88,78,,46,45,,,47,52],
   [62,,,,65,,81,115,,,,,58,58,65,58,59,53,,49,,47,45,66,67,60,46,43,66,50,
     ,67,45,56,258,,,238,52,,58,54,58,53,101,48,,50,,55,90,47,,340,338,
     344,318,343,340,71,56,57,56,72,57,61,53,53,52,48,51,51,,48,66,77,74,
     ,,,90,70,,54,74,48,,,,69,64,63,,82,,57,,,,47,52,,56],
   [62,,,76,46,91,44,90,76,,,51,,,49,,48,64,44,44,44,,46,90,72,47,54,52,,
     42,,74,52,46,231,264,219,196,44,66,41,40,41,42,42,40,39,44,66,39,
     44,39,39,300,334,291,268,301,311,73,61,49,53,,57,55,,,44,40,44,44,
     44,40,80,60,89,,,,,81,,49,68,44,,,,90,56,50,67,58,44,55,45,,,,38,,52,
     52],[90,196,,318,218,142,,,324,,45,76,53,45,,53,79,,77,,43,47,168,
     313,258,153,229,164,,259,,,225,,41,41,39,43,78,432,85,78,85,64,432,
     78,75,78,,61,340,63,,285,285,281,285,285,277,276,279,272,222,276,271,
     276,45,45,45,45,45,45,45,45,252,128,328,,,,,320,,71,63,39,,,68,,81,
     55,61,55,226,271,168,,,153,229,,,265],
   [90,167,130,283,,122,,194,277,,45,82,49,45,79,49,79,47,82,,,47,168,229,
     258,143,264,160,,254,,256,,,41,43,41,43,78,292,70,78,70,60,350,78,,
     78,278,61,304,75,61,285,285,277,285,285,281,292,249,284,218,292,245,
     292,45,45,45,45,45,45,45,45,181,,297,,,,130,,,66,69,39,,,,,78,,63,57,
     203,264,168,,,143,,,256,256,,41],
   [90,237,,312,,136,,208,,,45,67,35,45,67,35,67,35,67,35,35,35,164,215,
     260,153,222,140,278,223,,251,194,,41,39,35,41,76,,40,76,40,40,428,76,
     40,76,328,40,428,40,40,273,273,245,269,273,245,264,263,236,214,260,
     235,264,45,45,45,45,45,45,45,45,,136,318,,,,,,,54,59,35,,,54,59,71,
     53,59,55,226,257,164,,,153,219,,,251,221,41,41],
   [,,,,,60,,70,,,,,,,,,76,42,80,44,,42,,,,,,,53,,,,62,,,,323,,,,,,,42,,70,43,
     74,,43,,,39,,,395,386,529,396,,,,74,,51,,,,72,68,70,70,,68,,,,,,,,50,,,,,,
     ,55,132,,63,,,,,66,,,,91,,70,77,,449,400,423],
   [,,,,49,34,72,41,110,,,,,,,,17,,19,19,,19,,,,,,61,47,73,,,61,77,,,81,95,,,,
     ,,28,63,26,,28,69,28,58,,28,,,111,125,125,111,,,88,63,84,79,92,,,17,,
     17,17,,17,,,,,,,45,81,,,,17,,,,20,22,20,20,20,45,,60,,,51,81,,86,,58,
     100,114,81],[18,35,,48,,20,56,22,,,18,15,14,18,15,14,15,14,15,14,
     14,14,32,,44,29,40,28,31,,,45,36,47,75,75,65,75,16,42,15,16,15,14,
     42,16,15,16,42,15,42,15,15,101,101,91,101,101,91,52,51,44,40,52,47,
     48,16,16,15,16,16,15,16,16,35,20,48,,,,18,,,19,20,13,,,19,20,18,21,
     20,,31,45,32,,,29,40,,44,46,40,75,75,65,,17],[],[],
   [18,34,24,55,32,24,63,24,57,,16,,18,18,24,18,20,,22,17,16,17,34,35,
     57,30,40,34,35,54,,56,36,54,78,78,76,78,16,53,15,18,15,16,53,16,
     15,18,53,14,53,15,14,106,106,104,106,106,100,57,50,59,40,57,46,59,
     16,16,16,16,17,16,16,17,35,24,44,,,,26,44,,19,24,16,,,,,21,19,24,19,
     35,49,34,,,27,,,46,45,60,78,78,76,46,,16],
   [,101,,63,50,35,92,41,66,,,,,18,19,,19,,21,19,,19,,,87,48,65,61,50,71,,
     80,63,,128,103,81,,,58,,29,,28,,26,,28,63,28,69,,28,158,129,111,128,,
     111,105,81,85,61,84,79,,16,16,17,16,15,15,16,15,,35,,,,,45,73,,,20,
     17,,,,,22,20,20,20,52,91,60,,,,,,77,92,79,132,,81,,17,17],
   [18,33,,54,31,20,,24,52,,16,13,12,14,15,12,13,12,15,11,12,11,32,,46,
     29,47,28,31,42,,,43,46,65,65,57,65,14,42,13,16,13,12,42,14,13,16,
     42,12,42,13,12,87,87,79,87,87,79,49,51,50,43,49,47,54,14,14,13,14,
     13,13,14,13,36,20,58,,,,,,,17,18,13,,,17,18,20,16,18,16,31,52,32,,,
     29,40,,,47,40,65,65,57,,15,13,,,14,15],
   [,,,,,88,,,,,,,82,96,105,82,72,62,74,60,,56,,,,102,126,,79,,,,,,,,,,,,72,
     89,72,58,,70,63,70,,59,,,57,588,848,812,510,,634,122,81,120,74,129,
     77,114,92,92,70,72,70,68,,66,,,78,,,,,,,,,,,,85,110,,93,,,,,90,,,,129,,,
     115,127,571,724,,74,,,,,70],
   [18,,28,46,,20,,28,42,,18,15,14,18,15,14,15,14,15,14,14,14,32,,42,29,
     40,28,31,40,,,36,44,75,75,65,75,16,38,15,16,15,14,38,16,15,16,38,
     15,38,15,15,101,101,91,101,101,91,49,51,45,40,49,47,49,16,16,15,16,
     16,15,16,16,37,20,48,,,,18,,,19,20,13,,,19,20,,,20,21,29,47,32,,,27,
     36,,45,45,36,75,75,65,76,17,13,,,16,17,13,76],
   [34,,,92,,31,,41,62,,18,15,14,18,26,14,15,14,25,15,14,13,56,,97,44,61,
     75,44,,,66,59,65,,90,89,93,16,55,15,27,15,14,59,16,15,26,52,16,59,
     15,14,117,118,112,121,122,119,77,73,80,59,78,73,76,16,16,15,16,17,
     15,16,15,49,33,67,,,,31,97,,19,20,,,,19,20,,,20,18,44,71,68,,,46,69,,
     72,64,73,89,92,87,,17,,,,16,17,13],
   [,,,,,60,,70,,,,,,,,,83,46,83,44,,40,66,40,85,102,42,64,44,101,,103,40,
     88,681,,,468,,,42,,42,42,,70,86,74,,40,,43,43,569,406,478,402,749,,92,
     52,90,52,98,51,94,,,72,68,70,70,,68,56,,62,,,,,62,,87,,,,,55,120,61,
     63,,,,79,,,,74,92,,81,,,519,356,406,51,,,,,46,,,94,76],
   [,,,,44,33,72,41,98,,,,,18,19,,17,,19,19,,19,,,74,46,65,61,47,69,,74,
     60,102,97,,81,104,,82,,29,,28,58,28,,30,,28,65,,28,125,125,111,,,111,
     84,79,85,69,91,79,102,16,16,15,16,15,17,16,15,,39,,,,,45,80,,,20,17,,
     ,,20,22,20,,20,45,,58,,,49,,,,,63,97,97,81,,17,17,,,,17,15,,17,17],
   [34,40,,68,75,31,60,,,,18,15,14,18,26,14,15,14,25,13,14,15,56,,62,46,
     56,55,43,89,,67,55,67,89,96,86,,16,59,15,27,15,14,55,16,15,26,59,
     14,52,15,16,118,119,111,116,,117,78,75,78,59,78,73,78,16,16,15,16,
     15,15,16,17,54,33,78,,,,31,,,19,20,,,,19,20,,18,20,,41,75,,,,,51,,76,
     98,52,92,,,,17,,,,16,17,13,,,15,,17],
   [126,258,,430,252,180,410,200,,,63,102,,63,103,,103,57,104,61,57,57,232,
     402,342,207,301,220,335,332,,341,284,348,285,285,273,285,106,414,82,
     106,82,80,,106,,106,408,,412,77,77,55,55,53,57,57,53,372,369,360,294,
     372,353,372,63,63,63,63,63,63,63,63,299,168,404,,,,,,,91,85,53,,,88,
     87,103,73,85,75,284,357,232,,,207,300,,341,340,299,285,285,273,565,
     129,101,,,106,,87,594,101,115,545,126,117],
   [126,225,162,348,214,160,390,214,368,,63,105,63,63,105,63,106,57,104,59,
     59,61,232,300,342,197,,220,247,330,,338,318,349,285,285,273,285,106,
     370,101,106,101,80,350,106,77,106,350,,370,,77,55,57,55,57,57,53,388,
     339,376,290,388,327,388,63,63,63,63,63,63,63,63,243,,367,,,,162,338,,
     86,91,53,,,,,102,73,83,75,260,349,232,,,197,,,340,347,314,285,285,273,
     423,143,101,,,106,,87,716,101,,400,125,122,55],
   [126,258,,394,259,,401,,400,,63,93,49,63,93,49,93,49,93,49,49,49,228,
     270,333,207,296,196,336,300,,336,259,341,281,277,245,281,104,500,56,
     104,56,56,402,104,56,104,,56,402,56,56,55,53,49,55,53,49,360,353,
     324,286,356,317,360,63,63,63,63,63,63,63,63,288,164,394,,,,,,,74,81,
     49,,,74,81,95,71,81,71,,342,228,,,207,290,,,333,291,281,277,245,489,
     111,91,,,104,111,79,,91,111,395,111,117,55,55],
   [126,,162,324,223,164,352,200,324,,63,102,63,63,106,63,102,61,,61,61,57,
     232,283,316,197,268,216,292,300,,318,252,327,285,285,269,285,106,302,
     101,106,101,76,358,106,79,106,,77,302,,79,55,57,53,57,55,53,356,339,
     340,268,356,327,356,63,63,63,63,63,63,63,63,297,162,324,,,,162,,,,85,
     53,,,88,,,,89,75,256,328,232,,,197,268,,320,317,268,285,285,269,422,
     126,101,,,106,125,87,,101,,380,,117,55,55,55],
   [126,282,180,404,,,,216,,,63,107,67,63,102,67,105,,104,61,57,57,232,,340,
     207,298,220,348,,,343,287,350,285,285,273,285,106,406,84,106,84,80,
     414,106,79,106,512,77,,77,,55,57,53,57,57,55,372,369,360,294,372,357,
     372,63,63,63,63,63,63,63,63,290,,452,,,,180,380,,87,83,53,,,86,83,,77,
     ,73,289,350,232,,,207,,,344,,299,285,285,273,515,126,101,,,106,125,87,
     786,101,119,,,118,55,55,55,55],
   [72,72,91,,70,,92,105,81,,64,68,60,68,68,60,,58,,56,,54,61,83,52,61,
     52,50,86,57,,53,49,62,276,292,264,260,59,,,59,,52,97,53,53,57,86,53,
     95,63,53,372,388,360,356,372,370,57,57,60,59,59,55,64,60,60,58,56,
     58,60,58,56,83,90,91,,,,95,81,,67,88,52,,,64,86,61,71,,78,83,73,52,,
     ,61,73,,71,64,70,276,292,264,94,86,48,,,59,86,54,125,49,92,84,86,
     78,372,388,360,356,372],
   [72,62,90,68,58,94,68,124,55,,66,66,62,54,65,62,66,49,69,55,55,,61,
     121,56,58,61,57,105,56,,56,58,57,279,249,263,249,56,53,52,50,52,52,
     53,50,49,56,51,49,51,49,49,369,339,353,339,369,331,57,64,57,59,59,
     60,59,54,54,57,51,57,51,57,51,97,76,106,,,,87,98,,62,90,57,,,,,,66,
     82,78,60,73,61,,,49,,,73,71,60,279,249,263,,84,51,,,49,,51,163,45,75,
     111,82,92,369,339,353,339,369,57],
   [58,,68,,65,88,83,,83,,64,71,45,68,71,45,72,46,69,44,48,46,52,81,,61,
     73,51,,62,,65,60,72,272,284,236,256,53,,49,57,49,46,95,52,47,52,88,
     47,93,48,47,360,376,324,340,360,334,50,55,51,50,48,51,55,60,60,58,
     56,58,60,58,56,,75,83,,,,,,,63,73,48,,,65,77,63,72,84,65,,66,61,,,61,
     72,,,71,70,272,284,236,85,86,48,,,57,82,45,,45,77,90,83,78,360,376,
     324,340,360,57,57],
   [58,,76,46,40,81,57,87,46,,53,51,,49,51,,51,42,51,44,44,42,52,84,45,
     47,53,42,86,52,,45,49,57,222,218,214,196,44,44,41,40,41,42,51,40,
     39,44,44,39,51,39,39,294,290,286,268,294,288,50,59,55,52,50,55,59,
     45,45,44,40,44,42,44,40,,60,87,,,,,,,49,64,44,,,49,63,,,73,60,53,,52,,
     ,49,58,,64,64,58,222,218,214,93,65,40,,,45,,40,136,36,,92,69,61,294,
     290,286,268,294,50,47,50],
   [72,74,95,,71,77,87,107,83,,64,70,60,68,75,60,68,56,68,56,,54,61,83,
     52,61,53,50,86,57,,53,52,63,276,292,260,260,59,,69,59,69,48,95,53,,
     57,90,63,95,53,63,372,388,356,356,372,370,57,59,60,59,59,57,64,60,
     60,58,56,58,60,58,56,83,88,91,,,,91,81,,64,86,52,,,63,82,64,73,,78,
     87,73,52,,,61,70,,71,,72,276,292,260,94,87,48,,,59,87,54,129,49,81,,,
     77,372,388,356,356,372,50,57,57,50],
   [72,64,,,,88,53,108,51,,66,69,44,54,65,44,65,41,69,47,47,41,61,,57,54,
     57,51,103,48,,52,55,57,271,245,235,241,52,47,48,46,48,44,47,46,45,
     52,47,45,47,45,45,353,327,317,327,357,299,57,60,51,55,55,56,57,54,
     54,57,51,57,51,57,51,101,68,,,,,63,84,,58,80,53,,,63,68,63,62,80,74,
     54,77,61,,,49,60,,71,73,,271,245,235,176,83,47,,,49,83,47,154,41,75,
     112,83,75,353,327,317,327,357,57,47,51,47,57]],
 [,[],[],[],[,27],[,,22],[,,,41],[,,26,,,26],[,,,36,43,,41],
   [,,,41,,,36,,41],[18,,,,,,,20],[,29,,,34,,,25,55,47],[],
   [18,27,28,43,27,32,43,32,43,43,9,15],[,37,34,,,,54,30,,,10,16],
   [,37,34,53,37,40,47,32,55,,11,17],[],
   [34,39,24,59,35,32,53,26,55,55,,,,11,12,13],
   [,30,27,59,,29,45,,,,10,16,,,12,,,12],[,57,36,,,,,28,,,11,17,,,,13,,13]
    ,[,,32,,56,,,26,,,,,,11,12,13,,11,12,13],
   [30,33,34,57,43,40,51,28,,59,11,17,,,,13,,13,,13,13],
   [36,,,,,,,,,64,32,,,36,,,,50,,,46,50],
   [,,,,,,,40,,,,,,37,40,45,,41,37,67,,45],
   [,37,,,52,,,,56,,,45,,52,60,62,,64,52,77,70,62],
   [36,45,45,54,45,45,54,42,54,54,31,35,,27,,,,39,33,50,44,,34,33,43],
   [,70,71,82,74,71,79,64,84,84,53,52,,,41,,,,48,75,59,84,47,47,57],
   [36,,,,,,,52,64,,28,,,36,43,48,,44,43,48,44,48,34,,,34,47],
   [,,,,,,,40,,,,,,41,,51,,41,39,,,51,,29,,33,47],
   [,48,,,45,,,,64,56,,51,,52,,62,,60,57,,76,70,,,48,43,56],
   [,,43,,,43,,,,,33,37,,41,36,39,,35,,,42,43,,33,,33,46,,33],
   [,45,,56,52,93,59,,,63,57,50,,52,,68,,56,52,,,78,,,43,43,56,50,,48],
   [82,75,76,86,79,76,82,68,88,90,54,55,,,45,,,54,51,70,66,,50,50,61,,43,
     50,50,59,49,59],[82,42,,63,45,,46,80,63,,,,,52,60,58,,66,53,72,,66,
     47,,42,43,56,,,43,,48,59],
   [90,,,,,,,140,371,376,39,,,45,67,,,57,66,61,55,63,168,,,151,241,164,,,,
     279,254,259],[90,121,122,192,129,120,188,122,192,192,39,,,45,,,,,71,
     65,55,,168,159,223,129,,160,159,231,161,231,,223,41],
   [90,,,,,,,136,,284,35,,,45,54,59,,55,54,59,57,59,164,,,149,229,140,,,276,
     258,242,,41,41],[90,121,126,182,129,122,174,122,182,182,39,79,,45,,
     63,,,67,65,57,,168,159,213,129,206,164,167,221,161,221,,213,41,41,41],
   [18,,,,,,,20,52,,13,,,18,19,20,,23,19,20,,20,32,,,29,45,28,,,31,49,48,
     45,75,75,65,75],[,,,,,,,,42,47,,,,57,50,67,,55,,,,71,,,,66,91,,,,,62,
     86,,,216,,204],[],
   [18,25,24,34,25,24,34,24,34,34,16,21,,16,,,,19,19,26,19,,34,33,43,25,,
     34,33,43,33,43,,43,78,78,76,78,16,40],
   [,57,43,77,55,43,73,40,,,17,22,,,,,,20,,20,20,20,,53,81,,,61,53,79,46,
     97,119,75,,,81,96,17],
   [18,,,,,,,20,56,58,13,,,16,17,18,,16,17,18,16,18,32,,,29,45,28,,,31,48,
     48,47,65,65,57,65,13,,,14,15],
   [,,,,,,,,51,48,,,,57,52,65,,59,60,,,69,,,,70,112,,,,,74,122,64,,222,,220,,
     47,,42],[18,21,20,34,25,20,30,20,34,34,13,18,,18,19,20,,,19,20,27,
     20,32,27,37,25,47,28,27,41,27,41,47,37,75,75,65,75,13,44,,16,17,
     13,44],[,,44,,53,37,71,34,72,,,,,18,19,20,,,19,20,18,20,76,47,87,
     45,139,,45,73,42,68,72,88,94,92,85,,,,,16,17,13],
   [18,37,22,62,39,22,56,,,60,16,21,,16,19,24,,19,,,19,26,34,32,53,30,45,
     34,32,51,,,48,50,78,78,76,78,16,,,16,,14,,16,16],
   [,,,46,49,,47,,,53,,,,57,52,65,,57,,,,69,,,66,70,112,70,,74,,,122,72,,
     224,678,214,,42,,42,,,47,38],
   [36,57,43,,,43,73,,,77,17,22,,,,20,,20,,,20,20,61,48,83,49,,61,48,104,
     44,,61,82,99,101,81,111,17,,,,17,15,,17,17],
   [,63,,49,,,40,,47,,,,,57,50,67,,55,57,,,71,96,,68,66,91,,,64,,68,86,,,
     218,374,206,,39,,40,,,42,44,,,47],
   [,,39,,53,37,,34,70,,,,,18,19,20,,18,19,20,,20,,49,,,53,55,40,76,40,99,
     58,,92,,92,93,,,,16,17,13,,,15,16,,17],
   [36,53,43,77,57,43,73,38,,79,17,22,,,,20,,20,,20,20,,61,53,77,,,61,53,
     81,48,97,,79,96,109,81,101,17,,,,17,15,,17,17,,,17,,17],
   [126,,,,,,,180,383,427,53,,,63,86,,,75,,85,75,83,232,,,201,313,220,,,,347,
     330,330,285,285,273,285,101,,,106,,87,,101,119,106,471,125,537,118,125]
    ,[126,167,162,260,179,162,248,160,260,260,53,105,,63,,,,73,86,85,73,
     87,232,213,301,179,,220,213,313,211,313,323,297,285,285,273,285,101,
     284,,106,,87,294,101,,106,294,129,286,118,,55],
   [126,,,,,,,,,449,49,,,63,74,81,,,74,81,71,81,228,,,201,305,196,,,274,334,
     322,318,281,277,245,281,91,,,104,111,79,,91,113,104,709,111,489,115,
     111,55,55],[126,167,166,250,179,160,238,160,250,250,53,104,,63,86,,,,
     86,,77,85,232,215,291,179,277,216,219,303,213,303,299,287,285,285,269,
     285,101,280,,106,125,87,290,101,,106,284,166,280,121,,55,55,55],
   [126,218,180,,227,190,338,,,429,53,102,,63,83,83,,75,,,75,87,232,469,328,
     199,310,220,,339,,,330,339,285,285,273,285,101,416,,106,126,87,668,101,
     116,106,,,,123,137,55,55,55,55],
   [126,147,152,252,179,156,220,148,252,252,49,,,63,70,81,,,70,81,,81,232,
     201,269,175,,196,201,305,199,305,,269,277,281,245,277,91,260,,100,111,
     79,274,91,112,100,276,111,262,111,111,55,55,49,55,55],
   [62,,,,,,,78,80,92,56,,,68,67,94,,76,,,78,82,54,,,61,73,57,,,,65,75,68,
     284,294,272,274,52,,,59,,54,,52,98,55,100,89,94,78,88,384,394,372,
     374,384,378],[72,77,79,94,85,79,86,70,94,94,57,59,,45,,,,57,53,84,
     76,71,61,57,66,43,,57,57,70,54,70,59,66,273,207,251,207,51,106,,43,,
     51,114,39,70,50,114,76,106,80,,351,285,335,285,345,277,57],
   [72,,,,,,,88,89,81,52,,,68,68,80,,72,68,84,68,80,61,,,61,73,46,,,85,73,
     75,55,280,286,244,270,50,,,59,84,48,,48,,59,104,85,83,78,89,372,382,
     336,358,372,342,57,57],
   [62,66,67,78,69,67,74,60,78,79,48,50,,43,47,57,,,46,71,65,57,54,54,
     63,43,,54,54,63,51,63,62,63,226,192,214,182,43,93,,41,,43,108,36,,
     43,102,,93,61,64,294,260,286,250,290,256,52,41,52],
   [62,70,89,80,78,101,81,,,90,56,66,,68,66,82,,74,,,80,86,54,,61,61,73,
     57,102,72,,,75,68,284,294,268,274,52,85,,59,87,54,108,52,79,55,,,92,
     78,105,384,394,368,374,384,378,52,57,57,52],
   [72,69,71,94,85,71,78,62,94,94,53,55,,45,60,59,,59,49,80,74,59,61,51,
     60,43,57,51,51,70,48,70,,60,265,203,223,199,47,108,,43,78,47,114,35,
     ,46,114,79,108,,78,335,273,299,273,333,245,57,41,51,41,57],
   [72,74,103,93,73,95,72,92,89,,56,,,68,,84,,74,66,88,,86,61,146,69,61,
     73,54,,65,85,72,76,,284,294,272,274,54,96,,59,84,52,102,52,96,59,
     109,87,,,,384,394,372,374,384,378,57,57,52,52,57,57],
   [18,,,,,,,20,,54,7,,,9,10,11,,9,10,11,9,11,32,,,28,43,28,,,30,47,46,,
     39,39,35,39,13,,,14,15,11,,13,13,14,,15,,13,15,53,53,49,53,53,49,
     52,48,48,41,52,44,52],
   [18,27,26,40,27,28,40,26,40,40,9,14,,9,,,,11,14,11,11,11,36,35,49,27,
     ,36,37,49,35,49,50,49,45,45,45,45,16,50,,16,,14,50,16,16,16,50,16,
     50,16,16,63,63,63,63,63,63,62,45,62,40,62,45,62,9],
   [18,,,,,,,20,,54,7,,,9,10,11,,9,10,11,9,11,32,,,28,43,28,,,30,47,46,,
     39,39,35,39,13,,,14,15,11,,13,13,14,,15,,13,15,53,53,49,53,53,49,
     52,48,48,41,52,44,52,7,9],
   [18,21,22,34,25,20,30,20,34,34,7,16,,9,10,11,,,10,11,9,11,32,27,37,
     25,37,28,29,41,27,41,38,37,39,39,35,39,13,36,,15,16,12,38,13,,15,
     36,16,36,14,16,53,53,49,53,53,49,50,39,46,34,50,35,50,7,9,7],
   [18,32,26,50,32,,54,,,,9,14,,9,14,11,,11,,,11,11,36,37,51,29,44,36,49,
     50,,,46,50,45,45,45,45,16,72,,16,16,14,72,16,16,16,,,72,16,16,63,
     63,63,63,63,63,60,51,60,42,60,51,60,9,9,9,9],
   [18,21,20,36,25,24,32,20,36,36,7,12,,9,10,11,,9,10,11,9,11,32,27,39,
     25,40,28,31,43,27,43,,39,39,39,35,39,13,36,,14,15,11,42,13,13,14,
     42,15,36,13,15,53,53,49,53,53,49,54,39,50,36,54,35,54,7,9,7,7,9],
   [18,26,20,44,30,20,40,20,42,,7,,,9,10,11,,9,10,11,,11,32,44,40,27,40,
     28,,45,29,45,42,,39,39,35,39,13,,,15,16,12,64,13,14,15,42,16,,,16,
     53,53,49,53,53,49,52,45,48,38,52,41,52,7,9,7,7,9,7],
   [18,27,26,38,27,28,38,26,38,38,9,14,,9,14,11,,11,14,11,11,,36,35,47,
     27,44,36,37,47,35,47,46,47,45,45,45,45,16,48,,16,16,14,48,16,16,
     16,48,16,48,16,,63,63,63,63,63,63,58,45,58,38,58,45,58,9,9,9,9,9,
     9,9],[,,,,,,,,,,,,,27,30,33,,,37,56,,37,,,,27,40,,,,,,43,,,121,,125,,,,
     27,42,,,21,,31,,42,,,46,,163,,167,,147,,48,,45,,42,70,,27,,21,31,21,,
     27],[,,,,,,,,,,,,,32,27,42,,30,,,,42,,,,48,77,,,,,,,,,114,,122,,,,24,,,,
     28,,,,,,,,,152,,158,178,138,,84,,77,81,86,,,28,,20,32,18,,28],
   [,,,,,,,,,,,,,43,,59,,51,63,,,,,,,45,57,,,,,,59,,,192,,182,,,,43,56,,,36,71,,
     ,63,,,,,260,,250,351,252,,41,,36,,41,,,40,,34,,36,42,38],
   [,,,,,,,,,,60,49,,27,38,47,,35,43,,56,37,51,37,83,27,51,54,37,85,,79,
     54,79,223,129,219,129,35,,,27,50,,,25,40,34,,,,44,42,255,179,,179,277,
     179,78,52,79,40,,52,80,35,27,35,25,35,25,31,27,27,,40],
   [,,,,,,,,,,20,30,,32,,28,,26,30,36,26,28,,,74,54,94,,,,,86,,,148,120,136,
     122,20,56,,24,32,20,58,20,30,24,58,34,56,30,32,172,158,164,162,,152,
     92,90,,76,88,88,78,20,26,20,20,28,20,20,26,,24],
   [,,,,,,,,,,,75,,43,43,71,,51,,,,55,64,,110,45,40,64,,95,46,95,42,95,316,
     192,,182,58,,,43,,58,,36,61,,,59,,55,,380,260,447,250,,252,90,41,90,
     43,90,39,,54,40,54,34,,36,,38,40,,41],
   [,,,,,,,,,,,37,,28,27,34,,24,34,36,32,34,,,,52,,,,,,,102,102,,122,,126,24,
     81,,24,51,,,28,50,28,,51,81,49,51,,162,,166,180,152,89,92,91,89,,92,
     101,,26,,22,26,20,20,26,,28,,,26],
   [,,,,,,,,,,,,,43,57,55,,55,54,94,,51,,,,45,,,,,,,60,,407,184,338,174,60,,,
     43,61,,,32,56,48,,62,,63,56,403,244,385,234,470,220,73,39,67,36,73,
     35,73,,40,,30,50,32,46,38,,,36,40,,41],
   [,,,,,,,,,,,,,43,,67,,51,,,,55,70,,113,45,40,64,52,92,55,,43,92,396,192,
     285,182,,,,43,71,56,,36,,54,,,,58,62,381,260,,250,355,252,89,43,89,43,
     89,41,93,48,40,48,34,46,36,44,38,43,,41,,,36,,41],
   [,,,,,,,30,66,,,,,18,19,20,,,19,20,,20,,,,,51,,,,33,69,55,,,81,,79,,,,16,
     17,,,,,16,,17,,,17,,103,,103,,98,,59,,48,67,,68,,16,,16,16,14,,16,27,,,
     37,25,45,52,60,51],
   [,,,,,,,26,,,,,,13,14,15,,,14,15,,15,,,,44,64,,,,42,76,66,69,,,,57,,,,22,
     23,,,21,,22,,23,,,23,,73,,73,73,71,,76,,63,,78,78,,13,,,13,11,,13,,22,
     ,53,26],[18,67,,,,30,,,,,9,18,,9,18,,,13,,13,13,13,36,,66,34,57,36,
     57,,,63,60,70,45,45,45,45,18,,,18,,14,91,18,18,18,87,18,,18,18,63,
     63,63,63,63,63,64,66,64,53,64,66,64,9,9,9,9,9,9,9,9,,,,,,,,,,15,11 
    ],[,37,,63,,34,54,30,,63,10,19,,18,10,,,14,12,23,14,23,45,48,56,,
     71,43,41,60,39,58,,56,71,66,54,77,19,46,,16,,15,50,19,19,17,50,28,
     46,19,28,91,86,74,97,83,70,70,60,68,51,72,60,70,10,13,10,10,13,10,
     10,13,33,23,48,30,,,29,43,59,16,12],
   [,56,,,,36,,32,,,11,20,,13,23,11,,15,,13,15,13,,,72,46,68,48,65,,,,84,
     82,73,,59,,20,,,24,17,16,101,20,20,24,97,18,,20,18,89,83,81,83,,81,
     92,82,76,67,86,80,,11,13,11,11,11,11,11,11,,,,,28,,,100,,17,13],
   [],[],[,33,29,47,30,27,57,,48,,10,19,,,12,23,,14,10,,14,23,47,39,
     53,33,49,43,37,52,,57,51,52,68,71,54,66,19,53,,17,28,15,72,19,19,
     16,53,,,19,28,88,,74,87,83,70,67,53,68,46,70,49,67,10,13,10,10,13,
     10,10,13,37,,,,30,63,,54,,16,12,,12],
   [30,37,40,69,,34,47,28,53,55,11,20,,,23,13,,15,23,11,15,13,50,51,62,,,
     48,45,74,39,62,,62,61,65,59,63,20,63,,,18,16,59,20,20,24,59,17,63,
     20,18,83,87,81,85,87,81,82,,80,59,84,59,86,11,11,11,11,13,11,11,
     11,37,38,57,49,30,59,40,55,67,17,13,,,13],
   [,,,,53,,,26,,,,,,13,14,15,,,14,15,,15,46,,67,44,64,44,,72,42,65,66,,57,
     55,,,,98,,22,23,,106,27,,22,,23,157,,23,73,73,71,75,75,71,78,76,68,
     65,80,74,,9,11,9,9,11,11,9,11,,26,,,26,,,,,,11,11,12,13,,,12,13],
   [,73,,,,36,,28,,,11,20,,13,,13,,15,23,13,15,11,,,82,50,88,48,65,79,63,
     98,114,72,63,63,59,71,20,,,24,18,16,101,20,20,,97,18,,20,17,83,85,
     81,91,89,81,78,84,84,71,82,80,88,11,11,11,11,11,11,11,13,56,,,,28,,
     ,100,,17,13,,,13,,,,13,13],
   [,,,,,,,,,,,,,41,39,51,,41,,,,51,,,,61,103,,,,,67,113,60,,159,,165,,,,33,,,,
     35,,,,,47,,,,215,,219,307,201,,105,,99,,105,,,37,,29,49,31,,37,,,,,40,,,,,
     ,,57,37,65,,,41,45,,65],
   [,,,,,,,,,95,,,,52,52,62,,58,60,77,70,62,,,,52,64,,,,,,66,63,,223,,217,,,,
     50,63,,,39,79,50,,68,130,61,71,,297,,291,327,269,,48,,43,,42,56,,49,,
     37,50,39,,47,37,,,52,80,63,,46,64,45,,70,55,72,,,56,66,70,77],
   [36,,58,,51,,,52,,64,32,46,,36,45,56,,48,,50,,52,34,61,61,34,61,32,86,
     47,,63,63,43,168,168,164,168,32,,,34,,32,72,32,58,34,,75,66,56,,232,
     232,228,232,232,232,61,61,54,47,61,61,58,32,36,32,32,36,32,32,36,
     47,68,64,,,,,60,,48,48,36,,,,,45,52,,50,,47],
   [,,,,33,,46,,,46,33,33,,41,,39,,35,36,,42,41,,,61,63,88,57,,60,,,97,60,
     252,157,,159,31,47,,33,47,31,44,27,43,37,49,47,42,43,51,306,215,274,
     213,287,199,87,103,85,83,,101,103,30,35,30,27,,27,29,35,,39,,,,,43,,,
     37,42,,,,,,39,39,42,63,33],
   [,,,,79,,84,,,95,62,67,,52,53,70,,56,66,,76,62,47,64,75,52,47,43,64,
     58,64,73,49,54,279,231,257,221,49,,,50,69,,111,43,62,48,,71,134,65,
     68,353,313,338,303,354,305,72,48,57,50,,46,61,50,49,50,41,51,43,44,
     47,48,,63,45,,,,59,56,54,64,,52,,,,60,78,83,76,,48],
   [36,27,52,45,27,52,45,48,45,45,31,35,,27,33,41,,,,50,44,,34,61,52,36,
     47,34,61,52,63,52,49,52,151,129,149,129,29,51,,27,45,29,51,25,43,
     29,51,49,51,43,49,201,179,201,179,199,175,61,50,61,45,61,46,61,28,
     27,28,25,29,25,27,27,45,45,54,45,42,54,45,54,54,35,44,34,33,46,,,,,
     44,50,33,43,34,33,43],[],
   [,,,,33,,51,,,46,,31,,37,33,49,,33,,,,49,,,,57,102,,,58,,,85,58,,155,,159,
     30,,,27,,30,44,35,47,,65,,40,41,,,205,,201,315,189,,97,82,84,,99,84,
     29,35,29,27,37,25,,35,,,,,38,,,,,47,,,37,,,,51,53,,,35,,,31,,33],
   [,,,,,90,93,,,107,,71,,52,52,74,,70,,,62,74,,67,,52,64,56,,,63,,67,69,
     261,231,265,221,51,,,50,84,48,107,43,,,,71,91,58,71,340,313,338,303,
     355,305,65,50,52,43,65,46,56,47,49,47,41,51,43,44,47,45,,56,52,104,
     63,,,63,51,76,62,53,71,,,58,70,65,86,,43,47,,48,43],
   [82,,,,83,,84,74,,,,,,52,55,66,,62,60,69,,62,50,68,71,52,43,39,68,56,
     60,69,50,52,258,227,,213,51,,,50,69,47,,39,,48,,67,,59,67,330,301,
     327,287,325,269,69,46,55,46,68,42,,46,49,46,37,50,39,,47,42,,65,45,,
     56,183,53,,59,68,66,52,77,,,56,62,,73,,42,,,43,43,,,48],
   [82,,98,57,51,94,36,85,57,,51,48,,,48,,,62,41,71,87,,47,99,65,47,58,
     56,103,47,97,64,60,47,242,,231,,46,63,,38,78,45,42,36,56,47,63,64,
     47,78,68,314,328,305,282,309,309,73,61,52,56,73,57,56,43,,43,36,44,
     40,41,40,70,69,82,73,64,83,71,80,84,55,64,58,49,88,,,,56,64,76,47,
     56,47,46,56,,,46,56,57],
   [90,186,,323,,172,,,323,,39,78,,45,,73,,,69,,55,61,168,312,258,151,241,
     164,,278,252,,254,,41,41,39,43,75,551,,78,117,65,1181,75,96,78,,96,
     459,91,,285,285,281,285,285,277,284,273,280,226,284,265,284,39,45,39,
     39,45,39,39,45,224,,329,,,,,306,,81,57,45,,,,,66,61,55,61,293,271,168,,
     ,151,,269,,274,242],
   [90,121,120,192,129,122,188,122,192,192,39,79,,45,66,61,,57,66,,,,168,
     161,223,129,267,160,159,231,157,231,,223,41,43,41,43,75,218,,78,97,
     65,224,75,,78,224,99,216,92,128,285,285,277,285,285,281,294,207,286,
     192,294,203,294,39,45,39,39,45,39,39,45,125,118,192,129,122,192,120,
     188,192,81,55,45,,63,,,68,,57,63,161,227,168,157,231,129,,155,231,223,
     ,41],[90,190,,285,,176,312,124,,373,35,86,,45,54,59,,53,54,59,59,
     59,164,274,235,149,229,140,,249,,253,242,,41,39,35,41,65,,,76,81,57,,
     65,87,76,475,81,639,,81,273,273,245,269,273,245,272,251,244,214,268,
     223,272,35,45,35,35,45,35,35,45,,148,283,181,,373,,,,72,53,45,54,59,,
     ,54,59,59,59,261,220,164,276,250,149,,,,232,231,41,41],
   [,,,,,,,58,,,,,,53,72,63,,51,50,101,106,59,,,,51,63,,,,49,,66,,,224,,214,,,
     ,49,61,,,38,,45,,66,,60,67,,294,,286,527,274,,47,,42,,41,,,48,,38,50,
     38,42,46,,,,48,,53,,44,51,,,,60,,,,52,69,,,,,72,,74,70,,,70,,115,422,
     224],[,,,,,,,30,62,55,,,,18,19,20,,,19,20,,20,,,,43,60,,,,43,61,62,61,
     ,89,,89,,,,26,27,,,23,,26,62,27,49,,27,,,,115,115,,,69,,58,76,69,78,,
     17,,,17,15,,17,,,,47,34,73,37,68,,,,18,19,20,,,19,20,18,20,41,,58,40,
     70,45,,38,76,,56,94,92,87],
   [18,31,,54,,28,48,24,,54,16,16,,18,16,28,,22,17,24,22,24,34,,48,29,47,
     34,51,,37,48,50,50,78,78,76,78,16,43,,16,30,16,45,16,26,18,45,28,
     43,26,28,106,106,104,106,106,100,59,55,55,44,59,55,55,15,17,15,15,
     17,14,15,17,36,20,60,,,,22,58,60,21,19,16,,,,,19,24,19,,32,50,34,,,
     30,,30,51,53,46,78,78,76,,16],
   [,,,,,81,,56,,,,,,53,53,67,,43,46,,98,63,96,47,,51,47,,46,91,42,134,42,
     130,459,218,438,214,,,,49,67,45,,36,,43,,63,,74,68,425,284,,278,,260,
     94,47,,43,92,39,92,43,48,43,36,50,36,60,46,,,49,,,,,45,44,,,,,,,,50,
     71,,,,66,,,,66,,,70,60,111,,220,,47],
   [,46,,62,59,51,53,34,,,17,17,,18,28,17,,23,,18,23,18,87,,67,45,64,61,
     75,69,47,70,74,67,114,96,81,101,17,67,,28,17,17,61,17,27,28,67,19,
     66,27,19,144,,111,,125,111,90,75,84,62,,75,89,16,17,16,16,15,15,16,
     15,51,42,77,,,,41,80,79,22,20,,,,,,,20,20,20,49,78,,44,,,,50,82,83,,,
     95,81,,17],[18,21,22,38,25,22,34,20,38,38,13,,,18,19,20,,,19,20,
     21,20,32,29,41,25,36,28,29,45,27,45,38,41,75,75,65,75,13,38,,16,
     17,13,40,13,23,16,40,17,38,23,17,101,101,91,101,101,91,54,39,50,34,
     54,35,54,13,16,13,13,16,13,13,16,21,18,34,25,20,34,20,30,34,18,21,
     18,19,20,,,19,20,21,20,27,37,32,27,41,25,,25,41,37,50,75,75,65,38,,
     16,38,17],[],[18,,,56,33,24,,20,,58,13,,,14,15,16,,27,15,16,,16,
     32,,47,29,47,28,46,48,31,,48,45,65,65,57,65,13,45,,16,17,13,,13,28,
     16,71,17,45,,17,87,87,79,87,87,79,52,51,50,43,52,47,54,12,13,12,
     12,13,11,12,13,,18,58,33,20,58,,,,,16,16,17,18,,,17,18,16,18,46,47,
     32,31,48,29,,,,46,47,65,65,57,,13,14,,15,13],
   [,,,,,85,,58,,,,,,53,70,63,,59,50,97,,59,,,,51,63,,55,,49,,68,,,224,,212,,,
     ,49,64,71,,38,56,45,,65,,,61,475,294,,284,,276,100,45,96,42,100,41,
     102,69,48,69,36,50,38,,46,,,46,48,,57,,,61,,,,56,,,,52,69,,,,66,72,,
     74,70,,,,73,108,,222,,42,,,47,,38],
   [18,27,26,39,27,24,39,26,39,39,16,16,,18,17,24,,22,16,28,22,24,34,33,
     46,27,38,34,31,46,33,46,40,46,78,78,76,78,16,45,,18,28,16,45,16,
     26,16,45,30,45,26,28,106,106,104,106,106,100,55,41,55,36,55,37,55,
     15,17,15,15,17,14,15,17,25,24,34,25,24,34,24,34,34,21,19,16,19,24,,
     ,,,19,24,33,43,34,33,43,25,,33,43,43,42,78,78,76,42,16,16,40,,16,,
     14,42],[36,49,,,,51,62,32,59,63,17,17,,,28,18,,23,28,17,23,18,61,,
     71,49,68,61,75,,47,67,66,68,,109,81,100,17,66,,30,19,17,65,17,27,
     28,61,17,68,27,19,127,141,111,133,137,111,88,77,88,64,89,75,103,16,
     15,16,16,17,15,16,15,55,42,77,,40,,41,80,,22,20,,,20,,,,,20,20,50,
     79,75,46,97,51,,52,81,77,77,96,132,81,,17,,,17,17,,15],
   [,,,,,,,58,,,,,,53,53,63,,45,50,101,106,59,,50,,51,42,104,44,107,44,111,
     50,,1181,222,,214,,,,49,66,,,38,74,45,,67,,54,65,645,296,618,292,668,
     276,,45,105,45,107,41,143,,48,,38,50,38,42,46,45,,,,,48,,49,,54,,,,,,,
     52,69,,,,71,,,68,70,,,98,,115,,224,623,41,,,42,,38,,,47,42],
   [,,,,38,,54,30,59,67,,,,18,19,20,,,19,20,,20,,,59,43,60,55,,57,43,62,
     62,80,91,,91,94,,70,,26,27,28,54,27,,26,,27,74,,27,115,115,111,,123,,
     78,69,74,60,82,67,96,14,15,14,14,15,15,14,15,,,,,34,73,37,68,,,18,
     18,19,20,,,19,20,,20,45,,56,40,99,45,,38,76,,57,92,92,93,,15,16,,17,,
     ,13,,16,17],[36,,,63,63,51,60,32,,,17,17,,18,,18,,23,28,18,23,17,
     61,,65,49,78,61,75,89,49,71,98,67,96,101,81,,17,68,,28,19,17,67,17,
     27,30,65,19,63,27,17,129,130,111,141,,111,89,77,89,64,88,75,86,16,
     15,16,16,15,15,16,17,55,42,,,,,41,80,77,22,20,,,20,,,,20,20,,49,82,,
     48,,,,50,104,83,,99,,81,,17,,,17,17,,15,,,17,,17],
   [126,223,184,411,234,194,354,180,,,53,101,,63,88,,,75,91,83,73,83,232,
     360,334,201,313,220,449,346,,347,330,331,285,285,273,285,101,425,,106,
     144,87,,101,,106,,,423,115,125,55,55,53,57,57,53,384,351,372,294,384,
     335,384,53,63,53,53,63,53,53,63,239,,365,,,,184,,368,105,75,63,,,,,86,
     83,75,85,342,337,232,,,201,,396,343,332,314,285,285,273,,119,106,,,101,
     ,87,471,106,126,598,116,127],
   [126,163,162,260,179,160,244,162,260,260,53,103,,63,86,83,,73,87,87,73,
     87,232,213,297,179,,220,215,313,213,313,352,301,285,285,273,285,101,
     286,,106,127,87,294,101,116,106,294,,284,,139,55,57,55,57,57,53,394,
     285,382,260,394,273,394,53,63,53,53,63,53,53,63,167,150,260,179,160,
     260,162,248,260,105,73,63,86,,,,88,87,73,85,215,301,232,211,313,179,,
     203,313,297,308,285,285,273,294,118,106,284,125,101,,87,294,106,,294,
     116,131,55],[126,196,,367,267,,312,176,367,,49,95,,63,74,81,,71,74,
     81,73,81,228,332,301,201,305,196,383,341,329,338,322,302,281,277,245,
     281,91,535,,104,111,79,547,91,111,104,,111,473,112,111,55,53,49,55,
     53,49,372,335,336,286,368,299,372,49,63,49,49,63,49,49,63,,158,359,,
     176,366,,,,97,71,63,74,81,,,74,81,71,81,,,228,273,,201,,,,295,305,281,
     277,245,632,115,104,473,111,91,,79,,104,111,547,112,111,55,55],
   [126,167,166,250,179,160,238,162,250,250,53,104,,63,99,83,,73,,87,75,85,
     232,215,291,179,282,216,215,303,211,303,301,291,285,285,269,285,101,
     274,,106,125,87,292,101,116,106,284,141,278,,133,55,57,53,57,55,53,
     374,285,358,250,374,273,374,53,63,53,53,63,53,53,63,163,150,250,179,
     158,250,166,238,250,,75,63,86,83,,,,,75,93,219,287,232,215,303,179,,
     209,303,291,286,285,285,269,290,115,106,280,126,101,,87,284,106,,290,
     121,166,55,55,55],
   [126,256,180,351,,,424,,,355,53,106,,63,83,83,,,83,,75,87,232,,332,199,
     310,220,386,,286,342,330,327,285,285,273,285,101,414,,106,125,87,447,
     101,117,106,614,144,,120,,55,57,53,57,57,55,384,345,372,290,384,333,
     384,53,63,53,53,63,53,53,63,216,,,,172,,180,,,102,73,63,83,83,,,,89,,
     89,304,327,232,341,339,199,,,341,,309,285,285,273,445,115,106,482,127,
     101,,87,,106,133,,,147,55,55,55,55],
   [72,70,95,,78,,81,88,80,92,56,65,,68,66,88,,76,,86,,82,61,98,57,61,57,
     54,119,61,,56,58,57,284,294,272,274,54,,,59,,52,107,52,79,59,100,86,
     92,80,87,384,394,372,374,384,378,57,57,60,59,59,55,64,52,62,52,50,
     60,54,52,58,70,89,89,,,,103,84,80,68,80,64,,,,,66,82,,86,,68,54,,,61,,
     ,72,61,73,284,294,272,107,79,55,,,54,,54,107,55,103,100,79,87,384,
     394,372,374,384],[72,48,92,41,52,92,41,92,43,43,57,59,,45,53,61,,
     55,60,84,76,,61,105,48,50,61,57,105,48,103,50,63,46,273,207,251,207,
     51,47,,41,75,51,47,39,69,55,45,77,43,69,77,351,285,335,285,345,277,
     57,64,57,59,59,60,59,48,45,48,39,51,39,45,45,77,75,94,85,70,94,79,
     86,94,59,76,66,53,82,,,,71,76,84,57,66,61,54,70,43,,55,70,66,57,
     273,207,251,114,70,50,106,,39,,51,114,43,78,114,70,93,351,285,335,
     285,345,57],[62,,85,,78,93,77,,80,92,52,65,,68,68,80,,72,66,76,,80,
     54,,,61,73,51,,72,85,65,76,,280,286,244,270,48,,,59,88,50,103,48,75,
     55,98,84,118,99,85,372,382,336,358,372,342,52,55,51,52,50,51,55,48,
     62,48,46,60,50,48,58,,73,80,78,88,92,,,,65,68,64,66,84,,,66,80,76,
     76,,55,61,85,72,61,,,,62,73,280,286,244,96,79,59,90,84,50,,48,,55,
     88,107,76,89,372,382,336,358,372,57,57],
   [62,45,89,36,40,83,39,78,36,43,48,47,,43,46,,,53,47,71,65,59,54,93,
     43,45,56,43,99,50,83,43,58,46,226,192,214,182,43,42,,36,62,43,45,
     34,58,44,42,64,43,60,64,294,260,286,250,290,256,52,59,55,54,52,55,
     59,41,40,41,34,42,36,38,38,65,64,78,69,60,79,67,75,78,50,63,53,46,
     67,,,,,65,71,54,63,54,51,63,43,,54,63,63,,226,192,214,108,59,43,93,
     62,38,,43,102,37,,108,60,67,294,260,286,250,290,52,41,52],
   [72,75,99,,,91,81,92,80,95,56,67,,68,72,82,,76,70,90,,84,61,101,61,61,
     56,54,98,61,,56,61,57,284,294,268,274,54,,,59,85,52,109,52,,59,102,,
     94,80,90,384,394,368,374,384,378,57,59,60,59,59,57,64,52,62,52,50,
     60,54,52,58,70,,89,,82,81,95,,,69,78,64,66,,,,68,84,,90,102,68,54,,
     65,61,,135,72,,73,284,294,268,108,79,55,87,88,54,,54,160,55,91,,,103,
     384,394,368,374,384,52,57,57,52],
   [72,42,92,41,52,92,35,88,39,41,53,,,45,49,59,,,60,80,74,59,61,105,42,
     46,57,51,105,46,101,46,59,42,265,203,223,199,47,39,,37,75,47,41,35,
     69,55,41,75,39,67,75,335,273,299,273,333,245,57,60,51,55,55,56,57,
     44,45,44,35,51,35,41,45,69,63,94,85,62,94,71,78,94,55,78,66,49,80,,
     ,60,59,74,80,51,60,61,48,70,43,,47,70,60,,265,203,223,114,94,46,
     108,78,35,,47,114,43,79,114,72,78,335,273,299,273,333,57,41,51,41,57 
    ],[18,36,30,52,33,30,64,32,52,,9,15,,9,15,,,11,,11,11,11,36,53,56,
     30,47,36,53,53,,53,50,56,45,45,45,45,16,,,16,,14,79,16,16,16,79,16,
     ,16,16,63,63,63,63,63,63,60,54,60,45,60,54,60,9,9,9,9,9,9,9,9,
     37,,52,,,,30,58,,15,11,9,,,,,15,11,11,11,53,56,36,,,30,,,53,53,49,45,
     45,45,79,16,16,,,16,,14,79,16,16,79,16,16,63,63,63,63,63,60,54,60,
     45,60,54]],
 [,[],[],[],[,33,,44],[],[],[,,,,,18],[,,,44,38],
   [,38,,49,,,,,55],[18,,,,,,,20],[,,,,39,,,27,80,57],[,,,,28,,,14],
   [18,33,,46,33,18,,18,46,46,9,12,5],[,39,,,49,,,16,,,10,13,6],
   [,41,,48,29,26,,20,56,,11,14,7],[,,,,40,,,28,,56,,10,,12,13,14],
   [,,,,28,,,14,,,,,5,5,6,7],[,32,,70,33,19,,,,41,10,13,6,,6,,13,6],
   [,59,,,,,,18,,,11,14,7,,,7,14,7],[,,,,29,,,14,,,,,5,5,6,7,,5,6,7],
   [30,39,,52,25,26,,20,58,50,11,14,7,,,7,14,7,,7,7],
   [28,,,,46,42,,,,50,32,,,28,,40,,,,,26,40],
   [,,,,,32,,32,,,,,,23,24,41,,,24,43,,39],
   [,37,,,56,55,,,56,60,,54,,39,45,47,64,,39,67,39,53],
   [36,53,,62,49,34,,34,70,70,31,38,28,21,,,,28,25,33,25,43,32,,43],
   [60,68,,80,68,38,,38,86,86,53,50,26,,25,,65,26,27,44,28,44,35,34,41],
   [36,40,,50,,,,36,50,,28,39,20,20,23,28,39,20,23,28,20,28,26,,35,26,29]
    ,[,,,,,,,30,,,,42,,25,,35,49,,27,,,35,,27,,27,28],
   [60,56,,66,37,,,55,60,56,,54,36,39,61,38,55,36,46,41,38,40,41,,50,37,
     41],[,,,,,30,,,,,33,36,22,25,22,29,37,22,,,23,29,,27,,27,28,,25],
   [,53,,54,52,56,,,,62,57,58,36,31,,47,62,36,31,,31,53,,,36,40,34,30,,45 
    ],[62,66,,81,62,46,,46,69,77,54,48,30,58,46,40,55,30,31,36,32,32,
     41,,46,,30,35,34,40,34,41],
   [62,50,,60,49,,,60,66,,,89,52,39,45,53,66,52,39,49,,51,35,,44,43,43,,,
     41,,45,46],[78,,,,,100,,100,341,341,39,,,33,47,,,,51,47,31,45,140,,,
     131,180,124,175,,213,229,197,222],
   [86,151,,247,160,94,,,,308,39,,,33,,,68,,66,45,31,43,140,197,223,121,,
     128,131,217,204,214,,225,37],
   [86,164,,346,,,,94,346,274,35,50,25,25,30,35,50,25,30,35,25,35,132,207,
     193,119,152,100,,,195,170,172,196,31,31],
   [82,,,,167,98,,92,228,,39,,,33,,45,,,51,47,31,,140,,,129,148,124,148,199,
     133,190,172,202,31,37,31],
   [14,,,,33,18,,18,48,,13,,,14,15,16,,,15,16,,16,26,,,26,43,26,28,41,28,
     43,44,37,65,65,59,65],
   [,,,,40,,,,40,45,,,,34,35,44,,,,,,46,,,,56,72,48,,60,,50,75,56,,259],
   [,,,,29,16,,16,42,,,,,7,8,9,,,8,9,7,9,,22,,,29,23,24,38,24,36,35,,,51,
     30],[18,27,,36,27,14,,14,36,36,16,21,9,7,,,21,9,8,15,8,,26,23,34,
     21,,20,21,34,21,29,58,34,57,55,35,57,14,32,7],
   [,59,,82,31,22,,24,,,17,22,10,,,,22,10,,9,9,9,48,42,59,,,31,31,42,31,
     58,39,61,65,,40,61,15,,8],
   [18,,,60,,,,14,48,60,13,18,8,7,8,9,18,8,8,9,7,9,26,23,38,24,26,20,,,
     22,30,30,49,46,49,30,46,13,,6,7,8],
   [,36,,49,,,,,49,40,,47,,34,35,44,,,35,,,46,50,,56,,72,,,,,57,67,52,334,
     225,,178,,41,,32],
   [14,,,,31,18,,18,44,,13,,,14,15,16,,,15,16,13,16,26,,,25,34,26,27,41,
     27,39,34,39,65,65,59,65,11,,,14,15,13,38],
   [,,,,29,16,,16,42,,,,,7,8,9,,,8,9,7,9,,22,,,29,23,24,38,24,36,35,,,51,
     30,,,,6,7,8,6],[14,39,,,33,14,,,,,16,21,9,7,8,15,21,9,,,8,15,24,
     23,47,24,26,20,22,36,,,30,35,57,59,35,61,14,,7,7,,7,,14,7],
   [,,,36,40,,,,,49,,,,34,35,44,53,,,,,46,,,50,,76,48,,60,,,73,58,362,245,
     298,212,,34,,32,,,41],
   [,59,,,31,22,,,,,17,22,10,,,9,22,10,,,9,9,,42,69,47,,31,30,45,28,,35,
     69,76,64,40,76,15,,8,,8,8,,15,8],
   [,40,,49,,,,,49,,,58,,34,35,44,56,,33,,,46,52,,60,56,76,,,52,,57,73,,,
     199,238,208,,35,,32,,,34,,,,41],
   [,,,,27,16,,16,38,,,,8,7,8,9,,8,8,9,,9,,,,,26,23,22,37,22,34,29,,46,,
     30,45,,,6,7,8,6,,,6,7,,8],
   [36,55,,,29,22,,24,,82,17,22,10,,,9,22,10,,9,9,,48,43,61,,,31,31,42,
     31,58,39,59,61,63,40,65,15,,8,,8,8,,15,8,,,8,,8],
   [106,,,,233,120,,138,358,460,53,,,43,59,57,,,,61,43,59,188,,,173,225,164,
     256,282,213,259,248,287,227,227,203,223,87,,,71,,58,312,87,,71,310,77,
     410,59,79],[114,198,,,199,124,,118,325,313,53,86,,43,,,85,,63,57,41,
     61,188,,278,163,,164,173,280,,269,272,,227,227,203,227,87,250,,71,,58,
     276,87,,67,278,77,252,58,77,47],
   [114,,,338,,,,,384,384,49,70,35,35,42,49,70,35,42,49,35,49,180,207,,161,
     192,140,,,200,230,227,263,211,215,175,211,81,290,42,49,56,42,,81,42,
     49,290,56,358,42,56,41,41],
   [114,,,,,122,,122,284,,53,,,43,61,,,,61,57,43,57,192,,,171,200,172,187,
     264,206,241,222,264,223,227,207,227,87,,,69,78,61,232,87,,69,264,82,
     358,60,,41,47,41],[106,223,,,228,122,,,,432,53,,45,39,63,57,,45,,,41,
     57,184,,291,169,229,164,,286,,,248,279,231,227,203,231,87,316,62,67,
     77,58,416,87,62,71,,,388,58,92,47,41,41,47],
   [98,174,,264,173,110,,106,264,264,49,70,35,35,42,49,70,35,42,49,35,49,
     176,204,255,165,,140,157,254,159,,,255,215,211,175,215,77,222,42,49,
     56,42,222,77,42,49,224,56,224,42,56,41,41,35,41,41],
   [46,,,,69,68,,53,73,71,56,,,44,41,54,,,43,,42,58,40,,,53,50,43,67,62,,
     48,62,55,224,234,200,208,41,,,40,53,40,71,41,,40,64,66,69,41,64,296,
     308,272,284,296,280],
   [64,87,,88,83,58,,58,112,94,57,64,44,39,,,,44,41,55,43,53,53,,61,39,,
     43,46,56,46,57,48,63,229,211,201,211,46,82,,39,,40,,43,,40,,63,85,
     52,64,299,281,271,281,295,263,49],
   [64,62,,71,,,,62,73,65,52,57,36,36,36,46,57,36,36,48,32,46,47,60,55,
     47,44,32,,,59,47,56,50,208,222,172,196,46,67,37,34,47,32,,41,37,34,
     69,47,62,36,48,272,284,236,264,272,244,43,43],
   [54,,,,,46,,46,,,48,,,34,35,42,,,33,44,34,52,48,,,47,46,40,41,,41,51,54,
     59,182,188,166,164,39,,,34,,32,68,34,,32,70,43,72,33,58,242,242,222,
     220,242,222,38,43,38],
   [54,66,,71,63,64,,,,77,56,,,44,43,54,61,,,,42,58,48,,56,47,52,43,65,56,,
     ,54,61,228,238,208,216,45,66,41,40,53,40,73,45,41,36,,,71,39,65,
     296,304,276,284,296,280,44,43,43,44],
   [56,71,,89,75,50,,50,89,80,53,55,34,31,36,41,62,34,35,47,37,41,47,42,
     58,47,38,37,40,58,40,48,,55,217,195,173,199,42,88,35,31,46,34,88,
     39,35,34,88,46,82,36,46,279,257,235,257,275,223,43,37,37,37,43],
   [56,62,,71,70,59,,64,79,,56,69,44,44,,58,68,44,43,56,,58,47,,55,53,52,
     40,,57,63,53,60,,220,230,200,212,46,67,59,40,53,38,66,41,59,42,71,
     53,,,64,296,312,272,288,300,280,43,49,38,38,49,43],
   [18,,,,31,18,,20,,44,7,,,9,10,11,,,10,11,9,11,32,,,28,38,28,,43,30,46,
     38,,39,39,35,39,13,,,15,16,12,66,13,,15,40,16,,14,16,53,53,49,53,
     53,49,49,48,45,38,49,44,49],
   [18,32,,46,32,26,,26,48,48,9,12,13,9,,,12,13,14,11,11,11,36,59,51,29,
     ,36,37,50,37,51,45,51,45,45,45,45,16,50,17,15,,13,50,16,17,15,50,
     15,50,15,15,63,63,63,63,63,63,60,51,60,42,60,51,60,9],
   [18,41,,56,,,,20,56,52,7,10,11,9,10,11,10,11,10,11,9,11,32,43,43,29,
     40,28,,,31,46,40,42,39,39,35,39,13,64,14,13,14,10,,13,14,13,,14,64,
     12,14,53,53,49,53,53,49,50,51,46,40,50,47,50,7,9],
   [18,,,,31,18,,20,,44,7,,,9,10,11,,,10,11,9,11,32,,,28,38,28,,43,30,46,
     38,,39,39,35,39,13,,,15,16,12,66,13,,15,40,16,,14,16,53,53,49,53,
     53,49,49,48,45,38,49,44,49,7,9,7],
   [18,41,,64,41,,,,,,9,12,13,9,14,11,12,13,,,11,11,36,61,55,31,44,36,50,
     55,,,44,53,45,45,45,45,16,72,17,15,15,13,70,16,17,15,,,72,15,15,63,
     63,63,63,63,63,58,57,58,44,58,57,58,9,9,9,9],
   [18,26,,42,29,22,,20,44,42,7,10,11,9,10,11,10,11,10,11,9,11,32,41,
     41,27,40,28,31,44,29,45,,41,39,39,35,39,13,38,14,13,14,10,42,13,
     14,13,42,14,38,12,14,53,53,49,53,53,49,52,45,48,38,52,41,52,7,9,
     7,7,9],[18,35,,52,33,18,,20,52,,7,13,11,9,10,11,13,11,10,11,,11,
     32,,43,29,40,28,,45,31,49,40,,39,39,35,39,13,,15,14,15,11,60,13,15,
     14,42,15,,,15,53,53,49,53,53,49,50,51,46,40,50,47,50,7,9,7,7,9,7]
    ,[18,,,48,31,26,,26,48,44,9,12,13,9,14,11,12,13,14,11,11,,36,57,,
     29,40,36,37,48,37,49,40,50,45,45,45,45,16,48,17,15,15,13,48,16,17,
     15,48,15,48,15,,63,63,63,63,63,63,56,51,56,40,56,51,56,9,9,9,9,9,
     9,9],[,,,,,,,,,,,,,33,32,39,,,39,59,,41,,,,33,38,,,,,,44,,,,,,,,,27,39,,,
     ,,33,,38,,,37,,201,,,,173,,56,,,,50,69,,32,,,37,27,,33],
   [,,,,,,,,,,,,,18,19,26,,,,,,26,,,,36,58,36,,56,,,60,50,,92,86,,,,,18,,,,,,,,,,
     ,,,114,114,,136,106,,64,62,,59,64,62,,26,22,,28,18,,26],
   [,,,,,,,,,,,,,46,,58,,,110,,,,,,,59,60,,,,,,70,,,256,344,,,,,40,47,48,,,,,,56,,
     ,51,,311,,,346,264,,55,,,,49,,,48,56,,,44,52,48],
   [,,,,,,,,,,60,40,29,33,33,26,36,29,49,35,29,29,40,29,64,33,40,40,31,
     61,31,56,40,64,211,,183,165,31,,26,27,27,,,29,26,39,,27,,25,27,250,
     201,221,217,279,174,62,56,63,36,69,50,62,35,32,35,35,41,29,35,35,33,
     ,38],[,,,,,,,,,,20,28,14,18,,20,27,14,16,22,14,18,42,,56,,57,,,,,51,
     58,,94,,94,94,16,42,15,18,21,14,42,16,15,14,42,21,42,15,19,122,118,
     114,120,,110,68,68,,53,62,64,59,20,26,20,20,28,20,20,26,,18],
   [,,,,,,,,,,,60,,46,41,52,,,,,,48,56,40,67,59,38,50,36,73,40,69,36,69,
     288,256,,228,48,,35,40,,60,,40,35,,,45,,34,,358,311,384,282,,264,77,
     55,71,45,73,41,79,44,48,52,44,,42,,44,38,,55],[],[],
   [,,,,,,,,,,,,,46,53,58,80,,110,,,50,50,40,75,,32,50,40,72,40,68,44,73,
     350,,274,,,,,40,,48,,,,,,51,,39,56,346,307,,288,362,264,73,45,73,45,77,
     49,71,50,48,52,50,64,46,52,48,44,,49,,,44],
   [,,,,43,24,,24,62,,,,,11,12,13,,,12,13,,13,,,,,48,35,34,55,34,55,,,,60,
     44,,,,,11,12,10,,,,11,,12,,,12,,73,60,,,56,,67,52,,58,52,53,,13,10,,
     13,10,12,13,28,,,37,19,50],
   [,,,,47,26,,26,,,,,,13,14,15,,,14,15,,15,,,,43,66,40,,65,41,85,62,91,,,
     49,,,,,22,23,21,97,,,22,67,23,,,23,,73,67,,77,67,,73,70,,,67,76,,13,
     11,,13,11,,13,,22,,66,26],
   [18,,,,,20,,,,,9,15,7,9,15,7,15,7,15,7,7,7,32,,,31,53,28,33,,,64,52,
     64,39,39,35,39,16,50,8,16,8,8,50,16,8,16,50,8,50,8,8,53,53,49,
     53,53,49,56,57,52,48,56,53,56,9,9,9,9,9,9,9,9,59,20,,,,,,,,10,11],
   [24,43,,62,,24,,24,,62,10,16,8,11,10,11,16,8,8,11,8,11,39,,54,,50,35,
     35,,35,54,,54,63,,44,63,17,43,9,11,12,9,43,17,9,9,43,12,43,9,12,
     81,73,60,77,73,56,58,67,54,44,66,52,58,10,13,10,10,13,10,10,13,37,
     19,50,28,,,,,51,11,12],
   [,47,,,,26,,,,,11,17,9,13,21,11,17,9,21,9,9,9,52,,65,,65,40,41,,,69,
     69,,59,,49,,18,60,10,22,12,10,60,18,10,22,60,10,60,10,10,,77,67,73,
     ,67,82,77,62,62,76,67,,11,13,11,11,11,11,11,11,65,26,,,22,,,,,12,13 
    ],[24,28,,51,37,,,19,,50,,,,11,12,13,,,12,13,,13,39,33,43,31,39,35,,
     48,31,49,43,49,57,61,44,65,16,46,8,9,10,10,43,16,8,9,46,10,46,8,
     10,73,79,60,74,74,56,58,55,52,43,53,51,58,,13,10,,13,10,12,13,,24,
     62,43,24,,,,62,10,,10,11,12],
   [,,,,43,,,26,,,,,,13,14,15,,,14,15,,15,50,,,47,52,40,39,71,39,75,48,,59,
     61,49,55,,68,,22,23,21,,,,22,,23,68,,23,79,,67,73,75,67,78,73,68,56,
     76,61,78,9,11,11,9,11,9,9,11,,26,,43,26,,,,64,,11,11,12,13],
   [,37,,55,28,19,,,50,,10,16,8,11,8,11,16,8,10,11,8,11,,33,48,31,39,
     35,31,43,,51,43,49,57,61,44,59,17,43,9,9,12,9,46,17,9,11,46,12,
     46,9,12,73,,60,78,79,56,,55,54,43,58,51,55,10,13,10,10,13,10,10,
     13,43,24,,,24,62,,,,11,12,,10,,11,12],
   [,43,,,,26,,26,66,,11,17,9,13,21,9,17,9,21,11,9,9,,,59,,78,40,39,,41,
     63,,59,59,55,49,59,18,52,10,22,10,10,52,18,10,22,52,12,52,10,10,
     79,73,67,,79,67,,,68,68,80,61,74,11,11,11,11,13,11,11,11,43,26,82,,,
     ,,,,12,13,,,11,12,13],
   [,,,,,22,,26,,,,,,13,14,15,,,14,15,,15,46,,72,,66,40,44,,41,68,62,,57,
     61,49,,,97,,22,23,21,67,,,22,,23,,,23,73,77,67,79,,67,76,,62,,80,67,,
     9,11,9,9,11,11,9,11,,,,47,26,,,,,,11,11,12,13,,11,12,13],
   [,,,,,26,,22,,,11,17,9,13,21,9,17,9,21,9,9,11,,,,,66,40,41,72,,85,,65,
     57,,49,61,18,60,10,22,10,10,60,18,10,22,60,10,60,10,12,73,77,67,
     79,77,67,68,77,70,,72,67,80,11,11,11,11,11,11,11,13,47,26,,,26,,,,,
     12,13,,,11,12,13,,11,13],
   [,,,,31,,,,,36,,,,25,27,35,,,,,,35,,,,46,62,40,,52,,46,65,48,,131,195,,,,,
     25,,,34,,,,,,28,,,,193,235,,216,157,,78,60,,65,75,60,,37,,,50,31,,37,,,,
     ,30,,,,,,,33,31,41,34,,35,39,44,41],
   [,,,,65,52,,,,67,,,,39,39,53,,,45,67,39,50,,,,54,53,40,45,59,,,63,52,,,,,,
     ,,37,47,38,66,,,40,,50,78,37,54,,278,257,,284,253,,50,40,,,44,40,,51,
     42,,53,41,,50,37,,,56,60,60,,,66,43,,64,51,62,,75,54,71,84,69],
   [36,,,,40,,,42,,56,32,52,28,28,43,40,,28,,36,,38,32,40,46,32,46,24,44,
     37,44,46,46,37,140,140,132,140,30,,27,26,,28,52,30,27,24,,50,52,27,,
     188,188,180,192,184,176,53,53,38,36,47,47,42,32,36,32,32,36,32,32,
     36,40,42,56,,,,,,,39,52,32,,,,,39,54,,46,,35],
   [,,,,27,,,,,40,33,34,22,25,,29,36,22,22,,23,29,,,51,48,67,40,,48,,,81,
     52,175,146,,155,26,37,24,25,31,22,32,25,24,22,37,29,32,23,31,214,
     193,200,201,211,159,67,80,61,61,,75,65,30,37,31,30,,29,31,37,,30,,,,,,
     ,,31,41,,,,34,39,35,41,41,60,25],
   [60,,,,62,,,50,,75,62,59,33,39,37,40,54,33,61,40,38,39,35,50,58,54,35,
     33,52,42,50,50,36,42,230,219,196,193,44,,35,37,40,,67,40,35,35,,40,
     69,35,41,291,278,259,258,290,254,55,50,43,44,62,40,47,46,50,45,46,
     52,44,45,52,56,60,60,37,,,,,50,51,65,,43,,55,59,,,69,92,,50],
   [36,33,,,33,42,,42,59,59,31,35,,21,25,43,36,,,33,25,,26,43,54,28,33,
     26,46,54,,49,37,49,131,121,119,129,26,45,24,21,29,24,45,25,24,24,
     45,29,45,23,29,173,163,161,171,169,165,47,46,47,37,53,42,53,28,29,
     29,28,31,27,29,29,,34,70,49,34,70,,,62,31,43,31,31,49,,,,43,49,49,
     27,43,32,27,37],[60,,,70,46,61,,53,76,36,,37,,58,35,44,48,,39,44,
     36,66,41,58,58,37,39,40,65,41,65,58,42,36,193,,172,166,36,52,33,28,
     39,34,34,34,33,30,52,39,32,31,39,251,271,227,226,249,258,62,47,40,
     41,,43,41,34,45,36,34,44,38,36,40,,46,81,68,46,69,,,81,43,,53,43,62,
     ,,,52,75,61,34,40,35,34,46],[],[],
   [62,,,,64,,,56,,69,,,52,39,43,51,54,52,45,49,,47,41,50,54,,32,33,50,42,
     52,53,41,42,212,222,,192,42,,,37,47,47,81,37,,36,,56,64,37,50,281,
     282,264,256,288,253,62,44,43,44,55,44,47,42,50,45,42,52,40,,48,50,
     55,66,49,,50,,,,45,78,57,49,69,,,54,,,65,,44,,,41,43,40],
   [62,38,,60,40,55,,58,60,38,51,49,34,,27,,53,34,25,44,28,,35,,53,33,40,
     ,61,32,63,54,40,35,182,230,145,158,32,42,29,24,39,26,28,30,29,26,
     42,39,28,27,39,223,274,,200,220,202,50,44,33,37,50,40,40,38,,40,38,
     44,40,40,40,69,38,77,68,38,84,,,80,39,66,54,39,63,48,78,50,52,63,
     66,28,40,35,28,41,,30,,,41],
   [78,183,,282,238,110,,,290,354,39,66,,33,,43,68,,43,,31,47,140,249,216,
     131,174,124,,228,175,,191,,37,37,29,33,65,334,49,57,76,46,356,65,49,
     57,,61,258,47,,227,227,211,223,231,215,224,229,208,182,228,217,220,39,
     45,39,39,45,39,39,45,198,94,288,,,,,,336,65,61,39,,,,,58,61,55,55,
     175,232,140,,,131,190,,,228,175],
   [86,153,,251,152,98,,98,265,276,39,65,35,33,55,47,66,35,,,,51,140,,220,
     121,230,128,131,220,146,,,,31,33,31,33,65,197,,55,66,49,223,65,,59,
     251,62,238,47,63,227,227,215,227,227,211,234,211,222,188,238,195,230,
     39,45,39,39,45,39,39,45,,88,276,159,92,265,,,251,59,55,39,,61,,,59,,
     63,63,152,217,140,147,226,121,,,,218,,37],
   [86,183,,274,,94,,86,,344,35,50,25,25,30,35,50,25,30,35,25,35,132,168,
     200,119,148,100,195,192,,174,171,,31,29,25,31,59,,30,35,40,30,298,59,
     30,35,238,40,298,30,40,203,203,175,207,203,175,200,201,172,166,208,
     173,200,35,45,35,35,45,35,35,45,,94,274,164,,346,,,346,44,49,35,44,
     49,44,49,44,49,49,49,158,193,132,195,194,119,171,,,194,,31,31],[],
   [,,,,49,33,,33,,61,,,,16,17,18,,,17,18,,18,,,,45,61,51,41,71,44,72,60,,,
     86,64,,,,,27,28,26,56,,,27,64,28,49,,28,,,88,,116,88,,75,77,,83,69,80,
     ,16,14,,16,14,,16,,,,46,34,70,,,,,,17,18,19,,17,18,19,17,19,38,,83,
     42,69,47,79,,,,53,,89,64],
   [18,33,,48,,18,,18,,48,16,13,12,14,13,14,13,12,11,14,12,14,30,,41,26,
     43,26,28,,28,39,41,44,65,65,59,65,14,36,13,14,15,12,36,14,13,12,
     36,15,36,13,15,87,87,81,87,87,77,50,46,41,39,46,42,45,14,16,13,14,
     16,13,14,16,31,16,48,,,,,,48,17,18,13,,,17,18,16,,18,,26,44,26,,,26,
     36,,,46,32,65,65,59,,15],
   [,,,,,48,,48,,,,,40,36,35,62,,40,35,64,,60,50,34,64,,34,50,34,64,34,67,
     34,66,,356,333,,,,,36,63,34,,,,34,,61,,35,63,458,331,,362,606,,69,,69,
     43,71,39,71,70,88,64,70,90,62,,82,40,,51,,,,,,40,,,,,,47,,47,,,,,60,,,,
     54,68,,,50,,,288],[,46,,72,,33,,31,,,17,14,13,16,26,14,14,13,26,12,
     13,12,,,68,49,66,51,44,88,41,75,77,67,94,92,64,88,15,61,14,27,15,
     13,53,15,14,27,61,13,56,14,13,116,,88,,110,88,,79,75,59,,69,103,15,
     16,14,15,14,14,15,14,46,34,91,,,,,,91,18,19,,,,18,19,,17,19,17,42,69,
     ,38,,,53,,,73,61,,93,64,,16],
   [18,30,,50,29,,,16,,50,13,,,14,15,16,25,,15,16,13,16,30,27,48,25,30,
     26,27,49,25,48,34,48,65,65,59,65,13,44,12,12,13,13,44,13,12,12,44,
     13,44,12,13,87,87,81,87,87,77,50,43,46,34,46,39,50,13,16,13,13,16,
     13,13,16,,18,44,31,18,,,,44,16,21,16,17,18,,,17,18,,18,27,,26,27,41,
     25,,,,40,56,65,65,59,,,14,38,15],
   [,,,65,46,31,,33,,,,,,16,17,18,,,17,18,,18,79,,88,,66,51,44,68,44,69,57,
     ,94,95,64,,,53,,27,28,26,,26,,27,54,28,64,,28,115,116,88,111,,88,82,
     ,73,59,81,71,,13,14,14,13,14,12,13,14,,34,,50,34,,,,,,17,17,18,19,,,
     18,19,17,19,45,,82,45,69,,,,,94,77,94,,64,,14,15,,16],
   [14,25,,42,25,14,,14,42,42,13,10,9,8,9,10,10,9,9,10,9,10,24,,39,22,
     38,20,22,38,22,,36,38,50,50,40,50,11,34,10,10,11,9,34,11,10,10,34,
     11,34,10,11,66,66,56,66,66,56,38,38,36,34,38,34,40,11,12,10,11,12,
     10,11,12,25,14,42,25,14,42,,,42,14,15,13,14,15,14,15,14,15,15,15,
     22,39,24,22,38,22,36,,,38,38,50,50,40,,12,11,,12,11,12],[],
   [14,29,,,33,16,,,40,,16,13,12,14,11,14,13,12,13,14,12,14,26,27,40,25,
     30,26,25,38,27,38,34,40,65,65,59,65,14,36,13,12,15,12,36,14,13,14,
     36,15,36,13,15,87,87,81,87,87,77,41,43,41,34,45,39,41,14,16,13,14,
     16,13,14,16,31,18,,31,18,44,,,,17,18,13,16,21,17,18,,,18,,27,41,30,
     27,37,25,34,,,41,34,65,65,59,,15,13,38,,14,15,11],
   [,49,,,,33,,33,61,,17,14,13,16,26,12,14,13,26,14,13,12,,,71,45,61,51,
     44,,44,73,60,68,,85,64,93,15,56,14,27,13,13,61,15,14,27,53,15,61,
     14,13,118,112,88,117,120,88,85,75,74,,84,71,79,15,14,14,15,16,14,
     15,14,50,34,70,,34,,,,78,18,19,,,17,18,19,,,19,17,45,70,83,45,94,47,
     67,,,65,77,93,88,64,,16,,,14,15,16,12],[],
   [,,,,45,34,,33,72,87,,,,16,17,18,14,,17,18,,18,,,68,,66,51,44,64,44,75,
     61,,88,,64,,,79,,27,28,26,53,,,27,,28,56,,28,111,118,88,,118,88,81,
     94,75,63,,69,101,13,14,12,13,14,14,13,14,,34,,50,34,,,,,,17,17,18,19,
     ,17,18,19,,19,42,,59,42,72,49,,,,,61,88,98,64,,14,15,,16,,14,12,,15,
     16],[36,42,,,70,33,,34,,59,17,14,13,16,26,12,14,13,26,12,13,14,59,
     ,64,,61,51,44,87,42,72,64,68,87,98,64,,15,61,14,27,13,13,56,15,14,
     27,61,13,53,14,15,112,,88,120,,88,80,94,77,63,81,69,,15,14,14,15,
     14,14,15,16,50,34,,,34,,,,69,18,19,,,17,18,19,,17,19,,42,72,,44,,,52,,
     ,72,53,88,,64,,16,,,14,15,16,12,,,14,,16],
   [106,227,,416,227,128,,128,,,53,85,43,43,59,,,43,74,61,41,57,188,299,
     279,173,224,164,270,279,,268,246,289,227,227,203,223,87,312,,71,77,58,
     ,87,,71,306,,316,57,77,47,47,39,43,43,39,296,299,272,242,296,279,
     296,53,63,53,53,63,53,53,63,250,122,358,,,,,,348,79,77,53,,,73,77,73,
     77,75,75,214,292,188,,,173,247,,,284,228,227,227,203,,116,87,,,87,,66,,
     87,116,,109,112],[114,199,,306,198,118,,124,313,325,53,86,45,43,55,
     57,88,45,59,59,41,61,188,,280,163,,164,175,278,189,264,296,278,227,
     227,203,227,87,250,60,71,92,58,276,87,60,67,274,,250,,77,41,43,41,
     43,43,39,308,281,284,242,304,257,312,53,63,53,53,63,53,53,63,,114,
     325,197,126,307,,,305,74,73,53,73,,,,79,73,77,77,195,279,188,188,278,
     163,,,,280,238,227,227,203,,112,87,331,116,87,,66,,87,,,116,118,47],
   [114,223,,338,222,,,122,338,,49,70,35,35,42,49,70,35,42,49,35,49,180,
     209,257,161,196,140,235,257,235,228,227,257,211,215,175,211,81,358,42,
     49,56,42,290,81,42,49,,56,290,42,56,41,39,35,41,39,35,272,271,236,
     222,276,235,272,49,63,49,49,63,49,49,63,237,114,340,,122,338,,,384,
     60,67,49,60,67,60,67,60,67,67,67,,258,180,201,,161,228,,,257,197,211,
     215,175,,88,81,318,88,81,88,56,,81,88,,88,88,41,41],
   [114,207,,310,201,122,,126,280,282,53,85,43,43,78,59,85,43,,61,41,57,
     192,224,261,171,206,172,201,264,173,238,222,262,223,227,207,227,87,
     256,62,69,78,61,234,87,62,69,266,78,258,,101,47,43,39,43,47,39,284,
     281,264,220,284,257,288,53,63,53,53,63,53,53,63,207,120,282,209,114,
     280,,,310,,79,53,75,73,75,,,,79,81,190,264,192,175,260,171,226,,,259,
     196,223,227,207,,118,87,,109,87,110,66,,87,,,121,121,41,47,41],
   [106,274,,362,,,,138,,346,53,88,,39,59,61,86,,59,61,41,57,184,,293,169,
     227,164,254,,212,263,248,277,231,227,203,231,87,314,62,67,77,58,310,
     87,62,71,416,77,,57,,41,43,39,43,43,41,296,295,272,242,296,275,300,
     53,63,53,53,63,53,53,63,231,,432,228,120,,,,,,77,53,74,73,73,73,,,,
     77,216,281,184,248,281,169,248,,,,224,231,227,203,,,87,462,112,87,110,
     66,,87,116,,,118,47,41,41,47],
   [64,68,,,63,,,68,67,79,56,64,44,44,43,54,62,44,,56,,54,53,60,41,53,41,
     38,63,47,64,39,41,47,224,234,200,208,50,,40,40,,38,71,45,40,38,68,
     53,73,40,53,296,308,272,284,296,280,49,49,44,45,45,41,48,49,60,50,
     49,58,52,50,56,62,68,77,,,,,,73,58,80,56,,,55,78,56,78,,76,67,55,40,,
     ,53,54,,,51,52,224,234,200,,99,41,,,46,82,40,,45,101,,80,81,296,308,
     272,284,296],[64,56,,,56,68,,68,45,45,57,61,42,39,41,53,62,42,48,
     55,43,,47,73,50,46,45,43,78,50,,41,47,44,229,211,201,211,46,41,42,
     35,49,40,41,43,42,40,39,49,39,39,49,299,281,271,281,295,263,43,48,
     43,45,45,44,45,48,51,51,48,57,45,51,51,,58,100,83,58,88,,,100,55,
     73,57,55,77,,,,69,77,77,46,63,53,46,55,39,,,,64,44,229,211,201,,77,
     46,80,,43,,38,,43,77,,79,94,299,281,271,281,295,49],
   [54,,,,62,62,,,65,73,52,61,33,36,36,46,58,33,35,44,36,46,48,60,,47,44,
     37,,55,59,41,56,56,208,222,172,196,41,,36,34,48,34,67,41,36,32,62,
     47,69,36,47,272,284,236,264,272,244,38,41,37,38,36,37,41,45,60,46,
     45,58,48,46,56,62,53,65,62,62,71,,,73,52,62,52,52,70,54,68,52,68,
     70,62,,50,47,59,55,47,54,,,56,47,208,222,172,,74,46,69,73,46,75,34,,
     41,77,,73,74,272,284,236,264,272,43,43],
   [54,53,,44,36,57,,57,44,45,48,49,37,34,33,,47,37,35,44,34,42,48,57,
     36,37,39,32,62,44,60,36,41,44,182,188,166,164,36,34,33,28,39,32,39,
     34,33,32,34,39,39,31,39,242,242,222,220,242,222,44,45,41,40,44,41,
     45,38,42,40,38,44,38,40,40,66,46,75,64,46,75,,,75,43,66,48,43,62,
     49,64,,,66,66,41,59,48,41,58,47,54,,,58,46,182,188,166,,65,36,67,63,
     42,,34,,34,,,65,65,242,242,222,220,242,38,43,38],
   [56,66,,,68,59,,64,71,71,56,62,46,44,47,54,67,46,,56,,54,47,60,46,47,
     38,38,65,47,60,38,46,47,228,238,208,216,46,,,40,53,40,69,41,,42,64,
     66,71,41,67,296,304,276,284,296,280,43,45,44,45,45,43,48,49,60,50,
     49,58,52,50,56,68,68,71,66,59,71,,,,,82,56,56,,56,74,56,80,,82,65,
     61,48,,50,47,62,,,,50,228,238,208,,83,45,63,82,50,80,40,,41,,,,81,
     296,304,276,284,296,44,43,43,44],
   [56,50,,49,50,64,,64,41,49,53,62,34,31,35,41,55,34,36,47,37,41,47,,
     44,42,43,37,77,40,77,37,43,44,217,195,173,199,42,35,38,31,45,34,35,
     39,38,34,35,45,35,35,45,279,257,235,257,275,223,43,44,37,41,41,40,
     43,44,51,47,44,57,41,47,51,75,50,80,71,50,89,,,89,51,67,53,51,67,
     52,61,52,61,67,67,40,55,47,40,58,47,48,,,57,,217,195,173,,76,42,93,
     76,39,76,34,,39,76,,76,76,279,257,235,257,275,43,37,37,37,43],
   [18,31,,48,30,20,,24,54,,9,13,7,9,14,7,13,7,14,7,7,7,32,47,47,28,
     45,28,30,43,,49,41,49,39,39,35,39,14,43,8,15,8,8,43,14,8,15,43,8,
     43,8,8,53,53,49,53,53,49,52,48,48,41,52,44,52,9,9,9,9,9,9,9,9,
     34,20,54,,,,,,,10,11,7,,,10,11,,9,11,9,30,49,32,,,28,43,,,47,46,39,
     39,35,,15,13,,,14,15,11,,13,13,,15,13,53,53,49,53,53,52,48,48,41,
     52,44],[18,30,,,31,24,,20,,54,7,12,,9,10,11,,,10,11,9,11,32,47,43,
     28,45,28,45,47,30,50,46,43,39,39,35,39,13,43,,15,16,12,,13,,15,69,
     16,43,14,16,53,53,49,53,53,49,52,48,48,41,52,44,52,7,9,7,7,9,7,
     7,9,,18,,31,20,54,,,48,14,9,9,10,11,,,10,11,9,11,45,43,32,30,47,28,
     ,,,50,43,39,39,35,,13,14,,15,13,,11,,14,15,,13,15,53,53,49,53,53,
     52,48,48,41,52,44,9]],
 [,[],[],[],[,27,,34],[,,24],[,34,,41],[,,22,,,24],
   [,,,34,34,,41],[,34,,41,,,34,,41],[18],[,31,,,35,36,44,,,47],
   [,,18,,,,,18],[18,27,28,43,27,32,43,32,43,43,9,15],
   [,,34,,65,,63,34,69,,15,15],[,,18,40,21,26,28,20,38,,11,15,7],
   [,,34,,47,,66,34,,72,,13,,,15,15],
   [,33,20,40,21,26,30,18,42,42,,,7,11,15,7],
   [,31,,,37,36,45,,,42,,15,,,13,,15,15],[,,18,,,,,18,,,,,7,,,7,,7],
   [,,24,,27,,40,18,,,,,7,11,15,7,,7,15,7],
   [30,33,18,42,21,26,30,20,42,42,11,15,7,,,7,15,7,,7,7],
   [36,,,,41,58,50,,,54,36,,,36,,,,,,,36,40],
   [,,,,,38,,,,,,,,37,39,25,43,27,,,43,25],
   [,43,,,48,72,57,,,61,,53,,52,71,43,65,49,53,,45,49],
   [36,43,45,52,43,42,52,45,52,52,34,35,36,27,,,,37,35,36,31,,34,33,41],
   [54,,60,72,69,56,68,60,72,72,50,48,46,,41,,,,48,46,40,40,41,40,48],
   [36,45,50,54,,,,50,54,,36,50,28,36,50,28,50,28,50,28,28,28,34,,41,34,
     41],[,,39,,,,,39,,,,49,,41,,33,53,33,49,,,33,,31,,33,40],
   [54,52,72,61,35,,,62,61,61,59,57,38,52,69,35,62,37,58,38,41,37,41,,
     48,41,48],[,,,,,38,,,,,,,,41,39,27,43,25,,,27,27,,29,,33,40,,31],
   [,43,,,48,78,57,,,61,,53,,52,,43,63,49,53,,45,49,,,41,41,48,41,,48],
   [54,71,48,72,,48,60,48,72,72,50,48,34,,46,36,61,28,48,34,32,28,41,32,
     48,,34,35,34,42,32,48],
   [54,52,74,61,43,,54,76,61,,,60,50,52,71,47,65,49,55,50,,49,41,,48,41,
     48,,,41,,48,48],
   [90,,,,,,275,,,378,45,,,45,77,,78,43,,,45,45,168,,,149,216,164,218,,,,,247]
    ,[90,129,114,190,121,116,186,114,190,190,45,,51,45,,,80,,81,51,47,43,
     168,151,229,129,,160,155,221,159,229,,229,41],
   [90,191,,354,,,,,,,45,67,35,45,67,35,67,35,67,35,35,35,164,264,239,151,
     204,140,,,264,237,176,237,41,41],
   [90,129,116,168,125,122,160,116,168,168,45,84,53,45,,45,,,82,53,47,,168,
     155,207,129,168,164,161,203,155,207,160,207,41,41,41],
   [18,,,,31,24,44,,,,16,,,18,22,17,20,16,,,,17,34,,,29,42,34,37,44,,,42,
     44,78,78,76,78],[,,,,40,,47,,,49,,,,57,62,40,62,42,,,,42,,,,72,90,62,
     ,69,,,86,69,,222,,196],
   [,,,,25,22,34,,,,,,,,,9,,9,,,9,9,,26,,,,31,28,40,26,,32,,,68,40,85],
   [18,25,24,32,25,24,32,24,32,32,18,22,18,16,,,,17,20,18,17,,34,33,41,
     25,,34,33,41,33,41,,41,78,78,76,78,16,40],
   [38,,21,65,25,22,34,27,,69,18,22,10,,,,22,9,,10,9,9,47,28,56,,,31,29,
     39,30,55,35,56,63,,40,61,16,,8],
   [18,35,18,50,,,,18,50,50,16,20,10,16,20,9,20,9,20,10,9,9,36,26,44,
     30,38,28,,,26,44,30,48,62,60,40,64,16,,8,16,8],
   [,40,,47,,,,,47,46,,56,,57,62,40,62,42,60,,,42,62,,69,72,92,,,,,69,86,,
     482,220,,200,,47,,40],
   [18,25,24,32,25,24,32,24,32,32,16,20,18,18,,17,,,22,18,16,17,34,33,
     41,25,34,34,33,41,33,41,34,41,78,78,76,78,14,38,,16,16,16,40],
   [,,27,,25,22,34,21,65,,,,10,18,22,9,,,22,10,9,9,,30,55,45,67,31,29,
     39,28,56,35,55,59,63,40,,,,8,16,8,8],
   [18,,,,31,24,44,,,50,18,,,16,20,16,22,17,,,17,16,34,,,29,42,34,37,44,,,
     42,44,78,78,76,78,16,,,14,,16,,16,16],
   [,,,,40,,47,,,47,,,,57,62,40,62,42,,,,42,,,,64,88,62,,69,,,78,71,,220,
     418,200,,40,,38,,,47,40],
   [,,,,25,22,34,,,,,,,,,9,,9,,,9,9,,26,,,,31,28,40,26,,32,,,68,40,85,,,8,,
     8,8,,,8],[,44,,49,,,40,,49,,,63,,57,62,40,62,42,57,,,42,66,,71,72,
     90,,,66,,71,86,,,222,318,198,,41,,40,,,40,38,,,47],
   [,,27,,25,22,34,21,69,,,,10,18,22,9,,9,22,10,,9,,32,,,50,31,28,40,26,
     66,29,,75,,40,61,,,8,16,8,8,,,8,16,,8],
   [34,47,21,65,25,22,34,27,,65,18,22,10,,,9,22,9,,10,9,,47,28,56,,,31,
     29,39,30,55,35,56,59,61,40,63,16,,8,,8,8,,16,8,,,8,,8],
   [126,,,,229,172,,,,404,63,,,63,103,57,103,61,,,59,59,232,,,201,276,220,
     383,312,,,260,321,285,285,273,285,106,,,106,,80,424,106,77,106,,,486,
     79,79],[126,179,156,254,163,160,242,156,254,254,63,104,,63,,,103,57,
     105,,61,61,232,207,307,179,,220,209,291,207,307,276,307,285,285,273,
     285,106,288,82,106,,80,288,106,,106,284,82,290,91,77,55],
   [126,,168,343,,,,,,409,63,93,49,63,93,49,93,49,93,49,49,49,228,285,,199,
     270,196,,,,317,234,329,281,277,245,281,104,382,56,104,56,56,,104,56,
     104,382,56,486,56,56,55,55],
   [126,179,150,232,163,160,220,150,232,232,63,103,61,63,103,,,,102,61,59,
     57,232,203,285,179,232,216,213,269,203,285,216,285,285,285,269,285,
     106,266,82,106,77,76,264,106,,106,266,82,268,79,,55,55,55],
   [126,,,,,172,356,,,384,63,,,63,107,57,,59,,,61,57,232,,,201,276,220,,312,,,
     264,324,285,285,273,285,106,,,106,77,80,510,106,77,106,,,510,91,91,55,
     55,55,55],[126,179,138,246,147,152,214,138,246,246,63,93,49,63,93,
     49,93,49,93,49,49,49,232,187,299,175,,196,197,263,189,299,,299,277,
     281,245,277,100,264,56,100,56,56,264,100,56,100,266,56,266,56,56,55,
     55,49,55,55],[54,,,,68,90,73,,,81,61,,,68,67,52,68,52,,,54,56,50,,,
     59,68,55,109,64,,,64,68,270,290,256,246,50,,,57,51,52,91,50,64,50,,,
     93,51,61,360,382,350,338,360,366],
   [72,79,75,92,71,70,84,75,92,92,66,61,56,45,,,,45,61,56,49,47,59,55,
     68,43,,55,54,64,55,68,54,68,267,207,257,207,55,112,,43,,46,112,43,
     58,55,108,,112,59,59,351,285,329,285,351,277,55],
   [72,74,81,81,,,,81,81,82,61,67,48,68,70,44,67,44,70,48,42,44,59,,68,
     59,68,42,,,99,68,58,65,266,282,228,242,57,91,45,57,45,42,,50,46,57,
     91,45,88,46,46,348,370,314,322,348,330,55,55],
   [54,65,60,72,63,56,68,60,72,72,50,48,46,43,47,38,,,48,46,40,44,50,52,
     59,43,52,50,49,59,52,59,52,59,212,190,204,168,42,92,44,41,,38,92,34,
     ,42,86,44,92,39,53,276,254,268,232,276,250,48,41,48],
   [54,,,,68,90,73,,,81,61,,,68,,52,68,52,,,54,54,50,,,59,68,55,,64,,,64,
     68,270,290,252,246,50,,,57,51,52,91,50,61,50,,,93,51,62,360,382,346,
     338,360,366,48,55,55,48],
   [72,79,63,92,63,62,76,63,92,92,66,61,44,45,64,35,64,35,61,44,41,35,
     59,47,68,43,61,49,48,58,47,68,,68,259,203,229,199,55,108,42,43,40,
     38,108,43,40,55,108,42,108,40,40,335,273,293,273,339,245,55,41,49,
     41,55],[72,74,89,81,69,72,74,89,81,,61,73,60,68,,54,69,52,68,60,,
     56,59,87,68,59,68,50,,61,,68,64,,270,290,256,246,57,93,53,57,51,50,
     120,50,62,57,91,53,,,61,360,382,350,338,360,366,55,55,48,48,55,55],
   [18,,,,37,,54,,,,9,,,9,15,11,15,11,,,11,11,36,,,30,42,36,,52,,,42,,45,
     45,45,45,16,,,16,16,14,78,16,16,16,,,,16,16,63,63,63,63,63,63,57,
     54,57,42,57,54,57],
   [18,27,26,38,27,26,38,28,38,38,9,13,13,9,,,13,11,16,13,11,11,36,35,
     47,27,,36,35,47,37,47,41,47,45,45,45,45,17,46,17,16,,13,46,17,15,
     16,46,17,46,15,15,63,63,63,63,63,63,58,45,58,38,58,45,58,9],
   [18,33,26,46,,,,26,46,46,9,13,13,9,13,11,13,11,13,13,11,11,36,37,48,
     29,40,36,,,37,48,40,48,45,45,45,45,16,86,16,16,14,12,,16,14,16,,16,
     86,14,14,63,63,63,63,63,63,56,51,56,40,56,51,56,9,9],
   [18,27,28,36,27,26,36,26,36,36,9,16,13,9,13,11,,,13,13,11,11,36,37,
     45,27,36,36,35,45,35,45,36,45,45,45,45,45,16,44,17,17,15,13,44,16,
     ,17,44,17,44,15,15,63,63,63,63,63,63,54,45,54,36,54,45,54,9,9,9],
   [18,,,,37,,54,,,,9,,,9,15,11,15,11,,,11,11,36,,,30,42,36,,52,,,42,,45,
     45,45,45,16,,,16,16,14,78,16,16,16,,,,16,16,63,63,63,63,63,63,57,
     54,57,42,57,54,57,9,9,9,9],
   [18,27,26,38,27,24,38,26,38,38,9,13,13,9,13,11,13,11,13,13,11,11,36,
     35,47,27,41,36,33,47,35,47,,47,45,45,45,45,16,44,16,16,14,12,44,
     16,14,16,44,16,44,14,14,63,63,63,63,63,63,58,45,58,38,58,45,58,9,
     9,9,9,9],[18,33,32,46,31,28,44,26,46,,9,16,13,9,13,11,15,11,13,
     13,,11,36,53,48,29,40,36,,48,37,49,40,,45,45,45,45,16,,17,17,15,13,
     66,16,15,17,66,17,,,15,63,63,63,63,63,63,56,51,56,40,56,51,56,9,9,
     9,9,9,9],[18,27,26,36,27,26,36,28,36,36,9,13,13,9,15,11,13,11,
     16,13,11,,36,35,45,27,36,36,35,45,37,45,36,45,45,45,45,45,17,44,
     17,16,15,13,44,17,15,16,44,17,44,15,,63,63,63,63,63,63,54,45,54,
     36,54,45,54,9,9,9,9,9,9,9],
   [,,,,,,,,,,,,,27,31,33,39,,,,,,,,,27,34,,,,,,34,,,129,,129,,,,27,41,35,,27,
     40,,,,,,,,179,233,179,,179,,52,73,43,,52,,,27,31,27,,27,,27],
   [,,,,,,,,,,,,,32,36,26,36,26,,,,26,,,,56,72,52,,66,,,68,66,,122,124,120,,,,
     26,,,,24,,,,,,,,,160,164,160,,148,,92,86,74,,88,90,,26,32,26,,24,,26],
   [,,,,,,,,,,,,,43,,40,42,40,,,,48,,,,45,54,,,,,,50,,,190,,168,,,,43,35,50,,
     36,47,,,,,,46,,254,,232,,246,,41,,34,,41,,,38,46,36,,38,46,36],
   [,,,,,,,,,,,65,,27,35,21,31,21,47,,35,21,41,39,61,27,41,35,33,55,29,61,
     35,61,229,121,227,121,35,,23,27,22,,,27,22,37,,23,,23,22,303,163,,
     163,279,147,68,48,62,32,68,42,68,,27,33,27,,27,41,27,27,,34],
   [,,,,,,,,,,30,35,24,32,,22,45,20,37,24,20,20,60,,83,58,76,,,,,75,70,,
     148,122,,122,22,60,23,26,23,20,60,24,21,22,60,23,60,21,21,190,166,
     182,162,,156,97,98,,72,101,92,,30,28,26,26,30,26,26,28,,26],
   [,,,,,,,,,,,,,43,42,42,,48,,,,40,54,42,74,45,34,54,40,74,40,74,32,74,
     276,190,,168,,,37,43,,50,,36,43,,,37,,46,,346,254,426,232,,246,81,41,
     81,43,81,39,81,,38,46,36,,38,,36,34,,41],
   [,,,,,,,,,,,34,18,28,,18,,20,34,18,24,18,,,,54,72,50,,59,,,72,71,,114,,
     116,20,54,19,20,19,18,54,24,21,20,54,19,54,21,19,,156,168,150,,138,,
     88,81,66,,84,89,,26,26,28,,26,32,26,,24,,,28],
   [,,,,,,,,,,,63,48,43,54,30,45,28,63,48,44,28,,,,45,54,,,,,,44,,,182,324,
     160,54,,34,43,30,,,36,29,54,,34,,33,29,396,238,387,216,374,214,74,39,
     74,34,78,35,,56,38,,36,56,38,52,36,,,34,28,,41],
   [,,,,,,,,,,,,,43,47,42,,,69,,,38,54,40,74,45,36,54,40,74,42,74,34,74,,
     190,,168,,,53,43,43,50,,36,,60,,53,,35,40,338,254,,232,360,246,81,43,
     81,43,81,41,81,48,38,46,36,48,38,44,36,34,,41,,,34,,41],
   [,,,,37,30,50,,,,,,,18,24,13,,,,,,13,,,,,45,43,36,56,,,37,,,66,54,68,,,,
     16,12,12,,,,,,,,,12,,86,74,,,70,,60,59,44,,60,59,,13,12,14,,12,14,13,
     30,,,33,27,45,27,54,39],
   [,,,,57,28,96,,,,,,,13,19,15,,,,,,15,,,,46,62,48,,66,,,62,74,,,59,,,,,24,
     24,24,94,24,,,,,,,24,,83,81,87,,81,,82,84,70,,80,86,,13,13,,,13,,13,,
     28,,,36],[18,,,,,20,,,,,9,15,7,9,15,7,15,7,15,7,7,7,32,,,31,53,28,
     33,,,64,52,64,39,39,35,39,16,50,8,16,8,8,50,16,8,16,50,8,50,8,8,
     53,53,49,53,53,49,56,57,52,48,56,53,56,9,9,9,9,9,9,9,9,59,20,,,,,,
     ,,10,11],[28,,,71,,30,,28,,62,15,20,13,18,15,14,21,12,14,13,12,13,
     48,56,69,,60,,37,,35,65,,63,82,80,72,82,21,49,14,16,15,13,49,22,13,
     15,49,14,49,13,14,105,104,,106,105,,65,71,65,42,74,,65,15,16,14,14,
     15,14,14,15,38,25,41,26,,,34,42,51,16,17],
   [,,,,,26,,26,,,11,18,9,13,21,11,18,9,21,9,9,9,50,,70,44,58,,42,,,60,
     60,71,57,,53,,19,58,10,22,12,10,58,19,10,22,58,10,58,10,10,75,73,
     73,73,,71,80,76,62,60,78,74,,11,13,11,11,11,11,11,11,53,26,,,,,,,,
     12,13],[28,30,27,,33,,39,23,,45,,,,,24,13,,,24,,,13,47,37,49,33,43,
     43,,49,33,49,39,57,63,69,54,71,19,52,10,17,10,12,45,19,10,17,52,
     10,48,10,10,88,86,74,88,86,70,65,53,59,43,59,49,64,15,13,12,,15,
     12,14,13,,30,59,37,34,,,50,,12,,10,16,12],
   [30,49,42,71,37,30,55,38,59,59,,,,,19,15,,,19,,,15,50,53,78,,58,48,41,
     66,49,66,44,74,61,73,59,61,24,57,,,24,24,57,,,24,59,,57,,24,83,95,
     81,83,85,81,79,,77,52,81,59,85,11,11,13,11,11,11,11,11,,28,52,37,
     34,52,42,44,,,13,11,17,13],[],[],
   [,,,,,28,96,,,,,,,13,,15,,,19,,,15,56,,70,46,66,48,53,,,74,62,,,61,59,,,
     94,,24,24,24,76,26,,24,,,102,,24,87,83,81,85,85,81,90,82,70,68,88,
     80,,11,11,11,11,11,13,11,11,,32,,53,36,,,,,,13,11,17,13,,13],
   [,53,,,,26,,22,,,11,18,9,13,21,9,18,9,21,9,9,11,,,71,48,58,48,42,62,
     61,74,64,70,57,57,,57,19,58,10,22,10,10,58,19,10,22,58,10,58,10,
     12,73,75,77,73,73,71,64,78,76,60,64,74,80,11,11,11,11,11,11,11,13,
     ,26,,,,,,,,12,13,,,11,12,13,,,13],
   [,,,,33,,40,,,40,,,,41,49,33,49,33,,,,33,,,,55,84,53,,60,,,,62,,155,281,
     159,,,,31,,,40,33,,,,,40,,,,213,333,213,,197,,95,84,79,,95,84,,35,,35,,
     33,,35,,,,,43,,39,,,,,33,37,42,36,43,,,,42],
   [,,,,61,70,66,,,74,,,,52,53,49,54,43,,,45,,,,,52,61,48,,57,,,57,61,,229,,
     207,,,,50,43,44,84,43,55,,,,88,43,,,307,314,285,,299,,48,48,41,,48,48,
     ,47,48,45,,47,,45,43,,,48,82,61,,57,61,49,,64,56,56,,67,,,72],
   [36,,58,,41,,50,56,,54,36,58,40,36,56,40,,40,,40,,38,34,55,52,34,52,
     32,57,39,51,52,52,43,168,168,164,168,34,,54,34,,32,66,34,51,34,,54,
     62,47,,232,232,228,232,232,232,59,59,46,43,59,59,50,36,36,36,36,36,
     36,36,36,45,52,54,,,,56,50,,46,56,32,,,,52,,,,46,,41],
   [,,,,39,,36,,,40,,39,,41,,27,,25,39,,27,27,,,,61,79,51,,56,,,87,60,227,
     151,,155,30,46,27,31,29,26,38,27,27,30,46,27,38,27,29,297,211,264,
     203,347,189,87,95,78,77,,91,80,,37,37,35,,35,37,37,,38,,,,,,,,33,,,,,,
     49,,,,,31],[54,,63,,55,,60,59,,74,59,69,38,52,57,37,53,35,67,38,43,
     35,41,56,57,52,41,35,60,42,54,57,35,46,254,221,209,199,47,,37,50,37,
     ,84,43,37,47,,37,84,38,37,320,291,280,269,320,263,64,48,49,46,64,
     42,53,51,47,48,45,51,47,49,45,52,72,61,35,,,62,51,61,52,62,,45,,56,
     59,,,79,60,,48],[36,27,54,45,27,48,45,54,45,45,34,,36,27,35,37,35,,
     ,36,31,,34,61,52,36,43,34,55,52,61,52,39,52,149,129,151,129,30,51,
     27,27,27,30,51,27,27,30,51,27,51,27,27,201,179,199,179,201,175,59,
     50,59,43,59,46,59,30,27,29,27,30,27,29,27,43,42,52,43,45,52,45,52,
     52,33,46,31,35,44,,,,,46,48,33,41,34,33,41],
   [54,34,66,54,41,70,34,72,54,36,50,41,46,,48,,48,,,46,40,60,41,79,61,
     43,50,48,84,41,93,61,46,43,217,,204,168,40,60,35,34,35,38,40,34,35,
     40,60,35,38,35,35,276,289,271,232,276,315,68,57,48,50,68,53,50,42,
     42,40,36,42,41,40,36,73,56,72,69,62,72,60,68,72,43,68,53,47,68,37,,
     ,,66,54,40,48,41,40,48],
   [,,,,37,,44,,,46,,39,46,37,69,27,,29,39,46,,27,,,,65,,53,,62,,65,,64,
     356,167,336,161,32,50,31,31,29,28,40,33,31,32,50,31,40,29,29,377,
     215,,213,367,203,,105,85,84,,99,89,54,35,37,37,54,35,,35,,40,,,,,,,,39,
     ,,79,,,51,,,,,33,,,35,,33,40],
   [,,,,61,70,66,,,74,64,71,,52,53,49,61,43,,,45,47,,,,52,61,48,,57,63,,
     57,61,247,229,237,207,55,,45,50,55,44,88,43,43,,,45,88,47,43,323,
     307,316,285,331,299,68,50,46,41,,46,50,50,47,48,45,50,47,48,45,43,,
     58,48,78,61,,,61,49,80,,52,60,62,,,,70,74,,41,41,,48,41,48],
   [54,,71,,61,,66,67,,74,,,50,52,,47,53,47,71,50,,43,41,58,61,52,43,39,
     60,46,58,61,41,50,,229,,207,47,,,50,43,48,90,43,,47,,,84,43,45,326,
     307,333,285,324,299,68,50,53,50,68,48,57,49,47,49,45,49,47,,45,52,
     72,61,43,,67,74,57,,49,70,57,49,70,,65,,,,60,,48,,,41,41,48,,48],
   [54,34,72,54,41,74,32,66,54,34,50,51,46,,48,,48,60,41,46,40,,41,93,
     61,43,50,48,88,39,79,61,46,41,217,,204,168,40,60,35,34,35,38,38,34,
     35,40,60,35,40,35,35,276,308,271,232,276,283,68,57,46,50,68,53,48,
     42,,40,36,42,41,40,36,,56,72,,62,72,60,68,72,43,66,54,47,58,,69,,,
     70,58,40,48,41,40,48,,34,40,48,48],
   [90,,,273,229,,,,272,,45,77,,45,,43,80,,78,,43,47,168,227,247,149,217,164,
     ,254,227,,210,,41,41,39,43,78,438,63,78,75,62,438,78,75,78,,63,338,
     61,,285,285,281,285,285,277,270,267,266,212,270,259,270,45,45,45,45,
     45,45,45,45,,132,272,,,,,266,378,72,65,39,,,63,,,,67,55,218,,168,,,149,
     216,311,,261,216],[90,129,120,190,125,120,186,120,190,190,45,76,,45,
     79,45,80,45,80,,,47,168,159,229,129,262,160,155,225,151,229,,229,41,
     43,41,43,78,220,68,78,63,60,222,78,,78,220,68,222,75,61,285,285,277,
     285,285,281,290,207,282,190,290,203,290,45,45,45,45,45,45,45,45,129,
     122,190,121,128,190,120,186,190,67,61,39,,57,,,,,63,57,159,229,168,
     153,221,129,,165,229,229,,41],
   [90,,,292,,136,,118,,344,45,67,35,45,67,35,67,35,67,35,35,35,164,237,
     249,151,204,140,281,208,,239,176,,41,39,35,41,76,,40,76,40,40,418,76,
     40,76,318,40,418,40,40,273,273,245,269,273,245,256,257,228,204,252,
     229,256,45,45,45,45,45,45,45,45,,136,,165,,352,,,352,54,59,35,73,55,
     54,59,,,59,55,226,237,164,,208,151,204,,,240,204,41,41],
   [,,,,,52,,,,,,,,53,55,34,49,34,,,58,32,,,,51,60,,45,,,,48,,,214,,196,,,,49,
     33,34,,42,37,,,,,49,35,,282,369,258,,254,,47,,40,,39,,,46,48,46,,46,
     70,44,,,,46,,49,,,47,,,,61,,47,64,,,,,,,64,,65,70,84,,81,67,90,507,214]
    ,[,,,,45,32,59,,,59,,,,18,19,19,17,,,,,19,,,,45,60,62,47,74,,,60,74,,
     95,81,128,,,,28,28,28,59,26,,,,,55,,28,,,111,139,,111,,75,86,64,,75,85,
     ,17,17,,,17,,17,,,,71,41,,42,71,,,,17,22,20,,20,,,20,20,43,,84,49,79,
     50,78,47,81,,79,103,100,81],
   [18,,,54,,20,54,18,,48,18,15,14,18,15,14,15,14,15,14,14,14,32,,43,29,
     40,28,31,,30,43,36,50,75,75,65,75,16,42,15,16,15,14,42,16,15,16,
     42,15,42,15,15,101,101,91,101,101,91,54,51,42,40,54,47,46,16,16,15,
     16,16,15,16,16,35,20,48,,,,18,,48,19,20,13,,,19,20,,,20,,31,43,32,,,
     29,40,47,43,50,40,75,75,65,,17],
   [,,,,,54,,86,,,,,66,53,49,36,55,34,90,66,60,34,66,40,88,51,40,62,40,
     90,40,92,34,88,388,222,590,200,,,37,49,37,36,,42,,74,,37,,38,37,454,
     288,,266,,268,95,47,91,45,97,41,95,76,46,48,46,76,46,70,44,44,,51,,,,
     ,49,44,57,,,,,49,62,,,,,,73,,,,68,94,,73,93,86,,222,,47],
   [38,,,58,53,30,44,29,,55,18,15,14,18,25,15,15,14,26,14,14,13,60,,,43,
     56,76,43,63,41,61,54,60,94,90,89,92,16,55,15,26,16,14,49,16,15,27,
     55,15,51,15,14,119,,111,,115,118,77,69,89,56,,67,77,16,17,15,16,16,
     15,16,15,47,34,68,,,,32,,70,19,20,,,,19,20,,,20,18,39,69,,35,,,82,41,
     75,75,56,,91,86,,17],
   [18,27,24,43,27,24,43,20,43,43,16,,18,18,22,17,20,,24,18,16,17,34,31,
     50,27,34,34,31,50,27,50,30,50,78,78,76,78,16,49,15,18,14,16,49,16,
     15,18,49,15,49,15,14,106,106,104,106,106,100,57,41,57,34,57,37,57,
     16,17,16,16,16,16,16,17,25,24,32,25,24,32,24,32,32,19,24,16,21,19,,
     ,,,24,19,33,41,34,33,41,25,,33,41,41,65,78,78,76,38,,16,40,16],
   [,67,,,41,34,62,,57,,,,,,19,19,19,,19,,,19,74,,74,53,64,62,49,67,,72,56,
     ,95,118,81,,,57,,30,28,28,,26,,29,59,,67,,28,125,166,111,127,,111,85,
     79,83,60,86,75,,16,15,17,16,16,15,16,15,,38,,63,41,77,42,71,,,20,
     17,22,20,,,,,20,20,51,89,62,53,77,,,52,98,94,75,98,,81,,17,17,,17],
   [18,33,,54,35,20,,18,,,16,13,12,14,15,11,13,12,15,12,12,11,32,,47,29,
     40,28,31,39,30,,36,43,65,65,57,65,14,42,13,16,12,12,42,14,13,16,
     42,13,42,13,12,87,87,79,87,87,79,46,51,50,40,46,47,54,14,13,13,14,
     14,13,14,13,33,20,52,,24,54,,,,17,18,13,,16,17,18,,,18,16,31,47,32,
     30,39,29,40,,,43,40,65,65,57,,15,13,,13,14,15],
   [,,,,,54,,86,,,,,66,53,55,36,54,36,90,66,,34,,,,51,60,,47,,64,,50,,,222,,
     198,,,53,49,36,36,,42,37,74,,53,,,35,504,294,428,266,,270,92,45,,40,,
     41,92,76,46,48,46,76,46,,44,,,44,46,,53,,,51,,,,46,,49,62,,,,,,68,70,,
     71,74,94,,,75,94,538,226,,40,,,47,,40],
   [18,25,22,32,21,20,28,22,32,32,18,15,14,18,15,14,15,14,15,14,14,14,
     32,29,39,25,32,28,27,35,29,39,28,39,75,75,65,75,16,34,15,16,15,14,
     34,16,15,16,34,15,34,15,15,101,101,91,101,101,91,46,39,42,32,46,35,
     46,16,16,15,16,16,15,16,16,25,20,32,21,20,32,18,28,32,19,20,13,18,
     21,19,20,,,20,21,27,39,32,25,35,25,32,27,39,39,32,75,75,65,36,17,
     13,36,,16,17,13,36],[],
   [,,,,,52,,,,,,,,53,51,34,55,34,,,58,32,60,32,80,51,36,60,38,84,36,84,
     32,80,,220,,194,,,36,49,35,34,,42,50,,,36,,35,35,502,286,,258,504,256,
     87,43,85,43,87,39,87,,46,48,46,,46,70,44,40,,47,,,,,45,,51,,,,,47,64,,
     ,,,,67,,,83,70,84,,69,,90,521,220,468,39,,,40,,38,,,47,36],
   [,,,,41,32,56,,62,69,,,,18,21,19,17,,19,,,19,,,69,45,62,62,47,67,,75,
     60,88,,,81,99,,78,,28,28,28,56,28,,29,,,61,,28,144,127,111,,133,111,
     87,75,83,64,88,75,99,16,15,15,16,16,17,16,15,,40,,63,41,75,42,71,,,
     20,17,22,20,,20,,,,20,43,,,49,83,50,,47,83,,,117,98,81,,17,17,,17,,
     17,15,,17],[34,35,,58,75,30,47,27,,49,18,15,14,18,25,13,15,14,26,
     14,14,15,56,,57,47,56,,43,82,43,61,56,88,89,95,,,16,55,15,26,14,14,
     51,16,15,27,55,15,49,15,16,118,120,,116,,113,77,71,76,56,77,67,77,
     16,15,15,16,16,15,16,17,,34,70,,39,,32,69,68,19,20,,,18,19,20,,,20,,
     39,,,39,,,47,41,75,75,49,93,,86,,17,,,15,16,17,13,,,,,17],
   [126,,196,406,235,,338,184,,,63,102,67,63,104,,103,57,107,67,57,57,232,,
     323,201,276,220,383,316,,321,260,,285,285,273,285,106,424,,106,77,80,,
     106,,106,432,,428,77,77,55,55,53,57,57,53,360,351,348,276,360,335,
     360,63,63,63,63,63,63,63,63,277,172,342,,,,196,,348,91,85,53,,,87,83,,
     ,,75,313,336,232,,,201,276,417,321,323,276,285,285,273,394,130,101,,,
     106,,87,500,101,,462,139,118],
   [126,179,150,254,167,156,238,150,254,254,63,105,65,63,105,57,,57,104,65,
     61,61,232,209,307,179,,220,213,295,209,307,292,307,285,285,273,285,
     106,288,,106,91,80,288,106,77,106,284,,288,,77,55,57,55,57,57,53,382,
     285,370,254,382,273,382,63,63,63,63,63,63,63,63,179,160,254,167,162,
     254,150,242,254,88,83,53,101,,,,,,83,75,213,307,232,209,295,179,,219,
     307,307,,285,285,273,282,131,101,288,115,106,,87,294,101,,278,126,122,
     55],[126,231,,341,,,287,168,334,,63,93,49,63,93,49,93,49,93,49,49,
     49,228,264,316,199,271,196,333,280,420,314,236,315,281,277,245,281,
     104,486,56,104,56,56,382,104,56,104,,56,382,56,56,55,53,49,55,53,49,
     350,329,314,268,346,293,350,63,63,63,63,63,63,63,63,231,164,334,,194,
     334,,,409,74,81,49,95,71,74,81,,,81,77,,317,228,285,,199,270,,,318,
     272,281,277,245,484,111,91,430,113,104,111,79,,91,,369,111,119,55,55],
   [126,179,152,232,163,160,220,152,232,232,63,,67,63,105,59,102,61,,67,59,
     57,232,205,285,179,232,216,215,269,205,285,216,285,285,285,269,285,
     106,264,101,106,77,76,268,106,79,106,266,101,264,,79,55,57,53,57,55,
     53,338,285,322,232,338,273,338,63,63,63,63,63,63,63,63,179,160,232,
     167,160,232,152,220,232,,93,53,105,73,86,,,,85,75,213,285,232,207,273,
     179,232,213,285,285,232,285,285,269,256,158,101,268,115,106,125,87,
     266,101,,256,131,117,55,55,55],
   [126,259,170,,,,,186,,354,63,107,67,63,103,61,106,,102,67,57,57,232,,324,
     201,276,220,,,357,323,260,324,285,285,273,285,106,424,88,106,77,80,
     398,106,79,106,506,88,,77,,55,57,53,57,57,55,360,351,348,276,360,339,
     360,63,63,63,63,63,63,63,63,237,,384,249,,,170,340,,86,87,53,105,73,
     86,83,,,,73,,322,232,344,312,201,276,,323,,276,285,285,273,486,141,101,
     648,117,106,125,87,868,101,,,,118,55,55,55,55],
   [72,,89,,68,,73,89,82,81,61,68,60,68,68,52,67,56,,60,,52,59,82,48,59,
     48,46,86,53,80,50,46,57,270,290,256,246,57,,53,57,,50,93,50,51,57,,
     53,91,61,51,360,382,350,338,360,366,55,55,60,57,57,53,64,57,58,56,
     54,57,58,56,54,74,86,81,,,,89,73,82,64,88,56,,,59,79,,,,78,109,68,50,
     ,,59,68,92,68,65,68,270,290,256,89,85,46,,,57,83,54,97,46,,,90,77,
     360,382,350,338,360],
   [72,52,88,41,48,88,41,88,43,43,66,66,56,45,61,47,61,43,67,56,49,,59,
     95,48,50,57,55,95,48,95,50,53,50,267,207,257,207,50,47,43,41,43,46,
     47,41,43,50,45,43,45,43,43,351,285,329,285,351,277,55,64,55,57,57,
     60,57,54,45,51,45,54,45,51,45,79,70,92,71,79,92,75,84,92,53,82,57,
     59,76,,,,,82,78,54,68,59,55,64,43,,57,68,68,58,267,207,257,108,78,
     51,112,,43,,51,118,39,,108,78,89,351,285,329,285,351,55],
   [54,,,,62,86,67,,,81,61,70,42,68,70,44,70,44,67,42,46,44,50,99,,59,68,
     49,,58,,65,58,68,266,282,228,242,50,,45,57,46,44,91,50,45,50,88,45,
     91,46,45,348,370,314,322,348,330,48,53,49,48,46,49,53,57,58,56,54,
     57,58,56,54,69,72,82,62,93,81,,,81,59,70,52,64,76,62,77,,,84,,,65,
     59,99,58,59,68,,,68,68,266,282,228,,86,50,93,73,57,83,42,,42,,85,83,
     78,348,370,314,322,348,55,55],
   [54,43,66,34,32,68,39,66,34,43,50,47,46,43,48,,48,38,47,46,40,38,50,
     77,41,43,50,39,79,46,77,41,46,50,212,190,204,168,40,40,35,34,35,38,
     45,34,35,40,40,35,45,35,35,276,254,268,232,276,250,48,57,53,50,48,
     53,57,42,38,40,36,42,38,40,36,65,56,72,63,62,72,60,68,72,43,70,48,
     47,60,44,57,,,68,60,49,59,50,52,59,43,52,52,59,59,52,212,190,204,
     84,67,40,90,57,41,,40,90,32,,84,65,57,276,254,268,232,276,48,41,48],
   [72,71,89,,68,80,73,85,86,81,61,68,60,68,73,52,70,54,70,60,,52,59,80,
     48,59,50,46,86,53,80,50,48,57,270,290,252,246,57,,72,57,51,46,93,50,
     ,57,124,72,91,51,61,360,382,346,338,360,366,55,57,60,57,57,55,64,
     57,58,56,54,57,58,56,54,74,86,81,75,,86,85,73,,59,90,56,64,,59,79,,,
     ,78,,68,50,,66,59,68,127,68,,68,270,290,252,87,88,46,,77,57,86,54,
     97,46,,,,76,360,382,346,338,360,48,55,55,48],
   [72,52,84,41,42,88,35,84,39,41,66,64,44,45,61,35,61,35,64,44,41,35,
     59,91,48,46,53,49,95,42,91,46,49,48,259,203,229,199,46,41,39,37,39,
     38,41,37,39,46,41,39,41,39,39,335,273,293,273,339,245,55,60,49,53,
     53,56,55,54,45,51,45,54,45,51,45,79,62,92,63,71,92,63,76,92,49,80,
     53,55,74,60,59,,,80,74,48,68,59,47,58,43,58,51,68,68,,259,203,229,
     104,78,47,112,72,43,78,47,112,35,,104,78,93,335,273,293,273,339,55,
     41,49,41,55],[18,,18,50,31,20,,,44,,9,14,7,9,13,7,14,7,13,7,7,7,
     32,29,,28,38,28,30,39,,44,34,45,39,39,35,39,15,40,8,14,8,8,40,15,
     8,14,40,8,40,8,8,53,53,49,53,53,49,49,48,45,38,49,44,49,9,9,9,9,
     9,9,9,9,35,20,44,,,,18,,,10,11,7,,,10,11,,,11,9,30,45,32,,,28,38,,
     43,46,38,39,39,35,40,16,13,,,15,16,12,66,13,,40,16,14,53,53,49,53,
     53,49,48,45,38,49,44],
   [18,27,28,39,27,28,39,28,39,39,9,15,,9,15,11,,11,15,,11,11,36,37,48,
     27,,36,37,48,37,48,46,48,45,45,45,45,16,49,,16,16,14,49,16,16,16,
     49,,49,16,16,63,63,63,63,63,63,60,45,60,39,60,45,60,9,9,9,9,9,9,
     9,9,27,28,39,27,28,39,28,39,39,15,11,9,15,11,,,,,11,11,37,48,36,
     37,48,27,,37,48,48,42,45,45,45,49,16,16,49,16,16,,14,49,16,,49,16,
     16,63,63,63,63,63,60,45,60,39,60,45,9],
   [18,31,,50,,20,,18,44,,9,13,7,9,14,7,13,7,14,7,7,7,32,,43,28,38,28,
     30,,29,45,34,44,39,39,35,39,14,40,8,15,8,8,40,14,8,15,40,8,40,8,
     8,53,53,49,53,53,49,49,48,45,38,49,44,49,9,9,9,9,9,9,9,9,31,20,
     44,31,24,,,,,10,11,7,14,9,10,11,,,11,9,30,44,32,29,39,28,38,,,43,
     38,39,39,35,,15,13,70,13,14,15,11,,13,,,15,13,53,53,49,53,53,49,48,
     45,38,49,44,7,9]],
 [,[],[],[],[,36,,52],[],[,40,,59],[],[,,,46,52,,59],
   [,46,,59,,,46,,59],[18,,,,49,,,20],[,31,,,47,,,26,66,64],[],
   [18,38,,67,,,64,,,61,9,15],[,45,,,63,,66,30,78,,10,16],
   [,45,,64,47,,56,30,102,,11,17],[28,,,68,43,,,29,,62,,13,,15,16,17],
   [30,75,,68,44,,,26,71,106,,,,11,12,13],
   [28,37,,72,41,,56,,,51,10,16,,,12,,16,12],
   [,56,,,,,,28,,,11,17,,,,13,17,13],[,,,,57,,,26,,,,,,11,12,13,,11,12,13],
   [30,44,,80,,,72,28,,72,11,17,,,,13,17,13,,13,13],
   [36,,,,52,,58,,,62,32,,,36,,,46,48,46,,48,50],[],
   [,39,,,66,,64,,62,74,,50,,60,62,65,74,71,55,80,68,67],
   [36,51,,66,,,66,44,66,66,31,36,,30,,,,44,36,46,44,54,34,,47],
   [64,70,,85,78,,81,60,89,89,62,48,,,47,,65,58,49,68,62,62,45,,52],
   [36,40,,62,,,,52,62,,28,,,36,43,48,,,43,48,,48,34,,39,34,45],
   [,,,,,,,42,,,,48,,61,,85,51,43,41,,,91,,,,,74],
   [64,60,,76,49,,,80,76,66,64,58,,60,75,66,62,68,61,78,73,,46,,57,,53],
   [,,,,,,,,,,33,37,,61,40,,38,38,,,42,45,,,,35,44,,35],
   [,51,,62,66,,70,,,74,66,57,,58,,69,,60,53,,110,80,,,45,47,52,45,,57],
   [,68,,,80,,85,60,91,85,,47,,66,51,90,57,50,49,62,63,58,,,52,,38,45,,
     55,44,52],[],[90,,,,,,344,,,543,39,,,45,69,,80,55,,,59,63,168,,,153,
     228,164],[90,185,,284,202,,280,,307,354,39,,,45,,,79,,75,63,55,73,168,
     ,268,143,,160,245,289,198,270,,,41],
   [90,,,489,,,,136,489,336,35,76,,45,54,59,,,54,59,57,59,164,,238,153,228,
     140,,,281,259,220,,41,41],
   [90,159,,244,,,241,128,,262,39,79,,45,,73,,,68,77,55,,168,,227,141,205,
     164,233,248,208,237,205,,41,41,41],
   [18,,,,35,,74,20,54,,13,,,18,19,20,18,21,19,20,,20,32,,,29,46,28,30,50,
     31,55,,,75,75,65,75],
   [,,,,94,,96,,78,102,,,,93,85,98,96,93,,,,105,,,,108,123,90,,120,,94,,,,,,
     506],[],[18,31,,48,,,44,24,,44,16,22,,16,,,21,19,19,24,19,,34,,46,
     27,,34,48,46,35,46,60,,78,78,76,78,16,70],
   [36,55,,80,56,,82,41,,146,17,23,,,,,22,20,,20,20,20,62,,77,,,61,78,75,
     48,91,79,,142,,81,113,17],
   [18,39,,56,,,,20,56,56,13,,,16,17,18,,16,17,18,16,18,32,,41,29,45,28,,,
     31,44,48,,65,65,57,65,13,,,14,15],
   [,52,,68,,,,,62,56,,56,,93,55,132,57,63,80,,,127,70,,77,74,92,,,,,77,151,
     ,713,521,,321,,94,,46],
   [18,25,,46,,,42,20,46,46,13,21,,18,19,20,,,19,20,21,20,32,,43,27,36,
     28,28,50,29,47,36,,75,75,65,75,13,,,16,17,13,47],
   [,,,,54,,,33,67,,,,,18,19,20,,,19,20,18,20,71,,84,48,69,55,43,69,44,65,
     73,,89,99,91,,,,,16,17,13],
   [18,38,,72,41,,60,,,68,16,22,,16,19,26,21,19,,,19,24,34,,56,32,44,34,
     33,52,,,44,,78,78,76,78,16,,,16,,14,,16,16],[],
   [36,60,,126,,,73,,,78,17,23,,,,20,22,20,,,20,20,62,,82,49,,61,72,81,45,,
     63,,,97,81,153,17,,,,17,15,,17,17],
   [,76,,102,,,74,,100,,,,,93,85,110,86,93,87,,,105,96,,110,104,140,,,104,,
     114,,,,,,614,,91,,70,,,76],
   [,,,,55,,,33,78,,,,,18,19,20,,18,19,20,,20,,,,,51,75,40,74,41,93,52,,102,
     ,91,89,,,,16,17,13,,,15,16,,17],
   [32,50,,80,,,81,35,,88,17,23,,,,20,22,20,,20,20,,58,,70,,,61,78,,52,93,
     79,,95,123,81,97,17,,,,17,15,,17,17,,,17,,17],
   [126,,,,279,,,180,402,526,53,,,63,86,87,107,73,,87,77,83,232,,,207,300,
     220,,349,289,342,,,285,285,273,285,101,,,106,,87,531,101,116,106,,131,
     744,121,125],[126,214,,361,260,,341,172,358,362,53,105,,63,,,102,75,
     83,83,73,83,232,,331,197,,220,273,371,229,344,314,,285,285,273,285,
     101,558,,106,,87,410,101,,106,,126,,119,133,55],
   [126,,,398,,,,,,456,49,95,,63,74,81,100,71,74,81,73,81,228,,,207,291,196,,
     ,281,335,290,,281,277,245,281,91,859,,104,111,79,,91,111,104,,111,
     1023,115,111,55,55],
   [126,207,,316,,,298,160,317,325,53,103,,63,86,,,,86,87,75,83,232,,304,
     195,270,216,269,,,319,270,,285,285,269,285,101,580,,106,129,87,353,101,
     ,106,,162,699,118,,55,55,55],
   [126,251,,,270,,400,,,430,53,105,,63,86,85,,75,,,73,83,232,,332,207,299,
     220,,347,,,,,285,285,273,285,101,588,,106,129,87,569,101,115,106,,,703,
     118,127,55,55,55,55],
   [126,,,,239,,331,148,340,343,49,,,63,70,81,,71,70,81,71,81,232,,,193,,
     196,252,342,217,333,,,277,281,245,277,91,,,100,111,79,365,91,111,100,,
     111,620,112,111,55,55,49,55,55],
   [58,,,,83,,83,75,83,89,56,,,68,62,,66,74,63,,80,82,52,,,61,70,57,89,73,
     ,65,,,278,288,266,264,50,,,57,84,54,98,50,93,53,,89,129,80,84,372,
     386,360,358,372,372],
   [72,85,,100,111,,98,76,112,106,57,64,,54,,,,68,62,82,76,82,61,,67,49,,
     57,,73,60,74,60,,279,249,263,243,51,150,,49,,51,114,45,77,56,,82,156,
     88,101,369,339,353,333,369,331,57],
   [72,64,,89,,,,88,91,81,52,,,68,65,80,57,,65,84,,77,61,,61,61,70,44,,,
     83,72,72,,274,280,238,260,50,125,,59,84,45,,46,79,59,,84,110,99,89,
     360,374,324,342,360,336,57,57],
   [58,67,,85,73,,81,60,83,87,52,51,,49,,65,,,49,,63,58,52,,65,49,58,52,,
     66,53,,58,,224,222,216,198,44,,,45,,43,92,36,,44,,67,126,61,62,294,
     292,286,268,294,286,50,47,50],
   [58,68,,81,83,,83,,,89,56,64,,68,62,81,68,74,,,78,84,52,,60,61,72,57,
     82,73,,,70,,278,288,262,264,50,122,,57,87,54,94,50,77,53,,,129,74,99,
     372,386,356,358,372,372,50,57,57,50],
   [72,,,,101,,,68,,100,53,,,54,63,68,,62,58,80,,68,61,,,49,60,51,54,77,54,
     72,,,271,245,235,235,47,,,49,83,47,,41,75,52,,83,152,75,83,353,327,
     317,321,357,299,57,47,51,47,57],
   [72,70,,89,78,,75,90,91,,56,74,,68,,84,62,73,,86,,,61,,67,61,72,52,,66,
     85,72,70,,278,288,266,264,54,131,,59,86,49,90,50,99,59,,86,,,93,372,
     386,360,358,372,372,57,57,50,50,57,57],
   [18,,,,34,,50,20,,48,7,,,9,10,11,14,9,10,11,9,11,32,,,28,43,28,,49,30,
     47,,,39,39,35,39,13,,,14,15,11,81,13,13,14,,15,,13,15,53,53,49,53,
     53,49,52,48,48,41,52,44,52],
   [18,31,,46,33,,48,26,50,48,9,14,,9,,,14,11,14,11,11,11,36,,50,29,,36,
     51,51,37,50,46,,45,45,45,45,16,74,,16,,14,70,16,16,16,,16,74,16,16,
     63,63,63,63,63,63,60,51,60,42,60,51,60,9],
   [18,35,,52,,,,20,52,52,7,12,,9,10,11,12,9,10,11,9,11,32,,42,29,40,28,,
     ,31,45,40,,39,39,35,39,13,,,14,15,11,,13,13,14,,15,,13,15,53,53,49,
     53,53,49,50,51,46,40,50,47,50,7,9],
   [18,,,40,31,,38,20,42,42,7,,,9,10,11,,,10,11,9,11,32,,38,27,36,28,30,
     43,29,42,36,,39,39,35,39,13,62,,15,16,12,40,13,,15,,16,62,14,16,53,
     53,49,53,53,49,48,45,44,36,48,41,48,7,9,7],
   [18,37,,64,41,,64,,,,9,14,,9,14,11,14,11,,,11,11,36,,52,31,44,36,,52,,,
     44,,45,45,45,45,16,122,,16,16,14,122,16,16,16,,,122,16,16,63,63,63,
     63,63,63,58,57,58,44,58,57,58,9,9,9,9],
   [18,,,,34,,50,20,,48,7,,,9,10,11,14,9,10,11,9,11,32,,,28,43,28,,49,30,
     47,,,39,39,35,39,13,,,14,15,11,81,13,13,14,,15,,13,15,53,53,49,53,
     53,49,52,48,48,41,52,44,52,7,9,7,7,9],
   [18,33,,,35,,52,20,,,7,16,,9,10,11,16,9,10,11,,11,32,,43,29,40,28,,46,
     31,47,40,,39,39,35,39,13,,,15,16,12,64,13,14,15,,16,,,16,53,53,49,
     53,53,49,50,51,46,40,50,47,50,7,9,7,7,9,7],
   [18,31,,44,33,,52,26,48,44,9,14,,9,14,11,14,11,14,11,11,,36,,48,29,
     40,36,52,49,37,48,40,,45,45,45,45,16,74,,16,16,14,72,16,16,16,,16,
     74,16,,63,63,63,63,63,63,56,51,56,40,56,51,56,9,9,9,9,9,9,9],
   [],[,,,,,,,,,,,,,36,33,44,38,36,,,,44,,,,60,102,,,,,,,,,,,182,,,,30,,,,,,,,,,,
     ,,190,,204,204,,,104,,,99,,107,,32,,26,36,,,32],
   [,,,,,,,,,,,,,,,111,50,62,,,,,,,,63,88,,,,,,,,,284,460,244,,,,57,92,56,,42,
     78,60,,80,,,68,,364,,314,414,,,59,,52,,,,,50,52,42,,,,48],
   [,,,,,,,,,,49,49,,35,38,,,43,57,,57,45,50,,74,,50,50,42,70,41,73,50,,246,
     ,262,179,35,,,33,,,,31,46,41,,55,,45,48,,230,286,231,276,230,78,,79,
     44,79,65,78,34,32,45,29,41,34,35,31,,,46],
   [,,,,,,,,,,20,29,,36,,28,26,26,30,32,26,28,52,,70,,77,,,,,70,,,130,,136,
     128,20,88,,30,34,20,60,20,31,24,,39,88,31,33,166,172,164,168,,152,
     88,98,,77,88,88,77,20,26,20,20,28,20,20,26,,30],
   [,,,,,,,,,,,62,,61,51,,,104,,,,64,62,,85,63,,62,56,84,52,85,44,,391,283,,
     269,54,,,55,,58,,42,94,,,63,,60,,410,361,461,329,,,89,59,89,55,91,51,
     91,48,48,52,42,,48,,44,,,59],[],
   [,,,,,,,,,,,136,,64,64,74,69,,70,92,,68,,,,,,,,,,,88,,490,338,,320,,,,58,65,,
     ,,,60,,80,,,67,498,394,,367,452,397,79,57,73,52,77,53,84,56,50,,44,
     60,56,68,48,,,52,52,,68],[],
   [,,,,53,,,29,68,,,,,18,19,20,,,19,20,,20,,,,,49,47,36,66,37,65,,,,77,,,,,,
     16,17,13,,,,16,,17,,,17,,102,97,,,,,72,62,,65,,70,,16,13,,16,,16,16,,,,
     37,26,61],[,,,,53,,,26,,,,,,13,14,15,,,14,15,,15,,,,44,63,48,,63,42,
     73,,,,,57,57,,,,22,23,27,90,21,,22,,23,,,23,,73,,73,73,,,76,80,63,,,78,
     ,13,11,,13,,,13,,30,,52,26],
   [18,51,,,,,,,,,9,18,,9,18,,18,13,18,13,13,13,36,,58,34,50,36,60,,,59,50,
     ,45,45,45,45,18,84,,18,,14,88,18,18,18,,18,84,18,18,63,63,63,63,
     63,63,61,66,61,50,61,66,61,9,9,9,9,9,9,9,9,,30,,,,,,,,15,11],
   [28,45,,78,,,66,30,,,10,19,,18,10,,19,14,12,23,14,23,47,,58,,60,43,,72,
     42,64,,,75,,54,,19,77,,16,,15,51,19,19,17,,28,77,19,28,91,83,74,91,
     86,70,68,67,65,48,69,63,67,10,13,10,10,13,10,10,13,,29,,34,,,,59,,
     16,12],[,56,,,,,,32,,,11,20,,13,23,11,20,15,23,13,15,13,54,,70,46,
     66,48,82,,,71,68,,67,,59,,20,97,,24,17,16,123,20,20,28,,18,97,20,18,
     85,83,81,87,,81,88,82,73,72,94,80,,11,13,11,11,11,11,11,11,,36,,,28,
     ,,116,,17,13],[28,31,,66,37,,,26,,55,,,,18,19,20,,,19,20,,20,48,,48,
     36,55,,,57,38,59,53,,77,79,76,92,18,83,,15,16,13,45,21,16,15,,16,,
     20,16,101,103,,109,105,,68,64,57,50,72,,64,12,15,13,,15,12,16,15,,,
     61,,29,,,91,,13,,15,16,17],
   [30,75,,71,45,,,26,68,83,,,,13,14,15,,,14,15,,15,46,,100,44,50,44,38,
     66,38,67,46,,55,61,,55,21,,,22,23,,60,,,22,,23,,,23,73,77,71,73,75,,
     71,68,72,54,73,62,76,9,11,11,9,11,9,9,11,,,60,,26,74,,56,,,11,11,
     12,13],[,40,,59,36,,61,,52,,10,19,,18,12,23,19,14,10,,14,23,48,,
     53,36,49,43,37,55,,62,49,,,75,54,66,19,79,,17,28,15,85,19,19,16,,,
     84,19,28,86,,74,86,89,70,64,62,65,49,67,58,64,10,13,10,10,13,10,
     10,13,,36,,,30,86,,78,,16,12,,12,,16,12],
   [,45,,102,,,56,28,64,72,11,20,,13,,13,20,15,23,11,15,13,56,,63,,78,48,
     ,87,43,72,,,,61,59,,20,88,,24,18,16,,20,20,24,,17,88,20,18,87,83,
     81,85,85,81,86,,77,65,84,68,79,11,11,11,11,13,11,11,11,,38,72,62,
     30,75,,85,,17,13,,,13,17,13],[],
   [,57,,,,,,28,,,11,20,,,23,13,20,15,,13,15,11,,,82,,67,48,81,81,63,83,74,
     ,63,,59,63,20,96,,,18,16,120,20,20,24,,18,94,20,17,83,83,81,83,83,
     81,75,88,84,67,75,80,92,11,11,11,11,11,11,11,13,,36,,,28,,,118,,17,
     13,,,13,17,13,,13],
   [,,,,40,,50,,,56,,,,61,41,91,,43,,,,85,,,,,81,53,,67,,,,,,245,,212,,,,35,,,
     40,32,,,,,74,,,,285,315,267,,,,,80,82,,,86,,51,,30,,,,52,,,,,42,,,,,,,60,
     37,81,36,57,,,,82],[],
   [36,,,,53,,58,58,,62,32,48,,36,47,56,,46,,54,,52,34,,56,34,56,32,59,49,
     60,56,56,,168,168,164,168,32,,,34,,32,66,32,56,34,,82,94,58,,232,232,
     228,232,232,232,61,61,50,46,61,61,54,32,36,32,32,36,32,32,36,,64,62,
     ,,,,62,,46,48,36,,,,48,,,,50],
   [,,,,39,,48,,,52,33,37,,61,,43,37,38,40,,42,61,,,63,59,,56,,67,,,86,,
     241,171,,208,31,79,,35,49,31,44,29,44,37,,47,64,43,50,290,,281,264,
     289,217,87,103,85,,,103,85,30,37,31,29,,30,31,37,,49,,,,,,,,37,42,,,,
     37,38,42,43,,64,35],
   [64,,,,77,,75,72,,88,67,64,,58,54,92,,58,64,73,78,64,45,,68,,45,43,70,
     55,68,67,46,,281,268,254,243,49,,,54,90,,88,42,64,47,,73,130,69,70,
     352,348,333,320,350,336,71,,57,56,72,52,61,49,51,47,42,52,49,45,48,,
     ,74,47,,,,76,,59,60,,52,,75,67,64,86,,74],
   [36,36,,63,36,,63,66,63,63,31,44,,30,36,44,36,,,46,44,,34,,61,36,47,
     34,62,61,61,,47,,153,143,153,141,29,102,,30,46,29,102,27,46,29,,46,,
     44,52,207,197,207,195,207,193,61,58,61,47,61,54,61,28,29,29,27,31,
     28,29,29,,,,,44,74,,74,,36,44,34,36,46,,,,44,,58,,,34,35,47],
   [64,40,,84,52,,40,74,84,40,,,,66,45,54,43,,51,68,60,74,46,,61,43,50,,
     102,46,73,68,50,,225,,192,196,43,,,36,65,36,40,38,59,48,,60,60,55,
     61,285,303,255,258,288,288,69,57,,49,68,53,49,41,45,36,32,44,41,36,
     40,,,89,,52,91,,79,,43,60,50,45,68,,,,54,,58,40,,46,38,52],
   [,,,,41,,50,,,50,,36,,,37,,,57,53,81,,,,,,,118,55,,68,,66,81,,,341,,233,
     30,82,,31,76,30,44,32,44,50,,74,66,40,76,349,,,,,253,,119,82,80,82,,
     82,29,47,30,30,49,29,,48,,49,,,42,,,,,,,,41,,,43,55,91,,,32,,,35,,54,
     40],[,,,,74,,75,,,85,67,75,,58,52,86,59,67,,,60,71,,,,,73,52,,67,65,
     ,71,,265,266,254,243,53,,,55,93,47,85,42,91,,,89,121,62,73,341,342,
     335,321,350,335,65,56,49,,64,52,53,47,50,45,42,52,47,45,48,,,62,62,
     77,74,,,,,78,59,54,73,64,58,61,92,,84,,,45,,56,47,52],[],
   [,46,,,53,,40,85,76,46,,59,,,49,,48,66,47,75,72,,,,71,47,54,52,81,47,
     86,74,54,,233,270,222,205,,122,,40,65,40,42,42,57,47,,63,74,,67,300,
     340,290,270,299,309,70,61,49,53,70,57,,43,,40,36,44,43,40,40,,101,,
     72,60,89,,,,49,58,50,49,67,49,70,60,58,,68,74,,45,44,52,,38,,52],
   [90,197,,396,,,,,396,,39,79,,45,,67,78,,71,,59,61,168,,257,153,232,164,,
     284,241,,229,,41,41,39,43,75,660,,78,140,65,870,75,94,78,,105,522,99,
     ,285,285,281,285,285,277,278,279,274,224,278,271,278,39,45,39,39,45,
     39,39,45,,152,396,,,,,380,,78,59,45,,,79,,73,67,,61,,,168,,,153,226],
   [90,185,,307,,,280,,284,298,39,79,,45,,61,77,61,,,,81,168,,262,143,270,
     160,245,,171,,,,41,43,41,43,75,457,,78,97,65,427,75,,78,,95,,93,123,
     285,285,277,285,285,281,288,249,280,222,288,245,288,39,45,39,39,45,
     39,39,45,,,,,,283,,320,,79,55,45,,63,,,69,,,,341,,168,171,266,143,,245,
     268,,,41],[90,,,360,,,,124,,,35,,,45,54,59,,59,54,59,59,59,164,,,153,
     223,140,,263,,260,222,,41,39,35,41,65,,,76,81,57,,65,91,76,,81,,,81,
     273,273,245,269,273,245,266,263,238,216,262,235,266,35,45,35,35,45,
     35,35,45,,,360,221,,,,,,,,45,54,59,,57,54,59,,59,224,,164,281,255,153,
     197,,,,220,41,41],[],
   [,,,,51,,,31,94,62,,,,18,19,20,16,,19,20,,20,,,,44,57,,40,70,43,67,,,,89,
     ,89,,,,27,28,,56,25,,27,,28,,,28,,,115,115,116,,,73,,59,74,,80,,17,15,
     ,17,,,17,,,,47,33,68,,108,,,,18,19,20,,18,19,20,,20,39,,58,41,68,46,
     74,40,76,,52,97,93,91],
   [18,37,,64,,,56,24,,60,16,16,,18,16,,15,22,17,24,22,24,34,,47,29,42,
     34,51,,37,48,42,,78,78,76,78,16,70,,16,,16,46,16,27,18,,29,70,27,
     29,106,106,104,106,106,100,57,55,52,42,57,55,52,15,17,14,15,17,15,
     15,17,,26,64,,,,,68,,22,19,16,,,21,19,19,24,,,33,,34,,,32,40,33,49,,
     44,78,78,76,,16],[,,,,,,,60,,,,,,,,,52,54,51,122,105,,70,,85,,,64,44,
     87,44,101,42,,,461,,321,,,,,,45,,38,,46,,,,56,,541,410,,397,859,368,96,,
     90,52,94,48,98,44,68,42,40,70,44,64,68,,,68,,,,,77,,71,,,,,,56,55,127,
     ,,,,,,,106,92,,81,,151,,427],
   [36,50,,80,70,,59,35,,,17,17,,18,28,17,16,23,28,18,23,18,62,,74,46,,
     61,74,75,47,74,63,,105,95,81,153,17,115,,29,17,17,,17,28,,,19,103,
     28,19,129,,111,,158,111,86,79,84,67,,79,89,16,17,15,16,15,16,16,15,,
     57,126,,,,,102,,23,20,,,,22,20,,20,,20,,,,45,,,56,72,86,,63,,95,81,,17]
    ,[18,,,53,32,,52,20,53,59,13,,,18,19,20,19,,19,20,21,20,32,,54,29,
     40,28,,53,31,52,40,,75,75,65,75,13,,,16,17,13,47,13,26,16,,17,,24,
     17,101,101,91,101,101,91,54,51,50,40,54,47,54,13,16,13,13,16,13,13,
     16,,,48,,20,56,,52,,19,21,18,19,20,,,19,20,,20,28,,32,29,45,27,,28,
     45,,58,75,75,65,,,16,76,17],
   [,97,,62,48,,,31,60,,,,,18,19,20,20,,19,20,,20,71,,78,46,61,55,44,65,
     44,66,57,,89,101,91,,,,,27,28,28,,25,,27,,28,,,28,115,119,111,118,,
     111,76,75,74,57,77,,,14,15,15,14,15,14,14,15,,,,,33,78,,76,,,18,18,
     19,20,,,19,20,,20,48,,56,44,,,,43,72,,73,91,,91,,15,16,,17],
   [18,39,,56,37,,,20,56,52,13,13,,14,15,16,13,,15,16,27,16,32,,46,29,47,
     28,30,47,31,,45,,65,65,57,65,13,70,,16,17,13,42,13,,16,,17,70,28,
     17,87,87,79,87,87,79,49,51,50,43,49,47,54,12,13,11,12,13,12,12,13,
     ,24,58,33,20,58,,,,,16,16,17,18,,16,17,18,,18,30,,32,31,47,29,36,,,,
     40,65,65,57,,13,14,,15,13,13],
   [,,,,,,,88,,,,,,96,84,106,,,77,94,,88,,,,,126,,82,,79,,122,,,474,,506,,,,89,
     103,71,,,,70,,115,,,98,606,558,859,576,,620,127,81,110,,122,77,122,82,
     68,60,58,70,82,,66,,,80,78,,100,,,,,,,87,,99,98,85,105,,,,,94,,115,104,
     128,,,,,748,457,,,,,94,,76],
   [18,33,,54,,,46,,46,48,16,16,,18,17,24,15,22,16,,22,24,34,,46,30,40,
     34,31,47,,47,40,,78,78,76,78,16,72,,18,29,16,,16,27,16,,,72,27,29,
     106,106,104,106,106,100,53,50,52,40,53,46,52,15,17,14,15,17,15,15,
     17,,30,44,33,24,44,,52,,22,19,16,19,24,21,19,,,,24,,,34,35,47,27,38,
     51,45,,38,78,78,76,,16,16,46,,16,16,14,70],
   [36,48,,103,,,83,34,63,80,17,17,,18,,18,16,23,28,17,23,18,62,,72,46,,
     61,76,,49,78,65,,,95,81,113,17,103,,29,19,17,,17,28,29,,17,115,28,19,
     ,129,111,131,131,111,86,79,89,64,87,79,86,16,15,15,16,17,16,16,15,,
     57,78,,39,,,92,,23,20,,,20,22,20,,,,20,,,,48,92,49,71,78,109,,79,113,
     97,81,,17,,,17,17,17,15],[],[],
   [32,48,,98,86,,59,33,,64,17,17,,,28,18,16,23,,18,23,17,58,,74,52,61,
     61,74,102,49,,62,,95,155,81,,17,115,,,19,17,,17,28,29,,19,98,28,17,
     130,134,111,125,,111,87,85,89,63,84,79,90,16,15,15,16,15,16,16,17,,
     57,100,,35,,,102,,23,20,,,20,22,20,,20,,,,,,49,,,56,72,82,,58,102,,81,,
     17,,,17,17,17,15,,,17],
   [126,242,,478,286,,384,178,,,53,103,,63,86,,103,73,91,85,75,83,232,,329,
     207,300,220,407,350,,345,300,,285,285,273,285,101,613,,106,141,87,,101,
     ,106,,,601,120,127,55,55,53,57,57,53,372,369,360,294,372,353,372,53,
     63,53,53,63,53,53,63,,194,408,,,,,,,107,75,63,,,103,73,86,87,,85,398,,
     232,,,207,292,407,342,,300,285,285,273,,120,106,,,101,,87,613,106,141,,,
     128],[126,,,363,256,,,178,,355,53,102,,63,83,83,105,75,83,85,73,83,
     232,,,197,,220,,364,,345,340,,285,285,273,285,101,558,,106,129,87,410,
     101,119,106,,,572,,134,55,57,55,57,57,53,386,339,374,292,386,327,386,
     53,63,53,53,63,53,53,63,,,374,,178,390,,384,,101,73,63,83,,,,83,83,,
     83,278,,232,229,341,197,,273,350,,314,285,285,273,,119,106,410,126,101,
     ,87,558,106,,,,137,55],
   [126,237,,404,317,,364,176,404,,49,95,,63,74,81,,73,74,81,71,81,228,,
     297,207,295,196,325,344,338,336,298,,281,277,245,281,91,1060,,104,111,
     79,401,91,111,104,,111,826,111,111,55,53,49,55,53,49,360,353,324,286,
     356,317,360,49,63,49,49,63,49,49,63,,216,404,,176,396,,,,,71,63,74,
     81,95,73,74,81,,81,,,228,279,,207,254,,,,290,281,277,245,,112,104,401,
     111,91,111,79,,104,111,,,111,55,55],
   [126,207,,317,282,,298,168,316,318,53,109,,63,91,85,,73,,87,73,83,232,,
     304,195,272,216,270,330,255,320,272,,285,285,269,285,101,588,,106,129,
     87,359,101,117,106,,139,587,,127,55,57,53,57,55,53,358,333,342,268,
     358,321,358,53,63,53,53,63,53,53,63,,210,314,226,160,320,,356,,,75,
     63,86,87,103,,,,,85,,,232,264,321,195,258,267,320,,270,285,285,269,,
     115,106,381,145,101,115,87,587,106,,,,127,55,55,55],
   [126,260,,406,,,412,182,,400,53,106,,63,86,85,103,,88,93,73,83,232,,327,
     207,300,220,448,,288,340,300,,285,285,273,285,101,588,,106,129,87,565,
     101,117,106,,139,,115,,55,57,53,57,57,55,372,369,360,294,372,357,372,
     53,63,53,53,63,53,53,63,,,428,256,166,,,417,,103,73,63,,91,103,73,,87,
     ,83,352,,232,349,342,207,283,,341,,300,285,285,273,,115,106,549,162,
     101,116,87,703,106,130,,,127,55,55,55,55],
   [72,70,,,83,,81,90,83,91,56,67,,68,62,86,69,71,,88,,79,61,,52,61,52,
     50,87,62,86,53,53,,278,288,266,264,54,,,59,,49,92,50,77,59,,89,134,
     81,87,372,386,360,358,372,372,57,57,60,59,59,55,64,52,60,50,48,58,
     52,50,56,,105,89,,,,,89,,67,80,61,,,65,74,62,,,86,89,,52,,,61,66,116,
     72,,72,278,288,266,,79,52,,,54,77,54,134,52,109,,,87,372,386,360,358,
     372],[72,60,,59,66,,59,102,55,55,57,71,,54,62,70,64,66,69,82,76,,
     61,,57,58,61,57,103,57,105,56,61,,279,249,263,243,51,94,,50,79,51,
     94,45,75,55,,79,81,73,85,369,339,353,333,369,331,57,64,57,59,59,60,
     59,48,51,51,45,57,48,51,51,,,112,,76,100,,104,,64,76,66,62,82,,,,72,,
     94,,,61,60,71,49,,77,72,,60,279,249,263,,75,56,111,,45,,51,156,49,82,,
     ,101,369,339,353,333,369,57],
   [58,,,,82,,75,,81,91,52,68,,68,65,77,70,72,63,73,80,80,52,,,61,70,51,,
     72,83,64,72,,274,280,238,260,46,,,57,87,50,92,46,89,53,,82,139,,83,
     360,374,324,342,360,336,50,55,51,50,48,51,55,48,60,46,44,58,48,46,
     56,,117,81,78,88,89,,,,,71,61,62,84,72,69,63,80,,73,,,61,83,71,61,60,
     ,,,72,274,280,238,,,57,92,82,50,89,45,,53,87,,,88,360,374,324,342,
     360,57,57],[58,51,,46,48,,51,75,46,55,52,56,,49,49,,51,59,49,71,
     60,63,52,,45,47,53,42,80,57,,45,53,,224,222,216,198,44,,,40,64,40,
     52,40,57,45,,67,83,59,61,294,292,286,268,294,286,50,59,55,52,50,55,
     59,41,42,40,36,44,41,40,40,,95,83,71,60,85,,85,,51,60,50,49,71,56,
     59,,,,64,,,52,53,65,49,58,,65,,58,224,222,216,,61,44,92,67,44,,40,,38,
     ,,,65,294,292,286,268,294,50,47,50],
   [72,68,,,84,,83,90,81,89,56,72,,68,69,84,65,73,67,94,,79,61,,52,61,53,
     50,83,63,86,53,52,,278,288,262,264,54,,,59,86,49,94,50,,59,,88,125,
     78,86,372,386,356,358,372,372,57,59,60,59,59,57,64,52,60,50,48,58,
     52,50,56,,99,89,72,77,81,,89,,68,78,61,62,,64,74,62,81,,86,82,,52,,
     64,61,68,,72,,70,278,288,262,,78,52,84,88,54,78,54,130,52,88,,,84,
     372,386,356,358,372,50,57,57,50],
   [72,,,59,68,,47,88,51,59,53,,,54,58,68,61,62,63,80,76,68,61,,,54,57,
     51,123,53,103,52,57,,271,245,235,235,47,91,,46,79,47,48,41,73,55,,
     79,91,73,79,353,327,317,321,357,299,57,60,51,55,55,56,57,44,51,47,
     41,57,44,47,51,,87,100,93,68,106,,108,,63,74,66,58,80,67,62,63,68,,
     80,54,,61,54,73,49,50,54,77,,,271,245,235,,75,52,112,83,41,75,47,
     176,49,83,,,83,353,327,317,321,357,57,47,51,47,57],
   [18,33,,48,37,,54,30,54,,9,15,,9,15,,15,11,15,11,11,11,36,,49,30,42,
     36,54,52,,49,42,,45,45,45,45,16,76,,16,,14,76,16,16,16,,16,76,16,
     16,63,63,63,63,63,63,57,54,57,42,57,54,57,9,9,9,9,9,9,9,9,,30,54,
     ,,,,54,,15,11,9,,,15,11,15,11,,11,54,,36,,,30,42,,52,,42,45,45,45,,
     16,16,,,16,16,14,78,16,16,,,16,63,63,63,63,63,57,54,57,42,57,54],
   [18,30,,48,35,,,20,48,54,7,14,,9,10,11,,9,10,11,9,11,32,,46,28,43,28,
     ,50,30,47,46,,39,39,35,39,13,,,14,15,11,74,13,13,14,,15,,13,15,53,
     53,49,53,53,49,52,48,48,41,52,44,52,7,9,7,7,9,7,7,9,,,48,,20,54,,,
     ,12,9,9,10,11,,,10,11,,11,,,32,30,,28,,29,47,,43,39,39,35,,14,15,
     43,16,13,,12,69,15,16,,,16,53,53,49,53,53,52,48,48,41,52,44,9],
   [18,30,,48,34,,,20,48,54,7,,,9,10,11,12,,10,11,9,11,32,,43,28,45,28,
     29,49,30,49,43,,39,39,35,39,13,69,,15,16,12,43,13,,15,,16,69,14,16,
     53,53,49,53,53,49,52,48,48,41,52,44,52,7,9,7,7,9,7,7,9,,24,48,
     31,20,54,,,,,9,9,10,11,14,9,10,11,,11,29,,32,30,47,28,,,,,46,39,39,
     35,,13,14,74,15,13,13,11,,14,15,,,15,53,53,49,53,53,52,48,48,41,52,
     44,9,7],[18,33,,54,,,54,,48,48,9,15,,9,,11,15,11,15,,11,11,36,,50,
     30,42,36,,51,,,42,,45,45,45,45,16,78,,16,16,14,,16,16,16,,,78,16,16,
     63,63,63,63,63,63,57,54,57,42,57,54,57,9,9,9,9,9,9,9,9,,32,48,
     37,30,48,,56,,15,11,9,15,11,15,11,,,,11,,,36,,52,30,42,54,,,42,45,
     45,45,,16,16,76,16,16,16,14,76,16,,,,16,63,63,63,63,63,57,54,57,42,
     57,54,9,9,9]],
 [,[],[],[],[,27,,38],[,,16],[,32,,31],[,,16,,,18],
   [,,,34,35,,31],[,,,31,,,28,,37],[18,,,,49,,,20],[,28,,,,,,23,51],
   [,,12,,29,,,14],[18,27,12,36,27,18,24,18,36,36,9,12,5],
   [,31,,,41,,28,16,58,,10,13,6],[38,33,,42,21,26,30,20,40,54,11,14,7],
   [24,,28,70,55,,,26,,70,,10,,12,13,14],
   [18,27,14,32,19,18,24,14,30,32,,,5,5,6,7],
   [24,26,13,38,33,19,24,,,31,10,13,6,,6,,13,6],
   [,45,24,,27,,,18,,,11,14,7,,,7,14,7],
   [,,12,,29,,,14,,,,,5,5,6,7,,5,6,7],
   [38,33,,44,21,26,32,20,44,44,11,14,7,,,7,14,7,,7,7],
   [28,,,,47,42,48,,,,32,,,28,,40,41,28,35,,,40],
   [,,,,,32,,32,,,,,,23,24,31,,,25,33,,33],
   [,35,,,46,,45,,50,,,45,,37,42,45,,41,37,61,,51],
   [36,43,30,50,43,32,42,32,50,50,31,35,26,19,,,,23,23,31,26,,32,29,39],
   [70,71,,78,71,46,62,46,78,78,62,55,34,,27,,75,30,29,46,34,46,40,46,47 
    ],[36,43,,56,,,,36,56,,28,39,20,20,23,28,39,20,23,28,20,28,26,,38,
     26,35],[,,26,,,,,28,,,,,,23,,33,,23,25,,,33,,27,,25,33],
   [70,46,,55,35,,,,49,50,64,,40,37,58,37,61,33,48,39,40,39,43,,42,33,47]
    ,[,,26,,,28,,,,,33,37,22,23,20,27,37,19,,,22,27,,27,,25,33,,23],
   [,43,,44,40,60,,,,51,66,52,35,29,,45,64,29,29,,35,51,,,33,33,44,35,,36 
    ],[,67,200,74,61,50,63,50,67,74,,53,35,104,40,,52,28,31,36,35,33,
     43,46,50,,35,38,36,44,36,46],
   [,40,,,43,,40,64,55,,,51,,37,42,49,,41,37,47,,49,,,36,39,47,,,39,,36,50 
    ],[78,,,,,106,224,104,,,39,,,33,49,,68,31,55,47,,47,140,,,127,198,124,
     189,,222,230,205],
   [86,109,88,162,109,86,144,90,158,160,39,,35,33,,,69,,62,47,35,43,140,
     127,191,107,,128,117,185,119,177,,191,37],
   [86,150,,342,,,,94,342,290,35,50,25,25,30,35,50,25,30,35,25,35,132,,
     200,117,178,100,,,195,190,186,206,31,31],
   [82,111,84,156,115,92,134,88,158,156,39,68,33,33,,51,,,55,47,33,,140,
     129,181,115,,124,117,185,121,173,,187,31,37,31],
   [14,,,,29,18,42,18,46,,13,,,14,15,16,16,13,15,16,,16,26,,,26,48,26,28,
     44,28,41,,,65,65,59,65],
   [,,,,36,,33,,34,,,,,32,33,42,,32,,,,44,,,,54,72,52,,54,,46,74,,,168,,158],
   [,,,,23,16,30,16,34,,,,,7,8,9,,7,8,9,,9,,22,,,31,23,20,38,20,34,33,,,,
     30,49],[18,23,12,30,23,14,22,14,30,30,16,19,9,7,,,19,8,8,15,9,,
     26,23,33,19,,20,19,33,19,27,104,33,55,57,35,55,14,30,7],
   [36,51,,74,25,22,36,24,,74,17,20,10,,,,20,9,,9,10,9,47,49,57,,,31,29,
     41,29,56,42,59,85,,40,63,15,,8],
   [18,29,12,50,,,,14,34,50,13,16,8,7,8,9,16,7,8,9,8,9,26,24,36,22,28,
     20,,,20,28,30,41,47,48,30,47,13,,6,7,8],
   [,,,33,,,,,37,32,,,,32,33,42,91,32,33,,,44,54,,,54,72,,,,,51,66,46,322,
     166,,162,,35,,30],[14,19,20,26,23,18,26,18,30,26,13,16,15,14,15,16,
     ,,15,16,15,16,26,23,33,23,45,26,25,37,25,33,45,33,65,65,59,65,11,
     28,,14,15,13,34],[,,24,,23,16,28,16,32,,,,8,7,8,9,,,8,9,8,9,40,,
     48,23,35,23,21,35,21,31,35,48,46,47,30,,,,6,7,8,6],
   [14,33,12,46,25,14,26,,,46,16,19,9,7,8,15,19,8,,,9,15,24,24,45,22,
     28,20,20,34,,,30,34,55,61,35,59,14,,7,7,,7,,14,7],
   [,,,32,36,,33,,,33,,,,32,33,42,,32,,,,44,,,46,50,72,52,,54,,,74,,,166,
     324,166,,32,,30,,,35,34],
   [32,51,,74,25,22,36,,,70,17,20,10,,,9,20,9,,,10,9,47,32,66,,,31,28,42,
     26,,35,66,78,65,40,78,15,,8,,8,8,,15,8],
   [,,,,,,30,,37,,,,,32,33,42,,32,31,,,44,,,,54,72,,,50,,51,74,,,168,244,160,
     ,29,,30,,,32,28,,,35],
   [,,,,23,16,30,16,34,,,,,7,8,9,,7,8,9,,9,,22,,,31,23,20,38,20,34,33,,,,
     30,49,,,6,7,8,6,,,6,7,,8],
   [36,47,,70,25,22,36,24,,74,17,20,10,,,9,20,9,,9,10,,47,49,59,,,31,29,
     41,29,56,42,57,62,61,40,64,15,,8,,8,8,,15,8,,,8,,8],
   [106,,,,203,124,,,303,,53,,,43,61,57,87,41,,59,,,188,,,165,250,164,256,
     280,229,253,260,,227,227,203,223,87,,,69,,59,306,87,58,69,320,78],
   [114,151,112,210,153,118,188,116,214,216,53,87,,43,,,90,41,63,57,,61,
     188,169,251,145,,164,155,253,153,231,272,247,227,227,203,227,87,218,
     61,71,,58,218,87,,67,216,77,220,61,77,47],
   [114,,108,314,,,,,368,368,49,70,35,35,42,49,70,35,42,49,35,49,180,,,155,
     230,140,,,196,239,242,270,211,215,175,211,81,296,42,49,56,42,,81,42,
     49,296,56,364,42,56,41,41],
   [114,153,112,208,149,116,182,114,210,204,53,89,45,43,59,,,,59,57,45,57,
     192,173,247,153,224,172,153,249,157,221,237,249,223,227,207,227,87,
     212,62,71,77,60,212,87,,71,212,81,214,62,,41,47,41],
   [106,206,128,,206,128,282,,,383,53,88,43,39,63,57,,43,,,43,57,184,341,
     290,163,258,164,,290,,,261,282,231,227,203,231,87,310,63,67,77,58,459,
     87,57,71,,,374,63,92,47,41,41,47],
   [98,137,116,192,137,110,160,106,192,192,49,70,35,35,42,49,70,35,42,49,
     35,49,176,159,231,149,,140,141,231,143,195,,231,215,211,175,215,77,
     196,42,49,56,42,196,77,42,49,198,56,198,42,56,41,41,35,41,41],
   [50,,,,68,68,64,60,70,,56,,,46,43,56,62,42,45,,,60,42,,,53,55,43,67,62,
     ,47,63,,232,238,206,222,44,,,42,55,42,71,44,55,42,66,66,,,66,308,
     314,282,302,308,286],
   [64,75,58,82,75,52,66,52,82,82,57,63,42,33,,,,33,35,49,42,51,53,48,
     60,33,,43,40,54,40,50,45,60,217,169,195,169,46,86,,33,,34,84,37,35,
     34,82,60,86,,62,275,227,253,227,277,215,49],
   [64,64,,75,,,,62,71,64,52,59,36,38,38,48,59,36,38,50,36,48,47,,57,47,
     50,34,,,61,46,57,51,216,226,178,210,46,71,40,36,49,34,,44,38,36,69,
     49,64,40,50,284,290,246,282,284,250,43,43],
   [58,63,56,70,63,46,59,46,70,70,52,51,37,32,33,40,,,31,42,37,46,50,45,
     57,41,50,42,39,57,39,49,,57,182,160,172,150,42,68,35,32,,30,70,34,,
     30,70,41,68,35,54,238,212,224,202,242,196,40,37,40],
   [58,,62,70,62,,66,,,77,56,62,,46,45,56,,42,,,,58,50,,57,47,55,43,61,56,,
     ,57,62,236,242,214,230,48,68,44,42,55,42,73,48,42,38,,,73,44,65,
     308,310,286,302,308,286,46,43,43,46],
   [56,67,42,74,67,44,58,44,74,74,53,59,34,25,30,35,54,25,29,41,34,35,
     47,42,54,41,37,37,34,54,34,44,,54,205,153,167,157,42,82,32,25,40,
     28,82,33,30,28,82,40,82,32,40,255,203,217,203,257,175,43,31,37,31,
     43],[56,,,,,62,57,,77,,56,,,46,,58,62,42,45,58,,60,47,,,53,55,42,,
     57,61,52,63,,228,234,206,226,46,,,42,55,40,66,44,55,44,71,55,,,66,
     308,318,282,306,312,286,43,49,40,40,49,43],
   [18,,,,31,18,50,20,,,7,,,9,10,11,12,9,10,11,,11,32,,,28,46,28,,47,30,
     50,43,,39,39,35,39,13,,,15,16,12,82,13,14,15,44,16,,,16,53,53,49,
     53,53,49,52,48,48,41,52,44,52],
   [18,27,24,40,27,26,40,26,40,40,9,12,13,9,,,12,11,14,11,13,11,36,33,
     49,27,,36,35,49,35,49,50,49,45,45,45,45,16,48,17,15,,13,48,16,15,
     15,48,15,48,17,15,63,63,63,63,63,63,62,45,62,40,62,45,62,9],
   [18,27,22,44,,,,20,42,46,7,10,11,9,10,11,10,9,10,11,11,11,32,27,41,
     27,42,28,,,29,44,40,41,39,39,35,39,13,62,14,13,14,10,,13,12,13,,14,
     62,14,14,53,53,49,53,53,49,52,45,48,38,52,41,52,7,9],
   [18,21,24,34,25,18,30,20,34,34,7,14,11,9,10,11,,,10,11,11,11,32,25,
     37,25,40,28,27,41,27,41,36,37,39,39,35,39,13,36,15,14,15,11,36,13,
     ,14,34,15,36,15,15,53,53,49,53,53,49,50,39,46,34,50,35,50,7,9,7],
   [18,32,24,48,31,,50,,,,9,12,13,9,14,11,12,11,,,13,11,36,35,51,29,46,
     36,48,50,,,44,50,45,45,45,45,16,70,17,15,15,13,68,16,15,15,,,70,17,
     15,63,63,63,63,63,63,60,51,60,42,60,51,60,9,9,9,9],
   [18,21,22,36,25,22,32,20,36,36,7,10,11,9,10,11,10,9,10,11,11,11,32,
     25,39,25,42,28,29,43,27,43,,39,39,39,35,39,13,36,14,13,14,10,40,
     13,12,13,40,14,36,14,14,53,53,49,53,53,49,54,39,50,36,54,35,54,7,
     9,7,7,9],[18,,,,31,18,50,20,,,7,,,9,10,11,12,9,10,11,,11,32,,,28,
     46,28,,47,30,50,43,,39,39,35,39,13,,,15,16,12,82,13,14,15,44,16,,,
     16,53,53,49,53,53,49,52,48,48,41,52,44,52,7,9,7,7,9,7],
   [18,27,24,38,27,26,38,26,38,38,9,12,13,9,14,11,12,11,14,11,13,,36,
     33,47,27,42,36,35,47,35,47,42,47,45,45,45,45,16,46,17,15,15,13,46,
     16,15,15,46,15,46,17,,63,63,63,63,63,63,58,45,58,38,58,45,58,9,9,
     9,9,9,9,9],[,,,,,,,,,,,,,27,26,33,30,,31,45,,33,,,,27,35,,,,,,38,,,
     115,,115,,,,21,39,29,,21,32,25,,30,,,37,,153,184,153,,137,,46,60,43,,
     40,,,27,26,21,32,21,,27],
   [,,,,,,,,,,,,,18,19,26,,18,,,,26,,,,40,62,36,,60,,,66,,,92,86,88,,,,18,,,,
     16,,,,,,,,,116,114,116,,106,,68,62,56,62,64,,,26,22,20,28,18,,26],
   [,,,,,,,,,,,,,36,,42,47,28,58,,,50,,,,41,43,,,,,,51,,,162,338,156,,,,30,37,
     34,,32,39,46,,45,,,46,,214,,208,313,192,,37,,28,,31,,,40,42,34,,36,,38 
    ],[,,,,,,,,,,49,55,29,27,33,21,,19,41,29,29,21,44,29,71,27,44,43,27,
     ,23,73,43,71,199,115,188,111,31,,21,21,22,,,25,20,33,,23,,21,22,237,
     153,201,149,240,137,63,46,62,32,68,40,,35,27,31,25,35,25,35,27,27],
   [,,,,,,,,,,20,26,14,18,,20,23,14,16,22,14,18,42,,60,36,62,,,,,54,,,98,
     90,94,92,16,42,15,18,21,14,42,16,15,14,42,21,42,15,19,124,114,114,
     120,,110,68,64,,58,66,64,62,20,26,20,20,28,20,20,26,,18],
   [,,,,,,,,,,,72,,36,31,44,,30,,,,42,58,46,85,41,35,56,,82,38,88,32,,253,
     162,,158,52,,29,30,,50,,36,30,,,37,,29,,307,214,366,204,,192,77,37,75,
     33,,29,77,,40,46,34,,36,,38,35,,37],
   [,,,,,,,,,,,28,12,12,13,,,14,,24,12,,,,,32,204,,,,,,56,,,88,,84,14,44,13,
     12,23,12,44,16,15,12,44,23,44,13,23,,112,108,112,128,116,62,56,,52,,
     64,,,24,22,24,24,22,,24,,16,,,16],
   [,,,,,,,,,,,,,24,27,32,,22,28,42,,30,,,,35,,,,,,,45,,317,140,,134,53,,31,
     24,32,,,32,23,26,,34,,31,31,367,184,,178,361,160,57,29,51,28,57,25,
     57,,40,,30,50,32,,38,,,28,32,,31],
   [,,,,,,,,,,,,,36,35,44,51,30,58,,,42,,46,82,35,30,56,38,85,,88,38,82,
     353,160,290,156,,,44,30,45,34,,32,,46,,46,,44,45,305,216,,204,327,192,
     73,33,71,33,77,31,,48,40,42,34,46,36,48,38,38,,31,,,34,,31],
   [,,,,35,24,48,24,52,,,,,11,12,13,,,12,13,,13,,,,,51,35,28,56,28,52,48,,,
     58,44,59,,,,11,12,10,,,,11,,12,,,12,,74,60,74,,56,,,57,43,62,52,,,13,
     10,12,13,10,,13,24,,,31,19,42,19,51,43],
   [,,,,47,26,107,26,,,,,,13,14,15,,,14,15,,15,,,,49,74,40,,71,41,83,68,,,,
     49,57,,,,22,23,21,137,21,,22,72,23,,,23,,79,67,73,73,67,,79,70,66,,
     67,,,13,11,,13,11,,13,,22,,55,26],
   [18,49,,,,20,,,,,9,15,7,9,15,7,15,7,15,7,7,7,32,,64,31,62,28,33,,,67,
     80,67,39,39,35,39,16,54,8,16,8,8,54,16,8,16,54,8,54,8,8,53,53,
     49,53,53,49,56,57,52,52,56,53,56,9,9,9,9,9,9,9,9,49,20,,,,,,,,10,
     11],[24,35,,52,,24,48,24,,52,10,16,8,11,10,11,16,8,8,11,8,11,39,
     42,51,,63,35,31,54,31,47,,51,61,58,44,61,17,39,9,11,12,9,39,17,9,
     9,39,12,39,9,12,77,74,60,76,74,56,62,65,58,,65,52,62,10,13,10,10,
     13,10,10,13,31,19,42,24,,,19,37,48,11,12],
   [,47,,,,26,,26,,,11,17,9,13,21,11,17,9,21,9,9,9,,,71,43,74,40,41,,,79,
     ,79,61,,49,,18,64,10,22,12,10,64,18,10,22,64,10,64,10,10,77,73,67,
     77,,67,,73,66,70,80,67,,11,13,11,11,11,11,11,11,55,26,,,22,,,107,,
     12,13],[24,24,19,48,31,,37,19,,42,,,,11,12,13,,,12,13,,13,39,33,43,
     27,43,35,,49,27,43,41,53,65,57,44,61,16,45,8,9,10,10,41,16,8,9,
     45,10,42,8,10,75,73,60,,73,56,62,43,57,39,,39,62,14,13,10,,13,10,
     14,13,,24,52,35,24,,,48,52,10,,10,11,12],
   [30,,42,52,35,24,46,26,54,58,,,,13,14,15,,,14,15,,15,46,,,,59,40,39,59,
     35,59,55,67,55,61,49,61,21,50,,22,23,21,46,,,22,48,23,50,,23,73,79,
     67,77,79,67,74,,68,56,80,49,80,9,11,11,9,11,9,9,11,,26,52,35,26,
     54,42,40,60,,11,11,12,13],
   [,31,19,43,24,19,51,,42,,10,16,8,11,8,11,16,8,10,11,8,11,42,33,49,
     27,43,35,27,43,,46,41,47,61,,44,59,17,41,9,9,12,9,45,17,9,11,42,
     12,45,9,12,79,,60,73,73,56,61,43,58,39,62,39,,10,13,10,10,13,10,
     10,13,35,24,,,24,52,,48,,11,12,,10,,11,12],
   [30,35,42,60,,26,40,26,54,52,11,17,9,13,21,9,17,9,21,11,9,9,46,45,
     57,,78,40,35,,35,57,,57,55,,49,61,18,48,10,22,10,10,48,18,10,22,48,
     12,48,10,10,73,77,67,77,,67,74,,68,,78,49,80,11,11,11,11,13,11,11,
     11,35,26,58,,24,54,42,46,52,12,13,,,11,12,13],
   [,,,,55,22,107,26,,,,,,13,14,15,,,14,15,,15,,,,43,74,40,44,79,41,79,68,,
     63,55,49,,,137,,22,23,21,72,27,,22,,23,137,,23,77,73,67,77,79,67,80,
     73,66,70,,67,,9,11,9,9,11,11,9,11,,26,,47,26,,,,,,11,11,12,13,,11,
     12,13],[,55,,,,26,,22,,,11,17,9,13,21,9,17,9,21,9,9,11,,,79,49,
     74,40,41,,57,83,97,71,61,59,49,57,18,64,10,22,10,10,64,18,10,22,
     64,10,64,10,12,,77,67,73,73,67,76,79,70,66,72,67,,11,11,11,11,11,
     11,11,13,47,26,,,26,,,107,,12,13,,,11,12,13,,11,13],
   [,,,,27,,34,,,,,,,23,25,33,,23,,,,33,,,,47,65,42,,46,,43,67,,,117,195,115,,
     ,,23,,,36,21,,,,,,,,,157,235,153,205,141,,79,62,61,67,75,,,35,,27,48,
     29,,35,,,,,28,,26,,,,,33,27,41,28,39,31,35,44,41],
   [,,,,71,,71,,,,,,,37,37,51,47,35,42,61,,47,,,,46,48,44,45,65,,,56,,,189,,
     185,,,,35,45,36,,37,47,37,,47,,,56,,251,260,247,285,231,,42,44,33,,36,,
     ,49,41,37,50,39,,47,35,,,46,64,50,,40,55,43,,67,50,72,,,51,59,,73],
   [36,,,,,,48,42,,58,32,41,,28,41,40,,26,,36,,40,32,49,51,32,51,24,,37,
     45,50,50,37,140,140,132,140,30,,27,26,,28,54,30,27,24,,46,54,27,,
     188,188,180,192,184,176,53,53,42,37,47,47,46,32,36,32,32,36,32,32,
     36,,42,58,,,,,48,,39,,32,,,,48,39,48],
   [,,,,,,34,,,38,33,36,22,23,,27,37,19,20,,22,27,,,49,43,65,42,,,,,71,46,
     174,115,,121,24,35,21,23,29,20,32,21,21,20,35,27,32,21,29,208,157,
     196,159,209,143,67,75,61,63,,75,65,30,35,29,27,,27,30,35,,28,,,,,26,,
     ,27,41,,,,28,35,31,35,41,71,23],
   [70,,,,,,71,,,82,67,63,40,37,35,39,,31,58,39,40,37,40,50,65,46,40,35,
     46,46,42,63,37,46,233,189,206,181,48,,35,35,39,,74,41,33,34,,39,74,
     35,39,295,251,266,243,297,231,57,42,43,38,62,34,47,50,49,44,41,51,
     43,50,47,46,64,,35,,,,45,44,50,72,,43,,56,57,54,,73,,,42],
   [36,27,32,35,27,36,35,40,41,41,31,,26,19,23,37,35,,,31,26,,26,51,46,
     28,35,26,47,46,43,40,37,40,127,107,117,115,24,39,21,19,27,22,39,21,
     21,22,39,27,39,21,27,165,145,155,153,163,149,47,38,47,35,53,34,53,
     28,27,27,25,29,25,28,27,43,32,50,43,32,50,30,42,50,27,49,31,27,43,,
     ,,,43,49,25,39,32,25,33],
   [70,32,56,51,47,78,32,62,45,32,,,47,104,37,48,55,,45,46,47,112,43,89,
     50,37,44,44,67,43,67,51,46,37,204,,186,198,38,49,32,28,39,36,36,30,
     31,30,49,39,32,32,39,259,269,242,,262,257,63,47,44,44,57,43,44,39,
     46,37,32,44,,39,40,60,50,74,67,50,67,200,63,74,41,82,62,41,68,33,,
     71,52,97,70,36,44,37,36,50],
   [,,,,23,,,,,34,,38,,17,19,,,19,18,33,,31,,,,39,109,,,40,,35,59,40,,117,,
     117,22,33,19,17,31,18,30,21,21,18,33,31,30,19,31,257,149,,151,,139,,
     67,62,57,,75,59,,33,31,31,35,29,,33,,26,,,26,,,,,27,,,27,,,51,51,51,,,
     21,,,21,,29,40],[,,,,69,54,,,,82,67,65,33,29,29,51,55,27,,,33,49,,,,
     40,43,,,61,43,,51,61,198,169,,163,47,,30,29,55,28,73,37,29,,,45,73,
     30,45,254,223,238,221,285,195,47,34,37,33,47,30,41,47,49,44,41,50,
     43,47,47,43,,44,40,59,49,,,51,43,83,64,45,76,52,57,47,59,76,83,,33,
     37,,36,33,45],[,,,,71,,71,60,,85,,,,37,40,49,45,39,42,47,,45,43,50,
     ,40,35,35,42,46,46,63,43,46,222,189,,181,,,53,35,45,41,76,37,,34,,
     58,,53,47,277,251,270,243,293,231,62,38,43,38,,36,47,,49,41,37,50,39,
     ,47,40,,55,43,,44,,45,,49,,66,47,73,,61,51,55,,71,,36,,,39,39,44,,36 
    ],[],[78,166,,252,,,,,249,355,39,71,33,33,,43,75,,47,,33,47,140,280,
     216,127,194,124,,231,174,,203,,37,37,29,33,65,344,51,55,80,47,514,65,
     47,55,,62,309,51,,227,227,211,223,231,215,232,217,216,182,236,205,228,
     39,45,39,39,45,39,39,45,199,,253,,,,,224,,61,,39,,,59,,62,55,,59,170,
     234,140,,,127,202,177],
   [86,115,88,158,113,88,144,90,162,164,39,,,33,51,45,70,33,43,,,47,140,
     127,191,107,246,128,117,189,115,169,,189,31,33,31,33,65,166,51,57,63,
     48,168,65,,61,166,61,170,51,61,227,227,215,227,227,211,238,169,226,
     160,242,153,234,39,45,39,39,45,39,39,45,113,90,164,115,88,162,88,
     144,158,,59,39,,57,,,,,57,59,121,189,140,115,191,107,,115,177,185,,37],
   [86,188,,290,,94,,86,,338,35,50,25,25,30,35,50,25,30,35,25,35,132,,229,
     117,178,100,195,212,,,186,,31,29,25,31,59,,30,35,40,30,324,59,30,35,
     244,40,324,30,40,203,203,175,207,203,175,206,195,178,172,214,167,206,
     35,45,35,35,45,35,35,45,,94,290,150,,342,,,342,44,49,35,44,49,44,49,
     44,49,49,49,160,213,132,195,200,117,186,,,207,,31,31],
   [,,,,,40,,40,,,,,,26,27,42,47,26,27,44,,,,,,43,39,,33,,33,,53,,,156,,158,,,
     ,26,41,26,,38,30,26,,43,,,,,212,319,208,308,192,,39,,36,,27,,,46,42,
     40,48,40,,44,,,,32,,33,,28,33,,,,62,,39,64,39,66,,,,,48,,48,46,66,,42,
     48,,256,156,403],[,,,,47,29,58,29,67,,,,,16,17,18,14,,17,18,,18,,,,
     49,67,51,44,67,45,66,65,,,,64,89,,,,25,26,24,60,22,,25,63,26,,,26,,,
     88,112,112,88,,81,78,63,78,73,,,16,14,,16,14,,16,,,,61,32,86,38,,,,,
     17,18,19,,17,18,19,17,19,38,,55,44,75,,93,50,79,,,95,98,64],
   [18,29,,46,,18,42,18,,46,16,13,12,14,13,14,13,12,11,14,12,14,30,,44,
     26,48,26,28,,28,40,62,45,65,65,59,65,14,36,13,14,15,12,36,14,13,
     12,36,15,36,13,15,87,87,81,87,87,77,50,46,44,42,46,42,48,14,16,13,
     14,16,13,14,16,31,16,52,,,,14,53,52,17,18,13,,,17,18,16,21,18,,24,
     48,26,,,24,38,22,45,49,,65,65,59,,15],
   [,,,,,46,,46,,,,,71,32,31,36,52,28,31,38,71,34,58,46,94,43,46,,34,94,
     34,,34,94,,176,,170,,,33,32,37,30,,38,,30,,35,,33,37,506,232,,226,544,
     214,92,39,,35,92,31,92,81,46,42,40,48,40,81,44,38,,39,,,,,,36,53,,,,,
     45,58,45,62,,,,58,,,,58,96,,57,54,,,178,,39],
   [36,46,,67,,29,,,,66,17,14,13,16,24,14,14,13,24,12,13,12,55,,65,45,67,
     51,45,,44,66,74,,99,88,64,,15,58,14,25,15,13,55,15,14,25,58,13,58,
     14,13,117,,88,,118,88,80,77,74,65,,73,80,15,16,14,15,14,14,15,14,
     61,32,80,,,,38,84,86,18,19,,,,18,19,,17,19,17,44,73,,38,,,59,50,79,
     75,,,89,64,,16],[18,21,16,38,25,16,34,16,34,38,13,,15,14,15,16,16,
     ,15,16,15,16,30,27,39,21,28,26,27,43,21,39,30,39,65,65,59,65,13,
     38,12,12,13,13,38,13,12,12,38,13,38,12,13,87,87,81,87,87,77,50,31,
     46,28,46,27,50,13,16,13,13,16,13,13,16,19,18,30,23,18,26,20,26,30,
     16,27,16,17,18,,,17,18,21,18,25,33,26,25,37,23,,27,33,33,,65,65,59,
     28,,14,34,15],[,,,65,46,,59,29,62,,,,,16,17,18,18,,17,18,,18,73,,
     71,49,67,51,45,65,45,69,61,,89,96,64,,,59,,25,26,24,,26,,25,,26,63,,
     26,112,120,88,120,,88,80,79,75,65,82,73,,13,14,14,13,14,12,13,14,,
     32,,55,32,86,38,,,,17,17,18,19,,,18,19,17,19,,,53,45,74,,,51,77,96,,
     91,,64,,14,15,,16],
   [14,25,,45,25,14,,14,45,45,13,10,9,8,9,10,10,9,9,10,9,10,24,,41,22,,
     20,22,41,22,,39,41,50,50,40,50,11,36,10,10,11,9,36,11,10,10,36,11,
     36,10,11,66,66,56,66,66,56,40,38,36,36,40,34,40,11,12,10,11,12,10,
     11,12,25,14,45,25,14,45,,,45,14,15,13,14,15,14,15,14,15,15,15,22,
     41,24,22,41,22,39,,,41,,50,50,40,,12,11,,12,11,12],
   [,,,,,46,,46,,,,,,32,33,42,,30,33,44,,42,,,,43,52,,39,,39,,56,,,176,,170,,,
     ,32,58,32,,34,31,32,,43,,,41,372,232,723,226,,216,86,35,84,36,86,31,
     86,,46,38,34,48,36,,44,,,36,38,,39,,,39,,,,51,,45,,45,60,,,,54,58,,58,
     58,96,,,58,,478,176,,36,,,33,,34],
   [14,25,16,32,21,16,32,16,36,32,16,13,12,14,11,14,13,12,13,14,12,14,
     26,27,41,21,28,26,21,37,27,37,30,41,65,65,59,65,14,36,13,12,15,12,
     36,14,13,14,36,15,36,13,15,87,87,81,87,87,77,44,31,44,28,48,27,44,
     14,16,13,14,16,13,14,16,23,18,26,19,18,30,20,26,26,17,18,13,16,27,
     17,18,,,18,21,25,37,30,25,33,23,,27,33,37,,65,65,59,28,15,13,34,,
     14,15,11,34],[32,47,,66,,29,,29,,63,17,14,13,16,24,12,14,13,24,14,
     13,12,53,,67,49,67,51,45,,47,64,65,65,,,64,96,15,58,14,25,13,13,58,
     15,14,25,55,15,58,14,13,113,121,88,120,121,88,80,79,78,65,,73,80,
     15,14,14,15,16,14,15,14,55,32,86,,,,38,84,80,18,19,,,17,18,19,,,19,
     17,45,74,73,47,,,64,51,77,,,88,96,64,,16,,,14,15,16,12],
   [,,,,,40,,40,,,,,,26,,42,50,26,27,44,,40,48,46,68,43,28,,30,68,30,82,
     46,68,,154,,160,,,30,26,43,26,,38,45,26,,,,30,43,,212,,208,400,194,67,
     31,,31,67,27,67,,46,42,40,48,40,,44,32,,33,,,30,,,,57,,,,,39,64,39,66,
     ,,,48,,,44,46,66,,49,,,,156,403,27,,,36,,28,,,39,28],
   [,,,,,25,55,29,67,72,,,,16,17,18,18,,17,18,,18,,,66,45,67,51,47,,45,66,
     65,,101,,64,98,,79,,25,26,24,59,26,,25,,26,,,26,117,113,88,,121,88,
     104,77,74,65,82,73,99,13,14,12,13,14,14,13,14,,,,55,32,80,38,,,,17,
     17,18,19,,17,18,19,,19,46,,55,44,75,49,,50,79,,,,90,64,,14,15,,16,,
     14,12,,15,16],[36,,,63,,29,,25,,63,17,14,13,16,24,12,14,13,24,12,
     13,14,55,,,49,67,51,45,,,66,78,64,96,96,64,,15,58,14,25,13,13,58,
     15,14,25,58,13,55,14,15,,118,88,112,,88,82,81,78,63,80,73,80,15,14,
     14,15,14,14,15,16,55,32,86,,32,,38,84,86,18,19,,,17,18,19,,17,19,,
     44,75,,46,,,58,50,79,75,,98,,64,,16,,,14,15,16,12,,,14,,16],
   [106,201,,380,,132,272,134,,,53,89,43,43,61,,87,41,78,61,43,57,188,251,
     276,165,250,164,,276,,264,258,288,227,227,203,223,87,331,61,69,78,59,,
     87,,69,356,,328,61,79,47,47,39,43,43,39,308,275,284,238,308,255,308,
     53,63,53,53,63,53,53,63,237,126,307,,,,,,304,77,79,53,,,74,73,74,73,
     79,81,212,298,188,,,165,257,,251,279,,227,227,203,310,121,87,,,87,,66,
     382,87,111,304,120,123],
   [114,153,110,214,151,114,194,118,216,214,53,,45,43,55,57,90,41,59,61,
     45,61,188,169,253,145,,164,157,251,155,227,297,251,227,227,203,227,87,
     218,,71,92,58,218,87,57,67,216,,218,,77,41,43,41,43,43,39,314,227,
     290,212,310,203,318,53,63,53,53,63,53,53,63,151,116,210,151,118,210,
     110,188,214,73,,53,75,,,,73,77,73,77,159,251,188,153,251,145,,151,223,
     251,,227,227,203,212,121,87,232,112,87,,66,232,87,,212,112,121,47],
   [114,195,,314,201,,283,122,314,,49,70,35,35,42,49,70,35,42,49,35,49,180,
     ,268,155,230,140,235,267,235,231,242,272,211,215,175,211,81,364,42,
     49,56,42,296,81,42,49,,56,296,42,56,41,39,35,41,39,35,282,253,246,
     224,286,217,282,49,63,49,49,63,49,49,63,186,114,318,,122,314,,,368,
     60,67,49,60,67,60,67,60,67,67,67,,267,180,195,,155,242,,,264,,211,
     215,175,,88,81,723,88,81,88,56,,81,88,319,88,88,41,41],
   [114,153,108,210,149,116,182,116,208,208,53,88,43,43,74,61,,41,,61,43,
     57,192,173,247,153,233,172,157,249,155,217,,247,223,227,207,227,87,210,
     ,71,77,60,214,87,57,71,212,77,210,,79,47,43,39,43,47,39,302,227,
     282,202,302,203,306,53,63,53,53,63,53,53,63,149,116,208,153,116,208,
     108,182,210,,75,53,73,,73,,,,,75,153,249,192,157,247,153,236,149,227,
     247,,223,227,207,204,112,87,226,117,87,118,66,226,87,,206,120,114,41,
     47,41],[106,240,128,327,,,361,,,313,53,90,43,39,59,61,,,59,61,43,57,
     184,,292,163,254,164,245,,210,259,261,280,231,227,203,231,87,316,60,
     67,77,58,360,87,59,71,436,77,,60,,41,43,39,43,43,41,308,277,284,242,
     308,257,312,53,63,53,53,63,53,53,63,206,,383,206,128,,128,282,,73,73,
     53,73,79,74,,,79,,73,204,278,184,253,280,163,262,,257,,,231,227,203,,
     113,87,520,121,87,120,66,524,87,118,,,115,47,41,41,47],
   [64,71,,,,,64,68,64,77,56,62,,46,45,56,63,42,,58,,56,53,84,47,53,47,
     40,66,47,65,42,44,47,232,238,206,222,50,,44,42,,40,73,48,41,40,68,
     55,73,44,55,308,314,282,302,308,286,49,49,44,45,45,41,48,52,62,52,
     50,60,54,52,58,,68,77,,,,,66,70,62,80,56,,,63,74,61,74,,80,67,,42,,,
     53,57,,52,51,,232,238,206,67,80,44,,,46,78,40,92,48,99,62,82,84,308,
     314,282,302,308],
   [64,46,56,31,46,64,31,68,33,33,57,,42,33,35,47,63,31,42,49,42,,47,87,
     42,38,45,43,79,42,75,34,47,38,217,169,195,169,40,35,33,29,43,34,35,
     31,33,34,33,43,33,33,43,275,227,253,227,277,215,43,48,43,45,45,44,
     45,48,45,45,39,51,39,48,45,75,52,82,75,52,82,58,66,82,43,79,57,43,
     73,,,,,73,79,40,60,53,40,54,33,,42,50,60,,217,169,195,74,,40,94,,37,,
     38,94,37,104,74,77,105,275,227,253,227,277,49],
   [58,,52,,64,62,64,,64,71,52,62,36,38,38,48,62,36,37,46,36,48,50,,,47,
     52,37,,57,61,41,57,56,216,226,178,210,44,,40,36,50,36,71,44,37,34,
     64,49,69,40,49,284,290,246,282,284,250,40,41,37,40,38,37,41,48,62,
     48,46,60,50,48,58,61,56,64,64,62,75,,,71,57,66,52,57,70,58,68,57,
     68,70,66,,51,47,61,57,47,58,,,56,,216,226,178,60,78,46,,75,46,74,36,
     ,44,78,,75,78,284,290,246,282,284,43,43],
   [58,43,52,34,32,58,29,56,34,33,52,48,37,32,31,,51,30,33,42,37,40,50,
     83,33,35,42,34,61,38,63,33,44,38,182,160,172,150,36,32,30,26,37,30,
     33,28,29,30,32,37,33,30,37,238,212,224,202,242,196,46,45,41,42,46,
     41,45,41,40,38,34,42,36,41,38,63,46,70,63,46,70,56,59,70,39,66,52,
     39,70,43,58,,,70,66,39,57,50,39,57,41,54,37,49,57,,182,160,172,64,
     61,36,90,,36,,36,90,34,,64,,61,238,212,224,202,242,40,37,40],
   [56,67,,,68,62,64,62,70,71,56,65,,46,49,56,64,44,50,58,,56,47,84,50,
     47,42,40,65,47,,42,50,47,236,242,214,230,46,,62,42,55,42,,44,,44,66,
     66,71,62,66,308,310,286,302,308,286,43,45,44,45,45,43,48,52,62,52,
     50,60,54,52,58,68,62,71,67,62,70,,64,,61,76,56,61,,61,80,61,80,,76,
     61,62,50,,51,47,63,,52,,,236,242,214,67,80,48,86,82,50,,40,92,44,82,,
     ,78,308,310,286,302,308,46,43,43,46],
   [56,40,64,31,40,64,25,64,29,31,53,54,34,25,29,35,59,25,30,41,34,35,
     47,83,36,34,41,37,75,34,75,30,43,36,205,153,167,157,36,29,29,25,39,
     28,29,27,29,28,29,39,29,29,39,255,203,217,203,257,175,43,44,37,41,
     41,40,43,44,45,41,35,51,35,44,45,67,44,74,67,44,74,42,58,74,39,67,
     53,39,67,52,49,52,49,67,67,34,54,47,34,54,41,45,32,44,54,,205,153,
     167,82,68,36,90,68,33,68,34,90,33,68,82,68,68,255,203,217,203,257,
     43,31,37,31,43],[18,31,,,,20,,26,48,,9,13,7,9,14,7,13,7,14,7,7,
     7,32,52,47,28,46,28,30,45,,50,41,50,39,39,35,39,14,43,8,15,8,8,
     43,14,8,15,43,8,43,8,8,53,53,49,53,53,49,52,48,48,41,52,44,52,9,
     9,9,9,9,9,9,9,35,20,48,,,,,50,,10,11,7,,,10,11,14,9,11,9,30,50,32,
     ,,28,43,,49,47,,39,39,35,,15,13,,,14,15,11,81,13,13,,15,13,53,53,
     49,53,53,52,48,48,41,52,44],
   [18,21,24,35,25,22,31,20,35,35,7,,,9,10,11,,9,10,11,,11,32,27,38,25,
     41,28,29,42,27,42,41,38,39,39,35,39,13,35,,15,16,12,39,13,14,15,
     39,16,35,,16,53,53,49,53,53,49,52,39,48,35,52,35,52,7,9,7,7,9,7,
     7,9,21,18,35,25,20,35,24,31,35,,9,9,10,11,,,10,11,9,11,29,38,32,
     27,42,25,,31,42,38,,39,39,35,41,13,14,41,15,13,,11,37,14,15,41,13,
     15,53,53,49,53,53,52,39,48,35,52,35,9],
   [14,25,,40,25,14,,14,40,40,7,10,5,5,6,7,10,5,6,7,5,7,24,,37,22,38,
     20,22,37,22,,35,37,29,29,25,29,11,33,6,7,8,6,33,11,6,7,33,8,33,
     6,8,39,39,35,39,39,35,40,38,36,33,40,34,40,7,9,7,7,9,7,7,9,25,
     14,40,25,14,40,,,40,8,9,7,8,9,8,9,8,9,9,9,22,37,24,22,37,22,35,,
     ,37,,29,29,25,,12,11,,12,11,12,8,,11,12,,12,12,39,39,35,39,39,40,
     38,36,33,40,34,7,7],
   [18,25,24,35,21,20,31,18,35,35,9,13,7,9,14,7,13,7,14,7,7,7,32,31,
     42,25,42,28,27,38,25,42,,42,39,39,35,39,14,37,8,15,8,8,37,14,8,
     15,37,8,37,8,8,53,53,49,53,53,49,52,39,48,35,52,35,52,9,9,9,9,9,
     9,9,9,25,20,35,21,22,35,24,31,35,10,11,7,,9,10,11,,,11,9,27,42,
     32,25,38,25,38,31,42,42,,39,39,35,41,15,13,37,13,14,15,11,41,13,,
     41,15,13,53,53,49,53,53,52,39,48,35,52,35,7,9,7],
   [18,,,,35,,50,20,,48,7,12,,9,10,11,,9,10,11,,11,32,,43,28,46,28,29,50,
     30,50,43,,39,39,35,39,13,82,,15,16,12,44,13,14,15,,16,82,,16,53,53,
     49,53,53,49,52,48,48,41,52,44,52,7,9,7,7,9,7,7,9,,26,,31,20,48,,,
     ,14,9,9,10,11,,9,10,11,,11,29,,32,30,47,28,41,,49,,,39,39,35,,13,
     14,81,15,13,13,11,,14,15,,,15,53,53,49,53,53,52,48,48,41,52,44,9,
     7,7,9]],[,[],[],[],[],[,,24],[,58,,68],[],[],
   [,52,,59,,,52],[18],[,43,,,,,60],[,,18,,,,56],
   [18,38,,67,,,64,,,61,9,15],[,,,,,,74,,,,15,15],
   [38,43,18,50,,26,40,,,128,11,15,7],
   [24,,35,72,,,102,,,102,,13,,15,15,15],
   [30,41,20,54,,26,42,,,50,,,7,11,15,7],
   [24,43,33,,,,55,,,54,15,15,,,13,,15,15],
   [,59,18,,,,,,,,11,15,7,,,7,15,7],[,,,,,,68,,,,,,7,11,15,7,,7,15,7],
   [,,18,,,,56,,,,,,7,,,7,,7,,7,7],
   [36,,,,,58,64,,,62,36,,,36,,40,46,38,46,,36],
   [,,,,,42,,,,,,,,,,29,60,32,56,31,61],
   [,49,,,,80,81,,,76,,57,,60,65,47,67,53,62,64,49],
   [36,,69,58,,44,74,,,74,34,37,54,30,,,,39,37,33,33,54,34],
   [66,,72,,,60,,,,85,50,,52,,44,,65,48,49,44,44,52,45,,55],
   [36,52,50,62,,,,,,,36,50,28,36,50,28,49,28,49,28,28,28,34,,46,34,45],
   [,,39,,,,,,,,,51,,61,,35,53,35,53,,,,,35,,35,44],
   [66,70,66,78,,,,,,62,60,59,42,60,74,38,65,40,61,41,48,42,45,,58,47,52]
    ,[,,58,,,59,,,,,58,51,46,61,54,44,72,39,,,41,46,,52,,,74,,50],
   [,,,62,,77,79,,,74,60,57,89,58,,47,,53,59,,49,89,,,46,44,52,45,,57],
   [66,78,48,91,,52,,,,83,50,53,34,66,48,40,59,32,48,36,36,34,45,40,53,,
     38,39,38,47,,52],
   [66,66,90,74,,,64,,,,,69,58,,74,53,64,53,59,49,,58,45,,57,,52,,,45,,56,
     55],[90,,,,,140,365,,,364,45,,,45,76,,83,43,83,47,47,,168,,,153,230,
     164,234,,384,270,228,264],
   [90,,128,263,,124,336,,,292,45,,53,45,,,78,,80,45,45,53,168,199,273,141,,
     160,188,251,357,264,,258,41],
   [90,232,,396,,,,,,333,45,67,35,45,67,35,67,35,67,35,35,35,164,296,258,
     153,223,140,,,,257,195,257,41,41],
   [90,207,,,,122,304,,,,45,78,,45,,45,,,79,47,47,,168,227,238,143,196,164,
     207,227,297,233,188,235,41,41,41],
   [18,,,,,24,64,,,,16,,,18,24,17,20,16,22,17,,,34,,,29,42,34,37,47,49,51,
     42,47,78,78,76,78],
   [,,,,,,65,,,63,,,,93,62,44,62,46,,,,,,,,68,,66,,78,,66,91,76,,,,250],
   [,,,,,22,54,,,,,,,,,9,,9,,9,9,,,29,,,,31,32,44,48,78,39,,,63,40,68],
   [18,33,,44,,24,48,,,44,18,24,,16,,,22,17,20,16,17,,34,,46,27,,34,35,46,
     48,45,60,,78,78,76,78,16,46],
   [38,61,22,76,,22,46,,,108,18,22,10,,,,22,9,,9,9,10,47,28,60,,,31,31,
     42,47,58,39,59,65,,40,61,16,,8],
   [18,,18,68,,,,,,68,16,20,10,16,20,9,20,9,20,9,9,10,36,30,48,32,42,28,,
     ,40,48,34,54,64,58,40,64,16,,8,16,8],
   [,52,,59,,,,,,52,,58,,93,,44,79,46,67,,,,66,,77,,,,,,,78,94,68,438,330,,
     282,,53,,70],[18,35,26,44,,24,52,,,44,16,20,18,18,22,17,,,,17,16,
     18,34,51,47,27,38,34,35,46,51,45,38,47,78,78,76,78,14,46,,16,16,16 
    ],[,,30,,,22,46,,,,,,10,18,22,9,,,22,9,9,10,48,30,61,46,67,31,31,
     42,41,59,39,58,61,61,40,,,,8,16,8,8],
   [18,45,26,64,,24,60,,,60,18,22,18,16,20,16,,17,,,17,18,34,50,58,29,48,
     34,37,48,,,52,47,78,78,76,78,16,,,14,,16,,16,16],
   [,,,52,,,65,,,59,,,,,64,44,64,46,,,,,,,74,68,133,66,,78,,,85,78,458,,426,
     258,,44,,,,,53,70],
   [34,61,22,108,,22,46,,,76,18,22,10,,,9,22,9,,,9,10,47,30,70,46,,31,30,
     45,41,,35,67,75,61,40,75,16,,8,,8,8,,16,8],
   [,60,,63,,,52,,,,,67,,93,79,44,,46,58,,,,70,,83,,95,,,66,,76,93,,,,330,
     258,,47,,46,,,44,46,,,53],
   [,,,,,22,54,,,,,,10,18,22,9,,9,22,9,,10,,51,,,53,31,30,43,40,67,33,,75,
     ,40,61,,,8,16,8,8,,,8,16,,8],
   [,,,,,22,54,,,,,,,,,9,,9,,9,9,,,29,,,,31,32,44,48,78,39,,,63,40,68,,,8,,
     8,8,,,8,,,8,,8],
   [126,,,,,176,,,,,63,,,63,102,57,102,59,,59,,,232,,,207,300,220,460,331,396,
     346,292,,285,285,273,285,106,,,106,,82,404,106,79,106,454,79],
   [126,264,166,353,,168,388,,,359,63,102,,63,,,102,57,104,57,61,,232,253,
     356,195,,220,258,332,404,347,298,346,285,285,273,285,106,389,82,106,,
     80,386,106,,106,389,77,408,95,82,55],
   [126,,186,400,,,,,,504,63,93,49,63,93,49,93,49,93,49,49,49,228,278,,207,
     292,196,,,,336,258,355,281,277,245,281,104,402,56,104,56,56,,104,56,
     104,402,56,506,56,56,55,55],
   [126,247,170,336,,164,350,,,,63,102,61,63,102,,,,103,57,59,61,232,,323,
     197,268,216,248,301,,316,252,319,285,285,269,285,106,,,106,79,78,362,
     106,,106,332,,376,81,,55,55,55],
   [126,291,,,,170,444,,,518,63,102,61,63,104,57,,,,,61,61,232,,352,207,305,
     220,,333,,,289,354,285,285,273,285,106,416,108,106,79,82,712,106,80,
     106,,,,94,108,55,55,55,55],
   [126,242,150,352,,152,480,,,367,63,93,49,63,93,49,93,49,93,49,49,49,
     232,255,351,193,,196,215,309,,338,,345,277,281,245,277,100,304,56,100,
     56,56,304,100,56,100,306,56,306,56,56,55,55,49,55,55],
   [58,,,,,94,87,,,91,61,,,68,68,54,66,54,68,,56,,52,,,61,72,57,89,67,,64,
     66,72,276,290,262,260,52,,,59,53,54,93,53,65,53,90,64,99,53,,374,
     384,362,356,374,368],
   [72,,85,100,,76,104,,,112,66,66,62,54,,,,51,66,55,55,62,61,80,,49,,57,
     60,69,,71,56,72,279,243,263,249,55,112,,49,,52,161,49,64,55,112,62,,
     63,,369,333,353,339,369,331,57],
   [72,83,79,91,,,,,,83,61,67,48,68,71,46,69,46,72,48,44,48,61,81,73,61,
     72,44,,,118,71,60,65,272,282,234,256,57,95,49,57,47,44,,52,48,59,93,
     47,88,48,49,362,372,326,340,362,332,57,57],
   [58,72,80,83,,60,91,,,83,50,50,56,49,51,42,,,51,44,44,56,52,82,65,49,
     58,52,53,64,,64,58,,222,216,216,196,42,122,66,45,,42,,38,,45,92,43,
     92,43,66,296,288,288,268,296,290,50,47,50],
   [58,78,71,83,,90,87,,,91,61,70,,68,70,54,69,54,,,56,,52,,66,61,70,57,
     87,67,,,68,72,276,290,258,260,52,90,71,59,53,54,95,53,63,53,,,97,53,
     71,374,384,358,356,374,368,50,57,57,50],
   [72,97,63,106,,68,90,,,,66,65,44,54,69,41,69,41,65,47,47,44,61,54,73,
     49,60,51,54,61,85,73,,74,271,239,235,241,55,113,45,49,46,44,110,49,
     46,55,113,46,116,46,45,353,321,317,327,357,299,57,47,51,47,57],
   [72,83,101,91,,77,79,,,,61,81,66,68,,56,68,54,68,56,,66,61,,73,61,70,
     52,,60,99,71,68,,276,290,262,260,57,97,69,57,53,52,88,52,64,59,93,
     53,,,69,374,384,362,356,374,368,57,57,50,50,57,57],
   [18,,,,,30,56,,,48,9,,,9,15,11,15,11,15,11,11,,36,,,30,42,36,,49,54,50,
     42,,45,45,45,45,16,,,16,16,14,78,16,16,16,78,16,,16,,63,63,63,63,
     63,63,57,54,57,42,57,54,57],
   [18,33,28,46,,26,50,,,48,9,13,13,9,,,13,11,15,11,11,13,36,47,51,29,,
     36,37,50,52,50,45,51,45,45,45,45,17,50,17,16,,13,50,17,15,16,50,
     15,50,15,17,63,63,63,63,63,63,60,51,60,42,60,51,60,9],
   [18,,28,56,,,,,,64,9,13,13,9,13,11,13,11,13,11,11,13,36,50,52,31,44,
     36,,,49,52,44,52,45,45,45,45,16,90,16,16,14,12,,16,14,16,,14,90,14,
     16,63,63,63,63,63,63,58,57,58,44,58,57,58,9,9],
   [18,33,30,44,,26,48,,,44,9,16,13,9,13,11,,,13,11,11,13,36,52,49,29,
     40,36,37,48,47,48,40,49,45,45,45,45,16,48,17,17,15,13,48,16,,17,
     48,15,48,15,17,63,63,63,63,63,63,56,51,56,40,56,51,56,9,9,9],
   [18,41,28,64,,,60,,,,9,13,13,9,15,11,13,11,,,11,13,36,49,55,31,44,36,
     49,52,,,44,,45,45,45,45,17,70,17,16,15,13,70,17,15,16,,,70,15,17,
     63,63,63,63,63,63,58,57,58,44,58,57,58,9,9,9,9],
   [18,33,28,48,,24,50,,,46,9,13,13,9,13,11,13,11,13,11,11,13,36,48,51,
     29,44,36,35,50,47,50,,51,45,45,45,45,16,48,16,16,14,12,48,16,14,
     16,48,14,48,14,16,63,63,63,63,63,63,60,51,60,42,60,51,60,9,9,9,9,
     9],[18,41,,56,,28,64,,,,9,16,13,9,13,11,15,11,13,11,,13,36,79,52,
     31,44,36,,51,49,53,44,,45,45,45,45,16,,17,17,15,13,70,16,15,17,70,
     15,,,17,63,63,63,63,63,63,58,57,58,44,58,57,58,9,9,9,9,9,9],
   [18,,,,,30,56,,,48,9,,,9,15,11,15,11,15,11,11,,36,,,30,42,36,,49,54,50,
     42,,45,45,45,45,16,,,16,16,14,78,16,16,16,78,16,,16,,63,63,63,63,
     63,63,57,54,57,42,57,54,57,9,9,9,9,9,9,9],
   [,,,,,,,,,,,,,,,38,49,,,,,,,,,33,46,,,,,,46,,,165,,175,,,,33,41,41,,33,40,,,,,,
     ,,218,257,227,,225,,62,75,,,62,72,,32,37,33,,32],
   [,,,,,,,,,,,,,36,42,26,,26,,,,,,,,,85,52,,70,,,80,70,,128,124,122,,,,24,,,,
     24,,,,,,,,,170,164,168,192,148,,,88,77,77,88,90,,26,32,26,28,24],[],
   [,,,,,,,,,,,56,31,35,40,26,,25,47,35,35,31,46,40,62,33,46,40,37,60,54,
     64,40,65,227,150,237,167,39,,28,32,27,,,33,26,38,,27,,29,28,297,200,,
     213,292,,71,58,64,40,70,,71,37,32,37,31,41,31,41,37,33],
   [,,,,,,,,,,30,,18,36,,20,33,18,35,26,18,18,,,82,48,72,,,,,,77,,166,132,
     122,140,20,58,19,24,21,18,58,20,19,20,58,21,58,19,19,182,156,154,
     190,,168,,84,,,91,88,84,30,32,28,28,36,28,28,30,,24],
   [,,,,,,,,,,,88,,61,60,54,,60,,,,,62,56,84,,46,62,48,89,78,85,40,83,320,
     272,,246,64,,,57,,68,,46,52,,,45,,52,,398,352,501,,,352,91,,91,55,89,
     51,89,48,48,64,44,,46,,48,46],
   [,,,,,,,,,,,35,18,,33,18,,20,,18,,18,,,,48,122,46,,79,,,80,,,128,,,20,58,
     19,20,19,18,58,24,21,20,58,19,58,21,19,,166,186,170,,150,80,84,79,,,
     ,91,,28,28,30,28,28,,,,24,,,22],
   [,,,,,,,,,,,65,48,64,71,38,51,38,73,56,56,48,,,,63,88,,,,,,66,,354,266,
     426,246,56,,39,54,38,,,46,39,60,,42,,42,39,552,344,,340,526,,73,51,69,
     ,75,47,73,56,46,,46,64,46,64,56,,,,40,,59],
   [,,,,,,,,,,,,,,,54,85,56,74,,,,62,50,84,63,44,62,52,83,80,85,46,85,375,
     292,330,244,,,64,,62,68,,54,,72,,51,,47,64,398,377,,,402,352,89,55,89,
     55,91,,91,48,46,52,44,52,48,56,48,46,,,,,46,,59],
   [,,,,,30,78,,,,,,,18,24,13,,,24,13,,,,,,,51,43,40,60,56,64,49,,,63,54,67,,
     ,,16,12,12,,,,16,,12,,,,,88,74,89,,70,,67,63,49,67,63,64,,13,12,14,
     13,12,14,,34,,,40,23,52,27,61,53],
   [,,,,,28,118,,,,,,,13,19,15,,,19,15,,,,,,46,68,48,,70,66,84,62,90,,,59,63,
     ,,,24,24,24,97,24,,24,77,24,,,,,83,81,83,83,81,,82,84,64,,80,86,,13,
     13,,13,13,,,,28,,,42],
   [18,49,,,,20,,,,,9,15,7,9,15,7,15,7,15,7,7,7,32,,64,31,62,28,33,,,67,
     80,67,39,39,35,39,16,54,8,16,8,8,54,16,8,16,54,8,54,8,8,53,53,
     49,53,53,49,56,57,52,52,56,53,56,9,9,9,9,9,9,9,9,49,20,,,,,,,,10,
     11],[28,52,,72,,29,79,,,62,15,21,13,18,15,14,20,12,14,13,12,13,46,
     60,61,,57,,38,63,,58,,64,89,85,86,80,22,53,14,16,15,13,49,21,13,15,
     53,14,50,13,14,102,103,,106,101,,68,72,63,46,74,63,65,15,16,14,14,
     15,14,14,15,37,26,,31,,,,,60,16,17],
   [,53,,,,26,,,,,11,18,9,13,21,11,18,9,21,9,9,9,48,,63,44,63,44,42,,,
     61,68,70,57,,,,19,58,10,22,12,10,58,19,10,22,58,10,58,10,10,77,73,
     75,73,,77,80,76,65,63,78,74,,11,13,11,11,11,11,11,11,52,26,,,22,,,,,
     12,13],[28,36,27,62,,,59,,,,,,,18,,13,,,24,13,,,46,41,55,36,49,43,,
     53,53,52,45,56,66,63,54,71,19,55,10,17,10,12,51,19,10,17,56,10,54,
     10,10,91,86,74,89,89,70,68,62,63,49,64,58,67,15,13,12,,13,12,14,15,
     ,30,,45,,,,66,86,12,,10,16,12],
   [30,,50,72,,30,85,,,,,,,13,,15,,,19,15,,,50,91,82,46,58,48,45,74,63,92,
     50,81,61,67,59,,24,65,,24,24,24,67,,,,67,24,65,,,83,95,81,93,97,81,
     82,74,77,66,92,68,81,11,11,13,11,11,11,11,11,,28,,45,,,50,56,66,,
     13,11,17,13],[,37,37,57,,26,,,,,15,20,13,18,14,13,21,12,15,14,12,
     13,51,48,57,36,55,47,38,48,,61,53,59,79,84,,79,21,45,14,15,14,13,
     52,22,13,16,48,15,53,13,14,101,,,103,104,100,61,64,66,48,64,,72,15,
     15,14,14,16,14,14,15,,29,,,27,72,,,,16,17,,13,,16,17],
   [30,45,30,98,,26,56,,,60,11,18,9,13,21,9,18,9,21,11,9,9,46,43,61,,
     70,50,38,106,,58,,67,55,55,,57,19,50,10,22,10,10,50,19,10,22,50,12,
     50,10,10,73,73,75,77,77,,71,,72,61,73,62,74,11,11,11,11,13,11,11,
     11,,26,,62,24,68,30,,71,12,13,,,11,12,13],
   [,,,,,28,112,,,,,,,,19,15,,,,15,,,50,,75,,67,48,51,81,65,73,68,,63,67,59,,
     ,96,,,24,24,74,26,,24,,24,100,,,83,99,81,89,89,81,86,86,73,69,88,80,
     ,11,11,11,11,11,13,11,11,,32,,56,42,,,,,,13,11,17,13,,13,17,13],
   [],[,,,,,,52,,,48,,,,61,51,35,51,35,,,,,,,,59,,56,,67,,65,74,68,,188,282,
     ,,,,50,,,44,,,,,,44,,,,264,339,248,289,215,,103,85,83,85,103,85,,37,,
     37,49,35,,,,,,,39,,39,,,,,33,37,42,40,61,38,38,52],
   [,,,,,72,81,,,85,,,,,57,53,58,47,,,49,,,,,60,71,52,65,62,,,67,67,,262,,
     238,,,,54,47,48,88,47,54,,,,103,47,,,341,336,317,,338,,56,52,45,,56,52,
     ,51,52,49,,51,,,47,,,58,96,74,,58,74,52,,67,59,60,,71,,,76],
   [36,,50,,,,62,,,62,36,46,42,36,46,40,,40,,36,,42,34,59,59,34,59,32,60,
     43,75,56,56,47,168,168,164,168,34,,,34,,32,66,34,47,34,,48,70,47,,
     232,232,228,232,232,232,61,61,50,46,61,61,54,36,36,36,36,36,36,36,
     36,50,58,,,,,,58,,,50,32,,,,52,46,48,,,,45],
   [,,,,,,90,,,78,58,67,45,61,,45,51,39,54,,41,45,,,101,,116,72,,93,,,,94,
     323,357,,330,48,66,47,50,46,40,64,43,41,47,69,42,64,41,47,403,,,,
     391,379,105,149,108,104,,144,112,54,52,49,47,,47,49,54,,59,,,,,57,,,
     53,65,,,,56,63,,,66,,50],
   [66,,65,,,,75,,,85,65,76,39,58,58,40,57,38,67,40,48,39,45,66,60,60,45,
     39,66,46,94,62,38,50,260,248,227,224,48,,41,55,40,,89,47,40,51,,40,
     87,43,41,349,324,,301,346,,68,56,53,52,67,48,57,53,50,51,48,52,50,
     52,53,62,76,,39,,,92,64,62,58,64,,50,,62,65,72,81,80,,,56],
   [36,,48,72,,54,72,,,,34,37,,30,,39,37,,,33,33,,34,60,62,36,45,34,82,62,
     84,60,41,60,153,141,153,143,32,57,30,30,29,32,57,30,29,32,57,29,57,
     29,30,207,195,207,197,207,193,61,56,61,47,61,52,61,30,29,31,29,31,
     29,31,30,,44,,47,,58,,66,58,36,46,31,38,44,,,,42,54,,35,,34,,44],
   [66,58,74,76,,,58,,,44,50,44,80,66,,44,57,,51,44,44,80,45,83,75,47,56,
     52,85,45,119,71,54,46,229,,221,196,44,66,41,40,39,42,44,40,39,44,
     66,39,42,39,41,305,310,298,268,301,338,70,62,52,53,70,58,53,42,45,
     44,40,44,45,44,42,75,60,,70,,92,110,87,88,49,80,62,47,58,47,,71,50,
     66,,44,52,45,76,53],[],
   [,,,,,70,91,,,83,59,65,94,58,56,52,,47,,,48,94,,66,,60,74,52,,63,88,,
     67,66,258,259,258,233,51,,49,53,57,47,89,47,47,,,46,89,50,49,343,
     343,338,318,365,344,64,56,49,45,65,52,53,49,50,51,49,51,50,51,49,,,,
     58,,74,,,74,54,83,64,,65,72,75,63,67,71,,,45,45,,56,47,52],
   [66,,79,,,,79,,,85,,,51,,60,53,56,50,65,48,,51,45,66,67,60,46,43,66,50,
     100,70,45,54,261,264,,238,48,,66,,47,52,89,46,,51,,58,89,46,66,346,
     340,357,320,348,340,71,56,57,56,72,56,61,50,51,53,48,51,50,,50,62,
     76,,47,,62,,70,,53,71,66,54,113,,75,61,60,,,,56,,,45,44,53,,56],
   [66,52,88,88,,77,44,,,52,50,51,,,53,,,64,44,44,44,,45,123,72,47,54,52,
     101,42,104,73,52,45,228,268,223,196,44,66,41,40,39,42,42,40,39,44,
     66,39,44,39,41,,,293,268,303,312,72,61,49,53,,57,52,42,,44,40,44,45,
     44,42,72,60,,70,93,,,87,89,49,67,,49,58,51,78,57,50,66,,44,52,,74,
     52,,38,,52,52],[90,229,174,318,,144,,,,375,45,79,,45,,43,81,,80,,43,,
     168,311,265,153,228,164,,262,323,,228,,41,41,39,43,78,458,,78,75,64,
     438,78,75,78,,61,340,65,,285,285,281,285,285,277,276,279,272,222,276,
     271,276,45,45,45,45,45,45,45,45,,128,,,,,174,310,364,,67,39,,,66,,77,
     55,61,,234,272,168,,,153,229,,,269,229],
   [90,,124,274,,,320,,,290,45,77,53,45,,45,78,45,77,,,53,168,209,276,141,
     268,160,188,259,357,261,,262,41,43,41,43,78,301,69,78,61,58,348,78,,
     78,305,59,305,74,69,285,285,277,285,285,281,290,243,282,216,290,239,
     290,45,45,45,45,45,45,45,45,159,,,,,276,124,251,,63,61,39,,57,,,79,,,,
     253,256,168,320,251,141,,,259,,,41],
   [90,,,328,,136,,,,417,45,67,35,45,67,35,67,35,67,35,35,35,164,219,273,
     153,222,140,282,,,257,,,41,39,35,41,76,,40,76,40,40,426,76,40,76,330,
     40,426,40,40,273,273,245,269,273,245,262,263,234,216,258,235,262,45,
     45,45,45,45,45,45,45,,136,,175,,404,,,404,54,59,35,,59,54,59,72,53,
     59,,223,256,164,,224,153,224,,,265,222,41,41],
   [,,,,,60,,,,,,,,,,42,76,42,83,44,,,,,,,,,53,,70,,62,,,379,345,,,,,,41,42,,
     70,41,77,,43,,,,,392,427,446,877,416,,,,74,,51,,,68,72,68,70,70,,,,,,52,
     ,68,,50,62,,,,62,,55,132,57,63,,,,,70,,77,72,92,,68,77,,641,318,486],
   [,,,,,,76,,,63,,,,18,19,19,17,,19,19,,,,,,47,,62,48,72,59,70,65,87,,95,
     81,95,,,,29,28,28,63,26,,28,69,28,58,,,,,111,125,125,111,,80,87,61,
     86,79,85,,17,17,,17,17,,,,,,62,,88,45,73,,,,17,23,20,,20,22,20,20,,45,
     ,58,75,78,49,81,,81,,56,,99,81],
   [18,35,,54,,20,,,,54,18,15,14,18,15,14,15,14,15,14,14,14,32,,50,29,46,
     28,31,,47,49,43,53,75,75,65,75,16,46,15,16,15,14,46,16,15,16,46,
     15,46,15,15,101,101,91,101,101,91,54,51,46,44,54,47,50,16,16,15,16,
     16,15,16,16,35,20,,,,,18,66,54,19,20,13,,,19,20,18,21,20,,31,49,32,,
     ,29,46,,49,55,,75,75,65,,17],[],
   [38,48,,68,,31,60,,,92,18,15,14,18,26,15,15,14,25,13,14,14,58,,65,45,
     61,77,44,65,71,64,59,64,93,91,,92,16,59,15,27,16,14,52,16,15,26,
     59,14,55,15,15,123,,117,,115,119,78,74,74,57,,73,77,16,17,15,16,15,
     15,16,16,47,33,,,,,31,97,78,19,20,,,,19,20,,18,20,,41,67,,,,,52,,74,
     93,59,,89,,,17],[18,,24,55,,24,63,,,,16,,18,18,,17,20,,22,17,16,18,
     34,35,54,30,40,34,35,56,43,55,36,55,78,78,76,78,16,53,15,18,14,16,
     53,16,15,18,53,14,53,15,15,106,106,104,106,106,100,59,50,57,40,59,
     46,57,16,17,16,16,17,16,16,16,31,24,,31,,48,26,44,44,19,24,16,22,
     19,,,21,19,24,,35,45,34,51,46,27,,,45,48,60,78,78,76,46,,16,,16],
   [,,,63,,35,92,,,,,,,18,,19,19,,19,19,,,74,,77,48,79,62,49,76,62,,56,,97,
     107,81,,,58,,29,28,28,,26,,30,63,28,69,,,125,143,111,171,,111,86,81,
     83,67,91,79,,16,15,17,16,15,15,16,16,,35,,54,,122,45,82,,,20,17,23,
     20,,,22,20,20,,52,88,58,80,74,,,,,97,79,97,,81,,17,17,,17],
   [18,36,,58,,20,,,,58,16,13,12,14,15,11,13,12,15,11,12,12,32,,52,29,40,
     28,31,43,47,,36,47,65,65,57,65,14,45,13,16,12,12,45,14,13,16,45,
     12,45,13,13,87,87,79,87,87,79,49,51,50,40,49,47,54,14,13,13,14,13,
     13,14,14,33,20,,39,18,54,,,52,17,18,13,,16,17,18,,16,18,,31,46,32,
     46,41,29,48,,,44,47,65,65,57,,15,13,,13,14,15],
   [,,,,,88,,,,,,,68,96,105,58,69,62,79,60,,68,,,,106,126,,79,,,,,,,604,,684,,
     ,69,89,58,58,,70,63,73,,59,,,69,638,658,,812,,660,114,83,127,74,122,
     77,122,78,68,70,72,70,68,,78,,,,76,,102,,,100,,,,,,85,110,84,93,,,,96,
     98,,110,106,145,,,114,148,681,,,74,,,,,70],
   [18,33,,46,,20,46,,,42,18,15,14,18,15,14,15,14,15,14,14,14,32,52,44,
     29,40,28,31,40,52,42,36,42,75,75,65,75,16,38,15,16,15,14,38,16,15,
     16,38,15,38,15,15,101,101,91,101,101,91,49,51,45,40,49,47,49,16,16,
     15,16,16,15,16,16,,20,,,18,48,18,44,48,19,20,13,19,21,19,20,,,20,,
     29,,32,,43,27,36,,45,45,36,75,75,65,,17,13,,,16,17,13],
   [34,51,,92,,31,,,,68,18,15,14,18,26,13,15,14,25,15,14,14,56,,70,44,56,
     ,43,,71,65,54,,,89,,94,16,55,15,27,14,14,59,16,15,26,52,16,59,15,
     15,117,121,,125,128,119,80,73,76,61,82,73,74,16,15,15,16,17,15,16,
     16,,33,,,34,,31,,68,19,20,,,18,19,20,,,20,,44,,70,,89,46,65,,69,66,
     73,90,91,87,,17,,,15,16,17,13],
   [,,,,,60,,,,,,,,,,42,83,46,80,44,,,66,40,87,106,42,66,44,81,66,90,40,87,
     ,331,,318,,,43,,43,42,,70,86,77,,39,,43,43,,440,,598,,453,92,52,90,
     52,98,51,94,,68,72,68,70,70,,,50,,,,,56,,62,,87,,,,,55,120,79,63,,,,77,
     ,,66,68,94,,79,,,549,,429,51,,,,,46,,,96],
   [,,,,,33,72,,,79,,,,,19,19,17,,21,19,,,,,73,51,65,62,49,69,59,72,65,93,
     97,,81,100,,82,,,28,28,58,28,,28,,28,65,,,125,153,111,,,111,86,84,82,
     63,91,79,107,16,15,15,16,15,17,16,16,,39,,60,,88,45,74,,,20,17,23,
     20,,20,22,20,,,45,,58,75,84,51,,,80,,65,101,,81,,17,17,,17,,17,15,,
     17,17],[],[126,282,198,,,,458,,,,63,103,61,63,102,,103,57,112,61,
     57,61,232,380,356,207,300,220,,331,,345,288,358,285,285,273,285,106,
     454,84,106,80,82,,106,,106,454,,454,80,84,55,55,53,57,57,53,374,369,
     362,296,374,353,374,63,63,63,63,63,63,63,63,312,176,,,,,198,,398,95,
     95,53,,,89,83,101,73,85,,299,367,232,,,207,301,,343,354,306,285,285,
     273,,153,101,,,106,,87,638,101,115,,125],
   [126,,,346,,170,,,,352,63,103,,63,,57,,57,102,59,59,,232,253,,195,,220,,
     328,,344,338,339,285,285,273,285,106,389,82,106,95,80,386,106,77,106,
     389,,389,,82,55,57,55,57,57,53,384,333,372,288,384,321,384,63,63,63,
     63,63,63,63,63,217,170,,203,,,,322,352,86,83,53,103,,,,103,73,95,,264,
     339,232,404,326,195,,,347,347,310,285,285,273,392,131,101,,115,106,,87,
     658,101,,392,153,,55],
   [126,294,,400,,,473,,,,63,93,49,63,93,49,93,49,93,49,49,49,228,279,344,
     207,296,196,339,,,336,261,340,281,277,245,281,104,506,56,104,56,56,
     402,104,56,104,,56,402,56,56,55,53,49,55,53,49,362,353,326,288,358,
     317,362,63,63,63,63,63,63,63,63,257,164,,,,394,,,504,74,81,49,,,74,81,
     ,75,81,,,336,228,523,,207,293,,,337,293,281,277,245,745,111,91,,117,
     104,111,79,,91,117,427,111,,55,55],
   [126,247,166,356,,164,350,,,324,63,102,61,63,114,59,103,61,,61,59,61,
     232,324,323,197,268,216,259,301,363,317,252,317,285,285,269,285,106,
     332,108,106,79,78,376,106,103,106,332,80,332,,108,55,57,53,57,55,53,
     356,339,340,268,356,327,356,63,63,63,63,63,63,63,63,,,,211,168,324,
     166,316,358,,85,53,101,73,89,,,,89,,248,,232,,303,197,268,,,316,268,
     285,285,269,430,125,101,,115,106,143,87,812,101,,430,137,,55,55,55],
   [126,,186,410,,,737,,,402,63,,61,63,102,61,,,103,,57,61,232,,354,207,301,
     220,391,,399,347,291,347,285,285,273,285,106,416,,106,79,82,430,106,,
     106,,80,,79,,55,57,53,57,57,55,374,369,362,296,374,357,374,63,63,63,
     63,63,63,63,63,257,,,239,186,,186,388,,89,83,53,101,73,93,89,,79,,,
     289,347,232,484,332,207,305,,346,,301,285,285,273,877,125,101,,117,106,
     143,87,918,101,123,,,,55,55,55,55],
   [72,,91,,,,89,,,89,61,68,60,68,66,54,68,58,,56,,60,61,87,55,61,55,50,
     88,59,113,53,49,61,276,290,262,260,57,,56,57,,52,95,52,53,59,90,53,
     97,64,56,374,384,362,356,374,368,57,57,60,59,59,55,64,57,60,58,56,
     58,60,58,57,79,94,,,,,,81,81,,86,56,,,62,79,65,74,,,89,72,52,,,61,72,
     ,71,64,70,276,290,262,98,82,50,,,57,84,54,131,49,93,89,84,,374,384,
     362,356,374],[72,70,84,68,,92,68,,,55,66,66,,54,,53,66,49,69,55,55,
     ,61,101,58,56,61,57,122,58,139,56,58,56,279,243,263,249,56,53,52,
     50,49,52,53,50,49,56,51,49,51,49,52,369,333,353,339,369,331,57,64,
     57,59,59,60,59,54,51,57,51,57,51,57,54,95,76,,81,,100,,98,100,62,
     82,57,66,76,,,,66,86,,60,72,61,,67,49,,,73,71,60,279,243,263,112,82,
     51,,,49,,51,158,45,75,109,84,,369,333,353,339,369,57],
   [58,,67,,,88,86,,,89,61,72,45,68,72,46,70,46,66,44,48,45,52,78,,61,72,
     51,,62,,65,60,71,272,282,234,256,52,,48,59,48,46,95,53,47,53,88,47,
     93,48,48,362,372,326,340,362,332,50,55,51,50,48,51,55,57,60,58,56,
     58,60,58,57,74,75,,65,79,91,,,89,62,73,52,,76,65,80,61,,84,,,65,61,
     118,62,61,72,,,71,70,272,282,234,84,88,50,,75,59,85,45,,45,80,90,85,
     ,362,372,326,340,362,57,57],
   [58,,73,,,75,57,,,55,50,51,49,49,50,,49,42,51,44,44,49,52,81,46,45,53,
     42,,53,113,46,49,56,222,216,216,196,44,44,41,40,39,42,51,40,39,44,
     44,39,51,39,41,296,288,288,268,296,290,50,59,55,52,50,55,59,42,42,
     44,40,44,42,44,42,,60,,66,68,,68,79,83,49,67,52,51,60,,67,,,66,,53,,
     52,,64,49,58,,64,64,58,222,216,216,92,65,44,,61,45,,43,128,36,,,67,,
     296,288,288,268,296,50,47,50],
   [72,78,95,,,75,87,,,91,61,66,60,68,73,54,73,58,73,56,,60,61,83,53,61,
     53,50,84,58,115,53,53,61,276,290,258,260,57,,71,57,53,48,95,52,,59,
     90,63,95,53,71,374,384,358,356,374,368,57,59,60,59,59,57,64,57,60,
     58,56,58,60,58,57,79,88,,70,84,83,91,81,,62,86,56,63,,62,83,64,76,,
     ,87,72,52,,61,61,70,,71,,72,276,290,258,94,85,50,,77,57,88,54,129,
     49,80,,,,374,384,358,356,374,50,57,57,50],
   [72,66,96,59,,88,53,,,59,66,69,44,54,65,41,65,41,69,47,47,44,61,123,
     57,52,57,51,103,49,,52,55,57,271,239,235,241,52,47,48,46,45,44,47,
     46,45,52,47,45,47,45,48,353,321,317,327,357,299,57,60,51,55,55,56,
     57,54,51,57,51,57,51,57,54,93,68,,81,63,106,63,84,106,58,80,53,63,
     76,63,68,,62,80,,54,74,61,85,62,49,60,,71,73,,271,239,235,,83,47,,
     75,49,83,47,152,41,75,166,83,,353,321,317,327,357,57,47,51,47,57],
   [18,34,18,48,,20,56,,,,9,14,7,9,13,7,14,7,13,7,7,7,32,29,49,28,43,
     28,30,43,,47,41,49,39,39,35,39,15,43,8,14,8,8,43,15,8,14,43,8,43,
     8,8,53,53,49,53,53,49,52,48,48,41,52,44,52,9,9,9,9,9,9,9,9,34,
     20,,,,,18,50,,10,11,7,,,10,11,12,9,11,,30,49,32,,,28,46,,47,50,43,
     39,39,35,44,16,13,,,15,16,12,82,13,14,44,16,,53,53,49,53,53,52,48,
     48,41,52,44],[18,,30,52,,30,64,,,,9,15,,9,,11,,11,15,11,11,,36,53,
     56,30,49,36,53,55,55,55,54,53,45,45,45,45,16,,,16,16,14,79,16,16,
     16,79,16,,16,,63,63,63,63,63,63,60,54,60,45,60,54,60,9,9,9,9,9,9,
     9,9,33,,,33,,,30,58,52,15,11,9,15,11,,,15,11,11,,53,53,36,55,53,30,,
     ,53,56,47,45,45,45,79,16,16,,16,16,,14,79,16,16,79,16,,63,63,63,
     63,63,60,54,60,45,60,54,9],
   [18,35,,50,,20,,,,44,9,13,7,9,14,7,13,7,14,7,7,7,32,48,46,28,38,28,
     30,39,46,46,34,43,39,39,35,39,14,40,8,15,8,8,40,14,8,15,40,8,40,
     8,8,53,53,49,53,53,49,49,48,45,38,49,44,49,9,9,9,9,9,9,9,9,31,
     20,,31,18,44,,,44,10,11,7,,9,10,11,14,9,11,,30,43,32,46,42,28,38,,,
     44,38,39,39,35,,15,13,,13,14,15,11,,13,13,,15,,53,53,49,53,53,49,
     48,45,38,49,44,7,9],
   [18,35,18,50,,20,,,,44,9,14,7,9,13,7,14,7,13,7,7,7,32,29,45,28,38,
     28,30,42,,43,34,,39,39,35,39,15,40,8,14,8,8,40,15,8,14,40,8,40,8,
     8,53,53,49,53,53,49,49,48,45,38,49,44,49,9,9,9,9,9,9,9,9,,20,,31,
     ,44,18,,44,10,11,7,12,9,10,11,,,11,,30,,32,,39,28,38,,44,43,38,39,
     39,35,40,16,13,,14,15,16,12,66,13,,40,16,,53,53,49,53,53,49,48,45,
     38,49,44,7,9,7],[18,36,,58,,,58,,,52,9,15,,9,15,11,15,11,,11,11,,
     36,,55,30,47,36,53,55,53,53,47,,45,45,45,45,16,79,,16,16,14,79,16,
     16,16,,16,79,16,,63,63,63,63,63,63,60,54,60,45,60,54,60,9,9,9,9,
     9,9,9,9,,30,,33,30,52,,58,,15,11,9,15,11,15,11,15,11,,,53,,36,53,
     53,30,50,,53,,,45,45,45,,16,16,,16,16,16,14,92,16,16,,,,63,63,63,63,
     63,60,54,60,45,60,54,9,9,9,9],
   [18,35,,48,,20,,,,,9,13,7,9,14,7,13,7,14,7,7,7,32,52,50,28,46,28,30,
     45,47,50,41,47,39,39,35,39,14,43,8,15,8,8,43,14,8,15,43,8,43,8,
     8,53,53,49,53,53,49,52,48,48,41,52,44,52,9,9,9,9,9,9,9,9,31,20,,
     ,18,,,50,,10,11,7,14,9,10,11,,9,11,,30,47,32,47,45,28,43,,47,47,,
     39,39,35,,15,13,,13,14,15,11,81,13,13,,15,,53,53,49,53,53,52,48,48,
     41,52,44,7,9,7,7,9]],
 [,[],[],[],[,15,,21],[,,13],[,21,,27],[],[],[,21,,27,,,21],
   [8],[,14,,,,15,25,,,33],[,,14,,,,37],[],[],[],
   [,,14,,,,36,,,,,7],[,65,19,,,24,37,,,,,,8],[],[],
   [,,,,,,49,,,,,,8,,,,,8],[],[16,,,,22,36,27,,,27,16,,,,,,,65,,,54],
   [,,,,,19,,,,,,,,,,,17,21,,,52],[,21,,,27,36,32,,,32,,23,,,,,33,69,,,61],
   [],[],[,22,27,27,,,,,,,18,22,27,,,,23,27,,,28,,16,,20],
   [,,19,,,,,,,,,19,,,,,22,29,,,,,,16],
   [,27,42,32,21,,,,,27,,25,49,,,,,60,,,,,20,,24],
   [,,25,,,25,,,,,22,22,34,,,,,35,,,34,,,19,,,,,19],
   [,,,29,29,,34,,,34,24,29,35,,,,32,38,,,34,,,,21,,,21,,25],
   [,29,31,,35,31,40,,,40,27,26,59,,,,,,,,59,,,23,25,,,23,23,27],
   [,27,,32,,,27,,,,,23,,,,,33,69,,,,,20,,24,,,,,20,,25,27],[],[],
   [,99,,,,,,,,200,25,32,37,,,,32,37,,,37,,93,126,119,,,77,,,,129,130,115],
   [,,84,,129,69,129,,,159,,51,76,,,,,,,,,,113,,118,,,109,82,116,,129,153,122,,
     ,25],[8,,,,18,11,20,,,,5,,,,,,6,15,,,,,16,,,,,18,15,25,21,23,25,23,,,
     25],[],[,,,,,16,46,,,,,,,,,,,7,,,7,,,21,,,,23,24,,,37,,,,,30],[],
   [],[,15,11,23,,,,,,,5,6,7,,,,6,7,,,7,,21,15,22,,,16,,,21,23,25,21,,,
     20,,5,,6],[],[,17,12,,,12,24,,,,5,6,15,,,,,,,,15,,20,15,23,,,18,
     15,25,23,25,,23,,,25,,5,,,,,5],
   [,,20,,,16,26,,,,,,7,,,,,,,,7,,,19,,,,23,21,43,31,,,55,,,30,,,,6,,,6],
   [],[],[],[],[,,14,,,16,46,,,,,,7,,,,,7,,,,,,43,,,,23,24,47,,41,,,,,
     30,58,,,6,,,6,,,6],[],
   [64,,,,154,92,,,,218,41,,,,,,,73,,,,,114,,,,,122,162,162,,167,177,159,,,164,
     192,41,,,,,32,,44,83,,,,,67],[],
   [,,90,217,,,,,,342,35,44,51,,,,44,51,,,51,,120,125,,,,107,,,196,179,,162,,,
     140,174,35,,42,,,28,,35,42,,,,,42,,35],
   [96,,100,174,,88,171,,,,48,,82,,,,,,,,106,,138,120,,,,140,108,155,147,,175,
     155,,,176,202,46,,,,,32,,,,,,,,82,,32,,35],
   [68,125,116,,148,,210,,,,44,60,76,,,,,85,,,73,,115,173,154,,,124,,155,,,
     152,169,,,167,215,44,,70,,,32,,42,,,,,,67,,,,32,40],
   [56,,78,161,105,78,,,,162,35,42,51,,,,42,51,,,51,,107,103,152,,,107,103,
     151,,,,152,,,140,,35,,42,,,28,,35,42,,,,,42,,,,28,33],
   [24,,,,34,45,39,,,39,26,,,,,,,53,,,59,,22,,,,,26,43,30,,27,41,30,,,123,
     120,24,,,,,27,,27,,,,,,45,,162,,166,163,163,168],[],
   [,34,41,39,,,,,,34,26,27,38,,,,29,39,,,37,,26,35,30,,,22,,,56,31,37,26,,
     ,120,123,25,,33,,,24,,25,37,,,,,40,,166,,163,166,162,169,25],[],
   [,,,34,34,47,39,,,39,,33,,,,,31,54,,,48,,,,26,,,26,35,30,,,33,30,,,120,
     128,,,50,,,24,,25,50,,,,,41,,167,,163,162,164,,21,,25],
   [32,,34,66,40,34,45,,,45,29,27,39,,,,30,35,,,39,,26,27,,,,28,27,32,,,,32,
     ,,122,132,26,,35,,,26,,26,32,,,,,35,,167,,163,161,,148,25,,27],
   [32,34,,39,41,,34,,,,24,30,59,,,,,53,,,,,26,40,30,,,,,26,44,31,37,,,,125,
     119,24,,,,,,,27,65,,,,,,,163,,171,166,169,169,25,,21,,25,27],
   [24,,,,59,35,66,,,74,15,,,,,,20,18,,,18,,46,,,,,50,,71,53,64,65,,,,67,79,
     15,,,,,13,,15,15,,,,,15,,103,,93,107,104,93,68,,67,,70,69,66],[],
   [,40,28,60,,,,,,60,15,16,17,,,,16,17,,,17,,,37,56,,,39,,,44,56,65,56,,,
     50,68,13,,14,,,10,,13,14,,,,,14,,86,,70,86,85,70,,,57,,61,62,68,13],
   [,,35,72,,34,63,,,72,15,20,18,,,,,,,,18,,,43,63,,,50,44,64,54,66,71,62,,
     ,67,82,15,,15,,,13,,15,,,,,,15,,104,,93,108,102,93,68,,67,,68,64,69,
     14,,13],[28,49,29,72,53,,,,,,18,19,20,,,,19,20,,,20,,46,38,58,,,,37,
     63,,,61,63,,,76,79,16,,17,,,,,16,17,,,,,17,,104,,95,103,103,,66,,57,,68,
     ,62,15,,12,15],[24,,26,70,50,28,,,,72,15,16,17,,,,16,17,,,17,,41,37,
     ,,,39,39,63,,,,64,,,50,68,13,,14,,,10,,13,14,,,,,14,,87,,70,,,70,62,,
     59,,,54,62,13,,10,13],
   [24,47,,74,,35,73,,,,15,21,18,,,,20,18,,,,,46,72,63,,,49,,61,53,67,65,,,,
     67,79,15,,15,,,13,,15,15,,,,,,,102,,93,106,103,93,66,,69,,69,69,68,14,
     ,13,14,15,13],[32,53,30,62,,37,,,,62,18,19,20,,,,19,20,,,20,,51,37,
     64,,,,35,73,47,,80,62,,,,84,16,,17,,,13,,16,17,,,,,17,,103,,98,108,103,
     98,63,,59,,69,,63,15,,,15,14,12,15],
   [,,,,,,,,,,,,,,,,17,,,,,,,,,,,,,,,,,,,,,,,,,,,15,,13,,,,,,,,,,99,94,,108,,,27,,,,
     25,,,39,37,43,46,,36],[],
   [,,,,,,,,,,,,,,,,15,37,,,,,,,,,,,,,,,,,,,,72,,,,,,,,17,,,,,,,,,,,98,148,117,,,,,,
     25,,,,62,43,,47,54,37],
   [,,,,,,,,,,,,,,,,12,,,,,,,,,,,25,22,40,22,40,25,,,,,53,,,,,,,,11,36,,,,,,,,,,73,
     ,82,,,39,,39,24,,,,52,31,44,40,43,30,,,13],
   [,,,,,,,,,,,,,,,,15,24,,,,,,,,,,,,,,,,,,,109,97,,,,,,,,14,23,,,,,,,,,117,114,,,,,,,
     ,,45,,,,36,38,,,52],[],
   [,,,,,,,,,,,13,15,,,,,31,,,15,,,,,,,24,,33,,,,31,,,,72,11,,13,,,11,,,17,,,,,
     13,,,,81,98,78,63,33,,38,,,36,40,,,27,45,26,23,33,25,,,,,13],
   [,,,,,,,,,,,24,37,,,,19,25,,,33,,,,,,,,,,,,,,,,,,20,,40,,,,,15,25,,,,,40,,175,,
     190,112,197,128,31,,36,,28,27,,53,,,45,,,55,46],
   [,,,,,,,,,,,,,,,,28,,,,,,39,32,46,,,,,,40,42,,49,,,170,111,,,,,,,,,,,,,,,,,,,139,
     ,127,45,,,,45,25,48,85,,80,53,69,51,,53,,,25,,,,,27],
   [,,,,,10,,,,,,,,,,,,,,,,,,,,,,15,16,,,,,,,,20,23,,,,,,4,,,,,,,,,,,,28,34,,28,,,
     24,,27,25,24,,,12,15,15,12,15,15,16],
   [,,,,,29,72,,,,,,,,,,,,,,,,,,,,,42,,61,41,,65,,,,55,128,,,,,,11,,15,,,,,,,,,,77,
     ,121,77,,,56,,,59,83,,,11,,13,11,,13],
   [,,,,,10,,,,,,,,,,,,,,,,,,,,,,15,16,,,,,,,,20,23,,,,,,4,,,,,,,,,,,,28,34,,28,,,
     24,,27,25,24,,,12,15,15,12,15,15,16,,,,,,,,,4],
   [,,,,,14,36,,,,,,,,,,,,,,,,,,,,,23,17,32,22,33,,,,,32,39,,,,,,7,,,,,,,,,,,,44,
     51,59,42,,,31,,36,30,,,,20,24,20,18,24,21,,,16,12,,,15,17,28],
   [,,,,,24,,,,,,,,,,,,,,,,,,,,,,35,34,,,52,,,,,44,,,,,,,10,,,,,,,,,,,,60,95,,56,,,
     47,,63,53,,,,10,,12,10,,12,,,,,19,,,58],
   [,16,14,28,18,,22,,,,,,,,,,,,,,,,22,18,22,,,16,,22,18,22,22,26,,,20,26,6,
     ,8,,,4,,6,8,,,,,8,,32,,28,32,32,28,26,,24,,24,24,26,14,,12,,14,12,
     14,14,,,22,,14,,,24,28,4,,4,6,8],
   [,83,38,,,31,60,,,,,,,,,,,,,,,,75,45,89,,,42,38,84,43,58,,87,,,55,106,15,,,
     ,,11,,,,,,,,,,160,,77,128,123,77,70,,56,,72,56,70,21,,11,21,13,11,21,
     14,,,58,,28,,,36,,,11,,,13],
   [,,,,16,13,29,,,,,,,,,,,,,,,,27,23,25,,,22,17,23,,22,25,25,,,32,41,,,,,,7,,,
     ,,,,,,,54,,44,63,54,42,27,,29,,29,27,27,24,,20,,21,18,24,20,,,,,15,,,
     29,,,,,6,,6],[,,,,,24,42,,,,,,,,,,,,,,,,,49,53,,,35,31,65,41,47,,,,,44,,,
     ,,,,10,,,,,,,,,,86,,60,,86,56,71,,51,,56,50,,19,,10,19,13,10,19,12,,,,
     44,21,,27,37,,,13,,,8,8,13],
   [,,,,,25,100,,,,,,,,,,,,,,,,56,,,,,40,52,,46,54,65,,,,55,,,,,,,11,,15,,,,,,,,
     134,,77,,134,77,83,,58,,66,59,,21,,11,21,14,11,21,13,,,,,34,,,,,,11,,,
     13,,11],[,,,,,24,,,,,,,,,,,,,,,,,,,,,,35,34,61,64,65,,,,,44,,,,,,,10,,,,,,,,
     ,,89,,60,80,79,56,61,,54,,51,53,,19,,10,19,12,10,19,13,,,,,19,,,58,,,
     13,,,8,8,,,8,13],[],
   [,,,,29,32,34,,,34,,,,,,,23,41,,,44,,,,,,,22,28,26,,,,26,,,,97,,,,,,21,,20,
     54,,,,,47,,,,139,129,145,136,,,21,,,,21,,,54,54,56,53,,50,18,,,,,,,22,
     40,23,,23,,,,57,25,55,72,65],[],
   [,,,,21,,30,,,26,,,,,,,21,31,,,34,,,,,,,35,,37,,,,39,,,,131,,,,,,21,,19,29,,,,
     ,,,,,179,161,164,157,,,47,,,,45,,,45,49,,61,52,,,,,,,,20,,,,37,,,,16,39,
     19,27,41,49],[,,,,31,,37,,,37,,,,,,,21,41,,,58,,,,,,,19,32,24,38,35,
     23,24,,,125,91,,,,,,,,19,48,,,,,43,,,,148,125,146,132,,,26,,35,23,26,,,
     63,53,60,52,57,49,,,23,17,,,35,,24,,,,21,,24,,29,60,84,57],
   [,15,,27,15,,27,,,,,,,,,,15,,,,35,,16,30,24,,,16,30,24,32,25,23,25,,,69,
     61,,,28,,,,,13,27,,,,,28,,92,,94,83,88,81,25,,25,,25,23,25,37,,36,35,
     36,35,37,35,,,22,17,21,,16,,,14,,14,15,34,,,,33,59,34,,17,,15,17],
   [,21,36,33,22,36,21,,,18,20,25,34,,,,21,,,,41,,20,35,28,,,22,40,20,41,
     30,29,19,,,94,84,17,,33,,,21,,18,27,,,,,33,,132,,130,114,125,137,29,,
     21,,29,28,21,50,,48,48,47,53,53,47,27,,31,38,31,,23,35,39,21,56,21,
     21,37,16,,26,31,83,37,,21,,19,23],
   [,,,,21,,22,,,26,,18,24,,,,,47,,,,,,,,,,25,,31,,29,,29,,,123,105,14,,,,,15,,
     ,23,,,,,23,,132,,,131,129,95,,,37,,35,46,39,56,,36,69,37,37,,37,,,,,23,
     ,,,,,,,21,,,,22,35,,,,,,17,,13,17],
   [,,,,32,,37,,,37,28,30,43,,,,26,32,,,38,,,28,,,,24,,28,,,,28,,,128,118,25,
     ,33,,,,,22,34,,,,,,,155,,172,,165,147,27,,23,,26,22,23,64,,89,60,57,
     51,81,,,,28,24,59,,,,26,20,,20,25,49,30,52,23,52,56,52,,,,,23,20,25],
   [,,,,29,,34,,,34,,,,,,,21,49,,,,,,,,,,19,29,23,,,,23,,,,91,,,,,,21,,19,,,,,,
     44,,151,,149,125,151,134,,,25,,,,25,64,,54,53,63,54,,49,,,23,17,,,31,
     25,,,,,21,,,53,,,,46,,,,,17,17,21,,26],
   [,21,,33,,,18,,,21,18,,27,,,,21,36,,,31,,20,33,28,,,24,46,19,42,29,27,
     20,,,110,84,16,,29,,,,,18,23,,,,,29,,126,,134,114,132,131,29,,21,,29,
     27,21,48,,,48,46,53,53,43,25,,31,,31,,23,,39,21,43,21,21,41,18,48,
     22,35,49,41,,21,,19,,,15,17,24,21],
   [,,,,,,,,,,,,,,,,44,,,,74,,,,,,,,,119,217,,,,,,24,27,,,,,,25,,32,61,,,,,,,,,175,
     186,201,180,,,,,128,129,121,,,66,77,85,69,76,87,,,,,,,66,,214,29,,29,,,
     24,,,85,99,67,,119,,,,,,106,,,100],
   [,99,74,,97,71,,,,,38,43,55,,,,,,,,,,102,84,132,,,92,80,139,122,144,,133,,,
     ,28,36,,,,,24,,31,,,,,,49,,197,,179,202,,181,143,,133,,144,128,133,82,,
     65,81,77,75,77,79,71,,92,57,89,,70,106,115,26,107,26,,94,,,45,,140,
     63,,98,,,99,61,,103,,98,,38],
   [72,,,,,,,,,,25,32,37,,,,32,37,,,37,,94,100,121,,,77,293,134,,141,143,,,,20,
     ,25,,30,,,20,,25,30,,,,,30,,165,,140,,168,140,125,,119,,120,123,127,67,
     ,50,67,,50,67,,,,128,98,,,,,,20,55,20,32,44,20,55,32,44,55,44,,107,,
     189,105,75,100,,,121,104,27,24],
   [,,,,,24,,,,,,,,,,,17,28,,,,,,,,,,,21,,27,,33,,,,149,93,,,,,,18,,17,31,,,,,,,,,
     169,123,,126,,,,,,23,,,,43,50,45,45,,39,,,,,,,,18,31,,,,,,20,44,25,53,,,,,
     ,,,32,41,,32,37,37,,,187],
   [,,,,,28,57,,,65,,,,,,,17,,,,,,,,,,,44,34,,41,59,60,61,,,62,,,,,,,12,,14,,,,,,
     ,,,,86,147,155,84,,,58,,95,57,63,,,12,,14,12,,14,,,,,,,27,44,,,,,,,,13,,
     16,14,16,,,,,,,153,38,58,,53,,,62],
   [,,,,,10,30,,,,,,,,,,9,18,,,,,,,,,,15,14,,17,24,21,,,,37,40,,,,,,8,,8,17,,,,,
     ,,,,51,53,,49,,,21,,26,23,21,,,21,22,21,19,24,22,11,,,,,,9,18,24,7,,
     7,,,8,22,9,21,,,,18,,,,13,19,15,20,,19,42,39,37],
   [,,,,,27,,,,,,,,,,,22,27,,,79,,,,,,,34,21,45,35,47,21,,,,186,,,,,,,21,,19,,,,,
     ,60,,,,,157,272,130,,,43,,50,22,,,,51,55,52,48,105,48,,,,,,,,26,24,,,,,,
     22,51,31,,,,,,,,,33,39,,33,34,36],
   [,,,,62,25,43,,,,,,,,,,12,21,,,,,,,,,,38,33,53,38,49,57,,,,49,79,,,,,,11,,
     11,,,,,,,,,,67,,99,63,,,50,,,54,73,,,11,21,13,11,,13,,,,,,,21,40,,,11,,,,
     10,11,,11,11,11,,,,28,,,32,28,51,,39,,80,49],
   [,15,13,23,15,13,23,,,23,5,,13,,,,6,,,,13,,16,16,22,,,16,16,22,16,22,
     19,22,,,25,31,5,,13,,,5,,5,13,,,,,13,,39,,35,41,39,35,23,,23,,23,20,
     23,15,,13,15,15,13,15,15,13,,13,10,11,,9,16,16,7,17,7,9,11,,,9,11,
     17,11,,17,,15,17,11,,13,19,17,23,29,30,25,17,,7,19,9],
   [,51,,65,,31,55,,,,,,,,,,17,,,,,,,,61,,,45,39,97,43,57,60,,,,62,,,,,,,12,,
     14,,,,,,,,,,86,203,,84,63,,59,,76,57,,26,,12,25,14,12,26,15,,,,,37,,27,
     44,,,14,,,16,,,,16,14,,,65,,42,67,,,37,54,72,47,139,,62,,12,,,14],
   [,19,,,17,10,,,,,5,7,9,,,,7,9,,,9,,18,,23,,,15,14,20,17,,21,21,,,25,31,
     5,,11,,,5,,5,11,,,,,11,,39,,35,41,39,35,21,,23,,21,23,23,15,,11,15,
     13,11,15,13,11,,19,13,11,,,,,7,11,7,9,11,6,11,9,11,11,11,,20,,16,
     18,12,17,,,18,17,29,,25,,13,7,,9,5,13],
   [,,,,,25,,,,,,,69,,,,20,25,,,,,,,,,,,22,,28,,32,,,,,103,,,62,,,19,,17,27,,,,,,,
     ,,180,131,,134,40,,41,,40,23,42,93,,46,51,48,48,,44,,,22,22,,,,,31,,,,
     27,,22,52,28,59,,,,31,,,34,32,43,,,40,41,265,119,,,,,22,,19],
   [,,,,13,10,18,,,,,,,,,,9,18,,,,,18,19,21,,,15,13,19,19,21,22,21,,,37,38,,
     ,17,,,8,,8,,,,,,17,,55,,51,52,55,49,21,,21,,21,22,21,24,,21,22,22,19,
     ,21,,,13,10,11,,9,14,,7,,7,9,21,8,22,,,,21,,17,,15,17,11,15,13,21,
     17,15,38,38,37,19,,7,,,7,,7,22],
   [,,,,,25,51,,,,,,,,,,12,21,,,,,50,,,,,38,33,,43,49,57,,,,49,78,,,,,,11,,11,,,
     ,,,,,114,,67,,114,63,73,,51,,54,54,,19,,11,19,14,11,19,13,,,,,28,,21,
     40,,,11,,,11,10,11,,,11,11,,63,,30,67,33,37,29,51,,45,81,96,49,,14,,,
     9,9,14,9],[,,,,,27,,,,,,,,,,,22,29,,,,,,23,,,,31,21,47,35,46,23,,,,,
     124,,,32,,,21,,19,46,,,,,,,278,,223,,330,130,,,45,,52,23,,,,51,55,53,48,
     ,48,,,,,,,,26,,,,,,,22,51,,,,,,,,,31,,45,,31,,39,232,123,193,23,,,17,,19,,
     ,23],[,,,,,26,53,,,,,,,,,,17,,,,,,,,86,,,44,36,59,46,57,60,61,,,62,123,
     ,,,,,12,,14,,,,,,,,148,,86,,161,84,93,,57,,,57,78,26,,12,25,15,12,26,
     14,,,,,37,,27,44,,,14,,,16,,13,,,,16,,,,48,,,,38,58,,,,123,62,,12,,,14,,
     12,13],[,,,,62,25,44,,,,,,,,,,12,21,,,,,,,,,,38,33,71,40,49,57,55,,,49,
     ,,,,,,11,,11,,,,,,,,114,,67,96,,63,73,,51,,60,54,58,19,,11,19,13,11,
     19,14,,,,,22,,21,40,,,11,,,11,10,11,,11,11,,,,,34,,,33,28,51,,36,104,,
     49,,14,,,9,9,,9,,,9,,14],
   [,,,,154,104,,,,,,,,,,,53,73,,,76,,,,,,,127,160,162,,166,175,157,,,166,,,,,,,
     33,,42,,,,,,64,,,,31,34,35,31,,,167,,167,167,163,,,,103,107,87,102,105,
     106,,,,,,78,,,37,,37,,,32,111,54,83,123,99,,148,,,,89,,154,160,172,126,
     191,195,170,,,56,,,39,,39,217,,99,271,136],
   [,123,91,172,121,88,175,,,176,44,53,85,,,,63,76,,,79,,123,104,170,,,,104,
     162,,176,246,,,,166,190,44,,64,,,32,,41,83,,,,,,,35,,35,35,34,31,175,,
     173,,178,176,173,104,,85,103,102,90,102,103,89,,112,77,,,,,133,34,111,
     34,57,,,,53,80,,,,131,,149,129,83,,131,156,129,131,196,190,,129,156,53,
     151,89,39,,39,134,52,,150,152,90,40],
   [84,124,,,,,,,,,35,44,51,,,,44,51,,,51,,120,125,155,,,107,,160,286,185,167,
     155,,,140,179,35,,42,,,28,,35,42,,,,,42,,32,,28,32,31,28,165,,161,,162,
     163,,93,,70,93,100,70,93,95,99,,151,,152,,,,,28,77,28,44,60,28,77,44,
     60,77,60,,139,,176,,,128,,,147,,,181,140,213,86,51,183,67,35,86,35,,
     51,67,183,86,67,35,32],[],[],
   [,,,,40,,48,,,48,,,,,,,27,48,,,,,,,,,,23,38,29,51,25,23,29,,,122,117,,,,,,
     25,,25,44,,,,,50,,,,165,158,172,,,,31,,26,24,31,,,62,67,69,63,68,61,29,
     ,,,,,41,32,30,27,,27,,,24,80,33,54,,59,,27,,,,28,,35,31,24,35,135,
     135,122,,,21,,,23,63,23,43,21,73,39,91,54,175,173,167],
   [,27,,27,27,,27,,,23,29,27,,,,,27,43,,,52,,26,51,24,,,26,51,24,58,24,
     27,23,,,127,107,26,,46,,,26,,23,39,,,,,46,,166,,165,145,163,145,25,,25,
     ,25,28,25,66,,62,61,64,63,66,59,40,,40,31,41,,30,43,,28,,28,27,56,,,
     ,49,82,56,,30,,29,28,19,,24,31,28,23,127,107,130,54,79,25,53,,19,,
     22,53,19,52,,131,66,164,145,165,,,28],
   [,,35,,35,67,40,,,40,28,31,39,,,,31,40,,,41,,,40,,,,27,,31,58,28,,31,,,
     120,123,25,,40,,,24,,25,37,,,,,34,,173,,165,168,178,174,,,26,,22,25,26,
     72,,58,70,70,62,70,,32,,,35,66,,,,36,25,61,25,29,56,24,62,28,53,62,
     50,,30,,60,32,28,31,,,29,32,128,140,121,42,63,25,43,53,25,61,22,,22,
     54,41,63,54,,179,165,,,26,28],
   [,,39,,18,,23,,,23,21,23,39,,,,21,38,,,,,,40,21,,,19,38,23,46,21,24,23,,
     ,93,84,19,,37,,,17,,18,33,,,,,37,,124,,,114,126,121,21,,25,,21,24,25,
     51,,47,48,51,51,49,47,28,,31,28,31,,23,30,,21,55,21,21,45,18,50,,,,
     45,,26,,25,26,19,23,20,,24,23,96,93,93,43,81,19,43,43,17,,17,42,15,,
     ,,43,124,122,124,,,21,19,23],
   [32,29,58,,35,39,40,,,40,24,30,52,,,,32,,,,,,26,54,25,,,24,45,28,50,28,
     25,28,,,133,126,24,,,,,28,,25,,,,,,56,,171,,177,169,170,174,25,,30,,28,
     25,30,68,,67,70,65,64,73,65,32,,35,38,42,,46,35,,27,74,27,30,,26,72,
     ,,,74,,30,,,29,27,31,45,34,,31,127,144,,56,86,24,55,66,25,69,25,55,,,
     ,,67,171,181,,,,24,27,29],
   [32,27,,27,29,48,23,,,27,29,27,37,,,,27,33,,,37,,26,47,24,,,27,45,23,,
     24,27,24,,,123,107,26,,38,,,26,,23,29,,,,,38,,,,162,145,164,145,25,,25,
     ,25,28,25,65,,55,61,61,59,65,55,38,,40,31,41,,30,41,43,28,57,28,
     27,48,24,51,27,39,57,48,,30,,29,28,19,23,24,32,28,,129,107,124,48,
     55,25,48,46,19,55,22,50,19,46,48,57,46,164,145,162,,,,19,27,19,27],
   [,,,,45,30,70,,,,,,,,,,24,13,,,13,,,,,,,43,42,58,,64,69,66,,,54,63,,,,,,12,
     ,16,12,,,,,12,,,,74,86,87,70,,,62,,64,63,62,,,12,13,14,12,13,14,38,,,,
     ,,23,56,,10,,10,,,12,23,19,14,23,14,,55,,,,36,49,,56,56,49,68,66,54,,
     ,19,,,17,28,15,84,19,19,85,28,19,88,86,74,,,64,62,65,49,67,58],
   [,47,37,71,49,37,65,,,71,15,20,,,,,,18,,,18,,50,45,67,,,49,45,67,55,69,
     ,65,,,67,80,15,,,,,13,,15,15,,,,,15,,103,,93,104,102,93,68,,69,,68,64,
     ,13,,13,14,15,13,14,16,36,,,37,36,,45,51,49,15,21,15,24,19,,,24,19,
     21,,,53,,49,53,35,,,61,55,53,78,77,67,51,25,22,55,19,15,,15,54,22,
     19,56,25,21,102,,93,,,68,61,73,50,76,61,15],
   [36,49,,110,39,16,,,,110,15,20,8,,,,20,8,,,7,,43,24,51,,,23,23,43,28,
     34,47,51,,,30,51,13,,6,,,6,,13,6,,,,,6,,59,,42,67,59,42,43,,35,,41,
     36,43,14,,12,14,14,12,13,14,33,,41,32,19,,,,,10,21,10,12,14,8,21,
     12,14,21,14,,37,,27,39,25,31,,,43,27,47,47,30,,26,15,37,17,11,26,9,
     ,15,17,,26,17,59,59,42,,,41,41,36,33,52,35,10,14],
   [28,,,59,37,30,50,,,59,18,24,,,,,24,13,,,13,,46,47,55,,,43,39,53,51,57,
     58,55,,,54,66,16,,,,,12,,,12,,,,,12,,86,,74,86,86,70,59,,59,,59,60,59,
     15,,12,13,15,12,13,14,38,,39,30,29,,23,42,,10,23,10,19,14,12,23,,,,
     14,,49,,37,49,33,43,37,57,49,43,63,68,54,47,28,19,69,19,17,28,15,
     50,19,,,,19,87,86,74,,,59,53,62,43,,49,10,15,10],
   [24,44,,62,,,73,,,80,15,21,,,,,20,18,,,18,,46,,60,,,49,60,61,56,65,65,,,,
     67,,15,,,,,13,,15,15,,,,,15,,102,,93,105,,93,68,,68,,66,69,70,13,,13,
     14,16,13,14,15,,,54,40,42,,,55,,15,21,15,24,19,14,21,,,,19,,,,51,57,
     36,53,58,69,,53,76,80,67,,26,24,,19,15,26,15,93,,,,,19,102,102,93,,,
     70,65,72,,70,65,15,13,14],
   [24,41,,58,31,16,28,,,58,15,18,8,,,,18,7,,,8,,41,41,49,,,23,21,41,26,
     32,53,49,,,30,55,13,,6,,,6,,13,6,,,,,6,,61,,42,63,59,42,45,,37,,43,
     30,45,14,,12,13,14,12,14,14,33,,31,26,19,,13,24,38,10,21,10,12,14,
     8,21,12,14,21,14,,35,,25,37,23,31,19,31,39,,49,43,30,25,24,15,33,
     17,11,24,9,48,15,17,27,24,17,61,59,42,,,43,35,38,31,50,29,10,14,6,
     10,14],[28,63,,78,,30,70,,,,18,24,,,,,,13,,,13,,47,,66,,,43,42,59,74,
     63,62,61,,,54,66,16,,,,,12,,16,12,,,,,12,,89,,74,98,89,70,62,,63,,62,
     63,,15,,12,13,14,12,13,15,38,,,37,27,,23,56,64,10,23,10,19,14,12,,
     19,14,23,,,54,,59,53,36,49,,60,55,49,66,63,54,,28,19,,19,17,,15,84,
     19,19,82,28,,89,86,74,,,62,62,65,49,67,58,10,,10,10,15,10]],
 [,[],[],[],[,27,,32],[,,16],[,26,,43],[,,22],[,,,,36,,33],
   [,,,37,,,38,,61],[],[,24,,,,19,31,27],[,,22,,,,92],[],[],[],
   [,,24,,,,42,,,,,10],[,,24,79,,30,47,42,85,,,,11],[],[],
   [,,,,,,92,,,,,,11,,,,,11],[],[36,,,,35,,46,,,50,46,,,,,,,82,,,82],
   [,,,,,27,,37,,,,,,,,,31,39,,,55],
   [,33,,,42,58,41,,63,73,,39,,,,,47,68,,,63],[],[],
   [,35,36,58,,,,,46,,28,35,40,,,,35,40,,,40,,34,,31],
   [,,26,,,,,,,,,27,,,,,41,43,,,,,,21],
   [,46,,57,25,,,86,59,50,,43,,,,,,,,,,,33,,42],
   [,,32,,,,,,,,,35,,,,,49,51,,,,,,27],
   [,,,,42,,55,,,59,63,53,85,,,,57,64,,,83,,,,,,,43,,40],
   [,,42,116,45,43,,60,119,,80,37,116,,,,,,,,116,,57,30,49,,,,28,36,36,62],
   [,40,,73,,,36,,51,,,46,94,,,,52,64,,,,,,,36,,,,,37,,52,54],
   [,,,,,,288,236,,,53,,,,,,64,,,,67,,202,,,,,,218,,,331,221],[],
   [,152,,,,,,234,,,35,44,49,,,,44,49,,,49,,,194,191,,,100,,,,,162,199,39],
   [],[18,,,,,14,52,20,,,14,,,,,,17,22,,,,,30,,,,,26,22,,28,53,34,40,84,,64 
    ],[,,,,24,,39,,,39,,,,,,,35,59,,,,,,,,,,46,,43,,,83,47],
   [,,,,,33,84,46,,,,,,,,,,18,,,18,,,36,,,,52,42,,49,95,,,,,69],[],[],
   [,31,14,,,,,,,,14,15,16,,,,15,16,,,16,,,23,36,,,20,,,,,35,36,,,45,,12,,13]
    ,[,36,,33,,,,,41,28,,39,,,,,37,57,,,,,42,,53,,,,,,,51,160,50,658,,,,,43],
   [,19,18,40,,16,24,24,26,,14,17,22,,,,,,,,22,,42,25,31,,,26,25,,31,41,,
     31,76,,64,,14,26,,,,12,28],
   [,,34,,,33,84,46,,,,,18,,,,,,,,18,,,,88,,,52,44,,53,101,,87,139,,69,,,,15,,
     ,13],[,,18,,,,,,,,20,21,22,,,,21,22,,,22,,48,29,58,,,,32,50,,,44,,,,,,
     16,,17,,,,,16,17],
   [,,,,28,,29,,,41,,,,,,,35,55,,,,,,,48,,,38,,47,,,57,47,364,,365,,,,,,,,37,26 
    ],[],[,28,,39,,,34,,37,,,48,,,,,35,59,,,,,44,,45,,,,,36,,53,104,,,,242,
     ,,27,,,,,38,26,,,39],
   [,,,,,33,84,46,,,,,18,,,,,18,,,,,,40,,,,52,42,,49,95,,,,,69,,,,15,,,13,,,15,
     17],[],[],[],[,,122,508,,,,,,,49,60,67,,,,60,67,,,67,,,191,,,,140,
     ,,,331,211,260,243,,175,,88,280,95,,,63,,88,95,121,328,,358,95],
   [258,259,126,278,,134,208,182,314,306,,80,89,,,,,,,,,,268,169,279,,,264,
     155,243,207,291,252,259,263,,237,,100,222,154,,,87,206,102,,117,214,,
     198,168,,,,49],[194,,138,,,,,,,,61,86,89,,,,,,,,85,,224,277,316,,,,,295,,
     ,291,322,277,,231,,102,370,168,,,83,622,100,169,121,,,,,,,,43,53],
   [150,137,114,226,105,102,154,154,208,228,49,56,67,,,,56,67,,,67,,210,147,
     225,,,140,131,189,191,289,,225,253,,175,,84,182,95,,,63,198,84,95,95,
     184,,184,95,,,,35,45,43],
   [68,,,,54,,67,,,87,64,,,,,,71,86,,,90,,44,,,,,51,59,50,,74,52,66,281,,,,45,
     ,,,,46,72,51,101,66,,,68,84,,,,309,334,339,308],[],
   [,60,60,96,,,,,74,88,49,50,72,,,,51,68,,,61,,57,59,54,,,32,,,91,70,44,
     47,243,,174,,45,68,74,,,33,,41,74,66,61,,63,77,,,,238,298,309,244,51],
   [,77,50,107,63,53,66,72,87,174,57,42,75,,,,,,,,75,,,41,63,,,50,42,57,
     54,63,64,,230,,191,,39,69,92,,,39,75,41,,50,74,,69,,,,,247,258,294,
     230,40,,46],[,,70,,60,,59,,,109,64,,,,,,57,88,,,,,,,100,,,45,63,58,,,
     56,54,293,,251,,51,,121,,,46,80,43,92,50,,,68,84,,,,309,336,345,302,,,
     45,50],[80,61,44,96,45,45,50,63,80,90,56,39,70,,,,50,49,,,70,,57,
     34,52,,,35,33,40,43,72,,50,243,,161,,36,76,70,,,37,86,33,70,47,76,,,
     70,,,,211,,283,175,45,,35,,43],
   [80,88,68,90,,63,62,119,98,,,61,114,,,,,98,,,,,51,61,74,,,50,,45,101,62,
     52,,269,,,,49,68,,,,41,67,57,,,71,,,,,,,316,342,,308,45,,46,40,61,45],
   [,,,,,18,48,,,,7,,,,,,13,9,,,9,,46,,,,,28,,,,53,65,,53,,35,,14,,,,,12,68,
     14,14,18,44,,,14,,,,49,,61,49,60,,45,49,60,44],[],
   [,29,14,,,,,,,,7,8,9,,,,8,9,,,9,,,22,37,,,20,,,,,31,33,33,,25,,12,,13,,,
     9,,12,13,,,,,13,,,,35,,45,35,41,,36,37,41,34,44,7],
   [,21,22,52,,18,28,32,,,7,13,9,,,,,,,,9,,48,25,35,,,28,29,49,39,,,35,49,
     ,35,,14,36,14,,,12,36,14,,18,32,,36,14,,,,49,61,,49,59,,45,43,63,35,
     63,7,,7],[],[22,19,14,35,15,12,23,22,31,35,7,8,9,,,,8,9,,,9,,
     30,19,32,,,20,17,28,27,46,,32,35,,25,,12,31,13,,,9,,12,13,15,25,,31,
     13,,,,35,45,43,35,46,,36,33,44,25,46,7,,5,7],
   [,31,18,,,18,48,,,,7,13,9,,,,13,9,,,,,,47,43,,,28,,53,,67,65,,49,,35,,14,
     ,14,,,12,68,14,14,18,44,,,,,,,49,61,61,49,59,,48,49,59,44,66,7,,7,7,
     ,7],[],[,,,,,,,,,,,,,,,,36,,,,,,,,,,,,,,,,44,,,,,,,,,,,30,,21,55,,,,,,,,,
     179,223,,137,,,51,73,,40,,,,28,21,,19],
   [,,,,,,,,,,,,,,,,19,34,,,,,,,,,,40,,,,,78,74,,,78,,,,,,,,,16,,,,,,,,,,102,122,
     132,104,,,61,55,,68,63,,,12,22,,18],
   [,,,,,,,,,,,,,,,,,81,,,,,,,,,,,,,,,42,,,,,,,,,,,,,47,,,,,,,,,,,264,592,224,,,,30,,
     35,,,,,51,,33],[,,,,,,,,,,,,,,,,,,,,,,,,,,,,19,53,,,,,,,,,,,,,,,,,,,,,,,,,,146,,
     ,105,,,42,38,,30,58,,,24,,,15],
   [,,,,,,,,,,,,,,,,27,42,,,,,,,,,,,,,,,95,,,,274,,,,,,,,,24,,,,,,,,,,214,184,,,,,,
     109,,100,93,,,,32,,22],
   [,,,,,,,,,,,,,,,,,75,,,,,,,,,,,40,95,61,,32,,,,,,,,,,,,,37,76,,,,,,,,,843,280,,
     232,,,,45,,33,,,,,51,,35],
   [,,,,,,,,,,,24,22,,,,,24,,,,,,,,,,36,,58,,,87,54,,,,,18,36,26,,,14,38,16,28,
     22,36,,36,34,,,,122,126,138,114,,,62,58,,72,86,,,14,22,,14,18,,,16,,,
     22],[,,,,,,,,,,,46,92,,,,37,43,,,92,,,,,,,,,,,,36,,,,261,,40,,54,,,,,31,
     48,,,,,60,,,,261,206,526,160,54,,46,30,60,25,54,56,,,31,,23,56,,,,30,,,
     41],[,,,,,,,,,,,,,,,,,,,,,,112,,105,,,,,,,,44,108,,,,,,,,,,,,47,,,,,,87,,,,,
     246,,222,71,,69,41,83,35,71,,,,55,,31,,,44,,35,,,46],
   [,,,,,27,,38,,,,,,,,,,,,,,,,,,,,40,32,,39,87,,,,,55,,,,,,,11,,,,15,,,,,,,,77,
     130,,77,,,54,,70,56,70,,,11,13,,11,13,,29,,,,,,28,60,61],
   [,,,,,12,,,,,,,,,,,,,,,,,,,,,,20,,,,,33,58,,,25,,,,,,,10,58,16,,16,34,,,,,,,35,
     47,47,35,,,36,41,,34,42,,,5,,,5,,,,12],
   [,,,,,12,,,,,,,,,,,,,,,,,,,,,,20,,,,,33,58,,,25,,,,,,,10,58,16,,16,34,,,,,,,35,
     47,47,35,,,36,41,,34,42,,,5,,,5,,,,12,,,,,,,,,5],
   [,,,,,17,38,24,,,,,,,,,,,,,,,,,,,,28,20,37,27,65,,,,,37,,,,,,,9,67,,,13,34,,,,
     ,,,51,121,82,51,,,39,48,63,34,,,,8,,,8,,,,,,,,,24,28,39],
   [,,,,,22,,36,,,,,,,,,,,,,,,,,,,,40,,,,60,77,,,,49,,,,,,,22,50,30,,22,50,,,,,,,
     67,97,,67,,,65,71,86,58,,,,11,,,11,,,,,,,30],
   [,25,28,,,,32,,,,,,,,,,,,,,,,,37,43,,,42,,55,,59,66,52,95,,55,,18,45,15,,,
     11,38,18,17,17,43,,42,15,,,,77,134,134,77,72,,56,50,82,51,95,13,,11,,
     ,11,13,,,28,,,38,,,60,,11,,,15],
   [,27,18,34,15,14,22,18,34,34,,,,,,,,,,,,,28,23,39,,,20,19,27,23,35,25,
     39,33,,25,,14,24,,,,10,26,,,14,26,,24,,,,,35,43,47,35,42,,34,34,46,
     25,42,9,,5,9,,5,9,,,12,34,15,18,34,18,22,34,,5,5,7,9],
   [,,24,,17,17,28,,,,,,,,,,,,,,,,49,31,50,,,27,,29,,55,32,41,54,,37,,18,25,
     21,,,9,29,18,21,15,26,,27,21,,,,51,82,76,51,54,,41,38,64,33,48,,,8,,
     ,8,,,,16,,,24,,,40,,15,,,7,,,7],
   [,,42,,,22,40,34,,,,,,,,,,,,,,,,51,,,,40,41,73,43,55,,,79,,49,,30,50,,,,22,
     42,,,24,40,,52,,,,,67,95,99,67,101,,65,91,109,49,,,,11,,,11,,,,34,,,32,
     ,42,43,,,,,,9,,9],[,,,,25,12,48,18,,,,,,,,,,,,,,,28,,35,,,20,21,35,25,
     35,30,,37,,25,,,50,,,,10,36,14,,14,,,52,,,,,35,43,43,35,44,,32,34,44,
     31,,9,,5,9,,5,9,,,18,,20,18,,,,,,5,5,7,9,,5,7,9],
   [,,,,,22,,30,,,,,,,,,,,,,,,,,,,,40,,67,61,61,77,,63,,49,,,,,,,22,84,30,,22,
     50,,,,,,,67,85,97,67,91,,68,71,87,58,,,,11,,,11,,,,,,,42,,,,,,,,,9,,9,,
     9,9],[,,,,23,,24,,,34,,,,,,,27,43,,,,,,,,,,31,,40,,,61,40,,,169,,,,,,,,
     30,21,,,,,,,,,,213,159,587,133,,,55,64,,67,63,,,,29,,17,,,,,,,,,26,,,,,,,,
     31,19,21,43,22],[,,,,51,61,52,,,114,,,,,,,44,56,,,77,,,,,,,38,45,49,,,
     49,47,,,,,,,,,,37,75,36,74,72,,,59,67,,,,263,297,349,231,,,38,51,,36,,,,
     41,38,,32,,,35,,,,,,,40,51,43,,,,,,39,60,,37],
   [,,,,,,42,60,,,,,,,,,,60,,,,,,,,,,28,48,33,,,,37,,,186,,,,,,,,54,,107,32,,,48,,
     ,,,242,284,252,216,,,44,51,55,55,56,,,30,48,,30,42,,,46,,,,,36,,,,38,
     38,,,,,65,,,78],[,,,,31,,44,,,40,,,,,,,35,51,,,,,,,,,,57,,54,,,100,66,,,,,
     ,,,,,,30,29,,,,,34,,,,,396,205,472,193,,,95,90,,,87,,,,39,,27,,,,,,,,,32,,,
     ,,,,,37,23,29,43,25,67],
   [,,,,39,,46,,,,,,,,,,52,,,,,,,,,,,31,36,34,,,29,40,,,,,,,,,,,71,44,85,58,,,55,
     ,,,,224,297,329,195,,,35,42,,30,47,,,32,62,,28,68,,,,,27,,,68,37,50,,,,
     29,,,27,38,,32,90],
   [,27,,51,27,,51,,87,87,54,,74,,,,33,,,,72,,34,69,50,,,34,51,50,71,66,
     37,66,195,,159,,43,51,63,,,29,51,25,63,41,47,,47,63,,,,203,,217,,59,,
     59,41,75,38,75,46,,28,,,,54,,73,43,84,49,57,82,40,54,84,49,36,36,
     35,60,,,,,29,58,33,39,56,39,43],
   [,26,62,46,35,58,26,,,32,42,29,68,,,,35,,,,58,,33,67,45,,,38,53,33,91,
     63,38,33,212,,163,,34,44,60,,,32,30,26,60,48,42,,26,52,,,,211,244,
     260,294,54,,38,42,72,39,42,34,,30,28,,34,34,,51,46,64,51,60,94,42,
     54,64,40,38,38,38,66,32,,,,32,66,30,38,53,36,40],
   [,,,,31,,28,,,52,,28,,,,,,33,,,,,,,,,,37,,50,,57,112,42,293,,199,,29,31,47,,
     ,23,28,21,41,35,31,,26,39,,,,,167,225,153,,,62,67,83,73,80,,,22,29,,
     19,,,,27,,,37,,,,,37,,,31,,,23,35,51,,,21,,,27,,31,30],
   [,,,,59,,,,,102,70,72,113,,,,63,70,,,83,,,59,,,,,,53,73,,,71,,,769,,56,,73,,
     ,,83,52,77,,,,79,,,,,,357,501,,77,,44,51,67,46,50,60,,,58,,,,,73,,66,
     60,,61,,,,94,,,45,74,107,39,69,64,41,124,,51,,,48,61,60],
   [,,,,49,,52,,,114,,,65,,,,42,76,,,,,57,42,67,,,35,40,38,70,,57,44,361,,,,
     39,,74,,,42,75,36,,,,,59,61,,,,273,281,339,231,54,,39,40,66,36,45,47,,
     36,38,,32,,,40,96,51,49,,64,52,,,43,66,66,50,,,35,60,,,,,36,,,35,41,
     38],[],[],[,145,112,224,,132,176,,264,,,92,69,,,,,81,,,,,,145,233,,
     ,182,137,249,191,341,,231,39,,39,,82,186,171,,,75,204,88,,99,232,,190,,
     ,,,271,295,357,,296,,280,228,324,195,304,,,,51,,35,53,,155,116,262,161,
     174,268,112,200,242,97,43,43,,69,,,77,,,,145,233,,175,233,191,,131,303,
     257],[,,,,,88,,194,,,35,44,49,,,,44,49,,,49,,174,158,201,,,100,293,149,
     ,,162,,,,25,,64,,69,,,45,,64,69,,282,,,69,,,,175,235,249,175,232,,171,
     189,254,161,229,35,,25,35,,25,35,,,76,,,,,,,,55,25,25,37,49,55,25,37,
     49,25,49,,200,,,172,151,152,,,224,,,37],
   [,,,,,43,,58,,,,,,,,,39,47,,,,,,,,,,,34,,44,,38,,,,239,,,,,,,35,,35,72,44,,,,
     68,,,,295,236,426,202,,,,34,,29,,,,33,39,,27,,,,,,,,,,30,35,,,,,,52,30,
     40,67,,,,,,,,82,72,,58,49,,,204,315],
   [,,,,20,13,22,23,,39,,,,,,,8,,,,,,,,,,,23,19,30,29,41,28,35,,,30,,,,,,,11,
     28,13,,17,29,,23,,,,,42,58,58,42,,,37,34,,29,48,,,6,,,6,,,,,,,,,16,30,,,
     ,,,,,7,,,7,,18,,,,,,,20,56,,,,86,30],
   [,,,,,12,32,18,,,,,,,,,11,30,,,,,,,,,,20,18,,24,39,27,44,,,42,,,,,,,10,54,
     12,,14,30,,,,,,,58,78,78,58,,,33,33,39,28,39,,,9,18,,9,,,,12,,,,,14,28,
     ,,8,8,,,22,9,10,22,9,,,,28,,,33,36,21,46,54,,,70,42],
   [,,,,,43,,58,,,,,,,,,45,43,,,88,,,,,,,54,30,,38,108,28,77,,,323,,,,,,,35,,35,
     ,44,,,,53,,,,,230,509,202,,,73,37,,29,97,,,33,39,,27,82,,,,39,,,,,33,34,
     ,,,,,52,30,40,67,,,,,,,,76,74,,61,46,,,202],
   [,,,,60,23,41,33,,,,,,,,,14,,,,,,,,,,,43,37,59,41,59,60,100,,,54,,,,,,,23,
     43,23,,23,46,,66,,,,,74,,114,74,,,68,56,,53,121,,,12,,,12,,,,,,,,,28,50,,
     ,,,,,,11,,12,11,12,,,,40,,,,36,78,,,,119,54],
   [,21,16,41,27,16,35,24,51,43,14,,22,,,,17,,,,24,,28,21,40,,,26,21,42,
     29,50,26,40,76,,64,,12,39,24,,,12,39,14,24,18,37,,39,26,,,,88,106,
     102,84,49,,47,30,57,27,49,14,,12,14,,12,14,,19,18,28,21,24,42,18,
     26,28,18,16,16,18,30,,,,,14,30,25,33,38,31,35,,,25,47,33,,,80,64,28,
     ,16,28],[,36,,33,16,15,24,19,31,,,,,,,,8,,,,,,43,,33,,,23,21,27,25,
     36,27,,47,,30,,,23,,,,11,,13,,15,26,,28,,,,,42,63,,42,43,,35,31,43,29,
     ,14,,6,14,,6,14,,,15,,21,21,39,16,28,,,8,8,10,12,,,10,12,7,12,22,
     47,32,26,32,,,21,43,47,,,,30,,6,8,,10],
   [,,,46,19,12,,18,54,,14,10,22,,,,10,22,,,22,,36,,38,,,20,18,26,24,,27,
     34,48,,30,,14,24,26,,,10,26,14,26,14,24,,24,26,,,,42,64,60,42,40,,
     34,32,44,28,42,12,,6,12,,6,12,,28,12,56,18,18,48,,,56,18,8,8,10,
     12,18,7,10,12,7,12,18,40,32,24,28,28,30,,,36,,,72,30,,6,8,,10,14,6 
    ],[,,,,,43,,58,,,,,88,,,,41,51,,,,,,,,,,,34,,44,,40,,,,,,,,68,,,35,,35,,44,
     ,,,,,,,291,230,,204,64,,62,34,72,29,66,82,,33,35,,27,,,,,32,,,45,,,39,,,
     ,,,50,30,40,67,,,,46,,,53,74,62,,,74,,,188,,34,,,37,,30],
   [,,22,,15,12,20,22,28,36,20,,30,,,,11,,,,30,,36,27,35,,,20,17,25,27,35,
     24,33,56,,42,,16,22,30,,,10,24,12,30,16,22,,22,30,,,,58,84,78,58,46,
     ,32,28,40,25,42,18,,9,,,9,18,,29,12,38,15,18,36,14,22,38,22,8,8,
     10,22,,9,,,9,22,17,41,34,23,27,,,19,43,41,,,70,42,34,,8,34,,,8,8,34 
    ],[,,,,,23,49,35,53,,,,,,,,14,,,,,,89,,96,,,43,37,,45,57,60,,,,54,,,66,,,
     ,23,47,23,,25,41,,,,,,,74,110,153,74,115,,69,58,80,53,,,,12,,,12,,,,,,,
     39,,28,50,,,,,,12,,11,,,11,12,57,104,71,46,82,,,37,68,108,,,140,54,,,,,
     10,,10,10],[,,,,,43,,58,,,,,,,,,45,45,,,,,140,30,117,,,54,30,,38,108,
     30,,433,,,,,,51,,,35,,35,70,44,,,,,,,,363,232,582,200,69,,65,35,75,29,
     67,,,33,39,,27,,,53,,37,,,42,,33,,62,,,,,52,30,40,67,,,,51,,,50,82,72,,
     91,,,,202,315,29,,,34,,28,,,,34],
   [,,,,19,13,21,19,31,,,,,,,,8,,,,,,,,33,,,23,19,27,25,35,28,44,51,,30,,,40,
     ,,,11,25,13,,15,,,27,,,,,42,,61,42,43,,35,31,43,29,56,14,,6,14,,6,14,
     ,,21,,21,21,39,16,28,,,8,8,10,12,,7,10,12,,12,18,,32,24,34,34,,20,
     44,,,,,30,,6,8,,10,,6,6,,8,10],
   [,,,,60,23,42,31,,61,,,,,,,14,,,,,,,,75,,,43,37,76,43,55,60,63,102,,54,,,,,
     ,,23,46,23,,23,46,,49,,,,,74,,,74,103,,69,56,95,53,82,,,12,,,12,,,,,,,
     45,,28,50,,,,,,12,,11,,12,11,,,,,46,,,,36,72,,,,,54,,,,,10,,10,10,,,10,,
     10],[,,,,,,,242,,,,,,,,,80,89,,,85,,,,,,,188,,,,343,303,393,,,,,,,,,,83,,
     104,,121,488,,304,145,,,,41,55,51,41,,,303,296,353,289,345,,,43,67,,43,
     61,,,,,,,,,,,,47,47,,,111,43,,93,47,81,,,246,,,235,262,303,448,345,,,,243,
     ,,78,,,102,,60,412,78,118,383,59,110],
   [,191,164,292,,158,292,222,302,330,65,108,99,,,,120,87,,,81,,256,175,297,,
     ,208,183,267,225,323,,283,295,,245,,106,230,149,,,85,236,112,,121,232,,
     230,,,,,,55,49,43,372,,334,274,376,235,422,63,,45,65,,45,,,213,124,290,
     167,182,330,164,232,304,,53,53,85,,,,85,91,47,,179,289,284,221,281,,,
     169,387,297,,,,,254,98,86,246,139,104,,76,240,86,,248,74,199,59],
   [342,,,500,181,,232,,,,49,60,67,,,,60,67,,,67,,224,192,239,,,140,,198,,317,
     211,236,243,,175,,88,372,95,,,63,,88,95,131,,,281,95,,,,35,,41,35,299,,
     238,245,307,211,,49,,35,49,,35,49,,185,102,406,,,524,,,,77,35,35,51,
     67,77,35,51,67,35,67,,262,244,323,,197,200,,,257,,,277,175,367,42,58,
     295,74,88,42,42,,58,74,295,42,74,49,47],
   [406,,124,,,132,192,,286,,65,86,85,,,,,87,,,89,,288,167,263,,,210,157,,205,
     335,342,265,267,,237,,102,196,154,,,83,216,108,158,117,196,,198,,,,,41,
     55,,41,342,,294,254,340,,338,63,,43,67,,43,61,,181,120,262,,186,288,
     124,222,272,,53,53,73,,134,,,,43,95,157,271,326,215,273,,236,167,357,
     293,,,,231,228,64,84,232,118,102,59,64,232,78,,228,63,,43,59,49],
   [218,386,,598,,,392,284,,,67,89,,,,,80,,,,89,,236,,279,,,192,292,,,378,291,
     365,297,,233,,108,304,151,,,,448,100,220,117,,,,,,,,41,51,49,,345,,313,
     292,339,287,369,67,,,67,,43,61,,,,657,,,,,402,,111,47,47,73,85,118,43,,
     81,,97,,363,246,661,290,225,240,,461,,,,349,,366,,78,,116,100,59,60,,
     78,116,,,151,53,49,43,59],
   [,,,,56,,59,93,,109,,,,,,,54,86,,,,,,,,,,42,58,45,,,40,51,,,226,,,,,,,,80,
     43,84,56,,,68,90,,,,302,336,349,302,,,46,51,51,41,56,,,44,63,,44,60,,,
     65,,,,,70,63,80,,48,48,,,80,42,53,101,,94,,,48,,,75,72,,70,63,,,302,,,,
     39,,,57,41,42,75,40,95,72,43,99,339,380,306,344,357],
   [,46,78,43,42,,43,,45,41,72,,90,,,,49,,,,84,,57,85,42,,,51,79,42,111,
     52,47,42,289,,233,,57,43,77,,,47,43,35,77,67,35,,35,73,,,,297,309,
     339,273,51,,51,51,57,48,51,58,,44,51,,,62,,91,65,106,73,87,122,60,
     78,106,63,52,52,49,84,,,,,43,82,49,60,81,59,60,41,,46,90,62,,,247,
     223,94,56,47,92,,,,40,86,,,94,42,98,347,301,289,301,347,61],
   [,,54,,44,51,51,,,89,52,53,61,,,,53,68,,,72,,,59,,,,37,,42,91,,47,52,243,
     ,171,,41,,70,,,38,74,41,72,68,,,60,76,,,,235,294,301,244,40,,37,40,
     40,35,43,48,,33,45,,36,45,,51,43,66,42,117,79,,,,56,33,33,36,68,60,
     34,39,65,36,65,,49,65,,42,57,52,,,61,,,280,174,62,37,33,65,69,47,35,
     32,,32,69,71,35,69,,332,235,292,303,45,49],[],
   [80,,64,,54,71,65,137,,87,,60,90,,,,,94,,,,,57,62,49,,,44,,47,96,,49,53,
     273,,,,49,,101,,,41,72,51,,76,,,68,98,,,,310,334,355,308,45,,46,51,51,
     45,52,,,44,63,,44,60,,60,65,71,51,93,86,78,,,64,48,48,51,,,42,54,109,
     ,86,165,54,,,49,59,54,,,,,,324,261,67,53,45,66,107,49,43,42,,46,121,,,
     ,341,376,308,340,,50,51],
   [80,40,,37,30,76,25,,33,37,56,50,70,,,,39,49,,,70,,51,77,36,,,37,77,30,
     107,40,39,36,249,,161,,45,27,65,,,37,29,27,65,57,27,,27,65,,,,211,
     235,289,175,45,,37,43,45,40,45,44,,34,35,,25,44,,67,45,82,51,63,98,
     44,58,82,51,34,34,33,58,56,25,35,49,31,58,33,54,63,43,44,,40,34,
     80,54,,,,161,84,32,31,84,56,33,30,28,84,25,56,84,30,56,295,245,211,
     231,289,51,37,37,,45],
   [,,,,45,28,68,44,,,,,,,,,19,15,,,15,,,,,,,48,43,63,,71,69,72,,,59,,,,,,,24,
     60,24,24,24,60,,58,24,,,,81,83,83,81,,,80,63,79,68,86,,,13,13,,13,13,
     ,,28,,,,,,72,,,11,11,,,23,13,20,15,13,15,,,60,,,46,58,,86,70,,,65,59,,
     ,20,,,24,18,16,106,20,20,,18,20,87,87,81,83,83,86,74,77,,82,68],
   [,21,20,42,,20,30,26,42,46,7,12,,,,,,9,,,9,,40,27,37,,,28,29,49,33,45,
     66,37,43,,35,,14,36,,,,12,38,14,14,16,36,,36,14,,,,49,57,57,49,56,,
     48,40,56,35,60,7,,7,7,,7,7,,21,20,44,33,26,42,20,32,44,14,11,11,
     13,15,,,13,15,9,15,29,39,40,33,51,37,,25,51,39,,,45,35,38,15,17,36,
     19,14,,11,38,17,19,38,13,19,57,59,49,57,57,56,45,48,,56,35,11],
   [,,,56,41,18,,26,50,68,7,10,11,,,,10,11,,,9,,40,41,39,,,28,29,50,35,
     47,56,41,43,,35,,14,38,15,,,11,38,14,15,15,36,,38,13,,,,49,57,57,49,
     54,,46,42,54,41,58,7,,7,7,,7,7,,26,20,52,39,26,52,,,52,11,11,11,
     13,15,11,9,13,15,9,15,29,41,44,35,53,39,32,,,40,,,45,35,,14,16,62,
     18,14,12,10,,16,18,,12,18,57,59,49,57,57,54,51,46,,54,41,11,7],
   [,,38,,37,28,48,42,64,,,,,,,,19,15,,,15,,60,49,65,,,48,39,59,53,65,67,,
     67,,59,,28,50,,,,24,52,24,24,26,50,,50,24,,,,81,85,85,81,87,,77,61,
     81,59,79,,,13,13,,13,13,,47,28,71,33,40,65,38,51,57,,11,11,20,15,
     23,13,,,13,15,39,76,64,53,62,41,52,45,74,66,,,63,59,67,17,20,63,20,
     24,18,16,63,20,,67,18,20,87,85,81,85,85,83,63,77,,81,59,11,11,11],
   [38,25,,52,43,,44,26,52,60,7,12,,,,,12,9,,,9,,40,,38,,,28,31,49,35,46,
     60,,43,,35,,14,62,,,,12,46,14,14,16,,,64,14,,,,49,57,57,49,54,,46,42,
     54,41,58,7,,7,7,,7,7,,,26,54,38,26,50,,42,,14,11,11,13,15,13,9,13,
     15,,15,32,,40,35,53,39,32,30,53,,,,45,35,,15,17,42,19,14,13,11,58,
     17,19,,,19,57,59,49,57,57,54,51,46,,54,41,11,7,7,11],
   [38,21,,42,33,18,30,26,42,50,7,10,11,,,,10,9,,,11,,40,25,37,,,28,27,
     47,33,45,66,37,43,,35,,14,36,15,,,11,36,14,13,15,34,,36,15,,,,49,57,
     57,49,56,,48,40,56,35,60,7,,7,7,,7,7,,21,20,44,33,26,44,,32,44,11,
     11,11,13,15,11,9,13,15,9,15,27,39,40,33,51,,32,,51,39,,,47,35,42,
     14,16,42,18,14,12,10,36,16,18,42,12,18,57,61,49,57,57,56,51,48,,
     56,35,11,7,7,11,7],
   [,,,,,28,68,,,72,,,,,,,19,15,,,15,,50,,75,,,48,,66,71,67,69,,67,,59,,,58,,,
     ,24,94,24,24,24,60,,58,24,,,,81,83,83,81,82,,77,63,82,68,79,,,13,13,
     ,13,13,,,28,,41,50,75,,72,72,,11,11,20,15,23,13,20,15,13,,43,92,,
     77,70,44,58,,80,73,,,63,59,,17,20,,20,24,18,16,106,20,20,,18,,95,85,
     81,83,83,79,72,80,,79,68,11,11,11,11,11,11],[]],
 [,[],[],[],[,,,21],[],[,15,,27],[,,,,,13],[],[,13,,25],
   [8],[,10,,,,13,17,13],[,,,,,,52,34],[,10,,,,13,17,13,,,,4],
   [,,,,17,,29,15],[,,,,37,27,34,21,,53],
   [,,,28,22,,20,14,,22,,4,,4,6,8],[,,,55,,,50,28,,,,,11,,,13],
   [,12,,28,17,15,19,,,15,,,,,6,,6],[,,,,36,,,19,,,,,13,,,8,8,13],
   [,,,,,,60,,,,,,11,,,13,,11],[,,,,36,27,37,19,,,,,13,,,8,8,,,8,13],
   [16,,,,24,30,25,,,31,16,,,,,,22,89,23,,54],[],
   [,17,,,32,33,25,,,23,,20,,20,,,22,98,21,65,85,52],
   [,17,,,,16,23,21,,22,,11,,11,,,,49,15,34,61,33,,,17],
   [,,,30,34,23,37,31,,31,,,,,17,,22,52,21,49,,49],
   [,21,,,,,,,,,18,15,42,15,22,35,16,40,23,35,40,35,,,21,16,20],
   [,,,,,,,23,,,,17,,17,,35,18,,21,,,35,,,,13,17],
   [,25,,29,19,,,59,,28,,23,56,23,26,46,26,,26,49,71,52,24,,24,20,24],
   [,,,,,20,,,,,22,17,41,17,17,27,18,39,,,37,29,,,,15,19,,17],
   [,17,,23,,37,,,,23,24,20,,20,,51,24,65,21,,,62,,,17,17,21],
   [,38,,33,,23,,31,,31,27,23,49,23,18,43,22,40,21,41,43,35,22,,23,,15,
     21,17,24,19,21],[,,,34,,,22,,,,,23,74,23,27,43,22,59,,,,55,22,,23,
     17,21,,,,,,21],[,,,,,69,125,103,,,,,,,,,24,,,73,128,83,85,,,,,,105,,,
     115,99],[],[,82,,197,,,,,,,25,20,55,20,32,44,20,55,32,44,55,44,93,
     ,103,,102,77,,,218,121,104,130,24],[],
   [8,,,,18,11,20,,,,5,,,,,,6,15,,,,,16,,,,,18,15,25,21,23,25,23,,,25],
   [,,,,23,,26,,,,,,,,,,22,53,,,,,,,,,,31,,33,,30,36],
   [,,,,38,27,44,37,,,,,,,,,,13,,16,14,16,,,,,,45,38,58,48,,45,,,,62],
   [,10,,,14,9,14,11,,13,,7,,7,,,8,22,9,21,,,,,17,11,,15,13,20,15,17,23,
     17,,,37],[,,,,36,21,40,28,,,,,11,,,,10,11,,11,11,11,,,,,,38,29,51,30,
     67,45,65,,,49],[,15,,,,,,11,,19,5,7,11,7,9,11,6,11,9,11,11,11,16,
     ,18,12,17,15,,,16,18,17,20,29,,25,,5,,13,7,9],
   [,28,,31,,,,,,22,,25,,25,28,56,22,53,30,,,59,43,,34,33,49,,,,,34,43,31,
     223,,,,,23,,22],[,10,,16,12,9,16,11,,13,5,7,17,7,9,11,,,9,11,17,
     11,18,,17,11,15,17,13,19,15,17,15,17,29,,25,,5,19,,7,9,5,19],
   [,,,,38,27,44,37,,,,,14,,,16,,,,16,14,,52,,65,,77,44,37,54,42,71,41,65,
     131,,62,,,,12,,14,13],
   [,,,24,14,9,18,,,,,7,,7,9,21,8,22,,,,21,18,,20,13,19,15,15,20,,,19,18,
     44,,37,,,,,7,,7,,7],
   [,,,24,21,,26,,,,,,,,31,,22,51,,,,,,,32,33,,34,,31,,,39,,278,,193,,,17,,,,,
     22,19],[,,,,36,21,40,,,,,,11,,,11,10,11,,,11,11,50,,76,33,,38,28,51,
     28,,39,,104,,49,,,,14,,9,9,,9,14],
   [,,,31,,,18,,,,,25,,25,25,47,20,47,,,,53,46,,31,32,45,,,32,,,37,,,,145,,,
     23,,19,,,,17],[,,,,38,27,44,,,,,,14,,,16,,13,,,,16,,,,,,45,38,58,,,53,,,
     ,62,,,,12,,14,13,,,12],
   [,,,,36,21,40,22,,,,,11,,,11,10,11,,11,11,,,,,,,38,29,51,32,67,45,63,81,
     ,49,,,,14,,9,9,,9,,,,9,,14],
   [64,,,,119,78,,,,,41,,,,,,32,147,,105,119,81,115,,,,,120,158,164,177,151,
     125,149,192,,,,41,,,,,39,268,39,174,56,230,97,271,144,112],
   [,77,,,98,93,129,102,,115,,34,,34,,,32,130,,86,121,81,,,129,83,,119,131,
     152,,129,132,133,,,167,,,,,52,,39,134,39,,54,151,91,127,156,89],
   [,,,170,,,,,,,35,28,77,28,44,60,28,77,44,60,77,60,118,,,92,128,107,,,
     183,151,,145,173,,140,,35,183,86,51,67,35,,35,86,51,183,67,221,86,67,
     32,35],[96,73,,135,,86,116,100,,101,48,34,117,34,53,,,,60,86,162,80,
     128,,125,83,114,,133,,,125,114,133,189,,170,,46,,147,52,92,,128,40,,53,
     152,114,119,147,,33,40,32],
   [68,,,,106,82,148,,,,44,31,120,31,,80,,,,,,80,120,,148,93,136,128,,156,,,
     131,145,202,,170,,44,228,152,52,102,41,,41,164,54,,,,,,40,32,35],
   [56,,,128,84,63,128,113,,113,35,28,77,28,42,56,28,77,42,56,77,56,107,,
     132,81,,107,95,147,153,132,,133,182,,140,,35,130,84,49,63,35,134,35,
     84,49,,63,121,84,63,,,28,32,33],
   [24,,,,34,42,33,39,,32,26,,,,,,24,79,27,,81,68,22,,,,,29,37,30,,24,33,
     27,122,,124,,24,,,,,23,43,21,78,21,39,73,42,93,73,164,,166,159,167,
     169],[,31,,,42,30,40,41,,40,,19,,19,,,,63,27,56,80,49,,,28,19,,27,
     24,31,29,28,23,30,,,,,,,,19,,22,54,19,79,25,53,52,54,76,66,,145,165,
     145,167,145],[,34,,39,,,,66,,,26,28,60,28,31,53,26,60,31,56,61,53,
     28,,31,27,31,22,,,60,31,32,30,128,,121,,25,43,63,25,53,22,,23,63,25,
     41,53,42,63,54,172,180,165,167,186,174,27,27],
   [,29,,33,28,23,,31,,31,,18,,18,20,42,,,21,45,55,41,,,26,19,23,,20,28,
     25,24,23,26,98,,98,,,43,81,18,,17,41,15,,19,44,43,43,,41,126,122,
     130,114,125,121,21,19,24],[],
   [32,31,,43,41,30,41,41,,40,29,19,57,19,27,39,24,51,27,48,57,39,28,,
     28,19,23,27,24,32,29,28,,30,129,,124,,26,48,57,19,46,22,48,19,57,
     25,48,46,48,55,46,165,145,162,145,165,145,27,19,27,19],
   [32,,,48,28,33,31,,,,24,30,66,30,,64,24,64,,,,,28,,35,25,29,,,27,,,29,,
     121,,127,,24,,93,24,58,21,40,21,78,,,,,,73,163,173,176,164,,169,27,25,
     ,21,,25],[24,,,,49,33,53,42,,60,15,,,,,,14,21,24,19,21,19,46,,,,,50,
     ,70,51,57,53,,76,,67,,15,,,,,15,93,15,26,24,,19,,26,19,102,,93,106,
     103,93,68,,70,50,,65,66],
   [,30,,,38,27,45,29,,43,,10,,10,,,12,23,19,14,23,14,,,52,33,,43,33,59,
     37,52,48,53,,,54,,,,,19,,15,53,17,28,19,72,19,53,28,19,,86,74,86,83,
     70,,53,68,46,,49,66],
   [,36,,70,,,,19,,41,15,10,21,10,12,14,8,21,12,14,21,14,,,37,25,35,23,,,
     27,41,27,37,47,,30,,13,37,26,15,17,9,,11,26,15,,17,35,26,17,59,59,
     42,,55,42,43,41,36,33,,35,43,14,10],
   [,31,,53,39,,45,36,,42,15,15,21,15,24,19,,,24,19,21,,,,53,35,48,50,69,
     60,49,53,48,54,78,,67,,15,55,25,22,19,15,51,15,,22,55,19,49,25,21,
     104,104,93,103,106,93,,61,70,48,,61,68,13,15,14],
   [28,,,72,38,,60,,,,18,10,23,10,19,14,12,23,,,,14,46,,55,36,45,43,37,56,,
     ,49,54,69,,54,,16,82,28,19,19,15,84,17,28,19,,,,,19,88,83,74,88,86,
     70,63,62,65,49,,58,,15,10,10,15],
   [24,26,,38,18,13,24,19,,31,15,10,21,10,12,14,8,21,12,14,21,14,35,,35,
     23,37,23,19,31,25,39,,35,49,,30,,13,33,24,15,17,9,34,11,24,15,27,
     17,31,24,17,61,59,42,55,55,42,45,35,38,31,,29,45,14,10,6,14,10],
   [24,,,85,49,33,51,,,,15,15,21,15,24,19,14,21,,,,19,46,,60,37,50,49,,64,,
     ,48,,76,,67,,15,,26,24,19,15,93,15,26,,,,,,19,102,102,93,,,93,68,66,
     72,51,,65,68,13,15,14,13,,14],
   [32,30,,58,38,27,42,27,,39,18,10,23,10,19,14,12,,19,14,23,,50,,49,33,
     39,43,33,57,39,49,43,49,66,,54,,16,,28,19,19,15,50,17,,19,70,19,47,
     28,,83,86,74,86,86,70,59,53,62,43,,49,59,15,10,10,,10,10,15],
   [,,,,,,,,,,,,,,,,22,,,,,,,,,,,,,,,,21,,,,,,,,,,,19,,17,51,,,,,,,,,122,127,,,,,37,,
     ,29,,,,49,47,57,41,,49],
   [,,,,,,,,,,,,,,,,14,38,,,,,,,,,,27,,37,,,36,,,,64,,,,,,,,,13,,,,,,,,,,84,,,79,,,
     41,,,46,,,,16,37,,34],
   [,,,,,,,,,,,,,,,,22,,,,,,,,,,,,,,,,33,,,,208,,,,,,,,,21,,,,,,,,,,,174,220,162,,,,
     21,,27,,,,110,69,,58,102,62],[],[],[],
   [,,,,,,,,,,,10,25,10,13,24,,31,14,24,29,24,,,,35,36,,,,,,,32,,,,,11,27,26,
     10,25,10,25,13,31,10,27,25,24,28,25,,89,191,88,92,76,42,55,72,,,,49,
     ,30,16,37,30,16,35,30,,13],
   [,,,,,,,,,,,22,68,22,29,46,20,58,36,70,94,42,,,,27,33,,,,,,,,,,,,20,,53,
     22,44,,,21,53,30,,50,,55,43,221,,,168,228,176,34,23,35,21,,23,34,76,
     54,,66,78,28,102,50,,,21],
   [,,,,,,,,,,,,,,,,28,,,,,,29,,37,27,18,27,26,37,26,34,21,34,,,,,,,,,,,,21,,,,,
     ,65,,193,190,,,213,160,42,23,40,23,,27,39,102,63,110,69,78,58,72,,21,
     ,27,,,,,27],[,,,,20,13,24,,,,,,,,,,,,,,,,,,,,,23,18,30,,,,,,,32,,,,,,,7,,,,
     ,,,,,,,,44,55,,42,,,31,23,,30,33,,,20,20,24,18,21,24,14,,,,,,15,25,25]
    ,[,,,,33,15,33,,,,,,,,,,,,,,,,,,,,,27,,36,34,,31,44,,,37,,,,,,,9,69,13,,,,,,
     ,,,,51,68,68,51,,,40,,,37,50,,,8,,,8,,,,14],[],[],[],
   [,12,,28,18,,17,15,,21,,,,,,,,,,,,,23,,21,15,21,23,,26,21,21,21,25,45,,
     32,,6,22,17,9,12,7,18,6,17,9,22,12,19,17,12,53,57,44,60,55,42,30,
     27,31,21,,27,33,20,24,20,,24,18,20,,,14,,,,,,36,,7],
   [,,,42,21,31,34,24,,,,,,,,,,,,,,,51,,45,35,38,28,49,32,31,,26,45,,,37,,
     15,27,,18,21,9,29,,,18,31,21,27,,21,73,85,51,68,,51,48,49,39,42,,33,
     ,18,13,8,18,13,7,18,13,,16,,,,,24,32,,,8],[],[],
   [,,,,,15,37,,,,,,,,,,,,,,,,38,,47,35,,28,24,,,,27,,77,,37,,,79,,,,9,,13,,,,,
     66,,,,73,51,74,70,51,53,48,39,39,,37,,18,13,7,18,13,8,18,13,,35,,,,,,
     ,,,8,,,,,8],[],
   [,,,,18,,18,,,,,,,,,,16,39,,,,,,,,,,25,,29,,27,37,,,,118,,,,,,,,17,14,,,,,15,,,
     ,,142,99,155,90,,,39,41,,39,,,,,39,53,18,,,,,,,,,18,,,,,,,,14,23],
   [,,,,38,33,33,,,,,,,,,,24,87,,,,,,,,,,27,30,34,,,34,,,,,,,,,,,23,70,22,70,,,,
     ,82,,,,165,169,179,,,,27,22,,28,,,,61,67,72,58,,66,21,,,,,,,29,35,23],
   [],[],[],[],[,15,,22,24,,15,40,,14,20,19,50,19,,,18,,,,50,,24,,
     25,19,24,27,,24,45,24,24,19,101,,98,,17,25,42,14,39,17,17,14,42,16,
     24,39,16,42,39,126,125,126,114,129,143,32,29,27,24,,29,24,48,45,46,
     52,51,40,48,49,37,24,,,,,24,44,,18,54,,,,17,,,,54,,17,27],
   [,,,,,,,,,19,,12,46,12,18,28,,32,14,32,,28,,,,,37,,,37,,31,,27,139,,,,14,
     22,33,12,30,13,18,14,33,13,22,30,17,31,30,127,100,,95,133,92,,47,
     58,41,,39,42,54,36,22,39,40,20,,36,,18,,,,,,,,17,,,,,,27,,,,,14,,,,,,17]
    ,[,,,,,39,,,,,28,24,,24,26,72,24,86,,,65,66,,,,28,34,32,,,38,,,,146,,
     141,,25,,,24,75,21,40,22,63,,,56,,105,58,174,174,179,167,176,160,27,
     25,24,22,,25,23,67,60,45,73,60,42,74,56,,,29,,,,,,35,,,,,,,,,,51,,,22,,,
     ,,30],[,,,,,,35,52,,,,,75,,,,24,,,65,,,22,,29,28,20,21,31,26,39,27,
     22,23,,,,,,,67,,64,26,71,22,,26,,,,67,,208,174,173,,220,164,34,25,29,
     25,,28,28,74,66,61,69,64,58,,66,29,71,35,,,,36,35,,27,69,,,,,73,,,,,,
     28,,,,,27,,28],[,13,,24,,,14,,,13,18,,44,,,,16,,15,,44,,22,,23,20,27,
     32,,25,,23,27,22,119,,97,,16,23,39,13,36,15,16,13,39,15,23,36,15,
     39,36,129,,,106,,169,31,34,28,27,,34,,44,,37,44,,39,44,37,,22,,,,,22,,
     ,17,44,,,,,,,,44,,15,,,,,,,15,31],[],
   [,57,,106,,72,112,93,,120,38,26,,26,51,71,24,131,,,,,92,,100,61,112,,113,
     ,123,98,,131,24,,24,,36,128,171,38,,31,,31,,,,78,124,,80,193,193,181,
     198,197,177,136,107,,94,,107,142,80,66,55,79,78,51,78,63,,,174,,,,,
     150,167,,,,,,,,,,92,,80,142,,,,,,75,142,138],
   [72,,,,,63,,,,,25,20,55,20,32,44,20,55,32,44,55,44,90,,110,73,102,77,
     127,,,114,114,,,,20,,25,,62,37,49,25,193,25,62,37,149,49,195,62,49,
     166,,140,173,,140,121,129,121,94,,124,128,67,54,30,67,54,30,67,54,,70,
     ,,,,,,321,32,37,,,,32,37,,,37,,97,122,,,,,100,,,126,113,,27],[],
   [,,,,20,13,22,23,,39,,,,,,,8,,,,,,,,,,,23,19,30,29,41,28,35,,,30,,,,,,,11,
     28,13,,17,29,,23,,,,,42,58,58,42,,,37,34,,29,48,,,6,,,6,,,,,,,,,16,30,,,
     ,,,,,7,,,7,,18,,,,,,,20,56,,,,86,30],[],[],[],
   [,12,,17,15,,22,14,,,5,,15,,,,6,,,,15,,21,,20,13,18,18,,22,19,19,18,19,
     34,,25,,5,20,14,8,11,5,20,5,14,8,19,11,19,14,11,44,41,35,41,42,
     35,27,23,25,18,,23,,15,16,13,15,,13,15,16,17,12,,,,,12,24,,6,15,,,,,,,
     ,15,,14,24,,,,,,14,27,24,,,,25],
   [,,,,20,19,40,,,,,,,,,,8,,,,,,,,47,28,41,23,39,33,,,29,,49,,30,,,,,17,,11,,
     13,,,60,,,,,61,64,42,,,42,45,46,40,37,,38,,15,12,6,15,12,6,15,12,,14,
     ,,,,16,,,,7,,,,,,,,7,,40,,,,,,,24,,69,,,,30,,6],
   [,14,,,,11,,,,,5,4,11,4,7,10,4,11,7,10,11,10,20,,21,13,25,16,15,,21,,
     ,21,24,,20,,5,21,12,8,11,5,19,5,12,8,21,11,18,12,11,32,33,28,32,
     33,28,27,24,24,,,26,27,13,12,6,13,12,6,13,12,15,11,23,,,,,,,6,7,,,,
     6,7,,,7,,14,23,,,,,17,,,22,16,,24,20,,6,,,,5,6],[],[],[],[],
   [,,,,,13,25,23,,,,,,,,,8,,,,,,,,38,27,41,23,19,36,29,50,23,54,,,30,,,46,,,
     ,11,27,13,,17,,,31,,,86,67,42,,,42,54,37,37,33,,29,,15,12,6,15,12,
     6,15,12,,20,,,,,16,26,,,7,,,,,7,,,,,18,,,,,,,20,50,,,,,30,,6,,,,,6,6],
   [],[],[,82,,137,104,90,,,,121,44,34,150,34,55,80,34,164,54,,,95,122,
     ,134,83,,123,131,152,161,131,142,137,195,,,,44,161,,52,97,41,159,41,
     147,54,160,,158,,96,32,34,32,34,34,33,177,145,189,124,,145,183,105,
     86,63,105,83,63,104,86,131,,,,,,91,,188,65,,,,,,,,,82,,104,178,,,,,,99,
     175,189,143,,202,169,,98,,,,,,32,,,,,73],
   [84,102,,173,135,,179,131,,,35,28,77,28,44,60,28,77,44,60,77,60,120,,
     140,88,124,107,145,174,201,152,140,140,172,,140,,35,224,86,51,67,35,
     174,35,86,51,,67,171,86,67,33,32,28,33,32,28,162,162,164,126,,161,
     168,93,74,42,93,74,42,93,74,121,84,198,,,,,,,44,51,,,,44,51,,,51,,,162,
     ,,,,124,,,162,125,,,140,,42,,,,35,42,28,,,,,42,,,33],
   [,73,,139,,,,102,,100,,34,111,34,,81,32,173,,89,119,,,,125,83,114,,141,
     157,145,125,114,129,190,,169,,,146,,52,89,39,125,39,145,53,147,93,116,
     ,110,40,35,32,38,40,34,159,145,167,114,,145,163,102,86,61,102,86,59,
     103,89,,95,171,,,,,171,,,,,,,57,,,,73,,95,167,,,,,113,95,,171,99,,195,171,
     ,64,,,,44,67,32,,,,,67,,,40,32],[],[],
   [,25,,27,32,73,27,57,,23,29,22,67,22,26,72,24,,38,,67,,28,,24,22,27,
     29,54,24,60,22,27,24,136,,137,,26,23,61,21,58,23,23,20,61,24,22,58,
     24,61,58,176,158,176,168,178,,27,31,27,26,,31,28,69,60,48,67,69,42,
     69,,43,35,46,,,,35,48,,27,57,,,,,,,,57,,26,35,,,,,,26,33,38,31,,118,138,
     ,56,,,,,,26,,,,,,,,158,175,174],
   [,,,,36,40,31,,,32,28,28,58,28,31,51,26,56,27,47,56,50,,,,27,33,28,,
     29,45,24,,27,122,,118,,25,,59,25,51,23,39,21,57,21,39,50,40,59,50,
     164,171,160,162,171,169,21,26,25,21,,26,25,69,66,35,67,63,37,66,59,
     33,36,34,,,,,,42,29,37,,,,28,36,,,38,,,27,,,,,30,,,34,,,141,121,,37,,,,
     25,33,24,,,,,36,,,176,164,160,,,28],
   [,17,,,,39,22,44,,20,21,19,51,19,,,18,76,20,,51,51,,,17,17,23,19,,23,
     45,17,23,21,100,,95,,19,17,46,16,43,17,21,15,46,17,17,43,21,46,43,
     129,120,125,113,144,118,,28,26,22,,28,26,51,47,35,47,49,33,51,44,33,
     25,,,,,25,40,46,20,41,,,,20,,,,41,,20,31,,,,,25,20,,,21,,93,96,,,,,,20,,
     19,,,,,39,,,123,125,113,,,21,23],
   [32,38,,,33,39,36,52,,41,24,30,75,30,,71,28,,32,74,,,28,,23,27,22,24,
     42,27,44,22,23,26,127,,142,,24,,71,27,67,,59,23,,27,55,,58,69,66,
     171,182,174,168,172,174,27,26,30,26,,27,30,68,70,,70,67,50,73,,35,
     61,40,,,,,40,,29,55,,,,28,52,,,,,57,33,,,,,34,40,33,,31,,148,136,,53,,,,
     29,56,25,,,,,,,,188,174,167,,,29,27,24],
   [32,,,25,24,36,27,,,25,29,22,59,22,27,50,24,53,30,53,59,50,28,,23,23,
     24,28,42,24,58,22,24,23,129,,123,,26,23,57,22,54,23,23,20,57,23,22,
     54,23,57,54,167,,163,162,172,148,27,28,27,26,,28,27,69,60,36,64,63,
     30,69,60,40,34,45,,,,34,45,66,27,39,,,,32,34,,,39,,26,33,,,,,26,26,33,
     ,,,142,123,,32,,,,26,35,26,,,,,32,,,166,162,,,,,27,,25],[],
   [,,,49,39,45,52,36,,44,15,15,,15,24,,,21,,19,21,19,52,,55,35,53,49,67,
     60,49,53,56,53,80,,67,,15,56,,22,21,15,57,15,25,22,55,19,51,25,19,
     106,102,93,106,103,93,71,61,72,50,,61,70,14,13,14,14,13,13,14,13,
     45,34,74,,,,35,68,74,20,18,,,,,,,,18,,41,68,,,,,,40,71,69,,,82,67,,15,,,
     ,15,,13,,,,,15,,,108,93,102,,,71,69,49,75,64],
   [36,36,,80,,27,,,,62,15,12,11,12,20,10,12,11,20,10,11,10,50,,54,,54,
     39,36,89,50,61,51,54,66,,50,,13,51,12,21,11,11,46,13,12,21,51,11,
     43,12,11,85,86,70,85,86,70,63,,58,49,,55,,13,12,12,13,12,12,13,12,
     40,28,,,,,,,56,16,17,,,,16,17,,,17,,34,59,,,,,44,,,59,41,,66,50,,14,,,,
     13,14,10,,,,,14,,,,70,85,,,66,59,49,66,62,,13],
   [28,30,,54,,25,,34,,38,18,15,13,15,20,12,14,13,21,13,14,12,46,,49,35,
     47,,37,66,47,49,43,52,77,,76,,16,48,14,21,13,13,43,15,14,22,48,14,
     40,15,13,101,103,102,103,103,98,62,59,63,47,,55,64,15,14,14,15,15,
     14,16,14,49,30,62,,,,28,,62,19,20,,,,19,20,,,20,,32,66,,,,,41,36,68,
     68,38,,84,71,,17,,,,16,17,,,,,,17,,,108,96,105,,,77,59,46,64,,,15,12],
   [24,42,,73,,,51,42,,60,15,15,,15,24,,14,21,24,19,21,19,46,,60,36,48,
     49,56,66,53,,49,,76,,67,,15,105,,24,,15,,15,26,,,19,88,26,19,102,103,
     93,105,103,93,66,65,73,51,,65,70,14,13,13,14,13,14,14,13,,51,82,,,,,
     102,,21,18,,,,20,18,,,,,,,,,,,48,54,74,,44,,79,67,,15,,,,15,15,13,,,,,,,,
     105,93,106,,,69,67,51,70,69,,14,13,15],
   [24,,,51,30,23,,,,47,15,12,11,12,18,10,12,11,18,10,11,10,41,,,35,55,
     39,37,51,61,52,53,53,69,,50,,13,48,12,19,11,11,48,13,12,19,48,11,
     45,12,11,91,87,70,89,,70,62,63,62,51,,59,62,13,12,12,13,12,12,13,
     12,55,26,70,,,,28,,70,16,17,,,,16,17,,,17,,36,65,,,,,50,38,65,65,,,70,
     50,,14,,,,13,14,10,,,,,14,,,87,70,,,,69,58,,64,54,,13,10,,13],
   [28,44,,61,,26,69,,,56,18,15,13,15,21,12,14,14,20,12,13,13,48,,57,38,
     53,,38,68,72,54,49,55,79,,,,16,53,14,22,13,13,48,15,15,21,52,13,45,
     14,14,101,103,,107,111,100,66,66,,48,,61,61,15,14,14,16,14,14,15,15,
     49,29,,,,,27,,72,19,20,,,,19,20,,,20,,37,62,,,,,49,,71,68,55,,85,72,,
     17,,,,16,17,13,,,,,17,,,103,98,103,,,72,64,56,66,,,15,,14,15,12],
   [8,,,,18,11,20,,,,5,,,,,,6,15,,,,,16,,,,,18,15,25,21,23,25,23,,,25,,5,,,,,
     5,,5,,,,,,,,41,,35,46,44,35,24,,25,,,26,24,15,,13,15,16,13,15,16,,,,,,
     ,11,20,,,,,,,6,15,,,,,,,,,,,17,14,25,,16,,36,25,,,,,,5,,5,,,,,,,,44,35,,,
     ,26,25,19,24,26,,15,13,16,15,13,16],
   [,,,,20,13,22,23,,39,,,,,,,8,,,,,,,,,,,23,19,30,29,41,28,35,,,30,,,,,,,11,
     28,13,,17,29,,23,,,,,42,58,58,42,,,37,34,,29,48,,,6,,,6,,,,,,,,,16,30,,,
     ,,,,,7,,,7,,18,,,,,,,20,56,,,,86,30,,6,,,,,6,6,,,,,6,,,98,42,64,,,56,37,
     ,53,32,,15,14,17,15,14,17]],
 [,[],[],[],[],[,,16],[,50],[],[],[],[],[,37,,,,,52],
   [,,12,,,,48],[,,12,,,,48,,,,,,5],[,,,,,,38],[,,,,,,80],
   [,,29,,,,94,,,,,11,,,15],[,35,14,,,18,34,,,,,,5,5,7,9],
   [,,15,,,,33,,,,,15,,,7,,,7],[,,32,,,,,,,,,,,,,9,,9],
   [,,12,,,,60,,,,,,5,5,7,9,,5,7,9],[,,,,,,92,,,,,,,,,9,,9,,9,9],
   [,,,,,56,66,,,,46,,,,,,56,32,38,,28,82],
   [,,,,,30,,,,,,,,,,,52,22,24,55,53],[,39,,,,50,70,,,,,49,,,,,58,41,,118,37 
    ],[,,31,,,36,,,,,,,24,24,,,,29,35,,27,72],
   [,,,,,38,,,,,,,,,26,,65,24,26,87,28,72],
   [,41,42,,,,,,,,28,40,20,20,28,40,40,20,28,40,20,40,28,,33,38,27],
   [,,27,,,,,,,,,43,,,,,43,25,,,,,,25,,29,28],[],[],
   [,,,,,54,60,,,,63,,35,35,,83,61,29,33,,29,82,,,35,44,30,27],
   [,,96,,,50,,,,,80,66,72,72,54,106,63,32,36,68,36,60,77,48,,,34,51,38],
   [,57,,,,,60,,,,,,52,52,,,59,47,,104,,,44,,48,77,49,,,,,49,88],
   [,,,,,,742,,,,53,,,,,,106,33,,87,33,69,184,,,,,,231,,,,,411],
   [,,,,,108,452,,,,,,,,,,101,,,81,37,,,,,189,,186,187,,,484,,356],
   [,,,,,,,,,,35,55,25,25,37,49,55,25,37,49,25,49,162,,187,,151,100,,,,161,
     289,240,,39],[,,92,,,136,,,,,,106,37,37,,69,,,,93,33,,188,220,219,,178,
     ,,,,215,266,,35,,33],
   [,,,,,18,56,,,,14,,,,,,18,14,18,30,,,28,,,,,26,29,,,44,69,40,80,,64],
   [,,,,,,51,,,,,,,,,,51,34,,,,,,,,,,46,,,,50,76,57,,,,270],
   [,,,,,16,46,,,,,,,,,,,7,,,7,,,21,,,,23,24,,,37,,,,,30],
   [,,12,,,14,36,,,,,,8,8,,,22,9,10,22,9,,,,,23,,20,21,,,30,68,40,,,42,62],
   [,,,,,28,90,,,,,,,,,,,11,,12,11,12,,,,,,43,44,,,97,81,,,,54,127],
   [,,12,,,,,,,,14,18,8,8,10,12,18,7,10,12,7,12,28,22,36,26,26,20,,,,28,
     34,,50,72,30,50,14,,6,8,10],
   [,40,,,,,,,,,,46,,,41,,67,34,41,,,,54,,59,156,,,,,,61,112,54,,291,,,,43],
   [,29,20,,,18,44,,,,14,18,16,16,18,30,,,,,14,30,30,43,34,29,38,26,27,,,
     38,38,,,82,64,82,12,34,,16,,14],
   [,,24,,,16,38,,,,,,8,8,10,12,,,10,12,7,12,43,20,47,28,31,23,23,,,32,
     39,54,49,,30,,,,6,8,10,6],
   [,,12,,,14,40,,,,20,22,8,8,10,22,,9,,,9,22,26,22,50,,30,20,21,,,,42,41,
     ,78,42,,16,,,8,,8,,,8],
   [,,,,,,51,,,,,,,,,,50,34,,,,,,,46,,74,46,,,,,110,65,588,396,324,508,,36,,,,,
     43,58],[,,,,,28,90,,,,,,,,,12,,11,,,11,12,89,55,125,,,43,44,,,,63,,
     153,140,54,166,,,,,10,10,,,10],
   [,48,,,,,40,,,,,55,,,38,,,34,38,,,,56,,61,,,,,,,61,120,,,407,238,,,35,,,,,
     36,34,,,43],[,,,,,16,46,,,,,,8,8,10,12,,7,10,12,,12,,43,,,27,23,22,,
     ,34,33,,53,,30,49,,,6,8,10,6,,,6,8,,10],
   [,,,,,28,90,,,,,,,,,12,,11,,12,11,,,,,,,43,44,,,97,70,,127,119,54,,,,,,10,
     10,,,10,,,10,,10],[,,,,,130,,,,,,,,,,,111,43,,87,47,93,236,,,,,194,329,,
     ,296,352,,271,,,289,100,,,,,60,337,108,59,78,369,114,439,63,118],[],
   [,,100,,,,,,,,49,77,35,35,51,67,77,35,51,67,35,67,208,188,,201,193,140,,,
     ,215,,,239,,175,245,88,293,42,58,74,42,,88,42,58,297,74,371,42,74,43 
    ],[],[,,148,,,132,,,,,61,111,41,41,82,85,,47,,,43,89,224,296,337,
     219,250,196,,,,,324,420,297,,241,315,100,345,70,72,114,60,457,106,59,
     78,,,493,61,163,59,,45],
   [,202,116,,,116,378,,,,49,77,35,35,51,67,77,35,51,67,35,67,,218,261,193,
     ,140,159,,,217,,287,257,277,175,253,84,227,42,58,74,42,227,84,42,58,
     229,74,233,42,74,43,,35,,49],
   [,,,,,76,75,,,,64,,,,,,83,44,53,,46,102,46,,,,,45,73,,,51,94,64,282,,232,
     272,45,,,,,44,71,47,58,47,66,114,75,45,114,362,,306,,360],
   [,,61,,,60,,,,,,,46,46,,,,43,48,92,45,84,,,,43,,53,48,,,55,56,76,,297,,
     295,,,,43,,42,130,47,44,,94,131,,55,,,,303,,349,289],
   [,66,53,,,,,,,,49,54,36,36,39,61,58,32,39,64,30,61,51,54,54,59,44,30,,,
     ,44,74,53,235,276,167,,45,67,33,33,61,30,,38,34,33,67,61,62,34,62,
     294,,224,,292,234,45,51],
   [,81,54,,,48,82,,,,57,55,41,41,41,75,,,39,77,36,90,58,,65,55,50,,43,,,
     53,62,,238,273,202,204,49,74,,39,,34,,38,,37,76,100,94,35,110,305,,
     253,,301,249,44,49,38],
   [,,61,,,66,117,,,,64,81,,,50,90,66,44,,,46,,58,,63,51,55,53,63,,,,77,76,
     300,,,294,53,74,50,43,102,44,103,53,45,41,,,79,43,100,356,,312,,378,
     318,52,45,51,52],[,84,45,,,50,85,,,,56,57,34,34,39,70,59,31,37,70,
     37,70,,40,56,55,38,37,40,,,47,,60,253,255,173,243,45,89,35,31,71,34,
     90,39,36,31,90,71,89,36,71,311,,235,,,223,,41,37,39],[],
   [,,,,,18,48,,,,7,,,,,,13,9,,,9,,46,,,,,28,,,,53,65,,53,,35,,14,,,,,12,68,
     14,14,18,44,,,14,,,,49,,61,49,60,,45,49,60,44],
   [,,28,,,36,94,,,,,,11,11,,,23,13,20,15,13,15,,,,46,,48,,,,72,87,98,,63,
     59,61,,,,20,,16,97,24,18,20,101,20,,18,20,,,81,,83,81,,82,76,67,86,
     80],[,,22,,,,,,,,7,11,11,11,13,15,11,9,13,15,9,15,36,42,40,33,44,
     28,,,,49,44,46,47,47,35,47,14,64,14,16,18,10,,14,12,16,,18,64,12,
     18,57,,49,,57,49,56,55,44,44,56,47,,7,11],
   [,27,24,,,18,40,,,,7,14,11,11,13,15,,,13,15,9,15,36