/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.util.List;
import org.scilab.forge.jlatexmath.Atom;
import org.scilab.forge.jlatexmath.Box;
import org.scilab.forge.jlatexmath.DelimiterFactory;
import org.scilab.forge.jlatexmath.Glue;
import org.scilab.forge.jlatexmath.HorizontalBox;
import org.scilab.forge.jlatexmath.MiddleAtom;
import org.scilab.forge.jlatexmath.RowAtom;
import org.scilab.forge.jlatexmath.SpaceAtom;
import org.scilab.forge.jlatexmath.SymbolAtom;
import org.scilab.forge.jlatexmath.TeXEnvironment;
import org.scilab.forge.jlatexmath.TeXFont;

public class FencedAtom
extends Atom {
    private static final int DELIMITER_FACTOR = 901;
    private static final float DELIMITER_SHORTFALL = 5.0f;
    private final Atom base;
    private SymbolAtom left = null;
    private SymbolAtom right = null;
    private final List<MiddleAtom> middle;

    public FencedAtom(Atom atom, SymbolAtom symbolAtom, SymbolAtom symbolAtom2) {
        this(atom, symbolAtom, null, symbolAtom2);
    }

    public FencedAtom(Atom atom, SymbolAtom symbolAtom, List list, SymbolAtom symbolAtom2) {
        this.base = atom == null ? new RowAtom() : atom;
        if (symbolAtom == null || !symbolAtom.getName().equals("normaldot")) {
            this.left = symbolAtom;
        }
        if (symbolAtom2 == null || !symbolAtom2.getName().equals("normaldot")) {
            this.right = symbolAtom2;
        }
        this.middle = list;
    }

    public int getLeftType() {
        return 7;
    }

    public int getRightType() {
        return 7;
    }

    private static void center(Box box, float f) {
        float f2 = box.getHeight();
        float f3 = f2 + box.getDepth();
        box.setShift(-(f3 / 2.0f - f2) - f);
    }

    public Box createBox(TeXEnvironment teXEnvironment) {
        TeXFont teXFont = teXEnvironment.getTeXFont();
        Box box = this.base.createBox(teXEnvironment);
        float f = 5.0f * SpaceAtom.getFactor(3, teXEnvironment);
        float f2 = teXFont.getAxisHeight(teXEnvironment.getStyle());
        float f3 = Math.max(box.getHeight() - f2, box.getDepth() + f2);
        float f4 = Math.max(f3 / 500.0f * 901.0f, 2.0f * f3 - f);
        HorizontalBox horizontalBox = new HorizontalBox();
        if (this.middle != null) {
            for (int i = 0; i < this.middle.size(); ++i) {
                MiddleAtom middleAtom = this.middle.get(i);
                if (!(middleAtom.base instanceof SymbolAtom)) continue;
                Box box2 = DelimiterFactory.create(((SymbolAtom)middleAtom.base).getName(), teXEnvironment, f4);
                FencedAtom.center(box2, f2);
                middleAtom.box = box2;
            }
            if (this.middle.size() != 0) {
                box = this.base.createBox(teXEnvironment);
            }
        }
        if (this.left != null) {
            Box box3 = DelimiterFactory.create(this.left.getName(), teXEnvironment, f4);
            FencedAtom.center(box3, f2);
            horizontalBox.add(box3);
        }
        if (!(this.base instanceof SpaceAtom)) {
            horizontalBox.add(Glue.get(4, this.base.getLeftType(), teXEnvironment));
        }
        horizontalBox.add(box);
        if (!(this.base instanceof SpaceAtom)) {
            horizontalBox.add(Glue.get(this.base.getRightType(), 5, teXEnvironment));
        }
        if (this.right != null) {
            Box box4 = DelimiterFactory.create(this.right.getName(), teXEnvironment, f4);
            FencedAtom.center(box4, f2);
            horizontalBox.add(box4);
        }
        return horizontalBox;
    }
}

