/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import org.scilab.forge.jlatexmath.MacroInfo;
import org.scilab.forge.jlatexmath.ResourceParseException;
import org.scilab.forge.jlatexmath.TeXConstants;
import org.scilab.forge.jlatexmath.TeXFormula;
import org.scilab.forge.jlatexmath.XMLResourceParseException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TeXFormulaParser {
    private static final String ARG_VAL_ATTR = "value";
    private static final String RETURN_EL = "Return";
    private static final String ARG_OBJ_ATTR = "formula";
    private static Map<String, Class<?>> classMappings = new HashMap();
    private final Map<String, ArgumentValueParser> argValueParsers = new HashMap<String, ArgumentValueParser>();
    private final Map<String, ActionParser> actionParsers = new HashMap<String, ActionParser>();
    private final Map<String, TeXFormula> tempFormulas = new HashMap<String, TeXFormula>();
    private final Map<String, MacroInfo> tempCommands = new HashMap<String, MacroInfo>();
    private Object result = new Object();
    private final String formulaName;
    private final Element formula;
    private static final int COMMAND = 0;
    private static final int TEXFORMULA = 1;
    private int type;

    public TeXFormulaParser(String string, Element element, String string2) {
        this.formulaName = string;
        this.formula = element;
        int n = this.type = "Command".equals(string2) ? 0 : 1;
        if ("Command".equals(string2)) {
            this.actionParsers.put("CreateCommand", new CreateCommandParser());
        } else {
            this.actionParsers.put("CreateTeXFormula", new CreateTeXFormulaParser());
        }
        this.actionParsers.put("MethodInvocation", new MethodInvocationParser());
        this.actionParsers.put(RETURN_EL, new ReturnParser());
        this.argValueParsers.put("TeXConstants", new TeXConstantsValueParser());
        this.argValueParsers.put("TeXFormula", new TeXFormulaValueParser());
        this.argValueParsers.put("String", new StringValueParser());
        this.argValueParsers.put("float", new FloatValueParser());
        this.argValueParsers.put("int", new IntValueParser());
        this.argValueParsers.put("boolean", new BooleanValueParser());
        this.argValueParsers.put("char", new CharValueParser());
        this.argValueParsers.put("ColorConstant", new ColorConstantValueParser());
    }

    public Object parse() throws ResourceParseException {
        NodeList nodeList = this.formula.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element;
            ActionParser actionParser;
            Node node = nodeList.item(i);
            if (node.getNodeType() == 3 || (actionParser = this.actionParsers.get((element = (Element)node).getTagName())) == null) continue;
            actionParser.parse(element);
        }
        return this.result;
    }

    private Object[] getArgumentValues(NodeList nodeList) {
        Object[] objectArray = new Object[nodeList.getLength()];
        int n = 0;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            String string = TeXFormulaParser.getAttrValueAndCheckIfNotNull("type", element);
            String string2 = element.getAttribute(ARG_VAL_ATTR);
            objectArray[n] = this.argValueParsers.get(string).parseValue(string2, string);
            ++n;
        }
        return objectArray;
    }

    private static Class[] getArgumentClasses(NodeList nodeList) throws ResourceParseException {
        Class[] classArray = new Class[nodeList.getLength()];
        int n = 0;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            String string = TeXFormulaParser.getAttrValueAndCheckIfNotNull("type", element);
            Class<?> clazz = classMappings.get(string);
            if (clazz == null) {
                throw new XMLResourceParseException("PredefinedTeXFormulas.xml", "Argument", "type", "has an invalid class name value!");
            }
            classArray[n] = clazz;
            ++n;
        }
        return classArray;
    }

    private static void checkNullValue(String string, String string2) throws ResourceParseException {
        if (string.equals("")) {
            throw new XMLResourceParseException("PredefinedTeXFormulas.xml", "Argument", ARG_VAL_ATTR, "is required for an argument of type '" + string2 + "'!");
        }
    }

    private static String getAttrValueAndCheckIfNotNull(String string, Element element) throws ResourceParseException {
        String string2 = element.getAttribute(string);
        if (string2.equals("")) {
            throw new XMLResourceParseException("PredefinedTeXFormulas.xml", element.getTagName(), string, null);
        }
        return string2;
    }

    static {
        classMappings.put("TeXConstants", Integer.TYPE);
        classMappings.put("TeXFormula", TeXFormula.class);
        classMappings.put("String", String.class);
        classMappings.put("float", Float.TYPE);
        classMappings.put("int", Integer.TYPE);
        classMappings.put("boolean", Boolean.TYPE);
        classMappings.put("char", Character.TYPE);
        classMappings.put("ColorConstant", Color.class);
    }

    private static interface ActionParser {
        public void parse(Element var1) throws ResourceParseException;
    }

    private static interface ArgumentValueParser {
        public Object parseValue(String var1, String var2) throws ResourceParseException;
    }

    private class BooleanValueParser
    implements ArgumentValueParser {
        BooleanValueParser() {
        }

        public Object parseValue(String string, String string2) throws ResourceParseException {
            TeXFormulaParser.checkNullValue(string, string2);
            if ("true".equals(string)) {
                return Boolean.TRUE;
            }
            if ("false".equals(string)) {
                return Boolean.FALSE;
            }
            throw new XMLResourceParseException("PredefinedTeXFormulas.xml", "Argument", TeXFormulaParser.ARG_VAL_ATTR, "has an invalid '" + string2 + "'-value : '" + string + "'!");
        }
    }

    private class CharValueParser
    implements ArgumentValueParser {
        CharValueParser() {
        }

        public Object parseValue(String string, String string2) throws ResourceParseException {
            TeXFormulaParser.checkNullValue(string, string2);
            if (string.length() == 1) {
                return new Character(string.charAt(0));
            }
            throw new XMLResourceParseException("PredefinedTeXFormulas.xml", "Argument", TeXFormulaParser.ARG_VAL_ATTR, "must have a value that consists of exactly 1 character!");
        }
    }

    private class ColorConstantValueParser
    implements ArgumentValueParser {
        ColorConstantValueParser() {
        }

        public Object parseValue(String string, String string2) throws ResourceParseException {
            TeXFormulaParser.checkNullValue(string, string2);
            try {
                return Color.class.getDeclaredField(string).get(null);
            }
            catch (Exception exception) {
                throw new XMLResourceParseException("PredefinedTeXFormulas.xml", "Argument", TeXFormulaParser.ARG_VAL_ATTR, "has an unknown color constant name as value : '" + string + "'!", exception);
            }
        }
    }

    private class CreateCommandParser
    implements ActionParser {
        CreateCommandParser() {
        }

        public void parse(Element element) throws ResourceParseException {
            String string = TeXFormulaParser.getAttrValueAndCheckIfNotNull("name", element);
            NodeList nodeList = element.getElementsByTagName("Argument");
            Class[] classArray = TeXFormulaParser.getArgumentClasses(nodeList);
            Object[] objectArray = TeXFormulaParser.this.getArgumentValues(nodeList);
            try {
                MacroInfo macroInfo = (MacroInfo)MacroInfo.class.getConstructor(classArray).newInstance(objectArray);
                TeXFormulaParser.this.tempCommands.put(string, macroInfo);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                String string2 = "IllegalArgumentException:\n";
                string2 = string2 + "ClassLoader to load this class (TeXFormulaParser): " + this.getClass().getClassLoader() + "\n";
                for (Class object : classArray) {
                    string2 = string2 + "Created class: " + object + " loaded with the ClassLoader: " + object.getClassLoader() + "\n";
                }
                for (Object object : objectArray) {
                    string2 = string2 + "Created object: " + object + "\n";
                }
                throw new XMLResourceParseException("Error creating the temporary command '" + string + "' while constructing the predefined command '" + TeXFormulaParser.this.formulaName + "'!\n" + string2);
            }
            catch (Exception exception) {
                throw new XMLResourceParseException("Error creating the temporary command '" + string + "' while constructing the predefined command '" + TeXFormulaParser.this.formulaName + "'!\n" + exception.toString());
            }
        }
    }

    private class CreateTeXFormulaParser
    implements ActionParser {
        CreateTeXFormulaParser() {
        }

        public void parse(Element element) throws ResourceParseException {
            String string = TeXFormulaParser.getAttrValueAndCheckIfNotNull("name", element);
            NodeList nodeList = element.getElementsByTagName("Argument");
            Class[] classArray = TeXFormulaParser.getArgumentClasses(nodeList);
            Object[] objectArray = TeXFormulaParser.this.getArgumentValues(nodeList);
            try {
                TeXFormula teXFormula = (TeXFormula)TeXFormula.class.getConstructor(classArray).newInstance(objectArray);
                TeXFormulaParser.this.tempFormulas.put(string, teXFormula);
            }
            catch (Exception exception) {
                throw new XMLResourceParseException("Error creating the temporary TeXFormula '" + string + "' while constructing the predefined TeXFormula '" + TeXFormulaParser.this.formulaName + "'!\n" + exception.toString());
            }
        }
    }

    private class FloatValueParser
    implements ArgumentValueParser {
        FloatValueParser() {
        }

        public Object parseValue(String string, String string2) throws ResourceParseException {
            TeXFormulaParser.checkNullValue(string, string2);
            try {
                return new Float(Float.parseFloat(string));
            }
            catch (NumberFormatException numberFormatException) {
                throw new XMLResourceParseException("PredefinedTeXFormulas.xml", "Argument", TeXFormulaParser.ARG_VAL_ATTR, "has an invalid '" + string2 + "'-value : '" + string + "'!", numberFormatException);
            }
        }
    }

    private class IntValueParser
    implements ArgumentValueParser {
        IntValueParser() {
        }

        public Object parseValue(String string, String string2) throws ResourceParseException {
            TeXFormulaParser.checkNullValue(string, string2);
            try {
                int n = Integer.parseInt(string);
                return new Float(n);
            }
            catch (NumberFormatException numberFormatException) {
                throw new XMLResourceParseException("PredefinedTeXFormulas.xml", "Argument", TeXFormulaParser.ARG_VAL_ATTR, "has an invalid '" + string2 + "'-value : '" + string + "'!", numberFormatException);
            }
        }
    }

    private class MethodInvocationParser
    implements ActionParser {
        MethodInvocationParser() {
        }

        public void parse(Element element) throws ResourceParseException {
            String string = TeXFormulaParser.getAttrValueAndCheckIfNotNull("name", element);
            String string2 = TeXFormulaParser.getAttrValueAndCheckIfNotNull(TeXFormulaParser.ARG_OBJ_ATTR, element);
            Object v = TeXFormulaParser.this.tempFormulas.get(string2);
            if (v == null) {
                throw new XMLResourceParseException("PredefinedTeXFormulas.xml", "Argument", TeXFormulaParser.ARG_OBJ_ATTR, "has an unknown temporary TeXFormula name as value : '" + string2 + "'!");
            }
            NodeList nodeList = element.getElementsByTagName("Argument");
            Class[] classArray = TeXFormulaParser.getArgumentClasses(nodeList);
            Object[] objectArray = TeXFormulaParser.this.getArgumentValues(nodeList);
            try {
                TeXFormula.class.getMethod(string, classArray).invoke((Object)((TeXFormula)v), objectArray);
            }
            catch (Exception exception) {
                throw new XMLResourceParseException("Error invoking the method '" + string + "' on the temporary TeXFormula '" + string2 + "' while constructing the predefined TeXFormula '" + TeXFormulaParser.this.formulaName + "'!\n" + exception.toString());
            }
        }
    }

    private class ReturnParser
    implements ActionParser {
        ReturnParser() {
        }

        public void parse(Element element) throws ResourceParseException {
            Object v;
            String string = TeXFormulaParser.getAttrValueAndCheckIfNotNull("name", element);
            Object v2 = v = TeXFormulaParser.this.type == 0 ? TeXFormulaParser.this.tempCommands.get(string) : TeXFormulaParser.this.tempFormulas.get(string);
            if (v == null) {
                throw new XMLResourceParseException("PredefinedTeXFormulas.xml", TeXFormulaParser.RETURN_EL, "name", "contains an unknown temporary TeXFormula variable name '" + string + "' for the predefined TeXFormula '" + TeXFormulaParser.this.formulaName + "'!");
            }
            TeXFormulaParser.this.result = v;
        }
    }

    private class StringValueParser
    implements ArgumentValueParser {
        StringValueParser() {
        }

        public Object parseValue(String string, String string2) throws ResourceParseException {
            return string;
        }
    }

    private class TeXConstantsValueParser
    implements ArgumentValueParser {
        TeXConstantsValueParser() {
        }

        public Object parseValue(String string, String string2) throws ResourceParseException {
            TeXFormulaParser.checkNullValue(string, string2);
            try {
                int n = TeXConstants.class.getDeclaredField(string).getInt(null);
                return n;
            }
            catch (Exception exception) {
                throw new XMLResourceParseException("PredefinedTeXFormulas.xml", "Argument", TeXFormulaParser.ARG_VAL_ATTR, "has an unknown constant name as value : '" + string + "'!", exception);
            }
        }
    }

    private class TeXFormulaValueParser
    implements ArgumentValueParser {
        TeXFormulaValueParser() {
        }

        public Object parseValue(String string, String string2) throws ResourceParseException {
            if (string == null) {
                return null;
            }
            Object v = TeXFormulaParser.this.tempFormulas.get(string);
            if (v == null) {
                throw new XMLResourceParseException("PredefinedTeXFormulas.xml", "Argument", TeXFormulaParser.ARG_VAL_ATTR, "has an unknown temporary TeXFormula name as value : '" + string + "'!");
            }
            return (TeXFormula)v;
        }
    }
}

