/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.gradle.api.Nullable;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.DefaultModuleVersionIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.IvyUtil;
import org.gradle.internal.component.external.model.AbstractModuleComponentResolveMetaData;
import org.gradle.internal.component.external.model.MavenModuleResolveMetaData;
import org.gradle.internal.component.model.IvyArtifactName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMavenModuleResolveMetaData
extends AbstractModuleComponentResolveMetaData
implements MavenModuleResolveMetaData {
    private static final String POM_PACKAGING = "pom";
    private static final Collection<String> JAR_PACKAGINGS = Arrays.asList("ejb", "bundle", "maven-plugin", "eclipse-plugin");
    private final String packaging;
    private final boolean relocated;
    private String snapshotTimestamp;

    public DefaultMavenModuleResolveMetaData(ModuleDescriptor moduleDescriptor, String packaging, boolean relocated) {
        super(moduleDescriptor);
        this.packaging = packaging;
        this.relocated = relocated;
    }

    public DefaultMavenModuleResolveMetaData(ModuleComponentIdentifier componentId, ModuleDescriptor descriptor, String packaging, boolean relocated) {
        super(DefaultModuleVersionIdentifier.newId(componentId), descriptor, componentId);
        this.packaging = packaging;
        this.relocated = relocated;
    }

    private DefaultMavenModuleResolveMetaData(ModuleVersionIdentifier id, ModuleDescriptor descriptor, ModuleComponentIdentifier componentId, String packaging, boolean relocated) {
        super(id, descriptor, componentId);
        this.packaging = packaging;
        this.relocated = relocated;
    }

    public DefaultMavenModuleResolveMetaData(ModuleComponentIdentifier componentIdentifier, Set<IvyArtifactName> artifacts) {
        this(componentIdentifier, (ModuleDescriptor)IvyUtil.createModuleDescriptor(componentIdentifier, artifacts), "jar", false);
    }

    @Override
    public DefaultMavenModuleResolveMetaData copy() {
        DefaultMavenModuleResolveMetaData copy = new DefaultMavenModuleResolveMetaData(this.getId(), this.getDescriptor(), this.getComponentId(), this.packaging, this.relocated);
        this.copyTo(copy);
        copy.snapshotTimestamp = this.snapshotTimestamp;
        return copy;
    }

    @Override
    public String getPackaging() {
        return this.packaging;
    }

    @Override
    public boolean isRelocated() {
        return this.relocated;
    }

    @Override
    public boolean isPomPackaging() {
        return POM_PACKAGING.equals(this.packaging);
    }

    @Override
    public boolean isKnownJarPackaging() {
        return "jar".equals(this.packaging) || JAR_PACKAGINGS.contains(this.packaging);
    }

    public void setSnapshotTimestamp(@Nullable String snapshotTimestamp) {
        this.snapshotTimestamp = snapshotTimestamp;
    }

    @Override
    @Nullable
    public String getSnapshotTimestamp() {
        return this.snapshotTimestamp;
    }
}

