/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.Ruby;
import org.jruby.RubyBasicObject;
import org.jruby.parser.StaticScope;
import org.jruby.parser.StaticScopeFactory;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Frame;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.backtrace.BacktraceElement;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.scope.ManyVarsDynamicScope;
import org.jruby.runtime.scope.NoVarsDynamicScope;

public class Binding {
    public static final Binding DUMMY = new Binding(RubyBasicObject.NEVER, Frame.DUMMY, Visibility.PUBLIC, new NoVarsDynamicScope(StaticScopeFactory.newStaticScope(null, StaticScope.Type.BLOCK, null)), "<dummy>", "dummy", -1);
    private Frame frame;
    public String method;
    public String filename;
    public int line;
    private Visibility visibility;
    private IRubyObject self;
    private DynamicScope dynamicScope;
    private DynamicScope evalScope;
    private Binding evalScopeBinding = this;
    private DynamicScope dummyScope;

    public Binding(IRubyObject self2, Frame frame, Visibility visibility, DynamicScope dynamicScope, String method, String filename2, int line) {
        this.self = self2;
        this.frame = frame;
        this.visibility = visibility;
        this.dynamicScope = dynamicScope;
        this.method = method;
        this.filename = filename2;
        this.line = line;
    }

    private Binding(IRubyObject self2, Frame frame, Visibility visibility, DynamicScope dynamicScope, String method, String filename2, int line, DynamicScope dummyScope) {
        this.self = self2;
        this.frame = frame;
        this.visibility = visibility;
        this.dynamicScope = dynamicScope;
        this.method = method;
        this.filename = filename2;
        this.line = line;
        this.dummyScope = dummyScope;
    }

    public Binding(Frame frame, DynamicScope dynamicScope, String method, String filename2, int line) {
        this.self = frame.getSelf();
        this.frame = frame;
        this.visibility = frame.getVisibility();
        this.dynamicScope = dynamicScope;
        this.method = method;
        this.filename = filename2;
        this.line = line;
    }

    public Binding(IRubyObject self2) {
        this.self = self2;
    }

    public Binding(IRubyObject self2, Frame frame, Visibility visibility) {
        this.self = self2;
        this.frame = frame;
        this.visibility = visibility;
    }

    public Binding(IRubyObject self2, DynamicScope dynamicScope) {
        this.self = self2;
        this.dynamicScope = dynamicScope;
    }

    public Binding(IRubyObject self2, Frame frame, Visibility visibility, DynamicScope dynamicScope) {
        this.self = self2;
        this.frame = frame;
        this.visibility = visibility;
        this.dynamicScope = dynamicScope;
    }

    private Binding(Binding other) {
        this(other.self, other.frame, other.visibility, other.dynamicScope, other.method, other.filename, other.line, other.dummyScope);
    }

    public Binding cloneForEval() {
        Binding clone = new Binding(this);
        clone.evalScopeBinding = this;
        return clone;
    }

    public Binding clone() {
        return new Binding(this);
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    public IRubyObject getSelf() {
        return this.self;
    }

    public void setSelf(IRubyObject self2) {
        this.self = self2;
    }

    public DynamicScope getDynamicScope() {
        return this.dynamicScope;
    }

    public DynamicScope getDummyScope(StaticScope staticScope) {
        if (this.dummyScope == null || this.dummyScope.getStaticScope() != staticScope) {
            this.dummyScope = DynamicScope.newDummyScope(staticScope, this.dynamicScope);
            return this.dummyScope;
        }
        return this.dummyScope;
    }

    public Frame getFrame() {
        return this.frame;
    }

    public String getFile() {
        return this.filename;
    }

    public void setFile(String filename2) {
        this.filename = filename2;
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Binding)) {
            return false;
        }
        Binding bOther = (Binding)other;
        return this.self == bOther.self && this.dynamicScope == bOther.dynamicScope;
    }

    public final DynamicScope getEvalScope(Ruby runtime) {
        if (this.evalScopeBinding.evalScope == null) {
            this.evalScopeBinding.evalScope = new ManyVarsDynamicScope(runtime.getStaticScopeFactory().newEvalScope(this.dynamicScope.getStaticScope()), this.dynamicScope);
        }
        return this.evalScopeBinding.evalScope;
    }

    @Deprecated
    public Binding(IRubyObject self2, Frame frame, Visibility visibility, DynamicScope dynamicScope, BacktraceElement backtrace2) {
        this.self = self2;
        this.frame = frame;
        this.visibility = visibility;
        this.dynamicScope = dynamicScope;
        this.method = backtrace2.method;
        this.filename = backtrace2.filename;
        this.line = backtrace2.line;
    }

    @Deprecated
    public Binding(Frame frame, DynamicScope dynamicScope, BacktraceElement backtrace2) {
        this.self = frame.getSelf();
        this.frame = frame;
        this.visibility = frame.getVisibility();
        this.dynamicScope = dynamicScope;
        this.method = backtrace2.method;
        this.filename = backtrace2.filename;
        this.line = backtrace2.line;
    }

    @Deprecated
    public BacktraceElement getBacktrace() {
        return new BacktraceElement(this.method, this.filename, this.line);
    }
}

