/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import com.headius.invokebinder.Binder;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import org.jruby.ir.IRScope;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.runtime.ArgumentDescriptor;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.IRBlockBody;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class CompiledIRBlockBody
extends IRBlockBody {
    protected final MethodHandle handle;
    protected volatile MethodHandle normalYieldSpecificHandle;
    protected volatile MethodHandle normalYieldHandle;
    protected volatile MethodHandle normalYieldUnwrapHandle;
    protected volatile MethodHandle testBlockBody;
    private static final MethodHandle TEST_BLOCK_BODY = Binder.from(Boolean.TYPE, Block.class, IRBlockBody.class).invokeStaticQuiet(MethodHandles.lookup(), CompiledIRBlockBody.class, "testBlockBody");
    private static final MethodHandle FOLD_METHOD1 = Binder.from(String.class, ThreadContext.class, Block.class).invokeStaticQuiet(MethodHandles.lookup(), CompiledIRBlockBody.class, "foldMethod");
    private static final MethodHandle FOLD_TYPE1 = Binder.from(Block.Type.class, String.class, ThreadContext.class, Block.class).invokeStaticQuiet(MethodHandles.lookup(), CompiledIRBlockBody.class, "foldType");
    private static final MethodHandle FOLD_METHOD2 = Binder.from(String.class, ThreadContext.class, Block.class, IRubyObject.class).invokeStaticQuiet(MethodHandles.lookup(), CompiledIRBlockBody.class, "foldMethod");
    private static final MethodHandle FOLD_TYPE2 = Binder.from(Block.Type.class, String.class, ThreadContext.class, Block.class, IRubyObject.class).invokeStaticQuiet(MethodHandles.lookup(), CompiledIRBlockBody.class, "foldType");
    private static final MethodHandle SET_NORMAL = Binder.from(Void.TYPE, ThreadContext.class, Block.class).drop(1).append(new Object[]{Block.Type.NORMAL}).invokeVirtualQuiet(MethodHandles.lookup(), "setCurrentBlockType");
    private static final MethodHandle VALUE_TO_ARRAY = Binder.from(IRubyObject[].class, IRubyObject.class, new Class[0]).invokeStaticQuiet(MethodHandles.lookup(), IRRuntimeHelpers.class, "singleBlockArgToArray");
    private static final MethodHandle WRAP_VALUE = Binder.from(IRubyObject[].class, IRubyObject.class, new Class[0]).invokeStaticQuiet(MethodHandles.lookup(), CompiledIRBlockBody.class, "wrapValue");

    public CompiledIRBlockBody(MethodHandle handle, IRScope closure, long encodedSignature) {
        super(closure, Signature.decode(encodedSignature));
        this.handle = handle;
        closure.getStaticScope().determineModule();
    }

    public static boolean testBlockBody(Block block, IRBlockBody body) {
        return block.getBody() == body;
    }

    private static String foldMethod(ThreadContext context, Block block) {
        return block.getBinding().getMethod();
    }

    private static Block.Type foldType(String name2, ThreadContext context, Block block) {
        return block.type;
    }

    private static String foldMethod(ThreadContext context, Block block, IRubyObject arg2) {
        return block.getBinding().getMethod();
    }

    private static Block.Type foldType(String name2, ThreadContext context, Block block, IRubyObject arg2) {
        return block.type;
    }

    private static IRubyObject[] wrapValue(IRubyObject value2) {
        return new IRubyObject[]{value2};
    }

    @Override
    public ArgumentDescriptor[] getArgumentDescriptors() {
        return this.closure.getArgumentDescriptors();
    }

    @Override
    public boolean canCallDirect() {
        return true;
    }

    public MethodHandle getHandle() {
        return this.handle;
    }

    public MethodHandle getNormalYieldSpecificHandle() {
        if (this.normalYieldSpecificHandle != null) {
            return this.normalYieldSpecificHandle;
        }
        this.normalYieldSpecificHandle = Binder.from(IRubyObject.class, ThreadContext.class, Block.class).foldVoid(SET_NORMAL).fold(FOLD_METHOD1).fold(FOLD_TYPE1).append(this.getStaticScope()).append(IRubyObject.class, null).append(IRubyObject[].class, null).append(Block.class, (Object)Block.NULL_BLOCK).permute(2, 3, 4, 5, 6, 7, 1, 0).invoke(this.handle);
        return this.normalYieldSpecificHandle;
    }

    public MethodHandle getNormalYieldHandle() {
        if (this.normalYieldHandle != null) {
            return this.normalYieldHandle;
        }
        this.normalYieldHandle = Binder.from(IRubyObject.class, ThreadContext.class, Block.class, IRubyObject.class).foldVoid(SET_NORMAL).fold(FOLD_METHOD2).fold(FOLD_TYPE2).filter(4, WRAP_VALUE).insert(4, this.getStaticScope()).insert(5, IRubyObject.class, null).append(Block.class, (Object)Block.NULL_BLOCK).permute(2, 3, 4, 5, 6, 7, 1, 0).invoke(this.handle);
        return this.normalYieldHandle;
    }

    public MethodHandle getNormalYieldUnwrapHandle() {
        if (this.normalYieldUnwrapHandle != null) {
            return this.normalYieldUnwrapHandle;
        }
        this.normalYieldUnwrapHandle = Binder.from(IRubyObject.class, ThreadContext.class, Block.class, IRubyObject.class).foldVoid(SET_NORMAL).fold(FOLD_METHOD2).fold(FOLD_TYPE2).filter(4, VALUE_TO_ARRAY).insert(4, this.getStaticScope()).insert(5, IRubyObject.class, null).append(Block.class, (Object)Block.NULL_BLOCK).permute(2, 3, 4, 5, 6, 7, 1, 0).invoke(this.handle);
        return this.normalYieldUnwrapHandle;
    }

    public MethodHandle getTestBlockBody() {
        if (this.testBlockBody != null) {
            return this.testBlockBody;
        }
        this.testBlockBody = Binder.from(Boolean.TYPE, ThreadContext.class, Block.class).drop(0).append(this).invoke(TEST_BLOCK_BODY);
        return this.testBlockBody;
    }

    @Override
    protected IRubyObject callDirect(ThreadContext context, Block block, IRubyObject[] args2, Block blockArg) {
        context.setCurrentBlockType(Block.Type.PROC);
        try {
            return this.handle.invokeExact(context, block, this.getStaticScope(), null, args2, blockArg, block.getBinding().getMethod(), block.type);
        }
        catch (Throwable t) {
            Helpers.throwException(t);
            return null;
        }
    }

    @Override
    protected IRubyObject yieldDirect(ThreadContext context, Block block, IRubyObject[] args2, IRubyObject self2) {
        context.setCurrentBlockType(Block.Type.NORMAL);
        try {
            return this.handle.invokeExact(context, block, this.getStaticScope(), self2, args2, Block.NULL_BLOCK, block.getBinding().getMethod(), block.type);
        }
        catch (Throwable t) {
            Helpers.throwException(t);
            return null;
        }
    }
}

