/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.search.DisiWrapper;
import org.apache.lucene.search.DisjunctionScorer;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;

final class DisjunctionMaxScorer
extends DisjunctionScorer {
    private final float tieBreakerMultiplier;

    DisjunctionMaxScorer(Weight weight, float tieBreakerMultiplier, List<Scorer> subScorers, boolean needsScores) {
        super(weight, subScorers, needsScores);
        this.tieBreakerMultiplier = tieBreakerMultiplier;
    }

    @Override
    protected float score(DisiWrapper<Scorer> topList) throws IOException {
        float scoreSum = 0.0f;
        float scoreMax = 0.0f;
        DisiWrapper<Scorer> w = topList;
        while (w != null) {
            float subScore = ((Scorer)w.iterator).score();
            scoreSum += subScore;
            if (subScore > scoreMax) {
                scoreMax = subScore;
            }
            w = w.next;
        }
        return scoreMax + (scoreSum - scoreMax) * this.tieBreakerMultiplier;
    }
}

