/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.spelling;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Scanner;
import java.util.Set;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.tokenizers.WordTokenizer;

public abstract class SpellingCheckRule
extends Rule {
    public static final String LANGUAGETOOL = "LanguageTool";
    public static final String LANGUAGETOOL_FX = "LanguageToolFx";
    protected final Language language;
    private static final String SPELLING_IGNORE_FILE = "/hunspell/ignore.txt";
    private static final String SPELLING_FILE = "/hunspell/spelling.txt";
    private static final String SPELLING_PROHIBIT_FILE = "/hunspell/prohibit.txt";
    private final Set<String> wordsToBeIgnored = new HashSet<String>();
    private final Set<String> wordsToBeProhibited = new HashSet<String>();
    private boolean considerIgnoreWords = true;
    private boolean convertsCase = false;

    public SpellingCheckRule(ResourceBundle messages, Language language) {
        super(messages);
        this.language = language;
        this.setLocQualityIssueType(ITSIssueType.Misspelling);
    }

    @Override
    public abstract String getId();

    @Override
    public abstract String getDescription();

    @Override
    public abstract RuleMatch[] match(AnalyzedSentence var1) throws IOException;

    @Override
    public boolean isDictionaryBasedSpellingRule() {
        return true;
    }

    @Override
    public void reset() {
    }

    public void addIgnoreTokens(List<String> tokens) {
        this.wordsToBeIgnored.addAll(tokens);
    }

    public void setConsiderIgnoreWords(boolean considerIgnoreWords) {
        this.considerIgnoreWords = considerIgnoreWords;
    }

    protected List<String> getAdditionalTopSuggestions(List<String> suggestions, String word) throws IOException {
        ArrayList<String> moreSuggestions = new ArrayList<String>();
        if ("Languagetool".equals(word) && !suggestions.contains(LANGUAGETOOL)) {
            moreSuggestions.add(LANGUAGETOOL);
        }
        return moreSuggestions;
    }

    protected List<String> getAdditionalSuggestions(List<String> suggestions, String word) {
        return Collections.emptyList();
    }

    protected boolean ignoreToken(AnalyzedTokenReadings[] tokens, int idx) throws IOException {
        ArrayList<String> words = new ArrayList<String>();
        for (AnalyzedTokenReadings token : tokens) {
            words.add(token.getToken());
        }
        return this.ignoreWord(words, idx);
    }

    protected boolean ignoreWord(String word) throws IOException {
        if (!this.considerIgnoreWords) {
            return false;
        }
        if (word.endsWith(".") && !this.wordsToBeIgnored.contains(word)) {
            return this.isIgnoredNoCase(word.substring(0, word.length() - 1));
        }
        return this.isIgnoredNoCase(word);
    }

    private boolean isIgnoredNoCase(String word) {
        return this.wordsToBeIgnored.contains(word) || this.convertsCase && this.wordsToBeIgnored.contains(word.toLowerCase(this.language.getLocale()));
    }

    protected boolean ignoreWord(List<String> words, int idx) throws IOException {
        return this.ignoreWord(words.get(idx));
    }

    public boolean isConvertsCase() {
        return this.convertsCase;
    }

    public void setConvertsCase(boolean convertsCase) {
        this.convertsCase = convertsCase;
    }

    protected boolean isUrl(String token) {
        return WordTokenizer.isUrl(token);
    }

    protected void init() throws IOException {
        this.loadWordsToBeIgnored(this.getIgnoreFileName());
        this.loadWordsToBeIgnored(this.getSpellingFileName());
        this.loadWordsToBeProhibited(this.getProhibitFileName());
    }

    protected String getIgnoreFileName() {
        return this.language.getShortName() + SPELLING_IGNORE_FILE;
    }

    protected String getSpellingFileName() {
        return this.language.getShortName() + SPELLING_FILE;
    }

    protected String getProhibitFileName() {
        return this.language.getShortName() + SPELLING_PROHIBIT_FILE;
    }

    protected boolean isProhibited(String word) {
        return this.wordsToBeProhibited.contains(word);
    }

    protected void filterSuggestions(List<String> suggestions) {
        for (int i = 0; i < suggestions.size(); ++i) {
            if (!this.isProhibited(suggestions.get(i))) continue;
            suggestions.remove(i);
        }
    }

    private void loadWordsToBeIgnored(String ignoreFile) throws IOException {
        if (!JLanguageTool.getDataBroker().resourceExists(ignoreFile)) {
            return;
        }
        try (InputStream inputStream = JLanguageTool.getDataBroker().getFromResourceDirAsStream(ignoreFile);
             Scanner scanner = new Scanner(inputStream, "utf-8");){
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                if (this.isComment(line)) continue;
                this.failOnSpace(ignoreFile, line);
                this.addIgnoreWords(line, this.wordsToBeIgnored);
            }
        }
    }

    protected void addIgnoreWords(String line, Set<String> wordsToBeIgnored) {
        wordsToBeIgnored.add(line);
    }

    protected List<String> expandLine(String line) {
        return Collections.singletonList(line);
    }

    private void loadWordsToBeProhibited(String prohibitFile) throws IOException {
        if (!JLanguageTool.getDataBroker().resourceExists(prohibitFile)) {
            return;
        }
        try (InputStream inputStream = JLanguageTool.getDataBroker().getFromResourceDirAsStream(prohibitFile);
             Scanner scanner = new Scanner(inputStream, "utf-8");){
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                if (this.isComment(line)) continue;
                this.failOnSpace(prohibitFile, line);
                this.wordsToBeProhibited.addAll(this.expandLine(line));
            }
        }
    }

    private boolean isComment(String line) {
        return line.startsWith("#");
    }

    private void failOnSpace(String fileName, String line) {
        if (line.contains(" ")) {
            throw new RuntimeException("No space expected in " + fileName + ": '" + line + "'");
        }
    }
}

