/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.db.sql;

import java.io.File;
import org.apache.log4j.Logger;
import org.parosproxy.paros.db.Database;
import org.zaproxy.zap.db.sql.HsqldbDatabaseServer;
import org.zaproxy.zap.db.sql.SqlDatabase;

public class HsqldbDatabase
extends SqlDatabase
implements Database {
    private static final Logger log = Logger.getLogger(HsqldbDatabase.class);

    @Override
    public void close(boolean bl) {
        this.close(bl, true);
    }

    @Override
    public void deleteSession(String string) {
        super.deleteSession(string);
        log.debug((Object)("deleteSession " + string));
        this.deleteDbFile(new File(string));
        this.deleteDbFile(new File(string + ".data"));
        this.deleteDbFile(new File(string + ".script"));
        this.deleteDbFile(new File(string + ".properties"));
        this.deleteDbFile(new File(string + ".backup"));
        this.deleteDbFile(new File(string + ".lobs"));
    }

    private void deleteDbFile(File file) {
        log.debug((Object)("Deleting " + file.getAbsolutePath()));
        if (file.exists() && !file.delete()) {
            log.error((Object)("Failed to delete " + file.getAbsolutePath()));
        }
    }

    @Override
    public void open(String string) throws ClassNotFoundException, Exception {
        log.debug((Object)("open " + string));
        this.setDatabaseServer(new HsqldbDatabaseServer(string));
        this.notifyListenerDatabaseOpen();
    }

    @Override
    public void close(boolean bl, boolean bl2) {
        log.debug((Object)"close");
        super.close(bl, bl2);
        if (this.getDatabaseServer() == null) {
            return;
        }
        try {
            ((HsqldbDatabaseServer)this.getDatabaseServer()).shutdown(bl);
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
        }
    }

    @Override
    public boolean isFileBased() {
        return true;
    }
}

