/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.arguments;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Map;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.arguments.ReadUserKeywordsHashNode;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.hash.HashOperations;
import org.jruby.truffle.runtime.methods.Arity;

public abstract class CheckArityNode {
    public static RubyNode create(RubyContext context, SourceSection sourceSection, Arity arity) {
        if (!arity.acceptsKeywords()) {
            return new CheckAritySimple(context, sourceSection, arity);
        }
        return new CheckArityKeywords(context, sourceSection, arity);
    }

    private static class CheckArityKeywords
    extends RubyNode {
        private final Arity arity;
        @Node.Child
        private ReadUserKeywordsHashNode readUserKeywordsHashNode;

        private CheckArityKeywords(RubyContext context, SourceSection sourceSection, Arity arity) {
            super(context, sourceSection);
            this.arity = arity;
            this.readUserKeywordsHashNode = new ReadUserKeywordsHashNode(context, sourceSection, arity.getRequired());
        }

        @Override
        public Object execute(VirtualFrame frame) {
            throw new UnsupportedOperationException("CheckArity should be call with executeVoid()");
        }

        @Override
        public void executeVoid(VirtualFrame frame) {
            DynamicObject keywordArguments;
            Object[] frameArguments = frame.getArguments();
            int given = RubyArguments.getArgumentsCount(frame.getArguments());
            if (!this.checkArity(frame, given, keywordArguments = (DynamicObject)this.readUserKeywordsHashNode.execute(frame))) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError(given, this.arity.getRequired(), this));
            }
            if (!this.arity.hasKeywordsRest() && keywordArguments != null) {
                for (Map.Entry<Object, Object> keyValue : HashOperations.iterableKeyValues(keywordArguments)) {
                    if (RubyGuards.isRubySymbol(keyValue.getKey())) {
                        if (this.keywordAllowed(keyValue.getKey().toString())) continue;
                        CompilerDirectives.transferToInterpreter();
                        throw new RaiseException(this.getContext().getCoreLibrary().argumentError("unknown keyword: " + keyValue.getKey().toString(), this));
                    }
                    if (++given <= this.arity.getRequired() || this.arity.hasRest() || this.arity.getOptional() != 0) continue;
                    throw new RaiseException(this.getContext().getCoreLibrary().argumentError(given, this.arity.getRequired(), this));
                }
            }
            if (this.arity.hasKeywordsRest() && keywordArguments != null) {
                for (Map.Entry<Object, Object> keyValue : HashOperations.iterableKeyValues(keywordArguments)) {
                    if (RubyGuards.isRubySymbol(keyValue.getKey()) || ++given <= this.arity.getRequired() || this.arity.hasRest() || this.arity.getOptional() != 0) continue;
                    throw new RaiseException(this.getContext().getCoreLibrary().argumentError(given, this.arity.getRequired(), this));
                }
            }
        }

        private boolean checkArity(VirtualFrame frame, int given, DynamicObject keywordArguments) {
            int required;
            if (keywordArguments != null) {
                --given;
            }
            if ((required = this.arity.getRequired()) != 0 && given < required) {
                return false;
            }
            return this.arity.hasRest() || given <= required + this.arity.getOptional();
        }

        private boolean keywordAllowed(String keyword) {
            for (String allowedKeyword : this.arity.getKeywordArguments()) {
                if (!keyword.equals(allowedKeyword)) continue;
                return true;
            }
            return false;
        }
    }

    private static class CheckAritySimple
    extends RubyNode {
        private final Arity arity;

        public CheckAritySimple(RubyContext context, SourceSection sourceSection, Arity arity) {
            super(context, sourceSection);
            this.arity = arity;
        }

        @Override
        public void executeVoid(VirtualFrame frame) {
            int given = RubyArguments.getArgumentsCount(frame.getArguments());
            if (!this.checkArity(given)) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError(given, this.arity.getRequired(), this));
            }
        }

        @Override
        public Object execute(VirtualFrame frame) {
            throw new UnsupportedOperationException("CheckArity should be call with executeVoid()");
        }

        private boolean checkArity(int given) {
            int required = this.arity.getRequired();
            if (required != 0 && given < required) {
                return false;
            }
            return this.arity.hasRest() || given <= required + this.arity.getOptional();
        }
    }
}

