/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.arguments;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;

public class ReadUserKeywordsHashNode
extends RubyNode {
    private final int minArgumentCount;

    public ReadUserKeywordsHashNode(RubyContext context, SourceSection sourceSection, int minArgumentCount) {
        super(context, sourceSection);
        this.minArgumentCount = minArgumentCount;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object converted;
        int argumentCount = RubyArguments.getArgumentsCount(frame.getArguments());
        if (argumentCount <= this.minArgumentCount) {
            return null;
        }
        Object lastArgument = RubyArguments.getArgument(frame.getArguments(), argumentCount - 1);
        if (RubyGuards.isRubyHash(lastArgument)) {
            return lastArgument;
        }
        CompilerDirectives.transferToInterpreter();
        if (((Boolean)this.ruby(frame, "last_arg.respond_to?(:to_hash)", "last_arg", lastArgument)).booleanValue() && RubyGuards.isRubyHash(converted = this.ruby(frame, "last_arg.to_hash", "last_arg", lastArgument))) {
            RubyArguments.setArgument(frame.getArguments(), argumentCount - 1, converted);
            return converted;
        }
        return null;
    }
}

