/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core.hash;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.ConditionProfile;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.BasicObjectNodes;
import org.jruby.truffle.nodes.core.BasicObjectNodesFactory;
import org.jruby.truffle.nodes.core.hash.HashNode;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.hash.BucketsStrategy;
import org.jruby.truffle.runtime.hash.Entry;
import org.jruby.truffle.runtime.hash.HashLookupResult;
import org.jruby.truffle.runtime.layouts.Layouts;

public class LookupEntryNode
extends RubyNode {
    @Node.Child
    HashNode hashNode;
    @Node.Child
    CallDispatchHeadNode eqlNode;
    @Node.Child
    BasicObjectNodes.ReferenceEqualNode equalNode;
    private final ConditionProfile byIdentityProfile = ConditionProfile.createBinaryProfile();

    public LookupEntryNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
        this.hashNode = new HashNode(context, sourceSection);
        this.eqlNode = DispatchHeadNodeFactory.createMethodCall(context);
        this.equalNode = BasicObjectNodesFactory.ReferenceEqualNodeFactory.create(context, sourceSection, null, null);
    }

    public HashLookupResult lookup(VirtualFrame frame, DynamicObject hash, Object key) {
        int hashed = this.hashNode.hash(frame, key);
        Entry[] entries = (Entry[])Layouts.HASH.getStore(hash);
        int index = BucketsStrategy.getBucketIndex(hashed, entries.length);
        Entry previousEntry = null;
        for (Entry entry = entries[index]; entry != null; entry = entry.getNextInLookup()) {
            if (this.byIdentityProfile.profile(Layouts.HASH.getCompareByIdentity(hash)) ? this.equalNode.executeReferenceEqual(frame, key, entry.getKey()) : this.eqlNode.callBoolean(frame, key, "eql?", null, entry.getKey())) {
                return new HashLookupResult(hashed, index, previousEntry, entry);
            }
            previousEntry = entry;
        }
        return new HashLookupResult(hashed, index, previousEntry, null);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        throw new UnsupportedOperationException();
    }
}

