/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.subsystems;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrument.Instrument;
import com.oracle.truffle.api.instrument.Probe;
import com.oracle.truffle.api.instrument.ProbeInstrument;
import com.oracle.truffle.api.instrument.ProbeListener;
import com.oracle.truffle.api.instrument.StandardInstrumentListener;
import com.oracle.truffle.api.instrument.SyntaxTag;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.ConditionProfile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.RubySyntaxTag;
import org.jruby.truffle.runtime.core.StringOperations;
import org.jruby.truffle.runtime.layouts.Layouts;

public class TraceManager {
    private final RubyContext context;
    private Collection<ProbeInstrument> instruments;
    private boolean isInTraceFunc = false;
    private final Map<SyntaxTag, TraceFuncEventFactory> eventFactories = new LinkedHashMap<SyntaxTag, TraceFuncEventFactory>();

    public TraceManager(RubyContext context) {
        this.context = context;
    }

    public void setTraceFunc(final DynamicObject traceFunc) {
        assert (RubyGuards.isRubyProc(traceFunc));
        if (this.instruments != null) {
            for (Instrument instrument : this.instruments) {
                instrument.dispose();
            }
        }
        if (traceFunc == null) {
            this.instruments = null;
            return;
        }
        TraceFuncEventFactory lineEventFactory = new TraceFuncEventFactory(){

            @Override
            public StandardInstrumentListener createInstrumentListener(RubyContext context, DynamicObject traceFunc) {
                DynamicObject event = StringOperations.create7BitString(context, StringOperations.encodeByteList("line", (Encoding)UTF8Encoding.INSTANCE));
                return new BaseEventInstrumentListener(context, traceFunc, event);
            }
        };
        TraceFuncEventFactory traceFuncEventFactory = new TraceFuncEventFactory(){

            @Override
            public StandardInstrumentListener createInstrumentListener(RubyContext context, DynamicObject traceFunc) {
                DynamicObject event = StringOperations.create7BitString(context, StringOperations.encodeByteList("call", (Encoding)UTF8Encoding.INSTANCE));
                return new CallEventInstrumentListener(context, traceFunc, event);
            }
        };
        TraceFuncEventFactory classEventFactory = new TraceFuncEventFactory(){

            @Override
            public StandardInstrumentListener createInstrumentListener(RubyContext context, DynamicObject traceFunc) {
                DynamicObject event = StringOperations.create7BitString(context, StringOperations.encodeByteList("class", (Encoding)UTF8Encoding.INSTANCE));
                return new BaseEventInstrumentListener(context, traceFunc, event);
            }
        };
        this.eventFactories.put(RubySyntaxTag.LINE, lineEventFactory);
        this.eventFactories.put(RubySyntaxTag.CALL, traceFuncEventFactory);
        this.eventFactories.put(RubySyntaxTag.CLASS, classEventFactory);
        this.instruments = new ArrayList<ProbeInstrument>();
        for (Map.Entry<SyntaxTag, TraceFuncEventFactory> entry : this.eventFactories.entrySet()) {
            for (Probe probe : this.context.getEnv().instrumenter().findProbesTaggedAs(entry.getKey())) {
                this.instruments.add(this.context.getEnv().instrumenter().attach(probe, entry.getValue().createInstrumentListener(this.context, traceFunc), "set_trace_func"));
            }
        }
        this.context.getEnv().instrumenter().addProbeListener(new ProbeListener(){

            @Override
            public void startASTProbing(RootNode rootNode) {
            }

            @Override
            public void newProbeInserted(Probe probe) {
            }

            @Override
            public void probeTaggedAs(Probe probe, SyntaxTag tag, Object tagValue) {
                if (TraceManager.this.eventFactories.containsKey(tag)) {
                    TraceManager.this.instruments.add(TraceManager.this.context.getEnv().instrumenter().attach(probe, ((TraceFuncEventFactory)TraceManager.this.eventFactories.get(tag)).createInstrumentListener(TraceManager.this.context, traceFunc), "set_trace_func"));
                }
            }

            @Override
            public void endASTProbing(RootNode rootNode) {
            }
        });
    }

    private final class CallEventInstrumentListener
    implements StandardInstrumentListener {
        private final ConditionProfile inTraceFuncProfile = ConditionProfile.createBinaryProfile();
        private static final String callTraceFuncCode = "traceFunc.call(event, file, line, id, binding, classname)";
        private final RubyContext context;
        private final DynamicObject traceFunc;
        private final Object event;

        public CallEventInstrumentListener(RubyContext context, DynamicObject traceFunc, Object event) {
            this.context = context;
            this.traceFunc = traceFunc;
            this.event = event;
        }

        @Override
        public void onEnter(Probe probe, Node node, VirtualFrame frame) {
            if (!this.inTraceFuncProfile.profile(TraceManager.this.isInTraceFunc)) {
                this.callSetTraceFunc(node, frame.materialize());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private void callSetTraceFunc(Node node, MaterializedFrame frame) {
            int line;
            String filename;
            SourceSection sourceSection = Truffle.getRuntime().getCallerFrame().getCallNode().getEncapsulatingSourceSection();
            if (sourceSection.getSource() != null) {
                if (sourceSection.getSource().getCode().equals(callTraceFuncCode)) {
                    return;
                }
                filename = sourceSection.getSource().getName();
                line = sourceSection.getStartLine();
            } else {
                filename = "<internal>";
                line = -1;
            }
            DynamicObject file = StringOperations.createString(this.context, StringOperations.encodeByteList(filename, (Encoding)UTF8Encoding.INSTANCE));
            if (!this.context.getOptions().INCLUDE_CORE_FILE_CALLERS_IN_SET_TRACE_FUNC && filename.startsWith("truffle:")) {
                return;
            }
            Object self = RubyArguments.getSelf(frame.getArguments());
            DynamicObject classname = this.context.getCoreLibrary().getLogicalClass(self);
            DynamicObject id = this.context.getSymbol(RubyArguments.getMethod(frame.getArguments()).getName());
            DynamicObject binding = Layouts.BINDING.createBinding(this.context.getCoreLibrary().getBindingFactory(), Truffle.getRuntime().getCallerFrame().getFrame(FrameInstance.FrameAccess.MATERIALIZE, true).materialize());
            TraceManager.this.isInTraceFunc = true;
            try {
                this.context.inlineRubyHelper(node, frame, callTraceFuncCode, "traceFunc", this.traceFunc, "event", this.event, "file", file, "line", line, "id", id, "binding", binding, "classname", classname);
            }
            finally {
                TraceManager.this.isInTraceFunc = false;
            }
        }

        @Override
        public void onReturnVoid(Probe probe, Node node, VirtualFrame frame) {
        }

        @Override
        public void onReturnValue(Probe probe, Node node, VirtualFrame frame, Object result) {
        }

        @Override
        public void onReturnExceptional(Probe probe, Node node, VirtualFrame virtualFrame, Throwable throwable) {
        }
    }

    private final class BaseEventInstrumentListener
    implements StandardInstrumentListener {
        private final ConditionProfile inTraceFuncProfile = ConditionProfile.createBinaryProfile();
        private final RubyContext context;
        private final DynamicObject traceFunc;
        private final Object event;

        public BaseEventInstrumentListener(RubyContext context, DynamicObject traceFunc, Object event) {
            this.context = context;
            this.traceFunc = traceFunc;
            this.event = event;
        }

        @Override
        public void onEnter(Probe probe, Node node, VirtualFrame frame) {
            if (!this.inTraceFuncProfile.profile(TraceManager.this.isInTraceFunc)) {
                this.callSetTraceFunc(node, frame.materialize());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private void callSetTraceFunc(Node node, MaterializedFrame frame) {
            SourceSection sourceSection = node.getEncapsulatingSourceSection();
            DynamicObject file = StringOperations.createString(this.context, StringOperations.encodeByteList(sourceSection.getSource().getName(), (Encoding)UTF8Encoding.INSTANCE));
            int line = sourceSection.getStartLine();
            DynamicObject classname = this.context.getCoreLibrary().getNilObject();
            DynamicObject id = this.context.getCoreLibrary().getNilObject();
            DynamicObject binding = Layouts.BINDING.createBinding(this.context.getCoreLibrary().getBindingFactory(), frame);
            TraceManager.this.isInTraceFunc = true;
            try {
                this.context.inlineRubyHelper(node, frame, "traceFunc.call(event, file, line, id, binding, classname)", "traceFunc", this.traceFunc, "event", this.event, "file", file, "line", line, "id", id, "binding", binding, "classname", classname);
            }
            finally {
                TraceManager.this.isInTraceFunc = false;
            }
        }

        @Override
        public void onReturnVoid(Probe probe, Node node, VirtualFrame frame) {
        }

        @Override
        public void onReturnValue(Probe probe, Node node, VirtualFrame frame, Object result) {
        }

        @Override
        public void onReturnExceptional(Probe probe, Node node, VirtualFrame virtualFrame, Throwable throwable) {
        }
    }

    private abstract class TraceFuncEventFactory {
        private TraceFuncEventFactory() {
        }

        public abstract StandardInstrumentListener createInstrumentListener(RubyContext var1, DynamicObject var2);
    }
}

